# Arthur Brenno - Perfil Técnico Completo

## Informações Pessoais
- **Nome:** Arthur Brenno
- **Idade:** 21 anos
- **Idiomas:** Português (nativo), Inglês (fluente)

## Visão Geral Profissional

Desenvolvedor e Arquiteto de Software especializado em **Inteligência Artificial Generativa**, **Arquitetura de Sistemas** e **Frameworks Python**. Focado em criar soluções que priorizam a **experiência do desenvolvedor** através de arquiteturas robustas, escaláveis e bem documentadas.

### Filosofia de Desenvolvimento
- **Developer Experience First:** Obsessão pela criação de ferramentas que simplifiquem o trabalho de outros desenvolvedores
- **Arquitetura Limpa:** Aplicação rigorosa de Clean Architecture e Domain-Driven Design
- **Qualidade de Código:** Uso extensivo de tipagem estática, testes automatizados e refatoração contínua

## Experiência Técnica

### Inteligência Artificial & Machine Learning

#### IA Generativa Aplicada à Educação
- **Projetos confidenciais** com **savings de mais de R$100.000** em automação de processos
- Desenvolvimento de soluções **RAG (Retrieval-Augmented Generation)** sem dependência de LangChain/LlamaIndex
- **Semantic Chunking** e **Graph RAG** (Microsoft) para processamento avançado de documentos
- **Entity Extraction** e **Relationship Extraction** usando Google Cloud, spaCy, Ollama e Gemini

#### Frameworks e Bibliotecas Próprias
- **[IntelliBricks](https://github.com/arthurbrenno/intellibricks):** Framework Python-first para aplicações LLM com arquitetura superior ao LangChain/LlamaIndex
- **[Webson](https://github.com/arthurbrenno/webson):** Transformação de websites em JSON estruturado com código mínimo
- **[IntelliParse](https://github.com/arthurbrenno/intelliparse):** Processamento de arquivos não estruturados (documentos, imagens, áudio, vídeo, CAD) em dados estruturados
- **[Architecture](https://github.com/arthurbrenno/architecture):** Biblioteca base com funcionalidades essenciais para arquiteturas de software

#### Machine Learning Tradicional
- **Modelos:** Regressão Linear, KNN, Random Forest com Scikit-learn
- **Preprocessing:** Label Encoder, OneHotEncoder, StandardScaler
- **Engine Dinâmica:** Framework próprio para treinamento automatizado de modelos ML com IA generativa para configuração de parâmetros
- **Persistência:** Joblib para salvamento/recuperação de modelos e pipelines

### Avaliação e Educação

#### Sistemas de Avaliação Educacional
- **Teoria Clássica dos Testes** para avaliação de questões institucionais
- **Taxonomia de Bloom** aplicada à geração de questões
- **Critérios de Correção ENEM** para avaliação automatizada de redações
- **Avaliação de Competências** em sistemas educacionais

### Arquitetura de Software

#### Design Patterns e Princípios
- **Padrões Implementados:** Strategy, Composite, Facade, Null Object, Bridge, Factory
- **Princípios SOLID:** Inversão de dependência, segregação de interfaces
- **Composição sobre Herança:** Favorecimento de composição de objetos
- **Componentes Covariantes, Invariantes e Contravariantes**

#### Domain-Driven Design (DDD)
- Separação clara entre **Entidades de Negócio**
- **Bounded Contexts** para comunicação entre componentes
- **Services** para lógica de negócio
- **Repositories** para acesso a dados com inversão de dependência

#### Frameworks Próprios
- **Framework PHP & Python:** Uso de msgpack, Litestar, msgspec (alternativa ao Pydantic)
- **Sistema de Injeção de Dependência:** PHP com Attributes (similar ao @Autowired do Spring Boot)
- **Clients HTTP:** Abstração de microsserviços para facilitar desenvolvimento

### Tecnologias e Ferramentas

#### Linguagens e Frameworks
- **Python:** Litestar, FastAPI, msgspec, pytest
- **PHP:** Framework próprio com injeção de dependência
- **JavaScript/TypeScript:** Para integrações web

#### Cloud e Infraestrutura
- **Google Cloud Platform:** IAM, Faturamento, Agent Builder, Discovery Engine, Cloud Storage, Vertex AI, OAuth
- **Containerização:** Docker, Dockerfiles otimizados para Python high-performance
- **Orquestração:** Portainer para deploy local
- **CI/CD:** GitHub Actions para deploy e publicação automática no PyPI

#### Bancos de Dados
- **Relacionais:** PL/SQL avançado
- **Vetoriais:** Milvus para RAG
- **Analytics:** ClickHouse para Business Intelligence
- **NoSQL:** Experiência com diversos tipos

#### Ferramentas de Desenvolvimento
- **Tipagem Estática:** Pyright, Mypy (Pyre descontinuado)
- **Formatação:** Ruff
- **Testes:** pytest com TDD, GitHub Actions, Git hooks
- **Automação:** Makefile para aliases e automações
- **Visualização:** EMERGE para arquitetura de sistemas

#### Observabilidade e Monitoramento
- **Langfuse:** Tracing e observabilidade (low-level SDK)
- **Monitoramento de Custos:** Por projeto e por modelo
- **Logging:** Pretty logging com estruturas customizadas

#### Comunicação e Integração
- **Mensageria:** RabbitMQ para comunicação assíncrona
- **gRPC:** Comunicação server-to-server
- **Web Scraping:** Playwright assíncrono (alternativa ao Selenium)
- **APIs Financeiras:** Yahoo Finance para cotações
- **Documentação:** Stoplight e APIDOG para API-first development

#### Gerenciamento de Dependências
- **Python:** UV (anteriormente Poetry)
- **Dependências Externas:** Google Cloud Artifact Registry
- **Ambientes:** DevContainers para desenvolvimento

### Especializações Técnicas

#### Concorrência e Performance
- **Classes Thread-Safe:** Desenvolvimento de componentes imutáveis
- **Programação Assíncrona:** Otimização de experiência do usuário
- **High-Performance Servers:** Gunicorn/Uvicorn com Litestar para escalabilidade horizontal

#### Comunicação com Sistemas
- **Embarcados:** Comunicação via FTP
- **Microsserviços:** Arquitetura distribuída
- **Integrações:** WhatsApp, HubSpot, sistemas terceiros

#### Metodologias
- **TDD:** Test-Driven Development com pytest
- **Time Boxing:** Gestão eficiente de tempo
- **API-First Development:** Documentação e design antes da implementação

## Produção Acadêmica

### Artigos Publicados
1. **[Qualidade A]** - Publicação em revista de alto impacto ([Link](https://ojs.revistagesec.org.br/secretariado/article/view/4497))
2. **[Qualidade B]** - CRM Educacional ([Link](https://www.researchgate.net/publication/386249733_DESENVOLVIMENTO_DE_UM_CRM_EDUCACIONAL_PARA_AUXILIO_DA_GESTAO_DE_RELACIONAMENTO_COM_O_CLIENTE))
3. **Design Patterns em APIs** - Co-autoria com Humberto Patrick e Mateus Valente
4. **Detecção de Lixo Oceânico** - Aplicação de IA em problemas ambientais

## Projetos de Impacto

### Valor Entregue
- **+R$100.000 em savings** através de automação de processos empresariais
- **Redução significativa** de carga horária manual
- **Integração de IA Generativa** em processos críticos de negócio

### Projetos Comerciais
- **Integrações WhatsApp Business**
- **Sistemas CRM personalizados**
- **Soluções RAG** com bancos vetoriais e grafos
- **Automação de processos educacionais**

## Competências Comportamentais

- **Disciplina:** Abordagem metódica e consistente ao desenvolvimento
- **Obsessão pela Qualidade:** Foco na experiência do desenvolvedor e arquitetura limpa
- **Inovação:** Criação de soluções próprias quando ferramentas existentes são inadequadas
- **Colaboração:** Experiência em co-autoria e projetos em equipe
- **Aprendizado Contínuo:** Constante evolução técnica e adoção de novas tecnologias

## Filosofia Técnica

> *"Software deve envelhecer devagar e com qualidade de transição"*

Foco na criação de arquiteturas que:
- Minimizem a complexidade desnecessária
- Favoreçam a manutenibilidade a longo prazo
- Priorizem a experiência do desenvolvedor
- Sejam naturalmente escaláveis e testáveis

## Repositórios Principais

- **[IntelliBricks](https://github.com/arthurbrenno/intellibricks)** - Framework LLM Python-first
- **[Architecture](https://github.com/arthurbrenno/architecture)** - Fundações para arquitetura limpa
- **[Webson](https://github.com/arthurbrenno/webson)** - Web scraping estruturado
- **[IntelliParse](https://github.com/arthurbrenno/intelliparse)** - Processamento de arquivos com IA