import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::OpsWorksCM::Server`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html
 */
export interface CfnServerProps {
    /**
     * `AWS::OpsWorksCM::Server.InstanceProfileArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instanceprofilearn
     */
    readonly instanceProfileArn: string;
    /**
     * `AWS::OpsWorksCM::Server.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::OpsWorksCM::Server.ServiceRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servicerolearn
     */
    readonly serviceRoleArn: string;
    /**
     * `AWS::OpsWorksCM::Server.AssociatePublicIpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-associatepublicipaddress
     */
    readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorksCM::Server.BackupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupid
     */
    readonly backupId?: string;
    /**
     * `AWS::OpsWorksCM::Server.BackupRetentionCount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupretentioncount
     */
    readonly backupRetentionCount?: number;
    /**
     * `AWS::OpsWorksCM::Server.CustomCertificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customcertificate
     */
    readonly customCertificate?: string;
    /**
     * `AWS::OpsWorksCM::Server.CustomDomain`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customdomain
     */
    readonly customDomain?: string;
    /**
     * `AWS::OpsWorksCM::Server.CustomPrivateKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customprivatekey
     */
    readonly customPrivateKey?: string;
    /**
     * `AWS::OpsWorksCM::Server.DisableAutomatedBackup`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-disableautomatedbackup
     */
    readonly disableAutomatedBackup?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorksCM::Server.Engine`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engine
     */
    readonly engine?: string;
    /**
     * `AWS::OpsWorksCM::Server.EngineAttributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineattributes
     */
    readonly engineAttributes?: Array<CfnServer.EngineAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorksCM::Server.EngineModel`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-enginemodel
     */
    readonly engineModel?: string;
    /**
     * `AWS::OpsWorksCM::Server.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineversion
     */
    readonly engineVersion?: string;
    /**
     * `AWS::OpsWorksCM::Server.KeyPair`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-keypair
     */
    readonly keyPair?: string;
    /**
     * `AWS::OpsWorksCM::Server.PreferredBackupWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredbackupwindow
     */
    readonly preferredBackupWindow?: string;
    /**
     * `AWS::OpsWorksCM::Server.PreferredMaintenanceWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredmaintenancewindow
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::OpsWorksCM::Server.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::OpsWorksCM::Server.ServerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servername
     */
    readonly serverName?: string;
    /**
     * `AWS::OpsWorksCM::Server.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-subnetids
     */
    readonly subnetIds?: string[];
    /**
     * `AWS::OpsWorksCM::Server.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::OpsWorksCM::Server`
 *
 * @cloudformationResource AWS::OpsWorksCM::Server
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html
 */
export declare class CfnServer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorksCM::Server";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::OpsWorksCM::Server.InstanceProfileArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instanceprofilearn
     */
    instanceProfileArn: string;
    /**
     * `AWS::OpsWorksCM::Server.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instancetype
     */
    instanceType: string;
    /**
     * `AWS::OpsWorksCM::Server.ServiceRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servicerolearn
     */
    serviceRoleArn: string;
    /**
     * `AWS::OpsWorksCM::Server.AssociatePublicIpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-associatepublicipaddress
     */
    associatePublicIpAddress: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorksCM::Server.BackupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupid
     */
    backupId: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.BackupRetentionCount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupretentioncount
     */
    backupRetentionCount: number | undefined;
    /**
     * `AWS::OpsWorksCM::Server.CustomCertificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customcertificate
     */
    customCertificate: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.CustomDomain`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customdomain
     */
    customDomain: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.CustomPrivateKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customprivatekey
     */
    customPrivateKey: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.DisableAutomatedBackup`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-disableautomatedbackup
     */
    disableAutomatedBackup: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorksCM::Server.Engine`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engine
     */
    engine: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.EngineAttributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineattributes
     */
    engineAttributes: Array<CfnServer.EngineAttributeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorksCM::Server.EngineModel`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-enginemodel
     */
    engineModel: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineversion
     */
    engineVersion: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.KeyPair`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-keypair
     */
    keyPair: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.PreferredBackupWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredbackupwindow
     */
    preferredBackupWindow: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.PreferredMaintenanceWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredmaintenancewindow
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::OpsWorksCM::Server.ServerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servername
     */
    serverName: string | undefined;
    /**
     * `AWS::OpsWorksCM::Server.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-subnetids
     */
    subnetIds: string[] | undefined;
    /**
     * `AWS::OpsWorksCM::Server.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::OpsWorksCM::Server`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnServerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnServer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworkscm-server-engineattribute.html
     */
    interface EngineAttributeProperty {
        /**
         * `CfnServer.EngineAttributeProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworkscm-server-engineattribute.html#cfn-opsworkscm-server-engineattribute-name
         */
        readonly name?: string;
        /**
         * `CfnServer.EngineAttributeProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworkscm-server-engineattribute.html#cfn-opsworkscm-server-engineattribute-value
         */
        readonly value?: string;
    }
}
