# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['today']

package_data = \
{'': ['*']}

install_requires = \
['pydantic>=1.9.2,<2.0.0', 'rich>=13.1,<14.0']

entry_points = \
{'console_scripts': ['start = today.start:main', 'today = today.today:main']}

setup_kwargs = {
    'name': 'todo-today-cli',
    'version': '0.0.2',
    'description': 'A file-centric task management app',
    'long_description': '# Today: A File-Centric Task Management System\n\n![PR CI](https://github.com/vighneshiyer/today/actions/workflows/pr.yml/badge.svg?event=push) ![Publish CI](https://github.com/vighneshiyer/today/actions/workflows/publish.yml/badge.svg) [![PyPI version](https://badge.fury.io/py/todo-today-cli.svg)](https://badge.fury.io/py/todo-today-cli)\n\nTo install: `pip install todo-today-cli`\n\n## Motivation\n\nI\'ve used GUI based "task management" apps in the past, such as Asana, Trello, Google Tasks, and recently Superproductivity.\nI don\'t like these since they require a browser, are bloated, are GUI-driven, and are difficult to back up and version control.\nHowever, they are nice when it comes to visualization of tasks, physically moving tasks across projects, and general readability and scanability.\n\nI\'ve also seen and used CLI based "task management" apps (Taskwarrior, Ultralist, Todo.txt).\nI like that these apps often have easy backup strategies, are text driven, and are usually minimal, but overall I haven\'t been satisfied.\n\nThe CLI apps all seem to use a non-human-readable/editable database format to store task and project descriptions such as a sqlite database or JSON.\nAs a result, all interaction with tasks goes through the CLI rather than a text editor directly.\nThe CLI will never be as ergonomic as browsing and editing projects and tasks with vim or using a GUI.\nIn other words, they are *cli-centric* rather than *file-centric*, and I think this is why GUI solutions still feel better despite the downsides.\n\nBut, there is another way (I think).\n\nThe benefit of the GUI approach is the quick editing, visualization, and readability.\nThis can be achieved by putting all tasks in files with human-readable markup (e.g. my notes are just plain Markdown files and that has worked perfectly for readability and scanning).\nThis also allows regrouping of tasks, moving them between projects, and editing description text in bulk, since those are easy with any text editor.\n\nThe benefit of the CLI approach is minimal bloat and a quick UI to view the daily TODO summary we want.\nTo mitigate the downside of editing tasks through the CLI, I propose a *read-only* CLI where task changes are made to the Markdown files directly, which serve as the golden source of truth.\n\n### The "Today" Strategy\n\nOne common issue with task management systems is they are a great place to dump loads of tasks, but when it comes to "what should I do now?" at the start of the day, they provide little assistance.\nOften, you scroll through your projects and ad-hoc decide what to work on, or you suddenly realize I need to work on *this*.\nWhile you can use basic Markdown files or Trello boards to enumerate your tasks, `today` offers a directed view of what you should do *today* to counter analysis paralysis.\n\nIt is based on Superproductivity\'s approach where, every day, you would get a list of tasks that are due or have reminders for today or earlier.\nYou would then pick which tasks you want to work on today, and snooze (defer) the rest of them.\nThen you get a \'daily\' view of what to do and can tick things off from there (without having to go into different boards or project Markdown files).\n\n## Task Definitions\n\n- Tasks are kept in plain Markdown files. Each Markdown file represents a project. Ideally each project should be tightly scoped and not drag on forever.\n    - You can save Markdown files on disk in any way you want. Add nested folders to encode hierarchy.\n    - You can group tasks within a project any way you want. Add nested headings to encode hierarchy.\n\nIn `chores.md`:\n\n```markdown\n# Chores\n\n## Purchases\n\n## Bills\n\n## Cleaning\n```\n\n- Tasks are designated by a Markdown checkbox.\n\n```markdown\n## Cleaning\n\n- [ ] Home cleaning\n```\n\n### Tags\n\n- A task can have one or more tags, designated by hashtags in the task title. Tags are highlighted when a task is displayed, but are otherwise useless.\n\n```markdown\n- [ ] Home cleaning #cleaning #house #offline\n```\n\n### Dates\n\n- A task can have a created, due, and reminder date by placing it in square brackets with the prefix `c`, `d`, or `r`.\n    - The date is in `month`/`day`/`year` format\n    - You can also use `t` as a date. For example, to specify today as the due date, write: `[d:t]`\n\n```markdown\n- [ ] Home cleaning #cleaning #house #offline [c:1/3/2023] [r:2/27/2023] [d:3/1/2023]\n```\n\n### Descriptions\n\n- You can add a description for a task directly underneath the task title. It can consist of any Markdown you want (*except headings*).\n\n```markdown\n- [ ] Home cleaning #cleaning #house #offline [c:1/3/2023] [r:2/27/2023] [d:3/1/2023]\n\nHere is a description paragraph. Any text here will be part of the task\'s description.\n\n- Some bullets\n    - A nested bullet\n\n> A quote\n```\n\n### Subtasks\n\n- Subtasks are specified with a nested list under the main task.\n- Subtasks cannot have their own descriptions, but they can have tags and created/reminder/due dates.\n    - If the main task has a created/reminder/due date, it will apply for all subtasks automatically, unless otherwise specified\n    - Only one level of subtasks is supported\n\n```markdown\n- [ ] Home cleaning #cleaning #house #offline [c:1/3/2023] [r:2/27/2023] [d:3/1/2023]\n    - [ ] Sweep the floors [d:2/10/2023]\n    - [ ] Wipe the countertops\n    - [ ] Throw the trash\n\nI need to get this done soon. This is the main task description.\n```\n\n### Completed Tasks\n\n- A task can be marked complete just by checking its checkbox. You can optionally specify a completion time with a finish `f` date.\n\n```markdown\n[x] Home cleaning #cleaning #house #offline [c:1/3/2023] [r:2/27/2023] [d:3/1/2023] [f:2/28/2023]\n```\n\n### Recurring Tasks (Not Yet Supported)\n\n- A task can be made recurring by specifying a `[recur:]` string in the task title.\n    - Recurring tasks cannot have any subtasks, but they can have a description\n    - Recurring tasks should not be marked complete. They will show up in your daily report and there is a CLI option to mark an instance of the task complete. This completion isn\'t tracked anywhere explicitly.\n    - Recurring tasks disappear after the day they are scheduled. If you forget to finish a recurring task, you must explicitly add an instance of it to a project if you wish to be reminded later.\n\n```markdown\n[ ] Daily journal [recur:daily]\n[ ] Weekly tasks [recur:Sunday]\n[ ] Monthly tasks [recur:eom]\n```\n\n- TBD: more complex recurrence descriptions, maybe use ical recur format string? This implementation also seems brittle and has many caveats - is there a better way?\n\n## Today\n\nThe core CLI command is `today`.\nRunning `today` will parse all the Markdown files in the current directory, and display all the tasks that are due or have reminders for today (or in the past).\nTo select a directory that contains the Markdown task files, use `today --dir /path/to/md/files`.\n\nThis will give you a list of tasks to work on, ordered by alphabetical heading category and criticality of due/reminder dates.\n\nTo display the details of a specific task, provide its task number e.g. `today 3`.\n\nTo look ahead 10 days in advance for tasks that are due or have reminders, do `today --days 10`.\n\n- Recap: `today` is a READ-ONLY view of the tasks scheduled for today\n    - The only way to make changes is to directly change the files\n    - There is no intermediary database\n    - The files are the golden source of truth!\n\n### Completing a Task\n\nIf you\'ve completed a task, mark it complete by checking its box.\n\n### Editing a Task\n\nTo edit a task\'s description, title, or due date, edit the file defining the task.\n\n### Deleting / Archiving a Task\n\nTo delete a task, just remove it from the Markdown file that defined it.\n\nTo "archive" a task, just remove its due date.\nYou can also mark the task as completed, or move it around to an "Archived" section (or whatever you want).\n\n### Moving Tasks Across Projects\n\nJust copy a task string from one Markdown file and paste it in another one.\nNo GUI fiddling necessary.\n\n## i3 Integration\n\nJust displaying the tasks that need to be done today is fine, but often we want more direction about what we should be doing *right now* in contrast to *merely today*.\nThere is another included CLI program `start` which given a task id, will emit the formatted task title to `/tmp/task`.\nThen this task title can be displayed prominently using your window manager\'s notification area.\n\nFor i3 (w/ i3status and i3bar), you can add this to your `~/.config/i3status/config`:\n\n```conf\ngeneral {\n    colors = true\n    markup = "pango"\n}\n\norder += "read_file task"\n\nread_file task {\n  format = "%content"\n  path = "/tmp/task"\n}\n```\n\nNow when you run `start <task_id>`, the task title will show up in your statusbar to remind you of what you should be working on *at this moment*.\n\n`start` takes the same command line arguments as `today`.\nIf you run `start` without a task id, it will clear the task file.\n\nYou may want to include aliases to `today` and `start` for your shell:\n\n```fish\nalias t \'today --dir $HOME/task_folder\'\nalias s \'start --dir $HOME/task_folder\'\n```\n\n## Limitations\n\n- **Time tracking**: since there is no emphermal task state, it may be hard to record time tracking info in an automated way to the task Markdown\n- **Task history / burndown rate**: there is no way to enforce specification of a \'finish\' date for a task, so it is not possible in general to calculate a burndown rate\n\nIn general, I think these \'quantification\' things are mostly useless and can often be distracting - just focus on what needs to get done today.\n\n- **Attachments**: there is no way to \'attach\' a PDF or image to a task, unless it is a URL.\n- **Syncing / phone editing**: version control is easy, but live syncing and collaborative editing of Markdown task files may be difficult without a Markdown CRDT. Similarly, editing files on your phone via raw text is harder than with a nice GUI.\n\n## Dev Notes\n\n### TODO\n\n- [x] Capture file names and line numbers\n- [x] CLI\n- [x] Emit due dates in CLI + how many days have elapsed\n- [x] Emit reminder dates in CLI\n- [x] Task description in CLI by specifying a task\n- [x] Support Markdown in title text\n- [x] Make the task description fancier (explicitly state title, due date, reminders, description)\n- [x] Sort tasks by heading path and due date criticality (highest priority = beyond due + due today, then reminders sorted by timedelta)\n- [x] Links in task title (how can I make this work during emission so they are terminal clickable?)\n- [x] Tasks that only have reminders (emphermal tasks) or reminders that are today [r:t] (sticky)\n    - If a task only has a due date, then it is simple - only show the task as due when it is due\n    - If a task has both due and reminder dates, the due date subsumes the reminder once the task is actually due. While the reminder is active, both the reminder and due dates show up with the task.\n    - If a task has only a reminder date, it should be visible via lookahead. Also once the reminder date has passed and the task incomplete, the reminder should still be active.\n        - Reminder only tasks are useful for tasks that are never "due" since you can\'t specify a date ahead of time, rather you just need to be reminded every now and then to check it\n- [x] Fix task sorting with more tests\n- [x] Subtasks\n- [x] Cancelled tasks\n- [x] Start CLI\n    - ~~use custom argparse Action to parse dates: https://stackoverflow.com/questions/33301000/custom-parsing-function-for-any-number-of-arguments-in-python-argparse~~\n    - [x] Unify argument parsing between the 2 programs\n    - i3 integration, use pango syntax in the /tmp/task file: https://docs.gtk.org/Pango/pango_markup.html\n- [ ] Support Markdown in Start CLI\n- [ ] Verify that a subtask that is due earlier than the main task shows up at the right time (when the subtask is due or has a reminder, not the main task)\n- [ ] List tasks without reminders / due dates (+ be able to read from a specific Markdown file vs a directory) (to check if I missed adding due dates to something)\n- [ ] Add colors for headings / paths / dates\n- [ ] Recurring tasks\n- [ ] Highlight tags\n- [ ] Search by tags\n- [ ] Use created dates to figure out tasks that been languishing\n- [ ] Show subtasks that are done in the visible subtasks (with a checkmark)\n- [ ] Generalize created/due/reminder/finish dates - lots of duplicated logic\n- [ ] Support headings with Markdown (tough to combine Markdown (since it is not necessarily always inline) and Console Markup)\n\n### Markdown Parser\n\n- Python Markdown libraries\n    - [Python-Markdown (3.1k)](https://github.com/Python-Markdown/markdown/) - most popular, middling performance, also not precisely CommonMark compliant\n    - [mistune (2.2k)](https://github.com/lepture/mistune) - high performance, not precisely CommonMark compliant\n      - Easy AST hacking, high perf, new 3.0 release incoming\n    - [marko (179)](https://github.com/frostming/marko) - not popular, but claims best CommonMark compliance, middling performance\n      - There is no Markdown renderer (for roundtrip)\n    - [mistletoe (552)](https://github.com/miyuchina/mistletoe/) - less popular, claims fastest pure Python CommonMark compliance\n      - AST hacking is painful, and no Markdown renderer (for roundtrip)\n- Decision\n  - All these seem to support raw AST dumping mode, which is what I\'m looking for\n  - **Initial thoughts**: mistletoe seems to be the best balance of performance and compliance and ease of working with the AST representation; mistune is a close second\n  - **Update**: mistune is superior. Markdown renderer from AST, easy pure Python AST (just dicts and lists), fast\n  - **Further update**: all these libraries are a pain to work with and have very minimal benefit for this project. I just want to parse very specific Markdown features and leave the rest of the document alone, so I have switched to manual and minimal parsing.\n\n### Rich TUI Library\n\n- [rich (41.6k)](https://github.com/Textualize/rich) seems to be the de-facto option\n',
    'author': 'Vighnesh Iyer',
    'author_email': 'vighnesh.iyer@gmail.com',
    'maintainer': 'Vighnesh Iyer',
    'maintainer_email': 'vighnesh.iyer@gmail.com',
    'url': 'https://github.com/vighneshiyer/today',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
