import setuptools


setuptools.setup(
    name = "acelerai-staging",
    version = "0.0.1",
    author = "DaniloAraneda",
    author_email = "danilo@alert2gain.com",
    description = "short package description",
    classifiers = [
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    package_dir = {"": "src"},
    packages = setuptools.find_packages(where="src"),
    include_package_data=True, 
    package_data={
        "acelerai_inputstream.models": ["*.json", "*.yaml", "*.txt", "*.py"] # Ajusta según los archivos que tengas
    },
    python_requires = ">=3.10.0",
    install_requires = [
        "anyio==4.8.0",
        "certifi>=2024.7.4",
        "charset-normalizer>=3.3.2",
        "exceptiongroup>=1.2.2",
        "fastjsonschema>=2.20.0",
        "h11>=0.14.0",
        "h2==4.1.0",
        "hpack==4.0.0",
        "httpcore==1.0.7",
        "httpx==0.28.1",
        "hyperframe==6.0.1",
        "idna>=3.7",
        "msgpack==1.1.0",
        "python-dateutil>=2.9.0.post0",
        "requests>=2.32.3",
        "six>=1.16.0",
        "sniffio==1.3.1",
        "typing_extensions>=4.12.2",
        "urllib3>=2.2.2"
   ]
)