# TrainRequest


## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**validation** | **str** | Methods for validating the model using the provided dataset. | [optional]  if omitted the server will use the default value of "none"
**validation_target_columns** | **[str], none_type** | A list of the training datasets&#39;s column names that the model&#39;s validation metric will be the median average over.  Cannot include descriptor columns.  If not provided then the model&#39;s validation metric will be the median average over all non-descriptor columns. | [optional] 
**hyperparameter_optimization** | **str** | Search method for finding the optimal parameters to use when training the model.  If &#39;none&#39; then the parameters as specified by the &#39;hyperparameters&#39; argument will be used to train the model.  If &#39;hyperparameterOptimization&#39; is not &#39;none&#39; then &#39;validation&#39; must also be not &#39;none&#39;. | [optional]  if omitted the server will use the default value of "none"
**hyperparameters** | **{str: (bool, date, datetime, dict, float, int, list, str, none_type)}** | The hyperparameters which Alchemite will use when training.  Must not be provided unless &#39;hyperparameterOptimization&#39; is &#39;none&#39;.  If no argument is provided for this parameter and the model was previously trained then the existing hyperparameters will be used to train the model, otherwise Alchemite&#39;s default hyperparameters will be used instead. | [optional] 
**fraction_data_present** | **[float]** | The fraction of data expected to be in each column of the datasets which the model will make predictions from.  The list &#39;fractionDataPresent&#39; should be ordered corresponding to the training dataset&#39;s &#39;columnHeaders&#39; parameter. | [optional] 
**virtual_experiment_validation** | **bool** | If true then only the descriptor columns will be used to make predictions when computing the validation metric. | [optional]  if omitted the server will use the default value of False
**virtual_training** | **bool** | If true then only the descriptor columns will be used as input in the first iteration of training | [optional]  if omitted the server will use the default value of False
**permitted_column_relationships** | [**[ModelsIdTrainPermittedColumnRelationships]**](ModelsIdTrainPermittedColumnRelationships.md) | An array of objects defining which columns the ML model is able to use or not use as inputs when modelling specific columns.  The \&quot;allow\&quot; and \&quot;disallow\&quot; arrays must contain distinct columns. They do not need to contain all columns in the dataset.  If columns are not allowed in either \&quot;allow\&quot; nor \&quot;disallow\&quot;, the model will use default behaviors:   - use all descriptors for all targets when virtualTraining is true.   - use all descriptors + targets when virtualTraining is false for all targets (except for the same target -&gt; target).  if virtualTraining is false:   This is equivalent to passing \&quot;allow\&quot;: list_of_all_columns for every column in the dataset.   Therefore, passing allow when virtualTraining is false has no effect on the model.   However, columns passed within \&quot;disallow\&quot; will have an effect.  if virtualTraining is true:   This is equivalent to passing \&quot;allow\&quot;: list_of_all_descriptors and passing \&quot;disallow\&quot; for all non descriptors.   Therefore, passing descriptor columns in the \&quot;allow\&quot; list has no effect on the model.   Similarly, passing non descriptor columns in the \&quot;disallow\&quot; list has no effect on the model.   However, columns passed within \&quot;allow\&quot; for non descriptors, and \&quot;disallow\&quot; for descriptors will have an effect.  Interaction with Measurement Groups:   If measurement groups are specified for the training dataset that are incompatible, a 400 response is returned.   This happens when a column defined in \&quot;name\&quot; and one or more columns defined in \&quot;allow\&quot; are part of the same measurement group.  | [optional] 
**enable_training_dataset_outliers** | **bool** | If true then compute the outliers in the training dataset using five sub-models, each trained on 80% of the full dataset to identify the outliers in the remaining 20%.  Once &#x60;trainingDatasetOutliersJobStatus&#x60; in the model metadata has the value &#39;done&#39; then the results will be available via &#x60;/models/id/training-dataset-outliers&#x60;.  Computing the outliers this way is generally expected to give better results than using the model trained on the full dataset to identify the outliers in its own training dataset. | [optional]  if omitted the server will use the default value of False

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


