# Fonts manually created for sequence logos

## Rationale
For the sequence logos, we want all letters to be the same height and not have any [descenders](https://en.wikipedia.org/wiki/Descender) and have the letters all the same height.
Unfortunately, for normal typography there [aren't very many fonts like this](https://graphicdesign.stackexchange.com/questions/111439/is-there-a-font-that-has-the-same-height-for-every-character).
Therefore, here we have manually created such fonts by editing existing fonts.

If you want to add additional fonts, create the `*.ttf` file for one and add it here.
The `*.ttf` file must have the **exact same** name as the font.


## Fonts provided here

### DejaVuSansMonoBold_SeqLogo
Created as follows:

 - Downloaded *DejaVu Fonts* from [here](https://sourceforge.net/projects/dejavu/files/dejavu/2.37/dejavu-fonts-ttf-2.37.zip/download).

 - Used [FontForge](https://fontforge.github.io) to open the `DejaVuSansMona-Bold.ttf` font, and adjusted the heights of all **capital** letters as well as the asterisk to be the full height.

### Comic Sans MS
Downloaded from [here](https://www.wfonts.com/font/comic-sans-ms).
This is just for example of goofy comic sans logo: it isn't a font where all letters have the same height and no descenders.
