# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/file-management/v1/file-management.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class File(betterproto.Message):
    """Contains information about a file stored in Trinsic's CDN"""

    id: str = betterproto.string_field(1)
    uploader_id: str = betterproto.string_field(2)
    size: int = betterproto.uint32_field(3)
    mime_type: str = betterproto.string_field(4)
    uploaded: str = betterproto.string_field(5)
    url: str = betterproto.string_field(6)


@dataclass(eq=False, repr=False)
class StorageStats(betterproto.Message):
    """
    Represents aggregate statistics of all files uploaded by a single issuer
    """

    num_files: int = betterproto.uint32_field(1)
    total_size: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class UploadFileRequest(betterproto.Message):
    """Request to upload a file to Trinsic's CDN"""

    contents: bytes = betterproto.bytes_field(1)
    """Raw content of file"""

    mime_type: str = betterproto.string_field(2)
    """MIME type describing file contents"""


@dataclass(eq=False, repr=False)
class UploadFileResponse(betterproto.Message):
    """Response to `UploadFileRequest`"""

    uploaded_file: "File" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetFileRequest(betterproto.Message):
    """Request to fetch information about a stored file"""

    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetFileResponse(betterproto.Message):
    """Response to `GetFileRequest`"""

    file: "File" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DeleteFileRequest(betterproto.Message):
    """Request to delete a file from Trinsic's CDN by ID"""

    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class DeleteFileResponse(betterproto.Message):
    """Response to `DeleteFileRequest`. Empty payload."""

    pass


@dataclass(eq=False, repr=False)
class ListFilesRequest(betterproto.Message):
    """Request to list files"""

    query: str = betterproto.string_field(1)
    """
    Query to search with. If not specified, will return the most recent 100
    files.
    """

    continuation_token: str = betterproto.string_field(2)
    """
    Token provided by previous `ListFilesRequest` if more data is available for
    query
    """


@dataclass(eq=False, repr=False)
class ListFilesResponse(betterproto.Message):
    """Response to `ListFilesRequest`"""

    files: List["File"] = betterproto.message_field(1)
    """Files found by query"""

    has_more_results: bool = betterproto.bool_field(2)
    """
    Whether more results are available for this query via `continuation_token`
    """

    continuation_token: str = betterproto.string_field(3)
    """Token to fetch next set of resuts via `ListFilesRequest`"""


@dataclass(eq=False, repr=False)
class GetStorageStatsRequest(betterproto.Message):
    """Request to get statistics about files uploaded by this account"""

    pass


@dataclass(eq=False, repr=False)
class GetStorageStatsResponse(betterproto.Message):
    """Response to `GetStorageStatsRequest`"""

    stats: "StorageStats" = betterproto.message_field(1)


class FileManagementStub(betterproto.ServiceStub):
    async def upload_file(
        self,
        upload_file_request: "UploadFileRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "UploadFileResponse":
        return await self._unary_unary(
            "/services.filemanagement.v1.FileManagement/UploadFile",
            upload_file_request,
            UploadFileResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_file(
        self,
        get_file_request: "GetFileRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GetFileResponse":
        return await self._unary_unary(
            "/services.filemanagement.v1.FileManagement/GetFile",
            get_file_request,
            GetFileResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_file(
        self,
        delete_file_request: "DeleteFileRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "DeleteFileResponse":
        return await self._unary_unary(
            "/services.filemanagement.v1.FileManagement/DeleteFile",
            delete_file_request,
            DeleteFileResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def list_files(
        self,
        list_files_request: "ListFilesRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "ListFilesResponse":
        return await self._unary_unary(
            "/services.filemanagement.v1.FileManagement/ListFiles",
            list_files_request,
            ListFilesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_storage_stats(
        self,
        get_storage_stats_request: "GetStorageStatsRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GetStorageStatsResponse":
        return await self._unary_unary(
            "/services.filemanagement.v1.FileManagement/GetStorageStats",
            get_storage_stats_request,
            GetStorageStatsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class FileManagementBase(ServiceBase):
    async def upload_file(
        self, upload_file_request: "UploadFileRequest"
    ) -> "UploadFileResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_file(self, get_file_request: "GetFileRequest") -> "GetFileResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_file(
        self, delete_file_request: "DeleteFileRequest"
    ) -> "DeleteFileResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_files(
        self, list_files_request: "ListFilesRequest"
    ) -> "ListFilesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_storage_stats(
        self, get_storage_stats_request: "GetStorageStatsRequest"
    ) -> "GetStorageStatsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_upload_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.upload_file(request)
        await stream.send_message(response)

    async def __rpc_get_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.get_file(request)
        await stream.send_message(response)

    async def __rpc_delete_file(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.delete_file(request)
        await stream.send_message(response)

    async def __rpc_list_files(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.list_files(request)
        await stream.send_message(response)

    async def __rpc_get_storage_stats(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.get_storage_stats(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.filemanagement.v1.FileManagement/UploadFile": grpclib.const.Handler(
                self.__rpc_upload_file,
                grpclib.const.Cardinality.UNARY_UNARY,
                UploadFileRequest,
                UploadFileResponse,
            ),
            "/services.filemanagement.v1.FileManagement/GetFile": grpclib.const.Handler(
                self.__rpc_get_file,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetFileRequest,
                GetFileResponse,
            ),
            "/services.filemanagement.v1.FileManagement/DeleteFile": grpclib.const.Handler(
                self.__rpc_delete_file,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteFileRequest,
                DeleteFileResponse,
            ),
            "/services.filemanagement.v1.FileManagement/ListFiles": grpclib.const.Handler(
                self.__rpc_list_files,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListFilesRequest,
                ListFilesResponse,
            ),
            "/services.filemanagement.v1.FileManagement/GetStorageStats": grpclib.const.Handler(
                self.__rpc_get_storage_stats,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetStorageStatsRequest,
                GetStorageStatsResponse,
            ),
        }
