"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDeployment = exports.ServiceType = void 0;
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
var ServiceType;
(function (ServiceType) {
    ServiceType["EXTERNAL_NAME"] = "ExternalName";
    ServiceType["CLUSTER_IP"] = "ClusterIP";
    ServiceType["NODE_PORT"] = "NodePort";
    ServiceType["LOAD_BALANCER"] = "LoadBalancer";
})(ServiceType = exports.ServiceType || (exports.ServiceType = {}));
class ServiceDeployment extends constructs_1.Construct {
    constructor(scope, id, options) {
        var _a, _b, _c, _d, _e, _f;
        super(scope, id);
        const replicas = (_a = options.replicas) !== null && _a !== void 0 ? _a : 1;
        const resources = (_b = options.resources) !== null && _b !== void 0 ? _b : { requests: { cpu: '100m', memory: '100Mi' } };
        const externalPort = (_c = options.externalPort) !== null && _c !== void 0 ? _c : 80;
        const containerPort = (_d = options.containerPort) !== null && _d !== void 0 ? _d : 8080;
        const containerName = (_e = options.containerName) !== null && _e !== void 0 ? _e : 'app';
        const serviceType = (_f = options.serviceType) !== null && _f !== void 0 ? _f : ServiceType.CLUSTER_IP;
        const label = {
            ...options.labels,
            app: constructs_1.Node.of(this).uniqueId,
        };
        const service = new k8s.Service(this, 'service', {
            metadata: { labels: label },
            spec: {
                type: serviceType,
                ports: [{ port: externalPort, targetPort: containerPort }],
                selector: label,
            },
        });
        new k8s.Deployment(this, 'deployment', {
            spec: {
                selector: { matchLabels: label },
                replicas: replicas,
                template: {
                    metadata: { labels: label },
                    spec: {
                        containers: [
                            {
                                name: containerName,
                                image: options.image,
                                ports: [{ containerPort }],
                                resources: resources,
                                env: renderEnv(options.env),
                            },
                        ],
                    },
                },
            },
        });
        this.host = service.name;
    }
}
exports.ServiceDeployment = ServiceDeployment;
function renderEnv(env = {}) {
    const result = new Array();
    for (const [key, value] of Object.entries(env)) {
        result.push({
            name: key,
            value: value,
        });
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,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