import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataUpcloudStorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Storage access type (public, private)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/storage#access_type DataUpcloudStorage#access_type}
    */
    readonly accessType?: string;
    /**
    * If more than one result is returned, use the most recent storage. This is only useful with private storages. Public storages might give unpredictable results.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/storage#most_recent DataUpcloudStorage#most_recent}
    */
    readonly mostRecent?: boolean | cdktf.IResolvable;
    /**
    * Exact name of the storage (same as title)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/storage#name DataUpcloudStorage#name}
    */
    readonly name?: string;
    /**
    * Use regular expression to match storage name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/storage#name_regex DataUpcloudStorage#name_regex}
    */
    readonly nameRegex?: string;
    /**
    * Storage type (normal, backup, cdrom, template). Use 'favorite' as type to filter storages on the list of favorites.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/storage#type DataUpcloudStorage#type}
    */
    readonly type: string;
    /**
    * The zone in which the storage resides
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/storage#zone DataUpcloudStorage#zone}
    */
    readonly zone?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/d/storage upcloud_storage}
*/
export declare class DataUpcloudStorage extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "upcloud_storage";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/d/storage upcloud_storage} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataUpcloudStorageConfig
    */
    constructor(scope: Construct, id: string, config: DataUpcloudStorageConfig);
    private _accessType?;
    get accessType(): string;
    set accessType(value: string);
    resetAccessType(): void;
    get accessTypeInput(): string | undefined;
    get id(): string;
    private _mostRecent?;
    get mostRecent(): boolean | cdktf.IResolvable;
    set mostRecent(value: boolean | cdktf.IResolvable);
    resetMostRecent(): void;
    get mostRecentInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nameRegex?;
    get nameRegex(): string;
    set nameRegex(value: string);
    resetNameRegex(): void;
    get nameRegexInput(): string | undefined;
    get size(): number;
    get state(): string;
    get tier(): string;
    get title(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-upcloud-storage.d.ts.map