import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataUpcloudZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique lablel for the zone
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/d/zone#name DataUpcloudZone#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/d/zone upcloud_zone}
*/
export declare class DataUpcloudZone extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "upcloud_zone";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/d/zone upcloud_zone} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataUpcloudZoneConfig
    */
    constructor(scope: Construct, id: string, config: DataUpcloudZoneConfig);
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get public(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-upcloud-zone.d.ts.map