import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirewallRulesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The unique id of the server to be protected the firewall rules
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#server_id FirewallRules#server_id}
    */
    readonly serverId: string;
    /**
    * firewall_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#firewall_rule FirewallRules#firewall_rule}
    */
    readonly firewallRule: FirewallRulesFirewallRule[] | cdktf.IResolvable;
}
export interface FirewallRulesFirewallRule {
    /**
    * Action to take if the rule conditions are met
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#action FirewallRules#action}
    */
    readonly action: string;
    /**
    * Freeform comment string for the rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#comment FirewallRules#comment}
    */
    readonly comment?: string;
    /**
    * The destination address range ends from this address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#destination_address_end FirewallRules#destination_address_end}
    */
    readonly destinationAddressEnd?: string;
    /**
    * The destination address range starts from this address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#destination_address_start FirewallRules#destination_address_start}
    */
    readonly destinationAddressStart?: string;
    /**
    * The destination port range ends from this port number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#destination_port_end FirewallRules#destination_port_end}
    */
    readonly destinationPortEnd?: string;
    /**
    * The destination port range starts from this port number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#destination_port_start FirewallRules#destination_port_start}
    */
    readonly destinationPortStart?: string;
    /**
    * The direction of network traffic this rule will be applied to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#direction FirewallRules#direction}
    */
    readonly direction: string;
    /**
    * The address family of new firewall rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#family FirewallRules#family}
    */
    readonly family: string;
    /**
    * The ICMP type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#icmp_type FirewallRules#icmp_type}
    */
    readonly icmpType?: string;
    /**
    * The protocol this rule will be applied to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#protocol FirewallRules#protocol}
    */
    readonly protocol?: string;
    /**
    * The source address range ends from this address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#source_address_end FirewallRules#source_address_end}
    */
    readonly sourceAddressEnd?: string;
    /**
    * The source address range starts from this address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#source_address_start FirewallRules#source_address_start}
    */
    readonly sourceAddressStart?: string;
    /**
    * The source port range ends from this port number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#source_port_end FirewallRules#source_port_end}
    */
    readonly sourcePortEnd?: string;
    /**
    * The source port range starts from this port number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules#source_port_start FirewallRules#source_port_start}
    */
    readonly sourcePortStart?: string;
}
export declare function firewallRulesFirewallRuleToTerraform(struct?: FirewallRulesFirewallRule | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules upcloud_firewall_rules}
*/
export declare class FirewallRules extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_firewall_rules";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/firewall_rules upcloud_firewall_rules} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirewallRulesConfig
    */
    constructor(scope: Construct, id: string, config: FirewallRulesConfig);
    get id(): string;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _firewallRule?;
    get firewallRule(): FirewallRulesFirewallRule[] | cdktf.IResolvable;
    set firewallRule(value: FirewallRulesFirewallRule[] | cdktf.IResolvable);
    get firewallRuleInput(): cdktf.IResolvable | FirewallRulesFirewallRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=firewall-rules.d.ts.map