import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerFrontendRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the load balancer frontend to which the rule is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#frontend LoadbalancerFrontendRule#frontend}
    */
    readonly frontend: string;
    /**
    * The name of the frontend rule must be unique within the load balancer service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#name LoadbalancerFrontendRule#name}
    */
    readonly name: string;
    /**
    * Rule with the higher priority goes first. Rules with the same priority processed in alphabetical order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#priority LoadbalancerFrontendRule#priority}
    */
    readonly priority: number;
    /**
    * actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#actions LoadbalancerFrontendRule#actions}
    */
    readonly actions?: LoadbalancerFrontendRuleActions;
    /**
    * matchers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#matchers LoadbalancerFrontendRule#matchers}
    */
    readonly matchers?: LoadbalancerFrontendRuleMatchers;
}
export interface LoadbalancerFrontendRuleActionsHttpRedirect {
    /**
    * Target location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#location LoadbalancerFrontendRule#location}
    */
    readonly location: string;
}
export declare function loadbalancerFrontendRuleActionsHttpRedirectToTerraform(struct?: LoadbalancerFrontendRuleActionsHttpRedirect | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleActionsHttpReturn {
    /**
    * Content type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#content_type LoadbalancerFrontendRule#content_type}
    */
    readonly contentType: string;
    /**
    * The payload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#payload LoadbalancerFrontendRule#payload}
    */
    readonly payload: string;
    /**
    * HTTP status code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#status LoadbalancerFrontendRule#status}
    */
    readonly status: number;
}
export declare function loadbalancerFrontendRuleActionsHttpReturnToTerraform(struct?: LoadbalancerFrontendRuleActionsHttpReturn | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleActionsTcpReject {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#active LoadbalancerFrontendRule#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
}
export declare function loadbalancerFrontendRuleActionsTcpRejectToTerraform(struct?: LoadbalancerFrontendRuleActionsTcpReject | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleActionsUseBackend {
    /**
    * The name of the backend where traffic will be routed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#backend_name LoadbalancerFrontendRule#backend_name}
    */
    readonly backendName: string;
}
export declare function loadbalancerFrontendRuleActionsUseBackendToTerraform(struct?: LoadbalancerFrontendRuleActionsUseBackend | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleActions {
    /**
    * http_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#http_redirect LoadbalancerFrontendRule#http_redirect}
    */
    readonly httpRedirect?: LoadbalancerFrontendRuleActionsHttpRedirect[] | cdktf.IResolvable;
    /**
    * http_return block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#http_return LoadbalancerFrontendRule#http_return}
    */
    readonly httpReturn?: LoadbalancerFrontendRuleActionsHttpReturn[] | cdktf.IResolvable;
    /**
    * tcp_reject block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#tcp_reject LoadbalancerFrontendRule#tcp_reject}
    */
    readonly tcpReject?: LoadbalancerFrontendRuleActionsTcpReject[] | cdktf.IResolvable;
    /**
    * use_backend block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#use_backend LoadbalancerFrontendRule#use_backend}
    */
    readonly useBackend?: LoadbalancerFrontendRuleActionsUseBackend[] | cdktf.IResolvable;
}
export declare function loadbalancerFrontendRuleActionsToTerraform(struct?: LoadbalancerFrontendRuleActionsOutputReference | LoadbalancerFrontendRuleActions): any;
export declare class LoadbalancerFrontendRuleActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LoadbalancerFrontendRuleActions | undefined;
    set internalValue(value: LoadbalancerFrontendRuleActions | undefined);
    private _httpRedirect?;
    get httpRedirect(): LoadbalancerFrontendRuleActionsHttpRedirect[] | cdktf.IResolvable;
    set httpRedirect(value: LoadbalancerFrontendRuleActionsHttpRedirect[] | cdktf.IResolvable);
    resetHttpRedirect(): void;
    get httpRedirectInput(): cdktf.IResolvable | LoadbalancerFrontendRuleActionsHttpRedirect[] | undefined;
    private _httpReturn?;
    get httpReturn(): LoadbalancerFrontendRuleActionsHttpReturn[] | cdktf.IResolvable;
    set httpReturn(value: LoadbalancerFrontendRuleActionsHttpReturn[] | cdktf.IResolvable);
    resetHttpReturn(): void;
    get httpReturnInput(): cdktf.IResolvable | LoadbalancerFrontendRuleActionsHttpReturn[] | undefined;
    private _tcpReject?;
    get tcpReject(): LoadbalancerFrontendRuleActionsTcpReject[] | cdktf.IResolvable;
    set tcpReject(value: LoadbalancerFrontendRuleActionsTcpReject[] | cdktf.IResolvable);
    resetTcpReject(): void;
    get tcpRejectInput(): cdktf.IResolvable | LoadbalancerFrontendRuleActionsTcpReject[] | undefined;
    private _useBackend?;
    get useBackend(): LoadbalancerFrontendRuleActionsUseBackend[] | cdktf.IResolvable;
    set useBackend(value: LoadbalancerFrontendRuleActionsUseBackend[] | cdktf.IResolvable);
    resetUseBackend(): void;
    get useBackendInput(): cdktf.IResolvable | LoadbalancerFrontendRuleActionsUseBackend[] | undefined;
}
export interface LoadbalancerFrontendRuleMatchersBodySize {
    /**
    * Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: number;
}
export declare function loadbalancerFrontendRuleMatchersBodySizeToTerraform(struct?: LoadbalancerFrontendRuleMatchersBodySize | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersBodySizeRange {
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#range_end LoadbalancerFrontendRule#range_end}
    */
    readonly rangeEnd: number;
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#range_start LoadbalancerFrontendRule#range_start}
    */
    readonly rangeStart: number;
}
export declare function loadbalancerFrontendRuleMatchersBodySizeRangeToTerraform(struct?: LoadbalancerFrontendRuleMatchersBodySizeRange | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersCookie {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Name of the argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#name LoadbalancerFrontendRule#name}
    */
    readonly name: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersCookieToTerraform(struct?: LoadbalancerFrontendRuleMatchersCookie | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersHeader {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Name of the argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#name LoadbalancerFrontendRule#name}
    */
    readonly name: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersHeaderToTerraform(struct?: LoadbalancerFrontendRuleMatchersHeader | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersHost {
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: string;
}
export declare function loadbalancerFrontendRuleMatchersHostToTerraform(struct?: LoadbalancerFrontendRuleMatchersHost | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersHttpMethod {
    /**
    * String value (`GET`, `HEAD`, `POST`, `PUT`, `PATCH`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: string;
}
export declare function loadbalancerFrontendRuleMatchersHttpMethodToTerraform(struct?: LoadbalancerFrontendRuleMatchersHttpMethod | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersNumMembersUp {
    /**
    * The name of the `backend` which members will be monitored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#backend_name LoadbalancerFrontendRule#backend_name}
    */
    readonly backendName: string;
    /**
    * Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: number;
}
export declare function loadbalancerFrontendRuleMatchersNumMembersUpToTerraform(struct?: LoadbalancerFrontendRuleMatchersNumMembersUp | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersPath {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersPathToTerraform(struct?: LoadbalancerFrontendRuleMatchersPath | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersSrcIp {
    /**
    * IP address. CIDR masks are supported, e.g. `192.168.0.0/24`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: string;
}
export declare function loadbalancerFrontendRuleMatchersSrcIpToTerraform(struct?: LoadbalancerFrontendRuleMatchersSrcIp | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersSrcPort {
    /**
    * Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value: number;
}
export declare function loadbalancerFrontendRuleMatchersSrcPortToTerraform(struct?: LoadbalancerFrontendRuleMatchersSrcPort | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersSrcPortRange {
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#range_end LoadbalancerFrontendRule#range_end}
    */
    readonly rangeEnd: number;
    /**
    * Integer value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#range_start LoadbalancerFrontendRule#range_start}
    */
    readonly rangeStart: number;
}
export declare function loadbalancerFrontendRuleMatchersSrcPortRangeToTerraform(struct?: LoadbalancerFrontendRuleMatchersSrcPortRange | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersUrl {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersUrlToTerraform(struct?: LoadbalancerFrontendRuleMatchersUrl | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersUrlParam {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * Name of the argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#name LoadbalancerFrontendRule#name}
    */
    readonly name: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersUrlParamToTerraform(struct?: LoadbalancerFrontendRuleMatchersUrlParam | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchersUrlQuery {
    /**
    * Ignore case, default `false`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#ignore_case LoadbalancerFrontendRule#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#method LoadbalancerFrontendRule#method}
    */
    readonly method: string;
    /**
    * String value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#value LoadbalancerFrontendRule#value}
    */
    readonly value?: string;
}
export declare function loadbalancerFrontendRuleMatchersUrlQueryToTerraform(struct?: LoadbalancerFrontendRuleMatchersUrlQuery | cdktf.IResolvable): any;
export interface LoadbalancerFrontendRuleMatchers {
    /**
    * body_size block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#body_size LoadbalancerFrontendRule#body_size}
    */
    readonly bodySize?: LoadbalancerFrontendRuleMatchersBodySize[] | cdktf.IResolvable;
    /**
    * body_size_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#body_size_range LoadbalancerFrontendRule#body_size_range}
    */
    readonly bodySizeRange?: LoadbalancerFrontendRuleMatchersBodySizeRange[] | cdktf.IResolvable;
    /**
    * cookie block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#cookie LoadbalancerFrontendRule#cookie}
    */
    readonly cookie?: LoadbalancerFrontendRuleMatchersCookie[] | cdktf.IResolvable;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#header LoadbalancerFrontendRule#header}
    */
    readonly header?: LoadbalancerFrontendRuleMatchersHeader[] | cdktf.IResolvable;
    /**
    * host block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#host LoadbalancerFrontendRule#host}
    */
    readonly host?: LoadbalancerFrontendRuleMatchersHost[] | cdktf.IResolvable;
    /**
    * http_method block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#http_method LoadbalancerFrontendRule#http_method}
    */
    readonly httpMethod?: LoadbalancerFrontendRuleMatchersHttpMethod[] | cdktf.IResolvable;
    /**
    * num_members_up block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#num_members_up LoadbalancerFrontendRule#num_members_up}
    */
    readonly numMembersUp?: LoadbalancerFrontendRuleMatchersNumMembersUp[] | cdktf.IResolvable;
    /**
    * path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#path LoadbalancerFrontendRule#path}
    */
    readonly path?: LoadbalancerFrontendRuleMatchersPath[] | cdktf.IResolvable;
    /**
    * src_ip block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#src_ip LoadbalancerFrontendRule#src_ip}
    */
    readonly srcIp?: LoadbalancerFrontendRuleMatchersSrcIp[] | cdktf.IResolvable;
    /**
    * src_port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#src_port LoadbalancerFrontendRule#src_port}
    */
    readonly srcPort?: LoadbalancerFrontendRuleMatchersSrcPort[] | cdktf.IResolvable;
    /**
    * src_port_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#src_port_range LoadbalancerFrontendRule#src_port_range}
    */
    readonly srcPortRange?: LoadbalancerFrontendRuleMatchersSrcPortRange[] | cdktf.IResolvable;
    /**
    * url block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#url LoadbalancerFrontendRule#url}
    */
    readonly url?: LoadbalancerFrontendRuleMatchersUrl[] | cdktf.IResolvable;
    /**
    * url_param block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#url_param LoadbalancerFrontendRule#url_param}
    */
    readonly urlParam?: LoadbalancerFrontendRuleMatchersUrlParam[] | cdktf.IResolvable;
    /**
    * url_query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule#url_query LoadbalancerFrontendRule#url_query}
    */
    readonly urlQuery?: LoadbalancerFrontendRuleMatchersUrlQuery[] | cdktf.IResolvable;
}
export declare function loadbalancerFrontendRuleMatchersToTerraform(struct?: LoadbalancerFrontendRuleMatchersOutputReference | LoadbalancerFrontendRuleMatchers): any;
export declare class LoadbalancerFrontendRuleMatchersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LoadbalancerFrontendRuleMatchers | undefined;
    set internalValue(value: LoadbalancerFrontendRuleMatchers | undefined);
    private _bodySize?;
    get bodySize(): LoadbalancerFrontendRuleMatchersBodySize[] | cdktf.IResolvable;
    set bodySize(value: LoadbalancerFrontendRuleMatchersBodySize[] | cdktf.IResolvable);
    resetBodySize(): void;
    get bodySizeInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersBodySize[] | undefined;
    private _bodySizeRange?;
    get bodySizeRange(): LoadbalancerFrontendRuleMatchersBodySizeRange[] | cdktf.IResolvable;
    set bodySizeRange(value: LoadbalancerFrontendRuleMatchersBodySizeRange[] | cdktf.IResolvable);
    resetBodySizeRange(): void;
    get bodySizeRangeInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersBodySizeRange[] | undefined;
    private _cookie?;
    get cookie(): LoadbalancerFrontendRuleMatchersCookie[] | cdktf.IResolvable;
    set cookie(value: LoadbalancerFrontendRuleMatchersCookie[] | cdktf.IResolvable);
    resetCookie(): void;
    get cookieInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersCookie[] | undefined;
    private _header?;
    get header(): LoadbalancerFrontendRuleMatchersHeader[] | cdktf.IResolvable;
    set header(value: LoadbalancerFrontendRuleMatchersHeader[] | cdktf.IResolvable);
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersHeader[] | undefined;
    private _host?;
    get host(): LoadbalancerFrontendRuleMatchersHost[] | cdktf.IResolvable;
    set host(value: LoadbalancerFrontendRuleMatchersHost[] | cdktf.IResolvable);
    resetHost(): void;
    get hostInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersHost[] | undefined;
    private _httpMethod?;
    get httpMethod(): LoadbalancerFrontendRuleMatchersHttpMethod[] | cdktf.IResolvable;
    set httpMethod(value: LoadbalancerFrontendRuleMatchersHttpMethod[] | cdktf.IResolvable);
    resetHttpMethod(): void;
    get httpMethodInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersHttpMethod[] | undefined;
    private _numMembersUp?;
    get numMembersUp(): LoadbalancerFrontendRuleMatchersNumMembersUp[] | cdktf.IResolvable;
    set numMembersUp(value: LoadbalancerFrontendRuleMatchersNumMembersUp[] | cdktf.IResolvable);
    resetNumMembersUp(): void;
    get numMembersUpInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersNumMembersUp[] | undefined;
    private _path?;
    get path(): LoadbalancerFrontendRuleMatchersPath[] | cdktf.IResolvable;
    set path(value: LoadbalancerFrontendRuleMatchersPath[] | cdktf.IResolvable);
    resetPath(): void;
    get pathInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersPath[] | undefined;
    private _srcIp?;
    get srcIp(): LoadbalancerFrontendRuleMatchersSrcIp[] | cdktf.IResolvable;
    set srcIp(value: LoadbalancerFrontendRuleMatchersSrcIp[] | cdktf.IResolvable);
    resetSrcIp(): void;
    get srcIpInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersSrcIp[] | undefined;
    private _srcPort?;
    get srcPort(): LoadbalancerFrontendRuleMatchersSrcPort[] | cdktf.IResolvable;
    set srcPort(value: LoadbalancerFrontendRuleMatchersSrcPort[] | cdktf.IResolvable);
    resetSrcPort(): void;
    get srcPortInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersSrcPort[] | undefined;
    private _srcPortRange?;
    get srcPortRange(): LoadbalancerFrontendRuleMatchersSrcPortRange[] | cdktf.IResolvable;
    set srcPortRange(value: LoadbalancerFrontendRuleMatchersSrcPortRange[] | cdktf.IResolvable);
    resetSrcPortRange(): void;
    get srcPortRangeInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersSrcPortRange[] | undefined;
    private _url?;
    get url(): LoadbalancerFrontendRuleMatchersUrl[] | cdktf.IResolvable;
    set url(value: LoadbalancerFrontendRuleMatchersUrl[] | cdktf.IResolvable);
    resetUrl(): void;
    get urlInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersUrl[] | undefined;
    private _urlParam?;
    get urlParam(): LoadbalancerFrontendRuleMatchersUrlParam[] | cdktf.IResolvable;
    set urlParam(value: LoadbalancerFrontendRuleMatchersUrlParam[] | cdktf.IResolvable);
    resetUrlParam(): void;
    get urlParamInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersUrlParam[] | undefined;
    private _urlQuery?;
    get urlQuery(): LoadbalancerFrontendRuleMatchersUrlQuery[] | cdktf.IResolvable;
    set urlQuery(value: LoadbalancerFrontendRuleMatchersUrlQuery[] | cdktf.IResolvable);
    resetUrlQuery(): void;
    get urlQueryInput(): cdktf.IResolvable | LoadbalancerFrontendRuleMatchersUrlQuery[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule upcloud_loadbalancer_frontend_rule}
*/
export declare class LoadbalancerFrontendRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_frontend_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend_rule upcloud_loadbalancer_frontend_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerFrontendRuleConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerFrontendRuleConfig);
    private _frontend?;
    get frontend(): string;
    set frontend(value: string);
    get frontendInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _actions;
    get actions(): LoadbalancerFrontendRuleActionsOutputReference;
    putActions(value: LoadbalancerFrontendRuleActions): void;
    resetActions(): void;
    get actionsInput(): LoadbalancerFrontendRuleActions | undefined;
    private _matchers;
    get matchers(): LoadbalancerFrontendRuleMatchersOutputReference;
    putMatchers(value: LoadbalancerFrontendRuleMatchers): void;
    resetMatchers(): void;
    get matchersInput(): LoadbalancerFrontendRuleMatchers | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=loadbalancer-frontend-rule.d.ts.map