import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerFrontendConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the default backend where traffic will be routed. Note, default backend can be overwritten in frontend rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#default_backend_name LoadbalancerFrontend#default_backend_name}
    */
    readonly defaultBackendName: string;
    /**
    * ID of the load balancer to which the frontend is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#loadbalancer LoadbalancerFrontend#loadbalancer}
    */
    readonly loadbalancer: string;
    /**
    * When load balancer operating in `tcp` mode it acts as a layer 4 proxy. In `http` mode it acts as a layer 7 proxy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#mode LoadbalancerFrontend#mode}
    */
    readonly mode: string;
    /**
    * The name of the frontend must be unique within the load balancer service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#name LoadbalancerFrontend#name}
    */
    readonly name: string;
    /**
    * Port to listen incoming requests
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#port LoadbalancerFrontend#port}
    */
    readonly port: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend upcloud_loadbalancer_frontend}
*/
export declare class LoadbalancerFrontend extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_frontend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend upcloud_loadbalancer_frontend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerFrontendConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerFrontendConfig);
    private _defaultBackendName?;
    get defaultBackendName(): string;
    set defaultBackendName(value: string);
    get defaultBackendNameInput(): string | undefined;
    get id(): string;
    private _loadbalancer?;
    get loadbalancer(): string;
    set loadbalancer(value: string);
    get loadbalancerInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    get rules(): string[];
    get tlsConfigs(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=loadbalancer-frontend.d.ts.map