import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The service configured status indicates the service's current intended status. Managed by the customer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#configured_status Loadbalancer#configured_status}
    */
    readonly configuredStatus?: string;
    /**
    * The name of the service must be unique within customer account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#name Loadbalancer#name}
    */
    readonly name: string;
    /**
    * Private network UUID where traffic will be routed. Must reside in load balancer zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#network Loadbalancer#network}
    */
    readonly network: string;
    /**
    * Plan which the service will have
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#plan Loadbalancer#plan}
    */
    readonly plan: string;
    /**
    * Zone in which the service will be hosted, e.g. `fi-hel1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer#zone Loadbalancer#zone}
    */
    readonly zone: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer upcloud_loadbalancer}
*/
export declare class Loadbalancer extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer upcloud_loadbalancer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerConfig);
    get backends(): string[];
    private _configuredStatus?;
    get configuredStatus(): string;
    set configuredStatus(value: string);
    resetConfiguredStatus(): void;
    get configuredStatusInput(): string | undefined;
    get dnsName(): string;
    get frontends(): string[];
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    get operationalState(): string;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    get resolvers(): string[];
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=loadbalancer.d.ts.map