"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedDatabaseMysql = exports.ManagedDatabaseMysqlPropertiesOutputReference = exports.managedDatabaseMysqlPropertiesToTerraform = exports.ManagedDatabaseMysqlPropertiesMigrationOutputReference = exports.managedDatabaseMysqlPropertiesMigrationToTerraform = exports.ManagedDatabaseMysqlNodeStatesList = exports.ManagedDatabaseMysqlNodeStatesOutputReference = exports.managedDatabaseMysqlNodeStatesToTerraform = exports.ManagedDatabaseMysqlComponentsList = exports.ManagedDatabaseMysqlComponentsOutputReference = exports.managedDatabaseMysqlComponentsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function managedDatabaseMysqlComponentsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.managedDatabaseMysqlComponentsToTerraform = managedDatabaseMysqlComponentsToTerraform;
class ManagedDatabaseMysqlComponentsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // component - computed: true, optional: false, required: false
    get component() {
        return this.getStringAttribute('component');
    }
    // host - computed: true, optional: false, required: false
    get host() {
        return this.getStringAttribute('host');
    }
    // port - computed: true, optional: false, required: false
    get port() {
        return this.getNumberAttribute('port');
    }
    // route - computed: true, optional: false, required: false
    get route() {
        return this.getStringAttribute('route');
    }
    // usage - computed: true, optional: false, required: false
    get usage() {
        return this.getStringAttribute('usage');
    }
}
exports.ManagedDatabaseMysqlComponentsOutputReference = ManagedDatabaseMysqlComponentsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlComponentsOutputReference[_a] = { fqn: "@cdktf/provider-upcloud.ManagedDatabaseMysqlComponentsOutputReference", version: "0.0.7" };
class ManagedDatabaseMysqlComponentsList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ManagedDatabaseMysqlComponentsOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ManagedDatabaseMysqlComponentsList = ManagedDatabaseMysqlComponentsList;
_b = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlComponentsList[_b] = { fqn: "@cdktf/provider-upcloud.ManagedDatabaseMysqlComponentsList", version: "0.0.7" };
function managedDatabaseMysqlNodeStatesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.managedDatabaseMysqlNodeStatesToTerraform = managedDatabaseMysqlNodeStatesToTerraform;
class ManagedDatabaseMysqlNodeStatesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    // role - computed: true, optional: false, required: false
    get role() {
        return this.getStringAttribute('role');
    }
    // state - computed: true, optional: false, required: false
    get state() {
        return this.getStringAttribute('state');
    }
}
exports.ManagedDatabaseMysqlNodeStatesOutputReference = ManagedDatabaseMysqlNodeStatesOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlNodeStatesOutputReference[_c] = { fqn: "@cdktf/provider-upcloud.ManagedDatabaseMysqlNodeStatesOutputReference", version: "0.0.7" };
class ManagedDatabaseMysqlNodeStatesList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ManagedDatabaseMysqlNodeStatesOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ManagedDatabaseMysqlNodeStatesList = ManagedDatabaseMysqlNodeStatesList;
_d = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlNodeStatesList[_d] = { fqn: "@cdktf/provider-upcloud.ManagedDatabaseMysqlNodeStatesList", version: "0.0.7" };
function managedDatabaseMysqlPropertiesMigrationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        dbname: cdktf.stringToTerraform(struct.dbname),
        host: cdktf.stringToTerraform(struct.host),
        ignore_dbs: cdktf.stringToTerraform(struct.ignoreDbs),
        password: cdktf.stringToTerraform(struct.password),
        port: cdktf.numberToTerraform(struct.port),
        ssl: cdktf.booleanToTerraform(struct.ssl),
        username: cdktf.stringToTerraform(struct.username),
    };
}
exports.managedDatabaseMysqlPropertiesMigrationToTerraform = managedDatabaseMysqlPropertiesMigrationToTerraform;
class ManagedDatabaseMysqlPropertiesMigrationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._dbname !== undefined) {
            hasAnyValues = true;
            internalValueResult.dbname = this._dbname;
        }
        if (this._host !== undefined) {
            hasAnyValues = true;
            internalValueResult.host = this._host;
        }
        if (this._ignoreDbs !== undefined) {
            hasAnyValues = true;
            internalValueResult.ignoreDbs = this._ignoreDbs;
        }
        if (this._password !== undefined) {
            hasAnyValues = true;
            internalValueResult.password = this._password;
        }
        if (this._port !== undefined) {
            hasAnyValues = true;
            internalValueResult.port = this._port;
        }
        if (this._ssl !== undefined) {
            hasAnyValues = true;
            internalValueResult.ssl = this._ssl;
        }
        if (this._username !== undefined) {
            hasAnyValues = true;
            internalValueResult.username = this._username;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._dbname = undefined;
            this._host = undefined;
            this._ignoreDbs = undefined;
            this._password = undefined;
            this._port = undefined;
            this._ssl = undefined;
            this._username = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._dbname = value.dbname;
            this._host = value.host;
            this._ignoreDbs = value.ignoreDbs;
            this._password = value.password;
            this._port = value.port;
            this._ssl = value.ssl;
            this._username = value.username;
        }
    }
    get dbname() {
        return this.getStringAttribute('dbname');
    }
    set dbname(value) {
        this._dbname = value;
    }
    resetDbname() {
        this._dbname = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dbnameInput() {
        return this._dbname;
    }
    get host() {
        return this.getStringAttribute('host');
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get ignoreDbs() {
        return this.getStringAttribute('ignore_dbs');
    }
    set ignoreDbs(value) {
        this._ignoreDbs = value;
    }
    resetIgnoreDbs() {
        this._ignoreDbs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreDbsInput() {
        return this._ignoreDbs;
    }
    get password() {
        return this.getStringAttribute('password');
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get ssl() {
        return this.getBooleanAttribute('ssl');
    }
    set ssl(value) {
        this._ssl = value;
    }
    resetSsl() {
        this._ssl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslInput() {
        return this._ssl;
    }
    get username() {
        return this.getStringAttribute('username');
    }
    set username(value) {
        this._username = value;
    }
    resetUsername() {
        this._username = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
}
exports.ManagedDatabaseMysqlPropertiesMigrationOutputReference = ManagedDatabaseMysqlPropertiesMigrationOutputReference;
_e = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlPropertiesMigrationOutputReference[_e] = { fqn: "@cdktf/provider-upcloud.ManagedDatabaseMysqlPropertiesMigrationOutputReference", version: "0.0.7" };
function managedDatabaseMysqlPropertiesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        admin_password: cdktf.stringToTerraform(struct.adminPassword),
        admin_username: cdktf.stringToTerraform(struct.adminUsername),
        automatic_utility_network_ip_filter: cdktf.booleanToTerraform(struct.automaticUtilityNetworkIpFilter),
        backup_hour: cdktf.numberToTerraform(struct.backupHour),
        backup_minute: cdktf.numberToTerraform(struct.backupMinute),
        binlog_retention_period: cdktf.numberToTerraform(struct.binlogRetentionPeriod),
        connect_timeout: cdktf.numberToTerraform(struct.connectTimeout),
        default_time_zone: cdktf.stringToTerraform(struct.defaultTimeZone),
        group_concat_max_len: cdktf.numberToTerraform(struct.groupConcatMaxLen),
        information_schema_stats_expiry: cdktf.numberToTerraform(struct.informationSchemaStatsExpiry),
        innodb_ft_min_token_size: cdktf.numberToTerraform(struct.innodbFtMinTokenSize),
        innodb_ft_server_stopword_table: cdktf.stringToTerraform(struct.innodbFtServerStopwordTable),
        innodb_lock_wait_timeout: cdktf.numberToTerraform(struct.innodbLockWaitTimeout),
        innodb_log_buffer_size: cdktf.numberToTerraform(struct.innodbLogBufferSize),
        innodb_online_alter_log_max_size: cdktf.numberToTerraform(struct.innodbOnlineAlterLogMaxSize),
        innodb_print_all_deadlocks: cdktf.booleanToTerraform(struct.innodbPrintAllDeadlocks),
        innodb_rollback_on_timeout: cdktf.booleanToTerraform(struct.innodbRollbackOnTimeout),
        interactive_timeout: cdktf.numberToTerraform(struct.interactiveTimeout),
        internal_tmp_mem_storage_engine: cdktf.stringToTerraform(struct.internalTmpMemStorageEngine),
        ip_filter: cdktf.listMapper(cdktf.stringToTerraform)(struct.ipFilter),
        long_query_time: cdktf.numberToTerraform(struct.longQueryTime),
        max_allowed_packet: cdktf.numberToTerraform(struct.maxAllowedPacket),
        max_heap_table_size: cdktf.numberToTerraform(struct.maxHeapTableSize),
        net_read_timeout: cdktf.numberToTerraform(struct.netReadTimeout),
        net_write_timeout: cdktf.numberToTerraform(struct.netWriteTimeout),
        public_access: cdktf.booleanToTerraform(struct.publicAccess),
        slow_query_log: cdktf.booleanToTerraform(struct.slowQueryLog),
        sort_buffer_size: cdktf.numberToTerraform(struct.sortBufferSize),
        sql_mode: cdktf.stringToTerraform(struct.sqlMode),
        sql_require_primary_key: cdktf.booleanToTerraform(struct.sqlRequirePrimaryKey),
        tmp_table_size: cdktf.numberToTerraform(struct.tmpTableSize),
        version: cdktf.stringToTerraform(struct.version),
        wait_timeout: cdktf.numberToTerraform(struct.waitTimeout),
        migration: managedDatabaseMysqlPropertiesMigrationToTerraform(struct.migration),
    };
}
exports.managedDatabaseMysqlPropertiesToTerraform = managedDatabaseMysqlPropertiesToTerraform;
class ManagedDatabaseMysqlPropertiesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // migration - computed: false, optional: true, required: false
        this._migration = new ManagedDatabaseMysqlPropertiesMigrationOutputReference(this, "migration");
    }
    get internalValue() {
        var _h, _j;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._adminPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.adminPassword = this._adminPassword;
        }
        if (this._adminUsername !== undefined) {
            hasAnyValues = true;
            internalValueResult.adminUsername = this._adminUsername;
        }
        if (this._automaticUtilityNetworkIpFilter !== undefined) {
            hasAnyValues = true;
            internalValueResult.automaticUtilityNetworkIpFilter = this._automaticUtilityNetworkIpFilter;
        }
        if (this._backupHour !== undefined) {
            hasAnyValues = true;
            internalValueResult.backupHour = this._backupHour;
        }
        if (this._backupMinute !== undefined) {
            hasAnyValues = true;
            internalValueResult.backupMinute = this._backupMinute;
        }
        if (this._binlogRetentionPeriod !== undefined) {
            hasAnyValues = true;
            internalValueResult.binlogRetentionPeriod = this._binlogRetentionPeriod;
        }
        if (this._connectTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.connectTimeout = this._connectTimeout;
        }
        if (this._defaultTimeZone !== undefined) {
            hasAnyValues = true;
            internalValueResult.defaultTimeZone = this._defaultTimeZone;
        }
        if (this._groupConcatMaxLen !== undefined) {
            hasAnyValues = true;
            internalValueResult.groupConcatMaxLen = this._groupConcatMaxLen;
        }
        if (this._informationSchemaStatsExpiry !== undefined) {
            hasAnyValues = true;
            internalValueResult.informationSchemaStatsExpiry = this._informationSchemaStatsExpiry;
        }
        if (this._innodbFtMinTokenSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbFtMinTokenSize = this._innodbFtMinTokenSize;
        }
        if (this._innodbFtServerStopwordTable !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbFtServerStopwordTable = this._innodbFtServerStopwordTable;
        }
        if (this._innodbLockWaitTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbLockWaitTimeout = this._innodbLockWaitTimeout;
        }
        if (this._innodbLogBufferSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbLogBufferSize = this._innodbLogBufferSize;
        }
        if (this._innodbOnlineAlterLogMaxSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbOnlineAlterLogMaxSize = this._innodbOnlineAlterLogMaxSize;
        }
        if (this._innodbPrintAllDeadlocks !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbPrintAllDeadlocks = this._innodbPrintAllDeadlocks;
        }
        if (this._innodbRollbackOnTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.innodbRollbackOnTimeout = this._innodbRollbackOnTimeout;
        }
        if (this._interactiveTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.interactiveTimeout = this._interactiveTimeout;
        }
        if (this._internalTmpMemStorageEngine !== undefined) {
            hasAnyValues = true;
            internalValueResult.internalTmpMemStorageEngine = this._internalTmpMemStorageEngine;
        }
        if (this._ipFilter !== undefined) {
            hasAnyValues = true;
            internalValueResult.ipFilter = this._ipFilter;
        }
        if (this._longQueryTime !== undefined) {
            hasAnyValues = true;
            internalValueResult.longQueryTime = this._longQueryTime;
        }
        if (this._maxAllowedPacket !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxAllowedPacket = this._maxAllowedPacket;
        }
        if (this._maxHeapTableSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxHeapTableSize = this._maxHeapTableSize;
        }
        if (this._netReadTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.netReadTimeout = this._netReadTimeout;
        }
        if (this._netWriteTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.netWriteTimeout = this._netWriteTimeout;
        }
        if (this._publicAccess !== undefined) {
            hasAnyValues = true;
            internalValueResult.publicAccess = this._publicAccess;
        }
        if (this._slowQueryLog !== undefined) {
            hasAnyValues = true;
            internalValueResult.slowQueryLog = this._slowQueryLog;
        }
        if (this._sortBufferSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.sortBufferSize = this._sortBufferSize;
        }
        if (this._sqlMode !== undefined) {
            hasAnyValues = true;
            internalValueResult.sqlMode = this._sqlMode;
        }
        if (this._sqlRequirePrimaryKey !== undefined) {
            hasAnyValues = true;
            internalValueResult.sqlRequirePrimaryKey = this._sqlRequirePrimaryKey;
        }
        if (this._tmpTableSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.tmpTableSize = this._tmpTableSize;
        }
        if (this._version !== undefined) {
            hasAnyValues = true;
            internalValueResult.version = this._version;
        }
        if (this._waitTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.waitTimeout = this._waitTimeout;
        }
        if (((_h = this._migration) === null || _h === void 0 ? void 0 : _h.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.migration = (_j = this._migration) === null || _j === void 0 ? void 0 : _j.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._adminPassword = undefined;
            this._adminUsername = undefined;
            this._automaticUtilityNetworkIpFilter = undefined;
            this._backupHour = undefined;
            this._backupMinute = undefined;
            this._binlogRetentionPeriod = undefined;
            this._connectTimeout = undefined;
            this._defaultTimeZone = undefined;
            this._groupConcatMaxLen = undefined;
            this._informationSchemaStatsExpiry = undefined;
            this._innodbFtMinTokenSize = undefined;
            this._innodbFtServerStopwordTable = undefined;
            this._innodbLockWaitTimeout = undefined;
            this._innodbLogBufferSize = undefined;
            this._innodbOnlineAlterLogMaxSize = undefined;
            this._innodbPrintAllDeadlocks = undefined;
            this._innodbRollbackOnTimeout = undefined;
            this._interactiveTimeout = undefined;
            this._internalTmpMemStorageEngine = undefined;
            this._ipFilter = undefined;
            this._longQueryTime = undefined;
            this._maxAllowedPacket = undefined;
            this._maxHeapTableSize = undefined;
            this._netReadTimeout = undefined;
            this._netWriteTimeout = undefined;
            this._publicAccess = undefined;
            this._slowQueryLog = undefined;
            this._sortBufferSize = undefined;
            this._sqlMode = undefined;
            this._sqlRequirePrimaryKey = undefined;
            this._tmpTableSize = undefined;
            this._version = undefined;
            this._waitTimeout = undefined;
            this._migration.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._adminPassword = value.adminPassword;
            this._adminUsername = value.adminUsername;
            this._automaticUtilityNetworkIpFilter = value.automaticUtilityNetworkIpFilter;
            this._backupHour = value.backupHour;
            this._backupMinute = value.backupMinute;
            this._binlogRetentionPeriod = value.binlogRetentionPeriod;
            this._connectTimeout = value.connectTimeout;
            this._defaultTimeZone = value.defaultTimeZone;
            this._groupConcatMaxLen = value.groupConcatMaxLen;
            this._informationSchemaStatsExpiry = value.informationSchemaStatsExpiry;
            this._innodbFtMinTokenSize = value.innodbFtMinTokenSize;
            this._innodbFtServerStopwordTable = value.innodbFtServerStopwordTable;
            this._innodbLockWaitTimeout = value.innodbLockWaitTimeout;
            this._innodbLogBufferSize = value.innodbLogBufferSize;
            this._innodbOnlineAlterLogMaxSize = value.innodbOnlineAlterLogMaxSize;
            this._innodbPrintAllDeadlocks = value.innodbPrintAllDeadlocks;
            this._innodbRollbackOnTimeout = value.innodbRollbackOnTimeout;
            this._interactiveTimeout = value.interactiveTimeout;
            this._internalTmpMemStorageEngine = value.internalTmpMemStorageEngine;
            this._ipFilter = value.ipFilter;
            this._longQueryTime = value.longQueryTime;
            this._maxAllowedPacket = value.maxAllowedPacket;
            this._maxHeapTableSize = value.maxHeapTableSize;
            this._netReadTimeout = value.netReadTimeout;
            this._netWriteTimeout = value.netWriteTimeout;
            this._publicAccess = value.publicAccess;
            this._slowQueryLog = value.slowQueryLog;
            this._sortBufferSize = value.sortBufferSize;
            this._sqlMode = value.sqlMode;
            this._sqlRequirePrimaryKey = value.sqlRequirePrimaryKey;
            this._tmpTableSize = value.tmpTableSize;
            this._version = value.version;
            this._waitTimeout = value.waitTimeout;
            this._migration.internalValue = value.migration;
        }
    }
    get adminPassword() {
        return this.getStringAttribute('admin_password');
    }
    set adminPassword(value) {
        this._adminPassword = value;
    }
    resetAdminPassword() {
        this._adminPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminPasswordInput() {
        return this._adminPassword;
    }
    get adminUsername() {
        return this.getStringAttribute('admin_username');
    }
    set adminUsername(value) {
        this._adminUsername = value;
    }
    resetAdminUsername() {
        this._adminUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminUsernameInput() {
        return this._adminUsername;
    }
    get automaticUtilityNetworkIpFilter() {
        return this.getBooleanAttribute('automatic_utility_network_ip_filter');
    }
    set automaticUtilityNetworkIpFilter(value) {
        this._automaticUtilityNetworkIpFilter = value;
    }
    resetAutomaticUtilityNetworkIpFilter() {
        this._automaticUtilityNetworkIpFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get automaticUtilityNetworkIpFilterInput() {
        return this._automaticUtilityNetworkIpFilter;
    }
    get backupHour() {
        return this.getNumberAttribute('backup_hour');
    }
    set backupHour(value) {
        this._backupHour = value;
    }
    resetBackupHour() {
        this._backupHour = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupHourInput() {
        return this._backupHour;
    }
    get backupMinute() {
        return this.getNumberAttribute('backup_minute');
    }
    set backupMinute(value) {
        this._backupMinute = value;
    }
    resetBackupMinute() {
        this._backupMinute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupMinuteInput() {
        return this._backupMinute;
    }
    get binlogRetentionPeriod() {
        return this.getNumberAttribute('binlog_retention_period');
    }
    set binlogRetentionPeriod(value) {
        this._binlogRetentionPeriod = value;
    }
    resetBinlogRetentionPeriod() {
        this._binlogRetentionPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binlogRetentionPeriodInput() {
        return this._binlogRetentionPeriod;
    }
    get connectTimeout() {
        return this.getNumberAttribute('connect_timeout');
    }
    set connectTimeout(value) {
        this._connectTimeout = value;
    }
    resetConnectTimeout() {
        this._connectTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get connectTimeoutInput() {
        return this._connectTimeout;
    }
    get defaultTimeZone() {
        return this.getStringAttribute('default_time_zone');
    }
    set defaultTimeZone(value) {
        this._defaultTimeZone = value;
    }
    resetDefaultTimeZone() {
        this._defaultTimeZone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultTimeZoneInput() {
        return this._defaultTimeZone;
    }
    get groupConcatMaxLen() {
        return this.getNumberAttribute('group_concat_max_len');
    }
    set groupConcatMaxLen(value) {
        this._groupConcatMaxLen = value;
    }
    resetGroupConcatMaxLen() {
        this._groupConcatMaxLen = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupConcatMaxLenInput() {
        return this._groupConcatMaxLen;
    }
    get informationSchemaStatsExpiry() {
        return this.getNumberAttribute('information_schema_stats_expiry');
    }
    set informationSchemaStatsExpiry(value) {
        this._informationSchemaStatsExpiry = value;
    }
    resetInformationSchemaStatsExpiry() {
        this._informationSchemaStatsExpiry = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get informationSchemaStatsExpiryInput() {
        return this._informationSchemaStatsExpiry;
    }
    get innodbFtMinTokenSize() {
        return this.getNumberAttribute('innodb_ft_min_token_size');
    }
    set innodbFtMinTokenSize(value) {
        this._innodbFtMinTokenSize = value;
    }
    resetInnodbFtMinTokenSize() {
        this._innodbFtMinTokenSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbFtMinTokenSizeInput() {
        return this._innodbFtMinTokenSize;
    }
    get innodbFtServerStopwordTable() {
        return this.getStringAttribute('innodb_ft_server_stopword_table');
    }
    set innodbFtServerStopwordTable(value) {
        this._innodbFtServerStopwordTable = value;
    }
    resetInnodbFtServerStopwordTable() {
        this._innodbFtServerStopwordTable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbFtServerStopwordTableInput() {
        return this._innodbFtServerStopwordTable;
    }
    get innodbLockWaitTimeout() {
        return this.getNumberAttribute('innodb_lock_wait_timeout');
    }
    set innodbLockWaitTimeout(value) {
        this._innodbLockWaitTimeout = value;
    }
    resetInnodbLockWaitTimeout() {
        this._innodbLockWaitTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbLockWaitTimeoutInput() {
        return this._innodbLockWaitTimeout;
    }
    get innodbLogBufferSize() {
        return this.getNumberAttribute('innodb_log_buffer_size');
    }
    set innodbLogBufferSize(value) {
        this._innodbLogBufferSize = value;
    }
    resetInnodbLogBufferSize() {
        this._innodbLogBufferSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbLogBufferSizeInput() {
        return this._innodbLogBufferSize;
    }
    get innodbOnlineAlterLogMaxSize() {
        return this.getNumberAttribute('innodb_online_alter_log_max_size');
    }
    set innodbOnlineAlterLogMaxSize(value) {
        this._innodbOnlineAlterLogMaxSize = value;
    }
    resetInnodbOnlineAlterLogMaxSize() {
        this._innodbOnlineAlterLogMaxSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbOnlineAlterLogMaxSizeInput() {
        return this._innodbOnlineAlterLogMaxSize;
    }
    get innodbPrintAllDeadlocks() {
        return this.getBooleanAttribute('innodb_print_all_deadlocks');
    }
    set innodbPrintAllDeadlocks(value) {
        this._innodbPrintAllDeadlocks = value;
    }
    resetInnodbPrintAllDeadlocks() {
        this._innodbPrintAllDeadlocks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbPrintAllDeadlocksInput() {
        return this._innodbPrintAllDeadlocks;
    }
    get innodbRollbackOnTimeout() {
        return this.getBooleanAttribute('innodb_rollback_on_timeout');
    }
    set innodbRollbackOnTimeout(value) {
        this._innodbRollbackOnTimeout = value;
    }
    resetInnodbRollbackOnTimeout() {
        this._innodbRollbackOnTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get innodbRollbackOnTimeoutInput() {
        return this._innodbRollbackOnTimeout;
    }
    get interactiveTimeout() {
        return this.getNumberAttribute('interactive_timeout');
    }
    set interactiveTimeout(value) {
        this._interactiveTimeout = value;
    }
    resetInteractiveTimeout() {
        this._interactiveTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get interactiveTimeoutInput() {
        return this._interactiveTimeout;
    }
    get internalTmpMemStorageEngine() {
        return this.getStringAttribute('internal_tmp_mem_storage_engine');
    }
    set internalTmpMemStorageEngine(value) {
        this._internalTmpMemStorageEngine = value;
    }
    resetInternalTmpMemStorageEngine() {
        this._internalTmpMemStorageEngine = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get internalTmpMemStorageEngineInput() {
        return this._internalTmpMemStorageEngine;
    }
    get ipFilter() {
        return this.getListAttribute('ip_filter');
    }
    set ipFilter(value) {
        this._ipFilter = value;
    }
    resetIpFilter() {
        this._ipFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipFilterInput() {
        return this._ipFilter;
    }
    get longQueryTime() {
        return this.getNumberAttribute('long_query_time');
    }
    set longQueryTime(value) {
        this._longQueryTime = value;
    }
    resetLongQueryTime() {
        this._longQueryTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get longQueryTimeInput() {
        return this._longQueryTime;
    }
    get maxAllowedPacket() {
        return this.getNumberAttribute('max_allowed_packet');
    }
    set maxAllowedPacket(value) {
        this._maxAllowedPacket = value;
    }
    resetMaxAllowedPacket() {
        this._maxAllowedPacket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxAllowedPacketInput() {
        return this._maxAllowedPacket;
    }
    get maxHeapTableSize() {
        return this.getNumberAttribute('max_heap_table_size');
    }
    set maxHeapTableSize(value) {
        this._maxHeapTableSize = value;
    }
    resetMaxHeapTableSize() {
        this._maxHeapTableSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxHeapTableSizeInput() {
        return this._maxHeapTableSize;
    }
    get netReadTimeout() {
        return this.getNumberAttribute('net_read_timeout');
    }
    set netReadTimeout(value) {
        this._netReadTimeout = value;
    }
    resetNetReadTimeout() {
        this._netReadTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netReadTimeoutInput() {
        return this._netReadTimeout;
    }
    get netWriteTimeout() {
        return this.getNumberAttribute('net_write_timeout');
    }
    set netWriteTimeout(value) {
        this._netWriteTimeout = value;
    }
    resetNetWriteTimeout() {
        this._netWriteTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netWriteTimeoutInput() {
        return this._netWriteTimeout;
    }
    get publicAccess() {
        return this.getBooleanAttribute('public_access');
    }
    set publicAccess(value) {
        this._publicAccess = value;
    }
    resetPublicAccess() {
        this._publicAccess = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicAccessInput() {
        return this._publicAccess;
    }
    get slowQueryLog() {
        return this.getBooleanAttribute('slow_query_log');
    }
    set slowQueryLog(value) {
        this._slowQueryLog = value;
    }
    resetSlowQueryLog() {
        this._slowQueryLog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slowQueryLogInput() {
        return this._slowQueryLog;
    }
    get sortBufferSize() {
        return this.getNumberAttribute('sort_buffer_size');
    }
    set sortBufferSize(value) {
        this._sortBufferSize = value;
    }
    resetSortBufferSize() {
        this._sortBufferSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sortBufferSizeInput() {
        return this._sortBufferSize;
    }
    get sqlMode() {
        return this.getStringAttribute('sql_mode');
    }
    set sqlMode(value) {
        this._sqlMode = value;
    }
    resetSqlMode() {
        this._sqlMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlModeInput() {
        return this._sqlMode;
    }
    get sqlRequirePrimaryKey() {
        return this.getBooleanAttribute('sql_require_primary_key');
    }
    set sqlRequirePrimaryKey(value) {
        this._sqlRequirePrimaryKey = value;
    }
    resetSqlRequirePrimaryKey() {
        this._sqlRequirePrimaryKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlRequirePrimaryKeyInput() {
        return this._sqlRequirePrimaryKey;
    }
    get tmpTableSize() {
        return this.getNumberAttribute('tmp_table_size');
    }
    set tmpTableSize(value) {
        this._tmpTableSize = value;
    }
    resetTmpTableSize() {
        this._tmpTableSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tmpTableSizeInput() {
        return this._tmpTableSize;
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    resetVersion() {
        this._version = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
    get waitTimeout() {
        return this.getNumberAttribute('wait_timeout');
    }
    set waitTimeout(value) {
        this._waitTimeout = value;
    }
    resetWaitTimeout() {
        this._waitTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get waitTimeoutInput() {
        return this._waitTimeout;
    }
    get migration() {
        return this._migration;
    }
    putMigration(value) {
        this._migration.internalValue = value;
    }
    resetMigration() {
        this._migration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get migrationInput() {
        return this._migration.internalValue;
    }
}
exports.ManagedDatabaseMysqlPropertiesOutputReference = ManagedDatabaseMysqlPropertiesOutputReference;
_f = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysqlPropertiesOutputReference[_f] = { fqn: "@cdktf/provider-upcloud.ManagedDatabaseMysqlPropertiesOutputReference", version: "0.0.7" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql upcloud_managed_database_mysql}
*/
class ManagedDatabaseMysql extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_mysql upcloud_managed_database_mysql} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedDatabaseMysqlConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'upcloud_managed_database_mysql',
            terraformGeneratorMetadata: {
                providerName: 'upcloud',
                providerVersion: '2.4.2',
                providerVersionConstraint: '~> 2.4'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // ==========
        // ATTRIBUTES
        // ==========
        // components - computed: true, optional: false, required: false
        this._components = new ManagedDatabaseMysqlComponentsList(this, "components", false);
        // node_states - computed: true, optional: false, required: false
        this._nodeStates = new ManagedDatabaseMysqlNodeStatesList(this, "node_states", false);
        // properties - computed: false, optional: true, required: false
        this._properties = new ManagedDatabaseMysqlPropertiesOutputReference(this, "properties");
        this._maintenanceWindowDow = config.maintenanceWindowDow;
        this._maintenanceWindowTime = config.maintenanceWindowTime;
        this._name = config.name;
        this._plan = config.plan;
        this._powered = config.powered;
        this._title = config.title;
        this._zone = config.zone;
        this._properties.internalValue = config.properties;
    }
    get components() {
        return this._components;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get maintenanceWindowDow() {
        return this.getStringAttribute('maintenance_window_dow');
    }
    set maintenanceWindowDow(value) {
        this._maintenanceWindowDow = value;
    }
    resetMaintenanceWindowDow() {
        this._maintenanceWindowDow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceWindowDowInput() {
        return this._maintenanceWindowDow;
    }
    get maintenanceWindowTime() {
        return this.getStringAttribute('maintenance_window_time');
    }
    set maintenanceWindowTime(value) {
        this._maintenanceWindowTime = value;
    }
    resetMaintenanceWindowTime() {
        this._maintenanceWindowTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceWindowTimeInput() {
        return this._maintenanceWindowTime;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nodeStates() {
        return this._nodeStates;
    }
    get plan() {
        return this.getStringAttribute('plan');
    }
    set plan(value) {
        this._plan = value;
    }
    // Temporarily expose input value. Use with caution.
    get planInput() {
        return this._plan;
    }
    get powered() {
        return this.getBooleanAttribute('powered');
    }
    set powered(value) {
        this._powered = value;
    }
    resetPowered() {
        this._powered = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get poweredInput() {
        return this._powered;
    }
    // primary_database - computed: true, optional: false, required: false
    get primaryDatabase() {
        return this.getStringAttribute('primary_database');
    }
    // service_host - computed: true, optional: false, required: false
    get serviceHost() {
        return this.getStringAttribute('service_host');
    }
    // service_password - computed: true, optional: false, required: false
    get servicePassword() {
        return this.getStringAttribute('service_password');
    }
    // service_port - computed: true, optional: false, required: false
    get servicePort() {
        return this.getStringAttribute('service_port');
    }
    // service_uri - computed: true, optional: false, required: false
    get serviceUri() {
        return this.getStringAttribute('service_uri');
    }
    // service_username - computed: true, optional: false, required: false
    get serviceUsername() {
        return this.getStringAttribute('service_username');
    }
    // state - computed: true, optional: false, required: false
    get state() {
        return this.getStringAttribute('state');
    }
    get title() {
        return this.getStringAttribute('title');
    }
    set title(value) {
        this._title = value;
    }
    resetTitle() {
        this._title = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get titleInput() {
        return this._title;
    }
    // type - computed: true, optional: false, required: false
    get type() {
        return this.getStringAttribute('type');
    }
    get zone() {
        return this.getStringAttribute('zone');
    }
    set zone(value) {
        this._zone = value;
    }
    // Temporarily expose input value. Use with caution.
    get zoneInput() {
        return this._zone;
    }
    get properties() {
        return this._properties;
    }
    putProperties(value) {
        this._properties.internalValue = value;
    }
    resetProperties() {
        this._properties.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get propertiesInput() {
        return this._properties.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            maintenance_window_dow: cdktf.stringToTerraform(this._maintenanceWindowDow),
            maintenance_window_time: cdktf.stringToTerraform(this._maintenanceWindowTime),
            name: cdktf.stringToTerraform(this._name),
            plan: cdktf.stringToTerraform(this._plan),
            powered: cdktf.booleanToTerraform(this._powered),
            title: cdktf.stringToTerraform(this._title),
            zone: cdktf.stringToTerraform(this._zone),
            properties: managedDatabaseMysqlPropertiesToTerraform(this._properties.internalValue),
        };
    }
}
exports.ManagedDatabaseMysql = ManagedDatabaseMysql;
_g = JSII_RTTI_SYMBOL_1;
ManagedDatabaseMysql[_g] = { fqn: "@cdktf/provider-upcloud.ManagedDatabaseMysql", version: "0.0.7" };
// =================
// STATIC PROPERTIES
// =================
ManagedDatabaseMysql.tfResourceType = "upcloud_managed_database_mysql";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFuYWdlZC1kYXRhYmFzZS1teXNxbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9tYW5hZ2VkLWRhdGFiYXNlLW15c3FsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBSUEsK0JBQStCO0FBeUQvQixTQUFnQix5Q0FBeUMsQ0FBQyxNQUF1QztJQUMvRixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTyxFQUNOLENBQUE7QUFDSCxDQUFDO0FBUEQsOEZBT0M7QUFFRCxNQUFhLDZDQUE4QyxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR3BGOzs7OztNQUtFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCLEVBQUUsa0JBQTBCLEVBQUUsc0JBQStCO1FBQ3ZKLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxzQkFBc0IsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBVG5GLGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBVTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBaUQ7UUFDeEUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1NBQzVCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztTQUN0RDtJQUNILENBQUM7SUFFRCwrREFBK0Q7SUFDL0QsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRCwwREFBMEQ7SUFDMUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVELDBEQUEwRDtJQUMxRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQsMkRBQTJEO0lBQzNELElBQVcsS0FBSztRQUNkLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRCwyREFBMkQ7SUFDM0QsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDMUMsQ0FBQzs7QUFuREgsc0dBb0RDOzs7QUFFRCxNQUFhLGtDQUFtQyxTQUFRLEtBQUssQ0FBQyxXQUFXO0lBRXZFOzs7O01BSUU7SUFDRixZQUFzQixpQkFBNkMsRUFBWSxrQkFBMEIsRUFBWSxRQUFpQjtRQUNwSSxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsUUFBUSxDQUFDLENBQUE7UUFEbEMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUE0QjtRQUFZLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUFZLGFBQVEsR0FBUixRQUFRLENBQVM7SUFFdEksQ0FBQztJQUVEOztNQUVFO0lBQ0ssR0FBRyxDQUFDLEtBQWE7UUFDdEIsT0FBTyxJQUFJLDZDQUE2QyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUNsSSxDQUFDOztBQWhCSCxnRkFpQkM7OztBQUlELFNBQWdCLHlDQUF5QyxDQUFDLE1BQXVDO0lBQy9GLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPLEVBQ04sQ0FBQTtBQUNILENBQUM7QUFQRCw4RkFPQztBQUVELE1BQWEsNkNBQThDLFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHcEY7Ozs7O01BS0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEIsRUFBRSxrQkFBMEIsRUFBRSxzQkFBK0I7UUFDdkosS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLHNCQUFzQixFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFUbkYsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFVOUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUFpRDtRQUN4RSxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7U0FDNUI7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1NBQ3REO0lBQ0gsQ0FBQztJQUVELDBEQUEwRDtJQUMxRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQsMERBQTBEO0lBQzFELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRCwyREFBMkQ7SUFDM0QsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDMUMsQ0FBQzs7QUF6Q0gsc0dBMENDOzs7QUFFRCxNQUFhLGtDQUFtQyxTQUFRLEtBQUssQ0FBQyxXQUFXO0lBRXZFOzs7O01BSUU7SUFDRixZQUFzQixpQkFBNkMsRUFBWSxrQkFBMEIsRUFBWSxRQUFpQjtRQUNwSSxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsUUFBUSxDQUFDLENBQUE7UUFEbEMsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUE0QjtRQUFZLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUFZLGFBQVEsR0FBUixRQUFRLENBQVM7SUFFdEksQ0FBQztJQUVEOztNQUVFO0lBQ0ssR0FBRyxDQUFDLEtBQWE7UUFDdEIsT0FBTyxJQUFJLDZDQUE2QyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUNsSSxDQUFDOztBQWhCSCxnRkFpQkM7OztBQThDRCxTQUFnQixrREFBa0QsQ0FBQyxNQUF5RztJQUMxSyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztRQUMvQyxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxJQUFJLENBQUM7UUFDM0MsVUFBVSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsU0FBUyxDQUFDO1FBQ3RELFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFFBQVEsQ0FBQztRQUNuRCxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxJQUFJLENBQUM7UUFDM0MsR0FBRyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsR0FBRyxDQUFDO1FBQzFDLFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFFBQVEsQ0FBQztLQUNwRCxDQUFBO0FBQ0gsQ0FBQztBQWRELGdIQWNDO0FBRUQsTUFBYSxzREFBdUQsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUc3Rjs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVBqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVE5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsT0FBTyxLQUFLLFNBQVMsRUFBRTtZQUM5QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1NBQzNDO1FBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUM1QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1NBQ3ZDO1FBQ0QsSUFBSSxJQUFJLENBQUMsVUFBVSxLQUFLLFNBQVMsRUFBRTtZQUNqQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDO1NBQ2pEO1FBQ0QsSUFBSSxJQUFJLENBQUMsU0FBUyxLQUFLLFNBQVMsRUFBRTtZQUNoQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDO1NBQy9DO1FBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUM1QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1NBQ3ZDO1FBQ0QsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLFNBQVMsRUFBRTtZQUMzQixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLEdBQUcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDO1NBQ3JDO1FBQ0QsSUFBSSxJQUFJLENBQUMsU0FBUyxLQUFLLFNBQVMsRUFBRTtZQUNoQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDO1NBQy9DO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQTBEO1FBQ2pGLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztZQUN6QixJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUN2QixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztZQUM1QixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztZQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUN2QixJQUFJLENBQUMsSUFBSSxHQUFHLFNBQVMsQ0FBQztZQUN0QixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztTQUM1QjthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQzVCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztZQUN4QixJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7WUFDbEMsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1lBQ2hDLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztZQUN4QixJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxHQUFHLENBQUM7WUFDdEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1NBQ2pDO0lBQ0gsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBQ00sY0FBYztRQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztJQUM5QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDTSxTQUFTO1FBQ2QsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7SUFDekIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLEdBQUc7UUFDWixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxHQUFHLENBQUMsS0FBa0M7UUFDL0MsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUNNLFFBQVE7UUFDYixJQUFJLENBQUMsSUFBSSxHQUFHLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDbkIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQzs7QUFsTEgsd0hBbUxDOzs7QUFnTkQsU0FBZ0IseUNBQXlDLENBQUMsTUFBdUY7SUFDL0ksSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxjQUFjLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxhQUFhLENBQUM7UUFDOUQsY0FBYyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsYUFBYSxDQUFDO1FBQzlELG1DQUFtQyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsK0JBQStCLENBQUM7UUFDdEcsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsVUFBVSxDQUFDO1FBQ3hELGFBQWEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFlBQVksQ0FBQztRQUM1RCx1QkFBdUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLHFCQUFxQixDQUFDO1FBQy9FLGVBQWUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLGNBQWMsQ0FBQztRQUNoRSxpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLGVBQWUsQ0FBQztRQUNuRSxvQkFBb0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLGlCQUFpQixDQUFDO1FBQ3hFLCtCQUErQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsNEJBQTRCLENBQUM7UUFDOUYsd0JBQXdCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxvQkFBb0IsQ0FBQztRQUMvRSwrQkFBK0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLDJCQUEyQixDQUFDO1FBQzdGLHdCQUF3QixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMscUJBQXFCLENBQUM7UUFDaEYsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxtQkFBbUIsQ0FBQztRQUM1RSxnQ0FBZ0MsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLDJCQUEyQixDQUFDO1FBQzlGLDBCQUEwQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsdUJBQXVCLENBQUM7UUFDckYsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyx1QkFBdUIsQ0FBQztRQUNyRixtQkFBbUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLGtCQUFrQixDQUFDO1FBQ3hFLCtCQUErQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsMkJBQTJCLENBQUM7UUFDN0YsU0FBUyxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLENBQUMsTUFBTyxDQUFDLFFBQVEsQ0FBQztRQUN0RSxlQUFlLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxhQUFhLENBQUM7UUFDL0Qsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNyRSxtQkFBbUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLGdCQUFnQixDQUFDO1FBQ3RFLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsY0FBYyxDQUFDO1FBQ2pFLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsZUFBZSxDQUFDO1FBQ25FLGFBQWEsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLFlBQVksQ0FBQztRQUM3RCxjQUFjLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxZQUFZLENBQUM7UUFDOUQsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxjQUFjLENBQUM7UUFDakUsUUFBUSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsT0FBTyxDQUFDO1FBQ2xELHVCQUF1QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsb0JBQW9CLENBQUM7UUFDL0UsY0FBYyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsWUFBWSxDQUFDO1FBQzdELE9BQU8sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE9BQU8sQ0FBQztRQUNqRCxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxXQUFXLENBQUM7UUFDMUQsU0FBUyxFQUFFLGtEQUFrRCxDQUFDLE1BQU8sQ0FBQyxTQUFTLENBQUM7S0FDakYsQ0FBQTtBQUNILENBQUM7QUF6Q0QsOEZBeUNDO0FBRUQsTUFBYSw2Q0FBOEMsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUdwRjs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVBqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztRQXF2QjlCLCtEQUErRDtRQUN2RCxlQUFVLEdBQUcsSUFBSSxzREFBc0QsQ0FBQyxJQUFJLEVBQUUsV0FBVyxDQUFDLENBQUM7SUE5dUJuRyxDQUFDO0lBRUQsSUFBVyxhQUFhOztRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLGNBQWMsS0FBSyxTQUFTLEVBQUU7WUFDckMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztTQUN6RDtRQUNELElBQUksSUFBSSxDQUFDLGNBQWMsS0FBSyxTQUFTLEVBQUU7WUFDckMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztTQUN6RDtRQUNELElBQUksSUFBSSxDQUFDLGdDQUFnQyxLQUFLLFNBQVMsRUFBRTtZQUN2RCxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLCtCQUErQixHQUFHLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQztTQUM3RjtRQUNELElBQUksSUFBSSxDQUFDLFdBQVcsS0FBSyxTQUFTLEVBQUU7WUFDbEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQztTQUNuRDtRQUNELElBQUksSUFBSSxDQUFDLGFBQWEsS0FBSyxTQUFTLEVBQUU7WUFDcEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztTQUN2RDtRQUNELElBQUksSUFBSSxDQUFDLHNCQUFzQixLQUFLLFNBQVMsRUFBRTtZQUM3QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLHFCQUFxQixHQUFHLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztTQUN6RTtRQUNELElBQUksSUFBSSxDQUFDLGVBQWUsS0FBSyxTQUFTLEVBQUU7WUFDdEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQztTQUMzRDtRQUNELElBQUksSUFBSSxDQUFDLGdCQUFnQixLQUFLLFNBQVMsRUFBRTtZQUN2QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7U0FDN0Q7UUFDRCxJQUFJLElBQUksQ0FBQyxrQkFBa0IsS0FBSyxTQUFTLEVBQUU7WUFDekMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7U0FDakU7UUFDRCxJQUFJLElBQUksQ0FBQyw2QkFBNkIsS0FBSyxTQUFTLEVBQUU7WUFDcEQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyw0QkFBNEIsR0FBRyxJQUFJLENBQUMsNkJBQTZCLENBQUM7U0FDdkY7UUFDRCxJQUFJLElBQUksQ0FBQyxxQkFBcUIsS0FBSyxTQUFTLEVBQUU7WUFDNUMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUM7U0FDdkU7UUFDRCxJQUFJLElBQUksQ0FBQyw0QkFBNEIsS0FBSyxTQUFTLEVBQUU7WUFDbkQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQywyQkFBMkIsR0FBRyxJQUFJLENBQUMsNEJBQTRCLENBQUM7U0FDckY7UUFDRCxJQUFJLElBQUksQ0FBQyxzQkFBc0IsS0FBSyxTQUFTLEVBQUU7WUFDN0MsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLENBQUMsc0JBQXNCLENBQUM7U0FDekU7UUFDRCxJQUFJLElBQUksQ0FBQyxvQkFBb0IsS0FBSyxTQUFTLEVBQUU7WUFDM0MsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUMsb0JBQW9CLENBQUM7U0FDckU7UUFDRCxJQUFJLElBQUksQ0FBQyw0QkFBNEIsS0FBSyxTQUFTLEVBQUU7WUFDbkQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQywyQkFBMkIsR0FBRyxJQUFJLENBQUMsNEJBQTRCLENBQUM7U0FDckY7UUFDRCxJQUFJLElBQUksQ0FBQyx3QkFBd0IsS0FBSyxTQUFTLEVBQUU7WUFDL0MsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLENBQUMsd0JBQXdCLENBQUM7U0FDN0U7UUFDRCxJQUFJLElBQUksQ0FBQyx3QkFBd0IsS0FBSyxTQUFTLEVBQUU7WUFDL0MsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLENBQUMsd0JBQXdCLENBQUM7U0FDN0U7UUFDRCxJQUFJLElBQUksQ0FBQyxtQkFBbUIsS0FBSyxTQUFTLEVBQUU7WUFDMUMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUM7U0FDbkU7UUFDRCxJQUFJLElBQUksQ0FBQyw0QkFBNEIsS0FBSyxTQUFTLEVBQUU7WUFDbkQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQywyQkFBMkIsR0FBRyxJQUFJLENBQUMsNEJBQTRCLENBQUM7U0FDckY7UUFDRCxJQUFJLElBQUksQ0FBQyxTQUFTLEtBQUssU0FBUyxFQUFFO1lBQ2hDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUM7U0FDL0M7UUFDRCxJQUFJLElBQUksQ0FBQyxjQUFjLEtBQUssU0FBUyxFQUFFO1lBQ3JDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUM7U0FDekQ7UUFDRCxJQUFJLElBQUksQ0FBQyxpQkFBaUIsS0FBSyxTQUFTLEVBQUU7WUFDeEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUM7U0FDL0Q7UUFDRCxJQUFJLElBQUksQ0FBQyxpQkFBaUIsS0FBSyxTQUFTLEVBQUU7WUFDeEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUM7U0FDL0Q7UUFDRCxJQUFJLElBQUksQ0FBQyxlQUFlLEtBQUssU0FBUyxFQUFFO1lBQ3RDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDM0Q7UUFDRCxJQUFJLElBQUksQ0FBQyxnQkFBZ0IsS0FBSyxTQUFTLEVBQUU7WUFDdkMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1NBQzdEO1FBQ0QsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLFNBQVMsRUFBRTtZQUNwQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1NBQ3ZEO1FBQ0QsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLFNBQVMsRUFBRTtZQUNwQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1NBQ3ZEO1FBQ0QsSUFBSSxJQUFJLENBQUMsZUFBZSxLQUFLLFNBQVMsRUFBRTtZQUN0QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDO1NBQzNEO1FBQ0QsSUFBSSxJQUFJLENBQUMsUUFBUSxLQUFLLFNBQVMsRUFBRTtZQUMvQixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDO1NBQzdDO1FBQ0QsSUFBSSxJQUFJLENBQUMscUJBQXFCLEtBQUssU0FBUyxFQUFFO1lBQzVDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsb0JBQW9CLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDO1NBQ3ZFO1FBQ0QsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLFNBQVMsRUFBRTtZQUNwQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1NBQ3ZEO1FBQ0QsSUFBSSxJQUFJLENBQUMsUUFBUSxLQUFLLFNBQVMsRUFBRTtZQUMvQixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDO1NBQzdDO1FBQ0QsSUFBSSxJQUFJLENBQUMsWUFBWSxLQUFLLFNBQVMsRUFBRTtZQUNuQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDO1NBQ3JEO1FBQ0QsSUFBSSxPQUFBLElBQUksQ0FBQyxVQUFVLDBDQUFFLGFBQWEsTUFBSyxTQUFTLEVBQUU7WUFDaEQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxTQUFTLFNBQUcsSUFBSSxDQUFDLFVBQVUsMENBQUUsYUFBYSxDQUFDO1NBQ2hFO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQWlEO1FBQ3hFLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztZQUNoQyxJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztZQUNoQyxJQUFJLENBQUMsZ0NBQWdDLEdBQUcsU0FBUyxDQUFDO1lBQ2xELElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO1lBQzdCLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO1lBQy9CLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxTQUFTLENBQUM7WUFDeEMsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7WUFDakMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztZQUNsQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO1lBQ3BDLElBQUksQ0FBQyw2QkFBNkIsR0FBRyxTQUFTLENBQUM7WUFDL0MsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFNBQVMsQ0FBQztZQUN2QyxJQUFJLENBQUMsNEJBQTRCLEdBQUcsU0FBUyxDQUFDO1lBQzlDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxTQUFTLENBQUM7WUFDeEMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLFNBQVMsQ0FBQztZQUN0QyxJQUFJLENBQUMsNEJBQTRCLEdBQUcsU0FBUyxDQUFDO1lBQzlDLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxTQUFTLENBQUM7WUFDMUMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLFNBQVMsQ0FBQztZQUMxQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsU0FBUyxDQUFDO1lBQ3JDLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxTQUFTLENBQUM7WUFDOUMsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7WUFDM0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7WUFDaEMsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztZQUNuQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsU0FBUyxDQUFDO1lBQ25DLElBQUksQ0FBQyxlQUFlLEdBQUcsU0FBUyxDQUFDO1lBQ2pDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxTQUFTLENBQUM7WUFDbEMsSUFBSSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7WUFDL0IsSUFBSSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7WUFDL0IsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7WUFDakMsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7WUFDMUIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFNBQVMsQ0FBQztZQUN2QyxJQUFJLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztZQUMvQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztZQUMxQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztZQUM5QixJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7U0FDM0M7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztZQUMxQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7WUFDMUMsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLEtBQUssQ0FBQywrQkFBK0IsQ0FBQztZQUM5RSxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7WUFDcEMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1lBQ3hDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMscUJBQXFCLENBQUM7WUFDMUQsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1lBQzVDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1lBQzlDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7WUFDbEQsSUFBSSxDQUFDLDZCQUE2QixHQUFHLEtBQUssQ0FBQyw0QkFBNEIsQ0FBQztZQUN4RSxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1lBQ3hELElBQUksQ0FBQyw0QkFBNEIsR0FBRyxLQUFLLENBQUMsMkJBQTJCLENBQUM7WUFDdEUsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQztZQUMxRCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1lBQ3RELElBQUksQ0FBQyw0QkFBNEIsR0FBRyxLQUFLLENBQUMsMkJBQTJCLENBQUM7WUFDdEUsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQztZQUM5RCxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDLHVCQUF1QixDQUFDO1lBQzlELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUM7WUFDcEQsSUFBSSxDQUFDLDRCQUE0QixHQUFHLEtBQUssQ0FBQywyQkFBMkIsQ0FBQztZQUN0RSxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7WUFDaEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO1lBQzFDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7WUFDaEQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztZQUNoRCxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7WUFDNUMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7WUFDOUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1lBQ3hDLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztZQUN4QyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7WUFDNUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1lBQzlCLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7WUFDeEQsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1lBQ3hDLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztZQUM5QixJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7WUFDdEMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztTQUNqRDtJQUNILENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBYTtRQUNwQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBQ00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBYTtRQUNwQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBQ00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLCtCQUErQjtRQUN4QyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDO0lBQ3pFLENBQUM7SUFDRCxJQUFXLCtCQUErQixDQUFDLEtBQWtDO1FBQzNFLElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxLQUFLLENBQUM7SUFDaEQsQ0FBQztJQUNNLG9DQUFvQztRQUN6QyxJQUFJLENBQUMsZ0NBQWdDLEdBQUcsU0FBUyxDQUFDO0lBQ3BELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxvQ0FBb0M7UUFDN0MsT0FBTyxJQUFJLENBQUMsZ0NBQWdDLENBQUM7SUFDL0MsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBYTtRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ00sZUFBZTtRQUNwQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztJQUMvQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBQ0QsSUFBVyxZQUFZLENBQUMsS0FBYTtRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ00saUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVELENBQUM7SUFDRCxJQUFXLHFCQUFxQixDQUFDLEtBQWE7UUFDNUMsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQztJQUN0QyxDQUFDO0lBQ00sMEJBQTBCO1FBQy9CLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxTQUFTLENBQUM7SUFDMUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDBCQUEwQjtRQUNuQyxPQUFPLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztJQUNyQyxDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWE7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWE7UUFDdEMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztJQUNoQyxDQUFDO0lBQ00sb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxTQUFTLENBQUM7SUFDcEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUMvQixDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUFhO1FBQ3hDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUNNLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO0lBQ3RDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUlELElBQVcsNEJBQTRCO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGlDQUFpQyxDQUFDLENBQUM7SUFDcEUsQ0FBQztJQUNELElBQVcsNEJBQTRCLENBQUMsS0FBYTtRQUNuRCxJQUFJLENBQUMsNkJBQTZCLEdBQUcsS0FBSyxDQUFDO0lBQzdDLENBQUM7SUFDTSxpQ0FBaUM7UUFDdEMsSUFBSSxDQUFDLDZCQUE2QixHQUFHLFNBQVMsQ0FBQztJQUNqRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsaUNBQWlDO1FBQzFDLE9BQU8sSUFBSSxDQUFDLDZCQUE2QixDQUFDO0lBQzVDLENBQUM7SUFJRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdELENBQUM7SUFDRCxJQUFXLG9CQUFvQixDQUFDLEtBQWE7UUFDM0MsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQztJQUNyQyxDQUFDO0lBQ00seUJBQXlCO1FBQzlCLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxTQUFTLENBQUM7SUFDekMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztJQUNwQyxDQUFDO0lBSUQsSUFBVywyQkFBMkI7UUFDcEMsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsaUNBQWlDLENBQUMsQ0FBQztJQUNwRSxDQUFDO0lBQ0QsSUFBVywyQkFBMkIsQ0FBQyxLQUFhO1FBQ2xELElBQUksQ0FBQyw0QkFBNEIsR0FBRyxLQUFLLENBQUM7SUFDNUMsQ0FBQztJQUNNLGdDQUFnQztRQUNyQyxJQUFJLENBQUMsNEJBQTRCLEdBQUcsU0FBUyxDQUFDO0lBQ2hELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQ0FBZ0M7UUFDekMsT0FBTyxJQUFJLENBQUMsNEJBQTRCLENBQUM7SUFDM0MsQ0FBQztJQUlELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0QsQ0FBQztJQUNELElBQVcscUJBQXFCLENBQUMsS0FBYTtRQUM1QyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDO0lBQ3RDLENBQUM7SUFDTSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLFNBQVMsQ0FBQztJQUMxQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsMEJBQTBCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLHNCQUFzQixDQUFDO0lBQ3JDLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNELENBQUM7SUFDRCxJQUFXLG1CQUFtQixDQUFDLEtBQWE7UUFDMUMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBQ00sd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxTQUFTLENBQUM7SUFDeEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDO0lBSUQsSUFBVywyQkFBMkI7UUFDcEMsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRSxDQUFDO0lBQ0QsSUFBVywyQkFBMkIsQ0FBQyxLQUFhO1FBQ2xELElBQUksQ0FBQyw0QkFBNEIsR0FBRyxLQUFLLENBQUM7SUFDNUMsQ0FBQztJQUNNLGdDQUFnQztRQUNyQyxJQUFJLENBQUMsNEJBQTRCLEdBQUcsU0FBUyxDQUFDO0lBQ2hELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQ0FBZ0M7UUFDekMsT0FBTyxJQUFJLENBQUMsNEJBQTRCLENBQUM7SUFDM0MsQ0FBQztJQUlELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDaEUsQ0FBQztJQUNELElBQVcsdUJBQXVCLENBQUMsS0FBa0M7UUFDbkUsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQztJQUN4QyxDQUFDO0lBQ00sNEJBQTRCO1FBQ2pDLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxTQUFTLENBQUM7SUFDNUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyx3QkFBd0IsQ0FBQztJQUN2QyxDQUFDO0lBSUQsSUFBVyx1QkFBdUI7UUFDaEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsNEJBQTRCLENBQUMsQ0FBQztJQUNoRSxDQUFDO0lBQ0QsSUFBVyx1QkFBdUIsQ0FBQyxLQUFrQztRQUNuRSxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDO0lBQ3hDLENBQUM7SUFDTSw0QkFBNEI7UUFDakMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLFNBQVMsQ0FBQztJQUM1QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsNEJBQTRCO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLHdCQUF3QixDQUFDO0lBQ3ZDLENBQUM7SUFJRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFDRCxJQUFXLGtCQUFrQixDQUFDLEtBQWE7UUFDekMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQztJQUNuQyxDQUFDO0lBQ00sdUJBQXVCO1FBQzVCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxTQUFTLENBQUM7SUFDdkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHVCQUF1QjtRQUNoQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVywyQkFBMkI7UUFDcEMsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsaUNBQWlDLENBQUMsQ0FBQztJQUNwRSxDQUFDO0lBQ0QsSUFBVywyQkFBMkIsQ0FBQyxLQUFhO1FBQ2xELElBQUksQ0FBQyw0QkFBNEIsR0FBRyxLQUFLLENBQUM7SUFDNUMsQ0FBQztJQUNNLGdDQUFnQztRQUNyQyxJQUFJLENBQUMsNEJBQTRCLEdBQUcsU0FBUyxDQUFDO0lBQ2hELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQ0FBZ0M7UUFDekMsT0FBTyxJQUFJLENBQUMsNEJBQTRCLENBQUM7SUFDM0MsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBZTtRQUNqQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFhO1FBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBYTtRQUN2QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO0lBQ2pDLENBQUM7SUFDTSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztJQUNyQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFJRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFDRCxJQUFXLGdCQUFnQixDQUFDLEtBQWE7UUFDdkMsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztJQUNqQyxDQUFDO0lBQ00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxTQUFTLENBQUM7SUFDckMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWE7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWE7UUFDdEMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztJQUNoQyxDQUFDO0lBQ00sb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxTQUFTLENBQUM7SUFDcEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUMvQixDQUFDO0lBSUQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUFrQztRQUN4RCxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ00saUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBVyxZQUFZLENBQUMsS0FBa0M7UUFDeEQsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDN0IsQ0FBQztJQUNNLGlCQUFpQjtRQUN0QixJQUFJLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUNqQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQztJQUM1QixDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWE7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFDRCxJQUFXLE9BQU8sQ0FBQyxLQUFhO1FBQzlCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDO0lBQ3hCLENBQUM7SUFDTSxZQUFZO1FBQ2pCLElBQUksQ0FBQyxRQUFRLEdBQUcsU0FBUyxDQUFDO0lBQzVCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBSUQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBQ0QsSUFBVyxvQkFBb0IsQ0FBQyxLQUFrQztRQUNoRSxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDO0lBQ3JDLENBQUM7SUFDTSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFNBQVMsQ0FBQztJQUN6QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBQ0QsSUFBVyxZQUFZLENBQUMsS0FBYTtRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ00saUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUNELElBQVcsT0FBTyxDQUFDLEtBQWE7UUFDOUIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN6QixDQUFDO0lBQ00sWUFBWSxDQUFDLEtBQThDO1FBQ2hFLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN4QyxDQUFDO0lBQ00sY0FBYztRQUNuQixJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDNUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztJQUN2QyxDQUFDOztBQXB3Qkgsc0dBcXdCQzs7O0FBRUQ7O0VBRUU7QUFDRixNQUFhLG9CQUFxQixTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPL0QsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQ7Ozs7OztNQU1FO0lBQ0YsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBa0M7UUFDakYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSxnQ0FBZ0M7WUFDdkQsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxTQUFTO2dCQUN2QixlQUFlLEVBQUUsT0FBTztnQkFDeEIseUJBQXlCLEVBQUUsUUFBUTthQUNwQztZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztTQUM1QixDQUFDLENBQUM7UUFXTCxhQUFhO1FBQ2IsYUFBYTtRQUNiLGFBQWE7UUFFYixnRUFBZ0U7UUFDeEQsZ0JBQVcsR0FBRyxJQUFJLGtDQUFrQyxDQUFDLElBQUksRUFBRSxZQUFZLEVBQUUsS0FBSyxDQUFDLENBQUM7UUF1RHhGLGlFQUFpRTtRQUN6RCxnQkFBVyxHQUFHLElBQUksa0NBQWtDLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRSxLQUFLLENBQUMsQ0FBQztRQXVHekYsZ0VBQWdFO1FBQ3hELGdCQUFXLEdBQUcsSUFBSSw2Q0FBNkMsQ0FBQyxJQUFJLEVBQUUsWUFBWSxDQUFDLENBQUM7UUEvSzFGLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7UUFDekQsSUFBSSxDQUFDLHNCQUFzQixHQUFHLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQztRQUMzRCxJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7SUFDckQsQ0FBQztJQVFELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUVELHVEQUF1RDtJQUN2RCxJQUFXLEVBQUU7UUFDWCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBSUQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBQ0QsSUFBVyxvQkFBb0IsQ0FBQyxLQUFhO1FBQzNDLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUM7SUFDckMsQ0FBQztJQUNNLHlCQUF5QjtRQUM5QixJQUFJLENBQUMscUJBQXFCLEdBQUcsU0FBUyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDcEMsQ0FBQztJQUlELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUQsQ0FBQztJQUNELElBQVcscUJBQXFCLENBQUMsS0FBYTtRQUM1QyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDO0lBQ3RDLENBQUM7SUFDTSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLFNBQVMsQ0FBQztJQUMxQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsMEJBQTBCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLHNCQUFzQixDQUFDO0lBQ3JDLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFDRCxJQUFXLE9BQU8sQ0FBQyxLQUFrQztRQUNuRCxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUVELHNFQUFzRTtJQUN0RSxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBRUQsa0VBQWtFO0lBQ2xFLElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBRUQsc0VBQXNFO0lBQ3RFLElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFFRCxrRUFBa0U7SUFDbEUsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRCxpRUFBaUU7SUFDakUsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFFRCxzRUFBc0U7SUFDdEUsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVELDJEQUEyRDtJQUMzRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBSUQsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUNELElBQVcsS0FBSyxDQUFDLEtBQWE7UUFDNUIsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7SUFDdEIsQ0FBQztJQUNNLFVBQVU7UUFDZixJQUFJLENBQUMsTUFBTSxHQUFHLFNBQVMsQ0FBQztJQUMxQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUVELDBEQUEwRDtJQUMxRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFDTSxhQUFhLENBQUMsS0FBcUM7UUFDeEQsSUFBSSxDQUFDLFdBQVcsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3pDLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUM3QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxDQUFDO0lBQ3hDLENBQUM7SUFFRCxZQUFZO0lBQ1osWUFBWTtJQUNaLFlBQVk7SUFFRixvQkFBb0I7UUFDNUIsT0FBTztZQUNMLHNCQUFzQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUM7WUFDM0UsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztZQUM3RSxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDekMsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3pDLE9BQU8sRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUNoRCxLQUFLLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxNQUFNLENBQUM7WUFDM0MsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3pDLFVBQVUsRUFBRSx5Q0FBeUMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLGFBQWEsQ0FBQztTQUN0RixDQUFDO0lBQ0osQ0FBQzs7QUE1T0gsb0RBNk9DOzs7QUEzT0Msb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDRyxtQ0FBYyxHQUFHLGdDQUFnQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgTWFuYWdlZERhdGFiYXNlTXlzcWxDb25maWcgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgLyoqXG4gICogTWFpbnRlbmFuY2Ugd2luZG93IGRheSBvZiB3ZWVrLiBMb3dlciBjYXNlIHdlZWtkYXkgbmFtZSAobW9uZGF5LCB0dWVzZGF5LCAuLi4pXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjbWFpbnRlbmFuY2Vfd2luZG93X2RvdyBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNtYWludGVuYW5jZV93aW5kb3dfZG93fVxuICAqL1xuICByZWFkb25seSBtYWludGVuYW5jZVdpbmRvd0Rvdz86IHN0cmluZztcbiAgLyoqXG4gICogTWFpbnRlbmFuY2Ugd2luZG93IFVUQyB0aW1lIGluIGhoOm1tOnNzIGZvcm1hdFxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI21haW50ZW5hbmNlX3dpbmRvd190aW1lIE1hbmFnZWREYXRhYmFzZU15c3FsI21haW50ZW5hbmNlX3dpbmRvd190aW1lfVxuICAqL1xuICByZWFkb25seSBtYWludGVuYW5jZVdpbmRvd1RpbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIE5hbWUgb2YgdGhlIHNlcnZpY2UuIFRoZSBuYW1lIGlzIHVzZWQgYXMgYSBwcmVmaXggZm9yIHRoZSBsb2dpY2FsIGhvc3RuYW1lLiBNdXN0IGJlIHVuaXF1ZSB3aXRoaW4gYW4gYWNjb3VudFxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI25hbWUgTWFuYWdlZERhdGFiYXNlTXlzcWwjbmFtZX1cbiAgKi9cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAvKipcbiAgKiBTZXJ2aWNlIHBsYW4gdG8gdXNlLiBUaGlzIGRldGVybWluZXMgaG93IG11Y2ggcmVzb3VyY2VzIHRoZSBpbnN0YW5jZSB3aWxsIGhhdmVcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNwbGFuIE1hbmFnZWREYXRhYmFzZU15c3FsI3BsYW59XG4gICovXG4gIHJlYWRvbmx5IHBsYW46IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGFkbWluaXN0cmF0aXZlIHBvd2VyIHN0YXRlIG9mIHRoZSBzZXJ2aWNlXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjcG93ZXJlZCBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNwb3dlcmVkfVxuICAqL1xuICByZWFkb25seSBwb3dlcmVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBUaXRsZSBvZiBhIG1hbmFnZWQgZGF0YWJhc2UgaW5zdGFuY2VcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCN0aXRsZSBNYW5hZ2VkRGF0YWJhc2VNeXNxbCN0aXRsZX1cbiAgKi9cbiAgcmVhZG9ubHkgdGl0bGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFpvbmUgd2hlcmUgdGhlIGluc3RhbmNlIHJlc2lkZXNcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCN6b25lIE1hbmFnZWREYXRhYmFzZU15c3FsI3pvbmV9XG4gICovXG4gIHJlYWRvbmx5IHpvbmU6IHN0cmluZztcbiAgLyoqXG4gICogcHJvcGVydGllcyBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI3Byb3BlcnRpZXMgTWFuYWdlZERhdGFiYXNlTXlzcWwjcHJvcGVydGllc31cbiAgKi9cbiAgcmVhZG9ubHkgcHJvcGVydGllcz86IE1hbmFnZWREYXRhYmFzZU15c3FsUHJvcGVydGllcztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgTWFuYWdlZERhdGFiYXNlTXlzcWxDb21wb25lbnRzIHtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG1hbmFnZWREYXRhYmFzZU15c3FsQ29tcG9uZW50c1RvVGVycmFmb3JtKHN0cnVjdD86IE1hbmFnZWREYXRhYmFzZU15c3FsQ29tcG9uZW50cyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgTWFuYWdlZERhdGFiYXNlTXlzcWxDb21wb25lbnRzT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqIEBwYXJhbSBjb21wbGV4T2JqZWN0SW5kZXggdGhlIGluZGV4IG9mIHRoaXMgaXRlbSBpbiB0aGUgbGlzdFxuICAqIEBwYXJhbSBjb21wbGV4T2JqZWN0SXNGcm9tU2V0IHdoZXRoZXIgdGhlIGxpc3QgaXMgd3JhcHBpbmcgYSBzZXQgKHdpbGwgYWRkIHRvbGlzdCgpIHRvIGJlIGFibGUgdG8gYWNjZXNzIGFuIGl0ZW0gdmlhIGFuIGluZGV4KVxuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZywgY29tcGxleE9iamVjdEluZGV4OiBudW1iZXIsIGNvbXBsZXhPYmplY3RJc0Zyb21TZXQ6IGJvb2xlYW4pIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBjb21wbGV4T2JqZWN0SXNGcm9tU2V0LCBjb21wbGV4T2JqZWN0SW5kZXgpO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IE1hbmFnZWREYXRhYmFzZU15c3FsQ29tcG9uZW50cyB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogTWFuYWdlZERhdGFiYXNlTXlzcWxDb21wb25lbnRzIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgfVxuICB9XG5cbiAgLy8gY29tcG9uZW50IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgY29tcG9uZW50KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY29tcG9uZW50Jyk7XG4gIH1cblxuICAvLyBob3N0IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgaG9zdCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2hvc3QnKTtcbiAgfVxuXG4gIC8vIHBvcnQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBwb3J0KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgncG9ydCcpO1xuICB9XG5cbiAgLy8gcm91dGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCByb3V0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JvdXRlJyk7XG4gIH1cblxuICAvLyB1c2FnZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHVzYWdlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndXNhZ2UnKTtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgTWFuYWdlZERhdGFiYXNlTXlzcWxDb21wb25lbnRzTGlzdCBleHRlbmRzIGNka3RmLkNvbXBsZXhMaXN0IHtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKiBAcGFyYW0gd3JhcHNTZXQgd2hldGhlciB0aGUgbGlzdCBpcyB3cmFwcGluZyBhIHNldCAod2lsbCBhZGQgdG9saXN0KCkgdG8gYmUgYWJsZSB0byBhY2Nlc3MgYW4gaXRlbSB2aWEgYW4gaW5kZXgpXG4gICovXG4gIGNvbnN0cnVjdG9yKHByb3RlY3RlZCB0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHByb3RlY3RlZCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZywgcHJvdGVjdGVkIHdyYXBzU2V0OiBib29sZWFuKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgd3JhcHNTZXQpXG4gIH1cblxuICAvKipcbiAgKiBAcGFyYW0gaW5kZXggdGhlIGluZGV4IG9mIHRoZSBpdGVtIHRvIHJldHVyblxuICAqL1xuICBwdWJsaWMgZ2V0KGluZGV4OiBudW1iZXIpOiBNYW5hZ2VkRGF0YWJhc2VNeXNxbENvbXBvbmVudHNPdXRwdXRSZWZlcmVuY2Uge1xuICAgIHJldHVybiBuZXcgTWFuYWdlZERhdGFiYXNlTXlzcWxDb21wb25lbnRzT3V0cHV0UmVmZXJlbmNlKHRoaXMudGVycmFmb3JtUmVzb3VyY2UsIHRoaXMudGVycmFmb3JtQXR0cmlidXRlLCBpbmRleCwgdGhpcy53cmFwc1NldCk7XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgTWFuYWdlZERhdGFiYXNlTXlzcWxOb2RlU3RhdGVzIHtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG1hbmFnZWREYXRhYmFzZU15c3FsTm9kZVN0YXRlc1RvVGVycmFmb3JtKHN0cnVjdD86IE1hbmFnZWREYXRhYmFzZU15c3FsTm9kZVN0YXRlcyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgTWFuYWdlZERhdGFiYXNlTXlzcWxOb2RlU3RhdGVzT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqIEBwYXJhbSBjb21wbGV4T2JqZWN0SW5kZXggdGhlIGluZGV4IG9mIHRoaXMgaXRlbSBpbiB0aGUgbGlzdFxuICAqIEBwYXJhbSBjb21wbGV4T2JqZWN0SXNGcm9tU2V0IHdoZXRoZXIgdGhlIGxpc3QgaXMgd3JhcHBpbmcgYSBzZXQgKHdpbGwgYWRkIHRvbGlzdCgpIHRvIGJlIGFibGUgdG8gYWNjZXNzIGFuIGl0ZW0gdmlhIGFuIGluZGV4KVxuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZywgY29tcGxleE9iamVjdEluZGV4OiBudW1iZXIsIGNvbXBsZXhPYmplY3RJc0Zyb21TZXQ6IGJvb2xlYW4pIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBjb21wbGV4T2JqZWN0SXNGcm9tU2V0LCBjb21wbGV4T2JqZWN0SW5kZXgpO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IE1hbmFnZWREYXRhYmFzZU15c3FsTm9kZVN0YXRlcyB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogTWFuYWdlZERhdGFiYXNlTXlzcWxOb2RlU3RhdGVzIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgfVxuICB9XG5cbiAgLy8gbmFtZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IG5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCduYW1lJyk7XG4gIH1cblxuICAvLyByb2xlIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgcm9sZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JvbGUnKTtcbiAgfVxuXG4gIC8vIHN0YXRlIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgc3RhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzdGF0ZScpO1xuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBNYW5hZ2VkRGF0YWJhc2VNeXNxbE5vZGVTdGF0ZXNMaXN0IGV4dGVuZHMgY2RrdGYuQ29tcGxleExpc3Qge1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqIEBwYXJhbSB3cmFwc1NldCB3aGV0aGVyIHRoZSBsaXN0IGlzIHdyYXBwaW5nIGEgc2V0ICh3aWxsIGFkZCB0b2xpc3QoKSB0byBiZSBhYmxlIHRvIGFjY2VzcyBhbiBpdGVtIHZpYSBhbiBpbmRleClcbiAgKi9cbiAgY29uc3RydWN0b3IocHJvdGVjdGVkIHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgcHJvdGVjdGVkIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLCBwcm90ZWN0ZWQgd3JhcHNTZXQ6IGJvb2xlYW4pIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCB3cmFwc1NldClcbiAgfVxuXG4gIC8qKlxuICAqIEBwYXJhbSBpbmRleCB0aGUgaW5kZXggb2YgdGhlIGl0ZW0gdG8gcmV0dXJuXG4gICovXG4gIHB1YmxpYyBnZXQoaW5kZXg6IG51bWJlcik6IE1hbmFnZWREYXRhYmFzZU15c3FsTm9kZVN0YXRlc091dHB1dFJlZmVyZW5jZSB7XG4gICAgcmV0dXJuIG5ldyBNYW5hZ2VkRGF0YWJhc2VNeXNxbE5vZGVTdGF0ZXNPdXRwdXRSZWZlcmVuY2UodGhpcy50ZXJyYWZvcm1SZXNvdXJjZSwgdGhpcy50ZXJyYWZvcm1BdHRyaWJ1dGUsIGluZGV4LCB0aGlzLndyYXBzU2V0KTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBNYW5hZ2VkRGF0YWJhc2VNeXNxbFByb3BlcnRpZXNNaWdyYXRpb24ge1xuICAvKipcbiAgKiBEYXRhYmFzZSBuYW1lIGZvciBib290c3RyYXBwaW5nIHRoZSBpbml0aWFsIGNvbm5lY3Rpb25cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNkYm5hbWUgTWFuYWdlZERhdGFiYXNlTXlzcWwjZGJuYW1lfVxuICAqL1xuICByZWFkb25seSBkYm5hbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIEhvc3RuYW1lIG9yIElQIGFkZHJlc3Mgb2YgdGhlIHNlcnZlciB3aGVyZSB0byBtaWdyYXRlIGRhdGEgZnJvbVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2hvc3QgTWFuYWdlZERhdGFiYXNlTXlzcWwjaG9zdH1cbiAgKi9cbiAgcmVhZG9ubHkgaG9zdD86IHN0cmluZztcbiAgLyoqXG4gICogQ29tbWEtc2VwYXJhdGVkIGxpc3Qgb2YgZGF0YWJhc2VzLCB3aGljaCBzaG91bGQgYmUgaWdub3JlZCBkdXJpbmcgbWlncmF0aW9uIChzdXBwb3J0ZWQgYnkgTXlTUUwgb25seSBhdCB0aGUgbW9tZW50KVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2lnbm9yZV9kYnMgTWFuYWdlZERhdGFiYXNlTXlzcWwjaWdub3JlX2Ric31cbiAgKi9cbiAgcmVhZG9ubHkgaWdub3JlRGJzPzogc3RyaW5nO1xuICAvKipcbiAgKiBQYXNzd29yZCBmb3IgYXV0aGVudGljYXRpb24gd2l0aCB0aGUgc2VydmVyIHdoZXJlIHRvIG1pZ3JhdGUgZGF0YSBmcm9tXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjcGFzc3dvcmQgTWFuYWdlZERhdGFiYXNlTXlzcWwjcGFzc3dvcmR9XG4gICovXG4gIHJlYWRvbmx5IHBhc3N3b3JkPzogc3RyaW5nO1xuICAvKipcbiAgKiBQb3J0IG51bWJlciBvZiB0aGUgc2VydmVyIHdoZXJlIHRvIG1pZ3JhdGUgZGF0YSBmcm9tXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjcG9ydCBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNwb3J0fVxuICAqL1xuICByZWFkb25seSBwb3J0PzogbnVtYmVyO1xuICAvKipcbiAgKiBUaGUgc2VydmVyIHdoZXJlIHRvIG1pZ3JhdGUgZGF0YSBmcm9tIGlzIHNlY3VyZWQgd2l0aCBTU0xcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNzc2wgTWFuYWdlZERhdGFiYXNlTXlzcWwjc3NsfVxuICAqL1xuICByZWFkb25seSBzc2w/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFVzZXIgbmFtZSBmb3IgYXV0aGVudGljYXRpb24gd2l0aCB0aGUgc2VydmVyIHdoZXJlIHRvIG1pZ3JhdGUgZGF0YSBmcm9tXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjdXNlcm5hbWUgTWFuYWdlZERhdGFiYXNlTXlzcWwjdXNlcm5hbWV9XG4gICovXG4gIHJlYWRvbmx5IHVzZXJuYW1lPzogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbWFuYWdlZERhdGFiYXNlTXlzcWxQcm9wZXJ0aWVzTWlncmF0aW9uVG9UZXJyYWZvcm0oc3RydWN0PzogTWFuYWdlZERhdGFiYXNlTXlzcWxQcm9wZXJ0aWVzTWlncmF0aW9uT3V0cHV0UmVmZXJlbmNlIHwgTWFuYWdlZERhdGFiYXNlTXlzcWxQcm9wZXJ0aWVzTWlncmF0aW9uKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGRibmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5kYm5hbWUpLFxuICAgIGhvc3Q6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuaG9zdCksXG4gICAgaWdub3JlX2RiczogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5pZ25vcmVEYnMpLFxuICAgIHBhc3N3b3JkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnBhc3N3b3JkKSxcbiAgICBwb3J0OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLnBvcnQpLFxuICAgIHNzbDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuc3NsKSxcbiAgICB1c2VybmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS51c2VybmFtZSksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIE1hbmFnZWREYXRhYmFzZU15c3FsUHJvcGVydGllc01pZ3JhdGlvbk91dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogTWFuYWdlZERhdGFiYXNlTXlzcWxQcm9wZXJ0aWVzTWlncmF0aW9uIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9kYm5hbWUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZGJuYW1lID0gdGhpcy5fZGJuYW1lO1xuICAgIH1cbiAgICBpZiAodGhpcy5faG9zdCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5ob3N0ID0gdGhpcy5faG9zdDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2lnbm9yZURicyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5pZ25vcmVEYnMgPSB0aGlzLl9pZ25vcmVEYnM7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wYXNzd29yZCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wYXNzd29yZCA9IHRoaXMuX3Bhc3N3b3JkO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcG9ydCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wb3J0ID0gdGhpcy5fcG9ydDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3NzbCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5zc2wgPSB0aGlzLl9zc2w7XG4gICAgfVxuICAgIGlmICh0aGlzLl91c2VybmFtZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC51c2VybmFtZSA9IHRoaXMuX3VzZXJuYW1lO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogTWFuYWdlZERhdGFiYXNlTXlzcWxQcm9wZXJ0aWVzTWlncmF0aW9uIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fZGJuYW1lID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5faG9zdCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2lnbm9yZURicyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3Bhc3N3b3JkID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcG9ydCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NzbCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3VzZXJuYW1lID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9kYm5hbWUgPSB2YWx1ZS5kYm5hbWU7XG4gICAgICB0aGlzLl9ob3N0ID0gdmFsdWUuaG9zdDtcbiAgICAgIHRoaXMuX2lnbm9yZURicyA9IHZhbHVlLmlnbm9yZURicztcbiAgICAgIHRoaXMuX3Bhc3N3b3JkID0gdmFsdWUucGFzc3dvcmQ7XG4gICAgICB0aGlzLl9wb3J0ID0gdmFsdWUucG9ydDtcbiAgICAgIHRoaXMuX3NzbCA9IHZhbHVlLnNzbDtcbiAgICAgIHRoaXMuX3VzZXJuYW1lID0gdmFsdWUudXNlcm5hbWU7XG4gICAgfVxuICB9XG5cbiAgLy8gZGJuYW1lIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGJuYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBkYm5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdkYm5hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRibmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZGJuYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGJuYW1lKCkge1xuICAgIHRoaXMuX2RibmFtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGJuYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RibmFtZTtcbiAgfVxuXG4gIC8vIGhvc3QgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ob3N0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBob3N0KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaG9zdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaG9zdCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faG9zdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEhvc3QoKSB7XG4gICAgdGhpcy5faG9zdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaG9zdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9ob3N0O1xuICB9XG5cbiAgLy8gaWdub3JlX2RicyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lnbm9yZURicz86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaWdub3JlRGJzKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaWdub3JlX2RicycpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWdub3JlRGJzKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9pZ25vcmVEYnMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJZ25vcmVEYnMoKSB7XG4gICAgdGhpcy5faWdub3JlRGJzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBpZ25vcmVEYnNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWdub3JlRGJzO1xuICB9XG5cbiAgLy8gcGFzc3dvcmQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wYXNzd29yZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcGFzc3dvcmQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdwYXNzd29yZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcGFzc3dvcmQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3Bhc3N3b3JkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UGFzc3dvcmQoKSB7XG4gICAgdGhpcy5fcGFzc3dvcmQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBhc3N3b3JkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Bhc3N3b3JkO1xuICB9XG5cbiAgLy8gcG9ydCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHBvcnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdwb3J0Jyk7XG4gIH1cbiAgcHVibGljIHNldCBwb3J0KHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9wb3J0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9ydCgpIHtcbiAgICB0aGlzLl9wb3J0ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwb3J0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnQ7XG4gIH1cblxuICAvLyBzc2wgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc3NsPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBzc2woKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnc3NsJyk7XG4gIH1cbiAgcHVibGljIHNldCBzc2wodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3NzbCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNzbCgpIHtcbiAgICB0aGlzLl9zc2wgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNzbElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zc2w7XG4gIH1cblxuICAvLyB1c2VybmFtZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3VzZXJuYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB1c2VybmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3VzZXJuYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCB1c2VybmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdXNlcm5hbWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVc2VybmFtZSgpIHtcbiAgICB0aGlzLl91c2VybmFtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdXNlcm5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlcm5hbWU7XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgTWFuYWdlZERhdGFiYXNlTXlzcWxQcm9wZXJ0aWVzIHtcbiAgLyoqXG4gICogQ3VzdG9tIHBhc3N3b3JkIGZvciBhZG1pbiB1c2VyLiBEZWZhdWx0cyB0byByYW5kb20gc3RyaW5nLiBUaGlzIG11c3QgYmUgc2V0IG9ubHkgd2hlbiBhIG5ldyBzZXJ2aWNlIGlzIGJlaW5nIGNyZWF0ZWQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjYWRtaW5fcGFzc3dvcmQgTWFuYWdlZERhdGFiYXNlTXlzcWwjYWRtaW5fcGFzc3dvcmR9XG4gICovXG4gIHJlYWRvbmx5IGFkbWluUGFzc3dvcmQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIEN1c3RvbSB1c2VybmFtZSBmb3IgYWRtaW4gdXNlci4gVGhpcyBtdXN0IGJlIHNldCBvbmx5IHdoZW4gYSBuZXcgc2VydmljZSBpcyBiZWluZyBjcmVhdGVkLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2FkbWluX3VzZXJuYW1lIE1hbmFnZWREYXRhYmFzZU15c3FsI2FkbWluX3VzZXJuYW1lfVxuICAqL1xuICByZWFkb25seSBhZG1pblVzZXJuYW1lPzogc3RyaW5nO1xuICAvKipcbiAgKiBBdXRvbWF0aWMgdXRpbGl0eSBuZXR3b3JrIElQIEZpbHRlclxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2F1dG9tYXRpY191dGlsaXR5X25ldHdvcmtfaXBfZmlsdGVyIE1hbmFnZWREYXRhYmFzZU15c3FsI2F1dG9tYXRpY191dGlsaXR5X25ldHdvcmtfaXBfZmlsdGVyfVxuICAqL1xuICByZWFkb25seSBhdXRvbWF0aWNVdGlsaXR5TmV0d29ya0lwRmlsdGVyPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBUaGUgaG91ciBvZiBkYXkgKGluIFVUQykgd2hlbiBiYWNrdXAgZm9yIHRoZSBzZXJ2aWNlIGlzIHN0YXJ0ZWQuIE5ldyBiYWNrdXAgaXMgb25seSBzdGFydGVkIGlmIHByZXZpb3VzIGJhY2t1cCBoYXMgYWxyZWFkeSBjb21wbGV0ZWQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjYmFja3VwX2hvdXIgTWFuYWdlZERhdGFiYXNlTXlzcWwjYmFja3VwX2hvdXJ9XG4gICovXG4gIHJlYWRvbmx5IGJhY2t1cEhvdXI/OiBudW1iZXI7XG4gIC8qKlxuICAqIFRoZSBtaW51dGUgb2YgYW4gaG91ciB3aGVuIGJhY2t1cCBmb3IgdGhlIHNlcnZpY2UgaXMgc3RhcnRlZC4gTmV3IGJhY2t1cCBpcyBvbmx5IHN0YXJ0ZWQgaWYgcHJldmlvdXMgYmFja3VwIGhhcyBhbHJlYWR5IGNvbXBsZXRlZC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNiYWNrdXBfbWludXRlIE1hbmFnZWREYXRhYmFzZU15c3FsI2JhY2t1cF9taW51dGV9XG4gICovXG4gIHJlYWRvbmx5IGJhY2t1cE1pbnV0ZT86IG51bWJlcjtcbiAgLyoqXG4gICogVGhlIG1pbmltdW0gYW1vdW50IG9mIHRpbWUgaW4gc2Vjb25kcyB0byBrZWVwIGJpbmxvZyBlbnRyaWVzIGJlZm9yZSBkZWxldGlvbi4gVGhpcyBtYXkgYmUgZXh0ZW5kZWQgZm9yIHNlcnZpY2VzIHRoYXQgcmVxdWlyZSBiaW5sb2cgZW50cmllcyBmb3IgbG9uZ2VyIHRoYW4gdGhlIGRlZmF1bHQgZm9yIGV4YW1wbGUgaWYgdXNpbmcgdGhlIE15U1FMIERlYmV6aXVtIEthZmthIGNvbm5lY3Rvci5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNiaW5sb2dfcmV0ZW50aW9uX3BlcmlvZCBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNiaW5sb2dfcmV0ZW50aW9uX3BlcmlvZH1cbiAgKi9cbiAgcmVhZG9ubHkgYmlubG9nUmV0ZW50aW9uUGVyaW9kPzogbnVtYmVyO1xuICAvKipcbiAgKiBjb25uZWN0X3RpbWVvdXRcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNjb25uZWN0X3RpbWVvdXQgTWFuYWdlZERhdGFiYXNlTXlzcWwjY29ubmVjdF90aW1lb3V0fVxuICAqL1xuICByZWFkb25seSBjb25uZWN0VGltZW91dD86IG51bWJlcjtcbiAgLyoqXG4gICogZGVmYXVsdF90aW1lX3pvbmVcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNkZWZhdWx0X3RpbWVfem9uZSBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNkZWZhdWx0X3RpbWVfem9uZX1cbiAgKi9cbiAgcmVhZG9ubHkgZGVmYXVsdFRpbWVab25lPzogc3RyaW5nO1xuICAvKipcbiAgKiBncm91cF9jb25jYXRfbWF4X2xlblxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2dyb3VwX2NvbmNhdF9tYXhfbGVuIE1hbmFnZWREYXRhYmFzZU15c3FsI2dyb3VwX2NvbmNhdF9tYXhfbGVufVxuICAqL1xuICByZWFkb25seSBncm91cENvbmNhdE1heExlbj86IG51bWJlcjtcbiAgLyoqXG4gICogaW5mb3JtYXRpb25fc2NoZW1hX3N0YXRzX2V4cGlyeVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2luZm9ybWF0aW9uX3NjaGVtYV9zdGF0c19leHBpcnkgTWFuYWdlZERhdGFiYXNlTXlzcWwjaW5mb3JtYXRpb25fc2NoZW1hX3N0YXRzX2V4cGlyeX1cbiAgKi9cbiAgcmVhZG9ubHkgaW5mb3JtYXRpb25TY2hlbWFTdGF0c0V4cGlyeT86IG51bWJlcjtcbiAgLyoqXG4gICogaW5ub2RiX2Z0X21pbl90b2tlbl9zaXplXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjaW5ub2RiX2Z0X21pbl90b2tlbl9zaXplIE1hbmFnZWREYXRhYmFzZU15c3FsI2lubm9kYl9mdF9taW5fdG9rZW5fc2l6ZX1cbiAgKi9cbiAgcmVhZG9ubHkgaW5ub2RiRnRNaW5Ub2tlblNpemU/OiBudW1iZXI7XG4gIC8qKlxuICAqIGlubm9kYl9mdF9zZXJ2ZXJfc3RvcHdvcmRfdGFibGVcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNpbm5vZGJfZnRfc2VydmVyX3N0b3B3b3JkX3RhYmxlIE1hbmFnZWREYXRhYmFzZU15c3FsI2lubm9kYl9mdF9zZXJ2ZXJfc3RvcHdvcmRfdGFibGV9XG4gICovXG4gIHJlYWRvbmx5IGlubm9kYkZ0U2VydmVyU3RvcHdvcmRUYWJsZT86IHN0cmluZztcbiAgLyoqXG4gICogaW5ub2RiX2xvY2tfd2FpdF90aW1lb3V0XG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjaW5ub2RiX2xvY2tfd2FpdF90aW1lb3V0IE1hbmFnZWREYXRhYmFzZU15c3FsI2lubm9kYl9sb2NrX3dhaXRfdGltZW91dH1cbiAgKi9cbiAgcmVhZG9ubHkgaW5ub2RiTG9ja1dhaXRUaW1lb3V0PzogbnVtYmVyO1xuICAvKipcbiAgKiBpbm5vZGJfbG9nX2J1ZmZlcl9zaXplXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjaW5ub2RiX2xvZ19idWZmZXJfc2l6ZSBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNpbm5vZGJfbG9nX2J1ZmZlcl9zaXplfVxuICAqL1xuICByZWFkb25seSBpbm5vZGJMb2dCdWZmZXJTaXplPzogbnVtYmVyO1xuICAvKipcbiAgKiBpbm5vZGJfb25saW5lX2FsdGVyX2xvZ19tYXhfc2l6ZVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2lubm9kYl9vbmxpbmVfYWx0ZXJfbG9nX21heF9zaXplIE1hbmFnZWREYXRhYmFzZU15c3FsI2lubm9kYl9vbmxpbmVfYWx0ZXJfbG9nX21heF9zaXplfVxuICAqL1xuICByZWFkb25seSBpbm5vZGJPbmxpbmVBbHRlckxvZ01heFNpemU/OiBudW1iZXI7XG4gIC8qKlxuICAqIGlubm9kYl9wcmludF9hbGxfZGVhZGxvY2tzXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjaW5ub2RiX3ByaW50X2FsbF9kZWFkbG9ja3MgTWFuYWdlZERhdGFiYXNlTXlzcWwjaW5ub2RiX3ByaW50X2FsbF9kZWFkbG9ja3N9XG4gICovXG4gIHJlYWRvbmx5IGlubm9kYlByaW50QWxsRGVhZGxvY2tzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBpbm5vZGJfcm9sbGJhY2tfb25fdGltZW91dFxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2lubm9kYl9yb2xsYmFja19vbl90aW1lb3V0IE1hbmFnZWREYXRhYmFzZU15c3FsI2lubm9kYl9yb2xsYmFja19vbl90aW1lb3V0fVxuICAqL1xuICByZWFkb25seSBpbm5vZGJSb2xsYmFja09uVGltZW91dD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogaW50ZXJhY3RpdmVfdGltZW91dFxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2ludGVyYWN0aXZlX3RpbWVvdXQgTWFuYWdlZERhdGFiYXNlTXlzcWwjaW50ZXJhY3RpdmVfdGltZW91dH1cbiAgKi9cbiAgcmVhZG9ubHkgaW50ZXJhY3RpdmVUaW1lb3V0PzogbnVtYmVyO1xuICAvKipcbiAgKiBpbnRlcm5hbF90bXBfbWVtX3N0b3JhZ2VfZW5naW5lXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjaW50ZXJuYWxfdG1wX21lbV9zdG9yYWdlX2VuZ2luZSBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNpbnRlcm5hbF90bXBfbWVtX3N0b3JhZ2VfZW5naW5lfVxuICAqL1xuICByZWFkb25seSBpbnRlcm5hbFRtcE1lbVN0b3JhZ2VFbmdpbmU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIElQIGZpbHRlclxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2lwX2ZpbHRlciBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNpcF9maWx0ZXJ9XG4gICovXG4gIHJlYWRvbmx5IGlwRmlsdGVyPzogc3RyaW5nW107XG4gIC8qKlxuICAqIGxvbmdfcXVlcnlfdGltZVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI2xvbmdfcXVlcnlfdGltZSBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNsb25nX3F1ZXJ5X3RpbWV9XG4gICovXG4gIHJlYWRvbmx5IGxvbmdRdWVyeVRpbWU/OiBudW1iZXI7XG4gIC8qKlxuICAqIG1heF9hbGxvd2VkX3BhY2tldFxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI21heF9hbGxvd2VkX3BhY2tldCBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNtYXhfYWxsb3dlZF9wYWNrZXR9XG4gICovXG4gIHJlYWRvbmx5IG1heEFsbG93ZWRQYWNrZXQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIG1heF9oZWFwX3RhYmxlX3NpemVcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNtYXhfaGVhcF90YWJsZV9zaXplIE1hbmFnZWREYXRhYmFzZU15c3FsI21heF9oZWFwX3RhYmxlX3NpemV9XG4gICovXG4gIHJlYWRvbmx5IG1heEhlYXBUYWJsZVNpemU/OiBudW1iZXI7XG4gIC8qKlxuICAqIG5ldF9yZWFkX3RpbWVvdXRcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNuZXRfcmVhZF90aW1lb3V0IE1hbmFnZWREYXRhYmFzZU15c3FsI25ldF9yZWFkX3RpbWVvdXR9XG4gICovXG4gIHJlYWRvbmx5IG5ldFJlYWRUaW1lb3V0PzogbnVtYmVyO1xuICAvKipcbiAgKiBuZXRfd3JpdGVfdGltZW91dFxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI25ldF93cml0ZV90aW1lb3V0IE1hbmFnZWREYXRhYmFzZU15c3FsI25ldF93cml0ZV90aW1lb3V0fVxuICAqL1xuICByZWFkb25seSBuZXRXcml0ZVRpbWVvdXQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIFB1YmxpYyBBY2Nlc3NcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNwdWJsaWNfYWNjZXNzIE1hbmFnZWREYXRhYmFzZU15c3FsI3B1YmxpY19hY2Nlc3N9XG4gICovXG4gIHJlYWRvbmx5IHB1YmxpY0FjY2Vzcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogc2xvd19xdWVyeV9sb2dcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNzbG93X3F1ZXJ5X2xvZyBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNzbG93X3F1ZXJ5X2xvZ31cbiAgKi9cbiAgcmVhZG9ubHkgc2xvd1F1ZXJ5TG9nPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBzb3J0X2J1ZmZlcl9zaXplXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjc29ydF9idWZmZXJfc2l6ZSBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNzb3J0X2J1ZmZlcl9zaXplfVxuICAqL1xuICByZWFkb25seSBzb3J0QnVmZmVyU2l6ZT86IG51bWJlcjtcbiAgLyoqXG4gICogc3FsX21vZGVcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNzcWxfbW9kZSBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNzcWxfbW9kZX1cbiAgKi9cbiAgcmVhZG9ubHkgc3FsTW9kZT86IHN0cmluZztcbiAgLyoqXG4gICogc3FsX3JlcXVpcmVfcHJpbWFyeV9rZXlcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCNzcWxfcmVxdWlyZV9wcmltYXJ5X2tleSBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNzcWxfcmVxdWlyZV9wcmltYXJ5X2tleX1cbiAgKi9cbiAgcmVhZG9ubHkgc3FsUmVxdWlyZVByaW1hcnlLZXk/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIHRtcF90YWJsZV9zaXplXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjdG1wX3RhYmxlX3NpemUgTWFuYWdlZERhdGFiYXNlTXlzcWwjdG1wX3RhYmxlX3NpemV9XG4gICovXG4gIHJlYWRvbmx5IHRtcFRhYmxlU2l6ZT86IG51bWJlcjtcbiAgLyoqXG4gICogTXlTUUwgbWFqb3IgdmVyc2lvblxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI3ZlcnNpb24gTWFuYWdlZERhdGFiYXNlTXlzcWwjdmVyc2lvbn1cbiAgKi9cbiAgcmVhZG9ubHkgdmVyc2lvbj86IHN0cmluZztcbiAgLyoqXG4gICogd2FpdF90aW1lb3V0XG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdXBjbG91ZC9yL21hbmFnZWRfZGF0YWJhc2VfbXlzcWwjd2FpdF90aW1lb3V0IE1hbmFnZWREYXRhYmFzZU15c3FsI3dhaXRfdGltZW91dH1cbiAgKi9cbiAgcmVhZG9ubHkgd2FpdFRpbWVvdXQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIG1pZ3JhdGlvbiBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsI21pZ3JhdGlvbiBNYW5hZ2VkRGF0YWJhc2VNeXNxbCNtaWdyYXRpb259XG4gICovXG4gIHJlYWRvbmx5IG1pZ3JhdGlvbj86IE1hbmFnZWREYXRhYmFzZU15c3FsUHJvcGVydGllc01pZ3JhdGlvbjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG1hbmFnZWREYXRhYmFzZU15c3FsUHJvcGVydGllc1RvVGVycmFmb3JtKHN0cnVjdD86IE1hbmFnZWREYXRhYmFzZU15c3FsUHJvcGVydGllc091dHB1dFJlZmVyZW5jZSB8IE1hbmFnZWREYXRhYmFzZU15c3FsUHJvcGVydGllcyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBhZG1pbl9wYXNzd29yZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5hZG1pblBhc3N3b3JkKSxcbiAgICBhZG1pbl91c2VybmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5hZG1pblVzZXJuYW1lKSxcbiAgICBhdXRvbWF0aWNfdXRpbGl0eV9uZXR3b3JrX2lwX2ZpbHRlcjogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuYXV0b21hdGljVXRpbGl0eU5ldHdvcmtJcEZpbHRlciksXG4gICAgYmFja3VwX2hvdXI6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuYmFja3VwSG91ciksXG4gICAgYmFja3VwX21pbnV0ZTogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5iYWNrdXBNaW51dGUpLFxuICAgIGJpbmxvZ19yZXRlbnRpb25fcGVyaW9kOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmJpbmxvZ1JldGVudGlvblBlcmlvZCksXG4gICAgY29ubmVjdF90aW1lb3V0OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmNvbm5lY3RUaW1lb3V0KSxcbiAgICBkZWZhdWx0X3RpbWVfem9uZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5kZWZhdWx0VGltZVpvbmUpLFxuICAgIGdyb3VwX2NvbmNhdF9tYXhfbGVuOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmdyb3VwQ29uY2F0TWF4TGVuKSxcbiAgICBpbmZvcm1hdGlvbl9zY2hlbWFfc3RhdHNfZXhwaXJ5OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmluZm9ybWF0aW9uU2NoZW1hU3RhdHNFeHBpcnkpLFxuICAgIGlubm9kYl9mdF9taW5fdG9rZW5fc2l6ZTogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5pbm5vZGJGdE1pblRva2VuU2l6ZSksXG4gICAgaW5ub2RiX2Z0X3NlcnZlcl9zdG9wd29yZF90YWJsZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5pbm5vZGJGdFNlcnZlclN0b3B3b3JkVGFibGUpLFxuICAgIGlubm9kYl9sb2NrX3dhaXRfdGltZW91dDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5pbm5vZGJMb2NrV2FpdFRpbWVvdXQpLFxuICAgIGlubm9kYl9sb2dfYnVmZmVyX3NpemU6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuaW5ub2RiTG9nQnVmZmVyU2l6ZSksXG4gICAgaW5ub2RiX29ubGluZV9hbHRlcl9sb2dfbWF4X3NpemU6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuaW5ub2RiT25saW5lQWx0ZXJMb2dNYXhTaXplKSxcbiAgICBpbm5vZGJfcHJpbnRfYWxsX2RlYWRsb2NrczogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuaW5ub2RiUHJpbnRBbGxEZWFkbG9ja3MpLFxuICAgIGlubm9kYl9yb2xsYmFja19vbl90aW1lb3V0OiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5pbm5vZGJSb2xsYmFja09uVGltZW91dCksXG4gICAgaW50ZXJhY3RpdmVfdGltZW91dDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5pbnRlcmFjdGl2ZVRpbWVvdXQpLFxuICAgIGludGVybmFsX3RtcF9tZW1fc3RvcmFnZV9lbmdpbmU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuaW50ZXJuYWxUbXBNZW1TdG9yYWdlRW5naW5lKSxcbiAgICBpcF9maWx0ZXI6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0pKHN0cnVjdCEuaXBGaWx0ZXIpLFxuICAgIGxvbmdfcXVlcnlfdGltZTogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5sb25nUXVlcnlUaW1lKSxcbiAgICBtYXhfYWxsb3dlZF9wYWNrZXQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEubWF4QWxsb3dlZFBhY2tldCksXG4gICAgbWF4X2hlYXBfdGFibGVfc2l6ZTogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5tYXhIZWFwVGFibGVTaXplKSxcbiAgICBuZXRfcmVhZF90aW1lb3V0OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLm5ldFJlYWRUaW1lb3V0KSxcbiAgICBuZXRfd3JpdGVfdGltZW91dDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5uZXRXcml0ZVRpbWVvdXQpLFxuICAgIHB1YmxpY19hY2Nlc3M6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLnB1YmxpY0FjY2VzcyksXG4gICAgc2xvd19xdWVyeV9sb2c6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLnNsb3dRdWVyeUxvZyksXG4gICAgc29ydF9idWZmZXJfc2l6ZTogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5zb3J0QnVmZmVyU2l6ZSksXG4gICAgc3FsX21vZGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuc3FsTW9kZSksXG4gICAgc3FsX3JlcXVpcmVfcHJpbWFyeV9rZXk6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLnNxbFJlcXVpcmVQcmltYXJ5S2V5KSxcbiAgICB0bXBfdGFibGVfc2l6ZTogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS50bXBUYWJsZVNpemUpLFxuICAgIHZlcnNpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEudmVyc2lvbiksXG4gICAgd2FpdF90aW1lb3V0OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLndhaXRUaW1lb3V0KSxcbiAgICBtaWdyYXRpb246IG1hbmFnZWREYXRhYmFzZU15c3FsUHJvcGVydGllc01pZ3JhdGlvblRvVGVycmFmb3JtKHN0cnVjdCEubWlncmF0aW9uKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgTWFuYWdlZERhdGFiYXNlTXlzcWxQcm9wZXJ0aWVzT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBNYW5hZ2VkRGF0YWJhc2VNeXNxbFByb3BlcnRpZXMgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2FkbWluUGFzc3dvcmQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuYWRtaW5QYXNzd29yZCA9IHRoaXMuX2FkbWluUGFzc3dvcmQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9hZG1pblVzZXJuYW1lICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmFkbWluVXNlcm5hbWUgPSB0aGlzLl9hZG1pblVzZXJuYW1lO1xuICAgIH1cbiAgICBpZiAodGhpcy5fYXV0b21hdGljVXRpbGl0eU5ldHdvcmtJcEZpbHRlciAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5hdXRvbWF0aWNVdGlsaXR5TmV0d29ya0lwRmlsdGVyID0gdGhpcy5fYXV0b21hdGljVXRpbGl0eU5ldHdvcmtJcEZpbHRlcjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2JhY2t1cEhvdXIgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuYmFja3VwSG91ciA9IHRoaXMuX2JhY2t1cEhvdXI7XG4gICAgfVxuICAgIGlmICh0aGlzLl9iYWNrdXBNaW51dGUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuYmFja3VwTWludXRlID0gdGhpcy5fYmFja3VwTWludXRlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fYmlubG9nUmV0ZW50aW9uUGVyaW9kICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmJpbmxvZ1JldGVudGlvblBlcmlvZCA9IHRoaXMuX2JpbmxvZ1JldGVudGlvblBlcmlvZDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2Nvbm5lY3RUaW1lb3V0ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmNvbm5lY3RUaW1lb3V0ID0gdGhpcy5fY29ubmVjdFRpbWVvdXQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9kZWZhdWx0VGltZVpvbmUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZGVmYXVsdFRpbWVab25lID0gdGhpcy5fZGVmYXVsdFRpbWVab25lO1xuICAgIH1cbiAgICBpZiAodGhpcy5fZ3JvdXBDb25jYXRNYXhMZW4gIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZ3JvdXBDb25jYXRNYXhMZW4gPSB0aGlzLl9ncm91cENvbmNhdE1heExlbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2luZm9ybWF0aW9uU2NoZW1hU3RhdHNFeHBpcnkgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuaW5mb3JtYXRpb25TY2hlbWFTdGF0c0V4cGlyeSA9IHRoaXMuX2luZm9ybWF0aW9uU2NoZW1hU3RhdHNFeHBpcnk7XG4gICAgfVxuICAgIGlmICh0aGlzLl9pbm5vZGJGdE1pblRva2VuU2l6ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5pbm5vZGJGdE1pblRva2VuU2l6ZSA9IHRoaXMuX2lubm9kYkZ0TWluVG9rZW5TaXplO1xuICAgIH1cbiAgICBpZiAodGhpcy5faW5ub2RiRnRTZXJ2ZXJTdG9wd29yZFRhYmxlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0Lmlubm9kYkZ0U2VydmVyU3RvcHdvcmRUYWJsZSA9IHRoaXMuX2lubm9kYkZ0U2VydmVyU3RvcHdvcmRUYWJsZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2lubm9kYkxvY2tXYWl0VGltZW91dCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5pbm5vZGJMb2NrV2FpdFRpbWVvdXQgPSB0aGlzLl9pbm5vZGJMb2NrV2FpdFRpbWVvdXQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9pbm5vZGJMb2dCdWZmZXJTaXplICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0Lmlubm9kYkxvZ0J1ZmZlclNpemUgPSB0aGlzLl9pbm5vZGJMb2dCdWZmZXJTaXplO1xuICAgIH1cbiAgICBpZiAodGhpcy5faW5ub2RiT25saW5lQWx0ZXJMb2dNYXhTaXplICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0Lmlubm9kYk9ubGluZUFsdGVyTG9nTWF4U2l6ZSA9IHRoaXMuX2lubm9kYk9ubGluZUFsdGVyTG9nTWF4U2l6ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2lubm9kYlByaW50QWxsRGVhZGxvY2tzICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0Lmlubm9kYlByaW50QWxsRGVhZGxvY2tzID0gdGhpcy5faW5ub2RiUHJpbnRBbGxEZWFkbG9ja3M7XG4gICAgfVxuICAgIGlmICh0aGlzLl9pbm5vZGJSb2xsYmFja09uVGltZW91dCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5pbm5vZGJSb2xsYmFja09uVGltZW91dCA9IHRoaXMuX2lubm9kYlJvbGxiYWNrT25UaW1lb3V0O1xuICAgIH1cbiAgICBpZiAodGhpcy5faW50ZXJhY3RpdmVUaW1lb3V0ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmludGVyYWN0aXZlVGltZW91dCA9IHRoaXMuX2ludGVyYWN0aXZlVGltZW91dDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2ludGVybmFsVG1wTWVtU3RvcmFnZUVuZ2luZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5pbnRlcm5hbFRtcE1lbVN0b3JhZ2VFbmdpbmUgPSB0aGlzLl9pbnRlcm5hbFRtcE1lbVN0b3JhZ2VFbmdpbmU7XG4gICAgfVxuICAgIGlmICh0aGlzLl9pcEZpbHRlciAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5pcEZpbHRlciA9IHRoaXMuX2lwRmlsdGVyO1xuICAgIH1cbiAgICBpZiAodGhpcy5fbG9uZ1F1ZXJ5VGltZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5sb25nUXVlcnlUaW1lID0gdGhpcy5fbG9uZ1F1ZXJ5VGltZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX21heEFsbG93ZWRQYWNrZXQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQubWF4QWxsb3dlZFBhY2tldCA9IHRoaXMuX21heEFsbG93ZWRQYWNrZXQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9tYXhIZWFwVGFibGVTaXplICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0Lm1heEhlYXBUYWJsZVNpemUgPSB0aGlzLl9tYXhIZWFwVGFibGVTaXplO1xuICAgIH1cbiAgICBpZiAodGhpcy5fbmV0UmVhZFRpbWVvdXQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQubmV0UmVhZFRpbWVvdXQgPSB0aGlzLl9uZXRSZWFkVGltZW91dDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX25ldFdyaXRlVGltZW91dCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5uZXRXcml0ZVRpbWVvdXQgPSB0aGlzLl9uZXRXcml0ZVRpbWVvdXQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wdWJsaWNBY2Nlc3MgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucHVibGljQWNjZXNzID0gdGhpcy5fcHVibGljQWNjZXNzO1xuICAgIH1cbiAgICBpZiAodGhpcy5fc2xvd1F1ZXJ5TG9nICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnNsb3dRdWVyeUxvZyA9IHRoaXMuX3Nsb3dRdWVyeUxvZztcbiAgICB9XG4gICAgaWYgKHRoaXMuX3NvcnRCdWZmZXJTaXplICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnNvcnRCdWZmZXJTaXplID0gdGhpcy5fc29ydEJ1ZmZlclNpemU7XG4gICAgfVxuICAgIGlmICh0aGlzLl9zcWxNb2RlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnNxbE1vZGUgPSB0aGlzLl9zcWxNb2RlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fc3FsUmVxdWlyZVByaW1hcnlLZXkgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuc3FsUmVxdWlyZVByaW1hcnlLZXkgPSB0aGlzLl9zcWxSZXF1aXJlUHJpbWFyeUtleTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3RtcFRhYmxlU2l6ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC50bXBUYWJsZVNpemUgPSB0aGlzLl90bXBUYWJsZVNpemU7XG4gICAgfVxuICAgIGlmICh0aGlzLl92ZXJzaW9uICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnZlcnNpb24gPSB0aGlzLl92ZXJzaW9uO1xuICAgIH1cbiAgICBpZiAodGhpcy5fd2FpdFRpbWVvdXQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQud2FpdFRpbWVvdXQgPSB0aGlzLl93YWl0VGltZW91dDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX21pZ3JhdGlvbj8uaW50ZXJuYWxWYWx1ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5taWdyYXRpb24gPSB0aGlzLl9taWdyYXRpb24/LmludGVybmFsVmFsdWU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBNYW5hZ2VkRGF0YWJhc2VNeXNxbFByb3BlcnRpZXMgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9hZG1pblBhc3N3b3JkID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fYWRtaW5Vc2VybmFtZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2F1dG9tYXRpY1V0aWxpdHlOZXR3b3JrSXBGaWx0ZXIgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9iYWNrdXBIb3VyID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fYmFja3VwTWludXRlID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fYmlubG9nUmV0ZW50aW9uUGVyaW9kID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fY29ubmVjdFRpbWVvdXQgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9kZWZhdWx0VGltZVpvbmUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9ncm91cENvbmNhdE1heExlbiA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2luZm9ybWF0aW9uU2NoZW1hU3RhdHNFeHBpcnkgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9pbm5vZGJGdE1pblRva2VuU2l6ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2lubm9kYkZ0U2VydmVyU3RvcHdvcmRUYWJsZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2lubm9kYkxvY2tXYWl0VGltZW91dCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2lubm9kYkxvZ0J1ZmZlclNpemUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9pbm5vZGJPbmxpbmVBbHRlckxvZ01heFNpemUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9pbm5vZGJQcmludEFsbERlYWRsb2NrcyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2lubm9kYlJvbGxiYWNrT25UaW1lb3V0ID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5faW50ZXJhY3RpdmVUaW1lb3V0ID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5faW50ZXJuYWxUbXBNZW1TdG9yYWdlRW5naW5lID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5faXBGaWx0ZXIgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9sb25nUXVlcnlUaW1lID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fbWF4QWxsb3dlZFBhY2tldCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX21heEhlYXBUYWJsZVNpemUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9uZXRSZWFkVGltZW91dCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX25ldFdyaXRlVGltZW91dCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3B1YmxpY0FjY2VzcyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3Nsb3dRdWVyeUxvZyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NvcnRCdWZmZXJTaXplID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fc3FsTW9kZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NxbFJlcXVpcmVQcmltYXJ5S2V5ID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fdG1wVGFibGVTaXplID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fdmVyc2lvbiA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3dhaXRUaW1lb3V0ID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fbWlncmF0aW9uLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2FkbWluUGFzc3dvcmQgPSB2YWx1ZS5hZG1pblBhc3N3b3JkO1xuICAgICAgdGhpcy5fYWRtaW5Vc2VybmFtZSA9IHZhbHVlLmFkbWluVXNlcm5hbWU7XG4gICAgICB0aGlzLl9hdXRvbWF0aWNVdGlsaXR5TmV0d29ya0lwRmlsdGVyID0gdmFsdWUuYXV0b21hdGljVXRpbGl0eU5ldHdvcmtJcEZpbHRlcjtcbiAgICAgIHRoaXMuX2JhY2t1cEhvdXIgPSB2YWx1ZS5iYWNrdXBIb3VyO1xuICAgICAgdGhpcy5fYmFja3VwTWludXRlID0gdmFsdWUuYmFja3VwTWludXRlO1xuICAgICAgdGhpcy5fYmlubG9nUmV0ZW50aW9uUGVyaW9kID0gdmFsdWUuYmlubG9nUmV0ZW50aW9uUGVyaW9kO1xuICAgICAgdGhpcy5fY29ubmVjdFRpbWVvdXQgPSB2YWx1ZS5jb25uZWN0VGltZW91dDtcbiAgICAgIHRoaXMuX2RlZmF1bHRUaW1lWm9uZSA9IHZhbHVlLmRlZmF1bHRUaW1lWm9uZTtcbiAgICAgIHRoaXMuX2dyb3VwQ29uY2F0TWF4TGVuID0gdmFsdWUuZ3JvdXBDb25jYXRNYXhMZW47XG4gICAgICB0aGlzLl9pbmZvcm1hdGlvblNjaGVtYVN0YXRzRXhwaXJ5ID0gdmFsdWUuaW5mb3JtYXRpb25TY2hlbWFTdGF0c0V4cGlyeTtcbiAgICAgIHRoaXMuX2lubm9kYkZ0TWluVG9rZW5TaXplID0gdmFsdWUuaW5ub2RiRnRNaW5Ub2tlblNpemU7XG4gICAgICB0aGlzLl9pbm5vZGJGdFNlcnZlclN0b3B3b3JkVGFibGUgPSB2YWx1ZS5pbm5vZGJGdFNlcnZlclN0b3B3b3JkVGFibGU7XG4gICAgICB0aGlzLl9pbm5vZGJMb2NrV2FpdFRpbWVvdXQgPSB2YWx1ZS5pbm5vZGJMb2NrV2FpdFRpbWVvdXQ7XG4gICAgICB0aGlzLl9pbm5vZGJMb2dCdWZmZXJTaXplID0gdmFsdWUuaW5ub2RiTG9nQnVmZmVyU2l6ZTtcbiAgICAgIHRoaXMuX2lubm9kYk9ubGluZUFsdGVyTG9nTWF4U2l6ZSA9IHZhbHVlLmlubm9kYk9ubGluZUFsdGVyTG9nTWF4U2l6ZTtcbiAgICAgIHRoaXMuX2lubm9kYlByaW50QWxsRGVhZGxvY2tzID0gdmFsdWUuaW5ub2RiUHJpbnRBbGxEZWFkbG9ja3M7XG4gICAgICB0aGlzLl9pbm5vZGJSb2xsYmFja09uVGltZW91dCA9IHZhbHVlLmlubm9kYlJvbGxiYWNrT25UaW1lb3V0O1xuICAgICAgdGhpcy5faW50ZXJhY3RpdmVUaW1lb3V0ID0gdmFsdWUuaW50ZXJhY3RpdmVUaW1lb3V0O1xuICAgICAgdGhpcy5faW50ZXJuYWxUbXBNZW1TdG9yYWdlRW5naW5lID0gdmFsdWUuaW50ZXJuYWxUbXBNZW1TdG9yYWdlRW5naW5lO1xuICAgICAgdGhpcy5faXBGaWx0ZXIgPSB2YWx1ZS5pcEZpbHRlcjtcbiAgICAgIHRoaXMuX2xvbmdRdWVyeVRpbWUgPSB2YWx1ZS5sb25nUXVlcnlUaW1lO1xuICAgICAgdGhpcy5fbWF4QWxsb3dlZFBhY2tldCA9IHZhbHVlLm1heEFsbG93ZWRQYWNrZXQ7XG4gICAgICB0aGlzLl9tYXhIZWFwVGFibGVTaXplID0gdmFsdWUubWF4SGVhcFRhYmxlU2l6ZTtcbiAgICAgIHRoaXMuX25ldFJlYWRUaW1lb3V0ID0gdmFsdWUubmV0UmVhZFRpbWVvdXQ7XG4gICAgICB0aGlzLl9uZXRXcml0ZVRpbWVvdXQgPSB2YWx1ZS5uZXRXcml0ZVRpbWVvdXQ7XG4gICAgICB0aGlzLl9wdWJsaWNBY2Nlc3MgPSB2YWx1ZS5wdWJsaWNBY2Nlc3M7XG4gICAgICB0aGlzLl9zbG93UXVlcnlMb2cgPSB2YWx1ZS5zbG93UXVlcnlMb2c7XG4gICAgICB0aGlzLl9zb3J0QnVmZmVyU2l6ZSA9IHZhbHVlLnNvcnRCdWZmZXJTaXplO1xuICAgICAgdGhpcy5fc3FsTW9kZSA9IHZhbHVlLnNxbE1vZGU7XG4gICAgICB0aGlzLl9zcWxSZXF1aXJlUHJpbWFyeUtleSA9IHZhbHVlLnNxbFJlcXVpcmVQcmltYXJ5S2V5O1xuICAgICAgdGhpcy5fdG1wVGFibGVTaXplID0gdmFsdWUudG1wVGFibGVTaXplO1xuICAgICAgdGhpcy5fdmVyc2lvbiA9IHZhbHVlLnZlcnNpb247XG4gICAgICB0aGlzLl93YWl0VGltZW91dCA9IHZhbHVlLndhaXRUaW1lb3V0O1xuICAgICAgdGhpcy5fbWlncmF0aW9uLmludGVybmFsVmFsdWUgPSB2YWx1ZS5taWdyYXRpb247XG4gICAgfVxuICB9XG5cbiAgLy8gYWRtaW5fcGFzc3dvcmQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hZG1pblBhc3N3b3JkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBhZG1pblBhc3N3b3JkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnYWRtaW5fcGFzc3dvcmQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGFkbWluUGFzc3dvcmQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2FkbWluUGFzc3dvcmQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBZG1pblBhc3N3b3JkKCkge1xuICAgIHRoaXMuX2FkbWluUGFzc3dvcmQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGFkbWluUGFzc3dvcmRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYWRtaW5QYXNzd29yZDtcbiAgfVxuXG4gIC8vIGFkbWluX3VzZXJuYW1lIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYWRtaW5Vc2VybmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgYWRtaW5Vc2VybmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2FkbWluX3VzZXJuYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBhZG1pblVzZXJuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9hZG1pblVzZXJuYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QWRtaW5Vc2VybmFtZSgpIHtcbiAgICB0aGlzLl9hZG1pblVzZXJuYW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBhZG1pblVzZXJuYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FkbWluVXNlcm5hbWU7XG4gIH1cblxuICAvLyBhdXRvbWF0aWNfdXRpbGl0eV9uZXR3b3JrX2lwX2ZpbHRlciAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hdXRvbWF0aWNVdGlsaXR5TmV0d29ya0lwRmlsdGVyPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBhdXRvbWF0aWNVdGlsaXR5TmV0d29ya0lwRmlsdGVyKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2F1dG9tYXRpY191dGlsaXR5X25ldHdvcmtfaXBfZmlsdGVyJyk7XG4gIH1cbiAgcHVibGljIHNldCBhdXRvbWF0aWNVdGlsaXR5TmV0d29ya0lwRmlsdGVyKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9hdXRvbWF0aWNVdGlsaXR5TmV0d29ya0lwRmlsdGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QXV0b21hdGljVXRpbGl0eU5ldHdvcmtJcEZpbHRlcigpIHtcbiAgICB0aGlzLl9hdXRvbWF0aWNVdGlsaXR5TmV0d29ya0lwRmlsdGVyID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBhdXRvbWF0aWNVdGlsaXR5TmV0d29ya0lwRmlsdGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2F1dG9tYXRpY1V0aWxpdHlOZXR3b3JrSXBGaWx0ZXI7XG4gIH1cblxuICAvLyBiYWNrdXBfaG91ciAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2JhY2t1cEhvdXI/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGJhY2t1cEhvdXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdiYWNrdXBfaG91cicpO1xuICB9XG4gIHB1YmxpYyBzZXQgYmFja3VwSG91cih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fYmFja3VwSG91ciA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEJhY2t1cEhvdXIoKSB7XG4gICAgdGhpcy5fYmFja3VwSG91ciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYmFja3VwSG91cklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9iYWNrdXBIb3VyO1xuICB9XG5cbiAgLy8gYmFja3VwX21pbnV0ZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2JhY2t1cE1pbnV0ZT86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgYmFja3VwTWludXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnYmFja3VwX21pbnV0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgYmFja3VwTWludXRlKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9iYWNrdXBNaW51dGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRCYWNrdXBNaW51dGUoKSB7XG4gICAgdGhpcy5fYmFja3VwTWludXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBiYWNrdXBNaW51dGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYmFja3VwTWludXRlO1xuICB9XG5cbiAgLy8gYmlubG9nX3JldGVudGlvbl9wZXJpb2QgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9iaW5sb2dSZXRlbnRpb25QZXJpb2Q/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGJpbmxvZ1JldGVudGlvblBlcmlvZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2JpbmxvZ19yZXRlbnRpb25fcGVyaW9kJyk7XG4gIH1cbiAgcHVibGljIHNldCBiaW5sb2dSZXRlbnRpb25QZXJpb2QodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2JpbmxvZ1JldGVudGlvblBlcmlvZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEJpbmxvZ1JldGVudGlvblBlcmlvZCgpIHtcbiAgICB0aGlzLl9iaW5sb2dSZXRlbnRpb25QZXJpb2QgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJpbmxvZ1JldGVudGlvblBlcmlvZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9iaW5sb2dSZXRlbnRpb25QZXJpb2Q7XG4gIH1cblxuICAvLyBjb25uZWN0X3RpbWVvdXQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jb25uZWN0VGltZW91dD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgY29ubmVjdFRpbWVvdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdjb25uZWN0X3RpbWVvdXQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNvbm5lY3RUaW1lb3V0KHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9jb25uZWN0VGltZW91dCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENvbm5lY3RUaW1lb3V0KCkge1xuICAgIHRoaXMuX2Nvbm5lY3RUaW1lb3V0ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjb25uZWN0VGltZW91dElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jb25uZWN0VGltZW91dDtcbiAgfVxuXG4gIC8vIGRlZmF1bHRfdGltZV96b25lIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVmYXVsdFRpbWVab25lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBkZWZhdWx0VGltZVpvbmUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdkZWZhdWx0X3RpbWVfem9uZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVmYXVsdFRpbWVab25lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kZWZhdWx0VGltZVpvbmUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWZhdWx0VGltZVpvbmUoKSB7XG4gICAgdGhpcy5fZGVmYXVsdFRpbWVab25lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZWZhdWx0VGltZVpvbmVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVmYXVsdFRpbWVab25lO1xuICB9XG5cbiAgLy8gZ3JvdXBfY29uY2F0X21heF9sZW4gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ncm91cENvbmNhdE1heExlbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgZ3JvdXBDb25jYXRNYXhMZW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdncm91cF9jb25jYXRfbWF4X2xlbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZ3JvdXBDb25jYXRNYXhMZW4odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2dyb3VwQ29uY2F0TWF4TGVuID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0R3JvdXBDb25jYXRNYXhMZW4oKSB7XG4gICAgdGhpcy5fZ3JvdXBDb25jYXRNYXhMZW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGdyb3VwQ29uY2F0TWF4TGVuSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2dyb3VwQ29uY2F0TWF4TGVuO1xuICB9XG5cbiAgLy8gaW5mb3JtYXRpb25fc2NoZW1hX3N0YXRzX2V4cGlyeSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2luZm9ybWF0aW9uU2NoZW1hU3RhdHNFeHBpcnk/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGluZm9ybWF0aW9uU2NoZW1hU3RhdHNFeHBpcnkoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdpbmZvcm1hdGlvbl9zY2hlbWFfc3RhdHNfZXhwaXJ5Jyk7XG4gIH1cbiAgcHVibGljIHNldCBpbmZvcm1hdGlvblNjaGVtYVN0YXRzRXhwaXJ5KHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9pbmZvcm1hdGlvblNjaGVtYVN0YXRzRXhwaXJ5ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SW5mb3JtYXRpb25TY2hlbWFTdGF0c0V4cGlyeSgpIHtcbiAgICB0aGlzLl9pbmZvcm1hdGlvblNjaGVtYVN0YXRzRXhwaXJ5ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBpbmZvcm1hdGlvblNjaGVtYVN0YXRzRXhwaXJ5SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2luZm9ybWF0aW9uU2NoZW1hU3RhdHNFeHBpcnk7XG4gIH1cblxuICAvLyBpbm5vZGJfZnRfbWluX3Rva2VuX3NpemUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pbm5vZGJGdE1pblRva2VuU2l6ZT86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgaW5ub2RiRnRNaW5Ub2tlblNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdpbm5vZGJfZnRfbWluX3Rva2VuX3NpemUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlubm9kYkZ0TWluVG9rZW5TaXplKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9pbm5vZGJGdE1pblRva2VuU2l6ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldElubm9kYkZ0TWluVG9rZW5TaXplKCkge1xuICAgIHRoaXMuX2lubm9kYkZ0TWluVG9rZW5TaXplID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBpbm5vZGJGdE1pblRva2VuU2l6ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9pbm5vZGJGdE1pblRva2VuU2l6ZTtcbiAgfVxuXG4gIC8vIGlubm9kYl9mdF9zZXJ2ZXJfc3RvcHdvcmRfdGFibGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pbm5vZGJGdFNlcnZlclN0b3B3b3JkVGFibGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGlubm9kYkZ0U2VydmVyU3RvcHdvcmRUYWJsZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lubm9kYl9mdF9zZXJ2ZXJfc3RvcHdvcmRfdGFibGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlubm9kYkZ0U2VydmVyU3RvcHdvcmRUYWJsZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faW5ub2RiRnRTZXJ2ZXJTdG9wd29yZFRhYmxlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SW5ub2RiRnRTZXJ2ZXJTdG9wd29yZFRhYmxlKCkge1xuICAgIHRoaXMuX2lubm9kYkZ0U2VydmVyU3RvcHdvcmRUYWJsZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaW5ub2RiRnRTZXJ2ZXJTdG9wd29yZFRhYmxlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lubm9kYkZ0U2VydmVyU3RvcHdvcmRUYWJsZTtcbiAgfVxuXG4gIC8vIGlubm9kYl9sb2NrX3dhaXRfdGltZW91dCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lubm9kYkxvY2tXYWl0VGltZW91dD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgaW5ub2RiTG9ja1dhaXRUaW1lb3V0KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnaW5ub2RiX2xvY2tfd2FpdF90aW1lb3V0Jyk7XG4gIH1cbiAgcHVibGljIHNldCBpbm5vZGJMb2NrV2FpdFRpbWVvdXQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2lubm9kYkxvY2tXYWl0VGltZW91dCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldElubm9kYkxvY2tXYWl0VGltZW91dCgpIHtcbiAgICB0aGlzLl9pbm5vZGJMb2NrV2FpdFRpbWVvdXQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlubm9kYkxvY2tXYWl0VGltZW91dElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9pbm5vZGJMb2NrV2FpdFRpbWVvdXQ7XG4gIH1cblxuICAvLyBpbm5vZGJfbG9nX2J1ZmZlcl9zaXplIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaW5ub2RiTG9nQnVmZmVyU2l6ZT86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgaW5ub2RiTG9nQnVmZmVyU2l6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2lubm9kYl9sb2dfYnVmZmVyX3NpemUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlubm9kYkxvZ0J1ZmZlclNpemUodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2lubm9kYkxvZ0J1ZmZlclNpemUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJbm5vZGJMb2dCdWZmZXJTaXplKCkge1xuICAgIHRoaXMuX2lubm9kYkxvZ0J1ZmZlclNpemUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlubm9kYkxvZ0J1ZmZlclNpemVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faW5ub2RiTG9nQnVmZmVyU2l6ZTtcbiAgfVxuXG4gIC8vIGlubm9kYl9vbmxpbmVfYWx0ZXJfbG9nX21heF9zaXplIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaW5ub2RiT25saW5lQWx0ZXJMb2dNYXhTaXplPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBpbm5vZGJPbmxpbmVBbHRlckxvZ01heFNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdpbm5vZGJfb25saW5lX2FsdGVyX2xvZ19tYXhfc2l6ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgaW5ub2RiT25saW5lQWx0ZXJMb2dNYXhTaXplKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9pbm5vZGJPbmxpbmVBbHRlckxvZ01heFNpemUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJbm5vZGJPbmxpbmVBbHRlckxvZ01heFNpemUoKSB7XG4gICAgdGhpcy5faW5ub2RiT25saW5lQWx0ZXJMb2dNYXhTaXplID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBpbm5vZGJPbmxpbmVBbHRlckxvZ01heFNpemVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faW5ub2RiT25saW5lQWx0ZXJMb2dNYXhTaXplO1xuICB9XG5cbiAgLy8gaW5ub2RiX3ByaW50X2FsbF9kZWFkbG9ja3MgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pbm5vZGJQcmludEFsbERlYWRsb2Nrcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgaW5ub2RiUHJpbnRBbGxEZWFkbG9ja3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnaW5ub2RiX3ByaW50X2FsbF9kZWFkbG9ja3MnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlubm9kYlByaW50QWxsRGVhZGxvY2tzKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9pbm5vZGJQcmludEFsbERlYWRsb2NrcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldElubm9kYlByaW50QWxsRGVhZGxvY2tzKCkge1xuICAgIHRoaXMuX2lubm9kYlByaW50QWxsRGVhZGxvY2tzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBpbm5vZGJQcmludEFsbERlYWRsb2Nrc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9pbm5vZGJQcmludEFsbERlYWRsb2NrcztcbiAgfVxuXG4gIC8vIGlubm9kYl9yb2xsYmFja19vbl90aW1lb3V0IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaW5ub2RiUm9sbGJhY2tPblRpbWVvdXQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGlubm9kYlJvbGxiYWNrT25UaW1lb3V0KCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2lubm9kYl9yb2xsYmFja19vbl90aW1lb3V0Jyk7XG4gIH1cbiAgcHVibGljIHNldCBpbm5vZGJSb2xsYmFja09uVGltZW91dCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5faW5ub2RiUm9sbGJhY2tPblRpbWVvdXQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJbm5vZGJSb2xsYmFja09uVGltZW91dCgpIHtcbiAgICB0aGlzLl9pbm5vZGJSb2xsYmFja09uVGltZW91dCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaW5ub2RiUm9sbGJhY2tPblRpbWVvdXRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faW5ub2RiUm9sbGJhY2tPblRpbWVvdXQ7XG4gIH1cblxuICAvLyBpbnRlcmFjdGl2ZV90aW1lb3V0IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaW50ZXJhY3RpdmVUaW1lb3V0PzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBpbnRlcmFjdGl2ZVRpbWVvdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdpbnRlcmFjdGl2ZV90aW1lb3V0Jyk7XG4gIH1cbiAgcHVibGljIHNldCBpbnRlcmFjdGl2ZVRpbWVvdXQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2ludGVyYWN0aXZlVGltZW91dCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEludGVyYWN0aXZlVGltZW91dCgpIHtcbiAgICB0aGlzLl9pbnRlcmFjdGl2ZVRpbWVvdXQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGludGVyYWN0aXZlVGltZW91dElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9pbnRlcmFjdGl2ZVRpbWVvdXQ7XG4gIH1cblxuICAvLyBpbnRlcm5hbF90bXBfbWVtX3N0b3JhZ2VfZW5naW5lIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaW50ZXJuYWxUbXBNZW1TdG9yYWdlRW5naW5lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBpbnRlcm5hbFRtcE1lbVN0b3JhZ2VFbmdpbmUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpbnRlcm5hbF90bXBfbWVtX3N0b3JhZ2VfZW5naW5lJyk7XG4gIH1cbiAgcHVibGljIHNldCBpbnRlcm5hbFRtcE1lbVN0b3JhZ2VFbmdpbmUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2ludGVybmFsVG1wTWVtU3RvcmFnZUVuZ2luZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEludGVybmFsVG1wTWVtU3RvcmFnZUVuZ2luZSgpIHtcbiAgICB0aGlzLl9pbnRlcm5hbFRtcE1lbVN0b3JhZ2VFbmdpbmUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGludGVybmFsVG1wTWVtU3RvcmFnZUVuZ2luZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9pbnRlcm5hbFRtcE1lbVN0b3JhZ2VFbmdpbmU7XG4gIH1cblxuICAvLyBpcF9maWx0ZXIgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pcEZpbHRlcj86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBpcEZpbHRlcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRMaXN0QXR0cmlidXRlKCdpcF9maWx0ZXInKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlwRmlsdGVyKHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX2lwRmlsdGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SXBGaWx0ZXIoKSB7XG4gICAgdGhpcy5faXBGaWx0ZXIgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlwRmlsdGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lwRmlsdGVyO1xuICB9XG5cbiAgLy8gbG9uZ19xdWVyeV90aW1lIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbG9uZ1F1ZXJ5VGltZT86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgbG9uZ1F1ZXJ5VGltZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2xvbmdfcXVlcnlfdGltZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbG9uZ1F1ZXJ5VGltZSh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fbG9uZ1F1ZXJ5VGltZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldExvbmdRdWVyeVRpbWUoKSB7XG4gICAgdGhpcy5fbG9uZ1F1ZXJ5VGltZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbG9uZ1F1ZXJ5VGltZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9sb25nUXVlcnlUaW1lO1xuICB9XG5cbiAgLy8gbWF4X2FsbG93ZWRfcGFja2V0IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWF4QWxsb3dlZFBhY2tldD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgbWF4QWxsb3dlZFBhY2tldCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ21heF9hbGxvd2VkX3BhY2tldCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgbWF4QWxsb3dlZFBhY2tldCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fbWF4QWxsb3dlZFBhY2tldCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1heEFsbG93ZWRQYWNrZXQoKSB7XG4gICAgdGhpcy5fbWF4QWxsb3dlZFBhY2tldCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWF4QWxsb3dlZFBhY2tldElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tYXhBbGxvd2VkUGFja2V0O1xuICB9XG5cbiAgLy8gbWF4X2hlYXBfdGFibGVfc2l6ZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21heEhlYXBUYWJsZVNpemU/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IG1heEhlYXBUYWJsZVNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdtYXhfaGVhcF90YWJsZV9zaXplJyk7XG4gIH1cbiAgcHVibGljIHNldCBtYXhIZWFwVGFibGVTaXplKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9tYXhIZWFwVGFibGVTaXplID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TWF4SGVhcFRhYmxlU2l6ZSgpIHtcbiAgICB0aGlzLl9tYXhIZWFwVGFibGVTaXplID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtYXhIZWFwVGFibGVTaXplSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21heEhlYXBUYWJsZVNpemU7XG4gIH1cblxuICAvLyBuZXRfcmVhZF90aW1lb3V0IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbmV0UmVhZFRpbWVvdXQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IG5ldFJlYWRUaW1lb3V0KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnbmV0X3JlYWRfdGltZW91dCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgbmV0UmVhZFRpbWVvdXQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX25ldFJlYWRUaW1lb3V0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TmV0UmVhZFRpbWVvdXQoKSB7XG4gICAgdGhpcy5fbmV0UmVhZFRpbWVvdXQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG5ldFJlYWRUaW1lb3V0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX25ldFJlYWRUaW1lb3V0O1xuICB9XG5cbiAgLy8gbmV0X3dyaXRlX3RpbWVvdXQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9uZXRXcml0ZVRpbWVvdXQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IG5ldFdyaXRlVGltZW91dCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ25ldF93cml0ZV90aW1lb3V0Jyk7XG4gIH1cbiAgcHVibGljIHNldCBuZXRXcml0ZVRpbWVvdXQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX25ldFdyaXRlVGltZW91dCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE5ldFdyaXRlVGltZW91dCgpIHtcbiAgICB0aGlzLl9uZXRXcml0ZVRpbWVvdXQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG5ldFdyaXRlVGltZW91dElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9uZXRXcml0ZVRpbWVvdXQ7XG4gIH1cblxuICAvLyBwdWJsaWNfYWNjZXNzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3B1YmxpY0FjY2Vzcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgcHVibGljQWNjZXNzKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3B1YmxpY19hY2Nlc3MnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHB1YmxpY0FjY2Vzcyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcHVibGljQWNjZXNzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UHVibGljQWNjZXNzKCkge1xuICAgIHRoaXMuX3B1YmxpY0FjY2VzcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHVibGljQWNjZXNzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3B1YmxpY0FjY2VzcztcbiAgfVxuXG4gIC8vIHNsb3dfcXVlcnlfbG9nIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2xvd1F1ZXJ5TG9nPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBzbG93UXVlcnlMb2coKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnc2xvd19xdWVyeV9sb2cnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHNsb3dRdWVyeUxvZyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fc2xvd1F1ZXJ5TG9nID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U2xvd1F1ZXJ5TG9nKCkge1xuICAgIHRoaXMuX3Nsb3dRdWVyeUxvZyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc2xvd1F1ZXJ5TG9nSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Nsb3dRdWVyeUxvZztcbiAgfVxuXG4gIC8vIHNvcnRfYnVmZmVyX3NpemUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zb3J0QnVmZmVyU2l6ZT86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgc29ydEJ1ZmZlclNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdzb3J0X2J1ZmZlcl9zaXplJyk7XG4gIH1cbiAgcHVibGljIHNldCBzb3J0QnVmZmVyU2l6ZSh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fc29ydEJ1ZmZlclNpemUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTb3J0QnVmZmVyU2l6ZSgpIHtcbiAgICB0aGlzLl9zb3J0QnVmZmVyU2l6ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc29ydEJ1ZmZlclNpemVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc29ydEJ1ZmZlclNpemU7XG4gIH1cblxuICAvLyBzcWxfbW9kZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NxbE1vZGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHNxbE1vZGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzcWxfbW9kZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgc3FsTW9kZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc3FsTW9kZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNxbE1vZGUoKSB7XG4gICAgdGhpcy5fc3FsTW9kZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3FsTW9kZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zcWxNb2RlO1xuICB9XG5cbiAgLy8gc3FsX3JlcXVpcmVfcHJpbWFyeV9rZXkgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zcWxSZXF1aXJlUHJpbWFyeUtleT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgc3FsUmVxdWlyZVByaW1hcnlLZXkoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnc3FsX3JlcXVpcmVfcHJpbWFyeV9rZXknKTtcbiAgfVxuICBwdWJsaWMgc2V0IHNxbFJlcXVpcmVQcmltYXJ5S2V5KHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9zcWxSZXF1aXJlUHJpbWFyeUtleSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNxbFJlcXVpcmVQcmltYXJ5S2V5KCkge1xuICAgIHRoaXMuX3NxbFJlcXVpcmVQcmltYXJ5S2V5ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzcWxSZXF1aXJlUHJpbWFyeUtleUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zcWxSZXF1aXJlUHJpbWFyeUtleTtcbiAgfVxuXG4gIC8vIHRtcF90YWJsZV9zaXplIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdG1wVGFibGVTaXplPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCB0bXBUYWJsZVNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCd0bXBfdGFibGVfc2l6ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgdG1wVGFibGVTaXplKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl90bXBUYWJsZVNpemUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUbXBUYWJsZVNpemUoKSB7XG4gICAgdGhpcy5fdG1wVGFibGVTaXplID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0bXBUYWJsZVNpemVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdG1wVGFibGVTaXplO1xuICB9XG5cbiAgLy8gdmVyc2lvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3ZlcnNpb24/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd2ZXJzaW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCB2ZXJzaW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl92ZXJzaW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VmVyc2lvbigpIHtcbiAgICB0aGlzLl92ZXJzaW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB2ZXJzaW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZlcnNpb247XG4gIH1cblxuICAvLyB3YWl0X3RpbWVvdXQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF93YWl0VGltZW91dD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgd2FpdFRpbWVvdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCd3YWl0X3RpbWVvdXQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHdhaXRUaW1lb3V0KHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl93YWl0VGltZW91dCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFdhaXRUaW1lb3V0KCkge1xuICAgIHRoaXMuX3dhaXRUaW1lb3V0ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB3YWl0VGltZW91dElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl93YWl0VGltZW91dDtcbiAgfVxuXG4gIC8vIG1pZ3JhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9taWdyYXRpb24gPSBuZXcgTWFuYWdlZERhdGFiYXNlTXlzcWxQcm9wZXJ0aWVzTWlncmF0aW9uT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwibWlncmF0aW9uXCIpO1xuICBwdWJsaWMgZ2V0IG1pZ3JhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5fbWlncmF0aW9uO1xuICB9XG4gIHB1YmxpYyBwdXRNaWdyYXRpb24odmFsdWU6IE1hbmFnZWREYXRhYmFzZU15c3FsUHJvcGVydGllc01pZ3JhdGlvbikge1xuICAgIHRoaXMuX21pZ3JhdGlvbi5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TWlncmF0aW9uKCkge1xuICAgIHRoaXMuX21pZ3JhdGlvbi5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtaWdyYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWlncmF0aW9uLmludGVybmFsVmFsdWU7XG4gIH1cbn1cblxuLyoqXG4qIFJlcHJlc2VudHMgYSB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3VwY2xvdWQvci9tYW5hZ2VkX2RhdGFiYXNlX215c3FsIHVwY2xvdWRfbWFuYWdlZF9kYXRhYmFzZV9teXNxbH1cbiovXG5leHBvcnQgY2xhc3MgTWFuYWdlZERhdGFiYXNlTXlzcWwgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIFBST1BFUlRJRVNcbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSB0ZlJlc291cmNlVHlwZSA9IFwidXBjbG91ZF9tYW5hZ2VkX2RhdGFiYXNlX215c3FsXCI7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy91cGNsb3VkL3IvbWFuYWdlZF9kYXRhYmFzZV9teXNxbCB1cGNsb3VkX21hbmFnZWRfZGF0YWJhc2VfbXlzcWx9IFJlc291cmNlXG4gICpcbiAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdFxuICAqIEBwYXJhbSBpZCBUaGUgc2NvcGVkIGNvbnN0cnVjdCBJRC4gTXVzdCBiZSB1bmlxdWUgYW1vbmdzdCBzaWJsaW5ncyBpbiB0aGUgc2FtZSBzY29wZVxuICAqIEBwYXJhbSBvcHRpb25zIE1hbmFnZWREYXRhYmFzZU15c3FsQ29uZmlnXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IE1hbmFnZWREYXRhYmFzZU15c3FsQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICd1cGNsb3VkX21hbmFnZWRfZGF0YWJhc2VfbXlzcWwnLFxuICAgICAgdGVycmFmb3JtR2VuZXJhdG9yTWV0YWRhdGE6IHtcbiAgICAgICAgcHJvdmlkZXJOYW1lOiAndXBjbG91ZCcsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzIuNC4yJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uQ29uc3RyYWludDogJ34+IDIuNCdcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZVxuICAgIH0pO1xuICAgIHRoaXMuX21haW50ZW5hbmNlV2luZG93RG93ID0gY29uZmlnLm1haW50ZW5hbmNlV2luZG93RG93O1xuICAgIHRoaXMuX21haW50ZW5hbmNlV2luZG93VGltZSA9IGNvbmZpZy5tYWludGVuYW5jZVdpbmRvd1RpbWU7XG4gICAgdGhpcy5fbmFtZSA9IGNvbmZpZy5uYW1lO1xuICAgIHRoaXMuX3BsYW4gPSBjb25maWcucGxhbjtcbiAgICB0aGlzLl9wb3dlcmVkID0gY29uZmlnLnBvd2VyZWQ7XG4gICAgdGhpcy5fdGl0bGUgPSBjb25maWcudGl0bGU7XG4gICAgdGhpcy5fem9uZSA9IGNvbmZpZy56b25lO1xuICAgIHRoaXMuX3Byb3BlcnRpZXMuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5wcm9wZXJ0aWVzO1xuICB9XG5cbiAgLy8gPT09PT09PT09PVxuICAvLyBBVFRSSUJVVEVTXG4gIC8vID09PT09PT09PT1cblxuICAvLyBjb21wb25lbnRzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NvbXBvbmVudHMgPSBuZXcgTWFuYWdlZERhdGFiYXNlTXlzcWxDb21wb25lbnRzTGlzdCh0aGlzLCBcImNvbXBvbmVudHNcIiwgZmFsc2UpO1xuICBwdWJsaWMgZ2V0IGNvbXBvbmVudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NvbXBvbmVudHM7XG4gIH1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG5cbiAgLy8gbWFpbnRlbmFuY2Vfd2luZG93X2RvdyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21haW50ZW5hbmNlV2luZG93RG93Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBtYWludGVuYW5jZVdpbmRvd0RvdygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ21haW50ZW5hbmNlX3dpbmRvd19kb3cnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG1haW50ZW5hbmNlV2luZG93RG93KHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9tYWludGVuYW5jZVdpbmRvd0RvdyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1haW50ZW5hbmNlV2luZG93RG93KCkge1xuICAgIHRoaXMuX21haW50ZW5hbmNlV2luZG93RG93ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtYWludGVuYW5jZVdpbmRvd0Rvd0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tYWludGVuYW5jZVdpbmRvd0RvdztcbiAgfVxuXG4gIC8vIG1haW50ZW5hbmNlX3dpbmRvd190aW1lIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWFpbnRlbmFuY2VXaW5kb3dUaW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBtYWludGVuYW5jZVdpbmRvd1RpbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdtYWludGVuYW5jZV93aW5kb3dfdGltZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbWFpbnRlbmFuY2VXaW5kb3dUaW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9tYWludGVuYW5jZVdpbmRvd1RpbWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNYWludGVuYW5jZVdpbmRvd1RpbWUoKSB7XG4gICAgdGhpcy5fbWFpbnRlbmFuY2VXaW5kb3dUaW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtYWludGVuYW5jZVdpbmRvd1RpbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWFpbnRlbmFuY2VXaW5kb3dUaW1lO1xuICB9XG5cbiAgLy8gbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9uYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBuYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbmFtZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBuYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX25hbWU7XG4gIH1cblxuICAvLyBub2RlX3N0YXRlcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ub2RlU3RhdGVzID0gbmV3IE1hbmFnZWREYXRhYmFzZU15c3FsTm9kZVN0YXRlc0xpc3QodGhpcywgXCJub2RlX3N0YXRlc1wiLCBmYWxzZSk7XG4gIHB1YmxpYyBnZXQgbm9kZVN0YXRlcygpIHtcbiAgICByZXR1cm4gdGhpcy5fbm9kZVN0YXRlcztcbiAgfVxuXG4gIC8vIHBsYW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfcGxhbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcGxhbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BsYW4nKTtcbiAgfVxuICBwdWJsaWMgc2V0IHBsYW4odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3BsYW4gPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcGxhbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wbGFuO1xuICB9XG5cbiAgLy8gcG93ZXJlZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wb3dlcmVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBwb3dlcmVkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3Bvd2VyZWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHBvd2VyZWQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3Bvd2VyZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQb3dlcmVkKCkge1xuICAgIHRoaXMuX3Bvd2VyZWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBvd2VyZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcG93ZXJlZDtcbiAgfVxuXG4gIC8vIHByaW1hcnlfZGF0YWJhc2UgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBwcmltYXJ5RGF0YWJhc2UoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdwcmltYXJ5X2RhdGFiYXNlJyk7XG4gIH1cblxuICAvLyBzZXJ2aWNlX2hvc3QgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBzZXJ2aWNlSG9zdCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3NlcnZpY2VfaG9zdCcpO1xuICB9XG5cbiAgLy8gc2VydmljZV9wYXNzd29yZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHNlcnZpY2VQYXNzd29yZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3NlcnZpY2VfcGFzc3dvcmQnKTtcbiAgfVxuXG4gIC8vIHNlcnZpY2VfcG9ydCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHNlcnZpY2VQb3J0KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnc2VydmljZV9wb3J0Jyk7XG4gIH1cblxuICAvLyBzZXJ2aWNlX3VyaSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHNlcnZpY2VVcmkoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzZXJ2aWNlX3VyaScpO1xuICB9XG5cbiAgLy8gc2VydmljZV91c2VybmFtZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHNlcnZpY2VVc2VybmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3NlcnZpY2VfdXNlcm5hbWUnKTtcbiAgfVxuXG4gIC8vIHN0YXRlIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgc3RhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzdGF0ZScpO1xuICB9XG5cbiAgLy8gdGl0bGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGl0bGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHRpdGxlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndGl0bGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRpdGxlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl90aXRsZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRpdGxlKCkge1xuICAgIHRoaXMuX3RpdGxlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0aXRsZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90aXRsZTtcbiAgfVxuXG4gIC8vIHR5cGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCB0eXBlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndHlwZScpO1xuICB9XG5cbiAgLy8gem9uZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF96b25lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB6b25lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnem9uZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgem9uZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fem9uZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB6b25lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3pvbmU7XG4gIH1cblxuICAvLyBwcm9wZXJ0aWVzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Byb3BlcnRpZXMgPSBuZXcgTWFuYWdlZERhdGFiYXNlTXlzcWxQcm9wZXJ0aWVzT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwicHJvcGVydGllc1wiKTtcbiAgcHVibGljIGdldCBwcm9wZXJ0aWVzKCkge1xuICAgIHJldHVybiB0aGlzLl9wcm9wZXJ0aWVzO1xuICB9XG4gIHB1YmxpYyBwdXRQcm9wZXJ0aWVzKHZhbHVlOiBNYW5hZ2VkRGF0YWJhc2VNeXNxbFByb3BlcnRpZXMpIHtcbiAgICB0aGlzLl9wcm9wZXJ0aWVzLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQcm9wZXJ0aWVzKCkge1xuICAgIHRoaXMuX3Byb3BlcnRpZXMuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHJvcGVydGllc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wcm9wZXJ0aWVzLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG1haW50ZW5hbmNlX3dpbmRvd19kb3c6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX21haW50ZW5hbmNlV2luZG93RG93KSxcbiAgICAgIG1haW50ZW5hbmNlX3dpbmRvd190aW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9tYWludGVuYW5jZVdpbmRvd1RpbWUpLFxuICAgICAgbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbmFtZSksXG4gICAgICBwbGFuOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9wbGFuKSxcbiAgICAgIHBvd2VyZWQ6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9wb3dlcmVkKSxcbiAgICAgIHRpdGxlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl90aXRsZSksXG4gICAgICB6b25lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl96b25lKSxcbiAgICAgIHByb3BlcnRpZXM6IG1hbmFnZWREYXRhYmFzZU15c3FsUHJvcGVydGllc1RvVGVycmFmb3JtKHRoaXMuX3Byb3BlcnRpZXMuaW50ZXJuYWxWYWx1ZSksXG4gICAgfTtcbiAgfVxufVxuIl19