import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RouterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the router
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/router#name Router#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/router upcloud_router}
*/
export declare class Router extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_router";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/router upcloud_router} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RouterConfig
    */
    constructor(scope: Construct, id: string, config: RouterConfig);
    get attachedNetworks(): string[];
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=router.d.ts.map