# Generated by Django 3.2.4 on 2022-03-23 03:57

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('custom', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Citizen',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20, verbose_name='Cidadania Nasaun')),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
            ],
            options={
                'verbose_name_plural': 'Dadus Custom Ba Sidadaun',
            },
        ),
        migrations.CreateModel(
            name='Deficient',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Kondisaun Fiziku')),
            ],
            options={
                'verbose_name_plural': 'Dadus Custom Ba Difisiente',
            },
        ),
        migrations.CreateModel(
            name='Family',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('id_family', models.BigIntegerField(blank=True, null=True, verbose_name='Nú. Kartaun  Fixa FamÍlia')),
                ('data_registu', models.DateField(blank=True, null=True, verbose_name='Data Rejistu')),
                ('fdescription', models.TextField(verbose_name='Observasaun')),
                ('date_created', models.DateField()),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
                ('administrativepost', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('aldeia', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.aldeia')),
                ('municipality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
            options={
                'verbose_name_plural': 'Dadus Custom Ba FamÍlia',
            },
        ),
        migrations.CreateModel(
            name='FamilyPosition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Pozisaun iha Família')),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
            ],
            options={
                'verbose_name_plural': 'Dadus Custom Ba Pozisaun Família',
            },
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Naran Lingua')),
                ('type_language', models.CharField(blank=True, choices=[('o', 'Origen'), ('i', 'International')], max_length=1, null=True, verbose_name='Tipu Lingua')),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
            ],
            options={
                'verbose_name_plural': 'Dadus Custom Ba Lingua',
            },
        ),
        migrations.CreateModel(
            name='Level_Education',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Habilitasaun Literariu')),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
            ],
            options={
                'verbose_name_plural': 'Dadus Custom Ba Level Edukasaun',
            },
        ),
        migrations.CreateModel(
            name='Population',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('citizenp', models.CharField(blank=True, choices=[('a', 'Adkeridu'), ('o', 'Original')], max_length=15, null=True, verbose_name='Sidadania')),
                ('date_register', models.DateField(blank=True, null=True, verbose_name='Data Rejistu')),
                ('unique_id', models.CharField(blank=True, max_length=50, null=True, verbose_name='Id Uniku / Uza Ba test Husik Mamuk Deit')),
                ('name', models.CharField(max_length=100, verbose_name='Naran Kompletu/Alias')),
                ('date_of_bird', models.DateField(verbose_name='Data Moris')),
                ('place_of_bird', models.CharField(max_length=100, verbose_name='Fatin Moris')),
                ('gender', models.CharField(choices=[('m', 'Mane'), ('f', 'Feto'), ('s', 'Seluk')], max_length=4, verbose_name='Seksu')),
                ('marital_status', models.CharField(blank=True, choices=[('s', 'Klosan'), ('c', 'Kaben Nain'), ('d', 'Fahe Malu'), ('f', 'Faluk')], max_length=15, null=True, verbose_name='Estadu Civil')),
                ('language', models.CharField(blank=True, max_length=50, null=True)),
                ('readalatin', models.CharField(blank=True, choices=[('s', 'Sim'), ('l', 'Lae')], max_length=15, null=True, verbose_name='Hatene Le Alfabetu Latin ?')),
                ('readaarabe', models.CharField(blank=True, choices=[('s', 'Sim'), ('l', 'Lae')], max_length=15, null=True, verbose_name='Hatene Le Alfabetu Arabe ?')),
                ('readachina', models.CharField(blank=True, choices=[('s', 'Sim'), ('l', 'Lae')], max_length=15, null=True, verbose_name='Hatene Le Alfabetu China ?')),
                ('nu_bi', models.CharField(blank=True, max_length=25, null=True, verbose_name='Nú. Kartaun Identidade (BI)')),
                ('phone', models.CharField(blank=True, max_length=25, null=True, verbose_name='Nú. Telefone')),
                ('nu_e', models.CharField(blank=True, max_length=25, null=True, verbose_name='Nú. Kartaun Eleitoral')),
                ('nu_p', models.CharField(blank=True, max_length=50, null=True, verbose_name='Nú. Pasaporte')),
                ('id_family', models.CharField(blank=True, max_length=20, null=True, verbose_name='Nú. Kartaun  Fixa Família')),
                ('nationality', models.CharField(blank=True, max_length=1, null=True)),
                ('descriptionp', models.TextField(blank=True, null=True, verbose_name='Obs')),
                ('imagen', models.ImageField(blank=True, default='img/population/imagenlaiha.png', null=True, upload_to='img/population/', verbose_name='Imaen / Uza Ba test Husik Mamuk Deit')),
                ('status_datap', models.CharField(blank=True, choices=[('ma', 'mate'), ('mu', 'muda'), ('ac', 'activu')], max_length=2, null=True)),
                ('vulnerable', models.BooleanField(blank=True, choices=[(True, 'Lae'), (False, 'Sim')], default=False, null=True, verbose_name='Pesoa Vulnerável ...?')),
                ('type_data', models.CharField(choices=[('p', 'Population'), ('f', 'Family'), ('m', 'migration'), ('te', 'Populasaun Temporariu'), ('mo', 'Bebe Moris'), ('test', 'Test')], max_length=15, verbose_name='Tipu Dados')),
                ('date_created', models.DateField()),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
                ('administrativepost', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('aldeia', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.aldeia', verbose_name='Hela Fatin / Aldeia ')),
                ('deficient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.deficient', verbose_name='Kondisaun')),
                ('level_education', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='population.level_education', verbose_name='Habilitasaun Literaria ikus liu')),
                ('municipality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
            ],
            options={
                'verbose_name_plural': 'Livru Rejistu Populasaun',
            },
        ),
        migrations.CreateModel(
            name='Profession',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Profisaun Servisu')),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
            ],
            options={
                'verbose_name_plural': 'Dadus Custom Ba Profisaun',
            },
        ),
        migrations.CreateModel(
            name='Religion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Relijiun')),
                ('hashed', models.CharField(blank=True, max_length=32, null=True)),
            ],
            options={
                'verbose_name_plural': 'Dadus Custom Ba Relijiaun',
            },
        ),
        migrations.CreateModel(
            name='Temporary',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('from_place', models.CharField(blank=True, max_length=50, null=True, verbose_name='Mai Husi')),
                ('purpose', models.TextField(blank=True, null=True, verbose_name='Intensaun Mai')),
                ('residence', models.TextField(blank=True, null=True, verbose_name='Naran no hela fatin Visitor')),
                ('date_arive', models.DateField(blank=True, null=True, verbose_name='Data Mai')),
                ('date_return', models.DateField(blank=True, null=True, verbose_name='Data Fila')),
                ('descriptionte', models.TextField(blank=True, null=True, verbose_name='Observasaun')),
                ('date_created', models.DateField()),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
                ('cidadaunt', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='population.citizen', verbose_name='Cidadania')),
                ('population', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.population', verbose_name='Identidade Populasaun')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
            options={
                'verbose_name_plural': 'Dadus Populasaun Temporáriu',
            },
        ),
        migrations.AddField(
            model_name='population',
            name='profession',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='population.profession', verbose_name='Profisaun'),
        ),
        migrations.AddField(
            model_name='population',
            name='religion',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='population.religion', verbose_name='Relijiaun'),
        ),
        migrations.AddField(
            model_name='population',
            name='user_created',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='population',
            name='village',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='custom.village', verbose_name='Suku'),
        ),
        migrations.CreateModel(
            name='Migrationout',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('to_nation', models.CharField(blank=True, max_length=100, null=True, verbose_name="Muda Ba Nasaun Ne'ebe")),
                ('date_migration', models.DateField(blank=True, null=True, verbose_name='Data Muda Sai')),
                ('descriptionmo', models.TextField(blank=True, null=True, verbose_name='Observasaun')),
                ('date_created', models.DateField()),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
                ('cidadaunmo', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='population.citizen', verbose_name="Muda Ba Ne'ebe ..? ")),
                ('population', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.population')),
                ('to_aldeia', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.aldeia', verbose_name="Muda ba Aldeia ne'ebe")),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
            options={
                'verbose_name_plural': 'Dadus Populasaun Mudansa',
            },
        ),
        migrations.CreateModel(
            name='Migration',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('migration_accept', models.BooleanField(default=False)),
                ('user_accept', models.CharField(blank=True, max_length=5, null=True)),
                ('from_nation', models.CharField(blank=True, max_length=100, null=True, verbose_name='Nasionalidade')),
                ('date_migration', models.DateField(blank=True, null=True, verbose_name='Data Muda mai iha suku')),
                ('descriptionm', models.TextField(blank=True, null=True, verbose_name='Observasaun')),
                ('date_created', models.DateField()),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
                ('administrativepost', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost', verbose_name="Mai husi Postu Administrativu ne'ebe")),
                ('cidadaunm', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='population.citizen', verbose_name='Nasionalidade')),
                ('from_aldeia', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.aldeia', verbose_name="Mai husi aldeia ne'ebe")),
                ('municipality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality', verbose_name="Mai husi Munisípiu/Rejiaun ne'ebe")),
                ('population', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.population')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.village', verbose_name="Mai husi Suku ne'ebe")),
            ],
            options={
                'verbose_name_plural': 'Dadus Migrasaun Populasaun',
            },
        ),
        migrations.CreateModel(
            name='FamilyCardOnline',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cordinate', models.TextField(default=True, verbose_name='Ativu')),
                ('status', models.BooleanField(default=True, verbose_name='Ativu')),
                ('date_created', models.DateField()),
                ('user_created', models.CharField(blank=True, max_length=12, null=True)),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
                ('administrativepost', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.administrativepost')),
                ('family', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.family')),
                ('municipality', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='custom.municipality')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='custom.village', verbose_name='Suku')),
            ],
            options={
                'verbose_name_plural': 'Dadus Kartaun Família Online',
            },
        ),
        migrations.CreateModel(
            name='DetailFamily',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('status', models.BooleanField(default=True, verbose_name='Ativu')),
                ('date_created', models.DateField()),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
                ('family', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.family')),
                ('family_position', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.familyposition', verbose_name='Pozisaun iha FamÍlia')),
                ('population', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.population', verbose_name='Hili Populasaun Iha Suku')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Dadus Detail FamÍlia',
            },
        ),
        migrations.CreateModel(
            name='Death',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('date', models.DateField(verbose_name='Data')),
                ('descriptiond', models.TextField(null=True, verbose_name='Observasaun')),
                ('date_created', models.DateField()),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
                ('population', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.population')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
            options={
                'verbose_name_plural': 'Dadus Populsaun Mate',
            },
        ),
        migrations.CreateModel(
            name='ChangeFamily',
            fields=[
                ('id', models.BigIntegerField(primary_key=True, serialize=False)),
                ('date_change', models.DateField(blank=True, null=True, verbose_name='Data Sai Husi Família')),
                ('descriptioncf', models.TextField(blank=True, null=True, verbose_name='Observasaun')),
                ('date_created', models.DateField()),
                ('hashed', models.CharField(blank=True, max_length=40, null=True)),
                ('familymember', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='population.detailfamily')),
                ('user_created', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('village', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='custom.village')),
            ],
            options={
                'verbose_name_plural': 'Dadus Mudansa Família',
            },
        ),
    ]
