/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl;

import be.fedict.eid.applet.service.Address;
import be.fedict.eid.applet.service.EIdData;
import be.fedict.eid.applet.service.Identity;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PdfGenerator {
    private static final Log LOG = LogFactory.getLog(PdfGenerator.class);

    private com.lowagie.text.Image createBarcodeImage(String rrn, String cardNumber) throws IOException, BadElementException {
        if (null == rrn || rrn.length() != 11 || null == cardNumber || cardNumber.length() < 9) {
            throw new IllegalArgumentException("Missing or invalid length for RRN or Card Number");
        }
        String lastDigits = cardNumber.substring(cardNumber.length() - 9);
        String code = rrn + lastDigits;
        Barcode128 barcode = new Barcode128();
        barcode.setCodeType(199);
        barcode.setCode(code);
        barcode.setFont(null);
        return com.lowagie.text.Image.getInstance((Image)barcode.createAwtImage(Color.BLACK, Color.WHITE), null, (boolean)true);
    }

    private com.lowagie.text.Image createImageFromPhoto(byte[] photoData) throws IOException, BadElementException {
        com.lowagie.text.Image image = com.lowagie.text.Image.getInstance((byte[])photoData);
        image.setAlt("Photo");
        image.setAlignment(1);
        image.setSpacingAfter(20.0f);
        return image;
    }

    private void setDocumentMetadata(Document doc, String firstName, String lastName) {
        doc.addTitle(firstName + " " + lastName);
        doc.addSubject("Data from the eID card");
        doc.addCreator("Belgian eID applet");
        doc.addProducer();
        doc.addCreationDate();
    }

    public byte[] generatePdf(EIdData eIdData) throws DocumentException {
        Document document = new Document();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
        document.open();
        Paragraph titleParagraph = new Paragraph("eID Identity Data");
        titleParagraph.setAlignment(1);
        Font titleFont = titleParagraph.getFont();
        titleFont.setSize(20.0f);
        titleFont.setStyle(1);
        titleParagraph.setSpacingAfter(20.0f);
        document.add((Element)titleParagraph);
        if (null != eIdData && null != eIdData.getIdentity()) {
            if (null != eIdData.getPhoto()) {
                try {
                    com.lowagie.text.Image image = this.createImageFromPhoto(eIdData.getPhoto());
                    document.add((Element)image);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error getting photo: " + e.getMessage()));
                }
                Identity identity = eIdData.getIdentity();
                this.setDocumentMetadata(document, identity.firstName, identity.name);
                writer.createXmpMetadata();
                PdfPTable table = new PdfPTable(2);
                table.getDefaultCell().setBorder(0);
                table.addCell("Name");
                table.addCell(identity.name);
                table.addCell("First name");
                String firstName = identity.firstName;
                if (null != identity.middleName) {
                    firstName = firstName + " " + identity.middleName;
                }
                table.addCell(firstName);
                table.addCell("Nationality");
                table.addCell(identity.nationality);
                table.addCell("National Registration Number");
                table.addCell(identity.nationalNumber);
                table.addCell("Gender");
                table.addCell(identity.gender.toString());
                table.addCell("Date of birth");
                SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
                table.addCell(formatter.format(identity.dateOfBirth.getTime()));
                table.addCell("Place of birth");
                table.addCell(identity.placeOfBirth);
                if (null != eIdData.getAddress()) {
                    Address address = eIdData.getAddress();
                    table.addCell("Address");
                    PdfPCell cell = new PdfPCell();
                    cell.setBorder(0);
                    cell.addElement((Element)new Paragraph(address.streetAndNumber));
                    cell.addElement((Element)new Paragraph(address.zip + " " + address.municipality));
                    table.addCell(cell);
                }
                document.add((Element)table);
            } else {
                document.add((Element)new Paragraph("No eID identity data available."));
            }
        }
        document.close();
        return baos.toByteArray();
    }
}

