# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/70_imgs.ipynb.

# %% auto 0
__all__ = ['Img', 'Image', 'ImageLike', 'ImageSize', 'ImgSize', 'Video', 'VideoCapture', 'VidCap', 'Pnt', 'Point', 'BBox',
           'BoundingBox', 'RGB', 'RGBA', 'Color']

# %% ../nbs/70_imgs.ipynb 6
import inspect
from numbers import Number

# %% ../nbs/70_imgs.ipynb 8
from typing import (Union, Tuple, TypeAlias, ForwardRef)

# %% ../nbs/70_imgs.ipynb 11
try:
    from cv2 import VideoCapture as vidcap
except ImportError:
    vidcap = ForwardRef('cv2.VideoCapture', module='cv2', is_class=True)

# %% ../nbs/70_imgs.ipynb 13
try:
    from PIL.Image import Image as image
except ImportError:
    image = ForwardRef('PIL.Image.Image', module='PIL.Image', is_class=True)

# %% ../nbs/70_imgs.ipynb 15
#| export


# %% ../nbs/70_imgs.ipynb 17
from .data import NPArray
from .nums import Numeric

# %% ../nbs/70_imgs.ipynb 20
Img: TypeAlias = image
Image: TypeAlias = image
ImageLike: TypeAlias = Union[NPArray, Image]

ImageSize: TypeAlias = Tuple[int, int]
ImgSize: TypeAlias = ImageSize

# %% ../nbs/70_imgs.ipynb 22
Video: TypeAlias = vidcap
VideoCapture: TypeAlias = Video
VidCap: TypeAlias = Video

# %% ../nbs/70_imgs.ipynb 24
Pnt: TypeAlias = Tuple[Numeric, Numeric]
Point: TypeAlias = Pnt

BBox: TypeAlias = Tuple[Pnt, Pnt]
BoundingBox: TypeAlias = BBox

# %% ../nbs/70_imgs.ipynb 26
RGB: TypeAlias = Tuple[int, int, int]
RGBA: TypeAlias = Tuple[int, int, int, int]

Color: TypeAlias = Union[RGB, RGBA]
