# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/110_pdty.ipynb.

# %% auto 0
__all__ = ['Idx', 'Index', 'CIdx', 'CIndex', 'CatIndex', 'CategoricalIndex', 'BIdx', 'BooleanIndex', 'Series', 'DFrame',
           'DataFrame', 'DataFrames', 'GroupKey', 'BoolIndex', 'IndexLike', 'SeriesLike']

# %% ../nbs/110_pdty.ipynb 6
#| export


# %% ../nbs/110_pdty.ipynb 8
from typing import TypeAlias, List, Union, Iterable, List

# %% ../nbs/110_pdty.ipynb 11
try:
    
    import pandas as pd
    index = pd.Index
    cindex = pd.CategoricalIndex
    
    dframe = pd.DataFrame
    series = pd.Series

except ImportError:
    
    # Define a placeholder type if pandas is not installed
    index = 'pd.Index'    
    cindex = 'pd.CategoricalIndex'
    
    dframe = 'pd.DataFrame'
    series = 'pd.Series'

# %% ../nbs/110_pdty.ipynb 13
#| export


# %% ../nbs/110_pdty.ipynb 15
from ptyp import Alias
from .bool import Boolish, Bool01
from .nums import Numbers
from .tens import Tensor
from .npty import ndarray

# %% ../nbs/110_pdty.ipynb 18
Idx: TypeAlias = index
Index: TypeAlias = index


CIdx: TypeAlias = cindex
CIndex: TypeAlias = cindex
CatIndex: TypeAlias = cindex
CategoricalIndex: TypeAlias = cindex


# %% ../nbs/110_pdty.ipynb 19
@Alias(index, ndarray, list, attrs=dict(dtype=bool | Bool01))
class BoolIndex: ...

BIdx: TypeAlias = BoolIndex
BooleanIndex: TypeAlias = BoolIndex

# %% ../nbs/110_pdty.ipynb 20
Series: TypeAlias = series

DFrame: TypeAlias = dframe
DataFrame: TypeAlias = dframe
DataFrames: TypeAlias = List[DataFrame]

# %% ../nbs/110_pdty.ipynb 22
# IndexLike: TypeAlias = Union[Numbers, List[Boolish], Index]
@Alias(index, cindex, ndarray, BoolIndex, list, Numbers)
class IndexLike: ...

@Alias(series, ndarray, list, IndexLike)
class SeriesLike: ...

# SeriesLike: TypeAlias = Union[list, Series, ndarray, Tensor, IndexLike]
# IterLike: TypeAlias = Union[Iterable, SeriesLike, IndexLike]

# %% ../nbs/110_pdty.ipynb 23
GroupKey: TypeAlias = Union[str, int, float, tuple] # key for pandas groupby
