"""
astra auth plugin for HTTPie.
"""
import sys

from httpie.plugins import AuthPlugin
from configparser import ConfigParser
from requests.auth import AuthBase
from requests import Request, Session
from datetime import datetime
import os, uuid, requests, json
import sys, os
import re
import argparse
import configparser
from os.path import expanduser


__version__ = '1.0.0'
__author__ = 'Kirsten Hunter'
__licence__ = 'Apache 2.0'

class AstraAuth(AuthBase):
    def __init__(self, *args):
        return

    def __call__(self, r):
        return r

class HTTPieAstraAuth(AstraAuth):
    def __init__(self, USERNAME, ASTRA_DB_ID, ASTRA_DB_REGION, ASTRA_DB_USERNAME, ASTRA_DB_PASSWORD, ASTRA_DB_KEYSPACE, ASTRA_DB_TOKEN, ASTRA_DB_TOKEN_TIME):
        self.username = USERNAME,
        self.astra_db_id = ASTRA_DB_ID
        self.astra_db_region = ASTRA_DB_REGION
        self.astra_db_username = ASTRA_DB_USERNAME
        self.astra_db_password = ASTRA_DB_PASSWORD
        self.astra_db_keyspace = ASTRA_DB_KEYSPACE
        self.astra_db_token = ASTRA_DB_TOKEN
        self.astra_db_token_time = ASTRA_DB_TOKEN_TIME
        self.uuid = str(uuid.uuid4())

        return super(HTTPieAstraAuth, self).__init__()
                

    def __call__(self, r):
        now = datetime.timestamp(datetime.now())
        
        if (float(now)-float(self.astra_db_token_time)/(60)) > 30:
            headers = {
                'Content-Type': 'application/json',
                'Accept': '*/*'
            }
            payload = {'username':self.astra_db_username, 'password':self.astra_db_password}
            s = Session()
            resp = s.post("https://%s-%s.apps.astra.datastax.com/api/rest/v1/auth" % (self.astra_db_id, self.astra_db_region), 
                            data=json.dumps(payload), 
                            headers=headers)
            token = resp.json()['authToken']

            filename = os.path.expanduser("~/.astrarc")
            
            with open (filename, "r+") as myfile:
                data=myfile.read().replace('default','----DEFAULT----')
                myfile.close()
            with open (filename, "w") as myfile:
                myfile.write(data)
                myfile.close()

            rc = ConfigParser()
            rc.optionxform = str
            rc.read(filename)
            configfile = open(filename,'w')
            section = ''.join(self.username).replace('default','----DEFAULT----')
            rc.set(section, "ASTRA_DB_TOKEN", token)
            rc.set(section, "ASTRA_DB_TOKEN_TIME", str(datetime.timestamp(datetime.now())))
            self.astra_db_token = token
            with open(filename, 'w') as configfile:
	            rc.write(configfile)

            configfile.close()

            # Undo the ConfigParser work around
            with open (filename, "r") as myfile:
                data=myfile.read().replace('----DEFAULT----','default')
                myfile.close()
            with open (filename, "w") as myfile:
                myfile.write(data)
                myfile.close()
        # Now that we've got our token we can make the call
        r = super(HTTPieAstraAuth, self).__call__(r)
        r.url = r.url.replace("http:","https:")
        r.headers['Content-Type'] = "application/json"
        r.headers['x-cassandra-token'] = self.astra_db_token
        r.headers['x-cassandra-request-id'] = self.uuid
        r.url = r.url.replace("localhost","%s-%s.apps.astra.datastax.com/api" % (self.astra_db_id, self.astra_db_region))
        if ('KS') in r.url:
            r.url = r.url.replace('KS', self.astra_db_keyspace)
        
        if "json" in json.dumps(r.body):
            json_body = json.loads(r.body)
            if "json" in json_body:
                json_body = json_body["json"]
            r.body = json.dumps(json_body)
        if (r.body):
            r.body = r.body.replace("UUID", self.uuid)
        
        
        return r
 
class AstraPlugin(AuthPlugin):
    name = 'Astra auth'
    auth_type = 'astra'
    description = ''

    def setCreds(self, username):
            fields = ['ASTRA_DB_REGION','ASTRA_DB_ID','ASTRA_DB_USERNAME','ASTRA_DB_PASSWORD','ASTRA_DB_KEYSPACE']

            section_name = username
            section_name_pretty = username
            if section_name.lower() == "default":
                section_name = "----DEFAULT----"
                section_name_pretty = "default"
            else:
                section_name = "----DEFAULT----"
                section_name_pretty = "default"

            print ("Datastax Astra Credentials")
            print
            print ("This script will create or update a configuration section")
            print ( "in the local ~/.astrarc credential file.")
            print ("Would you like to copy/paste the configuration block from the website (1)")
            print ("or fill in the values individually(2)?")

            print ("Please make a selection (1/2):")
            choice = input("Input type:").strip()
            value = {}

            value['ASTRA_DB_TOKEN']= "0"
            value['ASTRA_DB_TOKEN_TIME'] = "0"
            fields.append('ASTRA_DB_TOKEN')
            fields.append('ASTRA_DB_TOKEN_TIME')
  
            if (choice == "2"):
                print ("Please fill in the following fields for your database:")
                print
                for field in fields:
                    value[field] = input(field + ": ")

            if (choice == "1"):
                err_msg = "\WARNING: No section named '%s' was found in your .astrarc file\n" % username
                err_msg += "Let's grab your configuration from the Astra Website.\n"
                err_msg += "Please log into your Astra instance at https://astra.datastax.com,\n"
                err_msg += "and select the database you want to use.\n\n"
                err_msg += "Now, click on the dark blue 'Connect' button under 'Settings'\n"
                err_msg += "On the lower right, there is a black box with 'export' commands.\n"
                err_msg += " Copy that whole block.\n"
                err_msg += "Paste the content below, then CTRL-D or CMD-D:\n"
                sys.stderr.write(err_msg)
                while True:
                    try:
                        line = input("")
                    except EOFError:                    
                        break
                    line = line.replace('export ', '')
                    key, contents = line.upper().split("=")
                    value[key] = contents.lower()
                
                print ("Please enter your database password:")
                line = input("")
                value["ASTRA_DB_PASSWORD"] = line
        
            print (value)
            # Process the original .astrarc file
            home = expanduser("~")
            origConfig = configparser.ConfigParser()
            filename = "%s/.astrarc" % home

            # If this is a new file, create it
            if not os.path.isfile(filename):
                print ("+++ Creating new credentials file: %s" % filename)
                open(filename, 'a+').close()
            else:
                print ("+++ Found credentials file: %s" % filename)
                
            # Recommend default section name if not present
            origConfig.read(filename)

            if section_name_pretty in origConfig.sections():
                print (">>> Replacing section: %s" % section_name_pretty)
                replace_section = True
            else:
                print ("+++ Creating section: %s" % section_name_pretty)
                replace_section = False

            # Make sure that this is ok ~ any key to continue
            try:
                input("\nPress Enter to continue or ctrl-c to exit.")
            except SyntaxError:
                pass

            # We need a line for the output to look nice
            print 

            # If we have a 'default' section hide it from ConfigParser
            print ("Using {section_name_pretty}")
            with open (filename, "r+") as myfile:
                data=myfile.read().replace('default','----DEFAULT----')
                myfile.close()
            with open (filename, "w") as myfile:
                myfile.write(data)
                myfile.close()

            # Open the ~/.astrarc file for writing
            Config = configparser.ConfigParser()
            Config.optionxform = str
            Config.read(filename)
            configfile = open(filename,'w')

            # Remove a section that is being replaced
            if replace_section: 
                print ("--- Removing section: %s" % section_name)
                Config.remove_section(section_name)

            # Add the new section
            print ("+++ Adding section: %s" % section_name)
            Config.add_section(section_name)
            for field in fields:
                Config[section_name][field] = value[field]

            with open(filename, 'w') as configfile:
                Config.write(configfile)

            configfile.close()

            # Undo the ConfigParser work around
            with open (filename, "r") as myfile:
                data=myfile.read().replace('----DEFAULT----','default')
                myfile.close()
            with open (filename, "w") as myfile:
                myfile.write(data)
                myfile.close()

            print ("\nDone. Please verify your credentials in ~/.astrarc")
            print	

            auth = HTTPieAstraAuth(
                USERNAME = username,
                ASTRA_DB_ID=value["ASTRA_DB_ID"],
                ASTRA_DB_REGION=value["ASTRA_DB_REGION"],
                ASTRA_DB_USERNAME=value["ASTRA_DB_USERNAME"],
                ASTRA_DB_PASSWORD=value["ASTRA_DB_PASSWORD"],
                ASTRA_DB_KEYSPACE=value["ASTRA_DB_KEYSPACE"],            )
            return auth
 
    def get_auth(self, username, password):
        filename = os.path.expanduser("~/.astrarc")
        rc = ConfigParser(allow_no_value=True)
        rc.read(filename)
        
        if not rc.has_section(username):
            return self.setCreds(username)

        auth = HTTPieAstraAuth(
            USERNAME = username,
            ASTRA_DB_ID=rc.get(username, 'astra_db_id'),
            ASTRA_DB_REGION=rc.get(username, 'astra_db_region'),
            ASTRA_DB_USERNAME=rc.get(username, 'astra_db_username'),
            ASTRA_DB_PASSWORD=rc.get(username, 'astra_db_password'),
            ASTRA_DB_KEYSPACE=rc.get(username, 'astra_db_keyspace'),
            ASTRA_DB_TOKEN=rc.get(username, 'astra_db_token'),
            ASTRA_DB_TOKEN_TIME=rc.get(username, 'astra_db_token_time')
        )
        return auth

    def __call__(self, r):
        

        return r


