import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
/**
 * Represents a GitHub repository.
 *
 * @stability stable
 */
export interface RepositoryConfig {
    /**
     * The owner of the repository.
     *
     * @stability stable
     */
    readonly owner: string;
    /**
     * The name of the repository.
     *
     * @stability stable
     */
    readonly repo: string;
    /**
     * The sub prefix string from the JWT token used to be validated by AWS.
     *
     * Appended after `repo:${owner}/${repo}:`
     * in an IAM role trust relationship. The default value '*' indicates all branches and all tags from this repo.
     *
     * Example:
     * repo:octo-org/octo-repo:ref:refs/heads/demo-branch - only allowed from `demo-branch`
     * repo:octo-org/octo-repo:ref:refs/tags/demo-tag - only allowed from `demo-tag`.
     * repo:octo-org/octo-repo:pull_request - only allowed from the `pull_request` event.
     * repo:octo-org/octo-repo:environment:Production - only allowd from `Production` environment name.
     *
     * @default '*'
     * @see https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/about-security-hardening-with-openid-connect#configuring-the-oidc-trust-with-the-cloud
     * @stability stable
     */
    readonly filter?: string;
}
/**
 * The Github OpenID Connect Provider.
 *
 * @stability stable
 */
export declare class Provider extends cdk.Construct {
    /**
     * The issuer of the OIDC provider claim or the "provider URL".
     *
     * @see https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/configuring-openid-connect-in-amazon-web-services#adding-the-identity-provider-to-aws
     * @stability stable
     */
    static readonly issuer: string;
    /**
     * The thumbprint of the OIDC provider claim.
     *
     * @see https://github.com/aws-actions/configure-aws-credentials
     * @stability stable
     */
    static readonly thumbprint: string;
    /**
     * @stability stable
     */
    readonly provider: iam.IOpenIdConnectProvider;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
    /**
     *
     * @param repo a list of repositories
     * @returns a list of subjects
     */
    private formatSubject;
    /**
     * Create an IAM role for the provider.
     *
     * @param repo a list of repositories using this role.
     * @param roleProps properties to create this role.
     * @returns an IAM role
     * @stability stable
     */
    createRole(id: string, repo: RepositoryConfig[], roleProps?: iam.RoleProps): iam.Role;
}
