"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Provider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * The Github OpenID Connect Provider.
 *
 * @stability stable
 */
class Provider extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id);
        this.provider = new iam.OpenIdConnectProvider(this, 'Provider', {
            url: `https://${Provider.issuer}`,
            clientIds: ['sts.amazonaws.com'],
            thumbprints: [`${Provider.thumbprint}`],
        });
    }
    /**
     *
     * @param repo a list of repositories
     * @returns a list of subjects
     */
    formatSubject(repo) {
        return repo.map(r => { var _b; return `repo:${r.owner}/${r.repo}:${(_b = r.filter) !== null && _b !== void 0 ? _b : '*'}`; });
    }
    /**
     * Create an IAM role for the provider.
     *
     * @param repo a list of repositories using this role.
     * @param roleProps properties to create this role.
     * @returns an IAM role
     * @stability stable
     */
    createRole(id, repo, roleProps) {
        const role = new iam.Role(this, id, {
            ...roleProps,
            assumedBy: new iam.OpenIdConnectPrincipal(this.provider, {
                StringEquals: {
                    // Audience is always sts.amazonaws.com with AWS official Github Action
                    // https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/configuring-openid-connect-in-amazon-web-services#adding-the-identity-provider-to-aws
                    [`${Provider.issuer}:aud`]: 'sts.amazonaws.com',
                },
                StringLike: {
                    [`${Provider.issuer}:sub`]: this.formatSubject(repo),
                },
            }),
        });
        return role;
    }
}
exports.Provider = Provider;
_a = JSII_RTTI_SYMBOL_1;
Provider[_a] = { fqn: "@pahud/cdk-github-oidc.Provider", version: "0.0.8" };
/**
 * The issuer of the OIDC provider claim or the "provider URL".
 *
 * @see https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/configuring-openid-connect-in-amazon-web-services#adding-the-identity-provider-to-aws
 * @stability stable
 */
Provider.issuer = 'token.actions.githubusercontent.com';
/**
 * The thumbprint of the OIDC provider claim.
 *
 * @see https://github.com/aws-actions/configure-aws-credentials
 * @stability stable
 */
Provider.thumbprint = 'a031c46782e6e6c662c2c87c76da9aa62ccabd8e';
//# sourceMappingURL=data:application/json;base64,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