#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = ["pytest", "requests", "beautifulsoup4", "pytest-cov", "wheel"]

test_requirements = ["pytest", "requests", "beautifulsoup4", "pytest-cov", "wheel"]

setup(
    author="Pepijn Boers",
    author_email='pepijnbb@gmail.com',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="Prijsoog compares prices for items in Dutch grocery stores.",
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    long_description_content_type='text/x-rst',
    include_package_data=True,
    keywords='prijsoog',
    name='prijsoog',
    packages=find_packages(include=['prijsoog', 'prijsoog.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/PepijnBoers/prijsoog',
    version='0.1.4',
    zip_safe=False,
)
