import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Synthetics::Canary`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 */
export interface CfnCanaryProps {
    /**
     * `AWS::Synthetics::Canary.ArtifactS3Location`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifacts3location
     */
    readonly artifactS3Location: string;
    /**
     * `AWS::Synthetics::Canary.Code`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-code
     */
    readonly code: CfnCanary.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.ExecutionRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn
     */
    readonly executionRoleArn: string;
    /**
     * `AWS::Synthetics::Canary.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-name
     */
    readonly name: string;
    /**
     * `AWS::Synthetics::Canary.RuntimeVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runtimeversion
     */
    readonly runtimeVersion: string;
    /**
     * `AWS::Synthetics::Canary.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-schedule
     */
    readonly schedule: CfnCanary.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.StartCanaryAfterCreation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-startcanaryaftercreation
     */
    readonly startCanaryAfterCreation: boolean | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.FailureRetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-failureretentionperiod
     */
    readonly failureRetentionPeriod?: number;
    /**
     * `AWS::Synthetics::Canary.RunConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runconfig
     */
    readonly runConfig?: CfnCanary.RunConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.SuccessRetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-successretentionperiod
     */
    readonly successRetentionPeriod?: number;
    /**
     * `AWS::Synthetics::Canary.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Synthetics::Canary.VPCConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-vpcconfig
     */
    readonly vpcConfig?: CfnCanary.VPCConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 *
 * @external
 * @cloudformationResource AWS::Synthetics::Canary
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 */
export declare class CfnCanary extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Synthetics::Canary";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCanary;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * `AWS::Synthetics::Canary.ArtifactS3Location`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifacts3location
     */
    artifactS3Location: string;
    /**
     * `AWS::Synthetics::Canary.Code`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-code
     */
    code: CfnCanary.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.ExecutionRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn
     */
    executionRoleArn: string;
    /**
     * `AWS::Synthetics::Canary.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-name
     */
    name: string;
    /**
     * `AWS::Synthetics::Canary.RuntimeVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runtimeversion
     */
    runtimeVersion: string;
    /**
     * `AWS::Synthetics::Canary.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-schedule
     */
    schedule: CfnCanary.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.StartCanaryAfterCreation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-startcanaryaftercreation
     */
    startCanaryAfterCreation: boolean | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.FailureRetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-failureretentionperiod
     */
    failureRetentionPeriod: number | undefined;
    /**
     * `AWS::Synthetics::Canary.RunConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runconfig
     */
    runConfig: CfnCanary.RunConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Synthetics::Canary.SuccessRetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-successretentionperiod
     */
    successRetentionPeriod: number | undefined;
    /**
     * `AWS::Synthetics::Canary.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Synthetics::Canary.VPCConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-vpcconfig
     */
    vpcConfig: CfnCanary.VPCConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Synthetics::Canary`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCanaryProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 *
 * @external
 * @cloudformationResource AWS::Synthetics::Canary
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 */
export declare namespace CfnCanary {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html
     */
    interface CodeProperty {
        /**
         * `CfnCanary.CodeProperty.Handler`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-handler
         */
        readonly handler: string;
        /**
         * `CfnCanary.CodeProperty.S3Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3bucket
         */
        readonly s3Bucket?: string;
        /**
         * `CfnCanary.CodeProperty.S3Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3key
         */
        readonly s3Key?: string;
        /**
         * `CfnCanary.CodeProperty.S3ObjectVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3objectversion
         */
        readonly s3ObjectVersion?: string;
        /**
         * `CfnCanary.CodeProperty.Script`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-script
         */
        readonly script?: string;
    }
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 *
 * @external
 * @cloudformationResource AWS::Synthetics::Canary
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 */
export declare namespace CfnCanary {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html
     */
    interface RunConfigProperty {
        /**
         * `CfnCanary.RunConfigProperty.ActiveTracing`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-activetracing
         */
        readonly activeTracing?: boolean | cdk.IResolvable;
        /**
         * `CfnCanary.RunConfigProperty.EnvironmentVariables`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-environmentvariables
         */
        readonly environmentVariables?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnCanary.RunConfigProperty.MemoryInMB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-memoryinmb
         */
        readonly memoryInMb?: number;
        /**
         * `CfnCanary.RunConfigProperty.TimeoutInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-timeoutinseconds
         */
        readonly timeoutInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 *
 * @external
 * @cloudformationResource AWS::Synthetics::Canary
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 */
export declare namespace CfnCanary {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html
     */
    interface ScheduleProperty {
        /**
         * `CfnCanary.ScheduleProperty.DurationInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-durationinseconds
         */
        readonly durationInSeconds?: string;
        /**
         * `CfnCanary.ScheduleProperty.Expression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-expression
         */
        readonly expression: string;
    }
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 *
 * @external
 * @cloudformationResource AWS::Synthetics::Canary
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 */
export declare namespace CfnCanary {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html
     */
    interface VPCConfigProperty {
        /**
         * `CfnCanary.VPCConfigProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnCanary.VPCConfigProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-subnetids
         */
        readonly subnetIds: string[];
        /**
         * `CfnCanary.VPCConfigProperty.VpcId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-vpcid
         */
        readonly vpcId?: string;
    }
}
