import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprivatemarketplace.html).
 *
 * @experimental
 */
export declare class AwsMarketplacePrivate extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprivatemarketplace.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to add new approved products to the Private Marketplace.
     *
     * Also allows to approve a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toAssociateProductsWithPrivateMarketplace(): this;
    /**
     * (experimental) Grants permission to create a new request for a product or products to be associated with the Private Marketplace.
     *
     * This action can be performed by any account in an in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toCreatePrivateMarketplaceRequests(): this;
    /**
     * (experimental) Grants permission to describe requests and associated products in the Private Marketplace.
     *
     * This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toDescribePrivateMarketplaceRequests(): this;
    /**
     * (experimental) Grants permission to remove approved products from the Private Marketplace.
     *
     * Also allows to decline a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toDisassociateProductsFromPrivateMarketplace(): this;
    /**
     * (experimental) Grants permission to get a queryable list for requests and associated products in the Private Marketplace.
     *
     * This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     *
     * @experimental
     */
    toListPrivateMarketplaceRequests(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
