import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * (experimental) Statement provider for service [securityhub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecurityhub.html).
 *
 * @experimental
 */
export declare class Securityhub extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [securityhub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecurityhub.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to accept Security Hub invitations to become a member account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AcceptAdministratorInvitation.html
     *
     * @experimental
     */
    toAcceptAdministratorInvitation(): this;
    /**
     * (experimental) Grants permission to accept Security Hub invitations to become a member account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AcceptInvitation.html
     *
     * @experimental
     */
    toAcceptInvitation(): this;
    /**
     * (experimental) Grants permission to disable standards in Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchDisableStandards.html
     *
     * @experimental
     */
    toBatchDisableStandards(): this;
    /**
     * (experimental) Grants permission to enable standards in Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchEnableStandards.html
     *
     * @experimental
     */
    toBatchEnableStandards(): this;
    /**
     * (experimental) Grants permission to import findings into Security Hub from an integrated product.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetAccount()
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchImportFindings.html
     *
     * @experimental
     */
    toBatchImportFindings(): this;
    /**
     * (experimental) Grants permission to update customer-controlled fields for a selected set of Security Hub findings.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifASFFSyntaxPath()
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateFindings.html
     *
     * @experimental
     */
    toBatchUpdateFindings(): this;
    /**
     * (experimental) Grants permission to create custom actions in Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_CreateActionTarget.html
     *
     * @experimental
     */
    toCreateActionTarget(): this;
    /**
     * (experimental) Grants permission to create a finding aggregator, which contains the cross-Region finding aggregation configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateFindingAggregator.html
     *
     * @experimental
     */
    toCreateFindingAggregator(): this;
    /**
     * (experimental) Grants permission to create insights in Security Hub. Insights are collections of related findings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_CreateInsight.html
     *
     * @experimental
     */
    toCreateInsight(): this;
    /**
     * (experimental) Grants permission to create member accounts in Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_CreateMembers.html
     *
     * @experimental
     */
    toCreateMembers(): this;
    /**
     * (experimental) Grants permission to decline Security Hub invitations to become a member account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeclineInvitations.html
     *
     * @experimental
     */
    toDeclineInvitations(): this;
    /**
     * (experimental) Grants permission to delete custom actions in Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeleteActionTarget.html
     *
     * @experimental
     */
    toDeleteActionTarget(): this;
    /**
     * (experimental) Grants permission to delete a finding aggregator, which disables finding aggregation across Regions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeleteFindingAggregator.html
     *
     * @experimental
     */
    toDeleteFindingAggregator(): this;
    /**
     * (experimental) Grants permission to delete insights from Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeleteInsight.html
     *
     * @experimental
     */
    toDeleteInsight(): this;
    /**
     * (experimental) Grants permission to delete Security Hub invitations to become a member account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeleteInvitations.html
     *
     * @experimental
     */
    toDeleteInvitations(): this;
    /**
     * (experimental) Grants permission to delete Security Hub member accounts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DeleteMembers.html
     *
     * @experimental
     */
    toDeleteMembers(): this;
    /**
     * (experimental) Grants permission to retrieve a list of custom actions using the API.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeActionTargets.html
     *
     * @experimental
     */
    toDescribeActionTargets(): this;
    /**
     * (experimental) Grants permission to retrieve information about the hub resource in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeHub.html
     *
     * @experimental
     */
    toDescribeHub(): this;
    /**
     * (experimental) Grants permission to describe the organization configuration for Security Hub.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeOrganizationConfiguration.html
     *
     * @experimental
     */
    toDescribeOrganizationConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve information about the available Security Hub product integrations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeProducts.html
     *
     * @experimental
     */
    toDescribeProducts(): this;
    /**
     * (experimental) Grants permission to retrieve information about Security Hub standards.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html
     *
     * @experimental
     */
    toDescribeStandards(): this;
    /**
     * (experimental) Grants permission to retrieve information about Security Hub standards controls.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandardsControls.html
     *
     * @experimental
     */
    toDescribeStandardsControls(): this;
    /**
     * (experimental) Grants permission to disable the findings importing for a Security Hub integrated product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DisableImportFindingsForProduct.html
     *
     * @experimental
     */
    toDisableImportFindingsForProduct(): this;
    /**
     * (experimental) Grants permission to remove the Security Hub administrator account for your organization.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DisableOrganizationAdminAccount.html
     *
     * @experimental
     */
    toDisableOrganizationAdminAccount(): this;
    /**
     * (experimental) Grants permission to disable Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DisableSecurityHub.html
     *
     * @experimental
     */
    toDisableSecurityHub(): this;
    /**
     * (experimental) Grants permission to a Security Hub member account to disassociate from the associated administrator account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DisassociateFromAdministratorAccount.html
     *
     * @experimental
     */
    toDisassociateFromAdministratorAccount(): this;
    /**
     * (experimental) Grants permission to a Security Hub member account to disassociate from the associated master account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DisassociateFromMasterAccount.html
     *
     * @experimental
     */
    toDisassociateFromMasterAccount(): this;
    /**
     * (experimental) Grants permission to disassociate Security Hub member accounts from the associated administrator account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DisassociateMembers.html
     *
     * @experimental
     */
    toDisassociateMembers(): this;
    /**
     * (experimental) Grants permission to enable the findings importing for a Security Hub integrated product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_EnableImportFindingsForProduct.html
     *
     * @experimental
     */
    toEnableImportFindingsForProduct(): this;
    /**
     * (experimental) Grants permission to designate a Security Hub administrator account for your organization.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     * - organizations:EnableAWSServiceAccess
     * - organizations:RegisterDelegatedAdministrator
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_EnableOrganizationAdminAccount.html
     *
     * @experimental
     */
    toEnableOrganizationAdminAccount(): this;
    /**
     * (experimental) Grants permission to enable Security Hub.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_EnableSecurityHub.html
     *
     * @experimental
     */
    toEnableSecurityHub(): this;
    /**
     * (experimental) Grants permission to retrieve insight results by providing a set of filters instead of an insight ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetAdhocInsightResults.html
     *
     * @experimental
     */
    toGetAdhocInsightResults(): this;
    /**
     * (experimental) Grants permission to retrieve details about the Security Hub administrator account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetAdministratorAccount.html
     *
     * @experimental
     */
    toGetAdministratorAccount(): this;
    /**
     * (experimental) Grants permission to retrieve a security score and counts of finding and control statuses for a security standard.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetControlFindingSummary.html
     *
     * @experimental
     */
    toGetControlFindingSummary(): this;
    /**
     * (experimental) Grants permission to retrieve a list of the standards that are enabled in Security Hub.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetEnabledStandards.html
     *
     * @experimental
     */
    toGetEnabledStandards(): this;
    /**
     * (experimental) Grants permission to retrieve details for a finding aggregator, which configures finding aggregation across Regions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFindingAggregator.html
     *
     * @experimental
     */
    toGetFindingAggregator(): this;
    /**
     * (experimental) Grants permission to retrieve a list of findings from Security Hub.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFindings.html
     *
     * @experimental
     */
    toGetFindings(): this;
    /**
     * (experimental) Grants permission to retrieve the end date for an account's free trial of Security Hub.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFreeTrialEndDate.html
     *
     * @experimental
     */
    toGetFreeTrialEndDate(): this;
    /**
     * (experimental) Grants permission to retrieve information about Security Hub usage during the free trial period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetFreeTrialUsage.html
     *
     * @experimental
     */
    toGetFreeTrialUsage(): this;
    /**
     * (experimental) Grants permission to retrieve an insight finding trend from Security Hub in order to generate a graph.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetInsightFindingTrend.html
     *
     * @experimental
     */
    toGetInsightFindingTrend(): this;
    /**
     * (experimental) Grants permission to retrieve insight results from Security Hub.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetInsightResults.html
     *
     * @experimental
     */
    toGetInsightResults(): this;
    /**
     * (experimental) Grants permission to retrieve Security Hub insights.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetInsights.html
     *
     * @experimental
     */
    toGetInsights(): this;
    /**
     * (experimental) Grants permission to retrieve the count of Security Hub membership invitations sent to the account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetInvitationsCount.html
     *
     * @experimental
     */
    toGetInvitationsCount(): this;
    /**
     * (experimental) Grants permission to retrieve details about the Security Hub master account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetMasterAccount.html
     *
     * @experimental
     */
    toGetMasterAccount(): this;
    /**
     * (experimental) Grants permission to retrieve the details of Security Hub member accounts.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetMembers.html
     *
     * @experimental
     */
    toGetMembers(): this;
    /**
     * (experimental) Grants permission to retrieve information about Security Hub usage by accounts.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_GetUsage.html
     *
     * @experimental
     */
    toGetUsage(): this;
    /**
     * (experimental) Grants permission to invite other AWS accounts to become Security Hub member accounts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_InviteMembers.html
     *
     * @experimental
     */
    toInviteMembers(): this;
    /**
     * (experimental) Grants permission to retrieve a list of controls for a standard, including the control IDs, statuses and finding counts.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_ListControlEvaluationSummaries.html
     *
     * @experimental
     */
    toListControlEvaluationSummaries(): this;
    /**
     * (experimental) Grants permission to retrieve the Security Hub integrated products that are currently enabled.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_ListEnabledProductsForImport.html
     *
     * @experimental
     */
    toListEnabledProductsForImport(): this;
    /**
     * (experimental) Grants permission to retrieve a list of finding aggregators, which contain the cross-Region finding aggregation configuration.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateFindingAggregator.html
     *
     * @experimental
     */
    toListFindingAggregators(): this;
    /**
     * (experimental) Grants permission to retrieve the Security Hub invitations sent to the account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_ListInvitations.html
     *
     * @experimental
     */
    toListInvitations(): this;
    /**
     * (experimental) Grants permission to retrieve details about Security Hub member accounts associated with the administrator account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_ListMembers.html
     *
     * @experimental
     */
    toListMembers(): this;
    /**
     * (experimental) Grants permission to list the Security Hub administrator accounts for your organization.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_ListOrganizationAdminAccounts.html
     *
     * @experimental
     */
    toListOrganizationAdminAccounts(): this;
    /**
     * (experimental) Grants permission to list of tags associated with a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to use a custom action to send Security Hub findings to Amazon EventBridge.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_SendFindingEvents.html
     *
     * @experimental
     */
    toSendFindingEvents(): this;
    /**
     * (experimental) Grants permission to use a custom action to send Security Hub insights to Amazon EventBridge.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_SendInsightEvents.html
     *
     * @experimental
     */
    toSendInsightEvents(): this;
    /**
     * (experimental) Grants permission to add tags to a Security Hub resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a Security Hub resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update custom actions in Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateActionTarget.html
     *
     * @experimental
     */
    toUpdateActionTarget(): this;
    /**
     * (experimental) Grants permission to update a finding aggregator, which contains the cross-Region finding aggregation configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateFindingAggregator.html
     *
     * @experimental
     */
    toUpdateFindingAggregator(): this;
    /**
     * (experimental) Grants permission to update Security Hub findings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateFindings.html
     *
     * @experimental
     */
    toUpdateFindings(): this;
    /**
     * (experimental) Grants permission to update insights in Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateInsight.html
     *
     * @experimental
     */
    toUpdateInsight(): this;
    /**
     * (experimental) Grants permission to update the organization configuration for Security Hub.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateOrganizationConfiguration.html
     *
     * @experimental
     */
    toUpdateOrganizationConfiguration(): this;
    /**
     * (experimental) Grants permission to update Security Hub configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateSecurityHubConfiguration.html
     *
     * @experimental
     */
    toUpdateSecurityHubConfiguration(): this;
    /**
     * (experimental) Grants permission to update Security Hub standards controls.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateStandardsControl.html
     *
     * @experimental
     */
    toUpdateStandardsControl(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type hub to the statement.
     *
     * https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-access.html#resources
     *
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onHub(account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type product to the statement.
     *
     * https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-access.html#resources
     *
     * @param company - Identifier for the company.
     * @param productId - Identifier for the productId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onProduct(company: string, productId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type finding-aggregator to the statement.
     *
     * https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-access.html#resources
     *
     * @param findingAggregatorId - Identifier for the findingAggregatorId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFindingAggregator(findingAggregatorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the specified fields and values in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-asffsyntaxpath
     *
     * Applies to actions:
     * - .toBatchUpdateFindings()
     *
     * @param aSFFSyntaxPath The tag key to check.
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifASFFSyntaxPath(aSFFSyntaxPath: string, value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the AwsAccountId field that is specified in the request.
     *
     * https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-access.html#conditions
     *
     * Applies to actions:
     * - .toBatchImportFindings()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifTargetAccount(value: string | string[], operator?: Operator | string): this;
}
