import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageDefaultObjectAclConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl.html#bucket StorageDefaultObjectAcl#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl.html#role_entity StorageDefaultObjectAcl#role_entity}.
     *
     * @stability stable
     */
    readonly roleEntity?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl.html google_storage_default_object_acl}.
 *
 * @stability stable
 */
export declare class StorageDefaultObjectAcl extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_acl.html google_storage_default_object_acl} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageDefaultObjectAclConfig);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _roleEntity?;
    /**
     * @stability stable
     */
    get roleEntity(): string[];
    /**
     * @stability stable
     */
    set roleEntity(value: string[]);
    /**
     * @stability stable
     */
    resetRoleEntity(): void;
    /**
     * @stability stable
     */
    get roleEntityInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
