"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubeSphere = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * The KubeSphere workload
 */
class KubeSphere extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        var _b, _c;
        super(scope, id);
        this.nodegroupOptions = props.nodegroupOptions;
        const cluster = (_b = props.cluster) !== null && _b !== void 0 ? _b : this._createEksCluster();
        cluster.addHelmChart('KubeSphere', {
            repository: 'https://charts.kubesphere.io/test',
            chart: 'ks-installer',
            namespace: 'kubesphere-system',
            values: {
                'openpitrix.enabled': (_c = props.appStore) !== null && _c !== void 0 ? _c : false,
            },
        });
    }
    _createEksCluster() {
        const vpc = getOrCreateVpc(aws_cdk_lib_1.Stack.of(this));
        const cluster = new aws_cdk_lib_1.aws_eks.Cluster(this, 'Cluster', {
            vpc,
            version: aws_cdk_lib_1.aws_eks.KubernetesVersion.V1_18,
        });
        if (this.nodegroupOptions) {
            cluster.addNodegroupCapacity('MNG', this.nodegroupOptions);
        }
        ;
        return cluster;
    }
}
exports.KubeSphere = KubeSphere;
_a = JSII_RTTI_SYMBOL_1;
KubeSphere[_a] = { fqn: "cdk-kubesphere.KubeSphere", version: "2.0.9" };
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1' ?
        aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new aws_cdk_lib_1.aws_ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,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