# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Cdn']


class Cdn(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 custom_domain: Optional[pulumi.Input[str]] = None,
                 origin: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a DigitalOcean CDN Endpoint resource for use with Spaces.

        ## Example Usage
        ### Basic Example

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        # Create a new Spaces Bucket
        mybucket = digitalocean.SpacesBucket("mybucket",
            region="sfo2",
            acl="public-read")
        # Add a CDN endpoint to the Spaces Bucket
        mycdn = digitalocean.Cdn("mycdn", origin=mybucket.bucket_domain_name)
        pulumi.export("fqdn", mycdn.endpoint)
        ```
        ### Custom Sub-Domain Example

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        # Create a new Spaces Bucket
        mybucket = digitalocean.SpacesBucket("mybucket",
            region="sfo2",
            acl="public-read")
        # Create a DigitalOcean managed Let's Encrypt Certificate
        cert = digitalocean.Certificate("cert",
            type="lets_encrypt",
            domains=["static.example.com"])
        # Add a CDN endpoint with a custom sub-domain to the Spaces Bucket
        mycdn = digitalocean.Cdn("mycdn",
            origin=mybucket.bucket_domain_name,
            custom_domain="static.example.com",
            certificate_name=cert.name)
        ```

        ## Import

        CDN Endpoints can be imported using the CDN `id`, e.g.

        ```sh
         $ pulumi import digitalocean:index/cdn:Cdn mycdn fb06ad00-351f-45c8-b5eb-13523c438661
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_id: **Deprecated** The ID of a DigitalOcean managed TLS certificate used for SSL when a custom subdomain is provided.
        :param pulumi.Input[str] certificate_name: The unique name of a DigitalOcean managed TLS certificate used for SSL when a custom subdomain is provided.
        :param pulumi.Input[str] custom_domain: The fully qualified domain name (FQDN) of the custom subdomain used with the CDN Endpoint.
        :param pulumi.Input[str] origin: The fully qualified domain name, (FQDN) for a Space.
        :param pulumi.Input[int] ttl: The time to live for the CDN Endpoint, in seconds. Default is 3600 seconds.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if certificate_id is not None and not opts.urn:
                warnings.warn("""Certificate IDs may change, for example when a Let's Encrypt certificate is auto-renewed. Please specify 'certificate_name' instead.""", DeprecationWarning)
                pulumi.log.warn("certificate_id is deprecated: Certificate IDs may change, for example when a Let's Encrypt certificate is auto-renewed. Please specify 'certificate_name' instead.")
            __props__['certificate_id'] = certificate_id
            __props__['certificate_name'] = certificate_name
            __props__['custom_domain'] = custom_domain
            if origin is None and not opts.urn:
                raise TypeError("Missing required property 'origin'")
            __props__['origin'] = origin
            __props__['ttl'] = ttl
            __props__['created_at'] = None
            __props__['endpoint'] = None
        super(Cdn, __self__).__init__(
            'digitalocean:index/cdn:Cdn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_id: Optional[pulumi.Input[str]] = None,
            certificate_name: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            custom_domain: Optional[pulumi.Input[str]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            origin: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[int]] = None) -> 'Cdn':
        """
        Get an existing Cdn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_id: **Deprecated** The ID of a DigitalOcean managed TLS certificate used for SSL when a custom subdomain is provided.
        :param pulumi.Input[str] certificate_name: The unique name of a DigitalOcean managed TLS certificate used for SSL when a custom subdomain is provided.
        :param pulumi.Input[str] created_at: The date and time when the CDN Endpoint was created.
        :param pulumi.Input[str] custom_domain: The fully qualified domain name (FQDN) of the custom subdomain used with the CDN Endpoint.
        :param pulumi.Input[str] endpoint: The fully qualified domain name (FQDN) from which the CDN-backed content is served.
        :param pulumi.Input[str] origin: The fully qualified domain name, (FQDN) for a Space.
        :param pulumi.Input[int] ttl: The time to live for the CDN Endpoint, in seconds. Default is 3600 seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["certificate_id"] = certificate_id
        __props__["certificate_name"] = certificate_name
        __props__["created_at"] = created_at
        __props__["custom_domain"] = custom_domain
        __props__["endpoint"] = endpoint
        __props__["origin"] = origin
        __props__["ttl"] = ttl
        return Cdn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[str]:
        """
        **Deprecated** The ID of a DigitalOcean managed TLS certificate used for SSL when a custom subdomain is provided.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[str]:
        """
        The unique name of a DigitalOcean managed TLS certificate used for SSL when a custom subdomain is provided.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date and time when the CDN Endpoint was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> pulumi.Output[Optional[str]]:
        """
        The fully qualified domain name (FQDN) of the custom subdomain used with the CDN Endpoint.
        """
        return pulumi.get(self, "custom_domain")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name (FQDN) from which the CDN-backed content is served.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name, (FQDN) for a Space.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[int]:
        """
        The time to live for the CDN Endpoint, in seconds. Default is 3600 seconds.
        """
        return pulumi.get(self, "ttl")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

