# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = [
    'GetSizesResult',
    'AwaitableGetSizesResult',
    'get_sizes',
]

@pulumi.output_type
class GetSizesResult:
    """
    A collection of values returned by getSizes.
    """
    def __init__(__self__, filters=None, id=None, sizes=None, sorts=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sizes and not isinstance(sizes, list):
            raise TypeError("Expected argument 'sizes' to be a list")
        pulumi.set(__self__, "sizes", sizes)
        if sorts and not isinstance(sorts, list):
            raise TypeError("Expected argument 'sorts' to be a list")
        pulumi.set(__self__, "sorts", sorts)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSizesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def sizes(self) -> Sequence['outputs.GetSizesSizeResult']:
        return pulumi.get(self, "sizes")

    @property
    @pulumi.getter
    def sorts(self) -> Optional[Sequence['outputs.GetSizesSortResult']]:
        return pulumi.get(self, "sorts")


class AwaitableGetSizesResult(GetSizesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSizesResult(
            filters=self.filters,
            id=self.id,
            sizes=self.sizes,
            sorts=self.sorts)


def get_sizes(filters: Optional[Sequence[pulumi.InputType['GetSizesFilterArgs']]] = None,
              sorts: Optional[Sequence[pulumi.InputType['GetSizesSortArgs']]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSizesResult:
    """
    Retrieves information about the Droplet sizes that DigitalOcean supports, with
    the ability to filter and sort the results. If no filters are specified, all sizes
    will be returned.

    ## Example Usage

    Most common usage will probably be to supply a size to Droplet:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    main = digitalocean.get_sizes(filters=[digitalocean.GetSizesFilterArgs(
        key="slug",
        values=["s-1vcpu-1gb"],
    )])
    web = digitalocean.Droplet("web",
        image="ubuntu-18-04-x64",
        region="sgp1",
        size=main.sizes[0].slug)
    ```

    The data source also supports multiple filters and sorts. For example, to fetch sizes with 1 or 2 virtual CPU that are available "sgp1" region, then pick the cheapest one:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    main = digitalocean.get_sizes(filters=[
            digitalocean.GetSizesFilterArgs(
                key="vcpus",
                values=[
                    "1",
                    "2",
                ],
            ),
            digitalocean.GetSizesFilterArgs(
                key="regions",
                values=["sgp1"],
            ),
        ],
        sorts=[digitalocean.GetSizesSortArgs(
            key="price_monthly",
            direction="asc",
        )])
    web = digitalocean.Droplet("web",
        image="ubuntu-18-04-x64",
        region="sgp1",
        size=main.sizes[0].slug)
    ```

    The data source can also handle multiple sorts. In which case, the sort will be applied in the order it is defined. For example, to sort by memory in ascending order, then sort by disk in descending order between sizes with same memory:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    main = digitalocean.get_sizes(sorts=[
        digitalocean.GetSizesSortArgs(
            direction="asc",
            key="memory",
        ),
        digitalocean.GetSizesSortArgs(
            direction="desc",
            key="disk",
        ),
    ])
    ```


    :param Sequence[pulumi.InputType['GetSizesFilterArgs']] filters: Filter the results.
           The `filter` block is documented below.
    :param Sequence[pulumi.InputType['GetSizesSortArgs']] sorts: Sort the results.
           The `sort` block is documented below.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['sorts'] = sorts
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getSizes:getSizes', __args__, opts=opts, typ=GetSizesResult).value

    return AwaitableGetSizesResult(
        filters=__ret__.filters,
        id=__ret__.id,
        sizes=__ret__.sizes,
        sorts=__ret__.sorts)
