# video-dl
[![PyPI version](https://img.shields.io/pypi/v/video_dl.svg)](https://pypi.org/project/video-dl/) 

`video-dl` is a naive online video downloader based on [aiohttp](https://docs.aiohttp.org/en/stable/).

## Prerequisites
- [ffmpeg](https://ffmpeg.org/) used to merge picture and sound to a complete video.
- [python](https://www.python.org) 3.8 or above (required by `:=` oprator).
- (Optional) JavaScript runtime environment, just like [Node.js](https://nodejs.org/en/), used to run javascript code.

You could check my help manual in [wiki](https://github.com/fengdongfa1995/video-dl/wiki) to install these system dependencies.

## Installation
```bash
pip3 install video-dl
```

## Upgrading
```bash
pip3 install --upgrade video-dl
```

## Typical usage
### Download the highest-definition video
> :warning: If there are special symbols in your url, please enclose it with quotation marks. 
```bash
video-dl 'https://www.bilibili.com/video/BV15L411p7M8'
```
> :warning: the `highest` depends my own view, maybe not the one you want.

![Normal Usage](https://github.com/fengdongfa1995/video-dl/raw/main/screenshots/normal_usage.gif)
### Download video which definition will be selected manually
```bash
video-dl -i 'https://www.bilibili.com/video/BV15L411p7M8'
```
![Normal Usage](https://github.com/fengdongfa1995/video-dl/raw/main/screenshots/interactive.gif)

### Download video to your specific directory
```bash
video-dl -d ~/tmp 'https://www.bilibili.com/video/BV15L411p7M8'
```
![set download directory](https://github.com/fengdongfa1995/video-dl/raw/main/screenshots/directory.gif)

### Download video via your proxy
> :underage: we have to access some non-existing sites via proxy.
```bash
video-dl -p http://172.30.176.1:10809 'https://cn.pornhub.com/view_video.php?viewkey=ph5c87e70498951'
```
![use proxy](https://github.com/fengdongfa1995/video-dl/raw/main/screenshots/proxy.gif)

### Try to download videos in the same playlist (experimental)
```bash
video-dl -l 'https://www.bilibili.com/video/BV1qy4y1V7qU'
```
![lists](https://github.com/fengdongfa1995/video-dl/raw/main/screenshots/lists.gif)

### Combine these arguments.
```bash
video-dl -d /mnt/d/Download -l -i 'https://www.bilibili.com/video/BV1qy4y1V7qU'
```
![combine arguments](https://github.com/fengdongfa1995/video-dl/raw/main/screenshots/combine.gif)

## Help document
### Program's help manual auto generated by `argparse`
you could use `video-dl -h` to see the below help manual.
```
usage: video_dl [-h] [-i] [-l] [-d DIRECTORY] [-c COOKIE] [-p PROXY] [-v] url

A naive online video downloader based on aiohttp

positional arguments:
  url                   target url copied from online video website.

optional arguments:
  -h, --help            show this help message and exit
  -i, --interactive     Manually select download resources.
  -l, --lists           try to find a playlist and download all videos in it.
  -d DIRECTORY, --directory DIRECTORY
                        set target diretory to save video file(s).
  -c COOKIE, --cookie COOKIE
                        provide your cookie.
  -p PROXY, --proxy PROXY
                        set proxy. e.g.: http://127.0.0.1:10809
  -v, --version         show program's version number and exit

You could find more important information in [github](https://github.com/fengdongfa1995/video_dl).
```

### Longer help manual written by myself
You could find how to install system prerequisites, FAQ and something else in [github's wiki](https://github.com/fengdongfa1995/video-dl/wiki).

# Supported websites
- [哔哩哔哩 (゜-゜)つロ 干杯~](https://www.bilibili.com/)
- [Free Porn Videos & Sex Movies](https://cn.pornhub.com/)

# How was this shit created?
- [在B站学习用Python做一个B站爬虫](https://www.bilibili.com/video/BV1nv411T798/)

# Getting Involved
You could discuss with me in [github's Discussions](https://github.com/fengdongfa1995/video-dl/discussions),
find bugs or submit your excelent ideas in [github's Issues](https://github.com/fengdongfa1995/video-dl/issues),
my last and the biggest wish is getting your [pull requests](https://github.com/fengdongfa1995/video-dl/pulls) to improve this naive tool.
