"""
Templates for state modules
"""

PRESENT_FUNCTION = """
async def {{function.name}}(
    hub,
    ctx{{function.header_params}}
) -> Dict[str, Any]:
    r'''
    **Autogenerated function**
    {{function.doc|replace("'" * 3, '"' * 3)}}
    Examples:

        .. code-block:: sls

            resource_is_{{function.name}}:
              {{ function.ref }}.{{ function.name }}:
                - {{ function.required_call_params.split(", ")|join("\n                - ")|replace("=", ": ") }}
    '''
"""

ABSENT_FUNCTION = """
async def {{function.name}}(hub, ctx{{function.header_params}})  -> Dict[str, Any]:
    r'''
    **Autogenerated function**
    {{function.doc|replace("'" * 3, '"' * 3)}}
    Examples:

        .. code-block:: sls

            resource_is_{{function.name}}:
              {{ function.ref }}.{{ function.name }}:
                - {{ function.required_call_params.split(", ")|join("\n                - ")|replace("=", ": ") }}
    '''
"""

DESCRIBE_FUNCTION = """
async def {{function.name}}(hub, ctx) -> Dict[str, Dict[str, Any]]:
    r'''
    **Autogenerated function**

    Describe the resource in a way that can be recreated/managed with the corresponding "present" function

    {{function.doc|replace("'" * 3, '"' * 3)}}
    Examples:

        .. code-block:: bash

            $ idem describe {{ function.ref }}
    '''
"""
