__all__ = [
    "ID",
    "Mutation",
    "Query",
    "Subscription",
    "graphql_schema",
    "interface",
    "relay",
    "resolver",
]


try:
    from .schema import ID, Query, Mutation, Subscription, graphql_schema
    from .interfaces import interface
    from .resolvers import resolver
    from . import relay
except ImportError:
    raise ImportError(
        "GraphQL feature requires graphql-core library\n"
        "Run `pip install apischema[graphql]` to install it"
    )
