/*
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
ART_ILLUMINA -- Artificial Read Transcription 
Copyright(c) 2008-2011 Weichun Huang, Jason Myers All Rights Reserved.
_____________________________________________________________________________________________________________
*/
#include <iostream>
#include <sstream>
#include <string>
#include <cstring>
#include <time.h>
#include <algorithm>
#include <iomanip>
#include <ctime>
#include "art.h"
#include "empdist.h"
#include "readSeqFile.h"
#include "samRead.h"


using namespace std;
double empdist::prob_err[HIGHEST_QUAL];
gsl_rng* art::gsl_R;
int art::gaussain_mean;
double art::gaussain_sigma;

int main(int argc, char* argv[]){
    cout << "=============================================================================="<<endl;
    cout << "                            ART (Q Version 1.5.1)                             "<<endl; 
    cout << "   Copyright(c) 2008-2013, Weichun Huang, Jason Myers. All Rights Reserved.   "<<endl; 
    cout << "=============================================================================="<<endl<<endl;

    bool mask_n=true; 
    short max_num_n=5; 
    int len_ref_id=250;

    //caluate CPUT time
    clock_t start, end;
    double cpu_time_used;
    start = clock();

    // Boolean flags showing the state of the run
    bool sam_out=false;
    bool is_matepair=false;
    bool arg_success = true;
    bool is_pairend_read=false;
    bool sep_flag = false;
    bool mean_flag = false;
    bool sDev_flag = false;
    bool in_flag = false;
    bool out_flag = false;
    bool len_flag = false;
    bool fold_flag = false;
    bool help_flag = false;
    bool show_flag = false;
    bool qs_flag = false;
    bool rate_flag = false;
    bool first_qual = false;
    bool second_qual = false;
    bool no_ALN = false;
    unsigned int rand_seed = 0;

    // Command-line Arguments
    string suffID=""; 
    string qual_file1 = "";
    string qual_file2 = "";
    char* seq_file = (char*) "";
    string out_file_prefix = "";
    int read_len  = 0;
    double x_fold  = 0;
    string num= "";
    int mean = 0;
    short q_shift_up=0;//2;
    short q_shift_up_2=0;//4;
    double std_dev = 0.0;
    double insRate=0.00009;
    double delRate=0.00011;
    double insRate2 = 0.00015;
    double delRate2 = 0.00023;

    // Get Command-line arguments
    for(int i=1;i < argc;++i){
        char* arg = argv[i];
            if(!strcmp(arg, "--matepair") || !strcmp(arg, "-mp") ){
        	num="1";
        	is_pairend_read=true;
        	is_matepair=true;
	    }
	    else if(!strcmp(arg, "--samout") || !strcmp(arg, "-sam") ){
        	sam_out=true;
	    }
	    else if(!strcmp(arg, "--paired") || !strcmp(arg, "-p") ){
        	num="1";
        	is_pairend_read=true;
            } else if(!strcmp(arg, "--help") || !strcmp(arg, "-h")){
		arg_success = false;
		help_flag = true;
		break;
            } else if(!strcmp(arg, "--quiet") || !strcmp(arg, "-q")){
		show_flag = true;
            } else if(!strcmp(arg, "--in") || !strcmp(arg, "-i")){
		i++;
		seq_file = argv[i];
		in_flag = true;
            } else if(!strcmp(arg, "--out") || !strcmp(arg, "-o")){
		i++;
		out_file_prefix = argv[i];
		out_flag = true;
            } else if(!strcmp(arg, "--len") || !strcmp(arg, "-l")){
		i++;
		read_len = atoi(argv[i]);
		len_flag = true;
		if(read_len < 0){
		   cerr << "Fatal Error: The read length must be a positive integer." << endl;
		   arg_success = false;
		}
            } else if(!strcmp(arg, "--insRate") || !strcmp(arg, "-ir")){
		i++;
		insRate = atof(argv[i]);
		rate_flag = true;
            } else if(!strcmp(arg, "--delRate") || !strcmp(arg, "-dr")){
		i++;
		delRate = atof(argv[i]);
		rate_flag = true;
            } else if(!strcmp(arg, "--insRate2") || !strcmp(arg, "-ir2")){
		i++;
		insRate2 = atof(argv[i]);
		rate_flag = true;
            } else if(!strcmp(arg, "--delRate2") || !strcmp(arg, "-dr2")){
		i++;
		delRate2 = atof(argv[i]);
		rate_flag = true;
            } else if(!strcmp(arg, "--fcov") || !strcmp(arg, "-f")){
		i++;
		x_fold = atof(argv[i]);
		fold_flag = true;
		if(x_fold < 0){
		   cerr << "Fatal Error: The fold coverage must be a positive." << endl;
		   arg_success = false;
		}
            } else if(!strcmp(arg, "--mflen") || !strcmp(arg, "-m")){
		i++;
		mean = atoi(argv[i]);
		mean_flag = true;
		if(mean < 0){
		   cerr << "Fatal Error: The mean fragment length must be a positive." << endl;
		   arg_success = false;
		}
            } else if(!strcmp(arg, "--qShift") || !strcmp(arg, "-qs")){
		i++;
		q_shift_up = atoi(argv[i]);
		qs_flag = true;
            } else if(!strcmp(arg, "--qShift2") || !strcmp(arg, "-qs2")){
		i++;
		q_shift_up_2 = atoi(argv[i]);
		qs_flag = true;
            } else if(!strcmp(arg, "--sdev") || !strcmp(arg, "-s")){
		i++;
		std_dev = atof(argv[i]);
		sDev_flag = true;
            } else if(!strcmp(arg, "--qprof1") || !strcmp(arg, "-1")){
		i++;
		qual_file1 = argv[i];
		first_qual = true;
            } else if(!strcmp(arg, "--qprof2") || !strcmp(arg, "-2")){
		i++;
		qual_file2 = argv[i];
		second_qual = true;
            } else if(!strcmp(arg, "--sepProf") || !strcmp(arg, "-sp")){
//		i++;
		sep_flag = true;
            } else if(!strcmp(arg, "--id") || !strcmp(arg, "-d")){
		i++;
		suffID = argv[i];
            } else if(!strcmp(arg, "--noALN") || !strcmp(arg, "-na")){ 
		no_ALN = true;
            } else if(!strcmp(arg, "--rndSeed") || !strcmp(arg, "-rs")){
		i++;
		rand_seed = abs(atoi(argv[i]));
            } else {
		arg_success = false;
		cerr << "Fatal Error: " << arg << ", is not a valid parameter." << endl;
		break;
            }
	
    }

    if(no_ALN && !sam_out){
		cerr << "Warning: your simulation will not output any ALN or SAM file with your parameter settings!" << endl;
    }
	
    // Make sure the minimum requirements to run were met if the help tag was not given
    if(help_flag){
    }
    else if(!in_flag || !out_flag || !len_flag || !fold_flag){
	arg_success = false;
//	cerr << "Fatal Error: An input-file, output-file prefix, read length, and fold coverage must be specified." << endl << endl;
    }

    if(mean_flag && sDev_flag){
	is_pairend_read = true;
	if(mean>=2000){
	       	is_matepair = true;
	}
	else if(is_matepair){
		cerr<<"Warning: a mate-pair simulation may be not appropriate for DNA fragment size < 2000bp"<<endl;
	}
	num = "1";
    }

    // Make sure the minimum requirements to run were given for a paired end simulation
    if (is_pairend_read){ 
	    //use the both default profiles or provide both profiles
	    if(qual_file1.empty() && !qual_file2.empty() ){
		    cerr<<"Please provide the quality profile of the first read" <<endl;
		    exit(1);
	    }
	    else if(!qual_file1.empty() && qual_file2.empty() ){
		    cerr<<"Please provide the quality profile of the second read" <<endl;
		    exit(1);
	    }
	   
	    if(mean_flag && sDev_flag){
		    art::ini_read_pair_rand(abs(mean),fabs(std_dev));
		    if(art::gaussain_mean<=read_len){
			    cerr<<"Fatal Error: The read length must be shorter than the mean fragment length specified." <<endl;
			    exit(1);
		    }
	    } else {
		    cerr << "Fatal Error: A mean fragment length and a standard deviation must be specified." << endl << endl;
		    exit(1);
	    }
    }

    if(!arg_success){
	cout << "---------------------------------------------USAGE---------------------------------------------"<< endl << endl;
	cout << "art_illumina [options] -i <DNA_reference_file> -l <read_length> -f <fold_coverage> -o <outFile_prefix>"<<endl<<endl;
	cout << " Examples:" <<endl;
	cout << " 1) single-end read simulation" <<endl;
	cout << " 	art_illumina -i reference.fa -l 50 -f 10 -o single_end_data" <<endl<<endl;
	cout << " 2) paired-end read simulation" <<endl;
	cout << "       art_illumina -i reference.fa -p -l 50 -f 20 -m 200 -s 10 -o outFile_prefix" <<endl<<endl;
	cout << " 3) mate-pair read simulation" <<endl;
	cout << "       art_illumina -i reference.fa -mp -l 50 -f 20 -m 2500 -s 50 -o outFile_prefix" <<endl<<endl;

	cout << " Parameters" << endl << endl;
	cout << "  -sam --samout   indicate to generate SAM alignment file" << endl;
	cout << "  -sp  --sepProf  indicate the use of separate quality profiles for different bases (ATGC)" << endl;
	cout << "  -mp  --matepair indicate a mate-pair read simulation" << endl;
	cout << "  -p   --paired   indicate a paired-end read simulation" << endl;
       	cout << "       NOTE: art will automatically switch to a mate-pair read simulation if the given mean fragment size >= 2000"<<endl;
	cout << "  -i   --in       the filename of input DNA reference" << endl;
	cout << "  -o   --out      the prefix of output files" << endl;
	cout << "  -l   --len      the length of reads to be simulated" << endl;
	cout << "  -f   --fcov     the fold of read coverage to be simulated" << endl;
	cout << "  -m   --mflen    the mean size of DNA fragments for paired-end simulations" << endl;
	cout << "  -s   --sdev     the standard deviation of DNA fragment size for paired-end simulations." << endl;
	cout << "  -na  --noALN    do not output ALN alignment file" << endl;
	cout << "  -rs  --rndSend  the seed for random number generator (default: system time in second)"  << endl;
	cout << "  -ir  --insRate  the first-read insertion rate (default: 0.00009)"<< endl;
	cout << "  -dr  --delRate  the first-read deletion rate (default:  0.00011)" << endl;
	cout << "  -ir2 --insRate2 the second-read insertion rate (default: 0.00015)" << endl;
	cout << "  -dr2 --delRate2 the second-read deletion rate (default: 0.00023)" << endl;
	cout << "  -qs  --qShift   the amount to shift every first-read quality score by" << endl;
	cout << "  -qs2 --qShift2  the amount to shift every second-read quality score by" << endl;
	cout << "  -1   --qprof1   the first-read quality profile" << endl;
	cout << "  -2   --qprof2   the second-read quality profile" << endl;
	cout << "  -d   --id       the prefix identification tag for read ID" << endl << endl;
	cout << "  -q   --quiet    turn off end of run summary" << endl;
	cout << "  -h   --help     print out usage information for ART" << endl<<endl;

	cout << "****NOTES****" << endl;
	cout << "* The default quality score profiles are determined based on the length" << endl; 
	cout << "  of read specified for the run and were derived from re-calibrated data." << endl << endl;
	cout << "* To simulate single-end reads one must provide the ART program with at least an input file,"<<endl;
	cout << "   output file prefix, the read length and the fold coverage." << endl << endl;;
	cout << "  Example: art --in reference_DNA.fa --out sim1 --len 35 --fcov 2 -sam" << endl << endl;;
	cout << "* To simulate paired-end reads one must use the parameters above as" << endl;
	cout << "  well as the mean fragment length, standard deviation, and --paired tag." << endl << endl;
	cout << "  Example: art --paired --in reference_DNA.fa --out sim2 --len 35 --fcov 2 --mflen 200 --sdev 3.5 -sam" << endl << endl;

	exit(0);
    }

    if(rand_seed==0){
	    rand_seed=(unsigned int) time(NULL); 
    }
    srand (rand_seed);

    string seqfasta=out_file_prefix+num+".fa";
    string qualfasta=out_file_prefix+num+".qual";
    string alnfasta=out_file_prefix+num+".aln";
    string fqfile=out_file_prefix+num+".fq";

    string samfile=out_file_prefix+".sam";
    ofstream SAMFILE;
    if(sam_out) {
	    SAMFILE.open(samfile.c_str(),ios::binary); 
	    if(!SAMFILE.is_open()) { cerr<<"Can not open output file: "<<samfile<<endl; exit(0); }
    }

    ofstream FQFILE(fqfile.c_str(),ios::binary);
    if(!FQFILE.is_open()) { cerr<<"Can not open output file: "<<fqfile<<endl; exit(0); }
	ofstream ALNFILE;	
	if (!no_ALN) {
	       	ALNFILE.open(alnfasta.c_str(),ios::binary);
	       	if(!ALNFILE.is_open()) { cerr<<"Can not open output file: "<<alnfasta<<endl; exit(0); }
	       	ALNFILE<<"##ART_Illumina\tread_length\t"<<read_len<<endl;
	}	
    empdist::set_err_prob();
    empdist qdist(qual_file1, qual_file2, sep_flag, read_len);
    int profile_size=qdist.qual_dist_first.size();
    int profile_size_2=qdist.qual_dist_second.size();
    if(sep_flag){
	    profile_size=qdist.a_qual_dist_first.size();
	    profile_size_2=qdist.a_qual_dist_second.size();
    }

    if(read_len > profile_size){
	if(profile_size == 0){
	    cerr << "Fatal Error: " <<  qual_file1 << ", is not a valid profile." << endl << endl;
	} else {
            cerr<<"Fatal Error: The read length, "<<read_len<<", exceeds the maximum first read profile length, "<<profile_size<< "." <<endl<<endl;
	}
        exit(1);
    }

    if((read_len > profile_size_2)  && is_pairend_read){
	if(profile_size_2 == 0){
	    cerr << "Fatal Error: " <<  qual_file2 << ", is not a valid profile." << endl << endl;
	} else {
            cerr<<"Fatal Error: The read length, "<<read_len<<", exceeds the maximum second read profile length, " <<profile_size_2 <<"." <<endl<<endl;
	}
        exit(1);
    }

    if(is_pairend_read && profile_size != profile_size_2){
        cerr<<"Fatal Error: The first profile read length, " << qdist.qual_dist_first.size()
	<< ", does not match the second profile read length, " << qdist.qual_dist_second.size() << "."
	<< endl << endl;
	exit(1);
    }

    //increase overal base quality value
    if(!sep_flag){
	    for(size_t i=0; i<qdist.qual_dist_first.size(); i++){
		    for(map<unsigned int, unsigned short>::iterator it=qdist.qual_dist_first[i].begin(); it!=qdist.qual_dist_first[i].end(); it++){
			    if(q_shift_up<0 && (-q_shift_up>it->second)){ it->second=0; }
			    else{ it->second+=q_shift_up; }
		    }
	    }
	    for(size_t i=0; i<qdist.qual_dist_second.size(); i++){
		    for(map<unsigned int, unsigned short>::iterator it=qdist.qual_dist_second[i].begin(); it!=qdist.qual_dist_second[i].end(); it++){
			    if(q_shift_up_2<0 && (-q_shift_up_2>it->second)){ it->second=0; }
			    else{ it->second+=q_shift_up_2; }
		    }
	    }

    } else{
	    for(size_t i=0; i<qdist.a_qual_dist_first.size(); i++){
		    for(map<unsigned int, unsigned short>::iterator it=qdist.a_qual_dist_first[i].begin(); it!=qdist.a_qual_dist_first[i].end(); it++){
			    if(q_shift_up<0 && (-q_shift_up>it->second)){ it->second=0; }
			    else{ it->second+=q_shift_up; }
		    }
	    }
	    for(size_t i=0; i<qdist.a_qual_dist_second.size(); i++){
		    for(map<unsigned int, unsigned short>::iterator it=qdist.a_qual_dist_second[i].begin(); it!=qdist.a_qual_dist_second[i].end(); it++){
			    if(q_shift_up_2<0 && (-q_shift_up_2>it->second)){ it->second=0; }
			    else{ it->second+=q_shift_up_2; }
		    }
	    }

	    for(size_t i=0; i<qdist.c_qual_dist_first.size(); i++){
		    for(map<unsigned int, unsigned short>::iterator it=qdist.c_qual_dist_first[i].begin(); it!=qdist.c_qual_dist_first[i].end(); it++){
			    if(q_shift_up<0 && (-q_shift_up>it->second)){ it->second=0; }
			    else{ it->second+=q_shift_up; }
		    }
	    }
	    for(size_t i=0; i<qdist.c_qual_dist_second.size(); i++){
		    for(map<unsigned int, unsigned short>::iterator it=qdist.c_qual_dist_second[i].begin(); it!=qdist.c_qual_dist_second[i].end(); it++){
			    if(q_shift_up_2<0 && (-q_shift_up_2>it->second)){ it->second=0; }
			    else{ it->second+=q_shift_up_2; }
		    }
	    }

	    for(size_t i=0; i<qdist.g_qual_dist_first.size(); i++){
		    for(map<unsigned int, unsigned short>::iterator it=qdist.g_qual_dist_first[i].begin(); it!=qdist.g_qual_dist_first[i].end(); it++){
			    if(q_shift_up<0 && (-q_shift_up>it->second)){ it->second=0; }
			    else{ it->second+=q_shift_up; }
		    }
	    }
	    for(size_t i=0; i<qdist.g_qual_dist_second.size(); i++){
		    for(map<unsigned int, unsigned short>::iterator it=qdist.g_qual_dist_second[i].begin(); it!=qdist.g_qual_dist_second[i].end(); it++){
			    if(q_shift_up_2<0 && (-q_shift_up_2>it->second)){ it->second=0; }
			    else{ it->second+=q_shift_up_2; }
		    }
	    }

	    for(size_t i=0; i<qdist.t_qual_dist_first.size(); i++){
		    for(map<unsigned int, unsigned short>::iterator it=qdist.t_qual_dist_first[i].begin(); it!=qdist.t_qual_dist_first[i].end(); it++){
			    if(q_shift_up<0 && (-q_shift_up>it->second)){ it->second=0; }
			    else{ it->second+=q_shift_up; }
		    }
	    }
	    for(size_t i=0; i<qdist.t_qual_dist_second.size(); i++){
		    for(map<unsigned int, unsigned short>::iterator it=qdist.t_qual_dist_second[i].begin(); it!=qdist.t_qual_dist_second[i].end(); it++){
			    if(q_shift_up_2<0 && (-q_shift_up_2>it->second)){ it->second=0; }
			    else{ it->second+=q_shift_up_2; }
		    }
	    }
   }

    samHeader sH;
    sH.getRefseqID(seq_file);
    sH.ID="01";
    sH.PN="ART_Illumina"; 
    if (!no_ALN){
	    for(int i=0;i < argc; ++i) { sH.CL.append(argv[i]);sH.CL.append(" "); }
	    sH.printAlnHeader(ALNFILE);
    }

    if(sam_out){
	    sH.printHeader(SAMFILE);
    }

    samRead sR;
    string srID;

    vector<short> qual;
    readSeqFile seq_reader(seq_file);
    string id;
    art a_art; 
    seqRead a_read;

    a_read.set_rate(read_len,insRate,2,a_read.ins_rate);
    a_read.set_rate(read_len,delRate,2,a_read.del_rate);
    string aln_read,aln_ref;
    ostringstream osID;
    int num_seq=0;
    string read_id;
        string seqfasta2="";
        string qualfasta2="";
        string alnfasta2="";
        string fqfile2="";
    if(is_pairend_read){
	samRead sR2; 
	sR.rNext="=";
	sR2.rNext="=";

        seqfasta2=out_file_prefix+"2.fa";
        qualfasta2=out_file_prefix+"2.qual";
        alnfasta2=out_file_prefix+"2.aln";
        fqfile2=out_file_prefix+"2.fq";
//        ofstream SEQFILE2(seqfasta2.c_str(),ios::binary);
//        if(!SEQFILE2.is_open()) { cout<<"can not open output file: "<<seqfasta2<<endl; exit(0); }

//        ofstream QUALFILE2(qualfasta2.c_str(),ios::binary);
//        if(!QUALFILE2.is_open()) { cout<<"can not open output file: "<<qualfasta2<<endl; exit(0); }

        ofstream FQFILE2(fqfile2.c_str(),ios::binary);
        if(!FQFILE2.is_open()) { cerr<<"Can not open output file: "<<fqfile2<<endl; exit(0); }
       	ofstream ALNFILE2;
       	if (!no_ALN) {
	       	ALNFILE2.open(alnfasta2.c_str(),ios::binary);
	       	if(!ALNFILE2.is_open()) { cerr<<"Can not open output file: "<<alnfasta2<<endl; exit(0); }
	       	ALNFILE2<<"##ART_Illumina\tread_length\t"<<read_len<<endl;
	       	sH.printAlnHeader(ALNFILE2);
       	}

        seqRead a_read_2;
        a_read_2.set_rate(read_len,insRate2,2,a_read.ins_rate);
        a_read_2.set_rate(read_len,delRate2,2,a_read.del_rate);
        vector<short> qual_2;
        string read_id_2;
        string aln_read_2,aln_ref_2;
        while(seq_reader.next_seq(id,a_art.ref_seq)){ 
//            size_t p1=id.find_first_of(' '); if(p1==string::npos) p1=10; size_t p2=id.find_first_of('\t'); if(p2==string::npos) p2=10;            p1=p1<p2?p1:p2; id=id.substr(0,p1); 
            istringstream isID; isID.str(id); isID>>id; id=id.substr(0,len_ref_id); 
            num_seq++;
            a_art.ini_set(read_len);
            if(mask_n){ 
              a_art.mask_n_region(max_num_n);
            }
            //long t_num_read=(unsigned long) a_art.ref_seq.size()/read_len*x_fold;
            long t_num_read= static_cast<unsigned long>(a_art.ref_seq.size()/read_len*x_fold);
            while(t_num_read>0){
//              osID<<num_seq<<fixed<<setfill('0')<< setw(10)<< t_num_read;
                osID<<id<<'-'<<suffID<<t_num_read;
                read_id = osID.str();
                osID.str("");
                a_read.clear();
                a_read_2.clear();
                //a_art.next_read(a_read);
		if(is_matepair){
		       	a_art.next_pair_read_indel_mate(a_read, a_read_2); 
		}
		else{
		       	a_art.next_pair_read_indel_cmp(a_read, a_read_2); 
		}
                if(mask_n){ 
                  if(a_read.is_plus_strand){
                    size_t bpos2=a_art.ref_seq.size()-a_read_2.bpos-read_len;
                    if(a_art.masked_pos.count(a_read.bpos)>0 || a_art.masked_pos.count(bpos2)>0){
                      t_num_read-=2;
                      continue;
                    }
                  }
                  else{
                    size_t bpos1=a_art.ref_seq.size()-a_read.bpos-read_len;
                    if(a_art.masked_pos.count(bpos1)>0 || a_art.masked_pos.count(a_read_2.bpos)>0){
                      t_num_read-=2;
                      continue;
                    }
                  }
                }
                qual.clear();
                qual_2.clear();

		if(!sep_flag){
		       	qdist.get_read_qual(qual, read_len, true);
		       	qdist.get_read_qual(qual_2,read_len, false);
	       	}
	       	else{
		       	qdist.get_read_qual_1st(a_read.seq_read, qual);
		       	qdist.get_read_qual_2nd(a_read_2.seq_read, qual_2);
	       	}

                a_read.add_error(qual);
                a_read_2.add_error(qual_2);
		srID=read_id;
                read_id_2=read_id+"/2";
                read_id+="/1";

                FQFILE<<"@"<<read_id<<endl<<a_read.seq_read<<endl<<"+"<<endl;
                for(size_t k=0; k<qual.size(); k++){
                    FQFILE<<(char)(qual[k]+33);
                }
                FQFILE<<endl;

		if(! a_read.get_aln(aln_read,aln_ref)){
		       	aln_ref=a_read.seq_ref;
		       	aln_read=a_read.seq_read;
	       	}
		if (!no_ALN) {
		       	ALNFILE<<">"<<id<<"\t"<<read_id<<"-1\t"<<a_read.bpos;
		       	if(a_read.is_plus_strand) ALNFILE<<"\t+\n";
		       	else ALNFILE<<"\t-\n";
		       	ALNFILE<<aln_ref<<endl<<aln_read<<endl;
	       	}

                FQFILE2<<"@"<<read_id_2<<endl<<a_read_2.seq_read<<endl<<"+"<<endl;
                for(size_t k=0; k<qual_2.size(); k++){
                    FQFILE2<<(char)(qual_2[k]+33);
                }
                FQFILE2<<endl;
	       	if(! a_read_2.get_aln(aln_read_2,aln_ref_2)){
		       	aln_ref_2=a_read_2.seq_ref;
		       	aln_read_2=a_read_2.seq_read;
	       	}
	       	if (!no_ALN) { 
			ALNFILE2<<">"<<id<<"\t"<<read_id_2<<"\t"<<a_read_2.bpos;
		       	if(a_read_2.is_plus_strand) ALNFILE2<<"\t+\n";
		       	else ALNFILE2<<"\t-\n";
		       	ALNFILE2<<aln_ref_2<<endl<<aln_read_2<<endl;
	       	}

		if(sam_out){
		       	sR.qname=srID;
		       	sR.rname=id;

		       	sR2.qname=srID;
		       	sR2.rname=id;

			sR.seq=a_read.seq_read;
		       	sR.qual.resize(qual.size());
		       	for(size_t k=0; k<qual.size(); k++){
			       	sR.qual[k]=(char)(qual[k]+33);
		       	}
		
			sR2.seq=a_read_2.seq_read;
		       	sR2.qual.resize(qual_2.size());
		       	for(size_t k=0; k<qual_2.size(); k++){
			       	sR2.qual[k]=(char)(qual_2[k]+33);
		       	}

			sR.flag=0x01 | 0x02 | 0x40;
		       	sR2.flag=0x01 | 0x02 | 0x80;
		       	if(a_read.is_plus_strand){
				       	sR.pos=a_read.bpos+1;
				       	sR.flag =sR.flag | 0x20;
				       	sR2.flag =sR2.flag |0x10;
				       	sR2.pos=a_art.ref_seq.size()-(a_read_2.bpos+read_len-1);
					sR2.reverse_comp();
		       	}
		       	else{
				       	sR.pos=a_art.ref_seq.size()-(a_read.bpos+read_len-1);
				       	sR.reverse_comp();
				       	sR2.pos=a_read_2.bpos+1;
				       	sR.flag = sR.flag | 0x10;
				       	sR2.flag = sR2.flag | 0x20;
		       	}
		       	sR.getCigar(aln_ref,aln_read);
			sR2.getCigar(aln_ref_2,aln_read_2);
		       	sR.pNext=sR2.pos;
		       	sR2.pNext=sR.pos;
		       	if(sR2.pos>sR.pos){
			       	sR.tLen=sR2.pos+a_read_2.seq_read.size()-sR.pos;
			       	sR2.tLen=-sR.tLen;
		       	}
		       	else{
			       	sR2.tLen=sR.pos+a_read.seq_read.size()-sR2.pos;
			       	sR.tLen=-sR2.tLen;
		       	} 
			sR.printRead(SAMFILE);
			sR2.printRead(SAMFILE);
		}

                t_num_read-=2;
            }
        }
        FQFILE2.close();
       	if (!no_ALN) ALNFILE2.close();
    }
    else{
        while(seq_reader.next_seq(id,a_art.ref_seq)){
            istringstream isID; isID.str(id); isID>>id; id=id.substr(0,len_ref_id); 
            num_seq++;
            a_art.ini_set(read_len);
            long t_num_read= static_cast<unsigned long>(a_art.ref_seq.size()/read_len*x_fold);
            while(t_num_read>0){
                osID<<id<<'-'<<suffID<<t_num_read;
                read_id = osID.str();
                osID.str("");
                a_read.clear();
                a_art.next_read_indel(a_read);
                if(mask_n){ 
                  if(a_read.is_plus_strand){
                    if(a_art.masked_pos.count(a_read.bpos)>0){
                      t_num_read-=2;
                      continue;
                    }
                  }
                  else{
                    size_t bpos=a_art.ref_seq.size()-a_read.bpos-read_len;
                    if(a_art.masked_pos.count(bpos)>0){
                      t_num_read-=2;
                      continue;
                    }
                  }
                }
 
                qual.clear();
		if(!sep_flag){
		       	qdist.get_read_qual(qual, read_len, true);
	       	}
	       	else{
		       	qdist.get_read_qual_1st(a_read.seq_read, qual);
	       	}
                a_read.add_error(qual);

                FQFILE<<"@"<<read_id<<endl<<a_read.seq_read<<endl<<"+"<<endl;
                for(size_t k=0; k<qual.size(); k++){
                    FQFILE<<(char)(qual[k]+33);
                }
                FQFILE<<endl;
	       	if(! a_read.get_aln(aln_read,aln_ref)){
		       	aln_ref=a_read.seq_ref;
		       	aln_read=a_read.seq_read;
	       	}
	       	if (!no_ALN) {
		       	ALNFILE<<">"<<id<<"\t"<<read_id<<"\t"<<a_read.bpos;
		       	if(a_read.is_plus_strand) ALNFILE<<"\t+\n";
		       	else ALNFILE<<"\t-\n";

		       	ALNFILE<<aln_ref<<endl<<aln_read<<endl;
	       	}

		if(sam_out){
		       	sR.qname=read_id;
		       	sR.rname=id;
		       	sR.flag =0;

			sR.seq=a_read.seq_read;
		       	sR.qual.resize(qual.size());
		       	for(size_t k=0; k<qual.size(); k++){
			       	sR.qual[k]=(char)(qual[k]+33);
		       	}

		       	if(a_read.is_plus_strand){
			       	sR.pos=a_read.bpos+1;
		       	}
		       	else{
			       	sR.flag = 0x10;
			       	sR.pos=a_art.ref_seq.size()-(a_read.bpos+a_read.seq_read.size()-1);
			       	sR.reverse_comp();
		       	}
		       	sR.getCigar(aln_ref,aln_read);
			sR.printRead(SAMFILE);
		}


                t_num_read--;
            }
        }
    }

    FQFILE.close();
    if (!no_ALN) { ALNFILE.close(); }
    if(sam_out){ SAMFILE.close(); }

    if(!is_pairend_read){
        cout << "                          Single-end Simulation" << endl << endl;
    } else if(is_matepair) {
        cout << "                          MatePair-end Simulation" << endl << endl;
    } else {
        cout << "                          Paired-end Simulation" << endl << endl;
    }

    end = clock();
    cpu_time_used = ((double) (end - start)) / CLOCKS_PER_SEC;
    cout<< "Total CPU time used: "<< cpu_time_used<<endl<<endl;
    cout<< "The random seed for the run: "<< rand_seed<<endl<<endl;

    if(!show_flag){

	cout << "Parameters used during run" << endl; 
	cout << "\tRead Length:              " << read_len << endl;
	cout << "\tFold Coverage:            " << x_fold << "X" << endl;
	if(is_pairend_read){
	    cout << "\tMean Fragment Length:     " << mean << endl;
	    cout << "\tStandard Deviation:       " << std_dev << endl;
	}
	if(rate_flag){
            cout << "\tFirst Insertion Rate:     " << insRate << endl;
	    cout << "\tSecond Insertion Rate:    " << insRate2 << endl;
	    cout << "\tFirst Deletion Rate:      " << delRate << endl;
	    cout << "\tSecond Deletion Rate:     " << delRate2 << endl;
	}
	if(qs_flag){
	    cout << "\tFirst quality shift:      " << q_shift_up << endl;
	    cout << "\tSecond quality shift:     " << q_shift_up_2 << endl;
	}
	if(!sep_flag){
	    cout << "\tProfile Type:             Combined" << endl;
	} else {
	    cout << "\tProfile Type:             Separated" << endl;
	}
	cout << "\tID Tag:                   " << suffID.c_str() << endl << endl;;
	cout << "Quality Profile(s)" << endl; 


	if(is_pairend_read){
	    if(first_qual){
		cout << "\tFirst Read:   " << qual_file1.c_str() <<" (user's profile)" << endl;
	    } else {
		cout << "\tFirst Read:   " <<" EMP" << profile_size <<"R1"<<" (built-in profile) "<<endl;
	    }
	    if(second_qual){
		cout << "\tSecond Read:  " << qual_file2.c_str()<<" (user's profile)"<< endl<< endl;
	    } else {
		cout << "\tSecond Read:  " <<" EMP" << profile_size_2 <<"R2"<<" (built-in profile) "<<endl<<endl;
	    }
	} else {
	    if(first_qual){
		cout << "\t" << qual_file1.c_str()<<" (user's profile)"<< endl << endl;
	    } else {
		cout << "\t " <<" EMP" << profile_size <<"R1"<<" (built-in profile) "<<endl<<endl;
	    }
	}
	
	cout << "Output files" << endl << endl;

	if(is_pairend_read){
	    cout << "  FASTQ Sequence Files:" << endl; 
	    cout << "\t the 1st reads: " << fqfile << endl;
	    cout << "\t the 2nd reads: " << fqfile2 << endl << endl;
	    if(!no_ALN){
		    cout << "  ALN Alignment Files:" << endl; 
		    cout << "\t the 1st reads: " << alnfasta << endl;
		    cout << "\t the 2nd reads: " << alnfasta2 << endl << endl;;
	    }
	} else {
	    cout << "  FASTQ Sequence File:" << endl; 
	    cout << "\t" << fqfile << endl << endl;
	    if (!no_ALN){
		    cout << "  ALN Alignment File:" << endl; 
		    cout << "\t" << alnfasta << endl << endl;
	    }
	}
	if(sam_out){
	    cout << "  SAM Alignment File:" << endl; 
	    cout << "\t" << samfile << endl << endl;
	}
    }    

   return 0;
}

