"""
Autogenerated using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__

hub.exec.boto3.client.rds.copy_db_parameter_group
hub.exec.boto3.client.rds.create_db_parameter_group
hub.exec.boto3.client.rds.delete_db_parameter_group
hub.exec.boto3.client.rds.describe_db_parameter_groups
hub.exec.boto3.client.rds.modify_db_parameter_group
hub.exec.boto3.client.rds.reset_db_parameter_group
"""
import copy
from collections import OrderedDict
from dataclasses import field
from dataclasses import make_dataclass
from typing import Any
from typing import Dict
from typing import List

__contracts__ = ["resource"]


async def present(
    hub,
    ctx,
    name: str,
    db_parameter_group_family: str,
    description: str = None,
    resource_id: str = None,
    tags: Dict[str, Any]
    or List[
        make_dataclass("Tag", [("Key", str), ("Value", str, field(default=None))])
    ] = None,
    parameters: List = None,
) -> Dict[str, Any]:
    """
    **Autogenerated function**

    Creates a new DB parameter group. A DB parameter group is initially created with the default parameters for the
    database engine used by the DB instance. To provide custom values for any of the parameters, you can specify parameters.
    Once you've created a DB parameter group, you can associate it with your DB instance. When you associate a new DB parameter group with a
    running DB instance, you need to reboot the DB instance without failover for the new DB parameter group and
    associated settings to take effect. After you create a DB parameter
    group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter
    group as the default parameter group. This allows Amazon RDS to fully complete the create action before the
    parameter group is used as the default for a new DB instance. This is especially important for parameters that
    are critical when creating the default database for a DB instance, such as the character set for the default
    database defined by the character_set_database parameter. You can use the Parameter Groups option of the Amazon
    RDS console to verify that your DB parameter group has been created or modified.

    Args:
        name(str): An Idem name of the resource.
        resource_id(str, Optional): An identifier of the resource in the provider. Defaults to None.
        db_parameter_group_family(str): The DB parameter group family name. A DB parameter group can be associated with one and only one
            DB parameter group family, and can be applied only to a DB instance running a database engine
            and engine version compatible with that DB parameter group family. To list all of the available
            parameter group families for a DB engine, use the following command:  aws rds describe-db-
            engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>  For
            example, to list all of the available parameter group families for the MySQL DB engine, use the
            following command:  aws rds describe-db-engine-versions --query
            "DBEngineVersions[].DBParameterGroupFamily" --engine mysql   The output contains duplicates.
            The following are the valid DB engine values:    aurora (for MySQL 5.6-compatible Aurora)
            aurora-mysql (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)    aurora-postgresql
            mariadb     mysql     oracle-ee     oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres
            sqlserver-ee     sqlserver-se     sqlserver-ex     sqlserver-web.
        description(str): The description for the DB parameter group.
        tags(Dict or List, Optional): Dict in the format of {tag-key: tag-value} or List of tags in the format of
            [{"Key": tag-key, "Value": tag-value}] to associate with the DB parameter group.
            Each tag consists of a key name and an associated value. Defaults to None.
            * Key (str, Optional): The key of the tag. Constraints: Tag keys are case-sensitive and accept a maximum of 127 Unicode
                characters. May not begin with aws:.
            * Value(str, Optional): The value of the tag. Constraints: Tag values are case-sensitive and accept a maximum of 256
                Unicode characters.
        parameters(List, Optional): parameters in the DB parameter group. Defaults to None.

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            resource_is_present:
              aws.rds.db_parameter_group.present:
              - name: 'test'
              - resource_id: 'test'
              - db_parameter_group_family: 'aurora-mysql5.7'
              - description: 'test'
              - tags:
                 - Key: 'test'
                   Value: 'test1'
                 - Key: 'test2'
                   Value: 'test2'
              - parameters:
                 - name: 'aurora_disable_hash_join'
                   value: '1'
                   apply_method: 'immediate'
    """

    result = dict(comment=(), old_state=None, new_state=None, name=name, result=True)
    before = None
    resource_updated = False
    if resource_id:
        before = await hub.exec.boto3.client.rds.describe_db_parameter_groups(
            ctx,
            DBParameterGroupName=resource_id,
        )
    tags = (
        hub.tool.aws.tag_utils.convert_tag_list_to_dict(tags)
        if isinstance(tags, List)
        else tags
    )
    if before:
        ret_tags = None
        tags_list = await hub.exec.boto3.client.rds.list_tags_for_resource(
            ctx,
            ResourceName=before["ret"]["DBParameterGroups"][0].get(
                "DBParameterGroupArn"
            ),
        )
        if tags_list["result"]:
            ret_tags = hub.tool.aws.tag_utils.convert_tag_list_to_dict(
                tags_list["ret"]["TagList"]
            )

        parameters_list = await hub.exec.boto3.client.rds.describe_db_parameters(
            ctx, DBParameterGroupName=resource_id
        )
        ret_parameters = None
        if parameters_list["result"]:
            ret_parameters = parameters_list["ret"]["Parameters"]
        result[
            "old_state"
        ] = await hub.tool.aws.rds.conversion_utils.convert_db_parameter_group_to_present(
            raw_resource=before["ret"]["DBParameterGroups"][0],
            idem_resource_name=name,
            parameters=ret_parameters,
            tags=ret_tags,
        )
        plan_state = copy.deepcopy(result["old_state"])

        if tags is not None:
            # Update tags
            update_ret = await hub.exec.aws.rds.tag.update_rds_tags(
                ctx=ctx,
                resource_arn=result["old_state"].get("db_parameter_group_arn"),
                old_tags=result["old_state"].get("tags"),
                new_tags=tags,
            )
            result["comment"] = result["comment"] + update_ret["comment"]
            result["result"] = result["result"] and update_ret["result"]
            resource_updated = resource_updated or update_ret["result"]
            if ctx.get("test", False) and update_ret["ret"] is not None:
                plan_state["tags"] = update_ret["ret"]
        if parameters is not None:
            update_ret = await hub.tool.aws.rds.parameters.modify_db_group_parameters(
                ctx=ctx,
                resource_name=result["old_state"].get("resource_id"),
                old_parameters=result["old_state"].get("parameters"),
                new_parameters=parameters,
            )
            result["comment"] = result["comment"] + update_ret["comment"]
            result["result"] = result["result"] and update_ret["result"]
            resource_updated = resource_updated or bool(update_ret["ret"])
            if ctx.get("test", False) and update_ret["ret"] is not None:
                plan_state["parameters"] = update_ret["ret"].get("parameters")
    else:
        if ctx.get("test", False):
            result["new_state"] = hub.tool.aws.test_state_utils.generate_test_state(
                enforced_state={},
                desired_state={
                    "name": name,
                    "db_parameter_group_family": db_parameter_group_family,
                    "description": description,
                    "tags": tags,
                    "parameters": parameters,
                },
            )
            result["comment"] = hub.tool.aws.comment_utils.would_create_comment(
                resource_type="aws.rds.db_parameter_group", name=name
            )
            return result
        try:
            ret = await hub.exec.boto3.client.rds.create_db_parameter_group(
                ctx,
                **{
                    "DBParameterGroupName": name,
                    "DBParameterGroupFamily": db_parameter_group_family,
                    "Description": description,
                    "Tags": hub.tool.aws.tag_utils.convert_tag_dict_to_list(tags)
                    if tags
                    else None,
                },
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                return result

            resource_id = ret["ret"]["DBParameterGroup"]["DBParameterGroupName"]
            result["new_state"] = {"name": name, "resource_id": resource_id}
            result["comment"] = hub.tool.aws.comment_utils.create_comment(
                resource_type="aws.rds.db_parameter_group", name=name
            )
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = result["comment"] + (f"{e.__class__.__name__}: {e}",)
            result["result"] = False
    # Modify the db group parameters
    if parameters is not None:
        ret_parameter = await hub.exec.boto3.client.rds.describe_db_parameters(
            ctx, DBParameterGroupName=resource_id
        )
        db_parameters = OrderedDict(
            {"ParameterName": "name", "ParameterValue": "value"}
        )
        list_parameters = []
        for parameter in ret_parameter["ret"]["Parameters"]:
            update_parameters = {}
            for parameter_old_key, parameter_new_key in db_parameters.items():
                if parameter.get(parameter_old_key) is not None:
                    update_parameters[parameter_new_key] = parameter.get(
                        parameter_old_key
                    )
            list_parameters.append(update_parameters)
        update_ret = await hub.tool.aws.rds.parameters.modify_db_group_parameters(
            ctx=ctx,
            resource_name=resource_id,
            old_parameters=list_parameters,
            new_parameters=parameters,
        )
        result["comment"] = result["comment"] + update_ret["comment"]
        result["result"] = result["result"] and update_ret["result"]

    try:
        if ctx.get("test", False):
            result["new_state"] = plan_state
        elif (not before) or resource_updated:
            after = await hub.exec.boto3.client.rds.describe_db_parameter_groups(
                ctx,
                DBParameterGroupName=resource_id,
            )
            ret_tags = None
            tags_list = await hub.exec.boto3.client.rds.list_tags_for_resource(
                ctx,
                ResourceName=after["ret"]["DBParameterGroups"][0].get(
                    "DBParameterGroupArn"
                ),
            )
            if tags_list["result"]:
                ret_tags = hub.tool.aws.tag_utils.convert_tag_list_to_dict(
                    tags_list["ret"]["TagList"]
                )

            parameters_list = await hub.exec.boto3.client.rds.describe_db_parameters(
                ctx, DBParameterGroupName=resource_id
            )
            ret_parameters = None
            if parameters_list["result"]:
                ret_parameters = parameters_list["ret"]["Parameters"]

            if not after["result"]:
                result["result"] = False
                result["comment"] = after["comment"]
                return result
            result[
                "new_state"
            ] = await hub.tool.aws.rds.conversion_utils.convert_db_parameter_group_to_present(
                raw_resource=after["ret"]["DBParameterGroups"][0],
                idem_resource_name=name,
                parameters=ret_parameters,
                tags=ret_tags,
            )
        else:
            result["new_state"] = copy.deepcopy(result["old_state"])
            result["comment"] = hub.tool.aws.comment_utils.already_exists_comment(
                resource_type="aws.rds.db_parameter_group", name=name
            )
    except Exception as e:
        result["comment"] = result["comment"] + (str(e),)
        result["result"] = False
    return result


async def absent(hub, ctx, name: str, resource_id: str) -> Dict[str, Any]:
    """
    **Autogenerated function**

    Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB
    instances.

    Args:
        resource_id(str): An identifier of the resource in the provider.
        name(str): The name of the DB parameter group. Constraints:   Must be the name of an existing DB parameter
            group   You can't delete a default DB parameter group   Can't be associated with any DB
            instances.

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: sls

            resource_is_absent:
              aws.rds.db_parameter_group.absent:
                - name: value
                - resource_id: value
    """

    result = dict(comment=(), old_state=None, new_state=None, name=name, result=True)
    if not resource_id:
        result["comment"] = hub.tool.aws.comment_utils.already_absent_comment(
            resource_type="aws.rds.db_parameter_group", name=name
        )
        return result
    before = await hub.exec.boto3.client.rds.describe_db_parameter_groups(
        ctx,
        DBParameterGroupName=resource_id,
    )
    if not before or not before["ret"].get("DBParameterGroups"):
        result["comment"] = hub.tool.aws.comment_utils.already_absent_comment(
            resource_type="aws.rds.db_parameter_group", name=name
        )
    elif ctx.get("test", False):
        result[
            "old_state"
        ] = await hub.tool.aws.rds.conversion_utils.convert_db_parameter_group_to_present(
            raw_resource=before["ret"]["DBParameterGroups"][0], idem_resource_name=name
        )
        result["comment"] = hub.tool.aws.comment_utils.would_delete_comment(
            resource_type="aws.rds.db_parameter_group", name=name
        )
        return result
    else:
        tags = None
        tags_list = await hub.exec.boto3.client.rds.list_tags_for_resource(
            ctx,
            ResourceName=before["ret"]["DBParameterGroups"][0].get(
                "DBParameterGroupArn"
            ),
        )
        if tags_list["result"]:
            tags = tags_list["ret"]["TagList"]

        ret_parameter = await hub.exec.boto3.client.rds.describe_db_parameters(
            ctx, DBParameterGroupName=resource_id
        )
        parameters = None
        if ret_parameter["result"]:
            parameters = ret_parameter["ret"]["Parameters"]
        result[
            "old_state"
        ] = await hub.tool.aws.rds.conversion_utils.convert_db_parameter_group_to_present(
            raw_resource=before["ret"]["DBParameterGroups"][0],
            idem_resource_name=name,
            parameters=parameters,
            tags=tags,
        )
        try:
            ret = await hub.exec.boto3.client.rds.delete_db_parameter_group(
                ctx,
                DBParameterGroupName=name,
            )
            result["result"] = ret["result"]
            if not result["result"]:
                result["comment"] = ret["comment"]
                result["result"] = False
                return result
            result["comment"] = hub.tool.aws.comment_utils.delete_comment(
                resource_type="aws.rds.db_parameter_group", name=name
            )
        except hub.tool.boto3.exception.ClientError as e:
            result["comment"] = result["comment"] + (f"{e.__class__.__name__}: {e}",)

    return result


async def describe(hub, ctx) -> Dict[str, Dict[str, Any]]:
    """
    **Autogenerated function**

    Describe the resource in a way that can be recreated/managed with the corresponding "present" function


    Returns a list of DBParameterGroup descriptions.

    Returns:
        Dict[str, Any]

    Examples:

        .. code-block:: bash

            $ idem describe aws.rds.db_parameter_group
    """

    result = {}
    ret = await hub.exec.boto3.client.rds.describe_db_parameter_groups(ctx)

    if not ret["result"]:
        hub.log.debug(f"Could not describe db_parameter_group {ret['comment']}")
        return {}

    for db_parameter_group in ret["ret"]["DBParameterGroups"]:
        resource_id = db_parameter_group.get("DBParameterGroupName")
        tags = None
        tags_list = await hub.exec.boto3.client.rds.list_tags_for_resource(
            ctx, ResourceName=db_parameter_group.get("DBParameterGroupArn")
        )
        if tags_list["result"]:
            tags = hub.tool.aws.tag_utils.convert_tag_list_to_dict(
                tags_list["ret"]["TagList"]
            )

        ret_parameter = await hub.exec.boto3.client.rds.describe_db_parameters(
            ctx, DBParameterGroupName=resource_id
        )
        parameters = None
        if ret_parameter["result"]:
            parameters = ret_parameter["ret"]["Parameters"]
        resource_translated = await hub.tool.aws.rds.conversion_utils.convert_db_parameter_group_to_present(
            raw_resource=db_parameter_group,
            idem_resource_name=resource_id,
            tags=tags,
            parameters=parameters,
        )
        result[resource_id] = {
            "aws.rds.db_parameter_group.present": [
                {parameter_key: parameter_value}
                for parameter_key, parameter_value in resource_translated.items()
            ]
        }
    return result
