# Generated by Django 2.1.10 on 2019-12-22 23:14
from django.db import migrations

from outputs.models import Export


def set_metadata(*args, **kwargs):
    print('Init emails in Exports ...')
    exports = Export.objects.all().only('emails')

    for export in exports:
        emails = list(export.recipients.values_list('email', flat=True))
        export.emails = emails

    print('>>> bulk update started ...')
    Export.objects.bulk_update(exports, fields=['emails'])
    print('>>> bulk update finished')


class Migration(migrations.Migration):

    dependencies = [
        ('outputs', '0002_auto_20200821_1321'),
    ]

    operations = [
        migrations.RunPython(set_metadata, lambda *args, **kwargs: None)
    ]
