# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['zenml',
 'zenml.artifact_stores',
 'zenml.artifacts',
 'zenml.cli',
 'zenml.config',
 'zenml.container_registries',
 'zenml.entrypoints',
 'zenml.experiment_trackers',
 'zenml.feature_stores',
 'zenml.integrations',
 'zenml.integrations.airflow',
 'zenml.integrations.airflow.orchestrators',
 'zenml.integrations.aws',
 'zenml.integrations.aws.container_registries',
 'zenml.integrations.aws.secret_schemas',
 'zenml.integrations.aws.secrets_managers',
 'zenml.integrations.azure',
 'zenml.integrations.azure.artifact_stores',
 'zenml.integrations.azureml',
 'zenml.integrations.azureml.step_operators',
 'zenml.integrations.dash',
 'zenml.integrations.dash.visualizers',
 'zenml.integrations.evidently',
 'zenml.integrations.evidently.steps',
 'zenml.integrations.evidently.visualizers',
 'zenml.integrations.facets',
 'zenml.integrations.facets.visualizers',
 'zenml.integrations.feast',
 'zenml.integrations.feast.feature_stores',
 'zenml.integrations.gcp',
 'zenml.integrations.gcp.artifact_stores',
 'zenml.integrations.gcp_secrets_manager',
 'zenml.integrations.gcp_secrets_manager.secrets_manager',
 'zenml.integrations.graphviz',
 'zenml.integrations.graphviz.visualizers',
 'zenml.integrations.huggingface',
 'zenml.integrations.huggingface.materializers',
 'zenml.integrations.kubeflow',
 'zenml.integrations.kubeflow.metadata_stores',
 'zenml.integrations.kubeflow.orchestrators',
 'zenml.integrations.lightgbm',
 'zenml.integrations.lightgbm.materializers',
 'zenml.integrations.mlflow',
 'zenml.integrations.mlflow.experiment_trackers',
 'zenml.integrations.mlflow.model_deployers',
 'zenml.integrations.mlflow.services',
 'zenml.integrations.mlflow.steps',
 'zenml.integrations.neural_prophet',
 'zenml.integrations.neural_prophet.materializers',
 'zenml.integrations.plotly',
 'zenml.integrations.plotly.visualizers',
 'zenml.integrations.pytorch',
 'zenml.integrations.pytorch.materializers',
 'zenml.integrations.pytorch_lightning',
 'zenml.integrations.pytorch_lightning.materializers',
 'zenml.integrations.s3',
 'zenml.integrations.s3.artifact_stores',
 'zenml.integrations.sagemaker',
 'zenml.integrations.sagemaker.step_operators',
 'zenml.integrations.scipy',
 'zenml.integrations.scipy.materializers',
 'zenml.integrations.seldon',
 'zenml.integrations.seldon.model_deployers',
 'zenml.integrations.seldon.secret_schemas',
 'zenml.integrations.seldon.services',
 'zenml.integrations.seldon.steps',
 'zenml.integrations.sklearn',
 'zenml.integrations.sklearn.helpers',
 'zenml.integrations.sklearn.materializers',
 'zenml.integrations.sklearn.steps',
 'zenml.integrations.tensorflow',
 'zenml.integrations.tensorflow.materializers',
 'zenml.integrations.tensorflow.services',
 'zenml.integrations.tensorflow.steps',
 'zenml.integrations.tensorflow.visualizers',
 'zenml.integrations.vertex',
 'zenml.integrations.vertex.orchestrator',
 'zenml.integrations.vertex.step_operators',
 'zenml.integrations.wandb',
 'zenml.integrations.wandb.experiment_trackers',
 'zenml.integrations.whylogs',
 'zenml.integrations.whylogs.materializers',
 'zenml.integrations.whylogs.steps',
 'zenml.integrations.whylogs.visualizers',
 'zenml.integrations.xgboost',
 'zenml.integrations.xgboost.materializers',
 'zenml.io',
 'zenml.materializers',
 'zenml.metadata_stores',
 'zenml.model_deployers',
 'zenml.orchestrators',
 'zenml.orchestrators.local',
 'zenml.pipelines',
 'zenml.pipelines.builtin_pipelines',
 'zenml.post_execution',
 'zenml.secret',
 'zenml.secrets_managers',
 'zenml.secrets_managers.local',
 'zenml.services',
 'zenml.services.local',
 'zenml.stack',
 'zenml.step_operators',
 'zenml.steps',
 'zenml.steps.builtin_steps',
 'zenml.steps.step_interfaces',
 'zenml.utils',
 'zenml.visualizers',
 'zenml.zen_server',
 'zenml.zen_stores',
 'zenml.zen_stores.models']

package_data = \
{'': ['*']}

install_requires = \
['analytics-python>=1.4.0,<2.0.0',
 'apache-beam>=2.30.0,<3.0.0',
 'click-params>=0.3.0,<0.4.0',
 'click>=8.0.1,<9.0.0',
 'distro>=1.6.0,<2.0.0',
 'fastapi>=0.75.0,<0.76.0',
 'gitpython>=3.1.18,<4.0.0',
 'httplib2>=0.19.1,<0.20',
 'markupsafe==1.1.1',
 'ml-pipelines-sdk==1.8.0rc1',
 'nbconvert==6.4.4',
 'pandas>=1.1.5,<2.0.0',
 'pydantic>=1.9.0,<2.0.0',
 'pyparsing>=2.4.0,<3',
 'python-dateutil>=2.8.1,<3.0.0',
 'pyyaml>=5.4.1,<6.0.0',
 'rich[jupyter]>=12.0.0,<13.0.0',
 'semver>=2.13.0,<3.0.0',
 'sqlmodel>=0.0.6,<0.1.0',
 'uvicorn[standard]>=0.17.5,<0.18.0']

entry_points = \
{'console_scripts': ['zenml = zenml.cli.cli:cli']}

setup_kwargs = {
    'name': 'zenml',
    'version': '0.8.1rc0',
    'description': 'ZenML: Write production-ready ML code.',
    'long_description': '<div align="center">\n    <img src="https://zenml.io/assets/social/github.svg">\n</div>\n\n# ⏲️ Join the ZenML team on the MLOps Day\n\nWe are hosting a MLOps day where we\'ll be building a vendor-agnostic MLOps pipeline from scratch.\n\nSign up [here](https://www.eventbrite.com/e/zenml-mlops-day-join-us-in-building-a-vendor-agnostic-mlops-pipeline-tickets-336331515617) to join the entire ZenML team in showcasing the latest release, answering the community\'s questions, and live-coding vendor agnostic MLOps features with the ZenML framework!\n\n# 👀 What is ZenML?\n\n**ZenML** is an extensible, open-source MLOps framework to create\nproduction-ready machine learning pipelines. Built for data scientists, it has a\nsimple, flexible syntax, is cloud- and tool-agnostic, and has\ninterfaces/abstractions that are catered towards ML workflows.\n\nAt its core, **ZenML pipelines execute ML-specific workflows** from sourcing\ndata to splitting, preprocessing, training, all the way to the evaluation of\nresults and even serving. There are many built-in batteries to support common ML\ndevelopment tasks. ZenML is not here to replace the great tools that solve these\nindividual problems. Rather, it offers an **extensible framework** and a\nstandard abstraction to write and build your workflows.\n\n🎉 **Version 0.8.0 out now!** [Check out the release notes\nhere](https://github.com/zenml-io/zenml/releases).\n\n[![PyPI - Python\nVersion](https://img.shields.io/pypi/pyversions/zenml)](https://pypi.org/project/zenml/)\n[![PyPI Status](https://pepy.tech/badge/zenml)](https://pepy.tech/project/zenml)\n![GitHub](https://img.shields.io/github/license/zenml-io/zenml)\n[![Codecov](https://codecov.io/gh/zenml-io/zenml/branch/main/graph/badge.svg)](https://codecov.io/gh/zenml-io/zenml)\n[![Interrogate](docs/interrogate.svg)](https://interrogate.readthedocs.io/en/latest/)\n[![Main Workflow\nTests](https://github.com/zenml-io/zenml/actions/workflows/ci.yml/badge.svg?branch=main)](https://github.com/zenml-io/zenml/actions/workflows/ci.yml)\n\n<div align="center">\nJoin our <a href="https://zenml.io/slack-invite" target="_blank">\n    <img width="25" src="https://cdn3.iconfinder.com/data/icons/logos-and-brands-adobe/512/306_Slack-512.png" alt="Slack"/>\n<b>Slack Community</b> </a> and become part of the ZenML family\n</div>\n<div align="center"> Give us a \n    <img width="25" src="https://cdn.iconscout.com/icon/free/png-256/github-153-675523.png" alt="Slack"/>\n<b>GitHub star</b> to show your love\n</div>\n<div align="center"> \n    <b>NEW: </b> <a href="https://zenml.io/discussion" target="_blank"><img width="25" src="https://cdn1.iconfinder.com/data/icons/social-17/48/like-512.png" alt="Vote"/><b> Vote</b></a> on the next ZenML features \n</div>\n\n<br>\n\n# 🤖 Why use ZenML?\n\nZenML pipelines are designed to be written early on the development lifecycle.\nData scientists can explore their pipelines as they develop towards production,\nswitching stacks from local to cloud deployments with ease. You can read more\nabout why we started building ZenML [on our\nblog](https://blog.zenml.io/why-zenml/). By using ZenML in the early stages of\nyour project, you get the following benefits:\n\n- **Extensible** so you can build out the framework to suit your specific needs\n- **Reproducibility** of training and inference workflows\n- A **simple and clear** way to represent the steps of your pipeline in code\n- **Batteries-included integrations**: bring all your favorite tools together\n- Easy switch between local and cloud stacks\n- Painless **deployment and configuration** of infrastructure\n\n# 📖 Learn More\n\n| ZenML Resources | Description |\n| ------------- | - |\n| 🧘\u200d♀️ **[ZenML 101]** | New to ZenML? Here\'s everything you need to know! |\n| ⚛️ **[Core Concepts]** | Some key terms and concepts we use. |\n| 🗃 **[Functional API Guide]** | Build production ML pipelines with simple functions. |\n| 🚀 **[New in v0.8.0]** | New features, bug fixes. |\n| 🗳 **[Vote for Features]** | Pick what we work on next! |\n| 📓 **[Docs]** | Full documentation for creating your own ZenML pipelines. |\n| 📒 **[API Reference]** | The detailed reference for ZenML\'s API. |\n| 🍰 **[ZenBytes]** | A guided and in-depth tutorial on MLOps and ZenML. |\n| 🗂️️ **[ZenFiles]** | End-to-end projects using ZenML. |\n| ⚽️ **[Examples]** | Learn best through examples where ZenML is used? We\'ve got you covered. |\n| 📬 **[Blog]** | Use cases of ZenML and technical deep dives on how we built it. |\n| 🔈 **[Podcast]** | Conversations with leaders in ML, released every 2 weeks. |\n| 📣 **[Newsletter]** | We build ZenML in public. Subscribe to learn how we work. |\n| 💬 **[Join Slack]** | Need help with your specific use case? Say hi on Slack! |\n| 🗺 **[Roadmap]** | See where ZenML is working to build new features. |\n| 🙋\u200d♀️ **[Contribute]** | How to contribute to the ZenML project and code base. |\n\n[ZenML 101]: https://docs.zenml.io/\n[Core Concepts]: https://docs.zenml.io/core-concepts\n[Functional API Guide]: https://docs.zenml.io/v/docs/guides/functional-api\n[New in v0.8.0]: https://github.com/zenml-io/zenml/releases\n[Vote for Features]: https://zenml.io/discussion\n[Docs]: https://docs.zenml.io/\n[API Reference]: https://apidocs.zenml.io/\n[ZenBytes]: https://github.com/zenml-io/zenbytes\n[ZenFiles]: https://github.com/zenml-io/zenfiles\n[Examples]: https://github.com/zenml-io/zenml/tree/main/examples\n[Blog]: https://blog.zenml.io/\n[Podcast]: https://podcast.zenml.io/\n[Newsletter]: https://zenml.io/newsletter/\n[Join Slack]: https://zenml.io/slack-invite/\n[Roadmap]: https://zenml.io/roadmap\n[Contribute]: https://github.com/zenml-io/zenml/blob/main/CONTRIBUTING.md\n\n# 🎮 Features\n\n### 1. 💪 Write local, run anywhere\n\nYou only need to write your core machine learning workflow code once, but you\ncan run it anywhere. We decouple your code from the environment and\ninfrastructure on which this code runs.\n\nSwitching from local experiments to cloud-based pipelines doesn\'t need to be\ncomplicated. ZenML supports running pipelines wherever you want, for example by\nusing Kubeflow, one of our built-in integrations, or any orchestrator of your\nchoice. Switching from your local stack to a cloud stack is easy to do with our\nCLI tool.\n\n![You can run your pipelines locally or in the\ncloud](docs/book/assets/core_concepts/concepts-3.png)\n\n### 2. 🌈 All your MLOps stacks in one place\n\nOnce code is organized into a ZenML pipeline, you can supercharge your ML\ndevelopment with [powerful\nintegrations](https://docs.zenml.io/features/integrations) on multiple [MLOps\nstacks](https://docs.zenml.io/core-concepts). There are lots of moving parts for\nall the MLOps tooling and infrastructure you require for ML in production and\nZenML aims to bring it all together under one roof.\n\nWe already support common use cases and integrations to standard ML tools via\nour stack components, from orchestrators like Airflow and Kubeflow to model\ndeployment via MLflow or Seldon Core, to custom infrastructure for training your\nmodels in the cloud and so on. If you want to learn more about our integrations,\ncheck out [our Examples](https://github.com/zenml-io/zenml/tree/main/examples)\nto see how they work.\n\n![ZenML is the glue](docs/book/assets/stack-list.png)\n\n### 3. 🛠 Extensibility\n\nZenML\'s Stack Components are built to support most machine learning use cases.\nWe offer a batteries-included initial installation that should serve many needs\nand workflows, but if you need a special kind of monitoring tool added, for\nexample, or a different orchestrator to run your pipelines, ZenML is built as a\nframework making it easy to extend and build out whatever you need.\n\n![ZenML is fully extensible](docs/book/assets/extensibility.gif)\n\n### 4. 🔍 Automated metadata tracking\n\nZenML tracks metadata for all the pipelines you run. This ensures that:\n\n- Code is versioned\n- Data is versioned\n- Models are versioned\n- Configurations are versioned\n\nThis also enables caching of the data that powers your pipelines which helps you\niterate quickly through ML experiments. (Read [our\nblogpost](https://blog.zenml.io/caching-ml-pipelines/) to learn more!)\n\n![Visualize your pipeline steps](docs/book/assets/dag-visualizer.png)\n\n### 5. ➿ Continuous Training and Continuous Deployment (CT/CD)\n\nContinuous Training (CT) refers to the paradigm where a team deploys training pipelines \nthat run automatically to train models on new (fresh) data. Continuous Deployment (CD) \nrefers to the paradigm where newly trained models are automatically deployed to a prediction \nservice/server\n\nZenML enabled CT/CD by enabling the model preparation and model training with model deployment. \nWith the built-in functionalities like Schedules, Model Deployers and Services you can \ncreate end-to-end ML workflows with Continuous Training and Deployment that deploys your \nmodel in a local environment with MLFlow integration or even in a production-grade environment \nlike Kubernetes with our Seldon Core integration. You can also listed served models with the CLI:\n\n![CI/CD/CT in ZenML](docs/book/assets/ct_cd_zenml.gif)\n\n```\nzenml served-models list\n```\n\nRead more about CT/CD in ZenML [here](https://blog.zenml.io/ci-ct-cd-with-zenml/).\n\n# 🤸 Getting Started\n\n## 💾 Install ZenML\n\n*Requirements*: ZenML supports Python 3.7 and 3.8.\n\nZenML is available for easy installation into your environment via PyPI:\n\n```bash\npip install zenml\n```\n\nAlternatively, if you’re feeling brave, feel free to install the bleeding edge:\n**NOTE:** Do so on your own risk, no guarantees given!\n\n```bash\npip install git+https://github.com/zenml-io/zenml.git@main --upgrade\n```\n\nZenML is also available as a Docker image hosted publicly on\n[DockerHub](https://hub.docker.com/r/zenmldocker/zenml). Use the following\ncommand to get started in a bash environment:\n\n```shell\ndocker run -it zenmldocker/zenml /bin/bash\n```\n\n## 🚅 Quickstart\n\nThe quickest way to get started is to create a simple pipeline.\n\n#### Step 1: Initialize a ZenML repo\n\n```bash\nzenml init\nzenml integration install sklearn -y # we use scikit-learn for this example\n```\n\n#### Step 2: Assemble, run, and evaluate your pipeline locally\n\n```python\nimport numpy as np\nfrom sklearn.base import ClassifierMixin\n\nfrom zenml.integrations.sklearn.helpers.digits import get_digits, get_digits_model\nfrom zenml.pipelines import pipeline\nfrom zenml.steps import step, Output\n\n@step\ndef importer() -> Output(\n    X_train=np.ndarray, X_test=np.ndarray, y_train=np.ndarray, y_test=np.ndarray\n):\n    """Loads the digits array as normal numpy arrays."""\n    X_train, X_test, y_train, y_test = get_digits()\n    return X_train, X_test, y_train, y_test\n\n\n@step\ndef trainer(\n    X_train: np.ndarray,\n    y_train: np.ndarray,\n) -> ClassifierMixin:\n    """Train a simple sklearn classifier for the digits dataset."""\n    model = get_digits_model()\n    model.fit(X_train, y_train)\n    return model\n\n\n@step\ndef evaluator(\n    X_test: np.ndarray,\n    y_test: np.ndarray,\n    model: ClassifierMixin,\n) -> float:\n    """Calculate the accuracy on the test set"""\n    test_acc = model.score(X_test, y_test)\n    print(f"Test accuracy: {test_acc}")\n    return test_acc\n\n\n@pipeline\ndef mnist_pipeline(\n    importer,\n    trainer,\n    evaluator,\n):\n    """Links all the steps together in a pipeline"""\n    X_train, X_test, y_train, y_test = importer()\n    model = trainer(X_train=X_train, y_train=y_train)\n    evaluator(X_test=X_test, y_test=y_test, model=model)\n\n\npipeline = mnist_pipeline(\n    importer=importer(),\n    trainer=trainer(),\n    evaluator=evaluator(),\n)\npipeline.run()\n```\n\n# :racehorse: Get a guided tour with `zenml go`\n\nFor a slightly more in-depth introduction to ZenML, taught through Jupyter\nnotebooks, install `zenml` via pip as described above and type:\n\n```shell\nzenml go\n```\n\nThis will spin up a Jupyter notebook that showcases the above example plus more\non how to use and extend ZenML.\n\n# 👭 Collaborate with your team\n\nZenML is built to support teams working together. The underlying infrastructure\non which your ML workflows run can be shared, as can the data, assets and\nartifacts that you need to enable your work. ZenML Profiles offer an easy way to\nmanage and switch between your stacks. The ZenML Server handles all the\ninteraction and sharing and you can host it wherever you\'d like.\n\n```\nzenml server up\n```\n\nRead more about collaboration in ZenML [here](https://docs.zenml.io/collaborate/collaborate).\n\n# 🍰 ZenBytes\n\n[ZenBytes](https://github.com/zenml-io/zenbytes) is a series of short practical\nMLOps lessons through ZenML and its various integrations. It is intended for\npeople looking to learn about MLOps generally, and also for ML practitioners who\nwant to get started with ZenML.\n\nAfter you\'ve run and understood the simple example above, your next port of call\nis probably either the [fully-fleshed-out quickstart\nexample](https://github.com/zenml-io/zenml/tree/main/examples/quickstart) and\nthen to look at [the ZenBytes repository](https://github.com/zenml-io/zenbytes)\nand notebooks.\n\n# 🗂️ ZenFiles\n\nZenFiles are production-grade ML use-cases powered by ZenML. They are fully\nfleshed out, end-to-end, projects that showcase ZenML\'s capabilities. They can\nalso serve as a template from which to start similar projects.\n\nThe ZenFiles project is fully maintained and can be viewed as a sister\nrepository of ZenML. Check it out [here](https://github.com/zenml-io/zenfiles).\n\n# 🗺 Roadmap\n\nZenML is being built in public. The [roadmap](https://zenml.io/roadmap) is a\nregularly updated source of truth for the ZenML community to understand where\nthe product is going in the short, medium, and long term.\n\nZenML is managed by a [core team](https://zenml.io/team) of developers that are\nresponsible for making key decisions and incorporating feedback from the\ncommunity. The team oversees feedback via various channels, and you can directly\ninfluence the roadmap as follows:\n\n- Vote on your most wanted feature on our [Discussion\n  board](https://zenml.io/discussion). You can also request for new features here.\n- Start a thread in our [Slack channel](https://zenml.io/slack-invite).\n\n# 🙋\u200d♀️ Contributing & Community\n\nWe would love to develop ZenML together with our community! Best way to get\nstarted is to select any issue from the [`good-first-issue`\nlabel](https://github.com/zenml-io/zenml/labels/good%20first%20issue). If you\nwould like to contribute, please review our [Contributing\nGuide](CONTRIBUTING.md) for all relevant details.\n\n<br>\n\n![Repobeats analytics\nimage](https://repobeats.axiom.co/api/embed/635c57b743efe649cadceba6a2e6a956663f96dd.svg\n"Repobeats analytics image")\n\n\n# 🆘 Where to get help\n\nFirst point of call should be [our Slack group](https://zenml.io/slack-invite/).\nAsk your questions about bugs or specific use cases and someone from the core\nteam will respond.\n\n# 📜 License\n\nZenML is distributed under the terms of the Apache License Version 2.0. A\ncomplete version of the license is available in the [LICENSE.md](LICENSE.md) in\nthis repository. Any contribution made to this project will be licensed under\nthe Apache License Version 2.0.\n',
    'author': 'ZenML GmbH',
    'author_email': 'info@zenml.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://zenml.io',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<3.10',
}


setup(**setup_kwargs)
