#  Copyright (c) ZenML GmbH 2022. All Rights Reserved.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at:
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
#  or implied. See the License for the specific language governing
#  permissions and limitations under the License.
from zenml.integrations.constants import WHYLOGS
from zenml.integrations.integration import Integration


class WhylogsIntegration(Integration):
    """Definition of [whylogs](https://github.com/whylabs/whylogs)
    integration for ZenML."""

    NAME = WHYLOGS
    REQUIREMENTS = ["whylogs>=0.6.22", "pybars3>=0.9.7"]

    @classmethod
    def activate(cls) -> None:
        """Activates the integration."""
        from zenml.integrations.whylogs import materializers  # noqa
        from zenml.integrations.whylogs import visualizers  # noqa


WhylogsIntegration.check_installation()
