# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-02-01 18:08


from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('products', '0015_auto_20190129_1728'),
        ('orders', '0009_orderitem_description'),
    ]

    operations = [
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('product_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='products.Product')),
                ('type', models.CharField(choices=[('a', 'All'), ('c', 'Custom')], default='a', max_length=5, verbose_name='Type')),
                ('duration', models.DurationField(default='30 00:00:00', verbose_name='Duration')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
            ],
            options={
                'verbose_name': 'Subscription',
                'manager_inheritance_from_future': True,
                'verbose_name_plural': 'Subscriptions',
            },
            bases=('products.product',),
        ),
        migrations.CreateModel(
            name='SubscriptionOrder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('expire_at', models.DateTimeField(verbose_name='Expire at')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('update_at', models.DateTimeField(auto_now=True, verbose_name='Update at')),
                ('order_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='orders.Order', verbose_name='Order')),
                ('subscription_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='subscriptions.Subscription', verbose_name='Subscription')),
            ],
            options={
                'verbose_name': 'Subscription Order',
                'verbose_name_plural': 'Subscriptions Orders',
            },
        ),
        migrations.AddField(
            model_name='subscription',
            name='orders',
            field=models.ManyToManyField(through='subscriptions.SubscriptionOrder', to='orders.Order', verbose_name='Orders'),
        ),
        migrations.AddField(
            model_name='subscription',
            name='products',
            field=models.ManyToManyField(blank=True, related_name='subscriptions', to='products.Product', verbose_name='Products'),
        ),
    ]
