/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
    if (aliases === undefined) aliases = {};
    if (externals === undefined) externals = {};

    var cache = {};

    var normalize = function(name) {
      if (typeof name === "number")
        return name;

      if (name === "bokehjs")
        return entry;

      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)

      var alias = aliases[name]
      if (alias != null)
        return alias;

      var trailing = name.length > 0 && name[name.lenght-1] === "/";
      var index = aliases[name + (trailing ? "" : "/") + "index"];
      if (index != null)
        return index;

      return name;
    }

    var require = function(name) {
      var mod = cache[name];
      if (!mod) {
        var id = normalize(name);

        mod = cache[id];
        if (!mod) {
          if (!modules[id]) {
            if (externals[id] === false || (externals[id] == true && parent_require)) {
              try {
                mod = {exports: externals[id] ? parent_require(id) : {}};
                cache[id] = cache[name] = mod;
                return mod.exports;
              } catch (e) {}
            }

            var err = new Error("Cannot find module '" + name + "'");
            err.code = 'MODULE_NOT_FOUND';
            throw err;
          }

          mod = {exports: {}};
          cache[id] = cache[name] = mod;

          function __esModule() {
            Object.defineProperty(mod.exports, "__esModule", {value: true});
          }

          function __esExport(name, value) {
            Object.defineProperty(mod.exports, name, {
              enumerable: true, get: function () { return value; }
            });
          }

          modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
        } else {
          cache[name] = mod;
        }
      }

      return mod.exports;
    }
    require.resolve = function(name) {
      return ""
    }

    var main = require(entry);
    main.require = require;

    if (typeof Proxy !== "undefined") {
      // allow Bokeh.loader["@bokehjs/module/name"] syntax
      main.loader = new Proxy({}, {
        get: function(_obj, module) {
          return require(module);
        }
      });
    }

    main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
      if (plugin_aliases === undefined) plugin_aliases = {};
      if (plugin_externals === undefined) plugin_externals = {};

      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      for (var name in plugin_externals) {
        externals[name] = plugin_externals[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
/* main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(2) /* ./index */, exports);
},
/* tslib/tslib.es6.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) {
                for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p];
            };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    exports.__extends = __extends;
    exports.__assign = function () {
        exports.__assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return exports.__assign.apply(this, arguments);
    };
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    exports.__rest = __rest;
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    exports.__decorate = __decorate;
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    exports.__param = __param;
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    exports.__metadata = __metadata;
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
                try {
                    step(generator.next(value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function rejected(value) {
                try {
                    step(generator["throw"](value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    exports.__awaiter = __awaiter;
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () {
                if (t[0] & 1)
                    throw t[1];
                return t[1];
            }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (_)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    exports.__generator = __generator;
    exports.__createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        Object.defineProperty(o, k2, { enumerable: true, get: function () { return m[k]; } });
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, o) {
        for (var p in m)
            if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
                exports.__createBinding(o, m, p);
    }
    exports.__exportStar = __exportStar;
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    exports.__values = __values;
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    exports.__read = __read;
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    exports.__spread = __spread;
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    exports.__spreadArrays = __spreadArrays;
    ;
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    exports.__await = __await;
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) {
            if (g[n])
                i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); };
        }
        function resume(n, v) {
            try {
                step(g[n](v));
            }
            catch (e) {
                settle(q[0][3], e);
            }
        }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) {
            if (f(v), q.shift(), q.length)
                resume(q[0][0], q[0][1]);
        }
    }
    exports.__asyncGenerator = __asyncGenerator;
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }
    exports.__asyncDelegator = __asyncDelegator;
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    exports.__asyncValues = __asyncValues;
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    exports.__makeTemplateObject = __makeTemplateObject;
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    exports.__createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    }
    exports.__importStar = __importStar;
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    exports.__importDefault = __importDefault;
    function __classPrivateFieldGet(receiver, privateMap) {
        if (!privateMap.has(receiver)) {
            throw new TypeError("attempted to get private field on non-instance");
        }
        return privateMap.get(receiver);
    }
    exports.__classPrivateFieldGet = __classPrivateFieldGet;
    function __classPrivateFieldSet(receiver, privateMap, value) {
        if (!privateMap.has(receiver)) {
            throw new TypeError("attempted to set private field on non-instance");
        }
        privateMap.set(receiver, value);
        return value;
    }
    exports.__classPrivateFieldSet = __classPrivateFieldSet;
},
/* index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var version_1 = require(3) /* ./version */;
    __esExport("version", version_1.version);
    var embed_1 = require(4) /* ./embed */;
    __esExport("index", embed_1.index);
    exports.embed = tslib_1.__importStar(require(4) /* ./embed */);
    exports.protocol = tslib_1.__importStar(require(396) /* ./protocol */);
    exports._testing = tslib_1.__importStar(require(397) /* ./testing */);
    var logging_1 = require(19) /* ./core/logging */;
    __esExport("logger", logging_1.logger);
    __esExport("set_log_level", logging_1.set_log_level);
    var settings_1 = require(27) /* ./core/settings */;
    __esExport("settings", settings_1.settings);
    var base_1 = require(7) /* ./base */;
    __esExport("Models", base_1.Models);
    var document_1 = require(5) /* ./document */;
    __esExport("documents", document_1.documents);
    var safely_1 = require(398) /* ./safely */;
    __esExport("safely", safely_1.safely);
},
/* version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.version = "2.3.0-dev.5";
},
/* embed/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const document_1 = require(5) /* ../document */;
    const logging_1 = require(19) /* ../core/logging */;
    const string_1 = require(29) /* ../core/util/string */;
    const object_1 = require(13) /* ../core/util/object */;
    const types_1 = require(8) /* ../core/util/types */;
    const defer_1 = require(16) /* ../core/util/defer */;
    const standalone_1 = require(387) /* ./standalone */;
    const server_1 = require(389) /* ./server */;
    const dom_1 = require(388) /* ./dom */;
    var standalone_2 = require(387) /* ./standalone */;
    __esExport("add_document_standalone", standalone_2.add_document_standalone);
    __esExport("index", standalone_2.index);
    var server_2 = require(389) /* ./server */;
    __esExport("add_document_from_session", server_2.add_document_from_session);
    var notebook_1 = require(394) /* ./notebook */;
    __esExport("embed_items_notebook", notebook_1.embed_items_notebook);
    __esExport("kernels", notebook_1.kernels);
    var dom_2 = require(388) /* ./dom */;
    __esExport("BOKEH_ROOT", dom_2.BOKEH_ROOT);
    async function embed_item(item, target_id) {
        const docs_json = {};
        const doc_id = string_1.uuid4();
        docs_json[doc_id] = item.doc;
        if (target_id == null)
            target_id = item.target_id;
        const element = document.getElementById(target_id);
        if (element != null)
            element.classList.add(dom_1.BOKEH_ROOT);
        const roots = { [item.root_id]: target_id };
        const render_item = { roots, root_ids: [item.root_id], docid: doc_id };
        await defer_1.defer();
        const [views] = await _embed_items(docs_json, [render_item]);
        return views;
    }
    exports.embed_item = embed_item;
    // TODO (bev) this is currently clunky. Standalone embeds only provide
    // the first two args, whereas server provide the app_app, and *may* prove and
    // absolute_url as well if non-relative links are needed for resources. This function
    // should probably be split in to two pieces to reflect the different usage patterns
    async function embed_items(docs_json, render_items, app_path, absolute_url) {
        await defer_1.defer();
        return _embed_items(docs_json, render_items, app_path, absolute_url);
    }
    exports.embed_items = embed_items;
    async function _embed_items(docs_json, render_items, app_path, absolute_url) {
        if (types_1.isString(docs_json))
            docs_json = JSON.parse(string_1.unescape(docs_json));
        const docs = {};
        for (const [docid, doc_json] of object_1.entries(docs_json)) {
            docs[docid] = document_1.Document.from_json(doc_json);
        }
        const views = [];
        for (const item of render_items) {
            const element = dom_1._resolve_element(item);
            const roots = dom_1._resolve_root_elements(item);
            if (item.docid != null) {
                views.push(await standalone_1.add_document_standalone(docs[item.docid], element, roots, item.use_for_title));
            }
            else if (item.token != null) {
                const websocket_url = server_1._get_ws_url(app_path, absolute_url);
                logging_1.logger.debug(`embed: computed ws url: ${websocket_url}`);
                try {
                    views.push(await server_1.add_document_from_session(websocket_url, item.token, element, roots, item.use_for_title));
                    console.log("Bokeh items were rendered successfully");
                }
                catch (error) {
                    console.log("Error rendering Bokeh items:", error);
                }
            }
            else
                throw new Error(`Error rendering Bokeh items: either 'docid' or 'token' was expected.`);
        }
        return views;
    }
},
/* document/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(6) /* ./document */, exports);
    tslib_1.__exportStar(require(133) /* ./events */, exports);
},
/* document/document.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const base_1 = require(7) /* ../base */;
    const version_1 = require(3) /* ../version */;
    const logging_1 = require(19) /* ../core/logging */;
    const bokeh_events_1 = require(80) /* ../core/bokeh_events */;
    const has_props_1 = require(14) /* ../core/has_props */;
    const serializer_1 = require(30) /* ../core/serializer */;
    const signaling_1 = require(15) /* ../core/signaling */;
    const refs_1 = require(17) /* ../core/util/refs */;
    const serialization_1 = require(278) /* ../core/util/serialization */;
    const array_1 = require(9) /* ../core/util/array */;
    const object_1 = require(13) /* ../core/util/object */;
    const sets = tslib_1.__importStar(require(132) /* ../core/util/set */);
    const eq_1 = require(26) /* ../core/util/eq */;
    const types_1 = require(8) /* ../core/util/types */;
    const layout_dom_1 = require(299) /* ../models/layouts/layout_dom */;
    const column_data_source_1 = require(130) /* ../models/sources/column_data_source */;
    const model_1 = require(88) /* ../model */;
    const events_1 = require(133) /* ./events */;
    // Dispatches events to the subscribed models
    class EventManager {
        constructor(document) {
            this.document = document;
            this.session = null;
            this.subscribed_models = new Set();
        }
        send_event(bokeh_event) {
            const event = new events_1.MessageSentEvent(this.document, "bokeh_event", bokeh_event.to_json());
            this.document._trigger_on_change(event);
        }
        trigger(event) {
            for (const model of this.subscribed_models) {
                if (event.origin != null && event.origin != model)
                    continue;
                model._process_event(event);
            }
        }
    }
    exports.EventManager = EventManager;
    EventManager.__name__ = "EventManager";
    exports.documents = [];
    exports.DEFAULT_TITLE = "Bokeh Application";
    // This class should match the API of the Python Document class
    // as much as possible.
    class Document {
        constructor() {
            exports.documents.push(this);
            this._init_timestamp = Date.now();
            this._title = exports.DEFAULT_TITLE;
            this._roots = [];
            this._all_models = new Map();
            this._all_models_freeze_count = 0;
            this._callbacks = new Map();
            this._message_callbacks = new Map();
            this.event_manager = new EventManager(this);
            this.idle = new signaling_1.Signal0(this, "idle");
            this._idle_roots = new WeakMap(); // TODO: WeakSet would be better
            this._interactive_timestamp = null;
            this._interactive_plot = null;
        }
        get layoutables() {
            return this._roots.filter((root) => root instanceof layout_dom_1.LayoutDOM);
        }
        get is_idle() {
            for (const root of this.layoutables) {
                if (!this._idle_roots.has(root))
                    return false;
            }
            return true;
        }
        notify_idle(model) {
            this._idle_roots.set(model, true);
            if (this.is_idle) {
                logging_1.logger.info(`document idle at ${Date.now() - this._init_timestamp} ms`);
                this.event_manager.send_event(new bokeh_events_1.DocumentReady());
                this.idle.emit();
            }
        }
        clear() {
            this._push_all_models_freeze();
            try {
                while (this._roots.length > 0) {
                    this.remove_root(this._roots[0]);
                }
            }
            finally {
                this._pop_all_models_freeze();
            }
        }
        interactive_start(plot) {
            if (this._interactive_plot == null) {
                this._interactive_plot = plot;
                this._interactive_plot.trigger_event(new bokeh_events_1.LODStart());
            }
            this._interactive_timestamp = Date.now();
        }
        interactive_stop() {
            if (this._interactive_plot != null) {
                this._interactive_plot.trigger_event(new bokeh_events_1.LODEnd());
            }
            this._interactive_plot = null;
            this._interactive_timestamp = null;
        }
        interactive_duration() {
            if (this._interactive_timestamp == null)
                return -1;
            else
                return Date.now() - this._interactive_timestamp;
        }
        destructively_move(dest_doc) {
            if (dest_doc === this) {
                throw new Error("Attempted to overwrite a document with itself");
            }
            dest_doc.clear();
            // we have to remove ALL roots before adding any
            // to the new doc or else models referenced from multiple
            // roots could be in both docs at once, which isn't allowed.
            const roots = array_1.copy(this._roots);
            this.clear();
            for (const root of roots) {
                if (root.document != null)
                    throw new Error(`Somehow we didn't detach ${root}`);
            }
            if (this._all_models.size != 0) {
                throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);
            }
            for (const root of roots) {
                dest_doc.add_root(root);
            }
            dest_doc.set_title(this._title);
        }
        // TODO other fields of doc
        _push_all_models_freeze() {
            this._all_models_freeze_count += 1;
        }
        _pop_all_models_freeze() {
            this._all_models_freeze_count -= 1;
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        }
        /*protected*/ _invalidate_all_models() {
            logging_1.logger.debug("invalidating document models");
            // if freeze count is > 0, we'll recompute on unfreeze
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        }
        _recompute_all_models() {
            let new_all_models_set = new Set();
            for (const r of this._roots) {
                new_all_models_set = sets.union(new_all_models_set, r.references());
            }
            const old_all_models_set = new Set(this._all_models.values());
            const to_detach = sets.difference(old_all_models_set, new_all_models_set);
            const to_attach = sets.difference(new_all_models_set, old_all_models_set);
            const recomputed = new Map();
            for (const model of new_all_models_set) {
                recomputed.set(model.id, model);
            }
            for (const d of to_detach) {
                d.detach_document();
            }
            for (const a of to_attach) {
                a.attach_document(this);
            }
            this._all_models = recomputed;
        }
        roots() {
            return this._roots;
        }
        add_root(model, setter_id) {
            logging_1.logger.debug(`Adding root: ${model}`);
            if (array_1.includes(this._roots, model))
                return;
            this._push_all_models_freeze();
            try {
                this._roots.push(model);
            }
            finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new events_1.RootAddedEvent(this, model, setter_id));
        }
        remove_root(model, setter_id) {
            const i = this._roots.indexOf(model);
            if (i < 0)
                return;
            this._push_all_models_freeze();
            try {
                this._roots.splice(i, 1);
            }
            finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new events_1.RootRemovedEvent(this, model, setter_id));
        }
        title() {
            return this._title;
        }
        set_title(title, setter_id) {
            if (title !== this._title) {
                this._title = title;
                this._trigger_on_change(new events_1.TitleChangedEvent(this, title, setter_id));
            }
        }
        get_model_by_id(model_id) {
            var _a;
            return (_a = this._all_models.get(model_id)) !== null && _a !== void 0 ? _a : null;
        }
        get_model_by_name(name) {
            const found = [];
            for (const model of this._all_models.values()) {
                if (model instanceof model_1.Model && model.name == name)
                    found.push(model);
            }
            switch (found.length) {
                case 0:
                    return null;
                case 1:
                    return found[0];
                default:
                    throw new Error(`Multiple models are named '${name}'`);
            }
        }
        on_message(msg_type, callback) {
            const message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks == null)
                this._message_callbacks.set(msg_type, new Set([callback]));
            else
                message_callbacks.add(callback);
        }
        remove_on_message(msg_type, callback) {
            var _a;
            (_a = this._message_callbacks.get(msg_type)) === null || _a === void 0 ? void 0 : _a.delete(callback);
        }
        _trigger_on_message(msg_type, msg_data) {
            const message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks != null) {
                for (const cb of message_callbacks) {
                    cb(msg_data);
                }
            }
        }
        on_change(callback, allow_batches = false) {
            if (!this._callbacks.has(callback)) {
                this._callbacks.set(callback, allow_batches);
            }
        }
        remove_on_change(callback) {
            this._callbacks.delete(callback);
        }
        _trigger_on_change(event) {
            for (const [callback, allow_batches] of this._callbacks) {
                if (!allow_batches && event instanceof events_1.DocumentEventBatch) {
                    for (const ev of event.events) {
                        callback(ev);
                    }
                }
                else {
                    callback(event); // TODO
                }
            }
        }
        _notify_change(model, attr, old_value, new_value, options) {
            this._trigger_on_change(new events_1.ModelChangedEvent(this, model, attr, old_value, new_value, options === null || options === void 0 ? void 0 : options.setter_id, options === null || options === void 0 ? void 0 : options.hint));
        }
        static _instantiate_object(obj_id, obj_type, obj_attrs) {
            const full_attrs = Object.assign(Object.assign({}, obj_attrs), { id: obj_id, __deferred__: true });
            const model = base_1.Models(obj_type);
            return new model(full_attrs);
        }
        // given a JSON representation of all models in a graph, return a
        // dict of new model objects
        static _instantiate_references_json(references_json, existing_models) {
            var _a;
            // Create all instances, but without setting their props
            const references = new Map();
            for (const obj of references_json) {
                const obj_id = obj.id;
                const obj_type = obj.type;
                const obj_attrs = (_a = obj.attributes) !== null && _a !== void 0 ? _a : {};
                let instance = existing_models.get(obj_id);
                if (instance == null) {
                    instance = Document._instantiate_object(obj_id, obj_type, obj_attrs);
                    if (obj.subtype != null)
                        instance.set_subtype(obj.subtype);
                }
                references.set(instance.id, instance);
            }
            return references;
        }
        // if v looks like a ref, or a collection, resolve it, otherwise return it unchanged
        // recurse into collections but not into HasProps
        static _resolve_refs(value, old_references, new_references, buffers) {
            function resolve_ref(v) {
                if (refs_1.is_ref(v)) {
                    if (old_references.has(v.id))
                        return old_references.get(v.id);
                    else if (new_references.has(v.id))
                        return new_references.get(v.id);
                    else
                        throw new Error(`reference ${JSON.stringify(v)} isn't known (not in Document?)`);
                }
                else if (serialization_1.is_NDArray_ref(v)) {
                    return serialization_1.decode_NDArray(v, buffers);
                }
                else if (types_1.isArray(v))
                    return resolve_array(v);
                else if (types_1.isPlainObject(v))
                    return resolve_dict(v);
                else
                    return v;
            }
            function resolve_array(array) {
                const results = [];
                for (const v of array) {
                    results.push(resolve_ref(v));
                }
                return results;
            }
            function resolve_dict(dict) {
                const resolved = {};
                for (const [k, v] of object_1.entries(dict)) {
                    resolved[k] = resolve_ref(v);
                }
                return resolved;
            }
            return resolve_ref(value);
        }
        // given a JSON representation of all models in a graph and new
        // model instances, set the properties on the models from the
        // JSON
        static _initialize_references_json(references_json, old_references, new_references, buffers) {
            const to_update = new Map();
            for (const { id, attributes } of references_json) {
                const is_new = !old_references.has(id);
                const instance = is_new ? new_references.get(id) : old_references.get(id);
                // replace references with actual instances in obj_attrs
                const resolved_attrs = Document._resolve_refs(attributes, old_references, new_references, buffers);
                instance.setv(resolved_attrs, { silent: true });
                to_update.set(id, { instance, is_new });
            }
            const ordered_instances = [];
            const handled = new Set();
            function finalize_all_by_dfs(v) {
                if (v instanceof has_props_1.HasProps) {
                    // note that we ignore instances that aren't updated (not in to_update)
                    if (to_update.has(v.id) && !handled.has(v.id)) {
                        handled.add(v.id);
                        const { instance, is_new } = to_update.get(v.id);
                        const { attributes } = instance;
                        for (const value of object_1.values(attributes)) {
                            finalize_all_by_dfs(value);
                        }
                        if (is_new) {
                            // Finalizing here just to avoid iterating
                            // over `ordered_instances` twice.
                            instance.finalize();
                            // Preserving an ordered collection of instances
                            // to avoid having to go through DFS again.
                            ordered_instances.push(instance);
                        }
                    }
                }
                else if (types_1.isArray(v)) {
                    for (const e of v)
                        finalize_all_by_dfs(e);
                }
                else if (types_1.isPlainObject(v)) {
                    for (const value of object_1.values(v))
                        finalize_all_by_dfs(value);
                }
            }
            for (const item of to_update.values()) {
                finalize_all_by_dfs(item.instance);
            }
            // `connect_signals` has to be executed last because it
            // may rely on properties of dependencies that are initialized
            // only in `finalize`. It's a problem that appears when
            // there are circular references, e.g. as in
            // CDS -> CustomJS (on data change) -> GlyphRenderer (in args) -> CDS.
            for (const instance of ordered_instances) {
                instance.connect_signals();
            }
        }
        //////
        ///{{{
        static _event_for_attribute_change(changed_obj, key, new_value, doc, value_refs) {
            const changed_model = doc.get_model_by_id(changed_obj.id); // XXX!
            if (!changed_model.property(key).syncable)
                return null;
            else {
                const event = {
                    kind: "ModelChanged",
                    model: { id: changed_obj.id },
                    attr: key,
                    new: new_value,
                };
                has_props_1.HasProps._json_record_references(doc, new_value, value_refs, { recursive: true });
                return event;
            }
        }
        static _events_to_sync_objects(from_obj, to_obj, to_doc, value_refs) {
            const from_keys = Object.keys(from_obj.attributes); //XXX!
            const to_keys = Object.keys(to_obj.attributes); //XXX!
            const removed = array_1.difference(from_keys, to_keys);
            const added = array_1.difference(to_keys, from_keys);
            const shared = array_1.intersection(from_keys, to_keys);
            const events = [];
            for (const key of removed) {
                // we don't really have a "remove" event - not sure this ever
                // happens even. One way this could happen is if the server
                // does include_defaults=True and we do
                // include_defaults=false ... in that case it'd be best to
                // just ignore this probably. Warn about it, could mean
                // there's a bug if we don't have a key that the server sent.
                logging_1.logger.warn(`Server sent key ${key} but we don't seem to have it in our JSON`);
            }
            for (const key of added) {
                const new_value = to_obj.attributes[key]; // XXX!
                events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
            }
            for (const key of shared) {
                const old_value = from_obj.attributes[key]; // XXX!
                const new_value = to_obj.attributes[key]; // XXX!
                if (old_value == null && new_value == null) {
                }
                else if (old_value == null || new_value == null) {
                    events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
                else {
                    if (!eq_1.is_equal(old_value, new_value))
                        events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
            }
            return events.filter((e) => e != null);
        }
        // we use this to detect changes during document deserialization
        // (in model constructors and initializers)
        static _compute_patch_since_json(from_json, to_doc) {
            const to_json = to_doc.to_json(false); // include_defaults=false
            function refs(json) {
                const result = new Map();
                for (const obj of json.roots.references)
                    result.set(obj.id, obj);
                return result;
            }
            const from_references = refs(from_json);
            const from_roots = new Map();
            const from_root_ids = [];
            for (const r of from_json.roots.root_ids) {
                from_roots.set(r, from_references.get(r));
                from_root_ids.push(r);
            }
            const to_references = refs(to_json);
            const to_roots = new Map();
            const to_root_ids = [];
            for (const r of to_json.roots.root_ids) {
                to_roots.set(r, to_references.get(r));
                to_root_ids.push(r);
            }
            from_root_ids.sort();
            to_root_ids.sort();
            if (array_1.difference(from_root_ids, to_root_ids).length > 0 ||
                array_1.difference(to_root_ids, from_root_ids).length > 0) {
                // this would arise if someone does add_root/remove_root during
                // document deserialization, hopefully they won't ever do so.
                throw new Error("Not implemented: computing add/remove of document roots");
            }
            const value_refs = new Set();
            let events = [];
            for (const id of to_doc._all_models.keys()) {
                if (from_references.has(id)) {
                    const update_model_events = Document._events_to_sync_objects(from_references.get(id), to_references.get(id), to_doc, value_refs);
                    events = events.concat(update_model_events);
                }
            }
            const serializer = new serializer_1.Serializer({ include_defaults: false });
            serializer.to_serializable([...value_refs]);
            return {
                references: [...serializer.definitions],
                events,
            };
        }
        ///}}}
        //////
        to_json_string(include_defaults = true) {
            return JSON.stringify(this.to_json(include_defaults));
        }
        to_json(include_defaults = true) {
            const serializer = new serializer_1.Serializer({ include_defaults });
            const roots = serializer.to_serializable(this._roots);
            return {
                version: version_1.version,
                title: this._title,
                roots: {
                    root_ids: roots.map((r) => r.id),
                    references: [...serializer.definitions],
                },
            };
        }
        static from_json_string(s) {
            const json = JSON.parse(s);
            return Document.from_json(json);
        }
        static from_json(json) {
            logging_1.logger.debug("Creating Document from JSON");
            function pyify(version) {
                return version.replace(/-(dev|rc)\./, "$1");
            }
            const py_version = json.version; // XXX!
            const is_dev = py_version.indexOf('+') !== -1 || py_version.indexOf('-') !== -1;
            const versions_string = `Library versions: JS (${version_1.version}) / Python (${py_version})`;
            if (!is_dev && pyify(version_1.version) != py_version) {
                logging_1.logger.warn("JS/Python version mismatch");
                logging_1.logger.warn(versions_string);
            }
            else
                logging_1.logger.debug(versions_string);
            const roots_json = json.roots;
            const root_ids = roots_json.root_ids;
            const references_json = roots_json.references;
            const references = Document._instantiate_references_json(references_json, new Map());
            Document._initialize_references_json(references_json, new Map(), references, new Map());
            const doc = new Document();
            for (const id of root_ids) {
                const root = references.get(id);
                if (root != null) {
                    doc.add_root(root); // XXX: HasProps
                }
            }
            doc.set_title(json.title); // XXX!
            return doc;
        }
        replace_with_json(json) {
            const replacement = Document.from_json(json);
            replacement.destructively_move(this);
        }
        create_json_patch_string(events) {
            return JSON.stringify(this.create_json_patch(events));
        }
        create_json_patch(events) {
            for (const event of events) {
                if (event.document != this)
                    throw new Error("Cannot create a patch using events from a different document");
            }
            const serializer = new serializer_1.Serializer();
            return {
                events: serializer.to_serializable(events),
                references: [...serializer.definitions],
            };
        }
        apply_json_patch(patch, buffers = new Map(), setter_id) {
            const references_json = patch.references;
            const events_json = patch.events;
            const references = Document._instantiate_references_json(references_json, this._all_models);
            if (!(buffers instanceof Map)) {
                buffers = new Map(buffers);
            }
            // The model being changed isn't always in references so add it in
            for (const event_json of events_json) {
                switch (event_json.kind) {
                    case "RootAdded":
                    case "RootRemoved":
                    case "ModelChanged": {
                        const model_id = event_json.model.id;
                        const model = this._all_models.get(model_id);
                        if (model != null) {
                            references.set(model_id, model);
                        }
                        else if (!references.has(model_id)) {
                            logging_1.logger.warn(`Got an event for unknown model ${event_json.model}"`);
                            throw new Error("event model wasn't known");
                        }
                        break;
                    }
                }
            }
            // split references into old and new so we know whether to initialize or update
            const old_references = new Map();
            const new_references = new Map();
            for (const [id, value] of references) {
                if (this._all_models.has(id))
                    old_references.set(id, value);
                else
                    new_references.set(id, value);
            }
            Document._initialize_references_json(references_json, old_references, new_references, buffers);
            for (const event_json of events_json) {
                switch (event_json.kind) {
                    case 'MessageSent': {
                        const { msg_type, msg_data } = event_json;
                        let data;
                        if (msg_data === undefined) {
                            if (buffers.size == 1) {
                                const [[, buffer]] = buffers;
                                data = buffer;
                            }
                            else {
                                throw new Error("expected exactly one buffer");
                            }
                        }
                        else {
                            data = Document._resolve_refs(msg_data, old_references, new_references, buffers);
                        }
                        this._trigger_on_message(msg_type, data);
                        break;
                    }
                    case 'ModelChanged': {
                        const patched_id = event_json.model.id;
                        const patched_obj = this._all_models.get(patched_id);
                        if (patched_obj == null) {
                            throw new Error(`Cannot apply patch to ${patched_id} which is not in the document`);
                        }
                        const attr = event_json.attr;
                        const value = Document._resolve_refs(event_json.new, old_references, new_references, buffers);
                        patched_obj.setv({ [attr]: value }, { setter_id });
                        break;
                    }
                    case 'ColumnDataChanged': {
                        const column_source_id = event_json.column_source.id;
                        const column_source = this._all_models.get(column_source_id);
                        if (column_source == null) {
                            throw new Error(`Cannot stream to ${column_source_id} which is not in the document`);
                        }
                        const data = Document._resolve_refs(event_json.new, new Map(), new Map(), buffers);
                        if (event_json.cols != null) {
                            for (const k in column_source.data) {
                                if (!(k in data)) {
                                    data[k] = column_source.data[k];
                                }
                            }
                        }
                        column_source.setv({ data }, { setter_id, check_eq: false });
                        break;
                    }
                    case 'ColumnsStreamed': {
                        const column_source_id = event_json.column_source.id;
                        const column_source = this._all_models.get(column_source_id);
                        if (column_source == null) {
                            throw new Error(`Cannot stream to ${column_source_id} which is not in the document`);
                        }
                        if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                            throw new Error("Cannot stream to non-ColumnDataSource");
                        }
                        const data = event_json.data;
                        const rollover = event_json.rollover;
                        column_source.stream(data, rollover, setter_id);
                        break;
                    }
                    case 'ColumnsPatched': {
                        const column_source_id = event_json.column_source.id;
                        const column_source = this._all_models.get(column_source_id);
                        if (column_source == null) {
                            throw new Error(`Cannot patch ${column_source_id} which is not in the document`);
                        }
                        if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                            throw new Error("Cannot patch non-ColumnDataSource");
                        }
                        const patches = event_json.patches;
                        column_source.patch(patches, setter_id);
                        break;
                    }
                    case 'RootAdded': {
                        const root_id = event_json.model.id;
                        const root_obj = references.get(root_id);
                        this.add_root(root_obj, setter_id); // XXX: HasProps
                        break;
                    }
                    case 'RootRemoved': {
                        const root_id = event_json.model.id;
                        const root_obj = references.get(root_id);
                        this.remove_root(root_obj, setter_id); // XXX: HasProps
                        break;
                    }
                    case 'TitleChanged': {
                        this.set_title(event_json.title, setter_id);
                        break;
                    }
                    default:
                        throw new Error("Unknown patch event " + JSON.stringify(event_json));
                }
            }
        }
    }
    exports.Document = Document;
    Document.__name__ = "Document";
},
/* base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const types_1 = require(8) /* ./core/util/types */;
    const object_1 = require(13) /* ./core/util/object */;
    const has_props_1 = require(14) /* ./core/has_props */;
    exports.overrides = {};
    const _all_models = new Map();
    exports.Models = ((name) => {
        var _a;
        const model = (_a = exports.overrides[name]) !== null && _a !== void 0 ? _a : _all_models.get(name);
        if (model == null) {
            throw new Error(`Model '${name}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`);
        }
        return model;
    });
    exports.Models.register = (name, model) => {
        exports.overrides[name] = model;
    };
    exports.Models.unregister = (name) => {
        delete exports.overrides[name];
    };
    function is_HasProps(obj) {
        return types_1.isObject(obj) && obj.prototype instanceof has_props_1.HasProps;
    }
    exports.Models.register_models = (models, force = false, errorFn) => {
        if (models == null)
            return;
        for (const model of object_1.values(models)) {
            if (is_HasProps(model)) {
                const qualified = model.__qualified__;
                if (force || !_all_models.has(qualified))
                    _all_models.set(qualified, model);
                else if (errorFn != null)
                    errorFn(qualified);
                else
                    console.warn(`Model '${qualified}' was already registered`);
            }
        }
    };
    exports.register_models = exports.Models.register_models;
    exports.Models.registered_names = () => [..._all_models.keys()];
    // TODO: this doesn't belong here, but it's easier this way for backwards compatibility
    const AllModels = tslib_1.__importStar(require(33) /* ./models */);
    exports.register_models(AllModels);
},
/* core/util/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    const array_1 = require(9) /* ./array */;
    const toString = Object.prototype.toString;
    function isBoolean(obj) {
        return obj === true || obj === false || toString.call(obj) === '[object Boolean]';
    }
    exports.isBoolean = isBoolean;
    function isNumber(obj) {
        return toString.call(obj) === "[object Number]";
    }
    exports.isNumber = isNumber;
    function isInteger(obj) {
        return isNumber(obj) && Number.isInteger(obj);
    }
    exports.isInteger = isInteger;
    function isString(obj) {
        return toString.call(obj) === "[object String]";
    }
    exports.isString = isString;
    function isPrimitive(obj) {
        return obj === null || isBoolean(obj) || isNumber(obj) || isString(obj);
    }
    exports.isPrimitive = isPrimitive;
    function isFunction(obj) {
        return toString.call(obj) === "[object Function]";
    }
    exports.isFunction = isFunction;
    function isArray(obj) {
        return Array.isArray(obj);
    }
    exports.isArray = isArray;
    function isArrayOf(arr, predicate) {
        return array_1.every(arr, predicate);
    }
    exports.isArrayOf = isArrayOf;
    function isArrayableOf(arr, predicate) {
        for (let i = 0, end = arr.length; i < end; i++) {
            if (!predicate(arr[i]))
                return false;
        }
        return true;
    }
    exports.isArrayableOf = isArrayableOf;
    function isTypedArray(obj) {
        return ArrayBuffer.isView(obj) && !(obj instanceof DataView);
    }
    exports.isTypedArray = isTypedArray;
    function isObject(obj) {
        const tp = typeof obj;
        return tp === 'function' || tp === 'object' && !!obj;
    }
    exports.isObject = isObject;
    function isPlainObject(obj) {
        return isObject(obj) && (obj.constructor == null || obj.constructor === Object);
    }
    exports.isPlainObject = isPlainObject;
    function isIterable(obj) {
        return Symbol.iterator in Object(obj);
    }
    exports.isIterable = isIterable;
},
/* core/util/array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    const math_1 = require(10) /* ./math */;
    const assert_1 = require(11) /* ./assert */;
    const arrayable_1 = require(12) /* ./arrayable */;
    __esExport("map", arrayable_1.map);
    __esExport("reduce", arrayable_1.reduce);
    __esExport("min", arrayable_1.min);
    __esExport("min_by", arrayable_1.min_by);
    __esExport("max", arrayable_1.max);
    __esExport("max_by", arrayable_1.max_by);
    __esExport("sum", arrayable_1.sum);
    __esExport("cumsum", arrayable_1.cumsum);
    __esExport("every", arrayable_1.every);
    __esExport("some", arrayable_1.some);
    __esExport("find", arrayable_1.find);
    __esExport("find_last", arrayable_1.find_last);
    __esExport("find_index", arrayable_1.find_index);
    __esExport("find_last_index", arrayable_1.find_last_index);
    __esExport("sorted_index", arrayable_1.sorted_index);
    __esExport("is_empty", arrayable_1.is_empty);
    const slice = Array.prototype.slice;
    function head(array) {
        return array[0];
    }
    exports.head = head;
    function tail(array) {
        return array[array.length - 1];
    }
    exports.tail = tail;
    function last(array) {
        return array[array.length - 1];
    }
    exports.last = last;
    function copy(array) {
        return slice.call(array);
    }
    exports.copy = copy;
    function concat(arrays) {
        return [].concat(...arrays);
    }
    exports.concat = concat;
    function includes(array, value) {
        return array.indexOf(value) !== -1;
    }
    exports.includes = includes;
    exports.contains = includes;
    function nth(array, index) {
        return array[index >= 0 ? index : array.length + index];
    }
    exports.nth = nth;
    function zip(...arrays) {
        if (arrays.length == 0)
            return [];
        const n = arrayable_1.min(arrays.map((a) => a.length));
        const k = arrays.length;
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[i] = new Array(k);
            for (let j = 0; j < k; j++)
                result[i][j] = arrays[j][i];
        }
        return result;
    }
    exports.zip = zip;
    function unzip(array) {
        const n = array.length;
        const k = arrayable_1.min(array.map((a) => a.length));
        const results = Array(k);
        for (let j = 0; j < k; j++)
            results[j] = new Array(n);
        for (let i = 0; i < n; i++) {
            for (let j = 0; j < k; j++)
                results[j][i] = array[i][j];
        }
        return results;
    }
    exports.unzip = unzip;
    function range(start, stop, step = 1) {
        assert_1.assert(step > 0, "'step' must be a positive number");
        if (stop == null) {
            stop = start;
            start = 0;
        }
        const { max, ceil, abs } = Math;
        const delta = start <= stop ? step : -step;
        const length = max(ceil(abs(stop - start) / step), 0);
        const range = new Array(length);
        for (let i = 0; i < length; i++, start += delta) {
            range[i] = start;
        }
        return range;
    }
    exports.range = range;
    function linspace(start, stop, num = 100) {
        const step = (stop - start) / (num - 1);
        const array = new Array(num);
        for (let i = 0; i < num; i++) {
            array[i] = start + step * i;
        }
        return array;
    }
    exports.linspace = linspace;
    function transpose(array) {
        const rows = array.length;
        const cols = array[0].length;
        const transposed = [];
        for (let j = 0; j < cols; j++) {
            transposed[j] = [];
            for (let i = 0; i < rows; i++) {
                transposed[j][i] = array[i][j];
            }
        }
        return transposed;
    }
    exports.transpose = transpose;
    function argmin(array) {
        return arrayable_1.min_by(range(array.length), (i) => array[i]);
    }
    exports.argmin = argmin;
    function argmax(array) {
        return arrayable_1.max_by(range(array.length), (i) => array[i]);
    }
    exports.argmax = argmax;
    function sort_by(array, key) {
        const tmp = array.map((value, index) => {
            return { value, index, key: key(value) };
        });
        tmp.sort((left, right) => {
            const a = left.key;
            const b = right.key;
            if (a !== b) {
                if (a > b || a === undefined)
                    return 1;
                if (a < b || b === undefined)
                    return -1;
            }
            return left.index - right.index;
        });
        return tmp.map((item) => item.value);
    }
    exports.sort_by = sort_by;
    function uniq(array) {
        const result = new Set();
        for (const value of array) {
            result.add(value);
        }
        return [...result];
    }
    exports.uniq = uniq;
    function uniq_by(array, key) {
        const result = [];
        const seen = [];
        for (const value of array) {
            const computed = key(value);
            if (!includes(seen, computed)) {
                seen.push(computed);
                result.push(value);
            }
        }
        return result;
    }
    exports.uniq_by = uniq_by;
    function union(...arrays) {
        const result = new Set();
        for (const array of arrays) {
            for (const value of array) {
                result.add(value);
            }
        }
        return [...result];
    }
    exports.union = union;
    function intersection(array, ...arrays) {
        const result = [];
        top: for (const item of array) {
            if (includes(result, item))
                continue;
            for (const other of arrays) {
                if (!includes(other, item))
                    continue top;
            }
            result.push(item);
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(array, ...arrays) {
        const rest = concat(arrays);
        return array.filter((value) => !includes(rest, value));
    }
    exports.difference = difference;
    function remove_at(array, i) {
        const result = copy(array);
        result.splice(i, 1);
        return result;
    }
    exports.remove_at = remove_at;
    function remove_by(array, key) {
        for (let i = 0; i < array.length;) {
            if (key(array[i]))
                array.splice(i, 1);
            else
                i++;
        }
    }
    exports.remove_by = remove_by;
    // Shuffle a collection, using the modern version of the
    // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
    function shuffle(array) {
        const length = array.length;
        const shuffled = new Array(length);
        for (let i = 0; i < length; i++) {
            const rand = math_1.randomIn(0, i);
            if (rand !== i)
                shuffled[i] = shuffled[rand];
            shuffled[rand] = array[i];
        }
        return shuffled;
    }
    exports.shuffle = shuffle;
    function pairwise(array, fn) {
        const n = array.length;
        const result = new Array(n - 1);
        for (let i = 0; i < n - 1; i++) {
            result[i] = fn(array[i], array[i + 1]);
        }
        return result;
    }
    exports.pairwise = pairwise;
    function reversed(array) {
        const n = array.length;
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[n - i - 1] = array[i];
        }
        return result;
    }
    exports.reversed = reversed;
    function repeat(value, n) {
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[i] = value;
        }
        return result;
    }
    exports.repeat = repeat;
},
/* core/util/math.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function angle_norm(angle) {
        if (angle == 0) {
            return 0;
        }
        while (angle <= 0) {
            angle += 2 * Math.PI;
        }
        while (angle > 2 * Math.PI) {
            angle -= 2 * Math.PI;
        }
        return angle;
    }
    exports.angle_norm = angle_norm;
    function angle_dist(lhs, rhs) {
        return angle_norm(lhs - rhs);
    }
    exports.angle_dist = angle_dist;
    function angle_between(mid, lhs, rhs, anticlock = false) {
        const d = angle_dist(lhs, rhs);
        if (d == 0)
            return false;
        if (d == 2 * Math.PI)
            return true;
        const norm_mid = angle_norm(mid);
        const cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
        return !anticlock ? cond : !cond;
    }
    exports.angle_between = angle_between;
    function random() {
        return Math.random();
    }
    exports.random = random;
    function randomIn(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    }
    exports.randomIn = randomIn;
    function atan2(start, end) {
        /*
         * Calculate the angle between a line containing start and end points (composed
         * of [x, y] arrays) and the positive x-axis.
         */
        return Math.atan2(end[1] - start[1], end[0] - start[0]);
    }
    exports.atan2 = atan2;
    function radians(degrees) {
        return degrees * (Math.PI / 180);
    }
    exports.radians = radians;
    function degrees(radians) {
        return radians / (Math.PI / 180);
    }
    exports.degrees = degrees;
    // http://www2.econ.osaka-u.ac.jp/~tanizaki/class/2013/econome3/13.pdf (Page 432)
    function rnorm(mu, sigma) {
        // Generate a random normal with a mean of 0 and a sigma of 1
        let r1;
        let r2;
        while (true) {
            r1 = random();
            r2 = random();
            r2 = (2 * r2 - 1) * Math.sqrt(2 * (1 / Math.E));
            if (-4 * r1 * r1 * Math.log(r1) >= r2 * r2)
                break;
        }
        let rn = r2 / r1;
        // Transform the standard normal to meet the characteristics that we want (mu, sigma)
        rn = mu + sigma * rn;
        return rn;
    }
    exports.rnorm = rnorm;
    function clamp(val, min, max) {
        return val < min ? min : (val > max ? max : val);
    }
    exports.clamp = clamp;
    function log(x, base = Math.E) {
        return Math.log(x) / Math.log(base);
    }
    exports.log = log;
},
/* core/util/assert.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class AssertionError extends Error {
    }
    exports.AssertionError = AssertionError;
    AssertionError.__name__ = "AssertionError";
    function assert(condition, message) {
        if (condition === true || (condition !== false && condition()))
            return;
        throw new AssertionError(message !== null && message !== void 0 ? message : "Assertion failed");
    }
    exports.assert = assert;
    function unreachable() {
        throw new Error("unreachable code");
    }
    exports.unreachable = unreachable;
},
/* core/util/arrayable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./types */;
    const math_1 = require(10) /* ./math */;
    function is_empty(array) {
        return array.length == 0;
    }
    exports.is_empty = is_empty;
    function copy(array) {
        if (types_1.isArray(array))
            return array.slice();
        else
            return new array.constructor(array);
    }
    exports.copy = copy;
    function splice(array, start, k, ...items) {
        const len = array.length;
        if (start < 0)
            start += len;
        if (start < 0)
            start = 0;
        else if (start > len)
            start = len;
        if (k == null || k > len - start)
            k = len - start;
        else if (k < 0)
            k = 0;
        const n = len - k + items.length;
        const result = new array.constructor(n);
        let i = 0;
        for (; i < start; i++) {
            result[i] = array[i];
        }
        for (const item of items) {
            result[i++] = item;
        }
        for (let j = start + k; j < len; j++) {
            result[i++] = array[j];
        }
        return result;
    }
    exports.splice = splice;
    function head(array, n) {
        return splice(array, n, array.length - n);
    }
    exports.head = head;
    function insert(array, item, i) {
        return splice(array, i, 0, item);
    }
    exports.insert = insert;
    function append(array, item) {
        return splice(array, array.length, 0, item);
    }
    exports.append = append;
    function prepend(array, item) {
        return splice(array, 0, 0, item);
    }
    exports.prepend = prepend;
    function indexOf(array, item) {
        for (let i = 0, n = array.length; i < n; i++) {
            if (array[i] === item)
                return i;
        }
        return -1;
    }
    exports.indexOf = indexOf;
    function subselect(array, indices) {
        const n = indices.length;
        const result = new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = array[indices[i]];
        }
        return result;
    }
    exports.subselect = subselect;
    function map(array, fn) {
        const n = array.length;
        const result = new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = fn(array[i], i, array);
        }
        return result;
    }
    exports.map = map;
    function filter(array, pred) {
        const n = array.length;
        const result = new array.constructor(n);
        let k = 0;
        for (let i = 0; i < n; i++) {
            const value = array[i];
            if (pred(value, i, array))
                result[k++] = value;
        }
        return head(result, k);
    }
    exports.filter = filter;
    function reduce(array, fn, initial) {
        const n = array.length;
        if (initial === undefined && n == 0)
            throw new Error("can't reduce an empty array without an initial value");
        let value;
        let i;
        if (initial === undefined) {
            value = array[0];
            i = 1;
        }
        else {
            value = initial;
            i = 0;
        }
        for (; i < n; i++) {
            value = fn(value, array[i], i, array);
        }
        return value;
    }
    exports.reduce = reduce;
    function min(array) {
        let value;
        let result = Infinity;
        for (let i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value) && value < result) {
                result = value;
            }
        }
        return result;
    }
    exports.min = min;
    function max(array) {
        let value;
        let result = -Infinity;
        for (let i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value) && value > result) {
                result = value;
            }
        }
        return result;
    }
    exports.max = max;
    function minmax(array) {
        let value;
        let min = +Infinity;
        let max = -Infinity;
        for (let i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value)) {
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
            }
        }
        return [min, max];
    }
    exports.minmax = minmax;
    function min_by(array, key) {
        if (array.length == 0)
            throw new Error("min_by() called with an empty array");
        let result = array[0];
        let resultComputed = key(result);
        for (let i = 1, length = array.length; i < length; i++) {
            const value = array[i];
            const computed = key(value);
            if (computed < resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.min_by = min_by;
    function max_by(array, key) {
        if (array.length == 0)
            throw new Error("max_by() called with an empty array");
        let result = array[0];
        let resultComputed = key(result);
        for (let i = 1, length = array.length; i < length; i++) {
            const value = array[i];
            const computed = key(value);
            if (computed > resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.max_by = max_by;
    function sum(array) {
        let result = 0;
        for (let i = 0, n = array.length; i < n; i++) {
            result += array[i];
        }
        return result;
    }
    exports.sum = sum;
    function cumsum(array) {
        const result = new array.constructor(array.length);
        reduce(array, (a, b, i) => result[i] = a + b, 0);
        return result;
    }
    exports.cumsum = cumsum;
    function every(array, predicate) {
        for (let i = 0, length = array.length; i < length; i++) {
            if (!predicate(array[i]))
                return false;
        }
        return true;
    }
    exports.every = every;
    function some(array, predicate) {
        for (let i = 0, length = array.length; i < length; i++) {
            if (predicate(array[i]))
                return true;
        }
        return false;
    }
    exports.some = some;
    function index_of(array, value) {
        for (let i = 0, length = array.length; i < length; i++) {
            if (array[i] === value)
                return i;
        }
        return -1;
    }
    exports.index_of = index_of;
    function _find_index(dir) {
        return function (array, predicate) {
            const length = array.length;
            let index = dir > 0 ? 0 : length - 1;
            for (; index >= 0 && index < length; index += dir) {
                if (predicate(array[index]))
                    return index;
            }
            return -1;
        };
    }
    exports.find_index = _find_index(1);
    exports.find_last_index = _find_index(-1);
    function find(array, predicate) {
        const index = exports.find_index(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find = find;
    function find_last(array, predicate) {
        const index = exports.find_last_index(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find_last = find_last;
    function sorted_index(array, value) {
        let low = 0;
        let high = array.length;
        while (low < high) {
            const mid = Math.floor((low + high) / 2);
            if (array[mid] < value)
                low = mid + 1;
            else
                high = mid;
        }
        return low;
    }
    exports.sorted_index = sorted_index;
    function bin_counts(data, bin_edges) {
        const nbins = bin_edges.length - 1;
        const counts = Array(nbins).fill(0);
        for (let i = 0; i < data.length; i++) {
            const sample = data[i];
            const index = sorted_index(bin_edges, sample);
            const bin = math_1.clamp(index - 1, 0, nbins - 1);
            counts[bin] += 1;
        }
        return counts;
    }
    exports.bin_counts = bin_counts;
    function interpolate(points, x_values, y_values) {
        // Implementation ported from np.interp
        const n = points.length;
        const results = new Array(n);
        for (let i = 0; i < n; i++) {
            const point = points[i];
            if (isNaN(point)) {
                results[i] = point;
                continue;
            }
            const index = left_edge_index(point, x_values);
            if (index == -1)
                results[i] = y_values[0];
            else if (index == x_values.length)
                results[i] = y_values[y_values.length - 1];
            else if (index == x_values.length - 1 || x_values[index] == point) {
                results[i] = y_values[index];
            }
            else {
                const x0 = x_values[index];
                const y0 = y_values[index];
                const x1 = x_values[index + 1];
                const y1 = y_values[index + 1];
                results[i] = lerp(point, x0, y0, x1, y1);
            }
        }
        return results;
    }
    exports.interpolate = interpolate;
    function lerp(x, x0, y0, x1, y1) {
        const slope = (y1 - y0) / (x1 - x0);
        let res = slope * (x - x0) + y0;
        if (!isFinite(res)) {
            res = slope * (x - x1) + y1;
            if (!isFinite(res) && (y0 == y1))
                res = y0;
        }
        return res;
    }
    function left_edge_index(point, intervals) {
        if (point < intervals[0])
            return -1;
        if (point > intervals[intervals.length - 1])
            return intervals.length;
        let leftEdgeIndex = 0;
        let rightEdgeIndex = intervals.length - 1;
        while (rightEdgeIndex - leftEdgeIndex != 1) {
            const indexOfNumberToCompare = leftEdgeIndex + Math.floor((rightEdgeIndex - leftEdgeIndex) / 2);
            if (point >= intervals[indexOfNumberToCompare])
                leftEdgeIndex = indexOfNumberToCompare;
            else
                rightEdgeIndex = indexOfNumberToCompare;
        }
        return leftEdgeIndex;
    }
    exports.left_edge_index = left_edge_index;
    function norm(array, start, end) {
        const span = end - start;
        return map(array, (x) => (x - start) / span);
    }
    exports.norm = norm;
},
/* core/util/object.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const array_1 = require(9) /* ./array */;
    exports.keys = Object.keys, exports.values = Object.values, exports.entries = Object.entries, exports.extend = Object.assign;
    function clone(obj) {
        return Object.assign({}, obj);
    }
    exports.clone = clone;
    function merge(obj1, obj2) {
        /*
         * Returns an object with the array values for obj1 and obj2 unioned by key.
         */
        const result = Object.create(Object.prototype);
        const keys = array_1.concat([Object.keys(obj1), Object.keys(obj2)]);
        for (const key of keys) {
            const arr1 = obj1.hasOwnProperty(key) ? obj1[key] : [];
            const arr2 = obj2.hasOwnProperty(key) ? obj2[key] : [];
            result[key] = array_1.union(arr1, arr2);
        }
        return result;
    }
    exports.merge = merge;
    function size(obj) {
        return Object.keys(obj).length;
    }
    exports.size = size;
    function isEmpty(obj) {
        return size(obj) == 0;
    }
    exports.isEmpty = isEmpty;
    function to_object(map) {
        const obj = {};
        for (const [key, val] of map) {
            obj[key] = val;
        }
        return obj;
    }
    exports.to_object = to_object;
},
/* core/has_props.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const signaling_1 = require(15) /* ./signaling */;
    const refs_1 = require(17) /* ./util/refs */;
    const p = tslib_1.__importStar(require(18) /* ./properties */);
    const k = tslib_1.__importStar(require(21) /* ./kinds */);
    const mixins = tslib_1.__importStar(require(28) /* ./property_mixins */);
    const string_1 = require(29) /* ./util/string */;
    const array_1 = require(9) /* ./util/array */;
    const object_1 = require(13) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    const eq_1 = require(26) /* ./util/eq */;
    const serializer_1 = require(30) /* ./serializer */;
    const document_1 = require(5) /* ../document */;
    const eq_2 = require(26) /* ./util/eq */;
    const pretty_1 = require(31) /* ./util/pretty */;
    const cloneable_1 = require(32) /* ./util/cloneable */;
    const kinds = tslib_1.__importStar(require(21) /* ./kinds */);
    class HasProps extends signaling_1.Signalable() {
        constructor(attrs = {}) {
            var _a, _b;
            super();
            this._subtype = undefined;
            this.document = null;
            this.destroyed = new signaling_1.Signal0(this, "destroyed");
            this.change = new signaling_1.Signal0(this, "change");
            this.transformchange = new signaling_1.Signal0(this, "transformchange");
            this.properties = {};
            this._pending = false;
            this._changing = false;
            const get = attrs instanceof Map ? attrs.get.bind(attrs) : (name) => attrs[name];
            this.id = (_a = get("id")) !== null && _a !== void 0 ? _a : string_1.uniqueId();
            for (const [name, { type, default_value, options }] of object_1.entries(this._props)) {
                let property;
                if (type instanceof p.PropertyAlias) {
                    property = new Proxy(this.properties[type.attr], {
                        get(target, member) {
                            return member == "attr" ? name : target[member];
                        },
                    });
                }
                else if (type instanceof k.Kind)
                    property = new p.PrimitiveProperty(this, name, type, default_value, get(name), options);
                else
                    property = new type(this, name, k.Any, default_value, get(name), options);
                this.properties[name] = property;
            }
            // allowing us to defer initialization when loading many models
            // when loading a bunch of models, we want to do initialization as a second pass
            // because other objects that this one depends on might not be loaded yet
            if (!((_b = get("__deferred__")) !== null && _b !== void 0 ? _b : false)) {
                this.finalize();
                this.connect_signals();
            }
        }
        // XXX: setter is only required for backwards compatibility
        set type(name) {
            console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead");
            this.constructor.__name__ = name;
        }
        get type() {
            return this.constructor.__qualified__;
        }
        static get __qualified__() {
            const { __module__, __name__ } = this;
            return __module__ != null ? `${__module__}.${__name__}` : __name__;
        }
        static get [Symbol.toStringTag]() {
            return this.__name__;
        }
        static init_HasProps() {
            this.prototype._props = {};
            this.prototype._mixins = [];
        }
        static _fix_default(default_value, _attr) {
            if (default_value === undefined || types_1.isFunction(default_value))
                return default_value;
            else if (types_1.isPrimitive(default_value))
                return () => default_value;
            else {
                const cloner = new cloneable_1.Cloner();
                return () => cloner.clone(default_value);
            }
        }
        // TODO: don't use Partial<>, but exclude inherited properties
        static define(obj) {
            for (const [name, prop] of object_1.entries(types_1.isFunction(obj) ? obj(kinds) : obj)) {
                if (this.prototype._props[name] != null)
                    throw new Error(`attempted to redefine property '${this.prototype.type}.${name}'`);
                if (this.prototype[name] != null)
                    throw new Error(`attempted to redefine attribute '${this.prototype.type}.${name}'`);
                Object.defineProperty(this.prototype, name, {
                    // XXX: don't use tail calls in getters/setters due to https://bugs.webkit.org/show_bug.cgi?id=164306
                    get() {
                        const value = this.properties[name].get_value();
                        return value;
                    },
                    set(value) {
                        this.setv({ [name]: value });
                        return this;
                    },
                    configurable: false,
                    enumerable: true,
                });
                const [type, default_value, options] = prop;
                const refined_prop = {
                    type,
                    default_value: this._fix_default(default_value, name),
                    options,
                };
                const props = Object.assign({}, this.prototype._props);
                props[name] = refined_prop;
                this.prototype._props = props;
            }
        }
        static internal(obj) {
            const _object = {};
            for (const [name, prop] of object_1.entries(types_1.isFunction(obj) ? obj(kinds) : obj)) {
                const [type, default_value, options = {}] = prop;
                _object[name] = [type, default_value, Object.assign(Object.assign({}, options), { internal: true })];
            }
            this.define(_object);
        }
        static mixins(defs) {
            if (!types_1.isArray(defs))
                defs = [defs];
            function resolve(kind) {
                switch (kind) {
                    case "line": return mixins.LineVector;
                    case "fill": return mixins.FillVector;
                    case "hatch": return mixins.HatchVector;
                    case "text": return mixins.TextVector;
                    default:
                        throw new Error(`Unknown property mixin kind '${kind}'`);
                }
            }
            function rename(prefix, mixin) {
                const result = {};
                for (const [name, prop] of object_1.entries(mixin)) {
                    result[prefix + name] = prop;
                }
                return result;
            }
            function kind_of(mixin) {
                const [key] = Object.keys(mixin);
                const [kind] = key.split("_", 1);
                return kind;
            }
            const mixin_defs = {};
            const names = [];
            for (const def of defs) {
                if (types_1.isString(def)) {
                    // TODO: remove this branch in 3.0
                    const [kind, prefix = ""] = def.split(":");
                    const mixin = resolve(kind);
                    names.push(def);
                    object_1.extend(mixin_defs, rename(prefix, mixin));
                }
                else if (types_1.isArray(def)) {
                    const [prefix, mixin] = def;
                    names.push(`${kind_of(mixin)}:${prefix}`);
                    object_1.extend(mixin_defs, rename(prefix, mixin));
                }
                else {
                    const mixin = def;
                    names.push(kind_of(mixin));
                    object_1.extend(mixin_defs, mixin);
                }
            }
            this.define(mixin_defs);
            this.prototype._mixins = [...this.prototype._mixins, ...names];
        }
        static override(obj) {
            for (const [name, prop] of object_1.entries(obj)) {
                const default_value = this._fix_default(prop, name);
                const value = this.prototype._props[name];
                if (value == null)
                    throw new Error(`attempted to override nonexistent '${this.prototype.type}.${name}'`);
                const props = Object.assign({}, this.prototype._props);
                props[name] = Object.assign(Object.assign({}, value), { default_value });
                this.prototype._props = props;
            }
        }
        toString() {
            return `${this.type}(${this.id})`;
        }
        property(name) {
            const prop = this.properties[name];
            if (prop != null)
                return prop;
            else
                throw new Error(`unknown property ${this.type}.${name}`);
        }
        get attributes() {
            const attrs = {};
            for (const prop of this) {
                attrs[prop.attr] = prop.get_value();
            }
            return attrs;
        }
        [cloneable_1.clone](cloner) {
            const attrs = new Map();
            for (const prop of this) {
                if (prop.dirty) {
                    attrs.set(prop.attr, cloner.clone(prop.get_value()));
                }
            }
            return new this.constructor(attrs);
        }
        [eq_2.equals](that, cmp) {
            for (const p0 of this) {
                const p1 = that.property(p0.attr);
                if (cmp.eq(p0.get_value(), p1.get_value()))
                    return false;
            }
            return true;
        }
        [pretty_1.pretty](printer) {
            const T = printer.token;
            const items = [];
            for (const prop of this) {
                if (prop.dirty) {
                    const value = prop.get_value();
                    items.push(`${prop.attr}${T(":")} ${printer.to_string(value)}`);
                }
            }
            const cls = this.constructor.__qualified__;
            return `${cls}${T("(")}${T("{")}${items.join(`${T(",")} `)}${T("}")}${T(")")}`;
        }
        [serializer_1.serialize](serializer) {
            const ref = this.ref();
            serializer.add_ref(this, ref);
            const struct = this.struct();
            for (const prop of this) {
                if (prop.syncable && (serializer.include_defaults || prop.dirty)) {
                    struct.attributes[prop.attr] = serializer.to_serializable(prop.get_value());
                }
            }
            serializer.add_def(this, struct);
            return ref;
        }
        finalize() {
            for (const prop of this) {
                if (prop.spec.transform != null)
                    this.connect(prop.spec.transform.change, () => this.transformchange.emit());
            }
            this.initialize();
        }
        initialize() { }
        connect_signals() { }
        disconnect_signals() {
            signaling_1.Signal.disconnectReceiver(this);
        }
        destroy() {
            this.disconnect_signals();
            this.destroyed.emit();
        }
        // Create a new model with exact attribute values to this one, but new identity.
        clone() {
            const cloner = new cloneable_1.Cloner();
            return cloner.clone(this);
        }
        // Set a hash of model attributes on the object, firing `"change"`. This is
        // the core primitive operation of a model, updating the data and notifying
        // anyone who needs to know about the change in state. The heart of the beast.
        _setv(changes, options) {
            // Extract attributes and options.
            const check_eq = options.check_eq;
            const changed = [];
            const changing = this._changing;
            this._changing = true;
            for (const [prop, value] of changes) {
                if (check_eq === false || !eq_1.is_equal(prop.get_value(), value)) {
                    prop.set_value(value);
                    changed.push(prop);
                }
            }
            // Trigger all relevant attribute changes.
            if (changed.length > 0)
                this._pending = true;
            for (const prop of changed) {
                prop.change.emit();
            }
            // You might be wondering why there's a `while` loop here. Changes can
            // be recursively nested within `"change"` events.
            if (changing)
                return;
            if (!options.no_change) {
                while (this._pending) {
                    this._pending = false;
                    this.change.emit();
                }
            }
            this._pending = false;
            this._changing = false;
        }
        setv(changed_attrs, options = {}) {
            const changes = object_1.entries(changed_attrs);
            if (changes.length == 0)
                return;
            if (options.silent === true) {
                for (const [attr, value] of changes) {
                    this.properties[attr].set_value(value);
                }
                return;
            }
            const changed = new Map();
            const previous = new Map();
            for (const [attr, value] of changes) {
                const prop = this.properties[attr];
                changed.set(prop, value);
                previous.set(prop, prop.get_value());
            }
            this._setv(changed, options);
            const { document } = this;
            if (document != null) {
                const changed = [];
                for (const [prop, value] of previous) {
                    changed.push([prop, value, prop.get_value()]);
                }
                for (const [, old_value, new_value] of changed) {
                    if (this._needs_invalidate(old_value, new_value)) {
                        document._invalidate_all_models();
                        break;
                    }
                }
                this._push_changes(changed, options);
            }
        }
        /** @deprecated */
        getv(name) {
            return this.property(name).get_value();
        }
        ref() {
            return { id: this.id };
        }
        struct() {
            const struct = {
                type: this.type,
                id: this.id,
                attributes: {},
            };
            if (this._subtype != null) {
                struct.subtype = this._subtype;
            }
            return struct;
        }
        // we only keep the subtype so we match Python;
        // only Python cares about this
        set_subtype(subtype) {
            this._subtype = subtype;
        }
        *[Symbol.iterator]() {
            yield* object_1.values(this.properties);
        }
        *syncable_properties() {
            for (const prop of this) {
                if (prop.syncable)
                    yield prop;
            }
        }
        /** @deprecated */
        serializable_attributes() {
            const attrs = {};
            for (const prop of this.syncable_properties()) {
                attrs[prop.attr] = prop.get_value();
            }
            return attrs;
        }
        // this is like _value_record_references but expects to find refs
        // instead of models, and takes a doc to look up the refs in
        static _json_record_references(doc, v, refs, options) {
            const { recursive } = options;
            if (refs_1.is_ref(v)) {
                const model = doc.get_model_by_id(v.id);
                if (model != null && !refs.has(model)) {
                    HasProps._value_record_references(model, refs, { recursive });
                }
            }
            else if (types_1.isArray(v)) {
                for (const elem of v)
                    HasProps._json_record_references(doc, elem, refs, { recursive });
            }
            else if (types_1.isPlainObject(v)) {
                for (const elem of object_1.values(v)) {
                    HasProps._json_record_references(doc, elem, refs, { recursive });
                }
            }
        }
        // add all references from 'v' to 'result', if recurse
        // is true then descend into refs, if false only
        // descend into non-refs
        static _value_record_references(v, refs, options) {
            const { recursive } = options;
            if (v instanceof HasProps) {
                if (!refs.has(v)) {
                    refs.add(v);
                    if (recursive) {
                        for (const prop of v.syncable_properties()) {
                            const value = prop.get_value();
                            HasProps._value_record_references(value, refs, { recursive });
                        }
                    }
                }
            }
            else if (types_1.isArray(v)) {
                for (const elem of v)
                    HasProps._value_record_references(elem, refs, { recursive });
            }
            else if (types_1.isPlainObject(v)) {
                for (const elem of object_1.values(v)) {
                    HasProps._value_record_references(elem, refs, { recursive });
                }
            }
        }
        references() {
            const refs = new Set();
            HasProps._value_record_references(this, refs, { recursive: true });
            return refs;
        }
        _doc_attached() { }
        _doc_detached() { }
        attach_document(doc) {
            // This should only be called by the Document implementation to set the document field
            if (this.document != null && this.document != doc)
                throw new Error("models must be owned by only a single document");
            this.document = doc;
            this._doc_attached();
        }
        detach_document() {
            // This should only be called by the Document implementation to unset the document field
            this._doc_detached();
            this.document = null;
        }
        _needs_invalidate(old_value, new_value) {
            const new_refs = new Set();
            HasProps._value_record_references(new_value, new_refs, { recursive: false });
            const old_refs = new Set();
            HasProps._value_record_references(old_value, old_refs, { recursive: false });
            for (const new_id of new_refs) {
                if (!old_refs.has(new_id))
                    return true;
            }
            for (const old_id of old_refs) {
                if (!new_refs.has(old_id))
                    return true;
            }
            return false;
        }
        _push_changes(changes, options = {}) {
            const { document } = this;
            if (document == null)
                return;
            const { setter_id } = options;
            const events = [];
            for (const [prop, old_value, new_value] of changes) {
                if (prop.syncable)
                    events.push(new document_1.ModelChangedEvent(document, this, prop.attr, old_value, new_value, setter_id));
            }
            if (events.length != 0) {
                let event;
                if (events.length == 1)
                    [event] = events;
                else
                    event = new document_1.DocumentEventBatch(document, events, setter_id);
                document._trigger_on_change(event);
            }
        }
        materialize_dataspecs(source) {
            // Note: this should be moved to a function separate from HasProps
            const data = {};
            for (const prop of this) {
                if (!(prop instanceof p.VectorSpec))
                    continue;
                // this skips optional properties like radius for circles
                if (prop.optional && prop.spec.value == null && !prop.dirty)
                    continue;
                const name = prop.attr;
                const array = prop.array(source);
                data[`_${name}`] = array;
                if (prop instanceof p.DistanceSpec)
                    data[`max_${name}`] = array_1.max(array);
            }
            return data;
        }
        on_change(properties, fn) {
            for (const property of types_1.isArray(properties) ? properties : [properties]) {
                this.connect(property.change, fn);
            }
        }
    }
    exports.HasProps = HasProps;
    HasProps.init_HasProps();
},
/* core/signaling.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // Based on https://github.com/phosphorjs/phosphor/blob/master/packages/signaling/src/index.ts
    const defer_1 = require(16) /* ./util/defer */;
    const array_1 = require(9) /* ./util/array */;
    class Signal {
        constructor(sender, name) {
            this.sender = sender;
            this.name = name;
        }
        connect(slot, context = null) {
            if (!receiversForSender.has(this.sender)) {
                receiversForSender.set(this.sender, []);
            }
            const receivers = receiversForSender.get(this.sender);
            if (find_connection(receivers, this, slot, context) != null) {
                return false;
            }
            const receiver = context !== null && context !== void 0 ? context : slot;
            if (!sendersForReceiver.has(receiver)) {
                sendersForReceiver.set(receiver, []);
            }
            const senders = sendersForReceiver.get(receiver);
            const connection = { signal: this, slot, context };
            receivers.push(connection);
            senders.push(connection);
            return true;
        }
        disconnect(slot, context = null) {
            const receivers = receiversForSender.get(this.sender);
            if (receivers == null || receivers.length === 0) {
                return false;
            }
            const connection = find_connection(receivers, this, slot, context);
            if (connection == null) {
                return false;
            }
            const receiver = context !== null && context !== void 0 ? context : slot;
            const senders = sendersForReceiver.get(receiver);
            connection.signal = null;
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
            return true;
        }
        emit(args) {
            var _a;
            const receivers = (_a = receiversForSender.get(this.sender)) !== null && _a !== void 0 ? _a : [];
            for (const { signal, slot, context } of receivers) {
                if (signal === this) {
                    slot.call(context, args, this.sender);
                }
            }
        }
    }
    exports.Signal = Signal;
    Signal.__name__ = "Signal";
    class Signal0 extends Signal {
        emit() {
            super.emit(undefined);
        }
    }
    exports.Signal0 = Signal0;
    Signal0.__name__ = "Signal0";
    (function (Signal) {
        function disconnect_between(sender, receiver) {
            const receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            const senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (const connection of senders) {
                if (connection.signal == null)
                    return;
                if (connection.signal.sender === sender)
                    connection.signal = null;
            }
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
        }
        Signal.disconnect_between = disconnect_between;
        function disconnect_sender(sender) {
            var _a;
            const receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            for (const connection of receivers) {
                if (connection.signal == null)
                    return;
                const receiver = (_a = connection.context) !== null && _a !== void 0 ? _a : connection.slot;
                connection.signal = null;
                schedule_cleanup(sendersForReceiver.get(receiver));
            }
            schedule_cleanup(receivers);
        }
        Signal.disconnect_sender = disconnect_sender;
        function disconnect_receiver(receiver, slot, except_senders) {
            const senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (const connection of senders) {
                if (connection.signal == null)
                    return;
                if (slot != null && connection.slot != slot)
                    continue;
                const sender = connection.signal.sender;
                if (except_senders != null && except_senders.has(sender))
                    continue;
                connection.signal = null;
                schedule_cleanup(receiversForSender.get(sender));
            }
            schedule_cleanup(senders);
        }
        Signal.disconnect_receiver = disconnect_receiver;
        function disconnect_all(obj) {
            const receivers = receiversForSender.get(obj);
            if (receivers != null && receivers.length !== 0) {
                for (const connection of receivers) {
                    connection.signal = null;
                }
                schedule_cleanup(receivers);
            }
            const senders = sendersForReceiver.get(obj);
            if (senders != null && senders.length !== 0) {
                for (const connection of senders) {
                    connection.signal = null;
                }
                schedule_cleanup(senders);
            }
        }
        Signal.disconnect_all = disconnect_all;
        /** @deprecated */
        Signal.disconnectBetween = disconnect_between;
        /** @deprecated */
        Signal.disconnectSender = disconnect_sender;
        /** @deprecated */
        Signal.disconnectReceiver = disconnect_receiver;
        /** @deprecated */
        Signal.disconnectAll = disconnect_all;
    })(Signal || (exports.Signal = Signal = {}));
    function Signalable() {
        return class {
            connect(signal, slot) {
                return signal.connect(slot, this);
            }
            disconnect(signal, slot) {
                return signal.disconnect(slot, this);
            }
        };
    }
    exports.Signalable = Signalable;
    const receiversForSender = new WeakMap();
    const sendersForReceiver = new WeakMap();
    function find_connection(conns, signal, slot, context) {
        return array_1.find(conns, conn => conn.signal === signal && conn.slot === slot && conn.context === context);
    }
    const dirty_set = new Set();
    function schedule_cleanup(connections) {
        if (dirty_set.size === 0) {
            (async () => {
                await defer_1.defer();
                cleanup_dirty_set();
            })();
        }
        dirty_set.add(connections);
    }
    function cleanup_dirty_set() {
        for (const connections of dirty_set) {
            array_1.remove_by(connections, (connection) => connection.signal == null);
        }
        dirty_set.clear();
    }
},
/* core/util/defer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const channel = new MessageChannel();
    const tasks = new Map();
    channel.port1.onmessage = (event) => {
        const handle = event.data;
        const fn = tasks.get(handle);
        if (fn != null) {
            try {
                fn();
            }
            finally {
                tasks.delete(handle);
            }
        }
    };
    let counter = 1;
    function defer() {
        return new Promise((resolve) => {
            const handle = counter++;
            tasks.set(handle, resolve);
            channel.port2.postMessage(handle);
        });
    }
    exports.defer = defer;
},
/* core/util/refs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./types */;
    const object_1 = require(13) /* ./object */;
    // Determine whether an object has the proper format of a Bokeh reference
    //
    // @param arg [Object] the object to test
    // @return [bool] whether the object is a reference
    //
    // @note this function does not check that the id and types are valid,
    //   only that the format is correct (all required keys are present)
    //
    function is_ref(arg) {
        if (types_1.isPlainObject(arg)) {
            const attrs = object_1.keys(arg);
            return attrs.length == 1 && attrs[0] == "id";
        }
        return false;
    }
    exports.is_ref = is_ref;
},
/* core/properties.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const signaling_1 = require(15) /* ./signaling */;
    const logging_1 = require(19) /* ./logging */;
    const enums = tslib_1.__importStar(require(20) /* ./enums */);
    const types_1 = require(24) /* ./types */;
    const array_1 = require(9) /* ./util/array */;
    const arrayable_1 = require(12) /* ./util/arrayable */;
    const color_1 = require(22) /* ./util/color */;
    const types_2 = require(8) /* ./util/types */;
    const settings_1 = require(27) /* ./settings */;
    function valueToString(value) {
        try {
            return JSON.stringify(value);
        }
        catch (_a) {
            return value.toString();
        }
    }
    function isSpec(obj) {
        return types_2.isPlainObject(obj) &&
            ((obj.value === undefined ? 0 : 1) +
                (obj.field === undefined ? 0 : 1) +
                (obj.expr === undefined ? 0 : 1) == 1); // garbage JS XOR
    }
    exports.isSpec = isSpec;
    class Property {
        constructor(obj, attr, kind, default_value, initial_value, options = {}) {
            var _a, _b;
            this.obj = obj;
            this.attr = attr;
            this.kind = kind;
            this.default_value = default_value;
            this._dirty = false;
            this.change = new signaling_1.Signal0(this.obj, "change");
            this.internal = (_a = options.internal) !== null && _a !== void 0 ? _a : false;
            this.optional = (_b = options.optional) !== null && _b !== void 0 ? _b : false;
            this.on_update = options.on_update;
            let attr_value;
            if (initial_value !== undefined) {
                attr_value = initial_value;
                this._dirty = true;
            }
            else {
                const value = this._default_override();
                if (value !== undefined)
                    attr_value = value;
                else if (default_value !== undefined)
                    attr_value = default_value(obj);
                else {
                    // XXX: temporary and super sketchy, but affects only "readonly" and a few internal properties
                    // console.warn(`${this.obj}.${this.attr} has no value nor default`)
                    this.spec = { value: null };
                    return;
                }
            }
            this._update(attr_value);
        }
        get is_value() {
            return this.spec.value !== undefined;
        }
        get syncable() {
            return !this.internal;
        }
        get_value() {
            return this.spec.value;
        }
        set_value(val) {
            this._update(val);
            this._dirty = true;
        }
        // abstract _intrinsic_default(): T
        _default_override() {
            return undefined;
        }
        get dirty() {
            return this._dirty;
        }
        //protected abstract _update(attr_value: T): void
        _update(attr_value) {
            var _a;
            this.validate(attr_value);
            this.spec = { value: attr_value };
            (_a = this.on_update) === null || _a === void 0 ? void 0 : _a.call(this, attr_value, this.obj);
        }
        toString() {
            /*${this.name}*/
            return `Prop(${this.obj}.${this.attr}, spec: ${valueToString(this.spec)})`;
        }
        // ----- customizable policies
        normalize(values) {
            return values;
        }
        validate(value) {
            if (!this.valid(value))
                throw new Error(`${this.obj}.${this.attr} given invalid value: ${valueToString(value)}`);
        }
        valid(value) {
            return this.kind.valid(value);
        }
        // ----- property accessors
        value(do_spec_transform = true) {
            if (!this.is_value)
                throw new Error("attempted to retrieve property value for property without value specification");
            let ret = this.normalize([this.spec.value])[0];
            if (this.spec.transform != null && do_spec_transform)
                ret = this.spec.transform.compute(ret);
            return ret;
        }
    }
    exports.Property = Property;
    Property.__name__ = "Property";
    class PropertyAlias {
        constructor(attr) {
            this.attr = attr;
        }
    }
    exports.PropertyAlias = PropertyAlias;
    PropertyAlias.__name__ = "PropertyAlias";
    function Alias(attr) {
        return new PropertyAlias(attr);
    }
    exports.Alias = Alias;
    //
    // Primitive Properties
    //
    class PrimitiveProperty extends Property {
    }
    exports.PrimitiveProperty = PrimitiveProperty;
    PrimitiveProperty.__name__ = "PrimitiveProperty";
    /** @deprecated */
    class Any extends Property {
    }
    exports.Any = Any;
    Any.__name__ = "Any";
    /** @deprecated */
    class Array extends Property {
        valid(value) {
            return types_2.isArray(value) || value instanceof Float32Array || value instanceof Float64Array;
        }
    }
    exports.Array = Array;
    Array.__name__ = "Array";
    /** @deprecated */
    class Boolean extends Property {
        valid(value) {
            return types_2.isBoolean(value);
        }
    }
    exports.Boolean = Boolean;
    Boolean.__name__ = "Boolean";
    /** @deprecated */
    class Color extends Property {
        valid(value) {
            return types_2.isString(value) && color_1.is_color(value);
        }
    }
    exports.Color = Color;
    Color.__name__ = "Color";
    /** @deprecated */
    class Instance extends Property {
    }
    exports.Instance = Instance;
    Instance.__name__ = "Instance";
    /** @deprecated */
    class Number extends Property {
        valid(value) {
            return types_2.isNumber(value);
        }
    }
    exports.Number = Number;
    Number.__name__ = "Number";
    /** @deprecated */
    class Int extends Number {
        valid(value) {
            return types_2.isNumber(value) && (value | 0) == value;
        }
    }
    exports.Int = Int;
    Int.__name__ = "Int";
    /** @deprecated */
    class Angle extends Number {
    }
    exports.Angle = Angle;
    Angle.__name__ = "Angle";
    /** @deprecated */
    class Percent extends Number {
        valid(value) {
            return types_2.isNumber(value) && 0 <= value && value <= 1.0;
        }
    }
    exports.Percent = Percent;
    Percent.__name__ = "Percent";
    /** @deprecated */
    class String extends Property {
        valid(value) {
            return types_2.isString(value);
        }
    }
    exports.String = String;
    String.__name__ = "String";
    /** @deprecated */
    class NullString extends Property {
        valid(value) {
            return value === null || types_2.isString(value);
        }
    }
    exports.NullString = NullString;
    NullString.__name__ = "NullString";
    /** @deprecated */
    class FontSize extends String {
    }
    exports.FontSize = FontSize;
    FontSize.__name__ = "FontSize";
    /** @deprecated */
    class Font extends String {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : undefined;
        }
    }
    exports.Font = Font;
    Font.__name__ = "Font";
    //
    // Enum properties
    //
    /** @deprecated */
    class EnumProperty extends Property {
        valid(value) {
            return types_2.isString(value) && array_1.includes(this.enum_values, value);
        }
    }
    exports.EnumProperty = EnumProperty;
    EnumProperty.__name__ = "EnumProperty";
    /** @deprecated */
    function Enum(values) {
        return class extends EnumProperty {
            get enum_values() {
                return [...values];
            }
        };
    }
    exports.Enum = Enum;
    class Direction extends EnumProperty {
        get enum_values() {
            return [...enums.Direction];
        }
        normalize(values) {
            const result = new Uint8Array(values.length);
            for (let i = 0; i < values.length; i++) {
                switch (values[i]) {
                    case "clock":
                        result[i] = 0;
                        break;
                    case "anticlock":
                        result[i] = 1;
                        break;
                }
            }
            return result;
        }
    }
    exports.Direction = Direction;
    Direction.__name__ = "Direction";
    /** @deprecated */ exports.Anchor = Enum(enums.Anchor);
    /** @deprecated */ exports.AngleUnits = Enum(enums.AngleUnits);
    /** @deprecated */ exports.BoxOrigin = Enum(enums.BoxOrigin);
    /** @deprecated */ exports.ButtonType = Enum(enums.ButtonType);
    /** @deprecated */ exports.CalendarPosition = Enum(enums.CalendarPosition);
    /** @deprecated */ exports.Dimension = Enum(enums.Dimension);
    /** @deprecated */ exports.Dimensions = Enum(enums.Dimensions);
    /** @deprecated */ exports.Distribution = Enum(enums.Distribution);
    /** @deprecated */ exports.FontStyle = Enum(enums.FontStyle);
    /** @deprecated */ exports.HatchPatternType = Enum(enums.HatchPatternType);
    /** @deprecated */ exports.HTTPMethod = Enum(enums.HTTPMethod);
    /** @deprecated */ exports.HexTileOrientation = Enum(enums.HexTileOrientation);
    /** @deprecated */ exports.HoverMode = Enum(enums.HoverMode);
    /** @deprecated */ exports.LatLon = Enum(enums.LatLon);
    /** @deprecated */ exports.LegendClickPolicy = Enum(enums.LegendClickPolicy);
    /** @deprecated */ exports.LegendLocation = Enum(enums.LegendLocation);
    /** @deprecated */ exports.LineCap = Enum(enums.LineCap);
    /** @deprecated */ exports.LineJoin = Enum(enums.LineJoin);
    /** @deprecated */ exports.LinePolicy = Enum(enums.LinePolicy);
    /** @deprecated */ exports.Location = Enum(enums.Location);
    /** @deprecated */ exports.Logo = Enum(enums.Logo);
    /** @deprecated */ exports.MarkerType = Enum(enums.MarkerType);
    /** @deprecated */ exports.MutedPolicy = Enum(enums.MutedPolicy);
    /** @deprecated */ exports.Orientation = Enum(enums.Orientation);
    /** @deprecated */ exports.OutputBackend = Enum(enums.OutputBackend);
    /** @deprecated */ exports.PaddingUnits = Enum(enums.PaddingUnits);
    /** @deprecated */ exports.Place = Enum(enums.Place);
    /** @deprecated */ exports.PointPolicy = Enum(enums.PointPolicy);
    /** @deprecated */ exports.RadiusDimension = Enum(enums.RadiusDimension);
    /** @deprecated */ exports.RenderLevel = Enum(enums.RenderLevel);
    /** @deprecated */ exports.RenderMode = Enum(enums.RenderMode);
    /** @deprecated */ exports.ResetPolicy = Enum(enums.ResetPolicy);
    /** @deprecated */ exports.RoundingFunction = Enum(enums.RoundingFunction);
    /** @deprecated */ exports.Side = Enum(enums.Side);
    /** @deprecated */ exports.SizingMode = Enum(enums.SizingMode);
    /** @deprecated */ exports.Sort = Enum(enums.Sort);
    /** @deprecated */ exports.SpatialUnits = Enum(enums.SpatialUnits);
    /** @deprecated */ exports.StartEnd = Enum(enums.StartEnd);
    /** @deprecated */ exports.StepMode = Enum(enums.StepMode);
    /** @deprecated */ exports.TapBehavior = Enum(enums.TapBehavior);
    /** @deprecated */ exports.TextAlign = Enum(enums.TextAlign);
    /** @deprecated */ exports.TextBaseline = Enum(enums.TextBaseline);
    /** @deprecated */ exports.TextureRepetition = Enum(enums.TextureRepetition);
    /** @deprecated */ exports.TickLabelOrientation = Enum(enums.TickLabelOrientation);
    /** @deprecated */ exports.TooltipAttachment = Enum(enums.TooltipAttachment);
    /** @deprecated */ exports.UpdateMode = Enum(enums.UpdateMode);
    /** @deprecated */ exports.VerticalAlign = Enum(enums.VerticalAlign);
    //
    // DataSpec properties
    //
    class ScalarSpec extends Property {
        get_value() {
            // XXX: allow obj.x = null; obj.x == null
            return this.spec.value === null ? null : this.spec;
        }
        _update(attr_value) {
            if (isSpec(attr_value))
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            if (this.spec.value != null)
                this.validate(this.spec.value);
        }
    }
    exports.ScalarSpec = ScalarSpec;
    ScalarSpec.__name__ = "ScalarSpec";
    class AnyScalar extends ScalarSpec {
    }
    exports.AnyScalar = AnyScalar;
    AnyScalar.__name__ = "AnyScalar";
    class ColorScalar extends ScalarSpec {
    }
    exports.ColorScalar = ColorScalar;
    ColorScalar.__name__ = "ColorScalar";
    class NumberScalar extends ScalarSpec {
    }
    exports.NumberScalar = NumberScalar;
    NumberScalar.__name__ = "NumberScalar";
    class StringScalar extends ScalarSpec {
    }
    exports.StringScalar = StringScalar;
    StringScalar.__name__ = "StringScalar";
    class NullStringScalar extends ScalarSpec {
    }
    exports.NullStringScalar = NullStringScalar;
    NullStringScalar.__name__ = "NullStringScalar";
    class ArrayScalar extends ScalarSpec {
    }
    exports.ArrayScalar = ArrayScalar;
    ArrayScalar.__name__ = "ArrayScalar";
    class LineJoinScalar extends ScalarSpec {
    }
    exports.LineJoinScalar = LineJoinScalar;
    LineJoinScalar.__name__ = "LineJoinScalar";
    class LineCapScalar extends ScalarSpec {
    }
    exports.LineCapScalar = LineCapScalar;
    LineCapScalar.__name__ = "LineCapScalar";
    class FontSizeScalar extends ScalarSpec {
    }
    exports.FontSizeScalar = FontSizeScalar;
    FontSizeScalar.__name__ = "FontSizeScalar";
    class FontStyleScalar extends ScalarSpec {
    }
    exports.FontStyleScalar = FontStyleScalar;
    FontStyleScalar.__name__ = "FontStyleScalar";
    class TextAlignScalar extends ScalarSpec {
    }
    exports.TextAlignScalar = TextAlignScalar;
    TextAlignScalar.__name__ = "TextAlignScalar";
    class TextBaselineScalar extends ScalarSpec {
    }
    exports.TextBaselineScalar = TextBaselineScalar;
    TextBaselineScalar.__name__ = "TextBaselineScalar";
    class VectorSpec extends Property {
        get_value() {
            // XXX: allow obj.x = null; obj.x == null
            return this.spec.value === null ? null : this.spec;
        }
        _update(attr_value) {
            if (isSpec(attr_value))
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            if (this.spec.value != null)
                this.validate(this.spec.value);
        }
        array(source) {
            var _a;
            let array;
            const length = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if (this.spec.field != null) {
                const column = source.get_column(this.spec.field);
                if (column != null)
                    array = this.normalize(column);
                else {
                    logging_1.logger.warn(`attempted to retrieve property array for nonexistent field '${this.spec.field}'`);
                    const missing = new types_1.NumberArray(length);
                    missing.fill(NaN);
                    array = missing;
                }
            }
            else if (this.spec.expr != null) {
                array = this.normalize(this.spec.expr.v_compute(source));
            }
            else {
                const value = this.value(false); // don't apply any spec transform
                if (types_2.isNumber(value)) {
                    const values = new types_1.NumberArray(length);
                    values.fill(value);
                    array = values;
                }
                else
                    array = array_1.repeat(value, length);
            }
            if (this.spec.transform != null)
                array = this.spec.transform.v_compute(array);
            return array;
        }
    }
    exports.VectorSpec = VectorSpec;
    VectorSpec.__name__ = "VectorSpec";
    class DataSpec extends VectorSpec {
    }
    exports.DataSpec = DataSpec;
    DataSpec.__name__ = "DataSpec";
    class UnitsSpec extends VectorSpec {
        _update(attr_value) {
            super._update(attr_value);
            const { units } = this.spec;
            if (units != null && !array_1.includes(this.valid_units, units)) {
                throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${units}`);
            }
        }
        get units() {
            var _a;
            return (_a = this.spec.units) !== null && _a !== void 0 ? _a : this.default_units;
        }
        set units(units) {
            if (units != this.default_units)
                this.spec.units = units;
            else
                delete this.spec.units;
        }
    }
    exports.UnitsSpec = UnitsSpec;
    UnitsSpec.__name__ = "UnitsSpec";
    class NumberUnitsSpec extends UnitsSpec {
        array(source) {
            return new types_1.NumberArray(super.array(source));
        }
    }
    exports.NumberUnitsSpec = NumberUnitsSpec;
    NumberUnitsSpec.__name__ = "NumberUnitsSpec";
    class BaseCoordinateSpec extends DataSpec {
    }
    exports.BaseCoordinateSpec = BaseCoordinateSpec;
    BaseCoordinateSpec.__name__ = "BaseCoordinateSpec";
    class CoordinateSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSpec = CoordinateSpec;
    CoordinateSpec.__name__ = "CoordinateSpec";
    class CoordinateSeqSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSeqSpec = CoordinateSeqSpec;
    CoordinateSeqSpec.__name__ = "CoordinateSeqSpec";
    class CoordinateSeqSeqSeqSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSeqSeqSeqSpec = CoordinateSeqSeqSeqSpec;
    CoordinateSeqSeqSeqSpec.__name__ = "CoordinateSeqSeqSeqSpec";
    class XCoordinateSpec extends CoordinateSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSpec = XCoordinateSpec;
    XCoordinateSpec.__name__ = "XCoordinateSpec";
    class YCoordinateSpec extends CoordinateSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSpec = YCoordinateSpec;
    YCoordinateSpec.__name__ = "YCoordinateSpec";
    class XCoordinateSeqSpec extends CoordinateSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSeqSpec = XCoordinateSeqSpec;
    XCoordinateSeqSpec.__name__ = "XCoordinateSeqSpec";
    class YCoordinateSeqSpec extends CoordinateSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSeqSpec = YCoordinateSeqSpec;
    YCoordinateSeqSpec.__name__ = "YCoordinateSeqSpec";
    class XCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSeqSeqSeqSpec = XCoordinateSeqSeqSeqSpec;
    XCoordinateSeqSeqSeqSpec.__name__ = "XCoordinateSeqSeqSeqSpec";
    class YCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSeqSeqSeqSpec = YCoordinateSeqSeqSeqSpec;
    YCoordinateSeqSeqSeqSpec.__name__ = "YCoordinateSeqSeqSeqSpec";
    class AngleSpec extends NumberUnitsSpec {
        get default_units() { return "rad"; }
        get valid_units() { return [...enums.AngleUnits]; }
        normalize(values) {
            if (this.spec.units == "deg")
                values = arrayable_1.map(values, (x) => x * Math.PI / 180.0);
            values = arrayable_1.map(values, (x) => -x);
            return super.normalize(values);
        }
    }
    exports.AngleSpec = AngleSpec;
    AngleSpec.__name__ = "AngleSpec";
    class DistanceSpec extends NumberUnitsSpec {
        get default_units() { return "data"; }
        get valid_units() { return [...enums.SpatialUnits]; }
    }
    exports.DistanceSpec = DistanceSpec;
    DistanceSpec.__name__ = "DistanceSpec";
    class ScreenDistanceSpec extends DistanceSpec {
        get default_units() { return "screen"; }
    }
    exports.ScreenDistanceSpec = ScreenDistanceSpec;
    ScreenDistanceSpec.__name__ = "ScreenDistanceSpec";
    class BooleanSpec extends DataSpec {
        array(source) {
            return new Uint8Array(super.array(source));
        }
    }
    exports.BooleanSpec = BooleanSpec;
    BooleanSpec.__name__ = "BooleanSpec";
    class NumberSpec extends DataSpec {
        array(source) {
            return new types_1.NumberArray(super.array(source));
        }
    }
    exports.NumberSpec = NumberSpec;
    NumberSpec.__name__ = "NumberSpec";
    class ColorSpec extends DataSpec {
        array(source) {
            const colors = super.array(source);
            const n = colors.length;
            const array = new types_1.ColorArray(n);
            for (let i = 0; i < n; i++) {
                const color = colors[i];
                if (types_2.isNumber(color))
                    array[i] = color;
                else {
                    const rgba = color_1.color2rgba(color);
                    array[i] = color_1.encode_rgba(rgba);
                }
            }
            return array;
        }
    }
    exports.ColorSpec = ColorSpec;
    ColorSpec.__name__ = "ColorSpec";
    class FontSizeSpec extends DataSpec {
    }
    exports.FontSizeSpec = FontSizeSpec;
    FontSizeSpec.__name__ = "FontSizeSpec";
    class MarkerSpec extends DataSpec {
    }
    exports.MarkerSpec = MarkerSpec;
    MarkerSpec.__name__ = "MarkerSpec";
    class StringSpec extends DataSpec {
    }
    exports.StringSpec = StringSpec;
    StringSpec.__name__ = "StringSpec";
    class NullStringSpec extends DataSpec {
    }
    exports.NullStringSpec = NullStringSpec;
    NullStringSpec.__name__ = "NullStringSpec";
    class NDArraySpec extends DataSpec {
    }
    exports.NDArraySpec = NDArraySpec;
    NDArraySpec.__name__ = "NDArraySpec";
},
/* core/logging.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // This is based on https://github.com/pimterry/loglevel
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(13) /* ./util/object */;
    const _loggers = {};
    class LogLevel {
        constructor(name, level) {
            this.name = name;
            this.level = level;
        }
    }
    exports.LogLevel = LogLevel;
    LogLevel.__name__ = "LogLevel";
    class Logger {
        constructor(name, level = Logger.INFO) {
            this._name = name;
            this.set_level(level);
        }
        static get levels() {
            return Object.keys(Logger.log_levels);
        }
        static get(name, level = Logger.INFO) {
            if (name.length > 0) {
                let logger = _loggers[name];
                if (logger == null)
                    _loggers[name] = logger = new Logger(name, level);
                return logger;
            }
            else
                throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level");
        }
        get level() {
            return this.get_level();
        }
        get_level() {
            return this._log_level;
        }
        set_level(log_level) {
            if (log_level instanceof LogLevel)
                this._log_level = log_level;
            else if (types_1.isString(log_level) && Logger.log_levels[log_level] != null)
                this._log_level = Logger.log_levels[log_level];
            else
                throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
            const logger_name = `[${this._name}]`;
            for (const [name, log_level] of object_1.entries(Logger.log_levels)) {
                if (log_level.level < this._log_level.level || this._log_level.level === Logger.OFF.level)
                    this[name] = function () { };
                else
                    this[name] = _method_factory(name, logger_name);
            }
        }
        trace(..._args) { }
        debug(..._args) { }
        info(..._args) { }
        warn(..._args) { }
        error(..._args) { }
    }
    exports.Logger = Logger;
    Logger.__name__ = "Logger";
    Logger.TRACE = new LogLevel("trace", 0);
    Logger.DEBUG = new LogLevel("debug", 1);
    Logger.INFO = new LogLevel("info", 2);
    Logger.WARN = new LogLevel("warn", 6);
    Logger.ERROR = new LogLevel("error", 7);
    Logger.FATAL = new LogLevel("fatal", 8);
    Logger.OFF = new LogLevel("off", 9);
    Logger.log_levels = {
        trace: Logger.TRACE,
        debug: Logger.DEBUG,
        info: Logger.INFO,
        warn: Logger.WARN,
        error: Logger.ERROR,
        fatal: Logger.FATAL,
        off: Logger.OFF,
    };
    function _method_factory(method_name, logger_name) {
        if (console[method_name] != null)
            return console[method_name].bind(console, logger_name);
        else if (console.log != null)
            return console.log.bind(console, logger_name);
        else
            return function () { };
    }
    exports.logger = Logger.get("bokeh");
    function set_log_level(level) {
        const previous_level = exports.logger.level;
        if (types_1.isString(level) && Logger.log_levels[level] == null) {
            console.log(`[bokeh] unrecognized logging level '${level}' passed to Bokeh.set_log_level(), ignoring`);
            console.log(`[bokeh] valid log levels are: ${Logger.levels.join(', ')}`);
        }
        else {
            console.log(`[bokeh] setting log level to: '${types_1.isString(level) ? level : level.level}'`);
            exports.logger.set_level(level);
        }
        return previous_level;
    }
    exports.set_log_level = set_log_level;
    function with_log_level(level, fn) {
        const original = set_log_level(level);
        try {
            fn();
        }
        finally {
            set_log_level(original);
        }
    }
    exports.with_log_level = with_log_level;
},
/* core/enums.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const kinds_1 = require(21) /* ./kinds */;
    exports.Align = kinds_1.Enum("start", "center", "end");
    exports.Anchor = kinds_1.Enum("top_left", "top_center", "top_right", "center_left", "center", "center_right", "bottom_left", "bottom_center", "bottom_right");
    exports.AngleUnits = kinds_1.Enum("deg", "rad");
    exports.BoxOrigin = kinds_1.Enum("corner", "center");
    exports.ButtonType = kinds_1.Enum("default", "primary", "success", "warning", "danger");
    exports.CalendarPosition = kinds_1.Enum("auto", "above", "below");
    exports.Dimension = kinds_1.Enum("width", "height");
    exports.Dimensions = kinds_1.Enum("width", "height", "both");
    exports.Direction = kinds_1.Enum("clock", "anticlock");
    exports.Distribution = kinds_1.Enum("uniform", "normal");
    exports.FontStyle = kinds_1.Enum("normal", "italic", "bold", "bold italic");
    exports.HatchPatternType = kinds_1.Enum('blank', 'dot', 'ring', 'horizontal_line', 'vertical_line', 'cross', 'horizontal_dash', 'vertical_dash', 'spiral', 'right_diagonal_line', 'left_diagonal_line', 'diagonal_cross', 'right_diagonal_dash', 'left_diagonal_dash', 'horizontal_wave', 'vertical_wave', 'criss_cross', ' ', '.', 'o', '-', '|', '+', '"', ':', '@', '/', '\\', 'x', ',', '`', 'v', '>', '*');
    exports.HTTPMethod = kinds_1.Enum("POST", "GET");
    exports.HexTileOrientation = kinds_1.Enum("pointytop", "flattop");
    exports.HoverMode = kinds_1.Enum("mouse", "hline", "vline");
    exports.LatLon = kinds_1.Enum("lat", "lon");
    exports.LegendClickPolicy = kinds_1.Enum("none", "hide", "mute");
    exports.LegendLocation = exports.Anchor;
    exports.LineCap = kinds_1.Enum("butt", "round", "square");
    exports.LineJoin = kinds_1.Enum("miter", "round", "bevel");
    exports.LinePolicy = kinds_1.Enum("prev", "next", "nearest", "interp", "none");
    exports.Location = kinds_1.Enum("above", "below", "left", "right");
    exports.Logo = kinds_1.Enum("normal", "grey");
    exports.MarkerType = kinds_1.Enum("asterisk", "circle", "circle_cross", "circle_dot", "circle_x", "circle_y", "cross", "dash", "diamond", "diamond_cross", "diamond_dot", "dot", "hex", "hex_dot", "inverted_triangle", "plus", "square", "square_cross", "square_dot", "square_pin", "square_x", "triangle", "triangle_dot", "triangle_pin", "x", "y");
    exports.MutedPolicy = kinds_1.Enum("show", "ignore");
    exports.Orientation = kinds_1.Enum("vertical", "horizontal");
    exports.OutputBackend = kinds_1.Enum("canvas", "svg", "webgl");
    exports.PaddingUnits = kinds_1.Enum("percent", "absolute");
    exports.Place = kinds_1.Enum("above", "below", "left", "right", "center");
    exports.PointPolicy = kinds_1.Enum("snap_to_data", "follow_mouse", "none");
    exports.RadiusDimension = kinds_1.Enum("x", "y", "max", "min");
    exports.RenderLevel = kinds_1.Enum("image", "underlay", "glyph", "guide", "annotation", "overlay");
    exports.RenderMode = kinds_1.Enum("canvas", "css");
    exports.ResetPolicy = kinds_1.Enum("standard", "event_only");
    exports.RoundingFunction = kinds_1.Enum("round", "nearest", "floor", "rounddown", "ceil", "roundup");
    exports.SelectionMode = kinds_1.Enum("replace", "append", "intersect", "subtract");
    exports.Side = kinds_1.Enum("above", "below", "left", "right");
    exports.SizingMode = kinds_1.Enum("stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed");
    exports.Sort = kinds_1.Enum("ascending", "descending");
    exports.SpatialUnits = kinds_1.Enum("screen", "data");
    exports.StartEnd = kinds_1.Enum("start", "end");
    exports.StepMode = kinds_1.Enum("after", "before", "center");
    exports.TapBehavior = kinds_1.Enum("select", "inspect");
    exports.TextAlign = kinds_1.Enum("left", "right", "center");
    exports.TextBaseline = kinds_1.Enum("top", "middle", "bottom", "alphabetic", "hanging", "ideographic");
    exports.TextureRepetition = kinds_1.Enum("repeat", "repeat_x", "repeat_y", "no_repeat");
    exports.TickLabelOrientation = kinds_1.Enum("vertical", "horizontal", "parallel", "normal");
    exports.TooltipAttachment = kinds_1.Enum("horizontal", "vertical", "left", "right", "above", "below");
    exports.UpdateMode = kinds_1.Enum("replace", "append");
    exports.VerticalAlign = kinds_1.Enum("top", "middle", "bottom");
},
/* core/kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const tp = tslib_1.__importStar(require(8) /* ./util/types */);
    const color_1 = require(22) /* ./util/color */;
    const object_1 = require(13) /* ./util/object */;
    const ESMap = window.Map;
    class Kind {
    }
    exports.Kind = Kind;
    Kind.__name__ = "Kind";
    (function (Kinds) {
        class Any extends Kind {
            valid(_value) {
                return true;
            }
        }
        Any.__name__ = "Any";
        Kinds.Any = Any;
        class Unknown extends Kind {
            valid(_value) {
                return true;
            }
        }
        Unknown.__name__ = "Unknown";
        Kinds.Unknown = Unknown;
        class Boolean extends Kind {
            valid(value) {
                return tp.isBoolean(value);
            }
        }
        Boolean.__name__ = "Boolean";
        Kinds.Boolean = Boolean;
        class Ref extends Kind {
            constructor(obj_type) {
                super();
                this.obj_type = obj_type;
            }
            valid(_value) {
                // XXX: disable validation for now, because object graph initialization depends on this.
                // return value instanceof this.obj_type
                return true;
            }
        }
        Ref.__name__ = "Ref";
        Kinds.Ref = Ref;
        class AnyRef extends Kind {
            valid(_value) {
                // XXX: disable validation for now, because object graph initialization depends on this.
                // return tp.isObject(value)
                return true;
            }
        }
        AnyRef.__name__ = "AnyRef";
        Kinds.AnyRef = AnyRef;
        class Number extends Kind {
            valid(value) {
                return tp.isNumber(value);
            }
        }
        Number.__name__ = "Number";
        Kinds.Number = Number;
        class Int extends Number {
            valid(value) {
                return super.valid(value) && tp.isInteger(value);
            }
        }
        Int.__name__ = "Int";
        Kinds.Int = Int;
        class Percent extends Number {
            valid(value) {
                return super.valid(value) && 0 <= value && value <= 1;
            }
        }
        Percent.__name__ = "Percent";
        Kinds.Percent = Percent;
        class Or extends Kind {
            constructor(types) {
                super();
                this.types = types;
                this.types = types;
            }
            valid(value) {
                return this.types.some((type) => type.valid(value));
            }
        }
        Or.__name__ = "Or";
        Kinds.Or = Or;
        class Tuple extends Kind {
            constructor(types) {
                super();
                this.types = types;
                this.types = types;
            }
            valid(value) {
                if (!tp.isArray(value))
                    return false;
                for (let i = 0; i < this.types.length; i++) {
                    const type = this.types[i];
                    const item = value[i];
                    if (!type.valid(item))
                        return false;
                }
                return true;
            }
        }
        Tuple.__name__ = "Tuple";
        Kinds.Tuple = Tuple;
        class Struct extends Kind {
            constructor(struct_type) {
                super();
                this.struct_type = struct_type;
            }
            valid(value) {
                if (!tp.isPlainObject(value))
                    return false;
                const { struct_type } = this;
                if (object_1.size(struct_type) != object_1.size(value))
                    return false;
                for (const key in struct_type) {
                    if (struct_type.hasOwnProperty(key)) {
                        if (!value.hasOwnProperty(key))
                            return false;
                        const item_type = struct_type[key];
                        const item = value[key];
                        if (!item_type.valid(item))
                            return false;
                    }
                }
                return true;
            }
        }
        Struct.__name__ = "Struct";
        Kinds.Struct = Struct;
        class Arrayable extends Kind {
            valid(value) {
                return tp.isArray(value) || tp.isTypedArray(value); // TODO: too specific
            }
        }
        Arrayable.__name__ = "Arrayable";
        Kinds.Arrayable = Arrayable;
        class Array extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                return tp.isArray(value) && value.every((item) => this.item_type.valid(item));
            }
        }
        Array.__name__ = "Array";
        Kinds.Array = Array;
        class Null extends Kind {
            valid(value) {
                return value === null;
            }
        }
        Null.__name__ = "Null";
        Kinds.Null = Null;
        class Nullable extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return value === null || this.base_type.valid(value);
            }
        }
        Nullable.__name__ = "Nullable";
        Kinds.Nullable = Nullable;
        class Opt extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return value === undefined || this.base_type.valid(value);
            }
        }
        Opt.__name__ = "Opt";
        Kinds.Opt = Opt;
        class String extends Kind {
            valid(value) {
                return tp.isString(value);
            }
        }
        String.__name__ = "String";
        Kinds.String = String;
        class Enum extends Kind {
            constructor(values) {
                super();
                this.values = new Set(values);
            }
            valid(value) {
                return this.values.has(value);
            }
            *[Symbol.iterator]() {
                yield* this.values;
            }
        }
        Enum.__name__ = "Enum";
        Kinds.Enum = Enum;
        class Dict extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                if (!tp.isPlainObject(value))
                    return false;
                for (const key in value) {
                    if (value.hasOwnProperty(key)) {
                        const item = value[key];
                        if (!this.item_type.valid(item))
                            return false;
                    }
                }
                return true;
            }
        }
        Dict.__name__ = "Dict";
        Kinds.Dict = Dict;
        class Map extends Kind {
            constructor(key_type, item_type) {
                super();
                this.key_type = key_type;
                this.item_type = item_type;
            }
            valid(value) {
                if (!(value instanceof ESMap))
                    return false;
                for (const [key, item] of value.entries()) {
                    if (!(this.key_type.valid(key) && this.item_type.valid(item)))
                        return false;
                }
                return true;
            }
        }
        Map.__name__ = "Map";
        Kinds.Map = Map;
        class Color extends Kind {
            valid(value) {
                return tp.isString(value) && color_1.is_color(value);
            }
        }
        Color.__name__ = "Color";
        Kinds.Color = Color;
        class Function extends Kind {
            valid(value) {
                return tp.isFunction(value);
            }
        }
        Function.__name__ = "Function";
        Kinds.Function = Function;
    })(exports.Kinds || (exports.Kinds = {}));
    exports.Any = new exports.Kinds.Any();
    exports.Unknown = new exports.Kinds.Unknown();
    exports.Boolean = new exports.Kinds.Boolean();
    exports.Number = new exports.Kinds.Number();
    exports.Int = new exports.Kinds.Int();
    exports.String = new exports.Kinds.String();
    exports.Null = new exports.Kinds.Null();
    exports.Nullable = (base_type) => new exports.Kinds.Nullable(base_type);
    exports.Opt = (base_type) => new exports.Kinds.Opt(base_type);
    exports.Or = (...types) => new exports.Kinds.Or(types);
    exports.Tuple = (...types) => new exports.Kinds.Tuple(types);
    exports.Struct = (struct_type) => new exports.Kinds.Struct(struct_type);
    exports.Arrayable = new exports.Kinds.Arrayable();
    exports.Array = (item_type) => new exports.Kinds.Array(item_type);
    exports.Dict = (item_type) => new exports.Kinds.Dict(item_type);
    exports.Map = (key_type, item_type) => new exports.Kinds.Map(key_type, item_type);
    exports.Enum = (...values) => new exports.Kinds.Enum(values);
    exports.Ref = (obj_type) => new exports.Kinds.Ref(obj_type);
    exports.AnyRef = () => new exports.Kinds.AnyRef();
    exports.Function = () => new exports.Kinds.Function();
    exports.Percent = new exports.Kinds.Percent();
    exports.Alpha = exports.Percent;
    exports.Color = new exports.Kinds.Color();
    exports.Auto = exports.Enum("auto");
    exports.FontSize = exports.String;
    exports.Font = exports.String;
    exports.Angle = exports.Number;
},
/* core/util/color.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const svg_colors_1 = require(23) /* ./svg_colors */;
    const array_1 = require(9) /* ./array */;
    function is_color(value) {
        return svg_colors_1.is_svg_color(value.toLowerCase()) || value.substring(0, 1) == "#" || valid_rgb(value);
    }
    exports.is_color = is_color;
    function _component2hex(v) {
        const h = Number(v).toString(16);
        return h.length == 1 ? `0${h}` : h;
    }
    function rgb2hex(r, g, b) {
        const R = _component2hex(r & 0xFF);
        const G = _component2hex(g & 0xFF);
        const B = _component2hex(b & 0xFF);
        return `#${R}${G}${B}`;
    }
    exports.rgb2hex = rgb2hex;
    function color2hex(color) {
        color = color + '';
        if (color.indexOf('#') == 0)
            return color;
        else if (svg_colors_1.is_svg_color(color))
            return svg_colors_1.svg_colors[color];
        else if (color.indexOf('rgb') == 0) {
            const rgb = color.replace(/^rgba?\(|\s+|\)$/g, '').split(',');
            let hex = rgb.slice(0, 3).map(_component2hex).join('');
            if (rgb.length == 4)
                hex += _component2hex(Math.floor(parseFloat(rgb[3]) * 255));
            return `#${hex.slice(0, 8)}`; // can also be rgba
        }
        else
            return color;
    }
    exports.color2hex = color2hex;
    function encode_rgba([r, g, b, a]) {
        return (r * 255 | 0) << 24 | (g * 255 | 0) << 16 | (b * 255 | 0) << 8 | (a * 255 | 0);
    }
    exports.encode_rgba = encode_rgba;
    function decode_rgba(rgba) {
        const r = ((rgba >> 24) & 0xff) / 255;
        const g = ((rgba >> 16) & 0xff) / 255;
        const b = ((rgba >> 8) & 0xff) / 255;
        const a = ((rgba >> 0) & 0xff) / 255;
        return [r, g, b, a];
    }
    exports.decode_rgba = decode_rgba;
    function color2rgba(color, alpha = 1.0) {
        if (!color) // NaN, null, '', etc.
            return [0, 0, 0, 0]; // transparent
        // Convert to hex and then to clean version of 6 or 8 chars
        let hex = color2hex(color);
        hex = hex.replace(/ |#/g, '');
        if (hex.length <= 4) {
            hex = hex.replace(/(.)/g, '$1$1');
        }
        // Convert pairs to numbers
        const rgba = hex.match(/../g).map((i) => parseInt(i, 16) / 255);
        // Ensure correct length, add alpha if necessary
        while (rgba.length < 3)
            rgba.push(0);
        if (rgba.length < 4)
            rgba.push(alpha);
        return rgba.slice(0, 4);
    }
    exports.color2rgba = color2rgba;
    function valid_rgb(value) {
        let params;
        switch (value.substring(0, 4)) {
            case "rgba": {
                params = { start: "rgba(", len: 4, alpha: true };
                break;
            }
            case "rgb(": {
                params = { start: "rgb(", len: 3, alpha: false };
                break;
            }
            default:
                return false;
        }
        // if '.' and then ',' found, we know decimals are used on rgb
        if (new RegExp(".*?(\\.).*(,)").test(value))
            return false;
        // throw new Error(`color expects integers for rgb in rgb/rgba tuple, received ${value}`)
        // extract the numerical values from inside parens
        const contents = value.replace(params.start, "").replace(")", "").split(',').map(parseFloat);
        // check length of array based on rgb/rgba
        if (contents.length != params.len)
            return false;
        // throw new Error(`color expects rgba ${params.len}-tuple, received ${value}`)
        // check for valid numerical values for rgba
        if (params.alpha && !(0 <= contents[3] && contents[3] <= 1))
            return false;
        // throw new Error("color expects rgba 4-tuple to have alpha value between 0 and 1")
        if (array_1.includes(contents.slice(0, 3).map((rgb) => 0 <= rgb && rgb <= 255), false))
            return false;
        // throw new Error("color expects rgb to have value between 0 and 255")
        return true;
    }
    exports.valid_rgb = valid_rgb;
},
/* core/util/svg_colors.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.svg_colors = {
        indianred: "#CD5C5C",
        lightcoral: "#F08080",
        salmon: "#FA8072",
        darksalmon: "#E9967A",
        lightsalmon: "#FFA07A",
        crimson: "#DC143C",
        red: "#FF0000",
        firebrick: "#B22222",
        darkred: "#8B0000",
        pink: "#FFC0CB",
        lightpink: "#FFB6C1",
        hotpink: "#FF69B4",
        deeppink: "#FF1493",
        mediumvioletred: "#C71585",
        palevioletred: "#DB7093",
        coral: "#FF7F50",
        tomato: "#FF6347",
        orangered: "#FF4500",
        darkorange: "#FF8C00",
        orange: "#FFA500",
        gold: "#FFD700",
        yellow: "#FFFF00",
        lightyellow: "#FFFFE0",
        lemonchiffon: "#FFFACD",
        lightgoldenrodyellow: "#FAFAD2",
        papayawhip: "#FFEFD5",
        moccasin: "#FFE4B5",
        peachpuff: "#FFDAB9",
        palegoldenrod: "#EEE8AA",
        khaki: "#F0E68C",
        darkkhaki: "#BDB76B",
        lavender: "#E6E6FA",
        thistle: "#D8BFD8",
        plum: "#DDA0DD",
        violet: "#EE82EE",
        orchid: "#DA70D6",
        fuchsia: "#FF00FF",
        magenta: "#FF00FF",
        mediumorchid: "#BA55D3",
        mediumpurple: "#9370DB",
        blueviolet: "#8A2BE2",
        darkviolet: "#9400D3",
        darkorchid: "#9932CC",
        darkmagenta: "#8B008B",
        purple: "#800080",
        indigo: "#4B0082",
        slateblue: "#6A5ACD",
        darkslateblue: "#483D8B",
        mediumslateblue: "#7B68EE",
        greenyellow: "#ADFF2F",
        chartreuse: "#7FFF00",
        lawngreen: "#7CFC00",
        lime: "#00FF00",
        limegreen: "#32CD32",
        palegreen: "#98FB98",
        lightgreen: "#90EE90",
        mediumspringgreen: "#00FA9A",
        springgreen: "#00FF7F",
        mediumseagreen: "#3CB371",
        seagreen: "#2E8B57",
        forestgreen: "#228B22",
        green: "#008000",
        darkgreen: "#006400",
        yellowgreen: "#9ACD32",
        olivedrab: "#6B8E23",
        olive: "#808000",
        darkolivegreen: "#556B2F",
        mediumaquamarine: "#66CDAA",
        darkseagreen: "#8FBC8F",
        lightseagreen: "#20B2AA",
        darkcyan: "#008B8B",
        teal: "#008080",
        aqua: "#00FFFF",
        cyan: "#00FFFF",
        lightcyan: "#E0FFFF",
        paleturquoise: "#AFEEEE",
        aquamarine: "#7FFFD4",
        turquoise: "#40E0D0",
        mediumturquoise: "#48D1CC",
        darkturquoise: "#00CED1",
        cadetblue: "#5F9EA0",
        steelblue: "#4682B4",
        lightsteelblue: "#B0C4DE",
        powderblue: "#B0E0E6",
        lightblue: "#ADD8E6",
        skyblue: "#87CEEB",
        lightskyblue: "#87CEFA",
        deepskyblue: "#00BFFF",
        dodgerblue: "#1E90FF",
        cornflowerblue: "#6495ED",
        royalblue: "#4169E1",
        blue: "#0000FF",
        mediumblue: "#0000CD",
        darkblue: "#00008B",
        navy: "#000080",
        midnightblue: "#191970",
        cornsilk: "#FFF8DC",
        blanchedalmond: "#FFEBCD",
        bisque: "#FFE4C4",
        navajowhite: "#FFDEAD",
        wheat: "#F5DEB3",
        burlywood: "#DEB887",
        tan: "#D2B48C",
        rosybrown: "#BC8F8F",
        sandybrown: "#F4A460",
        goldenrod: "#DAA520",
        darkgoldenrod: "#B8860B",
        peru: "#CD853F",
        chocolate: "#D2691E",
        saddlebrown: "#8B4513",
        sienna: "#A0522D",
        brown: "#A52A2A",
        maroon: "#800000",
        white: "#FFFFFF",
        snow: "#FFFAFA",
        honeydew: "#F0FFF0",
        mintcream: "#F5FFFA",
        azure: "#F0FFFF",
        aliceblue: "#F0F8FF",
        ghostwhite: "#F8F8FF",
        whitesmoke: "#F5F5F5",
        seashell: "#FFF5EE",
        beige: "#F5F5DC",
        oldlace: "#FDF5E6",
        floralwhite: "#FFFAF0",
        ivory: "#FFFFF0",
        antiquewhite: "#FAEBD7",
        linen: "#FAF0E6",
        lavenderblush: "#FFF0F5",
        mistyrose: "#FFE4E1",
        gainsboro: "#DCDCDC",
        lightgray: "#D3D3D3",
        lightgrey: "#D3D3D3",
        silver: "#C0C0C0",
        darkgray: "#A9A9A9",
        darkgrey: "#A9A9A9",
        gray: "#808080",
        grey: "#808080",
        dimgray: "#696969",
        dimgrey: "#696969",
        lightslategray: "#778899",
        lightslategrey: "#778899",
        slategray: "#708090",
        slategrey: "#708090",
        darkslategray: "#2F4F4F",
        darkslategrey: "#2F4F4F",
        black: "#000000",
    };
    function is_svg_color(color) {
        return color in exports.svg_colors;
    }
    exports.is_svg_color = is_svg_color;
},
/* core/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.NumberArray = Float32Array;
    exports.ColorArray = Uint32Array;
    var bitset_1 = require(25) /* ./util/bitset */;
    __esExport("Indices", bitset_1.BitSet);
},
/* core/util/bitset.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const eq_1 = require(26) /* ./eq */;
    const assert_1 = require(11) /* ./assert */;
    class BitSet {
        constructor(size, init = 0) {
            this.size = size;
            this[Symbol.toStringTag] = "BitSet";
            this._count = null;
            this._nwords = Math.ceil(size / 32);
            if (init == 0 || init == 1) {
                this._array = new Uint32Array(this._nwords);
                if (init == 1) {
                    this._array.fill(0xffffffff);
                }
            }
            else {
                assert_1.assert(init.length == this._nwords, "Initializer size mismatch");
                this._array = init;
            }
        }
        clone() {
            return new BitSet(this.size, new Uint32Array(this._array));
        }
        [eq_1.equals](that, cmp) {
            if (!cmp.eq(this.size, that.size))
                return false;
            const { _nwords } = this;
            const trailing = this.size % _nwords;
            const n = trailing == 0 ? _nwords : _nwords - 1;
            for (let i = 0; i < n; i++) {
                if (this._array[i] != that._array[i])
                    return false;
            }
            if (trailing == 0)
                return true;
            else {
                const msb = 1 << (trailing - 1);
                const mask = (msb - 1) ^ msb;
                return (this._array[n] & mask) == (that._array[n] & mask);
            }
        }
        static all_set(size) {
            return new BitSet(size, 1);
        }
        static all_unset(size) {
            return new BitSet(size, 0);
        }
        static from_indices(size, indices) {
            const bits = new BitSet(size);
            for (const i of indices) {
                bits.set(i);
            }
            return bits;
        }
        static from_booleans(size, booleans) {
            const bits = new BitSet(size);
            const n = Math.min(size, booleans.length);
            for (let i = 0; i < n; i++) {
                if (booleans[i])
                    bits.set(i);
            }
            return bits;
        }
        _check_bounds(k) {
            assert_1.assert(0 <= k && k < this.size, `Out of bounds: 0 <= ${k} < ${this.size}`);
        }
        get(k) {
            this._check_bounds(k);
            const i = k >>> 5; // Math.floor(k/32)
            const j = k & 0x1f; // k % 32
            return !!((this._array[i] >> j) & 0x1);
        }
        set(k, v = true) {
            this._check_bounds(k);
            this._count = null;
            const i = k >>> 5; // Math.floor(k/32)
            const j = k & 0x1f; // k % 32
            if (v)
                this._array[i] |= 0x1 << j;
            else
                this._array[i] &= ~(0x1 << j);
        }
        unset(k) {
            this.set(k, false);
        }
        *[Symbol.iterator]() {
            yield* this.ones();
        }
        get count() {
            let count = this._count;
            if (count == null)
                this._count = count = this._get_count();
            return count;
        }
        _get_count() {
            const { _array, _nwords, size } = this;
            let c = 0;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0) {
                    k += 32;
                }
                else {
                    for (let j = 0; j < 32 && k < size; j++, k++) {
                        if ((word >>> j) & 0x1)
                            c += 1;
                    }
                }
            }
            return c;
        }
        *ones() {
            const { _array, _nwords, size } = this;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0) {
                    k += 32;
                    continue;
                }
                for (let j = 0; j < 32 && k < size; j++, k++) {
                    if ((word >>> j) & 0x1)
                        yield k;
                }
            }
        }
        *zeros() {
            const { _array, _nwords, size } = this;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0xffffffff) {
                    k += 32;
                    continue;
                }
                for (let j = 0; j < 32 && k < size; j++, k++) {
                    if (!((word >>> j) & 0x1))
                        yield k;
                }
            }
        }
        _check_size(other) {
            assert_1.assert(this.size == other.size, "Size mismatch");
        }
        add(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] |= other._array[i];
            }
        }
        intersect(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] &= other._array[i];
            }
        }
        subtract(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                const a = this._array[i];
                const b = other._array[i];
                this._array[i] = (a ^ b) & a;
            }
        }
        union(other) {
            this._check_size(other);
            const result = this.clone();
            for (let i = 0; i < this._nwords; i++) {
                result._array[i] |= other._array[i];
            }
            return result;
        }
        intersection(other) {
            this._check_size(other);
            const result = this.clone();
            for (let i = 0; i < this._nwords; i++) {
                result._array[i] &= other._array[i];
            }
            return result;
        }
        difference(other) {
            this._check_size(other);
            const result = this.clone();
            for (let i = 0; i < this._nwords; i++) {
                const a = this._array[i];
                const b = other._array[i];
                result._array[i] = (a ^ b) & a;
            }
            return result;
        }
        select(array) {
            assert_1.assert(this.size == array.length, "Size mismatch");
            const n = this.count;
            const result = new array.constructor(n);
            let i = 0;
            for (const j of this) {
                result[i++] = array[j];
            }
            return result;
        }
    }
    exports.BitSet = BitSet;
    BitSet.__name__ = "BitSet";
},
/* core/util/eq.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // Based on Underscore.js 1.8.3 (http://underscorejs.org)
    exports.equals = Symbol("equals");
    function is_Equatable(obj) {
        return exports.equals in Object(obj);
    }
    exports.wildcard = Symbol("wildcard");
    const toString = Object.prototype.toString;
    class Comparator {
        constructor() {
            this.a_stack = [];
            this.b_stack = [];
        }
        eq(a, b) {
            if (Object.is(a, b))
                return true;
            if (a === exports.wildcard || b === exports.wildcard)
                return true;
            if (a == null || b == null)
                return a === b;
            const class_name = toString.call(a);
            if (class_name != toString.call(b))
                return false;
            switch (class_name) {
                case '[object Number]':
                    return this.numbers(a, b);
                case '[object RegExp]':
                case '[object String]':
                    return `${a}` == `${b}`;
                case '[object Date]':
                case '[object Boolean]':
                    return +a === +b;
            }
            // Assume equality for cyclic structures. The algorithm for detecting cyclic
            // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
            // Initializing stack of traversed objects.
            // It's done here since we only need them for objects and arrays comparison.
            const { a_stack, b_stack } = this;
            let length = a_stack.length;
            while (length--) {
                // Linear search. Performance is inversely proportional to the number of
                // unique nested structures.
                if (a_stack[length] === a)
                    return b_stack[length] === b;
            }
            a_stack.push(a);
            b_stack.push(b);
            const result = (() => {
                if (is_Equatable(a) && is_Equatable(b)) {
                    return a[exports.equals](b, this);
                }
                switch (class_name) {
                    case "[object Array]":
                    case "[object Uint8Array]":
                    case "[object Int8Array]":
                    case "[object Uint16Array]":
                    case "[object Int16Array]":
                    case "[object Uint32Array]":
                    case "[object Int32Array]":
                    case "[object Float32Array]":
                    case "[object Float64Array]": {
                        return this.arrays(a, b);
                    }
                    case "[object Map]":
                        return this.maps(a, b);
                    case "[object Set]":
                        return this.sets(a, b);
                    case "[object Object]": {
                        if (a.constructor == b.constructor && (a.constructor == null || a.constructor === Object)) {
                            return this.objects(a, b);
                        }
                    }
                    case "[object Function]": {
                        if (a.constructor == b.constructor && a.constructor === Function) {
                            return this.eq(`${a}`, `${b}`);
                        }
                    }
                }
                if (a instanceof Node) {
                    return this.nodes(a, b);
                }
                throw Error(`can't compare objects of type ${class_name}`);
            })();
            a_stack.pop();
            b_stack.pop();
            return result;
        }
        numbers(a, b) {
            return Object.is(a, b);
        }
        arrays(a, b) {
            const { length } = a;
            if (length != b.length)
                return false;
            for (let i = 0; i < length; i++) {
                if (!this.eq(a[i], b[i]))
                    return false;
            }
            return true;
        }
        iterables(a, b) {
            const ai = a[Symbol.iterator]();
            const bi = b[Symbol.iterator]();
            while (true) {
                const an = ai.next();
                const bn = bi.next();
                if (an.done && bn.done)
                    return true;
                if (an.done || bn.done)
                    return false;
                if (!this.eq(an.value, bn.value))
                    return false;
            }
        }
        maps(a, b) {
            if (a.size != b.size)
                return false;
            for (const [key, val] of a) {
                if (!b.has(key) || !this.eq(val, b.get(key)))
                    return false;
            }
            return true;
        }
        sets(a, b) {
            if (a.size != b.size)
                return false;
            for (const key of a) {
                if (!b.has(key))
                    return false;
            }
            return true;
        }
        objects(a, b) {
            const keys = Object.keys(a);
            if (keys.length != Object.keys(b).length)
                return false;
            for (const key of keys) {
                if (!b.hasOwnProperty(key) || !this.eq(a[key], b[key]))
                    return false;
            }
            return true;
        }
        nodes(a, b) {
            if (a.nodeType != b.nodeType)
                return false;
            if (a.textContent != b.textContent)
                return false;
            if (!this.iterables(a.childNodes, b.childNodes))
                return false;
            return true;
        }
    }
    exports.Comparator = Comparator;
    Comparator.__name__ = "Comparator";
    const { abs } = Math;
    class SimilarComparator extends Comparator {
        constructor(tolerance = 1e-4) {
            super();
            this.tolerance = tolerance;
        }
        numbers(a, b) {
            return super.numbers(a, b) || abs(a - b) < this.tolerance;
        }
    }
    exports.SimilarComparator = SimilarComparator;
    SimilarComparator.__name__ = "SimilarComparator";
    function is_equal(a, b) {
        const comparator = new Comparator();
        return comparator.eq(a, b);
    }
    exports.is_equal = is_equal;
    function is_similar(a, b, tolerance) {
        const comparator = new SimilarComparator(tolerance);
        return comparator.eq(a, b);
    }
    exports.is_similar = is_similar;
    /** @deprecated */
    exports.isEqual = is_equal;
},
/* core/settings.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class Settings {
        constructor() {
            this._dev = false;
        }
        set dev(dev) {
            this._dev = dev;
        }
        get dev() {
            return this._dev;
        }
    }
    exports.Settings = Settings;
    Settings.__name__ = "Settings";
    exports.settings = new Settings();
},
/* core/property_mixins.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const p = tslib_1.__importStar(require(18) /* ./properties */);
    const enums_1 = require(20) /* ./enums */;
    const k = tslib_1.__importStar(require(21) /* ./kinds */);
    exports.Line = {
        line_color: [k.Nullable(k.Color), "black"],
        line_alpha: [k.Alpha, 1.0],
        line_width: [k.Number, 1],
        line_join: [enums_1.LineJoin, "bevel"],
        line_cap: [enums_1.LineCap, "butt"],
        line_dash: [k.Array(k.Number), []],
        line_dash_offset: [k.Number, 0],
    };
    exports.Fill = {
        fill_color: [k.Nullable(k.Color), "gray"],
        fill_alpha: [k.Alpha, 1.0],
    };
    exports.Hatch = {
        hatch_color: [k.Nullable(k.Color), "black"],
        hatch_alpha: [k.Alpha, 1.0],
        hatch_scale: [k.Number, 12.0],
        hatch_pattern: [k.Nullable(k.Or(enums_1.HatchPatternType, k.String)), null],
        hatch_weight: [k.Number, 1.0],
        hatch_extra: [k.Dict(k.AnyRef()), {}],
    };
    exports.Text = {
        text_color: [k.Nullable(k.Color), "#444444"],
        text_alpha: [k.Alpha, 1.0],
        text_font: [p.Font, "helvetica"],
        text_font_size: [k.FontSize, "16px"],
        text_font_style: [enums_1.FontStyle, "normal"],
        text_align: [enums_1.TextAlign, "left"],
        text_baseline: [enums_1.TextBaseline, "bottom"],
        text_line_height: [k.Number, 1.2],
    };
    exports.LineScalar = {
        line_color: [p.ColorScalar, "black"],
        line_alpha: [p.NumberScalar, 1.0],
        line_width: [p.NumberScalar, 1],
        line_join: [p.LineJoinScalar, "bevel"],
        line_cap: [p.LineCapScalar, "butt"],
        line_dash: [p.ArrayScalar, []],
        line_dash_offset: [p.NumberScalar, 0],
    };
    exports.FillScalar = {
        fill_color: [p.ColorScalar, "gray"],
        fill_alpha: [p.NumberScalar, 1.0],
    };
    exports.HatchScalar = {
        hatch_color: [p.ColorScalar, "black"],
        hatch_alpha: [p.NumberScalar, 1.0],
        hatch_scale: [p.NumberScalar, 12.0],
        hatch_pattern: [p.NullStringScalar, null],
        hatch_weight: [p.NumberScalar, 1.0],
        hatch_extra: [p.AnyScalar, {}],
    };
    exports.TextScalar = {
        text_color: [p.ColorScalar, "#444444"],
        text_alpha: [p.NumberScalar, 1.0],
        text_font: [p.Font, "helvetica"],
        text_font_size: [p.FontSizeScalar, "16px"],
        text_font_style: [p.FontStyleScalar, "normal"],
        text_align: [p.TextAlignScalar, "left"],
        text_baseline: [p.TextBaselineScalar, "bottom"],
        text_line_height: [p.NumberScalar, 1.2],
    };
    exports.LineVector = {
        line_color: [p.ColorSpec, "black"],
        line_alpha: [p.NumberSpec, 1.0],
        line_width: [p.NumberSpec, 1],
        line_join: [enums_1.LineJoin, "bevel"],
        line_cap: [enums_1.LineCap, "butt"],
        line_dash: [k.Array(k.Number), []],
        line_dash_offset: [k.Number, 0],
    };
    exports.FillVector = {
        fill_color: [p.ColorSpec, "gray"],
        fill_alpha: [p.NumberSpec, 1.0],
    };
    exports.HatchVector = {
        hatch_color: [p.ColorSpec, "black"],
        hatch_alpha: [p.NumberSpec, 1.0],
        hatch_scale: [p.NumberSpec, 12.0],
        hatch_pattern: [p.NullStringSpec, null],
        hatch_weight: [p.NumberSpec, 1.0],
        hatch_extra: [k.Dict(k.AnyRef()), {}],
    };
    exports.TextVector = {
        text_color: [p.ColorSpec, "#444444"],
        text_alpha: [p.NumberSpec, 1.0],
        text_font: [p.Font, "helvetica"],
        text_font_size: [p.FontSizeSpec, "16px"],
        text_font_style: [enums_1.FontStyle, "normal"],
        text_align: [enums_1.TextAlign, "left"],
        text_baseline: [enums_1.TextBaseline, "bottom"],
        text_line_height: [k.Number, 1.2],
    };
},
/* core/util/string.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const settings_1 = require(27) /* ../settings */;
    function startsWith(str, searchString, position = 0) {
        return str.substr(position, searchString.length) == searchString;
    }
    exports.startsWith = startsWith;
    function uuid4() {
        // from ipython project
        // http://www.ietf.org/rfc/rfc4122.txt
        const s = new Array(32);
        const hexDigits = "0123456789ABCDEF";
        for (let i = 0; i < 32; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }
        s[12] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
        s[16] = hexDigits.substr((s[16].charCodeAt(0) & 0x3) | 0x8, 1); // bits 6-7 of the clock_seq_hi_and_reserved to 01
        return s.join("");
    }
    exports.uuid4 = uuid4;
    let counter = 1000;
    function uniqueId(prefix) {
        const id = settings_1.settings.dev ? `j${counter++}` : uuid4();
        if (prefix != null)
            return `${prefix}-${id}`;
        else
            return id;
    }
    exports.uniqueId = uniqueId;
    function escape(s) {
        return s.replace(/(?:[&<>"'`])/g, (ch) => {
            switch (ch) {
                case '&': return '&amp;';
                case '<': return '&lt;';
                case '>': return '&gt;';
                case '"': return '&quot;';
                case "'": return '&#x27;';
                case '`': return '&#x60;';
                default: return ch;
            }
        });
    }
    exports.escape = escape;
    function unescape(s) {
        return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, (_, entity) => {
            switch (entity) {
                case 'amp': return '&';
                case 'lt': return '<';
                case 'gt': return '>';
                case 'quot': return '"';
                case '#x27': return "'";
                case '#x60': return '`';
                default: return entity;
            }
        });
    }
    exports.unescape = unescape;
    function use_strict(code) {
        return `'use strict';\n${code}`;
    }
    exports.use_strict = use_strict;
    function to_fixed(val, precision) {
        return val.toFixed(precision).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
    }
    exports.to_fixed = to_fixed;
},
/* core/serializer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const assert_1 = require(11) /* ./util/assert */;
    const object_1 = require(13) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    //| Map<SerializableType, SerializableType>
    //| Set<SerializableType>
    //| ArrayBuffer
    // TypedArray?
    exports.serialize = Symbol("serialize");
    function is_Serializable(obj) {
        return exports.serialize in Object(obj);
    }
    class SerializationError extends Error {
    }
    exports.SerializationError = SerializationError;
    SerializationError.__name__ = "SerializationError";
    class Serializer {
        constructor(options) {
            var _a;
            this._references = new Map();
            this._definitions = new Map();
            this._refmap = new Map();
            this.include_defaults = (_a = options === null || options === void 0 ? void 0 : options.include_defaults) !== null && _a !== void 0 ? _a : true;
        }
        add_ref(obj, ref) {
            this._references.set(obj, ref);
        }
        add_def(obj, def) {
            const ref = this._references.get(obj);
            assert_1.assert(ref != null);
            this._definitions.set(obj, def);
            this._refmap.set(ref, def);
        }
        get objects() {
            return new Set(this._references.keys());
        }
        get references() {
            return new Set(this._references.values());
        }
        get definitions() {
            return new Set(this._definitions.values());
        }
        resolve_ref(ref) {
            return this._refmap.get(ref);
        }
        remove_ref(obj) {
            return this._references.delete(obj);
        }
        remove_def(obj) {
            return this._definitions.delete(obj);
        }
        to_serializable(obj) {
            if (is_Serializable(obj))
                return obj[exports.serialize](this);
            else if (types_1.isArray(obj) || types_1.isTypedArray(obj)) {
                const n = obj.length;
                const result = new Array(n);
                for (let i = 0; i < n; i++) {
                    const value = obj[i];
                    result[i] = this.to_serializable(value);
                }
                return result;
            }
            else if (types_1.isPlainObject(obj)) {
                const result = {};
                for (const [key, value] of object_1.entries(obj)) {
                    result[key] = this.to_serializable(value);
                }
                return result;
            }
            else if (obj === null || types_1.isBoolean(obj) || types_1.isNumber(obj) || types_1.isString(obj)) {
                return obj;
            }
            else
                throw new SerializationError(`${Object.prototype.toString.call(obj)} is not serializable`);
        }
    }
    exports.Serializer = Serializer;
    Serializer.__name__ = "Serializer";
},
/* core/util/pretty.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./types */;
    const object_1 = require(13) /* ./object */;
    exports.pretty = Symbol("pretty");
    function is_Printable(obj) {
        return exports.pretty in Object(obj);
    }
    class Printer {
        constructor(options) {
            this.precision = options === null || options === void 0 ? void 0 : options.precision;
        }
        to_string(obj) {
            if (is_Printable(obj))
                return obj[exports.pretty](this);
            else if (types_1.isBoolean(obj))
                return this.boolean(obj);
            else if (types_1.isNumber(obj))
                return this.number(obj);
            else if (types_1.isString(obj))
                return this.string(obj);
            else if (types_1.isArray(obj))
                return this.array(obj);
            else if (types_1.isIterable(obj))
                return this.iterable(obj);
            else if (types_1.isPlainObject(obj))
                return this.object(obj);
            else
                return `${obj}`;
        }
        token(val) {
            return val;
        }
        boolean(val) {
            return `${val}`;
        }
        number(val) {
            if (this.precision != null)
                return val.toFixed(this.precision);
            else
                return `${val}`;
        }
        string(val) {
            return `"${val.replace(/'/g, "\\'")}"`; // lgtm [js/incomplete-sanitization]
        }
        array(obj) {
            const T = this.token;
            const items = [];
            for (const entry of obj) {
                items.push(this.to_string(entry));
            }
            return `${T("[")}${items.join(`${T(",")} `)}${T("]")}`;
        }
        iterable(obj) {
            var _a;
            const T = this.token;
            const tag = (_a = Object(obj)[Symbol.toStringTag]) !== null && _a !== void 0 ? _a : "Object";
            const items = this.array(obj);
            return `${tag}${T("(")}${items}${T(")")}`;
        }
        object(obj) {
            const T = this.token;
            const items = [];
            for (const [key, val] of object_1.entries(obj)) {
                items.push(`${key}${T(":")} ${this.to_string(val)}`);
            }
            return `${T("{")}${items.join(`${T(",")} `)}${T("}")}`;
        }
    }
    exports.Printer = Printer;
    Printer.__name__ = "Printer";
    function to_string(obj, options) {
        const printer = new Printer(options);
        return printer.to_string(obj);
    }
    exports.to_string = to_string;
},
/* core/util/cloneable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const object_1 = require(13) /* ./object */;
    const types_1 = require(8) /* ./types */;
    //| Map<CloneableType, CloneableType>
    //| Set<CloneableType>
    exports.clone = Symbol("clone");
    function is_Cloneable(obj) {
        return exports.clone in Object(obj);
    }
    exports.is_Cloneable = is_Cloneable;
    class CloningError extends Error {
    }
    exports.CloningError = CloningError;
    CloningError.__name__ = "CloningError";
    class Cloner {
        constructor() { }
        clone(obj) {
            if (is_Cloneable(obj))
                return obj[exports.clone](this);
            else if (types_1.isArray(obj)) {
                const n = obj.length;
                const result = new Array(n);
                for (let i = 0; i < n; i++) {
                    const value = obj[i];
                    result[i] = this.clone(value);
                }
                return result;
            }
            else if (types_1.isPlainObject(obj)) {
                const result = {};
                for (const [key, value] of object_1.entries(obj)) {
                    result[key] = this.clone(value);
                }
                return result;
            }
            else if (obj === null || types_1.isBoolean(obj) || types_1.isNumber(obj) || types_1.isString(obj)) {
                return obj;
            }
            else
                throw new CloningError(`${Object.prototype.toString.call(obj)} is not cloneable`);
        }
    }
    exports.Cloner = Cloner;
    Cloner.__name__ = "Cloner";
},
/* models/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(34) /* ./annotations */, exports);
    tslib_1.__exportStar(require(204) /* ./axes */, exports);
    tslib_1.__exportStar(require(231) /* ./callbacks */, exports);
    tslib_1.__exportStar(require(235) /* ./canvas */, exports);
    tslib_1.__exportStar(require(247) /* ./expressions */, exports);
    tslib_1.__exportStar(require(251) /* ./filters */, exports);
    tslib_1.__exportStar(require(256) /* ./formatters */, exports);
    tslib_1.__exportStar(require(260) /* ./glyphs */, exports);
    tslib_1.__exportStar(require(293) /* ./graphs */, exports);
    tslib_1.__exportStar(require(295) /* ./grids */, exports);
    tslib_1.__exportStar(require(297) /* ./layouts */, exports);
    tslib_1.__exportStar(require(148) /* ./mappers */, exports);
    tslib_1.__exportStar(require(160) /* ./transforms */, exports);
    tslib_1.__exportStar(require(313) /* ./markers */, exports);
    tslib_1.__exportStar(require(317) /* ./plots */, exports);
    tslib_1.__exportStar(require(327) /* ./ranges */, exports);
    tslib_1.__exportStar(require(328) /* ./renderers */, exports);
    tslib_1.__exportStar(require(329) /* ./scales */, exports);
    tslib_1.__exportStar(require(330) /* ./selections */, exports);
    tslib_1.__exportStar(require(331) /* ./sources */, exports);
    tslib_1.__exportStar(require(336) /* ./tickers */, exports);
    tslib_1.__exportStar(require(338) /* ./tiles */, exports);
    tslib_1.__exportStar(require(349) /* ./textures */, exports);
    tslib_1.__exportStar(require(353) /* ./tools */, exports);
},
/* models/annotations/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var annotation_1 = require(35) /* ./annotation */;
    __esExport("Annotation", annotation_1.Annotation);
    var arrow_1 = require(90) /* ./arrow */;
    __esExport("Arrow", arrow_1.Arrow);
    var arrow_head_1 = require(91) /* ./arrow_head */;
    __esExport("ArrowHead", arrow_head_1.ArrowHead);
    var arrow_head_2 = require(91) /* ./arrow_head */;
    __esExport("OpenHead", arrow_head_2.OpenHead);
    var arrow_head_3 = require(91) /* ./arrow_head */;
    __esExport("NormalHead", arrow_head_3.NormalHead);
    var arrow_head_4 = require(91) /* ./arrow_head */;
    __esExport("TeeHead", arrow_head_4.TeeHead);
    var arrow_head_5 = require(91) /* ./arrow_head */;
    __esExport("VeeHead", arrow_head_5.VeeHead);
    var band_1 = require(134) /* ./band */;
    __esExport("Band", band_1.Band);
    var box_annotation_1 = require(136) /* ./box_annotation */;
    __esExport("BoxAnnotation", box_annotation_1.BoxAnnotation);
    var color_bar_1 = require(137) /* ./color_bar */;
    __esExport("ColorBar", color_bar_1.ColorBar);
    var label_1 = require(172) /* ./label */;
    __esExport("Label", label_1.Label);
    var label_set_1 = require(174) /* ./label_set */;
    __esExport("LabelSet", label_set_1.LabelSet);
    var legend_1 = require(175) /* ./legend */;
    __esExport("Legend", legend_1.Legend);
    var legend_item_1 = require(176) /* ./legend_item */;
    __esExport("LegendItem", legend_item_1.LegendItem);
    var poly_annotation_1 = require(178) /* ./poly_annotation */;
    __esExport("PolyAnnotation", poly_annotation_1.PolyAnnotation);
    var slope_1 = require(179) /* ./slope */;
    __esExport("Slope", slope_1.Slope);
    var span_1 = require(180) /* ./span */;
    __esExport("Span", span_1.Span);
    var text_annotation_1 = require(173) /* ./text_annotation */;
    __esExport("TextAnnotation", text_annotation_1.TextAnnotation);
    var title_1 = require(181) /* ./title */;
    __esExport("Title", title_1.Title);
    var toolbar_panel_1 = require(182) /* ./toolbar_panel */;
    __esExport("ToolbarPanel", toolbar_panel_1.ToolbarPanel);
    var tooltip_1 = require(200) /* ./tooltip */;
    __esExport("Tooltip", tooltip_1.Tooltip);
    var whisker_1 = require(203) /* ./whisker */;
    __esExport("Whisker", whisker_1.Whisker);
},
/* models/annotations/annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const proj = tslib_1.__importStar(require(36) /* ../../core/util/projections */);
    const object_1 = require(13) /* ../../core/util/object */;
    const renderer_1 = require(69) /* ../renderers/renderer */;
    class AnnotationView extends renderer_1.RendererView {
        get panel() {
            return this.layout;
        }
        connect_signals() {
            super.connect_signals();
            const p = this.model.properties;
            this.on_change(p.visible, () => this.plot_view.request_layout());
        }
        get_size() {
            if (this.model.visible) {
                const { width, height } = this._get_size();
                return { width: Math.round(width), height: Math.round(height) };
            }
            else
                return { width: 0, height: 0 };
        }
        _get_size() {
            throw new Error("not implemented");
        }
        set_data(source) {
            const data = this.model.materialize_dataspecs(source);
            object_1.extend(this, data);
            if (this.plot_model.use_map) {
                const self = this;
                if (self._x != null)
                    [self._x, self._y] = proj.project_xy(self._x, self._y);
                if (self._xs != null)
                    [self._xs, self._ys] = proj.project_xsys(self._xs, self._ys);
            }
        }
        get needs_clip() {
            return this.layout == null; // TODO: change this, when center layout is fully implemented
        }
        serializable_state() {
            const state = super.serializable_state();
            return this.layout == null ? state : Object.assign(Object.assign({}, state), { bbox: this.layout.bbox.box });
        }
    }
    exports.AnnotationView = AnnotationView;
    AnnotationView.__name__ = "AnnotationView";
    class Annotation extends renderer_1.Renderer {
        constructor(attrs) {
            super(attrs);
        }
        static init_Annotation() {
            this.override({
                level: 'annotation',
            });
        }
    }
    exports.Annotation = Annotation;
    Annotation.__name__ = "Annotation";
    Annotation.init_Annotation();
},
/* core/util/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const core_1 = tslib_1.__importDefault(require(37) /* proj4/lib/core */);
    const Proj_1 = tslib_1.__importDefault(require(38) /* proj4/lib/Proj */);
    const types_1 = require(24) /* ../types */;
    const mercator = new Proj_1.default('GOOGLE');
    const wgs84 = new Proj_1.default('WGS84');
    const _wgs84_mercator = core_1.default(wgs84, mercator);
    exports.wgs84_mercator = {
        compute(x, y) {
            if (isFinite(x) && isFinite(y))
                return _wgs84_mercator.forward([x, y]);
            else
                return [NaN, NaN];
        },
        invert(merc_x, merc_y) {
            if (isFinite(merc_x) && isFinite(merc_y))
                return _wgs84_mercator.inverse([merc_x, merc_y]);
            else
                return [NaN, NaN];
        },
    };
    const mercator_bounds = {
        lon: [-20026376.39, 20026376.39],
        lat: [-20048966.10, 20048966.10],
    };
    const latlon_bounds = {
        lon: [-180, 180],
        lat: [-85.06, 85.06],
    };
    const { min, max } = Math;
    function clip_mercator(low, high, dimension) {
        const [vmin, vmax] = mercator_bounds[dimension];
        return [max(low, vmin), min(high, vmax)];
    }
    exports.clip_mercator = clip_mercator;
    function in_bounds(value, dimension) {
        const [min, max] = latlon_bounds[dimension];
        return min < value && value < max;
    }
    exports.in_bounds = in_bounds;
    (function (inplace) {
        function project_xy(x, y, merc_x, merc_y) {
            const n = min(x.length, y.length);
            merc_x = merc_x !== null && merc_x !== void 0 ? merc_x : x;
            merc_y = merc_y !== null && merc_y !== void 0 ? merc_y : y;
            for (let i = 0; i < n; i++) {
                const xi = x[i];
                const yi = y[i];
                const [merc_xi, merc_yi] = exports.wgs84_mercator.compute(xi, yi);
                merc_x[i] = merc_xi;
                merc_y[i] = merc_yi;
            }
        }
        inplace.project_xy = project_xy;
        function project_xsys(xs, ys, merc_xs, merc_ys) {
            const n = min(xs.length, ys.length);
            merc_xs = merc_xs !== null && merc_xs !== void 0 ? merc_xs : xs;
            merc_ys = merc_ys !== null && merc_ys !== void 0 ? merc_ys : ys;
            for (let i = 0; i < n; i++) {
                project_xy(xs[i], ys[i], merc_xs[i], merc_ys[i]);
            }
        }
        inplace.project_xsys = project_xsys;
    })(exports.inplace || (exports.inplace = {}));
    function project_xy(x, y) {
        const n = min(x.length, y.length);
        const merc_x = new types_1.NumberArray(n);
        const merc_y = new types_1.NumberArray(n);
        exports.inplace.project_xy(x, y, merc_x, merc_y);
        return [merc_x, merc_y];
    }
    exports.project_xy = project_xy;
    function project_xsys(xs, ys) {
        const n = min(xs.length, ys.length);
        const merc_xs = new Array(n);
        const merc_ys = new Array(n);
        for (let i = 0; i < n; i++) {
            const [merc_x, merc_y] = project_xy(xs[i], ys[i]);
            merc_xs[i] = merc_x;
            merc_ys[i] = merc_y;
        }
        return [merc_xs, merc_ys];
    }
    exports.project_xsys = project_xsys;
},
/* proj4/lib/core.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const Proj_1 = tslib_1.__importDefault(require(38) /* ./Proj */);
    const transform_1 = tslib_1.__importDefault(require(63) /* ./transform */);
    var wgs84 = Proj_1.default('WGS84');
    function transformer(from, to, coords) {
        var transformedArray, out, keys;
        if (Array.isArray(coords)) {
            transformedArray = transform_1.default(from, to, coords) || { x: NaN, y: NaN };
            if (coords.length > 2) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (typeof transformedArray.z === 'number') {
                        return [transformedArray.x, transformedArray.y, transformedArray.z].concat(coords.splice(3));
                    }
                    else {
                        return [transformedArray.x, transformedArray.y, coords[2]].concat(coords.splice(3));
                    }
                }
                else {
                    return [transformedArray.x, transformedArray.y].concat(coords.splice(2));
                }
            }
            else {
                return [transformedArray.x, transformedArray.y];
            }
        }
        else {
            out = transform_1.default(from, to, coords);
            keys = Object.keys(coords);
            if (keys.length === 2) {
                return out;
            }
            keys.forEach(function (key) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (key === 'x' || key === 'y' || key === 'z') {
                        return;
                    }
                }
                else {
                    if (key === 'x' || key === 'y') {
                        return;
                    }
                }
                out[key] = coords[key];
            });
            return out;
        }
    }
    function checkProj(item) {
        if (item instanceof Proj_1.default) {
            return item;
        }
        if (item.oProj) {
            return item.oProj;
        }
        return Proj_1.default(item);
    }
    function proj4(fromProj, toProj, coord) {
        fromProj = checkProj(fromProj);
        var single = false;
        var obj;
        if (typeof toProj === 'undefined') {
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        else if (typeof toProj.x !== 'undefined' || Array.isArray(toProj)) {
            coord = toProj;
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        toProj = checkProj(toProj);
        if (coord) {
            return transformer(fromProj, toProj, coord);
        }
        else {
            obj = {
                forward: function (coords) {
                    return transformer(fromProj, toProj, coords);
                },
                inverse: function (coords) {
                    return transformer(toProj, fromProj, coords);
                }
            };
            if (single) {
                obj.oProj = toProj;
            }
            return obj;
        }
    }
    exports.default = proj4;
},
/* proj4/lib/Proj.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const parseCode_1 = tslib_1.__importDefault(require(39) /* ./parseCode */);
    const extend_1 = tslib_1.__importDefault(require(50) /* ./extend */);
    const projections_1 = tslib_1.__importDefault(require(51) /* ./projections */);
    const deriveConstants_1 = require(59) /* ./deriveConstants */;
    const Datum_1 = tslib_1.__importDefault(require(61) /* ./constants/Datum */);
    const datum_1 = tslib_1.__importDefault(require(62) /* ./datum */);
    const match_1 = tslib_1.__importDefault(require(46) /* ./match */);
    function Projection(srsCode, callback) {
        if (!(this instanceof Projection)) {
            return new Projection(srsCode);
        }
        callback = callback || function (error) {
            if (error) {
                throw error;
            }
        };
        var json = parseCode_1.default(srsCode);
        if (typeof json !== 'object') {
            callback(srsCode);
            return;
        }
        var ourProj = Projection.projections.get(json.projName);
        if (!ourProj) {
            callback(srsCode);
            return;
        }
        if (json.datumCode && json.datumCode !== 'none') {
            var datumDef = match_1.default(Datum_1.default, json.datumCode);
            if (datumDef) {
                json.datum_params = datumDef.towgs84 ? datumDef.towgs84.split(',') : null;
                json.ellps = datumDef.ellipse;
                json.datumName = datumDef.datumName ? datumDef.datumName : json.datumCode;
            }
        }
        json.k0 = json.k0 || 1.0;
        json.axis = json.axis || 'enu';
        json.ellps = json.ellps || 'wgs84';
        var sphere_ = deriveConstants_1.sphere(json.a, json.b, json.rf, json.ellps, json.sphere);
        var ecc = deriveConstants_1.eccentricity(sphere_.a, sphere_.b, sphere_.rf, json.R_A);
        var datumObj = json.datum || datum_1.default(json.datumCode, json.datum_params, sphere_.a, sphere_.b, ecc.es, ecc.ep2);
        extend_1.default(this, json); // transfer everything over from the projection because we don't know what we'll need
        extend_1.default(this, ourProj); // transfer all the methods from the projection
        // copy the 4 things over we calulated in deriveConstants.sphere
        this.a = sphere_.a;
        this.b = sphere_.b;
        this.rf = sphere_.rf;
        this.sphere = sphere_.sphere;
        // copy the 3 things we calculated in deriveConstants.eccentricity
        this.es = ecc.es;
        this.e = ecc.e;
        this.ep2 = ecc.ep2;
        // add in the datum object
        this.datum = datumObj;
        // init the projection
        this.init();
        // legecy callback from back in the day when it went to spatialreference.org
        callback(null, this);
    }
    Projection.projections = projections_1.default;
    Projection.projections.start();
    exports.default = Projection;
},
/* proj4/lib/parseCode.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const defs_1 = tslib_1.__importDefault(require(40) /* ./defs */);
    const wkt_parser_1 = tslib_1.__importDefault(require(47) /* wkt-parser */);
    const projString_1 = tslib_1.__importDefault(require(42) /* ./projString */);
    const match_1 = tslib_1.__importDefault(require(46) /* ./match */);
    function testObj(code) {
        return typeof code === 'string';
    }
    function testDef(code) {
        return code in defs_1.default;
    }
    var codeWords = ['PROJECTEDCRS', 'PROJCRS', 'GEOGCS', 'GEOCCS', 'PROJCS', 'LOCAL_CS', 'GEODCRS', 'GEODETICCRS', 'GEODETICDATUM', 'ENGCRS', 'ENGINEERINGCRS'];
    function testWKT(code) {
        return codeWords.some(function (word) {
            return code.indexOf(word) > -1;
        });
    }
    var codes = ['3857', '900913', '3785', '102113'];
    function checkMercator(item) {
        var auth = match_1.default(item, 'authority');
        if (!auth) {
            return;
        }
        var code = match_1.default(auth, 'epsg');
        return code && codes.indexOf(code) > -1;
    }
    function checkProjStr(item) {
        var ext = match_1.default(item, 'extension');
        if (!ext) {
            return;
        }
        return match_1.default(ext, 'proj4');
    }
    function testProj(code) {
        return code[0] === '+';
    }
    function parse(code) {
        if (testObj(code)) {
            //check to see if this is a WKT string
            if (testDef(code)) {
                return defs_1.default[code];
            }
            if (testWKT(code)) {
                var out = wkt_parser_1.default(code);
                // test of spetial case, due to this being a very common and often malformed
                if (checkMercator(out)) {
                    return defs_1.default['EPSG:3857'];
                }
                var maybeProjStr = checkProjStr(out);
                if (maybeProjStr) {
                    return projString_1.default(maybeProjStr);
                }
                return out;
            }
            if (testProj(code)) {
                return projString_1.default(code);
            }
        }
        else {
            return code;
        }
    }
    exports.default = parse;
},
/* proj4/lib/defs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const global_1 = tslib_1.__importDefault(require(41) /* ./global */);
    const projString_1 = tslib_1.__importDefault(require(42) /* ./projString */);
    const wkt_parser_1 = tslib_1.__importDefault(require(47) /* wkt-parser */);
    function defs(name) {
        /*global console*/
        var that = this;
        if (arguments.length === 2) {
            var def = arguments[1];
            if (typeof def === 'string') {
                if (def.charAt(0) === '+') {
                    defs[name] = projString_1.default(arguments[1]);
                }
                else {
                    defs[name] = wkt_parser_1.default(arguments[1]);
                }
            }
            else {
                defs[name] = def;
            }
        }
        else if (arguments.length === 1) {
            if (Array.isArray(name)) {
                return name.map(function (v) {
                    if (Array.isArray(v)) {
                        defs.apply(that, v);
                    }
                    else {
                        defs(v);
                    }
                });
            }
            else if (typeof name === 'string') {
                if (name in defs) {
                    return defs[name];
                }
            }
            else if ('EPSG' in name) {
                defs['EPSG:' + name.EPSG] = name;
            }
            else if ('ESRI' in name) {
                defs['ESRI:' + name.ESRI] = name;
            }
            else if ('IAU2000' in name) {
                defs['IAU2000:' + name.IAU2000] = name;
            }
            else {
                console.log(name);
            }
            return;
        }
    }
    global_1.default(defs);
    exports.default = defs;
},
/* proj4/lib/global.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(defs) {
        defs('EPSG:4326', "+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
        defs('EPSG:4269', "+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees");
        defs('EPSG:3857', "+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs");
        defs.WGS84 = defs['EPSG:4326'];
        defs['EPSG:3785'] = defs['EPSG:3857']; // maintain backward compat, official code is 3857
        defs.GOOGLE = defs['EPSG:3857'];
        defs['EPSG:900913'] = defs['EPSG:3857'];
        defs['EPSG:102113'] = defs['EPSG:3857'];
    }
    exports.default = default_1;
},
/* proj4/lib/projString.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(43) /* ./constants/values */;
    const PrimeMeridian_1 = tslib_1.__importDefault(require(44) /* ./constants/PrimeMeridian */);
    const units_1 = tslib_1.__importDefault(require(45) /* ./constants/units */);
    const match_1 = tslib_1.__importDefault(require(46) /* ./match */);
    function default_1(defData) {
        var self = {};
        var paramObj = defData.split('+').map(function (v) {
            return v.trim();
        }).filter(function (a) {
            return a;
        }).reduce(function (p, a) {
            var split = a.split('=');
            split.push(true);
            p[split[0].toLowerCase()] = split[1];
            return p;
        }, {});
        var paramName, paramVal, paramOutname;
        var params = {
            proj: 'projName',
            datum: 'datumCode',
            rf: function (v) {
                self.rf = parseFloat(v);
            },
            lat_0: function (v) {
                self.lat0 = v * values_1.D2R;
            },
            lat_1: function (v) {
                self.lat1 = v * values_1.D2R;
            },
            lat_2: function (v) {
                self.lat2 = v * values_1.D2R;
            },
            lat_ts: function (v) {
                self.lat_ts = v * values_1.D2R;
            },
            lon_0: function (v) {
                self.long0 = v * values_1.D2R;
            },
            lon_1: function (v) {
                self.long1 = v * values_1.D2R;
            },
            lon_2: function (v) {
                self.long2 = v * values_1.D2R;
            },
            alpha: function (v) {
                self.alpha = parseFloat(v) * values_1.D2R;
            },
            lonc: function (v) {
                self.longc = v * values_1.D2R;
            },
            x_0: function (v) {
                self.x0 = parseFloat(v);
            },
            y_0: function (v) {
                self.y0 = parseFloat(v);
            },
            k_0: function (v) {
                self.k0 = parseFloat(v);
            },
            k: function (v) {
                self.k0 = parseFloat(v);
            },
            a: function (v) {
                self.a = parseFloat(v);
            },
            b: function (v) {
                self.b = parseFloat(v);
            },
            r_a: function () {
                self.R_A = true;
            },
            zone: function (v) {
                self.zone = parseInt(v, 10);
            },
            south: function () {
                self.utmSouth = true;
            },
            towgs84: function (v) {
                self.datum_params = v.split(",").map(function (a) {
                    return parseFloat(a);
                });
            },
            to_meter: function (v) {
                self.to_meter = parseFloat(v);
            },
            units: function (v) {
                self.units = v;
                var unit = match_1.default(units_1.default, v);
                if (unit) {
                    self.to_meter = unit.to_meter;
                }
            },
            from_greenwich: function (v) {
                self.from_greenwich = v * values_1.D2R;
            },
            pm: function (v) {
                var pm = match_1.default(PrimeMeridian_1.default, v);
                self.from_greenwich = (pm ? pm : parseFloat(v)) * values_1.D2R;
            },
            nadgrids: function (v) {
                if (v === '@null') {
                    self.datumCode = 'none';
                }
                else {
                    self.nadgrids = v;
                }
            },
            axis: function (v) {
                var legalAxis = "ewnsud";
                if (v.length === 3 && legalAxis.indexOf(v.substr(0, 1)) !== -1 && legalAxis.indexOf(v.substr(1, 1)) !== -1 && legalAxis.indexOf(v.substr(2, 1)) !== -1) {
                    self.axis = v;
                }
            }
        };
        for (paramName in paramObj) {
            paramVal = paramObj[paramName];
            if (paramName in params) {
                paramOutname = params[paramName];
                if (typeof paramOutname === 'function') {
                    paramOutname(paramVal);
                }
                else {
                    self[paramOutname] = paramVal;
                }
            }
            else {
                self[paramName] = paramVal;
            }
        }
        if (typeof self.datumCode === 'string' && self.datumCode !== "WGS84") {
            self.datumCode = self.datumCode.toLowerCase();
        }
        return self;
    }
    exports.default = default_1;
},
/* proj4/lib/constants/values.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.PJD_3PARAM = 1;
    exports.PJD_7PARAM = 2;
    exports.PJD_WGS84 = 4; // WGS84 or equivalent
    exports.PJD_NODATUM = 5; // WGS84 or equivalent
    exports.SEC_TO_RAD = 4.84813681109535993589914102357e-6;
    exports.HALF_PI = Math.PI / 2;
    // ellipoid pj_set_ell.c
    exports.SIXTH = 0.1666666666666666667;
    /* 1/6 */
    exports.RA4 = 0.04722222222222222222;
    /* 17/360 */
    exports.RA6 = 0.02215608465608465608;
    exports.EPSLN = 1.0e-10;
    // you'd think you could use Number.EPSILON above but that makes
    // Mollweide get into an infinate loop.
    exports.D2R = 0.01745329251994329577;
    exports.R2D = 57.29577951308232088;
    exports.FORTPI = Math.PI / 4;
    exports.TWO_PI = Math.PI * 2;
    // SPI is slightly greater than Math.PI, so values that exceed the -180..180
    // degree range by a tiny amount don't get wrapped. This prevents points that
    // have drifted from their original location along the 180th meridian (due to
    // floating point error) from changing their sign.
    exports.SPI = 3.14159265359;
},
/* proj4/lib/constants/PrimeMeridian.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.greenwich = 0.0; //"0dE",
    exports$1.lisbon = -9.131906111111; //"9d07'54.862\"W",
    exports$1.paris = 2.337229166667; //"2d20'14.025\"E",
    exports$1.bogota = -74.080916666667; //"74d04'51.3\"W",
    exports$1.madrid = -3.687938888889; //"3d41'16.58\"W",
    exports$1.rome = 12.452333333333; //"12d27'8.4\"E",
    exports$1.bern = 7.439583333333; //"7d26'22.5\"E",
    exports$1.jakarta = 106.807719444444; //"106d48'27.79\"E",
    exports$1.ferro = -17.666666666667; //"17d40'W",
    exports$1.brussels = 4.367975; //"4d22'4.71\"E",
    exports$1.stockholm = 18.058277777778; //"18d3'29.8\"E",
    exports$1.athens = 23.7163375; //"23d42'58.815\"E",
    exports$1.oslo = 10.722916666667; //"10d43'22.5\"E"
},
/* proj4/lib/constants/units.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = {
        ft: { to_meter: 0.3048 },
        'us-ft': { to_meter: 1200 / 3937 }
    };
},
/* proj4/lib/match.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var ignoredChar = /[\s_\-\/\(\)]/g;
    function match(obj, key) {
        if (obj[key]) {
            return obj[key];
        }
        var keys = Object.keys(obj);
        var lkey = key.toLowerCase().replace(ignoredChar, '');
        var i = -1;
        var testkey, processedKey;
        while (++i < keys.length) {
            testkey = keys[i];
            processedKey = testkey.toLowerCase().replace(ignoredChar, '');
            if (processedKey === lkey) {
                return obj[testkey];
            }
        }
    }
    exports.default = match;
},
/* wkt-parser/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var D2R = 0.01745329251994329577;
    const parser_1 = tslib_1.__importDefault(require(48) /* ./parser */);
    const process_1 = require(49) /* ./process */;
    function rename(obj, params) {
        var outName = params[0];
        var inName = params[1];
        if (!(outName in obj) && (inName in obj)) {
            obj[outName] = obj[inName];
            if (params.length === 3) {
                obj[outName] = params[2](obj[outName]);
            }
        }
    }
    function d2r(input) {
        return input * D2R;
    }
    function cleanWKT(wkt) {
        if (wkt.type === 'GEOGCS') {
            wkt.projName = 'longlat';
        }
        else if (wkt.type === 'LOCAL_CS') {
            wkt.projName = 'identity';
            wkt.local = true;
        }
        else {
            if (typeof wkt.PROJECTION === 'object') {
                wkt.projName = Object.keys(wkt.PROJECTION)[0];
            }
            else {
                wkt.projName = wkt.PROJECTION;
            }
        }
        if (wkt.AXIS) {
            var axisOrder = '';
            for (var i = 0, ii = wkt.AXIS.length; i < ii; ++i) {
                var axis = wkt.AXIS[i];
                var descriptor = axis[0].toLowerCase();
                if (descriptor.indexOf('north') !== -1) {
                    axisOrder += 'n';
                }
                else if (descriptor.indexOf('south') !== -1) {
                    axisOrder += 's';
                }
                else if (descriptor.indexOf('east') !== -1) {
                    axisOrder += 'e';
                }
                else if (descriptor.indexOf('west') !== -1) {
                    axisOrder += 'w';
                }
            }
            if (axisOrder.length === 2) {
                axisOrder += 'u';
            }
            if (axisOrder.length === 3) {
                wkt.axis = axisOrder;
            }
        }
        if (wkt.UNIT) {
            wkt.units = wkt.UNIT.name.toLowerCase();
            if (wkt.units === 'metre') {
                wkt.units = 'meter';
            }
            if (wkt.UNIT.convert) {
                if (wkt.type === 'GEOGCS') {
                    if (wkt.DATUM && wkt.DATUM.SPHEROID) {
                        wkt.to_meter = wkt.UNIT.convert * wkt.DATUM.SPHEROID.a;
                    }
                }
                else {
                    wkt.to_meter = wkt.UNIT.convert;
                }
            }
        }
        var geogcs = wkt.GEOGCS;
        if (wkt.type === 'GEOGCS') {
            geogcs = wkt;
        }
        if (geogcs) {
            //if(wkt.GEOGCS.PRIMEM&&wkt.GEOGCS.PRIMEM.convert){
            //  wkt.from_greenwich=wkt.GEOGCS.PRIMEM.convert*D2R;
            //}
            if (geogcs.DATUM) {
                wkt.datumCode = geogcs.DATUM.name.toLowerCase();
            }
            else {
                wkt.datumCode = geogcs.name.toLowerCase();
            }
            if (wkt.datumCode.slice(0, 2) === 'd_') {
                wkt.datumCode = wkt.datumCode.slice(2);
            }
            if (wkt.datumCode === 'new_zealand_geodetic_datum_1949' || wkt.datumCode === 'new_zealand_1949') {
                wkt.datumCode = 'nzgd49';
            }
            if (wkt.datumCode === 'wgs_1984' || wkt.datumCode === 'world_geodetic_system_1984') {
                if (wkt.PROJECTION === 'Mercator_Auxiliary_Sphere') {
                    wkt.sphere = true;
                }
                wkt.datumCode = 'wgs84';
            }
            if (wkt.datumCode.slice(-6) === '_ferro') {
                wkt.datumCode = wkt.datumCode.slice(0, -6);
            }
            if (wkt.datumCode.slice(-8) === '_jakarta') {
                wkt.datumCode = wkt.datumCode.slice(0, -8);
            }
            if (~wkt.datumCode.indexOf('belge')) {
                wkt.datumCode = 'rnb72';
            }
            if (geogcs.DATUM && geogcs.DATUM.SPHEROID) {
                wkt.ellps = geogcs.DATUM.SPHEROID.name.replace('_19', '').replace(/[Cc]larke\_18/, 'clrk');
                if (wkt.ellps.toLowerCase().slice(0, 13) === 'international') {
                    wkt.ellps = 'intl';
                }
                wkt.a = geogcs.DATUM.SPHEROID.a;
                wkt.rf = parseFloat(geogcs.DATUM.SPHEROID.rf, 10);
            }
            if (geogcs.DATUM && geogcs.DATUM.TOWGS84) {
                wkt.datum_params = geogcs.DATUM.TOWGS84;
            }
            if (~wkt.datumCode.indexOf('osgb_1936')) {
                wkt.datumCode = 'osgb36';
            }
            if (~wkt.datumCode.indexOf('osni_1952')) {
                wkt.datumCode = 'osni52';
            }
            if (~wkt.datumCode.indexOf('tm65')
                || ~wkt.datumCode.indexOf('geodetic_datum_of_1965')) {
                wkt.datumCode = 'ire65';
            }
            if (wkt.datumCode === 'ch1903+') {
                wkt.datumCode = 'ch1903';
            }
            if (~wkt.datumCode.indexOf('israel')) {
                wkt.datumCode = 'isr93';
            }
        }
        if (wkt.b && !isFinite(wkt.b)) {
            wkt.b = wkt.a;
        }
        function toMeter(input) {
            var ratio = wkt.to_meter || 1;
            return input * ratio;
        }
        var renamer = function (a) {
            return rename(wkt, a);
        };
        var list = [
            ['standard_parallel_1', 'Standard_Parallel_1'],
            ['standard_parallel_2', 'Standard_Parallel_2'],
            ['false_easting', 'False_Easting'],
            ['false_northing', 'False_Northing'],
            ['central_meridian', 'Central_Meridian'],
            ['latitude_of_origin', 'Latitude_Of_Origin'],
            ['latitude_of_origin', 'Central_Parallel'],
            ['scale_factor', 'Scale_Factor'],
            ['k0', 'scale_factor'],
            ['latitude_of_center', 'Latitude_Of_Center'],
            ['latitude_of_center', 'Latitude_of_center'],
            ['lat0', 'latitude_of_center', d2r],
            ['longitude_of_center', 'Longitude_Of_Center'],
            ['longitude_of_center', 'Longitude_of_center'],
            ['longc', 'longitude_of_center', d2r],
            ['x0', 'false_easting', toMeter],
            ['y0', 'false_northing', toMeter],
            ['long0', 'central_meridian', d2r],
            ['lat0', 'latitude_of_origin', d2r],
            ['lat0', 'standard_parallel_1', d2r],
            ['lat1', 'standard_parallel_1', d2r],
            ['lat2', 'standard_parallel_2', d2r],
            ['azimuth', 'Azimuth'],
            ['alpha', 'azimuth', d2r],
            ['srsCode', 'name']
        ];
        list.forEach(renamer);
        if (!wkt.long0 && wkt.longc && (wkt.projName === 'Albers_Conic_Equal_Area' || wkt.projName === 'Lambert_Azimuthal_Equal_Area')) {
            wkt.long0 = wkt.longc;
        }
        if (!wkt.lat_ts && wkt.lat1 && (wkt.projName === 'Stereographic_South_Pole' || wkt.projName === 'Polar Stereographic (variant B)')) {
            wkt.lat0 = d2r(wkt.lat1 > 0 ? 90 : -90);
            wkt.lat_ts = wkt.lat1;
        }
    }
    function default_1(wkt) {
        var lisp = parser_1.default(wkt);
        var type = lisp.shift();
        var name = lisp.shift();
        lisp.unshift(['name', name]);
        lisp.unshift(['type', type]);
        var obj = {};
        process_1.sExpr(lisp, obj);
        cleanWKT(obj);
        return obj;
    }
    exports.default = default_1;
},
/* wkt-parser/parser.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = parseString;
    var NEUTRAL = 1;
    var KEYWORD = 2;
    var NUMBER = 3;
    var QUOTED = 4;
    var AFTERQUOTE = 5;
    var ENDED = -1;
    var whitespace = /\s/;
    var latin = /[A-Za-z]/;
    var keyword = /[A-Za-z84]/;
    var endThings = /[,\]]/;
    var digets = /[\d\.E\-\+]/;
    // const ignoredChar = /[\s_\-\/\(\)]/g;
    function Parser(text) {
        if (typeof text !== 'string') {
            throw new Error('not a string');
        }
        this.text = text.trim();
        this.level = 0;
        this.place = 0;
        this.root = null;
        this.stack = [];
        this.currentObject = null;
        this.state = NEUTRAL;
    }
    Parser.prototype.readCharicter = function () {
        var char = this.text[this.place++];
        if (this.state !== QUOTED) {
            while (whitespace.test(char)) {
                if (this.place >= this.text.length) {
                    return;
                }
                char = this.text[this.place++];
            }
        }
        switch (this.state) {
            case NEUTRAL:
                return this.neutral(char);
            case KEYWORD:
                return this.keyword(char);
            case QUOTED:
                return this.quoted(char);
            case AFTERQUOTE:
                return this.afterquote(char);
            case NUMBER:
                return this.number(char);
            case ENDED:
                return;
        }
    };
    Parser.prototype.afterquote = function (char) {
        if (char === '"') {
            this.word += '"';
            this.state = QUOTED;
            return;
        }
        if (endThings.test(char)) {
            this.word = this.word.trim();
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in afterquote yet, index ' + this.place);
    };
    Parser.prototype.afterItem = function (char) {
        if (char === ',') {
            if (this.word !== null) {
                this.currentObject.push(this.word);
            }
            this.word = null;
            this.state = NEUTRAL;
            return;
        }
        if (char === ']') {
            this.level--;
            if (this.word !== null) {
                this.currentObject.push(this.word);
                this.word = null;
            }
            this.state = NEUTRAL;
            this.currentObject = this.stack.pop();
            if (!this.currentObject) {
                this.state = ENDED;
            }
            return;
        }
    };
    Parser.prototype.number = function (char) {
        if (digets.test(char)) {
            this.word += char;
            return;
        }
        if (endThings.test(char)) {
            this.word = parseFloat(this.word);
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in number yet, index ' + this.place);
    };
    Parser.prototype.quoted = function (char) {
        if (char === '"') {
            this.state = AFTERQUOTE;
            return;
        }
        this.word += char;
        return;
    };
    Parser.prototype.keyword = function (char) {
        if (keyword.test(char)) {
            this.word += char;
            return;
        }
        if (char === '[') {
            var newObjects = [];
            newObjects.push(this.word);
            this.level++;
            if (this.root === null) {
                this.root = newObjects;
            }
            else {
                this.currentObject.push(newObjects);
            }
            this.stack.push(this.currentObject);
            this.currentObject = newObjects;
            this.state = NEUTRAL;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in keyword yet, index ' + this.place);
    };
    Parser.prototype.neutral = function (char) {
        if (latin.test(char)) {
            this.word = char;
            this.state = KEYWORD;
            return;
        }
        if (char === '"') {
            this.word = '';
            this.state = QUOTED;
            return;
        }
        if (digets.test(char)) {
            this.word = char;
            this.state = NUMBER;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in neutral yet, index ' + this.place);
    };
    Parser.prototype.output = function () {
        while (this.place < this.text.length) {
            this.readCharicter();
        }
        if (this.state === ENDED) {
            return this.root;
        }
        throw new Error('unable to parse string "' + this.text + '". State is ' + this.state);
    };
    function parseString(txt) {
        var parser = new Parser(txt);
        return parser.output();
    }
},
/* wkt-parser/process.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function mapit(obj, key, value) {
        if (Array.isArray(key)) {
            value.unshift(key);
            key = null;
        }
        var thing = key ? {} : obj;
        var out = value.reduce(function (newObj, item) {
            sExpr(item, newObj);
            return newObj;
        }, thing);
        if (key) {
            obj[key] = out;
        }
    }
    function sExpr(v, obj) {
        if (!Array.isArray(v)) {
            obj[v] = true;
            return;
        }
        var key = v.shift();
        if (key === 'PARAMETER') {
            key = v.shift();
        }
        if (v.length === 1) {
            if (Array.isArray(v[0])) {
                obj[key] = {};
                sExpr(v[0], obj[key]);
                return;
            }
            obj[key] = v[0];
            return;
        }
        if (!v.length) {
            obj[key] = true;
            return;
        }
        if (key === 'TOWGS84') {
            obj[key] = v;
            return;
        }
        if (key === 'AXIS') {
            if (!(key in obj)) {
                obj[key] = [];
            }
            obj[key].push(v);
            return;
        }
        if (!Array.isArray(key)) {
            obj[key] = {};
        }
        var i;
        switch (key) {
            case 'UNIT':
            case 'PRIMEM':
            case 'VERT_DATUM':
                obj[key] = {
                    name: v[0].toLowerCase(),
                    convert: v[1]
                };
                if (v.length === 3) {
                    sExpr(v[2], obj[key]);
                }
                return;
            case 'SPHEROID':
            case 'ELLIPSOID':
                obj[key] = {
                    name: v[0],
                    a: v[1],
                    rf: v[2]
                };
                if (v.length === 4) {
                    sExpr(v[3], obj[key]);
                }
                return;
            case 'PROJECTEDCRS':
            case 'PROJCRS':
            case 'GEOGCS':
            case 'GEOCCS':
            case 'PROJCS':
            case 'LOCAL_CS':
            case 'GEODCRS':
            case 'GEODETICCRS':
            case 'GEODETICDATUM':
            case 'EDATUM':
            case 'ENGINEERINGDATUM':
            case 'VERT_CS':
            case 'VERTCRS':
            case 'VERTICALCRS':
            case 'COMPD_CS':
            case 'COMPOUNDCRS':
            case 'ENGINEERINGCRS':
            case 'ENGCRS':
            case 'FITTED_CS':
            case 'LOCAL_DATUM':
            case 'DATUM':
                v[0] = ['name', v[0]];
                mapit(obj, key, v);
                return;
            default:
                i = -1;
                while (++i < v.length) {
                    if (!Array.isArray(v[i])) {
                        return sExpr(v, obj[key]);
                    }
                }
                return mapit(obj, key, v);
        }
    }
    exports.sExpr = sExpr;
},
/* proj4/lib/extend.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(destination, source) {
        destination = destination || {};
        var value, property;
        if (!source) {
            return destination;
        }
        for (property in source) {
            value = source[property];
            if (value !== undefined) {
                destination[property] = value;
            }
        }
        return destination;
    }
    exports.default = default_1;
},
/* proj4/lib/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const merc_1 = tslib_1.__importDefault(require(52) /* ./projections/merc */);
    const longlat_1 = tslib_1.__importDefault(require(58) /* ./projections/longlat */);
    var projs = [merc_1.default, longlat_1.default];
    var names = {};
    var projStore = [];
    function add(proj, i) {
        var len = projStore.length;
        if (!proj.names) {
            console.log(i);
            return true;
        }
        projStore[len] = proj;
        proj.names.forEach(function (n) {
            names[n.toLowerCase()] = len;
        });
        return this;
    }
    exports.add = add;
    function get(name) {
        if (!name) {
            return false;
        }
        var n = name.toLowerCase();
        if (typeof names[n] !== 'undefined' && projStore[names[n]]) {
            return projStore[names[n]];
        }
    }
    exports.get = get;
    function start() {
        projs.forEach(add);
    }
    exports.start = start;
    exports.default = {
        start: start,
        add: add,
        get: get
    };
},
/* proj4/lib/projections/merc.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const msfnz_1 = tslib_1.__importDefault(require(53) /* ../common/msfnz */);
    const adjust_lon_1 = tslib_1.__importDefault(require(54) /* ../common/adjust_lon */);
    const tsfnz_1 = tslib_1.__importDefault(require(56) /* ../common/tsfnz */);
    const phi2z_1 = tslib_1.__importDefault(require(57) /* ../common/phi2z */);
    const values_1 = require(43) /* ../constants/values */;
    function init() {
        var con = this.b / this.a;
        this.es = 1 - con * con;
        if (!('x0' in this)) {
            this.x0 = 0;
        }
        if (!('y0' in this)) {
            this.y0 = 0;
        }
        this.e = Math.sqrt(this.es);
        if (this.lat_ts) {
            if (this.sphere) {
                this.k0 = Math.cos(this.lat_ts);
            }
            else {
                this.k0 = msfnz_1.default(this.e, Math.sin(this.lat_ts), Math.cos(this.lat_ts));
            }
        }
        else {
            if (!this.k0) {
                if (this.k) {
                    this.k0 = this.k;
                }
                else {
                    this.k0 = 1;
                }
            }
        }
    }
    exports.init = init;
    /* Mercator forward equations--mapping lat,long to x,y
      --------------------------------------------------*/
    function forward(p) {
        var lon = p.x;
        var lat = p.y;
        // convert to radians
        if (lat * values_1.R2D > 90 && lat * values_1.R2D < -90 && lon * values_1.R2D > 180 && lon * values_1.R2D < -180) {
            return null;
        }
        var x, y;
        if (Math.abs(Math.abs(lat) - values_1.HALF_PI) <= values_1.EPSLN) {
            return null;
        }
        else {
            if (this.sphere) {
                x = this.x0 + this.a * this.k0 * adjust_lon_1.default(lon - this.long0);
                y = this.y0 + this.a * this.k0 * Math.log(Math.tan(values_1.FORTPI + 0.5 * lat));
            }
            else {
                var sinphi = Math.sin(lat);
                var ts = tsfnz_1.default(this.e, lat, sinphi);
                x = this.x0 + this.a * this.k0 * adjust_lon_1.default(lon - this.long0);
                y = this.y0 - this.a * this.k0 * Math.log(ts);
            }
            p.x = x;
            p.y = y;
            return p;
        }
    }
    exports.forward = forward;
    /* Mercator inverse equations--mapping x,y to lat/long
      --------------------------------------------------*/
    function inverse(p) {
        var x = p.x - this.x0;
        var y = p.y - this.y0;
        var lon, lat;
        if (this.sphere) {
            lat = values_1.HALF_PI - 2 * Math.atan(Math.exp(-y / (this.a * this.k0)));
        }
        else {
            var ts = Math.exp(-y / (this.a * this.k0));
            lat = phi2z_1.default(this.e, ts);
            if (lat === -9999) {
                return null;
            }
        }
        lon = adjust_lon_1.default(this.long0 + x / (this.a * this.k0));
        p.x = lon;
        p.y = lat;
        return p;
    }
    exports.inverse = inverse;
    exports.names = ["Mercator", "Popular Visualisation Pseudo Mercator", "Mercator_1SP", "Mercator_Auxiliary_Sphere", "merc"];
    exports.default = {
        init: init,
        forward: forward,
        inverse: inverse,
        names: exports.names
    };
},
/* proj4/lib/common/msfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(eccent, sinphi, cosphi) {
        var con = eccent * sinphi;
        return cosphi / (Math.sqrt(1 - con * con));
    }
    exports.default = default_1;
},
/* proj4/lib/common/adjust_lon.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(43) /* ../constants/values */;
    const sign_1 = tslib_1.__importDefault(require(55) /* ./sign */);
    function default_1(x) {
        return (Math.abs(x) <= values_1.SPI) ? x : (x - (sign_1.default(x) * values_1.TWO_PI));
    }
    exports.default = default_1;
},
/* proj4/lib/common/sign.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(x) {
        return x < 0 ? -1 : 1;
    }
    exports.default = default_1;
},
/* proj4/lib/common/tsfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(43) /* ../constants/values */;
    function default_1(eccent, phi, sinphi) {
        var con = eccent * sinphi;
        var com = 0.5 * eccent;
        con = Math.pow(((1 - con) / (1 + con)), com);
        return (Math.tan(0.5 * (values_1.HALF_PI - phi)) / con);
    }
    exports.default = default_1;
},
/* proj4/lib/common/phi2z.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(43) /* ../constants/values */;
    function default_1(eccent, ts) {
        var eccnth = 0.5 * eccent;
        var con, dphi;
        var phi = values_1.HALF_PI - 2 * Math.atan(ts);
        for (var i = 0; i <= 15; i++) {
            con = eccent * Math.sin(phi);
            dphi = values_1.HALF_PI - 2 * Math.atan(ts * (Math.pow(((1 - con) / (1 + con)), eccnth))) - phi;
            phi += dphi;
            if (Math.abs(dphi) <= 0.0000000001) {
                return phi;
            }
        }
        //console.log("phi2z has NoConvergence");
        return -9999;
    }
    exports.default = default_1;
},
/* proj4/lib/projections/longlat.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function init() {
        //no-op for longlat
    }
    exports.init = init;
    function identity(pt) {
        return pt;
    }
    exports.forward = identity;
    exports.inverse = identity;
    exports.names = ["longlat", "identity"];
    exports.default = {
        init: init,
        forward: identity,
        inverse: identity,
        names: exports.names
    };
},
/* proj4/lib/deriveConstants.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(43) /* ./constants/values */;
    const Ellipsoid_1 = tslib_1.__importStar(require(60) /* ./constants/Ellipsoid */);
    const match_1 = tslib_1.__importDefault(require(46) /* ./match */);
    function eccentricity(a, b, rf, R_A) {
        var a2 = a * a; // used in geocentric
        var b2 = b * b; // used in geocentric
        var es = (a2 - b2) / a2; // e ^ 2
        var e = 0;
        if (R_A) {
            a *= 1 - es * (values_1.SIXTH + es * (values_1.RA4 + es * values_1.RA6));
            a2 = a * a;
            es = 0;
        }
        else {
            e = Math.sqrt(es); // eccentricity
        }
        var ep2 = (a2 - b2) / b2; // used in geocentric
        return {
            es: es,
            e: e,
            ep2: ep2
        };
    }
    exports.eccentricity = eccentricity;
    function sphere(a, b, rf, ellps, sphere) {
        if (!a) { // do we have an ellipsoid?
            var ellipse = match_1.default(Ellipsoid_1.default, ellps);
            if (!ellipse) {
                ellipse = Ellipsoid_1.WGS84;
            }
            a = ellipse.a;
            b = ellipse.b;
            rf = ellipse.rf;
        }
        if (rf && !b) {
            b = (1.0 - 1.0 / rf) * a;
        }
        if (rf === 0 || Math.abs(a - b) < values_1.EPSLN) {
            sphere = true;
            b = a;
        }
        return {
            a: a,
            b: b,
            rf: rf,
            sphere: sphere
        };
    }
    exports.sphere = sphere;
},
/* proj4/lib/constants/Ellipsoid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.MERIT = {
        a: 6378137.0,
        rf: 298.257,
        ellipseName: "MERIT 1983"
    };
    exports$1.SGS85 = {
        a: 6378136.0,
        rf: 298.257,
        ellipseName: "Soviet Geodetic System 85"
    };
    exports$1.GRS80 = {
        a: 6378137.0,
        rf: 298.257222101,
        ellipseName: "GRS 1980(IUGG, 1980)"
    };
    exports$1.IAU76 = {
        a: 6378140.0,
        rf: 298.257,
        ellipseName: "IAU 1976"
    };
    exports$1.airy = {
        a: 6377563.396,
        b: 6356256.910,
        ellipseName: "Airy 1830"
    };
    exports$1.APL4 = {
        a: 6378137,
        rf: 298.25,
        ellipseName: "Appl. Physics. 1965"
    };
    exports$1.NWL9D = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "Naval Weapons Lab., 1965"
    };
    exports$1.mod_airy = {
        a: 6377340.189,
        b: 6356034.446,
        ellipseName: "Modified Airy"
    };
    exports$1.andrae = {
        a: 6377104.43,
        rf: 300.0,
        ellipseName: "Andrae 1876 (Den., Iclnd.)"
    };
    exports$1.aust_SA = {
        a: 6378160.0,
        rf: 298.25,
        ellipseName: "Australian Natl & S. Amer. 1969"
    };
    exports$1.GRS67 = {
        a: 6378160.0,
        rf: 298.2471674270,
        ellipseName: "GRS 67(IUGG 1967)"
    };
    exports$1.bessel = {
        a: 6377397.155,
        rf: 299.1528128,
        ellipseName: "Bessel 1841"
    };
    exports$1.bess_nam = {
        a: 6377483.865,
        rf: 299.1528128,
        ellipseName: "Bessel 1841 (Namibia)"
    };
    exports$1.clrk66 = {
        a: 6378206.4,
        b: 6356583.8,
        ellipseName: "Clarke 1866"
    };
    exports$1.clrk80 = {
        a: 6378249.145,
        rf: 293.4663,
        ellipseName: "Clarke 1880 mod."
    };
    exports$1.clrk58 = {
        a: 6378293.645208759,
        rf: 294.2606763692654,
        ellipseName: "Clarke 1858"
    };
    exports$1.CPM = {
        a: 6375738.7,
        rf: 334.29,
        ellipseName: "Comm. des Poids et Mesures 1799"
    };
    exports$1.delmbr = {
        a: 6376428.0,
        rf: 311.5,
        ellipseName: "Delambre 1810 (Belgium)"
    };
    exports$1.engelis = {
        a: 6378136.05,
        rf: 298.2566,
        ellipseName: "Engelis 1985"
    };
    exports$1.evrst30 = {
        a: 6377276.345,
        rf: 300.8017,
        ellipseName: "Everest 1830"
    };
    exports$1.evrst48 = {
        a: 6377304.063,
        rf: 300.8017,
        ellipseName: "Everest 1948"
    };
    exports$1.evrst56 = {
        a: 6377301.243,
        rf: 300.8017,
        ellipseName: "Everest 1956"
    };
    exports$1.evrst69 = {
        a: 6377295.664,
        rf: 300.8017,
        ellipseName: "Everest 1969"
    };
    exports$1.evrstSS = {
        a: 6377298.556,
        rf: 300.8017,
        ellipseName: "Everest (Sabah & Sarawak)"
    };
    exports$1.fschr60 = {
        a: 6378166.0,
        rf: 298.3,
        ellipseName: "Fischer (Mercury Datum) 1960"
    };
    exports$1.fschr60m = {
        a: 6378155.0,
        rf: 298.3,
        ellipseName: "Fischer 1960"
    };
    exports$1.fschr68 = {
        a: 6378150.0,
        rf: 298.3,
        ellipseName: "Fischer 1968"
    };
    exports$1.helmert = {
        a: 6378200.0,
        rf: 298.3,
        ellipseName: "Helmert 1906"
    };
    exports$1.hough = {
        a: 6378270.0,
        rf: 297.0,
        ellipseName: "Hough"
    };
    exports$1.intl = {
        a: 6378388.0,
        rf: 297.0,
        ellipseName: "International 1909 (Hayford)"
    };
    exports$1.kaula = {
        a: 6378163.0,
        rf: 298.24,
        ellipseName: "Kaula 1961"
    };
    exports$1.lerch = {
        a: 6378139.0,
        rf: 298.257,
        ellipseName: "Lerch 1979"
    };
    exports$1.mprts = {
        a: 6397300.0,
        rf: 191.0,
        ellipseName: "Maupertius 1738"
    };
    exports$1.new_intl = {
        a: 6378157.5,
        b: 6356772.2,
        ellipseName: "New International 1967"
    };
    exports$1.plessis = {
        a: 6376523.0,
        rf: 6355863.0,
        ellipseName: "Plessis 1817 (France)"
    };
    exports$1.krass = {
        a: 6378245.0,
        rf: 298.3,
        ellipseName: "Krassovsky, 1942"
    };
    exports$1.SEasia = {
        a: 6378155.0,
        b: 6356773.3205,
        ellipseName: "Southeast Asia"
    };
    exports$1.walbeck = {
        a: 6376896.0,
        b: 6355834.8467,
        ellipseName: "Walbeck"
    };
    exports$1.WGS60 = {
        a: 6378165.0,
        rf: 298.3,
        ellipseName: "WGS 60"
    };
    exports$1.WGS66 = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "WGS 66"
    };
    exports$1.WGS7 = {
        a: 6378135.0,
        rf: 298.26,
        ellipseName: "WGS 72"
    };
    exports.WGS84 = exports$1.WGS84 = {
        a: 6378137.0,
        rf: 298.257223563,
        ellipseName: "WGS 84"
    };
    exports$1.sphere = {
        a: 6370997.0,
        b: 6370997.0,
        ellipseName: "Normal Sphere (r=6370997)"
    };
},
/* proj4/lib/constants/Datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.wgs84 = {
        towgs84: "0,0,0",
        ellipse: "WGS84",
        datumName: "WGS84"
    };
    exports$1.ch1903 = {
        towgs84: "674.374,15.056,405.346",
        ellipse: "bessel",
        datumName: "swiss"
    };
    exports$1.ggrs87 = {
        towgs84: "-199.87,74.79,246.62",
        ellipse: "GRS80",
        datumName: "Greek_Geodetic_Reference_System_1987"
    };
    exports$1.nad83 = {
        towgs84: "0,0,0",
        ellipse: "GRS80",
        datumName: "North_American_Datum_1983"
    };
    exports$1.nad27 = {
        nadgrids: "@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",
        ellipse: "clrk66",
        datumName: "North_American_Datum_1927"
    };
    exports$1.potsdam = {
        towgs84: "606.0,23.0,413.0",
        ellipse: "bessel",
        datumName: "Potsdam Rauenberg 1950 DHDN"
    };
    exports$1.carthage = {
        towgs84: "-263.0,6.0,431.0",
        ellipse: "clark80",
        datumName: "Carthage 1934 Tunisia"
    };
    exports$1.hermannskogel = {
        towgs84: "653.0,-212.0,449.0",
        ellipse: "bessel",
        datumName: "Hermannskogel"
    };
    exports$1.osni52 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "airy",
        datumName: "Irish National"
    };
    exports$1.ire65 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "mod_airy",
        datumName: "Ireland 1965"
    };
    exports$1.rassadiran = {
        towgs84: "-133.63,-157.5,-158.62",
        ellipse: "intl",
        datumName: "Rassadiran"
    };
    exports$1.nzgd49 = {
        towgs84: "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",
        ellipse: "intl",
        datumName: "New Zealand Geodetic Datum 1949"
    };
    exports$1.osgb36 = {
        towgs84: "446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",
        ellipse: "airy",
        datumName: "Airy 1830"
    };
    exports$1.s_jtsk = {
        towgs84: "589,76,480",
        ellipse: 'bessel',
        datumName: 'S-JTSK (Ferro)'
    };
    exports$1.beduaram = {
        towgs84: '-106,-87,188',
        ellipse: 'clrk80',
        datumName: 'Beduaram'
    };
    exports$1.gunung_segara = {
        towgs84: '-403,684,41',
        ellipse: 'bessel',
        datumName: 'Gunung Segara Jakarta'
    };
    exports$1.rnb72 = {
        towgs84: "106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",
        ellipse: "intl",
        datumName: "Reseau National Belge 1972"
    };
},
/* proj4/lib/datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(43) /* ./constants/values */;
    function datum(datumCode, datum_params, a, b, es, ep2) {
        var out = {};
        if (datumCode === undefined || datumCode === 'none') {
            out.datum_type = values_1.PJD_NODATUM;
        }
        else {
            out.datum_type = values_1.PJD_WGS84;
        }
        if (datum_params) {
            out.datum_params = datum_params.map(parseFloat);
            if (out.datum_params[0] !== 0 || out.datum_params[1] !== 0 || out.datum_params[2] !== 0) {
                out.datum_type = values_1.PJD_3PARAM;
            }
            if (out.datum_params.length > 3) {
                if (out.datum_params[3] !== 0 || out.datum_params[4] !== 0 || out.datum_params[5] !== 0 || out.datum_params[6] !== 0) {
                    out.datum_type = values_1.PJD_7PARAM;
                    out.datum_params[3] *= values_1.SEC_TO_RAD;
                    out.datum_params[4] *= values_1.SEC_TO_RAD;
                    out.datum_params[5] *= values_1.SEC_TO_RAD;
                    out.datum_params[6] = (out.datum_params[6] / 1000000.0) + 1.0;
                }
            }
        }
        out.a = a; //datum object also uses these values
        out.b = b;
        out.es = es;
        out.ep2 = ep2;
        return out;
    }
    exports.default = datum;
},
/* proj4/lib/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(43) /* ./constants/values */;
    const datum_transform_1 = tslib_1.__importDefault(require(64) /* ./datum_transform */);
    const adjust_axis_1 = tslib_1.__importDefault(require(66) /* ./adjust_axis */);
    const Proj_1 = tslib_1.__importDefault(require(38) /* ./Proj */);
    const toPoint_1 = tslib_1.__importDefault(require(67) /* ./common/toPoint */);
    const checkSanity_1 = tslib_1.__importDefault(require(68) /* ./checkSanity */);
    function checkNotWGS(source, dest) {
        return ((source.datum.datum_type === values_1.PJD_3PARAM || source.datum.datum_type === values_1.PJD_7PARAM) && dest.datumCode !== 'WGS84') || ((dest.datum.datum_type === values_1.PJD_3PARAM || dest.datum.datum_type === values_1.PJD_7PARAM) && source.datumCode !== 'WGS84');
    }
    function transform(source, dest, point) {
        var wgs84;
        if (Array.isArray(point)) {
            point = toPoint_1.default(point);
        }
        checkSanity_1.default(point);
        // Workaround for datum shifts towgs84, if either source or destination projection is not wgs84
        if (source.datum && dest.datum && checkNotWGS(source, dest)) {
            wgs84 = new Proj_1.default('WGS84');
            point = transform(source, wgs84, point);
            source = wgs84;
        }
        // DGR, 2010/11/12
        if (source.axis !== 'enu') {
            point = adjust_axis_1.default(source, false, point);
        }
        // Transform source points to long/lat, if they aren't already.
        if (source.projName === 'longlat') {
            point = {
                x: point.x * values_1.D2R,
                y: point.y * values_1.D2R,
                z: point.z || 0
            };
        }
        else {
            if (source.to_meter) {
                point = {
                    x: point.x * source.to_meter,
                    y: point.y * source.to_meter,
                    z: point.z || 0
                };
            }
            point = source.inverse(point); // Convert Cartesian to longlat
            if (!point) {
                return;
            }
        }
        // Adjust for the prime meridian if necessary
        if (source.from_greenwich) {
            point.x += source.from_greenwich;
        }
        // Convert datums if needed, and if possible.
        point = datum_transform_1.default(source.datum, dest.datum, point);
        // Adjust for the prime meridian if necessary
        if (dest.from_greenwich) {
            point = {
                x: point.x - dest.from_greenwich,
                y: point.y,
                z: point.z || 0
            };
        }
        if (dest.projName === 'longlat') {
            // convert radians to decimal degrees
            point = {
                x: point.x * values_1.R2D,
                y: point.y * values_1.R2D,
                z: point.z || 0
            };
        }
        else { // else project
            point = dest.forward(point);
            if (dest.to_meter) {
                point = {
                    x: point.x / dest.to_meter,
                    y: point.y / dest.to_meter,
                    z: point.z || 0
                };
            }
        }
        // DGR, 2010/11/12
        if (dest.axis !== 'enu') {
            return adjust_axis_1.default(dest, true, point);
        }
        return point;
    }
    exports.default = transform;
},
/* proj4/lib/datum_transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(43) /* ./constants/values */;
    const datumUtils_1 = require(65) /* ./datumUtils */;
    function checkParams(type) {
        return (type === values_1.PJD_3PARAM || type === values_1.PJD_7PARAM);
    }
    function default_1(source, dest, point) {
        // Short cut if the datums are identical.
        if (datumUtils_1.compareDatums(source, dest)) {
            return point; // in this case, zero is sucess,
            // whereas cs_compare_datums returns 1 to indicate TRUE
            // confusing, should fix this
        }
        // Explicitly skip datum transform by setting 'datum=none' as parameter for either source or dest
        if (source.datum_type === values_1.PJD_NODATUM || dest.datum_type === values_1.PJD_NODATUM) {
            return point;
        }
        // If this datum requires grid shifts, then apply it to geodetic coordinates.
        // Do we need to go through geocentric coordinates?
        if (source.es === dest.es && source.a === dest.a && !checkParams(source.datum_type) && !checkParams(dest.datum_type)) {
            return point;
        }
        // Convert to geocentric coordinates.
        point = datumUtils_1.geodeticToGeocentric(point, source.es, source.a);
        // Convert between datums
        if (checkParams(source.datum_type)) {
            point = datumUtils_1.geocentricToWgs84(point, source.datum_type, source.datum_params);
        }
        if (checkParams(dest.datum_type)) {
            point = datumUtils_1.geocentricFromWgs84(point, dest.datum_type, dest.datum_params);
        }
        return datumUtils_1.geocentricToGeodetic(point, dest.es, dest.a, dest.b);
    }
    exports.default = default_1;
},
/* proj4/lib/datumUtils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(43) /* ./constants/values */;
    function compareDatums(source, dest) {
        if (source.datum_type !== dest.datum_type) {
            return false; // false, datums are not equal
        }
        else if (source.a !== dest.a || Math.abs(source.es - dest.es) > 0.000000000050) {
            // the tolerance for es is to ensure that GRS80 and WGS84
            // are considered identical
            return false;
        }
        else if (source.datum_type === values_1.PJD_3PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2]);
        }
        else if (source.datum_type === values_1.PJD_7PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2] && source.datum_params[3] === dest.datum_params[3] && source.datum_params[4] === dest.datum_params[4] && source.datum_params[5] === dest.datum_params[5] && source.datum_params[6] === dest.datum_params[6]);
        }
        else {
            return true; // datums are equal
        }
    } // cs_compare_datums()
    exports.compareDatums = compareDatums;
    /*
     * The function Convert_Geodetic_To_Geocentric converts geodetic coordinates
     * (latitude, longitude, and height) to geocentric coordinates (X, Y, Z),
     * according to the current ellipsoid parameters.
     *
     *    Latitude  : Geodetic latitude in radians                     (input)
     *    Longitude : Geodetic longitude in radians                    (input)
     *    Height    : Geodetic height, in meters                       (input)
     *    X         : Calculated Geocentric X coordinate, in meters    (output)
     *    Y         : Calculated Geocentric Y coordinate, in meters    (output)
     *    Z         : Calculated Geocentric Z coordinate, in meters    (output)
     *
     */
    function geodeticToGeocentric(p, es, a) {
        var Longitude = p.x;
        var Latitude = p.y;
        var Height = p.z ? p.z : 0; //Z value not always supplied
        var Rn; /*  Earth radius at location  */
        var Sin_Lat; /*  Math.sin(Latitude)  */
        var Sin2_Lat; /*  Square of Math.sin(Latitude)  */
        var Cos_Lat; /*  Math.cos(Latitude)  */
        /*
         ** Don't blow up if Latitude is just a little out of the value
         ** range as it may just be a rounding issue.  Also removed longitude
         ** test, it should be wrapped by Math.cos() and Math.sin().  NFW for PROJ.4, Sep/2001.
         */
        if (Latitude < -values_1.HALF_PI && Latitude > -1.001 * values_1.HALF_PI) {
            Latitude = -values_1.HALF_PI;
        }
        else if (Latitude > values_1.HALF_PI && Latitude < 1.001 * values_1.HALF_PI) {
            Latitude = values_1.HALF_PI;
        }
        else if (Latitude < -values_1.HALF_PI) {
            /* Latitude out of range */
            //..reportError('geocent:lat out of range:' + Latitude);
            return { x: -Infinity, y: -Infinity, z: p.z };
        }
        else if (Latitude > values_1.HALF_PI) {
            /* Latitude out of range */
            return { x: Infinity, y: Infinity, z: p.z };
        }
        if (Longitude > Math.PI) {
            Longitude -= (2 * Math.PI);
        }
        Sin_Lat = Math.sin(Latitude);
        Cos_Lat = Math.cos(Latitude);
        Sin2_Lat = Sin_Lat * Sin_Lat;
        Rn = a / (Math.sqrt(1.0e0 - es * Sin2_Lat));
        return {
            x: (Rn + Height) * Cos_Lat * Math.cos(Longitude),
            y: (Rn + Height) * Cos_Lat * Math.sin(Longitude),
            z: ((Rn * (1 - es)) + Height) * Sin_Lat
        };
    } // cs_geodetic_to_geocentric()
    exports.geodeticToGeocentric = geodeticToGeocentric;
    function geocentricToGeodetic(p, es, a, b) {
        /* local defintions and variables */
        /* end-criterium of loop, accuracy of sin(Latitude) */
        var genau = 1e-12;
        var genau2 = (genau * genau);
        var maxiter = 30;
        var P; /* distance between semi-minor axis and location */
        var RR; /* distance between center and location */
        var CT; /* sin of geocentric latitude */
        var ST; /* cos of geocentric latitude */
        var RX;
        var RK;
        var RN; /* Earth radius at location */
        var CPHI0; /* cos of start or old geodetic latitude in iterations */
        var SPHI0; /* sin of start or old geodetic latitude in iterations */
        var CPHI; /* cos of searched geodetic latitude */
        var SPHI; /* sin of searched geodetic latitude */
        var SDPHI; /* end-criterium: addition-theorem of sin(Latitude(iter)-Latitude(iter-1)) */
        var iter; /* # of continous iteration, max. 30 is always enough (s.a.) */
        var X = p.x;
        var Y = p.y;
        var Z = p.z ? p.z : 0.0; //Z value not always supplied
        var Longitude;
        var Latitude;
        var Height;
        P = Math.sqrt(X * X + Y * Y);
        RR = Math.sqrt(X * X + Y * Y + Z * Z);
        /*      special cases for latitude and longitude */
        if (P / a < genau) {
            /*  special case, if P=0. (X=0., Y=0.) */
            Longitude = 0.0;
            /*  if (X,Y,Z)=(0.,0.,0.) then Height becomes semi-minor axis
             *  of ellipsoid (=center of mass), Latitude becomes PI/2 */
            if (RR / a < genau) {
                Latitude = values_1.HALF_PI;
                Height = -b;
                return {
                    x: p.x,
                    y: p.y,
                    z: p.z
                };
            }
        }
        else {
            /*  ellipsoidal (geodetic) longitude
             *  interval: -PI < Longitude <= +PI */
            Longitude = Math.atan2(Y, X);
        }
        /* --------------------------------------------------------------
         * Following iterative algorithm was developped by
         * "Institut for Erdmessung", University of Hannover, July 1988.
         * Internet: www.ife.uni-hannover.de
         * Iterative computation of CPHI,SPHI and Height.
         * Iteration of CPHI and SPHI to 10**-12 radian resp.
         * 2*10**-7 arcsec.
         * --------------------------------------------------------------
         */
        CT = Z / RR;
        ST = P / RR;
        RX = 1.0 / Math.sqrt(1.0 - es * (2.0 - es) * ST * ST);
        CPHI0 = ST * (1.0 - es) * RX;
        SPHI0 = CT * RX;
        iter = 0;
        /* loop to find sin(Latitude) resp. Latitude
         * until |sin(Latitude(iter)-Latitude(iter-1))| < genau */
        do {
            iter++;
            RN = a / Math.sqrt(1.0 - es * SPHI0 * SPHI0);
            /*  ellipsoidal (geodetic) height */
            Height = P * CPHI0 + Z * SPHI0 - RN * (1.0 - es * SPHI0 * SPHI0);
            RK = es * RN / (RN + Height);
            RX = 1.0 / Math.sqrt(1.0 - RK * (2.0 - RK) * ST * ST);
            CPHI = ST * (1.0 - RK) * RX;
            SPHI = CT * RX;
            SDPHI = SPHI * CPHI0 - CPHI * SPHI0;
            CPHI0 = CPHI;
            SPHI0 = SPHI;
        } while (SDPHI * SDPHI > genau2 && iter < maxiter);
        /*      ellipsoidal (geodetic) latitude */
        Latitude = Math.atan(SPHI / Math.abs(CPHI));
        return {
            x: Longitude,
            y: Latitude,
            z: Height
        };
    } // cs_geocentric_to_geodetic()
    exports.geocentricToGeodetic = geocentricToGeodetic;
    /****************************************************************/
    // pj_geocentic_to_wgs84( p )
    //  p = point to transform in geocentric coordinates (x,y,z)
    /** point object, nothing fancy, just allows values to be
        passed back and forth by reference rather than by value.
        Other point classes may be used as long as they have
        x and y properties, which will get modified in the transform method.
    */
    function geocentricToWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x + datum_params[0],
                y: p.y + datum_params[1],
                z: p.z + datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: M_BF * (p.x - Rz_BF * p.y + Ry_BF * p.z) + Dx_BF,
                y: M_BF * (Rz_BF * p.x + p.y - Rx_BF * p.z) + Dy_BF,
                z: M_BF * (-Ry_BF * p.x + Rx_BF * p.y + p.z) + Dz_BF
            };
        }
    } // cs_geocentric_to_wgs84
    exports.geocentricToWgs84 = geocentricToWgs84;
    /****************************************************************/
    // pj_geocentic_from_wgs84()
    //  coordinate system definition,
    //  point to transform in geocentric coordinates (x,y,z)
    function geocentricFromWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x - datum_params[0],
                y: p.y - datum_params[1],
                z: p.z - datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            var x_tmp = (p.x - Dx_BF) / M_BF;
            var y_tmp = (p.y - Dy_BF) / M_BF;
            var z_tmp = (p.z - Dz_BF) / M_BF;
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: x_tmp + Rz_BF * y_tmp - Ry_BF * z_tmp,
                y: -Rz_BF * x_tmp + y_tmp + Rx_BF * z_tmp,
                z: Ry_BF * x_tmp - Rx_BF * y_tmp + z_tmp
            };
        } //cs_geocentric_from_wgs84()
    }
    exports.geocentricFromWgs84 = geocentricFromWgs84;
},
/* proj4/lib/adjust_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(crs, denorm, point) {
        var xin = point.x, yin = point.y, zin = point.z || 0.0;
        var v, t, i;
        var out = {};
        for (i = 0; i < 3; i++) {
            if (denorm && i === 2 && point.z === undefined) {
                continue;
            }
            if (i === 0) {
                v = xin;
                if ("ew".indexOf(crs.axis[i]) !== -1) {
                    t = 'x';
                }
                else {
                    t = 'y';
                }
            }
            else if (i === 1) {
                v = yin;
                if ("ns".indexOf(crs.axis[i]) !== -1) {
                    t = 'y';
                }
                else {
                    t = 'x';
                }
            }
            else {
                v = zin;
                t = 'z';
            }
            switch (crs.axis[i]) {
                case 'e':
                case 'w':
                case 'n':
                case 's':
                    out[t] = v;
                    break;
                case 'u':
                    if (point[t] !== undefined) {
                        out.z = v;
                    }
                    break;
                case 'd':
                    if (point[t] !== undefined) {
                        out.z = -v;
                    }
                    break;
                default:
                    //console.log("ERROR: unknow axis ("+crs.axis[i]+") - check definition of "+crs.projName);
                    return null;
            }
        }
        return out;
    }
    exports.default = default_1;
},
/* proj4/lib/common/toPoint.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(array) {
        var out = {
            x: array[0],
            y: array[1]
        };
        if (array.length > 2) {
            out.z = array[2];
        }
        if (array.length > 3) {
            out.m = array[3];
        }
        return out;
    }
    exports.default = default_1;
},
/* proj4/lib/checkSanity.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(point) {
        checkCoord(point.x);
        checkCoord(point.y);
    }
    exports.default = default_1;
    function checkCoord(num) {
        if (typeof Number.isFinite === 'function') {
            if (Number.isFinite(num)) {
                return;
            }
            throw new TypeError('coordinates must be finite numbers');
        }
        if (typeof num !== 'number' || num !== num || !isFinite(num)) {
            throw new TypeError('coordinates must be finite numbers');
        }
    }
},
/* models/renderers/renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const view_1 = require(70) /* ../../core/view */;
    const visuals = tslib_1.__importStar(require(73) /* ../../core/visuals */);
    const enums_1 = require(20) /* ../../core/enums */;
    const model_1 = require(88) /* ../../model */;
    const coordinates_1 = require(89) /* ../canvas/coordinates */;
    class RendererView extends view_1.View {
        get coordinates() {
            return this._coordinates;
        }
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this.model);
            this.needs_webgl_blit = false;
            this._initialize_coordinates();
        }
        connect_signals() {
            super.connect_signals();
            const { x_range_name, y_range_name } = this.model.properties;
            this.on_change([x_range_name, y_range_name], () => this._initialize_coordinates());
        }
        _initialize_coordinates() {
            const { x_range_name, y_range_name } = this.model;
            const { frame } = this.plot_view;
            const x_scale = frame.x_scales.get(x_range_name);
            const y_scale = frame.y_scales.get(y_range_name);
            this._coordinates = new coordinates_1.CoordinateTransform(x_scale, y_scale);
        }
        get plot_view() {
            return this.parent;
        }
        get plot_model() {
            return this.parent.model;
        }
        get layer() {
            const { overlays, primary } = this.plot_view.canvas_view;
            return this.model.level == "overlay" ? overlays : primary;
        }
        request_render() {
            this.plot_view.request_render();
        }
        notify_finished() {
            this.plot_view.notify_finished();
        }
        get needs_clip() {
            return false;
        }
        get has_webgl() {
            return false;
        }
        render() {
            if (this.model.visible) {
                this._render();
            }
            this._has_finished = true;
        }
        renderer_view(_renderer) {
            return undefined;
        }
    }
    exports.RendererView = RendererView;
    RendererView.__name__ = "RendererView";
    class Renderer extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        static init_Renderer() {
            this.define(({ Boolean, String }) => ({
                level: [enums_1.RenderLevel, "image"],
                visible: [Boolean, true],
                x_range_name: [String, "default"],
                y_range_name: [String, "default"],
            }));
        }
    }
    exports.Renderer = Renderer;
    Renderer.__name__ = "Renderer";
    Renderer.init_Renderer();
},
/* core/view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const signaling_1 = require(15) /* ./signaling */;
    const dom_1 = require(71) /* ./dom */;
    const types_1 = require(8) /* ./util/types */;
    const root_css_1 = tslib_1.__importDefault(require(72) /* ../styles/root.css */);
    class View {
        constructor(options) {
            this.removed = new signaling_1.Signal0(this, "removed");
            this._ready = Promise.resolve(undefined);
            /** @internal */
            this._slots = new WeakMap();
            const { model, parent } = options;
            this.model = model;
            this.parent = parent;
            this.root = parent == null ? this : parent.root;
            this.removed.emit();
        }
        get ready() {
            return this._ready;
        }
        connect(signal, slot) {
            let new_slot = this._slots.get(slot);
            if (new_slot == null) {
                new_slot = (args, sender) => {
                    const promise = Promise.resolve(slot.call(this, args, sender));
                    this._ready = this._ready.then(() => promise);
                };
                this._slots.set(slot, new_slot);
            }
            return signal.connect(new_slot, this);
        }
        disconnect(signal, slot) {
            return signal.disconnect(slot, this);
        }
        initialize() {
            this._has_finished = false;
            if (this.is_root) {
                this._stylesheet = dom_1.stylesheet;
            }
            for (const style of this.styles()) {
                this.stylesheet.append(style);
            }
        }
        async lazy_initialize() { }
        remove() {
            this.disconnect_signals();
            this.removed.emit();
        }
        toString() {
            return `${this.model.type}View(${this.model.id})`;
        }
        serializable_state() {
            return { type: this.model.type };
        }
        get is_root() {
            return this.parent == null;
        }
        assert_root() {
            if (!this.is_root)
                throw new Error(`${this.toString()} is not a root layout`);
        }
        has_finished() {
            return this._has_finished;
        }
        get is_idle() {
            return this.has_finished();
        }
        connect_signals() { }
        disconnect_signals() {
            signaling_1.Signal.disconnect_receiver(this);
        }
        on_change(properties, fn) {
            for (const property of types_1.isArray(properties) ? properties : [properties]) {
                this.connect(property.change, fn);
            }
        }
        cursor(_sx, _sy) {
            return null;
        }
        get stylesheet() {
            if (this.is_root)
                return this._stylesheet;
            else
                return this.root.stylesheet;
        }
        styles() {
            return [root_css_1.default];
        }
    }
    exports.View = View;
    View.__name__ = "View";
},
/* core/dom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(13) /* ./util/object */;
    const _createElement = (tag) => {
        return (attrs = {}, ...children) => {
            const element = document.createElement(tag);
            element.classList.add("bk");
            for (let [attr, value] of object_1.entries(attrs)) {
                if (value == null || types_1.isBoolean(value) && !value)
                    continue;
                if (attr === "class") {
                    if (types_1.isString(value))
                        value = value.split(/\s+/);
                    if (types_1.isArray(value)) {
                        for (const cls of value) {
                            if (cls != null)
                                element.classList.add(cls);
                        }
                        continue;
                    }
                }
                if (attr === "style" && types_1.isPlainObject(value)) {
                    for (const [prop, data] of object_1.entries(value)) {
                        element.style[prop] = data;
                    }
                    continue;
                }
                if (attr === "data" && types_1.isPlainObject(value)) {
                    for (const [key, data] of object_1.entries(value)) {
                        element.dataset[key] = data; // XXX: attrs needs a better type
                    }
                    continue;
                }
                element.setAttribute(attr, value);
            }
            function append(child) {
                if (types_1.isString(child))
                    element.appendChild(document.createTextNode(child));
                else if (child instanceof Node)
                    element.appendChild(child);
                else if (child instanceof NodeList || child instanceof HTMLCollection) {
                    for (const el of child) {
                        element.appendChild(el);
                    }
                }
                else if (child != null && child !== false)
                    throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(child)}`);
            }
            for (const child of children) {
                if (types_1.isArray(child)) {
                    for (const _child of child)
                        append(_child);
                }
                else
                    append(child);
            }
            return element;
        };
    };
    function createElement(tag, attrs, ...children) {
        return _createElement(tag)(attrs, ...children);
    }
    exports.createElement = createElement;
    exports.div = _createElement("div"), exports.span = _createElement("span"), exports.canvas = _createElement("canvas"), exports.link = _createElement("link"), exports.style = _createElement("style"), exports.a = _createElement("a"), exports.p = _createElement("p"), exports.i = _createElement("i"), exports.pre = _createElement("pre"), exports.button = _createElement("button"), exports.label = _createElement("label"), exports.input = _createElement("input"), exports.select = _createElement("select"), exports.option = _createElement("option"), exports.optgroup = _createElement("optgroup"), exports.textarea = _createElement("textarea");
    function nbsp() {
        return document.createTextNode("\u00a0");
    }
    exports.nbsp = nbsp;
    function append(element, ...children) {
        for (const child of children)
            element.appendChild(child);
    }
    exports.append = append;
    function remove(element) {
        const parent = element.parentNode;
        if (parent != null) {
            parent.removeChild(element);
        }
    }
    exports.remove = remove;
    exports.removeElement = remove;
    function replaceWith(element, replacement) {
        const parent = element.parentNode;
        if (parent != null) {
            parent.replaceChild(replacement, element);
        }
    }
    exports.replaceWith = replaceWith;
    function prepend(element, ...nodes) {
        const first = element.firstChild;
        for (const node of nodes) {
            element.insertBefore(node, first);
        }
    }
    exports.prepend = prepend;
    function empty(node, attrs = false) {
        let child;
        while (child = node.firstChild) {
            node.removeChild(child);
        }
        if (attrs && node instanceof Element) {
            for (const attr of node.attributes) {
                node.removeAttributeNode(attr);
            }
        }
    }
    exports.empty = empty;
    function display(element) {
        element.style.display = "";
    }
    exports.display = display;
    function undisplay(element) {
        element.style.display = "none";
    }
    exports.undisplay = undisplay;
    function show(element) {
        element.style.visibility = "";
    }
    exports.show = show;
    function hide(element) {
        element.style.visibility = "hidden";
    }
    exports.hide = hide;
    function offset(element) {
        const rect = element.getBoundingClientRect();
        return {
            top: rect.top + window.pageYOffset - document.documentElement.clientTop,
            left: rect.left + window.pageXOffset - document.documentElement.clientLeft,
        };
    }
    exports.offset = offset;
    function matches(el, selector) {
        var _a, _b, _c;
        const p = Element.prototype;
        const f = (_c = (_b = (_a = p.matches) !== null && _a !== void 0 ? _a : p.webkitMatchesSelector) !== null && _b !== void 0 ? _b : p.mozMatchesSelector) !== null && _c !== void 0 ? _c : p.msMatchesSelector;
        return f.call(el, selector);
    }
    exports.matches = matches;
    function parent(el, selector) {
        let node = el;
        while (node = node.parentElement) {
            if (matches(node, selector))
                return node;
        }
        return null;
    }
    exports.parent = parent;
    function num(value) {
        return parseFloat(value) || 0;
    }
    function extents(el) {
        const style = getComputedStyle(el);
        return {
            border: {
                top: num(style.borderTopWidth),
                bottom: num(style.borderBottomWidth),
                left: num(style.borderLeftWidth),
                right: num(style.borderRightWidth),
            },
            margin: {
                top: num(style.marginTop),
                bottom: num(style.marginBottom),
                left: num(style.marginLeft),
                right: num(style.marginRight),
            },
            padding: {
                top: num(style.paddingTop),
                bottom: num(style.paddingBottom),
                left: num(style.paddingLeft),
                right: num(style.paddingRight),
            },
        };
    }
    exports.extents = extents;
    function size(el) {
        const rect = el.getBoundingClientRect();
        return {
            width: Math.ceil(rect.width),
            height: Math.ceil(rect.height),
        };
    }
    exports.size = size;
    function scroll_size(el) {
        return {
            width: Math.ceil(el.scrollWidth),
            height: Math.ceil(el.scrollHeight),
        };
    }
    exports.scroll_size = scroll_size;
    function outer_size(el) {
        const { margin: { left, right, top, bottom } } = extents(el);
        const { width, height } = size(el);
        return {
            width: Math.ceil(width + left + right),
            height: Math.ceil(height + top + bottom),
        };
    }
    exports.outer_size = outer_size;
    function content_size(el) {
        const { left, top } = el.getBoundingClientRect();
        const { padding } = extents(el);
        let width = 0;
        let height = 0;
        for (const child of el.children) {
            const rect = child.getBoundingClientRect();
            width = Math.max(width, Math.ceil(rect.left - left - padding.left + rect.width));
            height = Math.max(height, Math.ceil(rect.top - top - padding.top + rect.height));
        }
        return { width, height };
    }
    exports.content_size = content_size;
    function position(el, box, margin) {
        const { style } = el;
        style.left = `${box.x}px`;
        style.top = `${box.y}px`;
        style.width = `${box.width}px`;
        style.height = `${box.height}px`;
        if (margin == null)
            style.margin = "";
        else {
            const { top, right, bottom, left } = margin;
            style.margin = `${top}px ${right}px ${bottom}px ${left}px`;
        }
    }
    exports.position = position;
    function children(el) {
        return Array.from(el.children);
    }
    exports.children = children;
    class ClassList {
        constructor(el) {
            this.el = el;
            this.classList = el.classList;
        }
        get values() {
            const values = [];
            for (let i = 0; i < this.classList.length; i++) {
                const item = this.classList.item(i);
                if (item != null)
                    values.push(item);
            }
            return values;
        }
        has(cls) {
            return this.classList.contains(cls);
        }
        add(...classes) {
            for (const cls of classes)
                this.classList.add(cls);
            return this;
        }
        remove(...classes) {
            for (const cls of classes)
                this.classList.remove(cls);
            return this;
        }
        clear() {
            for (const cls of this.values) {
                if (cls != "bk")
                    this.classList.remove(cls);
            }
            return this;
        }
        toggle(cls, activate) {
            const add = activate != null ? activate : !this.has(cls);
            if (add)
                this.add(cls);
            else
                this.remove(cls);
            return this;
        }
    }
    exports.ClassList = ClassList;
    ClassList.__name__ = "ClassList";
    function classes(el) {
        return new ClassList(el);
    }
    exports.classes = classes;
    function toggle_attribute(el, attr, state) {
        if (state == null) {
            state = !el.hasAttribute(attr);
        }
        if (state)
            el.setAttribute(attr, "true");
        else
            el.removeAttribute(attr);
    }
    exports.toggle_attribute = toggle_attribute;
    (function (Keys) {
        Keys[Keys["Backspace"] = 8] = "Backspace";
        Keys[Keys["Tab"] = 9] = "Tab";
        Keys[Keys["Enter"] = 13] = "Enter";
        Keys[Keys["Esc"] = 27] = "Esc";
        Keys[Keys["PageUp"] = 33] = "PageUp";
        Keys[Keys["PageDown"] = 34] = "PageDown";
        Keys[Keys["Left"] = 37] = "Left";
        Keys[Keys["Up"] = 38] = "Up";
        Keys[Keys["Right"] = 39] = "Right";
        Keys[Keys["Down"] = 40] = "Down";
        Keys[Keys["Delete"] = 46] = "Delete";
    })(exports.Keys || (exports.Keys = {}));
    function undisplayed(el, fn) {
        const { display } = el.style;
        el.style.display = "none";
        try {
            return fn();
        }
        finally {
            el.style.display = display;
        }
    }
    exports.undisplayed = undisplayed;
    function unsized(el, fn) {
        return sized(el, {}, fn);
    }
    exports.unsized = unsized;
    function sized(el, size, fn) {
        const { width, height, position, display } = el.style;
        el.style.position = "absolute";
        el.style.display = "";
        el.style.width = size.width != null && size.width != Infinity ? `${size.width}px` : "auto";
        el.style.height = size.height != null && size.height != Infinity ? `${size.height}px` : "auto";
        try {
            return fn();
        }
        finally {
            el.style.position = position;
            el.style.display = display;
            el.style.width = width;
            el.style.height = height;
        }
    }
    exports.sized = sized;
    class StyleSheet {
        constructor(root) {
            this.root = root;
            this.known = new Set();
            this.style = exports.style({ type: "text/css" });
            prepend(root, this.style);
        }
        append(css) {
            if (!this.known.has(css)) {
                this.style.appendChild(document.createTextNode(css));
                this.known.add(css);
            }
        }
    }
    exports.StyleSheet = StyleSheet;
    StyleSheet.__name__ = "StyleSheet";
    exports.stylesheet = new StyleSheet(document.head);
    async function dom_ready() {
        if (document.readyState == "loading") {
            return new Promise((resolve, _reject) => {
                document.addEventListener("DOMContentLoaded", () => resolve(), { once: true });
            });
        }
    }
    exports.dom_ready = dom_ready;
},
/* styles/root.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const css = `
.bk-root {
  position: relative;
  width: auto;
  height: auto;
  z-index: 0;
  box-sizing: border-box;
  font-family: Helvetica, Arial, sans-serif;
  font-size: 13px;
}
.bk-root .bk,
.bk-root .bk:before,
.bk-root .bk:after {
  box-sizing: inherit;
  margin: 0;
  border: 0;
  padding: 0;
  background-image: none;
  font-family: inherit;
  font-size: 100%;
  line-height: 1.42857143;
}
.bk-root pre.bk {
  font-family: Courier, monospace;
}
`;
    exports.default = css;
},
/* core/visuals.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const mixins = tslib_1.__importStar(require(28) /* ./property_mixins */);
    const p = tslib_1.__importStar(require(18) /* ./properties */);
    const color_1 = require(22) /* ./util/color */;
    const types_1 = require(8) /* ./util/types */;
    const svg_1 = require(74) /* ./util/svg */;
    const canvas_1 = require(76) /* ../models/canvas/canvas */;
    function color2css(color, alpha) {
        const [r, g, b, a] = types_1.isString(color) ? color_1.color2rgba(color) : color_1.decode_rgba(color);
        return `rgba(${r * 255}, ${g * 255}, ${b * 255}, ${a == 1.0 ? alpha : a})`;
    }
    function _horz(ctx, h, h2) {
        ctx.moveTo(0, h2 + 0.5);
        ctx.lineTo(h, h2 + 0.5);
        ctx.stroke();
    }
    function _vert(ctx, h, h2) {
        ctx.moveTo(h2 + 0.5, 0);
        ctx.lineTo(h2 + 0.5, h);
        ctx.stroke();
    }
    function _x(ctx, h) {
        ctx.moveTo(0, h);
        ctx.lineTo(h, 0);
        ctx.stroke();
        ctx.moveTo(0, 0);
        ctx.lineTo(h, h);
        ctx.stroke();
    }
    exports.hatch_aliases = {
        " ": "blank",
        ".": "dot",
        o: "ring",
        "-": "horizontal_line",
        "|": "vertical_line",
        "+": "cross",
        "\"": "horizontal_dash",
        ":": "vertical_dash",
        "@": "spiral",
        "/": "right_diagonal_line",
        "\\": "left_diagonal_line",
        x: "diagonal_cross",
        ",": "right_diagonal_dash",
        "`": "left_diagonal_dash",
        v: "horizontal_wave",
        ">": "vertical_wave",
        "*": "criss_cross",
    };
    function create_hatch_canvas(ctx, hatch_pattern, hatch_color, hatch_alpha, hatch_scale, hatch_weight) {
        var _a;
        const h = hatch_scale;
        const h2 = h / 2;
        const h4 = h2 / 2;
        ctx.strokeStyle = color2css(hatch_color, hatch_alpha);
        ctx.lineCap = "square";
        ctx.fillStyle = hatch_color;
        ctx.lineWidth = hatch_weight;
        switch ((_a = exports.hatch_aliases[hatch_pattern]) !== null && _a !== void 0 ? _a : hatch_pattern) {
            // we should not need these if code conditions on hatch.doit, but
            // include them here just for completeness
            case "blank":
                break;
            case "dot":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.fill();
                break;
            case "ring":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.stroke();
                break;
            case "horizontal_line":
                _horz(ctx, h, h2);
                break;
            case "vertical_line":
                _vert(ctx, h, h2);
                break;
            case "cross":
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
            case "horizontal_dash":
                _horz(ctx, h2, h2);
                break;
            case "vertical_dash":
                _vert(ctx, h2, h2);
                break;
            case "spiral": {
                const h30 = h / 30;
                ctx.moveTo(h2, h2);
                for (let i = 0; i < 360; i++) {
                    const angle = 0.1 * i;
                    const x = h2 + (h30 * angle) * Math.cos(angle);
                    const y = h2 + (h30 * angle) * Math.sin(angle);
                    ctx.lineTo(x, y);
                }
                ctx.stroke();
                break;
            }
            case "right_diagonal_line":
                ctx.moveTo(-h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(5 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "left_diagonal_line":
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(-h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(5 * h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "diagonal_cross":
                _x(ctx, h);
                break;
            case "right_diagonal_dash":
                ctx.moveTo(h4 + 0.5, 3 * h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, h4 + 0.5);
                ctx.stroke();
                break;
            case "left_diagonal_dash":
                ctx.moveTo(h4 + 0.5, h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, 3 * h4 + 0.5);
                ctx.stroke();
                break;
            case "horizontal_wave":
                ctx.moveTo(0, h4);
                ctx.lineTo(h2, 3 * h4);
                ctx.lineTo(h, h4);
                ctx.stroke();
                break;
            case "vertical_wave":
                ctx.moveTo(h4, 0);
                ctx.lineTo(3 * h4, h2);
                ctx.lineTo(h4, h);
                ctx.stroke();
                break;
            case "criss_cross":
                _x(ctx, h);
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
        }
    }
    class ContextProperties {
        constructor(obj, prefix = "") {
            this.obj = obj;
            this.prefix = prefix;
            this.cache = {};
            for (const attr of this.attrs)
                this[attr] = obj.properties[prefix + attr];
        }
        warm_cache(source, all_indices) {
            for (const attr of this.attrs) {
                const prop = this.obj.properties[this.prefix + attr];
                if (prop.spec.value !== undefined) // TODO (bev) better test?
                    this.cache[attr] = prop.spec.value;
                else if (source != null && prop instanceof p.VectorSpec) {
                    const array = prop.array(source);
                    const subarray = all_indices != null ? all_indices.select(array) : array;
                    this.cache[attr + "_array"] = subarray;
                }
                else
                    throw new Error("source is required with a vectorized visual property");
            }
        }
        cache_select(attr, i) {
            const prop = this.obj.properties[this.prefix + attr];
            let value;
            if (prop.spec.value !== undefined) // TODO (bev) better test?
                this.cache[attr] = value = prop.spec.value;
            else
                this.cache[attr] = value = this.cache[attr + "_array"][i];
            return value;
        }
        get_array(attr) {
            return this.cache[attr + "_array"];
        }
        set_vectorize(ctx, i) {
            this._set_vectorize(ctx, i);
        }
    }
    exports.ContextProperties = ContextProperties;
    ContextProperties.__name__ = "ContextProperties";
    class Line extends ContextProperties {
        set_value(ctx) {
            const color = this.line_color.value();
            const alpha = this.line_alpha.value();
            ctx.strokeStyle = color2css(color, alpha);
            ctx.lineWidth = this.line_width.value();
            ctx.lineJoin = this.line_join.value();
            ctx.lineCap = this.line_cap.value();
            ctx.lineDash = this.line_dash.value();
            ctx.lineDashOffset = this.line_dash_offset.value();
        }
        get doit() {
            return !(this.line_color.spec.value === null ||
                this.line_alpha.spec.value == 0 ||
                this.line_width.spec.value == 0);
        }
        _set_vectorize(ctx, i) {
            const color = this.cache_select("line_color", i);
            const alpha = this.cache_select("line_alpha", i);
            const width = this.cache_select("line_width", i);
            const join = this.cache_select("line_join", i);
            const cap = this.cache_select("line_cap", i);
            const dash = this.cache_select("line_dash", i);
            const offset = this.cache_select("line_dash_offset", i);
            ctx.strokeStyle = color2css(color, alpha);
            ctx.lineWidth = width;
            ctx.lineJoin = join;
            ctx.lineCap = cap;
            ctx.lineDash = dash;
            ctx.lineDashOffset = offset;
        }
        color_value() {
            return color2css(this.line_color.value(), this.line_alpha.value());
        }
    }
    exports.Line = Line;
    Line.__name__ = "Line";
    Line.prototype.attrs = Object.keys(mixins.LineVector);
    class Fill extends ContextProperties {
        set_value(ctx) {
            const color = this.fill_color.value();
            const alpha = this.fill_alpha.value();
            ctx.fillStyle = color2css(color, alpha);
        }
        get doit() {
            return !(this.fill_color.spec.value === null ||
                this.fill_alpha.spec.value == 0);
        }
        _set_vectorize(ctx, i) {
            const color = this.cache_select("fill_color", i);
            const alpha = this.cache_select("fill_alpha", i);
            ctx.fillStyle = color2css(color, alpha);
        }
        color_value() {
            return color2css(this.fill_color.value(), this.fill_alpha.value());
        }
    }
    exports.Fill = Fill;
    Fill.__name__ = "Fill";
    Fill.prototype.attrs = Object.keys(mixins.FillVector);
    class Hatch extends ContextProperties {
        cache_select(name, i) {
            let value;
            if (name == "pattern") {
                const color = this.cache_select("hatch_color", i);
                const alpha = this.cache_select("hatch_alpha", i);
                const scale = this.cache_select("hatch_scale", i);
                const pattern = this.cache_select("hatch_pattern", i);
                const weight = this.cache_select("hatch_weight", i);
                const { hatch_extra } = this.cache;
                if (hatch_extra != null && hatch_extra.hasOwnProperty(pattern)) {
                    const custom = hatch_extra[pattern];
                    this.cache.pattern = custom.get_pattern(color, alpha, scale, weight);
                }
                else {
                    this.cache.pattern = (ctx) => {
                        // TODO: this needs a canvas provider instead of trying to guess what to use
                        const output_backend = ctx instanceof svg_1.SVGRenderingContext2D ? "svg" : "canvas";
                        const region = new canvas_1.CanvasLayer(output_backend, true);
                        region.resize(scale, scale);
                        region.prepare();
                        create_hatch_canvas(region.ctx, pattern, color, alpha, scale, weight);
                        return ctx.createPattern(region.canvas, "repeat");
                    };
                }
            }
            else
                value = super.cache_select(name, i);
            return value;
        }
        _try_defer(defer_func) {
            const { hatch_pattern, hatch_extra } = this.cache;
            if (hatch_extra != null && hatch_extra.hasOwnProperty(hatch_pattern)) {
                const custom = hatch_extra[hatch_pattern];
                custom.onload(defer_func);
            }
        }
        get doit() {
            return !(this.hatch_color.spec.value === null ||
                this.hatch_alpha.spec.value == 0 ||
                this.hatch_pattern.spec.value == " " ||
                this.hatch_pattern.spec.value == "blank" ||
                this.hatch_pattern.spec.value === null);
        }
        doit2(ctx, i, ready_func, defer_func) {
            if (!this.doit) {
                return;
            }
            this.cache_select("pattern", i);
            const pattern = this.cache.pattern(ctx);
            if (pattern == null) {
                this._try_defer(defer_func);
            }
            else {
                this.set_vectorize(ctx, i);
                ready_func();
            }
        }
        _set_vectorize(ctx, i) {
            this.cache_select("pattern", i);
            ctx.fillStyle = this.cache.pattern(ctx);
        }
        color_value() {
            return color2css(this.hatch_color.value(), this.hatch_alpha.value());
        }
    }
    exports.Hatch = Hatch;
    Hatch.__name__ = "Hatch";
    Hatch.prototype.attrs = Object.keys(mixins.HatchVector);
    class Text extends ContextProperties {
        color_value() {
            return color2css(this.text_color.value(), this.text_alpha.value());
        }
        font_value() {
            const text_font = this.text_font.value();
            const text_font_size = this.text_font_size.value();
            const text_font_style = this.text_font_style.value();
            return `${text_font_style} ${text_font_size} ${text_font}`;
        }
        v_font_value(i) {
            super.cache_select("text_font_style", i);
            super.cache_select("text_font_size", i);
            super.cache_select("text_font", i);
            const { text_font_style, text_font_size, text_font } = this.cache;
            return `${text_font_style} ${text_font_size} ${text_font}`;
        }
        cache_select(name, i) {
            let value;
            if (name == "font") {
                this.cache.font = value = this.v_font_value(i);
            }
            else
                value = super.cache_select(name, i);
            return value;
        }
        set_value(ctx) {
            const color = this.text_color.value();
            const alpha = this.text_alpha.value();
            ctx.fillStyle = color2css(color, alpha);
            ctx.font = this.font_value();
            ctx.textAlign = this.text_align.value();
            ctx.textBaseline = this.text_baseline.value();
        }
        get doit() {
            return !(this.text_color.spec.value === null ||
                this.text_alpha.spec.value == 0);
        }
        _set_vectorize(ctx, i) {
            const color = this.cache_select("text_color", i);
            const alpha = this.cache_select("text_alpha", i);
            const font = this.cache_select("font", i);
            const align = this.cache_select("text_align", i);
            const baseline = this.cache_select("text_baseline", i);
            ctx.fillStyle = color2css(color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        }
    }
    exports.Text = Text;
    Text.__name__ = "Text";
    Text.prototype.attrs = Object.keys(mixins.TextVector);
    class Visuals {
        constructor(model) {
            for (const mixin of model._mixins) {
                const [name, prefix = ""] = mixin.split(":");
                let cls;
                switch (name) {
                    case "line":
                        cls = Line;
                        break;
                    case "fill":
                        cls = Fill;
                        break;
                    case "hatch":
                        cls = Hatch;
                        break;
                    case "text":
                        cls = Text;
                        break;
                    default:
                        throw new Error(`unknown visual: ${name}`);
                }
                this[prefix + name] = new cls(model, prefix);
            }
        }
        warm_cache(source, all_indices) {
            for (const name in this) {
                if (this.hasOwnProperty(name)) {
                    const prop = this[name];
                    if (prop instanceof ContextProperties)
                        prop.warm_cache(source, all_indices);
                }
            }
        }
    }
    exports.Visuals = Visuals;
    Visuals.__name__ = "Visuals";
},
/* core/util/svg.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    /**
     * Based on https://github.com/gliffy/canvas2svg
     */
    const affine_1 = require(75) /* ./affine */;
    const types_1 = require(8) /* ./types */;
    const dom_1 = require(71) /* ../dom */;
    // helper function that generates a random string
    function randomString(holder) {
        if (!holder) {
            throw new Error("cannot create a random attribute name for an undefined object");
        }
        const chars = "ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
        let randomstring = "";
        do {
            randomstring = "";
            for (let i = 0; i < 12; i++) {
                randomstring += chars[Math.floor(Math.random() * chars.length)];
            }
        } while (holder[randomstring]);
        return randomstring;
    }
    // helper function to map named to numbered entities
    function createNamedToNumberedLookup(input, radix) {
        const lookup = new Map();
        const items = input.split(',');
        radix = radix !== null && radix !== void 0 ? radix : 10;
        // Map from named to numbered entities.
        for (let i = 0; i < items.length; i += 2) {
            const entity = '&' + items[i + 1] + ';';
            const base10 = parseInt(items[i], radix);
            lookup.set(entity, '&#' + base10 + ';');
        }
        // FF and IE need to create a regex from hex values ie &nbsp; == \xa0
        lookup.set("\\xa0", '&#160;');
        return lookup;
    }
    // helper function to map canvas-textAlign to svg-textAnchor
    function getTextAnchor(textAlign) {
        var _a;
        // TODO: support rtl languages
        const mapping = { left: "start", right: "end", center: "middle", start: "start", end: "end" };
        return (_a = mapping[textAlign]) !== null && _a !== void 0 ? _a : mapping.start;
    }
    // helper function to map canvas-textBaseline to svg-dominantBaseline
    function getDominantBaseline(textBaseline) {
        var _a;
        // INFO: not supported in all browsers
        const mapping = { alphabetic: "alphabetic", hanging: "hanging", top: "text-before-edge", bottom: "text-after-edge", middle: "central" };
        return (_a = mapping[textBaseline]) !== null && _a !== void 0 ? _a : mapping.alphabetic;
    }
    // Unpack entities lookup where the numbers are in radix 32 to reduce the size
    // entity mapping courtesy of tinymce
    const namedEntities = createNamedToNumberedLookup('50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,' +
        '5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,' +
        '5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,' +
        '5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,' +
        '68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,' +
        '6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,' +
        '6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,' +
        '75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,' +
        '7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,' +
        '7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,' +
        'sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,' +
        'st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,' +
        't9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,' +
        'tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,' +
        'u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,' +
        '81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,' +
        '8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,' +
        '8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,' +
        '8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,' +
        '8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,' +
        'nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,' +
        'rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,' +
        'Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,' +
        '80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,' +
        '811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro', 32);
    // Some basic mappings for attributes and default values.
    const STYLES = {
        strokeStyle: {
            svgAttr: "stroke",
            canvas: "#000000",
            svg: "none",
            apply: "stroke",
        },
        fillStyle: {
            svgAttr: "fill",
            canvas: "#000000",
            svg: null,
            apply: "fill",
        },
        lineCap: {
            svgAttr: "stroke-linecap",
            canvas: "butt",
            svg: "butt",
            apply: "stroke",
        },
        lineJoin: {
            svgAttr: "stroke-linejoin",
            canvas: "miter",
            svg: "miter",
            apply: "stroke",
        },
        miterLimit: {
            svgAttr: "stroke-miterlimit",
            canvas: 10,
            svg: 4,
            apply: "stroke",
        },
        lineWidth: {
            svgAttr: "stroke-width",
            canvas: 1,
            svg: 1,
            apply: "stroke",
        },
        globalAlpha: {
            svgAttr: "opacity",
            canvas: 1,
            svg: 1,
            apply: "fill stroke",
        },
        font: {
            // font converts to multiple svg attributes, there is custom logic for this
            canvas: "10px sans-serif",
        },
        shadowColor: {
            canvas: "#000000",
        },
        shadowOffsetX: {
            canvas: 0,
        },
        shadowOffsetY: {
            canvas: 0,
        },
        shadowBlur: {
            canvas: 0,
        },
        textAlign: {
            canvas: "start",
        },
        textBaseline: {
            canvas: "alphabetic",
        },
        lineDash: {
            svgAttr: "stroke-dasharray",
            canvas: [],
            svg: null,
            apply: "stroke",
        },
    };
    class CanvasGradient {
        constructor(gradientNode, ctx) {
            this.__root = gradientNode;
            this.__ctx = ctx;
        }
        /**
         * Adds a color stop to the gradient root
         */
        addColorStop(offset, color) {
            const stop = this.__ctx.__createElement("stop");
            stop.setAttribute("offset", `${offset}`);
            if (color.indexOf("rgba") !== -1) {
                // separate alpha value, since webkit can't handle it
                const regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
                const matches = regex.exec(color);
                const [, r, g, b, a] = matches;
                stop.setAttribute("stop-color", `rgb(${r},${g},${b})`);
                stop.setAttribute("stop-opacity", a);
            }
            else {
                stop.setAttribute("stop-color", color);
            }
            this.__root.appendChild(stop);
        }
    }
    CanvasGradient.__name__ = "CanvasGradient";
    class CanvasPattern {
        constructor(pattern, ctx) {
            this.__root = pattern;
            this.__ctx = ctx;
        }
    }
    CanvasPattern.__name__ = "CanvasPattern";
    /**
     * The mock canvas context
     * @param o - options include:
     * ctx - existing Context2D to wrap around
     * width - width of your canvas (defaults to 500)
     * height - height of your canvas (defaults to 500)
     * document - the document object (defaults to the current document)
     */
    class SVGRenderingContext2D /*implements CanvasRenderingContext2D*/ {
        constructor(options) {
            var _a, _b, _c;
            this.__currentPosition = null;
            this.__currentElementsToStyle = null;
            this._transform = new affine_1.AffineTransform();
            this._clip_path = null;
            this.__document = (_a = options === null || options === void 0 ? void 0 : options.document) !== null && _a !== void 0 ? _a : document;
            // allow passing in an existing context to wrap around
            // if a context is passed in, we know a canvas already exist
            if (options === null || options === void 0 ? void 0 : options.ctx) {
                this.__ctx = options.ctx;
            }
            else {
                this.__canvas = this.__document.createElement("canvas");
                this.__ctx = this.__canvas.getContext("2d");
            }
            this.__setDefaultStyles();
            this.__stack = [];
            // the root svg element
            this.__root = this.__document.createElementNS("http://www.w3.org/2000/svg", "svg");
            this.__root.setAttribute("version", "1.1");
            this.__root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
            this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
            this.width = (_b = options === null || options === void 0 ? void 0 : options.width) !== null && _b !== void 0 ? _b : 500;
            this.height = (_c = options === null || options === void 0 ? void 0 : options.height) !== null && _c !== void 0 ? _c : 500;
            // make sure we don't generate the same ids in defs
            this.__ids = {};
            // defs tag
            this.__defs = this.__document.createElementNS("http://www.w3.org/2000/svg", "defs");
            this.__root.appendChild(this.__defs);
        }
        get canvas() {
            // XXX: point back to this instance
            return this;
        }
        get width() {
            return this._width;
        }
        set width(width) {
            this._width = width;
            this.__root.setAttribute("width", `${width}`);
        }
        get height() {
            return this._height;
        }
        set height(height) {
            this._height = height;
            this.__root.setAttribute("height", `${height}`);
        }
        /**
         * Creates the specified svg element
         */
        __createElement(elementName, properties = {}, resetFill = false) {
            const element = this.__document.createElementNS("http://www.w3.org/2000/svg", elementName);
            if (resetFill) {
                // if fill or stroke is not specified, the svg element should not display. By default SVG's fill is black.
                element.setAttribute("fill", "none");
                element.setAttribute("stroke", "none");
            }
            const keys = Object.keys(properties);
            for (const key of keys) {
                element.setAttribute(key, `${properties[key]}`);
            }
            return element;
        }
        /**
         * Applies default canvas styles to the context
         */
        __setDefaultStyles() {
            // default 2d canvas context properties see:http://www.w3.org/TR/2dcontext/
            const keys = Object.keys(STYLES);
            const self = this;
            for (let i = 0; i < keys.length; i++) {
                const key = keys[i];
                self[key] = STYLES[key].canvas;
            }
        }
        /**
         * Applies styles on restore
         */
        __applyStyleState(styleState) {
            const keys = Object.keys(styleState);
            const self = this;
            for (let i = 0; i < keys.length; i++) {
                const key = keys[i];
                self[key] = styleState[key];
            }
        }
        /**
         * Gets the current style state
         */
        __getStyleState() {
            const keys = Object.keys(STYLES);
            const styleState = {};
            for (let i = 0; i < keys.length; i++) {
                const key = keys[i];
                styleState[key] = this[key];
            }
            return styleState;
        }
        /**
         * Apples the current styles to the current SVG element. On "ctx.fill" or "ctx.stroke"
         */
        __applyStyleToCurrentElement(type) {
            let currentElement = this.__currentElement;
            const currentStyleGroup = this.__currentElementsToStyle;
            if (currentStyleGroup != null) {
                currentElement.setAttribute(type, "");
                currentElement = currentStyleGroup.element;
                for (const node of currentStyleGroup.children) {
                    node.setAttribute(type, "");
                }
            }
            const keys = Object.keys(STYLES);
            for (let i = 0; i < keys.length; i++) {
                const style = STYLES[keys[i]];
                const value = this[keys[i]];
                if (style.apply) {
                    if (value instanceof CanvasPattern) {
                        for (const def of [...value.__ctx.__defs.childNodes]) {
                            if (def instanceof Element) {
                                const id = def.getAttribute("id");
                                this.__ids[id] = id;
                                this.__defs.appendChild(def);
                            }
                        }
                        const id = value.__root.getAttribute("id");
                        currentElement.setAttribute(style.apply, `url(#${id})`);
                    }
                    else if (value instanceof CanvasGradient) {
                        const id = value.__root.getAttribute("id");
                        currentElement.setAttribute(style.apply, `url(#${id})`);
                    }
                    else if (style.apply.indexOf(type) !== -1 && style.svg !== value) {
                        if ((style.svgAttr === "stroke" || style.svgAttr === "fill") && types_1.isString(value) && value.indexOf("rgba") !== -1) {
                            // separate alpha value, since illustrator can't handle it
                            const regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
                            const matches = regex.exec(value);
                            const [, r, g, b, a] = matches;
                            currentElement.setAttribute(style.svgAttr, `rgb(${r},${g},${b})`);
                            // should take globalAlpha here
                            let opacity = parseFloat(a);
                            const globalAlpha = this.globalAlpha;
                            if (globalAlpha != null) {
                                opacity *= globalAlpha;
                            }
                            currentElement.setAttribute(style.svgAttr + "-opacity", `${opacity}`);
                        }
                        else {
                            let attr = style.svgAttr;
                            if (keys[i] === 'globalAlpha') {
                                attr = type + '-' + style.svgAttr;
                                if (currentElement.getAttribute(attr)) {
                                    // fill-opacity or stroke-opacity has already been set by stroke or fill.
                                    continue;
                                }
                            }
                            // otherwise only update attribute if right type, and not svg default
                            currentElement.setAttribute(attr, `${value}`);
                        }
                    }
                }
            }
        }
        /**
          * Returns the serialized value of the svg so far
          * @param fixNamedEntities - Standalone SVG doesn't support named entities, which document.createTextNode encodes.
          *                           If true, we attempt to find all named entities and encode it as a numeric entity.
          * @return serialized svg
          */
        get_serialized_svg(fixNamedEntities = false) {
            let serialized = new XMLSerializer().serializeToString(this.__root);
            // IE search for a duplicate xmnls because they didn't implement setAttributeNS correctly
            const xmlns = /xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;
            if (xmlns.test(serialized)) {
                serialized = serialized.replace('xmlns="http://www.w3.org/2000/svg', 'xmlns:xlink="http://www.w3.org/1999/xlink');
            }
            if (fixNamedEntities) {
                // loop over each named entity and replace with the proper equivalent.
                for (const [key, value] of namedEntities) {
                    const regexp = new RegExp(key, "gi");
                    if (regexp.test(serialized)) {
                        serialized = serialized.replace(regexp, value);
                    }
                }
            }
            return serialized;
        }
        get_svg() {
            return this.__root;
        }
        /**
          * Will generate a group tag.
          */
        save() {
            this.__stack.push({
                transform: this._transform,
                clip_path: this._clip_path,
                attributes: this.__getStyleState(),
            });
            this._transform = this._transform.clone();
        }
        /**
          * Sets current element to parent, or just root if already root
          */
        restore() {
            if (this.__stack.length == 0)
                return;
            const { transform, clip_path, attributes } = this.__stack.pop();
            this._transform = transform;
            this._clip_path = clip_path;
            this.__applyStyleState(attributes);
        }
        _apply_transform(element, transform = this._transform) {
            if (!transform.is_identity) {
                element.setAttribute("transform", transform.toString());
            }
        }
        /**
          *  scales the current element
          */
        scale(x, y) {
            if (!isFinite(x) || (y != null && !isFinite(y)))
                return;
            this._transform.scale(x, y !== null && y !== void 0 ? y : x);
        }
        /**
          * rotates the current element
          */
        rotate(angle) {
            if (!isFinite(angle))
                return;
            this._transform.rotate(angle);
        }
        /**
          * translates the current element
          */
        translate(x, y) {
            if (!isFinite(x + y))
                return;
            this._transform.translate(x, y);
        }
        /**
          * applies a transform to the current element
          */
        transform(a, b, c, d, e, f) {
            if (!isFinite(a + b + c + d + e + f))
                return;
            this._transform.transform(a, b, c, d, e, f);
        }
        /**
          * Create a new Path Element
          */
        beginPath() {
            // Note that there is only one current default path, it is not part of the drawing state.
            // See also: https://html.spec.whatwg.org/multipage/scripting.html#current-default-path
            this.__currentDefaultPath = "";
            this.__currentPosition = null;
            const path = this.__createElement("path", {}, true);
            this.__root.appendChild(path);
            this.__currentElement = path;
        }
        /**
          * Helper function to apply currentDefaultPath to current path element
          */
        __applyCurrentDefaultPath() {
            const currentElement = this.__currentElement;
            if (currentElement.nodeName === "path") {
                currentElement.setAttribute("d", this.__currentDefaultPath);
            }
            else {
                console.error("Attempted to apply path command to node", currentElement.nodeName);
            }
        }
        /**
          * Helper function to add path command
          */
        __addPathCommand(x, y, path) {
            const separator = !this.__currentDefaultPath ? "" : " ";
            this.__currentDefaultPath += separator + path;
            this.__currentPosition = { x, y };
        }
        get _hasCurrentDefaultPath() {
            return !!this.__currentDefaultPath;
        }
        /**
          * Adds the move command to the current path element,
          * if the currentPathElement is not empty create a new path element
          */
        moveTo(x, y) {
            if (!isFinite(x + y))
                return;
            if (this.__currentElement.nodeName !== "path") {
                this.beginPath();
            }
            // creates a new subpath with the given point
            const [tx, ty] = this._transform.apply(x, y);
            this.__addPathCommand(tx, ty, `M ${tx} ${ty}`);
        }
        /**
          * Closes the current path
          */
        closePath() {
            if (this._hasCurrentDefaultPath) {
                this.__addPathCommand(NaN, NaN, "Z");
            }
        }
        /**
          * Adds a line to command
          */
        lineTo(x, y) {
            if (!isFinite(x + y))
                return;
            if (!this._hasCurrentDefaultPath)
                this.moveTo(x, y);
            else {
                const [tx, ty] = this._transform.apply(x, y);
                this.__addPathCommand(tx, ty, `L ${tx} ${ty}`);
            }
        }
        /**
          * Add a bezier command
          */
        bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y) {
            if (!isFinite(cp1x + cp1y + cp2x + cp2y + x + y))
                return;
            const [tx, ty] = this._transform.apply(x, y);
            const [tcp1x, tcp1y] = this._transform.apply(cp1x, cp1y);
            const [tcp2x, tcp2y] = this._transform.apply(cp2x, cp2y);
            this.__addPathCommand(tx, ty, `C ${tcp1x} ${tcp1y} ${tcp2x} ${tcp2y} ${tx} ${ty}`);
        }
        /**
          * Adds a quadratic curve to command
          */
        quadraticCurveTo(cpx, cpy, x, y) {
            if (!isFinite(cpx + cpy + x + y))
                return;
            const [tx, ty] = this._transform.apply(x, y);
            const [tcpx, tcpy] = this._transform.apply(cpx, cpy);
            this.__addPathCommand(tx, ty, `Q ${tcpx} ${tcpy} ${tx} ${ty}`);
        }
        /**
          * Adds the arcTo to the current path
          *
          * @see http://www.w3.org/TR/2015/WD-2dcontext-20150514/#dom-context-2d-arcto
          */
        arcTo(x1, y1, x2, y2, radius) {
            if (!isFinite(x1 + y1 + x2 + y2 + radius))
                return;
            // Let the point (x0, y0) be the last point in the subpath.
            if (this.__currentPosition == null)
                return;
            const x0 = this.__currentPosition.x;
            const y0 = this.__currentPosition.y;
            // Negative values for radius must cause the implementation to throw an IndexSizeError exception.
            if (radius < 0) {
                throw new Error("IndexSizeError: The radius provided (" + radius + ") is negative.");
            }
            // If the point (x0, y0) is equal to the point (x1, y1),
            // or if the point (x1, y1) is equal to the point (x2, y2),
            // or if the radius radius is zero,
            // then the method must add the point (x1, y1) to the subpath,
            // and connect that point to the previous point (x0, y0) by a straight line.
            if (((x0 === x1) && (y0 === y1)) || ((x1 === x2) && (y1 === y2)) || (radius === 0)) {
                this.lineTo(x1, y1);
                return;
            }
            function normalize([x, y]) {
                const len = Math.sqrt(x ** 2 + y ** 2);
                return [x / len, y / len];
            }
            // Otherwise, if the points (x0, y0), (x1, y1), and (x2, y2) all lie on a single straight line,
            // then the method must add the point (x1, y1) to the subpath,
            // and connect that point to the previous point (x0, y0) by a straight line.
            const unit_vec_p1_p0 = normalize([x0 - x1, y0 - y1]);
            const unit_vec_p1_p2 = normalize([x2 - x1, y2 - y1]);
            if (unit_vec_p1_p0[0] * unit_vec_p1_p2[1] === unit_vec_p1_p0[1] * unit_vec_p1_p2[0]) {
                this.lineTo(x1, y1);
                return;
            }
            // Otherwise, let The Arc be the shortest arc given by circumference of the circle that has radius radius,
            // and that has one point tangent to the half-infinite line that crosses the point (x0, y0) and ends at the point (x1, y1),
            // and that has a different point tangent to the half-infinite line that ends at the point (x1, y1), and crosses the point (x2, y2).
            // The points at which this circle touches these two lines are called the start and end tangent points respectively.
            // note that both vectors are unit vectors, so the length is 1
            const cos = (unit_vec_p1_p0[0] * unit_vec_p1_p2[0] + unit_vec_p1_p0[1] * unit_vec_p1_p2[1]);
            const theta = Math.acos(Math.abs(cos));
            // Calculate origin
            const unit_vec_p1_origin = normalize([
                unit_vec_p1_p0[0] + unit_vec_p1_p2[0],
                unit_vec_p1_p0[1] + unit_vec_p1_p2[1],
            ]);
            const len_p1_origin = radius / Math.sin(theta / 2);
            const x = x1 + len_p1_origin * unit_vec_p1_origin[0];
            const y = y1 + len_p1_origin * unit_vec_p1_origin[1];
            // Calculate start angle and end angle
            // rotate 90deg clockwise (note that y axis points to its down)
            const unit_vec_origin_start_tangent = [
                -unit_vec_p1_p0[1],
                unit_vec_p1_p0[0],
            ];
            // rotate 90deg counter clockwise (note that y axis points to its down)
            const unit_vec_origin_end_tangent = [
                unit_vec_p1_p2[1],
                -unit_vec_p1_p2[0],
            ];
            function getAngle(vector) {
                // get angle (clockwise) between vector and (1, 0)
                const x = vector[0];
                const y = vector[1];
                if (y >= 0) { // note that y axis points to its down
                    return Math.acos(x);
                }
                else {
                    return -Math.acos(x);
                }
            }
            const startAngle = getAngle(unit_vec_origin_start_tangent);
            const endAngle = getAngle(unit_vec_origin_end_tangent);
            // Connect the point (x0, y0) to the start tangent point by a straight line
            this.lineTo(x + unit_vec_origin_start_tangent[0] * radius, y + unit_vec_origin_start_tangent[1] * radius);
            // Connect the start tangent point to the end tangent point by arc
            // and adding the end tangent point to the subpath.
            this.arc(x, y, radius, startAngle, endAngle);
        }
        /**
          * Sets the stroke property on the current element
          */
        stroke() {
            if (this.__currentElement.nodeName === "path") {
                this.__currentElement.setAttribute("paint-order", "fill");
            }
            this.__applyCurrentDefaultPath();
            this.__applyStyleToCurrentElement("stroke");
            if (this._clip_path != null) {
                this.__currentElement.setAttribute("clip-path", this._clip_path);
            }
        }
        /**
          * Sets fill properties on the current element
          */
        fill() {
            if (this.__currentElement.nodeName === "path") {
                this.__currentElement.setAttribute("paint-order", "stroke");
            }
            this.__applyCurrentDefaultPath();
            this.__applyStyleToCurrentElement("fill");
            if (this._clip_path != null) {
                this.__currentElement.setAttribute("clip-path", this._clip_path);
            }
        }
        /**
          *  Adds a rectangle to the path.
          */
        rect(x, y, width, height) {
            if (!isFinite(x + y + width + height))
                return;
            if (this.__currentElement.nodeName !== "path") {
                this.beginPath();
            }
            this.moveTo(x, y);
            this.lineTo(x + width, y);
            this.lineTo(x + width, y + height);
            this.lineTo(x, y + height);
            this.lineTo(x, y);
        }
        /**
          * adds a rectangle element
          */
        fillRect(x, y, width, height) {
            if (!isFinite(x + y + width + height))
                return;
            this.beginPath();
            this.rect(x, y, width, height);
            this.fill();
        }
        /**
          * Draws a rectangle with no fill
          * @param x
          * @param y
          * @param width
          * @param height
          */
        strokeRect(x, y, width, height) {
            if (!isFinite(x + y + width + height))
                return;
            this.beginPath();
            this.rect(x, y, width, height);
            this.stroke();
        }
        /**
          * Clear entire canvas:
          * 1. save current transforms
          * 2. remove all the childNodes of the root g element
          */
        __clearCanvas() {
            dom_1.empty(this.__defs);
            dom_1.empty(this.__root);
            this.__root.appendChild(this.__defs);
            this.__currentElement = this.__root;
        }
        /**
          * "Clears" a canvas by just drawing a white rectangle in the current group.
          */
        clearRect(x, y, width, height) {
            if (!isFinite(x + y + width + height))
                return;
            if (x === 0 && y === 0 && width === this.width && height === this.height) {
                this.__clearCanvas();
                return;
            }
            const rect = this.__createElement("rect", { x, y, width, height, fill: "#FFFFFF" }, true);
            this._apply_transform(rect);
            this.__root.appendChild(rect);
        }
        /**
          * Adds a linear gradient to a defs tag.
          * Returns a canvas gradient object that has a reference to it's parent def
          */
        createLinearGradient(x1, y1, x2, y2) {
            if (!isFinite(x1 + y1 + x2 + y2))
                throw new Error("The provided double value is non-finite");
            const [tx1, ty1] = this._transform.apply(x1, y1);
            const [tx2, ty2] = this._transform.apply(x2, y2);
            const grad = this.__createElement("linearGradient", {
                id: randomString(this.__ids),
                x1: `${tx1}px`,
                x2: `${tx2}px`,
                y1: `${ty1}px`,
                y2: `${ty2}px`,
                gradientUnits: "userSpaceOnUse",
            }, false);
            this.__defs.appendChild(grad);
            return new CanvasGradient(grad, this);
        }
        /**
          * Adds a radial gradient to a defs tag.
          * Returns a canvas gradient object that has a reference to it's parent def
          */
        createRadialGradient(x0, y0, _r0, x1, y1, r1) {
            if (!isFinite(x0 + y0 + _r0 + x1 + y1 + r1))
                throw new Error("The provided double value is non-finite");
            const [tx0, ty0] = this._transform.apply(x0, y0);
            const [tx1, ty1] = this._transform.apply(x1, y1);
            const grad = this.__createElement("radialGradient", {
                id: randomString(this.__ids),
                cx: `${tx1}px`,
                cy: `${ty1}px`,
                r: `${r1}px`,
                fx: `${tx0}px`,
                fy: `${ty0}px`,
                gradientUnits: "userSpaceOnUse",
            }, false);
            this.__defs.appendChild(grad);
            return new CanvasGradient(grad, this);
        }
        /**
          * Parses the font string and returns svg mapping
          */
        __parseFont() {
            var _a, _b, _c, _d, _e;
            const regex = /^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;
            const fontPart = regex.exec(this.font);
            const data = {
                style: (_a = fontPart[1]) !== null && _a !== void 0 ? _a : 'normal',
                size: (_b = fontPart[4]) !== null && _b !== void 0 ? _b : '10px',
                family: (_c = fontPart[6]) !== null && _c !== void 0 ? _c : 'sans-serif',
                weight: (_d = fontPart[3]) !== null && _d !== void 0 ? _d : 'normal',
                decoration: (_e = fontPart[2]) !== null && _e !== void 0 ? _e : 'normal',
            };
            // canvas doesn't support underline natively, but we can pass this attribute
            if (this.__fontUnderline === "underline") {
                data.decoration = "underline";
            }
            // canvas also doesn't support linking, but we can pass this as well
            if (this.__fontHref != null) {
                data.href = this.__fontHref;
            }
            return data;
        }
        /**
          * Helper to link text fragments
          */
        __wrapTextLink(font, element) {
            if (font.href) {
                const a = this.__createElement("a");
                a.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", font.href);
                a.appendChild(element);
                return a;
            }
            return element;
        }
        /**
          * Fills or strokes text
          */
        __applyText(text, x, y, action) {
            const font = this.__parseFont();
            const textElement = this.__createElement("text", {
                "font-family": font.family,
                "font-size": font.size,
                "font-style": font.style,
                "font-weight": font.weight,
                "text-decoration": font.decoration,
                x,
                y,
                "text-anchor": getTextAnchor(this.textAlign),
                "dominant-baseline": getDominantBaseline(this.textBaseline),
            }, true);
            textElement.appendChild(this.__document.createTextNode(text));
            this._apply_transform(textElement);
            this.__currentElement = textElement;
            this.__applyStyleToCurrentElement(action);
            this.__root.appendChild(this.__wrapTextLink(font, textElement));
        }
        /**
          * Creates a text element
          */
        fillText(text, x, y) {
            if (text == null || !isFinite(x + y))
                return;
            this.__applyText(text, x, y, "fill");
        }
        /**
          * Strokes text
          */
        strokeText(text, x, y) {
            if (text == null || !isFinite(x + y))
                return;
            this.__applyText(text, x, y, "stroke");
        }
        /**
          * No need to implement this for svg.
          */
        measureText(text) {
            this.__ctx.font = this.font;
            return this.__ctx.measureText(text);
        }
        arc(x, y, radius, startAngle, endAngle, counterClockwise = false) {
            if (!isFinite(x + y + radius + startAngle + endAngle))
                return;
            // in canvas no circle is drawn if no angle is provided.
            if (startAngle === endAngle) {
                return;
            }
            startAngle = startAngle % (2 * Math.PI);
            endAngle = endAngle % (2 * Math.PI);
            if (startAngle === endAngle) {
                // circle time! subtract some of the angle so svg is happy (svg elliptical arc can't draw a full circle)
                endAngle = ((endAngle + (2 * Math.PI)) - 0.001 * (counterClockwise ? -1 : 1)) % (2 * Math.PI);
            }
            const endX = x + radius * Math.cos(endAngle);
            const endY = y + radius * Math.sin(endAngle);
            const startX = x + radius * Math.cos(startAngle);
            const startY = y + radius * Math.sin(startAngle);
            const sweepFlag = counterClockwise ? 0 : 1;
            let largeArcFlag = 0;
            let diff = endAngle - startAngle;
            // https://github.com/gliffy/canvas2svg/issues/4
            if (diff < 0) {
                diff += 2 * Math.PI;
            }
            if (counterClockwise) {
                largeArcFlag = diff > Math.PI ? 0 : 1;
            }
            else {
                largeArcFlag = diff > Math.PI ? 1 : 0;
            }
            this.lineTo(startX, startY);
            const rx = radius;
            const ry = radius;
            const xAxisRotation = 0;
            const [tendX, tendY] = this._transform.apply(endX, endY);
            this.__addPathCommand(tendX, tendY, `A ${rx} ${ry} ${xAxisRotation} ${largeArcFlag} ${sweepFlag} ${tendX} ${tendY}`);
        }
        /**
          * Generates a ClipPath from the clip command.
          */
        clip() {
            const clip_path = this.__createElement("clipPath");
            const id = randomString(this.__ids);
            this.__applyCurrentDefaultPath();
            clip_path.setAttribute("id", id);
            clip_path.appendChild(this.__currentElement);
            this.__defs.appendChild(clip_path);
            this._clip_path = `url(#${id})`;
        }
        /**
          * Draws a canvas, image or mock context to this canvas.
          * Note that all svg dom manipulation uses node.childNodes rather than node.children for IE support.
          * http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#dom-context-2d-drawimage
          */
        drawImage(image, ...args) {
            let dx, dy;
            let dw, dh;
            let sx, sy;
            let sw, sh;
            if (args.length == 2) {
                [dx, dy] = args;
                if (!isFinite(dx + dy))
                    return;
                sx = 0;
                sy = 0;
                sw = image.width;
                sh = image.height;
                dw = sw;
                dh = sh;
            }
            else if (args.length == 4) {
                [dx, dy, dw, dh] = args;
                if (!isFinite(dx + dy + dw + dh))
                    return;
                sx = 0;
                sy = 0;
                sw = image.width;
                sh = image.height;
            }
            else if (args.length === 8) {
                [sx, sy, sw, sh, dx, dy, dw, dh] = args;
                if (!isFinite(sx + sy + sw + sh + dx + dy + dw + dh))
                    return;
            }
            else {
                throw new Error(`Inavlid number of arguments passed to drawImage: ${arguments.length}`);
            }
            // parent, svg, defs, group, currentElement, svgImage, canvas, context, id
            const parent = this.__root;
            const translateDirective = "translate(" + dx + ", " + dy + ")";
            const transform = this._transform.clone().translate(dx, dy);
            if (image instanceof SVGRenderingContext2D || image instanceof SVGSVGElement) {
                // In the future we may want to clone nodes instead.
                // also I'm currently ignoring dw, dh, sw, sh, sx, sy for a mock context.
                const svg_node = image instanceof SVGSVGElement ? image : image.get_svg();
                const svg = svg_node.cloneNode(true);
                let scope;
                if (transform.is_identity)
                    scope = parent;
                else {
                    scope = this.__createElement("g");
                    this._apply_transform(scope, transform);
                    parent.appendChild(scope);
                }
                for (const child of [...svg.childNodes]) {
                    if (child instanceof SVGDefsElement) {
                        for (const def of [...child.childNodes]) {
                            if (def instanceof Element) {
                                const id = def.getAttribute("id");
                                this.__ids[id] = id;
                                this.__defs.appendChild(def);
                            }
                        }
                    }
                    else {
                        scope.appendChild(child);
                    }
                }
            }
            else if (image instanceof HTMLImageElement || image instanceof SVGImageElement) {
                const svgImage = this.__createElement("image");
                svgImage.setAttribute("width", `${dw}`);
                svgImage.setAttribute("height", `${dh}`);
                svgImage.setAttribute("preserveAspectRatio", "none");
                if (sx || sy || sw !== image.width || sh !== image.height) {
                    // crop the image using a temporary canvas
                    const canvas = this.__document.createElement("canvas");
                    canvas.width = dw;
                    canvas.height = dh;
                    const context = canvas.getContext("2d");
                    context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
                    image = canvas;
                }
                svgImage.setAttribute("transform", translateDirective);
                const url = image instanceof HTMLCanvasElement ? image.toDataURL() : image.getAttribute("src");
                svgImage.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", url);
                parent.appendChild(svgImage);
            }
            else if (image instanceof HTMLCanvasElement) {
                const svgImage = this.__createElement("image");
                svgImage.setAttribute("width", `${dw}`);
                svgImage.setAttribute("height", `${dh}`);
                svgImage.setAttribute("preserveAspectRatio", "none");
                // draw canvas onto temporary canvas so that smoothing can be handled
                const canvas = this.__document.createElement("canvas");
                canvas.width = dw;
                canvas.height = dh;
                const context = canvas.getContext("2d");
                context.imageSmoothingEnabled = false;
                context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
                image = canvas;
                svgImage.setAttribute("transform", translateDirective);
                svgImage.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", image.toDataURL());
                parent.appendChild(svgImage);
            }
        }
        /**
          * Generates a pattern tag
          */
        createPattern(image, _repetition) {
            const pattern = this.__document.createElementNS("http://www.w3.org/2000/svg", "pattern");
            const id = randomString(this.__ids);
            pattern.setAttribute("id", id);
            pattern.setAttribute("width", `${this._to_number(image.width)}`);
            pattern.setAttribute("height", `${this._to_number(image.height)}`);
            pattern.setAttribute("patternUnits", "userSpaceOnUse");
            if (image instanceof HTMLCanvasElement || image instanceof HTMLImageElement || image instanceof SVGImageElement) {
                const img = this.__document.createElementNS("http://www.w3.org/2000/svg", "image");
                const url = image instanceof HTMLCanvasElement ? image.toDataURL() : image.getAttribute("src");
                img.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", url);
                pattern.appendChild(img);
                this.__defs.appendChild(pattern);
            }
            else if (image instanceof SVGRenderingContext2D) {
                for (const child of [...image.__root.childNodes]) {
                    if (!(child instanceof SVGDefsElement)) {
                        pattern.appendChild(child);
                    }
                }
                //pattern.appendChild(image.__root.childNodes[1])
                this.__defs.appendChild(pattern);
            }
            else if (image instanceof SVGSVGElement) {
                for (const child of [...image.childNodes]) {
                    if (!(child instanceof SVGDefsElement)) {
                        pattern.appendChild(child);
                    }
                }
                //pattern.appendChild(image.__root.childNodes[1])
                this.__defs.appendChild(pattern);
            }
            else {
                throw new Error("unsupported");
            }
            return new CanvasPattern(pattern, this);
        }
        setLineDash(dashArray) {
            if (dashArray && dashArray.length > 0) {
                this.lineDash = dashArray.join(",");
            }
            else {
                this.lineDash = null;
            }
        }
        _to_number(val) {
            return types_1.isNumber(val) ? val : val.baseVal.value;
        }
    }
    exports.SVGRenderingContext2D = SVGRenderingContext2D;
    SVGRenderingContext2D.__name__ = "SVGRenderingContext2D";
},
/* core/util/affine.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const { sin, cos } = Math;
    class AffineTransform {
        constructor(a = 1, b = 0, c = 0, d = 1, e = 0, f = 0) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }
        toString() {
            const { a, b, c, d, e, f } = this;
            return `matrix(${a}, ${b}, ${c}, ${d}, ${e}, ${f})`;
        }
        clone() {
            const { a, b, c, d, e, f } = this;
            return new AffineTransform(a, b, c, d, e, f);
        }
        get is_identity() {
            const { a, b, c, d, e, f } = this;
            return a == 1 && b == 0 && c == 0 && d == 1 && e == 0 && f == 0;
        }
        apply(x, y) {
            const { a, b, c, d, e, f } = this;
            return [
                a * x + c * y + e,
                b * x + d * y + f,
            ];
        }
        iv_apply(xs, ys) {
            const { a, b, c, d, e, f } = this;
            const n = xs.length;
            for (let i = 0; i < n; i++) {
                const x = xs[i];
                const y = ys[i];
                xs[i] = a * x + c * y + e;
                ys[i] = b * x + d * y + f;
            }
        }
        transform(A, B, C, D, E, F) {
            const { a, b, c, d, e, f } = this;
            this.a = a * A + c * B;
            this.c = a * C + c * D;
            this.e = a * E + c * F + e;
            this.b = b * A + d * B;
            this.d = b * C + d * D;
            this.f = b * E + d * F + f;
            return this;
        }
        translate(tx, ty) {
            return this.transform(1, 0, 0, 1, tx, ty);
        }
        scale(cx, cy) {
            return this.transform(cx, 0, 0, cy, 0, 0);
        }
        skew(sx, sy) {
            return this.transform(1, sy, sx, 1, 0, 0);
        }
        rotate(angle) {
            const s = sin(angle);
            const c = cos(angle);
            return this.transform(c, s, -s, c, 0, 0);
        }
        rotate_ccw(angle) {
            return this.rotate(-angle);
        }
        translate_x(tx) {
            return this.translate(tx, 0);
        }
        translate_y(ty) {
            return this.translate(0, ty);
        }
        flip() {
            return this.scale(-1, -1);
        }
        flip_x() {
            return this.scale(1, -1);
        }
        flip_y() {
            return this.scale(-1, 1);
        }
    }
    exports.AffineTransform = AffineTransform;
    AffineTransform.__name__ = "AffineTransform";
},
/* models/canvas/canvas.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const has_props_1 = require(14) /* ../../core/has_props */;
    const dom_view_1 = require(77) /* ../../core/dom_view */;
    const logging_1 = require(19) /* ../../core/logging */;
    const dom_1 = require(71) /* ../../core/dom */;
    const enums_1 = require(20) /* ../../core/enums */;
    const object_1 = require(13) /* ../../core/util/object */;
    const ui_events_1 = require(78) /* ../../core/ui_events */;
    const bbox_1 = require(86) /* ../../core/util/bbox */;
    const canvas_1 = require(87) /* ../../core/util/canvas */;
    const svg_1 = require(74) /* ../../core/util/svg */;
    const global_webgl = (() => {
        // We use a global invisible canvas and gl context. By having a global context,
        // we avoid the limitation of max 16 contexts that most browsers have.
        const canvas = document.createElement("canvas");
        const gl = canvas.getContext("webgl", { premultipliedAlpha: true });
        // If WebGL is available, we store a reference to the gl canvas on
        // the ctx object, because that's what gets passed everywhere.
        if (gl != null)
            return { canvas, gl };
        else {
            logging_1.logger.trace("WebGL is not supported");
            return undefined;
        }
    })();
    const style = {
        position: "absolute",
        top: "0",
        left: "0",
        width: "100%",
        height: "100%",
    };
    class CanvasLayer {
        constructor(backend, hidpi) {
            this.backend = backend;
            this.hidpi = hidpi;
            this.pixel_ratio = 1;
            this.bbox = new bbox_1.BBox();
            switch (backend) {
                case "webgl":
                case "canvas": {
                    this._el = this._canvas = dom_1.canvas({ style });
                    const ctx = this.canvas.getContext('2d');
                    if (ctx == null)
                        throw new Error("unable to obtain 2D rendering context");
                    this._ctx = ctx;
                    if (hidpi) {
                        this.pixel_ratio = devicePixelRatio;
                    }
                    break;
                }
                case "svg": {
                    const ctx = new svg_1.SVGRenderingContext2D();
                    this._ctx = ctx;
                    this._canvas = ctx.get_svg();
                    this._el = dom_1.div({ style }, this._canvas);
                    break;
                }
            }
            canvas_1.fixup_ctx(this._ctx);
        }
        get canvas() {
            return this._canvas;
        }
        get ctx() {
            return this._ctx;
        }
        get el() {
            return this._el;
        }
        resize(width, height) {
            this.bbox = new bbox_1.BBox({ left: 0, top: 0, width, height });
            const target = this._ctx instanceof svg_1.SVGRenderingContext2D ? this._ctx : this.canvas;
            target.width = width * this.pixel_ratio;
            target.height = height * this.pixel_ratio;
        }
        prepare() {
            const { ctx, hidpi, pixel_ratio } = this;
            ctx.save();
            if (hidpi) {
                ctx.scale(pixel_ratio, pixel_ratio);
                ctx.translate(0.5, 0.5);
            }
            this.clear();
        }
        clear() {
            const { x, y, width, height } = this.bbox;
            this.ctx.clearRect(x, y, width, height);
        }
        finish() {
            this.ctx.restore();
        }
        to_blob() {
            const { _canvas } = this;
            if (_canvas instanceof HTMLCanvasElement) {
                if (_canvas.msToBlob != null) {
                    return Promise.resolve(_canvas.msToBlob());
                }
                else {
                    return new Promise((resolve, reject) => {
                        _canvas.toBlob((blob) => blob != null ? resolve(blob) : reject(), "image/png");
                    });
                }
            }
            else {
                const ctx = this._ctx;
                const svg = ctx.get_serialized_svg(true);
                const blob = new Blob([svg], { type: "image/svg+xml" });
                return Promise.resolve(blob);
            }
        }
    }
    exports.CanvasLayer = CanvasLayer;
    CanvasLayer.__name__ = "CanvasLayer";
    class CanvasView extends dom_view_1.DOMView {
        constructor() {
            super(...arguments);
            this.bbox = new bbox_1.BBox();
        }
        initialize() {
            super.initialize();
            const { output_backend, hidpi } = this.model;
            if (output_backend == "webgl") {
                this.webgl = global_webgl;
            }
            this.underlays_el = dom_1.div({ style });
            this.primary = new CanvasLayer(output_backend, hidpi);
            this.overlays = new CanvasLayer(output_backend, hidpi);
            this.overlays_el = dom_1.div({ style });
            this.events_el = dom_1.div({ class: "bk-canvas-events", style });
            const elements = [
                this.underlays_el,
                this.primary.el,
                this.overlays.el,
                this.overlays_el,
                this.events_el,
            ];
            object_1.extend(this.el.style, style);
            dom_1.append(this.el, ...elements);
            this.ui_event_bus = new ui_events_1.UIEventBus(this);
        }
        remove() {
            this.ui_event_bus.destroy();
            super.remove();
        }
        add_underlay(el) {
            this.underlays_el.appendChild(el);
        }
        add_overlay(el) {
            this.overlays_el.appendChild(el);
        }
        add_event(el) {
            this.events_el.appendChild(el);
        }
        get pixel_ratio() {
            return this.primary.pixel_ratio; // XXX: primary
        }
        resize(width, height) {
            this.bbox = new bbox_1.BBox({ left: 0, top: 0, width, height });
            this.primary.resize(width, height);
            this.overlays.resize(width, height);
        }
        prepare_webgl(frame_box) {
            // Prepare WebGL for a drawing pass
            const { webgl } = this;
            if (webgl != null) {
                // Sync canvas size
                const { width, height } = this.bbox;
                webgl.canvas.width = this.pixel_ratio * width;
                webgl.canvas.height = this.pixel_ratio * height;
                const { gl } = webgl;
                // Clipping
                gl.enable(gl.SCISSOR_TEST);
                const [sx, sy, w, h] = frame_box;
                const { xview, yview } = this.bbox;
                const vx = xview.compute(sx);
                const vy = yview.compute(sy + h);
                const ratio = this.pixel_ratio;
                gl.scissor(ratio * vx, ratio * vy, ratio * w, ratio * h); // lower left corner, width, height
                // Setup blending
                gl.enable(gl.BLEND);
                gl.blendFuncSeparate(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA, gl.ONE_MINUS_DST_ALPHA, gl.ONE); // premultipliedAlpha == true
                this._clear_webgl();
            }
        }
        blit_webgl(ctx) {
            // This should be called when the ctx has no state except the HIDPI transform
            const { webgl } = this;
            if (webgl != null) {
                // Blit gl canvas into the 2D canvas. To do 1-on-1 blitting, we need
                // to remove the hidpi transform, then blit, then restore.
                // ctx.globalCompositeOperation = "source-over"  -> OK; is the default
                logging_1.logger.debug('Blitting WebGL canvas');
                ctx.restore();
                ctx.drawImage(webgl.canvas, 0, 0);
                // Set back hidpi transform
                ctx.save();
                if (this.model.hidpi) {
                    const ratio = this.pixel_ratio;
                    ctx.scale(ratio, ratio);
                    ctx.translate(0.5, 0.5);
                }
                this._clear_webgl();
            }
        }
        _clear_webgl() {
            const { webgl } = this;
            if (webgl != null) {
                // Prepare GL for drawing
                const { gl, canvas } = webgl;
                gl.viewport(0, 0, canvas.width, canvas.height);
                gl.clearColor(0, 0, 0, 0);
                gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
            }
        }
        compose() {
            const { output_backend, hidpi } = this.model;
            const { width, height } = this.bbox;
            const composite = new CanvasLayer(output_backend, hidpi);
            composite.resize(width, height);
            composite.ctx.drawImage(this.primary.canvas, 0, 0);
            composite.ctx.drawImage(this.overlays.canvas, 0, 0);
            return composite;
        }
        to_blob() {
            return this.compose().to_blob();
        }
    }
    exports.CanvasView = CanvasView;
    CanvasView.__name__ = "CanvasView";
    class Canvas extends has_props_1.HasProps {
        constructor(attrs) {
            super(attrs);
        }
        static init_Canvas() {
            this.prototype.default_view = CanvasView;
            this.internal(({ Boolean }) => ({
                hidpi: [Boolean, true],
                output_backend: [enums_1.OutputBackend, "canvas"],
            }));
        }
    }
    exports.Canvas = Canvas;
    Canvas.__name__ = "Canvas";
    Canvas.init_Canvas();
},
/* core/dom_view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const view_1 = require(70) /* ./view */;
    const dom_1 = require(71) /* ./dom */;
    class DOMView extends view_1.View {
        initialize() {
            super.initialize();
            this.el = this._createElement();
        }
        remove() {
            dom_1.remove(this.el);
            super.remove();
        }
        css_classes() {
            return [];
        }
        render() { }
        renderTo(element) {
            element.appendChild(this.el);
            this.render();
        }
        _createElement() {
            return dom_1.createElement(this.tagName, { class: this.css_classes() });
        }
    }
    exports.DOMView = DOMView;
    DOMView.__name__ = "DOMView";
    DOMView.prototype.tagName = "div";
},
/* core/ui_events.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const hammerjs_1 = tslib_1.__importDefault(require(79) /* hammerjs */);
    const signaling_1 = require(15) /* ./signaling */;
    const logging_1 = require(19) /* ./logging */;
    const dom_1 = require(71) /* ./dom */;
    const events = tslib_1.__importStar(require(80) /* ./bokeh_events */);
    const wheel_1 = require(81) /* ./util/wheel */;
    const array_1 = require(9) /* ./util/array */;
    const types_1 = require(8) /* ./util/types */;
    const compat_1 = require(82) /* ./util/compat */;
    const menus_1 = require(83) /* ./util/menus */;
    function is_touch(event) {
        return typeof TouchEvent !== "undefined" && event instanceof TouchEvent;
    }
    class UIEventBus {
        constructor(canvas_view) {
            this.canvas_view = canvas_view;
            this.pan_start = new signaling_1.Signal(this, 'pan:start');
            this.pan = new signaling_1.Signal(this, 'pan');
            this.pan_end = new signaling_1.Signal(this, 'pan:end');
            this.pinch_start = new signaling_1.Signal(this, 'pinch:start');
            this.pinch = new signaling_1.Signal(this, 'pinch');
            this.pinch_end = new signaling_1.Signal(this, 'pinch:end');
            this.rotate_start = new signaling_1.Signal(this, 'rotate:start');
            this.rotate = new signaling_1.Signal(this, 'rotate');
            this.rotate_end = new signaling_1.Signal(this, 'rotate:end');
            this.tap = new signaling_1.Signal(this, 'tap');
            this.doubletap = new signaling_1.Signal(this, 'doubletap');
            this.press = new signaling_1.Signal(this, 'press');
            this.pressup = new signaling_1.Signal(this, 'pressup');
            this.move_enter = new signaling_1.Signal(this, 'move:enter');
            this.move = new signaling_1.Signal(this, 'move');
            this.move_exit = new signaling_1.Signal(this, 'move:exit');
            this.scroll = new signaling_1.Signal(this, 'scroll');
            this.keydown = new signaling_1.Signal(this, 'keydown');
            this.keyup = new signaling_1.Signal(this, 'keyup');
            this.hammer = new hammerjs_1.default(this.hit_area, {
                touchAction: 'auto',
                inputClass: hammerjs_1.default.TouchMouseInput,
            });
            this._prev_move = null;
            this._curr_pan = null;
            this._curr_pinch = null;
            this._curr_rotate = null;
            this._configure_hammerjs();
            // Mouse & keyboard events not handled through hammerjs
            // We can 'add and forget' these event listeners because this.hit_area is a DOM element
            // that will be thrown away when the view is removed
            this.hit_area.addEventListener("mousemove", (e) => this._mouse_move(e));
            this.hit_area.addEventListener("mouseenter", (e) => this._mouse_enter(e));
            this.hit_area.addEventListener("mouseleave", (e) => this._mouse_exit(e));
            this.hit_area.addEventListener("contextmenu", (e) => this._context_menu(e));
            this.hit_area.addEventListener("wheel", (e) => this._mouse_wheel(e));
            // But we MUST remove listeners registered on document or we'll leak memory: register
            // 'this' as the listener (it implements the event listener interface, i.e. handleEvent)
            // instead of an anonymous function so we can easily refer back to it for removing
            document.addEventListener("keydown", this);
            document.addEventListener("keyup", this);
            this.menu = new menus_1.ContextMenu([], {
                prevent_hide: (event) => event.button == 2 && event.target == this.hit_area,
            });
            this.hit_area.appendChild(this.menu.el);
        }
        get hit_area() {
            return this.canvas_view.events_el;
        }
        destroy() {
            this.menu.remove();
            this.hammer.destroy();
            document.removeEventListener("keydown", this);
            document.removeEventListener("keyup", this);
        }
        handleEvent(e) {
            if (e.type == "keydown")
                this._key_down(e);
            else if (e.type == "keyup")
                this._key_up(e);
        }
        _configure_hammerjs() {
            // This is to be able to distinguish double taps from single taps
            this.hammer.get('doubletap').recognizeWith('tap');
            this.hammer.get('tap').requireFailure('doubletap');
            this.hammer.get('doubletap').dropRequireFailure('tap');
            this.hammer.on('doubletap', (e) => this._doubletap(e));
            this.hammer.on('tap', (e) => this._tap(e));
            this.hammer.on('press', (e) => this._press(e));
            this.hammer.on('pressup', (e) => this._pressup(e));
            this.hammer.get('pan').set({ direction: hammerjs_1.default.DIRECTION_ALL });
            this.hammer.on('panstart', (e) => this._pan_start(e));
            this.hammer.on('pan', (e) => this._pan(e));
            this.hammer.on('panend', (e) => this._pan_end(e));
            this.hammer.get('pinch').set({ enable: true });
            this.hammer.on('pinchstart', (e) => this._pinch_start(e));
            this.hammer.on('pinch', (e) => this._pinch(e));
            this.hammer.on('pinchend', (e) => this._pinch_end(e));
            this.hammer.get('rotate').set({ enable: true });
            this.hammer.on('rotatestart', (e) => this._rotate_start(e));
            this.hammer.on('rotate', (e) => this._rotate(e));
            this.hammer.on('rotateend', (e) => this._rotate_end(e));
        }
        register_tool(tool_view) {
            const et = tool_view.model.event_type;
            if (et != null) {
                if (types_1.isString(et))
                    this._register_tool(tool_view, et);
                else {
                    // Multi-tools should only registered shared events once
                    et.forEach((e, index) => this._register_tool(tool_view, e, index < 1));
                }
            }
        }
        _register_tool(tool_view, et, shared = true) {
            const v = tool_view;
            const { id } = v.model;
            const conditionally = (fn) => (arg) => {
                if (arg.id == id)
                    fn(arg.e);
            };
            const unconditionally = (fn) => (arg) => {
                fn(arg.e);
            };
            switch (et) {
                case "pan": {
                    if (v._pan_start != null)
                        v.connect(this.pan_start, conditionally(v._pan_start.bind(v)));
                    if (v._pan != null)
                        v.connect(this.pan, conditionally(v._pan.bind(v)));
                    if (v._pan_end != null)
                        v.connect(this.pan_end, conditionally(v._pan_end.bind(v)));
                    break;
                }
                case "pinch": {
                    if (v._pinch_start != null)
                        v.connect(this.pinch_start, conditionally(v._pinch_start.bind(v)));
                    if (v._pinch != null)
                        v.connect(this.pinch, conditionally(v._pinch.bind(v)));
                    if (v._pinch_end != null)
                        v.connect(this.pinch_end, conditionally(v._pinch_end.bind(v)));
                    break;
                }
                case "rotate": {
                    if (v._rotate_start != null)
                        v.connect(this.rotate_start, conditionally(v._rotate_start.bind(v)));
                    if (v._rotate != null)
                        v.connect(this.rotate, conditionally(v._rotate.bind(v)));
                    if (v._rotate_end != null)
                        v.connect(this.rotate_end, conditionally(v._rotate_end.bind(v)));
                    break;
                }
                case "move": {
                    if (v._move_enter != null)
                        v.connect(this.move_enter, conditionally(v._move_enter.bind(v)));
                    if (v._move != null)
                        v.connect(this.move, conditionally(v._move.bind(v)));
                    if (v._move_exit != null)
                        v.connect(this.move_exit, conditionally(v._move_exit.bind(v)));
                    break;
                }
                case "tap": {
                    if (v._tap != null)
                        v.connect(this.tap, conditionally(v._tap.bind(v)));
                    if (v._doubletap != null)
                        v.connect(this.doubletap, conditionally(v._doubletap.bind(v)));
                    break;
                }
                case "press": {
                    if (v._press != null)
                        v.connect(this.press, conditionally(v._press.bind(v)));
                    if (v._pressup != null)
                        v.connect(this.pressup, conditionally(v._pressup.bind(v)));
                    break;
                }
                case "scroll": {
                    if (v._scroll != null)
                        v.connect(this.scroll, conditionally(v._scroll.bind(v)));
                    break;
                }
                default:
                    throw new Error(`unsupported event_type: ${et}`);
            }
            // Skip shared events if registering multi-tool
            if (!shared)
                return;
            if (v._keydown != null)
                v.connect(this.keydown, unconditionally(v._keydown.bind(v)));
            if (v._keyup != null)
                v.connect(this.keyup, unconditionally(v._keyup.bind(v)));
            // Dual touch hack part 1/2
            // This is a hack for laptops with touch screen who may be pinching or scrolling
            // in order to use the wheel zoom tool. If it's a touch screen the WheelZoomTool event
            // will be linked to pinch. But we also want to trigger in the case of a scroll.
            if (compat_1.is_mobile && v._scroll != null && et == 'pinch') {
                logging_1.logger.debug("Registering scroll on touch screen");
                v.connect(this.scroll, conditionally(v._scroll.bind(v)));
            }
        }
        _hit_test_renderers(plot_view, sx, sy) {
            const views = plot_view.get_renderer_views();
            for (const view of array_1.reversed(views)) {
                const { level } = view.model;
                if ((level == 'annotation' || level == 'overlay') && view.interactive_hit != null) {
                    if (view.interactive_hit(sx, sy))
                        return view;
                }
            }
            return null;
        }
        set_cursor(cursor = "default") {
            this.hit_area.style.cursor = cursor;
        }
        _hit_test_frame(plot_view, sx, sy) {
            return plot_view.frame.bbox.contains(sx, sy);
        }
        _hit_test_canvas(plot_view, sx, sy) {
            return plot_view.layout.bbox.contains(sx, sy);
        }
        _hit_test_plot(sx, sy) {
            // TODO: z-index
            for (const plot_view of this.canvas_view.plot_views) {
                if (plot_view.layout.bbox.relative() /*XXX*/.contains(sx, sy))
                    return plot_view;
            }
            return null;
        }
        _trigger(signal, e, srcEvent) {
            var _a;
            const { sx, sy } = e;
            const plot_view = this._hit_test_plot(sx, sy);
            const curr_view = plot_view;
            const relativize_event = (_plot_view) => {
                const [rel_sx, rel_sy] = [sx, sy]; // plot_view.layout.bbox.relativize(sx, sy)
                return Object.assign(Object.assign({}, e), { sx: rel_sx, sy: rel_sy });
            };
            if (e.type == "panstart" || e.type == "pan" || e.type == "panend") {
                let pan_view;
                if (e.type == "panstart" && curr_view != null) {
                    this._curr_pan = { plot_view: curr_view };
                    pan_view = curr_view;
                }
                else if (e.type == "pan" && this._curr_pan != null) {
                    pan_view = this._curr_pan.plot_view;
                }
                else if (e.type == "panend" && this._curr_pan != null) {
                    pan_view = this._curr_pan.plot_view;
                    this._curr_pan = null;
                }
                else {
                    pan_view = null;
                }
                if (pan_view != null) {
                    const event = relativize_event(pan_view);
                    this.__trigger(pan_view, signal, event, srcEvent);
                }
            }
            else if (e.type == "pinchstart" || e.type == "pinch" || e.type == "pinchend") {
                let pinch_view;
                if (e.type == "pinchstart" && curr_view != null) {
                    this._curr_pinch = { plot_view: curr_view };
                    pinch_view = curr_view;
                }
                else if (e.type == "pinch" && this._curr_pinch != null) {
                    pinch_view = this._curr_pinch.plot_view;
                }
                else if (e.type == "pinchend" && this._curr_pinch != null) {
                    pinch_view = this._curr_pinch.plot_view;
                    this._curr_pinch = null;
                }
                else {
                    pinch_view = null;
                }
                if (pinch_view != null) {
                    const event = relativize_event(pinch_view);
                    this.__trigger(pinch_view, signal, event, srcEvent);
                }
            }
            else if (e.type == "rotatestart" || e.type == "rotate" || e.type == "rotateend") {
                let rotate_view;
                if (e.type == "rotatestart" && curr_view != null) {
                    this._curr_rotate = { plot_view: curr_view };
                    rotate_view = curr_view;
                }
                else if (e.type == "rotate" && this._curr_rotate != null) {
                    rotate_view = this._curr_rotate.plot_view;
                }
                else if (e.type == "rotateend" && this._curr_rotate != null) {
                    rotate_view = this._curr_rotate.plot_view;
                    this._curr_rotate = null;
                }
                else {
                    rotate_view = null;
                }
                if (rotate_view != null) {
                    const event = relativize_event(rotate_view);
                    this.__trigger(rotate_view, signal, event, srcEvent);
                }
            }
            else if (e.type == "mouseenter" || e.type == "mousemove" || e.type == "mouseleave") {
                const prev_view = (_a = this._prev_move) === null || _a === void 0 ? void 0 : _a.plot_view;
                if (prev_view != null && (e.type == "mouseleave" || prev_view != curr_view)) {
                    const { sx, sy } = relativize_event(prev_view);
                    this.__trigger(prev_view, this.move_exit, { type: "mouseleave", sx, sy, shiftKey: false, ctrlKey: false }, srcEvent);
                }
                if (curr_view != null && (e.type == "mouseenter" || prev_view != curr_view)) {
                    const { sx, sy } = relativize_event(curr_view);
                    this.__trigger(curr_view, this.move_enter, { type: "mouseenter", sx, sy, shiftKey: false, ctrlKey: false }, srcEvent);
                }
                if (curr_view != null && e.type == "mousemove") {
                    const event = relativize_event(curr_view);
                    this.__trigger(curr_view, signal, event, srcEvent);
                }
                this._prev_move = { sx, sy, plot_view: curr_view };
            }
            else {
                if (curr_view != null) {
                    const event = relativize_event(curr_view);
                    this.__trigger(curr_view, signal, event, srcEvent);
                }
            }
        }
        __trigger(plot_view, signal, e, srcEvent) {
            var _a, _b;
            const gestures = plot_view.model.toolbar.gestures;
            const event_type = signal.name;
            const base_type = event_type.split(":")[0];
            const view = this._hit_test_renderers(plot_view, e.sx, e.sy);
            const on_canvas = this._hit_test_canvas(plot_view, e.sx, e.sy);
            switch (base_type) {
                case "move": {
                    const active_gesture = gestures[base_type].active;
                    if (active_gesture != null)
                        this.trigger(signal, e, active_gesture.id);
                    const active_inspectors = plot_view.model.toolbar.inspectors.filter(t => t.active);
                    let cursor = "default";
                    // the event happened on a renderer
                    if (view != null) {
                        cursor = (_a = view.cursor(e.sx, e.sy)) !== null && _a !== void 0 ? _a : cursor;
                        if (!array_1.is_empty(active_inspectors)) {
                            // override event_type to cause inspectors to clear overlays
                            signal = this.move_exit; // XXX
                        }
                        // the event happened on the plot frame but off a renderer
                    }
                    else if (this._hit_test_frame(plot_view, e.sx, e.sy)) {
                        if (!array_1.is_empty(active_inspectors)) {
                            cursor = "crosshair";
                        }
                    }
                    this.set_cursor(cursor);
                    plot_view.set_toolbar_visibility(on_canvas);
                    active_inspectors.map((inspector) => this.trigger(signal, e, inspector.id));
                    break;
                }
                case "tap": {
                    const { target } = srcEvent;
                    if (target != null && target != this.hit_area)
                        return; // don't trigger bokeh events
                    if (view != null && view.on_hit != null)
                        view.on_hit(e.sx, e.sy);
                    const active_gesture = gestures[base_type].active;
                    if (active_gesture != null)
                        this.trigger(signal, e, active_gesture.id);
                    break;
                }
                case "doubletap": {
                    const active_gesture = (_b = gestures.doubletap.active) !== null && _b !== void 0 ? _b : gestures.tap.active;
                    if (active_gesture != null)
                        this.trigger(signal, e, active_gesture.id);
                    break;
                }
                case "scroll": {
                    // Dual touch hack part 2/2
                    // This is a hack for laptops with touch screen who may be pinching or scrolling
                    // in order to use the wheel zoom tool. If it's a touch screen the WheelZoomTool event
                    // will be linked to pinch. But we also want to trigger in the case of a scroll.
                    const base = compat_1.is_mobile ? "pinch" : "scroll";
                    const active_gesture = gestures[base].active;
                    if (active_gesture != null) {
                        srcEvent.preventDefault();
                        srcEvent.stopPropagation();
                        this.trigger(signal, e, active_gesture.id);
                    }
                    break;
                }
                case "pan": {
                    const active_gesture = gestures[base_type].active;
                    if (active_gesture != null) {
                        srcEvent.preventDefault();
                        this.trigger(signal, e, active_gesture.id);
                    }
                    break;
                }
                default: {
                    const active_gesture = gestures[base_type].active;
                    if (active_gesture != null)
                        this.trigger(signal, e, active_gesture.id);
                }
            }
            this._trigger_bokeh_event(plot_view, e);
        }
        trigger(signal, e, id = null) {
            signal.emit({ id, e });
        }
        /*protected*/ _trigger_bokeh_event(plot_view, e) {
            const ev = (() => {
                const { sx, sy } = e;
                const x = plot_view.frame.x_scale.invert(sx);
                const y = plot_view.frame.y_scale.invert(sy);
                switch (e.type) {
                    case "wheel":
                        return new events.MouseWheel(sx, sy, x, y, e.delta);
                    case "mousemove":
                        return new events.MouseMove(sx, sy, x, y);
                    case "mouseenter":
                        return new events.MouseEnter(sx, sy, x, y);
                    case "mouseleave":
                        return new events.MouseLeave(sx, sy, x, y);
                    case "tap":
                        return new events.Tap(sx, sy, x, y);
                    case "doubletap":
                        return new events.DoubleTap(sx, sy, x, y);
                    case "press":
                        return new events.Press(sx, sy, x, y);
                    case "pressup":
                        return new events.PressUp(sx, sy, x, y);
                    case "pan":
                        return new events.Pan(sx, sy, x, y, e.deltaX, e.deltaY);
                    case "panstart":
                        return new events.PanStart(sx, sy, x, y);
                    case "panend":
                        return new events.PanEnd(sx, sy, x, y);
                    case "pinch":
                        return new events.Pinch(sx, sy, x, y, e.scale);
                    case "pinchstart":
                        return new events.PinchStart(sx, sy, x, y);
                    case "pinchend":
                        return new events.PinchEnd(sx, sy, x, y);
                    case "rotate":
                        return new events.Rotate(sx, sy, x, y, e.rotation);
                    case "rotatestart":
                        return new events.RotateStart(sx, sy, x, y);
                    case "rotateend":
                        return new events.RotateEnd(sx, sy, x, y);
                    default:
                        return undefined;
                }
            })();
            if (ev != null)
                plot_view.model.trigger_event(ev);
        }
        /*private*/ _get_sxy(event) {
            const { pageX, pageY } = is_touch(event) ? (event.touches.length != 0 ? event.touches : event.changedTouches)[0] : event;
            const { left, top } = dom_1.offset(this.hit_area);
            return {
                sx: pageX - left,
                sy: pageY - top,
            };
        }
        /*private*/ _pan_event(e) {
            return Object.assign(Object.assign({ type: e.type }, this._get_sxy(e.srcEvent)), { deltaX: e.deltaX, deltaY: e.deltaY, shiftKey: e.srcEvent.shiftKey, ctrlKey: e.srcEvent.ctrlKey });
        }
        /*private*/ _pinch_event(e) {
            return Object.assign(Object.assign({ type: e.type }, this._get_sxy(e.srcEvent)), { scale: e.scale, shiftKey: e.srcEvent.shiftKey, ctrlKey: e.srcEvent.ctrlKey });
        }
        /*private*/ _rotate_event(e) {
            return Object.assign(Object.assign({ type: e.type }, this._get_sxy(e.srcEvent)), { rotation: e.rotation, shiftKey: e.srcEvent.shiftKey, ctrlKey: e.srcEvent.ctrlKey });
        }
        /*private*/ _tap_event(e) {
            return Object.assign(Object.assign({ type: e.type }, this._get_sxy(e.srcEvent)), { shiftKey: e.srcEvent.shiftKey, ctrlKey: e.srcEvent.ctrlKey });
        }
        /*private*/ _move_event(e) {
            return Object.assign(Object.assign({ type: e.type }, this._get_sxy(e)), { shiftKey: e.shiftKey, ctrlKey: e.ctrlKey });
        }
        /*private*/ _scroll_event(e) {
            return Object.assign(Object.assign({ type: e.type }, this._get_sxy(e)), { delta: wheel_1.getDeltaY(e), shiftKey: e.shiftKey, ctrlKey: e.ctrlKey });
        }
        /*private*/ _key_event(e) {
            return {
                type: e.type,
                keyCode: e.keyCode,
            };
        }
        /*private*/ _pan_start(e) {
            const ev = this._pan_event(e);
            // back out delta to get original center point
            ev.sx -= e.deltaX;
            ev.sy -= e.deltaY;
            this._trigger(this.pan_start, ev, e.srcEvent);
        }
        /*private*/ _pan(e) {
            this._trigger(this.pan, this._pan_event(e), e.srcEvent);
        }
        /*private*/ _pan_end(e) {
            this._trigger(this.pan_end, this._pan_event(e), e.srcEvent);
        }
        /*private*/ _pinch_start(e) {
            this._trigger(this.pinch_start, this._pinch_event(e), e.srcEvent);
        }
        /*private*/ _pinch(e) {
            this._trigger(this.pinch, this._pinch_event(e), e.srcEvent);
        }
        /*private*/ _pinch_end(e) {
            this._trigger(this.pinch_end, this._pinch_event(e), e.srcEvent);
        }
        /*private*/ _rotate_start(e) {
            this._trigger(this.rotate_start, this._rotate_event(e), e.srcEvent);
        }
        /*private*/ _rotate(e) {
            this._trigger(this.rotate, this._rotate_event(e), e.srcEvent);
        }
        /*private*/ _rotate_end(e) {
            this._trigger(this.rotate_end, this._rotate_event(e), e.srcEvent);
        }
        /*private*/ _tap(e) {
            this._trigger(this.tap, this._tap_event(e), e.srcEvent);
        }
        /*private*/ _doubletap(e) {
            this._trigger(this.doubletap, this._tap_event(e), e.srcEvent);
        }
        /*private*/ _press(e) {
            this._trigger(this.press, this._tap_event(e), e.srcEvent);
        }
        /*private*/ _pressup(e) {
            this._trigger(this.pressup, this._tap_event(e), e.srcEvent);
        }
        /*private*/ _mouse_enter(e) {
            this._trigger(this.move_enter, this._move_event(e), e);
        }
        /*private*/ _mouse_move(e) {
            this._trigger(this.move, this._move_event(e), e);
        }
        /*private*/ _mouse_exit(e) {
            this._trigger(this.move_exit, this._move_event(e), e);
        }
        /*private*/ _mouse_wheel(e) {
            this._trigger(this.scroll, this._scroll_event(e), e);
        }
        /*private*/ _context_menu(e) {
            if (!this.menu.is_open && this.menu.can_open) {
                e.preventDefault();
            }
            const { sx, sy } = this._get_sxy(e);
            this.menu.toggle({ left: sx, top: sy });
        }
        /*private*/ _key_down(e) {
            // NOTE: keyup event triggered unconditionally
            this.trigger(this.keydown, this._key_event(e));
        }
        /*private*/ _key_up(e) {
            // NOTE: keyup event triggered unconditionally
            this.trigger(this.keyup, this._key_event(e));
        }
    }
    exports.UIEventBus = UIEventBus;
    UIEventBus.__name__ = "UIEventBus";
},
/* hammerjs/hammer.js */ function _(require, module, exports, __esModule, __esExport) {
    /*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
    (function (window, document, exportName, undefined) {
        'use strict';
        var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
        var TEST_ELEMENT = document.createElement('div');
        var TYPE_FUNCTION = 'function';
        var round = Math.round;
        var abs = Math.abs;
        var now = Date.now;
        /**
         * set a timeout with a given scope
         * @param {Function} fn
         * @param {Number} timeout
         * @param {Object} context
         * @returns {number}
         */
        function setTimeoutContext(fn, timeout, context) {
            return setTimeout(bindFn(fn, context), timeout);
        }
        /**
         * if the argument is an array, we want to execute the fn on each entry
         * if it aint an array we don't want to do a thing.
         * this is used by all the methods that accept a single and array argument.
         * @param {*|Array} arg
         * @param {String} fn
         * @param {Object} [context]
         * @returns {Boolean}
         */
        function invokeArrayArg(arg, fn, context) {
            if (Array.isArray(arg)) {
                each(arg, context[fn], context);
                return true;
            }
            return false;
        }
        /**
         * walk objects and arrays
         * @param {Object} obj
         * @param {Function} iterator
         * @param {Object} context
         */
        function each(obj, iterator, context) {
            var i;
            if (!obj) {
                return;
            }
            if (obj.forEach) {
                obj.forEach(iterator, context);
            }
            else if (obj.length !== undefined) {
                i = 0;
                while (i < obj.length) {
                    iterator.call(context, obj[i], i, obj);
                    i++;
                }
            }
            else {
                for (i in obj) {
                    obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
                }
            }
        }
        /**
         * wrap a method with a deprecation warning and stack trace
         * @param {Function} method
         * @param {String} name
         * @param {String} message
         * @returns {Function} A new function wrapping the supplied method.
         */
        function deprecate(method, name, message) {
            var deprecationMessage = 'DEPRECATED METHOD: ' + name + '\n' + message + ' AT \n';
            return function () {
                var e = new Error('get-stack-trace');
                var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '')
                    .replace(/^\s+at\s+/gm, '')
                    .replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';
                var log = window.console && (window.console.warn || window.console.log);
                if (log) {
                    log.call(window.console, deprecationMessage, stack);
                }
                return method.apply(this, arguments);
            };
        }
        /**
         * extend object.
         * means that properties in dest will be overwritten by the ones in src.
         * @param {Object} target
         * @param {...Object} objects_to_assign
         * @returns {Object} target
         */
        var assign;
        if (typeof Object.assign !== 'function') {
            assign = function assign(target) {
                if (target === undefined || target === null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var output = Object(target);
                for (var index = 1; index < arguments.length; index++) {
                    var source = arguments[index];
                    if (source !== undefined && source !== null) {
                        for (var nextKey in source) {
                            if (source.hasOwnProperty(nextKey)) {
                                output[nextKey] = source[nextKey];
                            }
                        }
                    }
                }
                return output;
            };
        }
        else {
            assign = Object.assign;
        }
        /**
         * extend object.
         * means that properties in dest will be overwritten by the ones in src.
         * @param {Object} dest
         * @param {Object} src
         * @param {Boolean} [merge=false]
         * @returns {Object} dest
         */
        var extend = deprecate(function extend(dest, src, merge) {
            var keys = Object.keys(src);
            var i = 0;
            while (i < keys.length) {
                if (!merge || (merge && dest[keys[i]] === undefined)) {
                    dest[keys[i]] = src[keys[i]];
                }
                i++;
            }
            return dest;
        }, 'extend', 'Use `assign`.');
        /**
         * merge the values from src in the dest.
         * means that properties that exist in dest will not be overwritten by src
         * @param {Object} dest
         * @param {Object} src
         * @returns {Object} dest
         */
        var merge = deprecate(function merge(dest, src) {
            return extend(dest, src, true);
        }, 'merge', 'Use `assign`.');
        /**
         * simple class inheritance
         * @param {Function} child
         * @param {Function} base
         * @param {Object} [properties]
         */
        function inherit(child, base, properties) {
            var baseP = base.prototype, childP;
            childP = child.prototype = Object.create(baseP);
            childP.constructor = child;
            childP._super = baseP;
            if (properties) {
                assign(childP, properties);
            }
        }
        /**
         * simple function bind
         * @param {Function} fn
         * @param {Object} context
         * @returns {Function}
         */
        function bindFn(fn, context) {
            return function boundFn() {
                return fn.apply(context, arguments);
            };
        }
        /**
         * let a boolean value also be a function that must return a boolean
         * this first item in args will be used as the context
         * @param {Boolean|Function} val
         * @param {Array} [args]
         * @returns {Boolean}
         */
        function boolOrFn(val, args) {
            if (typeof val == TYPE_FUNCTION) {
                return val.apply(args ? args[0] || undefined : undefined, args);
            }
            return val;
        }
        /**
         * use the val2 when val1 is undefined
         * @param {*} val1
         * @param {*} val2
         * @returns {*}
         */
        function ifUndefined(val1, val2) {
            return (val1 === undefined) ? val2 : val1;
        }
        /**
         * addEventListener with multiple events at once
         * @param {EventTarget} target
         * @param {String} types
         * @param {Function} handler
         */
        function addEventListeners(target, types, handler) {
            each(splitStr(types), function (type) {
                target.addEventListener(type, handler, false);
            });
        }
        /**
         * removeEventListener with multiple events at once
         * @param {EventTarget} target
         * @param {String} types
         * @param {Function} handler
         */
        function removeEventListeners(target, types, handler) {
            each(splitStr(types), function (type) {
                target.removeEventListener(type, handler, false);
            });
        }
        /**
         * find if a node is in the given parent
         * @method hasParent
         * @param {HTMLElement} node
         * @param {HTMLElement} parent
         * @return {Boolean} found
         */
        function hasParent(node, parent) {
            while (node) {
                if (node == parent) {
                    return true;
                }
                node = node.parentNode;
            }
            return false;
        }
        /**
         * small indexOf wrapper
         * @param {String} str
         * @param {String} find
         * @returns {Boolean} found
         */
        function inStr(str, find) {
            return str.indexOf(find) > -1;
        }
        /**
         * split string on whitespace
         * @param {String} str
         * @returns {Array} words
         */
        function splitStr(str) {
            return str.trim().split(/\s+/g);
        }
        /**
         * find if a array contains the object using indexOf or a simple polyFill
         * @param {Array} src
         * @param {String} find
         * @param {String} [findByKey]
         * @return {Boolean|Number} false when not found, or the index
         */
        function inArray(src, find, findByKey) {
            if (src.indexOf && !findByKey) {
                return src.indexOf(find);
            }
            else {
                var i = 0;
                while (i < src.length) {
                    if ((findByKey && src[i][findByKey] == find) || (!findByKey && src[i] === find)) {
                        return i;
                    }
                    i++;
                }
                return -1;
            }
        }
        /**
         * convert array-like objects to real arrays
         * @param {Object} obj
         * @returns {Array}
         */
        function toArray(obj) {
            return Array.prototype.slice.call(obj, 0);
        }
        /**
         * unique array with objects based on a key (like 'id') or just by the array's value
         * @param {Array} src [{id:1},{id:2},{id:1}]
         * @param {String} [key]
         * @param {Boolean} [sort=False]
         * @returns {Array} [{id:1},{id:2}]
         */
        function uniqueArray(src, key, sort) {
            var results = [];
            var values = [];
            var i = 0;
            while (i < src.length) {
                var val = key ? src[i][key] : src[i];
                if (inArray(values, val) < 0) {
                    results.push(src[i]);
                }
                values[i] = val;
                i++;
            }
            if (sort) {
                if (!key) {
                    results = results.sort();
                }
                else {
                    results = results.sort(function sortUniqueArray(a, b) {
                        return a[key] > b[key];
                    });
                }
            }
            return results;
        }
        /**
         * get the prefixed property
         * @param {Object} obj
         * @param {String} property
         * @returns {String|Undefined} prefixed
         */
        function prefixed(obj, property) {
            var prefix, prop;
            var camelProp = property[0].toUpperCase() + property.slice(1);
            var i = 0;
            while (i < VENDOR_PREFIXES.length) {
                prefix = VENDOR_PREFIXES[i];
                prop = (prefix) ? prefix + camelProp : property;
                if (prop in obj) {
                    return prop;
                }
                i++;
            }
            return undefined;
        }
        /**
         * get a unique id
         * @returns {number} uniqueId
         */
        var _uniqueId = 1;
        function uniqueId() {
            return _uniqueId++;
        }
        /**
         * get the window object of an element
         * @param {HTMLElement} element
         * @returns {DocumentView|Window}
         */
        function getWindowForElement(element) {
            var doc = element.ownerDocument || element;
            return (doc.defaultView || doc.parentWindow || window);
        }
        var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
        var SUPPORT_TOUCH = ('ontouchstart' in window);
        var SUPPORT_POINTER_EVENTS = prefixed(window, 'PointerEvent') !== undefined;
        var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
        var INPUT_TYPE_TOUCH = 'touch';
        var INPUT_TYPE_PEN = 'pen';
        var INPUT_TYPE_MOUSE = 'mouse';
        var INPUT_TYPE_KINECT = 'kinect';
        var COMPUTE_INTERVAL = 25;
        var INPUT_START = 1;
        var INPUT_MOVE = 2;
        var INPUT_END = 4;
        var INPUT_CANCEL = 8;
        var DIRECTION_NONE = 1;
        var DIRECTION_LEFT = 2;
        var DIRECTION_RIGHT = 4;
        var DIRECTION_UP = 8;
        var DIRECTION_DOWN = 16;
        var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
        var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
        var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
        var PROPS_XY = ['x', 'y'];
        var PROPS_CLIENT_XY = ['clientX', 'clientY'];
        /**
         * create new input type manager
         * @param {Manager} manager
         * @param {Function} callback
         * @returns {Input}
         * @constructor
         */
        function Input(manager, callback) {
            var self = this;
            this.manager = manager;
            this.callback = callback;
            this.element = manager.element;
            this.target = manager.options.inputTarget;
            // smaller wrapper around the handler, for the scope and the enabled state of the manager,
            // so when disabled the input events are completely bypassed.
            this.domHandler = function (ev) {
                if (boolOrFn(manager.options.enable, [manager])) {
                    self.handler(ev);
                }
            };
            this.init();
        }
        Input.prototype = {
            /**
             * should handle the inputEvent data and trigger the callback
             * @virtual
             */
            handler: function () { },
            /**
             * bind the events
             */
            init: function () {
                this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
                this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
                this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
            },
            /**
             * unbind the events
             */
            destroy: function () {
                this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
                this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
                this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
            }
        };
        /**
         * create new input type manager
         * called by the Manager constructor
         * @param {Hammer} manager
         * @returns {Input}
         */
        function createInputInstance(manager) {
            var Type;
            var inputClass = manager.options.inputClass;
            if (inputClass) {
                Type = inputClass;
            }
            else if (SUPPORT_POINTER_EVENTS) {
                Type = PointerEventInput;
            }
            else if (SUPPORT_ONLY_TOUCH) {
                Type = TouchInput;
            }
            else if (!SUPPORT_TOUCH) {
                Type = MouseInput;
            }
            else {
                Type = TouchMouseInput;
            }
            return new (Type)(manager, inputHandler);
        }
        /**
         * handle input events
         * @param {Manager} manager
         * @param {String} eventType
         * @param {Object} input
         */
        function inputHandler(manager, eventType, input) {
            var pointersLen = input.pointers.length;
            var changedPointersLen = input.changedPointers.length;
            var isFirst = (eventType & INPUT_START && (pointersLen - changedPointersLen === 0));
            var isFinal = (eventType & (INPUT_END | INPUT_CANCEL) && (pointersLen - changedPointersLen === 0));
            input.isFirst = !!isFirst;
            input.isFinal = !!isFinal;
            if (isFirst) {
                manager.session = {};
            }
            // source event is the normalized value of the domEvents
            // like 'touchstart, mouseup, pointerdown'
            input.eventType = eventType;
            // compute scale, rotation etc
            computeInputData(manager, input);
            // emit secret event
            manager.emit('hammer.input', input);
            manager.recognize(input);
            manager.session.prevInput = input;
        }
        /**
         * extend the data with some usable properties like scale, rotate, velocity etc
         * @param {Object} manager
         * @param {Object} input
         */
        function computeInputData(manager, input) {
            var session = manager.session;
            var pointers = input.pointers;
            var pointersLength = pointers.length;
            // store the first input to calculate the distance and direction
            if (!session.firstInput) {
                session.firstInput = simpleCloneInputData(input);
            }
            // to compute scale and rotation we need to store the multiple touches
            if (pointersLength > 1 && !session.firstMultiple) {
                session.firstMultiple = simpleCloneInputData(input);
            }
            else if (pointersLength === 1) {
                session.firstMultiple = false;
            }
            var firstInput = session.firstInput;
            var firstMultiple = session.firstMultiple;
            var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;
            var center = input.center = getCenter(pointers);
            input.timeStamp = now();
            input.deltaTime = input.timeStamp - firstInput.timeStamp;
            input.angle = getAngle(offsetCenter, center);
            input.distance = getDistance(offsetCenter, center);
            computeDeltaXY(session, input);
            input.offsetDirection = getDirection(input.deltaX, input.deltaY);
            var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
            input.overallVelocityX = overallVelocity.x;
            input.overallVelocityY = overallVelocity.y;
            input.overallVelocity = (abs(overallVelocity.x) > abs(overallVelocity.y)) ? overallVelocity.x : overallVelocity.y;
            input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
            input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;
            input.maxPointers = !session.prevInput ? input.pointers.length : ((input.pointers.length >
                session.prevInput.maxPointers) ? input.pointers.length : session.prevInput.maxPointers);
            computeIntervalInputData(session, input);
            // find the correct target
            var target = manager.element;
            if (hasParent(input.srcEvent.target, target)) {
                target = input.srcEvent.target;
            }
            input.target = target;
        }
        function computeDeltaXY(session, input) {
            var center = input.center;
            var offset = session.offsetDelta || {};
            var prevDelta = session.prevDelta || {};
            var prevInput = session.prevInput || {};
            if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
                prevDelta = session.prevDelta = {
                    x: prevInput.deltaX || 0,
                    y: prevInput.deltaY || 0
                };
                offset = session.offsetDelta = {
                    x: center.x,
                    y: center.y
                };
            }
            input.deltaX = prevDelta.x + (center.x - offset.x);
            input.deltaY = prevDelta.y + (center.y - offset.y);
        }
        /**
         * velocity is calculated every x ms
         * @param {Object} session
         * @param {Object} input
         */
        function computeIntervalInputData(session, input) {
            var last = session.lastInterval || input, deltaTime = input.timeStamp - last.timeStamp, velocity, velocityX, velocityY, direction;
            if (input.eventType != INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {
                var deltaX = input.deltaX - last.deltaX;
                var deltaY = input.deltaY - last.deltaY;
                var v = getVelocity(deltaTime, deltaX, deltaY);
                velocityX = v.x;
                velocityY = v.y;
                velocity = (abs(v.x) > abs(v.y)) ? v.x : v.y;
                direction = getDirection(deltaX, deltaY);
                session.lastInterval = input;
            }
            else {
                // use latest velocity info if it doesn't overtake a minimum period
                velocity = last.velocity;
                velocityX = last.velocityX;
                velocityY = last.velocityY;
                direction = last.direction;
            }
            input.velocity = velocity;
            input.velocityX = velocityX;
            input.velocityY = velocityY;
            input.direction = direction;
        }
        /**
         * create a simple clone from the input used for storage of firstInput and firstMultiple
         * @param {Object} input
         * @returns {Object} clonedInputData
         */
        function simpleCloneInputData(input) {
            // make a simple copy of the pointers because we will get a reference if we don't
            // we only need clientXY for the calculations
            var pointers = [];
            var i = 0;
            while (i < input.pointers.length) {
                pointers[i] = {
                    clientX: round(input.pointers[i].clientX),
                    clientY: round(input.pointers[i].clientY)
                };
                i++;
            }
            return {
                timeStamp: now(),
                pointers: pointers,
                center: getCenter(pointers),
                deltaX: input.deltaX,
                deltaY: input.deltaY
            };
        }
        /**
         * get the center of all the pointers
         * @param {Array} pointers
         * @return {Object} center contains `x` and `y` properties
         */
        function getCenter(pointers) {
            var pointersLength = pointers.length;
            // no need to loop when only one touch
            if (pointersLength === 1) {
                return {
                    x: round(pointers[0].clientX),
                    y: round(pointers[0].clientY)
                };
            }
            var x = 0, y = 0, i = 0;
            while (i < pointersLength) {
                x += pointers[i].clientX;
                y += pointers[i].clientY;
                i++;
            }
            return {
                x: round(x / pointersLength),
                y: round(y / pointersLength)
            };
        }
        /**
         * calculate the velocity between two points. unit is in px per ms.
         * @param {Number} deltaTime
         * @param {Number} x
         * @param {Number} y
         * @return {Object} velocity `x` and `y`
         */
        function getVelocity(deltaTime, x, y) {
            return {
                x: x / deltaTime || 0,
                y: y / deltaTime || 0
            };
        }
        /**
         * get the direction between two points
         * @param {Number} x
         * @param {Number} y
         * @return {Number} direction
         */
        function getDirection(x, y) {
            if (x === y) {
                return DIRECTION_NONE;
            }
            if (abs(x) >= abs(y)) {
                return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
            }
            return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
        }
        /**
         * calculate the absolute distance between two points
         * @param {Object} p1 {x, y}
         * @param {Object} p2 {x, y}
         * @param {Array} [props] containing x and y keys
         * @return {Number} distance
         */
        function getDistance(p1, p2, props) {
            if (!props) {
                props = PROPS_XY;
            }
            var x = p2[props[0]] - p1[props[0]], y = p2[props[1]] - p1[props[1]];
            return Math.sqrt((x * x) + (y * y));
        }
        /**
         * calculate the angle between two coordinates
         * @param {Object} p1
         * @param {Object} p2
         * @param {Array} [props] containing x and y keys
         * @return {Number} angle
         */
        function getAngle(p1, p2, props) {
            if (!props) {
                props = PROPS_XY;
            }
            var x = p2[props[0]] - p1[props[0]], y = p2[props[1]] - p1[props[1]];
            return Math.atan2(y, x) * 180 / Math.PI;
        }
        /**
         * calculate the rotation degrees between two pointersets
         * @param {Array} start array of pointers
         * @param {Array} end array of pointers
         * @return {Number} rotation
         */
        function getRotation(start, end) {
            return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
        }
        /**
         * calculate the scale factor between two pointersets
         * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
         * @param {Array} start array of pointers
         * @param {Array} end array of pointers
         * @return {Number} scale
         */
        function getScale(start, end) {
            return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
        }
        var MOUSE_INPUT_MAP = {
            mousedown: INPUT_START,
            mousemove: INPUT_MOVE,
            mouseup: INPUT_END
        };
        var MOUSE_ELEMENT_EVENTS = 'mousedown';
        var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';
        /**
         * Mouse events input
         * @constructor
         * @extends Input
         */
        function MouseInput() {
            this.evEl = MOUSE_ELEMENT_EVENTS;
            this.evWin = MOUSE_WINDOW_EVENTS;
            this.pressed = false; // mousedown state
            Input.apply(this, arguments);
        }
        inherit(MouseInput, Input, {
            /**
             * handle mouse events
             * @param {Object} ev
             */
            handler: function MEhandler(ev) {
                var eventType = MOUSE_INPUT_MAP[ev.type];
                // on start we want to have the left mouse button down
                if (eventType & INPUT_START && ev.button === 0) {
                    this.pressed = true;
                }
                if (eventType & INPUT_MOVE && ev.which !== 1) {
                    eventType = INPUT_END;
                }
                // mouse must be down
                if (!this.pressed) {
                    return;
                }
                if (eventType & INPUT_END) {
                    this.pressed = false;
                }
                this.callback(this.manager, eventType, {
                    pointers: [ev],
                    changedPointers: [ev],
                    pointerType: INPUT_TYPE_MOUSE,
                    srcEvent: ev
                });
            }
        });
        var POINTER_INPUT_MAP = {
            pointerdown: INPUT_START,
            pointermove: INPUT_MOVE,
            pointerup: INPUT_END,
            pointercancel: INPUT_CANCEL,
            pointerout: INPUT_CANCEL
        };
        // in IE10 the pointer types is defined as an enum
        var IE10_POINTER_TYPE_ENUM = {
            2: INPUT_TYPE_TOUCH,
            3: INPUT_TYPE_PEN,
            4: INPUT_TYPE_MOUSE,
            5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816
        };
        var POINTER_ELEMENT_EVENTS = 'pointerdown';
        var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel';
        // IE10 has prefixed support, and case-sensitive
        if (window.MSPointerEvent && !window.PointerEvent) {
            POINTER_ELEMENT_EVENTS = 'MSPointerDown';
            POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
        }
        /**
         * Pointer events input
         * @constructor
         * @extends Input
         */
        function PointerEventInput() {
            this.evEl = POINTER_ELEMENT_EVENTS;
            this.evWin = POINTER_WINDOW_EVENTS;
            Input.apply(this, arguments);
            this.store = (this.manager.session.pointerEvents = []);
        }
        inherit(PointerEventInput, Input, {
            /**
             * handle mouse events
             * @param {Object} ev
             */
            handler: function PEhandler(ev) {
                var store = this.store;
                var removePointer = false;
                var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
                var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
                var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;
                var isTouch = (pointerType == INPUT_TYPE_TOUCH);
                // get index of the event in the store
                var storeIndex = inArray(store, ev.pointerId, 'pointerId');
                // start and mouse must be down
                if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
                    if (storeIndex < 0) {
                        store.push(ev);
                        storeIndex = store.length - 1;
                    }
                }
                else if (eventType & (INPUT_END | INPUT_CANCEL)) {
                    removePointer = true;
                }
                // it not found, so the pointer hasn't been down (so it's probably a hover)
                if (storeIndex < 0) {
                    return;
                }
                // update the event in the store
                store[storeIndex] = ev;
                this.callback(this.manager, eventType, {
                    pointers: store,
                    changedPointers: [ev],
                    pointerType: pointerType,
                    srcEvent: ev
                });
                if (removePointer) {
                    // remove from the store
                    store.splice(storeIndex, 1);
                }
            }
        });
        var SINGLE_TOUCH_INPUT_MAP = {
            touchstart: INPUT_START,
            touchmove: INPUT_MOVE,
            touchend: INPUT_END,
            touchcancel: INPUT_CANCEL
        };
        var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
        var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';
        /**
         * Touch events input
         * @constructor
         * @extends Input
         */
        function SingleTouchInput() {
            this.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
            this.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
            this.started = false;
            Input.apply(this, arguments);
        }
        inherit(SingleTouchInput, Input, {
            handler: function TEhandler(ev) {
                var type = SINGLE_TOUCH_INPUT_MAP[ev.type];
                // should we handle the touch events?
                if (type === INPUT_START) {
                    this.started = true;
                }
                if (!this.started) {
                    return;
                }
                var touches = normalizeSingleTouches.call(this, ev, type);
                // when done, reset the started state
                if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
                    this.started = false;
                }
                this.callback(this.manager, type, {
                    pointers: touches[0],
                    changedPointers: touches[1],
                    pointerType: INPUT_TYPE_TOUCH,
                    srcEvent: ev
                });
            }
        });
        /**
         * @this {TouchInput}
         * @param {Object} ev
         * @param {Number} type flag
         * @returns {undefined|Array} [all, changed]
         */
        function normalizeSingleTouches(ev, type) {
            var all = toArray(ev.touches);
            var changed = toArray(ev.changedTouches);
            if (type & (INPUT_END | INPUT_CANCEL)) {
                all = uniqueArray(all.concat(changed), 'identifier', true);
            }
            return [all, changed];
        }
        var TOUCH_INPUT_MAP = {
            touchstart: INPUT_START,
            touchmove: INPUT_MOVE,
            touchend: INPUT_END,
            touchcancel: INPUT_CANCEL
        };
        var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';
        /**
         * Multi-user touch events input
         * @constructor
         * @extends Input
         */
        function TouchInput() {
            this.evTarget = TOUCH_TARGET_EVENTS;
            this.targetIds = {};
            Input.apply(this, arguments);
        }
        inherit(TouchInput, Input, {
            handler: function MTEhandler(ev) {
                var type = TOUCH_INPUT_MAP[ev.type];
                var touches = getTouches.call(this, ev, type);
                if (!touches) {
                    return;
                }
                this.callback(this.manager, type, {
                    pointers: touches[0],
                    changedPointers: touches[1],
                    pointerType: INPUT_TYPE_TOUCH,
                    srcEvent: ev
                });
            }
        });
        /**
         * @this {TouchInput}
         * @param {Object} ev
         * @param {Number} type flag
         * @returns {undefined|Array} [all, changed]
         */
        function getTouches(ev, type) {
            var allTouches = toArray(ev.touches);
            var targetIds = this.targetIds;
            // when there is only one touch, the process can be simplified
            if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
                targetIds[allTouches[0].identifier] = true;
                return [allTouches, allTouches];
            }
            var i, targetTouches, changedTouches = toArray(ev.changedTouches), changedTargetTouches = [], target = this.target;
            // get target touches from touches
            targetTouches = allTouches.filter(function (touch) {
                return hasParent(touch.target, target);
            });
            // collect touches
            if (type === INPUT_START) {
                i = 0;
                while (i < targetTouches.length) {
                    targetIds[targetTouches[i].identifier] = true;
                    i++;
                }
            }
            // filter changed touches to only contain touches that exist in the collected target ids
            i = 0;
            while (i < changedTouches.length) {
                if (targetIds[changedTouches[i].identifier]) {
                    changedTargetTouches.push(changedTouches[i]);
                }
                // cleanup removed touches
                if (type & (INPUT_END | INPUT_CANCEL)) {
                    delete targetIds[changedTouches[i].identifier];
                }
                i++;
            }
            if (!changedTargetTouches.length) {
                return;
            }
            return [
                // merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
                uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true),
                changedTargetTouches
            ];
        }
        /**
         * Combined touch and mouse input
         *
         * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
         * This because touch devices also emit mouse events while doing a touch.
         *
         * @constructor
         * @extends Input
         */
        var DEDUP_TIMEOUT = 2500;
        var DEDUP_DISTANCE = 25;
        function TouchMouseInput() {
            Input.apply(this, arguments);
            var handler = bindFn(this.handler, this);
            this.touch = new TouchInput(this.manager, handler);
            this.mouse = new MouseInput(this.manager, handler);
            this.primaryTouch = null;
            this.lastTouches = [];
        }
        inherit(TouchMouseInput, Input, {
            /**
             * handle mouse and touch events
             * @param {Hammer} manager
             * @param {String} inputEvent
             * @param {Object} inputData
             */
            handler: function TMEhandler(manager, inputEvent, inputData) {
                var isTouch = (inputData.pointerType == INPUT_TYPE_TOUCH), isMouse = (inputData.pointerType == INPUT_TYPE_MOUSE);
                if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
                    return;
                }
                // when we're in a touch event, record touches to  de-dupe synthetic mouse event
                if (isTouch) {
                    recordTouches.call(this, inputEvent, inputData);
                }
                else if (isMouse && isSyntheticEvent.call(this, inputData)) {
                    return;
                }
                this.callback(manager, inputEvent, inputData);
            },
            /**
             * remove the event listeners
             */
            destroy: function destroy() {
                this.touch.destroy();
                this.mouse.destroy();
            }
        });
        function recordTouches(eventType, eventData) {
            if (eventType & INPUT_START) {
                this.primaryTouch = eventData.changedPointers[0].identifier;
                setLastTouch.call(this, eventData);
            }
            else if (eventType & (INPUT_END | INPUT_CANCEL)) {
                setLastTouch.call(this, eventData);
            }
        }
        function setLastTouch(eventData) {
            var touch = eventData.changedPointers[0];
            if (touch.identifier === this.primaryTouch) {
                var lastTouch = { x: touch.clientX, y: touch.clientY };
                this.lastTouches.push(lastTouch);
                var lts = this.lastTouches;
                var removeLastTouch = function () {
                    var i = lts.indexOf(lastTouch);
                    if (i > -1) {
                        lts.splice(i, 1);
                    }
                };
                setTimeout(removeLastTouch, DEDUP_TIMEOUT);
            }
        }
        function isSyntheticEvent(eventData) {
            var x = eventData.srcEvent.clientX, y = eventData.srcEvent.clientY;
            for (var i = 0; i < this.lastTouches.length; i++) {
                var t = this.lastTouches[i];
                var dx = Math.abs(x - t.x), dy = Math.abs(y - t.y);
                if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
                    return true;
                }
            }
            return false;
        }
        var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
        var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined;
        // magical touchAction value
        var TOUCH_ACTION_COMPUTE = 'compute';
        var TOUCH_ACTION_AUTO = 'auto';
        var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented
        var TOUCH_ACTION_NONE = 'none';
        var TOUCH_ACTION_PAN_X = 'pan-x';
        var TOUCH_ACTION_PAN_Y = 'pan-y';
        var TOUCH_ACTION_MAP = getTouchActionProps();
        /**
         * Touch Action
         * sets the touchAction property or uses the js alternative
         * @param {Manager} manager
         * @param {String} value
         * @constructor
         */
        function TouchAction(manager, value) {
            this.manager = manager;
            this.set(value);
        }
        TouchAction.prototype = {
            /**
             * set the touchAction value on the element or enable the polyfill
             * @param {String} value
             */
            set: function (value) {
                // find out the touch-action by the event handlers
                if (value == TOUCH_ACTION_COMPUTE) {
                    value = this.compute();
                }
                if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
                    this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
                }
                this.actions = value.toLowerCase().trim();
            },
            /**
             * just re-set the touchAction value
             */
            update: function () {
                this.set(this.manager.options.touchAction);
            },
            /**
             * compute the value for the touchAction property based on the recognizer's settings
             * @returns {String} value
             */
            compute: function () {
                var actions = [];
                each(this.manager.recognizers, function (recognizer) {
                    if (boolOrFn(recognizer.options.enable, [recognizer])) {
                        actions = actions.concat(recognizer.getTouchAction());
                    }
                });
                return cleanTouchActions(actions.join(' '));
            },
            /**
             * this method is called on each input cycle and provides the preventing of the browser behavior
             * @param {Object} input
             */
            preventDefaults: function (input) {
                var srcEvent = input.srcEvent;
                var direction = input.offsetDirection;
                // if the touch action did prevented once this session
                if (this.manager.session.prevented) {
                    srcEvent.preventDefault();
                    return;
                }
                var actions = this.actions;
                var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
                var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
                var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];
                if (hasNone) {
                    //do not prevent defaults if this is a tap gesture
                    var isTapPointer = input.pointers.length === 1;
                    var isTapMovement = input.distance < 2;
                    var isTapTouchTime = input.deltaTime < 250;
                    if (isTapPointer && isTapMovement && isTapTouchTime) {
                        return;
                    }
                }
                if (hasPanX && hasPanY) {
                    // `pan-x pan-y` means browser handles all scrolling/panning, do not prevent
                    return;
                }
                if (hasNone ||
                    (hasPanY && direction & DIRECTION_HORIZONTAL) ||
                    (hasPanX && direction & DIRECTION_VERTICAL)) {
                    return this.preventSrc(srcEvent);
                }
            },
            /**
             * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
             * @param {Object} srcEvent
             */
            preventSrc: function (srcEvent) {
                this.manager.session.prevented = true;
                srcEvent.preventDefault();
            }
        };
        /**
         * when the touchActions are collected they are not a valid value, so we need to clean things up. *
         * @param {String} actions
         * @returns {*}
         */
        function cleanTouchActions(actions) {
            // none
            if (inStr(actions, TOUCH_ACTION_NONE)) {
                return TOUCH_ACTION_NONE;
            }
            var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
            var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y);
            // if both pan-x and pan-y are set (different recognizers
            // for different directions, e.g. horizontal pan but vertical swipe?)
            // we need none (as otherwise with pan-x pan-y combined none of these
            // recognizers will work, since the browser would handle all panning
            if (hasPanX && hasPanY) {
                return TOUCH_ACTION_NONE;
            }
            // pan-x OR pan-y
            if (hasPanX || hasPanY) {
                return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
            }
            // manipulation
            if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
                return TOUCH_ACTION_MANIPULATION;
            }
            return TOUCH_ACTION_AUTO;
        }
        function getTouchActionProps() {
            if (!NATIVE_TOUCH_ACTION) {
                return false;
            }
            var touchMap = {};
            var cssSupports = window.CSS && window.CSS.supports;
            ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function (val) {
                // If css.supports is not supported but there is native touch-action assume it supports
                // all values. This is the case for IE 10 and 11.
                touchMap[val] = cssSupports ? window.CSS.supports('touch-action', val) : true;
            });
            return touchMap;
        }
        /**
         * Recognizer flow explained; *
         * All recognizers have the initial state of POSSIBLE when a input session starts.
         * The definition of a input session is from the first input until the last input, with all it's movement in it. *
         * Example session for mouse-input: mousedown -> mousemove -> mouseup
         *
         * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
         * which determines with state it should be.
         *
         * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
         * POSSIBLE to give it another change on the next cycle.
         *
         *               Possible
         *                  |
         *            +-----+---------------+
         *            |                     |
         *      +-----+-----+               |
         *      |           |               |
         *   Failed      Cancelled          |
         *                          +-------+------+
         *                          |              |
         *                      Recognized       Began
         *                                         |
         *                                      Changed
         *                                         |
         *                                  Ended/Recognized
         */
        var STATE_POSSIBLE = 1;
        var STATE_BEGAN = 2;
        var STATE_CHANGED = 4;
        var STATE_ENDED = 8;
        var STATE_RECOGNIZED = STATE_ENDED;
        var STATE_CANCELLED = 16;
        var STATE_FAILED = 32;
        /**
         * Recognizer
         * Every recognizer needs to extend from this class.
         * @constructor
         * @param {Object} options
         */
        function Recognizer(options) {
            this.options = assign({}, this.defaults, options || {});
            this.id = uniqueId();
            this.manager = null;
            // default is enable true
            this.options.enable = ifUndefined(this.options.enable, true);
            this.state = STATE_POSSIBLE;
            this.simultaneous = {};
            this.requireFail = [];
        }
        Recognizer.prototype = {
            /**
             * @virtual
             * @type {Object}
             */
            defaults: {},
            /**
             * set options
             * @param {Object} options
             * @return {Recognizer}
             */
            set: function (options) {
                assign(this.options, options);
                // also update the touchAction, in case something changed about the directions/enabled state
                this.manager && this.manager.touchAction.update();
                return this;
            },
            /**
             * recognize simultaneous with an other recognizer.
             * @param {Recognizer} otherRecognizer
             * @returns {Recognizer} this
             */
            recognizeWith: function (otherRecognizer) {
                if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
                    return this;
                }
                var simultaneous = this.simultaneous;
                otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
                if (!simultaneous[otherRecognizer.id]) {
                    simultaneous[otherRecognizer.id] = otherRecognizer;
                    otherRecognizer.recognizeWith(this);
                }
                return this;
            },
            /**
             * drop the simultaneous link. it doesnt remove the link on the other recognizer.
             * @param {Recognizer} otherRecognizer
             * @returns {Recognizer} this
             */
            dropRecognizeWith: function (otherRecognizer) {
                if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
                    return this;
                }
                otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
                delete this.simultaneous[otherRecognizer.id];
                return this;
            },
            /**
             * recognizer can only run when an other is failing
             * @param {Recognizer} otherRecognizer
             * @returns {Recognizer} this
             */
            requireFailure: function (otherRecognizer) {
                if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
                    return this;
                }
                var requireFail = this.requireFail;
                otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
                if (inArray(requireFail, otherRecognizer) === -1) {
                    requireFail.push(otherRecognizer);
                    otherRecognizer.requireFailure(this);
                }
                return this;
            },
            /**
             * drop the requireFailure link. it does not remove the link on the other recognizer.
             * @param {Recognizer} otherRecognizer
             * @returns {Recognizer} this
             */
            dropRequireFailure: function (otherRecognizer) {
                if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
                    return this;
                }
                otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
                var index = inArray(this.requireFail, otherRecognizer);
                if (index > -1) {
                    this.requireFail.splice(index, 1);
                }
                return this;
            },
            /**
             * has require failures boolean
             * @returns {boolean}
             */
            hasRequireFailures: function () {
                return this.requireFail.length > 0;
            },
            /**
             * if the recognizer can recognize simultaneous with an other recognizer
             * @param {Recognizer} otherRecognizer
             * @returns {Boolean}
             */
            canRecognizeWith: function (otherRecognizer) {
                return !!this.simultaneous[otherRecognizer.id];
            },
            /**
             * You should use `tryEmit` instead of `emit` directly to check
             * that all the needed recognizers has failed before emitting.
             * @param {Object} input
             */
            emit: function (input) {
                var self = this;
                var state = this.state;
                function emit(event) {
                    self.manager.emit(event, input);
                }
                // 'panstart' and 'panmove'
                if (state < STATE_ENDED) {
                    emit(self.options.event + stateStr(state));
                }
                emit(self.options.event); // simple 'eventName' events
                if (input.additionalEvent) { // additional event(panleft, panright, pinchin, pinchout...)
                    emit(input.additionalEvent);
                }
                // panend and pancancel
                if (state >= STATE_ENDED) {
                    emit(self.options.event + stateStr(state));
                }
            },
            /**
             * Check that all the require failure recognizers has failed,
             * if true, it emits a gesture event,
             * otherwise, setup the state to FAILED.
             * @param {Object} input
             */
            tryEmit: function (input) {
                if (this.canEmit()) {
                    return this.emit(input);
                }
                // it's failing anyway
                this.state = STATE_FAILED;
            },
            /**
             * can we emit?
             * @returns {boolean}
             */
            canEmit: function () {
                var i = 0;
                while (i < this.requireFail.length) {
                    if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
                        return false;
                    }
                    i++;
                }
                return true;
            },
            /**
             * update the recognizer
             * @param {Object} inputData
             */
            recognize: function (inputData) {
                // make a new copy of the inputData
                // so we can change the inputData without messing up the other recognizers
                var inputDataClone = assign({}, inputData);
                // is is enabled and allow recognizing?
                if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
                    this.reset();
                    this.state = STATE_FAILED;
                    return;
                }
                // reset when we've reached the end
                if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
                    this.state = STATE_POSSIBLE;
                }
                this.state = this.process(inputDataClone);
                // the recognizer has recognized a gesture
                // so trigger an event
                if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
                    this.tryEmit(inputDataClone);
                }
            },
            /**
             * return the state of the recognizer
             * the actual recognizing happens in this method
             * @virtual
             * @param {Object} inputData
             * @returns {Const} STATE
             */
            process: function (inputData) { },
            /**
             * return the preferred touch-action
             * @virtual
             * @returns {Array}
             */
            getTouchAction: function () { },
            /**
             * called when the gesture isn't allowed to recognize
             * like when another is being recognized or it is disabled
             * @virtual
             */
            reset: function () { }
        };
        /**
         * get a usable string, used as event postfix
         * @param {Const} state
         * @returns {String} state
         */
        function stateStr(state) {
            if (state & STATE_CANCELLED) {
                return 'cancel';
            }
            else if (state & STATE_ENDED) {
                return 'end';
            }
            else if (state & STATE_CHANGED) {
                return 'move';
            }
            else if (state & STATE_BEGAN) {
                return 'start';
            }
            return '';
        }
        /**
         * direction cons to string
         * @param {Const} direction
         * @returns {String}
         */
        function directionStr(direction) {
            if (direction == DIRECTION_DOWN) {
                return 'down';
            }
            else if (direction == DIRECTION_UP) {
                return 'up';
            }
            else if (direction == DIRECTION_LEFT) {
                return 'left';
            }
            else if (direction == DIRECTION_RIGHT) {
                return 'right';
            }
            return '';
        }
        /**
         * get a recognizer by name if it is bound to a manager
         * @param {Recognizer|String} otherRecognizer
         * @param {Recognizer} recognizer
         * @returns {Recognizer}
         */
        function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
            var manager = recognizer.manager;
            if (manager) {
                return manager.get(otherRecognizer);
            }
            return otherRecognizer;
        }
        /**
         * This recognizer is just used as a base for the simple attribute recognizers.
         * @constructor
         * @extends Recognizer
         */
        function AttrRecognizer() {
            Recognizer.apply(this, arguments);
        }
        inherit(AttrRecognizer, Recognizer, {
            /**
             * @namespace
             * @memberof AttrRecognizer
             */
            defaults: {
                /**
                 * @type {Number}
                 * @default 1
                 */
                pointers: 1
            },
            /**
             * Used to check if it the recognizer receives valid input, like input.distance > 10.
             * @memberof AttrRecognizer
             * @param {Object} input
             * @returns {Boolean} recognized
             */
            attrTest: function (input) {
                var optionPointers = this.options.pointers;
                return optionPointers === 0 || input.pointers.length === optionPointers;
            },
            /**
             * Process the input and return the state for the recognizer
             * @memberof AttrRecognizer
             * @param {Object} input
             * @returns {*} State
             */
            process: function (input) {
                var state = this.state;
                var eventType = input.eventType;
                var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
                var isValid = this.attrTest(input);
                // on cancel input and we've recognized before, return STATE_CANCELLED
                if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
                    return state | STATE_CANCELLED;
                }
                else if (isRecognized || isValid) {
                    if (eventType & INPUT_END) {
                        return state | STATE_ENDED;
                    }
                    else if (!(state & STATE_BEGAN)) {
                        return STATE_BEGAN;
                    }
                    return state | STATE_CHANGED;
                }
                return STATE_FAILED;
            }
        });
        /**
         * Pan
         * Recognized when the pointer is down and moved in the allowed direction.
         * @constructor
         * @extends AttrRecognizer
         */
        function PanRecognizer() {
            AttrRecognizer.apply(this, arguments);
            this.pX = null;
            this.pY = null;
        }
        inherit(PanRecognizer, AttrRecognizer, {
            /**
             * @namespace
             * @memberof PanRecognizer
             */
            defaults: {
                event: 'pan',
                threshold: 10,
                pointers: 1,
                direction: DIRECTION_ALL
            },
            getTouchAction: function () {
                var direction = this.options.direction;
                var actions = [];
                if (direction & DIRECTION_HORIZONTAL) {
                    actions.push(TOUCH_ACTION_PAN_Y);
                }
                if (direction & DIRECTION_VERTICAL) {
                    actions.push(TOUCH_ACTION_PAN_X);
                }
                return actions;
            },
            directionTest: function (input) {
                var options = this.options;
                var hasMoved = true;
                var distance = input.distance;
                var direction = input.direction;
                var x = input.deltaX;
                var y = input.deltaY;
                // lock to axis?
                if (!(direction & options.direction)) {
                    if (options.direction & DIRECTION_HORIZONTAL) {
                        direction = (x === 0) ? DIRECTION_NONE : (x < 0) ? DIRECTION_LEFT : DIRECTION_RIGHT;
                        hasMoved = x != this.pX;
                        distance = Math.abs(input.deltaX);
                    }
                    else {
                        direction = (y === 0) ? DIRECTION_NONE : (y < 0) ? DIRECTION_UP : DIRECTION_DOWN;
                        hasMoved = y != this.pY;
                        distance = Math.abs(input.deltaY);
                    }
                }
                input.direction = direction;
                return hasMoved && distance > options.threshold && direction & options.direction;
            },
            attrTest: function (input) {
                return AttrRecognizer.prototype.attrTest.call(this, input) &&
                    (this.state & STATE_BEGAN || (!(this.state & STATE_BEGAN) && this.directionTest(input)));
            },
            emit: function (input) {
                this.pX = input.deltaX;
                this.pY = input.deltaY;
                var direction = directionStr(input.direction);
                if (direction) {
                    input.additionalEvent = this.options.event + direction;
                }
                this._super.emit.call(this, input);
            }
        });
        /**
         * Pinch
         * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
         * @constructor
         * @extends AttrRecognizer
         */
        function PinchRecognizer() {
            AttrRecognizer.apply(this, arguments);
        }
        inherit(PinchRecognizer, AttrRecognizer, {
            /**
             * @namespace
             * @memberof PinchRecognizer
             */
            defaults: {
                event: 'pinch',
                threshold: 0,
                pointers: 2
            },
            getTouchAction: function () {
                return [TOUCH_ACTION_NONE];
            },
            attrTest: function (input) {
                return this._super.attrTest.call(this, input) &&
                    (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
            },
            emit: function (input) {
                if (input.scale !== 1) {
                    var inOut = input.scale < 1 ? 'in' : 'out';
                    input.additionalEvent = this.options.event + inOut;
                }
                this._super.emit.call(this, input);
            }
        });
        /**
         * Press
         * Recognized when the pointer is down for x ms without any movement.
         * @constructor
         * @extends Recognizer
         */
        function PressRecognizer() {
            Recognizer.apply(this, arguments);
            this._timer = null;
            this._input = null;
        }
        inherit(PressRecognizer, Recognizer, {
            /**
             * @namespace
             * @memberof PressRecognizer
             */
            defaults: {
                event: 'press',
                pointers: 1,
                time: 251,
                threshold: 9 // a minimal movement is ok, but keep it low
            },
            getTouchAction: function () {
                return [TOUCH_ACTION_AUTO];
            },
            process: function (input) {
                var options = this.options;
                var validPointers = input.pointers.length === options.pointers;
                var validMovement = input.distance < options.threshold;
                var validTime = input.deltaTime > options.time;
                this._input = input;
                // we only allow little movement
                // and we've reached an end event, so a tap is possible
                if (!validMovement || !validPointers || (input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime)) {
                    this.reset();
                }
                else if (input.eventType & INPUT_START) {
                    this.reset();
                    this._timer = setTimeoutContext(function () {
                        this.state = STATE_RECOGNIZED;
                        this.tryEmit();
                    }, options.time, this);
                }
                else if (input.eventType & INPUT_END) {
                    return STATE_RECOGNIZED;
                }
                return STATE_FAILED;
            },
            reset: function () {
                clearTimeout(this._timer);
            },
            emit: function (input) {
                if (this.state !== STATE_RECOGNIZED) {
                    return;
                }
                if (input && (input.eventType & INPUT_END)) {
                    this.manager.emit(this.options.event + 'up', input);
                }
                else {
                    this._input.timeStamp = now();
                    this.manager.emit(this.options.event, this._input);
                }
            }
        });
        /**
         * Rotate
         * Recognized when two or more pointer are moving in a circular motion.
         * @constructor
         * @extends AttrRecognizer
         */
        function RotateRecognizer() {
            AttrRecognizer.apply(this, arguments);
        }
        inherit(RotateRecognizer, AttrRecognizer, {
            /**
             * @namespace
             * @memberof RotateRecognizer
             */
            defaults: {
                event: 'rotate',
                threshold: 0,
                pointers: 2
            },
            getTouchAction: function () {
                return [TOUCH_ACTION_NONE];
            },
            attrTest: function (input) {
                return this._super.attrTest.call(this, input) &&
                    (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
            }
        });
        /**
         * Swipe
         * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
         * @constructor
         * @extends AttrRecognizer
         */
        function SwipeRecognizer() {
            AttrRecognizer.apply(this, arguments);
        }
        inherit(SwipeRecognizer, AttrRecognizer, {
            /**
             * @namespace
             * @memberof SwipeRecognizer
             */
            defaults: {
                event: 'swipe',
                threshold: 10,
                velocity: 0.3,
                direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
                pointers: 1
            },
            getTouchAction: function () {
                return PanRecognizer.prototype.getTouchAction.call(this);
            },
            attrTest: function (input) {
                var direction = this.options.direction;
                var velocity;
                if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
                    velocity = input.overallVelocity;
                }
                else if (direction & DIRECTION_HORIZONTAL) {
                    velocity = input.overallVelocityX;
                }
                else if (direction & DIRECTION_VERTICAL) {
                    velocity = input.overallVelocityY;
                }
                return this._super.attrTest.call(this, input) &&
                    direction & input.offsetDirection &&
                    input.distance > this.options.threshold &&
                    input.maxPointers == this.options.pointers &&
                    abs(velocity) > this.options.velocity && input.eventType & INPUT_END;
            },
            emit: function (input) {
                var direction = directionStr(input.offsetDirection);
                if (direction) {
                    this.manager.emit(this.options.event + direction, input);
                }
                this.manager.emit(this.options.event, input);
            }
        });
        /**
         * A tap is ecognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
         * between the given interval and position. The delay option can be used to recognize multi-taps without firing
         * a single tap.
         *
         * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
         * multi-taps being recognized.
         * @constructor
         * @extends Recognizer
         */
        function TapRecognizer() {
            Recognizer.apply(this, arguments);
            // previous time and center,
            // used for tap counting
            this.pTime = false;
            this.pCenter = false;
            this._timer = null;
            this._input = null;
            this.count = 0;
        }
        inherit(TapRecognizer, Recognizer, {
            /**
             * @namespace
             * @memberof PinchRecognizer
             */
            defaults: {
                event: 'tap',
                pointers: 1,
                taps: 1,
                interval: 300,
                time: 250,
                threshold: 9,
                posThreshold: 10 // a multi-tap can be a bit off the initial position
            },
            getTouchAction: function () {
                return [TOUCH_ACTION_MANIPULATION];
            },
            process: function (input) {
                var options = this.options;
                var validPointers = input.pointers.length === options.pointers;
                var validMovement = input.distance < options.threshold;
                var validTouchTime = input.deltaTime < options.time;
                this.reset();
                if ((input.eventType & INPUT_START) && (this.count === 0)) {
                    return this.failTimeout();
                }
                // we only allow little movement
                // and we've reached an end event, so a tap is possible
                if (validMovement && validTouchTime && validPointers) {
                    if (input.eventType != INPUT_END) {
                        return this.failTimeout();
                    }
                    var validInterval = this.pTime ? (input.timeStamp - this.pTime < options.interval) : true;
                    var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;
                    this.pTime = input.timeStamp;
                    this.pCenter = input.center;
                    if (!validMultiTap || !validInterval) {
                        this.count = 1;
                    }
                    else {
                        this.count += 1;
                    }
                    this._input = input;
                    // if tap count matches we have recognized it,
                    // else it has began recognizing...
                    var tapCount = this.count % options.taps;
                    if (tapCount === 0) {
                        // no failing requirements, immediately trigger the tap event
                        // or wait as long as the multitap interval to trigger
                        if (!this.hasRequireFailures()) {
                            return STATE_RECOGNIZED;
                        }
                        else {
                            this._timer = setTimeoutContext(function () {
                                this.state = STATE_RECOGNIZED;
                                this.tryEmit();
                            }, options.interval, this);
                            return STATE_BEGAN;
                        }
                    }
                }
                return STATE_FAILED;
            },
            failTimeout: function () {
                this._timer = setTimeoutContext(function () {
                    this.state = STATE_FAILED;
                }, this.options.interval, this);
                return STATE_FAILED;
            },
            reset: function () {
                clearTimeout(this._timer);
            },
            emit: function () {
                if (this.state == STATE_RECOGNIZED) {
                    this._input.tapCount = this.count;
                    this.manager.emit(this.options.event, this._input);
                }
            }
        });
        /**
         * Simple way to create a manager with a default set of recognizers.
         * @param {HTMLElement} element
         * @param {Object} [options]
         * @constructor
         */
        function Hammer(element, options) {
            options = options || {};
            options.recognizers = ifUndefined(options.recognizers, Hammer.defaults.preset);
            return new Manager(element, options);
        }
        /**
         * @const {string}
         */
        Hammer.VERSION = '2.0.7';
        /**
         * default settings
         * @namespace
         */
        Hammer.defaults = {
            /**
             * set if DOM events are being triggered.
             * But this is slower and unused by simple implementations, so disabled by default.
             * @type {Boolean}
             * @default false
             */
            domEvents: false,
            /**
             * The value for the touchAction property/fallback.
             * When set to `compute` it will magically set the correct value based on the added recognizers.
             * @type {String}
             * @default compute
             */
            touchAction: TOUCH_ACTION_COMPUTE,
            /**
             * @type {Boolean}
             * @default true
             */
            enable: true,
            /**
             * EXPERIMENTAL FEATURE -- can be removed/changed
             * Change the parent input target element.
             * If Null, then it is being set the to main element.
             * @type {Null|EventTarget}
             * @default null
             */
            inputTarget: null,
            /**
             * force an input class
             * @type {Null|Function}
             * @default null
             */
            inputClass: null,
            /**
             * Default recognizer setup when calling `Hammer()`
             * When creating a new Manager these will be skipped.
             * @type {Array}
             */
            preset: [
                // RecognizerClass, options, [recognizeWith, ...], [requireFailure, ...]
                [RotateRecognizer, { enable: false }],
                [PinchRecognizer, { enable: false }, ['rotate']],
                [SwipeRecognizer, { direction: DIRECTION_HORIZONTAL }],
                [PanRecognizer, { direction: DIRECTION_HORIZONTAL }, ['swipe']],
                [TapRecognizer],
                [TapRecognizer, { event: 'doubletap', taps: 2 }, ['tap']],
                [PressRecognizer]
            ],
            /**
             * Some CSS properties can be used to improve the working of Hammer.
             * Add them to this method and they will be set when creating a new Manager.
             * @namespace
             */
            cssProps: {
                /**
                 * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
                 * @type {String}
                 * @default 'none'
                 */
                userSelect: 'none',
                /**
                 * Disable the Windows Phone grippers when pressing an element.
                 * @type {String}
                 * @default 'none'
                 */
                touchSelect: 'none',
                /**
                 * Disables the default callout shown when you touch and hold a touch target.
                 * On iOS, when you touch and hold a touch target such as a link, Safari displays
                 * a callout containing information about the link. This property allows you to disable that callout.
                 * @type {String}
                 * @default 'none'
                 */
                touchCallout: 'none',
                /**
                 * Specifies whether zooming is enabled. Used by IE10>
                 * @type {String}
                 * @default 'none'
                 */
                contentZooming: 'none',
                /**
                 * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
                 * @type {String}
                 * @default 'none'
                 */
                userDrag: 'none',
                /**
                 * Overrides the highlight color shown when the user taps a link or a JavaScript
                 * clickable element in iOS. This property obeys the alpha value, if specified.
                 * @type {String}
                 * @default 'rgba(0,0,0,0)'
                 */
                tapHighlightColor: 'rgba(0,0,0,0)'
            }
        };
        var STOP = 1;
        var FORCED_STOP = 2;
        /**
         * Manager
         * @param {HTMLElement} element
         * @param {Object} [options]
         * @constructor
         */
        function Manager(element, options) {
            this.options = assign({}, Hammer.defaults, options || {});
            this.options.inputTarget = this.options.inputTarget || element;
            this.handlers = {};
            this.session = {};
            this.recognizers = [];
            this.oldCssProps = {};
            this.element = element;
            this.input = createInputInstance(this);
            this.touchAction = new TouchAction(this, this.options.touchAction);
            toggleCssProps(this, true);
            each(this.options.recognizers, function (item) {
                var recognizer = this.add(new (item[0])(item[1]));
                item[2] && recognizer.recognizeWith(item[2]);
                item[3] && recognizer.requireFailure(item[3]);
            }, this);
        }
        Manager.prototype = {
            /**
             * set options
             * @param {Object} options
             * @returns {Manager}
             */
            set: function (options) {
                assign(this.options, options);
                // Options that need a little more setup
                if (options.touchAction) {
                    this.touchAction.update();
                }
                if (options.inputTarget) {
                    // Clean up existing event listeners and reinitialize
                    this.input.destroy();
                    this.input.target = options.inputTarget;
                    this.input.init();
                }
                return this;
            },
            /**
             * stop recognizing for this session.
             * This session will be discarded, when a new [input]start event is fired.
             * When forced, the recognizer cycle is stopped immediately.
             * @param {Boolean} [force]
             */
            stop: function (force) {
                this.session.stopped = force ? FORCED_STOP : STOP;
            },
            /**
             * run the recognizers!
             * called by the inputHandler function on every movement of the pointers (touches)
             * it walks through all the recognizers and tries to detect the gesture that is being made
             * @param {Object} inputData
             */
            recognize: function (inputData) {
                var session = this.session;
                if (session.stopped) {
                    return;
                }
                // run the touch-action polyfill
                this.touchAction.preventDefaults(inputData);
                var recognizer;
                var recognizers = this.recognizers;
                // this holds the recognizer that is being recognized.
                // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
                // if no recognizer is detecting a thing, it is set to `null`
                var curRecognizer = session.curRecognizer;
                // reset when the last recognizer is recognized
                // or when we're in a new session
                if (!curRecognizer || (curRecognizer && curRecognizer.state & STATE_RECOGNIZED)) {
                    curRecognizer = session.curRecognizer = null;
                }
                var i = 0;
                while (i < recognizers.length) {
                    recognizer = recognizers[i];
                    // find out if we are allowed try to recognize the input for this one.
                    // 1.   allow if the session is NOT forced stopped (see the .stop() method)
                    // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
                    //      that is being recognized.
                    // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
                    //      this can be setup with the `recognizeWith()` method on the recognizer.
                    if (session.stopped !== FORCED_STOP && ( // 1
                    !curRecognizer || recognizer == curRecognizer || // 2
                        recognizer.canRecognizeWith(curRecognizer))) { // 3
                        recognizer.recognize(inputData);
                    }
                    else {
                        recognizer.reset();
                    }
                    // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
                    // current active recognizer. but only if we don't already have an active recognizer
                    if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
                        curRecognizer = session.curRecognizer = recognizer;
                    }
                    i++;
                }
            },
            /**
             * get a recognizer by its event name.
             * @param {Recognizer|String} recognizer
             * @returns {Recognizer|Null}
             */
            get: function (recognizer) {
                if (recognizer instanceof Recognizer) {
                    return recognizer;
                }
                var recognizers = this.recognizers;
                for (var i = 0; i < recognizers.length; i++) {
                    if (recognizers[i].options.event == recognizer) {
                        return recognizers[i];
                    }
                }
                return null;
            },
            /**
             * add a recognizer to the manager
             * existing recognizers with the same event name will be removed
             * @param {Recognizer} recognizer
             * @returns {Recognizer|Manager}
             */
            add: function (recognizer) {
                if (invokeArrayArg(recognizer, 'add', this)) {
                    return this;
                }
                // remove existing
                var existing = this.get(recognizer.options.event);
                if (existing) {
                    this.remove(existing);
                }
                this.recognizers.push(recognizer);
                recognizer.manager = this;
                this.touchAction.update();
                return recognizer;
            },
            /**
             * remove a recognizer by name or instance
             * @param {Recognizer|String} recognizer
             * @returns {Manager}
             */
            remove: function (recognizer) {
                if (invokeArrayArg(recognizer, 'remove', this)) {
                    return this;
                }
                recognizer = this.get(recognizer);
                // let's make sure this recognizer exists
                if (recognizer) {
                    var recognizers = this.recognizers;
                    var index = inArray(recognizers, recognizer);
                    if (index !== -1) {
                        recognizers.splice(index, 1);
                        this.touchAction.update();
                    }
                }
                return this;
            },
            /**
             * bind event
             * @param {String} events
             * @param {Function} handler
             * @returns {EventEmitter} this
             */
            on: function (events, handler) {
                if (events === undefined) {
                    return;
                }
                if (handler === undefined) {
                    return;
                }
                var handlers = this.handlers;
                each(splitStr(events), function (event) {
                    handlers[event] = handlers[event] || [];
                    handlers[event].push(handler);
                });
                return this;
            },
            /**
             * unbind event, leave emit blank to remove all handlers
             * @param {String} events
             * @param {Function} [handler]
             * @returns {EventEmitter} this
             */
            off: function (events, handler) {
                if (events === undefined) {
                    return;
                }
                var handlers = this.handlers;
                each(splitStr(events), function (event) {
                    if (!handler) {
                        delete handlers[event];
                    }
                    else {
                        handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
                    }
                });
                return this;
            },
            /**
             * emit event to the listeners
             * @param {String} event
             * @param {Object} data
             */
            emit: function (event, data) {
                // we also want to trigger dom events
                if (this.options.domEvents) {
                    triggerDomEvent(event, data);
                }
                // no handlers, so skip it all
                var handlers = this.handlers[event] && this.handlers[event].slice();
                if (!handlers || !handlers.length) {
                    return;
                }
                data.type = event;
                data.preventDefault = function () {
                    data.srcEvent.preventDefault();
                };
                var i = 0;
                while (i < handlers.length) {
                    handlers[i](data);
                    i++;
                }
            },
            /**
             * destroy the manager and unbinds all events
             * it doesn't unbind dom events, that is the user own responsibility
             */
            destroy: function () {
                this.element && toggleCssProps(this, false);
                this.handlers = {};
                this.session = {};
                this.input.destroy();
                this.element = null;
            }
        };
        /**
         * add/remove the css properties as defined in manager.options.cssProps
         * @param {Manager} manager
         * @param {Boolean} add
         */
        function toggleCssProps(manager, add) {
            var element = manager.element;
            if (!element.style) {
                return;
            }
            var prop;
            each(manager.options.cssProps, function (value, name) {
                prop = prefixed(element.style, name);
                if (add) {
                    manager.oldCssProps[prop] = element.style[prop];
                    element.style[prop] = value;
                }
                else {
                    element.style[prop] = manager.oldCssProps[prop] || '';
                }
            });
            if (!add) {
                manager.oldCssProps = {};
            }
        }
        /**
         * trigger dom event
         * @param {String} event
         * @param {Object} data
         */
        function triggerDomEvent(event, data) {
            var gestureEvent = document.createEvent('Event');
            gestureEvent.initEvent(event, true, true);
            gestureEvent.gesture = data;
            data.target.dispatchEvent(gestureEvent);
        }
        assign(Hammer, {
            INPUT_START: INPUT_START,
            INPUT_MOVE: INPUT_MOVE,
            INPUT_END: INPUT_END,
            INPUT_CANCEL: INPUT_CANCEL,
            STATE_POSSIBLE: STATE_POSSIBLE,
            STATE_BEGAN: STATE_BEGAN,
            STATE_CHANGED: STATE_CHANGED,
            STATE_ENDED: STATE_ENDED,
            STATE_RECOGNIZED: STATE_RECOGNIZED,
            STATE_CANCELLED: STATE_CANCELLED,
            STATE_FAILED: STATE_FAILED,
            DIRECTION_NONE: DIRECTION_NONE,
            DIRECTION_LEFT: DIRECTION_LEFT,
            DIRECTION_RIGHT: DIRECTION_RIGHT,
            DIRECTION_UP: DIRECTION_UP,
            DIRECTION_DOWN: DIRECTION_DOWN,
            DIRECTION_HORIZONTAL: DIRECTION_HORIZONTAL,
            DIRECTION_VERTICAL: DIRECTION_VERTICAL,
            DIRECTION_ALL: DIRECTION_ALL,
            Manager: Manager,
            Input: Input,
            TouchAction: TouchAction,
            TouchInput: TouchInput,
            MouseInput: MouseInput,
            PointerEventInput: PointerEventInput,
            TouchMouseInput: TouchMouseInput,
            SingleTouchInput: SingleTouchInput,
            Recognizer: Recognizer,
            AttrRecognizer: AttrRecognizer,
            Tap: TapRecognizer,
            Pan: PanRecognizer,
            Swipe: SwipeRecognizer,
            Pinch: PinchRecognizer,
            Rotate: RotateRecognizer,
            Press: PressRecognizer,
            on: addEventListeners,
            off: removeEventListeners,
            each: each,
            merge: merge,
            extend: extend,
            assign: assign,
            inherit: inherit,
            bindFn: bindFn,
            prefixed: prefixed
        });
        // this prevents errors when Hammer is loaded in the presence of an AMD
        //  style loader but by script tag, not by the loader.
        var freeGlobal = (typeof window !== 'undefined' ? window : (typeof self !== 'undefined' ? self : {})); // jshint ignore:line
        freeGlobal.Hammer = Hammer;
        if (typeof define === 'function' && define.amd) {
            define(function () {
                return Hammer;
            });
        }
        else if (typeof module != 'undefined' && module.exports) {
            module.exports = Hammer;
        }
        else {
            window[exportName] = Hammer;
        }
    })(window, document, 'Hammer');
},
/* core/bokeh_events.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    function event(event_name) {
        return function (cls) {
            cls.prototype.event_name = event_name;
        };
    }
    class BokehEvent {
        to_json() {
            const { event_name } = this;
            return { event_name, event_values: this._to_json() };
        }
    }
    exports.BokehEvent = BokehEvent;
    BokehEvent.__name__ = "BokehEvent";
    class ModelEvent extends BokehEvent {
        constructor() {
            super(...arguments);
            this.origin = null;
        }
        _to_json() {
            return { model: this.origin };
        }
    }
    exports.ModelEvent = ModelEvent;
    ModelEvent.__name__ = "ModelEvent";
    let DocumentReady = class DocumentReady extends BokehEvent {
        _to_json() {
            return {};
        }
    };
    exports.DocumentReady = DocumentReady;
    DocumentReady.__name__ = "DocumentReady";
    exports.DocumentReady = DocumentReady = __decorate([
        event("document_ready")
    ], DocumentReady);
    let ButtonClick = class ButtonClick extends ModelEvent {
    };
    exports.ButtonClick = ButtonClick;
    ButtonClick.__name__ = "ButtonClick";
    exports.ButtonClick = ButtonClick = __decorate([
        event("button_click")
    ], ButtonClick);
    let MenuItemClick = class MenuItemClick extends ModelEvent {
        constructor(item) {
            super();
            this.item = item;
        }
        _to_json() {
            const { item } = this;
            return Object.assign(Object.assign({}, super._to_json()), { item });
        }
    };
    exports.MenuItemClick = MenuItemClick;
    MenuItemClick.__name__ = "MenuItemClick";
    exports.MenuItemClick = MenuItemClick = __decorate([
        event("menu_item_click")
    ], MenuItemClick);
    // A UIEvent is an event originating on a canvas this includes.
    // DOM events such as keystrokes as well as hammer events and LOD events.
    class UIEvent extends ModelEvent {
    }
    exports.UIEvent = UIEvent;
    UIEvent.__name__ = "UIEvent";
    let LODStart = class LODStart extends UIEvent {
    };
    exports.LODStart = LODStart;
    LODStart.__name__ = "LODStart";
    exports.LODStart = LODStart = __decorate([
        event("lodstart")
    ], LODStart);
    let LODEnd = class LODEnd extends UIEvent {
    };
    exports.LODEnd = LODEnd;
    LODEnd.__name__ = "LODEnd";
    exports.LODEnd = LODEnd = __decorate([
        event("lodend")
    ], LODEnd);
    let SelectionGeometry = class SelectionGeometry extends UIEvent {
        constructor(geometry, final) {
            super();
            this.geometry = geometry;
            this.final = final;
        }
        _to_json() {
            const { geometry, final } = this;
            return Object.assign(Object.assign({}, super._to_json()), { geometry, final });
        }
    };
    exports.SelectionGeometry = SelectionGeometry;
    SelectionGeometry.__name__ = "SelectionGeometry";
    exports.SelectionGeometry = SelectionGeometry = __decorate([
        event("selectiongeometry")
    ], SelectionGeometry);
    let Reset = class Reset extends UIEvent {
    };
    exports.Reset = Reset;
    Reset.__name__ = "Reset";
    exports.Reset = Reset = __decorate([
        event("reset")
    ], Reset);
    class PointEvent extends UIEvent {
        constructor(sx, sy, x, y) {
            super();
            this.sx = sx;
            this.sy = sy;
            this.x = x;
            this.y = y;
        }
        _to_json() {
            const { sx, sy, x, y } = this;
            return Object.assign(Object.assign({}, super._to_json()), { sx, sy, x, y });
        }
    }
    exports.PointEvent = PointEvent;
    PointEvent.__name__ = "PointEvent";
    let Pan = class Pan extends PointEvent {
        /* TODO: direction: -1 | 1 */
        constructor(sx, sy, x, y, delta_x, delta_y) {
            super(sx, sy, x, y);
            this.sx = sx;
            this.sy = sy;
            this.x = x;
            this.y = y;
            this.delta_x = delta_x;
            this.delta_y = delta_y;
        }
        _to_json() {
            const { delta_x, delta_y /*, direction*/ } = this;
            return Object.assign(Object.assign({}, super._to_json()), { delta_x, delta_y /*, direction*/ });
        }
    };
    exports.Pan = Pan;
    Pan.__name__ = "Pan";
    exports.Pan = Pan = __decorate([
        event("pan")
    ], Pan);
    let Pinch = class Pinch extends PointEvent {
        constructor(sx, sy, x, y, scale) {
            super(sx, sy, x, y);
            this.sx = sx;
            this.sy = sy;
            this.x = x;
            this.y = y;
            this.scale = scale;
        }
        _to_json() {
            const { scale } = this;
            return Object.assign(Object.assign({}, super._to_json()), { scale });
        }
    };
    exports.Pinch = Pinch;
    Pinch.__name__ = "Pinch";
    exports.Pinch = Pinch = __decorate([
        event("pinch")
    ], Pinch);
    let Rotate = class Rotate extends PointEvent {
        constructor(sx, sy, x, y, rotation) {
            super(sx, sy, x, y);
            this.sx = sx;
            this.sy = sy;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
        }
        _to_json() {
            const { rotation } = this;
            return Object.assign(Object.assign({}, super._to_json()), { rotation });
        }
    };
    exports.Rotate = Rotate;
    Rotate.__name__ = "Rotate";
    exports.Rotate = Rotate = __decorate([
        event("rotate")
    ], Rotate);
    let MouseWheel = class MouseWheel extends PointEvent {
        constructor(sx, sy, x, y, delta) {
            super(sx, sy, x, y);
            this.sx = sx;
            this.sy = sy;
            this.x = x;
            this.y = y;
            this.delta = delta;
        }
        _to_json() {
            const { delta } = this;
            return Object.assign(Object.assign({}, super._to_json()), { delta });
        }
    };
    exports.MouseWheel = MouseWheel;
    MouseWheel.__name__ = "MouseWheel";
    exports.MouseWheel = MouseWheel = __decorate([
        event("wheel")
    ], MouseWheel);
    let MouseMove = class MouseMove extends PointEvent {
    };
    exports.MouseMove = MouseMove;
    MouseMove.__name__ = "MouseMove";
    exports.MouseMove = MouseMove = __decorate([
        event("mousemove")
    ], MouseMove);
    let MouseEnter = class MouseEnter extends PointEvent {
    };
    exports.MouseEnter = MouseEnter;
    MouseEnter.__name__ = "MouseEnter";
    exports.MouseEnter = MouseEnter = __decorate([
        event("mouseenter")
    ], MouseEnter);
    let MouseLeave = class MouseLeave extends PointEvent {
    };
    exports.MouseLeave = MouseLeave;
    MouseLeave.__name__ = "MouseLeave";
    exports.MouseLeave = MouseLeave = __decorate([
        event("mouseleave")
    ], MouseLeave);
    let Tap = class Tap extends PointEvent {
    };
    exports.Tap = Tap;
    Tap.__name__ = "Tap";
    exports.Tap = Tap = __decorate([
        event("tap")
    ], Tap);
    let DoubleTap = class DoubleTap extends PointEvent {
    };
    exports.DoubleTap = DoubleTap;
    DoubleTap.__name__ = "DoubleTap";
    exports.DoubleTap = DoubleTap = __decorate([
        event("doubletap")
    ], DoubleTap);
    let Press = class Press extends PointEvent {
    };
    exports.Press = Press;
    Press.__name__ = "Press";
    exports.Press = Press = __decorate([
        event("press")
    ], Press);
    let PressUp = class PressUp extends PointEvent {
    };
    exports.PressUp = PressUp;
    PressUp.__name__ = "PressUp";
    exports.PressUp = PressUp = __decorate([
        event("pressup")
    ], PressUp);
    let PanStart = class PanStart extends PointEvent {
    };
    exports.PanStart = PanStart;
    PanStart.__name__ = "PanStart";
    exports.PanStart = PanStart = __decorate([
        event("panstart")
    ], PanStart);
    let PanEnd = class PanEnd extends PointEvent {
    };
    exports.PanEnd = PanEnd;
    PanEnd.__name__ = "PanEnd";
    exports.PanEnd = PanEnd = __decorate([
        event("panend")
    ], PanEnd);
    let PinchStart = class PinchStart extends PointEvent {
    };
    exports.PinchStart = PinchStart;
    PinchStart.__name__ = "PinchStart";
    exports.PinchStart = PinchStart = __decorate([
        event("pinchstart")
    ], PinchStart);
    let PinchEnd = class PinchEnd extends PointEvent {
    };
    exports.PinchEnd = PinchEnd;
    PinchEnd.__name__ = "PinchEnd";
    exports.PinchEnd = PinchEnd = __decorate([
        event("pinchend")
    ], PinchEnd);
    let RotateStart = class RotateStart extends PointEvent {
    };
    exports.RotateStart = RotateStart;
    RotateStart.__name__ = "RotateStart";
    exports.RotateStart = RotateStart = __decorate([
        event("rotatestart")
    ], RotateStart);
    let RotateEnd = class RotateEnd extends PointEvent {
    };
    exports.RotateEnd = RotateEnd;
    RotateEnd.__name__ = "RotateEnd";
    exports.RotateEnd = RotateEnd = __decorate([
        event("rotateend")
    ], RotateEnd);
},
/* core/util/wheel.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    /*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
    function fontSize(element) {
        const value = getComputedStyle(element).fontSize;
        if (value != null)
            return parseInt(value, 10);
        return null;
    }
    function lineHeight(element) {
        var _a, _b, _c;
        const parent = (_a = element.offsetParent) !== null && _a !== void 0 ? _a : document.body;
        return (_c = (_b = fontSize(parent)) !== null && _b !== void 0 ? _b : fontSize(element)) !== null && _c !== void 0 ? _c : 16;
    }
    function pageHeight(element) {
        return element.clientHeight; // XXX: should be content height?
    }
    function getDeltaY(event) {
        let deltaY = -event.deltaY;
        if (event.target instanceof HTMLElement) {
            switch (event.deltaMode) {
                case event.DOM_DELTA_LINE:
                    deltaY *= lineHeight(event.target);
                    break;
                case event.DOM_DELTA_PAGE:
                    deltaY *= pageHeight(event.target);
                    break;
            }
        }
        return deltaY;
    }
    exports.getDeltaY = getDeltaY;
},
/* core/util/compat.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_ie = (() => {
        const ua = typeof navigator !== "undefined" ? navigator.userAgent : "";
        return ua.indexOf('MSIE') >= 0 || ua.indexOf('Trident') > 0 || ua.indexOf('Edge') > 0;
    })();
    exports.is_mobile = (() => {
        return typeof window !== "undefined" && ("ontouchstart" in window || navigator.maxTouchPoints > 0);
    })();
    exports.is_little_endian = (() => {
        const buf = new ArrayBuffer(4);
        const buf8 = new Uint8Array(buf);
        const buf32 = new Uint32Array(buf);
        buf32[1] = 0x0a0b0c0d;
        let little_endian = true;
        if (buf8[4] == 0x0a && buf8[5] == 0x0b && buf8[6] == 0x0c && buf8[7] == 0x0d) {
            little_endian = false;
        }
        return little_endian;
    })();
},
/* core/util/menus.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const dom_1 = require(71) /* ../dom */;
    const iterator_1 = require(84) /* ./iterator */;
    //import menus_css from "styles/menus.css"
    const styles = tslib_1.__importStar(require(85) /* ../../styles/menus */);
    class ContextMenu {
        constructor(items, options = {}) {
            this.items = items;
            this.options = options;
            this.el = dom_1.div();
            this._open = false;
            this._item_click = (i) => {
                var _a;
                (_a = this.items[i]) === null || _a === void 0 ? void 0 : _a.handler();
                this.hide();
            };
            this._on_mousedown = (event) => {
                var _a, _b;
                const { target } = event;
                if (target instanceof Node && this.el.contains(target))
                    return;
                if ((_b = (_a = this.options).prevent_hide) === null || _b === void 0 ? void 0 : _b.call(_a, event))
                    return;
                this.hide();
            };
            this._on_keydown = (event) => {
                if (event.keyCode == dom_1.Keys.Esc)
                    this.hide();
            };
            this._on_blur = () => {
                this.hide();
            };
            dom_1.undisplay(this.el);
        }
        get is_open() {
            return this._open;
        }
        get can_open() {
            return this.items.length != 0;
        }
        remove() {
            dom_1.remove(this.el);
            this._unlisten();
        }
        _listen() {
            document.addEventListener("mousedown", this._on_mousedown);
            document.addEventListener("keydown", this._on_keydown);
            window.addEventListener("blur", this._on_blur);
        }
        _unlisten() {
            document.removeEventListener("mousedown", this._on_mousedown);
            document.removeEventListener("keydown", this._on_keydown);
            window.removeEventListener("blur", this._on_blur);
        }
        _position(at) {
            const parent_el = this.el.parentElement;
            if (parent_el != null) {
                const parent = parent_el.getBoundingClientRect();
                this.el.style.left = at.left != null ? `${at.left - parent.left}px` : "";
                this.el.style.top = at.top != null ? `${at.top - parent.top}px` : "";
                this.el.style.right = at.right != null ? `${parent.right - at.right}px` : "";
                this.el.style.bottom = at.bottom != null ? `${parent.bottom - at.bottom}px` : "";
            }
        }
        /*
        styles(): string[] {
          return [...super.styles(), menus_css]
        }
        */
        render() {
            var _a, _b;
            dom_1.empty(this.el, true);
            const orientation = (_a = this.options.orientation) !== null && _a !== void 0 ? _a : "vertical";
            dom_1.classes(this.el).add("bk-context-menu", `bk-${orientation}`);
            for (const [item, i] of iterator_1.enumerate(this.items)) {
                let el;
                if (item == null) {
                    el = dom_1.div({ class: styles.bk_divider });
                }
                else if (item.if != null && !item.if()) {
                    continue;
                }
                else {
                    const icon = item.icon != null ? dom_1.div({ class: ["bk-menu-icon", item.icon] }) : null;
                    el = dom_1.div({ class: ((_b = item.active) === null || _b === void 0 ? void 0 : _b.call(item)) ? "bk-active" : null, title: item.tooltip }, icon, item.label);
                }
                el.addEventListener("click", () => this._item_click(i));
                this.el.appendChild(el);
            }
        }
        show(at) {
            if (this.items.length == 0)
                return;
            if (!this._open) {
                this.render();
                if (this.el.children.length == 0)
                    return;
                this._position(at !== null && at !== void 0 ? at : { left: 0, top: 0 });
                dom_1.display(this.el);
                this._listen();
                this._open = true;
            }
        }
        hide() {
            if (this._open) {
                this._open = false;
                this._unlisten();
                dom_1.undisplay(this.el);
            }
        }
        toggle(at) {
            this._open ? this.hide() : this.show(at);
        }
    }
    exports.ContextMenu = ContextMenu;
    ContextMenu.__name__ = "ContextMenu";
},
/* core/util/iterator.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const array_1 = require(9) /* ./array */;
    function* enumerate(seq) {
        let i = 0;
        for (const item of seq) {
            yield [item, i++];
        }
    }
    exports.enumerate = enumerate;
    // https://docs.python.org/3.8/library/itertools.html#itertools.combinations
    function* combinations(seq, r) {
        const n = seq.length;
        if (r > n)
            return;
        const indices = array_1.range(r);
        yield indices.map((i) => seq[i]);
        while (true) {
            let k;
            for (const i of array_1.reversed(array_1.range(r))) {
                if (indices[i] != i + n - r) {
                    k = i;
                    break;
                }
            }
            if (k == null)
                return;
            indices[k] += 1;
            for (const j of array_1.range(k + 1, r)) {
                indices[j] = indices[j - 1] + 1;
            }
            yield indices.map((i) => seq[i]);
        }
    }
    exports.combinations = combinations;
    function* subsets(seq) {
        for (const k of array_1.range(seq.length + 1)) {
            yield* combinations(seq, k);
        }
    }
    exports.subsets = subsets;
},
/* styles/menus.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.bk_menu = "bk-menu";
    exports.bk_caret = "bk-caret";
    exports.bk_divider = "bk-divider";
},
/* core/util/bbox.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(24) /* ../types */;
    const { min, max } = Math;
    function empty() {
        return {
            x0: Infinity,
            y0: Infinity,
            x1: -Infinity,
            y1: -Infinity,
        };
    }
    exports.empty = empty;
    function positive_x() {
        return {
            x0: Number.MIN_VALUE,
            y0: -Infinity,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_x = positive_x;
    function positive_y() {
        return {
            x0: -Infinity,
            y0: Number.MIN_VALUE,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_y = positive_y;
    function union(a, b) {
        return {
            x0: min(a.x0, b.x0),
            x1: max(a.x1, b.x1),
            y0: min(a.y0, b.y0),
            y1: max(a.y1, b.y1),
        };
    }
    exports.union = union;
    class BBox {
        constructor(box) {
            if (box == null) {
                this.x0 = 0;
                this.y0 = 0;
                this.x1 = 0;
                this.y1 = 0;
            }
            else if ('x0' in box) {
                const { x0, y0, x1, y1 } = box;
                if (!(x0 <= x1 && y0 <= y1))
                    throw new Error(`invalid bbox {x0: ${x0}, y0: ${y0}, x1: ${x1}, y1: ${y1}}`);
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            }
            else if ("x" in box) {
                const { x, y, width, height } = box;
                if (!(width >= 0 && height >= 0))
                    throw new Error(`invalid bbox {x: ${x}, y: ${y}, width: ${width}, height: ${height}}`);
                this.x0 = x;
                this.y0 = y;
                this.x1 = x + width;
                this.y1 = y + height;
            }
            else {
                let left, right;
                let top, bottom;
                if ("width" in box) {
                    if ("left" in box) {
                        left = box.left;
                        right = left + box.width;
                    }
                    else if ("right" in box) {
                        right = box.right;
                        left = right - box.width;
                    }
                    else {
                        const w2 = box.width / 2;
                        left = box.hcenter - w2;
                        right = box.hcenter + w2;
                    }
                }
                else {
                    left = box.left;
                    right = box.right;
                }
                if ("height" in box) {
                    if ("top" in box) {
                        top = box.top;
                        bottom = top + box.height;
                    }
                    else if ("bottom" in box) {
                        bottom = box.bottom;
                        top = bottom - box.height;
                    }
                    else {
                        const h2 = box.height / 2;
                        top = box.vcenter - h2;
                        bottom = box.vcenter + h2;
                    }
                }
                else {
                    top = box.top;
                    bottom = box.bottom;
                }
                if (!(left <= right && top <= bottom))
                    throw new Error(`invalid bbox {left: ${left}, top: ${top}, right: ${right}, bottom: ${bottom}}`);
                this.x0 = left;
                this.y0 = top;
                this.x1 = right;
                this.y1 = bottom;
            }
        }
        toString() {
            return `BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`;
        }
        get left() { return this.x0; }
        get top() { return this.y0; }
        get right() { return this.x1; }
        get bottom() { return this.y1; }
        get p0() { return [this.x0, this.y0]; }
        get p1() { return [this.x1, this.y1]; }
        get x() { return this.x0; }
        get y() { return this.y0; }
        get width() { return this.x1 - this.x0; }
        get height() { return this.y1 - this.y0; }
        get rect() { return { x0: this.x0, y0: this.y0, x1: this.x1, y1: this.y1 }; }
        get box() { return { x: this.x, y: this.y, width: this.width, height: this.height }; }
        get h_range() { return { start: this.x0, end: this.x1 }; }
        get v_range() { return { start: this.y0, end: this.y1 }; }
        get ranges() { return [this.h_range, this.v_range]; }
        get aspect() { return this.width / this.height; }
        get hcenter() { return (this.left + this.right) / 2; }
        get vcenter() { return (this.top + this.bottom) / 2; }
        relative() {
            const { width, height } = this;
            return new BBox({ x: 0, y: 0, width, height });
        }
        relativize(x, y) {
            return [x - this.x, y - this.y];
        }
        contains(x, y) {
            return x >= this.x0 && x <= this.x1 && y >= this.y0 && y <= this.y1;
        }
        clip(x, y) {
            if (x < this.x0)
                x = this.x0;
            else if (x > this.x1)
                x = this.x1;
            if (y < this.y0)
                y = this.y0;
            else if (y > this.y1)
                y = this.y1;
            return [x, y];
        }
        union(that) {
            return new BBox({
                x0: min(this.x0, that.x0),
                y0: min(this.y0, that.y0),
                x1: max(this.x1, that.x1),
                y1: max(this.y1, that.y1),
            });
        }
        equals(that) {
            return this.x0 == that.x0 && this.y0 == that.y0 && this.x1 == that.x1 && this.y1 == that.y1;
        }
        get xview() {
            return {
                compute: (x) => {
                    return this.left + x;
                },
                v_compute: (xx) => {
                    const _xx = new types_1.NumberArray(xx.length);
                    const left = this.left;
                    for (let i = 0; i < xx.length; i++) {
                        _xx[i] = left + xx[i];
                    }
                    return _xx;
                },
            };
        }
        get yview() {
            return {
                compute: (y) => {
                    return this.bottom - y;
                },
                v_compute: (yy) => {
                    const _yy = new types_1.NumberArray(yy.length);
                    const bottom = this.bottom;
                    for (let i = 0; i < yy.length; i++) {
                        _yy[i] = bottom - yy[i];
                    }
                    return _yy;
                },
            };
        }
    }
    exports.BBox = BBox;
    BBox.__name__ = "BBox";
},
/* core/util/canvas.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function fixup_line_dash(ctx) {
        if (typeof ctx.lineDash === "undefined") {
            Object.defineProperty(ctx, "lineDash", {
                get: () => ctx.getLineDash(),
                set: (segments) => ctx.setLineDash(segments),
            });
        }
    }
    function fixup_image_smoothing(ctx) {
        ctx.setImageSmoothingEnabled = (value) => {
            ctx.imageSmoothingEnabled = value;
            ctx.mozImageSmoothingEnabled = value;
            ctx.oImageSmoothingEnabled = value;
            ctx.webkitImageSmoothingEnabled = value;
            ctx.msImageSmoothingEnabled = value;
        };
        ctx.getImageSmoothingEnabled = () => {
            const val = ctx.imageSmoothingEnabled;
            return val != null ? val : true;
        };
    }
    function fixup_measure_text(ctx) {
        if (ctx.measureText && ctx.html5MeasureText == null) {
            ctx.html5MeasureText = ctx.measureText;
            ctx.measureText = (text) => {
                const textMetrics = ctx.html5MeasureText(text);
                // fake it til you make it
                textMetrics.ascent = ctx.html5MeasureText("m").width * 1.6;
                return textMetrics;
            };
        }
    }
    function fixup_ellipse(ctx) {
        // implementing the ctx.ellipse function with bezier curves
        // we don't implement the startAngle, endAngle and anticlockwise arguments.
        function ellipse_bezier(x, y, radiusX, radiusY, rotation, _startAngle, _endAngle, anticlockwise = false) {
            const c = 0.551784; // see http://www.tinaja.com/glib/ellipse4.pdf
            ctx.translate(x, y);
            ctx.rotate(rotation);
            let rx = radiusX;
            let ry = radiusY;
            if (anticlockwise) {
                rx = -radiusX;
                ry = -radiusY;
            }
            ctx.moveTo(-rx, 0); // start point of first curve
            ctx.bezierCurveTo(-rx, ry * c, -rx * c, ry, 0, ry);
            ctx.bezierCurveTo(rx * c, ry, rx, ry * c, rx, 0);
            ctx.bezierCurveTo(rx, -ry * c, rx * c, -ry, 0, -ry);
            ctx.bezierCurveTo(-rx * c, -ry, -rx, -ry * c, -rx, 0);
            ctx.rotate(-rotation);
            ctx.translate(-x, -y);
        }
        if (!ctx.ellipse)
            ctx.ellipse = ellipse_bezier;
    }
    function fixup_ctx(ctx) {
        fixup_line_dash(ctx);
        fixup_image_smoothing(ctx);
        fixup_measure_text(ctx);
        fixup_ellipse(ctx);
    }
    exports.fixup_ctx = fixup_ctx;
},
/* model.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const has_props_1 = require(14) /* ./core/has_props */;
    const types_1 = require(8) /* ./core/util/types */;
    const object_1 = require(13) /* ./core/util/object */;
    const logging_1 = require(19) /* ./core/logging */;
    class Model extends has_props_1.HasProps {
        constructor(attrs) {
            super(attrs);
        }
        static init_Model() {
            this.define(({ Any, Unknown, String, Array, Dict, Nullable }) => ({
                tags: [Array(Unknown), []],
                name: [Nullable(String), null],
                js_property_callbacks: [Dict(Array(Any /*TODO*/)), {}],
                js_event_callbacks: [Dict(Array(Any /*TODO*/)), {}],
                subscribed_events: [Array(String), []],
            }));
        }
        initialize() {
            super.initialize();
            this._js_callbacks = new Map();
        }
        connect_signals() {
            super.connect_signals();
            this._update_property_callbacks();
            this.connect(this.properties.js_property_callbacks.change, () => this._update_property_callbacks());
            this.connect(this.properties.js_event_callbacks.change, () => this._update_event_callbacks());
            this.connect(this.properties.subscribed_events.change, () => this._update_event_callbacks());
        }
        /*protected*/ _process_event(event) {
            var _a;
            for (const callback of (_a = this.js_event_callbacks[event.event_name]) !== null && _a !== void 0 ? _a : [])
                callback.execute(event);
            if (this.document != null && this.subscribed_events.some((m) => m == event.event_name))
                this.document.event_manager.send_event(event);
        }
        trigger_event(event) {
            if (this.document != null) {
                event.origin = this;
                this.document.event_manager.trigger(event);
            }
        }
        _update_event_callbacks() {
            if (this.document == null) {
                // File an issue: SidePanel in particular seems to have this issue
                logging_1.logger.warn('WARNING: Document not defined for updating event callbacks');
                return;
            }
            this.document.event_manager.subscribed_models.add(this);
        }
        _update_property_callbacks() {
            const signal_for = (event) => {
                const [evt, attr = null] = event.split(":");
                return attr != null ? this.properties[attr][evt] : this[evt];
            };
            for (const [event, callbacks] of this._js_callbacks) {
                const signal = signal_for(event);
                for (const cb of callbacks)
                    this.disconnect(signal, cb);
            }
            this._js_callbacks.clear();
            for (const [event, callbacks] of object_1.entries(this.js_property_callbacks)) {
                const wrappers = callbacks.map((cb) => () => cb.execute(this));
                this._js_callbacks.set(event, wrappers);
                const signal = signal_for(event);
                for (const cb of wrappers)
                    this.connect(signal, cb);
            }
        }
        _doc_attached() {
            if (!object_1.isEmpty(this.js_event_callbacks) || this.subscribed_events.length != 0)
                this._update_event_callbacks();
        }
        _doc_detached() {
            this.document.event_manager.subscribed_models.delete(this);
        }
        select(selector) {
            if (types_1.isString(selector))
                return [...this.references()].filter((ref) => ref instanceof Model && ref.name === selector);
            else if (selector.prototype instanceof has_props_1.HasProps)
                return [...this.references()].filter((ref) => ref instanceof selector);
            else
                throw new Error("invalid selector");
        }
        select_one(selector) {
            const result = this.select(selector);
            switch (result.length) {
                case 0:
                    return null;
                case 1:
                    return result[0];
                default:
                    throw new Error("found more than one object matching given selector");
            }
        }
    }
    exports.Model = Model;
    Model.__name__ = "Model";
    Model.init_Model();
},
/* models/canvas/coordinates.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class CoordinateTransform {
        constructor(x_scale, y_scale) {
            this.x_scale = x_scale;
            this.y_scale = y_scale;
            this.x_range = this.x_scale.source_range;
            this.y_range = this.y_scale.source_range;
            this.ranges = [this.x_range, this.y_range];
            this.scales = [this.x_scale, this.y_scale];
        }
        map_to_screen(xs, ys) {
            const sxs = this.x_scale.v_compute(xs);
            const sys = this.y_scale.v_compute(ys);
            return [sxs, sys];
        }
        map_from_screen(sxs, sys) {
            const xs = this.x_scale.v_invert(sxs);
            const ys = this.y_scale.v_invert(sys);
            return [xs, ys];
        }
    }
    exports.CoordinateTransform = CoordinateTransform;
    CoordinateTransform.__name__ = "CoordinateTransform";
},
/* models/annotations/arrow.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(35) /* ./annotation */;
    const arrow_head_1 = require(91) /* ./arrow_head */;
    const columnar_data_source_1 = require(92) /* ../sources/columnar_data_source */;
    const column_data_source_1 = require(130) /* ../sources/column_data_source */;
    const property_mixins_1 = require(28) /* ../../core/property_mixins */;
    const enums_1 = require(20) /* ../../core/enums */;
    const build_views_1 = require(123) /* ../../core/build_views */;
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    const math_1 = require(10) /* ../../core/util/math */;
    class ArrowView extends annotation_1.AnnotationView {
        initialize() {
            super.initialize();
            this.set_data(this.model.source);
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const { start, end } = this.model;
            const { parent } = this;
            if (start != null)
                this.start = await build_views_1.build_view(start, { parent });
            if (end != null)
                this.end = await build_views_1.build_view(end, { parent });
        }
        remove() {
            var _a, _b;
            (_a = this.start) === null || _a === void 0 ? void 0 : _a.remove();
            (_b = this.end) === null || _b === void 0 ? void 0 : _b.remove();
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.set_data(this.model.source));
            this.connect(this.model.source.streaming, () => this.set_data(this.model.source));
            this.connect(this.model.source.patching, () => this.set_data(this.model.source));
            this.connect(this.model.source.change, () => this.set_data(this.model.source));
        }
        set_data(source) {
            super.set_data(source);
            this.visuals.warm_cache(source);
            this.plot_view.request_render();
        }
        _map_data() {
            const { frame } = this.plot_view;
            let sx_start, sy_start;
            if (this.model.start_units == 'data') {
                sx_start = this.coordinates.x_scale.v_compute(this._x_start);
                sy_start = this.coordinates.y_scale.v_compute(this._y_start);
            }
            else {
                sx_start = frame.xview.v_compute(this._x_start);
                sy_start = frame.yview.v_compute(this._y_start);
            }
            let sx_end, sy_end;
            if (this.model.end_units == 'data') {
                sx_end = this.coordinates.x_scale.v_compute(this._x_end);
                sy_end = this.coordinates.y_scale.v_compute(this._y_end);
            }
            else {
                sx_end = frame.xview.v_compute(this._x_end);
                sy_end = frame.yview.v_compute(this._y_end);
            }
            return [[sx_start, sy_start], [sx_end, sy_end]];
        }
        _render() {
            const { ctx } = this.layer;
            ctx.save();
            // Order in this function is important. First we draw all the arrow heads.
            const [start, end] = this._map_data();
            if (this.end != null)
                this._arrow_head(ctx, "render", this.end, start, end);
            if (this.start != null)
                this._arrow_head(ctx, "render", this.start, end, start);
            // Next we call .clip on all the arrow heads, inside an initial canvas sized
            // rect, to create an "inverted" clip region for the arrow heads
            ctx.beginPath();
            const { x, y, width, height } = this.plot_view.frame.bbox;
            ctx.rect(x, y, width, height);
            if (this.end != null)
                this._arrow_head(ctx, "clip", this.end, start, end);
            if (this.start != null)
                this._arrow_head(ctx, "clip", this.start, end, start);
            ctx.closePath();
            ctx.clip();
            // Finally we draw the arrow body, with the clipping regions set up. This prevents
            // "fat" arrows from overlapping the arrow head in a bad way.
            this._arrow_body(ctx, start, end);
            ctx.restore();
        }
        _arrow_head(ctx, action, head, start, end) {
            for (let i = 0, _end = this._x_start.length; i < _end; i++) {
                // arrow head runs orthogonal to arrow body
                const angle = Math.PI / 2 + math_1.atan2([start[0][i], start[1][i]], [end[0][i], end[1][i]]);
                ctx.save();
                ctx.translate(end[0][i], end[1][i]);
                ctx.rotate(angle);
                if (action == "render")
                    head.render(ctx, i);
                else if (action == "clip")
                    head.clip(ctx, i);
                ctx.restore();
            }
        }
        _arrow_body(ctx, start, end) {
            if (!this.visuals.line.doit)
                return;
            for (let i = 0, n = this._x_start.length; i < n; i++) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(start[0][i], start[1][i]);
                ctx.lineTo(end[0][i], end[1][i]);
                ctx.stroke();
            }
        }
    }
    exports.ArrowView = ArrowView;
    ArrowView.__name__ = "ArrowView";
    class Arrow extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_Arrow() {
            this.prototype.default_view = ArrowView;
            this.mixins(property_mixins_1.LineVector);
            this.define(({ Ref, Nullable }) => ({
                x_start: [p.XCoordinateSpec],
                y_start: [p.YCoordinateSpec],
                start_units: [enums_1.SpatialUnits, "data"],
                start: [Nullable(Ref(arrow_head_1.ArrowHead)), null],
                x_end: [p.XCoordinateSpec],
                y_end: [p.YCoordinateSpec],
                end_units: [enums_1.SpatialUnits, "data"],
                end: [Nullable(Ref(arrow_head_1.ArrowHead)), () => new arrow_head_1.OpenHead()],
                source: [Ref(columnar_data_source_1.ColumnarDataSource), () => new column_data_source_1.ColumnDataSource()],
            }));
        }
    }
    exports.Arrow = Arrow;
    Arrow.__name__ = "Arrow";
    Arrow.init_Arrow();
},
/* models/annotations/arrow_head.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const model_1 = require(88) /* ../../model */;
    const view_1 = require(70) /* ../../core/view */;
    const visuals = tslib_1.__importStar(require(73) /* ../../core/visuals */);
    const property_mixins_1 = require(28) /* ../../core/property_mixins */;
    class ArrowHeadView extends view_1.View {
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this.model);
        }
    }
    exports.ArrowHeadView = ArrowHeadView;
    ArrowHeadView.__name__ = "ArrowHeadView";
    class ArrowHead extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        static init_ArrowHead() {
            this.define(({ Number }) => ({
                size: [Number, 25],
            }));
        }
    }
    exports.ArrowHead = ArrowHead;
    ArrowHead.__name__ = "ArrowHead";
    ArrowHead.init_ArrowHead();
    class OpenHeadView extends ArrowHeadView {
        clip(ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            const { size } = this.model;
            ctx.moveTo(0.5 * size, size);
            ctx.lineTo(0.5 * size, -2);
            ctx.lineTo(-0.5 * size, -2);
            ctx.lineTo(-0.5 * size, size);
            ctx.lineTo(0, 0);
            ctx.lineTo(0.5 * size, size);
        }
        render(ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                const { size } = this.model;
                ctx.beginPath();
                ctx.moveTo(0.5 * size, size);
                ctx.lineTo(0, 0);
                ctx.lineTo(-0.5 * size, size);
                ctx.stroke();
            }
        }
    }
    exports.OpenHeadView = OpenHeadView;
    OpenHeadView.__name__ = "OpenHeadView";
    class OpenHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
        static init_OpenHead() {
            this.prototype.default_view = OpenHeadView;
            this.mixins(property_mixins_1.LineVector);
        }
    }
    exports.OpenHead = OpenHead;
    OpenHead.__name__ = "OpenHead";
    OpenHead.init_OpenHead();
    class NormalHeadView extends ArrowHeadView {
        clip(ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            const { size } = this.model;
            ctx.moveTo(0.5 * size, size);
            ctx.lineTo(0.5 * size, -2);
            ctx.lineTo(-0.5 * size, -2);
            ctx.lineTo(-0.5 * size, size);
            ctx.lineTo(0.5 * size, size);
        }
        render(ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.stroke();
            }
        }
        _normal(ctx, _i) {
            const { size } = this.model;
            ctx.beginPath();
            ctx.moveTo(0.5 * size, size);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size, size);
            ctx.closePath();
        }
    }
    exports.NormalHeadView = NormalHeadView;
    NormalHeadView.__name__ = "NormalHeadView";
    class NormalHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
        static init_NormalHead() {
            this.prototype.default_view = NormalHeadView;
            this.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector]);
            this.override({
                fill_color: "black",
            });
        }
    }
    exports.NormalHead = NormalHead;
    NormalHead.__name__ = "NormalHead";
    NormalHead.init_NormalHead();
    class VeeHeadView extends ArrowHeadView {
        clip(ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            const { size } = this.model;
            ctx.moveTo(0.5 * size, size);
            ctx.lineTo(0.5 * size, -2);
            ctx.lineTo(-0.5 * size, -2);
            ctx.lineTo(-0.5 * size, size);
            ctx.lineTo(0, 0.5 * size);
            ctx.lineTo(0.5 * size, size);
        }
        render(ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.stroke();
            }
        }
        _vee(ctx, _i) {
            const { size } = this.model;
            ctx.beginPath();
            ctx.moveTo(0.5 * size, size);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size, size);
            ctx.lineTo(0, 0.5 * size);
            ctx.closePath();
        }
    }
    exports.VeeHeadView = VeeHeadView;
    VeeHeadView.__name__ = "VeeHeadView";
    class VeeHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
        static init_VeeHead() {
            this.prototype.default_view = VeeHeadView;
            this.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector]);
            this.override({
                fill_color: "black",
            });
        }
    }
    exports.VeeHead = VeeHead;
    VeeHead.__name__ = "VeeHead";
    VeeHead.init_VeeHead();
    class TeeHeadView extends ArrowHeadView {
        render(ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                const { size } = this.model;
                ctx.beginPath();
                ctx.moveTo(0.5 * size, 0);
                ctx.lineTo(-0.5 * size, 0);
                ctx.stroke();
            }
        }
        clip(_ctx, _i) { }
    }
    exports.TeeHeadView = TeeHeadView;
    TeeHeadView.__name__ = "TeeHeadView";
    class TeeHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
        static init_TeeHead() {
            this.prototype.default_view = TeeHeadView;
            this.mixins(property_mixins_1.LineVector);
        }
    }
    exports.TeeHead = TeeHead;
    TeeHead.__name__ = "TeeHead";
    TeeHead.init_TeeHead();
},
/* models/sources/columnar_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const data_source_1 = require(93) /* ./data_source */;
    const signaling_1 = require(15) /* ../../core/signaling */;
    const logging_1 = require(19) /* ../../core/logging */;
    const selection_manager_1 = require(102) /* ../../core/selection_manager */;
    const types_1 = require(8) /* ../../core/util/types */;
    const array_1 = require(9) /* ../../core/util/array */;
    const object_1 = require(13) /* ../../core/util/object */;
    const selection_1 = require(94) /* ../selections/selection */;
    const interaction_policy_1 = require(129) /* ../selections/interaction_policy */;
    class ColumnarDataSource extends data_source_1.DataSource {
        constructor(attrs) {
            super(attrs);
        }
        get_array(key) {
            let column = this.data[key];
            if (column == null)
                this.data[key] = column = [];
            else if (!types_1.isArray(column))
                this.data[key] = column = Array.from(column);
            return column;
        }
        static init_ColumnarDataSource() {
            this.define(({ Ref }) => ({
                selection_policy: [Ref(interaction_policy_1.SelectionPolicy), () => new interaction_policy_1.UnionRenderers()],
            }));
            this.internal(({ Ref }) => ({
                selection_manager: [Ref(selection_manager_1.SelectionManager), (self) => new selection_manager_1.SelectionManager({ source: self })],
                inspected: [Ref(selection_1.Selection), () => new selection_1.Selection()],
            }));
        }
        initialize() {
            super.initialize();
            this._select = new signaling_1.Signal0(this, "select");
            this.inspect = new signaling_1.Signal(this, "inspect");
            this.streaming = new signaling_1.Signal0(this, "streaming");
            this.patching = new signaling_1.Signal(this, "patching");
        }
        get_column(colname) {
            const column = this.data[colname];
            return column != null ? column : null;
        }
        columns() {
            // return the column names in this data source
            return object_1.keys(this.data);
        }
        get_length(soft = true) {
            const lengths = array_1.uniq(object_1.values(this.data).map((v) => v.length));
            switch (lengths.length) {
                case 0: {
                    return null; // XXX: don't guess, treat on case-by-case basis
                }
                case 1: {
                    return lengths[0];
                }
                default: {
                    const msg = "data source has columns of inconsistent lengths";
                    if (soft) {
                        logging_1.logger.warn(msg);
                        return lengths.sort()[0];
                    }
                    else
                        throw new Error(msg);
                }
            }
        }
        get length() {
            var _a;
            return (_a = this.get_length()) !== null && _a !== void 0 ? _a : 0;
        }
        clear() {
            const empty = {};
            for (const col of this.columns()) {
                empty[col] = new this.data[col].constructor(0);
            }
            this.data = empty;
        }
    }
    exports.ColumnarDataSource = ColumnarDataSource;
    ColumnarDataSource.__name__ = "ColumnarDataSource";
    ColumnarDataSource.init_ColumnarDataSource();
},
/* models/sources/data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    const selection_1 = require(94) /* ../selections/selection */;
    class DataSource extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        static init_DataSource() {
            this.define(({ Ref }) => ({
                selected: [Ref(selection_1.Selection), () => new selection_1.Selection()],
            }));
        }
    }
    exports.DataSource = DataSource;
    DataSource.__name__ = "DataSource";
    DataSource.init_DataSource();
},
/* models/selections/selection.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    const array_1 = require(9) /* ../../core/util/array */;
    const object_1 = require(13) /* ../../core/util/object */;
    const glyph_1 = require(95) /* ../glyphs/glyph */;
    class Selection extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        get_view() {
            return this.view;
        }
        static init_Selection() {
            this.define(({ Int, Array, Dict }) => ({
                indices: [Array(Int), []],
                line_indices: [Array(Int), []],
                multiline_indices: [Dict(Array(Int)), {}],
            }));
            this.internal(({ Int, Array, Ref, Struct, Nullable }) => ({
                selected_glyphs: [Array(Ref(glyph_1.Glyph)), []],
                view: [Nullable(Ref(glyph_1.GlyphView)), null],
                // Used internally to support hover tool for now. Python API TBD
                image_indices: [Array(Struct({ index: Int, dim1: Int, dim2: Int, flat_index: Int })), []],
            }));
        }
        get selected_glyph() {
            return this.selected_glyphs.length > 0 ? this.selected_glyphs[0] : null;
        }
        add_to_selected_glyphs(glyph) {
            this.selected_glyphs.push(glyph);
        }
        update(selection, _final = true, mode = "replace") {
            switch (mode) {
                case "replace": {
                    this.indices = selection.indices;
                    this.line_indices = selection.line_indices;
                    this.selected_glyphs = selection.selected_glyphs;
                    this.view = selection.view;
                    this.multiline_indices = selection.multiline_indices;
                    this.image_indices = selection.image_indices;
                    break;
                }
                case "append": {
                    this.update_through_union(selection);
                    break;
                }
                case "intersect": {
                    this.update_through_intersection(selection);
                    break;
                }
                case "subtract": {
                    this.update_through_subtraction(selection);
                    break;
                }
            }
        }
        clear() {
            this.indices = [];
            this.line_indices = [];
            this.multiline_indices = {};
            this.view = null;
            this.selected_glyphs = [];
        }
        is_empty() {
            return this.indices.length == 0 && this.line_indices.length == 0 && this.image_indices.length == 0;
        }
        update_through_union(other) {
            this.indices = array_1.union(this.indices, other.indices);
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        }
        update_through_intersection(other) {
            this.indices = array_1.intersection(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        }
        update_through_subtraction(other) {
            this.indices = array_1.difference(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        }
    }
    exports.Selection = Selection;
    Selection.__name__ = "Selection";
    Selection.init_Selection();
},
/* models/glyphs/glyph.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    const bbox = tslib_1.__importStar(require(86) /* ../../core/util/bbox */);
    const visuals = tslib_1.__importStar(require(73) /* ../../core/visuals */);
    const view_1 = require(70) /* ../../core/view */;
    const model_1 = require(88) /* ../../model */;
    const logging_1 = require(19) /* ../../core/logging */;
    const types_1 = require(24) /* ../../core/types */;
    const ragged_array_1 = require(96) /* ../../core/util/ragged_array */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const spatial_1 = require(97) /* ../../core/util/spatial */;
    const factor_range_1 = require(100) /* ../ranges/factor_range */;
    const selection_1 = require(94) /* ../selections/selection */;
    class GlyphView extends view_1.View {
        constructor() {
            super(...arguments);
            this._index = null;
            this._data_size = null;
            this._nohit_warned = new Set();
        }
        get renderer() {
            return this.parent;
        }
        get has_webgl() {
            return this.glglyph != null;
        }
        get index() {
            const { _index } = this;
            if (_index != null)
                return _index;
            else
                throw new Error(`${this}.index_data() wasn't called`);
        }
        get data_size() {
            const { _data_size } = this;
            if (_data_size != null)
                return _data_size;
            else
                throw new Error(`${this}.set_data() wasn't called`);
        }
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this.model);
        }
        set_visuals(source, indices) {
            this.visuals.warm_cache(source, indices);
            if (this.glglyph != null)
                this.glglyph.set_visuals_changed();
        }
        render(ctx, indices, data) {
            ctx.beginPath();
            if (this.glglyph != null) {
                this.renderer.needs_webgl_blit = this.glglyph.render(ctx, indices, data);
                if (this.renderer.needs_webgl_blit)
                    return;
            }
            this._render(ctx, indices, data);
        }
        has_finished() {
            return true;
        }
        notify_finished() {
            this.renderer.notify_finished();
        }
        _bounds(bounds) {
            return bounds;
        }
        bounds() {
            return this._bounds(this.index.bbox);
        }
        log_bounds() {
            const { x0, x1 } = this.index.bounds(bbox.positive_x());
            const { y0, y1 } = this.index.bounds(bbox.positive_y());
            return this._bounds({ x0, y0, x1, y1 });
        }
        get_anchor_point(anchor, i, [sx, sy]) {
            switch (anchor) {
                case "center": {
                    const [x, y] = this.scenterxy(i, sx, sy);
                    return { x, y };
                }
                default:
                    return null;
            }
        }
        /** @deprecated */
        scenterx(i, sx, sy) {
            return this.scenterxy(i, sx, sy)[0];
        }
        /** @deprecated */
        scentery(i, sx, sy) {
            return this.scenterxy(i, sx, sy)[1];
        }
        sdist(scale, pts, spans, pts_location = "edge", dilate = false) {
            let pt0;
            let pt1;
            const n = pts.length;
            if (pts_location == 'center') {
                const halfspan = arrayable_1.map(spans, (d) => d / 2);
                pt0 = new Float64Array(n);
                for (let i = 0; i < n; i++) {
                    pt0[i] = pts[i] - halfspan[i];
                }
                pt1 = new Float64Array(n);
                for (let i = 0; i < n; i++) {
                    pt1[i] = pts[i] + halfspan[i];
                }
            }
            else {
                pt0 = pts;
                pt1 = new Float64Array(n);
                for (let i = 0; i < n; i++) {
                    pt1[i] = pt0[i] + spans[i];
                }
            }
            const spt0 = scale.v_compute(pt0);
            const spt1 = scale.v_compute(pt1);
            if (dilate)
                return arrayable_1.map(spt0, (_, i) => Math.ceil(Math.abs(spt1[i] - spt0[i])));
            else
                return arrayable_1.map(spt0, (_, i) => Math.abs(spt1[i] - spt0[i]));
        }
        draw_legend_for_index(_ctx, _bbox, _index) { }
        hit_test(geometry) {
            switch (geometry.type) {
                case "point":
                    if (this._hit_point != null)
                        return this._hit_point(geometry);
                    break;
                case "span":
                    if (this._hit_span != null)
                        return this._hit_span(geometry);
                    break;
                case "rect":
                    if (this._hit_rect != null)
                        return this._hit_rect(geometry);
                    break;
                case "poly":
                    if (this._hit_poly != null)
                        return this._hit_poly(geometry);
                    break;
            }
            if (!this._nohit_warned.has(geometry.type)) {
                logging_1.logger.debug(`'${geometry.type}' selection not available for ${this.model.type}`);
                this._nohit_warned.add(geometry.type);
            }
            return null;
        }
        _hit_rect_against_index(geometry) {
            const { sx0, sx1, sy0, sy1 } = geometry;
            const [x0, x1] = this.renderer.coordinates.x_scale.r_invert(sx0, sx1);
            const [y0, y1] = this.renderer.coordinates.y_scale.r_invert(sy0, sy1);
            const indices = [...this.index.indices({ x0, x1, y0, y1 })];
            return new selection_1.Selection({ indices });
        }
        _project_data() { }
        set_data(source, indices, indices_to_update) {
            var _a;
            const { x_range, y_range } = this.renderer.coordinates;
            this._data_size = indices.count;
            for (const prop of this.model) {
                if (!(prop instanceof p.VectorSpec))
                    continue;
                // this skips optional properties like radius for circles
                if (prop.optional && prop.spec.value == null && !prop.dirty)
                    continue;
                const name = prop.attr;
                const base_array = prop.array(source);
                let array = indices.select(base_array);
                if (prop instanceof p.BaseCoordinateSpec) {
                    const range = prop.dimension == "x" ? x_range : y_range;
                    if (range instanceof factor_range_1.FactorRange) {
                        if (prop instanceof p.CoordinateSpec) {
                            array = range.v_synthetic(array);
                        }
                        else if (prop instanceof p.CoordinateSeqSpec) {
                            for (let i = 0; i < array.length; i++) {
                                array[i] = range.v_synthetic(array[i]);
                            }
                        }
                    }
                    if (prop instanceof p.CoordinateSeqSpec) {
                        array = ragged_array_1.RaggedArray.from(array);
                    }
                }
                else if (prop instanceof p.DistanceSpec) {
                    this[`max_${name}`] = arrayable_1.max(array);
                }
                this[`_${name}`] = array;
            }
            if (this.renderer.plot_view.model.use_map) {
                this._project_data();
            }
            this._set_data(indices_to_update); // TODO doesn't take subset indices into account
            (_a = this.glglyph) === null || _a === void 0 ? void 0 : _a.set_data_changed();
            this.index_data();
        }
        _set_data(_indices) { }
        get _index_size() {
            return this.data_size;
        }
        index_data() {
            const index = new spatial_1.SpatialIndex(this._index_size);
            this._index_data(index);
            index.finish();
            this._index = index;
        }
        mask_data() {
            /** Returns subset indices in the viewport. */
            if (this._mask_data == null)
                return types_1.Indices.all_set(this.data_size);
            else
                return this._mask_data();
        }
        map_data() {
            var _a;
            const self = this;
            const { x_scale, y_scale } = this.renderer.coordinates;
            for (const prop of this.model) {
                if (prop instanceof p.BaseCoordinateSpec) {
                    const scale = prop.dimension == "x" ? x_scale : y_scale;
                    let array = self[`_${prop.attr}`];
                    if (array instanceof ragged_array_1.RaggedArray) {
                        const screen = scale.v_compute(array.array);
                        array = new ragged_array_1.RaggedArray(array.offsets, screen);
                    }
                    else {
                        array = scale.v_compute(array);
                    }
                    this[`s${prop.attr}`] = array;
                }
            }
            this._map_data();
            (_a = this.glglyph) === null || _a === void 0 ? void 0 : _a.set_data_changed();
        }
        // This is where specs not included in coords are computed, e.g. radius.
        _map_data() { }
    }
    exports.GlyphView = GlyphView;
    GlyphView.__name__ = "GlyphView";
    class Glyph extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        static init_Glyph() { }
    }
    exports.Glyph = Glyph;
    Glyph.__name__ = "Glyph";
    Glyph.init_Glyph();
},
/* core/util/ragged_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(24) /* ../types */;
    const eq_1 = require(26) /* ./eq */;
    const assert_1 = require(11) /* ./assert */;
    class RaggedArray {
        constructor(offsets, array) {
            this.offsets = offsets;
            this.array = array;
        }
        [eq_1.equals](that, cmp) {
            return cmp.arrays(this.offsets, that.offsets) && cmp.arrays(this.array, that.array);
        }
        get length() {
            return this.offsets.length;
        }
        clone() {
            return new RaggedArray(new Uint32Array(this.offsets), new types_1.NumberArray(this.array));
        }
        static from(items) {
            const n = items.length;
            const offsets = new Uint32Array(n);
            let offset = 0;
            for (let i = 0; i < n; i++) {
                const length = items[i].length;
                offsets[i] = offset;
                offset += length;
            }
            const array = new types_1.NumberArray(offset);
            for (let i = 0; i < n; i++) {
                array.set(items[i], offsets[i]);
            }
            return new RaggedArray(offsets, array);
        }
        *[Symbol.iterator]() {
            const { offsets, length } = this;
            for (let i = 0; i < length; i++) {
                yield this.array.subarray(offsets[i], offsets[i + 1]);
            }
        }
        _check_bounds(i) {
            assert_1.assert(0 <= i && i < this.length, `Out of bounds: 0 <= ${i} < ${this.length}`);
        }
        get(i) {
            this._check_bounds(i);
            const { offsets } = this;
            return this.array.subarray(offsets[i], offsets[i + 1]);
        }
        set(i, array) {
            this._check_bounds(i);
            this.array.set(array, this.offsets[i]);
        }
    }
    exports.RaggedArray = RaggedArray;
    RaggedArray.__name__ = "RaggedArray";
    RaggedArray[Symbol.toStringTag] = "RaggedArray";
},
/* core/util/spatial.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const flatbush_1 = tslib_1.__importDefault(require(98) /* flatbush */);
    const types_1 = require(24) /* ../types */;
    const bbox_1 = require(86) /* ./bbox */;
    function upperBound(value, arr) {
        let i = 0;
        let j = arr.length - 1;
        while (i < j) {
            const m = (i + j) >> 1;
            if (arr[m] > value) {
                j = m;
            }
            else {
                i = m + 1;
            }
        }
        return arr[i];
    }
    class _FlatBush extends flatbush_1.default {
        search_indices(minX, minY, maxX, maxY) {
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            let nodeIndex = this._boxes.length - 4;
            const queue = [];
            const results = new types_1.Indices(this.numItems);
            while (nodeIndex !== undefined) {
                // find the end index of the node
                const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // search through child nodes
                for (let pos = nodeIndex; pos < end; pos += 4) {
                    const index = this._indices[pos >> 2] | 0;
                    // check if node bbox intersects with query bbox
                    if (maxX < this._boxes[pos + 0])
                        continue; // maxX < nodeMinX
                    if (maxY < this._boxes[pos + 1])
                        continue; // maxY < nodeMinY
                    if (minX > this._boxes[pos + 2])
                        continue; // minX > nodeMaxX
                    if (minY > this._boxes[pos + 3])
                        continue; // minY > nodeMaxY
                    if (nodeIndex < this.numItems * 4) {
                        results.set(index); // leaf item
                    }
                    else {
                        queue.push(index); // node; add it to the search queue
                    }
                }
                nodeIndex = queue.pop();
            }
            return results;
        }
    }
    _FlatBush.__name__ = "_FlatBush";
    class SpatialIndex {
        constructor(size) {
            this.index = null;
            if (size > 0) {
                this.index = new _FlatBush(size);
            }
        }
        add(x0, y0, x1, y1) {
            var _a;
            (_a = this.index) === null || _a === void 0 ? void 0 : _a.add(x0, y0, x1, y1);
        }
        add_empty() {
            var _a;
            (_a = this.index) === null || _a === void 0 ? void 0 : _a.add(Infinity, Infinity, -Infinity, -Infinity);
        }
        finish() {
            var _a;
            (_a = this.index) === null || _a === void 0 ? void 0 : _a.finish();
        }
        _normalize(rect) {
            let { x0, y0, x1, y1 } = rect;
            if (x0 > x1)
                [x0, x1] = [x1, x0];
            if (y0 > y1)
                [y0, y1] = [y1, y0];
            return { x0, y0, x1, y1 };
        }
        get bbox() {
            if (this.index == null)
                return bbox_1.empty();
            else {
                const { minX, minY, maxX, maxY } = this.index;
                return { x0: minX, y0: minY, x1: maxX, y1: maxY };
            }
        }
        indices(rect) {
            if (this.index == null)
                return new types_1.Indices(0);
            else {
                const { x0, y0, x1, y1 } = this._normalize(rect);
                return this.index.search_indices(x0, y0, x1, y1);
            }
        }
        bounds(rect) {
            const bounds = bbox_1.empty();
            for (const i of this.indices(rect)) {
                const boxes = this.index._boxes;
                const x1 = boxes[4 * i + 0];
                const y1 = boxes[4 * i + 1];
                const x0 = boxes[4 * i + 2];
                const y0 = boxes[4 * i + 3];
                if (x0 < bounds.x0)
                    bounds.x0 = x0;
                if (x1 > bounds.x1)
                    bounds.x1 = x1;
                if (y0 < bounds.y0)
                    bounds.y0 = y0;
                if (y1 > bounds.y1)
                    bounds.y1 = y1;
            }
            return bounds;
        }
    }
    exports.SpatialIndex = SpatialIndex;
    SpatialIndex.__name__ = "SpatialIndex";
},
/* flatbush/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const flatqueue_1 = tslib_1.__importDefault(require(99) /* flatqueue */);
    const ARRAY_TYPES = [
        Int8Array, Uint8Array, Uint8ClampedArray, Int16Array, Uint16Array,
        Int32Array, Uint32Array, Float32Array, Float64Array
    ];
    const VERSION = 3; // serialized format version
    class Flatbush {
        static from(data) {
            if (!(data instanceof ArrayBuffer)) {
                throw new Error('Data must be an instance of ArrayBuffer.');
            }
            const [magic, versionAndType] = new Uint8Array(data, 0, 2);
            if (magic !== 0xfb) {
                throw new Error('Data does not appear to be in a Flatbush format.');
            }
            if (versionAndType >> 4 !== VERSION) {
                throw new Error(`Got v${versionAndType >> 4} data when expected v${VERSION}.`);
            }
            const [nodeSize] = new Uint16Array(data, 2, 1);
            const [numItems] = new Uint32Array(data, 4, 1);
            return new Flatbush(numItems, nodeSize, ARRAY_TYPES[versionAndType & 0x0f], data);
        }
        constructor(numItems, nodeSize = 16, ArrayType = Float64Array, data) {
            if (numItems === undefined)
                throw new Error('Missing required argument: numItems.');
            if (isNaN(numItems) || numItems <= 0)
                throw new Error(`Unpexpected numItems value: ${numItems}.`);
            this.numItems = +numItems;
            this.nodeSize = Math.min(Math.max(+nodeSize, 2), 65535);
            // calculate the total number of nodes in the R-tree to allocate space for
            // and the index of each tree level (used in search later)
            let n = numItems;
            let numNodes = n;
            this._levelBounds = [n * 4];
            do {
                n = Math.ceil(n / this.nodeSize);
                numNodes += n;
                this._levelBounds.push(numNodes * 4);
            } while (n !== 1);
            this.ArrayType = ArrayType || Float64Array;
            this.IndexArrayType = numNodes < 16384 ? Uint16Array : Uint32Array;
            const arrayTypeIndex = ARRAY_TYPES.indexOf(this.ArrayType);
            const nodesByteSize = numNodes * 4 * this.ArrayType.BYTES_PER_ELEMENT;
            if (arrayTypeIndex < 0) {
                throw new Error(`Unexpected typed array class: ${ArrayType}.`);
            }
            if (data && (data instanceof ArrayBuffer)) {
                this.data = data;
                this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
                this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
                this._pos = numNodes * 4;
                this.minX = this._boxes[this._pos - 4];
                this.minY = this._boxes[this._pos - 3];
                this.maxX = this._boxes[this._pos - 2];
                this.maxY = this._boxes[this._pos - 1];
            }
            else {
                this.data = new ArrayBuffer(8 + nodesByteSize + numNodes * this.IndexArrayType.BYTES_PER_ELEMENT);
                this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
                this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
                this._pos = 0;
                this.minX = Infinity;
                this.minY = Infinity;
                this.maxX = -Infinity;
                this.maxY = -Infinity;
                new Uint8Array(this.data, 0, 2).set([0xfb, (VERSION << 4) + arrayTypeIndex]);
                new Uint16Array(this.data, 2, 1)[0] = nodeSize;
                new Uint32Array(this.data, 4, 1)[0] = numItems;
            }
            // a priority queue for k-nearest-neighbors queries
            this._queue = new flatqueue_1.default();
        }
        add(minX, minY, maxX, maxY) {
            const index = this._pos >> 2;
            this._indices[index] = index;
            this._boxes[this._pos++] = minX;
            this._boxes[this._pos++] = minY;
            this._boxes[this._pos++] = maxX;
            this._boxes[this._pos++] = maxY;
            if (minX < this.minX)
                this.minX = minX;
            if (minY < this.minY)
                this.minY = minY;
            if (maxX > this.maxX)
                this.maxX = maxX;
            if (maxY > this.maxY)
                this.maxY = maxY;
            return index;
        }
        finish() {
            if (this._pos >> 2 !== this.numItems) {
                throw new Error(`Added ${this._pos >> 2} items when expected ${this.numItems}.`);
            }
            if (this.numItems <= this.nodeSize) {
                // only one node, skip sorting and just fill the root box
                this._boxes[this._pos++] = this.minX;
                this._boxes[this._pos++] = this.minY;
                this._boxes[this._pos++] = this.maxX;
                this._boxes[this._pos++] = this.maxY;
                return;
            }
            const width = this.maxX - this.minX;
            const height = this.maxY - this.minY;
            const hilbertValues = new Uint32Array(this.numItems);
            const hilbertMax = (1 << 16) - 1;
            // map item centers into Hilbert coordinate space and calculate Hilbert values
            for (let i = 0; i < this.numItems; i++) {
                let pos = 4 * i;
                const minX = this._boxes[pos++];
                const minY = this._boxes[pos++];
                const maxX = this._boxes[pos++];
                const maxY = this._boxes[pos++];
                const x = Math.floor(hilbertMax * ((minX + maxX) / 2 - this.minX) / width);
                const y = Math.floor(hilbertMax * ((minY + maxY) / 2 - this.minY) / height);
                hilbertValues[i] = hilbert(x, y);
            }
            // sort items by their Hilbert value (for packing later)
            sort(hilbertValues, this._boxes, this._indices, 0, this.numItems - 1, this.nodeSize);
            // generate nodes at each tree level, bottom-up
            for (let i = 0, pos = 0; i < this._levelBounds.length - 1; i++) {
                const end = this._levelBounds[i];
                // generate a parent node for each block of consecutive <nodeSize> nodes
                while (pos < end) {
                    const nodeIndex = pos;
                    // calculate bbox for the new node
                    let nodeMinX = Infinity;
                    let nodeMinY = Infinity;
                    let nodeMaxX = -Infinity;
                    let nodeMaxY = -Infinity;
                    for (let i = 0; i < this.nodeSize && pos < end; i++) {
                        nodeMinX = Math.min(nodeMinX, this._boxes[pos++]);
                        nodeMinY = Math.min(nodeMinY, this._boxes[pos++]);
                        nodeMaxX = Math.max(nodeMaxX, this._boxes[pos++]);
                        nodeMaxY = Math.max(nodeMaxY, this._boxes[pos++]);
                    }
                    // add the new node to the tree data
                    this._indices[this._pos >> 2] = nodeIndex;
                    this._boxes[this._pos++] = nodeMinX;
                    this._boxes[this._pos++] = nodeMinY;
                    this._boxes[this._pos++] = nodeMaxX;
                    this._boxes[this._pos++] = nodeMaxY;
                }
            }
        }
        search(minX, minY, maxX, maxY, filterFn) {
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            let nodeIndex = this._boxes.length - 4;
            const queue = [];
            const results = [];
            while (nodeIndex !== undefined) {
                // find the end index of the node
                const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // search through child nodes
                for (let pos = nodeIndex; pos < end; pos += 4) {
                    const index = this._indices[pos >> 2] | 0;
                    // check if node bbox intersects with query bbox
                    if (maxX < this._boxes[pos])
                        continue; // maxX < nodeMinX
                    if (maxY < this._boxes[pos + 1])
                        continue; // maxY < nodeMinY
                    if (minX > this._boxes[pos + 2])
                        continue; // minX > nodeMaxX
                    if (minY > this._boxes[pos + 3])
                        continue; // minY > nodeMaxY
                    if (nodeIndex < this.numItems * 4) {
                        if (filterFn === undefined || filterFn(index)) {
                            results.push(index); // leaf item
                        }
                    }
                    else {
                        queue.push(index); // node; add it to the search queue
                    }
                }
                nodeIndex = queue.pop();
            }
            return results;
        }
        neighbors(x, y, maxResults = Infinity, maxDistance = Infinity, filterFn) {
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            let nodeIndex = this._boxes.length - 4;
            const q = this._queue;
            const results = [];
            const maxDistSquared = maxDistance * maxDistance;
            while (nodeIndex !== undefined) {
                // find the end index of the node
                const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // add child nodes to the queue
                for (let pos = nodeIndex; pos < end; pos += 4) {
                    const index = this._indices[pos >> 2] | 0;
                    const dx = axisDist(x, this._boxes[pos], this._boxes[pos + 2]);
                    const dy = axisDist(y, this._boxes[pos + 1], this._boxes[pos + 3]);
                    const dist = dx * dx + dy * dy;
                    if (nodeIndex < this.numItems * 4) { // leaf node
                        if (filterFn === undefined || filterFn(index)) {
                            // put a negative index if it's an item rather than a node, to recognize later
                            q.push(-index - 1, dist);
                        }
                    }
                    else {
                        q.push(index, dist);
                    }
                }
                // pop items from the queue
                while (q.length && q.peek() < 0) {
                    const dist = q.peekValue();
                    if (dist > maxDistSquared) {
                        q.clear();
                        return results;
                    }
                    results.push(-q.pop() - 1);
                    if (results.length === maxResults) {
                        q.clear();
                        return results;
                    }
                }
                nodeIndex = q.pop();
            }
            q.clear();
            return results;
        }
    }
    exports.default = Flatbush;
    function axisDist(k, min, max) {
        return k < min ? min - k : k <= max ? 0 : k - max;
    }
    // binary search for the first value in the array bigger than the given
    function upperBound(value, arr) {
        let i = 0;
        let j = arr.length - 1;
        while (i < j) {
            const m = (i + j) >> 1;
            if (arr[m] > value) {
                j = m;
            }
            else {
                i = m + 1;
            }
        }
        return arr[i];
    }
    // custom quicksort that partially sorts bbox data alongside the hilbert values
    function sort(values, boxes, indices, left, right, nodeSize) {
        if (Math.floor(left / nodeSize) >= Math.floor(right / nodeSize))
            return;
        const pivot = values[(left + right) >> 1];
        let i = left - 1;
        let j = right + 1;
        while (true) {
            do
                i++;
            while (values[i] < pivot);
            do
                j--;
            while (values[j] > pivot);
            if (i >= j)
                break;
            swap(values, boxes, indices, i, j);
        }
        sort(values, boxes, indices, left, j, nodeSize);
        sort(values, boxes, indices, j + 1, right, nodeSize);
    }
    // swap two values and two corresponding boxes
    function swap(values, boxes, indices, i, j) {
        const temp = values[i];
        values[i] = values[j];
        values[j] = temp;
        const k = 4 * i;
        const m = 4 * j;
        const a = boxes[k];
        const b = boxes[k + 1];
        const c = boxes[k + 2];
        const d = boxes[k + 3];
        boxes[k] = boxes[m];
        boxes[k + 1] = boxes[m + 1];
        boxes[k + 2] = boxes[m + 2];
        boxes[k + 3] = boxes[m + 3];
        boxes[m] = a;
        boxes[m + 1] = b;
        boxes[m + 2] = c;
        boxes[m + 3] = d;
        const e = indices[i];
        indices[i] = indices[j];
        indices[j] = e;
    }
    // Fast Hilbert curve algorithm by http://threadlocalmutex.com/
    // Ported from C++ https://github.com/rawrunprotected/hilbert_curves (public domain)
    function hilbert(x, y) {
        let a = x ^ y;
        let b = 0xFFFF ^ a;
        let c = 0xFFFF ^ (x | y);
        let d = x & (y ^ 0xFFFF);
        let A = a | (b >> 1);
        let B = (a >> 1) ^ a;
        let C = ((c >> 1) ^ (b & (d >> 1))) ^ c;
        let D = ((a & (c >> 1)) ^ (d >> 1)) ^ d;
        a = A;
        b = B;
        c = C;
        d = D;
        A = ((a & (a >> 2)) ^ (b & (b >> 2)));
        B = ((a & (b >> 2)) ^ (b & ((a ^ b) >> 2)));
        C ^= ((a & (c >> 2)) ^ (b & (d >> 2)));
        D ^= ((b & (c >> 2)) ^ ((a ^ b) & (d >> 2)));
        a = A;
        b = B;
        c = C;
        d = D;
        A = ((a & (a >> 4)) ^ (b & (b >> 4)));
        B = ((a & (b >> 4)) ^ (b & ((a ^ b) >> 4)));
        C ^= ((a & (c >> 4)) ^ (b & (d >> 4)));
        D ^= ((b & (c >> 4)) ^ ((a ^ b) & (d >> 4)));
        a = A;
        b = B;
        c = C;
        d = D;
        C ^= ((a & (c >> 8)) ^ (b & (d >> 8)));
        D ^= ((b & (c >> 8)) ^ ((a ^ b) & (d >> 8)));
        a = C ^ (C >> 1);
        b = D ^ (D >> 1);
        let i0 = x ^ y;
        let i1 = b | (0xFFFF ^ (i0 | a));
        i0 = (i0 | (i0 << 8)) & 0x00FF00FF;
        i0 = (i0 | (i0 << 4)) & 0x0F0F0F0F;
        i0 = (i0 | (i0 << 2)) & 0x33333333;
        i0 = (i0 | (i0 << 1)) & 0x55555555;
        i1 = (i1 | (i1 << 8)) & 0x00FF00FF;
        i1 = (i1 | (i1 << 4)) & 0x0F0F0F0F;
        i1 = (i1 | (i1 << 2)) & 0x33333333;
        i1 = (i1 | (i1 << 1)) & 0x55555555;
        return ((i1 << 1) | i0) >>> 0;
    }
},
/* flatqueue/index.mjs */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class FlatQueue {
        constructor() {
            this.ids = [];
            this.values = [];
            this.length = 0;
        }
        clear() {
            this.length = 0;
        }
        push(id, value) {
            let pos = this.length++;
            this.ids[pos] = id;
            this.values[pos] = value;
            while (pos > 0) {
                const parent = (pos - 1) >> 1;
                const parentValue = this.values[parent];
                if (value >= parentValue)
                    break;
                this.ids[pos] = this.ids[parent];
                this.values[pos] = parentValue;
                pos = parent;
            }
            this.ids[pos] = id;
            this.values[pos] = value;
        }
        pop() {
            if (this.length === 0)
                return undefined;
            const top = this.ids[0];
            this.length--;
            if (this.length > 0) {
                const id = this.ids[0] = this.ids[this.length];
                const value = this.values[0] = this.values[this.length];
                const halfLength = this.length >> 1;
                let pos = 0;
                while (pos < halfLength) {
                    let left = (pos << 1) + 1;
                    const right = left + 1;
                    let bestIndex = this.ids[left];
                    let bestValue = this.values[left];
                    const rightValue = this.values[right];
                    if (right < this.length && rightValue < bestValue) {
                        left = right;
                        bestIndex = this.ids[right];
                        bestValue = rightValue;
                    }
                    if (bestValue >= value)
                        break;
                    this.ids[pos] = bestIndex;
                    this.values[pos] = bestValue;
                    pos = left;
                }
                this.ids[pos] = id;
                this.values[pos] = value;
            }
            return top;
        }
        peek() {
            if (this.length === 0)
                return undefined;
            return this.ids[0];
        }
        peekValue() {
            if (this.length === 0)
                return undefined;
            return this.values[0];
        }
    }
    exports.default = FlatQueue;
},
/* models/ranges/factor_range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const range_1 = require(101) /* ./range */;
    const enums_1 = require(20) /* ../../core/enums */;
    const types_1 = require(24) /* ../../core/types */;
    const array_1 = require(9) /* ../../core/util/array */;
    const types_2 = require(8) /* ../../core/util/types */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    function map_one_level(factors, padding, offset = 0) {
        const mapping = new Map();
        for (let i = 0; i < factors.length; i++) {
            const factor = factors[i];
            if (!mapping.has(factor))
                mapping.set(factor, { value: 0.5 + i * (1 + padding) + offset });
            else
                throw new Error(`duplicate factor or subfactor: ${factor}`);
        }
        return [mapping, (factors.length - 1) * padding];
    }
    exports.map_one_level = map_one_level;
    function map_two_levels(factors, outer_pad, factor_pad, offset = 0) {
        var _a;
        const mapping = new Map();
        const tops = new Map();
        for (const [f0, f1] of factors) {
            const top = (_a = tops.get(f0)) !== null && _a !== void 0 ? _a : [];
            tops.set(f0, [...top, f1]);
        }
        let suboffset = offset;
        let total_subpad = 0;
        for (const [f0, top] of tops) {
            const n = top.length;
            const [submap, subpad] = map_one_level(top, factor_pad, suboffset);
            total_subpad += subpad;
            const subtot = array_1.sum(top.map((f1) => submap.get(f1).value));
            mapping.set(f0, { value: subtot / n, mapping: submap });
            suboffset += n + outer_pad + subpad;
        }
        return [mapping, (tops.size - 1) * outer_pad + total_subpad];
    }
    exports.map_two_levels = map_two_levels;
    function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset = 0) {
        var _a;
        const mapping = new Map();
        const tops = new Map();
        for (const [f0, f1, f2] of factors) {
            const top = (_a = tops.get(f0)) !== null && _a !== void 0 ? _a : [];
            tops.set(f0, [...top, [f1, f2]]);
        }
        let suboffset = offset;
        let total_subpad = 0;
        for (const [f0, top] of tops) {
            const n = top.length;
            const [submap, subpad] = map_two_levels(top, inner_pad, factor_pad, suboffset);
            total_subpad += subpad;
            const subtot = array_1.sum(top.map(([f1]) => submap.get(f1).value));
            mapping.set(f0, { value: subtot / n, mapping: submap });
            suboffset += n + outer_pad + subpad;
        }
        return [mapping, (tops.size - 1) * outer_pad + total_subpad];
    }
    exports.map_three_levels = map_three_levels;
    class FactorRange extends range_1.Range {
        constructor(attrs) {
            super(attrs);
        }
        static init_FactorRange() {
            this.define(({ Any, Number, Array }) => ({
                factors: [Array(Any /*TODO*/), []],
                factor_padding: [Number, 0],
                subgroup_padding: [Number, 0.8],
                group_padding: [Number, 1.4],
                range_padding: [Number, 0],
                range_padding_units: [enums_1.PaddingUnits, "percent"],
                start: [Number],
                end: [Number],
            }));
            this.internal(({ Number, String, Array, Tuple, Nullable }) => ({
                levels: [Number],
                mids: [Nullable(Array(Tuple(String, String))), null],
                tops: [Nullable(Array(String)), null],
            }));
        }
        get min() {
            return this.start;
        }
        get max() {
            return this.end;
        }
        initialize() {
            super.initialize();
            this._init(true);
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.properties.factors.change, () => this.reset());
            this.connect(this.properties.factor_padding.change, () => this.reset());
            this.connect(this.properties.group_padding.change, () => this.reset());
            this.connect(this.properties.subgroup_padding.change, () => this.reset());
            this.connect(this.properties.range_padding.change, () => this.reset());
            this.connect(this.properties.range_padding_units.change, () => this.reset());
        }
        reset() {
            this._init(false);
            this.change.emit();
        }
        _lookup(x) {
            switch (x.length) {
                case 1: {
                    const [f0] = x;
                    const mapping = this._mapping;
                    const y0 = mapping.get(f0);
                    return y0 != null ? y0.value : NaN;
                }
                case 2: {
                    const [f0, f1] = x;
                    const mapping = this._mapping;
                    const y0 = mapping.get(f0);
                    if (y0 != null) {
                        const y1 = y0.mapping.get(f1);
                        if (y1 != null)
                            return y1.value;
                    }
                    return NaN;
                }
                case 3: {
                    const [f0, f1, f2] = x;
                    const mapping = this._mapping;
                    const y0 = mapping.get(f0);
                    if (y0 != null) {
                        const y1 = y0.mapping.get(f1);
                        if (y1 != null) {
                            const y2 = y1.mapping.get(f2);
                            if (y2 != null)
                                return y2.value;
                        }
                    }
                    return NaN;
                }
                default:
                    assert_1.unreachable();
            }
        }
        // convert a string factor into a synthetic coordinate
        synthetic(x) {
            if (types_2.isNumber(x))
                return x;
            if (types_2.isString(x))
                return this._lookup([x]);
            let offset = 0;
            const off = x[x.length - 1];
            if (types_2.isNumber(off)) {
                offset = off;
                x = x.slice(0, -1);
            }
            return this._lookup(x) + offset;
        }
        // convert an array of string factors into synthetic coordinates
        v_synthetic(xs) {
            const n = xs.length;
            const array = new types_1.NumberArray(n);
            for (let i = 0; i < n; i++) {
                array[i] = this.synthetic(xs[i]);
            }
            return array;
        }
        _init(silent) {
            const { levels, mapping, tops, mids, inside_padding } = (() => {
                if (array_1.every(this.factors, types_2.isString)) {
                    const factors = this.factors;
                    const [mapping, inside_padding] = map_one_level(factors, this.factor_padding);
                    const tops = null;
                    const mids = null;
                    return { levels: 1, mapping, tops, mids, inside_padding };
                }
                else if (array_1.every(this.factors, (x) => types_2.isArray(x) && x.length == 2 && types_2.isString(x[0]) && types_2.isString(x[1]))) {
                    const factors = this.factors;
                    const [mapping, inside_padding] = map_two_levels(factors, this.group_padding, this.factor_padding);
                    const tops = [...mapping.keys()];
                    const mids = null;
                    return { levels: 2, mapping, tops, mids, inside_padding };
                }
                else if (array_1.every(this.factors, (x) => types_2.isArray(x) && x.length == 3 && types_2.isString(x[0]) && types_2.isString(x[1]) && types_2.isString(x[2]))) {
                    const factors = this.factors;
                    const [mapping, inside_padding] = map_three_levels(factors, this.group_padding, this.subgroup_padding, this.factor_padding);
                    const tops = [...mapping.keys()];
                    const mids = [];
                    for (const [f0, L2] of mapping) {
                        for (const f1 of L2.mapping.keys()) {
                            mids.push([f0, f1]);
                        }
                    }
                    return { levels: 3, mapping, tops, mids, inside_padding };
                }
                else
                    assert_1.unreachable();
            })();
            this._mapping = mapping;
            this.tops = tops;
            this.mids = mids;
            let start = 0;
            let end = this.factors.length + inside_padding;
            if (this.range_padding_units == "percent") {
                const half_span = (end - start) * this.range_padding / 2;
                start -= half_span;
                end += half_span;
            }
            else {
                start -= this.range_padding;
                end += this.range_padding;
            }
            this.setv({ start, end, levels }, { silent });
            if (this.bounds == "auto")
                this.setv({ bounds: [start, end] }, { silent: true });
        }
    }
    exports.FactorRange = FactorRange;
    FactorRange.__name__ = "FactorRange";
    FactorRange.init_FactorRange();
},
/* models/ranges/range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    class Range extends model_1.Model {
        constructor(attrs) {
            super(attrs);
            this.have_updated_interactively = false;
        }
        static init_Range() {
            this.define(({ Number, Tuple, Or, Auto, Nullable }) => ({
                bounds: [Nullable(Or(Tuple(Nullable(Number), Nullable(Number)), Auto)), null],
                min_interval: [Nullable(Number), null],
                max_interval: [Nullable(Number), null],
            }));
            this.internal(({ Array, AnyRef }) => ({
                plots: [Array(AnyRef()), []],
            }));
        }
        get is_reversed() {
            return this.start > this.end;
        }
        get is_valid() {
            return !isNaN(this.min) && !isNaN(this.max);
        }
    }
    exports.Range = Range;
    Range.__name__ = "Range";
    Range.init_Range();
},
/* core/selection_manager.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const has_props_1 = require(14) /* ./has_props */;
    const selection_1 = require(94) /* ../models/selections/selection */;
    const glyph_renderer_1 = require(103) /* ../models/renderers/glyph_renderer */;
    const graph_renderer_1 = require(124) /* ../models/renderers/graph_renderer */;
    const columnar_data_source_1 = require(92) /* ../models/sources/columnar_data_source */;
    class SelectionManager extends has_props_1.HasProps {
        constructor(attrs) {
            super(attrs);
            this.inspectors = new Map();
        }
        static init_SelectionManager() {
            this.internal(({ Ref }) => ({
                source: [Ref(columnar_data_source_1.ColumnarDataSource)],
            }));
        }
        select(renderer_views, geometry, final, mode = "replace") {
            // divide renderers into glyph_renderers or graph_renderers
            const glyph_renderer_views = [];
            const graph_renderer_views = [];
            for (const r of renderer_views) {
                if (r instanceof glyph_renderer_1.GlyphRendererView)
                    glyph_renderer_views.push(r);
                else if (r instanceof graph_renderer_1.GraphRendererView)
                    graph_renderer_views.push(r);
            }
            let did_hit = false;
            // graph renderer case
            for (const r of graph_renderer_views) {
                const hit_test_result = r.model.selection_policy.hit_test(geometry, r);
                did_hit = did_hit || r.model.selection_policy.do_selection(hit_test_result, r.model, final, mode);
            }
            // glyph renderers
            if (glyph_renderer_views.length > 0) {
                const hit_test_result = this.source.selection_policy.hit_test(geometry, glyph_renderer_views);
                did_hit = did_hit || this.source.selection_policy.do_selection(hit_test_result, this.source, final, mode);
            }
            return did_hit;
        }
        inspect(renderer_view, geometry) {
            let did_hit = false;
            if (renderer_view instanceof glyph_renderer_1.GlyphRendererView) {
                const hit_test_result = renderer_view.hit_test(geometry);
                if (hit_test_result != null) {
                    did_hit = !hit_test_result.is_empty();
                    const inspection = this.get_or_create_inspector(renderer_view.model);
                    inspection.update(hit_test_result, true, "replace");
                    this.source.setv({ inspected: inspection }, { silent: true });
                    this.source.inspect.emit([renderer_view.model, { geometry }]);
                }
            }
            else if (renderer_view instanceof graph_renderer_1.GraphRendererView) {
                const hit_test_result = renderer_view.model.inspection_policy.hit_test(geometry, renderer_view);
                did_hit = did_hit || renderer_view.model.inspection_policy.do_inspection(hit_test_result, geometry, renderer_view, false, "replace");
            }
            return did_hit;
        }
        clear(rview) {
            this.source.selected.clear();
            if (rview != null)
                this.get_or_create_inspector(rview.model).clear();
        }
        get_or_create_inspector(renderer) {
            let selection = this.inspectors.get(renderer);
            if (selection == null) {
                selection = new selection_1.Selection();
                this.inspectors.set(renderer, selection);
            }
            return selection;
        }
    }
    exports.SelectionManager = SelectionManager;
    SelectionManager.__name__ = "SelectionManager";
    SelectionManager.init_SelectionManager();
},
/* models/renderers/glyph_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const data_renderer_1 = require(104) /* ./data_renderer */;
    const line_1 = require(105) /* ../glyphs/line */;
    const patch_1 = require(117) /* ../glyphs/patch */;
    const harea_1 = require(118) /* ../glyphs/harea */;
    const varea_1 = require(120) /* ../glyphs/varea */;
    const glyph_1 = require(95) /* ../glyphs/glyph */;
    const columnar_data_source_1 = require(92) /* ../sources/columnar_data_source */;
    const cds_view_1 = require(121) /* ../sources/cds_view */;
    const types_1 = require(24) /* ../../core/types */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const array_1 = require(9) /* ../../core/util/array */;
    const object_1 = require(13) /* ../../core/util/object */;
    const build_views_1 = require(123) /* ../../core/build_views */;
    const factor_range_1 = require(100) /* ../ranges/factor_range */;
    const selection_defaults = {
        fill: {},
        line: {},
    };
    const decimated_defaults = {
        fill: { fill_alpha: 0.3, fill_color: "grey" },
        line: { line_alpha: 0.3, line_color: "grey" },
    };
    const nonselection_defaults = {
        fill: { fill_alpha: 0.2 },
        line: {},
    };
    class GlyphRendererView extends data_renderer_1.DataRendererView {
        get glyph_view() {
            return this.glyph;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const base_glyph = this.model.glyph;
            const has_fill = array_1.includes(base_glyph._mixins, "fill");
            const has_line = array_1.includes(base_glyph._mixins, "line");
            const glyph_attrs = object_1.clone(base_glyph.attributes);
            delete glyph_attrs.id;
            function mk_glyph(defaults) {
                const attrs = object_1.clone(glyph_attrs);
                if (has_fill)
                    object_1.extend(attrs, defaults.fill);
                if (has_line)
                    object_1.extend(attrs, defaults.line);
                return new base_glyph.constructor(attrs);
            }
            this.glyph = await this.build_glyph_view(base_glyph);
            let { selection_glyph } = this.model;
            if (selection_glyph == null)
                selection_glyph = mk_glyph({ fill: {}, line: {} });
            else if (selection_glyph === "auto")
                selection_glyph = mk_glyph(selection_defaults);
            this.selection_glyph = await this.build_glyph_view(selection_glyph);
            let { nonselection_glyph } = this.model;
            if ((nonselection_glyph == null))
                nonselection_glyph = mk_glyph({ fill: {}, line: {} });
            else if (nonselection_glyph === "auto")
                nonselection_glyph = mk_glyph(nonselection_defaults);
            this.nonselection_glyph = await this.build_glyph_view(nonselection_glyph);
            const { hover_glyph } = this.model;
            if (hover_glyph != null)
                this.hover_glyph = await this.build_glyph_view(hover_glyph);
            const { muted_glyph } = this.model;
            if (muted_glyph != null)
                this.muted_glyph = await this.build_glyph_view(muted_glyph);
            const decimated_glyph = mk_glyph(decimated_defaults);
            this.decimated_glyph = await this.build_glyph_view(decimated_glyph);
            this.set_data(false);
        }
        async build_glyph_view(glyph) {
            return build_views_1.build_view(glyph, { parent: this });
        }
        remove() {
            var _a, _b;
            this.glyph.remove();
            this.selection_glyph.remove();
            this.nonselection_glyph.remove();
            (_a = this.hover_glyph) === null || _a === void 0 ? void 0 : _a.remove();
            (_b = this.muted_glyph) === null || _b === void 0 ? void 0 : _b.remove();
            this.decimated_glyph.remove();
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.request_render());
            this.connect(this.model.glyph.change, () => this.set_data());
            this.connect(this.model.data_source.change, () => this.set_data());
            this.connect(this.model.data_source.streaming, () => this.set_data());
            this.connect(this.model.data_source.patching, (indices /* XXX: WHY? */) => this.set_data(true, indices));
            this.connect(this.model.data_source.selected.change, () => this.request_render());
            this.connect(this.model.data_source._select, () => this.request_render());
            if (this.hover_glyph != null)
                this.connect(this.model.data_source.inspect, () => this.request_render());
            this.connect(this.model.properties.view.change, () => this.set_data());
            this.connect(this.model.view.properties.indices.change, () => this.set_data());
            this.connect(this.model.view.properties.masked.change, () => this.set_visuals());
            this.connect(this.model.properties.visible.change, () => this.plot_view.invalidate_dataranges = true);
            const { x_ranges, y_ranges } = this.plot_view.frame;
            for (const [, range] of x_ranges) {
                if (range instanceof factor_range_1.FactorRange)
                    this.connect(range.change, () => this.set_data());
            }
            for (const [, range] of y_ranges) {
                if (range instanceof factor_range_1.FactorRange)
                    this.connect(range.change, () => this.set_data());
            }
            this.connect(this.model.glyph.transformchange, () => this.set_data());
        }
        _update_masked_indices() {
            const masked = this.glyph.mask_data();
            this.model.view.masked = masked;
            return masked;
        }
        // in case of partial updates like patching, the list of indices that actually
        // changed may be passed as the "indices" parameter to afford any optional optimizations
        set_data(request_render = true, indices = null) {
            const source = this.model.data_source;
            this.all_indices = this.model.view.indices;
            const { all_indices } = this;
            this.glyph.set_data(source, all_indices, indices);
            this.set_visuals();
            this._update_masked_indices();
            const { lod_factor } = this.plot_model;
            const n = this.all_indices.count;
            this.decimated = new types_1.Indices(n);
            for (let i = 0; i < n; i += lod_factor) {
                this.decimated.set(i);
            }
            this.plot_view.invalidate_dataranges = true;
            if (request_render) {
                this.request_render();
            }
        }
        set_visuals() {
            var _a, _b, _c, _d;
            const source = this.model.data_source;
            const { all_indices } = this;
            this.glyph.set_visuals(source, all_indices);
            this.decimated_glyph.set_visuals(source, all_indices);
            (_a = this.selection_glyph) === null || _a === void 0 ? void 0 : _a.set_visuals(source, all_indices);
            (_b = this.nonselection_glyph) === null || _b === void 0 ? void 0 : _b.set_visuals(source, all_indices);
            (_c = this.hover_glyph) === null || _c === void 0 ? void 0 : _c.set_visuals(source, all_indices);
            (_d = this.muted_glyph) === null || _d === void 0 ? void 0 : _d.set_visuals(source, all_indices);
        }
        get has_webgl() {
            return this.glyph.has_webgl;
        }
        _render() {
            const glsupport = this.has_webgl;
            this.glyph.map_data();
            // all_indices is in full data space, indices is converted to subset space by mask_data (that may use the spatial index)
            const all_indices = [...this.all_indices];
            let indices = [...this._update_masked_indices()];
            const { ctx } = this.layer;
            ctx.save();
            // selected is in full set space
            const { selected } = this.model.data_source;
            let selected_full_indices;
            if (!selected || selected.is_empty())
                selected_full_indices = [];
            else {
                if (this.glyph instanceof line_1.LineView && selected.selected_glyph === this.glyph.model)
                    selected_full_indices = this.model.view.convert_indices_from_subset(indices);
                else
                    selected_full_indices = selected.indices;
            }
            // inspected is in full set space
            const { inspected } = this.model.data_source;
            const inspected_full_indices = new Set((() => {
                if (!inspected || inspected.is_empty())
                    return [];
                else {
                    if (inspected.selected_glyph)
                        return this.model.view.convert_indices_from_subset(indices);
                    else if (inspected.indices.length > 0)
                        return inspected.indices;
                    else {
                        // TODO: return inspected.multiline_indices.keys()
                        return Object.keys(inspected.multiline_indices).map((i) => parseInt(i));
                    }
                }
            })());
            // inspected is transformed to subset space
            const inspected_subset_indices = arrayable_1.filter(indices, (i) => inspected_full_indices.has(all_indices[i]));
            const { lod_threshold } = this.plot_model;
            let glyph;
            let nonselection_glyph;
            let selection_glyph;
            if ((this.model.document != null ? this.model.document.interactive_duration() > 0 : false)
                && !glsupport && lod_threshold != null && all_indices.length > lod_threshold) {
                // Render decimated during interaction if too many elements and not using GL
                indices = [...this.decimated];
                glyph = this.decimated_glyph;
                nonselection_glyph = this.decimated_glyph;
                selection_glyph = this.selection_glyph;
            }
            else {
                glyph = this.model.muted && this.muted_glyph != null ? this.muted_glyph : this.glyph;
                nonselection_glyph = this.nonselection_glyph;
                selection_glyph = this.selection_glyph;
            }
            if (this.hover_glyph != null && inspected_subset_indices.length)
                indices = array_1.difference(indices, inspected_subset_indices);
            // Render with no selection
            if (!selected_full_indices.length) {
                if (this.glyph instanceof line_1.LineView) {
                    if (this.hover_glyph && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices), this.glyph);
                    else
                        glyph.render(ctx, all_indices, this.glyph);
                }
                else if (this.glyph instanceof patch_1.PatchView || this.glyph instanceof harea_1.HAreaView || this.glyph instanceof varea_1.VAreaView) {
                    if (inspected.selected_glyphs.length == 0 || this.hover_glyph == null) {
                        glyph.render(ctx, all_indices, this.glyph);
                    }
                    else {
                        for (const sglyph of inspected.selected_glyphs) {
                            if (sglyph == this.glyph.model)
                                this.hover_glyph.render(ctx, all_indices, this.glyph);
                        }
                    }
                }
                else {
                    glyph.render(ctx, indices, this.glyph);
                    if (this.hover_glyph && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, inspected_subset_indices, this.glyph);
                }
                // Render with selection
            }
            else {
                // reset the selection mask
                const selected_mask = {};
                for (const i of selected_full_indices) {
                    selected_mask[i] = true;
                }
                // intersect/different selection with render mask
                const selected_subset_indices = new Array();
                const nonselected_subset_indices = new Array();
                // now, selected is changed to subset space, except for Line glyph
                if (this.glyph instanceof line_1.LineView) {
                    for (const i of all_indices) {
                        if (selected_mask[i] != null)
                            selected_subset_indices.push(i);
                        else
                            nonselected_subset_indices.push(i);
                    }
                }
                else {
                    for (const i of indices) {
                        if (selected_mask[all_indices[i]] != null)
                            selected_subset_indices.push(i);
                        else
                            nonselected_subset_indices.push(i);
                    }
                }
                nonselection_glyph.render(ctx, nonselected_subset_indices, this.glyph);
                selection_glyph.render(ctx, selected_subset_indices, this.glyph);
                if (this.hover_glyph != null) {
                    if (this.glyph instanceof line_1.LineView)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices), this.glyph);
                    else
                        this.hover_glyph.render(ctx, inspected_subset_indices, this.glyph);
                }
            }
            ctx.restore();
        }
        draw_legend(ctx, x0, x1, y0, y1, field, label, index) {
            if (index == null)
                index = this.model.get_reference_point(field, label);
            this.glyph.draw_legend_for_index(ctx, { x0, x1, y0, y1 }, index);
        }
        hit_test(geometry) {
            if (!this.model.visible)
                return null;
            const hit_test_result = this.glyph.hit_test(geometry);
            // glyphs that don't have hit-testing implemented will return null
            if (hit_test_result == null)
                return null;
            return this.model.view.convert_selection_from_subset(hit_test_result);
        }
    }
    exports.GlyphRendererView = GlyphRendererView;
    GlyphRendererView.__name__ = "GlyphRendererView";
    class GlyphRenderer extends data_renderer_1.DataRenderer {
        constructor(attrs) {
            super(attrs);
        }
        static init_GlyphRenderer() {
            this.prototype.default_view = GlyphRendererView;
            this.define(({ Boolean, Auto, Or, Ref, Nullable }) => ({
                data_source: [Ref(columnar_data_source_1.ColumnarDataSource)],
                view: [Ref(cds_view_1.CDSView), (self) => new cds_view_1.CDSView({ source: self.data_source })],
                glyph: [Ref(glyph_1.Glyph)],
                hover_glyph: [Nullable(Ref(glyph_1.Glyph)), null],
                nonselection_glyph: [Or(Ref(glyph_1.Glyph), Auto), "auto"],
                selection_glyph: [Or(Ref(glyph_1.Glyph), Auto), "auto"],
                muted_glyph: [Nullable(Ref(glyph_1.Glyph)), null],
                muted: [Boolean, false],
            }));
        }
        initialize() {
            super.initialize();
            if (this.view.source != this.data_source) {
                this.view.source = this.data_source;
                this.view.compute_indices();
            }
        }
        get_reference_point(field, value) {
            let index = 0;
            if (field != null) {
                const data = this.data_source.get_column(field);
                if (data != null) {
                    const i = arrayable_1.indexOf(data, value);
                    if (i != -1)
                        index = i;
                }
            }
            return index;
        }
        get_selection_manager() {
            return this.data_source.selection_manager;
        }
    }
    exports.GlyphRenderer = GlyphRenderer;
    GlyphRenderer.__name__ = "GlyphRenderer";
    GlyphRenderer.init_GlyphRenderer();
},
/* models/renderers/data_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const renderer_1 = require(69) /* ./renderer */;
    class DataRendererView extends renderer_1.RendererView {
        get xscale() {
            return this.coordinates.x_scale;
        }
        get yscale() {
            return this.coordinates.y_scale;
        }
    }
    exports.DataRendererView = DataRendererView;
    DataRendererView.__name__ = "DataRendererView";
    class DataRenderer extends renderer_1.Renderer {
        constructor(attrs) {
            super(attrs);
        }
        static init_DataRenderer() {
            this.override({
                level: 'glyph',
            });
        }
        get selection_manager() {
            return this.get_selection_manager();
        }
    }
    exports.DataRenderer = DataRenderer;
    DataRenderer.__name__ = "DataRenderer";
    DataRenderer.init_DataRenderer();
},
/* models/glyphs/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const xy_glyph_1 = require(106) /* ./xy_glyph */;
    const utils_1 = require(107) /* ./utils */;
    const line_1 = require(109) /* ./webgl/line */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    const hittest = tslib_1.__importStar(require(108) /* ../../core/hittest */);
    const selection_1 = require(94) /* ../selections/selection */;
    class LineView extends xy_glyph_1.XYGlyphView {
        initialize() {
            super.initialize();
            const { webgl } = this.renderer.plot_view.canvas_view;
            if (webgl != null) {
                this.glglyph = new line_1.LineGL(webgl.gl, this);
            }
        }
        _render(ctx, indices, { sx, sy }) {
            let drawing = false;
            let last_index = null;
            this.visuals.line.set_value(ctx);
            for (const i of indices) {
                if (drawing) {
                    if (!isFinite(sx[i] + sy[i])) {
                        ctx.stroke();
                        ctx.beginPath();
                        drawing = false;
                        last_index = i;
                        continue;
                    }
                    if (last_index != null && i - last_index > 1) {
                        ctx.stroke();
                        drawing = false;
                    }
                }
                if (drawing)
                    ctx.lineTo(sx[i], sy[i]);
                else {
                    ctx.beginPath();
                    ctx.moveTo(sx[i], sy[i]);
                    drawing = true;
                }
                last_index = i;
            }
            if (drawing)
                ctx.stroke();
        }
        _hit_point(geometry) {
            /* Check if the point geometry hits this line glyph and return an object
            that describes the hit result:
              Args:
                * geometry (object): object with the following keys
                  * sx (float): screen x coordinate of the point
                  * sy (float): screen y coordinate of the point
                  * type (str): type of geometry (in this case it's a point)
            */
            const result = new selection_1.Selection();
            const point = { x: geometry.sx, y: geometry.sy };
            let shortest = 9999;
            const threshold = Math.max(2, this.visuals.line.line_width.value() / 2);
            for (let i = 0, end = this.sx.length - 1; i < end; i++) {
                const p0 = { x: this.sx[i], y: this.sy[i] };
                const p1 = { x: this.sx[i + 1], y: this.sy[i + 1] };
                const dist = hittest.dist_to_segment(point, p0, p1);
                if (dist < threshold && dist < shortest) {
                    shortest = dist;
                    result.add_to_selected_glyphs(this.model);
                    result.view = this;
                    result.line_indices = [i];
                }
            }
            return result;
        }
        _hit_span(geometry) {
            const { sx, sy } = geometry;
            const result = new selection_1.Selection();
            let val;
            let values;
            if (geometry.direction == 'v') {
                val = this.renderer.yscale.invert(sy);
                values = this._y;
            }
            else {
                val = this.renderer.xscale.invert(sx);
                values = this._x;
            }
            for (let i = 0, end = values.length - 1; i < end; i++) {
                if ((values[i] <= val && val <= values[i + 1]) || (values[i + 1] <= val && val <= values[i])) {
                    result.add_to_selected_glyphs(this.model);
                    result.view = this;
                    result.line_indices.push(i);
                }
            }
            return result;
        }
        get_interpolation_hit(i, geometry) {
            const [x2, y2, x3, y3] = [this._x[i], this._y[i], this._x[i + 1], this._y[i + 1]];
            return utils_1.line_interpolation(this.renderer, geometry, x2, y2, x3, y3);
        }
        draw_legend_for_index(ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        }
    }
    exports.LineView = LineView;
    LineView.__name__ = "LineView";
    class Line extends xy_glyph_1.XYGlyph {
        constructor(attrs) {
            super(attrs);
        }
        static init_Line() {
            this.prototype.default_view = LineView;
            this.mixins(mixins.Line /*Scalar*/);
        }
    }
    exports.Line = Line;
    Line.__name__ = "Line";
    Line.init_Line();
},
/* models/glyphs/xy_glyph.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const projections_1 = require(36) /* ../../core/util/projections */;
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    const glyph_1 = require(95) /* ./glyph */;
    class XYGlyphView extends glyph_1.GlyphView {
        _project_data() {
            projections_1.inplace.project_xy(this._x, this._y);
        }
        _index_data(index) {
            const { data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const x = this._x[i];
                const y = this._y[i];
                if (isNaN(x + y) || !isFinite(x + y))
                    index.add_empty();
                else
                    index.add(x, y, x, y);
            }
        }
        scenterxy(i) {
            return [this.sx[i], this.sy[i]];
        }
    }
    exports.XYGlyphView = XYGlyphView;
    XYGlyphView.__name__ = "XYGlyphView";
    class XYGlyph extends glyph_1.Glyph {
        constructor(attrs) {
            super(attrs);
        }
        static init_XYGlyph() {
            this.define(({}) => ({
                x: [p.XCoordinateSpec, { field: "x" }],
                y: [p.YCoordinateSpec, { field: "y" }],
            }));
        }
    }
    exports.XYGlyph = XYGlyph;
    XYGlyph.__name__ = "XYGlyph";
    XYGlyph.init_XYGlyph();
},
/* models/glyphs/utils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const hittest = tslib_1.__importStar(require(108) /* ../../core/hittest */);
    function generic_line_legend(visuals, ctx, { x0, x1, y0, y1 }, index) {
        ctx.save();
        ctx.beginPath();
        ctx.moveTo(x0, (y0 + y1) / 2);
        ctx.lineTo(x1, (y0 + y1) / 2);
        if (visuals.line.doit) {
            visuals.line.set_vectorize(ctx, index);
            ctx.stroke();
        }
        ctx.restore();
    }
    exports.generic_line_legend = generic_line_legend;
    function generic_area_legend(visuals, ctx, { x0, x1, y0, y1 }, index) {
        const w = Math.abs(x1 - x0);
        const dw = w * 0.1;
        const h = Math.abs(y1 - y0);
        const dh = h * 0.1;
        const sx0 = x0 + dw;
        const sx1 = x1 - dw;
        const sy0 = y0 + dh;
        const sy1 = y1 - dh;
        if (visuals.fill.doit) {
            visuals.fill.set_vectorize(ctx, index);
            ctx.fillRect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        }
        if (visuals.hatch != null && visuals.hatch.doit) {
            visuals.hatch.set_vectorize(ctx, index);
            ctx.fillRect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        }
        if (visuals.line && visuals.line.doit) {
            ctx.beginPath();
            ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
            visuals.line.set_vectorize(ctx, index);
            ctx.stroke();
        }
    }
    exports.generic_area_legend = generic_area_legend;
    function line_interpolation(renderer, geometry, x2, y2, x3, y3) {
        const { sx, sy } = geometry;
        let x0, x1;
        let y0, y1;
        if (geometry.type == 'point') {
            // The +/- adjustments here are to dilate the hit point into a virtual "segment" to use below
            [y0, y1] = renderer.yscale.r_invert(sy - 1, sy + 1);
            [x0, x1] = renderer.xscale.r_invert(sx - 1, sx + 1);
        }
        else {
            // The +/- adjustments here are to handle cases such as purely horizontal or vertical lines
            if (geometry.direction == 'v') {
                [y0, y1] = renderer.yscale.r_invert(sy, sy);
                [x0, x1] = [Math.min(x2 - 1, x3 - 1), Math.max(x2 + 1, x3 + 1)];
            }
            else {
                [x0, x1] = renderer.xscale.r_invert(sx, sx);
                [y0, y1] = [Math.min(y2 - 1, y3 - 1), Math.max(y2 + 1, y3 + 1)];
            }
        }
        const { x, y } = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3);
        return [x, y]; // XXX: null is not handled at use sites
    }
    exports.line_interpolation = line_interpolation;
},
/* core/hittest.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function point_in_poly(x, y, px, py) {
        let inside = false;
        let x1 = px[px.length - 1];
        let y1 = py[py.length - 1];
        for (let i = 0; i < px.length; i++) {
            const x2 = px[i];
            const y2 = py[i];
            if ((y1 < y) != (y2 < y)) {
                if ((x1 + (y - y1) / (y2 - y1) * (x2 - x1)) < x)
                    inside = !inside;
            }
            x1 = x2;
            y1 = y2;
        }
        return inside;
    }
    exports.point_in_poly = point_in_poly;
    function point_in_ellipse(x, y, angle, b, a, x0, y0) {
        const A = ((Math.cos(angle) / a) ** 2 + (Math.sin(angle) / b) ** 2);
        const B = 2 * Math.cos(angle) * Math.sin(angle) * ((1 / a) ** 2 - (1 / b) ** 2);
        const C = ((Math.cos(angle) / b) ** 2 + (Math.sin(angle) / a) ** 2);
        const eqn = A * (x - x0) ** 2 + B * (x - x0) * (y - y0) + C * (y - y0) ** 2;
        const inside = eqn <= 1;
        return inside;
    }
    exports.point_in_ellipse = point_in_ellipse;
    function dist_2_pts(p0, p1) {
        return (p0.x - p1.x) ** 2 + (p0.y - p1.y) ** 2;
    }
    exports.dist_2_pts = dist_2_pts;
    function dist_to_segment_squared(p, v, w) {
        const l2 = dist_2_pts(v, w);
        if (l2 == 0)
            return dist_2_pts(p, v);
        const t = ((p.x - v.x) * (w.x - v.x) + (p.y - v.y) * (w.y - v.y)) / l2;
        if (t < 0)
            return dist_2_pts(p, v);
        if (t > 1)
            return dist_2_pts(p, w);
        const q = { x: v.x + t * (w.x - v.x), y: v.y + t * (w.y - v.y) };
        return dist_2_pts(p, q);
    }
    exports.dist_to_segment_squared = dist_to_segment_squared;
    function dist_to_segment(p, v, w) {
        return Math.sqrt(dist_to_segment_squared(p, v, w));
    }
    exports.dist_to_segment = dist_to_segment;
    function check_2_segments_intersect(l0_x0, l0_y0, l0_x1, l0_y1, l1_x0, l1_y0, l1_x1, l1_y1) {
        /*
         *  Check if 2 segments (l0 and l1) intersect. Returns a structure with
         *  the following attributes:
         *   * hit (boolean): whether the 2 segments intersect
         *   * x (float): x coordinate of the intersection point
         *   * y (float): y coordinate of the intersection point
         */
        const den = ((l1_y1 - l1_y0) * (l0_x1 - l0_x0)) - ((l1_x1 - l1_x0) * (l0_y1 - l0_y0));
        if (den == 0) {
            return { hit: false, x: null, y: null };
        }
        else {
            let a = l0_y0 - l1_y0;
            let b = l0_x0 - l1_x0;
            const num1 = ((l1_x1 - l1_x0) * a) - ((l1_y1 - l1_y0) * b);
            const num2 = ((l0_x1 - l0_x0) * a) - ((l0_y1 - l0_y0) * b);
            a = num1 / den;
            b = num2 / den;
            const x = l0_x0 + (a * (l0_x1 - l0_x0));
            const y = l0_y0 + (a * (l0_y1 - l0_y0));
            return { hit: (a > 0 && a < 1) && (b > 0 && b < 1), x, y };
        }
    }
    exports.check_2_segments_intersect = check_2_segments_intersect;
},
/* models/glyphs/webgl/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const utils_1 = require(110) /* ./utils */;
    const base_1 = require(114) /* ./base */;
    const line_vert_1 = require(115) /* ./line.vert */;
    const line_frag_1 = require(116) /* ./line.frag */;
    const color_1 = require(22) /* ../../../core/util/color */;
    class DashAtlas {
        constructor(gl) {
            this._atlas = new Map();
            this._width = 256;
            this._height = 256;
            // Init texture
            this.tex = new utils_1.Texture2d(gl);
            this.tex.set_wrapping(gl.REPEAT, gl.REPEAT);
            this.tex.set_interpolation(gl.NEAREST, gl.NEAREST);
            this.tex.set_size([this._width, this._height], gl.RGBA);
            this.tex.set_data([0, 0], [this._width, this._height], new Uint8Array(4 * this._width * this._height));
            // Init with solid line (index 0 is reserved for this)
            this.get_atlas_data([1]);
        }
        get_atlas_data(pattern) {
            const key = pattern.join("-");
            let atlas_data = this._atlas.get(key);
            if (atlas_data == null) {
                const [data, period] = this.make_pattern(pattern);
                const index = this._atlas.size;
                this.tex.set_data([0, index], [this._width, 1], new Uint8Array(data.map((x) => x + 10)));
                atlas_data = [index / this._height, period];
                this._atlas.set(key, atlas_data);
            }
            return atlas_data;
        }
        make_pattern(pattern) {
            // A pattern is defined as on/off sequence of segments
            // It must be a multiple of 2
            if (pattern.length > 1 && pattern.length % 2) {
                pattern = pattern.concat(pattern);
            }
            // Period is sum of elements
            let period = 0;
            for (const v of pattern) {
                period += v;
            }
            // Find all start and end of on-segment only
            const C = [];
            let c = 0;
            for (let i = 0, end = pattern.length + 2; i < end; i += 2) {
                const a = Math.max(0.0001, pattern[i % pattern.length]);
                const b = Math.max(0.0001, pattern[(i + 1) % pattern.length]);
                C.push(c, c + a);
                c += a + b;
            }
            // Build pattern
            const n = this._width;
            const Z = new Float32Array(n * 4);
            for (let i = 0, end = n; i < end; i++) {
                let dash_end, dash_start, dash_type;
                const x = (period * i) / (n - 1);
                // get index at min - index = np.argmin(abs(C-(x)))
                let index = 0;
                let val_at_index = 1e16;
                for (let j = 0, endj = C.length; j < endj; j++) {
                    const val = Math.abs(C[j] - x);
                    if (val < val_at_index) {
                        index = j;
                        val_at_index = val;
                    }
                }
                if ((index % 2) === 0) {
                    dash_type = (x <= C[index]) ? +1 : 0;
                    dash_start = C[index];
                    dash_end = C[index + 1];
                }
                else {
                    dash_type = (x > C[index]) ? -1 : 0;
                    dash_start = C[index - 1];
                    dash_end = C[index];
                }
                Z[(i * 4) + 0] = C[index];
                Z[(i * 4) + 1] = dash_type;
                Z[(i * 4) + 2] = dash_start;
                Z[(i * 4) + 3] = dash_end;
            }
            return [Z, period];
        }
    }
    DashAtlas.__name__ = "DashAtlas";
    const joins = { miter: 0, round: 1, bevel: 2 };
    const caps = {
        '': 0, none: 0, '.': 0,
        round: 1, ')': 1, '(': 1, o: 1,
        'triangle in': 2, '<': 2,
        'triangle out': 3, '>': 3,
        square: 4, '[': 4, ']': 4, '=': 4,
        butt: 5, '|': 5,
    };
    class LineGL extends base_1.BaseGLGlyph {
        init() {
            const { gl } = this;
            this._scale_aspect = 0; // keep track, so we know when we need to update segment data
            const vert = line_vert_1.vertex_shader;
            const frag = line_frag_1.fragment_shader;
            // The program
            this.prog = new utils_1.Program(gl);
            this.prog.set_shaders(vert, frag);
            this.index_buffer = new utils_1.IndexBuffer(gl);
            // Buffers
            this.vbo_position = new utils_1.VertexBuffer(gl);
            this.vbo_tangents = new utils_1.VertexBuffer(gl);
            this.vbo_segment = new utils_1.VertexBuffer(gl);
            this.vbo_angles = new utils_1.VertexBuffer(gl);
            this.vbo_texcoord = new utils_1.VertexBuffer(gl);
            // Dash atlas
            this.dash_atlas = new DashAtlas(gl);
        }
        draw(indices, mainGlyph, trans) {
            const mainGlGlyph = mainGlyph.glglyph;
            if (mainGlGlyph.data_changed) {
                mainGlGlyph._set_data();
                mainGlGlyph.data_changed = false;
            }
            if (this.visuals_changed) {
                this._set_visuals();
                this.visuals_changed = false;
            }
            mainGlGlyph._update_scale(1, 1);
            this._scale_aspect = 1;
            // Select buffers from main glyph
            // (which may be this glyph but maybe not if this is a (non)selection glyph)
            this.prog.set_attribute('a_position', 'vec2', mainGlGlyph.vbo_position);
            this.prog.set_attribute('a_tangents', 'vec4', mainGlGlyph.vbo_tangents);
            this.prog.set_attribute('a_segment', 'vec2', mainGlGlyph.vbo_segment);
            this.prog.set_attribute('a_angles', 'vec2', mainGlGlyph.vbo_angles);
            this.prog.set_attribute('a_texcoord', 'vec2', mainGlGlyph.vbo_texcoord);
            //
            this.prog.set_uniform('u_length', 'float', [mainGlGlyph.cumsum]);
            this.prog.set_texture('u_dash_atlas', this.dash_atlas.tex);
            // Handle transformation to device coordinates
            this.prog.set_uniform('u_pixel_ratio', 'float', [trans.pixel_ratio]);
            this.prog.set_uniform('u_canvas_size', 'vec2', [trans.width, trans.height]);
            this.prog.set_uniform('u_scale_aspect', 'vec2', [1, 1]);
            this.prog.set_uniform('u_scale_length', 'float', [Math.sqrt(2)]);
            this.I_triangles = mainGlGlyph.I_triangles;
            if (this.I_triangles.length < 65535) {
                // Data is small enough to draw in one pass
                this.index_buffer.set_size(this.I_triangles.length * 2);
                this.index_buffer.set_data(0, new Uint16Array(this.I_triangles));
                this.prog.draw(this.gl.TRIANGLES, this.index_buffer);
                // @prog.draw(@gl.LINE_STRIP, @index_buffer)  # Use this to draw the line skeleton
            }
            else {
                // Work around the limit that the indexbuffer must be uint16. We draw in chunks.
                // First collect indices in chunks
                indices = Array.from(this.I_triangles);
                const nvertices = this.I_triangles.length;
                const chunksize = 64008; // 65536 max. 64008 is divisible by 12
                const chunks = [];
                for (let i = 0, end = Math.ceil(nvertices / chunksize); i < end; i++) {
                    chunks.push([]);
                }
                for (let i = 0, end = indices.length; i < end; i++) {
                    const uint16_index = indices[i] % chunksize;
                    const chunk = Math.floor(indices[i] / chunksize);
                    chunks[chunk].push(uint16_index);
                }
                // Then draw each chunk
                for (let chunk = 0, end = chunks.length; chunk < end; chunk++) {
                    const these_indices = new Uint16Array(chunks[chunk]);
                    const offset = chunk * chunksize * 4;
                    if (these_indices.length === 0) {
                        continue;
                    }
                    this.prog.set_attribute('a_position', 'vec2', mainGlGlyph.vbo_position, 0, offset * 2);
                    this.prog.set_attribute('a_tangents', 'vec4', mainGlGlyph.vbo_tangents, 0, offset * 4);
                    this.prog.set_attribute('a_segment', 'vec2', mainGlGlyph.vbo_segment, 0, offset * 2);
                    this.prog.set_attribute('a_angles', 'vec2', mainGlGlyph.vbo_angles, 0, offset * 2);
                    this.prog.set_attribute('a_texcoord', 'vec2', mainGlGlyph.vbo_texcoord, 0, offset * 2);
                    // The actual drawing
                    this.index_buffer.set_size(these_indices.length * 2);
                    this.index_buffer.set_data(0, these_indices);
                    this.prog.draw(this.gl.TRIANGLES, this.index_buffer);
                }
            }
        }
        _set_data() {
            this._bake();
            this.vbo_position.set_size(this.V_position.length * 4);
            this.vbo_position.set_data(0, this.V_position);
            this.vbo_tangents.set_size(this.V_tangents.length * 4);
            this.vbo_tangents.set_data(0, this.V_tangents);
            this.vbo_angles.set_size(this.V_angles.length * 4);
            this.vbo_angles.set_data(0, this.V_angles);
            this.vbo_texcoord.set_size(this.V_texcoord.length * 4);
            this.vbo_texcoord.set_data(0, this.V_texcoord);
        }
        _set_visuals() {
            const color = color_1.color2rgba(this.glyph.visuals.line.line_color.value(), this.glyph.visuals.line.line_alpha.value());
            const cap = caps[this.glyph.visuals.line.line_cap.value()];
            const join = joins[this.glyph.visuals.line.line_join.value()];
            this.prog.set_uniform('u_color', 'vec4', color);
            this.prog.set_uniform('u_linewidth', 'float', [this.glyph.visuals.line.line_width.value()]);
            this.prog.set_uniform('u_antialias', 'float', [0.9]); // Smaller aa-region to obtain crisper images
            this.prog.set_uniform('u_linecaps', 'vec2', [cap, cap]);
            this.prog.set_uniform('u_linejoin', 'float', [join]);
            this.prog.set_uniform('u_miter_limit', 'float', [10.0]); // 10 should be a good value
            // https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-miterlimit
            const dash_pattern = this.glyph.visuals.line.line_dash.value();
            let dash_index = 0;
            let dash_period = 1;
            if (dash_pattern.length) {
                [dash_index, dash_period] = this.dash_atlas.get_atlas_data(dash_pattern);
            }
            this.prog.set_uniform('u_dash_index', 'float', [dash_index]); // 0 means solid line
            this.prog.set_uniform('u_dash_phase', 'float', [this.glyph.visuals.line.line_dash_offset.value()]);
            this.prog.set_uniform('u_dash_period', 'float', [dash_period]);
            this.prog.set_uniform('u_dash_caps', 'vec2', [cap, cap]);
            this.prog.set_uniform('u_closed', 'float', [0]); // We dont do closed lines
        }
        _bake() {
            // This is what you get if you port 50 lines of numpy code to JS.
            // V_segment is handled in another method, because it depends on the aspect
            // ratio of the scale (The original paper/code assumed isotropic scaling).
            //
            // Buffer dtype from the Python implementation:
            //
            // self.vtype = np.dtype( [('a_position', 'f4', 2),
            //                         ('a_segment',  'f4', 2),
            //                         ('a_angles',   'f4', 2),
            //                         ('a_tangents', 'f4', 4),
            //                         ('a_texcoord', 'f4', 2) ])
            // Init array of implicit shape nx2
            let I, T, V_angles2, V_position2, V_tangents2, V_texcoord2, Vp, Vt;
            const n = this.nvertices;
            const sx = this.glyph.sx;
            const sy = this.glyph.sy;
            // Init vertex data
            const V_position = (Vp = new Float32Array(n * 2));
            //V_segment = new Float32Array(n*2)  # Done later
            const V_angles = new Float32Array(n * 2);
            const V_tangents = (Vt = new Float32Array(n * 4)); // mind the 4!
            // Position
            for (let i = 0, end = n; i < end; i++) {
                V_position[(i * 2) + 0] = sx[i];
                V_position[(i * 2) + 1] = sy[i];
            }
            // Tangents & norms (need tangents to calculate segments based on scale)
            this.tangents = (T = new Float32Array((n * 2) - 2));
            for (let i = 0, end = n - 1; i < end; i++) {
                T[(i * 2) + 0] = Vp[((i + 1) * 2) + 0] - Vp[(i * 2) + 0];
                T[(i * 2) + 1] = Vp[((i + 1) * 2) + 1] - Vp[(i * 2) + 1];
            }
            for (let i = 0, end = n - 1; i < end; i++) {
                // V['a_tangents'][+1:, :2] = T
                V_tangents[((i + 1) * 4) + 0] = T[(i * 2) + 0];
                V_tangents[((i + 1) * 4) + 1] = T[(i * 2) + 1];
                // V['a_tangents'][:-1, 2:] = T
                V_tangents[(i * 4) + 2] = T[(i * 2) + 0];
                V_tangents[(i * 4) + 3] = T[(i * 2) + 1];
            }
            // V['a_tangents'][0  , :2] = T[0]
            V_tangents[(0 * 4) + 0] = T[0];
            V_tangents[(0 * 4) + 1] = T[1];
            // V['a_tangents'][ -1, 2:] = T[-1]
            V_tangents[((n - 1) * 4) + 2] = T[((n - 2) * 2) + 0];
            V_tangents[((n - 1) * 4) + 3] = T[((n - 2) * 2) + 1];
            // Angles
            const A = new Float32Array(n);
            for (let i = 0, end = n; i < end; i++) {
                A[i] = Math.atan2((Vt[(i * 4) + 0] * Vt[(i * 4) + 3]) - (Vt[(i * 4) + 1] * Vt[(i * 4) + 2]), (Vt[(i * 4) + 0] * Vt[(i * 4) + 2]) + (Vt[(i * 4) + 1] * Vt[(i * 4) + 3]));
            }
            for (let i = 0, end = n - 1; i < end; i++) {
                V_angles[(i * 2) + 0] = A[i];
                V_angles[(i * 2) + 1] = A[i + 1];
            }
            // Step 1: A -- B -- C  =>  A -- B, B' -- C
            // Repeat our array 4 times
            const m = (4 * n) - 4;
            this.V_position = (V_position2 = new Float32Array(m * 2));
            this.V_angles = (V_angles2 = new Float32Array(m * 2));
            this.V_tangents = (V_tangents2 = new Float32Array(m * 4)); // mind the 4!
            this.V_texcoord = (V_texcoord2 = new Float32Array(m * 2));
            const o = 2;
            //
            // Arg, we really need an ndarray thing in JS :/
            for (let i = 0, end = n; i < end; i++) { // all nodes on the line
                for (let j = 0; j < 4; j++) { // the four quad vertices
                    for (let k = 0; k < 2; k++) { // xy
                        V_position2[((((i * 4) + j) - o) * 2) + k] = V_position[(i * 2) + k];
                        V_angles2[(((i * 4) + j) * 2) + k] = V_angles[(i * 2) + k];
                    } // no offset
                    for (let k = 0; k < 4; k++) {
                        V_tangents2[((((i * 4) + j) - o) * 4) + k] = V_tangents[(i * 4) + k];
                    }
                }
            }
            for (let i = 0, end = n; i < end; i++) {
                V_texcoord2[(((i * 4) + 0) * 2) + 0] = -1;
                V_texcoord2[(((i * 4) + 1) * 2) + 0] = -1;
                V_texcoord2[(((i * 4) + 2) * 2) + 0] = +1;
                V_texcoord2[(((i * 4) + 3) * 2) + 0] = +1;
                //
                V_texcoord2[(((i * 4) + 0) * 2) + 1] = -1;
                V_texcoord2[(((i * 4) + 1) * 2) + 1] = +1;
                V_texcoord2[(((i * 4) + 2) * 2) + 1] = -1;
                V_texcoord2[(((i * 4) + 3) * 2) + 1] = +1;
            }
            // Indices
            //I = np.resize( np.array([0,1,2,1,2,3], dtype=np.uint32), (n-1)*(2*3))
            //I += np.repeat( 4*np.arange(n-1), 6)
            const ni = (n - 1) * 6;
            this.I_triangles = (I = new Uint32Array(ni));
            // Order of indices is such that drawing as line_strip reveals the line skeleton
            // Might have implications on culling, if we ever turn that on.
            // Order in paper was: 0 1 2 1 2 3
            for (let i = 0, end = n; i < end; i++) {
                I[(i * 6) + 0] = 0 + (4 * i);
                I[(i * 6) + 1] = 1 + (4 * i);
                I[(i * 6) + 2] = 3 + (4 * i);
                I[(i * 6) + 3] = 2 + (4 * i);
                I[(i * 6) + 4] = 0 + (4 * i);
                I[(i * 6) + 5] = 3 + (4 * i);
            }
        }
        _update_scale(sx, sy) {
            // Update segment data and cumsum so the length along the line has the
            // scale aspect ratio in it. In the vertex shader we multiply with the
            // "isotropic part" of the scale.
            let V_segment2;
            const n = this.nvertices;
            const m = (4 * n) - 4;
            // Prepare arrays
            const T = this.tangents;
            const N = new Float32Array(n - 1);
            const V_segment = new Float32Array(n * 2); // Elements are initialized with 0
            this.V_segment = (V_segment2 = new Float32Array(m * 2));
            // Calculate vector lengths - with scale aspect ratio taken into account
            for (let i = 0, end = n - 1; i < end; i++) {
                N[i] = Math.sqrt((T[(i * 2) + 0] * sx) ** 2 + (T[(i * 2) + 1] * sy) ** 2);
            }
            // Calculate Segments
            let cumsum = 0;
            for (let i = 0, end = n - 1; i < end; i++) {
                cumsum += N[i];
                V_segment[((i + 1) * 2) + 0] = cumsum;
                V_segment[(i * 2) + 1] = cumsum;
            }
            // Upscale (same loop as in _bake())
            for (let i = 0, end = n; i < end; i++) {
                for (let j = 0; j < 4; j++) {
                    for (let k = 0; k < 2; k++) {
                        V_segment2[(((i * 4) + j) * 2) + k] = V_segment[(i * 2) + k];
                    }
                }
            }
            // Update
            this.cumsum = cumsum; // L[-1] in Nico's code
            this.vbo_segment.set_size(this.V_segment.length * 4);
            this.vbo_segment.set_data(0, this.V_segment);
        }
    }
    exports.LineGL = LineGL;
    LineGL.__name__ = "LineGL";
},
/* models/glyphs/webgl/utils/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var program_1 = require(111) /* ./program */;
    __esExport("Program", program_1.Program);
    var texture_1 = require(113) /* ./texture */;
    __esExport("Texture2d", texture_1.Texture2d);
    var buffer_1 = require(112) /* ./buffer */;
    __esExport("IndexBuffer", buffer_1.IndexBuffer);
    __esExport("VertexBuffer", buffer_1.VertexBuffer);
},
/* models/glyphs/webgl/utils/program.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const buffer_1 = require(112) /* ./buffer */;
    class Program {
        constructor(gl) {
            this.gl = gl;
            this.UTYPEMAP = {
                float: "uniform1fv",
                vec2: "uniform2fv",
                vec3: "uniform3fv",
                vec4: "uniform4fv",
                int: "uniform1iv",
                ivec2: "uniform2iv",
                ivec3: "uniform3iv",
                ivec4: "uniform4iv",
                bool: "uniform1iv",
                bvec2: "uniform2iv",
                bvec3: "uniform3iv",
                bvec4: "uniform4iv",
                mat2: "uniformMatrix2fv",
                mat3: "uniformMatrix3fv",
                mat4: "uniformMatrix4fv",
                sampler1D: "uniform1i",
                sampler2D: "uniform1i",
                sampler3D: "uniform1i",
            };
            this.ATYPEMAP = {
                float: "vertexAttrib1f",
                vec2: "vertexAttrib2f",
                vec3: "vertexAttrib3f",
                vec4: "vertexAttrib4f",
            };
            this.ATYPEINFO = {
                float: [1, 5126],
                vec2: [2, 5126],
                vec3: [3, 5126],
                vec4: [4, 5126],
            };
            this._linked = false;
            this._validated = false;
            this._unset_variables = new Set();
            this._known_invalid = new Set();
            this._locations = new Map();
            this._samplers = new Map();
            this._attributes = new Map();
            this.handle = this.gl.createProgram();
        }
        delete() {
            this.gl.deleteProgram(this.handle);
        }
        activate() {
            this.gl.useProgram(this.handle);
        }
        deactivate() {
            this.gl.useProgram(0);
        }
        set_shaders(vert, frag) {
            // Set GLSL code for the vertex and fragment shader.
            //
            // This function takes care of setting the shading code and
            // compiling+linking it into a working program object that is ready
            // to use.
            //
            // Parameters
            // ----------
            // vert : str
            //     GLSL code for the vertex shader.
            // frag : str
            //     GLSL code for the fragment shader.
            const gl = this.gl;
            this._linked = false;
            const vert_handle = gl.createShader(gl.VERTEX_SHADER);
            const frag_handle = gl.createShader(gl.FRAGMENT_SHADER);
            const tmp = [
                [vert, vert_handle, "vertex"],
                [frag, frag_handle, "fragment"],
            ];
            for (const [code, handle, type] of tmp) {
                gl.shaderSource(handle, code);
                gl.compileShader(handle);
                const status = gl.getShaderParameter(handle, gl.COMPILE_STATUS);
                if (!status) {
                    const errors = gl.getShaderInfoLog(handle);
                    throw new Error(`errors in ${type} shader:\n${errors}`);
                }
            }
            gl.attachShader(this.handle, vert_handle);
            gl.attachShader(this.handle, frag_handle);
            gl.linkProgram(this.handle);
            if (!gl.getProgramParameter(this.handle, gl.LINK_STATUS)) {
                const logs = gl.getProgramInfoLog(this.handle);
                throw new Error(`Program link error:\n${logs}`);
            }
            this._unset_variables = this._get_active_attributes_and_uniforms();
            gl.detachShader(this.handle, vert_handle);
            gl.detachShader(this.handle, frag_handle);
            gl.deleteShader(vert_handle);
            gl.deleteShader(frag_handle);
            this._known_invalid.clear();
            this._linked = true;
        }
        _get_active_attributes_and_uniforms() {
            // Retrieve active attributes and uniforms to be able to check that
            // all uniforms/attributes are set by the user.
            const gl = this.gl;
            this._locations.clear();
            const regex = new RegExp("(\\w+)\\s*(\\[(\\d+)\\])\\s*");
            const cu = gl.getProgramParameter(this.handle, gl.ACTIVE_UNIFORMS);
            const ca = gl.getProgramParameter(this.handle, gl.ACTIVE_ATTRIBUTES);
            const attributes = [];
            const uniforms = [];
            const stub5_seq = [
                [attributes, ca, gl.getActiveAttrib, gl.getAttribLocation],
                [uniforms, cu, gl.getActiveUniform, gl.getUniformLocation],
            ];
            for (const [container, count, getActive, getLocation] of stub5_seq) {
                for (let i = 0; i < count; i += 1) {
                    const info = getActive.call(gl, this.handle, i);
                    const name = info.name;
                    const m = name.match(regex);
                    if (m != null) {
                        const name = m[1];
                        for (let j = 0; j < info.size; j += 1) {
                            container.push([`${name}[${j}]`, info.type]);
                        }
                    }
                    else {
                        container.push([name, info.type]);
                    }
                    this._locations.set(name, getLocation.call(gl, this.handle, name));
                }
            }
            const attrs_and_uniforms = new Set();
            for (const [name] of attributes) {
                attrs_and_uniforms.add(name);
            }
            for (const [name] of uniforms) {
                attrs_and_uniforms.add(name);
            }
            return attrs_and_uniforms;
        }
        set_texture(name, value) {
            var _a;
            // Set a texture sampler.
            //
            // A texture is a 2 dimensional grid of colors/intensities that
            // can be applied to a face (or used for other means by providing
            // a regular grid of data).
            //
            // Parameters
            // ----------
            // name : str
            //     The name by which the texture is known in the GLSL code.
            // value : Texture2d
            //     The Texture2d object to bind.
            if (!this._linked) {
                throw new Error("Cannot set uniform when program has no code");
            }
            const handle = (_a = this._locations.get(name)) !== null && _a !== void 0 ? _a : -1;
            if (handle < 0) {
                if (!this._known_invalid.has(name)) {
                    this._known_invalid.add(name);
                    console.log(`"Variable ${name} is not an active texture`);
                }
                return;
            }
            if (this._unset_variables.has(name)) {
                this._unset_variables.delete(name);
            }
            this.activate();
            if (true) {
                let unit = this._samplers.size;
                if (this._samplers.has(name)) {
                    unit = this._samplers.get(name)[2];
                }
                this._samplers.set(name, [value._target, value.handle, unit]);
                this.gl.uniform1i(handle, unit);
            }
        }
        set_uniform(name, type_, value) {
            var _a;
            // Set a uniform value.
            //
            // A uniform is a value that is global to both the vertex and
            // fragment shader.
            //
            // Parameters
            // ----------
            // name : str
            //     The name by which the uniform is known in the GLSL code.
            // type_ : str
            //     The type of the uniform, e.g. 'float', 'vec2', etc.
            // value : list of scalars
            //     The value for the uniform. Should be a list even for type float.
            if (!this._linked) {
                throw new Error("Cannot set uniform when program has no code");
            }
            const handle = (_a = this._locations.get(name)) !== null && _a !== void 0 ? _a : -1;
            if (handle < 0) {
                if (!this._known_invalid.has(name)) {
                    this._known_invalid.add(name);
                    console.log(`Variable ${name} is not an active uniform`);
                }
                return;
            }
            if (this._unset_variables.has(name)) {
                this._unset_variables.delete(name);
            }
            let count = 1;
            if (!type_.startsWith("mat")) {
                const a_type = type_ == "int" || type_ == "bool" ? "float" : type_.replace(/^ib/, "");
                count = Math.floor(value.length / (this.ATYPEINFO[a_type][0]));
            }
            if (count > 1) {
                for (let j = 0; j < count; j += 1) {
                    if (this._unset_variables.has(`${name}[${j}]`)) {
                        const name_ = `${name}[${j}]`;
                        if (this._unset_variables.has(name_)) {
                            this._unset_variables.delete(name_);
                        }
                    }
                }
            }
            const funcname = this.UTYPEMAP[type_];
            this.activate();
            if (type_.startsWith("mat")) {
                this.gl[funcname](handle, false, value);
            }
            else {
                this.gl[funcname](handle, value);
            }
        }
        set_attribute(name, type_, value, stride = 0, offset = 0) {
            var _a;
            // Set an attribute value.
            //
            // An attribute represents per-vertex data and can only be used
            // in the vertex shader.
            //
            // Parameters
            // ----------
            // name : str
            //     The name by which the attribute is known in the GLSL code.
            // type_ : str
            //     The type of the attribute, e.g. 'float', 'vec2', etc.
            // value : VertexBuffer, array
            //     If value is a VertexBuffer, it is used (with stride and offset)
            //     for the vertex data. If value is an array, its used to set
            //     the value of all vertices (similar to a uniform).
            // stide : int, default 0
            //     The stride to "sample" the vertex data inside the buffer. Unless
            //     multiple vertex data are packed into a single buffer, this should
            //     be zero.
            // offset : int, default 0
            //     The offset to "sample" the vertex data inside the buffer. Unless
            //     multiple vertex data are packed into a single buffer, or only
            //     a part of the data must be used, this should probably be zero.
            if (!this._linked) {
                throw new Error("Cannot set attribute when program has no code");
            }
            const handle = (_a = this._locations.get(name)) !== null && _a !== void 0 ? _a : -1;
            if (handle < 0) {
                if (!this._known_invalid.has(name)) {
                    this._known_invalid.add(name);
                    if (value instanceof buffer_1.VertexBuffer && offset > 0) {
                    }
                    else {
                        console.log(`Variable ${name} is not an active attribute`);
                    }
                }
                return;
            }
            if (this._unset_variables.has(name)) {
                this._unset_variables.delete(name);
            }
            this.activate();
            if (!(value instanceof buffer_1.VertexBuffer)) {
                const funcname = this.ATYPEMAP[type_];
                this._attributes.set(name, [null, handle, funcname, value]);
            }
            else {
                const [size, gtype] = this.ATYPEINFO[type_];
                const funcname = "vertexAttribPointer";
                const args = [size, gtype, false, stride, offset];
                this._attributes.set(name, [value.handle, handle, funcname, args]);
            }
        }
        _pre_draw() {
            this.activate();
            for (const [tex_target, tex_handle, unit] of this._samplers.values()) {
                this.gl.activeTexture(this.gl.TEXTURE0 + unit);
                this.gl.bindTexture(tex_target, tex_handle);
            }
            for (const [vbo_handle, attr_handle, funcname, args] of this._attributes.values()) {
                if (vbo_handle != null) {
                    this.gl.bindBuffer(this.gl.ARRAY_BUFFER, vbo_handle);
                    this.gl.enableVertexAttribArray(attr_handle);
                    this.gl[funcname].apply(this.gl, [attr_handle, ...args]);
                }
                else {
                    this.gl.bindBuffer(this.gl.ARRAY_BUFFER, null);
                    this.gl.disableVertexAttribArray(attr_handle);
                    this.gl[funcname].apply(this.gl, [attr_handle, ...args]);
                }
            }
            if (!this._validated) {
                this._validated = true;
                this._validate();
            }
        }
        _validate() {
            if (this._unset_variables.size) {
                console.log(`Program has unset variables: ${this._unset_variables}`);
            }
            this.gl.validateProgram(this.handle);
            if (!this.gl.getProgramParameter(this.handle, this.gl.VALIDATE_STATUS)) {
                console.log(this.gl.getProgramInfoLog(this.handle));
                throw new Error("Program validation error");
            }
        }
        draw(mode, selection) {
            // Draw the current visualization defined by the program.
            //
            // Parameters
            // ----------
            // mode : GL enum
            //     Can be POINTS, LINES, LINE_LOOP, LINE_STRIP, LINE_FAN, TRIANGLES
            // selection : 2-element tuple or IndexBuffer
            //     The selection to draw, specified either as (first, count) or an
            //     IndexBuffer object.
            if (!this._linked) {
                throw new Error("Cannot draw program if code has not been set");
            }
            if (selection instanceof buffer_1.IndexBuffer) {
                this._pre_draw();
                selection.activate();
                const count = selection.buffer_size / 2;
                const gtype = this.gl.UNSIGNED_SHORT;
                this.gl.drawElements(mode, count, gtype, 0);
                selection.deactivate();
            }
            else {
                const [first, count] = selection;
                if (count != 0) {
                    this._pre_draw();
                    this.gl.drawArrays(mode, first, count);
                }
            }
        }
    }
    exports.Program = Program;
    Program.__name__ = "Program";
},
/* models/glyphs/webgl/utils/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class Buffer {
        constructor(gl) {
            this.gl = gl;
            this._usage = 35048;
            this.buffer_size = 0;
            this.handle = this.gl.createBuffer();
        }
        delete() {
            this.gl.deleteBuffer(this.handle);
        }
        activate() {
            this.gl.bindBuffer(this._target, this.handle);
        }
        deactivate() {
            this.gl.bindBuffer(this._target, null);
        }
        set_size(nbytes) {
            // Set the size of the buffer in bytes.
            //
            // Parameters
            // ----------
            // nbytes : int
            //     The number of bytes that the buffer needs to hold.
            if (nbytes != this.buffer_size) {
                this.activate();
                this.gl.bufferData(this._target, nbytes, this._usage);
                this.buffer_size = nbytes;
            }
        }
        set_data(offset, data) {
            // Set the buffer data.
            //
            // Parameters
            // ----------
            // offset : int
            //     The offset in bytes for the new data.
            // data : typed array
            //     The data to upload.
            this.activate();
            this.gl.bufferSubData(this._target, offset, data);
        }
    }
    exports.Buffer = Buffer;
    Buffer.__name__ = "Buffer";
    class VertexBuffer extends Buffer {
        constructor() {
            super(...arguments);
            this._target = 34962;
        }
    }
    exports.VertexBuffer = VertexBuffer;
    VertexBuffer.__name__ = "VertexBuffer";
    class IndexBuffer extends Buffer {
        constructor() {
            super(...arguments);
            this._target = 34963;
        }
    }
    exports.IndexBuffer = IndexBuffer;
    IndexBuffer.__name__ = "IndexBuffer";
},
/* models/glyphs/webgl/utils/texture.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const assert_1 = require(11) /* ../../../../core/util/assert */;
    class Texture2d {
        constructor(gl) {
            this.gl = gl;
            this._target = 3553;
            this._types = {
                Int8Array: 5120,
                Uint8Array: 5121,
                Int16Array: 5122,
                Uint16Array: 5123,
                Int32Array: 5124,
                Uint32Array: 5125,
                Float32Array: 5126,
            };
            this.handle = this.gl.createTexture();
        }
        delete() {
            this.gl.deleteTexture(this.handle);
        }
        activate() {
            this.gl.bindTexture(this._target, this.handle);
        }
        deactivate() {
            this.gl.bindTexture(this._target, 0);
        }
        _get_alignment(width) {
            // Determines a textures byte alignment. If the width isn't a
            // power of 2 we need to adjust the byte alignment of the image.
            // The image height is unimportant.
            //
            // www.opengl.org/wiki/Common_Mistakes#Texture_upload_and_pixel_reads
            const alignments = [4, 8, 2, 1];
            for (const alignment of alignments) {
                if (width % alignment == 0) {
                    return alignment;
                }
            }
            assert_1.unreachable();
        }
        set_wrapping(wrap_s, wrap_t) {
            // Set the texture wrapping mode.
            //
            // Parameters
            // ----------
            // wrap_s : GL enum
            //     The mode to wrap the x dimension. Valid values are REPEAT
            //     CLAMP_TO_EDGE MIRRORED_REPEAT
            // wrap_t : GL enum
            //     The mode to wrap the y dimension. Same options as for wrap_s.
            this.activate();
            this.gl.texParameterf(this._target, this.gl.TEXTURE_WRAP_S, wrap_s);
            this.gl.texParameterf(this._target, this.gl.TEXTURE_WRAP_T, wrap_t);
        }
        set_interpolation(min, mag) {
            // Set the texture interpolation mode
            //
            // Parameters
            // ----------
            // min : GL enum
            //     The interpolation mode when minifying (i.e. zoomed out). Valid
            //     values are LINEAR and NEAREST.
            // max : GL enum
            //     The interpolation mode when magnifying (i.e. zoomed in). Valid
            //     values are LINEAR, NEAREST, NEAREST_MIPMAP_NEAREST,
            //     LINEAR_MIPMAP_NEAREST, NEAREST_MIPMAP_LINEAR, LINEAR_MIPMAP_LINEAR.
            this.activate();
            this.gl.texParameterf(this._target, this.gl.TEXTURE_MIN_FILTER, min);
            this.gl.texParameterf(this._target, this.gl.TEXTURE_MAG_FILTER, mag);
        }
        set_size([width, height], format) {
            var _a, _b, _c;
            // Set the size of the 2D texture.
            //
            // Parameters
            // ----------
            // shape : tuple of ints
            //     The shape of the data to upload
            // format : GL enum
            //     The format of the texture data. Can be LUMINANCE, LUMINANCE_ALPHA,
            //     RGB, and RGBA.
            if (width != ((_a = this._shape_format) === null || _a === void 0 ? void 0 : _a.width) || height != ((_b = this._shape_format) === null || _b === void 0 ? void 0 : _b.height) || format != ((_c = this._shape_format) === null || _c === void 0 ? void 0 : _c.format)) {
                this._shape_format = { width, height, format };
                this.activate();
                this.gl.texImage2D(this._target, 0, format, width, height, 0, format, this.gl.UNSIGNED_BYTE, null);
            }
        }
        set_data(offset, [width, height], data) {
            // Set the 2D texture data.
            //
            // Parameters
            // ----------
            // offset : tuple of ints
            //     Offset in pixels for each dimension.
            // shape : tuple of ints
            //     The shape of the data to upload
            // data : typed array
            //     The actual pixel data. Can be of any type, but on the GPU the
            //     dat is stored in 8 bit precision.
            this.activate();
            const { format } = this._shape_format;
            const [x, y] = offset;
            const gtype = this._types[data.constructor.name];
            if (gtype == null) {
                throw new Error(`Type ${data.constructor.name} not allowed for texture`);
            }
            const alignment = this._get_alignment(width);
            if (alignment != 4) {
                this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT, alignment);
            }
            this.gl.texSubImage2D(this._target, 0, x, y, width, height, format, gtype, data);
            if (alignment != 4) {
                this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT, 4);
            }
        }
    }
    exports.Texture2d = Texture2d;
    Texture2d.__name__ = "Texture2d";
},
/* models/glyphs/webgl/base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class BaseGLGlyph {
        constructor(gl, glyph) {
            this.gl = gl;
            this.glyph = glyph;
            this.nvertices = 0;
            this.size_changed = false;
            this.data_changed = false;
            this.visuals_changed = false;
            this.init();
        }
        set_data_changed() {
            const { data_size } = this.glyph;
            if (data_size != this.nvertices) {
                this.nvertices = data_size;
                this.size_changed = true;
            }
            this.data_changed = true;
        }
        set_visuals_changed() {
            this.visuals_changed = true;
        }
        render(_ctx, indices, mainglyph) {
            if (indices.length == 0) {
                return true;
            }
            const { width, height } = this.glyph.renderer.plot_view.canvas_view.webgl.canvas;
            const trans = {
                pixel_ratio: this.glyph.renderer.plot_view.canvas_view.pixel_ratio,
                width,
                height,
            };
            this.draw(indices, mainglyph, trans);
            return true;
        }
    }
    exports.BaseGLGlyph = BaseGLGlyph;
    BaseGLGlyph.__name__ = "BaseGLGlyph";
},
/* models/glyphs/webgl/line.vert.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.vertex_shader = `
precision mediump float;

const float PI = 3.14159265358979323846264;
const float THETA = 15.0 * 3.14159265358979323846264/180.0;

uniform float u_pixel_ratio;
uniform vec2 u_canvas_size, u_offset;
uniform vec2 u_scale_aspect;
uniform float u_scale_length;

uniform vec4 u_color;
uniform float u_antialias;
uniform float u_length;
uniform float u_linewidth;
uniform float u_dash_index;
uniform float u_closed;

attribute vec2 a_position;
attribute vec4 a_tangents;
attribute vec2 a_segment;
attribute vec2 a_angles;
attribute vec2 a_texcoord;

varying vec4  v_color;
varying vec2  v_segment;
varying vec2  v_angles;
varying vec2  v_texcoord;
varying vec2  v_miter;
varying float v_length;
varying float v_linewidth;

float cross(in vec2 v1, in vec2 v2)
{
    return v1.x*v2.y - v1.y*v2.x;
}

float signed_distance(in vec2 v1, in vec2 v2, in vec2 v3)
{
    return cross(v2-v1,v1-v3) / length(v2-v1);
}

void rotate( in vec2 v, in float alpha, out vec2 result )
{
    float c = cos(alpha);
    float s = sin(alpha);
    result = vec2( c*v.x - s*v.y,
                   s*v.x + c*v.y );
}

void main()
{
    bool closed = (u_closed > 0.0);

    // Attributes and uniforms to varyings
    v_color = u_color;
    v_linewidth = u_linewidth;
    v_segment = a_segment * u_scale_length;
    v_length = u_length * u_scale_length;

    // Scale to map to pixel coordinates. The original algorithm from the paper
    // assumed isotropic scale. We obviously do not have this.
    vec2 abs_scale_aspect = abs(u_scale_aspect);
    vec2 abs_scale = u_scale_length * abs_scale_aspect;

    // Correct angles for aspect ratio
    vec2 av;
    av = vec2(1.0, tan(a_angles.x)) / abs_scale_aspect;
    v_angles.x = atan(av.y, av.x);
    av = vec2(1.0, tan(a_angles.y)) / abs_scale_aspect;
    v_angles.y = atan(av.y, av.x);

    // Thickness below 1 pixel are represented using a 1 pixel thickness
    // and a modified alpha
    v_color.a = min(v_linewidth, v_color.a);
    v_linewidth = max(v_linewidth, 1.0);

    // If color is fully transparent we just will discard the fragment anyway
    if( v_color.a <= 0.0 ) {
        gl_Position = vec4(0.0,0.0,0.0,1.0);
        return;
    }

    // This is the actual half width of the line
    float w = ceil(u_antialias+v_linewidth)/2.0;

    vec2 position = a_position;

    vec2 t1 = normalize(a_tangents.xy * abs_scale_aspect);  // note the scaling for aspect ratio here
    vec2 t2 = normalize(a_tangents.zw * abs_scale_aspect);
    float u = a_texcoord.x;
    float v = a_texcoord.y;
    vec2 o1 = vec2( +t1.y, -t1.x);
    vec2 o2 = vec2( +t2.y, -t2.x);

    // This is a join
    // ----------------------------------------------------------------
    if( t1 != t2 ) {
        float angle = atan (t1.x*t2.y-t1.y*t2.x, t1.x*t2.x+t1.y*t2.y);  // Angle needs recalculation for some reason
        vec2 t  = normalize(t1+t2);
        vec2 o  = vec2( + t.y, - t.x);

        if ( u_dash_index > 0.0 )
        {
            // Broken angle
            // ----------------------------------------------------------------
            if( (abs(angle) > THETA) ) {
                position += v * w * o / cos(angle/2.0);
                float s = sign(angle);
                if( angle < 0.0 ) {
                    if( u == +1.0 ) {
                        u = v_segment.y + v * w * tan(angle/2.0);
                        if( v == 1.0 ) {
                            position -= 2.0 * w * t1 / sin(angle);
                            u -= 2.0 * w / sin(angle);
                        }
                    } else {
                        u = v_segment.x - v * w * tan(angle/2.0);
                        if( v == 1.0 ) {
                            position += 2.0 * w * t2 / sin(angle);
                            u += 2.0*w / sin(angle);
                        }
                    }
                } else {
                    if( u == +1.0 ) {
                        u = v_segment.y + v * w * tan(angle/2.0);
                        if( v == -1.0 ) {
                            position += 2.0 * w * t1 / sin(angle);
                            u += 2.0 * w / sin(angle);
                        }
                    } else {
                        u = v_segment.x - v * w * tan(angle/2.0);
                        if( v == -1.0 ) {
                            position -= 2.0 * w * t2 / sin(angle);
                            u -= 2.0*w / sin(angle);
                        }
                    }
                }
                // Continuous angle
                // ------------------------------------------------------------
            } else {
                position += v * w * o / cos(angle/2.0);
                if( u == +1.0 ) u = v_segment.y;
                else            u = v_segment.x;
            }
        }

        // Solid line
        // --------------------------------------------------------------------
        else
        {
            position.xy += v * w * o / cos(angle/2.0);
            if( angle < 0.0 ) {
                if( u == +1.0 ) {
                    u = v_segment.y + v * w * tan(angle/2.0);
                } else {
                    u = v_segment.x - v * w * tan(angle/2.0);
                }
            } else {
                if( u == +1.0 ) {
                    u = v_segment.y + v * w * tan(angle/2.0);
                } else {
                    u = v_segment.x - v * w * tan(angle/2.0);
                }
            }
        }

    // This is a line start or end (t1 == t2)
    // ------------------------------------------------------------------------
    } else {
        position += v * w * o1;
        if( u == -1.0 ) {
            u = v_segment.x - w;
            position -= w * t1;
        } else {
            u = v_segment.y + w;
            position += w * t2;
        }
    }

    // Miter distance
    // ------------------------------------------------------------------------
    vec2 t;
    vec2 curr = a_position * abs_scale;
    if( a_texcoord.x < 0.0 ) {
        vec2 next = curr + t2*(v_segment.y-v_segment.x);

        rotate( t1, +v_angles.x/2.0, t);
        v_miter.x = signed_distance(curr, curr+t, position);

        rotate( t2, +v_angles.y/2.0, t);
        v_miter.y = signed_distance(next, next+t, position);
    } else {
        vec2 prev = curr - t1*(v_segment.y-v_segment.x);

        rotate( t1, -v_angles.x/2.0,t);
        v_miter.x = signed_distance(prev, prev+t, position);

        rotate( t2, -v_angles.y/2.0,t);
        v_miter.y = signed_distance(curr, curr+t, position);
    }

    if (!closed && v_segment.x <= 0.0) {
        v_miter.x = 1e10;
    }
    if (!closed && v_segment.y >= v_length)
    {
        v_miter.y = 1e10;
    }

    v_texcoord = vec2( u, v*w );

    // Calculate position in device coordinates. Note that we
    // already scaled with abs scale above.
    vec2 normpos = position * sign(u_scale_aspect);
    normpos += 0.5;  // make up for Bokeh's offset
    normpos /= u_canvas_size / u_pixel_ratio;  // in 0..1
    gl_Position = vec4(normpos*2.0-1.0, 0.0, 1.0);
    gl_Position.y *= -1.0;
}
`;
},
/* models/glyphs/webgl/line.frag.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.fragment_shader = `
precision mediump float;

const float PI = 3.14159265358979323846264;
const float THETA = 15.0 * 3.14159265358979323846264/180.0;

uniform sampler2D u_dash_atlas;

uniform vec2 u_linecaps;
uniform float u_miter_limit;
uniform float u_linejoin;
uniform float u_antialias;
uniform float u_dash_phase;
uniform float u_dash_period;
uniform float u_dash_index;
uniform vec2 u_dash_caps;
uniform float u_closed;

varying vec4  v_color;
varying vec2  v_segment;
varying vec2  v_angles;
varying vec2  v_texcoord;
varying vec2  v_miter;
varying float v_length;
varying float v_linewidth;

// Compute distance to cap ----------------------------------------------------
float cap( int type, float dx, float dy, float t, float linewidth )
{
    float d = 0.0;
    dx = abs(dx);
    dy = abs(dy);
    if      (type == 0)  discard;  // None
    else if (type == 1)  d = sqrt(dx*dx+dy*dy);  // Round
    else if (type == 3)  d = (dx+abs(dy));  // Triangle in
    else if (type == 2)  d = max(abs(dy),(t+dx-abs(dy)));  // Triangle out
    else if (type == 4)  d = max(dx,dy);  // Square
    else if (type == 5)  d = max(dx+t,dy);  // Butt
    return d;
}

// Compute distance to join -------------------------------------------------
float join( in int type, in float d, in vec2 segment, in vec2 texcoord, in vec2 miter,
           in float linewidth )
{
    // texcoord.x is distance from start
    // texcoord.y is distance from centerline
    // segment.x and y indicate the limits (as for texcoord.x) for this segment

    float dx = texcoord.x;

    // Round join
    if( type == 1 ) {
        if (dx < segment.x) {
            d = max(d,length( texcoord - vec2(segment.x,0.0)));
            //d = length( texcoord - vec2(segment.x,0.0));
        } else if (dx > segment.y) {
            d = max(d,length( texcoord - vec2(segment.y,0.0)));
            //d = length( texcoord - vec2(segment.y,0.0));
        }
    }
    // Bevel join
    else if ( type == 2 ) {
        if (dx < segment.x) {
            vec2 x = texcoord - vec2(segment.x,0.0);
            d = max(d, max(abs(x.x), abs(x.y)));

        } else if (dx > segment.y) {
            vec2 x = texcoord - vec2(segment.y,0.0);
            d = max(d, max(abs(x.x), abs(x.y)));
        }
        /*  Original code for bevel which does not work for us
        if( (dx < segment.x) ||  (dx > segment.y) )
            d = max(d, min(abs(x.x),abs(x.y)));
        */
    }

    return d;
}

void main()
{
    // If color is fully transparent we just discard the fragment
    if( v_color.a <= 0.0 ) {
        discard;
    }

    // Test if dash pattern is the solid one (0)
    bool solid =  (u_dash_index == 0.0);

    // Test if path is closed
    bool closed = (u_closed > 0.0);

    vec4 color = v_color;
    float dx = v_texcoord.x;
    float dy = v_texcoord.y;
    float t = v_linewidth/2.0-u_antialias;
    float width = 1.0;  //v_linewidth; original code had dashes scale with line width, we do not
    float d = 0.0;

    vec2 linecaps = u_linecaps;
    vec2 dash_caps = u_dash_caps;
    float line_start = 0.0;
    float line_stop = v_length;

    // Apply miter limit; fragments too far into the miter are simply discarded
    if( (dx < v_segment.x) || (dx > v_segment.y) ) {
        float into_miter = max(v_segment.x - dx, dx - v_segment.y);
        if (into_miter > u_miter_limit*v_linewidth/2.0)
          discard;
    }

    // Solid line --------------------------------------------------------------
    if( solid ) {
        d = abs(dy);
        if( (!closed) && (dx < line_start) ) {
            d = cap( int(u_linecaps.x), abs(dx), abs(dy), t, v_linewidth );
        }
        else if( (!closed) &&  (dx > line_stop) ) {
            d = cap( int(u_linecaps.y), abs(dx)-line_stop, abs(dy), t, v_linewidth );
        }
        else {
            d = join( int(u_linejoin), abs(dy), v_segment, v_texcoord, v_miter, v_linewidth );
        }

    // Dash line --------------------------------------------------------------
    } else {
        float segment_start = v_segment.x;
        float segment_stop  = v_segment.y;
        float segment_center= (segment_start+segment_stop)/2.0;
        float freq          = u_dash_period*width;
        float u = mod( dx + u_dash_phase*width, freq);
        vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like
        float dash_center= tex.x * width;
        float dash_type  = tex.y;
        float _start = tex.z * width;
        float _stop  = tex.a * width;
        float dash_start = dx - u + _start;
        float dash_stop  = dx - u + _stop;

        // Compute extents of the first dash (the one relative to v_segment.x)
        // Note: this could be computed in the vertex shader
        if( (dash_stop < segment_start) && (dash_caps.x != 5.0) ) {
            float u = mod(segment_start + u_dash_phase*width, freq);
            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like
            dash_center= tex.x * width;
            //dash_type  = tex.y;
            float _start = tex.z * width;
            float _stop  = tex.a * width;
            dash_start = segment_start - u + _start;
            dash_stop = segment_start - u + _stop;
        }

        // Compute extents of the last dash (the one relatives to v_segment.y)
        // Note: This could be computed in the vertex shader
        else if( (dash_start > segment_stop)  && (dash_caps.y != 5.0) ) {
            float u = mod(segment_stop + u_dash_phase*width, freq);
            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like
            dash_center= tex.x * width;
            //dash_type  = tex.y;
            float _start = tex.z * width;
            float _stop  = tex.a * width;
            dash_start = segment_stop - u + _start;
            dash_stop  = segment_stop - u + _stop;
        }

        // This test if the we are dealing with a discontinuous angle
        bool discontinuous = ((dx <  segment_center) && abs(v_angles.x) > THETA) ||
                             ((dx >= segment_center) && abs(v_angles.y) > THETA);
        //if( dx < line_start) discontinuous = false;
        //if( dx > line_stop)  discontinuous = false;

        float d_join = join( int(u_linejoin), abs(dy),
                            v_segment, v_texcoord, v_miter, v_linewidth );

        // When path is closed, we do not have room for linecaps, so we make room
        // by shortening the total length
        if (closed) {
             line_start += v_linewidth/2.0;
             line_stop  -= v_linewidth/2.0;
        }

        // We also need to take antialias area into account
        //line_start += u_antialias;
        //line_stop  -= u_antialias;

        // Check is dash stop is before line start
        if( dash_stop <= line_start ) {
            discard;
        }
        // Check is dash start is beyond line stop
        if( dash_start >= line_stop ) {
            discard;
        }

        // Check if current dash start is beyond segment stop
        if( discontinuous ) {
            // Dash start is beyond segment, we discard
            if( (dash_start > segment_stop) ) {
                discard;
                //gl_FragColor = vec4(1.0,0.0,0.0,.25); return;
            }

            // Dash stop is before segment, we discard
            if( (dash_stop < segment_start) ) {
                discard;  //gl_FragColor = vec4(0.0,1.0,0.0,.25); return;
            }

            // Special case for round caps (nicer with this)
            if( dash_caps.x == 1.0 ) {
                if( (u > _stop) && (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0)) {
                    discard;
                }
            }

            // Special case for round caps  (nicer with this)
            if( dash_caps.y == 1.0 ) {
                if( (u < _start) && (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0)) {
                    discard;
                }
            }

            // Special case for triangle caps (in & out) and square
            // We make sure the cap stop at crossing frontier
            if( (dash_caps.x != 1.0) && (dash_caps.x != 5.0) ) {
                if( (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0) ) {
                    float a = v_angles.x/2.0;
                    float x = (segment_start-dx)*cos(a) - dy*sin(a);
                    float y = (segment_start-dx)*sin(a) + dy*cos(a);
                    if( x > 0.0 ) discard;
                    // We transform the cap into square to avoid holes
                    dash_caps.x = 4.0;
                }
            }

            // Special case for triangle caps (in & out) and square
            // We make sure the cap stop at crossing frontier
            if( (dash_caps.y != 1.0) && (dash_caps.y != 5.0) ) {
                if( (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0) ) {
                    float a = v_angles.y/2.0;
                    float x = (dx-segment_stop)*cos(a) - dy*sin(a);
                    float y = (dx-segment_stop)*sin(a) + dy*cos(a);
                    if( x > 0.0 ) discard;
                    // We transform the caps into square to avoid holes
                    dash_caps.y = 4.0;
                }
            }
        }

        // Line cap at start
        if( (dx < line_start) && (dash_start < line_start) && (dash_stop > line_start) ) {
            d = cap( int(linecaps.x), dx-line_start, dy, t, v_linewidth);
        }
        // Line cap at stop
        else if( (dx > line_stop) && (dash_stop > line_stop) && (dash_start < line_stop) ) {
            d = cap( int(linecaps.y), dx-line_stop, dy, t, v_linewidth);
        }
        // Dash cap left - dash_type = -1, 0 or 1, but there may be roundoff errors
        else if( dash_type < -0.5 ) {
            d = cap( int(dash_caps.y), abs(u-dash_center), dy, t, v_linewidth);
            if( (dx > line_start) && (dx < line_stop) )
                d = max(d,d_join);
        }
        // Dash cap right
        else if( dash_type > 0.5 ) {
            d = cap( int(dash_caps.x), abs(dash_center-u), dy, t, v_linewidth);
            if( (dx > line_start) && (dx < line_stop) )
                d = max(d,d_join);
        }
        // Dash body (plain)
        else {// if( dash_type > -0.5 &&  dash_type < 0.5) {
            d = abs(dy);
        }

        // Line join
        if( (dx > line_start) && (dx < line_stop)) {
            if( (dx <= segment_start) && (dash_start <= segment_start)
                && (dash_stop >= segment_start) ) {
                d = d_join;
                // Antialias at outer border
                float angle = PI/2.+v_angles.x;
                float f = abs( (segment_start - dx)*cos(angle) - dy*sin(angle));
                d = max(f,d);
            }
            else if( (dx > segment_stop) && (dash_start <= segment_stop)
                     && (dash_stop >= segment_stop) ) {
                d = d_join;
                // Antialias at outer border
                float angle = PI/2.+v_angles.y;
                float f = abs((dx - segment_stop)*cos(angle) - dy*sin(angle));
                d = max(f,d);
            }
            else if( dx < (segment_start - v_linewidth/2.)) {
                discard;
            }
            else if( dx > (segment_stop + v_linewidth/2.)) {
                discard;
            }
        }
        else if( dx < (segment_start - v_linewidth/2.)) {
            discard;
        }
        else if( dx > (segment_stop + v_linewidth/2.)) {
            discard;
        }
    }

    // Distance to border ------------------------------------------------------
    d = d - t;
    if( d < 0.0 ) {
        gl_FragColor = color;
    } else {
        d /= u_antialias;
        gl_FragColor = vec4(color.rgb, exp(-d*d)*color.a);
    }
}
`;
},
/* models/glyphs/patch.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const xy_glyph_1 = require(106) /* ./xy_glyph */;
    const utils_1 = require(107) /* ./utils */;
    const hittest = tslib_1.__importStar(require(108) /* ../../core/hittest */);
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    const selection_1 = require(94) /* ../selections/selection */;
    class PatchView extends xy_glyph_1.XYGlyphView {
        _inner_loop(ctx, indices, sx, sy, func) {
            for (const i of indices) {
                if (i == 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx[i], sy[i]);
                    continue;
                }
                else if (isNaN(sx[i] + sy[i])) {
                    ctx.closePath();
                    func.apply(ctx);
                    ctx.beginPath();
                    continue;
                }
                else
                    ctx.lineTo(sx[i], sy[i]);
            }
            ctx.closePath();
            func.call(ctx);
        }
        _render(ctx, indices, { sx, sy }) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                this._inner_loop(ctx, indices, sx, sy, ctx.fill);
            }
            this.visuals.hatch.doit2(ctx, 0, () => this._inner_loop(ctx, indices, sx, sy, ctx.fill), () => this.renderer.request_render());
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                this._inner_loop(ctx, indices, sx, sy, ctx.stroke);
            }
        }
        draw_legend_for_index(ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        }
        _hit_point(geometry) {
            const result = new selection_1.Selection();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, this.sx, this.sy)) {
                result.add_to_selected_glyphs(this.model);
                result.view = this;
            }
            return result;
        }
    }
    exports.PatchView = PatchView;
    PatchView.__name__ = "PatchView";
    class Patch extends xy_glyph_1.XYGlyph {
        constructor(attrs) {
            super(attrs);
        }
        static init_Patch() {
            this.prototype.default_view = PatchView;
            this.mixins([mixins.Line /*Scalar*/, mixins.Fill /*Scalar*/, mixins.Hatch /*Scalar*/]);
        }
    }
    exports.Patch = Patch;
    Patch.__name__ = "Patch";
    Patch.init_Patch();
},
/* models/glyphs/harea.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const types_1 = require(24) /* ../../core/types */;
    const area_1 = require(119) /* ./area */;
    const hittest = tslib_1.__importStar(require(108) /* ../../core/hittest */);
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    const selection_1 = require(94) /* ../selections/selection */;
    class HAreaView extends area_1.AreaView {
        _index_data(index) {
            const { min, max } = Math;
            const { data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const x1 = this._x1[i];
                const x2 = this._x2[i];
                const y = this._y[i];
                if (isNaN(x1 + x2 + y) || !isFinite(x1 + x2 + y))
                    index.add_empty();
                else
                    index.add(min(x1, x2), y, max(x1, x2), y);
            }
        }
        _inner(ctx, sx1, sx2, sy, func) {
            ctx.beginPath();
            for (let i = 0, end = sx1.length; i < end; i++) {
                ctx.lineTo(sx1[i], sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (let i = sx2.length - 1; i >= 0; i--) {
                ctx.lineTo(sx2[i], sy[i]);
            }
            ctx.closePath();
            func.call(ctx);
        }
        _render(ctx, _indices, { sx1, sx2, sy }) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                this._inner(ctx, sx1, sx2, sy, ctx.fill);
            }
            this.visuals.hatch.doit2(ctx, 0, () => this._inner(ctx, sx1, sx2, sy, ctx.fill), () => this.renderer.request_render());
        }
        _hit_point(geometry) {
            const L = this.sy.length;
            const sx = new types_1.NumberArray(2 * L);
            const sy = new types_1.NumberArray(2 * L);
            for (let i = 0, end = L; i < end; i++) {
                sx[i] = this.sx1[i];
                sy[i] = this.sy[i];
                sx[L + i] = this.sx2[L - i - 1];
                sy[L + i] = this.sy[L - i - 1];
            }
            const result = new selection_1.Selection();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
                result.add_to_selected_glyphs(this.model);
                result.view = this;
            }
            return result;
        }
        scenterxy(i) {
            const scx = (this.sx1[i] + this.sx2[i]) / 2;
            const scy = this.sy[i];
            return [scx, scy];
        }
        _map_data() {
            this.sx1 = this.renderer.xscale.v_compute(this._x1);
            this.sx2 = this.renderer.xscale.v_compute(this._x2);
            this.sy = this.renderer.yscale.v_compute(this._y);
        }
    }
    exports.HAreaView = HAreaView;
    HAreaView.__name__ = "HAreaView";
    class HArea extends area_1.Area {
        constructor(attrs) {
            super(attrs);
        }
        static init_HArea() {
            this.prototype.default_view = HAreaView;
            this.define(({}) => ({
                x1: [p.XCoordinateSpec, { field: "x1" }],
                x2: [p.XCoordinateSpec, { field: "x2" }],
                y: [p.YCoordinateSpec, { field: "y" }],
            }));
        }
    }
    exports.HArea = HArea;
    HArea.__name__ = "HArea";
    HArea.init_HArea();
},
/* models/glyphs/area.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const glyph_1 = require(95) /* ./glyph */;
    const utils_1 = require(107) /* ./utils */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    class AreaView extends glyph_1.GlyphView {
        draw_legend_for_index(ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        }
    }
    exports.AreaView = AreaView;
    AreaView.__name__ = "AreaView";
    class Area extends glyph_1.Glyph {
        constructor(attrs) {
            super(attrs);
        }
        static init_Area() {
            this.mixins([mixins.Fill /*Scalar*/, mixins.HatchVector]);
        }
    }
    exports.Area = Area;
    Area.__name__ = "Area";
    Area.init_Area();
},
/* models/glyphs/varea.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const types_1 = require(24) /* ../../core/types */;
    const area_1 = require(119) /* ./area */;
    const hittest = tslib_1.__importStar(require(108) /* ../../core/hittest */);
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    const selection_1 = require(94) /* ../selections/selection */;
    class VAreaView extends area_1.AreaView {
        _index_data(index) {
            const { min, max } = Math;
            const { data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const x = this._x[i];
                const y1 = this._y1[i];
                const y2 = this._y2[i];
                if (isNaN(x + y1 + y2) || !isFinite(x + y1 + y2))
                    index.add_empty();
                else
                    index.add(x, min(y1, y2), x, max(y1, y2));
            }
        }
        _inner(ctx, sx, sy1, sy2, func) {
            ctx.beginPath();
            for (let i = 0, end = sy1.length; i < end; i++) {
                ctx.lineTo(sx[i], sy1[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (let i = sy2.length - 1; i >= 0; i--) {
                ctx.lineTo(sx[i], sy2[i]);
            }
            ctx.closePath();
            func.call(ctx);
        }
        _render(ctx, _indices, { sx, sy1, sy2 }) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                this._inner(ctx, sx, sy1, sy2, ctx.fill);
            }
            this.visuals.hatch.doit2(ctx, 0, () => this._inner(ctx, sx, sy1, sy2, ctx.fill), () => this.renderer.request_render());
        }
        scenterxy(i) {
            const scx = this.sx[i];
            const scy = (this.sy1[i] + this.sy2[i]) / 2;
            return [scx, scy];
        }
        _hit_point(geometry) {
            const L = this.sx.length;
            const sx = new types_1.NumberArray(2 * L);
            const sy = new types_1.NumberArray(2 * L);
            for (let i = 0, end = L; i < end; i++) {
                sx[i] = this.sx[i];
                sy[i] = this.sy1[i];
                sx[L + i] = this.sx[L - i - 1];
                sy[L + i] = this.sy2[L - i - 1];
            }
            const result = new selection_1.Selection();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
                result.add_to_selected_glyphs(this.model);
                result.view = this;
            }
            return result;
        }
        _map_data() {
            this.sx = this.renderer.xscale.v_compute(this._x);
            this.sy1 = this.renderer.yscale.v_compute(this._y1);
            this.sy2 = this.renderer.yscale.v_compute(this._y2);
        }
    }
    exports.VAreaView = VAreaView;
    VAreaView.__name__ = "VAreaView";
    class VArea extends area_1.Area {
        constructor(attrs) {
            super(attrs);
        }
        static init_VArea() {
            this.prototype.default_view = VAreaView;
            this.define(({}) => ({
                x: [p.XCoordinateSpec, { field: "x" }],
                y1: [p.YCoordinateSpec, { field: "y1" }],
                y2: [p.YCoordinateSpec, { field: "y2" }],
            }));
        }
    }
    exports.VArea = VArea;
    VArea.__name__ = "VArea";
    VArea.init_VArea();
},
/* models/sources/cds_view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    const selection_1 = require(94) /* ../selections/selection */;
    const types_1 = require(24) /* ../../core/types */;
    const filter_1 = require(122) /* ../filters/filter */;
    const columnar_data_source_1 = require(92) /* ./columnar_data_source */;
    class CDSView extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        static init_CDSView() {
            this.define(({ Array, Ref }) => ({
                filters: [Array(Ref(filter_1.Filter)), []],
                source: [Ref(columnar_data_source_1.ColumnarDataSource)],
            }));
            this.internal(({ Int, Dict, Ref, Nullable }) => ({
                indices: [Ref(types_1.Indices)],
                indices_map: [Dict(Int), {}],
                masked: [Nullable(Ref(types_1.Indices)), null],
            }));
        }
        initialize() {
            super.initialize();
            this.compute_indices();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.properties.filters.change, () => this.compute_indices());
            const connect_listeners = () => {
                const fn = () => this.compute_indices();
                if (this.source != null) {
                    this.connect(this.source.change, fn);
                    if (this.source instanceof columnar_data_source_1.ColumnarDataSource) {
                        this.connect(this.source.streaming, fn);
                        this.connect(this.source.patching, fn);
                    }
                }
            };
            let initialized = this.source != null;
            if (initialized)
                connect_listeners();
            else {
                this.connect(this.properties.source.change, () => {
                    if (!initialized) {
                        connect_listeners();
                        initialized = true;
                    }
                });
            }
        }
        compute_indices() {
            var _a;
            const { source } = this;
            if (source == null)
                return;
            // XXX: if the data source is empty, there still may be one
            // index originating from glyph's scalar values.
            const size = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            const indices = types_1.Indices.all_set(size);
            for (const filter of this.filters) {
                indices.intersect(filter.compute_indices(source));
            }
            this.indices = indices;
            this._indices = [...indices];
            this.indices_map_to_subset();
        }
        indices_map_to_subset() {
            this.indices_map = {};
            for (let i = 0; i < this._indices.length; i++) {
                this.indices_map[this._indices[i]] = i;
            }
        }
        convert_selection_from_subset(selection_subset) {
            const indices = selection_subset.indices.map((i) => this._indices[i]);
            return new selection_1.Selection(Object.assign(Object.assign({}, selection_subset.attributes), { indices }));
        }
        convert_selection_to_subset(selection_full) {
            const indices = selection_full.indices.map((i) => this.indices_map[i]);
            return new selection_1.Selection(Object.assign(Object.assign({}, selection_full.attributes), { indices }));
        }
        convert_indices_from_subset(indices) {
            return indices.map((i) => this._indices[i]);
        }
    }
    exports.CDSView = CDSView;
    CDSView.__name__ = "CDSView";
    CDSView.init_CDSView();
},
/* models/filters/filter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    class Filter extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Filter = Filter;
    Filter.__name__ = "Filter";
},
/* core/build_views.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const array_1 = require(9) /* ./util/array */;
    async function _build_view(view_cls, model, options) {
        const view = new view_cls(Object.assign(Object.assign({}, options), { model }));
        view.initialize();
        await view.lazy_initialize();
        return view;
    }
    async function build_view(model, options = { parent: null }, cls = (model) => model.default_view) {
        const view = await _build_view(cls(model), model, options);
        view.connect_signals();
        return view;
    }
    exports.build_view = build_view;
    async function build_views(view_storage, models, options = { parent: null }, cls = (model) => model.default_view) {
        const to_remove = array_1.difference([...view_storage.keys()], models);
        for (const model of to_remove) {
            view_storage.get(model).remove();
            view_storage.delete(model);
        }
        const created_views = [];
        const new_models = models.filter((model) => !view_storage.has(model));
        for (const model of new_models) {
            const view = await _build_view(cls(model), model, options);
            view_storage.set(model, view);
            created_views.push(view);
        }
        for (const view of created_views)
            view.connect_signals();
        return created_views;
    }
    exports.build_views = build_views;
    function remove_views(view_storage) {
        for (const [model, view] of view_storage) {
            view.remove();
            view_storage.delete(model);
        }
    }
    exports.remove_views = remove_views;
},
/* models/renderers/graph_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const data_renderer_1 = require(104) /* ./data_renderer */;
    const glyph_renderer_1 = require(103) /* ./glyph_renderer */;
    const layout_provider_1 = require(125) /* ../graphs/layout_provider */;
    const graph_hit_test_policy_1 = require(126) /* ../graphs/graph_hit_test_policy */;
    const build_views_1 = require(123) /* ../../core/build_views */;
    const xy_glyph_1 = require(106) /* ../glyphs/xy_glyph */;
    const multi_line_1 = require(127) /* ../glyphs/multi_line */;
    const patches_1 = require(128) /* ../glyphs/patches */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    class GraphRendererView extends data_renderer_1.DataRendererView {
        get glyph_view() {
            return this.node_view.glyph;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const graph = this.model;
            // TODO: replace this with bi-variate transforms
            let xs_ys = null;
            let x_y = null;
            const xs_expr = {
                v_compute(source) {
                    assert_1.assert(xs_ys == null);
                    const [xs] = xs_ys = graph.layout_provider.get_edge_coordinates(source);
                    return xs;
                },
            };
            const ys_expr = {
                v_compute(_source) {
                    assert_1.assert(xs_ys != null);
                    const [, ys] = xs_ys;
                    xs_ys = null;
                    return ys;
                },
            };
            const x_expr = {
                v_compute(source) {
                    assert_1.assert(x_y == null);
                    const [x] = x_y = graph.layout_provider.get_node_coordinates(source);
                    return x;
                },
            };
            const y_expr = {
                v_compute(_source) {
                    assert_1.assert(x_y != null);
                    const [, y] = x_y;
                    x_y = null;
                    return y;
                },
            };
            const { edge_renderer, node_renderer } = this.model;
            // TODO: XsYsGlyph or something
            if (!(edge_renderer.glyph instanceof multi_line_1.MultiLine || edge_renderer.glyph instanceof patches_1.Patches)) {
                throw new Error(`${this}.edge_renderer.glyph must be a MultiLine glyph`);
            }
            if (!(node_renderer.glyph instanceof xy_glyph_1.XYGlyph)) {
                throw new Error(`${this}.node_renderer.glyph must be a XYGlyph glyph`);
            }
            edge_renderer.glyph.properties.xs.internal = true;
            edge_renderer.glyph.properties.ys.internal = true;
            node_renderer.glyph.properties.x.internal = true;
            node_renderer.glyph.properties.y.internal = true;
            edge_renderer.glyph.xs = { expr: xs_expr };
            edge_renderer.glyph.ys = { expr: ys_expr };
            node_renderer.glyph.x = { expr: x_expr };
            node_renderer.glyph.y = { expr: y_expr };
            const { parent } = this;
            this.edge_view = await build_views_1.build_view(edge_renderer, { parent });
            this.node_view = await build_views_1.build_view(node_renderer, { parent });
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.layout_provider.change, () => {
                this.edge_view.set_data(false);
                this.node_view.set_data(false);
                this.request_render();
            });
        }
        remove() {
            this.edge_view.remove();
            this.node_view.remove();
            super.remove();
        }
        _render() {
            this.edge_view.render();
            this.node_view.render();
        }
        renderer_view(renderer) {
            if (renderer instanceof glyph_renderer_1.GlyphRenderer) {
                if (renderer == this.edge_view.model)
                    return this.edge_view;
                if (renderer == this.node_view.model)
                    return this.node_view;
            }
            return super.renderer_view(renderer);
        }
    }
    exports.GraphRendererView = GraphRendererView;
    GraphRendererView.__name__ = "GraphRendererView";
    class GraphRenderer extends data_renderer_1.DataRenderer {
        constructor(attrs) {
            super(attrs);
        }
        static init_GraphRenderer() {
            this.prototype.default_view = GraphRendererView;
            this.define(({ Ref }) => ({
                layout_provider: [Ref(layout_provider_1.LayoutProvider)],
                node_renderer: [Ref(glyph_renderer_1.GlyphRenderer)],
                edge_renderer: [Ref(glyph_renderer_1.GlyphRenderer)],
                selection_policy: [Ref(graph_hit_test_policy_1.GraphHitTestPolicy), () => new graph_hit_test_policy_1.NodesOnly()],
                inspection_policy: [Ref(graph_hit_test_policy_1.GraphHitTestPolicy), () => new graph_hit_test_policy_1.NodesOnly()],
            }));
        }
        get_selection_manager() {
            return this.node_renderer.data_source.selection_manager;
        }
    }
    exports.GraphRenderer = GraphRenderer;
    GraphRenderer.__name__ = "GraphRenderer";
    GraphRenderer.init_GraphRenderer();
},
/* models/graphs/layout_provider.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    class LayoutProvider extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.LayoutProvider = LayoutProvider;
    LayoutProvider.__name__ = "LayoutProvider";
},
/* models/graphs/graph_hit_test_policy.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const array_1 = require(9) /* ../../core/util/array */;
    const selection_1 = require(94) /* ../selections/selection */;
    class GraphHitTestPolicy extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        _hit_test_nodes(geometry, graph_view) {
            if (!graph_view.model.visible)
                return null;
            const hit_test_result = graph_view.node_view.glyph.hit_test(geometry);
            if (hit_test_result == null)
                return null;
            else
                return graph_view.node_view.model.view.convert_selection_from_subset(hit_test_result);
        }
        _hit_test_edges(geometry, graph_view) {
            if (!graph_view.model.visible)
                return null;
            const hit_test_result = graph_view.edge_view.glyph.hit_test(geometry);
            if (hit_test_result == null)
                return null;
            else
                return graph_view.edge_view.model.view.convert_selection_from_subset(hit_test_result);
        }
    }
    exports.GraphHitTestPolicy = GraphHitTestPolicy;
    GraphHitTestPolicy.__name__ = "GraphHitTestPolicy";
    class NodesOnly extends GraphHitTestPolicy {
        constructor(attrs) {
            super(attrs);
        }
        hit_test(geometry, graph_view) {
            return this._hit_test_nodes(geometry, graph_view);
        }
        do_selection(hit_test_result, graph, final, mode) {
            if (hit_test_result == null)
                return false;
            const node_selection = graph.node_renderer.data_source.selected;
            node_selection.update(hit_test_result, final, mode);
            graph.node_renderer.data_source._select.emit();
            return !node_selection.is_empty();
        }
        do_inspection(hit_test_result, geometry, graph_view, final, mode) {
            if (hit_test_result == null)
                return false;
            const node_inspection = graph_view.model.get_selection_manager().get_or_create_inspector(graph_view.node_view.model);
            node_inspection.update(hit_test_result, final, mode);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            graph_view.node_view.model.data_source.inspect.emit([graph_view.node_view.model, { geometry }]);
            return !node_inspection.is_empty();
        }
    }
    exports.NodesOnly = NodesOnly;
    NodesOnly.__name__ = "NodesOnly";
    class NodesAndLinkedEdges extends GraphHitTestPolicy {
        constructor(attrs) {
            super(attrs);
        }
        hit_test(geometry, graph_view) {
            return this._hit_test_nodes(geometry, graph_view);
        }
        get_linked_edges(node_source, edge_source, mode) {
            let node_indices = [];
            if (mode == 'selection') {
                node_indices = node_source.selected.indices.map((i) => node_source.data.index[i]);
            }
            else if (mode == 'inspection') {
                node_indices = node_source.inspected.indices.map((i) => node_source.data.index[i]);
            }
            const edge_indices = [];
            for (let i = 0; i < edge_source.data.start.length; i++) {
                if (array_1.contains(node_indices, edge_source.data.start[i]) || array_1.contains(node_indices, edge_source.data.end[i]))
                    edge_indices.push(i);
            }
            const linked_edges = new selection_1.Selection();
            for (const i of edge_indices) {
                linked_edges.multiline_indices[i] = [0]; //currently only supports 2-element multilines, so this is all of it
            }
            linked_edges.indices = edge_indices;
            return linked_edges;
        }
        do_selection(hit_test_result, graph, final, mode) {
            if (hit_test_result == null)
                return false;
            const node_selection = graph.node_renderer.data_source.selected;
            node_selection.update(hit_test_result, final, mode);
            const edge_selection = graph.edge_renderer.data_source.selected;
            const linked_edges_selection = this.get_linked_edges(graph.node_renderer.data_source, graph.edge_renderer.data_source, 'selection');
            edge_selection.update(linked_edges_selection, final, mode);
            graph.node_renderer.data_source._select.emit();
            return !node_selection.is_empty();
        }
        do_inspection(hit_test_result, geometry, graph_view, final, mode) {
            if (hit_test_result == null)
                return false;
            const node_inspection = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
            node_inspection.update(hit_test_result, final, mode);
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            const edge_inspection = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
            const linked_edges = this.get_linked_edges(graph_view.node_view.model.data_source, graph_view.edge_view.model.data_source, 'inspection');
            edge_inspection.update(linked_edges, final, mode);
            //silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
            graph_view.node_view.model.data_source.inspect.emit([graph_view.node_view.model, { geometry }]);
            return !node_inspection.is_empty();
        }
    }
    exports.NodesAndLinkedEdges = NodesAndLinkedEdges;
    NodesAndLinkedEdges.__name__ = "NodesAndLinkedEdges";
    class EdgesAndLinkedNodes extends GraphHitTestPolicy {
        constructor(attrs) {
            super(attrs);
        }
        hit_test(geometry, graph_view) {
            return this._hit_test_edges(geometry, graph_view);
        }
        get_linked_nodes(node_source, edge_source, mode) {
            let edge_indices = [];
            if (mode == 'selection')
                edge_indices = edge_source.selected.indices;
            else if (mode == 'inspection')
                edge_indices = edge_source.inspected.indices;
            const nodes = [];
            for (const i of edge_indices) {
                nodes.push(edge_source.data.start[i]);
                nodes.push(edge_source.data.end[i]);
            }
            const node_indices = array_1.uniq(nodes).map((i) => arrayable_1.indexOf(node_source.data.index, i));
            return new selection_1.Selection({ indices: node_indices });
        }
        do_selection(hit_test_result, graph, final, mode) {
            if (hit_test_result == null)
                return false;
            const edge_selection = graph.edge_renderer.data_source.selected;
            edge_selection.update(hit_test_result, final, mode);
            const node_selection = graph.node_renderer.data_source.selected;
            const linked_nodes = this.get_linked_nodes(graph.node_renderer.data_source, graph.edge_renderer.data_source, 'selection');
            node_selection.update(linked_nodes, final, mode);
            graph.edge_renderer.data_source._select.emit();
            return !edge_selection.is_empty();
        }
        do_inspection(hit_test_result, geometry, graph_view, final, mode) {
            if (hit_test_result == null)
                return false;
            const edge_inspection = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
            edge_inspection.update(hit_test_result, final, mode);
            graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
            const node_inspection = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
            const linked_nodes = this.get_linked_nodes(graph_view.node_view.model.data_source, graph_view.edge_view.model.data_source, 'inspection');
            node_inspection.update(linked_nodes, final, mode);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            graph_view.edge_view.model.data_source.inspect.emit([graph_view.edge_view.model, { geometry }]);
            return !edge_inspection.is_empty();
        }
    }
    exports.EdgesAndLinkedNodes = EdgesAndLinkedNodes;
    EdgesAndLinkedNodes.__name__ = "EdgesAndLinkedNodes";
},
/* models/glyphs/multi_line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const projections_1 = require(36) /* ../../core/util/projections */;
    const property_mixins_1 = require(28) /* ../../core/property_mixins */;
    const hittest = tslib_1.__importStar(require(108) /* ../../core/hittest */);
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const object_1 = require(13) /* ../../core/util/object */;
    const glyph_1 = require(95) /* ./glyph */;
    const utils_1 = require(107) /* ./utils */;
    const selection_1 = require(94) /* ../selections/selection */;
    class MultiLineView extends glyph_1.GlyphView {
        _project_data() {
            projections_1.inplace.project_xy(this._xs.array, this._ys.array);
        }
        _index_data(index) {
            const { data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const xsi = this._xs.get(i);
                if (xsi.length == 0) {
                    index.add_empty();
                    continue;
                }
                const ysi = this._ys.get(i);
                if (ysi.length == 0) {
                    index.add_empty();
                    continue;
                }
                const [x0, x1] = arrayable_1.minmax(xsi);
                const [y0, y1] = arrayable_1.minmax(ysi);
                index.add(x0, y0, x1, y1);
            }
        }
        _render(ctx, indices, { sxs, sys }) {
            for (const i of indices) {
                const sx = sxs.get(i);
                const sy = sys.get(i);
                this.visuals.line.set_vectorize(ctx, i);
                for (let j = 0, end = sx.length; j < end; j++) {
                    if (j == 0) {
                        ctx.beginPath();
                        ctx.moveTo(sx[j], sy[j]);
                        continue;
                    }
                    else if (isNaN(sx[j]) || isNaN(sy[j])) {
                        ctx.stroke();
                        ctx.beginPath();
                        continue;
                    }
                    else
                        ctx.lineTo(sx[j], sy[j]);
                }
                ctx.stroke();
            }
        }
        _hit_point(geometry) {
            const point = { x: geometry.sx, y: geometry.sy };
            let shortest = 9999;
            const hits = new Map();
            for (let i = 0, end = this.sxs.length; i < end; i++) {
                const threshold = Math.max(2, this.visuals.line.cache_select('line_width', i) / 2);
                const sxsi = this.sxs.get(i);
                const sysi = this.sys.get(i);
                let points = null;
                for (let j = 0, endj = sxsi.length - 1; j < endj; j++) {
                    const p0 = { x: sxsi[j], y: sysi[j] };
                    const p1 = { x: sxsi[j + 1], y: sysi[j + 1] };
                    const dist = hittest.dist_to_segment(point, p0, p1);
                    if (dist < threshold && dist < shortest) {
                        shortest = dist;
                        points = [j];
                    }
                }
                if (points != null) {
                    hits.set(i, points);
                }
            }
            return new selection_1.Selection({
                indices: [...hits.keys()],
                multiline_indices: object_1.to_object(hits),
            });
        }
        _hit_span(geometry) {
            const { sx, sy } = geometry;
            let val;
            let vs;
            if (geometry.direction == 'v') {
                val = this.renderer.yscale.invert(sy);
                vs = this._ys;
            }
            else {
                val = this.renderer.xscale.invert(sx);
                vs = this._xs;
            }
            const hits = new Map();
            for (let i = 0, end = vs.length; i < end; i++) {
                const vsi = vs.get(i);
                const points = [];
                for (let j = 0, endj = vsi.length - 1; j < endj; j++) {
                    if (vsi[j] <= val && val <= vsi[j + 1])
                        points.push(j);
                }
                if (points.length > 0) {
                    hits.set(i, points);
                }
            }
            return new selection_1.Selection({
                indices: [...hits.keys()],
                multiline_indices: object_1.to_object(hits),
            });
        }
        get_interpolation_hit(i, point_i, geometry) {
            const xsi = this._xs.get(i);
            const ysi = this._ys.get(i);
            const x2 = xsi[point_i];
            const y2 = ysi[point_i];
            const x3 = xsi[point_i + 1];
            const y3 = ysi[point_i + 1];
            return utils_1.line_interpolation(this.renderer, geometry, x2, y2, x3, y3);
        }
        draw_legend_for_index(ctx, bbox, index) {
            utils_1.generic_line_legend(this.visuals, ctx, bbox, index);
        }
        scenterxy() {
            throw new Error(`${this}.scenterxy() is not implemented`);
        }
    }
    exports.MultiLineView = MultiLineView;
    MultiLineView.__name__ = "MultiLineView";
    class MultiLine extends glyph_1.Glyph {
        constructor(attrs) {
            super(attrs);
        }
        static init_MultiLine() {
            this.prototype.default_view = MultiLineView;
            this.define(({}) => ({
                xs: [p.XCoordinateSeqSpec, { field: "xs" }],
                ys: [p.YCoordinateSeqSpec, { field: "ys" }],
            }));
            this.mixins(property_mixins_1.LineVector);
        }
    }
    exports.MultiLine = MultiLine;
    MultiLine.__name__ = "MultiLine";
    MultiLine.init_MultiLine();
},
/* models/glyphs/patches.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const glyph_1 = require(95) /* ./glyph */;
    const utils_1 = require(107) /* ./utils */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const property_mixins_1 = require(28) /* ../../core/property_mixins */;
    const hittest = tslib_1.__importStar(require(108) /* ../../core/hittest */);
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    const selection_1 = require(94) /* ../selections/selection */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    const projections_1 = require(36) /* ../../core/util/projections */;
    class PatchesView extends glyph_1.GlyphView {
        _project_data() {
            projections_1.inplace.project_xy(this._xs.array, this._ys.array);
        }
        _index_data(index) {
            const { data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const xsi = this._xs.get(i);
                const ysi = this._ys.get(i);
                if (xsi.length == 0)
                    index.add_empty();
                else {
                    const [x0, x1] = arrayable_1.minmax(xsi);
                    const [y0, y1] = arrayable_1.minmax(ysi);
                    index.add(x0, y0, x1, y1);
                }
            }
        }
        _mask_data() {
            const { x_range, y_range } = this.renderer.plot_view.frame;
            return this.index.indices({
                x0: x_range.min, x1: x_range.max,
                y0: y_range.min, y1: y_range.max,
            });
        }
        _inner_loop(ctx, sx, sy, func) {
            for (let j = 0, end = sx.length; j < end; j++) {
                if (j == 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx[j], sy[j]);
                    continue;
                }
                else if (isNaN(sx[j] + sy[j])) {
                    ctx.closePath();
                    func.apply(ctx);
                    ctx.beginPath();
                    continue;
                }
                else
                    ctx.lineTo(sx[j], sy[j]);
            }
            ctx.closePath();
            func.call(ctx);
        }
        _render(ctx, indices, { sxs, sys }) {
            for (const i of indices) {
                const sx = sxs.get(i);
                const sy = sys.get(i);
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    this._inner_loop(ctx, sx, sy, ctx.fill);
                }
                this.visuals.hatch.doit2(ctx, i, () => this._inner_loop(ctx, sx, sy, ctx.fill), () => this.renderer.request_render());
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    this._inner_loop(ctx, sx, sy, ctx.stroke);
                }
            }
        }
        _hit_rect(geometry) {
            const { sx0, sx1, sy0, sy1 } = geometry;
            const xs = [sx0, sx1, sx1, sx0];
            const ys = [sy0, sy0, sy1, sy1];
            const [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
            const [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
            const candidates = this.index.indices({ x0, x1, y0, y1 });
            const indices = [];
            for (const index of candidates) {
                const sxss = this.sxs.get(index);
                const syss = this.sys.get(index);
                let hit = true;
                for (let j = 0, endj = sxss.length; j < endj; j++) {
                    const sx = sxss[j];
                    const sy = syss[j];
                    if (!hittest.point_in_poly(sx, sy, xs, ys)) {
                        hit = false;
                        break;
                    }
                }
                if (hit) {
                    indices.push(index);
                }
            }
            return new selection_1.Selection({ indices });
        }
        _hit_point(geometry) {
            const { sx, sy } = geometry;
            const x = this.renderer.xscale.invert(sx);
            const y = this.renderer.yscale.invert(sy);
            const candidates = this.index.indices({ x0: x, y0: y, x1: x, y1: y });
            const indices = [];
            for (const index of candidates) {
                const sxsi = this.sxs.get(index);
                const sysi = this.sys.get(index);
                const n = sxsi.length;
                for (let k = 0, j = 0;; j++) {
                    if (isNaN(sxsi[j]) || j == n) {
                        const sxsi_kj = sxsi.subarray(k, j);
                        const sysi_kj = sysi.subarray(k, j);
                        if (hittest.point_in_poly(sx, sy, sxsi_kj, sysi_kj)) {
                            indices.push(index);
                            break;
                        }
                        k = j + 1;
                    }
                    if (j == n)
                        break;
                }
            }
            return new selection_1.Selection({ indices });
        }
        _get_snap_coord(array) {
            return arrayable_1.sum(array) / array.length;
        }
        scenterxy(i, sx, sy) {
            const sxsi = this.sxs.get(i);
            const sysi = this.sys.get(i);
            const n = sxsi.length;
            let has_nan = false;
            for (let k = 0, j = 0;; j++) {
                const this_nan = isNaN(sxsi[j]);
                has_nan = has_nan || this_nan;
                if (j == n && !has_nan) {
                    const scx = this._get_snap_coord(sxsi);
                    const scy = this._get_snap_coord(sysi);
                    return [scx, scy];
                }
                if (this_nan || j == n) {
                    const sxsi_kj = sxsi.subarray(k, j);
                    const sysi_kj = sysi.subarray(k, j);
                    if (hittest.point_in_poly(sx, sy, sxsi_kj, sysi_kj)) {
                        const scx = this._get_snap_coord(sxsi_kj);
                        const scy = this._get_snap_coord(sysi_kj);
                        return [scx, scy];
                    }
                    k = j + 1;
                }
                if (j == n)
                    break;
            }
            assert_1.unreachable();
        }
        draw_legend_for_index(ctx, bbox, index) {
            utils_1.generic_area_legend(this.visuals, ctx, bbox, index);
        }
    }
    exports.PatchesView = PatchesView;
    PatchesView.__name__ = "PatchesView";
    class Patches extends glyph_1.Glyph {
        constructor(attrs) {
            super(attrs);
        }
        static init_Patches() {
            this.prototype.default_view = PatchesView;
            this.define(({}) => ({
                xs: [p.XCoordinateSeqSpec, { field: "xs" }],
                ys: [p.YCoordinateSeqSpec, { field: "ys" }],
            }));
            this.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector, property_mixins_1.HatchVector]);
        }
    }
    exports.Patches = Patches;
    Patches.__name__ = "Patches";
    Patches.init_Patches();
},
/* models/selections/interaction_policy.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    class SelectionPolicy extends model_1.Model {
        do_selection(hit_test_result, source, final, mode) {
            if (hit_test_result === null) {
                return false;
            }
            else {
                source.selected.update(hit_test_result, final, mode);
                source._select.emit();
                return !source.selected.is_empty();
            }
        }
    }
    exports.SelectionPolicy = SelectionPolicy;
    SelectionPolicy.__name__ = "SelectionPolicy";
    class IntersectRenderers extends SelectionPolicy {
        hit_test(geometry, renderer_views) {
            const hit_test_result_renderers = [];
            for (const r of renderer_views) {
                const result = r.hit_test(geometry);
                if (result !== null)
                    hit_test_result_renderers.push(result);
            }
            if (hit_test_result_renderers.length > 0) {
                const hit_test_result = hit_test_result_renderers[0];
                for (const hit_test_result_other of hit_test_result_renderers) {
                    hit_test_result.update_through_intersection(hit_test_result_other);
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        }
    }
    exports.IntersectRenderers = IntersectRenderers;
    IntersectRenderers.__name__ = "IntersectRenderers";
    class UnionRenderers extends SelectionPolicy {
        hit_test(geometry, renderer_views) {
            const hit_test_result_renderers = [];
            for (const r of renderer_views) {
                const result = r.hit_test(geometry);
                if (result !== null)
                    hit_test_result_renderers.push(result);
            }
            if (hit_test_result_renderers.length > 0) {
                const hit_test_result = hit_test_result_renderers[0];
                for (const hit_test_result_other of hit_test_result_renderers) {
                    hit_test_result.update_through_union(hit_test_result_other);
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        }
    }
    exports.UnionRenderers = UnionRenderers;
    UnionRenderers.__name__ = "UnionRenderers";
},
/* models/sources/column_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const columnar_data_source_1 = require(92) /* ./columnar_data_source */;
    const types_1 = require(8) /* ../../core/util/types */;
    const object_1 = require(13) /* ../../core/util/object */;
    const typed_array = tslib_1.__importStar(require(131) /* ../../core/util/typed_array */);
    const set_1 = require(132) /* ../../core/util/set */;
    const events_1 = require(133) /* ../../document/events */;
    //exported for testing
    function stream_to_column(col, new_col, rollover) {
        if (types_1.isArray(col)) {
            const result = col.concat(new_col);
            if (rollover != null && result.length > rollover)
                return result.slice(-rollover);
            else
                return result;
        }
        else if (types_1.isTypedArray(col)) {
            const total_len = col.length + new_col.length;
            // handle rollover case for typed arrays
            if (rollover != null && total_len > rollover) {
                const start = total_len - rollover;
                const end = col.length;
                // resize col if it is shorter than the rollover length
                let result;
                if (col.length < rollover) {
                    result = new col.constructor(rollover);
                    result.set(col, 0);
                }
                else
                    result = col;
                // shift values in original col to accommodate new_col
                for (let i = start, endi = end; i < endi; i++) {
                    result[i - start] = result[i];
                }
                // update end values in col with new_col
                for (let i = 0, endi = new_col.length; i < endi; i++) {
                    result[i + (end - start)] = new_col[i];
                }
                return result;
            }
            else {
                const tmp = new col.constructor(new_col);
                return typed_array.concat(col, tmp);
            }
        }
        else
            throw new Error("unsupported array types");
    }
    exports.stream_to_column = stream_to_column;
    // exported for testing
    function slice(ind, length) {
        let start, step, stop;
        if (types_1.isNumber(ind)) {
            start = ind;
            stop = ind + 1;
            step = 1;
        }
        else {
            start = ind.start != null ? ind.start : 0;
            stop = ind.stop != null ? ind.stop : length;
            step = ind.step != null ? ind.step : 1;
        }
        return [start, stop, step];
    }
    exports.slice = slice;
    // exported for testing
    function patch_to_column(col, patch) {
        const patched = new Set();
        let patched_range = false;
        for (const [ind, val] of patch) {
            // make the single index case look like the length-3 multi-index case
            let shape;
            let item;
            let index;
            let value;
            if (types_1.isArray(ind)) {
                const [i] = ind;
                patched.add(i);
                shape = col[i].shape;
                item = col[i];
                value = val;
                // this is basically like NumPy's "newaxis", inserting an empty dimension
                // makes length 2 and 3 multi-index cases uniform, so that the same code
                // can handle both
                if (ind.length === 2) {
                    shape = [1, shape[0]];
                    index = [ind[0], 0, ind[1]];
                }
                else
                    index = ind;
            }
            else {
                if (types_1.isNumber(ind)) {
                    value = [val];
                    patched.add(ind);
                }
                else {
                    value = val;
                    patched_range = true;
                }
                index = [0, 0, ind];
                shape = [1, col.length];
                item = col;
            }
            // now this one nested loop handles all cases
            let flat_index = 0;
            const [istart, istop, istep] = slice(index[1], shape[0]);
            const [jstart, jstop, jstep] = slice(index[2], shape[1]);
            for (let i = istart; i < istop; i += istep) {
                for (let j = jstart; j < jstop; j += jstep) {
                    if (patched_range) {
                        patched.add(j);
                    }
                    item[i * shape[1] + j] = value[flat_index];
                    flat_index++;
                }
            }
        }
        return patched;
    }
    exports.patch_to_column = patch_to_column;
    class ColumnDataSource extends columnar_data_source_1.ColumnarDataSource {
        constructor(attrs) {
            super(attrs);
        }
        static init_ColumnDataSource() {
            this.define(({ Dict, Any /*Arrayable*/ }) => ({
                data: [Dict(Any /*Arrayable*/), {}],
            }));
        }
        stream(new_data, rollover, setter_id) {
            const { data } = this;
            for (const [name, new_column] of object_1.entries(new_data)) {
                data[name] = stream_to_column(data[name], new_column, rollover);
            }
            this.setv({ data }, { silent: true });
            this.streaming.emit();
            if (this.document != null) {
                const hint = new events_1.ColumnsStreamedEvent(this.document, this.ref(), new_data, rollover);
                this.document._notify_change(this, 'data', null, null, { setter_id, hint });
            }
        }
        patch(patches, setter_id) {
            const { data } = this;
            let patched = new Set();
            for (const [column, patch] of object_1.entries(patches)) {
                patched = set_1.union(patched, patch_to_column(data[column], patch)); // XXX
            }
            this.setv({ data }, { silent: true });
            this.patching.emit([...patched]);
            if (this.document != null) {
                const hint = new events_1.ColumnsPatchedEvent(this.document, this.ref(), patches);
                this.document._notify_change(this, 'data', null, null, { setter_id, hint });
            }
        }
    }
    exports.ColumnDataSource = ColumnDataSource;
    ColumnDataSource.__name__ = "ColumnDataSource";
    ColumnDataSource.init_ColumnDataSource();
},
/* core/util/typed_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function concat(array0, ...arrays) {
        let n = array0.length;
        for (const array of arrays)
            n += array.length;
        const result = new array0.constructor(n);
        result.set(array0, 0);
        let i = array0.length;
        for (const array of arrays) {
            result.set(array, i);
            i += array.length;
        }
        return result;
    }
    exports.concat = concat;
},
/* core/util/set.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function union(...sets) {
        const result = new Set();
        for (const set of sets) {
            for (const item of set) {
                result.add(item);
            }
        }
        return result;
    }
    exports.union = union;
    function intersection(set, ...sets) {
        const result = new Set();
        top: for (const item of set) {
            for (const other of sets) {
                if (!other.has(item))
                    continue top;
            }
            result.add(item);
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(set, ...sets) {
        const result = new Set(set);
        for (const item of union(...sets)) {
            result.delete(item);
        }
        return result;
    }
    exports.difference = difference;
},
/* document/events.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const serializer_1 = require(30) /* ../core/serializer */;
    class DocumentEvent {
        constructor(document) {
            this.document = document;
        }
    }
    exports.DocumentEvent = DocumentEvent;
    DocumentEvent.__name__ = "DocumentEvent";
    class DocumentEventBatch extends DocumentEvent {
        constructor(document, events, setter_id) {
            super(document);
            this.events = events;
            this.setter_id = setter_id;
        }
    }
    exports.DocumentEventBatch = DocumentEventBatch;
    DocumentEventBatch.__name__ = "DocumentEventBatch";
    class DocumentChangedEvent extends DocumentEvent {
    }
    exports.DocumentChangedEvent = DocumentChangedEvent;
    DocumentChangedEvent.__name__ = "DocumentChangedEvent";
    class MessageSentEvent extends DocumentChangedEvent {
        constructor(document, msg_type, msg_data) {
            super(document);
            this.msg_type = msg_type;
            this.msg_data = msg_data;
        }
        [serializer_1.serialize](serializer) {
            const value = this.msg_data;
            const value_serialized = serializer.to_serializable(value);
            return {
                kind: "MessageSent",
                msg_type: this.msg_type,
                msg_data: value_serialized,
            };
        }
    }
    exports.MessageSentEvent = MessageSentEvent;
    MessageSentEvent.__name__ = "MessageSentEvent";
    class ModelChangedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, old, new_, setter_id, hint) {
            super(document);
            this.model = model;
            this.attr = attr;
            this.old = old;
            this.new_ = new_;
            this.setter_id = setter_id;
            this.hint = hint;
        }
        [serializer_1.serialize](serializer) {
            if (this.hint != null)
                return serializer.to_serializable(this.hint);
            const value = this.new_;
            const value_serialized = serializer.to_serializable(value);
            if (this.model != value) {
                // we know we don't want a whole new copy of the obj we're
                // patching unless it's also the value itself
                serializer.remove_def(this.model);
            }
            return {
                kind: "ModelChanged",
                model: this.model.ref(),
                attr: this.attr,
                new: value_serialized,
            };
        }
    }
    exports.ModelChangedEvent = ModelChangedEvent;
    ModelChangedEvent.__name__ = "ModelChangedEvent";
    class ColumnsPatchedEvent extends DocumentChangedEvent {
        constructor(document, column_source, patches) {
            super(document);
            this.column_source = column_source;
            this.patches = patches;
        }
        [serializer_1.serialize](_serializer) {
            return {
                kind: "ColumnsPatched",
                column_source: this.column_source,
                patches: this.patches,
            };
        }
    }
    exports.ColumnsPatchedEvent = ColumnsPatchedEvent;
    ColumnsPatchedEvent.__name__ = "ColumnsPatchedEvent";
    class ColumnsStreamedEvent extends DocumentChangedEvent {
        constructor(document, column_source, data, rollover) {
            super(document);
            this.column_source = column_source;
            this.data = data;
            this.rollover = rollover;
        }
        [serializer_1.serialize](_serializer) {
            return {
                kind: "ColumnsStreamed",
                column_source: this.column_source,
                data: this.data,
                rollover: this.rollover,
            };
        }
    }
    exports.ColumnsStreamedEvent = ColumnsStreamedEvent;
    ColumnsStreamedEvent.__name__ = "ColumnsStreamedEvent";
    class TitleChangedEvent extends DocumentChangedEvent {
        constructor(document, title, setter_id) {
            super(document);
            this.title = title;
            this.setter_id = setter_id;
        }
        [serializer_1.serialize](_serializer) {
            return {
                kind: "TitleChanged",
                title: this.title,
            };
        }
    }
    exports.TitleChangedEvent = TitleChangedEvent;
    TitleChangedEvent.__name__ = "TitleChangedEvent";
    class RootAddedEvent extends DocumentChangedEvent {
        constructor(document, model, setter_id) {
            super(document);
            this.model = model;
            this.setter_id = setter_id;
        }
        [serializer_1.serialize](serializer) {
            return {
                kind: "RootAdded",
                model: serializer.to_serializable(this.model),
            };
        }
    }
    exports.RootAddedEvent = RootAddedEvent;
    RootAddedEvent.__name__ = "RootAddedEvent";
    class RootRemovedEvent extends DocumentChangedEvent {
        constructor(document, model, setter_id) {
            super(document);
            this.model = model;
            this.setter_id = setter_id;
        }
        [serializer_1.serialize](_serializer) {
            return {
                kind: "RootRemoved",
                model: this.model.ref(),
            };
        }
    }
    exports.RootRemovedEvent = RootRemovedEvent;
    RootRemovedEvent.__name__ = "RootRemovedEvent";
},
/* models/annotations/band.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const upper_lower_1 = require(135) /* ./upper_lower */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    class BandView extends upper_lower_1.UpperLowerView {
        connect_signals() {
            super.connect_signals();
            const update = () => this.set_data(this.model.source);
            this.connect(this.model.change, update);
            this.connect(this.model.source.streaming, update);
            this.connect(this.model.source.patching, update);
            this.connect(this.model.source.change, update);
        }
        _render() {
            this._map_data();
            const { ctx } = this.layer;
            // Draw the band body
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (let i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (let i = this._upper_sx.length - 1; i >= 0; i--) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            ctx.closePath();
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                ctx.fill();
            }
            // Draw the lower band edge
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (let i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            // Draw the upper band edge
            ctx.beginPath();
            ctx.moveTo(this._upper_sx[0], this._upper_sy[0]);
            for (let i = 0, end = this._upper_sx.length; i < end; i++) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
        }
    }
    exports.BandView = BandView;
    BandView.__name__ = "BandView";
    class Band extends upper_lower_1.UpperLower {
        constructor(attrs) {
            super(attrs);
        }
        static init_Band() {
            this.prototype.default_view = BandView;
            this.mixins([mixins.Line /*Scalar*/, mixins.Fill /*Scalar*/]);
            this.override({
                fill_color: "#fff9ba",
                fill_alpha: 0.4,
                line_color: "#cccccc",
                line_alpha: 0.3,
            });
        }
    }
    exports.Band = Band;
    Band.__name__ = "Band";
    Band.init_Band();
},
/* models/annotations/upper_lower.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(35) /* ./annotation */;
    const columnar_data_source_1 = require(92) /* ../sources/columnar_data_source */;
    const column_data_source_1 = require(130) /* ../sources/column_data_source */;
    const enums_1 = require(20) /* ../../core/enums */;
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    class UpperLowerView extends annotation_1.AnnotationView {
        initialize() {
            super.initialize();
            this.set_data(this.model.source);
        }
        set_data(source) {
            super.set_data(source);
            this.visuals.warm_cache(source);
            this.plot_view.request_render();
        }
        _map_data() {
            const { frame } = this.plot_view;
            const dim = this.model.dimension;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            const limit_scale = dim == "height" ? yscale : xscale;
            const base_scale = dim == "height" ? xscale : yscale;
            const limit_view = dim == "height" ? frame.yview : frame.xview;
            const base_view = dim == "height" ? frame.xview : frame.yview;
            let _lower_sx;
            if (this.model.properties.lower.units == "data")
                _lower_sx = limit_scale.v_compute(this._lower);
            else
                _lower_sx = limit_view.v_compute(this._lower);
            let _upper_sx;
            if (this.model.properties.upper.units == "data")
                _upper_sx = limit_scale.v_compute(this._upper);
            else
                _upper_sx = limit_view.v_compute(this._upper);
            let _base_sx;
            if (this.model.properties.base.units == "data")
                _base_sx = base_scale.v_compute(this._base);
            else
                _base_sx = base_view.v_compute(this._base);
            const [i, j] = dim == 'height' ? [1, 0] : [0, 1];
            const _lower = [_lower_sx, _base_sx];
            const _upper = [_upper_sx, _base_sx];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            this._upper_sy = _upper[j];
        }
    }
    exports.UpperLowerView = UpperLowerView;
    UpperLowerView.__name__ = "UpperLowerView";
    class XOrYCoordinateSpec extends p.CoordinateSpec {
        get dimension() {
            return this.obj.dimension == "width" ? "x" : "y";
        }
        // XXX: a hack to make a coordinate & unit spec
        get units() {
            var _a;
            return (_a = this.spec.units) !== null && _a !== void 0 ? _a : "data";
        }
    }
    exports.XOrYCoordinateSpec = XOrYCoordinateSpec;
    XOrYCoordinateSpec.__name__ = "XOrYCoordinateSpec";
    class UpperLower extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_UpperLower() {
            this.define(({ Ref }) => ({
                dimension: [enums_1.Dimension, "height"],
                lower: [XOrYCoordinateSpec, { field: "lower" }],
                upper: [XOrYCoordinateSpec, { field: "upper" }],
                base: [XOrYCoordinateSpec, { field: "base" }],
                source: [Ref(columnar_data_source_1.ColumnarDataSource), () => new column_data_source_1.ColumnDataSource()],
            }));
        }
    }
    exports.UpperLower = UpperLower;
    UpperLower.__name__ = "UpperLower";
    UpperLower.init_UpperLower();
},
/* models/annotations/box_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(35) /* ./annotation */;
    const signaling_1 = require(15) /* ../../core/signaling */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    const bbox_1 = require(86) /* ../../core/util/bbox */;
    exports.EDGE_TOLERANCE = 2.5;
    class BoxAnnotationView extends annotation_1.AnnotationView {
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.plot_view.request_paint(this));
            this.connect(this.model.data_update, () => this.plot_view.request_paint(this));
        }
        _render() {
            // don't render if *all* position are null
            if (this.model.left == null && this.model.right == null && this.model.top == null && this.model.bottom == null) {
                return;
            }
            const { frame } = this.plot_view;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            const _calc_dim = (dim, dim_units, scale, view, frame_extrema) => {
                let sdim;
                if (dim != null) {
                    if (this.model.screen)
                        sdim = dim;
                    else {
                        if (dim_units == 'data')
                            sdim = scale.compute(dim);
                        else
                            sdim = view.compute(dim);
                    }
                }
                else
                    sdim = frame_extrema;
                return sdim;
            };
            this.sleft = _calc_dim(this.model.left, this.model.left_units, xscale, frame.xview, frame.bbox.left);
            this.sright = _calc_dim(this.model.right, this.model.right_units, xscale, frame.xview, frame.bbox.right);
            this.stop = _calc_dim(this.model.top, this.model.top_units, yscale, frame.yview, frame.bbox.top);
            this.sbottom = _calc_dim(this.model.bottom, this.model.bottom_units, yscale, frame.yview, frame.bbox.bottom);
            this._paint_box(this.sleft, this.sright, this.sbottom, this.stop);
        }
        _paint_box(sleft, sright, sbottom, stop) {
            const { ctx } = this.layer;
            ctx.save();
            ctx.beginPath();
            ctx.rect(sleft, stop, sright - sleft, sbottom - stop);
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            ctx.restore();
        }
        interactive_bbox() {
            const tol = this.model.properties.line_width.value() + exports.EDGE_TOLERANCE;
            return new bbox_1.BBox({
                x0: this.sleft - tol,
                y0: this.stop - tol,
                x1: this.sright + tol,
                y1: this.sbottom + tol,
            });
        }
        interactive_hit(sx, sy) {
            if (this.model.in_cursor == null)
                return false;
            const bbox = this.interactive_bbox();
            return bbox.contains(sx, sy);
        }
        cursor(sx, sy) {
            const tol = 3;
            if (Math.abs(sx - this.sleft) < tol || Math.abs(sx - this.sright) < tol)
                return this.model.ew_cursor;
            else if (Math.abs(sy - this.sbottom) < tol || Math.abs(sy - this.stop) < tol)
                return this.model.ns_cursor;
            else if (sx > this.sleft && sx < this.sright && sy > this.stop && sy < this.sbottom)
                return this.model.in_cursor;
            else
                return null;
        }
    }
    exports.BoxAnnotationView = BoxAnnotationView;
    BoxAnnotationView.__name__ = "BoxAnnotationView";
    class BoxAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_BoxAnnotation() {
            this.prototype.default_view = BoxAnnotationView;
            this.mixins([mixins.Line /*Scalar*/, mixins.Fill /*Scalar*/]);
            this.define(({ Number, Nullable }) => ({
                render_mode: [enums_1.RenderMode, "canvas"],
                top: [Nullable(Number), null],
                top_units: [enums_1.SpatialUnits, "data"],
                bottom: [Nullable(Number), null],
                bottom_units: [enums_1.SpatialUnits, "data"],
                left: [Nullable(Number), null],
                left_units: [enums_1.SpatialUnits, "data"],
                right: [Nullable(Number), null],
                right_units: [enums_1.SpatialUnits, "data"],
            }));
            this.internal(({ Boolean, String, Nullable }) => ({
                screen: [Boolean, false],
                ew_cursor: [Nullable(String), null],
                ns_cursor: [Nullable(String), null],
                in_cursor: [Nullable(String), null],
            }));
            this.override({
                fill_color: '#fff9ba',
                fill_alpha: 0.4,
                line_color: '#cccccc',
                line_alpha: 0.3,
            });
        }
        initialize() {
            super.initialize();
            this.data_update = new signaling_1.Signal0(this, "data_update");
        }
        update({ left, right, top, bottom }) {
            this.setv({ left, right, top, bottom, screen: true }, { silent: true });
            this.data_update.emit();
        }
    }
    exports.BoxAnnotation = BoxAnnotation;
    BoxAnnotation.__name__ = "BoxAnnotation";
    BoxAnnotation.init_BoxAnnotation();
},
/* models/annotations/color_bar.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(35) /* ./annotation */;
    const continuous_ticker_1 = require(138) /* ../tickers/continuous_ticker */;
    const tick_formatter_1 = require(140) /* ../formatters/tick_formatter */;
    const basic_ticker_1 = require(141) /* ../tickers/basic_ticker */;
    const basic_tick_formatter_1 = require(143) /* ../formatters/basic_tick_formatter */;
    const continuous_color_mapper_1 = require(144) /* ../mappers/continuous_color_mapper */;
    const mappers_1 = require(148) /* ../mappers */;
    const linear_scale_1 = require(157) /* ../scales/linear_scale */;
    const linear_interpolation_scale_1 = require(169) /* ../scales/linear_interpolation_scale */;
    const log_scale_1 = require(170) /* ../scales/log_scale */;
    const range1d_1 = require(168) /* ../ranges/range1d */;
    const enums_1 = require(20) /* ../../core/enums */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    const text_util = tslib_1.__importStar(require(171) /* ../../core/util/text */);
    const array_1 = require(9) /* ../../core/util/array */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const types_1 = require(8) /* ../../core/util/types */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    const SHORT_DIM = 25;
    const LONG_DIM_MIN_SCALAR = 0.3;
    const LONG_DIM_MAX_SCALAR = 0.8;
    class ColorBarView extends annotation_1.AnnotationView {
        initialize() {
            super.initialize();
            this._set_canvas_image();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.ticker.change, () => this.plot_view.request_render());
            this.connect(this.model.formatter.change, () => this.plot_view.request_render());
            if (this.model.color_mapper != null) {
                this.connect(this.model.color_mapper.change, () => {
                    this._set_canvas_image();
                    this.plot_view.request_render();
                });
            }
        }
        _get_size() {
            if (this.model.color_mapper == null)
                return { width: 0, height: 0 };
            else {
                const { width, height } = this.compute_legend_dimensions();
                return { width, height };
            }
        }
        _set_canvas_image() {
            if (this.model.color_mapper == null)
                return;
            let { palette } = this.model.color_mapper;
            if (this.model.orientation == 'vertical')
                palette = array_1.reversed(palette);
            let w, h;
            switch (this.model.orientation) {
                case "vertical": {
                    [w, h] = [1, palette.length];
                    break;
                }
                case "horizontal": {
                    [w, h] = [palette.length, 1];
                    break;
                }
            }
            const canvas = document.createElement('canvas');
            canvas.width = w;
            canvas.height = h;
            const image_ctx = canvas.getContext('2d');
            const image_data = image_ctx.getImageData(0, 0, w, h);
            // We always want to draw the entire palette linearly, so we create a new
            // LinearColorMapper instance and map a monotonic range of values with
            // length = palette.length to get each palette color in order.
            const cmap = new mappers_1.LinearColorMapper({ palette }).rgba_mapper;
            const buf8 = cmap.v_compute(array_1.range(0, palette.length));
            image_data.data.set(buf8);
            image_ctx.putImageData(image_data, 0, 0);
            this.image = canvas;
        }
        compute_legend_dimensions() {
            const image_dimensions = this._computed_image_dimensions();
            const [image_height, image_width] = [image_dimensions.height, image_dimensions.width];
            const label_extent = this._get_label_extent();
            const title_extent = this._title_extent();
            const tick_extent = this._tick_extent();
            const { padding } = this.model;
            let legend_height, legend_width;
            switch (this.model.orientation) {
                case "vertical":
                    legend_height = image_height + title_extent + 2 * padding;
                    legend_width = image_width + tick_extent + label_extent + 2 * padding;
                    break;
                case "horizontal":
                    legend_height = image_height + title_extent + tick_extent + label_extent + 2 * padding;
                    legend_width = image_width + 2 * padding;
                    break;
            }
            return { width: legend_width, height: legend_height };
        }
        compute_legend_location() {
            const legend_dimensions = this.compute_legend_dimensions();
            const [legend_height, legend_width] = [legend_dimensions.height, legend_dimensions.width];
            const legend_margin = this.model.margin;
            const panel = this.panel != null ? this.panel : this.plot_view.frame;
            const [hr, vr] = panel.bbox.ranges;
            const { location } = this.model;
            let sx, sy;
            if (types_1.isString(location)) {
                switch (location) {
                    case 'top_left':
                        sx = hr.start + legend_margin;
                        sy = vr.start + legend_margin;
                        break;
                    case 'top_center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = vr.start + legend_margin;
                        break;
                    case 'top_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = vr.start + legend_margin;
                        break;
                    case 'bottom_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'bottom_center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'bottom_left':
                        sx = hr.start + legend_margin;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'center_left':
                        sx = hr.start + legend_margin;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    case 'center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    case 'center_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                }
            }
            else if (types_1.isArray(location) && location.length == 2) {
                const [vx, vy] = location;
                sx = panel.xview.compute(vx);
                sy = panel.yview.compute(vy) - legend_height;
            }
            else
                assert_1.unreachable();
            return { sx, sy };
        }
        _render() {
            if (this.model.color_mapper == null)
                return;
            const { ctx } = this.layer;
            ctx.save();
            const { sx, sy } = this.compute_legend_location();
            ctx.translate(sx, sy);
            this._draw_bbox(ctx);
            const image_offset = this._get_image_offset();
            ctx.translate(image_offset.x, image_offset.y);
            this._draw_image(ctx);
            const tick_info = this.tick_info();
            this._draw_major_ticks(ctx, tick_info);
            this._draw_minor_ticks(ctx, tick_info);
            this._draw_major_labels(ctx, tick_info);
            if (this.model.title)
                this._draw_title(ctx);
            ctx.restore();
        }
        _draw_bbox(ctx) {
            const bbox = this.compute_legend_dimensions();
            ctx.save();
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fillRect(0, 0, bbox.width, bbox.height);
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.strokeRect(0, 0, bbox.width, bbox.height);
            }
            ctx.restore();
        }
        _draw_image(ctx) {
            const image = this._computed_image_dimensions();
            ctx.save();
            ctx.setImageSmoothingEnabled(false);
            ctx.globalAlpha = this.model.scale_alpha;
            ctx.drawImage(this.image, 0, 0, image.width, image.height);
            if (this.visuals.bar_line.doit) {
                this.visuals.bar_line.set_value(ctx);
                ctx.strokeRect(0, 0, image.width, image.height);
            }
            ctx.restore();
        }
        _draw_major_ticks(ctx, tick_info) {
            if (!this.visuals.major_tick_line.doit)
                return;
            const [nx, ny] = this._normals();
            const image = this._computed_image_dimensions();
            const [x_offset, y_offset] = [image.width * nx, image.height * ny];
            const [sx, sy] = tick_info.coords.major;
            const tin = this.model.major_tick_in;
            const tout = this.model.major_tick_out;
            ctx.save();
            ctx.translate(x_offset, y_offset);
            this.visuals.major_tick_line.set_value(ctx);
            for (let i = 0, end = sx.length; i < end; i++) {
                ctx.beginPath();
                ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
                ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
                ctx.stroke();
            }
            ctx.restore();
        }
        _draw_minor_ticks(ctx, tick_info) {
            if (!this.visuals.minor_tick_line.doit)
                return;
            const [nx, ny] = this._normals();
            const image = this._computed_image_dimensions();
            const [x_offset, y_offset] = [image.width * nx, image.height * ny];
            const [sx, sy] = tick_info.coords.minor;
            const tin = this.model.minor_tick_in;
            const tout = this.model.minor_tick_out;
            ctx.save();
            ctx.translate(x_offset, y_offset);
            this.visuals.minor_tick_line.set_value(ctx);
            for (let i = 0, end = sx.length; i < end; i++) {
                ctx.beginPath();
                ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
                ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
                ctx.stroke();
            }
            ctx.restore();
        }
        _draw_major_labels(ctx, tick_info) {
            if (!this.visuals.major_label_text.doit)
                return;
            const [nx, ny] = this._normals();
            const image = this._computed_image_dimensions();
            const [x_offset, y_offset] = [image.width * nx, image.height * ny];
            const standoff = (this.model.label_standoff + this._tick_extent());
            const [x_standoff, y_standoff] = [standoff * nx, standoff * ny];
            const [sx, sy] = tick_info.coords.major;
            const formatted_labels = tick_info.labels.major;
            this.visuals.major_label_text.set_value(ctx);
            ctx.save();
            ctx.translate(x_offset + x_standoff, y_offset + y_standoff);
            for (let i = 0, end = sx.length; i < end; i++) {
                ctx.fillText(formatted_labels[i], Math.round(sx[i] + nx * this.model.label_standoff), Math.round(sy[i] + ny * this.model.label_standoff));
            }
            ctx.restore();
        }
        _draw_title(ctx) {
            if (!this.visuals.title_text.doit)
                return;
            ctx.save();
            this.visuals.title_text.set_value(ctx);
            ctx.fillText(this.model.title, 0, -this.model.title_standoff);
            ctx.restore();
        }
        /*protected*/ _get_label_extent() {
            const major_labels = this.tick_info().labels.major;
            let label_extent;
            if (!array_1.is_empty(major_labels)) {
                const { ctx } = this.layer;
                ctx.save();
                this.visuals.major_label_text.set_value(ctx);
                switch (this.model.orientation) {
                    case "vertical":
                        label_extent = array_1.max((major_labels.map((label) => ctx.measureText(label.toString()).width)));
                        break;
                    case "horizontal":
                        label_extent = text_util.measure_font(this.visuals.major_label_text.font_value()).height;
                        break;
                }
                label_extent += this.model.label_standoff;
                ctx.restore();
            }
            else
                label_extent = 0;
            return label_extent;
        }
        /*protected*/ _get_image_offset() {
            // Returns image offset relative to legend bounding box
            const x = this.model.padding;
            const y = this.model.padding + this._title_extent();
            return { x, y };
        }
        // {{{ TODO: state
        _normals() {
            return this.model.orientation == 'vertical' ? [1, 0] : [0, 1];
        }
        _title_extent() {
            const font_value = this.model.title_text_font + " " + this.model.title_text_font_size + " " + this.model.title_text_font_style;
            const title_extent = this.model.title ? text_util.measure_font(font_value).height + this.model.title_standoff : 0;
            return title_extent;
        }
        _tick_extent() {
            return array_1.max([this.model.major_tick_out, this.model.minor_tick_out]);
        }
        _computed_image_dimensions() {
            /*
            Heuristics to determine ColorBar image dimensions if set to "auto"
        
            Note: Returns the height/width values for the ColorBar's scale image, not
            the dimensions of the entire ColorBar.
        
            If the short dimension (the width of a vertical bar or height of a
            horizontal bar) is set to "auto", the resulting dimension will be set to
            25 px.
        
            For a ColorBar in a side panel with the long dimension (the height of a
            vertical bar or width of a horizontal bar) set to "auto", the
            resulting dimension will be as long as the adjacent frame edge, so that the
            bar "fits" to the plot.
        
            For a ColorBar in the plot frame with the long dimension set to "auto", the
            resulting dimension will be the greater of:
              * The length of the color palette * 25px
              * The parallel frame dimension * 0.30
                (i.e the frame height for a vertical ColorBar)
            But not greater than:
              * The parallel frame dimension * 0.80
            */
            var _a;
            const { bbox } = (_a = this.panel) !== null && _a !== void 0 ? _a : this.plot_view.frame;
            const { padding } = this.model;
            const title_extent = this._title_extent();
            let width;
            let height;
            switch (this.model.orientation) {
                case "vertical": {
                    if (this.model.height == 'auto') {
                        if (this.panel != null)
                            height = bbox.height - 2 * padding - title_extent;
                        else {
                            height = array_1.max([this.model.color_mapper.palette.length * SHORT_DIM, bbox.height * LONG_DIM_MIN_SCALAR]);
                            height = array_1.min([height, bbox.height * LONG_DIM_MAX_SCALAR - 2 * padding - title_extent]);
                        }
                    }
                    else
                        height = this.model.height;
                    width = this.model.width == 'auto' ? SHORT_DIM : this.model.width;
                    break;
                }
                case "horizontal": {
                    height = this.model.height == 'auto' ? SHORT_DIM : this.model.height;
                    if (this.model.width == 'auto') {
                        if (this.panel != null)
                            width = bbox.width - 2 * padding;
                        else {
                            width = array_1.max([this.model.color_mapper.palette.length * SHORT_DIM, bbox.width * LONG_DIM_MIN_SCALAR]);
                            width = array_1.min([width, bbox.width * LONG_DIM_MAX_SCALAR - 2 * padding]);
                        }
                    }
                    else
                        width = this.model.width;
                    break;
                }
            }
            return { width, height };
        }
        /*protected*/ _tick_coordinate_scale(scale_length) {
            /*
            Creates and returns a scale instance that maps the `color_mapper` range
            (low to high) to a screen space range equal to the length of the ColorBar's
            scale image. The scale is used to calculate the tick coordinates in screen
            coordinates for plotting purposes.
        
            Note: the type of color_mapper has to match the type of scale (i.e.
            a LinearColorMapper will require a corresponding LinearScale instance).
            */
            const ranges = {
                source_range: new range1d_1.Range1d({
                    start: this.model.color_mapper.metrics.min,
                    end: this.model.color_mapper.metrics.max,
                }),
                target_range: new range1d_1.Range1d({
                    start: 0,
                    end: scale_length,
                }),
            };
            const { color_mapper } = this.model;
            if (color_mapper instanceof mappers_1.LinearColorMapper)
                return new linear_scale_1.LinearScale(ranges);
            else if (color_mapper instanceof mappers_1.LogColorMapper)
                return new log_scale_1.LogScale(ranges);
            else if (color_mapper instanceof mappers_1.ScanningColorMapper) {
                const { binning } = color_mapper.metrics;
                return new linear_interpolation_scale_1.LinearInterpolationScale(Object.assign(Object.assign({}, ranges), { binning }));
            }
            else {
                // TODO: Categorical*Mapper needs painters
                assert_1.unreachable();
            }
        }
        _format_major_labels(initial_labels, major_ticks) {
            // XXX: passing null as cross_loc probably means MercatorTickFormatters, etc
            // will not function properly in conjunction with colorbars
            const formatted_labels = this.model.formatter.doFormat(initial_labels, { loc: NaN });
            for (let i = 0, end = major_ticks.length; i < end; i++) {
                if (major_ticks[i] in this.model.major_label_overrides)
                    formatted_labels[i] = this.model.major_label_overrides[major_ticks[i]];
            }
            return formatted_labels;
        }
        tick_info() {
            const image_dimensions = this._computed_image_dimensions();
            let scale_length;
            switch (this.model.orientation) {
                case "vertical": {
                    scale_length = image_dimensions.height;
                    break;
                }
                case "horizontal": {
                    scale_length = image_dimensions.width;
                    break;
                }
            }
            const scale = this._tick_coordinate_scale(scale_length);
            const [i, j] = this._normals();
            const [start, end] = [this.model.color_mapper.metrics.min, this.model.color_mapper.metrics.max];
            const ticks = this.model.ticker.get_ticks_no_defaults(start, end, NaN, this.model.ticker.desired_num_ticks);
            const majors = ticks.major;
            const minors = ticks.minor;
            const major_coords = [[], []];
            const minor_coords = [[], []];
            for (let ii = 0, _end = majors.length; ii < _end; ii++) {
                if (majors[ii] < start || majors[ii] > end)
                    continue;
                major_coords[i].push(majors[ii]);
                major_coords[j].push(0);
            }
            for (let ii = 0, _end = minors.length; ii < _end; ii++) {
                if (minors[ii] < start || minors[ii] > end)
                    continue;
                minor_coords[i].push(minors[ii]);
                minor_coords[j].push(0);
            }
            const labels = { major: this._format_major_labels(major_coords[i], majors) };
            const coords = {
                major: [[], []],
                minor: [[], []],
            };
            coords.major[i] = scale.v_compute(major_coords[i]);
            coords.minor[i] = scale.v_compute(minor_coords[i]);
            coords.major[j] = major_coords[j];
            coords.minor[j] = minor_coords[j];
            // Because we want the scale to be reversed
            if (this.model.orientation == 'vertical') {
                coords.major[i] = arrayable_1.map(coords.major[i], (coord) => scale_length - coord);
                coords.minor[i] = arrayable_1.map(coords.minor[i], (coord) => scale_length - coord);
            }
            return { coords, labels };
        }
    }
    exports.ColorBarView = ColorBarView;
    ColorBarView.__name__ = "ColorBarView";
    class ColorBar extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_ColorBar() {
            this.prototype.default_view = ColorBarView;
            this.mixins([
                ["major_label_", mixins.Text],
                ["title_", mixins.Text],
                ["major_tick_", mixins.Line],
                ["minor_tick_", mixins.Line],
                ["border_", mixins.Line],
                ["bar_", mixins.Line],
                ["background_", mixins.Fill],
            ]);
            this.define(({ Alpha, Number, String, Tuple, Dict, Or, Ref, Auto }) => ({
                location: [Or(enums_1.LegendLocation, Tuple(Number, Number)), "top_right"],
                orientation: [enums_1.Orientation, "vertical"],
                title: [String],
                title_standoff: [Number, 2],
                width: [Or(Number, Auto), "auto"],
                height: [Or(Number, Auto), "auto"],
                scale_alpha: [Alpha, 1.0],
                ticker: [Ref(continuous_ticker_1.ContinuousTicker), () => new basic_ticker_1.BasicTicker()],
                formatter: [Ref(tick_formatter_1.TickFormatter), () => new basic_tick_formatter_1.BasicTickFormatter()],
                major_label_overrides: [Dict(String), {}],
                color_mapper: [Ref(continuous_color_mapper_1.ContinuousColorMapper)],
                label_standoff: [Number, 5],
                margin: [Number, 30],
                padding: [Number, 10],
                major_tick_in: [Number, 5],
                major_tick_out: [Number, 0],
                minor_tick_in: [Number, 0],
                minor_tick_out: [Number, 0],
            }));
            this.override({
                background_fill_color: "#ffffff",
                background_fill_alpha: 0.95,
                bar_line_color: null,
                border_line_color: null,
                major_label_text_align: "center",
                major_label_text_baseline: "middle",
                major_label_text_font_size: "11px",
                major_tick_line_color: "#ffffff",
                minor_tick_line_color: null,
                title_text_font_size: "13px",
                title_text_font_style: "italic",
            });
        }
    }
    exports.ColorBar = ColorBar;
    ColorBar.__name__ = "ColorBar";
    ColorBar.init_ColorBar();
},
/* models/tickers/continuous_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const ticker_1 = require(139) /* ./ticker */;
    const array_1 = require(9) /* ../../core/util/array */;
    class ContinuousTicker extends ticker_1.Ticker {
        constructor(attrs) {
            super(attrs);
        }
        static init_ContinuousTicker() {
            this.define(({ Int }) => ({
                num_minor_ticks: [Int, 5],
                desired_num_ticks: [Int, 6],
            }));
        }
        get_ticks(data_low, data_high, _range, cross_loc) {
            return this.get_ticks_no_defaults(data_low, data_high, cross_loc, this.desired_num_ticks);
        }
        // The version of get_ticks() that does the work (and the version that
        // should be overridden in subclasses).
        get_ticks_no_defaults(data_low, data_high, _cross_loc, desired_n_ticks) {
            const interval = this.get_interval(data_low, data_high, desired_n_ticks);
            const start_factor = Math.floor(data_low / interval);
            const end_factor = Math.ceil(data_high / interval);
            let factors;
            if (!isFinite(start_factor) || !isFinite(end_factor))
                factors = [];
            else
                factors = array_1.range(start_factor, end_factor + 1);
            const ticks = factors
                .map((factor) => factor * interval)
                .filter((tick) => data_low <= tick && tick <= data_high);
            const num_minor_ticks = this.num_minor_ticks;
            const minor_ticks = [];
            if (num_minor_ticks > 0 && ticks.length > 0) {
                const minor_interval = interval / num_minor_ticks;
                const minor_offsets = array_1.range(0, num_minor_ticks).map((i) => i * minor_interval);
                for (const x of minor_offsets.slice(1)) {
                    const mt = ticks[0] - x;
                    if (data_low <= mt && mt <= data_high) {
                        minor_ticks.push(mt);
                    }
                }
                for (const tick of ticks) {
                    for (const x of minor_offsets) {
                        const mt = tick + x;
                        if (data_low <= mt && mt <= data_high) {
                            minor_ticks.push(mt);
                        }
                    }
                }
            }
            return {
                major: ticks,
                minor: minor_ticks,
            };
        }
        // Returns the interval size that would produce exactly the number of
        // desired ticks.  (In general we won't use exactly this interval, because
        // we want the ticks to be round numbers.)
        get_ideal_interval(data_low, data_high, desired_n_ticks) {
            const data_range = data_high - data_low;
            return data_range / desired_n_ticks;
        }
    }
    exports.ContinuousTicker = ContinuousTicker;
    ContinuousTicker.__name__ = "ContinuousTicker";
    ContinuousTicker.init_ContinuousTicker();
},
/* models/tickers/ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    class Ticker extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Ticker = Ticker;
    Ticker.__name__ = "Ticker";
},
/* models/formatters/tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    class TickFormatter extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        compute(tick, opts) {
            return this.doFormat([tick], opts !== null && opts !== void 0 ? opts : { loc: 0 })[0];
        }
        v_compute(tick, opts) {
            return this.doFormat(tick, opts !== null && opts !== void 0 ? opts : { loc: 0 });
        }
    }
    exports.TickFormatter = TickFormatter;
    TickFormatter.__name__ = "TickFormatter";
},
/* models/tickers/basic_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const adaptive_ticker_1 = require(142) /* ./adaptive_ticker */;
    class BasicTicker extends adaptive_ticker_1.AdaptiveTicker {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.BasicTicker = BasicTicker;
    BasicTicker.__name__ = "BasicTicker";
},
/* models/tickers/adaptive_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_ticker_1 = require(138) /* ./continuous_ticker */;
    const array_1 = require(9) /* ../../core/util/array */;
    const math_1 = require(10) /* ../../core/util/math */;
    class AdaptiveTicker extends continuous_ticker_1.ContinuousTicker {
        constructor(attrs) {
            super(attrs);
        }
        static init_AdaptiveTicker() {
            this.define(({ Number, Array, Nullable }) => ({
                base: [Number, 10.0],
                mantissas: [Array(Number), [1, 2, 5]],
                min_interval: [Number, 0.0],
                max_interval: [Nullable(Number), null],
            }));
        }
        get_min_interval() {
            return this.min_interval;
        }
        get_max_interval() {
            var _a;
            return (_a = this.max_interval) !== null && _a !== void 0 ? _a : Infinity;
        }
        // These arguments control the range of possible intervals.  The interval I
        // returned by get_interval() will be the one that most closely matches the
        // desired number of ticks, subject to the following constraints:
        // I = (M * B^N), where
        // M is a member of mantissas,
        // B is base,
        // and N is an integer;
        // and min_interval <= I <= max_interval.
        initialize() {
            super.initialize();
            const prefix_mantissa = array_1.nth(this.mantissas, -1) / this.base;
            const suffix_mantissa = array_1.nth(this.mantissas, 0) * this.base;
            this.extended_mantissas = [prefix_mantissa, ...this.mantissas, suffix_mantissa];
            this.base_factor = this.get_min_interval() === 0.0 ? 1.0 : this.get_min_interval();
        }
        get_interval(data_low, data_high, desired_n_ticks) {
            const data_range = data_high - data_low;
            const ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
            const interval_exponent = Math.floor(math_1.log(ideal_interval / this.base_factor, this.base));
            const ideal_magnitude = this.base ** interval_exponent * this.base_factor;
            // An untested optimization.
            //   const ideal_mantissa = ideal_interval / ideal_magnitude
            //   index = sorted_index(this.extended_mantissas, ideal_mantissa)
            //   candidate_mantissas = this.extended_mantissas[index..index + 1]
            const candidate_mantissas = this.extended_mantissas;
            const errors = candidate_mantissas.map((mantissa) => {
                return Math.abs(desired_n_ticks - (data_range / (mantissa * ideal_magnitude)));
            });
            const best_mantissa = candidate_mantissas[array_1.argmin(errors)];
            const interval = best_mantissa * ideal_magnitude;
            return math_1.clamp(interval, this.get_min_interval(), this.get_max_interval());
        }
    }
    exports.AdaptiveTicker = AdaptiveTicker;
    AdaptiveTicker.__name__ = "AdaptiveTicker";
    AdaptiveTicker.init_AdaptiveTicker();
},
/* models/formatters/basic_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tick_formatter_1 = require(140) /* ./tick_formatter */;
    const string_1 = require(29) /* ../../core/util/string */;
    class BasicTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
            this.last_precision = 3;
        }
        static init_BasicTickFormatter() {
            this.define(({ Boolean, Int, Auto, Or }) => ({
                precision: [Or(Int, Auto), "auto"],
                use_scientific: [Boolean, true],
                power_limit_high: [Int, 5],
                power_limit_low: [Int, -3],
            }));
        }
        get scientific_limit_low() {
            return 10.0 ** this.power_limit_low;
        }
        get scientific_limit_high() {
            return 10.0 ** this.power_limit_high;
        }
        _need_sci(ticks) {
            if (!this.use_scientific)
                return false;
            const { scientific_limit_high } = this;
            const { scientific_limit_low } = this;
            const zeroish = ticks.length < 2 ? 0 : Math.abs(ticks[1] - ticks[0]) / 10000;
            for (const tick of ticks) {
                const tick_abs = Math.abs(tick);
                if (tick_abs <= zeroish)
                    continue;
                if (tick_abs >= scientific_limit_high || tick_abs <= scientific_limit_low) {
                    return true;
                }
            }
            return false;
        }
        _format_with_precision(ticks, need_sci, precision) {
            if (need_sci) {
                return ticks.map((tick) => tick.toExponential(precision));
            }
            else {
                return ticks.map((tick) => string_1.to_fixed(tick, precision));
            }
        }
        _auto_precision(ticks, need_sci) {
            const labels = new Array(ticks.length);
            const asc = this.last_precision <= 15;
            outer: for (let x = this.last_precision; asc ? x <= 15 : x >= 1; asc ? x++ : x--) {
                if (need_sci) {
                    labels[0] = ticks[0].toExponential(x);
                    for (let i = 1; i < ticks.length; i++) {
                        if (labels[i] == labels[i - 1]) {
                            continue outer;
                        }
                    }
                    this.last_precision = x;
                    break;
                }
                else {
                    labels[0] = string_1.to_fixed(ticks[0], x);
                    for (let i = 1; i < ticks.length; i++) {
                        labels[i] = string_1.to_fixed(ticks[i], x);
                        if (labels[i] == labels[i - 1]) {
                            continue outer;
                        }
                    }
                    this.last_precision = x;
                    break;
                }
            }
            return this.last_precision;
        }
        doFormat(ticks, _opts) {
            if (ticks.length == 0)
                return [];
            const need_sci = this._need_sci(ticks);
            const precision = this.precision == "auto" ? this._auto_precision(ticks, need_sci) : this.precision;
            return this._format_with_precision(ticks, need_sci, precision);
        }
    }
    exports.BasicTickFormatter = BasicTickFormatter;
    BasicTickFormatter.__name__ = "BasicTickFormatter";
    BasicTickFormatter.init_BasicTickFormatter();
},
/* models/mappers/continuous_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const color_mapper_1 = require(145) /* ./color_mapper */;
    const glyph_renderer_1 = require(103) /* ../renderers/glyph_renderer */;
    const array_1 = require(9) /* ../../core/util/array */;
    const types_1 = require(8) /* ../../core/util/types */;
    class ContinuousColorMapper extends color_mapper_1.ColorMapper {
        constructor(attrs) {
            super(attrs);
            this._scan_data = null;
        }
        static init_ContinuousColorMapper() {
            this.define(({ Number, String, Ref, Color, Or, Tuple, Array, Nullable }) => {
                return {
                    high: [Nullable(Number), null],
                    low: [Nullable(Number), null],
                    high_color: [Nullable(Color), null],
                    low_color: [Nullable(Color), null],
                    domain: [Array(Tuple(Ref(glyph_renderer_1.GlyphRenderer), Or(String, Array(String)))), []],
                };
            });
        }
        connect_signals() {
            super.connect_signals();
            const connect_renderers = () => {
                // TODO: if already connected this will bail. However, it won't remove old connections.
                for (const [renderer] of this.domain) {
                    this.connect(renderer.view.change, () => this.update_data());
                    this.connect(renderer.data_source.selected.change, () => this.update_data());
                }
            };
            this.connect(this.properties.domain.change, () => connect_renderers());
            connect_renderers();
        }
        update_data() {
            const { domain, palette } = this;
            const all_data = [...this._collect(domain)];
            this._scan_data = this.scan(all_data, palette.length);
            this.change.emit();
        }
        get metrics() {
            if (this._scan_data == null) {
                this.update_data();
            }
            return this._scan_data;
        }
        *_collect(domain) {
            for (const [renderer, fields] of domain) {
                for (const field of types_1.isArray(fields) ? fields : [fields]) {
                    let array = renderer.data_source.get_column(field);
                    array = renderer.view.indices.select(array);
                    const masked = renderer.view.masked;
                    const selected = renderer.data_source.selected.indices;
                    let subset;
                    if (masked != null && selected.length > 0)
                        subset = array_1.intersection([...masked], selected);
                    else if (masked != null)
                        subset = [...masked];
                    else if (selected.length > 0)
                        subset = selected;
                    if (subset != null) {
                        array = array_1.map(subset, (i) => array[i]);
                    }
                    if (array.length > 0 && !types_1.isNumber(array[0])) {
                        for (const subarray of array) {
                            yield* subarray;
                        }
                    }
                    else {
                        yield* array;
                    }
                }
            }
        }
        _v_compute(data, values, palette, colors) {
            const { nan_color } = colors;
            let { low_color, high_color } = colors;
            if (low_color == null)
                low_color = palette[0];
            if (high_color == null)
                high_color = palette[palette.length - 1];
            const { domain } = this;
            const all_data = !array_1.is_empty(domain) ? [...this._collect(domain)] : data;
            this._scan_data = this.scan(all_data, palette.length);
            for (let i = 0, end = data.length; i < end; i++) {
                const d = data[i];
                if (isNaN(d))
                    values[i] = nan_color;
                else
                    values[i] = this.cmap(d, palette, low_color, high_color, this._scan_data);
            }
        }
        _colors(conv) {
            return Object.assign(Object.assign({}, super._colors(conv)), { low_color: this.low_color != null ? conv(this.low_color) : undefined, high_color: this.high_color != null ? conv(this.high_color) : undefined });
        }
    }
    exports.ContinuousColorMapper = ContinuousColorMapper;
    ContinuousColorMapper.__name__ = "ContinuousColorMapper";
    ContinuousColorMapper.init_ContinuousColorMapper();
},
/* models/mappers/color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const mapper_1 = require(146) /* ./mapper */;
    const types_1 = require(8) /* ../../core/util/types */;
    const color_1 = require(22) /* ../../core/util/color */;
    const compat_1 = require(82) /* ../../core/util/compat */;
    function _convert_color(color) {
        if (types_1.isNumber(color))
            return color;
        if (color[0] != "#")
            color = color_1.color2hex(color);
        if (color.length != 9)
            color = color + 'ff';
        return parseInt(color.slice(1), 16);
    }
    exports._convert_color = _convert_color;
    function _convert_palette(palette) {
        const new_palette = new Uint32Array(palette.length);
        for (let i = 0, end = palette.length; i < end; i++)
            new_palette[i] = _convert_color(palette[i]);
        return new_palette;
    }
    exports._convert_palette = _convert_palette;
    function _uint32_to_rgba(values) {
        if (compat_1.is_little_endian) {
            const view = new DataView(values.buffer);
            for (let i = 0, end = values.length; i < end; i++)
                view.setUint32(i * 4, values[i]);
        }
        return new Uint8Array(values.buffer);
    }
    exports._uint32_to_rgba = _uint32_to_rgba;
    class ColorMapper extends mapper_1.Mapper {
        constructor(attrs) {
            super(attrs);
        }
        static init_ColorMapper() {
            this.define(({ Number, Color, Array, Or }) => ({
                palette: [Array(Or(Color, Number))],
                nan_color: [Color, "gray"],
            }));
        }
        v_compute(xs) {
            const values = new Array(xs.length);
            this._v_compute(xs, values, this.palette, this._colors((c) => c));
            return values;
        }
        get rgba_mapper() {
            const self = this;
            const palette = _convert_palette(this.palette);
            const colors = this._colors(_convert_color);
            return {
                v_compute(xs) {
                    const values = new Uint32Array(xs.length);
                    self._v_compute(xs, values, palette, colors);
                    return _uint32_to_rgba(values);
                },
            };
        }
        _colors(conv) {
            return { nan_color: conv(this.nan_color) };
        }
    }
    exports.ColorMapper = ColorMapper;
    ColorMapper.__name__ = "ColorMapper";
    ColorMapper.init_ColorMapper();
},
/* models/mappers/mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const transform_1 = require(147) /* ../transforms/transform */;
    class Mapper extends transform_1.Transform {
        constructor(attrs) {
            super(attrs);
        }
        compute(_x) {
            // If it's just a single value, then a mapper doesn't really make sense.
            throw new Error("mapping single values is not supported");
        }
    }
    exports.Mapper = Mapper;
    Mapper.__name__ = "Mapper";
},
/* models/transforms/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(88) /* ../../model */;
    class Transform extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Transform = Transform;
    Transform.__name__ = "Transform";
},
/* models/mappers/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var categorical_color_mapper_1 = require(149) /* ./categorical_color_mapper */;
    __esExport("CategoricalColorMapper", categorical_color_mapper_1.CategoricalColorMapper);
    var categorical_marker_mapper_1 = require(151) /* ./categorical_marker_mapper */;
    __esExport("CategoricalMarkerMapper", categorical_marker_mapper_1.CategoricalMarkerMapper);
    var categorical_pattern_mapper_1 = require(152) /* ./categorical_pattern_mapper */;
    __esExport("CategoricalPatternMapper", categorical_pattern_mapper_1.CategoricalPatternMapper);
    var continuous_color_mapper_1 = require(144) /* ./continuous_color_mapper */;
    __esExport("ContinuousColorMapper", continuous_color_mapper_1.ContinuousColorMapper);
    var color_mapper_1 = require(145) /* ./color_mapper */;
    __esExport("ColorMapper", color_mapper_1.ColorMapper);
    var linear_color_mapper_1 = require(153) /* ./linear_color_mapper */;
    __esExport("LinearColorMapper", linear_color_mapper_1.LinearColorMapper);
    var log_color_mapper_1 = require(154) /* ./log_color_mapper */;
    __esExport("LogColorMapper", log_color_mapper_1.LogColorMapper);
    var scanning_color_mapper_1 = require(155) /* ./scanning_color_mapper */;
    __esExport("ScanningColorMapper", scanning_color_mapper_1.ScanningColorMapper);
    var eqhist_color_mapper_1 = require(156) /* ./eqhist_color_mapper */;
    __esExport("EqHistColorMapper", eqhist_color_mapper_1.EqHistColorMapper);
},
/* models/mappers/categorical_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const categorical_mapper_1 = require(150) /* ./categorical_mapper */;
    const color_mapper_1 = require(145) /* ./color_mapper */;
    class CategoricalColorMapper extends color_mapper_1.ColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        static init_CategoricalColorMapper() {
            this.define(({ Any, Number, Array, Nullable }) => ({
                factors: [Array(Any /*TODO*/)],
                start: [Number, 0],
                end: [Nullable(Number), null],
            }));
        }
        _v_compute(data, values, palette, { nan_color }) {
            categorical_mapper_1.cat_v_compute(data, this.factors, palette, values, this.start, this.end, nan_color);
        }
    }
    exports.CategoricalColorMapper = CategoricalColorMapper;
    CategoricalColorMapper.__name__ = "CategoricalColorMapper";
    CategoricalColorMapper.init_CategoricalColorMapper();
},
/* models/mappers/categorical_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const types_1 = require(8) /* ../../core/util/types */;
    function _cat_equals(a, b) {
        if (a.length != b.length)
            return false;
        for (let i = 0, end = a.length; i < end; i++) {
            if (a[i] !== b[i])
                return false;
        }
        return true;
    }
    exports._cat_equals = _cat_equals;
    function cat_v_compute(data, factors, targets, values, start, end, extra_value) {
        const N = data.length;
        for (let i = 0; i < N; i++) {
            let d = data[i];
            let key;
            if (types_1.isString(d))
                key = arrayable_1.index_of(factors, d);
            else {
                if (start != null) {
                    if (end != null)
                        d = d.slice(start, end);
                    else
                        d = d.slice(start);
                }
                else if (end != null)
                    d = d.slice(0, end);
                if (d.length == 1)
                    key = arrayable_1.index_of(factors, d[0]);
                else
                    key = arrayable_1.find_index(factors, (x) => _cat_equals(x, d));
            }
            let value;
            if (key < 0 || key >= targets.length)
                value = extra_value;
            else
                value = targets[key];
            values[i] = value;
        }
    }
    exports.cat_v_compute = cat_v_compute;
},
/* models/mappers/categorical_marker_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const categorical_mapper_1 = require(150) /* ./categorical_mapper */;
    const mapper_1 = require(146) /* ./mapper */;
    const enums_1 = require(20) /* ../../core/enums */;
    class CategoricalMarkerMapper extends mapper_1.Mapper {
        constructor(attrs) {
            super(attrs);
        }
        static init_CategoricalMarkerMapper() {
            this.define(({ Any, Number, Array, Nullable }) => ({
                factors: [Array(Any /*TODO*/)],
                markers: [Array(enums_1.MarkerType)],
                start: [Number, 0],
                end: [Nullable(Number), null],
                default_value: [enums_1.MarkerType, "circle"],
            }));
        }
        v_compute(xs) {
            const values = new Array(xs.length);
            categorical_mapper_1.cat_v_compute(xs, this.factors, this.markers, values, this.start, this.end, this.default_value);
            return values;
        }
    }
    exports.CategoricalMarkerMapper = CategoricalMarkerMapper;
    CategoricalMarkerMapper.__name__ = "CategoricalMarkerMapper";
    CategoricalMarkerMapper.init_CategoricalMarkerMapper();
},
/* models/mappers/categorical_pattern_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const categorical_mapper_1 = require(150) /* ./categorical_mapper */;
    const mapper_1 = require(146) /* ./mapper */;
    const enums_1 = require(20) /* ../../core/enums */;
    class CategoricalPatternMapper extends mapper_1.Mapper {
        constructor(attrs) {
            super(attrs);
        }
        static init_CategoricalPatternMapper() {
            this.define(({ Any, Number, Array, Nullable }) => ({
                factors: [Array(Any /*TODO*/)],
                patterns: [Array(enums_1.HatchPatternType)],
                start: [Number, 0],
                end: [Nullable(Number), null],
                default_value: [enums_1.HatchPatternType, " "],
            }));
        }
        v_compute(xs) {
            const values = new Array(xs.length);
            categorical_mapper_1.cat_v_compute(xs, this.factors, this.patterns, values, this.start, this.end, this.default_value);
            return values;
        }
    }
    exports.CategoricalPatternMapper = CategoricalPatternMapper;
    CategoricalPatternMapper.__name__ = "CategoricalPatternMapper";
    CategoricalPatternMapper.init_CategoricalPatternMapper();
},
/* models/mappers/linear_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_color_mapper_1 = require(144) /* ./continuous_color_mapper */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    class LinearColorMapper extends continuous_color_mapper_1.ContinuousColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        scan(data, n) {
            const low = this.low != null ? this.low : arrayable_1.min(data);
            const high = this.high != null ? this.high : arrayable_1.max(data);
            const norm_factor = 1 / (high - low);
            const normed_interval = 1 / n;
            return { max: high, min: low, norm_factor, normed_interval };
        }
        cmap(d, palette, low_color, high_color, scan_data) {
            // This handles the edge case where d == high, since the code below maps
            // values exactly equal to high to palette.length, which is greater than
            // max_key
            const max_key = palette.length - 1;
            if (d == scan_data.max) {
                return palette[max_key];
            }
            const normed_d = (d - scan_data.min) * scan_data.norm_factor;
            const key = Math.floor(normed_d / scan_data.normed_interval);
            if (key < 0)
                return low_color;
            else if (key > max_key)
                return high_color;
            else
                return palette[key];
        }
    }
    exports.LinearColorMapper = LinearColorMapper;
    LinearColorMapper.__name__ = "LinearColorMapper";
},
/* models/mappers/log_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_color_mapper_1 = require(144) /* ./continuous_color_mapper */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    class LogColorMapper extends continuous_color_mapper_1.ContinuousColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        scan(data, n) {
            const low = this.low != null ? this.low : arrayable_1.min(data);
            const high = this.high != null ? this.high : arrayable_1.max(data);
            const scale = n / (Math.log(high) - Math.log(low)); // subtract the low offset
            return { max: high, min: low, scale };
        }
        cmap(d, palette, low_color, high_color, scan_data) {
            const max_key = palette.length - 1;
            if (d > scan_data.max) {
                return high_color;
            }
            // This handles the edge case where d == high, since the code below maps
            // values exactly equal to high to palette.length, which is greater than
            // max_key
            if (d == scan_data.max)
                return palette[max_key];
            else if (d < scan_data.min)
                return low_color;
            // Get the key
            const log = Math.log(d) - Math.log(scan_data.min); // subtract the low offset
            let key = Math.floor(log * scan_data.scale);
            // Deal with upper bound
            if (key > max_key) {
                key = max_key;
            }
            return palette[key];
        }
    }
    exports.LogColorMapper = LogColorMapper;
    LogColorMapper.__name__ = "LogColorMapper";
},
/* models/mappers/scanning_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_color_mapper_1 = require(144) /* ./continuous_color_mapper */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    class ScanningColorMapper extends continuous_color_mapper_1.ContinuousColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        cmap(d, palette, low_color, high_color, edges) {
            if (d < edges.binning[0])
                return low_color;
            if (d > edges.binning[edges.binning.length - 1])
                return high_color;
            const key = arrayable_1.left_edge_index(d, edges.binning);
            return palette[key];
        }
    }
    exports.ScanningColorMapper = ScanningColorMapper;
    ScanningColorMapper.__name__ = "ScanningColorMapper";
},
/* models/mappers/eqhist_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scanning_color_mapper_1 = require(155) /* ./scanning_color_mapper */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    const array_1 = require(9) /* ../../core/util/array */;
    const logging_1 = require(19) /* ../../core/logging */;
    class EqHistColorMapper extends scanning_color_mapper_1.ScanningColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        static init_EqHistColorMapper() {
            this.define(({ Int }) => ({
                bins: [Int, 256 * 256],
            }));
        }
        scan(data, n) {
            const low = this.low != null ? this.low : arrayable_1.min(data);
            const high = this.high != null ? this.high : arrayable_1.max(data);
            const nbins = this.bins;
            const eq_bin_edges = array_1.linspace(low, high, nbins + 1);
            const hist = arrayable_1.bin_counts(data, eq_bin_edges);
            const eq_bin_centers = new Array(nbins);
            for (let i = 0, length = eq_bin_edges.length; i < length - 1; i++) {
                const left = eq_bin_edges[i];
                const right = eq_bin_edges[i + 1];
                eq_bin_centers[i] = (left + right) / 2;
            }
            // CDFs
            const cdf = array_1.cumsum(hist);
            const cdf_max = cdf[cdf.length - 1];
            const norm_cdf = arrayable_1.map(cdf, (x) => x / cdf_max);
            // Iteratively find as many finite bins as there are colors
            let finite_bins = n - 1;
            let binning = [];
            let iterations = 0;
            let guess = n * 2;
            while ((finite_bins != n) && (iterations < 4) && (finite_bins != 0)) {
                const ratio = guess / finite_bins;
                if (ratio > 1000) {
                    // Abort if distribution is extremely skewed
                    break;
                }
                guess = Math.round(Math.max(n * ratio, n));
                // Interpolate
                const palette_edges = array_1.range(0, guess);
                const palette_cdf = arrayable_1.map(norm_cdf, (x) => x * (guess - 1));
                binning = arrayable_1.interpolate(palette_edges, palette_cdf, eq_bin_centers);
                // Evaluate binning
                const uniq_bins = array_1.uniq(binning);
                finite_bins = uniq_bins.length - 1;
                iterations++;
            }
            if (finite_bins == 0) {
                binning = [low, high];
                for (let j = 0; j < n - 1; j++)
                    binning.push(high);
            }
            else {
                binning = binning.slice(binning.length - n - 1);
                if (finite_bins != n)
                    logging_1.logger.warn("EqHistColorMapper warning: Histogram equalization did not converge.");
            }
            return { min: low, max: high, binning };
        }
    }
    exports.EqHistColorMapper = EqHistColorMapper;
    EqHistColorMapper.__name__ = "EqHistColorMapper";
    EqHistColorMapper.init_EqHistColorMapper();
},
/* models/scales/linear_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_scale_1 = require(158) /* ./continuous_scale */;
    class LinearScale extends continuous_scale_1.ContinuousScale {
        constructor(attrs) {
            super(attrs);
        }
        compute(x) {
            return this._linear_compute(x);
        }
        v_compute(xs) {
            return this._linear_v_compute(xs);
        }
        invert(xprime) {
            return this._linear_invert(xprime);
        }
        v_invert(xprimes) {
            return this._linear_v_invert(xprimes);
        }
    }
    exports.LinearScale = LinearScale;
    LinearScale.__name__ = "LinearScale";
},
/* models/scales/continuous_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scale_1 = require(159) /* ./scale */;
    class ContinuousScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ContinuousScale = ContinuousScale;
    ContinuousScale.__name__ = "ContinuousScale";
},
/* models/scales/scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const transforms_1 = require(160) /* ../transforms */;
    const range_1 = require(101) /* ../ranges/range */;
    const range1d_1 = require(168) /* ../ranges/range1d */;
    const types_1 = require(24) /* ../../core/types */;
    class Scale extends transforms_1.Transform {
        constructor(attrs) {
            super(attrs);
        }
        static init_Scale() {
            this.internal(({ Ref }) => ({
                source_range: [Ref(range_1.Range)],
                target_range: [Ref(range1d_1.Range1d)],
            }));
        }
        r_compute(x0, x1) {
            if (this.target_range.is_reversed)
                return [this.compute(x1), this.compute(x0)];
            else
                return [this.compute(x0), this.compute(x1)];
        }
        r_invert(sx0, sx1) {
            if (this.target_range.is_reversed)
                return [this.invert(sx1), this.invert(sx0)];
            else
                return [this.invert(sx0), this.invert(sx1)];
        }
        // These are needed by both LinearScale and CategoricalScale and this is the
        // only common ancestor. TODO: Proper MI/Mixin would be better.
        _linear_compute(x) {
            const [factor, offset] = this._linear_compute_state();
            return factor * x + offset;
        }
        _linear_v_compute(xs) {
            const [factor, offset] = this._linear_compute_state();
            const result = new types_1.NumberArray(xs.length);
            for (let i = 0; i < xs.length; i++)
                result[i] = factor * xs[i] + offset;
            return result;
        }
        _linear_invert(xprime) {
            const [factor, offset] = this._linear_compute_state();
            return (xprime - offset) / factor;
        }
        _linear_v_invert(xprimes) {
            const [factor, offset] = this._linear_compute_state();
            const result = new types_1.NumberArray(xprimes.length);
            for (let i = 0; i < xprimes.length; i++)
                result[i] = (xprimes[i] - offset) / factor;
            return result;
        }
        /*protected*/ _linear_compute_state() {
            //
            //  (t1 - t0)       (t1 - t0)
            //  --------- * x - --------- * s0 + t0
            //  (s1 - s0)       (s1 - s0)
            //
            // [  factor  ]     [    offset    ]
            //
            const source_start = this.source_range.start;
            const source_end = this.source_range.end;
            const target_start = this.target_range.start;
            const target_end = this.target_range.end;
            const factor = (target_end - target_start) / (source_end - source_start);
            const offset = -(factor * source_start) + target_start;
            return [factor, offset];
        }
    }
    exports.Scale = Scale;
    Scale.__name__ = "Scale";
    Scale.init_Scale();
},
/* models/transforms/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var customjs_transform_1 = require(161) /* ./customjs_transform */;
    __esExport("CustomJSTransform", customjs_transform_1.CustomJSTransform);
    var dodge_1 = require(162) /* ./dodge */;
    __esExport("Dodge", dodge_1.Dodge);
    var interpolator_1 = require(164) /* ./interpolator */;
    __esExport("Interpolator", interpolator_1.Interpolator);
    var jitter_1 = require(165) /* ./jitter */;
    __esExport("Jitter", jitter_1.Jitter);
    var linear_interpolator_1 = require(166) /* ./linear_interpolator */;
    __esExport("LinearInterpolator", linear_interpolator_1.LinearInterpolator);
    var step_interpolator_1 = require(167) /* ./step_interpolator */;
    __esExport("StepInterpolator", step_interpolator_1.StepInterpolator);
    var transform_1 = require(147) /* ./transform */;
    __esExport("Transform", transform_1.Transform);
},
/* models/transforms/customjs_transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const transform_1 = require(147) /* ./transform */;
    const object_1 = require(13) /* ../../core/util/object */;
    const string_1 = require(29) /* ../../core/util/string */;
    class CustomJSTransform extends transform_1.Transform {
        constructor(attrs) {
            super(attrs);
        }
        static init_CustomJSTransform() {
            this.define(({ Unknown, String, Dict }) => ({
                args: [Dict(Unknown), {}],
                func: [String, ""],
                v_func: [String, ""],
            }));
        }
        get names() {
            return object_1.keys(this.args);
        }
        get values() {
            return object_1.values(this.args);
        }
        _make_transform(name, func) {
            return new Function(...this.names, name, string_1.use_strict(func));
        }
        get scalar_transform() {
            return this._make_transform("x", this.func);
        }
        get vector_transform() {
            return this._make_transform("xs", this.v_func);
        }
        compute(x) {
            return this.scalar_transform(...this.values, x);
        }
        v_compute(xs) {
            return this.vector_transform(...this.values, xs);
        }
    }
    exports.CustomJSTransform = CustomJSTransform;
    CustomJSTransform.__name__ = "CustomJSTransform";
    CustomJSTransform.init_CustomJSTransform();
},
/* models/transforms/dodge.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const range_transform_1 = require(163) /* ./range_transform */;
    class Dodge extends range_transform_1.RangeTransform {
        constructor(attrs) {
            super(attrs);
        }
        static init_Dodge() {
            this.define(({ Number }) => ({
                value: [Number, 0],
            }));
        }
        _compute(x) {
            return x + this.value;
        }
    }
    exports.Dodge = Dodge;
    Dodge.__name__ = "Dodge";
    Dodge.init_Dodge();
},
/* models/transforms/range_transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const transform_1 = require(147) /* ./transform */;
    const range_1 = require(101) /* ../ranges/range */;
    const factor_range_1 = require(100) /* ../ranges/factor_range */;
    const types_1 = require(24) /* ../../core/types */;
    const types_2 = require(8) /* ../../core/util/types */;
    class RangeTransform extends transform_1.Transform {
        constructor(attrs) {
            super(attrs);
        }
        static init_RangeTransform() {
            this.define(({ Ref }) => ({
                range: [Ref(range_1.Range)],
            }));
        }
        v_compute(xs0) {
            let xs;
            if (this.range instanceof factor_range_1.FactorRange)
                xs = this.range.v_synthetic(xs0);
            else if (types_2.isArrayableOf(xs0, types_2.isNumber))
                xs = xs0;
            else
                throw new Error("unexpected");
            const result = new types_1.NumberArray(xs.length);
            for (let i = 0; i < xs.length; i++) {
                const x = xs[i];
                result[i] = this._compute(x);
            }
            return result;
        }
        compute(x) {
            if (this.range instanceof factor_range_1.FactorRange)
                return this._compute(this.range.synthetic(x));
            else if (types_2.isNumber(x))
                return this._compute(x);
            else
                throw new Error("unexpected");
        }
    }
    exports.RangeTransform = RangeTransform;
    RangeTransform.__name__ = "RangeTransform";
    RangeTransform.init_RangeTransform();
},
/* models/transforms/interpolator.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const transform_1 = require(147) /* ./transform */;
    const columnar_data_source_1 = require(92) /* ../sources/columnar_data_source */;
    const types_1 = require(24) /* ../../core/types */;
    const array_1 = require(9) /* ../../core/util/array */;
    const types_2 = require(8) /* ../../core/util/types */;
    class Interpolator extends transform_1.Transform {
        constructor(attrs) {
            super(attrs);
            this._sorted_dirty = true;
        }
        static init_Interpolator() {
            this.define(({ Boolean, Number, String, Ref, Array, Or, Nullable }) => ({
                x: [Or(String, Array(Number))],
                y: [Or(String, Array(Number))],
                data: [Nullable(Ref(columnar_data_source_1.ColumnarDataSource)), null],
                clip: [Boolean, true],
            }));
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.change, () => this._sorted_dirty = true);
        }
        v_compute(xs) {
            const result = new types_1.NumberArray(xs.length);
            for (let i = 0; i < xs.length; i++) {
                const x = xs[i];
                result[i] = this.compute(x);
            }
            return result;
        }
        sort(descending = false) {
            if (!this._sorted_dirty)
                return;
            let tsx;
            let tsy;
            if (types_2.isString(this.x) && types_2.isString(this.y) && this.data != null) {
                const column_names = this.data.columns();
                if (!array_1.includes(column_names, this.x))
                    throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");
                if (!array_1.includes(column_names, this.y))
                    throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");
                tsx = this.data.get_column(this.x);
                tsy = this.data.get_column(this.y);
            }
            else if (types_2.isArray(this.x) && types_2.isArray(this.y)) {
                tsx = this.x;
                tsy = this.y;
            }
            else {
                throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");
            }
            if (tsx.length !== tsy.length)
                throw new Error("The length for x and y do not match");
            if (tsx.length < 2)
                throw new Error("x and y must have at least two elements to support interpolation");
            const n = tsx.length;
            const index = new Uint32Array(n);
            for (let i = 0; i < n; i++) {
                index[i] = i;
            }
            const sign = descending ? -1 : 1;
            index.sort((i, j) => sign * (tsx[i] - tsx[j]));
            this._x_sorted = new types_1.NumberArray(n);
            this._y_sorted = new types_1.NumberArray(n);
            for (let i = 0; i < n; i++) {
                this._x_sorted[i] = tsx[index[i]];
                this._y_sorted[i] = tsy[index[i]];
            }
            this._sorted_dirty = false;
        }
    }
    exports.Interpolator = Interpolator;
    Interpolator.__name__ = "Interpolator";
    Interpolator.init_Interpolator();
},
/* models/transforms/jitter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const range_transform_1 = require(163) /* ./range_transform */;
    const enums_1 = require(20) /* ../../core/enums */;
    const bokeh_math = tslib_1.__importStar(require(10) /* ../../core/util/math */);
    class Jitter extends range_transform_1.RangeTransform {
        constructor(attrs) {
            super(attrs);
        }
        static init_Jitter() {
            this.define(({ Number }) => ({
                mean: [Number, 0],
                width: [Number, 1],
                distribution: [enums_1.Distribution, "uniform"],
            }));
        }
        v_compute(xs0) {
            if (this.previous_values != null && this.previous_values.length == xs0.length)
                return this.previous_values;
            this.previous_values = super.v_compute(xs0);
            return this.previous_values;
        }
        _compute(x) {
            switch (this.distribution) {
                case "uniform":
                    return x + this.mean + (bokeh_math.random() - 0.5) * this.width;
                case "normal":
                    return x + bokeh_math.rnorm(this.mean, this.width);
            }
        }
    }
    exports.Jitter = Jitter;
    Jitter.__name__ = "Jitter";
    Jitter.init_Jitter();
},
/* models/transforms/linear_interpolator.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const array_1 = require(9) /* ../../core/util/array */;
    const interpolator_1 = require(164) /* ./interpolator */;
    class LinearInterpolator extends interpolator_1.Interpolator {
        constructor(attrs) {
            super(attrs);
        }
        compute(x) {
            this.sort(false);
            if (this.clip) {
                if (x < this._x_sorted[0] || x > this._x_sorted[this._x_sorted.length - 1])
                    return NaN;
            }
            else {
                if (x < this._x_sorted[0])
                    return this._y_sorted[0];
                if (x > this._x_sorted[this._x_sorted.length - 1])
                    return this._y_sorted[this._y_sorted.length - 1];
            }
            if (x == this._x_sorted[0])
                return this._y_sorted[0];
            const ind = array_1.find_last_index(this._x_sorted, num => num < x);
            const x1 = this._x_sorted[ind];
            const x2 = this._x_sorted[ind + 1];
            const y1 = this._y_sorted[ind];
            const y2 = this._y_sorted[ind + 1];
            return y1 + (((x - x1) / (x2 - x1)) * (y2 - y1));
        }
    }
    exports.LinearInterpolator = LinearInterpolator;
    LinearInterpolator.__name__ = "LinearInterpolator";
},
/* models/transforms/step_interpolator.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const interpolator_1 = require(164) /* ./interpolator */;
    const enums_1 = require(20) /* ../../core/enums */;
    const array_1 = require(9) /* ../../core/util/array */;
    class StepInterpolator extends interpolator_1.Interpolator {
        constructor(attrs) {
            super(attrs);
        }
        static init_StepInterpolator() {
            this.define(() => ({
                mode: [enums_1.StepMode, "after"],
            }));
        }
        compute(x) {
            this.sort(false);
            if (this.clip) {
                if (x < this._x_sorted[0] || x > this._x_sorted[this._x_sorted.length - 1])
                    return NaN;
            }
            else {
                if (x < this._x_sorted[0])
                    return this._y_sorted[0];
                if (x > this._x_sorted[this._x_sorted.length - 1])
                    return this._y_sorted[this._y_sorted.length - 1];
            }
            let ind;
            switch (this.mode) {
                case "after": {
                    ind = array_1.find_last_index(this._x_sorted, num => x >= num);
                    break;
                }
                case "before": {
                    ind = array_1.find_index(this._x_sorted, num => x <= num);
                    break;
                }
                case "center": {
                    const diffs = this._x_sorted.map((tx) => Math.abs(tx - x));
                    const mdiff = array_1.min(diffs);
                    ind = array_1.find_index(diffs, num => mdiff === num);
                    break;
                }
                default:
                    throw new Error(`unknown mode: ${this.mode}`);
            }
            return ind != -1 ? this._y_sorted[ind] : NaN;
        }
    }
    exports.StepInterpolator = StepInterpolator;
    StepInterpolator.__name__ = "StepInterpolator";
    StepInterpolator.init_StepInterpolator();
},
/* models/ranges/range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const range_1 = require(101) /* ./range */;
    class Range1d extends range_1.Range {
        constructor(attrs) {
            super(attrs);
        }
        static init_Range1d() {
            this.define(({ Number, Nullable }) => ({
                start: [Number, 0],
                end: [Number, 1],
                reset_start: [Nullable(Number), null, {
                        on_update(reset_start, self) {
                            self._reset_start = reset_start !== null && reset_start !== void 0 ? reset_start : self.start;
                        },
                    }],
                reset_end: [Nullable(Number), null, {
                        on_update(reset_end, self) {
                            self._reset_end = reset_end !== null && reset_end !== void 0 ? reset_end : self.end;
                        },
                    }],
            }));
        }
        _set_auto_bounds() {
            if (this.bounds == 'auto') {
                const min = Math.min(this._reset_start, this._reset_end);
                const max = Math.max(this._reset_start, this._reset_end);
                this.setv({ bounds: [min, max] }, { silent: true });
            }
        }
        initialize() {
            super.initialize();
            this._set_auto_bounds();
        }
        get min() {
            return Math.min(this.start, this.end);
        }
        get max() {
            return Math.max(this.start, this.end);
        }
        reset() {
            this._set_auto_bounds();
            const { _reset_start, _reset_end } = this;
            if (this.start != _reset_start || this.end != _reset_end)
                this.setv({ start: _reset_start, end: _reset_end });
            else
                this.change.emit();
        }
        map(fn) {
            return new Range1d({ start: fn(this.start), end: fn(this.end) });
        }
        widen(v) {
            let { start, end } = this;
            if (this.is_reversed) {
                start += v;
                end -= v;
            }
            else {
                start -= v;
                end += v;
            }
            return new Range1d({ start, end });
        }
    }
    exports.Range1d = Range1d;
    Range1d.__name__ = "Range1d";
    Range1d.init_Range1d();
},
/* models/scales/linear_interpolation_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scale_1 = require(159) /* ./scale */;
    const types_1 = require(24) /* ../../core/types */;
    const array_1 = require(9) /* ../../core/util/array */;
    const arrayable_1 = require(12) /* ../../core/util/arrayable */;
    class LinearInterpolationScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        static init_LinearInterpolationScale() {
            this.internal(({ Arrayable }) => ({
                binning: [Arrayable],
            }));
        }
        compute(x) {
            return x;
        }
        v_compute(xs) {
            const norm_xs = arrayable_1.norm(xs, this.source_range.start, this.source_range.end);
            const edges_norm = array_1.linspace(0, 1, this.binning.length);
            const interpolated = arrayable_1.interpolate(norm_xs, edges_norm, this.binning);
            const norm_interp = arrayable_1.norm(interpolated, this.source_range.start, this.source_range.end);
            const target_span = this.target_range.end - this.target_range.start;
            const sxs = arrayable_1.map(norm_interp, (x) => this.target_range.start + x * target_span);
            return new types_1.NumberArray(sxs);
        }
        invert(xprime) {
            return xprime;
        }
        v_invert(xprimes) {
            return new types_1.NumberArray(xprimes);
        }
    }
    exports.LinearInterpolationScale = LinearInterpolationScale;
    LinearInterpolationScale.__name__ = "LinearInterpolationScale";
    LinearInterpolationScale.init_LinearInterpolationScale();
},
/* models/scales/log_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_scale_1 = require(158) /* ./continuous_scale */;
    const types_1 = require(24) /* ../../core/types */;
    class LogScale extends continuous_scale_1.ContinuousScale {
        constructor(attrs) {
            super(attrs);
        }
        compute(x) {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            let value;
            if (inter_factor == 0)
                value = 0;
            else {
                const _x = (Math.log(x) - inter_offset) / inter_factor;
                if (isFinite(_x))
                    value = _x * factor + offset;
                else
                    value = NaN;
            }
            return value;
        }
        v_compute(xs) {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            const result = new types_1.NumberArray(xs.length);
            if (inter_factor == 0) {
                for (let i = 0; i < xs.length; i++)
                    result[i] = 0;
            }
            else {
                for (let i = 0; i < xs.length; i++) {
                    const _x = (Math.log(xs[i]) - inter_offset) / inter_factor;
                    let value;
                    if (isFinite(_x))
                        value = _x * factor + offset;
                    else
                        value = NaN;
                    result[i] = value;
                }
            }
            return result;
        }
        invert(xprime) {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            const value = (xprime - offset) / factor;
            return Math.exp(inter_factor * value + inter_offset);
        }
        v_invert(xprimes) {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            const result = new types_1.NumberArray(xprimes.length);
            for (let i = 0; i < xprimes.length; i++) {
                const value = (xprimes[i] - offset) / factor;
                result[i] = Math.exp(inter_factor * value + inter_offset);
            }
            return result;
        }
        _get_safe_factor(orig_start, orig_end) {
            let start = orig_start < 0 ? 0 : orig_start;
            let end = orig_end < 0 ? 0 : orig_end;
            if (start == end) {
                if (start == 0)
                    [start, end] = [1, 10];
                else {
                    const log_val = Math.log(start) / Math.log(10);
                    start = 10 ** Math.floor(log_val);
                    if (Math.ceil(log_val) != Math.floor(log_val))
                        end = 10 ** Math.ceil(log_val);
                    else
                        end = 10 ** (Math.ceil(log_val) + 1);
                }
            }
            return [start, end];
        }
        /*protected*/ _compute_state() {
            const source_start = this.source_range.start;
            const source_end = this.source_range.end;
            const target_start = this.target_range.start;
            const target_end = this.target_range.end;
            const screen_range = target_end - target_start;
            const [start, end] = this._get_safe_factor(source_start, source_end);
            let inter_factor;
            let inter_offset;
            if (start == 0) {
                inter_factor = Math.log(end);
                inter_offset = 0;
            }
            else {
                inter_factor = Math.log(end) - Math.log(start);
                inter_offset = Math.log(start);
            }
            const factor = screen_range;
            const offset = target_start;
            return [factor, offset, inter_factor, inter_offset];
        }
    }
    exports.LogScale = LogScale;
    LogScale.__name__ = "LogScale";
},
/* core/util/text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const dom_1 = require(71) /* ../dom */;
    const _font_cache = new Map();
    function measure_font(font) {
        const metrics = _font_cache.get(font);
        if (metrics != null)
            return metrics;
        const text = dom_1.span({ style: { font } }, "Hg");
        const block = dom_1.div({ style: { display: "inline-block", width: "1px", height: "0px" } });
        const elem = dom_1.div({}, text, block);
        document.body.appendChild(elem);
        try {
            block.style.verticalAlign = "baseline";
            const ascent = dom_1.offset(block).top - dom_1.offset(text).top;
            block.style.verticalAlign = "bottom";
            const height = dom_1.offset(block).top - dom_1.offset(text).top;
            const result = { height, ascent, descent: height - ascent };
            _font_cache.set(font, result);
            return result;
        }
        finally {
            document.body.removeChild(elem);
        }
    }
    exports.measure_font = measure_font;
    const _text_cache = new Map();
    function measure_text(text, font) {
        let size_cache = _text_cache.get(font);
        if (size_cache != null) {
            const size = size_cache.get(text);
            if (size != null)
                return size;
        }
        else {
            size_cache = new Map();
            _text_cache.set(font, size_cache);
        }
        const el = dom_1.div({ style: { display: "inline-block", "white-space": "nowrap", font } }, text);
        document.body.appendChild(el);
        try {
            const { width, height } = el.getBoundingClientRect();
            size_cache.set(text, { width, height });
            return { width, height };
        }
        finally {
            document.body.removeChild(el);
        }
    }
    exports.measure_text = measure_text;
},
/* models/annotations/label.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const text_annotation_1 = require(173) /* ./text_annotation */;
    const enums_1 = require(20) /* ../../core/enums */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    class LabelView extends text_annotation_1.TextAnnotationView {
        initialize() {
            super.initialize();
            this.visuals.warm_cache();
        }
        _get_size() {
            const { ctx } = this.layer;
            this.visuals.text.set_value(ctx);
            const { width, ascent } = ctx.measureText(this.model.text);
            return { width, height: ascent };
        }
        _render() {
            // Here because AngleSpec does units transform and label doesn't support specs
            let angle;
            switch (this.model.angle_units) {
                case "rad": {
                    angle = -this.model.angle;
                    break;
                }
                case "deg": {
                    angle = (-this.model.angle * Math.PI) / 180.0;
                    break;
                }
            }
            const panel = this.panel != null ? this.panel : this.plot_view.frame;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            let sx = this.model.x_units == "data" ? xscale.compute(this.model.x) : panel.xview.compute(this.model.x);
            let sy = this.model.y_units == "data" ? yscale.compute(this.model.y) : panel.yview.compute(this.model.y);
            sx += this.model.x_offset;
            sy -= this.model.y_offset;
            const draw = this.model.render_mode == 'canvas' ? this._canvas_text.bind(this) : this._css_text.bind(this);
            draw(this.layer.ctx, this.model.text, sx, sy, angle);
        }
    }
    exports.LabelView = LabelView;
    LabelView.__name__ = "LabelView";
    class Label extends text_annotation_1.TextAnnotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_Label() {
            this.prototype.default_view = LabelView;
            this.mixins([
                mixins.Text /*Scalar*/,
                ["border_", mixins.Line],
                ["background_", mixins.Fill],
            ]);
            this.define(({ Number, String, Angle }) => ({
                x: [Number],
                x_units: [enums_1.SpatialUnits, "data"],
                y: [Number],
                y_units: [enums_1.SpatialUnits, "data"],
                text: [String],
                angle: [Angle, 0],
                angle_units: [enums_1.AngleUnits, "rad"],
                x_offset: [Number, 0],
                y_offset: [Number, 0],
            }));
            this.override({
                background_fill_color: null,
                border_line_color: null,
            });
        }
    }
    exports.Label = Label;
    Label.__name__ = "Label";
    Label.init_Label();
},
/* models/annotations/text_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const annotation_1 = require(35) /* ./annotation */;
    const dom_1 = require(71) /* ../../core/dom */;
    const enums_1 = require(20) /* ../../core/enums */;
    const text_1 = require(171) /* ../../core/util/text */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    class TextAnnotationView extends annotation_1.AnnotationView {
        constructor() {
            super(...arguments);
            this.rotate = true;
        }
        initialize() {
            super.initialize();
            if (this.model.render_mode == 'css') {
                this.el = dom_1.div();
                this.plot_view.canvas_view.add_overlay(this.el);
            }
        }
        remove() {
            if (this.el != null)
                dom_1.remove(this.el);
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            if (this.model.render_mode == 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, () => this.render());
            }
            else {
                this.connect(this.model.change, () => this.plot_view.request_render());
            }
        }
        render() {
            if (!this.model.visible && this.model.render_mode == "css")
                dom_1.undisplay(this.el);
            super.render();
        }
        _calculate_text_dimensions(ctx, text) {
            const { width } = ctx.measureText(text);
            const { height } = text_1.measure_font(this.visuals.text.font_value());
            return [width, height];
        }
        _calculate_bounding_box_dimensions(ctx, text) {
            const [width, height] = this._calculate_text_dimensions(ctx, text);
            let x_offset;
            switch (ctx.textAlign) {
                case 'left':
                    x_offset = 0;
                    break;
                case 'center':
                    x_offset = -width / 2;
                    break;
                case 'right':
                    x_offset = -width;
                    break;
                default:
                    assert_1.unreachable();
            }
            // guestimated from https://www.w3.org/TR/2dcontext/#dom-context-2d-textbaseline
            let y_offset;
            switch (ctx.textBaseline) {
                case 'top':
                    y_offset = 0.0;
                    break;
                case 'middle':
                    y_offset = -0.5 * height;
                    break;
                case 'bottom':
                    y_offset = -1.0 * height;
                    break;
                case 'alphabetic':
                    y_offset = -0.8 * height;
                    break;
                case 'hanging':
                    y_offset = -0.17 * height;
                    break;
                case 'ideographic':
                    y_offset = -0.83 * height;
                    break;
                default:
                    assert_1.unreachable();
            }
            return [x_offset, y_offset, width, height];
        }
        _canvas_text(ctx, text, sx, sy, angle) {
            this.visuals.text.set_value(ctx);
            const bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            ctx.save();
            ctx.beginPath();
            ctx.translate(sx, sy);
            if (angle)
                ctx.rotate(angle);
            ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fill();
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.stroke();
            }
            if (this.visuals.text.doit) {
                this.visuals.text.set_value(ctx);
                ctx.fillText(text, 0, 0);
            }
            ctx.restore();
        }
        _css_text(ctx, text, sx, sy, angle) {
            const { el } = this;
            assert_1.assert(el != null);
            dom_1.undisplay(el);
            this.visuals.text.set_value(ctx);
            const bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            // attempt to support vector string-style ("8 4 8") line dashing for css mode
            const ld = this.visuals.border_line.line_dash.value();
            const line_dash = ld.length < 2 ? "solid" : "dashed";
            this.visuals.border_line.set_value(ctx);
            this.visuals.background_fill.set_value(ctx);
            el.style.position = 'absolute';
            el.style.left = `${sx + bbox_dims[0]}px`;
            el.style.top = `${sy + bbox_dims[1]}px`;
            el.style.color = `${this.visuals.text.text_color.value()}`;
            el.style.opacity = `${this.visuals.text.text_alpha.value()}`;
            el.style.font = `${this.visuals.text.font_value()}`;
            el.style.lineHeight = "normal"; // needed to prevent ipynb css override
            if (angle) {
                el.style.transform = `rotate(${angle}rad)`;
            }
            if (this.visuals.background_fill.doit) {
                el.style.backgroundColor = `${this.visuals.background_fill.color_value()}`;
            }
            if (this.visuals.border_line.doit) {
                el.style.borderStyle = `${line_dash}`;
                el.style.borderWidth = `${this.visuals.border_line.line_width.value()}px`;
                el.style.borderColor = `${this.visuals.border_line.color_value()}`;
            }
            el.textContent = text;
            dom_1.display(el);
        }
    }
    exports.TextAnnotationView = TextAnnotationView;
    TextAnnotationView.__name__ = "TextAnnotationView";
    class TextAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_TextAnnotation() {
            this.define(() => ({
                render_mode: [enums_1.RenderMode, "canvas"],
            }));
        }
    }
    exports.TextAnnotation = TextAnnotation;
    TextAnnotation.__name__ = "TextAnnotation";
    TextAnnotation.init_TextAnnotation();
},
/* models/annotations/label_set.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const text_annotation_1 = require(173) /* ./text_annotation */;
    const column_data_source_1 = require(130) /* ../sources/column_data_source */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    const dom_1 = require(71) /* ../../core/dom */;
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    class LabelSetView extends text_annotation_1.TextAnnotationView {
        initialize() {
            super.initialize();
            this.set_data(this.model.source);
            if (this.model.render_mode == 'css') {
                for (let i = 0, end = this._text.length; i < end; i++) {
                    const el = dom_1.div({ style: { display: "none" } });
                    this.el.appendChild(el);
                }
            }
        }
        connect_signals() {
            super.connect_signals();
            if (this.model.render_mode == 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, () => {
                    this.set_data(this.model.source);
                    this.render();
                });
                this.connect(this.model.source.streaming, () => {
                    this.set_data(this.model.source);
                    this.render();
                });
                this.connect(this.model.source.patching, () => {
                    this.set_data(this.model.source);
                    this.render();
                });
                this.connect(this.model.source.change, () => {
                    this.set_data(this.model.source);
                    this.render();
                });
            }
            else {
                this.connect(this.model.change, () => {
                    this.set_data(this.model.source);
                    this.plot_view.request_render();
                });
                this.connect(this.model.source.streaming, () => {
                    this.set_data(this.model.source);
                    this.plot_view.request_render();
                });
                this.connect(this.model.source.patching, () => {
                    this.set_data(this.model.source);
                    this.plot_view.request_render();
                });
                this.connect(this.model.source.change, () => {
                    this.set_data(this.model.source);
                    this.plot_view.request_render();
                });
            }
        }
        set_data(source) {
            super.set_data(source);
            this.visuals.warm_cache(source);
        }
        _map_data() {
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            const panel = this.panel != null ? this.panel : this.plot_view.frame;
            const sx = this.model.x_units == "data" ? xscale.v_compute(this._x) : panel.xview.v_compute(this._x);
            const sy = this.model.y_units == "data" ? yscale.v_compute(this._y) : panel.yview.v_compute(this._y);
            return [sx, sy];
        }
        _render() {
            const draw = this.model.render_mode == 'canvas' ? this._v_canvas_text.bind(this) : this._v_css_text.bind(this);
            const { ctx } = this.layer;
            const [sx, sy] = this._map_data();
            for (let i = 0, end = this._text.length; i < end; i++) {
                draw(ctx, i, this._text[i], sx[i] + this._x_offset[i], sy[i] - this._y_offset[i], this._angle[i]);
            }
        }
        _get_size() {
            const { ctx } = this.layer;
            this.visuals.text.set_value(ctx);
            const { width, ascent } = ctx.measureText(this._text[0]);
            return { width, height: ascent };
        }
        _v_canvas_text(ctx, i, text, sx, sy, angle) {
            this.visuals.text.set_vectorize(ctx, i);
            const bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            ctx.save();
            ctx.beginPath();
            ctx.translate(sx, sy);
            ctx.rotate(angle);
            ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_vectorize(ctx, i);
                ctx.fill();
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_vectorize(ctx, i);
                ctx.stroke();
            }
            if (this.visuals.text.doit) {
                this.visuals.text.set_vectorize(ctx, i);
                ctx.fillText(text, 0, 0);
            }
            ctx.restore();
        }
        _v_css_text(ctx, i, text, sx, sy, angle) {
            const el = this.el.children[i];
            el.textContent = text;
            this.visuals.text.set_vectorize(ctx, i);
            const bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            // attempt to support vector-style ("8 4 8") line dashing for css mode
            const ld = this.visuals.border_line.line_dash.value();
            const line_dash = ld.length < 2 ? "solid" : "dashed";
            this.visuals.border_line.set_vectorize(ctx, i);
            this.visuals.background_fill.set_vectorize(ctx, i);
            el.style.position = 'absolute';
            el.style.left = `${sx + bbox_dims[0]}px`;
            el.style.top = `${sy + bbox_dims[1]}px`;
            el.style.color = `${this.visuals.text.text_color.value()}`;
            el.style.opacity = `${this.visuals.text.text_alpha.value()}`;
            el.style.font = `${this.visuals.text.font_value()}`;
            el.style.lineHeight = "normal"; // needed to prevent ipynb css override
            if (angle) {
                el.style.transform = `rotate(${angle}rad)`;
            }
            if (this.visuals.background_fill.doit) {
                el.style.backgroundColor = `${this.visuals.background_fill.color_value()}`;
            }
            if (this.visuals.border_line.doit) {
                el.style.borderStyle = `${line_dash}`;
                el.style.borderWidth = `${this.visuals.border_line.line_width.value()}px`;
                el.style.borderColor = `${this.visuals.border_line.color_value()}`;
            }
            dom_1.display(el);
        }
    }
    exports.LabelSetView = LabelSetView;
    LabelSetView.__name__ = "LabelSetView";
    class LabelSet extends text_annotation_1.TextAnnotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_LabelSet() {
            this.prototype.default_view = LabelSetView;
            this.mixins([
                mixins.TextVector,
                ["border_", mixins.LineVector],
                ["background_", mixins.FillVector],
            ]);
            this.define(({ Ref }) => ({
                x: [p.XCoordinateSpec],
                y: [p.YCoordinateSpec],
                x_units: [enums_1.SpatialUnits, "data"],
                y_units: [enums_1.SpatialUnits, "data"],
                text: [p.StringSpec, { field: "text" }],
                angle: [p.AngleSpec, 0],
                x_offset: [p.NumberSpec, { value: 0 }],
                y_offset: [p.NumberSpec, { value: 0 }],
                source: [Ref(column_data_source_1.ColumnDataSource), () => new column_data_source_1.ColumnDataSource()],
            }));
            this.override({
                background_fill_color: null,
                border_line_color: null,
            });
        }
    }
    exports.LabelSet = LabelSet;
    LabelSet.__name__ = "LabelSet";
    LabelSet.init_LabelSet();
},
/* models/annotations/legend.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(35) /* ./annotation */;
    const legend_item_1 = require(176) /* ./legend_item */;
    const enums_1 = require(20) /* ../../core/enums */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    const signaling_1 = require(15) /* ../../core/signaling */;
    const text_1 = require(171) /* ../../core/util/text */;
    const bbox_1 = require(86) /* ../../core/util/bbox */;
    const array_1 = require(9) /* ../../core/util/array */;
    const types_1 = require(8) /* ../../core/util/types */;
    const assert_1 = require(11) /* ../../core/util/assert */;
    class LegendView extends annotation_1.AnnotationView {
        cursor(_sx, _sy) {
            return this.model.click_policy == "none" ? null : "pointer";
        }
        get legend_padding() {
            return this.visuals.border_line.line_color.value() != null ? this.model.padding : 0;
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.plot_view.request_render());
            this.connect(this.model.item_change, () => this.plot_view.request_render());
        }
        compute_legend_bbox() {
            const legend_names = this.model.get_legend_names();
            const { glyph_height, glyph_width } = this.model;
            const { label_height, label_width } = this.model;
            this.max_label_height = array_1.max([text_1.measure_font(this.visuals.label_text.font_value()).height, label_height, glyph_height]);
            // this is to measure text properties
            const { ctx } = this.layer;
            ctx.save();
            this.visuals.label_text.set_value(ctx);
            this.text_widths = new Map();
            for (const name of legend_names) {
                this.text_widths.set(name, array_1.max([ctx.measureText(name).width, label_width]));
            }
            this.visuals.title_text.set_value(ctx);
            this.title_height = this.model.title ? text_1.measure_font(this.visuals.title_text.font_value()).height + this.model.title_standoff : 0;
            this.title_width = this.model.title ? ctx.measureText(this.model.title).width : 0;
            ctx.restore();
            const max_label_width = Math.max(array_1.max([...this.text_widths.values()]), 0);
            const legend_margin = this.model.margin;
            const { legend_padding } = this;
            const legend_spacing = this.model.spacing;
            const { label_standoff } = this.model;
            let legend_height, legend_width;
            if (this.model.orientation == "vertical") {
                legend_height = legend_names.length * this.max_label_height + Math.max(legend_names.length - 1, 0) * legend_spacing + 2 * legend_padding + this.title_height;
                legend_width = array_1.max([(max_label_width + glyph_width + label_standoff + 2 * legend_padding), this.title_width + 2 * legend_padding]);
            }
            else {
                let item_width = 2 * legend_padding + Math.max(legend_names.length - 1, 0) * legend_spacing;
                for (const [, width] of this.text_widths) {
                    item_width += array_1.max([width, label_width]) + glyph_width + label_standoff;
                }
                legend_width = array_1.max([this.title_width + 2 * legend_padding, item_width]);
                legend_height = this.max_label_height + this.title_height + 2 * legend_padding;
            }
            const panel = this.panel != null ? this.panel : this.plot_view.frame;
            const [hr, vr] = panel.bbox.ranges;
            const { location } = this.model;
            let sx, sy;
            if (types_1.isString(location)) {
                switch (location) {
                    case 'top_left':
                        sx = hr.start + legend_margin;
                        sy = vr.start + legend_margin;
                        break;
                    case 'top_center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = vr.start + legend_margin;
                        break;
                    case 'top_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = vr.start + legend_margin;
                        break;
                    case 'bottom_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'bottom_center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'bottom_left':
                        sx = hr.start + legend_margin;
                        sy = vr.end - legend_margin - legend_height;
                        break;
                    case 'center_left':
                        sx = hr.start + legend_margin;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    case 'center':
                        sx = (hr.end + hr.start) / 2 - legend_width / 2;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                    case 'center_right':
                        sx = hr.end - legend_margin - legend_width;
                        sy = (vr.end + vr.start) / 2 - legend_height / 2;
                        break;
                }
            }
            else if (types_1.isArray(location) && location.length == 2) {
                const [vx, vy] = location;
                sx = panel.xview.compute(vx);
                sy = panel.yview.compute(vy) - legend_height;
            }
            else
                assert_1.unreachable();
            return new bbox_1.BBox({ left: sx, top: sy, width: legend_width, height: legend_height });
        }
        interactive_bbox() {
            return this.compute_legend_bbox();
        }
        interactive_hit(sx, sy) {
            const bbox = this.interactive_bbox();
            return bbox.contains(sx, sy);
        }
        on_hit(sx, sy) {
            let yoffset;
            const { glyph_width } = this.model;
            const { legend_padding } = this;
            const legend_spacing = this.model.spacing;
            const { label_standoff } = this.model;
            let xoffset = (yoffset = legend_padding);
            const legend_bbox = this.compute_legend_bbox();
            const vertical = this.model.orientation == "vertical";
            for (const item of this.model.items) {
                const labels = item.get_labels_list_from_label_prop();
                for (const label of labels) {
                    const x1 = legend_bbox.x + xoffset;
                    const y1 = legend_bbox.y + yoffset + this.title_height;
                    let w, h;
                    if (vertical)
                        [w, h] = [legend_bbox.width - 2 * legend_padding, this.max_label_height];
                    else
                        [w, h] = [this.text_widths.get(label) + glyph_width + label_standoff, this.max_label_height];
                    const bbox = new bbox_1.BBox({ left: x1, top: y1, width: w, height: h });
                    if (bbox.contains(sx, sy)) {
                        switch (this.model.click_policy) {
                            case "hide": {
                                for (const r of item.renderers)
                                    r.visible = !r.visible;
                                break;
                            }
                            case "mute": {
                                for (const r of item.renderers)
                                    r.muted = !r.muted;
                                break;
                            }
                        }
                        return true;
                    }
                    if (vertical)
                        yoffset += this.max_label_height + legend_spacing;
                    else
                        xoffset += this.text_widths.get(label) + glyph_width + label_standoff + legend_spacing;
                }
            }
            return false;
        }
        _render() {
            if (this.model.items.length == 0)
                return;
            // set a backref on render so that items can later signal item_change upates
            // on the model to trigger a re-render
            for (const item of this.model.items) {
                item.legend = this.model;
            }
            const { ctx } = this.layer;
            const bbox = this.compute_legend_bbox();
            ctx.save();
            this._draw_legend_box(ctx, bbox);
            this._draw_legend_items(ctx, bbox);
            if (this.model.title)
                this._draw_title(ctx, bbox);
            ctx.restore();
        }
        _draw_legend_box(ctx, bbox) {
            ctx.beginPath();
            ctx.rect(bbox.x, bbox.y, bbox.width, bbox.height);
            this.visuals.background_fill.set_value(ctx);
            ctx.fill();
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.stroke();
            }
        }
        _draw_legend_items(ctx, bbox) {
            const { glyph_width, glyph_height } = this.model;
            const { legend_padding } = this;
            const legend_spacing = this.model.spacing;
            const { label_standoff } = this.model;
            let xoffset = legend_padding;
            let yoffset = legend_padding;
            const vertical = this.model.orientation == "vertical";
            for (const item of this.model.items) {
                const labels = item.get_labels_list_from_label_prop();
                const field = item.get_field_from_label_prop();
                if (labels.length == 0)
                    continue;
                const active = (() => {
                    switch (this.model.click_policy) {
                        case "none": return true;
                        case "hide": return array_1.every(item.renderers, r => r.visible);
                        case "mute": return array_1.every(item.renderers, r => !r.muted);
                    }
                })();
                for (const label of labels) {
                    const x1 = bbox.x + xoffset;
                    const y1 = bbox.y + yoffset + this.title_height;
                    const x2 = x1 + glyph_width;
                    const y2 = y1 + glyph_height;
                    if (vertical)
                        yoffset += this.max_label_height + legend_spacing;
                    else
                        xoffset += this.text_widths.get(label) + glyph_width + label_standoff + legend_spacing;
                    this.visuals.label_text.set_value(ctx);
                    ctx.fillText(label, x2 + label_standoff, y1 + this.max_label_height / 2.0);
                    for (const r of item.renderers) {
                        const view = this.plot_view.renderer_view(r);
                        view === null || view === void 0 ? void 0 : view.draw_legend(ctx, x1, x2, y1, y2, field, label, item.index);
                    }
                    if (!active) {
                        let w, h;
                        if (vertical)
                            [w, h] = [bbox.width - 2 * legend_padding, this.max_label_height];
                        else
                            [w, h] = [this.text_widths.get(label) + glyph_width + label_standoff, this.max_label_height];
                        ctx.beginPath();
                        ctx.rect(x1, y1, w, h);
                        this.visuals.inactive_fill.set_value(ctx);
                        ctx.fill();
                    }
                }
            }
        }
        _draw_title(ctx, bbox) {
            if (!this.visuals.title_text.doit)
                return;
            ctx.save();
            ctx.translate(bbox.x0, bbox.y0 + this.title_height);
            this.visuals.title_text.set_value(ctx);
            ctx.fillText(this.model.title, this.legend_padding, this.legend_padding - this.model.title_standoff);
            ctx.restore();
        }
        _get_size() {
            const { width, height } = this.compute_legend_bbox();
            return {
                width: width + 2 * this.model.margin,
                height: height + 2 * this.model.margin,
            };
        }
    }
    exports.LegendView = LegendView;
    LegendView.__name__ = "LegendView";
    class Legend extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this.item_change = new signaling_1.Signal0(this, "item_change");
        }
        static init_Legend() {
            this.prototype.default_view = LegendView;
            this.mixins([
                ["label_", mixins.Text],
                ["title_", mixins.Text],
                ["inactive_", mixins.Fill],
                ["border_", mixins.Line],
                ["background_", mixins.Fill],
            ]);
            this.define(({ Number, String, Array, Tuple, Or, Ref }) => ({
                orientation: [enums_1.Orientation, "vertical"],
                location: [Or(enums_1.LegendLocation, Tuple(Number, Number)), "top_right"],
                title: [String],
                title_standoff: [Number, 5],
                label_standoff: [Number, 5],
                glyph_height: [Number, 20],
                glyph_width: [Number, 20],
                label_height: [Number, 20],
                label_width: [Number, 20],
                margin: [Number, 10],
                padding: [Number, 10],
                spacing: [Number, 3],
                items: [Array(Ref(legend_item_1.LegendItem)), []],
                click_policy: [enums_1.LegendClickPolicy, "none"],
            }));
            this.override({
                border_line_color: "#e5e5e5",
                border_line_alpha: 0.5,
                border_line_width: 1,
                background_fill_color: "#ffffff",
                background_fill_alpha: 0.95,
                inactive_fill_color: "white",
                inactive_fill_alpha: 0.7,
                label_text_font_size: "13px",
                label_text_baseline: "middle",
                title_text_font_size: "13px",
                title_text_font_style: "italic",
            });
        }
        get_legend_names() {
            const legend_names = [];
            for (const item of this.items) {
                const labels = item.get_labels_list_from_label_prop();
                legend_names.push(...labels);
            }
            return legend_names;
        }
    }
    exports.Legend = Legend;
    Legend.__name__ = "Legend";
    Legend.init_Legend();
},
/* models/annotations/legend_item.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const model_1 = require(88) /* ../../model */;
    const glyph_renderer_1 = require(103) /* ../renderers/glyph_renderer */;
    const columnar_data_source_1 = require(92) /* ../sources/columnar_data_source */;
    const vectorization_1 = require(177) /* ../../core/vectorization */;
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    const logging_1 = require(19) /* ../../core/logging */;
    const array_1 = require(9) /* ../../core/util/array */;
    class LegendItem extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        static init_LegendItem() {
            this.define(({ Int, Array, Ref, Nullable }) => ({
                label: [p.NullStringSpec, null],
                renderers: [Array(Ref(glyph_renderer_1.GlyphRenderer)), []],
                index: [Nullable(Int), null],
            }));
        }
        /*protected*/ _check_data_sources_on_renderers() {
            const field = this.get_field_from_label_prop();
            if (field != null) {
                if (this.renderers.length < 1) {
                    return false;
                }
                const source = this.renderers[0].data_source;
                if (source != null) {
                    for (const r of this.renderers) {
                        if (r.data_source != source) {
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        /*protected*/ _check_field_label_on_data_source() {
            const field = this.get_field_from_label_prop();
            if (field != null) {
                if (this.renderers.length < 1) {
                    return false;
                }
                const source = this.renderers[0].data_source;
                if (source != null && !array_1.includes(source.columns(), field)) {
                    return false;
                }
            }
            return true;
        }
        initialize() {
            super.initialize();
            this.legend = null;
            this.connect(this.change, () => { var _a; return (_a = this.legend) === null || _a === void 0 ? void 0 : _a.item_change.emit(); });
            // Validate data_sources match
            const data_source_validation = this._check_data_sources_on_renderers();
            if (!data_source_validation)
                logging_1.logger.error("Non matching data sources on legend item renderers");
            // Validate label in data_source
            const field_validation = this._check_field_label_on_data_source();
            if (!field_validation)
                logging_1.logger.error(`Bad column name on label: ${this.label}`);
        }
        get_field_from_label_prop() {
            const { label } = this;
            return vectorization_1.isField(label) ? label.field : null;
        }
        get_labels_list_from_label_prop() {
            // Always return a list of the labels
            if (vectorization_1.isValue(this.label)) {
                const { value } = this.label;
                return value != null ? [value] : [];
            }
            const field = this.get_field_from_label_prop();
            if (field != null) {
                let source;
                if (this.renderers[0] && this.renderers[0].data_source != null)
                    source = this.renderers[0].data_source;
                else
                    return ["No source found"];
                if (source instanceof columnar_data_source_1.ColumnarDataSource) {
                    const data = source.get_column(field);
                    if (data != null)
                        return array_1.uniq(Array.from(data));
                    else
                        return ["Invalid field"];
                }
            }
            return [];
        }
    }
    exports.LegendItem = LegendItem;
    LegendItem.__name__ = "LegendItem";
    LegendItem.init_LegendItem();
},
/* core/vectorization.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./util/types */;
    function isValue(obj) {
        return types_1.isPlainObject(obj) && "value" in obj;
    }
    exports.isValue = isValue;
    function isField(obj) {
        return types_1.isPlainObject(obj) && "field" in obj;
    }
    exports.isField = isField;
},
/* models/annotations/poly_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(35) /* ./annotation */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    const signaling_1 = require(15) /* ../../core/signaling */;
    class PolyAnnotationView extends annotation_1.AnnotationView {
        connect_signals() {
            super.connect_signals();
            // need to respond to either normal BB change events or silent
            // "data only updates" that tools might want to use
            this.connect(this.model.change, () => this.plot_view.request_render());
            this.connect(this.model.data_update, () => this.plot_view.request_render());
        }
        _render() {
            const { xs, ys } = this.model;
            if (xs.length != ys.length)
                return;
            if (xs.length < 3 || ys.length < 3)
                return;
            const { frame } = this.plot_view;
            const { ctx } = this.layer;
            for (let i = 0, end = xs.length; i < end; i++) {
                let sx;
                if (this.model.xs_units == 'screen')
                    sx = this.model.screen ? xs[i] : frame.xview.compute(xs[i]);
                else
                    throw new Error("not implemented");
                let sy;
                if (this.model.ys_units == 'screen')
                    sy = this.model.screen ? ys[i] : frame.yview.compute(ys[i]);
                else
                    throw new Error("not implemented");
                if (i == 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx, sy);
                }
                else {
                    ctx.lineTo(sx, sy);
                }
            }
            ctx.closePath();
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                ctx.fill();
            }
        }
    }
    exports.PolyAnnotationView = PolyAnnotationView;
    PolyAnnotationView.__name__ = "PolyAnnotationView";
    class PolyAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_PolyAnnotation() {
            this.prototype.default_view = PolyAnnotationView;
            this.mixins([mixins.Line /*Scalar*/, mixins.Fill /*Scalar*/]);
            this.define(({ Number, Array }) => ({
                xs: [Array(Number), []],
                xs_units: [enums_1.SpatialUnits, "data"],
                ys: [Array(Number), []],
                ys_units: [enums_1.SpatialUnits, "data"],
            }));
            this.internal(({ Boolean }) => ({
                screen: [Boolean, false],
            }));
            this.override({
                fill_color: "#fff9ba",
                fill_alpha: 0.4,
                line_color: "#cccccc",
                line_alpha: 0.3,
            });
        }
        initialize() {
            super.initialize();
            this.data_update = new signaling_1.Signal0(this, "data_update");
        }
        update({ xs, ys }) {
            this.setv({ xs, ys, screen: true }, { silent: true });
            this.data_update.emit();
        }
    }
    exports.PolyAnnotation = PolyAnnotation;
    PolyAnnotation.__name__ = "PolyAnnotation";
    PolyAnnotation.init_PolyAnnotation();
},
/* models/annotations/slope.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(35) /* ./annotation */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    class SlopeView extends annotation_1.AnnotationView {
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.plot_view.request_render());
        }
        _render() {
            const { gradient, y_intercept } = this.model;
            if (gradient == null || y_intercept == null)
                return;
            const { frame } = this.plot_view;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            let sy_start, sy_end, sx_start, sx_end;
            if (gradient == 0) {
                sy_start = yscale.compute(y_intercept);
                sy_end = sy_start;
                sx_start = frame.bbox.left;
                sx_end = sx_start + frame.bbox.width;
            }
            else {
                sy_start = frame.bbox.top;
                sy_end = sy_start + frame.bbox.height;
                const y_start = yscale.invert(sy_start);
                const y_end = yscale.invert(sy_end);
                const x_start = (y_start - y_intercept) / gradient;
                const x_end = (y_end - y_intercept) / gradient;
                sx_start = xscale.compute(x_start);
                sx_end = xscale.compute(x_end);
            }
            const { ctx } = this.layer;
            ctx.save();
            ctx.beginPath();
            this.visuals.line.set_value(ctx);
            ctx.moveTo(sx_start, sy_start);
            ctx.lineTo(sx_end, sy_end);
            ctx.stroke();
            ctx.restore();
        }
    }
    exports.SlopeView = SlopeView;
    SlopeView.__name__ = "SlopeView";
    class Slope extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_Slope() {
            this.prototype.default_view = SlopeView;
            this.mixins(mixins.Line /*Scalar*/);
            this.define(({ Number, Nullable }) => ({
                gradient: [Nullable(Number), null],
                y_intercept: [Nullable(Number), null],
            }));
            this.override({
                line_color: 'black',
            });
        }
    }
    exports.Slope = Slope;
    Slope.__name__ = "Slope";
    Slope.init_Slope();
},
/* models/annotations/span.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(35) /* ./annotation */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    class SpanView extends annotation_1.AnnotationView {
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.plot_view.request_paint(this));
        }
        _render() {
            const { location } = this.model;
            if (location == null) {
                return;
            }
            const { frame } = this.plot_view;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            const _calc_dim = (scale, view) => {
                if (this.model.location_units == 'data')
                    return scale.compute(location);
                else
                    return this.model.for_hover ? location : view.compute(location);
            };
            let height, sleft, stop, width;
            if (this.model.dimension == 'width') {
                stop = _calc_dim(yscale, frame.yview);
                sleft = frame.bbox.left;
                width = frame.bbox.width;
                height = this.model.properties.line_width.value();
            }
            else {
                stop = frame.bbox.top;
                sleft = _calc_dim(xscale, frame.xview);
                width = this.model.properties.line_width.value();
                height = frame.bbox.height;
            }
            const { ctx } = this.layer;
            ctx.save();
            ctx.beginPath();
            this.visuals.line.set_value(ctx);
            ctx.moveTo(sleft, stop);
            if (this.model.dimension == "width") {
                ctx.lineTo(sleft + width, stop);
            }
            else {
                ctx.lineTo(sleft, stop + height);
            }
            ctx.stroke();
            ctx.restore();
        }
    }
    exports.SpanView = SpanView;
    SpanView.__name__ = "SpanView";
    class Span extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_Span() {
            this.prototype.default_view = SpanView;
            this.mixins(mixins.Line /*Scalar*/);
            this.define(({ Number, Nullable }) => ({
                render_mode: [enums_1.RenderMode, "canvas"],
                location: [Nullable(Number), null],
                location_units: [enums_1.SpatialUnits, "data"],
                dimension: [enums_1.Dimension, "width"],
            }));
            this.internal(({ Boolean }) => ({
                for_hover: [Boolean, false],
            }));
            this.override({
                line_color: 'black',
            });
        }
    }
    exports.Span = Span;
    Span.__name__ = "Span";
    Span.init_Span();
},
/* models/annotations/title.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const text_annotation_1 = require(173) /* ./text_annotation */;
    const enums_1 = require(20) /* ../../core/enums */;
    const visuals_1 = require(73) /* ../../core/visuals */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    const p = tslib_1.__importStar(require(18) /* ../../core/properties */);
    class TitleView extends text_annotation_1.TextAnnotationView {
        initialize() {
            super.initialize();
            this.visuals.text = new visuals_1.Text(this.model);
        }
        _get_location() {
            const panel = this.panel;
            const hmargin = this.model.offset;
            const vmargin = 5;
            let sx, sy;
            const { bbox } = panel;
            switch (panel.side) {
                case 'above':
                case 'below': {
                    switch (this.model.vertical_align) {
                        case 'top':
                            sy = bbox.top + vmargin;
                            break;
                        case 'middle':
                            sy = bbox.vcenter;
                            break;
                        case 'bottom':
                            sy = bbox.bottom - vmargin;
                            break;
                    }
                    switch (this.model.align) {
                        case 'left':
                            sx = bbox.left + hmargin;
                            break;
                        case 'center':
                            sx = bbox.hcenter;
                            break;
                        case 'right':
                            sx = bbox.right - hmargin;
                            break;
                    }
                    break;
                }
                case 'left': {
                    switch (this.model.vertical_align) {
                        case 'top':
                            sx = bbox.left - vmargin;
                            break;
                        case 'middle':
                            sx = bbox.hcenter;
                            break;
                        case 'bottom':
                            sx = bbox.right + vmargin;
                            break;
                    }
                    switch (this.model.align) {
                        case 'left':
                            sy = bbox.bottom - hmargin;
                            break;
                        case 'center':
                            sy = bbox.vcenter;
                            break;
                        case 'right':
                            sy = bbox.top + hmargin;
                            break;
                    }
                    break;
                }
                case 'right': {
                    switch (this.model.vertical_align) {
                        case 'top':
                            sx = bbox.right - vmargin;
                            break;
                        case 'middle':
                            sx = bbox.hcenter;
                            break;
                        case 'bottom':
                            sx = bbox.left + vmargin;
                            break;
                    }
                    switch (this.model.align) {
                        case 'left':
                            sy = bbox.top + hmargin;
                            break;
                        case 'center':
                            sy = bbox.vcenter;
                            break;
                        case 'right':
                            sy = bbox.bottom - hmargin;
                            break;
                    }
                    break;
                }
            }
            return [sx, sy];
        }
        _render() {
            const { text } = this.model;
            if (text == null || text.length == 0)
                return;
            this.model.text_baseline = this.model.vertical_align;
            this.model.text_align = this.model.align;
            const [sx, sy] = this._get_location();
            const angle = this.panel.get_label_angle_heuristic('parallel');
            const draw = this.model.render_mode == 'canvas' ? this._canvas_text.bind(this) : this._css_text.bind(this);
            draw(this.layer.ctx, text, sx, sy, angle);
        }
        _get_size() {
            const { text } = this.model;
            if (text == null || text.length == 0)
                return { width: 0, height: 0 };
            else {
                this.visuals.text.set_value(this.layer.ctx);
                const { width, ascent } = this.layer.ctx.measureText(text);
                return { width, height: ascent * this.visuals.text.text_line_height.value() + 10 };
            }
        }
    }
    exports.TitleView = TitleView;
    TitleView.__name__ = "TitleView";
    class Title extends text_annotation_1.TextAnnotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_Title() {
            this.prototype.default_view = TitleView;
            this.mixins([
                ["border_", mixins.Line],
                ["background_", mixins.Fill],
            ]);
            this.define(({ Number, String }) => ({
                text: [String],
                text_font: [p.Font, "helvetica"],
                text_font_size: [p.StringSpec, "13px"],
                text_font_style: [enums_1.FontStyle, "bold"],
                text_color: [p.ColorSpec, "#444444"],
                text_alpha: [p.NumberSpec, 1.0],
                text_line_height: [Number, 1.0],
                vertical_align: [enums_1.VerticalAlign, "bottom"],
                align: [enums_1.TextAlign, "left"],
                offset: [Number, 0],
            }));
            this.internal(() => ({
                text_align: [enums_1.TextAlign, "left"],
                text_baseline: [enums_1.TextBaseline, "bottom"],
            }));
            this.override({
                background_fill_color: null,
                border_line_color: null,
            });
        }
    }
    exports.Title = Title;
    Title.__name__ = "Title";
    Title.init_Title();
},
/* models/annotations/toolbar_panel.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const annotation_1 = require(35) /* ./annotation */;
    const toolbar_1 = require(183) /* ../tools/toolbar */;
    const build_views_1 = require(123) /* ../../core/build_views */;
    const dom_1 = require(71) /* ../../core/dom */;
    const bbox_1 = require(86) /* ../../core/util/bbox */;
    class ToolbarPanelView extends annotation_1.AnnotationView {
        constructor() {
            super(...arguments);
            this.rotate = true;
            this._invalidate_toolbar = true;
            this._previous_bbox = new bbox_1.BBox();
        }
        initialize() {
            super.initialize();
            this.el = dom_1.div();
            this.plot_view.canvas_view.add_event(this.el);
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            this._toolbar_view = await build_views_1.build_view(this.model.toolbar, { parent: this });
            this.plot_view.visibility_callbacks.push((visible) => this._toolbar_view.set_visibility(visible));
        }
        remove() {
            this._toolbar_view.remove();
            dom_1.remove(this.el);
            super.remove();
        }
        render() {
            if (!this.model.visible)
                dom_1.undisplay(this.el);
            super.render();
        }
        _render() {
            // TODO: this should be handled by the layout
            const { bbox } = this.panel;
            if (!this._previous_bbox.equals(bbox)) {
                dom_1.position(this.el, bbox);
                this._previous_bbox = bbox;
            }
            if (this._invalidate_toolbar) {
                this.el.style.position = "absolute";
                this.el.style.overflow = "hidden";
                this._toolbar_view.render();
                dom_1.empty(this.el);
                this.el.appendChild(this._toolbar_view.el);
                this._invalidate_toolbar = false;
            }
            dom_1.display(this.el);
        }
        _get_size() {
            const { tools, logo } = this.model.toolbar;
            return {
                width: tools.length * 30 + (logo != null ? 25 : 0),
                height: 30,
            };
        }
    }
    exports.ToolbarPanelView = ToolbarPanelView;
    ToolbarPanelView.__name__ = "ToolbarPanelView";
    class ToolbarPanel extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_ToolbarPanel() {
            this.prototype.default_view = ToolbarPanelView;
            this.define(({ Ref }) => ({
                toolbar: [Ref(toolbar_1.Toolbar)],
            }));
        }
    }
    exports.ToolbarPanel = ToolbarPanel;
    ToolbarPanel.__name__ = "ToolbarPanel";
    ToolbarPanel.init_ToolbarPanel();
},
/* models/tools/toolbar.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ../../core/util/types */;
    const array_1 = require(9) /* ../../core/util/array */;
    const object_1 = require(13) /* ../../core/util/object */;
    const tool_1 = require(184) /* ./tool */;
    const gesture_tool_1 = require(185) /* ./gestures/gesture_tool */;
    const inspect_tool_1 = require(193) /* ./inspectors/inspect_tool */;
    const toolbar_base_1 = require(194) /* ./toolbar_base */;
    exports.Drag = tool_1.Tool;
    exports.Inspection = tool_1.Tool;
    exports.Scroll = tool_1.Tool;
    exports.Tap = tool_1.Tool;
    const _get_active_attr = (et) => {
        switch (et) {
            case 'tap': return 'active_tap';
            case 'pan': return 'active_drag';
            case 'pinch':
            case 'scroll': return 'active_scroll';
            case 'multi': return 'active_multi';
        }
        return null;
    };
    const _supports_auto = (et) => {
        return et == 'tap' || et == 'pan';
    };
    class Toolbar extends toolbar_base_1.ToolbarBase {
        constructor(attrs) {
            super(attrs);
        }
        static init_Toolbar() {
            this.prototype.default_view = toolbar_base_1.ToolbarBaseView;
            this.define(({ Or, Ref, Auto, Null, Nullable }) => ({
                active_drag: [Or(Ref(exports.Drag), Auto, Null), "auto"],
                active_inspect: [Or(Ref(exports.Inspection), Auto, Null), "auto"],
                active_scroll: [Or(Ref(exports.Scroll), Auto, Null), "auto"],
                active_tap: [Or(Ref(exports.Tap), Auto, Null), "auto"],
                active_multi: [Nullable(Ref(gesture_tool_1.GestureTool)), null],
            }));
        }
        connect_signals() {
            super.connect_signals();
            const { tools, active_drag, active_inspect, active_scroll, active_tap, active_multi } = this.properties;
            this.on_change([tools, active_drag, active_inspect, active_scroll, active_tap, active_multi], () => this._init_tools());
        }
        _init_tools() {
            super._init_tools();
            if (this.active_inspect == 'auto') {
                // do nothing as all tools are active be default
            }
            else if (this.active_inspect instanceof inspect_tool_1.InspectTool) {
                let found = false;
                for (const inspector of this.inspectors) {
                    if (inspector != this.active_inspect)
                        inspector.active = false;
                    else
                        found = true;
                }
                if (!found) {
                    this.active_inspect = null;
                }
            }
            else if (types_1.isArray(this.active_inspect)) {
                const active_inspect = array_1.intersection(this.active_inspect, this.inspectors);
                if (active_inspect.length != this.active_inspect.length) {
                    this.active_inspect = active_inspect;
                }
                for (const inspector of this.inspectors) {
                    if (!array_1.includes(this.active_inspect, inspector))
                        inspector.active = false;
                }
            }
            else if (this.active_inspect == null) {
                for (const inspector of this.inspectors)
                    inspector.active = false;
            }
            const _activate_gesture = (tool) => {
                if (tool.active) {
                    // tool was activated by a proxy, but we need to finish configuration manually
                    this._active_change(tool);
                }
                else
                    tool.active = true;
            };
            // Connecting signals has to be done before changing the active state of the tools.
            for (const gesture of object_1.values(this.gestures)) {
                gesture.tools = array_1.sort_by(gesture.tools, (tool) => tool.default_order);
                for (const tool of gesture.tools) {
                    this.connect(tool.properties.active.change, () => this._active_change(tool));
                }
            }
            for (const [et, gesture] of object_1.entries(this.gestures)) {
                const active_attr = _get_active_attr(et);
                if (active_attr) {
                    const active_tool = this[active_attr];
                    if (active_tool == 'auto') {
                        if (gesture.tools.length != 0 && _supports_auto(et)) {
                            _activate_gesture(gesture.tools[0]);
                        }
                    }
                    else if (active_tool != null) {
                        if (array_1.includes(this.tools, active_tool)) {
                            _activate_gesture(active_tool);
                        }
                        else {
                            this[active_attr] = null;
                        }
                    }
                }
            }
        }
    }
    exports.Toolbar = Toolbar;
    Toolbar.__name__ = "Toolbar";
    Toolbar.init_Toolbar();
},
/* models/tools/tool.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const view_1 = require(70) /* ../../core/view */;
    const array_1 = require(9) /* ../../core/util/array */;
    const model_1 = require(88) /* ../../model */;
    class ToolView extends view_1.View {
        get plot_view() {
            return this.parent;
        }
        get plot_model() {
            return this.parent.model;
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.properties.active.change, () => {
                if (this.model.active)
                    this.activate();
                else
                    this.deactivate();
            });
        }
        // activate is triggered by toolbar ui actions
        activate() { }
        // deactivate is triggered by toolbar ui actions
        deactivate() { }
    }
    exports.ToolView = ToolView;
    ToolView.__name__ = "ToolView";
    class Tool extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        static init_Tool() {
            this.prototype._known_aliases = new Map();
            this.internal(({ Boolean }) => ({
                active: [Boolean, false],
            }));
        }
        get synthetic_renderers() {
            return [];
        }
        // utility function to return a tool name, modified
        // by the active dimensions. Used by tools that have dimensions
        _get_dim_tooltip(name, dims) {
            switch (dims) {
                case "width": return `${name} (x-axis)`;
                case "height": return `${name} (y-axis)`;
                case "both": return name;
            }
        }
        // utility function to get limits along both dimensions, given
        // optional dimensional constraints
        _get_dim_limits([sx0, sy0], [sx1, sy1], frame, dims) {
            const hr = frame.bbox.h_range;
            let sxlim;
            if (dims == 'width' || dims == 'both') {
                sxlim = [array_1.min([sx0, sx1]), array_1.max([sx0, sx1])];
                sxlim = [array_1.max([sxlim[0], hr.start]), array_1.min([sxlim[1], hr.end])];
            }
            else
                sxlim = [hr.start, hr.end];
            const vr = frame.bbox.v_range;
            let sylim;
            if (dims == 'height' || dims == 'both') {
                sylim = [array_1.min([sy0, sy1]), array_1.max([sy0, sy1])];
                sylim = [array_1.max([sylim[0], vr.start]), array_1.min([sylim[1], vr.end])];
            }
            else
                sylim = [vr.start, vr.end];
            return [sxlim, sylim];
        }
        static register_alias(name, fn) {
            this.prototype._known_aliases.set(name, fn);
        }
        static from_string(name) {
            const fn = this.prototype._known_aliases.get(name);
            if (fn != null)
                return fn();
            else {
                const names = [...this.prototype._known_aliases.keys()];
                throw new Error(`unexpected tool name '${name}', possible tools are ${names.join(", ")}`);
            }
        }
    }
    exports.Tool = Tool;
    Tool.__name__ = "Tool";
    Tool.init_Tool();
},
/* models/tools/gestures/gesture_tool.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const button_tool_1 = require(186) /* ../button_tool */;
    const on_off_button_1 = require(191) /* ../on_off_button */;
    class GestureToolView extends button_tool_1.ButtonToolView {
    }
    exports.GestureToolView = GestureToolView;
    GestureToolView.__name__ = "GestureToolView";
    class GestureTool extends button_tool_1.ButtonTool {
        constructor(attrs) {
            super(attrs);
            this.button_view = on_off_button_1.OnOffButtonView;
        }
    }
    exports.GestureTool = GestureTool;
    GestureTool.__name__ = "GestureTool";
},
/* models/tools/button_tool.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const hammerjs_1 = tslib_1.__importDefault(require(79) /* hammerjs */);
    const dom_view_1 = require(77) /* ../../core/dom_view */;
    const tool_1 = require(184) /* ./tool */;
    const dom_1 = require(71) /* ../../core/dom */;
    const string_1 = require(29) /* ../../core/util/string */;
    const types_1 = require(8) /* ../../core/util/types */;
    const array_1 = require(9) /* ../../core/util/array */;
    const toolbar_1 = require(187) /* ../../styles/toolbar */;
    const toolbar_css_1 = tslib_1.__importDefault(require(188) /* ../../styles/toolbar.css */);
    const icons_css_1 = tslib_1.__importDefault(require(189) /* ../../styles/icons.css */);
    const menus_css_1 = tslib_1.__importDefault(require(190) /* ../../styles/menus.css */);
    const menus_1 = require(83) /* ../../core/util/menus */;
    class ButtonToolButtonView extends dom_view_1.DOMView {
        initialize() {
            super.initialize();
            const items = this.model.menu;
            if (items != null) {
                const location = this.parent.model.toolbar_location;
                const reverse = location == "left" || location == "above";
                const orientation = this.parent.model.horizontal ? "vertical" : "horizontal";
                this._menu = new menus_1.ContextMenu(!reverse ? items : array_1.reversed(items), {
                    orientation,
                    prevent_hide: (event) => event.target == this.el,
                });
            }
            this._hammer = new hammerjs_1.default(this.el, {
                touchAction: "auto",
                inputClass: hammerjs_1.default.TouchMouseInput,
            });
            this.connect(this.model.change, () => this.render());
            this._hammer.on("tap", (e) => {
                var _a;
                if ((_a = this._menu) === null || _a === void 0 ? void 0 : _a.is_open) {
                    this._menu.hide();
                    return;
                }
                if (e.target == this.el) {
                    this._clicked();
                }
            });
            this._hammer.on("press", () => this._pressed());
        }
        remove() {
            var _a;
            this._hammer.destroy();
            (_a = this._menu) === null || _a === void 0 ? void 0 : _a.remove();
            super.remove();
        }
        styles() {
            return [...super.styles(), toolbar_css_1.default, icons_css_1.default, menus_css_1.default];
        }
        css_classes() {
            return super.css_classes().concat(toolbar_1.bk_toolbar_button);
        }
        render() {
            dom_1.empty(this.el);
            const icon = this.model.computed_icon;
            if (types_1.isString(icon)) {
                if (string_1.startsWith(icon, "data:image"))
                    this.el.style.backgroundImage = "url('" + icon + "')";
                else
                    this.el.classList.add(icon);
            }
            this.el.title = this.model.tooltip;
            if (this._menu != null) {
                this.root.el.appendChild(this._menu.el);
            }
        }
        _pressed() {
            var _a;
            const { left, top, right, bottom } = this.el.getBoundingClientRect();
            const at = (() => {
                switch (this.parent.model.toolbar_location) {
                    case "right":
                        return { right: left, top };
                    case "left":
                        return { left: right, top };
                    case "above":
                        return { left, top: bottom };
                    case "below":
                        return { left, bottom: top };
                }
            })();
            (_a = this._menu) === null || _a === void 0 ? void 0 : _a.toggle(at);
        }
    }
    exports.ButtonToolButtonView = ButtonToolButtonView;
    ButtonToolButtonView.__name__ = "ButtonToolButtonView";
    class ButtonToolView extends tool_1.ToolView {
    }
    exports.ButtonToolView = ButtonToolView;
    ButtonToolView.__name__ = "ButtonToolView";
    class ButtonTool extends tool_1.Tool {
        constructor(attrs) {
            super(attrs);
        }
        static init_ButtonTool() {
            this.internal(({ Boolean }) => ({
                disabled: [Boolean, false],
            }));
        }
        get tooltip() {
            return this.tool_name;
        }
        get computed_icon() {
            return this.icon;
        }
        get menu() {
            return null;
        }
    }
    exports.ButtonTool = ButtonTool;
    ButtonTool.__name__ = "ButtonTool";
    ButtonTool.init_ButtonTool();
},
/* styles/toolbar.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.bk_toolbar = "bk-toolbar";
    exports.bk_toolbar_hidden = "bk-toolbar-hidden";
    exports.bk_toolbar_button = "bk-toolbar-button";
    exports.bk_button_bar = "bk-button-bar";
    exports.bk_toolbar_button_custom_action = "bk-toolbar-button-custom-action";
},
/* styles/toolbar.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const css = `
.bk-root .bk-toolbar-hidden {
  visibility: hidden;
  opacity: 0;
  transition: visibility 0.3s linear, opacity 0.3s linear;
}
.bk-root .bk-toolbar,
.bk-root .bk-button-bar {
  display: flex;
  display: -webkit-flex;
  flex-wrap: nowrap;
  -webkit-flex-wrap: nowrap;
  align-items: center;
  -webkit-align-items: center;
  user-select: none;
  -ms-user-select: none;
  -moz-user-select: none;
  -webkit-user-select: none;
}
.bk-root .bk-toolbar .bk-logo {
  flex-shrink: 0;
  -webkit-flex-shrink: 0;
}
.bk-root .bk-toolbar.bk-above,
.bk-root .bk-toolbar.bk-below {
  flex-direction: row;
  -webkit-flex-direction: row;
  justify-content: flex-end;
  -webkit-justify-content: flex-end;
}
.bk-root .bk-toolbar.bk-above .bk-button-bar,
.bk-root .bk-toolbar.bk-below .bk-button-bar {
  display: flex;
  display: -webkit-flex;
  flex-direction: row;
  -webkit-flex-direction: row;
}
.bk-root .bk-toolbar.bk-above .bk-logo,
.bk-root .bk-toolbar.bk-below .bk-logo {
  order: 1;
  -webkit-order: 1;
  margin-left: 5px;
  margin-right: 0px;
}
.bk-root .bk-toolbar.bk-left,
.bk-root .bk-toolbar.bk-right {
  flex-direction: column;
  -webkit-flex-direction: column;
  justify-content: flex-start;
  -webkit-justify-content: flex-start;
}
.bk-root .bk-toolbar.bk-left .bk-button-bar,
.bk-root .bk-toolbar.bk-right .bk-button-bar {
  display: flex;
  display: -webkit-flex;
  flex-direction: column;
  -webkit-flex-direction: column;
}
.bk-root .bk-toolbar.bk-left .bk-logo,
.bk-root .bk-toolbar.bk-right .bk-logo {
  order: 0;
  -webkit-order: 0;
  margin-bottom: 5px;
  margin-top: 0px;
}
.bk-root .bk-toolbar-button {
  width: 30px;
  height: 30px;
  cursor: pointer;
  background-size: 60% 60%;
  background-origin: border-box;
  background-color: transparent;
  background-repeat: no-repeat;
  background-position: center center;
}
.bk-root .bk-toolbar-button:hover {
  background-color: rgba(192, 192, 192, 0.15);
}
.bk-root .bk-toolbar-button:focus {
  outline: none;
}
.bk-root .bk-toolbar-button::-moz-focus-inner {
  border: 0;
}
.bk-root .bk-toolbar.bk-above .bk-toolbar-button {
  border-bottom: 2px solid transparent;
}
.bk-root .bk-toolbar.bk-above .bk-toolbar-button.bk-active {
  border-bottom-color: #26aae1;
}
.bk-root .bk-toolbar.bk-below .bk-toolbar-button {
  border-top: 2px solid transparent;
}
.bk-root .bk-toolbar.bk-below .bk-toolbar-button.bk-active {
  border-top-color: #26aae1;
}
.bk-root .bk-toolbar.bk-right .bk-toolbar-button {
  border-left: 2px solid transparent;
}
.bk-root .bk-toolbar.bk-right .bk-toolbar-button.bk-active {
  border-left-color: #26aae1;
}
.bk-root .bk-toolbar.bk-left .bk-toolbar-button {
  border-right: 2px solid transparent;
}
.bk-root .bk-toolbar.bk-left .bk-toolbar-button.bk-active {
  border-right-color: #26aae1;
}
.bk-root .bk-button-bar + .bk-button-bar:before {
  content: " ";
  display: inline-block;
  background-color: lightgray;
}
.bk-root .bk-toolbar.bk-above .bk-button-bar + .bk-button-bar:before,
.bk-root .bk-toolbar.bk-below .bk-button-bar + .bk-button-bar:before {
  height: 10px;
  width: 1px;
}
.bk-root .bk-toolbar.bk-left .bk-button-bar + .bk-button-bar:before,
.bk-root .bk-toolbar.bk-right .bk-button-bar + .bk-button-bar:before {
  height: 1px;
  width: 10px;
}
`;
    exports.default = css;
},
/* styles/icons.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const css = `
.bk-root .bk-tool-icon-copy-to-clipboard {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");
}
.bk-root .bk-tool-icon-replace-mode {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");
}
.bk-root .bk-tool-icon-append-mode {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-intersect-mode {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");
}
.bk-root .bk-tool-icon-subtract-mode {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");
}
.bk-root .bk-tool-icon-clear-selection {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");
}
.bk-root .bk-tool-icon-box-select {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");
}
.bk-root .bk-tool-icon-box-zoom {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");
}
.bk-root .bk-tool-icon-zoom-in {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");
}
.bk-root .bk-tool-icon-zoom-out {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");
}
.bk-root .bk-tool-icon-help {
  background-image: url("data:image/png;base64,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");
}
.bk-root .bk-tool-icon-hover {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");
}
.bk-root .bk-tool-icon-crosshair {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-lasso-select {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-pan {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-xpan {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-ypan {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");
}
.bk-root .bk-tool-icon-range {
  background-image: url("data:image/png;base64,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");
}
.bk-root .bk-tool-icon-polygon-select {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-redo {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");
}
.bk-root .bk-tool-icon-reset {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-save {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");
}
.bk-root .bk-tool-icon-tap-select {
  background-image: url("data:image/png;base64,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");
}
.bk-root .bk-tool-icon-undo {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-wheel-pan {
  background-image: url("data:image/png;base64,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");
}
.bk-root .bk-tool-icon-wheel-zoom {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-box-edit {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-freehand-draw {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");
}
.bk-root .bk-tool-icon-poly-draw {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");
}
.bk-root .bk-tool-icon-point-draw {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");
}
.bk-root .bk-tool-icon-poly-edit {
  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");
}
.bk-root .bk-tool-icon-line-edit {
  background-image: url("data:image/png;base64,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");
}
`;
    exports.default = css;
},
/* styles/menus.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const css = `
.bk-root .bk-menu-icon {
  width: 28px;
  height: 28px;
  background-size: 60%;
  background-color: transparent;
  background-repeat: no-repeat;
  background-position: center center;
}
.bk-root .bk-context-menu {
  position: absolute;
  display: inline-flex;
  display: -webkit-inline-flex;
  flex-wrap: nowrap;
  -webkit-flex-wrap: nowrap;
  user-select: none;
  -ms-user-select: none;
  -moz-user-select: none;
  -webkit-user-select: none;
  width: auto;
  height: auto;
  z-index: 100;
  cursor: pointer;
  font-size: 12px;
  background-color: #fff;
  border: 1px solid #ccc;
  border-radius: 4px;
  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);
}
.bk-root .bk-context-menu.bk-horizontal {
  flex-direction: row;
  -webkit-flex-direction: row;
}
.bk-root .bk-context-menu.bk-vertical {
  flex-direction: column;
  -webkit-flex-direction: column;
}
.bk-root .bk-context-menu > .bk-divider {
  cursor: default;
  overflow: hidden;
  background-color: #e5e5e5;
}
.bk-root .bk-context-menu.bk-horizontal > .bk-divider {
  width: 1px;
  margin: 5px 0;
}
.bk-root .bk-context-menu.bk-vertical > .bk-divider {
  height: 1px;
  margin: 0 5px;
}
.bk-root .bk-context-menu > :not(.bk-divider) {
  border: 1px solid transparent;
}
.bk-root .bk-context-menu > :not(.bk-divider).bk-active {
  border-color: #26aae1;
}
.bk-root .bk-context-menu > :not(.bk-divider):hover {
  background-color: #f9f9f9;
}
.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child {
  border-top-left-radius: 4px;
  border-bottom-left-radius: 4px;
}
.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child {
  border-top-right-radius: 4px;
  border-bottom-right-radius: 4px;
}
.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child {
  border-top-left-radius: 4px;
  border-top-right-radius: 4px;
}
.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child {
  border-bottom-left-radius: 4px;
  border-bottom-right-radius: 4px;
}
.bk-root .bk-menu {
  position: absolute;
  left: 0;
  width: 100%;
  z-index: 100;
  cursor: pointer;
  font-size: 12px;
  background-color: #fff;
  border: 1px solid #ccc;
  border-radius: 4px;
  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);
}
.bk-root .bk-menu.bk-above {
  bottom: 100%;
}
.bk-root .bk-menu.bk-below {
  top: 100%;
}
.bk-root .bk-menu > .bk-divider {
  height: 1px;
  margin: 7.5px 0;
  overflow: hidden;
  background-color: #e5e5e5;
}
.bk-root .bk-menu > :not(.bk-divider) {
  padding: 6px 12px;
}
.bk-root .bk-menu > :not(.bk-divider):hover,
.bk-root .bk-menu > :not(.bk-divider).bk-active {
  background-color: #e6e6e6;
}
.bk-root .bk-caret {
  display: inline-block;
  vertical-align: middle;
  width: 0;
  height: 0;
  margin: 0 5px;
}
.bk-root .bk-caret.bk-down {
  border-top: 4px solid;
}
.bk-root .bk-caret.bk-up {
  border-bottom: 4px solid;
}
.bk-root .bk-caret.bk-down,
.bk-root .bk-caret.bk-up {
  border-right: 4px solid transparent;
  border-left: 4px solid transparent;
}
.bk-root .bk-caret.bk-left {
  border-right: 4px solid;
}
.bk-root .bk-caret.bk-right {
  border-left: 4px solid;
}
.bk-root .bk-caret.bk-left,
.bk-root .bk-caret.bk-right {
  border-top: 4px solid transparent;
  border-bottom: 4px solid transparent;
}
`;
    exports.default = css;
},
/* models/tools/on_off_button.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const button_tool_1 = require(186) /* ./button_tool */;
    const mixins_1 = require(192) /* ../../styles/mixins */;
    const dom_1 = require(71) /* ../../core/dom */;
    class OnOffButtonView extends button_tool_1.ButtonToolButtonView {
        render() {
            super.render();
            dom_1.classes(this.el).toggle(mixins_1.bk_active, this.model.active);
        }
        _clicked() {
            const { active } = this.model;
            this.model.active = !active;
        }
    }
    exports.OnOffButtonView = OnOffButtonView;
    OnOffButtonView.__name__ = "OnOffButtonView";
},
/* styles/mixins.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.bk_active = "bk-active";
    exports.bk_inline = "bk-inline";
    exports.bk_left = "bk-left";
    exports.bk_right = "bk-right";
    exports.bk_above = "bk-above";
    exports.bk_below = "bk-below";
    exports.bk_up = "bk-up";
    exports.bk_down = "bk-down";
    function bk_side(side) {
        switch (side) {
            case "above": return exports.bk_above;
            case "below": return exports.bk_below;
            case "left": return exports.bk_left;
            case "right": return exports.bk_right;
        }
    }
    exports.bk_side = bk_side;
},
/* models/tools/inspectors/inspect_tool.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const button_tool_1 = require(186) /* ../button_tool */;
    const on_off_button_1 = require(191) /* ../on_off_button */;
    class InspectToolView extends button_tool_1.ButtonToolView {
    }
    exports.InspectToolView = InspectToolView;
    InspectToolView.__name__ = "InspectToolView";
    class InspectTool extends button_tool_1.ButtonTool {
        constructor(attrs) {
            super(attrs);
            this.event_type = "move";
        }
        static init_InspectTool() {
            this.prototype.button_view = on_off_button_1.OnOffButtonView;
            this.define(({ Boolean }) => ({
                toggleable: [Boolean, true],
            }));
            this.override({
                active: true,
            });
        }
    }
    exports.InspectTool = InspectTool;
    InspectTool.__name__ = "InspectTool";
    InspectTool.init_InspectTool();
},
/* models/tools/toolbar_base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const logging_1 = require(19) /* ../../core/logging */;
    const dom_1 = require(71) /* ../../core/dom */;
    const build_views_1 = require(123) /* ../../core/build_views */;
    const dom_view_1 = require(77) /* ../../core/dom_view */;
    const enums_1 = require(20) /* ../../core/enums */;
    const array_1 = require(9) /* ../../core/util/array */;
    const object_1 = require(13) /* ../../core/util/object */;
    const types_1 = require(8) /* ../../core/util/types */;
    const model_1 = require(88) /* ../../model */;
    const tool_1 = require(184) /* ./tool */;
    const gesture_tool_1 = require(185) /* ./gestures/gesture_tool */;
    const action_tool_1 = require(195) /* ./actions/action_tool */;
    const help_tool_1 = require(196) /* ./actions/help_tool */;
    const inspect_tool_1 = require(193) /* ./inspectors/inspect_tool */;
    const toolbar_1 = require(187) /* ../../styles/toolbar */;
    const logo_1 = require(198) /* ../../styles/logo */;
    const mixins_1 = require(192) /* ../../styles/mixins */;
    const toolbar_css_1 = tslib_1.__importDefault(require(188) /* ../../styles/toolbar.css */);
    const logo_css_1 = tslib_1.__importDefault(require(199) /* ../../styles/logo.css */);
    class ToolbarViewModel extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        static init_ToolbarViewModel() {
            this.define(({ Boolean, Nullable }) => ({
                _visible: [Nullable(Boolean), null],
                autohide: [Boolean, false],
            }));
        }
        get visible() {
            return (!this.autohide) ? true : (this._visible == null) ? false : this._visible;
        }
    }
    exports.ToolbarViewModel = ToolbarViewModel;
    ToolbarViewModel.__name__ = "ToolbarViewModel";
    ToolbarViewModel.init_ToolbarViewModel();
    class ToolbarBaseView extends dom_view_1.DOMView {
        initialize() {
            super.initialize();
            this._tool_button_views = new Map();
            this._toolbar_view_model = new ToolbarViewModel({ autohide: this.model.autohide });
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await this._build_tool_button_views();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.properties.tools.change, async () => {
                await this._build_tool_button_views();
                this.render();
            });
            this.connect(this.model.properties.autohide.change, () => {
                this._toolbar_view_model.autohide = this.model.autohide;
                this._on_visible_change();
            });
            this.connect(this._toolbar_view_model.properties._visible.change, () => this._on_visible_change());
        }
        styles() {
            return [...super.styles(), toolbar_css_1.default, logo_css_1.default];
        }
        remove() {
            build_views_1.remove_views(this._tool_button_views);
            super.remove();
        }
        async _build_tool_button_views() {
            const tools = (this.model._proxied_tools != null ? this.model._proxied_tools : this.model.tools); // XXX
            await build_views_1.build_views(this._tool_button_views, tools, { parent: this }, (tool) => tool.button_view); // XXX: no ButtonToolButton model
        }
        set_visibility(visible) {
            if (visible != this._toolbar_view_model._visible) {
                this._toolbar_view_model._visible = visible;
            }
        }
        _on_visible_change() {
            const visible = this._toolbar_view_model.visible;
            const hidden_class = toolbar_1.bk_toolbar_hidden;
            if (this.el.classList.contains(hidden_class) && visible) {
                this.el.classList.remove(hidden_class);
            }
            else if (!visible) {
                this.el.classList.add(hidden_class);
            }
        }
        render() {
            dom_1.empty(this.el);
            this.el.classList.add(toolbar_1.bk_toolbar);
            this.el.classList.add(mixins_1.bk_side(this.model.toolbar_location));
            this._toolbar_view_model.autohide = this.model.autohide;
            this._on_visible_change();
            if (this.model.logo != null) {
                const gray = this.model.logo === "grey" ? logo_1.bk_grey : null;
                const logo = dom_1.a({ href: "https://bokeh.org/", target: "_blank", class: [logo_1.bk_logo, logo_1.bk_logo_small, gray] });
                this.el.appendChild(logo);
            }
            for (const [, button_view] of this._tool_button_views) {
                button_view.render();
            }
            const bars = [];
            const el = (tool) => {
                return this._tool_button_views.get(tool).el;
            };
            const { gestures } = this.model;
            for (const gesture of object_1.values(gestures)) {
                bars.push(gesture.tools.map(el));
            }
            bars.push(this.model.actions.map(el));
            bars.push(this.model.inspectors.filter((tool) => tool.toggleable).map(el));
            for (const bar of bars) {
                if (bar.length !== 0) {
                    const el = dom_1.div({ class: toolbar_1.bk_button_bar }, bar);
                    this.el.appendChild(el);
                }
            }
        }
        update_layout() { }
        update_position() { }
        after_layout() {
            this._has_finished = true;
        }
    }
    exports.ToolbarBaseView = ToolbarBaseView;
    ToolbarBaseView.__name__ = "ToolbarBaseView";
    function create_gesture_map() {
        return {
            pan: { tools: [], active: null },
            scroll: { tools: [], active: null },
            pinch: { tools: [], active: null },
            tap: { tools: [], active: null },
            doubletap: { tools: [], active: null },
            press: { tools: [], active: null },
            pressup: { tools: [], active: null },
            rotate: { tools: [], active: null },
            move: { tools: [], active: null },
            multi: { tools: [], active: null },
        };
    }
    class ToolbarBase extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        static init_ToolbarBase() {
            this.prototype.default_view = ToolbarBaseView;
            this.define(({ Boolean, Array, Ref }) => ({
                tools: [Array(Ref(tool_1.Tool)), []],
                logo: [enums_1.Logo, "normal"],
                autohide: [Boolean, false],
            }));
            this.internal(({ Array, Struct, Ref, Nullable }) => {
                const GestureEntry = Struct({
                    tools: Array(Ref(gesture_tool_1.GestureTool)),
                    active: Nullable(Ref(tool_1.Tool)),
                });
                const GestureMap = Struct({
                    pan: GestureEntry,
                    scroll: GestureEntry,
                    pinch: GestureEntry,
                    tap: GestureEntry,
                    doubletap: GestureEntry,
                    press: GestureEntry,
                    pressup: GestureEntry,
                    rotate: GestureEntry,
                    move: GestureEntry,
                    multi: GestureEntry,
                });
                return {
                    gestures: [GestureMap, create_gesture_map],
                    actions: [Array(Ref(action_tool_1.ActionTool)), []],
                    inspectors: [Array(Ref(inspect_tool_1.InspectTool)), []],
                    help: [Array(Ref(help_tool_1.HelpTool)), []],
                    toolbar_location: [enums_1.Location, "right"],
                };
            });
        }
        initialize() {
            super.initialize();
            this._init_tools();
        }
        _init_tools() {
            // The only purpose of this function is to avoid unnecessary property churning.
            const tools_changed = function (old_tools, new_tools) {
                if (old_tools.length != new_tools.length) {
                    return true;
                }
                const new_ids = new Set(new_tools.map(t => t.id));
                return array_1.some(old_tools, t => !new_ids.has(t.id));
            };
            const new_inspectors = this.tools.filter(t => t instanceof inspect_tool_1.InspectTool);
            if (tools_changed(this.inspectors, new_inspectors)) {
                this.inspectors = new_inspectors;
            }
            const new_help = this.tools.filter(t => t instanceof help_tool_1.HelpTool);
            if (tools_changed(this.help, new_help)) {
                this.help = new_help;
            }
            const new_actions = this.tools.filter(t => t instanceof action_tool_1.ActionTool);
            if (tools_changed(this.actions, new_actions)) {
                this.actions = new_actions;
            }
            const check_event_type = (et, tool) => {
                if (!(et in this.gestures)) {
                    logging_1.logger.warn(`Toolbar: unknown event type '${et}' for tool: ${tool}`);
                }
            };
            const new_gestures = create_gesture_map();
            for (const tool of this.tools) {
                if (tool instanceof gesture_tool_1.GestureTool && tool.event_type) {
                    if (types_1.isString(tool.event_type)) {
                        new_gestures[tool.event_type].tools.push(tool);
                        check_event_type(tool.event_type, tool);
                    }
                    else {
                        new_gestures.multi.tools.push(tool);
                        for (const et of tool.event_type) {
                            check_event_type(et, tool);
                        }
                    }
                }
            }
            for (const et of Object.keys(new_gestures)) {
                const gm = this.gestures[et];
                if (tools_changed(gm.tools, new_gestures[et].tools)) {
                    gm.tools = new_gestures[et].tools;
                }
                if (gm.active && array_1.every(gm.tools, t => t.id != gm.active.id)) {
                    gm.active = null;
                }
            }
        }
        get horizontal() {
            return this.toolbar_location === "above" || this.toolbar_location === "below";
        }
        get vertical() {
            return this.toolbar_location === "left" || this.toolbar_location === "right";
        }
        _active_change(tool) {
            const { event_type } = tool;
            if (event_type == null)
                return;
            const event_types = types_1.isString(event_type) ? [event_type] : event_type;
            for (const et of event_types) {
                if (tool.active) {
                    const currently_active_tool = this.gestures[et].active;
                    if (currently_active_tool != null && tool != currently_active_tool) {
                        logging_1.logger.debug(`Toolbar: deactivating tool: ${currently_active_tool} for event type '${et}'`);
                        currently_active_tool.active = false;
                    }
                    this.gestures[et].active = tool;
                    logging_1.logger.debug(`Toolbar: activating tool: ${tool} for event type '${et}'`);
                }
                else
                    this.gestures[et].active = null;
            }
        }
    }
    exports.ToolbarBase = ToolbarBase;
    ToolbarBase.__name__ = "ToolbarBase";
    ToolbarBase.init_ToolbarBase();
},
/* models/tools/actions/action_tool.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const button_tool_1 = require(186) /* ../button_tool */;
    const signaling_1 = require(15) /* ../../../core/signaling */;
    class ActionToolButtonView extends button_tool_1.ButtonToolButtonView {
        _clicked() {
            this.model.do.emit(undefined);
        }
    }
    exports.ActionToolButtonView = ActionToolButtonView;
    ActionToolButtonView.__name__ = "ActionToolButtonView";
    class ActionToolView extends button_tool_1.ButtonToolView {
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.do, (arg) => this.doit(arg));
        }
    }
    exports.ActionToolView = ActionToolView;
    ActionToolView.__name__ = "ActionToolView";
    class ActionTool extends button_tool_1.ButtonTool {
        constructor(attrs) {
            super(attrs);
            this.button_view = ActionToolButtonView;
            this.do = new signaling_1.Signal(this, "do");
        }
    }
    exports.ActionTool = ActionTool;
    ActionTool.__name__ = "ActionTool";
},
/* models/tools/actions/help_tool.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const action_tool_1 = require(195) /* ./action_tool */;
    const icons_1 = require(197) /* ../../../styles/icons */;
    class HelpToolView extends action_tool_1.ActionToolView {
        doit() {
            window.open(this.model.redirect);
        }
    }
    exports.HelpToolView = HelpToolView;
    HelpToolView.__name__ = "HelpToolView";
    class HelpTool extends action_tool_1.ActionTool {
        constructor(attrs) {
            super(attrs);
            this.tool_name = "Help";
            this.icon = icons_1.bk_tool_icon_help;
        }
        static init_HelpTool() {
            this.prototype.default_view = HelpToolView;
            this.define(({ String }) => ({
                help_tooltip: [String, 'Click the question mark to learn more about Bokeh plot tools.'],
                redirect: [String, 'https://docs.bokeh.org/en/latest/docs/user_guide/tools.html'],
            }));
            this.register_alias("help", () => new HelpTool());
        }
        get tooltip() {
            return this.help_tooltip;
        }
    }
    exports.HelpTool = HelpTool;
    HelpTool.__name__ = "HelpTool";
    HelpTool.init_HelpTool();
},
/* styles/icons.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.bk_tool_icon_box_select = "bk-tool-icon-box-select";
    exports.bk_tool_icon_box_zoom = "bk-tool-icon-box-zoom";
    exports.bk_tool_icon_zoom_in = "bk-tool-icon-zoom-in";
    exports.bk_tool_icon_zoom_out = "bk-tool-icon-zoom-out";
    exports.bk_tool_icon_help = "bk-tool-icon-help";
    exports.bk_tool_icon_hover = "bk-tool-icon-hover";
    exports.bk_tool_icon_crosshair = "bk-tool-icon-crosshair";
    exports.bk_tool_icon_lasso_select = "bk-tool-icon-lasso-select";
    exports.bk_tool_icon_pan = "bk-tool-icon-pan";
    exports.bk_tool_icon_xpan = "bk-tool-icon-xpan";
    exports.bk_tool_icon_ypan = "bk-tool-icon-ypan";
    exports.bk_tool_icon_range = "bk-tool-icon-range";
    exports.bk_tool_icon_polygon_select = "bk-tool-icon-polygon-select";
    exports.bk_tool_icon_redo = "bk-tool-icon-redo";
    exports.bk_tool_icon_reset = "bk-tool-icon-reset";
    exports.bk_tool_icon_save = "bk-tool-icon-save";
    exports.bk_tool_icon_tap_select = "bk-tool-icon-tap-select";
    exports.bk_tool_icon_undo = "bk-tool-icon-undo";
    exports.bk_tool_icon_wheel_pan = "bk-tool-icon-wheel-pan";
    exports.bk_tool_icon_wheel_zoom = "bk-tool-icon-wheel-zoom";
    exports.bk_tool_icon_box_edit = "bk-tool-icon-box-edit";
    exports.bk_tool_icon_freehand_draw = "bk-tool-icon-freehand-draw";
    exports.bk_tool_icon_poly_draw = "bk-tool-icon-poly-draw";
    exports.bk_tool_icon_point_draw = "bk-tool-icon-point-draw";
    exports.bk_tool_icon_poly_edit = "bk-tool-icon-poly-edit";
    exports.bk_tool_icon_line_edit = "bk-tool-icon-line-edit";
},
/* styles/logo.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.bk_logo = "bk-logo";
    exports.bk_logo_notebook = "bk-logo-notebook";
    exports.bk_logo_small = "bk-logo-small";
    exports.bk_grey = "bk-grey";
},
/* styles/logo.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const css = `
.bk-root .bk-logo {
  margin: 5px;
  position: relative;
  display: block;
  background-repeat: no-repeat;
}
.bk-root .bk-logo.bk-grey {
  filter: url("data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale");
  /* Firefox 10+, Firefox on Android */
  filter: gray;
  /* IE6-9 */
  -webkit-filter: grayscale(100%);
  /* Chrome 19+, Safari 6+, Safari 6+ iOS */
}
.bk-root .bk-logo-small {
  width: 20px;
  height: 20px;
  background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);
}
.bk-root .bk-logo-notebook {
  display: inline-block;
  vertical-align: middle;
  margin-right: 5px;
}
`;
    exports.default = css;
},
/* models/annotations/tooltip.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(35) /* ./annotation */;
    const enums_1 = require(20) /* ../../core/enums */;
    const dom_1 = require(71) /* ../../core/dom */;
    const tooltips_1 = require(201) /* ../../styles/tooltips */;
    const mixins_1 = require(192) /* ../../styles/mixins */;
    const tooltips_css_1 = tslib_1.__importDefault(require(202) /* ../../styles/tooltips.css */);
    const arrow_size = 10; // XXX: keep in sync with less
    class TooltipView extends annotation_1.AnnotationView {
        initialize() {
            super.initialize();
            this.el = dom_1.div({ class: tooltips_1.bk_tooltip });
            dom_1.undisplay(this.el);
            this.plot_view.canvas_view.add_overlay(this.el);
        }
        remove() {
            dom_1.remove(this.el);
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.properties.content.change, () => this.render());
            this.connect(this.model.properties.position.change, () => this._reposition());
        }
        styles() {
            return [...super.styles(), tooltips_css_1.default];
        }
        render() {
            if (!this.model.visible)
                dom_1.undisplay(this.el);
            super.render();
        }
        _render() {
            const { content } = this.model;
            if (content == null) {
                dom_1.undisplay(this.el);
                return;
            }
            dom_1.empty(this.el);
            dom_1.classes(this.el).toggle(tooltips_1.bk_tooltip_custom, this.model.custom);
            this.el.appendChild(content);
            if (this.model.show_arrow)
                this.el.classList.add(tooltips_1.bk_tooltip_arrow);
        }
        _reposition() {
            const { position } = this.model;
            if (position == null) {
                dom_1.undisplay(this.el);
                return;
            }
            const [sx, sy] = position;
            const side = (() => {
                const area = this.parent.layout.bbox.relative();
                const { attachment } = this.model;
                switch (attachment) {
                    case "horizontal":
                        return sx < area.hcenter ? "right" : "left";
                    case "vertical":
                        return sy < area.vcenter ? "below" : "above";
                    default:
                        return attachment;
                }
            })();
            this.el.classList.remove(mixins_1.bk_right);
            this.el.classList.remove(mixins_1.bk_left);
            this.el.classList.remove(mixins_1.bk_above);
            this.el.classList.remove(mixins_1.bk_below);
            dom_1.display(this.el); // XXX: {offset,client}Width() gives 0 when display="none"
            // slightly confusing: side "left" (for example) is relative to point that
            // is being annotated but CS class ".bk-left" is relative to the tooltip itself
            let top;
            let left = null;
            let right = null;
            switch (side) {
                case "right":
                    this.el.classList.add(mixins_1.bk_left);
                    left = sx + (this.el.offsetWidth - this.el.clientWidth) + arrow_size;
                    top = sy - this.el.offsetHeight / 2;
                    break;
                case "left":
                    this.el.classList.add(mixins_1.bk_right);
                    right = (this.plot_view.layout.bbox.width - sx) + arrow_size;
                    top = sy - this.el.offsetHeight / 2;
                    break;
                case "below":
                    this.el.classList.add(mixins_1.bk_above);
                    top = sy + (this.el.offsetHeight - this.el.clientHeight) + arrow_size;
                    left = Math.round(sx - this.el.offsetWidth / 2);
                    break;
                case "above":
                    this.el.classList.add(mixins_1.bk_below);
                    top = sy - this.el.offsetHeight - arrow_size;
                    left = Math.round(sx - this.el.offsetWidth / 2);
                    break;
            }
            this.el.style.top = `${top}px`;
            this.el.style.left = left != null ? `${left}px` : "auto";
            this.el.style.right = right != null ? `${right}px` : "auto";
        }
    }
    exports.TooltipView = TooltipView;
    TooltipView.__name__ = "TooltipView";
    class Tooltip extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        static init_Tooltip() {
            this.prototype.default_view = TooltipView;
            this.define(({ Boolean }) => ({
                attachment: [enums_1.TooltipAttachment, "horizontal"],
                inner_only: [Boolean, true],
                show_arrow: [Boolean, true],
            }));
            this.internal(({ Boolean, Number, Tuple, Ref, Nullable }) => ({
                position: [Nullable(Tuple(Number, Number)), null],
                content: [Ref(HTMLElement), () => dom_1.div()],
                custom: [Boolean],
            }));
            this.override({
                level: 'overlay',
            });
        }
        clear() {
            this.position = null;
        }
    }
    exports.Tooltip = Tooltip;
    Tooltip.__name__ = "Tooltip";
    Tooltip.init_Tooltip();
},
/* styles/tooltips.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.bk_tooltip = "bk-tooltip";
    exports.bk_tooltip_arrow = "bk-tooltip-arrow";
    exports.bk_tooltip_custom = "bk-tooltip-custom";
    exports.bk_tooltip_row_label = "bk-tooltip-row-label";
    exports.bk_tooltip_row_value = "bk-tooltip-row-value";
    exports.bk_tooltip_color_block = "bk-tooltip-color-block";
},
/* styles/tooltips.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const css = `
.bk-root {
  /* Same border color used everywhere */
  /* Gray of icons */
}
.bk-root .bk-tooltip {
  font-weight: 300;
  font-size: 12px;
  position: absolute;
  padding: 5px;
  border: 1px solid #e5e5e5;
  color: #2f2f2f;
  background-color: white;
  pointer-events: none;
  opacity: 0.95;
  z-index: 100;
}
.bk-root .bk-tooltip > div:not(:first-child) {
  /* gives space when multiple elements are being hovered over */
  margin-top: 5px;
  border-top: #e5e5e5 1px dashed;
}
.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before {
  position: absolute;
  margin: -7px 0 0 0;
  top: 50%;
  width: 0;
  height: 0;
  border-style: solid;
  border-width: 7px 0 7px 0;
  border-color: transparent;
  content: " ";
  display: block;
  left: -10px;
  border-right-width: 10px;
  border-right-color: #909599;
}
.bk-root .bk-tooltip.bk-left::before {
  left: -10px;
  border-right-width: 10px;
  border-right-color: #909599;
}
.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after {
  position: absolute;
  margin: -7px 0 0 0;
  top: 50%;
  width: 0;
  height: 0;
  border-style: solid;
  border-width: 7px 0 7px 0;
  border-color: transparent;
  content: " ";
  display: block;
  right: -10px;
  border-left-width: 10px;
  border-left-color: #909599;
}
.bk-root .bk-tooltip.bk-right::after {
  right: -10px;
  border-left-width: 10px;
  border-left-color: #909599;
}
.bk-root .bk-tooltip.bk-above::before {
  position: absolute;
  margin: 0 0 0 -7px;
  left: 50%;
  width: 0;
  height: 0;
  border-style: solid;
  border-width: 0 7px 0 7px;
  border-color: transparent;
  content: " ";
  display: block;
  top: -10px;
  border-bottom-width: 10px;
  border-bottom-color: #909599;
}
.bk-root .bk-tooltip.bk-below::after {
  position: absolute;
  margin: 0 0 0 -7px;
  left: 50%;
  width: 0;
  height: 0;
  border-style: solid;
  border-width: 0 7px 0 7px;
  border-color: transparent;
  content: " ";
  display: block;
  bottom: -10px;
  border-top-width: 10px;
  border-top-color: #909599;
}
.bk-root .bk-tooltip-row-label {
  text-align: right;
  color: #26aae1;
  /* blue from toolbar highlighting */
}
.bk-root .bk-tooltip-row-value {
  color: default;
  /* seems to be necessary for notebook */
}
.bk-root .bk-tooltip-color-block {
  width: 12px;
  height: 12px;
  margin-left: 5px;
  margin-right: 5px;
  outline: #dddddd solid 1px;
  display: inline-block;
}
`;
    exports.default = css;
},
/* models/annotations/whisker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const upper_lower_1 = require(135) /* ./upper_lower */;
    const arrow_head_1 = require(91) /* ./arrow_head */;
    const build_views_1 = require(123) /* ../../core/build_views */;
    const property_mixins_1 = require(28) /* ../../core/property_mixins */;
    class WhiskerView extends upper_lower_1.UpperLowerView {
        async lazy_initialize() {
            await super.lazy_initialize();
            const { lower_head, upper_head } = this.model;
            const { parent } = this;
            if (lower_head != null)
                this.lower_head = await build_views_1.build_view(lower_head, { parent });
            if (upper_head != null)
                this.upper_head = await build_views_1.build_view(upper_head, { parent });
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.source.streaming, () => this.set_data(this.model.source));
            this.connect(this.model.source.patching, () => this.set_data(this.model.source));
            this.connect(this.model.source.change, () => this.set_data(this.model.source));
        }
        _render() {
            this._map_data();
            const { ctx } = this.layer;
            if (this.visuals.line.doit) {
                for (let i = 0, end = this._lower_sx.length; i < end; i++) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.beginPath();
                    ctx.moveTo(this._lower_sx[i], this._lower_sy[i]);
                    ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
                    ctx.stroke();
                }
            }
            const angle = this.model.dimension == "height" ? 0 : Math.PI / 2;
            if (this.lower_head != null) {
                for (let i = 0, end = this._lower_sx.length; i < end; i++) {
                    ctx.save();
                    ctx.translate(this._lower_sx[i], this._lower_sy[i]);
                    ctx.rotate(angle + Math.PI);
                    this.lower_head.render(ctx, i);
                    ctx.restore();
                }
            }
            if (this.upper_head != null) {
                for (let i = 0, end = this._upper_sx.length; i < end; i++) {
                    ctx.save();
                    ctx.translate(this._upper_sx[i], this._upper_sy[i]);
                    ctx.rotate(angle);
                    this.upper_head.render(ctx, i);
                    ctx.restore();
                }
            }
        }
    }
    exports.WhiskerView = WhiskerView;
    WhiskerView.__name__ = "WhiskerView";
    class Whisker extends upper_lower_1.UpperLower {
        constructor(attrs) {
            super(attrs);
        }
        static init_Whisker() {
            this.prototype.default_view = WhiskerView;
            this.mixins(property_mixins_1.LineVector);
            this.define(({ Ref, Nullable }) => ({
                lower_head: [Nullable(Ref(arrow_head_1.ArrowHead)), () => new arrow_head_1.TeeHead({ size: 10 })],
                upper_head: [Nullable(Ref(arrow_head_1.ArrowHead)), () => new arrow_head_1.TeeHead({ size: 10 })],
            }));
            this.override({
                level: "underlay",
            });
        }
    }
    exports.Whisker = Whisker;
    Whisker.__name__ = "Whisker";
    Whisker.init_Whisker();
},
/* models/axes/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var axis_1 = require(205) /* ./axis */;
    __esExport("Axis", axis_1.Axis);
    var categorical_axis_1 = require(207) /* ./categorical_axis */;
    __esExport("CategoricalAxis", categorical_axis_1.CategoricalAxis);
    var continuous_axis_1 = require(210) /* ./continuous_axis */;
    __esExport("ContinuousAxis", continuous_axis_1.ContinuousAxis);
    var datetime_axis_1 = require(211) /* ./datetime_axis */;
    __esExport("DatetimeAxis", datetime_axis_1.DatetimeAxis);
    var linear_axis_1 = require(212) /* ./linear_axis */;
    __esExport("LinearAxis", linear_axis_1.LinearAxis);
    var log_axis_1 = require(225) /* ./log_axis */;
    __esExport("LogAxis", log_axis_1.LogAxis);
    var mercator_axis_1 = require(228) /* ./mercator_axis */;
    __esExport("MercatorAxis", mercator_axis_1.MercatorAxis);
},
/* models/axes/axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const guide_renderer_1 = require(206) /* ../renderers/guide_renderer */;
    const ticker_1 = require(139) /* ../tickers/ticker */;
    const tick_formatter_1 = require(140) /* ../formatters/tick_formatter */;
    const mixins = tslib_1.__importStar(require(28) /* ../../core/property_mixins */);
    const enums_1 = require(20) /* ../../core/enums */;
    const array_1 = require(9) /* ../../core/util/array */;
    const types_1 = require(8) /* ../../core/util/types */;
    const factor_range_1 = require(100) /* ../ranges/factor_range */;
    const { abs, min, max } = Math;
    class AxisView extends guide_renderer_1.GuideRendererView {
        constructor() {
            super(...arguments);
            this.rotate = true;
        }
        get panel() {
            return this.layout;
        }
        get is_renderable() {
            const [range, cross_range] = this.ranges;
            return range.is_valid && cross_range.is_valid;
        }
        _render() {
            var _a;
            if (!this.is_renderable)
                return;
            const extents = {
                tick: this._tick_extent(),
                tick_label: this._tick_label_extents(),
                axis_label: this._axis_label_extent(),
            };
            const { tick_coords } = this;
            const ctx = this.layer.ctx;
            ctx.save();
            this._draw_rule(ctx, extents);
            this._draw_major_ticks(ctx, extents, tick_coords);
            this._draw_minor_ticks(ctx, extents, tick_coords);
            this._draw_major_labels(ctx, extents, tick_coords);
            this._draw_axis_label(ctx, extents, tick_coords);
            (_a = this._paint) === null || _a === void 0 ? void 0 : _a.call(this, ctx, extents, tick_coords);
            ctx.restore();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.plot_view.request_layout());
        }
        get_size() {
            if (this.model.visible && this.model.fixed_location == null && this.is_renderable) {
                const size = this._get_size();
                return { width: 0 /* max */, height: Math.round(size) };
            }
            else
                return { width: 0, height: 0 };
        }
        _get_size() {
            return this._tick_extent() + this._tick_label_extent() + this._axis_label_extent();
        }
        get needs_clip() {
            return this.model.fixed_location != null;
        }
        // drawing sub functions -----------------------------------------------------
        _draw_rule(ctx, _extents) {
            if (!this.visuals.axis_line.doit)
                return;
            const [xs, ys] = this.rule_coords;
            const [sxs, sys] = this.coordinates.map_to_screen(xs, ys);
            const [nx, ny] = this.normals;
            const [xoff, yoff] = this.offsets;
            this.visuals.axis_line.set_value(ctx);
            ctx.beginPath();
            ctx.moveTo(Math.round(sxs[0] + nx * xoff), Math.round(sys[0] + ny * yoff));
            for (let i = 1; i < sxs.length; i++) {
                const sx = Math.round(sxs[i] + nx * xoff);
                const sy = Math.round(sys[i] + ny * yoff);
                ctx.lineTo(sx, sy);
            }
            ctx.stroke();
        }
        _draw_major_ticks(ctx, _extents, tick_coords) {
            const tin = this.model.major_tick_in;
            const tout = this.model.major_tick_out;
            const visuals = this.visuals.major_tick_line;
            this._draw_ticks(ctx, tick_coords.major, tin, tout, visuals);
        }
        _draw_minor_ticks(ctx, _extents, tick_coords) {
            const tin = this.model.minor_tick_in;
            const tout = this.model.minor_tick_out;
            const visuals = this.visuals.minor_tick_line;
            this._draw_ticks(ctx, tick_coords.minor, tin, tout, visuals);
        }
        _draw_major_labels(ctx, extents, tick_coords) {
            const coords = tick_coords.major;
            const labels = this.compute_labels(coords[this.dimension]);
            const orient = this.model.major_label_orientation;
            const standoff = extents.tick + this.model.major_label_standoff;
            const visuals = this.visuals.major_label_text;
            this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
        }
        _draw_axis_label(ctx, extents, _tick_coords) {
            if (this.model.axis_label == null || this.model.axis_label.length == 0 || this.model.fixed_location != null)
                return;
            let sx;
            let sy;
            const { bbox } = this.panel;
            switch (this.panel.side) {
                case "above":
                    sx = bbox.hcenter;
                    sy = bbox.bottom;
                    break;
                case "below":
                    sx = bbox.hcenter;
                    sy = bbox.top;
                    break;
                case "left":
                    sx = bbox.right;
                    sy = bbox.vcenter;
                    break;
                case "right":
                    sx = bbox.left;
                    sy = bbox.vcenter;
                    break;
                default:
                    throw new Error(`unknown side: ${this.panel.side}`);
            }
            const coords = [[sx], [sy]];
            const standoff = extents.tick + array_1.sum(extents.tick_label) + this.model.axis_label_standoff;
            const visuals = this.visuals.axis_label_text;
            this._draw_oriented_labels(ctx, [this.model.axis_label], coords, 'parallel', this.panel.side, standoff, visuals, "screen");
        }
        _draw_ticks(ctx, coords, tin, tout, visuals) {
            if (!visuals.doit)
                return;
            const [x, y] = coords;
            const [sxs, sys] = this.coordinates.map_to_screen(x, y);
            const [nx, ny] = this.normals;
            const [xoff, yoff] = this.offsets;
            const [nxin, nyin] = [nx * (xoff - tin), ny * (yoff - tin)];
            const [nxout, nyout] = [nx * (xoff + tout), ny * (yoff + tout)];
            visuals.set_value(ctx);
            ctx.beginPath();
            for (let i = 0; i < sxs.length; i++) {
                const sx0 = Math.round(sxs[i] + nxout);
                const sy0 = Math.round(sys[i] + nyout);
                const sx1 = Math.round(sxs[i] + nxin);
                const sy1 = Math.round(sys[i] + nyin);
                ctx.moveTo(sx0, sy0);
                ctx.lineTo(sx1, sy1);
            }
            ctx.stroke();
        }
        _draw_oriented_labels(ctx, labels, coords, orient, _side, standoff, visuals, units = "data") {
            if (!visuals.doit || labels.length == 0)
                return;
            let sxs, sys;
            let xoff, yoff;
            if (units == "screen") {
                [sxs, sys] = coords;
                [xoff, yoff] = [0, 0];
            }
            else {
                const [dxs, dys] = coords;
                [sxs, sys] = this.coordinates.map_to_screen(dxs, dys);
                [xoff, yoff] = this.offsets;
            }
            const [nx, ny] = this.normals;
            const nxd = nx * (xoff + standoff);
            const nyd = ny * (yoff + standoff);
            visuals.set_value(ctx);
            this.panel.apply_label_text_heuristics(ctx, orient);
            let angle;
            if (types_1.isString(orient))
                angle = this.panel.get_label_angle_heuristic(orient);
            else
                angle = -orient;
            for (let i = 0; i < sxs.length; i++) {
                const sx = Math.round(sxs[i] + nxd);
                const sy = Math.round(sys[i] + nyd);
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.fillText(labels[i], 0, 0);
                ctx.rotate(-angle);
                ctx.translate(-sx, -sy);
            }
        }
        // extents sub functions -----------------------------------------------------
        /*protected*/ _axis_label_extent() {
          