/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
    if (aliases === undefined) aliases = {};
    if (externals === undefined) externals = {};

    var cache = {};

    var normalize = function(name) {
      if (typeof name === "number")
        return name;

      if (name === "bokehjs")
        return entry;

      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)

      var alias = aliases[name]
      if (alias != null)
        return alias;

      var trailing = name.length > 0 && name[name.lenght-1] === "/";
      var index = aliases[name + (trailing ? "" : "/") + "index"];
      if (index != null)
        return index;

      return name;
    }

    var require = function(name) {
      var mod = cache[name];
      if (!mod) {
        var id = normalize(name);

        mod = cache[id];
        if (!mod) {
          if (!modules[id]) {
            if (externals[id] === false || (externals[id] == true && parent_require)) {
              try {
                mod = {exports: externals[id] ? parent_require(id) : {}};
                cache[id] = cache[name] = mod;
                return mod.exports;
              } catch (e) {}
            }

            var err = new Error("Cannot find module '" + name + "'");
            err.code = 'MODULE_NOT_FOUND';
            throw err;
          }

          mod = {exports: {}};
          cache[id] = cache[name] = mod;

          function __esModule() {
            Object.defineProperty(mod.exports, "__esModule", {value: true});
          }

          function __esExport(name, value) {
            Object.defineProperty(mod.exports, name, {
              enumerable: true, get: function () { return value; }
            });
          }

          modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
        } else {
          cache[name] = mod;
        }
      }

      return mod.exports;
    }
    require.resolve = function(name) {
      return ""
    }

    var main = require(entry);
    main.require = require;

    if (typeof Proxy !== "undefined") {
      // allow Bokeh.loader["@bokehjs/module/name"] syntax
      main.loader = new Proxy({}, {
        get: function(_obj, module) {
          return require(module);
        }
      });
    }

    main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
      if (plugin_aliases === undefined) plugin_aliases = {};
      if (plugin_externals === undefined) plugin_externals = {};

      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      for (var name in plugin_externals) {
        externals[name] = plugin_externals[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
function _(t,_,n,o,r){o();t(1).__exportStar(t(2),n)},
function _(t,e,n,r,o){r();var a=function(t,e){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])})(t,e)};function i(t){var e="function"==typeof Symbol&&Symbol.iterator,n=e&&t[e],r=0;if(n)return n.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&r>=t.length&&(t=void 0),{value:t&&t[r++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function c(t,e){var n="function"==typeof Symbol&&t[Symbol.iterator];if(!n)return t;var r,o,a=n.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(r=a.next()).done;)i.push(r.value)}catch(t){o={error:t}}finally{try{r&&!r.done&&(n=a.return)&&n.call(a)}finally{if(o)throw o.error}}return i}function u(t){return this instanceof u?(this.v=t,this):new u(t)}n.__extends=function(t,e){function n(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)},n.__assign=function(){return n.__assign=Object.assign||function(t){for(var e,n=1,r=arguments.length;n<r;n++)for(var o in e=arguments[n])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},n.__assign.apply(this,arguments)},n.__rest=function(t,e){var n={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(n[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(r=Object.getOwnPropertySymbols(t);o<r.length;o++)e.indexOf(r[o])<0&&Object.prototype.propertyIsEnumerable.call(t,r[o])&&(n[r[o]]=t[r[o]])}return n},n.__decorate=function(t,e,n,r){var o,a=arguments.length,i=a<3?e:null===r?r=Object.getOwnPropertyDescriptor(e,n):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,n,r);else for(var c=t.length-1;c>=0;c--)(o=t[c])&&(i=(a<3?o(i):a>3?o(e,n,i):o(e,n))||i);return a>3&&i&&Object.defineProperty(e,n,i),i},n.__param=function(t,e){return function(n,r){e(n,r,t)}},n.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},n.__awaiter=function(t,e,n,r){return new(n||(n=Promise))((function(o,a){function i(t){try{u(r.next(t))}catch(t){a(t)}}function c(t){try{u(r.throw(t))}catch(t){a(t)}}function u(t){var e;t.done?o(t.value):(e=t.value,e instanceof n?e:new n((function(t){t(e)}))).then(i,c)}u((r=r.apply(t,e||[])).next())}))},n.__generator=function(t,e){var n,r,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:c(0),throw:c(1),return:c(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function c(a){return function(c){return function(a){if(n)throw new TypeError("Generator is already executing.");for(;i;)try{if(n=1,r&&(o=2&a[0]?r.return:a[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,a[1])).done)return o;switch(r=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,r=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],r=0}finally{n=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,c])}}},n.__createBinding=Object.create?function(t,e,n,r){void 0===r&&(r=n),Object.defineProperty(t,r,{enumerable:!0,get:function(){return e[n]}})}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]},n.__exportStar=function(t,e){for(var r in t)"default"===r||Object.prototype.hasOwnProperty.call(e,r)||n.__createBinding(e,t,r)},n.__values=i,n.__read=c,n.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(c(arguments[e]));return t},n.__spreadArrays=function(){for(var t=0,e=0,n=arguments.length;e<n;e++)t+=arguments[e].length;var r=Array(t),o=0;for(e=0;e<n;e++)for(var a=arguments[e],i=0,c=a.length;i<c;i++,o++)r[o]=a[i];return r},n.__await=u,n.__asyncGenerator=function(t,e,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=n.apply(t,e||[]),a=[];return r={},i("next"),i("throw"),i("return"),r[Symbol.asyncIterator]=function(){return this},r;function i(t){o[t]&&(r[t]=function(e){return new Promise((function(n,r){a.push([t,e,n,r])>1||c(t,e)}))})}function c(t,e){try{(n=o[t](e)).value instanceof u?Promise.resolve(n.value.v).then(f,l):s(a[0][2],n)}catch(t){s(a[0][3],t)}var n}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},n.__asyncDelegator=function(t){var e,n;return e={},r("next"),r("throw",(function(t){throw t})),r("return"),e[Symbol.iterator]=function(){return this},e;function r(r,o){e[r]=t[r]?function(e){return(n=!n)?{value:u(t[r](e)),done:"return"===r}:o?o(e):e}:o}},n.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,n=t[Symbol.asyncIterator];return n?n.call(t):(t=i(t),e={},r("next"),r("throw"),r("return"),e[Symbol.asyncIterator]=function(){return this},e);function r(n){e[n]=t[n]&&function(e){return new Promise((function(r,o){(function(t,e,n,r){Promise.resolve(r).then((function(e){t({value:e,done:n})}),e)})(r,o,(e=t[n](e)).done,e.value)}))}}},n.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t};var f=Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e};n.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var r in t)"default"!==r&&Object.prototype.hasOwnProperty.call(t,r)&&n.__createBinding(e,t,r);return f(e,t),e},n.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},n.__classPrivateFieldGet=function(t,e){if(!e.has(t))throw new TypeError("attempted to get private field on non-instance");return e.get(t)},n.__classPrivateFieldSet=function(t,e,n){if(!e.has(t))throw new TypeError("attempted to set private field on non-instance");return e.set(t,n),n}},
function _(e,t,o,s,l){s();const n=e(1);l("version",e(3).version),l("index",e(4).index),o.embed=n.__importStar(e(4)),o.protocol=n.__importStar(e(396)),o._testing=n.__importStar(e(397));var r=e(19);l("logger",r.logger),l("set_log_level",r.set_log_level),l("settings",e(27).settings),l("Models",e(7).Models),l("documents",e(5).documents),l("safely",e(398).safely)},
function _(n,e,i,o,v){o(),i.version="2.3.0-dev.5"},
function _(e,o,t,n,s){n();const d=e(5),r=e(19),_=e(29),c=e(13),i=e(8),a=e(16),u=e(387),l=e(389),m=e(388);var f=e(387);s("add_document_standalone",f.add_document_standalone),s("index",f.index),s("add_document_from_session",e(389).add_document_from_session);var g=e(394);async function w(e,o,t,n){i.isString(e)&&(e=JSON.parse(_.unescape(e)));const s={};for(const[o,t]of c.entries(e))s[o]=d.Document.from_json(t);const a=[];for(const e of o){const o=m._resolve_element(e),d=m._resolve_root_elements(e);if(null!=e.docid)a.push(await u.add_document_standalone(s[e.docid],o,d,e.use_for_title));else{if(null==e.token)throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");{const s=l._get_ws_url(t,n);r.logger.debug("embed: computed ws url: "+s);try{a.push(await l.add_document_from_session(s,e.token,o,d,e.use_for_title)),console.log("Bokeh items were rendered successfully")}catch(e){console.log("Error rendering Bokeh items:",e)}}}}return a}s("embed_items_notebook",g.embed_items_notebook),s("kernels",g.kernels),s("BOKEH_ROOT",e(388).BOKEH_ROOT),t.embed_item=async function(e,o){const t={},n=_.uuid4();t[n]=e.doc,null==o&&(o=e.target_id);const s=document.getElementById(o);null!=s&&s.classList.add(m.BOKEH_ROOT);const d={roots:{[e.root_id]:o},root_ids:[e.root_id],docid:n};await a.defer();const[r]=await w(t,[d]);return r},t.embed_items=async function(e,o,t,n){return await a.defer(),w(e,o,t,n)}},
function _(t,_,o,r,n){r();const a=t(1);a.__exportStar(t(6),o),a.__exportStar(t(133),o)},
function _(e,t,s,o,n){o();const i=e(1),r=e(7),a=e(3),_=e(19),l=e(80),c=e(14),d=e(30),h=e(15),f=e(17),u=e(278),m=e(9),g=e(13),w=i.__importStar(e(132)),p=e(26),v=e(8),b=e(299),y=e(130),k=e(88),j=e(133);class M{constructor(e){this.document=e,this.session=null,this.subscribed_models=new Set}send_event(e){const t=new j.MessageSentEvent(this.document,"bokeh_event",e.to_json());this.document._trigger_on_change(t)}trigger(e){for(const t of this.subscribed_models)null!=e.origin&&e.origin!=t||t._process_event(e)}}s.EventManager=M,M.__name__="EventManager",s.documents=[],s.DEFAULT_TITLE="Bokeh Application";class S{constructor(){s.documents.push(this),this._init_timestamp=Date.now(),this._title=s.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._all_models_freeze_count=0,this._callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new M(this),this.idle=new h.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}get layoutables(){return this._roots.filter(e=>e instanceof b.LayoutDOM)}get is_idle(){for(const e of this.layoutables)if(!this._idle_roots.has(e))return!1;return!0}notify_idle(e){this._idle_roots.set(e,!0),this.is_idle&&(_.logger.info(`document idle at ${Date.now()-this._init_timestamp} ms`),this.event_manager.send_event(new l.DocumentReady),this.idle.emit())}clear(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}}interactive_start(e){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new l.LODStart)),this._interactive_timestamp=Date.now()}interactive_stop(){null!=this._interactive_plot&&this._interactive_plot.trigger_event(new l.LODEnd),this._interactive_plot=null,this._interactive_timestamp=null}interactive_duration(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp}destructively_move(e){if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();const t=m.copy(this._roots);this.clear();for(const e of t)if(null!=e.document)throw new Error("Somehow we didn't detach "+e);if(0!=this._all_models.size)throw new Error("this._all_models still had stuff in it: "+this._all_models);for(const s of t)e.add_root(s);e.set_title(this._title)}_push_all_models_freeze(){this._all_models_freeze_count+=1}_pop_all_models_freeze(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()}_invalidate_all_models(){_.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()}_recompute_all_models(){let e=new Set;for(const t of this._roots)e=w.union(e,t.references());const t=new Set(this._all_models.values()),s=w.difference(t,e),o=w.difference(e,t),n=new Map;for(const t of e)n.set(t.id,t);for(const e of s)e.detach_document();for(const e of o)e.attach_document(this);this._all_models=n}roots(){return this._roots}add_root(e,t){if(_.logger.debug("Adding root: "+e),!m.includes(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new j.RootAddedEvent(this,e,t))}}remove_root(e,t){const s=this._roots.indexOf(e);if(!(s<0)){this._push_all_models_freeze();try{this._roots.splice(s,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new j.RootRemovedEvent(this,e,t))}}title(){return this._title}set_title(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new j.TitleChangedEvent(this,e,t)))}get_model_by_id(e){var t;return null!==(t=this._all_models.get(e))&&void 0!==t?t:null}get_model_by_name(e){const t=[];for(const s of this._all_models.values())s instanceof k.Model&&s.name==e&&t.push(s);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error(`Multiple models are named '${e}'`)}}on_message(e,t){const s=this._message_callbacks.get(e);null==s?this._message_callbacks.set(e,new Set([t])):s.add(t)}remove_on_message(e,t){var s;null===(s=this._message_callbacks.get(e))||void 0===s||s.delete(t)}_trigger_on_message(e,t){const s=this._message_callbacks.get(e);if(null!=s)for(const e of s)e(t)}on_change(e,t=!1){this._callbacks.has(e)||this._callbacks.set(e,t)}remove_on_change(e){this._callbacks.delete(e)}_trigger_on_change(e){for(const[t,s]of this._callbacks)if(!s&&e instanceof j.DocumentEventBatch)for(const s of e.events)t(s);else t(e)}_notify_change(e,t,s,o,n){this._trigger_on_change(new j.ModelChangedEvent(this,e,t,s,o,null==n?void 0:n.setter_id,null==n?void 0:n.hint))}static _instantiate_object(e,t,s){const o=Object.assign(Object.assign({},s),{id:e,__deferred__:!0});return new(r.Models(t))(o)}static _instantiate_references_json(e,t){var s;const o=new Map;for(const n of e){const e=n.id,i=n.type,r=null!==(s=n.attributes)&&void 0!==s?s:{};let a=t.get(e);null==a&&(a=S._instantiate_object(e,i,r),null!=n.subtype&&a.set_subtype(n.subtype)),o.set(a.id,a)}return o}static _resolve_refs(e,t,s,o){function n(e){if(f.is_ref(e)){if(t.has(e.id))return t.get(e.id);if(s.has(e.id))return s.get(e.id);throw new Error(`reference ${JSON.stringify(e)} isn't known (not in Document?)`)}return u.is_NDArray_ref(e)?u.decode_NDArray(e,o):v.isArray(e)?function(e){const t=[];for(const s of e)t.push(n(s));return t}(e):v.isPlainObject(e)?function(e){const t={};for(const[s,o]of g.entries(e))t[s]=n(o);return t}(e):e}return n(e)}static _initialize_references_json(e,t,s,o){const n=new Map;for(const{id:i,attributes:r}of e){const e=!t.has(i),a=e?s.get(i):t.get(i),_=S._resolve_refs(r,t,s,o);a.setv(_,{silent:!0}),n.set(i,{instance:a,is_new:e})}const i=[],r=new Set;function a(e){if(e instanceof c.HasProps){if(n.has(e.id)&&!r.has(e.id)){r.add(e.id);const{instance:t,is_new:s}=n.get(e.id),{attributes:o}=t;for(const e of g.values(o))a(e);s&&(t.finalize(),i.push(t))}}else if(v.isArray(e))for(const t of e)a(t);else if(v.isPlainObject(e))for(const t of g.values(e))a(t)}for(const e of n.values())a(e.instance);for(const e of i)e.connect_signals()}static _event_for_attribute_change(e,t,s,o,n){if(o.get_model_by_id(e.id).property(t).syncable){const i={kind:"ModelChanged",model:{id:e.id},attr:t,new:s};return c.HasProps._json_record_references(o,s,n,{recursive:!0}),i}return null}static _events_to_sync_objects(e,t,s,o){const n=Object.keys(e.attributes),i=Object.keys(t.attributes),r=m.difference(n,i),a=m.difference(i,n),l=m.intersection(n,i),c=[];for(const e of r)_.logger.warn(`Server sent key ${e} but we don't seem to have it in our JSON`);for(const n of a){const i=t.attributes[n];c.push(S._event_for_attribute_change(e,n,i,s,o))}for(const n of l){const i=e.attributes[n],r=t.attributes[n];null==i&&null==r||(null==i||null==r?c.push(S._event_for_attribute_change(e,n,r,s,o)):p.is_equal(i,r)||c.push(S._event_for_attribute_change(e,n,r,s,o)))}return c.filter(e=>null!=e)}static _compute_patch_since_json(e,t){const s=t.to_json(!1);function o(e){const t=new Map;for(const s of e.roots.references)t.set(s.id,s);return t}const n=o(e),i=new Map,r=[];for(const t of e.roots.root_ids)i.set(t,n.get(t)),r.push(t);const a=o(s),_=new Map,l=[];for(const e of s.roots.root_ids)_.set(e,a.get(e)),l.push(e);if(r.sort(),l.sort(),m.difference(r,l).length>0||m.difference(l,r).length>0)throw new Error("Not implemented: computing add/remove of document roots");const c=new Set;let h=[];for(const e of t._all_models.keys())if(n.has(e)){const s=S._events_to_sync_objects(n.get(e),a.get(e),t,c);h=h.concat(s)}const f=new d.Serializer({include_defaults:!1});return f.to_serializable([...c]),{references:[...f.definitions],events:h}}to_json_string(e=!0){return JSON.stringify(this.to_json(e))}to_json(e=!0){const t=new d.Serializer({include_defaults:e}),s=t.to_serializable(this._roots);return{version:a.version,title:this._title,roots:{root_ids:s.map(e=>e.id),references:[...t.definitions]}}}static from_json_string(e){const t=JSON.parse(e);return S.from_json(t)}static from_json(e){_.logger.debug("Creating Document from JSON");const t=e.version,s=-1!==t.indexOf("+")||-1!==t.indexOf("-"),o=`Library versions: JS (${a.version}) / Python (${t})`;s||a.version.replace(/-(dev|rc)\./,"$1")==t?_.logger.debug(o):(_.logger.warn("JS/Python version mismatch"),_.logger.warn(o));const n=e.roots,i=n.root_ids,r=n.references,l=S._instantiate_references_json(r,new Map);S._initialize_references_json(r,new Map,l,new Map);const c=new S;for(const e of i){const t=l.get(e);null!=t&&c.add_root(t)}return c.set_title(e.title),c}replace_with_json(e){S.from_json(e).destructively_move(this)}create_json_patch_string(e){return JSON.stringify(this.create_json_patch(e))}create_json_patch(e){for(const t of e)if(t.document!=this)throw new Error("Cannot create a patch using events from a different document");const t=new d.Serializer;return{events:t.to_serializable(e),references:[...t.definitions]}}apply_json_patch(e,t=new Map,s){const o=e.references,n=e.events,i=S._instantiate_references_json(o,this._all_models);t instanceof Map||(t=new Map(t));for(const e of n)switch(e.kind){case"RootAdded":case"RootRemoved":case"ModelChanged":{const t=e.model.id,s=this._all_models.get(t);if(null!=s)i.set(t,s);else if(!i.has(t))throw _.logger.warn(`Got an event for unknown model ${e.model}"`),new Error("event model wasn't known");break}}const r=new Map,a=new Map;for(const[e,t]of i)this._all_models.has(e)?r.set(e,t):a.set(e,t);S._initialize_references_json(o,r,a,t);for(const e of n)switch(e.kind){case"MessageSent":{const{msg_type:s,msg_data:o}=e;let n;if(void 0===o){if(1!=t.size)throw new Error("expected exactly one buffer");{const[[,e]]=t;n=e}}else n=S._resolve_refs(o,r,a,t);this._trigger_on_message(s,n);break}case"ModelChanged":{const o=e.model.id,n=this._all_models.get(o);if(null==n)throw new Error(`Cannot apply patch to ${o} which is not in the document`);const i=e.attr,_=S._resolve_refs(e.new,r,a,t);n.setv({[i]:_},{setter_id:s});break}case"ColumnDataChanged":{const o=e.column_source.id,n=this._all_models.get(o);if(null==n)throw new Error(`Cannot stream to ${o} which is not in the document`);const i=S._resolve_refs(e.new,new Map,new Map,t);if(null!=e.cols)for(const e in n.data)e in i||(i[e]=n.data[e]);n.setv({data:i},{setter_id:s,check_eq:!1});break}case"ColumnsStreamed":{const t=e.column_source.id,o=this._all_models.get(t);if(null==o)throw new Error(`Cannot stream to ${t} which is not in the document`);if(!(o instanceof y.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");const n=e.data,i=e.rollover;o.stream(n,i,s);break}case"ColumnsPatched":{const t=e.column_source.id,o=this._all_models.get(t);if(null==o)throw new Error(`Cannot patch ${t} which is not in the document`);if(!(o instanceof y.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");const n=e.patches;o.patch(n,s);break}case"RootAdded":{const t=e.model.id,o=i.get(t);this.add_root(o,s);break}case"RootRemoved":{const t=e.model.id,o=i.get(t);this.remove_root(o,s);break}case"TitleChanged":this.set_title(e.title,s);break;default:throw new Error("Unknown patch event "+JSON.stringify(e))}}}s.Document=S,S.__name__="Document"},
function _(e,s,o,r,t){r();const d=e(1),i=e(8),l=e(13),n=e(14);o.overrides={};const a=new Map;o.Models=e=>{var s;const r=null!==(s=o.overrides[e])&&void 0!==s?s:a.get(e);if(null==r)throw new Error(`Model '${e}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`);return r},o.Models.register=(e,s)=>{o.overrides[e]=s},o.Models.unregister=e=>{delete o.overrides[e]},o.Models.register_models=(e,s=!1,o)=>{var r;if(null!=e)for(const t of l.values(e))if(r=t,i.isObject(r)&&r.prototype instanceof n.HasProps){const e=t.__qualified__;s||!a.has(e)?a.set(e,t):null!=o?o(e):console.warn(`Model '${e}' was already registered`)}},o.register_models=o.Models.register_models,o.Models.registered_names=()=>[...a.keys()];const g=d.__importStar(e(33));o.register_models(g)},
function _(n,t,r,e,i){e();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const o=n(9),u=Object.prototype.toString;function c(n){return!0===n||!1===n||"[object Boolean]"===u.call(n)}function f(n){return"[object Number]"===u.call(n)}function s(n){return"[object String]"===u.call(n)}function a(n){const t=typeof n;return"function"===t||"object"===t&&!!n}r.isBoolean=c,r.isNumber=f,r.isInteger=function(n){return f(n)&&Number.isInteger(n)},r.isString=s,r.isPrimitive=function(n){return null===n||c(n)||f(n)||s(n)},r.isFunction=function(n){return"[object Function]"===u.call(n)},r.isArray=function(n){return Array.isArray(n)},r.isArrayOf=function(n,t){return o.every(n,t)},r.isArrayableOf=function(n,t){for(let r=0,e=n.length;r<e;r++)if(!t(n[r]))return!1;return!0},r.isTypedArray=function(n){return ArrayBuffer.isView(n)&&!(n instanceof DataView)},r.isObject=a,r.isPlainObject=function(n){return a(n)&&(null==n.constructor||n.constructor===Object)},r.isIterable=function(n){return Symbol.iterator in Object(n)}},
function _(n,t,e,r,o){r();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const i=n(10),u=n(11),c=n(12);o("map",c.map),o("reduce",c.reduce),o("min",c.min),o("min_by",c.min_by),o("max",c.max),o("max_by",c.max_by),o("sum",c.sum),o("cumsum",c.cumsum),o("every",c.every),o("some",c.some),o("find",c.find),o("find_last",c.find_last),o("find_index",c.find_index),o("find_last_index",c.find_last_index),o("sorted_index",c.sorted_index),o("is_empty",c.is_empty);const f=Array.prototype.slice;function s(n){return f.call(n)}function a(n){return[].concat(...n)}function l(n,t){return-1!==n.indexOf(t)}function m(n,t,e=1){u.assert(e>0,"'step' must be a positive number"),null==t&&(t=n,n=0);const{max:r,ceil:o,abs:i}=Math,c=n<=t?e:-e,f=r(o(i(t-n)/e),0),s=new Array(f);for(let t=0;t<f;t++,n+=c)s[t]=n;return s}e.head=function(n){return n[0]},e.tail=function(n){return n[n.length-1]},e.last=function(n){return n[n.length-1]},e.copy=s,e.concat=a,e.includes=l,e.contains=l,e.nth=function(n,t){return n[t>=0?t:n.length+t]},e.zip=function(...n){if(0==n.length)return[];const t=c.min(n.map(n=>n.length)),e=n.length,r=new Array(t);for(let o=0;o<t;o++){r[o]=new Array(e);for(let t=0;t<e;t++)r[o][t]=n[t][o]}return r},e.unzip=function(n){const t=n.length,e=c.min(n.map(n=>n.length)),r=Array(e);for(let n=0;n<e;n++)r[n]=new Array(t);for(let o=0;o<t;o++)for(let t=0;t<e;t++)r[t][o]=n[o][t];return r},e.range=m,e.linspace=function(n,t,e=100){const r=(t-n)/(e-1),o=new Array(e);for(let t=0;t<e;t++)o[t]=n+r*t;return o},e.transpose=function(n){const t=n.length,e=n[0].length,r=[];for(let o=0;o<e;o++){r[o]=[];for(let e=0;e<t;e++)r[o][e]=n[e][o]}return r},e.argmin=function(n){return c.min_by(m(n.length),t=>n[t])},e.argmax=function(n){return c.max_by(m(n.length),t=>n[t])},e.sort_by=function(n,t){const e=n.map((n,e)=>({value:n,index:e,key:t(n)}));return e.sort((n,t)=>{const e=n.key,r=t.key;if(e!==r){if(e>r||void 0===e)return 1;if(e<r||void 0===r)return-1}return n.index-t.index}),e.map(n=>n.value)},e.uniq=function(n){const t=new Set;for(const e of n)t.add(e);return[...t]},e.uniq_by=function(n,t){const e=[],r=[];for(const o of n){const n=t(o);l(r,n)||(r.push(n),e.push(o))}return e},e.union=function(...n){const t=new Set;for(const e of n)for(const n of e)t.add(n);return[...t]},e.intersection=function(n,...t){const e=[];n:for(const r of n)if(!l(e,r)){for(const n of t)if(!l(n,r))continue n;e.push(r)}return e},e.difference=function(n,...t){const e=a(t);return n.filter(n=>!l(e,n))},e.remove_at=function(n,t){const e=s(n);return e.splice(t,1),e},e.remove_by=function(n,t){for(let e=0;e<n.length;)t(n[e])?n.splice(e,1):e++},e.shuffle=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++){const t=i.randomIn(0,r);t!==r&&(e[r]=e[t]),e[t]=n[r]}return e},e.pairwise=function(n,t){const e=n.length,r=new Array(e-1);for(let o=0;o<e-1;o++)r[o]=t(n[o],n[o+1]);return r},e.reversed=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++)e[t-r-1]=n[r];return e},e.repeat=function(n,t){const e=new Array(t);for(let r=0;r<t;r++)e[r]=n;return e}},
function _(n,t,r,a,o){function u(n){if(0==n)return 0;for(;n<=0;)n+=2*Math.PI;for(;n>2*Math.PI;)n-=2*Math.PI;return n}function e(n,t){return u(n-t)}function f(){return Math.random()}a(),r.angle_norm=u,r.angle_dist=e,r.angle_between=function(n,t,r,a=!1){const o=e(t,r);if(0==o)return!1;if(o==2*Math.PI)return!0;const f=u(n),i=e(t,f)<=o&&e(f,r)<=o;return a?!i:i},r.random=f,r.randomIn=function(n,t){return null==t&&(t=n,n=0),n+Math.floor(Math.random()*(t-n+1))},r.atan2=function(n,t){return Math.atan2(t[1]-n[1],t[0]-n[0])},r.radians=function(n){return n*(Math.PI/180)},r.degrees=function(n){return n/(Math.PI/180)},r.rnorm=function(n,t){let r,a;for(;r=f(),a=f(),a=(2*a-1)*Math.sqrt(1/Math.E*2),!(-4*r*r*Math.log(r)>=a*a););let o=a/r;return o=n+t*o,o},r.clamp=function(n,t,r){return n<t?t:n>r?r:n},r.log=function(n,t=Math.E){return Math.log(n)/Math.log(t)}},
function _(r,n,e,o,s){o();class t extends Error{}e.AssertionError=t,t.__name__="AssertionError",e.assert=function(r,n){if(!(!0===r||!1!==r&&r()))throw new t(null!=n?n:"Assertion failed")},e.unreachable=function(){throw new Error("unreachable code")}},
function _(n,t,e,r,o){r();const i=n(8),u=n(10);function l(n,t,e,...r){const o=n.length;t<0&&(t+=o),t<0?t=0:t>o&&(t=o),null==e||e>o-t?e=o-t:e<0&&(e=0);const i=o-e+r.length,u=new n.constructor(i);let l=0;for(;l<t;l++)u[l]=n[l];for(const n of r)u[l++]=n;for(let r=t+e;r<o;r++)u[l++]=n[r];return u}function c(n,t){return l(n,t,n.length-t)}function f(n,t){const e=n.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=t(n[o],o,n);return r}function s(n,t,e){const r=n.length;if(void 0===e&&0==r)throw new Error("can't reduce an empty array without an initial value");let o,i;for(void 0===e?(o=n[0],i=1):(o=e,i=0);i<r;i++)o=t(o,n[i],i,n);return o}function h(n){return function(t,e){const r=t.length;let o=n>0?0:r-1;for(;o>=0&&o<r;o+=n)if(e(t[o]))return o;return-1}}function a(n,t){let e=0,r=n.length;for(;e<r;){const o=Math.floor((e+r)/2);n[o]<t?e=o+1:r=o}return e}function g(n,t,e,r,o){const i=(o-e)/(r-t);let u=i*(n-t)+e;return isFinite(u)||(u=i*(n-r)+o,isFinite(u)||e!=o||(u=e)),u}function d(n,t){if(n<t[0])return-1;if(n>t[t.length-1])return t.length;let e=0,r=t.length-1;for(;r-e!=1;){const o=e+Math.floor((r-e)/2);n>=t[o]?e=o:r=o}return e}e.is_empty=function(n){return 0==n.length},e.copy=function(n){return i.isArray(n)?n.slice():new n.constructor(n)},e.splice=l,e.head=c,e.insert=function(n,t,e){return l(n,e,0,t)},e.append=function(n,t){return l(n,n.length,0,t)},e.prepend=function(n,t){return l(n,0,0,t)},e.indexOf=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.subselect=function(n,t){const e=t.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=n[t[o]];return r},e.map=f,e.filter=function(n,t){const e=n.length,r=new n.constructor(e);let o=0;for(let i=0;i<e;i++){const e=n[i];t(e,i,n)&&(r[o++]=e)}return c(r,o)},e.reduce=s,e.min=function(n){let t,e=1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],!isNaN(t)&&t<e&&(e=t);return e},e.max=function(n){let t,e=-1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],!isNaN(t)&&t>e&&(e=t);return e},e.minmax=function(n){let t,e=1/0,r=-1/0;for(let o=0,i=n.length;o<i;o++)t=n[o],isNaN(t)||(t<e&&(e=t),t>r&&(r=t));return[e,r]},e.min_by=function(n,t){if(0==n.length)throw new Error("min_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,i=n.length;o<i;o++){const i=n[o],u=t(i);u<r&&(e=i,r=u)}return e},e.max_by=function(n,t){if(0==n.length)throw new Error("max_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,i=n.length;o<i;o++){const i=n[o],u=t(i);u>r&&(e=i,r=u)}return e},e.sum=function(n){let t=0;for(let e=0,r=n.length;e<r;e++)t+=n[e];return t},e.cumsum=function(n){const t=new n.constructor(n.length);return s(n,(n,e,r)=>t[r]=n+e,0),t},e.every=function(n,t){for(let e=0,r=n.length;e<r;e++)if(!t(n[e]))return!1;return!0},e.some=function(n,t){for(let e=0,r=n.length;e<r;e++)if(t(n[e]))return!0;return!1},e.index_of=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.find_index=h(1),e.find_last_index=h(-1),e.find=function(n,t){const r=e.find_index(n,t);return-1==r?void 0:n[r]},e.find_last=function(n,t){const r=e.find_last_index(n,t);return-1==r?void 0:n[r]},e.sorted_index=a,e.bin_counts=function(n,t){const e=t.length-1,r=Array(e).fill(0);for(let o=0;o<n.length;o++){const i=a(t,n[o]);r[u.clamp(i-1,0,e-1)]+=1}return r},e.interpolate=function(n,t,e){const r=n.length,o=new Array(r);for(let i=0;i<r;i++){const r=n[i];if(isNaN(r)){o[i]=r;continue}const u=d(r,t);if(-1==u)o[i]=e[0];else if(u==t.length)o[i]=e[e.length-1];else if(u==t.length-1||t[u]==r)o[i]=e[u];else{const n=t[u],l=e[u],c=t[u+1],f=e[u+1];o[i]=g(r,n,l,c,f)}}return o},e.left_edge_index=d,e.norm=function(n,t,e){const r=e-t;return f(n,n=>(n-t)/r)}},
function _(t,e,n,c,o){c();const s=t(9);function r(t){return Object.keys(t).length}n.keys=Object.keys,n.values=Object.values,n.entries=Object.entries,n.extend=Object.assign,n.clone=function(t){return Object.assign({},t)},n.merge=function(t,e){const n=Object.create(Object.prototype),c=s.concat([Object.keys(t),Object.keys(e)]);for(const o of c){const c=t.hasOwnProperty(o)?t[o]:[],r=e.hasOwnProperty(o)?e[o]:[];n[o]=s.union(c,r)}return n},n.size=r,n.isEmpty=function(t){return 0==r(t)},n.to_object=function(t){const e={};for(const[n,c]of t)e[n]=c;return e}},
function _(t,e,s,r,n){r();const i=t(1),o=t(15),c=t(17),a=i.__importStar(t(18)),_=i.__importStar(t(21)),u=i.__importStar(t(28)),h=t(29),l=t(9),f=t(13),p=t(8),d=t(26),g=t(30),y=t(5),v=t(26),m=t(31),b=t(32),w=i.__importStar(t(21));class $ extends(o.Signalable()){constructor(t={}){var e,s;super(),this._subtype=void 0,this.document=null,this.destroyed=new o.Signal0(this,"destroyed"),this.change=new o.Signal0(this,"change"),this.transformchange=new o.Signal0(this,"transformchange"),this.properties={},this._pending=!1,this._changing=!1;const r=t instanceof Map?t.get.bind(t):e=>t[e];this.id=null!==(e=r("id"))&&void 0!==e?e:h.uniqueId();for(const[t,{type:e,default_value:s,options:n}]of f.entries(this._props)){let i;i=e instanceof a.PropertyAlias?new Proxy(this.properties[e.attr],{get:(e,s)=>"attr"==s?t:e[s]}):e instanceof _.Kind?new a.PrimitiveProperty(this,t,e,s,r(t),n):new e(this,t,_.Any,s,r(t),n),this.properties[t]=i}null!==(s=r("__deferred__"))&&void 0!==s&&s||(this.finalize(),this.connect_signals())}set type(t){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=t}get type(){return this.constructor.__qualified__}static get __qualified__(){const{__module__:t,__name__:e}=this;return null!=t?`${t}.${e}`:e}static get[Symbol.toStringTag](){return this.__name__}static init_HasProps(){this.prototype._props={},this.prototype._mixins=[]}static _fix_default(t,e){if(void 0===t||p.isFunction(t))return t;if(p.isPrimitive(t))return()=>t;{const e=new b.Cloner;return()=>e.clone(t)}}static define(t){for(const[e,s]of f.entries(p.isFunction(t)?t(w):t)){if(null!=this.prototype._props[e])throw new Error(`attempted to redefine property '${this.prototype.type}.${e}'`);if(null!=this.prototype[e])throw new Error(`attempted to redefine attribute '${this.prototype.type}.${e}'`);Object.defineProperty(this.prototype,e,{get(){return this.properties[e].get_value()},set(t){return this.setv({[e]:t}),this},configurable:!1,enumerable:!0});const[t,r,n]=s,i={type:t,default_value:this._fix_default(r,e),options:n},o=Object.assign({},this.prototype._props);o[e]=i,this.prototype._props=o}}static internal(t){const e={};for(const[s,r]of f.entries(p.isFunction(t)?t(w):t)){const[t,n,i={}]=r;e[s]=[t,n,Object.assign(Object.assign({},i),{internal:!0})]}this.define(e)}static mixins(t){function e(t){switch(t){case"line":return u.LineVector;case"fill":return u.FillVector;case"hatch":return u.HatchVector;case"text":return u.TextVector;default:throw new Error(`Unknown property mixin kind '${t}'`)}}function s(t,e){const s={};for(const[r,n]of f.entries(e))s[t+r]=n;return s}function r(t){const[e]=Object.keys(t),[s]=e.split("_",1);return s}p.isArray(t)||(t=[t]);const n={},i=[];for(const o of t)if(p.isString(o)){const[t,r=""]=o.split(":"),c=e(t);i.push(o),f.extend(n,s(r,c))}else if(p.isArray(o)){const[t,e]=o;i.push(`${r(e)}:${t}`),f.extend(n,s(t,e))}else{const t=o;i.push(r(t)),f.extend(n,t)}this.define(n),this.prototype._mixins=[...this.prototype._mixins,...i]}static override(t){for(const[e,s]of f.entries(t)){const t=this._fix_default(s,e),r=this.prototype._props[e];if(null==r)throw new Error(`attempted to override nonexistent '${this.prototype.type}.${e}'`);const n=Object.assign({},this.prototype._props);n[e]=Object.assign(Object.assign({},r),{default_value:t}),this.prototype._props=n}}toString(){return`${this.type}(${this.id})`}property(t){const e=this.properties[t];if(null!=e)return e;throw new Error(`unknown property ${this.type}.${t}`)}get attributes(){const t={};for(const e of this)t[e.attr]=e.get_value();return t}[b.clone](t){const e=new Map;for(const s of this)s.dirty&&e.set(s.attr,t.clone(s.get_value()));return new this.constructor(e)}[v.equals](t,e){for(const s of this){const r=t.property(s.attr);if(e.eq(s.get_value(),r.get_value()))return!1}return!0}[m.pretty](t){const e=t.token,s=[];for(const r of this)if(r.dirty){const n=r.get_value();s.push(`${r.attr}${e(":")} ${t.to_string(n)}`)}return`${this.constructor.__qualified__}${e("(")}${e("{")}${s.join(e(",")+" ")}${e("}")}${e(")")}`}[g.serialize](t){const e=this.ref();t.add_ref(this,e);const s=this.struct();for(const e of this)e.syncable&&(t.include_defaults||e.dirty)&&(s.attributes[e.attr]=t.to_serializable(e.get_value()));return t.add_def(this,s),e}finalize(){for(const t of this)null!=t.spec.transform&&this.connect(t.spec.transform.change,()=>this.transformchange.emit());this.initialize()}initialize(){}connect_signals(){}disconnect_signals(){o.Signal.disconnectReceiver(this)}destroy(){this.disconnect_signals(),this.destroyed.emit()}clone(){return(new b.Cloner).clone(this)}_setv(t,e){const s=e.check_eq,r=[],n=this._changing;this._changing=!0;for(const[e,n]of t)!1!==s&&d.is_equal(e.get_value(),n)||(e.set_value(n),r.push(e));r.length>0&&(this._pending=!0);for(const t of r)t.change.emit();if(!n){if(!e.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}}setv(t,e={}){const s=f.entries(t);if(0==s.length)return;if(!0===e.silent){for(const[t,e]of s)this.properties[t].set_value(e);return}const r=new Map,n=new Map;for(const[t,e]of s){const s=this.properties[t];r.set(s,e),n.set(s,s.get_value())}this._setv(r,e);const{document:i}=this;if(null!=i){const t=[];for(const[e,s]of n)t.push([e,s,e.get_value()]);for(const[,e,s]of t)if(this._needs_invalidate(e,s)){i._invalidate_all_models();break}this._push_changes(t,e)}}getv(t){return this.property(t).get_value()}ref(){return{id:this.id}}struct(){const t={type:this.type,id:this.id,attributes:{}};return null!=this._subtype&&(t.subtype=this._subtype),t}set_subtype(t){this._subtype=t}*[Symbol.iterator](){yield*f.values(this.properties)}*syncable_properties(){for(const t of this)t.syncable&&(yield t)}serializable_attributes(){const t={};for(const e of this.syncable_properties())t[e.attr]=e.get_value();return t}static _json_record_references(t,e,s,r){const{recursive:n}=r;if(c.is_ref(e)){const r=t.get_model_by_id(e.id);null==r||s.has(r)||$._value_record_references(r,s,{recursive:n})}else if(p.isArray(e))for(const r of e)$._json_record_references(t,r,s,{recursive:n});else if(p.isPlainObject(e))for(const r of f.values(e))$._json_record_references(t,r,s,{recursive:n})}static _value_record_references(t,e,s){const{recursive:r}=s;if(t instanceof $){if(!e.has(t)&&(e.add(t),r))for(const s of t.syncable_properties()){const t=s.get_value();$._value_record_references(t,e,{recursive:r})}}else if(p.isArray(t))for(const s of t)$._value_record_references(s,e,{recursive:r});else if(p.isPlainObject(t))for(const s of f.values(t))$._value_record_references(s,e,{recursive:r})}references(){const t=new Set;return $._value_record_references(this,t,{recursive:!0}),t}_doc_attached(){}_doc_detached(){}attach_document(t){if(null!=this.document&&this.document!=t)throw new Error("models must be owned by only a single document");this.document=t,this._doc_attached()}detach_document(){this._doc_detached(),this.document=null}_needs_invalidate(t,e){const s=new Set;$._value_record_references(e,s,{recursive:!1});const r=new Set;$._value_record_references(t,r,{recursive:!1});for(const t of s)if(!r.has(t))return!0;for(const t of r)if(!s.has(t))return!0;return!1}_push_changes(t,e={}){const{document:s}=this;if(null==s)return;const{setter_id:r}=e,n=[];for(const[e,i,o]of t)e.syncable&&n.push(new y.ModelChangedEvent(s,this,e.attr,i,o,r));if(0!=n.length){let t;1==n.length?[t]=n:t=new y.DocumentEventBatch(s,n,r),s._trigger_on_change(t)}}materialize_dataspecs(t){const e={};for(const s of this){if(!(s instanceof a.VectorSpec))continue;if(s.optional&&null==s.spec.value&&!s.dirty)continue;const r=s.attr,n=s.array(t);e["_"+r]=n,s instanceof a.DistanceSpec&&(e["max_"+r]=l.max(n))}return e}on_change(t,e){for(const s of p.isArray(t)?t:[t])this.connect(s.change,e)}}s.HasProps=$,$.init_HasProps()},
function _(n,t,e,l,s){l();const i=n(16),o=n(9);class c{constructor(n,t){this.sender=n,this.name=t}connect(n,t=null){u.has(this.sender)||u.set(this.sender,[]);const e=u.get(this.sender);if(null!=g(e,this,n,t))return!1;const l=null!=t?t:n;a.has(l)||a.set(l,[]);const s=a.get(l),i={signal:this,slot:n,context:t};return e.push(i),s.push(i),!0}disconnect(n,t=null){const e=u.get(this.sender);if(null==e||0===e.length)return!1;const l=g(e,this,n,t);if(null==l)return!1;const s=null!=t?t:n,i=a.get(s);return l.signal=null,d(e),d(i),!0}emit(n){var t;const e=null!==(t=u.get(this.sender))&&void 0!==t?t:[];for(const{signal:t,slot:l,context:s}of e)t===this&&l.call(s,n,this.sender)}}e.Signal=c,c.__name__="Signal";class r extends c{emit(){super.emit(void 0)}}e.Signal0=r,r.__name__="Signal0",function(n){function t(n,t){const e=u.get(n);if(null==e||0===e.length)return;const l=a.get(t);if(null!=l&&0!==l.length){for(const t of l){if(null==t.signal)return;t.signal.sender===n&&(t.signal=null)}d(e),d(l)}}function e(n){var t;const e=u.get(n);if(null!=e&&0!==e.length){for(const n of e){if(null==n.signal)return;const e=null!==(t=n.context)&&void 0!==t?t:n.slot;n.signal=null,d(a.get(e))}d(e)}}function l(n,t,e){const l=a.get(n);if(null!=l&&0!==l.length){for(const n of l){if(null==n.signal)return;if(null!=t&&n.slot!=t)continue;const l=n.signal.sender;null!=e&&e.has(l)||(n.signal=null,d(u.get(l)))}d(l)}}function s(n){const t=u.get(n);if(null!=t&&0!==t.length){for(const n of t)n.signal=null;d(t)}const e=a.get(n);if(null!=e&&0!==e.length){for(const n of e)n.signal=null;d(e)}}n.disconnect_between=t,n.disconnect_sender=e,n.disconnect_receiver=l,n.disconnect_all=s,n.disconnectBetween=t,n.disconnectSender=e,n.disconnectReceiver=l,n.disconnectAll=s}(c||(e.Signal=c={})),e.Signalable=function(){return class{connect(n,t){return n.connect(t,this)}disconnect(n,t){return n.disconnect(t,this)}}};const u=new WeakMap,a=new WeakMap;function g(n,t,e,l){return o.find(n,n=>n.signal===t&&n.slot===e&&n.context===l)}const f=new Set;function d(n){0===f.size&&(async()=>{await i.defer(),function(){for(const n of f)o.remove_by(n,n=>null==n.signal);f.clear()}()})(),f.add(n)}},
function _(e,n,t,s,o){s();const a=new MessageChannel,l=new Map;a.port1.onmessage=e=>{const n=e.data,t=l.get(n);if(null!=t)try{t()}finally{l.delete(n)}};let r=1;t.defer=function(){return new Promise(e=>{const n=r++;l.set(n,e),a.port2.postMessage(n)})}},
function _(n,t,i,e,c){e();const r=n(8),s=n(13);i.is_ref=function(n){if(r.isPlainObject(n)){const t=s.keys(n);return 1==t.length&&"id"==t[0]}return!1}},
function _(e,t,n,a,s){a();const i=e(1),r=e(15),l=e(19),o=i.__importStar(e(20)),c=e(24),_=e(9),u=e(12),d=e(22),p=e(8),S=e(27);function m(e){try{return JSON.stringify(e)}catch(t){return e.toString()}}function h(e){return p.isPlainObject(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}n.isSpec=h;class v{constructor(e,t,n,a,s,i={}){var l,o;let c;if(this.obj=e,this.attr=t,this.kind=n,this.default_value=a,this._dirty=!1,this.change=new r.Signal0(this.obj,"change"),this.internal=null!==(l=i.internal)&&void 0!==l&&l,this.optional=null!==(o=i.optional)&&void 0!==o&&o,this.on_update=i.on_update,void 0!==s)c=s,this._dirty=!0;else{const t=this._default_override();if(void 0!==t)c=t;else{if(void 0===a)return void(this.spec={value:null});c=a(e)}}this._update(c)}get is_value(){return void 0!==this.spec.value}get syncable(){return!this.internal}get_value(){return this.spec.value}set_value(e){this._update(e),this._dirty=!0}_default_override(){}get dirty(){return this._dirty}_update(e){var t;this.validate(e),this.spec={value:e},null===(t=this.on_update)||void 0===t||t.call(this,e,this.obj)}toString(){return`Prop(${this.obj}.${this.attr}, spec: ${m(this.spec)})`}normalize(e){return e}validate(e){if(!this.valid(e))throw new Error(`${this.obj}.${this.attr} given invalid value: ${m(e)}`)}valid(e){return this.kind.valid(e)}value(e=!0){if(!this.is_value)throw new Error("attempted to retrieve property value for property without value specification");let t=this.normalize([this.spec.value])[0];return null!=this.spec.transform&&e&&(t=this.spec.transform.compute(t)),t}}n.Property=v,v.__name__="Property";class g{constructor(e){this.attr=e}}n.PropertyAlias=g,g.__name__="PropertyAlias",n.Alias=function(e){return new g(e)};class x extends v{}n.PrimitiveProperty=x,x.__name__="PrimitiveProperty";class y extends v{}n.Any=y,y.__name__="Any";class f extends v{valid(e){return p.isArray(e)||e instanceof Float32Array||e instanceof Float64Array}}n.Array=f,f.__name__="Array";class A extends v{valid(e){return p.isBoolean(e)}}n.Boolean=A,A.__name__="Boolean";class P extends v{valid(e){return p.isString(e)&&d.is_color(e)}}n.Color=P,P.__name__="Color";class C extends v{}n.Instance=C,C.__name__="Instance";class b extends v{valid(e){return p.isNumber(e)}}n.Number=b,b.__name__="Number";class L extends b{valid(e){return p.isNumber(e)&&(0|e)==e}}n.Int=L,L.__name__="Int";class N extends b{}n.Angle=N,N.__name__="Angle";class T extends b{valid(e){return p.isNumber(e)&&0<=e&&e<=1}}n.Percent=T,T.__name__="Percent";class q extends v{valid(e){return p.isString(e)}}n.String=q,q.__name__="String";class B extends v{valid(e){return null===e||p.isString(e)}}n.NullString=B,B.__name__="NullString";class D extends q{}n.FontSize=D,D.__name__="FontSize";class M extends q{_default_override(){return S.settings.dev?"Bokeh":void 0}}n.Font=M,M.__name__="Font";class w extends v{valid(e){return p.isString(e)&&_.includes(this.enum_values,e)}}function k(e){return class extends w{get enum_values(){return[...e]}}}n.EnumProperty=w,w.__name__="EnumProperty",n.Enum=k;class F extends w{get enum_values(){return[...o.Direction]}normalize(e){const t=new Uint8Array(e.length);for(let n=0;n<e.length;n++)switch(e[n]){case"clock":t[n]=0;break;case"anticlock":t[n]=1}return t}}n.Direction=F,F.__name__="Direction",n.Anchor=k(o.Anchor),n.AngleUnits=k(o.AngleUnits),n.BoxOrigin=k(o.BoxOrigin),n.ButtonType=k(o.ButtonType),n.CalendarPosition=k(o.CalendarPosition),n.Dimension=k(o.Dimension),n.Dimensions=k(o.Dimensions),n.Distribution=k(o.Distribution),n.FontStyle=k(o.FontStyle),n.HatchPatternType=k(o.HatchPatternType),n.HTTPMethod=k(o.HTTPMethod),n.HexTileOrientation=k(o.HexTileOrientation),n.HoverMode=k(o.HoverMode),n.LatLon=k(o.LatLon),n.LegendClickPolicy=k(o.LegendClickPolicy),n.LegendLocation=k(o.LegendLocation),n.LineCap=k(o.LineCap),n.LineJoin=k(o.LineJoin),n.LinePolicy=k(o.LinePolicy),n.Location=k(o.Location),n.Logo=k(o.Logo),n.MarkerType=k(o.MarkerType),n.MutedPolicy=k(o.MutedPolicy),n.Orientation=k(o.Orientation),n.OutputBackend=k(o.OutputBackend),n.PaddingUnits=k(o.PaddingUnits),n.Place=k(o.Place),n.PointPolicy=k(o.PointPolicy),n.RadiusDimension=k(o.RadiusDimension),n.RenderLevel=k(o.RenderLevel),n.RenderMode=k(o.RenderMode),n.ResetPolicy=k(o.ResetPolicy),n.RoundingFunction=k(o.RoundingFunction),n.Side=k(o.Side),n.SizingMode=k(o.SizingMode),n.Sort=k(o.Sort),n.SpatialUnits=k(o.SpatialUnits),n.StartEnd=k(o.StartEnd),n.StepMode=k(o.StepMode),n.TapBehavior=k(o.TapBehavior),n.TextAlign=k(o.TextAlign),n.TextBaseline=k(o.TextBaseline),n.TextureRepetition=k(o.TextureRepetition),n.TickLabelOrientation=k(o.TickLabelOrientation),n.TooltipAttachment=k(o.TooltipAttachment),n.UpdateMode=k(o.UpdateMode),n.VerticalAlign=k(o.VerticalAlign);class U extends v{get_value(){return null===this.spec.value?null:this.spec}_update(e){h(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)}}n.ScalarSpec=U,U.__name__="ScalarSpec";class z extends U{}n.AnyScalar=z,z.__name__="AnyScalar";class O extends U{}n.ColorScalar=O,O.__name__="ColorScalar";class R extends U{}n.NumberScalar=R,R.__name__="NumberScalar";class $ extends U{}n.StringScalar=$,$.__name__="StringScalar";class E extends U{}n.NullStringScalar=E,E.__name__="NullStringScalar";class H extends U{}n.ArrayScalar=H,H.__name__="ArrayScalar";class j extends U{}n.LineJoinScalar=j,j.__name__="LineJoinScalar";class X extends U{}n.LineCapScalar=X,X.__name__="LineCapScalar";class Y extends U{}n.FontSizeScalar=Y,Y.__name__="FontSizeScalar";class I extends U{}n.FontStyleScalar=I,I.__name__="FontStyleScalar";class J extends U{}n.TextAlignScalar=J,J.__name__="TextAlignScalar";class V extends U{}n.TextBaselineScalar=V,V.__name__="TextBaselineScalar";class G extends v{get_value(){return null===this.spec.value?null:this.spec}_update(e){h(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)}array(e){var t;let n;const a=null!==(t=e.get_length())&&void 0!==t?t:1;if(null!=this.spec.field){const t=e.get_column(this.spec.field);if(null!=t)n=this.normalize(t);else{l.logger.warn(`attempted to retrieve property array for nonexistent field '${this.spec.field}'`);const e=new c.NumberArray(a);e.fill(NaN),n=e}}else if(null!=this.spec.expr)n=this.normalize(this.spec.expr.v_compute(e));else{const e=this.value(!1);if(p.isNumber(e)){const t=new c.NumberArray(a);t.fill(e),n=t}else n=_.repeat(e,a)}return null!=this.spec.transform&&(n=this.spec.transform.v_compute(n)),n}}n.VectorSpec=G,G.__name__="VectorSpec";class K extends G{}n.DataSpec=K,K.__name__="DataSpec";class Q extends G{_update(e){super._update(e);const{units:t}=this.spec;if(null!=t&&!_.includes(this.valid_units,t))throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${t}`)}get units(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:this.default_units}set units(e){e!=this.default_units?this.spec.units=e:delete this.spec.units}}n.UnitsSpec=Q,Q.__name__="UnitsSpec";class W extends Q{array(e){return new c.NumberArray(super.array(e))}}n.NumberUnitsSpec=W,W.__name__="NumberUnitsSpec";class Z extends K{}n.BaseCoordinateSpec=Z,Z.__name__="BaseCoordinateSpec";class ee extends Z{}n.CoordinateSpec=ee,ee.__name__="CoordinateSpec";class te extends Z{}n.CoordinateSeqSpec=te,te.__name__="CoordinateSeqSpec";class ne extends Z{}n.CoordinateSeqSeqSeqSpec=ne,ne.__name__="CoordinateSeqSeqSeqSpec";class ae extends ee{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSpec=ae,ae.__name__="XCoordinateSpec";class se extends ee{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSpec=se,se.__name__="YCoordinateSpec";class ie extends te{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSeqSpec=ie,ie.__name__="XCoordinateSeqSpec";class re extends te{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSeqSpec=re,re.__name__="YCoordinateSeqSpec";class le extends ne{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSeqSeqSeqSpec=le,le.__name__="XCoordinateSeqSeqSeqSpec";class oe extends ne{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSeqSeqSeqSpec=oe,oe.__name__="YCoordinateSeqSeqSeqSpec";class ce extends W{get default_units(){return"rad"}get valid_units(){return[...o.AngleUnits]}normalize(e){return"deg"==this.spec.units&&(e=u.map(e,e=>e*Math.PI/180)),e=u.map(e,e=>-e),super.normalize(e)}}n.AngleSpec=ce,ce.__name__="AngleSpec";class _e extends W{get default_units(){return"data"}get valid_units(){return[...o.SpatialUnits]}}n.DistanceSpec=_e,_e.__name__="DistanceSpec";class ue extends _e{get default_units(){return"screen"}}n.ScreenDistanceSpec=ue,ue.__name__="ScreenDistanceSpec";class de extends K{array(e){return new Uint8Array(super.array(e))}}n.BooleanSpec=de,de.__name__="BooleanSpec";class pe extends K{array(e){return new c.NumberArray(super.array(e))}}n.NumberSpec=pe,pe.__name__="NumberSpec";class Se extends K{array(e){const t=super.array(e),n=t.length,a=new c.ColorArray(n);for(let e=0;e<n;e++){const n=t[e];if(p.isNumber(n))a[e]=n;else{const t=d.color2rgba(n);a[e]=d.encode_rgba(t)}}return a}}n.ColorSpec=Se,Se.__name__="ColorSpec";class me extends K{}n.FontSizeSpec=me,me.__name__="FontSizeSpec";class he extends K{}n.MarkerSpec=he,he.__name__="MarkerSpec";class ve extends K{}n.StringSpec=ve,ve.__name__="StringSpec";class ge extends K{}n.NullStringSpec=ge,ge.__name__="NullStringSpec";class xe extends K{}n.NDArraySpec=xe,xe.__name__="NDArraySpec"},
function _(e,l,o,n,t){n();const s=e(8),g=e(13),r={};class i{constructor(e,l){this.name=e,this.level=l}}o.LogLevel=i,i.__name__="LogLevel";class v{constructor(e,l=v.INFO){this._name=e,this.set_level(l)}static get levels(){return Object.keys(v.log_levels)}static get(e,l=v.INFO){if(e.length>0){let o=r[e];return null==o&&(r[e]=o=new v(e,l)),o}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")}get level(){return this.get_level()}get_level(){return this._log_level}set_level(e){if(e instanceof i)this._log_level=e;else{if(!s.isString(e)||null==v.log_levels[e])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=v.log_levels[e]}const l=`[${this._name}]`;for(const[e,o]of g.entries(v.log_levels))o.level<this._log_level.level||this._log_level.level===v.OFF.level?this[e]=function(){}:this[e]=_(e,l)}trace(...e){}debug(...e){}info(...e){}warn(...e){}error(...e){}}function _(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}function c(e){const l=o.logger.level;return s.isString(e)&&null==v.log_levels[e]?(console.log(`[bokeh] unrecognized logging level '${e}' passed to Bokeh.set_log_level(), ignoring`),console.log("[bokeh] valid log levels are: "+v.levels.join(", "))):(console.log(`[bokeh] setting log level to: '${s.isString(e)?e:e.level}'`),o.logger.set_level(e)),l}o.Logger=v,v.__name__="Logger",v.TRACE=new i("trace",0),v.DEBUG=new i("debug",1),v.INFO=new i("info",2),v.WARN=new i("warn",6),v.ERROR=new i("error",7),v.FATAL=new i("fatal",8),v.OFF=new i("off",9),v.log_levels={trace:v.TRACE,debug:v.DEBUG,info:v.INFO,warn:v.WARN,error:v.ERROR,fatal:v.FATAL,off:v.OFF},o.logger=v.get("bokeh"),o.set_log_level=c,o.with_log_level=function(e,l){const o=c(e);try{l()}finally{c(o)}}},
function _(e,n,t,o,i){o();const a=e(21);t.Align=a.Enum("start","center","end"),t.Anchor=a.Enum("top_left","top_center","top_right","center_left","center","center_right","bottom_left","bottom_center","bottom_right"),t.AngleUnits=a.Enum("deg","rad"),t.BoxOrigin=a.Enum("corner","center"),t.ButtonType=a.Enum("default","primary","success","warning","danger"),t.CalendarPosition=a.Enum("auto","above","below"),t.Dimension=a.Enum("width","height"),t.Dimensions=a.Enum("width","height","both"),t.Direction=a.Enum("clock","anticlock"),t.Distribution=a.Enum("uniform","normal"),t.FontStyle=a.Enum("normal","italic","bold","bold italic"),t.HatchPatternType=a.Enum("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),t.HTTPMethod=a.Enum("POST","GET"),t.HexTileOrientation=a.Enum("pointytop","flattop"),t.HoverMode=a.Enum("mouse","hline","vline"),t.LatLon=a.Enum("lat","lon"),t.LegendClickPolicy=a.Enum("none","hide","mute"),t.LegendLocation=t.Anchor,t.LineCap=a.Enum("butt","round","square"),t.LineJoin=a.Enum("miter","round","bevel"),t.LinePolicy=a.Enum("prev","next","nearest","interp","none"),t.Location=a.Enum("above","below","left","right"),t.Logo=a.Enum("normal","grey"),t.MarkerType=a.Enum("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","triangle","triangle_dot","triangle_pin","x","y"),t.MutedPolicy=a.Enum("show","ignore"),t.Orientation=a.Enum("vertical","horizontal"),t.OutputBackend=a.Enum("canvas","svg","webgl"),t.PaddingUnits=a.Enum("percent","absolute"),t.Place=a.Enum("above","below","left","right","center"),t.PointPolicy=a.Enum("snap_to_data","follow_mouse","none"),t.RadiusDimension=a.Enum("x","y","max","min"),t.RenderLevel=a.Enum("image","underlay","glyph","guide","annotation","overlay"),t.RenderMode=a.Enum("canvas","css"),t.ResetPolicy=a.Enum("standard","event_only"),t.RoundingFunction=a.Enum("round","nearest","floor","rounddown","ceil","roundup"),t.SelectionMode=a.Enum("replace","append","intersect","subtract"),t.Side=a.Enum("above","below","left","right"),t.SizingMode=a.Enum("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"),t.Sort=a.Enum("ascending","descending"),t.SpatialUnits=a.Enum("screen","data"),t.StartEnd=a.Enum("start","end"),t.StepMode=a.Enum("after","before","center"),t.TapBehavior=a.Enum("select","inspect"),t.TextAlign=a.Enum("left","right","center"),t.TextBaseline=a.Enum("top","middle","bottom","alphabetic","hanging","ideographic"),t.TextureRepetition=a.Enum("repeat","repeat_x","repeat_y","no_repeat"),t.TickLabelOrientation=a.Enum("vertical","horizontal","parallel","normal"),t.TooltipAttachment=a.Enum("horizontal","vertical","left","right","above","below"),t.UpdateMode=a.Enum("replace","append"),t.VerticalAlign=a.Enum("top","middle","bottom")},
function _(e,n,t,s,r){s();const i=e(1).__importStar(e(8)),a=e(22),_=e(13),l=window.Map;class u{}t.Kind=u,u.__name__="Kind",function(e){class n extends u{valid(e){return!0}}n.__name__="Any",e.Any=n;class t extends u{valid(e){return!0}}t.__name__="Unknown",e.Unknown=t;class s extends u{valid(e){return i.isBoolean(e)}}s.__name__="Boolean",e.Boolean=s;class r extends u{constructor(e){super(),this.obj_type=e}valid(e){return!0}}r.__name__="Ref",e.Ref=r;class d extends u{valid(e){return!0}}d.__name__="AnyRef",e.AnyRef=d;class o extends u{valid(e){return i.isNumber(e)}}o.__name__="Number",e.Number=o;class c extends o{valid(e){return super.valid(e)&&i.isInteger(e)}}c.__name__="Int",e.Int=c;class p extends o{valid(e){return super.valid(e)&&0<=e&&e<=1}}p.__name__="Percent",e.Percent=p;class y extends u{constructor(e){super(),this.types=e,this.types=e}valid(e){return this.types.some(n=>n.valid(e))}}y.__name__="Or",e.Or=y;class m extends u{constructor(e){super(),this.types=e,this.types=e}valid(e){if(!i.isArray(e))return!1;for(let n=0;n<this.types.length;n++){const t=this.types[n],s=e[n];if(!t.valid(s))return!1}return!0}}m.__name__="Tuple",e.Tuple=m;class v extends u{constructor(e){super(),this.struct_type=e}valid(e){if(!i.isPlainObject(e))return!1;const{struct_type:n}=this;if(_.size(n)!=_.size(e))return!1;for(const t in n)if(n.hasOwnProperty(t)){if(!e.hasOwnProperty(t))return!1;const s=n[t],r=e[t];if(!s.valid(r))return!1}return!0}}v.__name__="Struct",e.Struct=v;class w extends u{valid(e){return i.isArray(e)||i.isTypedArray(e)}}w.__name__="Arrayable",e.Arrayable=w;class h extends u{constructor(e){super(),this.item_type=e}valid(e){return i.isArray(e)&&e.every(e=>this.item_type.valid(e))}}h.__name__="Array",e.Array=h;class f extends u{valid(e){return null===e}}f.__name__="Null",e.Null=f;class K extends u{constructor(e){super(),this.base_type=e}valid(e){return null===e||this.base_type.valid(e)}}K.__name__="Nullable",e.Nullable=K;class A extends u{constructor(e){super(),this.base_type=e}valid(e){return void 0===e||this.base_type.valid(e)}}A.__name__="Opt",e.Opt=A;class b extends u{valid(e){return i.isString(e)}}b.__name__="String",e.String=b;class x extends u{constructor(e){super(),this.values=new Set(e)}valid(e){return this.values.has(e)}*[Symbol.iterator](){yield*this.values}}x.__name__="Enum",e.Enum=x;class S extends u{constructor(e){super(),this.item_type=e}valid(e){if(!i.isPlainObject(e))return!1;for(const n in e)if(e.hasOwnProperty(n)){const t=e[n];if(!this.item_type.valid(t))return!1}return!0}}S.__name__="Dict",e.Dict=S;class N extends u{constructor(e,n){super(),this.key_type=e,this.item_type=n}valid(e){if(!(e instanceof l))return!1;for(const[n,t]of e.entries())if(!this.key_type.valid(n)||!this.item_type.valid(t))return!1;return!0}}N.__name__="Map",e.Map=N;class O extends u{valid(e){return i.isString(e)&&a.is_color(e)}}O.__name__="Color",e.Color=O;class g extends u{valid(e){return i.isFunction(e)}}g.__name__="Function",e.Function=g}(t.Kinds||(t.Kinds={})),t.Any=new t.Kinds.Any,t.Unknown=new t.Kinds.Unknown,t.Boolean=new t.Kinds.Boolean,t.Number=new t.Kinds.Number,t.Int=new t.Kinds.Int,t.String=new t.Kinds.String,t.Null=new t.Kinds.Null,t.Nullable=e=>new t.Kinds.Nullable(e),t.Opt=e=>new t.Kinds.Opt(e),t.Or=(...e)=>new t.Kinds.Or(e),t.Tuple=(...e)=>new t.Kinds.Tuple(e),t.Struct=e=>new t.Kinds.Struct(e),t.Arrayable=new t.Kinds.Arrayable,t.Array=e=>new t.Kinds.Array(e),t.Dict=e=>new t.Kinds.Dict(e),t.Map=(e,n)=>new t.Kinds.Map(e,n),t.Enum=(...e)=>new t.Kinds.Enum(e),t.Ref=e=>new t.Kinds.Ref(e),t.AnyRef=()=>new t.Kinds.AnyRef,t.Function=()=>new t.Kinds.Function,t.Percent=new t.Kinds.Percent,t.Alpha=t.Percent,t.Color=new t.Kinds.Color,t.Auto=t.Enum("auto"),t.FontSize=t.String,t.Font=t.String,t.Angle=t.Number},
function _(r,e,t,n,a){n();const l=r(23),o=r(9);function s(r){const e=Number(r).toString(16);return 1==e.length?"0"+e:e}function c(r){if(0==(r+="").indexOf("#"))return r;if(l.is_svg_color(r))return l.svg_colors[r];if(0==r.indexOf("rgb")){const e=r.replace(/^rgba?\(|\s+|\)$/g,"").split(",");let t=e.slice(0,3).map(s).join("");return 4==e.length&&(t+=s(Math.floor(255*parseFloat(e[3])))),"#"+t.slice(0,8)}return r}function i(r){let e;switch(r.substring(0,4)){case"rgba":e={start:"rgba(",len:4,alpha:!0};break;case"rgb(":e={start:"rgb(",len:3,alpha:!1};break;default:return!1}if(new RegExp(".*?(\\.).*(,)").test(r))return!1;const t=r.replace(e.start,"").replace(")","").split(",").map(parseFloat);return t.length==e.len&&((!e.alpha||0<=t[3]&&t[3]<=1)&&!o.includes(t.slice(0,3).map(r=>0<=r&&r<=255),!1))}t.is_color=function(r){return l.is_svg_color(r.toLowerCase())||"#"==r.substring(0,1)||i(r)},t.rgb2hex=function(r,e,t){return`#${s(255&r)}${s(255&e)}${s(255&t)}`},t.color2hex=c,t.encode_rgba=function([r,e,t,n]){return(255*r|0)<<24|(255*e|0)<<16|(255*t|0)<<8|255*n|0},t.decode_rgba=function(r){return[(r>>24&255)/255,(r>>16&255)/255,(r>>8&255)/255,(r>>0&255)/255]},t.color2rgba=function(r,e=1){if(!r)return[0,0,0,0];let t=c(r);t=t.replace(/ |#/g,""),t.length<=4&&(t=t.replace(/(.)/g,"$1$1"));const n=t.match(/../g).map(r=>parseInt(r,16)/255);for(;n.length<3;)n.push(0);return n.length<4&&n.push(e),n.slice(0,4)},t.valid_rgb=i},
function _(F,e,r,l,a){l(),r.svg_colors={indianred:"#CD5C5C",lightcoral:"#F08080",salmon:"#FA8072",darksalmon:"#E9967A",lightsalmon:"#FFA07A",crimson:"#DC143C",red:"#FF0000",firebrick:"#B22222",darkred:"#8B0000",pink:"#FFC0CB",lightpink:"#FFB6C1",hotpink:"#FF69B4",deeppink:"#FF1493",mediumvioletred:"#C71585",palevioletred:"#DB7093",coral:"#FF7F50",tomato:"#FF6347",orangered:"#FF4500",darkorange:"#FF8C00",orange:"#FFA500",gold:"#FFD700",yellow:"#FFFF00",lightyellow:"#FFFFE0",lemonchiffon:"#FFFACD",lightgoldenrodyellow:"#FAFAD2",papayawhip:"#FFEFD5",moccasin:"#FFE4B5",peachpuff:"#FFDAB9",palegoldenrod:"#EEE8AA",khaki:"#F0E68C",darkkhaki:"#BDB76B",lavender:"#E6E6FA",thistle:"#D8BFD8",plum:"#DDA0DD",violet:"#EE82EE",orchid:"#DA70D6",fuchsia:"#FF00FF",magenta:"#FF00FF",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",blueviolet:"#8A2BE2",darkviolet:"#9400D3",darkorchid:"#9932CC",darkmagenta:"#8B008B",purple:"#800080",indigo:"#4B0082",slateblue:"#6A5ACD",darkslateblue:"#483D8B",mediumslateblue:"#7B68EE",greenyellow:"#ADFF2F",chartreuse:"#7FFF00",lawngreen:"#7CFC00",lime:"#00FF00",limegreen:"#32CD32",palegreen:"#98FB98",lightgreen:"#90EE90",mediumspringgreen:"#00FA9A",springgreen:"#00FF7F",mediumseagreen:"#3CB371",seagreen:"#2E8B57",forestgreen:"#228B22",green:"#008000",darkgreen:"#006400",yellowgreen:"#9ACD32",olivedrab:"#6B8E23",olive:"#808000",darkolivegreen:"#556B2F",mediumaquamarine:"#66CDAA",darkseagreen:"#8FBC8F",lightseagreen:"#20B2AA",darkcyan:"#008B8B",teal:"#008080",aqua:"#00FFFF",cyan:"#00FFFF",lightcyan:"#E0FFFF",paleturquoise:"#AFEEEE",aquamarine:"#7FFFD4",turquoise:"#40E0D0",mediumturquoise:"#48D1CC",darkturquoise:"#00CED1",cadetblue:"#5F9EA0",steelblue:"#4682B4",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",lightblue:"#ADD8E6",skyblue:"#87CEEB",lightskyblue:"#87CEFA",deepskyblue:"#00BFFF",dodgerblue:"#1E90FF",cornflowerblue:"#6495ED",royalblue:"#4169E1",blue:"#0000FF",mediumblue:"#0000CD",darkblue:"#00008B",navy:"#000080",midnightblue:"#191970",cornsilk:"#FFF8DC",blanchedalmond:"#FFEBCD",bisque:"#FFE4C4",navajowhite:"#FFDEAD",wheat:"#F5DEB3",burlywood:"#DEB887",tan:"#D2B48C",rosybrown:"#BC8F8F",sandybrown:"#F4A460",goldenrod:"#DAA520",darkgoldenrod:"#B8860B",peru:"#CD853F",chocolate:"#D2691E",saddlebrown:"#8B4513",sienna:"#A0522D",brown:"#A52A2A",maroon:"#800000",white:"#FFFFFF",snow:"#FFFAFA",honeydew:"#F0FFF0",mintcream:"#F5FFFA",azure:"#F0FFFF",aliceblue:"#F0F8FF",ghostwhite:"#F8F8FF",whitesmoke:"#F5F5F5",seashell:"#FFF5EE",beige:"#F5F5DC",oldlace:"#FDF5E6",floralwhite:"#FFFAF0",ivory:"#FFFFF0",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lavenderblush:"#FFF0F5",mistyrose:"#FFE4E1",gainsboro:"#DCDCDC",lightgray:"#D3D3D3",lightgrey:"#D3D3D3",silver:"#C0C0C0",darkgray:"#A9A9A9",darkgrey:"#A9A9A9",gray:"#808080",grey:"#808080",dimgray:"#696969",dimgrey:"#696969",lightslategray:"#778899",lightslategrey:"#778899",slategray:"#708090",slategrey:"#708090",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",black:"#000000"},r.is_svg_color=function(F){return F in r.svg_colors}},
function _(r,a,t,i,n){i(),t.NumberArray=Float32Array,t.ColorArray=Uint32Array,n("Indices",r(25).BitSet)},
function _(t,s,r,e,i){e();const n=t(26),o=t(11);class a{constructor(t,s=0){this.size=t,this[Symbol.toStringTag]="BitSet",this._count=null,this._nwords=Math.ceil(t/32),0==s||1==s?(this._array=new Uint32Array(this._nwords),1==s&&this._array.fill(4294967295)):(o.assert(s.length==this._nwords,"Initializer size mismatch"),this._array=s)}clone(){return new a(this.size,new Uint32Array(this._array))}[n.equals](t,s){if(!s.eq(this.size,t.size))return!1;const{_nwords:r}=this,e=this.size%r,i=0==e?r:r-1;for(let s=0;s<i;s++)if(this._array[s]!=t._array[s])return!1;if(0==e)return!0;{const s=1<<e-1,r=s-1^s;return(this._array[i]&r)==(t._array[i]&r)}}static all_set(t){return new a(t,1)}static all_unset(t){return new a(t,0)}static from_indices(t,s){const r=new a(t);for(const t of s)r.set(t);return r}static from_booleans(t,s){const r=new a(t),e=Math.min(t,s.length);for(let t=0;t<e;t++)s[t]&&r.set(t);return r}_check_bounds(t){o.assert(0<=t&&t<this.size,`Out of bounds: 0 <= ${t} < ${this.size}`)}get(t){this._check_bounds(t);const s=t>>>5,r=31&t;return!!(this._array[s]>>r&1)}set(t,s=!0){this._check_bounds(t),this._count=null;const r=t>>>5,e=31&t;s?this._array[r]|=1<<e:this._array[r]&=~(1<<e)}unset(t){this.set(t,!1)}*[Symbol.iterator](){yield*this.ones()}get count(){let t=this._count;return null==t&&(this._count=t=this._get_count()),t}_get_count(){const{_array:t,_nwords:s,size:r}=this;let e=0;for(let i=0,n=0;n<s;n++){const s=t[n];if(0==s)i+=32;else for(let t=0;t<32&&i<r;t++,i++)s>>>t&1&&(e+=1)}return e}*ones(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(0!=s)for(let t=0;t<32&&e<r;t++,e++)s>>>t&1&&(yield e);else e+=32}}*zeros(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(4294967295!=s)for(let t=0;t<32&&e<r;t++,e++)s>>>t&1||(yield e);else e+=32}}_check_size(t){o.assert(this.size==t.size,"Size mismatch")}add(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]|=t._array[s]}intersect(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]&=t._array[s]}subtract(t){this._check_size(t);for(let s=0;s<this._nwords;s++){const r=this._array[s],e=t._array[s];this._array[s]=(r^e)&r}}union(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++)s._array[r]|=t._array[r];return s}intersection(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++)s._array[r]&=t._array[r];return s}difference(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++){const e=this._array[r],i=t._array[r];s._array[r]=(e^i)&e}return s}select(t){o.assert(this.size==t.length,"Size mismatch");const s=this.count,r=new t.constructor(s);let e=0;for(const s of this)r[e++]=t[s];return r}}r.BitSet=a,a.__name__="BitSet"},
function _(t,e,r,n,s){function o(t){return r.equals in Object(t)}n(),r.equals=Symbol("equals"),r.wildcard=Symbol("wildcard");const c=Object.prototype.toString;class a{constructor(){this.a_stack=[],this.b_stack=[]}eq(t,e){if(Object.is(t,e))return!0;if(t===r.wildcard||e===r.wildcard)return!0;if(null==t||null==e)return t===e;const n=c.call(t);if(n!=c.call(e))return!1;switch(n){case"[object Number]":return this.numbers(t,e);case"[object RegExp]":case"[object String]":return""+t==""+e;case"[object Date]":case"[object Boolean]":return+t==+e}const{a_stack:s,b_stack:a}=this;let i=s.length;for(;i--;)if(s[i]===t)return a[i]===e;s.push(t),a.push(e);const u=(()=>{if(o(t)&&o(e))return t[r.equals](e,this);switch(n){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return this.arrays(t,e);case"[object Map]":return this.maps(t,e);case"[object Set]":return this.sets(t,e);case"[object Object]":if(t.constructor==e.constructor&&(null==t.constructor||t.constructor===Object))return this.objects(t,e);case"[object Function]":if(t.constructor==e.constructor&&t.constructor===Function)return this.eq(""+t,""+e)}if(t instanceof Node)return this.nodes(t,e);throw Error("can't compare objects of type "+n)})();return s.pop(),a.pop(),u}numbers(t,e){return Object.is(t,e)}arrays(t,e){const{length:r}=t;if(r!=e.length)return!1;for(let n=0;n<r;n++)if(!this.eq(t[n],e[n]))return!1;return!0}iterables(t,e){const r=t[Symbol.iterator](),n=e[Symbol.iterator]();for(;;){const t=r.next(),e=n.next();if(t.done&&e.done)return!0;if(t.done||e.done)return!1;if(!this.eq(t.value,e.value))return!1}}maps(t,e){if(t.size!=e.size)return!1;for(const[r,n]of t)if(!e.has(r)||!this.eq(n,e.get(r)))return!1;return!0}sets(t,e){if(t.size!=e.size)return!1;for(const r of t)if(!e.has(r))return!1;return!0}objects(t,e){const r=Object.keys(t);if(r.length!=Object.keys(e).length)return!1;for(const n of r)if(!e.hasOwnProperty(n)||!this.eq(t[n],e[n]))return!1;return!0}nodes(t,e){return t.nodeType==e.nodeType&&(t.textContent==e.textContent&&!!this.iterables(t.childNodes,e.childNodes))}}r.Comparator=a,a.__name__="Comparator";const{abs:i}=Math;class u extends a{constructor(t=1e-4){super(),this.tolerance=t}numbers(t,e){return super.numbers(t,e)||i(t-e)<this.tolerance}}function l(t,e){return(new a).eq(t,e)}r.SimilarComparator=u,u.__name__="SimilarComparator",r.is_equal=l,r.is_similar=function(t,e,r){return new u(r).eq(t,e)},r.isEqual=l},
function _(t,e,s,n,_){n();class i{constructor(){this._dev=!1}set dev(t){this._dev=t}get dev(){return this._dev}}s.Settings=i,i.__name__="Settings",s.settings=new i},
function _(e,l,t,a,r){a();const c=e(1),o=c.__importStar(e(18)),n=e(20),i=c.__importStar(e(21));t.Line={line_color:[i.Nullable(i.Color),"black"],line_alpha:[i.Alpha,1],line_width:[i.Number,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[i.Array(i.Number),[]],line_dash_offset:[i.Number,0]},t.Fill={fill_color:[i.Nullable(i.Color),"gray"],fill_alpha:[i.Alpha,1]},t.Hatch={hatch_color:[i.Nullable(i.Color),"black"],hatch_alpha:[i.Alpha,1],hatch_scale:[i.Number,12],hatch_pattern:[i.Nullable(i.Or(n.HatchPatternType,i.String)),null],hatch_weight:[i.Number,1],hatch_extra:[i.Dict(i.AnyRef()),{}]},t.Text={text_color:[i.Nullable(i.Color),"#444444"],text_alpha:[i.Alpha,1],text_font:[o.Font,"helvetica"],text_font_size:[i.FontSize,"16px"],text_font_style:[n.FontStyle,"normal"],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[i.Number,1.2]},t.LineScalar={line_color:[o.ColorScalar,"black"],line_alpha:[o.NumberScalar,1],line_width:[o.NumberScalar,1],line_join:[o.LineJoinScalar,"bevel"],line_cap:[o.LineCapScalar,"butt"],line_dash:[o.ArrayScalar,[]],line_dash_offset:[o.NumberScalar,0]},t.FillScalar={fill_color:[o.ColorScalar,"gray"],fill_alpha:[o.NumberScalar,1]},t.HatchScalar={hatch_color:[o.ColorScalar,"black"],hatch_alpha:[o.NumberScalar,1],hatch_scale:[o.NumberScalar,12],hatch_pattern:[o.NullStringScalar,null],hatch_weight:[o.NumberScalar,1],hatch_extra:[o.AnyScalar,{}]},t.TextScalar={text_color:[o.ColorScalar,"#444444"],text_alpha:[o.NumberScalar,1],text_font:[o.Font,"helvetica"],text_font_size:[o.FontSizeScalar,"16px"],text_font_style:[o.FontStyleScalar,"normal"],text_align:[o.TextAlignScalar,"left"],text_baseline:[o.TextBaselineScalar,"bottom"],text_line_height:[o.NumberScalar,1.2]},t.LineVector={line_color:[o.ColorSpec,"black"],line_alpha:[o.NumberSpec,1],line_width:[o.NumberSpec,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[i.Array(i.Number),[]],line_dash_offset:[i.Number,0]},t.FillVector={fill_color:[o.ColorSpec,"gray"],fill_alpha:[o.NumberSpec,1]},t.HatchVector={hatch_color:[o.ColorSpec,"black"],hatch_alpha:[o.NumberSpec,1],hatch_scale:[o.NumberSpec,12],hatch_pattern:[o.NullStringSpec,null],hatch_weight:[o.NumberSpec,1],hatch_extra:[i.Dict(i.AnyRef()),{}]},t.TextVector={text_color:[o.ColorSpec,"#444444"],text_alpha:[o.NumberSpec,1],text_font:[o.Font,"helvetica"],text_font_size:[o.FontSizeSpec,"16px"],text_font_style:[n.FontStyle,"normal"],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[i.Number,1.2]}},
function _(t,e,r,n,u){n();const c=t(27);function s(){const t=new Array(32),e="0123456789ABCDEF";for(let r=0;r<32;r++)t[r]=e.substr(Math.floor(16*Math.random()),1);return t[12]="4",t[16]=e.substr(3&t[16].charCodeAt(0)|8,1),t.join("")}r.startsWith=function(t,e,r=0){return t.substr(r,e.length)==e},r.uuid4=s;let a=1e3;r.uniqueId=function(t){const e=c.settings.dev?"j"+a++:s();return null!=t?`${t}-${e}`:e},r.escape=function(t){return t.replace(/(?:[&<>"'`])/g,t=>{switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return t}})},r.unescape=function(t){return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,(t,e)=>{switch(e){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return e}})},r.use_strict=function(t){return"'use strict';\n"+t},r.to_fixed=function(t,e){return t.toFixed(e).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"")}},
function _(e,r,i,t,s){t();const n=e(11),a=e(13),l=e(8);i.serialize=Symbol("serialize");class o extends Error{}i.SerializationError=o,o.__name__="SerializationError";class _{constructor(e){var r;this._references=new Map,this._definitions=new Map,this._refmap=new Map,this.include_defaults=null===(r=null==e?void 0:e.include_defaults)||void 0===r||r}add_ref(e,r){this._references.set(e,r)}add_def(e,r){const i=this._references.get(e);n.assert(null!=i),this._definitions.set(e,r),this._refmap.set(i,r)}get objects(){return new Set(this._references.keys())}get references(){return new Set(this._references.values())}get definitions(){return new Set(this._definitions.values())}resolve_ref(e){return this._refmap.get(e)}remove_ref(e){return this._references.delete(e)}remove_def(e){return this._definitions.delete(e)}to_serializable(e){if(function(e){return i.serialize in Object(e)}(e))return e[i.serialize](this);if(l.isArray(e)||l.isTypedArray(e)){const r=e.length,i=new Array(r);for(let t=0;t<r;t++){const r=e[t];i[t]=this.to_serializable(r)}return i}if(l.isPlainObject(e)){const r={};for(const[i,t]of a.entries(e))r[i]=this.to_serializable(t);return r}if(null===e||l.isBoolean(e)||l.isNumber(e)||l.isString(e))return e;throw new o(Object.prototype.toString.call(e)+" is not serializable")}}i.Serializer=_,_.__name__="Serializer"},
function _(t,r,n,i,e){i();const s=t(8),o=t(13);n.pretty=Symbol("pretty");class c{constructor(t){this.precision=null==t?void 0:t.precision}to_string(t){return function(t){return n.pretty in Object(t)}(t)?t[n.pretty](this):s.isBoolean(t)?this.boolean(t):s.isNumber(t)?this.number(t):s.isString(t)?this.string(t):s.isArray(t)?this.array(t):s.isIterable(t)?this.iterable(t):s.isPlainObject(t)?this.object(t):""+t}token(t){return t}boolean(t){return""+t}number(t){return null!=this.precision?t.toFixed(this.precision):""+t}string(t){return`"${t.replace(/'/g,"\\'")}"`}array(t){const r=this.token,n=[];for(const r of t)n.push(this.to_string(r));return`${r("[")}${n.join(r(",")+" ")}${r("]")}`}iterable(t){var r;const n=this.token,i=null!==(r=Object(t)[Symbol.toStringTag])&&void 0!==r?r:"Object",e=this.array(t);return`${i}${n("(")}${e}${n(")")}`}object(t){const r=this.token,n=[];for(const[i,e]of o.entries(t))n.push(`${i}${r(":")} ${this.to_string(e)}`);return`${r("{")}${n.join(r(",")+" ")}${r("}")}`}}n.Printer=c,c.__name__="Printer",n.to_string=function(t,r){return new c(r).to_string(t)}},
function _(n,o,r,e,t){e();const l=n(13),c=n(8);function i(n){return r.clone in Object(n)}r.clone=Symbol("clone"),r.is_Cloneable=i;class s extends Error{}r.CloningError=s,s.__name__="CloningError";class a{constructor(){}clone(n){if(i(n))return n[r.clone](this);if(c.isArray(n)){const o=n.length,r=new Array(o);for(let e=0;e<o;e++){const o=n[e];r[e]=this.clone(o)}return r}if(c.isPlainObject(n)){const o={};for(const[r,e]of l.entries(n))o[r]=this.clone(e);return o}if(null===n||c.isBoolean(n)||c.isNumber(n)||c.isString(n))return n;throw new s(Object.prototype.toString.call(n)+" is not cloneable")}}r.Cloner=a,a.__name__="Cloner"},
function _(t,_,r,o,a){o();const e=t(1);e.__exportStar(t(34),r),e.__exportStar(t(204),r),e.__exportStar(t(231),r),e.__exportStar(t(235),r),e.__exportStar(t(247),r),e.__exportStar(t(251),r),e.__exportStar(t(256),r),e.__exportStar(t(260),r),e.__exportStar(t(293),r),e.__exportStar(t(295),r),e.__exportStar(t(297),r),e.__exportStar(t(148),r),e.__exportStar(t(160),r),e.__exportStar(t(313),r),e.__exportStar(t(317),r),e.__exportStar(t(327),r),e.__exportStar(t(328),r),e.__exportStar(t(329),r),e.__exportStar(t(330),r),e.__exportStar(t(331),r),e.__exportStar(t(336),r),e.__exportStar(t(338),r),e.__exportStar(t(349),r),e.__exportStar(t(353),r)},
function _(e,o,n,a,t){a(),t("Annotation",e(35).Annotation),t("Arrow",e(90).Arrow),t("ArrowHead",e(91).ArrowHead),t("OpenHead",e(91).OpenHead),t("NormalHead",e(91).NormalHead),t("TeeHead",e(91).TeeHead),t("VeeHead",e(91).VeeHead),t("Band",e(134).Band),t("BoxAnnotation",e(136).BoxAnnotation),t("ColorBar",e(137).ColorBar),t("Label",e(172).Label),t("LabelSet",e(174).LabelSet),t("Legend",e(175).Legend),t("LegendItem",e(176).LegendItem),t("PolyAnnotation",e(178).PolyAnnotation),t("Slope",e(179).Slope),t("Span",e(180).Span),t("TextAnnotation",e(173).TextAnnotation),t("Title",e(181).Title),t("ToolbarPanel",e(182).ToolbarPanel),t("Tooltip",e(200).Tooltip),t("Whisker",e(203).Whisker)},
function _(t,e,n,s,i){s();const o=t(1).__importStar(t(36)),_=t(13),a=t(69);class r extends a.RendererView{get panel(){return this.layout}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.visible,()=>this.plot_view.request_layout())}get_size(){if(this.model.visible){const{width:t,height:e}=this._get_size();return{width:Math.round(t),height:Math.round(e)}}return{width:0,height:0}}_get_size(){throw new Error("not implemented")}set_data(t){const e=this.model.materialize_dataspecs(t);if(_.extend(this,e),this.plot_model.use_map){const t=this;null!=t._x&&([t._x,t._y]=o.project_xy(t._x,t._y)),null!=t._xs&&([t._xs,t._ys]=o.project_xsys(t._xs,t._ys))}}get needs_clip(){return null==this.layout}serializable_state(){const t=super.serializable_state();return null==this.layout?t:Object.assign(Object.assign({},t),{bbox:this.layout.bbox.box})}}n.AnnotationView=r,r.__name__="AnnotationView";class l extends a.Renderer{constructor(t){super(t)}static init_Annotation(){this.override({level:"annotation"})}}n.Annotation=l,l.__name__="Annotation",l.init_Annotation()},
function _(n,t,e,r,o){r();const c=n(1),l=c.__importDefault(n(37)),i=c.__importDefault(n(38)),u=n(24),a=new i.default("GOOGLE"),s=new i.default("WGS84"),f=l.default(s,a);e.wgs84_mercator={compute:(n,t)=>isFinite(n)&&isFinite(t)?f.forward([n,t]):[NaN,NaN],invert:(n,t)=>isFinite(n)&&isFinite(t)?f.inverse([n,t]):[NaN,NaN]};const _={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},p={lon:[-180,180],lat:[-85.06,85.06]},{min:m,max:g}=Math;function N(n,t){const r=m(n.length,t.length),o=new u.NumberArray(r),c=new u.NumberArray(r);return e.inplace.project_xy(n,t,o,c),[o,c]}e.clip_mercator=function(n,t,e){const[r,o]=_[e];return[g(n,r),m(t,o)]},e.in_bounds=function(n,t){const[e,r]=p[t];return e<n&&n<r},function(n){function t(n,t,r,o){const c=m(n.length,t.length);r=null!=r?r:n,o=null!=o?o:t;for(let l=0;l<c;l++){const c=n[l],i=t[l],[u,a]=e.wgs84_mercator.compute(c,i);r[l]=u,o[l]=a}}n.project_xy=t,n.project_xsys=function(n,e,r,o){const c=m(n.length,e.length);r=null!=r?r:n,o=null!=o?o:e;for(let l=0;l<c;l++)t(n[l],e[l],r[l],o[l])}}(e.inplace||(e.inplace={})),e.project_xy=N,e.project_xsys=function(n,t){const e=m(n.length,t.length),r=new Array(e),o=new Array(e);for(let c=0;c<e;c++){const[e,l]=N(n[c],t[c]);r[c]=e,o[c]=l}return[r,o]}},
function _(e,n,t,r,o){r();const a=e(1),i=a.__importDefault(e(38)),c=a.__importDefault(e(63));var u=i.default("WGS84");function f(e,n,t){var r,o,a;return Array.isArray(t)?(r=c.default(e,n,t)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof r.z?[r.x,r.y,r.z].concat(t.splice(3)):[r.x,r.y,t[2]].concat(t.splice(3)):[r.x,r.y].concat(t.splice(2)):[r.x,r.y]):(o=c.default(e,n,t),2===(a=Object.keys(t)).length||a.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;o[r]=t[r]})),o)}function l(e){return e instanceof i.default?e:e.oProj?e.oProj:i.default(e)}t.default=function(e,n,t){e=l(e);var r,o=!1;return void 0===n?(n=e,e=u,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=u,o=!0),n=l(n),t?f(e,n,t):(r={forward:function(t){return f(e,n,t)},inverse:function(t){return f(n,e,t)}},o&&(r.oProj=n),r)}},
function _(t,e,a,s,i){s();const u=t(1),l=u.__importDefault(t(39)),o=u.__importDefault(t(50)),r=u.__importDefault(t(51)),f=t(59),p=u.__importDefault(t(61)),d=u.__importDefault(t(62)),m=u.__importDefault(t(46));function n(t,e){if(!(this instanceof n))return new n(t);e=e||function(t){if(t)throw t};var a=l.default(t);if("object"==typeof a){var s=n.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var i=m.default(p.default,a.datumCode);i&&(a.datum_params=i.towgs84?i.towgs84.split(","):null,a.ellps=i.ellipse,a.datumName=i.datumName?i.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84";var u=f.sphere(a.a,a.b,a.rf,a.ellps,a.sphere),r=f.eccentricity(u.a,u.b,u.rf,a.R_A),h=a.datum||d.default(a.datumCode,a.datum_params,u.a,u.b,r.es,r.ep2);o.default(this,a),o.default(this,s),this.a=u.a,this.b=u.b,this.rf=u.rf,this.sphere=u.sphere,this.es=r.es,this.e=r.e,this.ep2=r.ep2,this.datum=h,this.init(),e(null,this)}else e(t)}else e(t)}n.projections=r.default,n.projections.start(),a.default=n},
function _(t,r,n,u,e){u();const f=t(1),i=f.__importDefault(t(40)),a=f.__importDefault(t(47)),o=f.__importDefault(t(42)),l=f.__importDefault(t(46));var C=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var d=["3857","900913","3785","102113"];n.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in i.default}(t))return i.default[t];if(function(t){return C.some((function(r){return t.indexOf(r)>-1}))}(t)){var r=a.default(t);if(function(t){var r=l.default(t,"authority");if(r){var n=l.default(r,"epsg");return n&&d.indexOf(n)>-1}}(r))return i.default["EPSG:3857"];var n=function(t){var r=l.default(t,"extension");if(r)return l.default(r,"proj4")}(r);return n?o.default(n):r}return function(t){return"+"===t[0]}(t)?o.default(t):void 0}},
function _(t,r,i,e,n){e();const f=t(1),a=f.__importDefault(t(41)),l=f.__importDefault(t(42)),u=f.__importDefault(t(47));function o(t){var r=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?o[t]=l.default(arguments[1]):o[t]=u.default(arguments[1]):o[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?o.apply(r,t):o(t)}));if("string"==typeof t){if(t in o)return o[t]}else"EPSG"in t?o["EPSG:"+t.EPSG]=t:"ESRI"in t?o["ESRI:"+t.ESRI]=t:"IAU2000"in t?o["IAU2000:"+t.IAU2000]=t:console.log(t);return}}a.default(o),i.default=o},
function _(t,l,G,S,e){S(),G.default=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},
function _(t,n,o,a,u){a();const e=t(1),r=t(43),i=e.__importDefault(t(44)),f=e.__importDefault(t(45)),l=e.__importDefault(t(46));o.default=function(t){var n,o,a,u={},e=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){u.rf=parseFloat(t)},lat_0:function(t){u.lat0=t*r.D2R},lat_1:function(t){u.lat1=t*r.D2R},lat_2:function(t){u.lat2=t*r.D2R},lat_ts:function(t){u.lat_ts=t*r.D2R},lon_0:function(t){u.long0=t*r.D2R},lon_1:function(t){u.long1=t*r.D2R},lon_2:function(t){u.long2=t*r.D2R},alpha:function(t){u.alpha=parseFloat(t)*r.D2R},lonc:function(t){u.longc=t*r.D2R},x_0:function(t){u.x0=parseFloat(t)},y_0:function(t){u.y0=parseFloat(t)},k_0:function(t){u.k0=parseFloat(t)},k:function(t){u.k0=parseFloat(t)},a:function(t){u.a=parseFloat(t)},b:function(t){u.b=parseFloat(t)},r_a:function(){u.R_A=!0},zone:function(t){u.zone=parseInt(t,10)},south:function(){u.utmSouth=!0},towgs84:function(t){u.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){u.to_meter=parseFloat(t)},units:function(t){u.units=t;var n=l.default(f.default,t);n&&(u.to_meter=n.to_meter)},from_greenwich:function(t){u.from_greenwich=t*r.D2R},pm:function(t){var n=l.default(i.default,t);u.from_greenwich=(n||parseFloat(t))*r.D2R},nadgrids:function(t){"@null"===t?u.datumCode="none":u.nadgrids=t},axis:function(t){var n="ewnsud";3===t.length&&-1!==n.indexOf(t.substr(0,1))&&-1!==n.indexOf(t.substr(1,1))&&-1!==n.indexOf(t.substr(2,1))&&(u.axis=t)}};for(n in e)o=e[n],n in c?"function"==typeof(a=c[n])?a(o):u[a]=o:u[n]=o;return"string"==typeof u.datumCode&&"WGS84"!==u.datumCode&&(u.datumCode=u.datumCode.toLowerCase()),u}},
function _(P,A,_,D,I){D(),_.PJD_3PARAM=1,_.PJD_7PARAM=2,_.PJD_WGS84=4,_.PJD_NODATUM=5,_.SEC_TO_RAD=484813681109536e-20,_.HALF_PI=Math.PI/2,_.SIXTH=.16666666666666666,_.RA4=.04722222222222222,_.RA6=.022156084656084655,_.EPSLN=1e-10,_.D2R=.017453292519943295,_.R2D=57.29577951308232,_.FORTPI=Math.PI/4,_.TWO_PI=2*Math.PI,_.SPI=3.14159265359},
function _(o,r,a,e,s){e();var n={};a.default=n,n.greenwich=0,n.lisbon=-9.131906111111,n.paris=2.337229166667,n.bogota=-74.080916666667,n.madrid=-3.687938888889,n.rome=12.452333333333,n.bern=7.439583333333,n.jakarta=106.807719444444,n.ferro=-17.666666666667,n.brussels=4.367975,n.stockholm=18.058277777778,n.athens=23.7163375,n.oslo=10.722916666667},
function _(t,e,f,o,u){o(),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t,a,n){a();var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,t,a,o,d){o();const r=e(1);const n=r.__importDefault(e(48)),l=e(49);function i(e){return.017453292519943295*e}a.default=function(e){var t=n.default(e),a=t.shift(),o=t.shift();t.unshift(["name",o]),t.unshift(["type",a]);var d={};return l.sExpr(t,d),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var t="",a=0,o=e.AXIS.length;a<o;++a){var d=e.AXIS[a][0].toLowerCase();-1!==d.indexOf("north")?t+="n":-1!==d.indexOf("south")?t+="s":-1!==d.indexOf("east")?t+="e":-1!==d.indexOf("west")&&(t+="w")}2===t.length&&(t+="u"),3===t.length&&(e.axis=t)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function n(t){return t*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",i],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",i],["x0","false_easting",n],["y0","false_northing",n],["long0","central_meridian",i],["lat0","latitude_of_origin",i],["lat0","standard_parallel_1",i],["lat1","standard_parallel_1",i],["lat2","standard_parallel_2",i],["azimuth","Azimuth"],["alpha","azimuth",i],["srsCode","name"]].forEach((function(t){return a=e,d=(o=t)[0],r=o[1],void(!(d in a)&&r in a&&(a[d]=a[r],3===o.length&&(a[d]=o[2](a[d]))));var a,o,d,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=i(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(d),d}},
function _(t,e,r,i,s){i(),r.default=function(t){return new d(t).output()};var h=/\s/,o=/[A-Za-z]/,n=/[A-Za-z84]/,a=/[,\]]/,u=/[\d\.E\-\+]/;function d(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}d.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;h.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},d.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(a.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},d.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},d.prototype.number=function(t){if(!u.test(t)){if(a.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},d.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},d.prototype.keyword=function(t){if(n.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!a.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},d.prototype.neutral=function(t){if(o.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(u.test(t))return this.word=t,void(this.state=3);if(!a.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},d.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,a,r,s,c){function n(e,a,r){Array.isArray(a)&&(r.unshift(a),a=null);var s=a?{}:e,c=r.reduce((function(e,a){return E(a,e),e}),s);a&&(e[a]=c)}function E(e,a){if(Array.isArray(e)){var r=e.shift();if("PARAMETER"===r&&(r=e.shift()),1===e.length)return Array.isArray(e[0])?(a[r]={},void E(e[0],a[r])):void(a[r]=e[0]);if(e.length)if("TOWGS84"!==r){if("AXIS"===r)return r in a||(a[r]=[]),void a[r].push(e);var s;switch(Array.isArray(r)||(a[r]={}),r){case"UNIT":case"PRIMEM":case"VERT_DATUM":return a[r]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&E(e[2],a[r]));case"SPHEROID":case"ELLIPSOID":return a[r]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&E(e[3],a[r]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void n(a,r,e);default:for(s=-1;++s<e.length;)if(!Array.isArray(e[s]))return E(e,a[r]);return n(a,r,e)}}else a[r]=e;else a[r]=!0}else a[e]=!0}s(),r.sExpr=E},
function _(n,r,f,i,t){i(),f.default=function(n,r){var f,i;if(n=n||{},!r)return n;for(i in r)void 0!==(f=r[i])&&(n[i]=f);return n}},
function _(t,o,a,e,n){e();const r=t(1),f=r.__importDefault(t(52)),u=r.__importDefault(t(58));var i=[f.default,u.default],c={},d=[];function s(t,o){var a=d.length;return t.names?(d[a]=t,t.names.forEach((function(t){c[t.toLowerCase()]=a})),this):(console.log(o),!0)}function l(t){if(!t)return!1;var o=t.toLowerCase();return void 0!==c[o]&&d[c[o]]?d[c[o]]:void 0}function v(){i.forEach(s)}a.add=s,a.get=l,a.start=v,a.default={start:v,add:s,get:l}},
function _(t,i,s,h,a){h();const e=t(1),r=e.__importDefault(t(53)),n=e.__importDefault(t(54)),l=e.__importDefault(t(56)),u=e.__importDefault(t(57)),o=t(43);function f(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=r.default(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function _(t){var i,s,h=t.x,a=t.y;if(a*o.R2D>90&&a*o.R2D<-90&&h*o.R2D>180&&h*o.R2D<-180)return null;if(Math.abs(Math.abs(a)-o.HALF_PI)<=o.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*n.default(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(o.FORTPI+.5*a));else{var e=Math.sin(a),r=l.default(this.e,a,e);i=this.x0+this.a*this.k0*n.default(h-this.long0),s=this.y0-this.a*this.k0*Math.log(r)}return t.x=i,t.y=s,t}function M(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=o.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var e=Math.exp(-a/(this.a*this.k0));if(-9999===(s=u.default(this.e,e)))return null}return i=n.default(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=f,s.forward=_,s.inverse=M,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:f,forward:_,inverse:M,names:s.names}},
function _(t,n,r,u,a){u(),r.default=function(t,n,r){var u=t*n;return r/Math.sqrt(1-u*u)}},
function _(t,n,u,a,f){a();const e=t(1),o=t(43),_=e.__importDefault(t(55));u.default=function(t){return Math.abs(t)<=o.SPI?t:t-_.default(t)*o.TWO_PI}},
function _(n,t,u,f,c){f(),u.default=function(n){return n<0?-1:1}},
function _(t,n,a,o,u){o();const c=t(43);a.default=function(t,n,a){var o=t*a,u=.5*t;return o=Math.pow((1-o)/(1+o),u),Math.tan(.5*(c.HALF_PI-n))/o}},
function _(t,a,n,r,f){r();const h=t(43);n.default=function(t,a){for(var n,r,f=.5*t,o=h.HALF_PI-2*Math.atan(a),u=0;u<=15;u++)if(n=t*Math.sin(o),o+=r=h.HALF_PI-2*Math.atan(a*Math.pow((1-n)/(1+n),f))-o,Math.abs(r)<=1e-10)return o;return-9999}},
function _(n,i,e,t,r){function a(){}function f(n){return n}t(),e.init=a,e.forward=f,e.inverse=f,e.names=["longlat","identity"],e.default={init:a,forward:f,inverse:f,names:e.names}},
function _(t,r,e,a,n){a();const f=t(1),i=t(43),u=f.__importStar(t(60)),c=f.__importDefault(t(46));e.eccentricity=function(t,r,e,a){var n=t*t,f=r*r,u=(n-f)/n,c=0;return a?(n=(t*=1-u*(i.SIXTH+u*(i.RA4+u*i.RA6)))*t,u=0):c=Math.sqrt(u),{es:u,e:c,ep2:(n-f)/f}},e.sphere=function(t,r,e,a,n){if(!t){var f=c.default(u.default,a);f||(f=u.WGS84),t=f.a,r=f.b,e=f.rf}return e&&!r&&(r=(1-1/e)*t),(0===e||Math.abs(t-r)<i.EPSLN)&&(n=!0,r=t),{a:t,b:r,rf:e,sphere:n}}},
function _(e,a,l,s,r){s();var i={};l.default=i,i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s,t,l){t();var m={};s.default=m,m.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},m.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},m.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},m.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},m.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},m.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},m.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},m.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},m.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},m.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},m.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},m.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},m.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},m.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},m.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},m.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},m.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_,t,u){t();const p=a(43);_.default=function(a,m,_,t,u,d){var r={};return r.datum_type=void 0===a||"none"===a?p.PJD_NODATUM:p.PJD_WGS84,m&&(r.datum_params=m.map(parseFloat),0===r.datum_params[0]&&0===r.datum_params[1]&&0===r.datum_params[2]||(r.datum_type=p.PJD_3PARAM),r.datum_params.length>3&&(0===r.datum_params[3]&&0===r.datum_params[4]&&0===r.datum_params[5]&&0===r.datum_params[6]||(r.datum_type=p.PJD_7PARAM,r.datum_params[3]*=p.SEC_TO_RAD,r.datum_params[4]*=p.SEC_TO_RAD,r.datum_params[5]*=p.SEC_TO_RAD,r.datum_params[6]=r.datum_params[6]/1e6+1))),r.a=_,r.b=t,r.es=u,r.ep2=d,r}},
function _(t,e,a,r,u){r();const m=t(1),_=t(43),o=m.__importDefault(t(64)),d=m.__importDefault(t(66)),f=m.__importDefault(t(38)),n=m.__importDefault(t(67)),i=m.__importDefault(t(68));a.default=function t(e,a,r){var u;if(Array.isArray(r)&&(r=n.default(r)),i.default(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===_.PJD_3PARAM||t.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==e.datumCode||(e.datum.datum_type===_.PJD_3PARAM||e.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==t.datumCode}(e,a)&&(r=t(e,u=new f.default("WGS84"),r),e=u),"enu"!==e.axis&&(r=d.default(e,!1,r)),"longlat"===e.projName)r={x:r.x*_.D2R,y:r.y*_.D2R,z:r.z||0};else if(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),!(r=e.inverse(r)))return;return e.from_greenwich&&(r.x+=e.from_greenwich),r=o.default(e.datum,a.datum,r),a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*_.R2D,y:r.y*_.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),"enu"!==a.axis?d.default(a,!0,r):r}},
function _(t,e,a,u,c){u();const m=t(43),o=t(65);function _(t){return t===m.PJD_3PARAM||t===m.PJD_7PARAM}a.default=function(t,e,a){return o.compareDatums(t,e)||t.datum_type===m.PJD_NODATUM||e.datum_type===m.PJD_NODATUM?a:t.es!==e.es||t.a!==e.a||_(t.datum_type)||_(e.datum_type)?(a=o.geodeticToGeocentric(a,t.es,t.a),_(t.datum_type)&&(a=o.geocentricToWgs84(a,t.datum_type,t.datum_params)),_(e.datum_type)&&(a=o.geocentricFromWgs84(a,e.datum_type,e.datum_params)),o.geocentricToGeodetic(a,e.es,e.a,e.b)):a}},
function _(a,t,r,m,s){m();const u=a(43);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===u.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==u.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,s,_,e,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-u.HALF_PI&&d>-1.001*u.HALF_PI)d=-u.HALF_PI;else if(d>u.HALF_PI&&d<1.001*u.HALF_PI)d=u.HALF_PI;else{if(d<-u.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>u.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),s=Math.sin(d),e=Math.cos(d),_=s*s,{x:((m=r/Math.sqrt(1-t*_))+i)*e*Math.cos(n),y:(m+i)*e*Math.sin(n),z:(m*(1-t)+i)*s}},r.geocentricToGeodetic=function(a,t,r,m){var s,_,e,n,d,i,p,P,y,z,M,o,A,c,x,h=1e-12,f=a.x,I=a.y,F=a.z?a.z:0;if(s=Math.sqrt(f*f+I*I),_=Math.sqrt(f*f+I*I+F*F),s/r<h){if(c=0,_/r<h)return u.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(I,f);e=F/_,P=(n=s/_)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),y=e*d,A=0;do{A++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(x=s*P+F*y-p*(1-t*y*y))),o=(M=e*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(z=n*(1-i)*d)*y,P=z,y=M}while(o*o>1e-24&&A<30);return{x:c,y:Math.atan(M/Math.abs(z)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-e*a.z)+s,z:i*(-n*a.x+e*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-s)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+e*y,z:n*p-e*P+y}}}},
function _(e,a,i,s,n){s(),i.default=function(e,a,i){var s,n,c,r=i.x,d=i.y,f=i.z||0,u={};for(c=0;c<3;c++)if(!a||2!==c||void 0!==i.z)switch(0===c?(s=r,n=-1!=="ew".indexOf(e.axis[c])?"x":"y"):1===c?(s=d,n=-1!=="ns".indexOf(e.axis[c])?"y":"x"):(s=f,n="z"),e.axis[c]){case"e":case"w":case"n":case"s":u[n]=s;break;case"u":void 0!==i[n]&&(u.z=s);break;case"d":void 0!==i[n]&&(u.z=-s);break;default:return null}return u}},
function _(n,t,e,u,f){u(),e.default=function(n){var t={x:n[0],y:n[1]};return n.length>2&&(t.z=n[2]),n.length>3&&(t.m=n[3]),t}},
function _(e,i,n,t,r){function o(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}t(),n.default=function(e){o(e.x),o(e.y)}},
function _(e,i,t,n,r){n();const s=e(1),_=e(70),a=s.__importStar(e(73)),o=e(20),l=e(88),d=e(89);class h extends _.View{get coordinates(){return this._coordinates}initialize(){super.initialize(),this.visuals=new a.Visuals(this.model),this.needs_webgl_blit=!1,this._initialize_coordinates()}connect_signals(){super.connect_signals();const{x_range_name:e,y_range_name:i}=this.model.properties;this.on_change([e,i],()=>this._initialize_coordinates())}_initialize_coordinates(){const{x_range_name:e,y_range_name:i}=this.model,{frame:t}=this.plot_view,n=t.x_scales.get(e),r=t.y_scales.get(i);this._coordinates=new d.CoordinateTransform(n,r)}get plot_view(){return this.parent}get plot_model(){return this.parent.model}get layer(){const{overlays:e,primary:i}=this.plot_view.canvas_view;return"overlay"==this.model.level?e:i}request_render(){this.plot_view.request_render()}notify_finished(){this.plot_view.notify_finished()}get needs_clip(){return!1}get has_webgl(){return!1}render(){this.model.visible&&this._render(),this._has_finished=!0}renderer_view(e){}}t.RendererView=h,h.__name__="RendererView";class c extends l.Model{constructor(e){super(e)}static init_Renderer(){this.define(({Boolean:e,String:i})=>({level:[o.RenderLevel,"image"],visible:[e,!0],x_range_name:[i,"default"],y_range_name:[i,"default"]}))}}t.Renderer=c,c.__name__="Renderer",c.init_Renderer()},
function _(t,e,s,i,n){i();const r=t(1),o=t(15),h=t(71),l=t(8),a=r.__importDefault(t(72));class _{constructor(t){this.removed=new o.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),this._slots=new WeakMap;const{model:e,parent:s}=t;this.model=e,this.parent=s,this.root=null==s?this:s.root,this.removed.emit()}get ready(){return this._ready}connect(t,e){let s=this._slots.get(e);return null==s&&(s=(t,s)=>{const i=Promise.resolve(e.call(this,t,s));this._ready=this._ready.then(()=>i)},this._slots.set(e,s)),t.connect(s,this)}disconnect(t,e){return t.disconnect(e,this)}initialize(){this._has_finished=!1,this.is_root&&(this._stylesheet=h.stylesheet);for(const t of this.styles())this.stylesheet.append(t)}async lazy_initialize(){}remove(){this.disconnect_signals(),this.removed.emit()}toString(){return`${this.model.type}View(${this.model.id})`}serializable_state(){return{type:this.model.type}}get is_root(){return null==this.parent}assert_root(){if(!this.is_root)throw new Error(this.toString()+" is not a root layout")}has_finished(){return this._has_finished}get is_idle(){return this.has_finished()}connect_signals(){}disconnect_signals(){o.Signal.disconnect_receiver(this)}on_change(t,e){for(const s of l.isArray(t)?t:[t])this.connect(s.change,e)}cursor(t,e){return null}get stylesheet(){return this.is_root?this._stylesheet:this.root.stylesheet}styles(){return[a.default]}}s.View=_,_.__name__="View"},
function _(t,e,n,i,o){i();const s=t(8),l=t(13),r=t=>(e={},...n)=>{const i=document.createElement(t);i.classList.add("bk");for(let[t,n]of l.entries(e))if(null!=n&&(!s.isBoolean(n)||n))if("class"===t&&(s.isString(n)&&(n=n.split(/\s+/)),s.isArray(n)))for(const t of n)null!=t&&i.classList.add(t);else if("style"===t&&s.isPlainObject(n))for(const[t,e]of l.entries(n))i.style[t]=e;else if("data"===t&&s.isPlainObject(n))for(const[t,e]of l.entries(n))i.dataset[t]=e;else i.setAttribute(t,n);function o(t){if(s.isString(t))i.appendChild(document.createTextNode(t));else if(t instanceof Node)i.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)for(const e of t)i.appendChild(e);else if(null!=t&&!1!==t)throw new Error("expected a DOM element, string, false or null, got "+JSON.stringify(t))}for(const t of n)if(s.isArray(t))for(const e of t)o(e);else o(t);return i};function a(t){const e=t.parentNode;null!=e&&e.removeChild(t)}function c(t,...e){const n=t.firstChild;for(const i of e)t.insertBefore(i,n)}function d(t,e){var n,i,o;const s=Element.prototype;return(null!==(o=null!==(i=null!==(n=s.matches)&&void 0!==n?n:s.webkitMatchesSelector)&&void 0!==i?i:s.mozMatchesSelector)&&void 0!==o?o:s.msMatchesSelector).call(t,e)}function h(t){return parseFloat(t)||0}function u(t){const e=getComputedStyle(t);return{border:{top:h(e.borderTopWidth),bottom:h(e.borderBottomWidth),left:h(e.borderLeftWidth),right:h(e.borderRightWidth)},margin:{top:h(e.marginTop),bottom:h(e.marginBottom),left:h(e.marginLeft),right:h(e.marginRight)},padding:{top:h(e.paddingTop),bottom:h(e.paddingBottom),left:h(e.paddingLeft),right:h(e.paddingRight)}}}function f(t){const e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}n.createElement=function(t,e,...n){return r(t)(e,...n)},n.div=r("div"),n.span=r("span"),n.canvas=r("canvas"),n.link=r("link"),n.style=r("style"),n.a=r("a"),n.p=r("p"),n.i=r("i"),n.pre=r("pre"),n.button=r("button"),n.label=r("label"),n.input=r("input"),n.select=r("select"),n.option=r("option"),n.optgroup=r("optgroup"),n.textarea=r("textarea"),n.nbsp=function(){return document.createTextNode(" ")},n.append=function(t,...e){for(const n of e)t.appendChild(n)},n.remove=a,n.removeElement=a,n.replaceWith=function(t,e){const n=t.parentNode;null!=n&&n.replaceChild(e,t)},n.prepend=c,n.empty=function(t,e=!1){let n;for(;n=t.firstChild;)t.removeChild(n);if(e&&t instanceof Element)for(const e of t.attributes)t.removeAttributeNode(e)},n.display=function(t){t.style.display=""},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset=function(t){const e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},n.matches=d,n.parent=function(t,e){let n=t;for(;n=n.parentElement;)if(d(n,e))return n;return null},n.extents=u,n.size=f,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){const{margin:{left:e,right:n,top:i,bottom:o}}=u(t),{width:s,height:l}=f(t);return{width:Math.ceil(s+e+n),height:Math.ceil(l+i+o)}},n.content_size=function(t){const{left:e,top:n}=t.getBoundingClientRect(),{padding:i}=u(t);let o=0,s=0;for(const l of t.children){const t=l.getBoundingClientRect();o=Math.max(o,Math.ceil(t.left-e-i.left+t.width)),s=Math.max(s,Math.ceil(t.top-n-i.top+t.height))}return{width:o,height:s}},n.position=function(t,e,n){const{style:i}=t;if(i.left=e.x+"px",i.top=e.y+"px",i.width=e.width+"px",i.height=e.height+"px",null==n)i.margin="";else{const{top:t,right:e,bottom:o,left:s}=n;i.margin=`${t}px ${e}px ${o}px ${s}px`}},n.children=function(t){return Array.from(t.children)};class p{constructor(t){this.el=t,this.classList=t.classList}get values(){const t=[];for(let e=0;e<this.classList.length;e++){const n=this.classList.item(e);null!=n&&t.push(n)}return t}has(t){return this.classList.contains(t)}add(...t){for(const e of t)this.classList.add(e);return this}remove(...t){for(const e of t)this.classList.remove(e);return this}clear(){for(const t of this.values)"bk"!=t&&this.classList.remove(t);return this}toggle(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this}}var g;function m(t,e,n){const{width:i,height:o,position:s,display:l}=t.style;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?e.width+"px":"auto",t.style.height=null!=e.height&&e.height!=1/0?e.height+"px":"auto";try{return n()}finally{t.style.position=s,t.style.display=l,t.style.width=i,t.style.height=o}}n.ClassList=p,p.__name__="ClassList",n.classes=function(t){return new p(t)},n.toggle_attribute=function(t,e,n){null==n&&(n=!t.hasAttribute(e)),n?t.setAttribute(e,"true"):t.removeAttribute(e)},(g=n.Keys||(n.Keys={}))[g.Backspace=8]="Backspace",g[g.Tab=9]="Tab",g[g.Enter=13]="Enter",g[g.Esc=27]="Esc",g[g.PageUp=33]="PageUp",g[g.PageDown=34]="PageDown",g[g.Left=37]="Left",g[g.Up=38]="Up",g[g.Right=39]="Right",g[g.Down=40]="Down",g[g.Delete=46]="Delete",n.undisplayed=function(t,e){const{display:n}=t.style;t.style.display="none";try{return e()}finally{t.style.display=n}},n.unsized=function(t,e){return m(t,{},e)},n.sized=m;class y{constructor(t){this.root=t,this.known=new Set,this.style=n.style({type:"text/css"}),c(t,this.style)}append(t){this.known.has(t)||(this.style.appendChild(document.createTextNode(t)),this.known.add(t))}}n.StyleSheet=y,y.__name__="StyleSheet",n.stylesheet=new y(document.head),n.dom_ready=async function(){if("loading"==document.readyState)return new Promise((t,e)=>{document.addEventListener("DOMContentLoaded",()=>t(),{once:!0})})}},
function _(n,o,i,e,t){e();i.default="\n.bk-root {\n  position: relative;\n  width: auto;\n  height: auto;\n  z-index: 0;\n  box-sizing: border-box;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: 13px;\n}\n.bk-root .bk,\n.bk-root .bk:before,\n.bk-root .bk:after {\n  box-sizing: inherit;\n  margin: 0;\n  border: 0;\n  padding: 0;\n  background-image: none;\n  font-family: inherit;\n  font-size: 100%;\n  line-height: 1.42857143;\n}\n.bk-root pre.bk {\n  font-family: Courier, monospace;\n}\n"},
function _(e,t,a,s,l){s();const c=e(1),i=c.__importStar(e(28)),o=c.__importStar(e(18)),r=e(22),h=e(8),n=e(74),_=e(76);function u(e,t){const[a,s,l,c]=h.isString(e)?r.color2rgba(e):r.decode_rgba(e);return`rgba(${255*a}, ${255*s}, ${255*l}, ${1==c?t:c})`}function v(e,t,a){e.moveTo(0,a+.5),e.lineTo(t,a+.5),e.stroke()}function p(e,t,a){e.moveTo(a+.5,0),e.lineTo(a+.5,t),e.stroke()}function f(e,t){e.moveTo(0,t),e.lineTo(t,0),e.stroke(),e.moveTo(0,0),e.lineTo(t,t),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"};class d{constructor(e,t=""){this.obj=e,this.prefix=t,this.cache={};for(const a of this.attrs)this[a]=e.properties[t+a]}warm_cache(e,t){for(const a of this.attrs){const s=this.obj.properties[this.prefix+a];if(void 0!==s.spec.value)this.cache[a]=s.spec.value;else{if(!(null!=e&&s instanceof o.VectorSpec))throw new Error("source is required with a vectorized visual property");{const l=s.array(e),c=null!=t?t.select(l):l;this.cache[a+"_array"]=c}}}}cache_select(e,t){const a=this.obj.properties[this.prefix+e];let s;return void 0!==a.spec.value?this.cache[e]=s=a.spec.value:this.cache[e]=s=this.cache[e+"_array"][t],s}get_array(e){return this.cache[e+"_array"]}set_vectorize(e,t){this._set_vectorize(e,t)}}a.ContextProperties=d,d.__name__="ContextProperties";class k extends d{set_value(e){const t=this.line_color.value(),a=this.line_alpha.value();e.strokeStyle=u(t,a),e.lineWidth=this.line_width.value(),e.lineJoin=this.line_join.value(),e.lineCap=this.line_cap.value(),e.lineDash=this.line_dash.value(),e.lineDashOffset=this.line_dash_offset.value()}get doit(){return!(null===this.line_color.spec.value||0==this.line_alpha.spec.value||0==this.line_width.spec.value)}_set_vectorize(e,t){const a=this.cache_select("line_color",t),s=this.cache_select("line_alpha",t),l=this.cache_select("line_width",t),c=this.cache_select("line_join",t),i=this.cache_select("line_cap",t),o=this.cache_select("line_dash",t),r=this.cache_select("line_dash_offset",t);e.strokeStyle=u(a,s),e.lineWidth=l,e.lineJoin=c,e.lineCap=i,e.lineDash=o,e.lineDashOffset=r}color_value(){return u(this.line_color.value(),this.line_alpha.value())}}a.Line=k,k.__name__="Line",k.prototype.attrs=Object.keys(i.LineVector);class x extends d{set_value(e){const t=this.fill_color.value(),a=this.fill_alpha.value();e.fillStyle=u(t,a)}get doit(){return!(null===this.fill_color.spec.value||0==this.fill_alpha.spec.value)}_set_vectorize(e,t){const a=this.cache_select("fill_color",t),s=this.cache_select("fill_alpha",t);e.fillStyle=u(a,s)}color_value(){return u(this.fill_color.value(),this.fill_alpha.value())}}a.Fill=x,x.__name__="Fill",x.prototype.attrs=Object.keys(i.FillVector);class b extends d{cache_select(e,t){let s;if("pattern"==e){const e=this.cache_select("hatch_color",t),s=this.cache_select("hatch_alpha",t),l=this.cache_select("hatch_scale",t),c=this.cache_select("hatch_pattern",t),i=this.cache_select("hatch_weight",t),{hatch_extra:o}=this.cache;if(null!=o&&o.hasOwnProperty(c)){const t=o[c];this.cache.pattern=t.get_pattern(e,s,l,i)}else this.cache.pattern=t=>{const o=t instanceof n.SVGRenderingContext2D?"svg":"canvas",r=new _.CanvasLayer(o,!0);return r.resize(l,l),r.prepare(),function(e,t,s,l,c,i){var o;const r=c,h=r/2,n=h/2;switch(e.strokeStyle=u(s,l),e.lineCap="square",e.fillStyle=s,e.lineWidth=i,null!==(o=a.hatch_aliases[t])&&void 0!==o?o:t){case"blank":break;case"dot":e.arc(h,h,h/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(h,h,h/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":v(e,r,h);break;case"vertical_line":p(e,r,h);break;case"cross":v(e,r,h),p(e,r,h);break;case"horizontal_dash":v(e,h,h);break;case"vertical_dash":p(e,h,h);break;case"spiral":{const t=r/30;e.moveTo(h,h);for(let a=0;a<360;a++){const s=.1*a,l=h+t*s*Math.cos(s),c=h+t*s*Math.sin(s);e.lineTo(l,c)}e.stroke();break}case"right_diagonal_line":e.moveTo(.5-n,r),e.lineTo(n+.5,0),e.stroke(),e.moveTo(n+.5,r),e.lineTo(3*n+.5,0),e.stroke(),e.moveTo(3*n+.5,r),e.lineTo(5*n+.5,0),e.stroke(),e.stroke();break;case"left_diagonal_line":e.moveTo(n+.5,r),e.lineTo(.5-n,0),e.stroke(),e.moveTo(3*n+.5,r),e.lineTo(n+.5,0),e.stroke(),e.moveTo(5*n+.5,r),e.lineTo(3*n+.5,0),e.stroke(),e.stroke();break;case"diagonal_cross":f(e,r);break;case"right_diagonal_dash":e.moveTo(n+.5,3*n+.5),e.lineTo(3*n+.5,n+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(n+.5,n+.5),e.lineTo(3*n+.5,3*n+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,n),e.lineTo(h,3*n),e.lineTo(r,n),e.stroke();break;case"vertical_wave":e.moveTo(n,0),e.lineTo(3*n,h),e.lineTo(n,r),e.stroke();break;case"criss_cross":f(e,r),v(e,r,h),p(e,r,h)}}(r.ctx,c,e,s,l,i),t.createPattern(r.canvas,"repeat")}}else s=super.cache_select(e,t);return s}_try_defer(e){const{hatch_pattern:t,hatch_extra:a}=this.cache;if(null!=a&&a.hasOwnProperty(t)){a[t].onload(e)}}get doit(){return!(null===this.hatch_color.spec.value||0==this.hatch_alpha.spec.value||" "==this.hatch_pattern.spec.value||"blank"==this.hatch_pattern.spec.value||null===this.hatch_pattern.spec.value)}doit2(e,t,a,s){if(!this.doit)return;this.cache_select("pattern",t);null==this.cache.pattern(e)?this._try_defer(s):(this.set_vectorize(e,t),a())}_set_vectorize(e,t){this.cache_select("pattern",t),e.fillStyle=this.cache.pattern(e)}color_value(){return u(this.hatch_color.value(),this.hatch_alpha.value())}}a.Hatch=b,b.__name__="Hatch",b.prototype.attrs=Object.keys(i.HatchVector);class T extends d{color_value(){return u(this.text_color.value(),this.text_alpha.value())}font_value(){const e=this.text_font.value(),t=this.text_font_size.value();return`${this.text_font_style.value()} ${t} ${e}`}v_font_value(e){super.cache_select("text_font_style",e),super.cache_select("text_font_size",e),super.cache_select("text_font",e);const{text_font_style:t,text_font_size:a,text_font:s}=this.cache;return`${t} ${a} ${s}`}cache_select(e,t){let a;return"font"==e?this.cache.font=a=this.v_font_value(t):a=super.cache_select(e,t),a}set_value(e){const t=this.text_color.value(),a=this.text_alpha.value();e.fillStyle=u(t,a),e.font=this.font_value(),e.textAlign=this.text_align.value(),e.textBaseline=this.text_baseline.value()}get doit(){return!(null===this.text_color.spec.value||0==this.text_alpha.spec.value)}_set_vectorize(e,t){const a=this.cache_select("text_color",t),s=this.cache_select("text_alpha",t),l=this.cache_select("font",t),c=this.cache_select("text_align",t),i=this.cache_select("text_baseline",t);e.fillStyle=u(a,s),e.font=l,e.textAlign=c,e.textBaseline=i}}a.Text=T,T.__name__="Text",T.prototype.attrs=Object.keys(i.TextVector);class g{constructor(e){for(const t of e._mixins){const[a,s=""]=t.split(":");let l;switch(a){case"line":l=k;break;case"fill":l=x;break;case"hatch":l=b;break;case"text":l=T;break;default:throw new Error("unknown visual: "+a)}this[s+a]=new l(e,s)}}warm_cache(e,t){for(const a in this)if(this.hasOwnProperty(a)){const s=this[a];s instanceof d&&s.warm_cache(e,t)}}}a.Visuals=g,g.__name__="Visuals"},
function _(t,e,i,s,n){s();const r=t(75),a=t(8),o=t(71);function l(t){if(!t)throw new Error("cannot create a random attribute name for an undefined object");const e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";let i="";do{i="";for(let t=0;t<12;t++)i+=e[Math.floor(Math.random()*e.length)]}while(t[i]);return i}function h(t){var e;const i={left:"start",right:"end",center:"middle",start:"start",end:"end"};return null!==(e=i[t])&&void 0!==e?e:i.start}function c(t){var e;const i={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return null!==(e=i[t])&&void 0!==e?e:i.alphabetic}const _=function(t,e){const i=new Map,s=t.split(",");e=null!=e?e:10;for(let t=0;t<s.length;t+=2){const n="&"+s[t+1]+";",r=parseInt(s[t],e);i.set(n,"&#"+r+";")}return i.set("\\xa0","&#160;"),i}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),u={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};class p{constructor(t,e){this.__root=t,this.__ctx=e}addColorStop(t,e){const i=this.__ctx.__createElement("stop");if(i.setAttribute("offset",""+t),-1!==e.indexOf("rgba")){const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),[,s,n,r,a]=t;i.setAttribute("stop-color",`rgb(${s},${n},${r})`),i.setAttribute("stop-opacity",a)}else i.setAttribute("stop-color",e);this.__root.appendChild(i)}}p.__name__="CanvasGradient";class d{constructor(t,e){this.__root=t,this.__ctx=e}}d.__name__="CanvasPattern";class m{constructor(t){var e,i,s;this.__currentPosition=null,this.__currentElementsToStyle=null,this._transform=new r.AffineTransform,this._clip_path=null,this.__document=null!==(e=null==t?void 0:t.document)&&void 0!==e?e:document,(null==t?void 0:t.ctx)?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.width=null!==(i=null==t?void 0:t.width)&&void 0!==i?i:500,this.height=null!==(s=null==t?void 0:t.height)&&void 0!==s?s:500,this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}get canvas(){return this}get width(){return this._width}set width(t){this._width=t,this.__root.setAttribute("width",""+t)}get height(){return this._height}set height(t){this._height=t,this.__root.setAttribute("height",""+t)}__createElement(t,e={},i=!1){const s=this.__document.createElementNS("http://www.w3.org/2000/svg",t);i&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none"));const n=Object.keys(e);for(const t of n)s.setAttribute(t,""+e[t]);return s}__setDefaultStyles(){const t=Object.keys(u),e=this;for(let i=0;i<t.length;i++){const s=t[i];e[s]=u[s].canvas}}__applyStyleState(t){const e=Object.keys(t),i=this;for(let s=0;s<e.length;s++){const n=e[s];i[n]=t[n]}}__getStyleState(){const t=Object.keys(u),e={};for(let i=0;i<t.length;i++){const s=t[i];e[s]=this[s]}return e}__applyStyleToCurrentElement(t){let e=this.__currentElement;const i=this.__currentElementsToStyle;if(null!=i){e.setAttribute(t,""),e=i.element;for(const e of i.children)e.setAttribute(t,"")}const s=Object.keys(u);for(let i=0;i<s.length;i++){const n=u[s[i]],r=this[s[i]];if(n.apply)if(r instanceof d){for(const t of[...r.__ctx.__defs.childNodes])if(t instanceof Element){const e=t.getAttribute("id");this.__ids[e]=e,this.__defs.appendChild(t)}const t=r.__root.getAttribute("id");e.setAttribute(n.apply,`url(#${t})`)}else if(r instanceof p){const t=r.__root.getAttribute("id");e.setAttribute(n.apply,`url(#${t})`)}else if(-1!==n.apply.indexOf(t)&&n.svg!==r)if("stroke"!==n.svgAttr&&"fill"!==n.svgAttr||!a.isString(r)||-1===r.indexOf("rgba")){let a=n.svgAttr;if("globalAlpha"===s[i]&&(a=t+"-"+n.svgAttr,e.getAttribute(a)))continue;e.setAttribute(a,""+r)}else{const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(r),[,i,s,a,o]=t;e.setAttribute(n.svgAttr,`rgb(${i},${s},${a})`);let l=parseFloat(o);const h=this.globalAlpha;null!=h&&(l*=h),e.setAttribute(n.svgAttr+"-opacity",""+l)}}}get_serialized_svg(t=!1){let e=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(e)&&(e=e.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)for(const[t,i]of _){const s=new RegExp(t,"gi");s.test(e)&&(e=e.replace(s,i))}return e}get_svg(){return this.__root}save(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()}restore(){if(0==this.__stack.length)return;const{transform:t,clip_path:e,attributes:i}=this.__stack.pop();this._transform=t,this._clip_path=e,this.__applyStyleState(i)}_apply_transform(t,e=this._transform){e.is_identity||t.setAttribute("transform",e.toString())}scale(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,null!=e?e:t)}rotate(t){isFinite(t)&&this._transform.rotate(t)}translate(t,e){isFinite(t+e)&&this._transform.translate(t,e)}transform(t,e,i,s,n,r){isFinite(t+e+i+s+n+r)&&this._transform.transform(t,e,i,s,n,r)}beginPath(){this.__currentDefaultPath="",this.__currentPosition=null;const t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t}__applyCurrentDefaultPath(){const t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)}__addPathCommand(t,e,i){const s=this.__currentDefaultPath?" ":"";this.__currentDefaultPath+=s+i,this.__currentPosition={x:t,y:e}}get _hasCurrentDefaultPath(){return!!this.__currentDefaultPath}moveTo(t,e){if(!isFinite(t+e))return;"path"!==this.__currentElement.nodeName&&this.beginPath();const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`M ${i} ${s}`)}closePath(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")}lineTo(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`L ${i} ${s}`)}else this.moveTo(t,e)}bezierCurveTo(t,e,i,s,n,r){if(!isFinite(t+e+i+s+n+r))return;const[a,o]=this._transform.apply(n,r),[l,h]=this._transform.apply(t,e),[c,_]=this._transform.apply(i,s);this.__addPathCommand(a,o,`C ${l} ${h} ${c} ${_} ${a} ${o}`)}quadraticCurveTo(t,e,i,s){if(!isFinite(t+e+i+s))return;const[n,r]=this._transform.apply(i,s),[a,o]=this._transform.apply(t,e);this.__addPathCommand(n,r,`Q ${a} ${o} ${n} ${r}`)}arcTo(t,e,i,s,n){if(!isFinite(t+e+i+s+n))return;if(null==this.__currentPosition)return;const r=this.__currentPosition.x,a=this.__currentPosition.y;if(n<0)throw new Error("IndexSizeError: The radius provided ("+n+") is negative.");if(r===t&&a===e||t===i&&e===s||0===n)return void this.lineTo(t,e);function o([t,e]){const i=Math.sqrt(t**2+e**2);return[t/i,e/i]}const l=o([r-t,a-e]),h=o([i-t,s-e]);if(l[0]*h[1]==l[1]*h[0])return void this.lineTo(t,e);const c=l[0]*h[0]+l[1]*h[1],_=Math.acos(Math.abs(c)),u=o([l[0]+h[0],l[1]+h[1]]),p=n/Math.sin(_/2),d=t+p*u[0],m=e+p*u[1],f=[-l[1],l[0]],g=[h[1],-h[0]];function v(t){const e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}const w=v(f),b=v(g);this.lineTo(d+f[0]*n,m+f[1]*n),this.arc(d,m,n,w,b)}stroke(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}fill(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}rect(t,e,i,s){isFinite(t+e+i+s)&&("path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+i,e),this.lineTo(t+i,e+s),this.lineTo(t,e+s),this.lineTo(t,e))}fillRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.fill())}strokeRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.stroke())}__clearCanvas(){o.empty(this.__defs),o.empty(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root}clearRect(t,e,i,s){if(!isFinite(t+e+i+s))return;if(0===t&&0===e&&i===this.width&&s===this.height)return void this.__clearCanvas();const n=this.__createElement("rect",{x:t,y:e,width:i,height:s,fill:"#FFFFFF"},!0);this._apply_transform(n),this.__root.appendChild(n)}createLinearGradient(t,e,i,s){if(!isFinite(t+e+i+s))throw new Error("The provided double value is non-finite");const[n,r]=this._transform.apply(t,e),[a,o]=this._transform.apply(i,s),h=this.__createElement("linearGradient",{id:l(this.__ids),x1:n+"px",x2:a+"px",y1:r+"px",y2:o+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(h),new p(h,this)}createRadialGradient(t,e,i,s,n,r){if(!isFinite(t+e+i+s+n+r))throw new Error("The provided double value is non-finite");const[a,o]=this._transform.apply(t,e),[h,c]=this._transform.apply(s,n),_=this.__createElement("radialGradient",{id:l(this.__ids),cx:h+"px",cy:c+"px",r:r+"px",fx:a+"px",fy:o+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(_),new p(_,this)}__parseFont(){var t,e,i,s,n;const r=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),a={style:null!==(t=r[1])&&void 0!==t?t:"normal",size:null!==(e=r[4])&&void 0!==e?e:"10px",family:null!==(i=r[6])&&void 0!==i?i:"sans-serif",weight:null!==(s=r[3])&&void 0!==s?s:"normal",decoration:null!==(n=r[2])&&void 0!==n?n:"normal"};return"underline"===this.__fontUnderline&&(a.decoration="underline"),null!=this.__fontHref&&(a.href=this.__fontHref),a}__wrapTextLink(t,e){if(t.href){const i=this.__createElement("a");return i.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),i.appendChild(e),i}return e}__applyText(t,e,i,s){const n=this.__parseFont(),r=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:e,y:i,"text-anchor":h(this.textAlign),"dominant-baseline":c(this.textBaseline)},!0);r.appendChild(this.__document.createTextNode(t)),this._apply_transform(r),this.__currentElement=r,this.__applyStyleToCurrentElement(s),this.__root.appendChild(this.__wrapTextLink(n,r))}fillText(t,e,i){null!=t&&isFinite(e+i)&&this.__applyText(t,e,i,"fill")}strokeText(t,e,i){null!=t&&isFinite(e+i)&&this.__applyText(t,e,i,"stroke")}measureText(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)}arc(t,e,i,s,n,r=!1){if(!isFinite(t+e+i+s+n))return;if(s===n)return;(s%=2*Math.PI)===(n%=2*Math.PI)&&(n=(n+2*Math.PI-.001*(r?-1:1))%(2*Math.PI));const a=t+i*Math.cos(n),o=e+i*Math.sin(n),l=t+i*Math.cos(s),h=e+i*Math.sin(s),c=r?0:1;let _=0,u=n-s;u<0&&(u+=2*Math.PI),_=r?u>Math.PI?0:1:u>Math.PI?1:0,this.lineTo(l,h);const p=i,d=i,[m,f]=this._transform.apply(a,o);this.__addPathCommand(m,f,`A ${p} ${d} 0 ${_} ${c} ${m} ${f}`)}clip(){const t=this.__createElement("clipPath"),e=l(this.__ids);this.__applyCurrentDefaultPath(),t.setAttribute("id",e),t.appendChild(this.__currentElement),this.__defs.appendChild(t),this._clip_path=`url(#${e})`}drawImage(t,...e){let i,s,n,r,a,o,l,h;if(2==e.length){if([i,s]=e,!isFinite(i+s))return;a=0,o=0,l=t.width,h=t.height,n=l,r=h}else if(4==e.length){if([i,s,n,r]=e,!isFinite(i+s+n+r))return;a=0,o=0,l=t.width,h=t.height}else{if(8!==e.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);if([a,o,l,h,i,s,n,r]=e,!isFinite(a+o+l+h+i+s+n+r))return}const c=this.__root,_="translate("+i+", "+s+")",u=this._transform.clone().translate(i,s);if(t instanceof m||t instanceof SVGSVGElement){const e=(t instanceof SVGSVGElement?t:t.get_svg()).cloneNode(!0);let i;u.is_identity?i=c:(i=this.__createElement("g"),this._apply_transform(i,u),c.appendChild(i));for(const t of[...e.childNodes])if(t instanceof SVGDefsElement){for(const e of[...t.childNodes])if(e instanceof Element){const t=e.getAttribute("id");this.__ids[t]=t,this.__defs.appendChild(e)}}else i.appendChild(t)}else if(t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__createElement("image");if(e.setAttribute("width",""+n),e.setAttribute("height",""+r),e.setAttribute("preserveAspectRatio","none"),a||o||l!==t.width||h!==t.height){const e=this.__document.createElement("canvas");e.width=n,e.height=r;e.getContext("2d").drawImage(t,a,o,l,h,0,0,n,r),t=e}e.setAttribute("transform",_);const i=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",i),c.appendChild(e)}else if(t instanceof HTMLCanvasElement){const e=this.__createElement("image");e.setAttribute("width",""+n),e.setAttribute("height",""+r),e.setAttribute("preserveAspectRatio","none");const i=this.__document.createElement("canvas");i.width=n,i.height=r;const s=i.getContext("2d");s.imageSmoothingEnabled=!1,s.drawImage(t,a,o,l,h,0,0,n,r),t=i,e.setAttribute("transform",_),e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.toDataURL()),c.appendChild(e)}}createPattern(t,e){const i=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),s=l(this.__ids);if(i.setAttribute("id",s),i.setAttribute("width",""+this._to_number(t.width)),i.setAttribute("height",""+this._to_number(t.height)),i.setAttribute("patternUnits","userSpaceOnUse"),t instanceof HTMLCanvasElement||t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),s=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",s),i.appendChild(e),this.__defs.appendChild(i)}else if(t instanceof m){for(const e of[...t.__root.childNodes])e instanceof SVGDefsElement||i.appendChild(e);this.__defs.appendChild(i)}else{if(!(t instanceof SVGSVGElement))throw new Error("unsupported");for(const e of[...t.childNodes])e instanceof SVGDefsElement||i.appendChild(e);this.__defs.appendChild(i)}return new d(i,this)}setLineDash(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null}_to_number(t){return a.isNumber(t)?t:t.baseVal.value}}i.SVGRenderingContext2D=m,m.__name__="SVGRenderingContext2D"},
function _(t,s,r,n,e){n();const{sin:i,cos:a}=Math;class h{constructor(t=1,s=0,r=0,n=1,e=0,i=0){this.a=t,this.b=s,this.c=r,this.d=n,this.e=e,this.f=i}toString(){const{a:t,b:s,c:r,d:n,e,f:i}=this;return`matrix(${t}, ${s}, ${r}, ${n}, ${e}, ${i})`}clone(){const{a:t,b:s,c:r,d:n,e,f:i}=this;return new h(t,s,r,n,e,i)}get is_identity(){const{a:t,b:s,c:r,d:n,e,f:i}=this;return 1==t&&0==s&&0==r&&1==n&&0==e&&0==i}apply(t,s){const{a:r,b:n,c:e,d:i,e:a,f:h}=this;return[r*t+e*s+a,n*t+i*s+h]}iv_apply(t,s){const{a:r,b:n,c:e,d:i,e:a,f:h}=this,c=t.length;for(let o=0;o<c;o++){const c=t[o],f=s[o];t[o]=r*c+e*f+a,s[o]=n*c+i*f+h}}transform(t,s,r,n,e,i){const{a,b:h,c,d:o,e:f,f:l}=this;return this.a=a*t+c*s,this.c=a*r+c*n,this.e=a*e+c*i+f,this.b=h*t+o*s,this.d=h*r+o*n,this.f=h*e+o*i+l,this}translate(t,s){return this.transform(1,0,0,1,t,s)}scale(t,s){return this.transform(t,0,0,s,0,0)}skew(t,s){return this.transform(1,s,t,1,0,0)}rotate(t){const s=i(t),r=a(t);return this.transform(r,s,-s,r,0,0)}rotate_ccw(t){return this.rotate(-t)}translate_x(t){return this.translate(t,0)}translate_y(t){return this.translate(0,t)}flip(){return this.scale(-1,-1)}flip_x(){return this.scale(1,-1)}flip_y(){return this.scale(-1,1)}}r.AffineTransform=h,h.__name__="AffineTransform"},
function _(e,t,s,i,a){i();const n=e(14),l=e(77),o=e(19),r=e(71),h=e(20),c=e(13),_=e(78),v=e(86),d=e(87),p=e(74),b=(()=>{const e=document.createElement("canvas"),t=e.getContext("webgl",{premultipliedAlpha:!0});return null!=t?{canvas:e,gl:t}:void o.logger.trace("WebGL is not supported")})(),u={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};class g{constructor(e,t){switch(this.backend=e,this.hidpi=t,this.pixel_ratio=1,this.bbox=new v.BBox,e){case"webgl":case"canvas":{this._el=this._canvas=r.canvas({style:u});const e=this.canvas.getContext("2d");if(null==e)throw new Error("unable to obtain 2D rendering context");this._ctx=e,t&&(this.pixel_ratio=devicePixelRatio);break}case"svg":{const e=new p.SVGRenderingContext2D;this._ctx=e,this._canvas=e.get_svg(),this._el=r.div({style:u},this._canvas);break}}d.fixup_ctx(this._ctx)}get canvas(){return this._canvas}get ctx(){return this._ctx}get el(){return this._el}resize(e,t){this.bbox=new v.BBox({left:0,top:0,width:e,height:t});const s=this._ctx instanceof p.SVGRenderingContext2D?this._ctx:this.canvas;s.width=e*this.pixel_ratio,s.height=t*this.pixel_ratio}prepare(){const{ctx:e,hidpi:t,pixel_ratio:s}=this;e.save(),t&&(e.scale(s,s),e.translate(.5,.5)),this.clear()}clear(){const{x:e,y:t,width:s,height:i}=this.bbox;this.ctx.clearRect(e,t,s,i)}finish(){this.ctx.restore()}to_blob(){const{_canvas:e}=this;if(e instanceof HTMLCanvasElement)return null!=e.msToBlob?Promise.resolve(e.msToBlob()):new Promise((t,s)=>{e.toBlob(e=>null!=e?t(e):s(),"image/png")});{const e=this._ctx.get_serialized_svg(!0),t=new Blob([e],{type:"image/svg+xml"});return Promise.resolve(t)}}}s.CanvasLayer=g,g.__name__="CanvasLayer";class x extends l.DOMView{constructor(){super(...arguments),this.bbox=new v.BBox}initialize(){super.initialize();const{output_backend:e,hidpi:t}=this.model;"webgl"==e&&(this.webgl=b),this.underlays_el=r.div({style:u}),this.primary=new g(e,t),this.overlays=new g(e,t),this.overlays_el=r.div({style:u}),this.events_el=r.div({class:"bk-canvas-events",style:u});const s=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];c.extend(this.el.style,u),r.append(this.el,...s),this.ui_event_bus=new _.UIEventBus(this)}remove(){this.ui_event_bus.destroy(),super.remove()}add_underlay(e){this.underlays_el.appendChild(e)}add_overlay(e){this.overlays_el.appendChild(e)}add_event(e){this.events_el.appendChild(e)}get pixel_ratio(){return this.primary.pixel_ratio}resize(e,t){this.bbox=new v.BBox({left:0,top:0,width:e,height:t}),this.primary.resize(e,t),this.overlays.resize(e,t)}prepare_webgl(e){const{webgl:t}=this;if(null!=t){const{width:s,height:i}=this.bbox;t.canvas.width=this.pixel_ratio*s,t.canvas.height=this.pixel_ratio*i;const{gl:a}=t;a.enable(a.SCISSOR_TEST);const[n,l,o,r]=e,{xview:h,yview:c}=this.bbox,_=h.compute(n),v=c.compute(l+r),d=this.pixel_ratio;a.scissor(d*_,d*v,d*o,d*r),a.enable(a.BLEND),a.blendFuncSeparate(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA,a.ONE_MINUS_DST_ALPHA,a.ONE),this._clear_webgl()}}blit_webgl(e){const{webgl:t}=this;if(null!=t){if(o.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi){const t=this.pixel_ratio;e.scale(t,t),e.translate(.5,.5)}this._clear_webgl()}}_clear_webgl(){const{webgl:e}=this;if(null!=e){const{gl:t,canvas:s}=e;t.viewport(0,0,s.width,s.height),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT)}}compose(){const{output_backend:e,hidpi:t}=this.model,{width:s,height:i}=this.bbox,a=new g(e,t);return a.resize(s,i),a.ctx.drawImage(this.primary.canvas,0,0),a.ctx.drawImage(this.overlays.canvas,0,0),a}to_blob(){return this.compose().to_blob()}}s.CanvasView=x,x.__name__="CanvasView";class w extends n.HasProps{constructor(e){super(e)}static init_Canvas(){this.prototype.default_view=x,this.internal(({Boolean:e})=>({hidpi:[e,!0],output_backend:[h.OutputBackend,"canvas"]}))}}s.Canvas=w,w.__name__="Canvas",w.init_Canvas()},
function _(e,s,t,i,r){i();const n=e(70),a=e(71);class l extends n.View{initialize(){super.initialize(),this.el=this._createElement()}remove(){a.remove(this.el),super.remove()}css_classes(){return[]}render(){}renderTo(e){e.appendChild(this.el),this.render()}_createElement(){return a.createElement(this.tagName,{class:this.css_classes()})}}t.DOMView=l,l.__name__="DOMView",l.prototype.tagName="div"},
function _(t,e,s,n,i){n();const r=t(1),a=r.__importDefault(t(79)),_=t(15),h=t(19),o=t(71),l=r.__importStar(t(80)),c=t(81),p=t(9),u=t(8),v=t(82),d=t(83);class g{constructor(t){this.canvas_view=t,this.pan_start=new _.Signal(this,"pan:start"),this.pan=new _.Signal(this,"pan"),this.pan_end=new _.Signal(this,"pan:end"),this.pinch_start=new _.Signal(this,"pinch:start"),this.pinch=new _.Signal(this,"pinch"),this.pinch_end=new _.Signal(this,"pinch:end"),this.rotate_start=new _.Signal(this,"rotate:start"),this.rotate=new _.Signal(this,"rotate"),this.rotate_end=new _.Signal(this,"rotate:end"),this.tap=new _.Signal(this,"tap"),this.doubletap=new _.Signal(this,"doubletap"),this.press=new _.Signal(this,"press"),this.pressup=new _.Signal(this,"pressup"),this.move_enter=new _.Signal(this,"move:enter"),this.move=new _.Signal(this,"move"),this.move_exit=new _.Signal(this,"move:exit"),this.scroll=new _.Signal(this,"scroll"),this.keydown=new _.Signal(this,"keydown"),this.keyup=new _.Signal(this,"keyup"),this.hammer=new a.default(this.hit_area,{touchAction:"auto",inputClass:a.default.TouchMouseInput}),this._prev_move=null,this._curr_pan=null,this._curr_pinch=null,this._curr_rotate=null,this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",t=>this._mouse_move(t)),this.hit_area.addEventListener("mouseenter",t=>this._mouse_enter(t)),this.hit_area.addEventListener("mouseleave",t=>this._mouse_exit(t)),this.hit_area.addEventListener("contextmenu",t=>this._context_menu(t)),this.hit_area.addEventListener("wheel",t=>this._mouse_wheel(t)),document.addEventListener("keydown",this),document.addEventListener("keyup",this),this.menu=new d.ContextMenu([],{prevent_hide:t=>2==t.button&&t.target==this.hit_area}),this.hit_area.appendChild(this.menu.el)}get hit_area(){return this.canvas_view.events_el}destroy(){this.menu.remove(),this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)}handleEvent(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)}_configure_hammerjs(){this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",t=>this._doubletap(t)),this.hammer.on("tap",t=>this._tap(t)),this.hammer.on("press",t=>this._press(t)),this.hammer.on("pressup",t=>this._pressup(t)),this.hammer.get("pan").set({direction:a.default.DIRECTION_ALL}),this.hammer.on("panstart",t=>this._pan_start(t)),this.hammer.on("pan",t=>this._pan(t)),this.hammer.on("panend",t=>this._pan_end(t)),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",t=>this._pinch_start(t)),this.hammer.on("pinch",t=>this._pinch(t)),this.hammer.on("pinchend",t=>this._pinch_end(t)),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",t=>this._rotate_start(t)),this.hammer.on("rotate",t=>this._rotate(t)),this.hammer.on("rotateend",t=>this._rotate_end(t))}register_tool(t){const e=t.model.event_type;null!=e&&(u.isString(e)?this._register_tool(t,e):e.forEach((e,s)=>this._register_tool(t,e,s<1)))}_register_tool(t,e,s=!0){const n=t,{id:i}=n.model,r=t=>e=>{e.id==i&&t(e.e)},a=t=>e=>{t(e.e)};switch(e){case"pan":null!=n._pan_start&&n.connect(this.pan_start,r(n._pan_start.bind(n))),null!=n._pan&&n.connect(this.pan,r(n._pan.bind(n))),null!=n._pan_end&&n.connect(this.pan_end,r(n._pan_end.bind(n)));break;case"pinch":null!=n._pinch_start&&n.connect(this.pinch_start,r(n._pinch_start.bind(n))),null!=n._pinch&&n.connect(this.pinch,r(n._pinch.bind(n))),null!=n._pinch_end&&n.connect(this.pinch_end,r(n._pinch_end.bind(n)));break;case"rotate":null!=n._rotate_start&&n.connect(this.rotate_start,r(n._rotate_start.bind(n))),null!=n._rotate&&n.connect(this.rotate,r(n._rotate.bind(n))),null!=n._rotate_end&&n.connect(this.rotate_end,r(n._rotate_end.bind(n)));break;case"move":null!=n._move_enter&&n.connect(this.move_enter,r(n._move_enter.bind(n))),null!=n._move&&n.connect(this.move,r(n._move.bind(n))),null!=n._move_exit&&n.connect(this.move_exit,r(n._move_exit.bind(n)));break;case"tap":null!=n._tap&&n.connect(this.tap,r(n._tap.bind(n))),null!=n._doubletap&&n.connect(this.doubletap,r(n._doubletap.bind(n)));break;case"press":null!=n._press&&n.connect(this.press,r(n._press.bind(n))),null!=n._pressup&&n.connect(this.pressup,r(n._pressup.bind(n)));break;case"scroll":null!=n._scroll&&n.connect(this.scroll,r(n._scroll.bind(n)));break;default:throw new Error("unsupported event_type: "+e)}s&&(null!=n._keydown&&n.connect(this.keydown,a(n._keydown.bind(n))),null!=n._keyup&&n.connect(this.keyup,a(n._keyup.bind(n))),v.is_mobile&&null!=n._scroll&&"pinch"==e&&(h.logger.debug("Registering scroll on touch screen"),n.connect(this.scroll,r(n._scroll.bind(n)))))}_hit_test_renderers(t,e,s){const n=t.get_renderer_views();for(const t of p.reversed(n)){const{level:n}=t.model;if(("annotation"==n||"overlay"==n)&&null!=t.interactive_hit&&t.interactive_hit(e,s))return t}return null}set_cursor(t="default"){this.hit_area.style.cursor=t}_hit_test_frame(t,e,s){return t.frame.bbox.contains(e,s)}_hit_test_canvas(t,e,s){return t.layout.bbox.contains(e,s)}_hit_test_plot(t,e){for(const s of this.canvas_view.plot_views)if(s.layout.bbox.relative().contains(t,e))return s;return null}_trigger(t,e,s){var n;const{sx:i,sy:r}=e,a=this._hit_test_plot(i,r),_=t=>{const[s,n]=[i,r];return Object.assign(Object.assign({},e),{sx:s,sy:n})};if("panstart"==e.type||"pan"==e.type||"panend"==e.type){let n;if("panstart"==e.type&&null!=a?(this._curr_pan={plot_view:a},n=a):"pan"==e.type&&null!=this._curr_pan?n=this._curr_pan.plot_view:"panend"==e.type&&null!=this._curr_pan?(n=this._curr_pan.plot_view,this._curr_pan=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("pinchstart"==e.type||"pinch"==e.type||"pinchend"==e.type){let n;if("pinchstart"==e.type&&null!=a?(this._curr_pinch={plot_view:a},n=a):"pinch"==e.type&&null!=this._curr_pinch?n=this._curr_pinch.plot_view:"pinchend"==e.type&&null!=this._curr_pinch?(n=this._curr_pinch.plot_view,this._curr_pinch=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("rotatestart"==e.type||"rotate"==e.type||"rotateend"==e.type){let n;if("rotatestart"==e.type&&null!=a?(this._curr_rotate={plot_view:a},n=a):"rotate"==e.type&&null!=this._curr_rotate?n=this._curr_rotate.plot_view:"rotateend"==e.type&&null!=this._curr_rotate?(n=this._curr_rotate.plot_view,this._curr_rotate=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("mouseenter"==e.type||"mousemove"==e.type||"mouseleave"==e.type){const h=null===(n=this._prev_move)||void 0===n?void 0:n.plot_view;if(null!=h&&("mouseleave"==e.type||h!=a)){const{sx:t,sy:e}=_();this.__trigger(h,this.move_exit,{type:"mouseleave",sx:t,sy:e,shiftKey:!1,ctrlKey:!1},s)}if(null!=a&&("mouseenter"==e.type||h!=a)){const{sx:t,sy:e}=_();this.__trigger(a,this.move_enter,{type:"mouseenter",sx:t,sy:e,shiftKey:!1,ctrlKey:!1},s)}if(null!=a&&"mousemove"==e.type){const e=_();this.__trigger(a,t,e,s)}this._prev_move={sx:i,sy:r,plot_view:a}}else if(null!=a){const e=_();this.__trigger(a,t,e,s)}}__trigger(t,e,s,n){var i,r;const a=t.model.toolbar.gestures,_=e.name.split(":")[0],h=this._hit_test_renderers(t,s.sx,s.sy),o=this._hit_test_canvas(t,s.sx,s.sy);switch(_){case"move":{const n=a[_].active;null!=n&&this.trigger(e,s,n.id);const r=t.model.toolbar.inspectors.filter(t=>t.active);let l="default";null!=h?(l=null!==(i=h.cursor(s.sx,s.sy))&&void 0!==i?i:l,p.is_empty(r)||(e=this.move_exit)):this._hit_test_frame(t,s.sx,s.sy)&&(p.is_empty(r)||(l="crosshair")),this.set_cursor(l),t.set_toolbar_visibility(o),r.map(t=>this.trigger(e,s,t.id));break}case"tap":{const{target:t}=n;if(null!=t&&t!=this.hit_area)return;null!=h&&null!=h.on_hit&&h.on_hit(s.sx,s.sy);const i=a[_].active;null!=i&&this.trigger(e,s,i.id);break}case"doubletap":{const t=null!==(r=a.doubletap.active)&&void 0!==r?r:a.tap.active;null!=t&&this.trigger(e,s,t.id);break}case"scroll":{const t=a[v.is_mobile?"pinch":"scroll"].active;null!=t&&(n.preventDefault(),n.stopPropagation(),this.trigger(e,s,t.id));break}case"pan":{const t=a[_].active;null!=t&&(n.preventDefault(),this.trigger(e,s,t.id));break}default:{const t=a[_].active;null!=t&&this.trigger(e,s,t.id)}}this._trigger_bokeh_event(t,s)}trigger(t,e,s=null){t.emit({id:s,e})}_trigger_bokeh_event(t,e){const s=(()=>{const{sx:s,sy:n}=e,i=t.frame.x_scale.invert(s),r=t.frame.y_scale.invert(n);switch(e.type){case"wheel":return new l.MouseWheel(s,n,i,r,e.delta);case"mousemove":return new l.MouseMove(s,n,i,r);case"mouseenter":return new l.MouseEnter(s,n,i,r);case"mouseleave":return new l.MouseLeave(s,n,i,r);case"tap":return new l.Tap(s,n,i,r);case"doubletap":return new l.DoubleTap(s,n,i,r);case"press":return new l.Press(s,n,i,r);case"pressup":return new l.PressUp(s,n,i,r);case"pan":return new l.Pan(s,n,i,r,e.deltaX,e.deltaY);case"panstart":return new l.PanStart(s,n,i,r);case"panend":return new l.PanEnd(s,n,i,r);case"pinch":return new l.Pinch(s,n,i,r,e.scale);case"pinchstart":return new l.PinchStart(s,n,i,r);case"pinchend":return new l.PinchEnd(s,n,i,r);case"rotate":return new l.Rotate(s,n,i,r,e.rotation);case"rotatestart":return new l.RotateStart(s,n,i,r);case"rotateend":return new l.RotateEnd(s,n,i,r);default:return}})();null!=s&&t.model.trigger_event(s)}_get_sxy(t){const{pageX:e,pageY:s}=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,{left:n,top:i}=o.offset(this.hit_area);return{sx:e-n,sy:s-i}}_pan_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_pinch_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_rotate_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_tap_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_move_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_scroll_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{delta:c.getDeltaY(t),shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_key_event(t){return{type:t.type,keyCode:t.keyCode}}_pan_start(t){const e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)}_pan(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)}_pan_end(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)}_pinch_start(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)}_pinch(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)}_pinch_end(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)}_rotate_start(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)}_rotate(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)}_rotate_end(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)}_tap(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)}_doubletap(t){this._trigger(this.doubletap,this._tap_event(t),t.srcEvent)}_press(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)}_pressup(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)}_mouse_enter(t){this._trigger(this.move_enter,this._move_event(t),t)}_mouse_move(t){this._trigger(this.move,this._move_event(t),t)}_mouse_exit(t){this._trigger(this.move_exit,this._move_event(t),t)}_mouse_wheel(t){this._trigger(this.scroll,this._scroll_event(t),t)}_context_menu(t){!this.menu.is_open&&this.menu.can_open&&t.preventDefault();const{sx:e,sy:s}=this._get_sxy(t);this.menu.toggle({left:e,top:s})}_key_down(t){this.trigger(this.keydown,this._key_event(t))}_key_up(t){this.trigger(this.keyup,this._key_event(t))}}s.UIEventBus=g,g.__name__="UIEventBus"},
function _(t,e,i,n,r){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,i,n,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=i.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,i){return setTimeout(T(t,i),e)}function p(t,e,i){return!!Array.isArray(t)&&(f(t,i[e],i),!0)}function f(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==r)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function v(e,i,n){var r="DEPRECATED METHOD: "+i+"\n"+n+" AT \n";return function(){var i=new Error("get-stack-trace"),n=i&&i.stack?i.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,n),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(t===r||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==r&&null!==n)for(var s in n)n.hasOwnProperty(s)&&(e[s]=n[s])}return e}:Object.assign;var d=v((function(t,e,i){for(var n=Object.keys(e),s=0;s<n.length;)(!i||i&&t[n[s]]===r)&&(t[n[s]]=e[n[s]]),s++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,i){var n,r=e.prototype;(n=t.prototype=Object.create(r)).constructor=t,n._super=r,i&&s(n,i)}function T(t,e){return function(){return t.apply(e,arguments)}}function y(t,e){return"function"==typeof t?t.apply(e&&e[0]||r,e):t}function E(t,e){return t===r?e:t}function I(t,e,i){f(S(e),(function(e){t.addEventListener(e,i,!1)}))}function A(t,e,i){f(S(e),(function(e){t.removeEventListener(e,i,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function P(t){return Array.prototype.slice.call(t,0)}function D(t,e,i){for(var n=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&n.push(t[s]),r[s]=o,s++}return i&&(n=e?n.sort((function(t,i){return t[e]>i[e]})):n.sort()),n}function x(t,e){for(var i,n,s=e[0].toUpperCase()+e.slice(1),a=0;a<o.length;){if((n=(i=o[a])?i+s:e)in t)return n;a++}return r}var w=1;function O(e){var i=e.ownerDocument||e;return i.defaultView||i.parentWindow||t}var R="ontouchstart"in t,M=x(t,"PointerEvent")!==r,z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N="touch",X="mouse",Y=24,F=["x","y"],W=["clientX","clientY"];function q(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){y(t.options.enable,[t])&&i.handler(e)},this.init()}function k(t,e,i){var n=i.pointers.length,s=i.changedPointers.length,o=1&e&&n-s==0,a=12&e&&n-s==0;i.isFirst=!!o,i.isFinal=!!a,o&&(t.session={}),i.eventType=e,function(t,e){var i=t.session,n=e.pointers,s=n.length;i.firstInput||(i.firstInput=H(e));s>1&&!i.firstMultiple?i.firstMultiple=H(e):1===s&&(i.firstMultiple=!1);var o=i.firstInput,a=i.firstMultiple,h=a?a.center:o.center,l=e.center=L(n);e.timeStamp=c(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=G(h,l),e.distance=j(h,l),function(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y});e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}(i,e),e.offsetDirection=V(e.deltaX,e.deltaY);var p=U(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=p.x,e.overallVelocityY=p.y,e.overallVelocity=u(p.x)>u(p.y)?p.x:p.y,e.scale=a?(f=a.pointers,v=n,j(v[0],v[1],W)/j(f[0],f[1],W)):1,e.rotation=a?function(t,e){return G(e[1],e[0],W)+G(t[1],t[0],W)}(a.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,s,o,a=t.lastInterval||e,h=e.timeStamp-a.timeStamp;if(8!=e.eventType&&(h>25||a.velocity===r)){var c=e.deltaX-a.deltaX,l=e.deltaY-a.deltaY,p=U(h,c,l);n=p.x,s=p.y,i=u(p.x)>u(p.y)?p.x:p.y,o=V(c,l),t.lastInterval=e}else i=a.velocity,n=a.velocityX,s=a.velocityY,o=a.direction;e.velocity=i,e.velocityX=n,e.velocityY=s,e.direction=o}(i,e);var f,v;var d=t.element;_(e.srcEvent.target,d)&&(d=e.srcEvent.target);e.target=d}(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function H(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:h(t.pointers[i].clientX),clientY:h(t.pointers[i].clientY)},i++;return{timeStamp:c(),pointers:e,center:L(e),deltaX:t.deltaX,deltaY:t.deltaY}}function L(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:h(i/e),y:h(n/e)}}function U(t,e,i){return{x:e/t||0,y:i/t||0}}function V(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function j(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function G(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}q.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var Z={mousedown:1,mousemove:2,mouseup:4},B="mousedown",$="mousemove mouseup";function J(){this.evEl=B,this.evWin=$,this.pressed=!1,q.apply(this,arguments)}g(J,q,{handler:function(t){var e=Z[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:X,srcEvent:t}))}});var K={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Q={2:N,3:"pen",4:X,5:"kinect"},tt="pointerdown",et="pointermove pointerup pointercancel";function it(){this.evEl=tt,this.evWin=et,q.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(tt="MSPointerDown",et="MSPointerMove MSPointerUp MSPointerCancel"),g(it,q,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=K[n],s=Q[t.pointerType]||t.pointerType,o=s==N,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))}});var nt={touchstart:1,touchmove:2,touchend:4,touchcancel:8},rt="touchstart",st="touchstart touchmove touchend touchcancel";function ot(){this.evTarget=rt,this.evWin=st,this.started=!1,q.apply(this,arguments)}function at(t,e){var i=P(t.touches),n=P(t.changedTouches);return 12&e&&(i=D(i.concat(n),"identifier",!0)),[i,n]}g(ot,q,{handler:function(t){var e=nt[t.type];if(1===e&&(this.started=!0),this.started){var i=at.call(this,t,e);12&e&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}}});var ht={touchstart:1,touchmove:2,touchend:4,touchcancel:8},ut="touchstart touchmove touchend touchcancel";function ct(){this.evTarget=ut,this.targetIds={},q.apply(this,arguments)}function lt(t,e){var i=P(t.touches),n=this.targetIds;if(3&e&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,s,o=P(t.changedTouches),a=[],h=this.target;if(s=i.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)n[s[r].identifier]=!0,r++;for(r=0;r<o.length;)n[o[r].identifier]&&a.push(o[r]),12&e&&delete n[o[r].identifier],r++;return a.length?[D(s.concat(a),"identifier",!0),a]:void 0}g(ct,q,{handler:function(t){var e=ht[t.type],i=lt.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}});function pt(){q.apply(this,arguments);var t=T(this.handler,this);this.touch=new ct(this.manager,t),this.mouse=new J(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function ft(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,vt.call(this,e)):12&t&&vt.call(this,e)}function vt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches;setTimeout((function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)}),2500)}}function dt(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],s=Math.abs(e-r.x),o=Math.abs(i-r.y);if(s<=25&&o<=25)return!0}return!1}g(pt,q,{handler:function(t,e,i){var n=i.pointerType==N,r=i.pointerType==X;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)ft.call(this,e,i);else if(r&&dt.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var mt=x(a.style,"touchAction"),gt=mt!==r,Tt="compute",yt="auto",Et="manipulation",It="none",At="pan-x",_t="pan-y",Ct=function(){if(!gt)return!1;var e={},i=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(n){e[n]=!i||t.CSS.supports("touch-action",n)})),e}();function St(t,e){this.manager=t,this.set(e)}St.prototype={set:function(t){t==Tt&&(t=this.compute()),gt&&this.manager.element.style&&Ct[t]&&(this.manager.element.style[mt]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){y(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,It))return It;var e=C(t,At),i=C(t,_t);if(e&&i)return It;if(e||i)return e?At:_t;if(C(t,Et))return Et;return yt}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,r=C(n,It)&&!Ct.none,s=C(n,_t)&&!Ct["pan-y"],o=C(n,At)&&!Ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&i||o&&i&Y?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var bt=32;function Pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function Dt(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function xt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function wt(t,e){var i=e.manager;return i?i.get(t):t}function Ot(){Pt.apply(this,arguments)}function Rt(){Ot.apply(this,arguments),this.pX=null,this.pY=null}function Mt(){Ot.apply(this,arguments)}function zt(){Pt.apply(this,arguments),this._timer=null,this._input=null}function Nt(){Ot.apply(this,arguments)}function Xt(){Ot.apply(this,arguments)}function Yt(){Pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function Ft(t,e){return(e=e||{}).recognizers=E(e.recognizers,Ft.defaults.preset),new Wt(t,e)}Pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=wt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=wt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=wt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=wt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<8&&n(e.options.event+Dt(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=8&&n(e.options.event+Dt(i))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=bt},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!y(this.options.enable,[this,e]))return this.reset(),void(this.state=bt);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(Ot,Pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=6&e,r=this.attrTest(t);return n&&(8&i||!r)?16|e:n||r?4&i?8|e:2&e?4|e:2:bt}}),g(Rt,Ot,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push(_t),t&Y&&e.push(At),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,i=s!=this.pX,n=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,i=o!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return Ot.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=xt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(Mt,Ot,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(zt,Pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[yt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return bt},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Nt,Ot,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(Xt,Ot,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return Rt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return 30&i?e=t.overallVelocity:6&i?e=t.overallVelocityX:i&Y&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=xt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(Yt,Pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[Et]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(n&&r&&i){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||j(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return bt},failTimeout:function(){return this._timer=l((function(){this.state=bt}),this.options.interval,this),bt},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),Ft.VERSION="2.0.7",Ft.defaults={domEvents:!1,touchAction:Tt,enable:!0,inputTarget:null,inputClass:null,preset:[[Nt,{enable:!1}],[Mt,{enable:!1},["rotate"]],[Xt,{direction:6}],[Rt,{direction:6},["swipe"]],[Yt],[Yt,{event:"doubletap",taps:2},["tap"]],[zt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Wt(t,e){var i;this.options=s({},Ft.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(M?it:z?ct:R?pt:J))(i,k),this.touchAction=new St(this,this.options.touchAction),qt(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function qt(t,e){var i,n=t.element;n.style&&(f(t.options.cssProps,(function(r,s){i=x(n.style,s),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""})),e||(t.oldCssProps={}))}Wt.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<n.length;)i=n[s],2===e.stopped||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&14&i.state&&(r=e.curRecognizer=i),s++}},get:function(t){if(t instanceof Pt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=b(e,t);-1!==i&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==r&&e!==r){var i=this.handlers;return f(S(t),(function(t){i[t]=i[t]||[],i[t].push(e)})),this}},off:function(t,e){if(t!==r){var i=this.handlers;return f(S(t),(function(t){e?i[t]&&i[t].splice(b(i[t],e),1):delete i[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var n=i.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<n.length;)n[r](e),r++}},destroy:function(){this.element&&qt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(Ft,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:bt,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:Y,DIRECTION_ALL:30,Manager:Wt,Input:q,TouchAction:St,TouchInput:ct,MouseInput:J,PointerEventInput:it,TouchMouseInput:pt,SingleTouchInput:ot,Recognizer:Pt,AttrRecognizer:Ot,Tap:Yt,Pan:Rt,Swipe:Xt,Pinch:Mt,Rotate:Nt,Press:zt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:T,prefixed:x}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=Ft,"function"==typeof define&&define.amd?define((function(){return Ft})):void 0!==e&&e.exports?e.exports=Ft:t.Hammer=Ft}(window,document)},
function _(e,t,s,n,_){n();var a=this&&this.__decorate||function(e,t,s,n){var _,a=arguments.length,o=a<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,s):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)o=Reflect.decorate(e,t,s,n);else for(var c=e.length-1;c>=0;c--)(_=e[c])&&(o=(a<3?_(o):a>3?_(t,s,o):_(t,s))||o);return a>3&&o&&Object.defineProperty(t,s,o),o};function o(e){return function(t){t.prototype.event_name=e}}class c{to_json(){const{event_name:e}=this;return{event_name:e,event_values:this._to_json()}}}s.BokehEvent=c,c.__name__="BokehEvent";class r extends c{constructor(){super(...arguments),this.origin=null}_to_json(){return{model:this.origin}}}s.ModelEvent=r,r.__name__="ModelEvent";let l=class extends c{_to_json(){return{}}};s.DocumentReady=l,l.__name__="DocumentReady",s.DocumentReady=l=a([o("document_ready")],l);let i=class extends r{};s.ButtonClick=i,i.__name__="ButtonClick",s.ButtonClick=i=a([o("button_click")],i);let u=class extends r{constructor(e){super(),this.item=e}_to_json(){const{item:e}=this;return Object.assign(Object.assign({},super._to_json()),{item:e})}};s.MenuItemClick=u,u.__name__="MenuItemClick",s.MenuItemClick=u=a([o("menu_item_click")],u);class d extends r{}s.UIEvent=d,d.__name__="UIEvent";let h=class extends d{};s.LODStart=h,h.__name__="LODStart",s.LODStart=h=a([o("lodstart")],h);let m=class extends d{};s.LODEnd=m,m.__name__="LODEnd",s.LODEnd=m=a([o("lodend")],m);let x=class extends d{constructor(e,t){super(),this.geometry=e,this.final=t}_to_json(){const{geometry:e,final:t}=this;return Object.assign(Object.assign({},super._to_json()),{geometry:e,final:t})}};s.SelectionGeometry=x,x.__name__="SelectionGeometry",s.SelectionGeometry=x=a([o("selectiongeometry")],x);let p=class extends d{};s.Reset=p,p.__name__="Reset",s.Reset=p=a([o("reset")],p);class j extends d{constructor(e,t,s,n){super(),this.sx=e,this.sy=t,this.x=s,this.y=n}_to_json(){const{sx:e,sy:t,x:s,y:n}=this;return Object.assign(Object.assign({},super._to_json()),{sx:e,sy:t,x:s,y:n})}}s.PointEvent=j,j.__name__="PointEvent";let y=class extends j{constructor(e,t,s,n,_,a){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.delta_x=_,this.delta_y=a}_to_json(){const{delta_x:e,delta_y:t}=this;return Object.assign(Object.assign({},super._to_json()),{delta_x:e,delta_y:t})}};s.Pan=y,y.__name__="Pan",s.Pan=y=a([o("pan")],y);let P=class extends j{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.scale=_}_to_json(){const{scale:e}=this;return Object.assign(Object.assign({},super._to_json()),{scale:e})}};s.Pinch=P,P.__name__="Pinch",s.Pinch=P=a([o("pinch")],P);let v=class extends j{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.rotation=_}_to_json(){const{rotation:e}=this;return Object.assign(Object.assign({},super._to_json()),{rotation:e})}};s.Rotate=v,v.__name__="Rotate",s.Rotate=v=a([o("rotate")],v);let g=class extends j{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.delta=_}_to_json(){const{delta:e}=this;return Object.assign(Object.assign({},super._to_json()),{delta:e})}};s.MouseWheel=g,g.__name__="MouseWheel",s.MouseWheel=g=a([o("wheel")],g);let E=class extends j{};s.MouseMove=E,E.__name__="MouseMove",s.MouseMove=E=a([o("mousemove")],E);let O=class extends j{};s.MouseEnter=O,O.__name__="MouseEnter",s.MouseEnter=O=a([o("mouseenter")],O);let b=class extends j{};s.MouseLeave=b,b.__name__="MouseLeave",s.MouseLeave=b=a([o("mouseleave")],b);let M=class extends j{};s.Tap=M,M.__name__="Tap",s.Tap=M=a([o("tap")],M);let R=class extends j{};s.DoubleTap=R,R.__name__="DoubleTap",s.DoubleTap=R=a([o("doubletap")],R);let f=class extends j{};s.Press=f,f.__name__="Press",s.Press=f=a([o("press")],f);let S=class extends j{};s.PressUp=S,S.__name__="PressUp",s.PressUp=S=a([o("pressup")],S);let D=class extends j{};s.PanStart=D,D.__name__="PanStart",s.PanStart=D=a([o("panstart")],D);let k=class extends j{};s.PanEnd=k,k.__name__="PanEnd",s.PanEnd=k=a([o("panend")],k);let L=class extends j{};s.PinchStart=L,L.__name__="PinchStart",s.PinchStart=L=a([o("pinchstart")],L);let C=class extends j{};s.PinchEnd=C,C.__name__="PinchEnd",s.PinchEnd=C=a([o("pinchend")],C);let T=class extends j{};s.RotateStart=T,T.__name__="RotateStart",s.RotateStart=T=a([o("rotatestart")],T);let B=class extends j{};s.RotateEnd=B,B.__name__="RotateEnd",s.RotateEnd=B=a([o("rotateend")],B)},
function _(t,e,n,l,o){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function u(t){const e=getComputedStyle(t).fontSize;return null!=e?parseInt(e,10):null}l(),n.getDeltaY=function(t){let e=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:e*=(n=t.target,null!==(a=null!==(o=u(null!==(l=n.offsetParent)&&void 0!==l?l:document.body))&&void 0!==o?o:u(n))&&void 0!==a?a:16);break;case t.DOM_DELTA_PAGE:e*=function(t){return t.clientHeight}(t.target)}var n,l,o,a;return e}},
function _(n,e,i,t,r){t(),i.is_ie=(()=>{const n="undefined"!=typeof navigator?navigator.userAgent:"";return n.indexOf("MSIE")>=0||n.indexOf("Trident")>0||n.indexOf("Edge")>0})(),i.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),i.is_little_endian=(()=>{const n=new ArrayBuffer(4),e=new Uint8Array(n);new Uint32Array(n)[1]=168496141;let i=!0;return 10==e[4]&&11==e[5]&&12==e[6]&&13==e[7]&&(i=!1),i})()},
function _(t,e,i,n,s){n();const o=t(1),l=t(71),h=t(84),d=o.__importStar(t(85));class r{constructor(t,e={}){this.items=t,this.options=e,this.el=l.div(),this._open=!1,this._item_click=t=>{var e;null===(e=this.items[t])||void 0===e||e.handler(),this.hide()},this._on_mousedown=t=>{var e,i;const{target:n}=t;n instanceof Node&&this.el.contains(n)||(null===(i=(e=this.options).prevent_hide)||void 0===i?void 0:i.call(e,t))||this.hide()},this._on_keydown=t=>{t.keyCode==l.Keys.Esc&&this.hide()},this._on_blur=()=>{this.hide()},l.undisplay(this.el)}get is_open(){return this._open}get can_open(){return 0!=this.items.length}remove(){l.remove(this.el),this._unlisten()}_listen(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)}_unlisten(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)}_position(t){const e=this.el.parentElement;if(null!=e){const i=e.getBoundingClientRect();this.el.style.left=null!=t.left?t.left-i.left+"px":"",this.el.style.top=null!=t.top?t.top-i.top+"px":"",this.el.style.right=null!=t.right?i.right-t.right+"px":"",this.el.style.bottom=null!=t.bottom?i.bottom-t.bottom+"px":""}}render(){var t,e;l.empty(this.el,!0);const i=null!==(t=this.options.orientation)&&void 0!==t?t:"vertical";l.classes(this.el).add("bk-context-menu","bk-"+i);for(const[t,i]of h.enumerate(this.items)){let n;if(null==t)n=l.div({class:d.bk_divider});else{if(null!=t.if&&!t.if())continue;{const i=null!=t.icon?l.div({class:["bk-menu-icon",t.icon]}):null;n=l.div({class:(null===(e=t.active)||void 0===e?void 0:e.call(t))?"bk-active":null,title:t.tooltip},i,t.label)}}n.addEventListener("click",()=>this._item_click(i)),this.el.appendChild(n)}}show(t){if(0!=this.items.length&&!this._open){if(this.render(),0==this.el.children.length)return;this._position(null!=t?t:{left:0,top:0}),l.display(this.el),this._listen(),this._open=!0}}hide(){this._open&&(this._open=!1,this._unlisten(),l.undisplay(this.el))}toggle(t){this._open?this.hide():this.show(t)}}i.ContextMenu=r,r.__name__="ContextMenu"},
function _(n,e,o,t,r){t();const f=n(9);function*i(n,e){const o=n.length;if(e>o)return;const t=f.range(e);for(yield t.map(e=>n[e]);;){let r;for(const n of f.reversed(f.range(e)))if(t[n]!=n+o-e){r=n;break}if(null==r)return;t[r]+=1;for(const n of f.range(r+1,e))t[n]=t[n-1]+1;yield t.map(e=>n[e])}}o.enumerate=function*(n){let e=0;for(const o of n)yield[o,e++]},o.combinations=i,o.subsets=function*(n){for(const e of f.range(n.length+1))yield*i(n,e)}},
function _(b,e,k,i,d){i(),k.bk_menu="bk-menu",k.bk_caret="bk-caret",k.bk_divider="bk-divider"},
function _(t,i,e,h,r){h();const s=t(24),{min:n,max:x}=Math;e.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},e.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},e.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},e.union=function(t,i){return{x0:n(t.x0,i.x0),x1:x(t.x1,i.x1),y0:n(t.y0,i.y0),y1:x(t.y1,i.y1)}};class y{constructor(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){const{x0:i,y0:e,x1:h,y1:r}=t;if(!(i<=h&&e<=r))throw new Error(`invalid bbox {x0: ${i}, y0: ${e}, x1: ${h}, y1: ${r}}`);this.x0=i,this.y0=e,this.x1=h,this.y1=r}else if("x"in t){const{x:i,y:e,width:h,height:r}=t;if(!(h>=0&&r>=0))throw new Error(`invalid bbox {x: ${i}, y: ${e}, width: ${h}, height: ${r}}`);this.x0=i,this.y0=e,this.x1=i+h,this.y1=e+r}else{let i,e,h,r;if("width"in t)if("left"in t)i=t.left,e=i+t.width;else if("right"in t)e=t.right,i=e-t.width;else{const h=t.width/2;i=t.hcenter-h,e=t.hcenter+h}else i=t.left,e=t.right;if("height"in t)if("top"in t)h=t.top,r=h+t.height;else if("bottom"in t)r=t.bottom,h=r-t.height;else{const i=t.height/2;h=t.vcenter-i,r=t.vcenter+i}else h=t.top,r=t.bottom;if(!(i<=e&&h<=r))throw new Error(`invalid bbox {left: ${i}, top: ${h}, right: ${e}, bottom: ${r}}`);this.x0=i,this.y0=h,this.x1=e,this.y1=r}}toString(){return`BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`}get left(){return this.x0}get top(){return this.y0}get right(){return this.x1}get bottom(){return this.y1}get p0(){return[this.x0,this.y0]}get p1(){return[this.x1,this.y1]}get x(){return this.x0}get y(){return this.y0}get width(){return this.x1-this.x0}get height(){return this.y1-this.y0}get rect(){return{x0:this.x0,y0:this.y0,x1:this.x1,y1:this.y1}}get box(){return{x:this.x,y:this.y,width:this.width,height:this.height}}get h_range(){return{start:this.x0,end:this.x1}}get v_range(){return{start:this.y0,end:this.y1}}get ranges(){return[this.h_range,this.v_range]}get aspect(){return this.width/this.height}get hcenter(){return(this.left+this.right)/2}get vcenter(){return(this.top+this.bottom)/2}relative(){const{width:t,height:i}=this;return new y({x:0,y:0,width:t,height:i})}relativize(t,i){return[t-this.x,i-this.y]}contains(t,i){return t>=this.x0&&t<=this.x1&&i>=this.y0&&i<=this.y1}clip(t,i){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),i<this.y0?i=this.y0:i>this.y1&&(i=this.y1),[t,i]}union(t){return new y({x0:n(this.x0,t.x0),y0:n(this.y0,t.y0),x1:x(this.x1,t.x1),y1:x(this.y1,t.y1)})}equals(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1}get xview(){return{compute:t=>this.left+t,v_compute:t=>{const i=new s.NumberArray(t.length),e=this.left;for(let h=0;h<t.length;h++)i[h]=e+t[h];return i}}}get yview(){return{compute:t=>this.bottom-t,v_compute:t=>{const i=new s.NumberArray(t.length),e=this.bottom;for(let h=0;h<t.length;h++)i[h]=e-t[h];return i}}}}e.BBox=y,y.__name__="BBox"},
function _(e,t,n,o,a){o(),n.fixup_ctx=function(e){!function(e){void 0===e.lineDash&&Object.defineProperty(e,"lineDash",{get:()=>e.getLineDash(),set:t=>e.setLineDash(t)})}(e),function(e){e.setImageSmoothingEnabled=t=>{e.imageSmoothingEnabled=t,e.mozImageSmoothingEnabled=t,e.oImageSmoothingEnabled=t,e.webkitImageSmoothingEnabled=t,e.msImageSmoothingEnabled=t},e.getImageSmoothingEnabled=()=>{const t=e.imageSmoothingEnabled;return null==t||t}}(e),function(e){e.measureText&&null==e.html5MeasureText&&(e.html5MeasureText=e.measureText,e.measureText=t=>{const n=e.html5MeasureText(t);return n.ascent=1.6*e.html5MeasureText("m").width,n})}(e),function(e){e.ellipse||(e.ellipse=function(t,n,o,a,i,m,l,r=!1){const s=.551784;e.translate(t,n),e.rotate(i);let u=o,g=a;r&&(u=-o,g=-a),e.moveTo(-u,0),e.bezierCurveTo(-u,g*s,-u*s,g,0,g),e.bezierCurveTo(u*s,g,u,g*s,u,0),e.bezierCurveTo(u,-g*s,u*s,-g,0,-g),e.bezierCurveTo(-u*s,-g,-u,-g*s,-u,0),e.rotate(-i),e.translate(-t,-n)})}(e)}},
function _(e,t,s,n,c){n();const i=e(14),a=e(8),r=e(13),o=e(19);class l extends i.HasProps{constructor(e){super(e)}static init_Model(){this.define(({Any:e,Unknown:t,String:s,Array:n,Dict:c,Nullable:i})=>({tags:[n(t),[]],name:[i(s),null],js_property_callbacks:[c(n(e)),{}],js_event_callbacks:[c(n(e)),{}],subscribed_events:[n(s),[]]}))}initialize(){super.initialize(),this._js_callbacks=new Map}connect_signals(){super.connect_signals(),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,()=>this._update_property_callbacks()),this.connect(this.properties.js_event_callbacks.change,()=>this._update_event_callbacks()),this.connect(this.properties.subscribed_events.change,()=>this._update_event_callbacks())}_process_event(e){var t;for(const s of null!==(t=this.js_event_callbacks[e.event_name])&&void 0!==t?t:[])s.execute(e);null!=this.document&&this.subscribed_events.some(t=>t==e.event_name)&&this.document.event_manager.send_event(e)}trigger_event(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))}_update_event_callbacks(){null!=this.document?this.document.event_manager.subscribed_models.add(this):o.logger.warn("WARNING: Document not defined for updating event callbacks")}_update_property_callbacks(){const e=e=>{const[t,s=null]=e.split(":");return null!=s?this.properties[s][t]:this[t]};for(const[t,s]of this._js_callbacks){const n=e(t);for(const e of s)this.disconnect(n,e)}this._js_callbacks.clear();for(const[t,s]of r.entries(this.js_property_callbacks)){const n=s.map(e=>()=>e.execute(this));this._js_callbacks.set(t,n);const c=e(t);for(const e of n)this.connect(c,e)}}_doc_attached(){r.isEmpty(this.js_event_callbacks)&&0==this.subscribed_events.length||this._update_event_callbacks()}_doc_detached(){this.document.event_manager.subscribed_models.delete(this)}select(e){if(a.isString(e))return[...this.references()].filter(t=>t instanceof l&&t.name===e);if(e.prototype instanceof i.HasProps)return[...this.references()].filter(t=>t instanceof e);throw new Error("invalid selector")}select_one(e){const t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}}}s.Model=l,l.__name__="Model",l.init_Model()},
function _(s,e,_,t,a){t();class r{constructor(s,e){this.x_scale=s,this.y_scale=e,this.x_range=this.x_scale.source_range,this.y_range=this.y_scale.source_range,this.ranges=[this.x_range,this.y_range],this.scales=[this.x_scale,this.y_scale]}map_to_screen(s,e){return[this.x_scale.v_compute(s),this.y_scale.v_compute(e)]}map_from_screen(s,e){return[this.x_scale.v_invert(s),this.y_scale.v_invert(e)]}}_.CoordinateTransform=r,r.__name__="CoordinateTransform"},
function _(t,e,s,i,a){i();const r=t(1),o=t(35),n=t(91),_=t(92),h=t(130),l=t(28),d=t(20),c=t(123),u=r.__importStar(t(18)),p=t(10);class m extends o.AnnotationView{initialize(){super.initialize(),this.set_data(this.model.source)}async lazy_initialize(){await super.lazy_initialize();const{start:t,end:e}=this.model,{parent:s}=this;null!=t&&(this.start=await c.build_view(t,{parent:s})),null!=e&&(this.end=await c.build_view(e,{parent:s}))}remove(){var t,e;null===(t=this.start)||void 0===t||t.remove(),null===(e=this.end)||void 0===e||e.remove(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.set_data(this.model.source)),this.connect(this.model.source.streaming,()=>this.set_data(this.model.source)),this.connect(this.model.source.patching,()=>this.set_data(this.model.source)),this.connect(this.model.source.change,()=>this.set_data(this.model.source))}set_data(t){super.set_data(t),this.visuals.warm_cache(t),this.plot_view.request_render()}_map_data(){const{frame:t}=this.plot_view;let e,s,i,a;return"data"==this.model.start_units?(e=this.coordinates.x_scale.v_compute(this._x_start),s=this.coordinates.y_scale.v_compute(this._y_start)):(e=t.xview.v_compute(this._x_start),s=t.yview.v_compute(this._y_start)),"data"==this.model.end_units?(i=this.coordinates.x_scale.v_compute(this._x_end),a=this.coordinates.y_scale.v_compute(this._y_end)):(i=t.xview.v_compute(this._x_end),a=t.yview.v_compute(this._y_end)),[[e,s],[i,a]]}_render(){const{ctx:t}=this.layer;t.save();const[e,s]=this._map_data();null!=this.end&&this._arrow_head(t,"render",this.end,e,s),null!=this.start&&this._arrow_head(t,"render",this.start,s,e),t.beginPath();const{x:i,y:a,width:r,height:o}=this.plot_view.frame.bbox;t.rect(i,a,r,o),null!=this.end&&this._arrow_head(t,"clip",this.end,e,s),null!=this.start&&this._arrow_head(t,"clip",this.start,s,e),t.closePath(),t.clip(),this._arrow_body(t,e,s),t.restore()}_arrow_head(t,e,s,i,a){for(let r=0,o=this._x_start.length;r<o;r++){const o=Math.PI/2+p.atan2([i[0][r],i[1][r]],[a[0][r],a[1][r]]);t.save(),t.translate(a[0][r],a[1][r]),t.rotate(o),"render"==e?s.render(t,r):"clip"==e&&s.clip(t,r),t.restore()}}_arrow_body(t,e,s){if(this.visuals.line.doit)for(let i=0,a=this._x_start.length;i<a;i++)this.visuals.line.set_vectorize(t,i),t.beginPath(),t.moveTo(e[0][i],e[1][i]),t.lineTo(s[0][i],s[1][i]),t.stroke()}}s.ArrowView=m,m.__name__="ArrowView";class w extends o.Annotation{constructor(t){super(t)}static init_Arrow(){this.prototype.default_view=m,this.mixins(l.LineVector),this.define(({Ref:t,Nullable:e})=>({x_start:[u.XCoordinateSpec],y_start:[u.YCoordinateSpec],start_units:[d.SpatialUnits,"data"],start:[e(t(n.ArrowHead)),null],x_end:[u.XCoordinateSpec],y_end:[u.YCoordinateSpec],end_units:[d.SpatialUnits,"data"],end:[e(t(n.ArrowHead)),()=>new n.OpenHead],source:[t(_.ColumnarDataSource),()=>new h.ColumnDataSource]}))}}s.Arrow=w,w.__name__="Arrow",w.init_Arrow()},
function _(e,i,s,t,o){t();const l=e(1),n=e(88),a=e(70),r=l.__importStar(e(73)),_=e(28);class d extends a.View{initialize(){super.initialize(),this.visuals=new r.Visuals(this.model)}}s.ArrowHeadView=d,d.__name__="ArrowHeadView";class c extends n.Model{constructor(e){super(e)}static init_ArrowHead(){this.define(({Number:e})=>({size:[e,25]}))}}s.ArrowHead=c,c.__name__="ArrowHead",c.init_ArrowHead();class h extends d{clip(e,i){this.visuals.line.set_vectorize(e,i);const{size:s}=this.model;e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(0,0),e.lineTo(.5*s,s)}render(e,i){if(this.visuals.line.doit){this.visuals.line.set_vectorize(e,i);const{size:s}=this.model;e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.stroke()}}}s.OpenHeadView=h,h.__name__="OpenHeadView";class v extends c{constructor(e){super(e)}static init_OpenHead(){this.prototype.default_view=h,this.mixins(_.LineVector)}}s.OpenHead=v,v.__name__="OpenHead",v.init_OpenHead();class m extends d{clip(e,i){this.visuals.line.set_vectorize(e,i);const{size:s}=this.model;e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(.5*s,s)}render(e,i){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,i),this._normal(e,i),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,i),this._normal(e,i),e.stroke())}_normal(e,i){const{size:s}=this.model;e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.closePath()}}s.NormalHeadView=m,m.__name__="NormalHeadView";class T extends c{constructor(e){super(e)}static init_NormalHead(){this.prototype.default_view=m,this.mixins([_.LineVector,_.FillVector]),this.override({fill_color:"black"})}}s.NormalHead=T,T.__name__="NormalHead",T.init_NormalHead();class u extends d{clip(e,i){this.visuals.line.set_vectorize(e,i);const{size:s}=this.model;e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(0,.5*s),e.lineTo(.5*s,s)}render(e,i){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,i),this._vee(e,i),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,i),this._vee(e,i),e.stroke())}_vee(e,i){const{size:s}=this.model;e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.lineTo(0,.5*s),e.closePath()}}s.VeeHeadView=u,u.__name__="VeeHeadView";class H extends c{constructor(e){super(e)}static init_VeeHead(){this.prototype.default_view=u,this.mixins([_.LineVector,_.FillVector]),this.override({fill_color:"black"})}}s.VeeHead=H,H.__name__="VeeHead",H.init_VeeHead();class p extends d{render(e,i){if(this.visuals.line.doit){this.visuals.line.set_vectorize(e,i);const{size:s}=this.model;e.beginPath(),e.moveTo(.5*s,0),e.lineTo(-.5*s,0),e.stroke()}}clip(e,i){}}s.TeeHeadView=p,p.__name__="TeeHeadView";class V extends c{constructor(e){super(e)}static init_TeeHead(){this.prototype.default_view=p,this.mixins(_.LineVector)}}s.TeeHead=V,V.__name__="TeeHead",V.init_TeeHead()},
function _(t,e,n,a,i){a();const s=t(93),r=t(15),l=t(19),o=t(102),c=t(8),u=t(9),h=t(13),g=t(94),d=t(129);class m extends s.DataSource{constructor(t){super(t)}get_array(t){let e=this.data[t];return null==e?this.data[t]=e=[]:c.isArray(e)||(this.data[t]=e=Array.from(e)),e}static init_ColumnarDataSource(){this.define(({Ref:t})=>({selection_policy:[t(d.SelectionPolicy),()=>new d.UnionRenderers]})),this.internal(({Ref:t})=>({selection_manager:[t(o.SelectionManager),t=>new o.SelectionManager({source:t})],inspected:[t(g.Selection),()=>new g.Selection]}))}initialize(){super.initialize(),this._select=new r.Signal0(this,"select"),this.inspect=new r.Signal(this,"inspect"),this.streaming=new r.Signal0(this,"streaming"),this.patching=new r.Signal(this,"patching")}get_column(t){const e=this.data[t];return null!=e?e:null}columns(){return h.keys(this.data)}get_length(t=!0){const e=u.uniq(h.values(this.data).map(t=>t.length));switch(e.length){case 0:return null;case 1:return e[0];default:{const n="data source has columns of inconsistent lengths";if(t)return l.logger.warn(n),e.sort()[0];throw new Error(n)}}}get length(){var t;return null!==(t=this.get_length())&&void 0!==t?t:0}clear(){const t={};for(const e of this.columns())t[e]=new this.data[e].constructor(0);this.data=t}}n.ColumnarDataSource=m,m.__name__="ColumnarDataSource",m.init_ColumnarDataSource()},
function _(e,t,c,n,a){n();const o=e(88),i=e(94);class s extends o.Model{constructor(e){super(e)}static init_DataSource(){this.define(({Ref:e})=>({selected:[e(i.Selection),()=>new i.Selection]}))}}c.DataSource=s,s.__name__="DataSource",s.init_DataSource()},
function _(i,e,s,t,n){t();const l=i(88),c=i(9),h=i(13),d=i(95);class _ extends l.Model{constructor(i){super(i)}get_view(){return this.view}static init_Selection(){this.define(({Int:i,Array:e,Dict:s})=>({indices:[e(i),[]],line_indices:[e(i),[]],multiline_indices:[s(e(i)),{}]})),this.internal(({Int:i,Array:e,Ref:s,Struct:t,Nullable:n})=>({selected_glyphs:[e(s(d.Glyph)),[]],view:[n(s(d.GlyphView)),null],image_indices:[e(t({index:i,dim1:i,dim2:i,flat_index:i})),[]]}))}get selected_glyph(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null}add_to_selected_glyphs(i){this.selected_glyphs.push(i)}update(i,e=!0,s="replace"){switch(s){case"replace":this.indices=i.indices,this.line_indices=i.line_indices,this.selected_glyphs=i.selected_glyphs,this.view=i.view,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices;break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i)}}clear(){this.indices=[],this.line_indices=[],this.multiline_indices={},this.view=null,this.selected_glyphs=[]}is_empty(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length}update_through_union(i){this.indices=c.union(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)}update_through_intersection(i){this.indices=c.intersection(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)}update_through_subtraction(i){this.indices=c.difference(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)}}s.Selection=_,_.__name__="Selection",_.init_Selection()},
function _(t,e,i,s,n){s();const a=t(1),r=a.__importStar(t(18)),_=a.__importStar(t(86)),o=a.__importStar(t(73)),l=t(70),h=t(88),d=t(19),c=t(24),u=t(96),p=t(12),y=t(97),f=t(100),g=t(94);class x extends l.View{constructor(){super(...arguments),this._index=null,this._data_size=null,this._nohit_warned=new Set}get renderer(){return this.parent}get has_webgl(){return null!=this.glglyph}get index(){const{_index:t}=this;if(null!=t)return t;throw new Error(this+".index_data() wasn't called")}get data_size(){const{_data_size:t}=this;if(null!=t)return t;throw new Error(this+".set_data() wasn't called")}initialize(){super.initialize(),this.visuals=new o.Visuals(this.model)}set_visuals(t,e){this.visuals.warm_cache(t,e),null!=this.glglyph&&this.glglyph.set_visuals_changed()}render(t,e,i){t.beginPath(),null!=this.glglyph&&(this.renderer.needs_webgl_blit=this.glglyph.render(t,e,i),this.renderer.needs_webgl_blit)||this._render(t,e,i)}has_finished(){return!0}notify_finished(){this.renderer.notify_finished()}_bounds(t){return t}bounds(){return this._bounds(this.index.bbox)}log_bounds(){const{x0:t,x1:e}=this.index.bounds(_.positive_x()),{y0:i,y1:s}=this.index.bounds(_.positive_y());return this._bounds({x0:t,y0:i,x1:e,y1:s})}get_anchor_point(t,e,[i,s]){switch(t){case"center":{const[t,n]=this.scenterxy(e,i,s);return{x:t,y:n}}default:return null}}scenterx(t,e,i){return this.scenterxy(t,e,i)[0]}scentery(t,e,i){return this.scenterxy(t,e,i)[1]}sdist(t,e,i,s="edge",n=!1){let a,r;const _=e.length;if("center"==s){const t=p.map(i,t=>t/2);a=new Float64Array(_);for(let i=0;i<_;i++)a[i]=e[i]-t[i];r=new Float64Array(_);for(let i=0;i<_;i++)r[i]=e[i]+t[i]}else{a=e,r=new Float64Array(_);for(let t=0;t<_;t++)r[t]=a[t]+i[t]}const o=t.v_compute(a),l=t.v_compute(r);return n?p.map(o,(t,e)=>Math.ceil(Math.abs(l[e]-o[e]))):p.map(o,(t,e)=>Math.abs(l[e]-o[e]))}draw_legend_for_index(t,e,i){}hit_test(t){switch(t.type){case"point":if(null!=this._hit_point)return this._hit_point(t);break;case"span":if(null!=this._hit_span)return this._hit_span(t);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(t);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(t)}return this._nohit_warned.has(t.type)||(d.logger.debug(`'${t.type}' selection not available for ${this.model.type}`),this._nohit_warned.add(t.type)),null}_hit_rect_against_index(t){const{sx0:e,sx1:i,sy0:s,sy1:n}=t,[a,r]=this.renderer.coordinates.x_scale.r_invert(e,i),[_,o]=this.renderer.coordinates.y_scale.r_invert(s,n),l=[...this.index.indices({x0:a,x1:r,y0:_,y1:o})];return new g.Selection({indices:l})}_project_data(){}set_data(t,e,i){var s;const{x_range:n,y_range:a}=this.renderer.coordinates;this._data_size=e.count;for(const i of this.model){if(!(i instanceof r.VectorSpec))continue;if(i.optional&&null==i.spec.value&&!i.dirty)continue;const s=i.attr,_=i.array(t);let o=e.select(_);if(i instanceof r.BaseCoordinateSpec){const t="x"==i.dimension?n:a;if(t instanceof f.FactorRange)if(i instanceof r.CoordinateSpec)o=t.v_synthetic(o);else if(i instanceof r.CoordinateSeqSpec)for(let e=0;e<o.length;e++)o[e]=t.v_synthetic(o[e]);i instanceof r.CoordinateSeqSpec&&(o=u.RaggedArray.from(o))}else i instanceof r.DistanceSpec&&(this["max_"+s]=p.max(o));this["_"+s]=o}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(i),null===(s=this.glglyph)||void 0===s||s.set_data_changed(),this.index_data()}_set_data(t){}get _index_size(){return this.data_size}index_data(){const t=new y.SpatialIndex(this._index_size);this._index_data(t),t.finish(),this._index=t}mask_data(){return null==this._mask_data?c.Indices.all_set(this.data_size):this._mask_data()}map_data(){var t;const e=this,{x_scale:i,y_scale:s}=this.renderer.coordinates;for(const t of this.model)if(t instanceof r.BaseCoordinateSpec){const n="x"==t.dimension?i:s;let a=e["_"+t.attr];if(a instanceof u.RaggedArray){const t=n.v_compute(a.array);a=new u.RaggedArray(a.offsets,t)}else a=n.v_compute(a);this["s"+t.attr]=a}this._map_data(),null===(t=this.glglyph)||void 0===t||t.set_data_changed()}_map_data(){}}i.GlyphView=x,x.__name__="GlyphView";class m extends h.Model{constructor(t){super(t)}static init_Glyph(){}}i.Glyph=m,m.__name__="Glyph",m.init_Glyph()},
function _(t,r,s,e,a){e();const n=t(24),o=t(26),h=t(11);class i{constructor(t,r){this.offsets=t,this.array=r}[o.equals](t,r){return r.arrays(this.offsets,t.offsets)&&r.arrays(this.array,t.array)}get length(){return this.offsets.length}clone(){return new i(new Uint32Array(this.offsets),new n.NumberArray(this.array))}static from(t){const r=t.length,s=new Uint32Array(r);let e=0;for(let a=0;a<r;a++){const r=t[a].length;s[a]=e,e+=r}const a=new n.NumberArray(e);for(let e=0;e<r;e++)a.set(t[e],s[e]);return new i(s,a)}*[Symbol.iterator](){const{offsets:t,length:r}=this;for(let s=0;s<r;s++)yield this.array.subarray(t[s],t[s+1])}_check_bounds(t){h.assert(0<=t&&t<this.length,`Out of bounds: 0 <= ${t} < ${this.length}`)}get(t){this._check_bounds(t);const{offsets:r}=this;return this.array.subarray(r[t],r[t+1])}set(t,r){this._check_bounds(t),this.array.set(r,this.offsets[t])}}s.RaggedArray=i,i.__name__="RaggedArray",i[Symbol.toStringTag]="RaggedArray"},
function _(n,i,t,e,s){e();const o=n(1).__importDefault(n(98)),d=n(24),x=n(86);function h(n,i){let t=0,e=i.length-1;for(;t<e;){const s=t+e>>1;i[s]>n?e=s:t=s+1}return i[t]}class r extends o.default{search_indices(n,i,t,e){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let s=this._boxes.length-4;const o=[],x=new d.Indices(this.numItems);for(;void 0!==s;){const d=Math.min(s+4*this.nodeSize,h(s,this._levelBounds));for(let h=s;h<d;h+=4){const d=0|this._indices[h>>2];t<this._boxes[h+0]||(e<this._boxes[h+1]||n>this._boxes[h+2]||i>this._boxes[h+3]||(s<4*this.numItems?x.set(d):o.push(d)))}s=o.pop()}return x}}r.__name__="_FlatBush";class l{constructor(n){this.index=null,n>0&&(this.index=new r(n))}add(n,i,t,e){var s;null===(s=this.index)||void 0===s||s.add(n,i,t,e)}add_empty(){var n;null===(n=this.index)||void 0===n||n.add(1/0,1/0,-1/0,-1/0)}finish(){var n;null===(n=this.index)||void 0===n||n.finish()}_normalize(n){let{x0:i,y0:t,x1:e,y1:s}=n;return i>e&&([i,e]=[e,i]),t>s&&([t,s]=[s,t]),{x0:i,y0:t,x1:e,y1:s}}get bbox(){if(null==this.index)return x.empty();{const{minX:n,minY:i,maxX:t,maxY:e}=this.index;return{x0:n,y0:i,x1:t,y1:e}}}indices(n){if(null==this.index)return new d.Indices(0);{const{x0:i,y0:t,x1:e,y1:s}=this._normalize(n);return this.index.search_indices(i,t,e,s)}}bounds(n){const i=x.empty();for(const t of this.indices(n)){const n=this.index._boxes,e=n[4*t+0],s=n[4*t+1],o=n[4*t+2],d=n[4*t+3];o<i.x0&&(i.x0=o),e>i.x1&&(i.x1=e),d<i.y0&&(i.y0=d),s>i.y1&&(i.y1=s)}return i}}t.SpatialIndex=l,l.__name__="SpatialIndex"},
function _(t,s,i,e,h){e();const n=t(1).__importDefault(t(99)),o=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class r{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[s,i]=new Uint8Array(t,0,2);if(251!==s)throw new Error("Data does not appear to be in a Flatbush format.");if(i>>4!=3)throw new Error(`Got v${i>>4} data when expected v3.`);const[e]=new Uint16Array(t,2,1),[h]=new Uint32Array(t,4,1);return new r(h,e,o[15&i],t)}constructor(t,s=16,i=Float64Array,e){if(void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+s,2),65535);let h=t,r=h;this._levelBounds=[4*h];do{h=Math.ceil(h/this.nodeSize),r+=h,this._levelBounds.push(4*r)}while(1!==h);this.ArrayType=i||Float64Array,this.IndexArrayType=r<16384?Uint16Array:Uint32Array;const a=o.indexOf(this.ArrayType),_=4*r*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error(`Unexpected typed array class: ${i}.`);e&&e instanceof ArrayBuffer?(this.data=e,this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=4*r,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+r*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=s,new Uint32Array(this.data,4,1)[0]=t),this._queue=new n.default}add(t,s,i,e){const h=this._pos>>2;return this._indices[h]=h,this._boxes[this._pos++]=t,this._boxes[this._pos++]=s,this._boxes[this._pos++]=i,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),s<this.minY&&(this.minY=s),i>this.maxX&&(this.maxX=i),e>this.maxY&&(this.maxY=e),h}finish(){if(this._pos>>2!==this.numItems)throw new Error(`Added ${this._pos>>2} items when expected ${this.numItems}.`);if(this.numItems<=this.nodeSize)return this._boxes[this._pos++]=this.minX,this._boxes[this._pos++]=this.minY,this._boxes[this._pos++]=this.maxX,void(this._boxes[this._pos++]=this.maxY);const t=this.maxX-this.minX,s=this.maxY-this.minY,i=new Uint32Array(this.numItems);for(let e=0;e<this.numItems;e++){let h=4*e;const n=this._boxes[h++],o=this._boxes[h++],r=this._boxes[h++],a=this._boxes[h++],_=Math.floor(65535*((n+r)/2-this.minX)/t),x=Math.floor(65535*((o+a)/2-this.minY)/s);i[e]=d(_,x)}!function t(s,i,e,h,n,o){if(Math.floor(h/o)>=Math.floor(n/o))return;const r=s[h+n>>1];let a=h-1,_=n+1;for(;;){do{a++}while(s[a]<r);do{_--}while(s[_]>r);if(a>=_)break;x(s,i,e,a,_)}t(s,i,e,h,_,o),t(s,i,e,_+1,n,o)}(i,this._boxes,this._indices,0,this.numItems-1,this.nodeSize);for(let t=0,s=0;t<this._levelBounds.length-1;t++){const i=this._levelBounds[t];for(;s<i;){const t=s;let e=1/0,h=1/0,n=-1/0,o=-1/0;for(let t=0;t<this.nodeSize&&s<i;t++)e=Math.min(e,this._boxes[s++]),h=Math.min(h,this._boxes[s++]),n=Math.max(n,this._boxes[s++]),o=Math.max(o,this._boxes[s++]);this._indices[this._pos>>2]=t,this._boxes[this._pos++]=e,this._boxes[this._pos++]=h,this._boxes[this._pos++]=n,this._boxes[this._pos++]=o}}}search(t,s,i,e,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const o=[],r=[];for(;void 0!==n;){const a=Math.min(n+4*this.nodeSize,_(n,this._levelBounds));for(let _=n;_<a;_+=4){const a=0|this._indices[_>>2];i<this._boxes[_]||(e<this._boxes[_+1]||t>this._boxes[_+2]||s>this._boxes[_+3]||(n<4*this.numItems?(void 0===h||h(a))&&r.push(a):o.push(a)))}n=o.pop()}return r}neighbors(t,s,i=1/0,e=1/0,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const o=this._queue,r=[],x=e*e;for(;void 0!==n;){const e=Math.min(n+4*this.nodeSize,_(n,this._levelBounds));for(let i=n;i<e;i+=4){const e=0|this._indices[i>>2],r=a(t,this._boxes[i],this._boxes[i+2]),_=a(s,this._boxes[i+1],this._boxes[i+3]),x=r*r+_*_;n<4*this.numItems?(void 0===h||h(e))&&o.push(-e-1,x):o.push(e,x)}for(;o.length&&o.peek()<0;){if(o.peekValue()>x)return o.clear(),r;if(r.push(-o.pop()-1),r.length===i)return o.clear(),r}n=o.pop()}return o.clear(),r}}function a(t,s,i){return t<s?s-t:t<=i?0:t-i}function _(t,s){let i=0,e=s.length-1;for(;i<e;){const h=i+e>>1;s[h]>t?e=h:i=h+1}return s[i]}function x(t,s,i,e,h){const n=t[e];t[e]=t[h],t[h]=n;const o=4*e,r=4*h,a=s[o],_=s[o+1],x=s[o+2],d=s[o+3];s[o]=s[r],s[o+1]=s[r+1],s[o+2]=s[r+2],s[o+3]=s[r+3],s[r]=a,s[r+1]=_,s[r+2]=x,s[r+3]=d;const m=i[e];i[e]=i[h],i[h]=m}function d(t,s){let i=t^s,e=65535^i,h=65535^(t|s),n=t&(65535^s),o=i|e>>1,r=i>>1^i,a=h>>1^e&n>>1^h,_=i&h>>1^n>>1^n;i=o,e=r,h=a,n=_,o=i&i>>2^e&e>>2,r=i&e>>2^e&(i^e)>>2,a^=i&h>>2^e&n>>2,_^=e&h>>2^(i^e)&n>>2,i=o,e=r,h=a,n=_,o=i&i>>4^e&e>>4,r=i&e>>4^e&(i^e)>>4,a^=i&h>>4^e&n>>4,_^=e&h>>4^(i^e)&n>>4,i=o,e=r,h=a,n=_,a^=i&h>>8^e&n>>8,_^=e&h>>8^(i^e)&n>>8,i=a^a>>1,e=_^_>>1;let x=t^s,d=e|65535^(x|i);return x=16711935&(x|x<<8),x=252645135&(x|x<<4),x=858993459&(x|x<<2),x=1431655765&(x|x<<1),d=16711935&(d|d<<8),d=252645135&(d|d<<4),d=858993459&(d|d<<2),d=1431655765&(d|d<<1),(d<<1|x)>>>0}i.default=r},
function _(s,t,i,h,e){h();i.default=class{constructor(){this.ids=[],this.values=[],this.length=0}clear(){this.length=0}push(s,t){let i=this.length++;for(this.ids[i]=s,this.values[i]=t;i>0;){const s=i-1>>1,h=this.values[s];if(t>=h)break;this.ids[i]=this.ids[s],this.values[i]=h,i=s}this.ids[i]=s,this.values[i]=t}pop(){if(0===this.length)return;const s=this.ids[0];if(this.length--,this.length>0){const s=this.ids[0]=this.ids[this.length],t=this.values[0]=this.values[this.length],i=this.length>>1;let h=0;for(;h<i;){let s=1+(h<<1);const i=s+1;let e=this.ids[s],l=this.values[s];const n=this.values[i];if(i<this.length&&n<l&&(s=i,e=this.ids[i],l=n),l>=t)break;this.ids[h]=e,this.values[h]=l,h=s}this.ids[h]=s,this.values[h]=t}return s}peek(){if(0!==this.length)return this.ids[0]}peekValue(){if(0!==this.length)return this.values[0]}}},
function _(t,n,e,s,i){s();const r=t(101),a=t(20),o=t(24),g=t(9),p=t(8),c=t(11);function l(t,n,e=0){const s=new Map;for(let i=0;i<t.length;i++){const r=t[i];if(s.has(r))throw new Error("duplicate factor or subfactor: "+r);s.set(r,{value:.5+i*(1+n)+e})}return[s,(t.length-1)*n]}function h(t,n,e,s=0){var i;const r=new Map,a=new Map;for(const[n,e]of t){const t=null!==(i=a.get(n))&&void 0!==i?i:[];a.set(n,[...t,e])}let o=s,p=0;for(const[t,s]of a){const i=s.length,[a,c]=l(s,e,o);p+=c;const h=g.sum(s.map(t=>a.get(t).value));r.set(t,{value:h/i,mapping:a}),o+=i+n+c}return[r,(a.size-1)*n+p]}function u(t,n,e,s,i=0){var r;const a=new Map,o=new Map;for(const[n,e,s]of t){const t=null!==(r=o.get(n))&&void 0!==r?r:[];o.set(n,[...t,[e,s]])}let p=i,c=0;for(const[t,i]of o){const r=i.length,[o,l]=h(i,e,s,p);c+=l;const u=g.sum(i.map(([t])=>o.get(t).value));a.set(t,{value:u/r,mapping:o}),p+=r+n+l}return[a,(o.size-1)*n+c]}e.map_one_level=l,e.map_two_levels=h,e.map_three_levels=u;class d extends r.Range{constructor(t){super(t)}static init_FactorRange(){this.define(({Any:t,Number:n,Array:e})=>({factors:[e(t),[]],factor_padding:[n,0],subgroup_padding:[n,.8],group_padding:[n,1.4],range_padding:[n,0],range_padding_units:[a.PaddingUnits,"percent"],start:[n],end:[n]})),this.internal(({Number:t,String:n,Array:e,Tuple:s,Nullable:i})=>({levels:[t],mids:[i(e(s(n,n))),null],tops:[i(e(n)),null]}))}get min(){return this.start}get max(){return this.end}initialize(){super.initialize(),this._init(!0)}connect_signals(){super.connect_signals(),this.connect(this.properties.factors.change,()=>this.reset()),this.connect(this.properties.factor_padding.change,()=>this.reset()),this.connect(this.properties.group_padding.change,()=>this.reset()),this.connect(this.properties.subgroup_padding.change,()=>this.reset()),this.connect(this.properties.range_padding.change,()=>this.reset()),this.connect(this.properties.range_padding_units.change,()=>this.reset())}reset(){this._init(!1),this.change.emit()}_lookup(t){switch(t.length){case 1:{const[n]=t,e=this._mapping.get(n);return null!=e?e.value:NaN}case 2:{const[n,e]=t,s=this._mapping.get(n);if(null!=s){const t=s.mapping.get(e);if(null!=t)return t.value}return NaN}case 3:{const[n,e,s]=t,i=this._mapping.get(n);if(null!=i){const t=i.mapping.get(e);if(null!=t){const n=t.mapping.get(s);if(null!=n)return n.value}}return NaN}default:c.unreachable()}}synthetic(t){if(p.isNumber(t))return t;if(p.isString(t))return this._lookup([t]);let n=0;const e=t[t.length-1];return p.isNumber(e)&&(n=e,t=t.slice(0,-1)),this._lookup(t)+n}v_synthetic(t){const n=t.length,e=new o.NumberArray(n);for(let s=0;s<n;s++)e[s]=this.synthetic(t[s]);return e}_init(t){const{levels:n,mapping:e,tops:s,mids:i,inside_padding:r}=(()=>{if(g.every(this.factors,p.isString)){const t=this.factors,[n,e]=l(t,this.factor_padding);return{levels:1,mapping:n,tops:null,mids:null,inside_padding:e}}if(g.every(this.factors,t=>p.isArray(t)&&2==t.length&&p.isString(t[0])&&p.isString(t[1]))){const t=this.factors,[n,e]=h(t,this.group_padding,this.factor_padding),s=[...n.keys()];return{levels:2,mapping:n,tops:s,mids:null,inside_padding:e}}if(g.every(this.factors,t=>p.isArray(t)&&3==t.length&&p.isString(t[0])&&p.isString(t[1])&&p.isString(t[2]))){const t=this.factors,[n,e]=u(t,this.group_padding,this.subgroup_padding,this.factor_padding),s=[...n.keys()],i=[];for(const[t,e]of n)for(const n of e.mapping.keys())i.push([t,n]);return{levels:3,mapping:n,tops:s,mids:i,inside_padding:e}}c.unreachable()})();this._mapping=e,this.tops=s,this.mids=i;let a=0,o=this.factors.length+r;if("percent"==this.range_padding_units){const t=(o-a)*this.range_padding/2;a-=t,o+=t}else a-=this.range_padding,o+=this.range_padding;this.setv({start:a,end:o,levels:n},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[a,o]},{silent:!0})}}e.FactorRange=d,d.__name__="FactorRange",d.init_FactorRange()},
function _(e,t,n,i,s){i();const a=e(88);class l extends a.Model{constructor(e){super(e),this.have_updated_interactively=!1}static init_Range(){this.define(({Number:e,Tuple:t,Or:n,Auto:i,Nullable:s})=>({bounds:[s(n(t(s(e),s(e)),i)),null],min_interval:[s(e),null],max_interval:[s(e),null]})),this.internal(({Array:e,AnyRef:t})=>({plots:[e(t()),[]]}))}get is_reversed(){return this.start>this.end}get is_valid(){return!isNaN(this.min)&&!isNaN(this.max)}}n.Range=l,l.__name__="Range",l.init_Range()},
function _(e,t,s,n,o){n();const i=e(14),c=e(94),r=e(103),l=e(124),a=e(92);class p extends i.HasProps{constructor(e){super(e),this.inspectors=new Map}static init_SelectionManager(){this.internal(({Ref:e})=>({source:[e(a.ColumnarDataSource)]}))}select(e,t,s,n="replace"){const o=[],i=[];for(const t of e)t instanceof r.GlyphRendererView?o.push(t):t instanceof l.GraphRendererView&&i.push(t);let c=!1;for(const e of i){const o=e.model.selection_policy.hit_test(t,e);c=c||e.model.selection_policy.do_selection(o,e.model,s,n)}if(o.length>0){const e=this.source.selection_policy.hit_test(t,o);c=c||this.source.selection_policy.do_selection(e,this.source,s,n)}return c}inspect(e,t){let s=!1;if(e instanceof r.GlyphRendererView){const n=e.hit_test(t);if(null!=n){s=!n.is_empty();const o=this.get_or_create_inspector(e.model);o.update(n,!0,"replace"),this.source.setv({inspected:o},{silent:!0}),this.source.inspect.emit([e.model,{geometry:t}])}}else if(e instanceof l.GraphRendererView){const n=e.model.inspection_policy.hit_test(t,e);s=s||e.model.inspection_policy.do_inspection(n,t,e,!1,"replace")}return s}clear(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()}get_or_create_inspector(e){let t=this.inspectors.get(e);return null==t&&(t=new c.Selection,this.inspectors.set(e,t)),t}}s.SelectionManager=p,p.__name__="SelectionManager",p.init_SelectionManager()},
function _(e,t,i,s,l){s();const h=e(104),n=e(105),o=e(117),a=e(118),r=e(120),c=e(95),d=e(92),_=e(121),p=e(24),g=e(12),u=e(9),y=e(13),m=e(123),v=e(100),f={fill:{},line:{}},w={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},b={fill:{fill_alpha:.2},line:{}};class V extends h.DataRendererView{get glyph_view(){return this.glyph}async lazy_initialize(){await super.lazy_initialize();const e=this.model.glyph,t=u.includes(e._mixins,"fill"),i=u.includes(e._mixins,"line"),s=y.clone(e.attributes);function l(l){const h=y.clone(s);return t&&y.extend(h,l.fill),i&&y.extend(h,l.line),new e.constructor(h)}delete s.id,this.glyph=await this.build_glyph_view(e);let{selection_glyph:h}=this.model;null==h?h=l({fill:{},line:{}}):"auto"===h&&(h=l(f)),this.selection_glyph=await this.build_glyph_view(h);let{nonselection_glyph:n}=this.model;null==n?n=l({fill:{},line:{}}):"auto"===n&&(n=l(b)),this.nonselection_glyph=await this.build_glyph_view(n);const{hover_glyph:o}=this.model;null!=o&&(this.hover_glyph=await this.build_glyph_view(o));const{muted_glyph:a}=this.model;null!=a&&(this.muted_glyph=await this.build_glyph_view(a));const r=l(w);this.decimated_glyph=await this.build_glyph_view(r),this.set_data(!1)}async build_glyph_view(e){return m.build_view(e,{parent:this})}remove(){var e,t;this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(e=this.hover_glyph)||void 0===e||e.remove(),null===(t=this.muted_glyph)||void 0===t||t.remove(),this.decimated_glyph.remove(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render()),this.connect(this.model.glyph.change,()=>this.set_data()),this.connect(this.model.data_source.change,()=>this.set_data()),this.connect(this.model.data_source.streaming,()=>this.set_data()),this.connect(this.model.data_source.patching,e=>this.set_data(!0,e)),this.connect(this.model.data_source.selected.change,()=>this.request_render()),this.connect(this.model.data_source._select,()=>this.request_render()),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,()=>this.request_render()),this.connect(this.model.properties.view.change,()=>this.set_data()),this.connect(this.model.view.properties.indices.change,()=>this.set_data()),this.connect(this.model.view.properties.masked.change,()=>this.set_visuals()),this.connect(this.model.properties.visible.change,()=>this.plot_view.invalidate_dataranges=!0);const{x_ranges:e,y_ranges:t}=this.plot_view.frame;for(const[,t]of e)t instanceof v.FactorRange&&this.connect(t.change,()=>this.set_data());for(const[,e]of t)e instanceof v.FactorRange&&this.connect(e.change,()=>this.set_data());this.connect(this.model.glyph.transformchange,()=>this.set_data())}_update_masked_indices(){const e=this.glyph.mask_data();return this.model.view.masked=e,e}set_data(e=!0,t=null){const i=this.model.data_source;this.all_indices=this.model.view.indices;const{all_indices:s}=this;this.glyph.set_data(i,s,t),this.set_visuals(),this._update_masked_indices();const{lod_factor:l}=this.plot_model,h=this.all_indices.count;this.decimated=new p.Indices(h);for(let e=0;e<h;e+=l)this.decimated.set(e);this.plot_view.invalidate_dataranges=!0,e&&this.request_render()}set_visuals(){var e,t,i,s;const l=this.model.data_source,{all_indices:h}=this;this.glyph.set_visuals(l,h),this.decimated_glyph.set_visuals(l,h),null===(e=this.selection_glyph)||void 0===e||e.set_visuals(l,h),null===(t=this.nonselection_glyph)||void 0===t||t.set_visuals(l,h),null===(i=this.hover_glyph)||void 0===i||i.set_visuals(l,h),null===(s=this.muted_glyph)||void 0===s||s.set_visuals(l,h)}get has_webgl(){return this.glyph.has_webgl}_render(){const e=this.has_webgl;this.glyph.map_data();const t=[...this.all_indices];let i=[...this._update_masked_indices()];const{ctx:s}=this.layer;s.save();const{selected:l}=this.model.data_source;let h;h=!l||l.is_empty()?[]:this.glyph instanceof n.LineView&&l.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(i):l.indices;const{inspected:c}=this.model.data_source,d=new Set((()=>!c||c.is_empty()?[]:c.selected_glyph?this.model.view.convert_indices_from_subset(i):c.indices.length>0?c.indices:Object.keys(c.multiline_indices).map(e=>parseInt(e)))()),_=g.filter(i,e=>d.has(t[e])),{lod_threshold:p}=this.plot_model;let y,m,v;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!e&&null!=p&&t.length>p?(i=[...this.decimated],y=this.decimated_glyph,m=this.decimated_glyph,v=this.selection_glyph):(y=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,m=this.nonselection_glyph,v=this.selection_glyph),null!=this.hover_glyph&&_.length&&(i=u.difference(i,_)),h.length){const e={};for(const t of h)e[t]=!0;const l=new Array,o=new Array;if(this.glyph instanceof n.LineView)for(const i of t)null!=e[i]?l.push(i):o.push(i);else for(const s of i)null!=e[t[s]]?l.push(s):o.push(s);m.render(s,o,this.glyph),v.render(s,l,this.glyph),null!=this.hover_glyph&&(this.glyph instanceof n.LineView?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(_),this.glyph):this.hover_glyph.render(s,_,this.glyph))}else if(this.glyph instanceof n.LineView)this.hover_glyph&&_.length?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(_),this.glyph):y.render(s,t,this.glyph);else if(this.glyph instanceof o.PatchView||this.glyph instanceof a.HAreaView||this.glyph instanceof r.VAreaView)if(0==c.selected_glyphs.length||null==this.hover_glyph)y.render(s,t,this.glyph);else for(const e of c.selected_glyphs)e==this.glyph.model&&this.hover_glyph.render(s,t,this.glyph);else y.render(s,i,this.glyph),this.hover_glyph&&_.length&&this.hover_glyph.render(s,_,this.glyph);s.restore()}draw_legend(e,t,i,s,l,h,n,o){null==o&&(o=this.model.get_reference_point(h,n)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:s,y1:l},o)}hit_test(e){if(!this.model.visible)return null;const t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)}}i.GlyphRendererView=V,V.__name__="GlyphRendererView";class x extends h.DataRenderer{constructor(e){super(e)}static init_GlyphRenderer(){this.prototype.default_view=V,this.define(({Boolean:e,Auto:t,Or:i,Ref:s,Nullable:l})=>({data_source:[s(d.ColumnarDataSource)],view:[s(_.CDSView),e=>new _.CDSView({source:e.data_source})],glyph:[s(c.Glyph)],hover_glyph:[l(s(c.Glyph)),null],nonselection_glyph:[i(s(c.Glyph),t),"auto"],selection_glyph:[i(s(c.Glyph),t),"auto"],muted_glyph:[l(s(c.Glyph)),null],muted:[e,!1]}))}initialize(){super.initialize(),this.view.source!=this.data_source&&(this.view.source=this.data_source,this.view.compute_indices())}get_reference_point(e,t){let i=0;if(null!=e){const s=this.data_source.get_column(e);if(null!=s){const e=g.indexOf(s,t);-1!=e&&(i=e)}}return i}get_selection_manager(){return this.data_source.selection_manager}}i.GlyphRenderer=x,x.__name__="GlyphRenderer",x.init_GlyphRenderer()},
function _(e,r,t,a,n){a();const s=e(69);class i extends s.RendererView{get xscale(){return this.coordinates.x_scale}get yscale(){return this.coordinates.y_scale}}t.DataRendererView=i,i.__name__="DataRendererView";class _ extends s.Renderer{constructor(e){super(e)}static init_DataRenderer(){this.override({level:"glyph"})}get selection_manager(){return this.get_selection_manager()}}t.DataRenderer=_,_.__name__="DataRenderer",_.init_DataRenderer()},
function _(e,i,t,s,n){s();const l=e(1),_=e(106),r=e(107),h=e(109),o=l.__importStar(e(28)),a=l.__importStar(e(108)),c=e(94);class d extends _.XYGlyphView{initialize(){super.initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;null!=e&&(this.glglyph=new h.LineGL(e.gl,this))}_render(e,i,{sx:t,sy:s}){let n=!1,l=null;this.visuals.line.set_value(e);for(const _ of i){if(n){if(!isFinite(t[_]+s[_])){e.stroke(),e.beginPath(),n=!1,l=_;continue}null!=l&&_-l>1&&(e.stroke(),n=!1)}n?e.lineTo(t[_],s[_]):(e.beginPath(),e.moveTo(t[_],s[_]),n=!0),l=_}n&&e.stroke()}_hit_point(e){const i=new c.Selection,t={x:e.sx,y:e.sy};let s=9999;const n=Math.max(2,this.visuals.line.line_width.value()/2);for(let e=0,l=this.sx.length-1;e<l;e++){const l={x:this.sx[e],y:this.sy[e]},_={x:this.sx[e+1],y:this.sy[e+1]},r=a.dist_to_segment(t,l,_);r<n&&r<s&&(s=r,i.add_to_selected_glyphs(this.model),i.view=this,i.line_indices=[e])}return i}_hit_span(e){const{sx:i,sy:t}=e,s=new c.Selection;let n,l;"v"==e.direction?(n=this.renderer.yscale.invert(t),l=this._y):(n=this.renderer.xscale.invert(i),l=this._x);for(let e=0,i=l.length-1;e<i;e++)(l[e]<=n&&n<=l[e+1]||l[e+1]<=n&&n<=l[e])&&(s.add_to_selected_glyphs(this.model),s.view=this,s.line_indices.push(e));return s}get_interpolation_hit(e,i){const[t,s,n,l]=[this._x[e],this._y[e],this._x[e+1],this._y[e+1]];return r.line_interpolation(this.renderer,i,t,s,n,l)}draw_legend_for_index(e,i,t){r.generic_line_legend(this.visuals,e,i,t)}}t.LineView=d,d.__name__="LineView";class u extends _.XYGlyph{constructor(e){super(e)}static init_Line(){this.prototype.default_view=d,this.mixins(o.Line)}}t.Line=u,u.__name__="Line",u.init_Line()},
function _(t,i,e,s,_){s();const n=t(1),a=t(36),h=n.__importStar(t(18)),p=t(95);class y extends p.GlyphView{_project_data(){a.inplace.project_xy(this._x,this._y)}_index_data(t){const{data_size:i}=this;for(let e=0;e<i;e++){const i=this._x[e],s=this._y[e];isNaN(i+s)||!isFinite(i+s)?t.add_empty():t.add(i,s,i,s)}}scenterxy(t){return[this.sx[t],this.sy[t]]}}e.XYGlyphView=y,y.__name__="XYGlyphView";class c extends p.Glyph{constructor(t){super(t)}static init_XYGlyph(){this.define(({})=>({x:[h.XCoordinateSpec,{field:"x"}],y:[h.YCoordinateSpec,{field:"y"}]}))}}e.XYGlyph=c,c.__name__="XYGlyph",c.init_XYGlyph()},
function _(e,t,i,n,c){n();const o=e(1).__importStar(e(108));i.generic_line_legend=function(e,t,{x0:i,x1:n,y0:c,y1:o},r){t.save(),t.beginPath(),t.moveTo(i,(c+o)/2),t.lineTo(n,(c+o)/2),e.line.doit&&(e.line.set_vectorize(t,r),t.stroke()),t.restore()},i.generic_area_legend=function(e,t,{x0:i,x1:n,y0:c,y1:o},r){const l=.1*Math.abs(n-i),a=.1*Math.abs(o-c),s=i+l,_=n-l,h=c+a,v=o-a;e.fill.doit&&(e.fill.set_vectorize(t,r),t.fillRect(s,h,_-s,v-h)),null!=e.hatch&&e.hatch.doit&&(e.hatch.set_vectorize(t,r),t.fillRect(s,h,_-s,v-h)),e.line&&e.line.doit&&(t.beginPath(),t.rect(s,h,_-s,v-h),e.line.set_vectorize(t,r),t.stroke())},i.line_interpolation=function(e,t,i,n,c,r){const{sx:l,sy:a}=t;let s,_,h,v;"point"==t.type?([h,v]=e.yscale.r_invert(a-1,a+1),[s,_]=e.xscale.r_invert(l-1,l+1)):"v"==t.direction?([h,v]=e.yscale.r_invert(a,a),[s,_]=[Math.min(i-1,c-1),Math.max(i+1,c+1)]):([s,_]=e.xscale.r_invert(l,l),[h,v]=[Math.min(n-1,r-1),Math.max(n+1,r+1)]);const{x,y}=o.check_2_segments_intersect(s,h,_,v,i,n,c,r);return[x,y]}},
function _(t,n,e,i,r){function s(t,n){return(t.x-n.x)**2+(t.y-n.y)**2}function o(t,n,e){const i=s(n,e);if(0==i)return s(t,n);const r=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/i;if(r<0)return s(t,n);if(r>1)return s(t,e);return s(t,{x:n.x+r*(e.x-n.x),y:n.y+r*(e.y-n.y)})}i(),e.point_in_poly=function(t,n,e,i){let r=!1,s=e[e.length-1],o=i[i.length-1];for(let u=0;u<e.length;u++){const c=e[u],_=i[u];o<n!=_<n&&s+(n-o)/(_-o)*(c-s)<t&&(r=!r),s=c,o=_}return r},e.point_in_ellipse=function(t,n,e,i,r,s,o){return((Math.cos(e)/r)**2+(Math.sin(e)/i)**2)*(t-s)**2+2*Math.cos(e)*Math.sin(e)*((1/r)**2-(1/i)**2)*(t-s)*(n-o)+((Math.cos(e)/i)**2+(Math.sin(e)/r)**2)*(n-o)**2<=1},e.dist_2_pts=s,e.dist_to_segment_squared=o,e.dist_to_segment=function(t,n,e){return Math.sqrt(o(t,n,e))},e.check_2_segments_intersect=function(t,n,e,i,r,s,o,u){const c=(u-s)*(e-t)-(o-r)*(i-n);if(0==c)return{hit:!1,x:null,y:null};{let _=n-s,h=t-r;const l=(e-t)*_-(i-n)*h;_=((o-r)*_-(u-s)*h)/c,h=l/c;return{hit:_>0&&_<1&&h>0&&h<1,x:t+_*(e-t),y:n+_*(i-n)}}}},
function _(t,e,s,i,a){i();const n=t(110),o=t(114),h=t(115),_=t(116),r=t(22);class l{constructor(t){this._atlas=new Map,this._width=256,this._height=256,this.tex=new n.Texture2d(t),this.tex.set_wrapping(t.REPEAT,t.REPEAT),this.tex.set_interpolation(t.NEAREST,t.NEAREST),this.tex.set_size([this._width,this._height],t.RGBA),this.tex.set_data([0,0],[this._width,this._height],new Uint8Array(4*this._width*this._height)),this.get_atlas_data([1])}get_atlas_data(t){const e=t.join("-");let s=this._atlas.get(e);if(null==s){const[i,a]=this.make_pattern(t),n=this._atlas.size;this.tex.set_data([0,n],[this._width,1],new Uint8Array(i.map(t=>t+10))),s=[n/this._height,a],this._atlas.set(e,s)}return s}make_pattern(t){t.length>1&&t.length%2&&(t=t.concat(t));let e=0;for(const s of t)e+=s;const s=[];let i=0;for(let e=0,a=t.length+2;e<a;e+=2){const a=Math.max(1e-4,t[e%t.length]),n=Math.max(1e-4,t[(e+1)%t.length]);s.push(i,i+a),i+=a+n}const a=this._width,n=new Float32Array(4*a);for(let t=0,i=a;t<i;t++){let i,o,h;const _=e*t/(a-1);let r=0,l=1e16;for(let t=0,e=s.length;t<e;t++){const e=Math.abs(s[t]-_);e<l&&(r=t,l=e)}r%2==0?(h=_<=s[r]?1:0,o=s[r],i=s[r+1]):(h=_>s[r]?-1:0,o=s[r-1],i=s[r]),n[4*t+0]=s[r],n[4*t+1]=h,n[4*t+2]=o,n[4*t+3]=i}return[n,e]}}l.__name__="DashAtlas";const g={miter:0,round:1,bevel:2},u={"":0,none:0,".":0,round:1,")":1,"(":1,o:1,"triangle in":2,"<":2,"triangle out":3,">":3,square:4,"[":4,"]":4,"=":4,butt:5,"|":5};class f extends o.BaseGLGlyph{init(){const{gl:t}=this;this._scale_aspect=0;const e=h.vertex_shader,s=_.fragment_shader;this.prog=new n.Program(t),this.prog.set_shaders(e,s),this.index_buffer=new n.IndexBuffer(t),this.vbo_position=new n.VertexBuffer(t),this.vbo_tangents=new n.VertexBuffer(t),this.vbo_segment=new n.VertexBuffer(t),this.vbo_angles=new n.VertexBuffer(t),this.vbo_texcoord=new n.VertexBuffer(t),this.dash_atlas=new l(t)}draw(t,e,s){const i=e.glglyph;if(i.data_changed&&(i._set_data(),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1),i._update_scale(1,1),this._scale_aspect=1,this.prog.set_attribute("a_position","vec2",i.vbo_position),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents),this.prog.set_attribute("a_segment","vec2",i.vbo_segment),this.prog.set_attribute("a_angles","vec2",i.vbo_angles),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord),this.prog.set_uniform("u_length","float",[i.cumsum]),this.prog.set_texture("u_dash_atlas",this.dash_atlas.tex),this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_uniform("u_scale_aspect","vec2",[1,1]),this.prog.set_uniform("u_scale_length","float",[Math.sqrt(2)]),this.I_triangles=i.I_triangles,this.I_triangles.length<65535)this.index_buffer.set_size(2*this.I_triangles.length),this.index_buffer.set_data(0,new Uint16Array(this.I_triangles)),this.prog.draw(this.gl.TRIANGLES,this.index_buffer);else{t=Array.from(this.I_triangles);const e=this.I_triangles.length,s=64008,a=[];for(let t=0,i=Math.ceil(e/s);t<i;t++)a.push([]);for(let e=0,i=t.length;e<i;e++){const i=t[e]%s;a[Math.floor(t[e]/s)].push(i)}for(let t=0,e=a.length;t<e;t++){const e=new Uint16Array(a[t]),n=t*s*4;0!==e.length&&(this.prog.set_attribute("a_position","vec2",i.vbo_position,0,2*n),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents,0,4*n),this.prog.set_attribute("a_segment","vec2",i.vbo_segment,0,2*n),this.prog.set_attribute("a_angles","vec2",i.vbo_angles,0,2*n),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord,0,2*n),this.index_buffer.set_size(2*e.length),this.index_buffer.set_data(0,e),this.prog.draw(this.gl.TRIANGLES,this.index_buffer))}}}_set_data(){this._bake(),this.vbo_position.set_size(4*this.V_position.length),this.vbo_position.set_data(0,this.V_position),this.vbo_tangents.set_size(4*this.V_tangents.length),this.vbo_tangents.set_data(0,this.V_tangents),this.vbo_angles.set_size(4*this.V_angles.length),this.vbo_angles.set_data(0,this.V_angles),this.vbo_texcoord.set_size(4*this.V_texcoord.length),this.vbo_texcoord.set_data(0,this.V_texcoord)}_set_visuals(){const t=r.color2rgba(this.glyph.visuals.line.line_color.value(),this.glyph.visuals.line.line_alpha.value()),e=u[this.glyph.visuals.line.line_cap.value()],s=g[this.glyph.visuals.line.line_join.value()];this.prog.set_uniform("u_color","vec4",t),this.prog.set_uniform("u_linewidth","float",[this.glyph.visuals.line.line_width.value()]),this.prog.set_uniform("u_antialias","float",[.9]),this.prog.set_uniform("u_linecaps","vec2",[e,e]),this.prog.set_uniform("u_linejoin","float",[s]),this.prog.set_uniform("u_miter_limit","float",[10]);const i=this.glyph.visuals.line.line_dash.value();let a=0,n=1;i.length&&([a,n]=this.dash_atlas.get_atlas_data(i)),this.prog.set_uniform("u_dash_index","float",[a]),this.prog.set_uniform("u_dash_phase","float",[this.glyph.visuals.line.line_dash_offset.value()]),this.prog.set_uniform("u_dash_period","float",[n]),this.prog.set_uniform("u_dash_caps","vec2",[e,e]),this.prog.set_uniform("u_closed","float",[0])}_bake(){let t,e,s,i,a,n,o,h;const _=this.nvertices,r=this.glyph.sx,l=this.glyph.sy,g=o=new Float32Array(2*_),u=new Float32Array(2*_),f=h=new Float32Array(4*_);for(let t=0,e=_;t<e;t++)g[2*t+0]=r[t],g[2*t+1]=l[t];this.tangents=e=new Float32Array(2*_-2);for(let t=0,s=_-1;t<s;t++)e[2*t+0]=o[2*(t+1)+0]-o[2*t+0],e[2*t+1]=o[2*(t+1)+1]-o[2*t+1];for(let t=0,s=_-1;t<s;t++)f[4*(t+1)+0]=e[2*t+0],f[4*(t+1)+1]=e[2*t+1],f[4*t+2]=e[2*t+0],f[4*t+3]=e[2*t+1];f[0]=e[0],f[1]=e[1],f[4*(_-1)+2]=e[2*(_-2)+0],f[4*(_-1)+3]=e[2*(_-2)+1];const c=new Float32Array(_);for(let t=0,e=_;t<e;t++)c[t]=Math.atan2(h[4*t+0]*h[4*t+3]-h[4*t+1]*h[4*t+2],h[4*t+0]*h[4*t+2]+h[4*t+1]*h[4*t+3]);for(let t=0,e=_-1;t<e;t++)u[2*t+0]=c[t],u[2*t+1]=c[t+1];const p=4*_-4;this.V_position=i=new Float32Array(2*p),this.V_angles=s=new Float32Array(2*p),this.V_tangents=a=new Float32Array(4*p),this.V_texcoord=n=new Float32Array(2*p);for(let t=0,e=_;t<e;t++)for(let e=0;e<4;e++){for(let a=0;a<2;a++)i[2*(4*t+e-2)+a]=g[2*t+a],s[2*(4*t+e)+a]=u[2*t+a];for(let s=0;s<4;s++)a[4*(4*t+e-2)+s]=f[4*t+s]}for(let t=0,e=_;t<e;t++)n[2*(4*t+0)+0]=-1,n[2*(4*t+1)+0]=-1,n[2*(4*t+2)+0]=1,n[2*(4*t+3)+0]=1,n[2*(4*t+0)+1]=-1,n[2*(4*t+1)+1]=1,n[2*(4*t+2)+1]=-1,n[2*(4*t+3)+1]=1;const d=6*(_-1);this.I_triangles=t=new Uint32Array(d);for(let e=0,s=_;e<s;e++)t[6*e+0]=0+4*e,t[6*e+1]=1+4*e,t[6*e+2]=3+4*e,t[6*e+3]=2+4*e,t[6*e+4]=0+4*e,t[6*e+5]=3+4*e}_update_scale(t,e){let s;const i=this.nvertices,a=4*i-4,n=this.tangents,o=new Float32Array(i-1),h=new Float32Array(2*i);this.V_segment=s=new Float32Array(2*a);for(let s=0,a=i-1;s<a;s++)o[s]=Math.sqrt((n[2*s+0]*t)**2+(n[2*s+1]*e)**2);let _=0;for(let t=0,e=i-1;t<e;t++)_+=o[t],h[2*(t+1)+0]=_,h[2*t+1]=_;for(let t=0,e=i;t<e;t++)for(let e=0;e<4;e++)for(let i=0;i<2;i++)s[2*(4*t+e)+i]=h[2*t+i];this.cumsum=_,this.vbo_segment.set_size(4*this.V_segment.length),this.vbo_segment.set_data(0,this.V_segment)}}s.LineGL=f,f.__name__="LineGL"},
function _(e,r,f,u,x){u(),x("Program",e(111).Program),x("Texture2d",e(113).Texture2d);var t=e(112);x("IndexBuffer",t.IndexBuffer),x("VertexBuffer",t.VertexBuffer)},
function _(t,e,i,s,a){s();const r=t(112);class n{constructor(t){this.gl=t,this.UTYPEMAP={float:"uniform1fv",vec2:"uniform2fv",vec3:"uniform3fv",vec4:"uniform4fv",int:"uniform1iv",ivec2:"uniform2iv",ivec3:"uniform3iv",ivec4:"uniform4iv",bool:"uniform1iv",bvec2:"uniform2iv",bvec3:"uniform3iv",bvec4:"uniform4iv",mat2:"uniformMatrix2fv",mat3:"uniformMatrix3fv",mat4:"uniformMatrix4fv",sampler1D:"uniform1i",sampler2D:"uniform1i",sampler3D:"uniform1i"},this.ATYPEMAP={float:"vertexAttrib1f",vec2:"vertexAttrib2f",vec3:"vertexAttrib3f",vec4:"vertexAttrib4f"},this.ATYPEINFO={float:[1,5126],vec2:[2,5126],vec3:[3,5126],vec4:[4,5126]},this._linked=!1,this._validated=!1,this._unset_variables=new Set,this._known_invalid=new Set,this._locations=new Map,this._samplers=new Map,this._attributes=new Map,this.handle=this.gl.createProgram()}delete(){this.gl.deleteProgram(this.handle)}activate(){this.gl.useProgram(this.handle)}deactivate(){this.gl.useProgram(0)}set_shaders(t,e){const i=this.gl;this._linked=!1;const s=i.createShader(i.VERTEX_SHADER),a=i.createShader(i.FRAGMENT_SHADER),r=[[t,s,"vertex"],[e,a,"fragment"]];for(const[t,e,s]of r){i.shaderSource(e,t),i.compileShader(e);if(!i.getShaderParameter(e,i.COMPILE_STATUS)){const t=i.getShaderInfoLog(e);throw new Error(`errors in ${s} shader:\n${t}`)}}if(i.attachShader(this.handle,s),i.attachShader(this.handle,a),i.linkProgram(this.handle),!i.getProgramParameter(this.handle,i.LINK_STATUS)){const t=i.getProgramInfoLog(this.handle);throw new Error("Program link error:\n"+t)}this._unset_variables=this._get_active_attributes_and_uniforms(),i.detachShader(this.handle,s),i.detachShader(this.handle,a),i.deleteShader(s),i.deleteShader(a),this._known_invalid.clear(),this._linked=!0}_get_active_attributes_and_uniforms(){const t=this.gl;this._locations.clear();const e=new RegExp("(\\w+)\\s*(\\[(\\d+)\\])\\s*"),i=t.getProgramParameter(this.handle,t.ACTIVE_UNIFORMS),s=[],a=[],r=[[s,t.getProgramParameter(this.handle,t.ACTIVE_ATTRIBUTES),t.getActiveAttrib,t.getAttribLocation],[a,i,t.getActiveUniform,t.getUniformLocation]];for(const[i,s,a,n]of r)for(let r=0;r<s;r+=1){const s=a.call(t,this.handle,r),o=s.name,h=o.match(e);if(null!=h){const t=h[1];for(let e=0;e<s.size;e+=1)i.push([`${t}[${e}]`,s.type])}else i.push([o,s.type]);this._locations.set(o,n.call(t,this.handle,o))}const n=new Set;for(const[t]of s)n.add(t);for(const[t]of a)n.add(t);return n}set_texture(t,e){var i;if(!this._linked)throw new Error("Cannot set uniform when program has no code");const s=null!==(i=this._locations.get(t))&&void 0!==i?i:-1;if(s<0)this._known_invalid.has(t)||(this._known_invalid.add(t),console.log(`"Variable ${t} is not an active texture`));else{this._unset_variables.has(t)&&this._unset_variables.delete(t),this.activate();{let i=this._samplers.size;this._samplers.has(t)&&(i=this._samplers.get(t)[2]),this._samplers.set(t,[e._target,e.handle,i]),this.gl.uniform1i(s,i)}}}set_uniform(t,e,i){var s;if(!this._linked)throw new Error("Cannot set uniform when program has no code");const a=null!==(s=this._locations.get(t))&&void 0!==s?s:-1;if(a<0)return void(this._known_invalid.has(t)||(this._known_invalid.add(t),console.log(`Variable ${t} is not an active uniform`)));this._unset_variables.has(t)&&this._unset_variables.delete(t);let r=1;if(!e.startsWith("mat")){const t="int"==e||"bool"==e?"float":e.replace(/^ib/,"");r=Math.floor(i.length/this.ATYPEINFO[t][0])}if(r>1)for(let e=0;e<r;e+=1)if(this._unset_variables.has(`${t}[${e}]`)){const i=`${t}[${e}]`;this._unset_variables.has(i)&&this._unset_variables.delete(i)}const n=this.UTYPEMAP[e];this.activate(),e.startsWith("mat")?this.gl[n](a,!1,i):this.gl[n](a,i)}set_attribute(t,e,i,s=0,a=0){var n;if(!this._linked)throw new Error("Cannot set attribute when program has no code");const o=null!==(n=this._locations.get(t))&&void 0!==n?n:-1;if(o<0)this._known_invalid.has(t)||(this._known_invalid.add(t),i instanceof r.VertexBuffer&&a>0||console.log(`Variable ${t} is not an active attribute`));else if(this._unset_variables.has(t)&&this._unset_variables.delete(t),this.activate(),i instanceof r.VertexBuffer){const[r,n]=this.ATYPEINFO[e],h="vertexAttribPointer",l=[r,n,!1,s,a];this._attributes.set(t,[i.handle,o,h,l])}else{const s=this.ATYPEMAP[e];this._attributes.set(t,[null,o,s,i])}}_pre_draw(){this.activate();for(const[t,e,i]of this._samplers.values())this.gl.activeTexture(this.gl.TEXTURE0+i),this.gl.bindTexture(t,e);for(const[t,e,i,s]of this._attributes.values())null!=t?(this.gl.bindBuffer(this.gl.ARRAY_BUFFER,t),this.gl.enableVertexAttribArray(e),this.gl[i].apply(this.gl,[e,...s])):(this.gl.bindBuffer(this.gl.ARRAY_BUFFER,null),this.gl.disableVertexAttribArray(e),this.gl[i].apply(this.gl,[e,...s]));this._validated||(this._validated=!0,this._validate())}_validate(){if(this._unset_variables.size&&console.log("Program has unset variables: "+this._unset_variables),this.gl.validateProgram(this.handle),!this.gl.getProgramParameter(this.handle,this.gl.VALIDATE_STATUS))throw console.log(this.gl.getProgramInfoLog(this.handle)),new Error("Program validation error")}draw(t,e){if(!this._linked)throw new Error("Cannot draw program if code has not been set");if(e instanceof r.IndexBuffer){this._pre_draw(),e.activate();const i=e.buffer_size/2,s=this.gl.UNSIGNED_SHORT;this.gl.drawElements(t,i,s,0),e.deactivate()}else{const[i,s]=e;0!=s&&(this._pre_draw(),this.gl.drawArrays(t,i,s))}}}i.Program=n,n.__name__="Program"},
function _(t,e,s,i,a){i();class r{constructor(t){this.gl=t,this._usage=35048,this.buffer_size=0,this.handle=this.gl.createBuffer()}delete(){this.gl.deleteBuffer(this.handle)}activate(){this.gl.bindBuffer(this._target,this.handle)}deactivate(){this.gl.bindBuffer(this._target,null)}set_size(t){t!=this.buffer_size&&(this.activate(),this.gl.bufferData(this._target,t,this._usage),this.buffer_size=t)}set_data(t,e){this.activate(),this.gl.bufferSubData(this._target,t,e)}}s.Buffer=r,r.__name__="Buffer";class f extends r{constructor(){super(...arguments),this._target=34962}}s.VertexBuffer=f,f.__name__="VertexBuffer";class h extends r{constructor(){super(...arguments),this._target=34963}}s.IndexBuffer=h,h.__name__="IndexBuffer"},
function _(t,e,i,a,r){a();const s=t(11);class h{constructor(t){this.gl=t,this._target=3553,this._types={Int8Array:5120,Uint8Array:5121,Int16Array:5122,Uint16Array:5123,Int32Array:5124,Uint32Array:5125,Float32Array:5126},this.handle=this.gl.createTexture()}delete(){this.gl.deleteTexture(this.handle)}activate(){this.gl.bindTexture(this._target,this.handle)}deactivate(){this.gl.bindTexture(this._target,0)}_get_alignment(t){const e=[4,8,2,1];for(const i of e)if(t%i==0)return i;s.unreachable()}set_wrapping(t,e){this.activate(),this.gl.texParameterf(this._target,this.gl.TEXTURE_WRAP_S,t),this.gl.texParameterf(this._target,this.gl.TEXTURE_WRAP_T,e)}set_interpolation(t,e){this.activate(),this.gl.texParameterf(this._target,this.gl.TEXTURE_MIN_FILTER,t),this.gl.texParameterf(this._target,this.gl.TEXTURE_MAG_FILTER,e)}set_size([t,e],i){var a,r,s;t==(null===(a=this._shape_format)||void 0===a?void 0:a.width)&&e==(null===(r=this._shape_format)||void 0===r?void 0:r.height)&&i==(null===(s=this._shape_format)||void 0===s?void 0:s.format)||(this._shape_format={width:t,height:e,format:i},this.activate(),this.gl.texImage2D(this._target,0,i,t,e,0,i,this.gl.UNSIGNED_BYTE,null))}set_data(t,[e,i],a){this.activate();const{format:r}=this._shape_format,[s,h]=t,l=this._types[a.constructor.name];if(null==l)throw new Error(`Type ${a.constructor.name} not allowed for texture`);const _=this._get_alignment(e);4!=_&&this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,_),this.gl.texSubImage2D(this._target,0,s,h,e,i,r,l,a),4!=_&&this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,4)}}i.Texture2d=h,h.__name__="Texture2d"},
function _(e,t,i,s,h){s();class a{constructor(e,t){this.gl=e,this.glyph=t,this.nvertices=0,this.size_changed=!1,this.data_changed=!1,this.visuals_changed=!1,this.init()}set_data_changed(){const{data_size:e}=this.glyph;e!=this.nvertices&&(this.nvertices=e,this.size_changed=!0),this.data_changed=!0}set_visuals_changed(){this.visuals_changed=!0}render(e,t,i){if(0==t.length)return!0;const{width:s,height:h}=this.glyph.renderer.plot_view.canvas_view.webgl.canvas,a={pixel_ratio:this.glyph.renderer.plot_view.canvas_view.pixel_ratio,width:s,height:h};return this.draw(t,i,a),!0}}i.BaseGLGlyph=a,a.__name__="BaseGLGlyph"},
function _(n,e,t,a,i){a(),t.vertex_shader="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size, u_offset;\nuniform vec2 u_scale_aspect;\nuniform float u_scale_length;\n\nuniform vec4 u_color;\nuniform float u_antialias;\nuniform float u_length;\nuniform float u_linewidth;\nuniform float u_dash_index;\nuniform float u_closed;\n\nattribute vec2 a_position;\nattribute vec4 a_tangents;\nattribute vec2 a_segment;\nattribute vec2 a_angles;\nattribute vec2 a_texcoord;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\nfloat cross(in vec2 v1, in vec2 v2)\n{\n    return v1.x*v2.y - v1.y*v2.x;\n}\n\nfloat signed_distance(in vec2 v1, in vec2 v2, in vec2 v3)\n{\n    return cross(v2-v1,v1-v3) / length(v2-v1);\n}\n\nvoid rotate( in vec2 v, in float alpha, out vec2 result )\n{\n    float c = cos(alpha);\n    float s = sin(alpha);\n    result = vec2( c*v.x - s*v.y,\n                   s*v.x + c*v.y );\n}\n\nvoid main()\n{\n    bool closed = (u_closed > 0.0);\n\n    // Attributes and uniforms to varyings\n    v_color = u_color;\n    v_linewidth = u_linewidth;\n    v_segment = a_segment * u_scale_length;\n    v_length = u_length * u_scale_length;\n\n    // Scale to map to pixel coordinates. The original algorithm from the paper\n    // assumed isotropic scale. We obviously do not have this.\n    vec2 abs_scale_aspect = abs(u_scale_aspect);\n    vec2 abs_scale = u_scale_length * abs_scale_aspect;\n\n    // Correct angles for aspect ratio\n    vec2 av;\n    av = vec2(1.0, tan(a_angles.x)) / abs_scale_aspect;\n    v_angles.x = atan(av.y, av.x);\n    av = vec2(1.0, tan(a_angles.y)) / abs_scale_aspect;\n    v_angles.y = atan(av.y, av.x);\n\n    // Thickness below 1 pixel are represented using a 1 pixel thickness\n    // and a modified alpha\n    v_color.a = min(v_linewidth, v_color.a);\n    v_linewidth = max(v_linewidth, 1.0);\n\n    // If color is fully transparent we just will discard the fragment anyway\n    if( v_color.a <= 0.0 ) {\n        gl_Position = vec4(0.0,0.0,0.0,1.0);\n        return;\n    }\n\n    // This is the actual half width of the line\n    float w = ceil(u_antialias+v_linewidth)/2.0;\n\n    vec2 position = a_position;\n\n    vec2 t1 = normalize(a_tangents.xy * abs_scale_aspect);  // note the scaling for aspect ratio here\n    vec2 t2 = normalize(a_tangents.zw * abs_scale_aspect);\n    float u = a_texcoord.x;\n    float v = a_texcoord.y;\n    vec2 o1 = vec2( +t1.y, -t1.x);\n    vec2 o2 = vec2( +t2.y, -t2.x);\n\n    // This is a join\n    // ----------------------------------------------------------------\n    if( t1 != t2 ) {\n        float angle = atan (t1.x*t2.y-t1.y*t2.x, t1.x*t2.x+t1.y*t2.y);  // Angle needs recalculation for some reason\n        vec2 t  = normalize(t1+t2);\n        vec2 o  = vec2( + t.y, - t.x);\n\n        if ( u_dash_index > 0.0 )\n        {\n            // Broken angle\n            // ----------------------------------------------------------------\n            if( (abs(angle) > THETA) ) {\n                position += v * w * o / cos(angle/2.0);\n                float s = sign(angle);\n                if( angle < 0.0 ) {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position -= 2.0 * w * t1 / sin(angle);\n                            u -= 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position += 2.0 * w * t2 / sin(angle);\n                            u += 2.0*w / sin(angle);\n                        }\n                    }\n                } else {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position += 2.0 * w * t1 / sin(angle);\n                            u += 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position -= 2.0 * w * t2 / sin(angle);\n                            u -= 2.0*w / sin(angle);\n                        }\n                    }\n                }\n                // Continuous angle\n                // ------------------------------------------------------------\n            } else {\n                position += v * w * o / cos(angle/2.0);\n                if( u == +1.0 ) u = v_segment.y;\n                else            u = v_segment.x;\n            }\n        }\n\n        // Solid line\n        // --------------------------------------------------------------------\n        else\n        {\n            position.xy += v * w * o / cos(angle/2.0);\n            if( angle < 0.0 ) {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            } else {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            }\n        }\n\n    // This is a line start or end (t1 == t2)\n    // ------------------------------------------------------------------------\n    } else {\n        position += v * w * o1;\n        if( u == -1.0 ) {\n            u = v_segment.x - w;\n            position -= w * t1;\n        } else {\n            u = v_segment.y + w;\n            position += w * t2;\n        }\n    }\n\n    // Miter distance\n    // ------------------------------------------------------------------------\n    vec2 t;\n    vec2 curr = a_position * abs_scale;\n    if( a_texcoord.x < 0.0 ) {\n        vec2 next = curr + t2*(v_segment.y-v_segment.x);\n\n        rotate( t1, +v_angles.x/2.0, t);\n        v_miter.x = signed_distance(curr, curr+t, position);\n\n        rotate( t2, +v_angles.y/2.0, t);\n        v_miter.y = signed_distance(next, next+t, position);\n    } else {\n        vec2 prev = curr - t1*(v_segment.y-v_segment.x);\n\n        rotate( t1, -v_angles.x/2.0,t);\n        v_miter.x = signed_distance(prev, prev+t, position);\n\n        rotate( t2, -v_angles.y/2.0,t);\n        v_miter.y = signed_distance(curr, curr+t, position);\n    }\n\n    if (!closed && v_segment.x <= 0.0) {\n        v_miter.x = 1e10;\n    }\n    if (!closed && v_segment.y >= v_length)\n    {\n        v_miter.y = 1e10;\n    }\n\n    v_texcoord = vec2( u, v*w );\n\n    // Calculate position in device coordinates. Note that we\n    // already scaled with abs scale above.\n    vec2 normpos = position * sign(u_scale_aspect);\n    normpos += 0.5;  // make up for Bokeh's offset\n    normpos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(normpos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n}\n"},
function _(n,t,e,s,a){s(),e.fragment_shader="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform sampler2D u_dash_atlas;\n\nuniform vec2 u_linecaps;\nuniform float u_miter_limit;\nuniform float u_linejoin;\nuniform float u_antialias;\nuniform float u_dash_phase;\nuniform float u_dash_period;\nuniform float u_dash_index;\nuniform vec2 u_dash_caps;\nuniform float u_closed;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\n// Compute distance to cap ----------------------------------------------------\nfloat cap( int type, float dx, float dy, float t, float linewidth )\n{\n    float d = 0.0;\n    dx = abs(dx);\n    dy = abs(dy);\n    if      (type == 0)  discard;  // None\n    else if (type == 1)  d = sqrt(dx*dx+dy*dy);  // Round\n    else if (type == 3)  d = (dx+abs(dy));  // Triangle in\n    else if (type == 2)  d = max(abs(dy),(t+dx-abs(dy)));  // Triangle out\n    else if (type == 4)  d = max(dx,dy);  // Square\n    else if (type == 5)  d = max(dx+t,dy);  // Butt\n    return d;\n}\n\n// Compute distance to join -------------------------------------------------\nfloat join( in int type, in float d, in vec2 segment, in vec2 texcoord, in vec2 miter,\n           in float linewidth )\n{\n    // texcoord.x is distance from start\n    // texcoord.y is distance from centerline\n    // segment.x and y indicate the limits (as for texcoord.x) for this segment\n\n    float dx = texcoord.x;\n\n    // Round join\n    if( type == 1 ) {\n        if (dx < segment.x) {\n            d = max(d,length( texcoord - vec2(segment.x,0.0)));\n            //d = length( texcoord - vec2(segment.x,0.0));\n        } else if (dx > segment.y) {\n            d = max(d,length( texcoord - vec2(segment.y,0.0)));\n            //d = length( texcoord - vec2(segment.y,0.0));\n        }\n    }\n    // Bevel join\n    else if ( type == 2 ) {\n        if (dx < segment.x) {\n            vec2 x = texcoord - vec2(segment.x,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n\n        } else if (dx > segment.y) {\n            vec2 x = texcoord - vec2(segment.y,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n        }\n        /*  Original code for bevel which does not work for us\n        if( (dx < segment.x) ||  (dx > segment.y) )\n            d = max(d, min(abs(x.x),abs(x.y)));\n        */\n    }\n\n    return d;\n}\n\nvoid main()\n{\n    // If color is fully transparent we just discard the fragment\n    if( v_color.a <= 0.0 ) {\n        discard;\n    }\n\n    // Test if dash pattern is the solid one (0)\n    bool solid =  (u_dash_index == 0.0);\n\n    // Test if path is closed\n    bool closed = (u_closed > 0.0);\n\n    vec4 color = v_color;\n    float dx = v_texcoord.x;\n    float dy = v_texcoord.y;\n    float t = v_linewidth/2.0-u_antialias;\n    float width = 1.0;  //v_linewidth; original code had dashes scale with line width, we do not\n    float d = 0.0;\n\n    vec2 linecaps = u_linecaps;\n    vec2 dash_caps = u_dash_caps;\n    float line_start = 0.0;\n    float line_stop = v_length;\n\n    // Apply miter limit; fragments too far into the miter are simply discarded\n    if( (dx < v_segment.x) || (dx > v_segment.y) ) {\n        float into_miter = max(v_segment.x - dx, dx - v_segment.y);\n        if (into_miter > u_miter_limit*v_linewidth/2.0)\n          discard;\n    }\n\n    // Solid line --------------------------------------------------------------\n    if( solid ) {\n        d = abs(dy);\n        if( (!closed) && (dx < line_start) ) {\n            d = cap( int(u_linecaps.x), abs(dx), abs(dy), t, v_linewidth );\n        }\n        else if( (!closed) &&  (dx > line_stop) ) {\n            d = cap( int(u_linecaps.y), abs(dx)-line_stop, abs(dy), t, v_linewidth );\n        }\n        else {\n            d = join( int(u_linejoin), abs(dy), v_segment, v_texcoord, v_miter, v_linewidth );\n        }\n\n    // Dash line --------------------------------------------------------------\n    } else {\n        float segment_start = v_segment.x;\n        float segment_stop  = v_segment.y;\n        float segment_center= (segment_start+segment_stop)/2.0;\n        float freq          = u_dash_period*width;\n        float u = mod( dx + u_dash_phase*width, freq);\n        vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n        float dash_center= tex.x * width;\n        float dash_type  = tex.y;\n        float _start = tex.z * width;\n        float _stop  = tex.a * width;\n        float dash_start = dx - u + _start;\n        float dash_stop  = dx - u + _stop;\n\n        // Compute extents of the first dash (the one relative to v_segment.x)\n        // Note: this could be computed in the vertex shader\n        if( (dash_stop < segment_start) && (dash_caps.x != 5.0) ) {\n            float u = mod(segment_start + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_start - u + _start;\n            dash_stop = segment_start - u + _stop;\n        }\n\n        // Compute extents of the last dash (the one relatives to v_segment.y)\n        // Note: This could be computed in the vertex shader\n        else if( (dash_start > segment_stop)  && (dash_caps.y != 5.0) ) {\n            float u = mod(segment_stop + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_stop - u + _start;\n            dash_stop  = segment_stop - u + _stop;\n        }\n\n        // This test if the we are dealing with a discontinuous angle\n        bool discontinuous = ((dx <  segment_center) && abs(v_angles.x) > THETA) ||\n                             ((dx >= segment_center) && abs(v_angles.y) > THETA);\n        //if( dx < line_start) discontinuous = false;\n        //if( dx > line_stop)  discontinuous = false;\n\n        float d_join = join( int(u_linejoin), abs(dy),\n                            v_segment, v_texcoord, v_miter, v_linewidth );\n\n        // When path is closed, we do not have room for linecaps, so we make room\n        // by shortening the total length\n        if (closed) {\n             line_start += v_linewidth/2.0;\n             line_stop  -= v_linewidth/2.0;\n        }\n\n        // We also need to take antialias area into account\n        //line_start += u_antialias;\n        //line_stop  -= u_antialias;\n\n        // Check is dash stop is before line start\n        if( dash_stop <= line_start ) {\n            discard;\n        }\n        // Check is dash start is beyond line stop\n        if( dash_start >= line_stop ) {\n            discard;\n        }\n\n        // Check if current dash start is beyond segment stop\n        if( discontinuous ) {\n            // Dash start is beyond segment, we discard\n            if( (dash_start > segment_stop) ) {\n                discard;\n                //gl_FragColor = vec4(1.0,0.0,0.0,.25); return;\n            }\n\n            // Dash stop is before segment, we discard\n            if( (dash_stop < segment_start) ) {\n                discard;  //gl_FragColor = vec4(0.0,1.0,0.0,.25); return;\n            }\n\n            // Special case for round caps (nicer with this)\n            if( dash_caps.x == 1.0 ) {\n                if( (u > _stop) && (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for round caps  (nicer with this)\n            if( dash_caps.y == 1.0 ) {\n                if( (u < _start) && (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.x != 1.0) && (dash_caps.x != 5.0) ) {\n                if( (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0) ) {\n                    float a = v_angles.x/2.0;\n                    float x = (segment_start-dx)*cos(a) - dy*sin(a);\n                    float y = (segment_start-dx)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the cap into square to avoid holes\n                    dash_caps.x = 4.0;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.y != 1.0) && (dash_caps.y != 5.0) ) {\n                if( (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0) ) {\n                    float a = v_angles.y/2.0;\n                    float x = (dx-segment_stop)*cos(a) - dy*sin(a);\n                    float y = (dx-segment_stop)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the caps into square to avoid holes\n                    dash_caps.y = 4.0;\n                }\n            }\n        }\n\n        // Line cap at start\n        if( (dx < line_start) && (dash_start < line_start) && (dash_stop > line_start) ) {\n            d = cap( int(linecaps.x), dx-line_start, dy, t, v_linewidth);\n        }\n        // Line cap at stop\n        else if( (dx > line_stop) && (dash_stop > line_stop) && (dash_start < line_stop) ) {\n            d = cap( int(linecaps.y), dx-line_stop, dy, t, v_linewidth);\n        }\n        // Dash cap left - dash_type = -1, 0 or 1, but there may be roundoff errors\n        else if( dash_type < -0.5 ) {\n            d = cap( int(dash_caps.y), abs(u-dash_center), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash cap right\n        else if( dash_type > 0.5 ) {\n            d = cap( int(dash_caps.x), abs(dash_center-u), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash body (plain)\n        else {// if( dash_type > -0.5 &&  dash_type < 0.5) {\n            d = abs(dy);\n        }\n\n        // Line join\n        if( (dx > line_start) && (dx < line_stop)) {\n            if( (dx <= segment_start) && (dash_start <= segment_start)\n                && (dash_stop >= segment_start) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.x;\n                float f = abs( (segment_start - dx)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( (dx > segment_stop) && (dash_start <= segment_stop)\n                     && (dash_stop >= segment_stop) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.y;\n                float f = abs((dx - segment_stop)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( dx < (segment_start - v_linewidth/2.)) {\n                discard;\n            }\n            else if( dx > (segment_stop + v_linewidth/2.)) {\n                discard;\n            }\n        }\n        else if( dx < (segment_start - v_linewidth/2.)) {\n            discard;\n        }\n        else if( dx > (segment_stop + v_linewidth/2.)) {\n            discard;\n        }\n    }\n\n    // Distance to border ------------------------------------------------------\n    d = d - t;\n    if( d < 0.0 ) {\n        gl_FragColor = color;\n    } else {\n        d /= u_antialias;\n        gl_FragColor = vec4(color.rgb, exp(-d*d)*color.a);\n    }\n}\n"},
function _(i,t,e,s,l){s();const n=i(1),_=i(106),o=i(107),a=n.__importStar(i(108)),h=n.__importStar(i(28)),r=i(94);class c extends _.XYGlyphView{_inner_loop(i,t,e,s,l){for(const n of t)0!=n?isNaN(e[n]+s[n])?(i.closePath(),l.apply(i),i.beginPath()):i.lineTo(e[n],s[n]):(i.beginPath(),i.moveTo(e[n],s[n]));i.closePath(),l.call(i)}_render(i,t,{sx:e,sy:s}){this.visuals.fill.doit&&(this.visuals.fill.set_value(i),this._inner_loop(i,t,e,s,i.fill)),this.visuals.hatch.doit2(i,0,()=>this._inner_loop(i,t,e,s,i.fill),()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_value(i),this._inner_loop(i,t,e,s,i.stroke))}draw_legend_for_index(i,t,e){o.generic_area_legend(this.visuals,i,t,e)}_hit_point(i){const t=new r.Selection;return a.point_in_poly(i.sx,i.sy,this.sx,this.sy)&&(t.add_to_selected_glyphs(this.model),t.view=this),t}}e.PatchView=c,c.__name__="PatchView";class d extends _.XYGlyph{constructor(i){super(i)}static init_Patch(){this.prototype.default_view=c,this.mixins([h.Line,h.Fill,h.Hatch])}}e.Patch=d,d.__name__="Patch",d.init_Patch()},
function _(e,t,s,i,r){i();const n=e(1),a=e(24),_=e(119),h=n.__importStar(e(108)),l=n.__importStar(e(18)),o=e(94);class d extends _.AreaView{_index_data(e){const{min:t,max:s}=Math,{data_size:i}=this;for(let r=0;r<i;r++){const i=this._x1[r],n=this._x2[r],a=this._y[r];isNaN(i+n+a)||!isFinite(i+n+a)?e.add_empty():e.add(t(i,n),a,s(i,n),a)}}_inner(e,t,s,i,r){e.beginPath();for(let s=0,r=t.length;s<r;s++)e.lineTo(t[s],i[s]);for(let t=s.length-1;t>=0;t--)e.lineTo(s[t],i[t]);e.closePath(),r.call(e)}_render(e,t,{sx1:s,sx2:i,sy:r}){this.visuals.fill.doit&&(this.visuals.fill.set_value(e),this._inner(e,s,i,r,e.fill)),this.visuals.hatch.doit2(e,0,()=>this._inner(e,s,i,r,e.fill),()=>this.renderer.request_render())}_hit_point(e){const t=this.sy.length,s=new a.NumberArray(2*t),i=new a.NumberArray(2*t);for(let e=0,r=t;e<r;e++)s[e]=this.sx1[e],i[e]=this.sy[e],s[t+e]=this.sx2[t-e-1],i[t+e]=this.sy[t-e-1];const r=new o.Selection;return h.point_in_poly(e.sx,e.sy,s,i)&&(r.add_to_selected_glyphs(this.model),r.view=this),r}scenterxy(e){return[(this.sx1[e]+this.sx2[e])/2,this.sy[e]]}_map_data(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)}}s.HAreaView=d,d.__name__="HAreaView";class c extends _.Area{constructor(e){super(e)}static init_HArea(){this.prototype.default_view=d,this.define(({})=>({x1:[l.XCoordinateSpec,{field:"x1"}],x2:[l.XCoordinateSpec,{field:"x2"}],y:[l.YCoordinateSpec,{field:"y"}]}))}}s.HArea=c,c.__name__="HArea",c.init_HArea()},
function _(e,i,_,a,r){a();const t=e(1),n=e(95),s=e(107),c=t.__importStar(e(28));class l extends n.GlyphView{draw_legend_for_index(e,i,_){s.generic_area_legend(this.visuals,e,i,_)}}_.AreaView=l,l.__name__="AreaView";class o extends n.Glyph{constructor(e){super(e)}static init_Area(){this.mixins([c.Fill,c.HatchVector])}}_.Area=o,o.__name__="Area",o.init_Area()},
function _(e,t,s,i,r){i();const n=e(1),a=e(24),_=e(119),h=n.__importStar(e(108)),l=n.__importStar(e(18)),o=e(94);class d extends _.AreaView{_index_data(e){const{min:t,max:s}=Math,{data_size:i}=this;for(let r=0;r<i;r++){const i=this._x[r],n=this._y1[r],a=this._y2[r];isNaN(i+n+a)||!isFinite(i+n+a)?e.add_empty():e.add(i,t(n,a),i,s(n,a))}}_inner(e,t,s,i,r){e.beginPath();for(let i=0,r=s.length;i<r;i++)e.lineTo(t[i],s[i]);for(let s=i.length-1;s>=0;s--)e.lineTo(t[s],i[s]);e.closePath(),r.call(e)}_render(e,t,{sx:s,sy1:i,sy2:r}){this.visuals.fill.doit&&(this.visuals.fill.set_value(e),this._inner(e,s,i,r,e.fill)),this.visuals.hatch.doit2(e,0,()=>this._inner(e,s,i,r,e.fill),()=>this.renderer.request_render())}scenterxy(e){return[this.sx[e],(this.sy1[e]+this.sy2[e])/2]}_hit_point(e){const t=this.sx.length,s=new a.NumberArray(2*t),i=new a.NumberArray(2*t);for(let e=0,r=t;e<r;e++)s[e]=this.sx[e],i[e]=this.sy1[e],s[t+e]=this.sx[t-e-1],i[t+e]=this.sy2[t-e-1];const r=new o.Selection;return h.point_in_poly(e.sx,e.sy,s,i)&&(r.add_to_selected_glyphs(this.model),r.view=this),r}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)}}s.VAreaView=d,d.__name__="VAreaView";class c extends _.Area{constructor(e){super(e)}static init_VArea(){this.prototype.default_view=d,this.define(({})=>({x:[l.XCoordinateSpec,{field:"x"}],y1:[l.YCoordinateSpec,{field:"y1"}],y2:[l.YCoordinateSpec,{field:"y2"}]}))}}s.VArea=c,c.__name__="VArea",c.init_VArea()},
function _(i,e,s,t,n){t();const c=i(88),o=i(94),r=i(24),a=i(122),u=i(92);class _ extends c.Model{constructor(i){super(i)}static init_CDSView(){this.define(({Array:i,Ref:e})=>({filters:[i(e(a.Filter)),[]],source:[e(u.ColumnarDataSource)]})),this.internal(({Int:i,Dict:e,Ref:s,Nullable:t})=>({indices:[s(r.Indices)],indices_map:[e(i),{}],masked:[t(s(r.Indices)),null]}))}initialize(){super.initialize(),this.compute_indices()}connect_signals(){super.connect_signals(),this.connect(this.properties.filters.change,()=>this.compute_indices());const i=()=>{const i=()=>this.compute_indices();null!=this.source&&(this.connect(this.source.change,i),this.source instanceof u.ColumnarDataSource&&(this.connect(this.source.streaming,i),this.connect(this.source.patching,i)))};let e=null!=this.source;e?i():this.connect(this.properties.source.change,()=>{e||(i(),e=!0)})}compute_indices(){var i;const{source:e}=this;if(null==e)return;const s=null!==(i=e.get_length())&&void 0!==i?i:1,t=r.Indices.all_set(s);for(const i of this.filters)t.intersect(i.compute_indices(e));this.indices=t,this._indices=[...t],this.indices_map_to_subset()}indices_map_to_subset(){this.indices_map={};for(let i=0;i<this._indices.length;i++)this.indices_map[this._indices[i]]=i}convert_selection_from_subset(i){const e=i.indices.map(i=>this._indices[i]);return new o.Selection(Object.assign(Object.assign({},i.attributes),{indices:e}))}convert_selection_to_subset(i){const e=i.indices.map(i=>this.indices_map[i]);return new o.Selection(Object.assign(Object.assign({},i.attributes),{indices:e}))}convert_indices_from_subset(i){return i.map(i=>this._indices[i])}}s.CDSView=_,_.__name__="CDSView",_.init_CDSView()},
function _(e,t,n,s,c){s();const o=e(88);class r extends o.Model{constructor(e){super(e)}}n.Filter=r,r.__name__="Filter"},
function _(n,e,t,i,o){i();const s=n(9);async function c(n,e,t){const i=new n(Object.assign(Object.assign({},t),{model:e}));return i.initialize(),await i.lazy_initialize(),i}t.build_view=async function(n,e={parent:null},t=(n=>n.default_view)){const i=await c(t(n),n,e);return i.connect_signals(),i},t.build_views=async function(n,e,t={parent:null},i=(n=>n.default_view)){const o=s.difference([...n.keys()],e);for(const e of o)n.get(e).remove(),n.delete(e);const a=[],f=e.filter(e=>!n.has(e));for(const e of f){const o=await c(i(e),e,t);n.set(e,o),a.push(o)}for(const n of a)n.connect_signals();return a},t.remove_views=function(n){for(const[e,t]of n)t.remove(),n.delete(e)}},
function _(e,r,n,t,i){t();const s=e(104),o=e(103),l=e(125),d=e(126),a=e(123),p=e(106),_=e(127),h=e(128),c=e(11);class u extends s.DataRendererView{get glyph_view(){return this.node_view.glyph}async lazy_initialize(){await super.lazy_initialize();const e=this.model;let r=null,n=null;const t={v_compute(n){c.assert(null==r);const[t]=r=e.layout_provider.get_edge_coordinates(n);return t}},i={v_compute(e){c.assert(null!=r);const[,n]=r;return r=null,n}},s={v_compute(r){c.assert(null==n);const[t]=n=e.layout_provider.get_node_coordinates(r);return t}},o={v_compute(e){c.assert(null!=n);const[,r]=n;return n=null,r}},{edge_renderer:l,node_renderer:d}=this.model;if(!(l.glyph instanceof _.MultiLine||l.glyph instanceof h.Patches))throw new Error(this+".edge_renderer.glyph must be a MultiLine glyph");if(!(d.glyph instanceof p.XYGlyph))throw new Error(this+".node_renderer.glyph must be a XYGlyph glyph");l.glyph.properties.xs.internal=!0,l.glyph.properties.ys.internal=!0,d.glyph.properties.x.internal=!0,d.glyph.properties.y.internal=!0,l.glyph.xs={expr:t},l.glyph.ys={expr:i},d.glyph.x={expr:s},d.glyph.y={expr:o};const{parent:u}=this;this.edge_view=await a.build_view(l,{parent:u}),this.node_view=await a.build_view(d,{parent:u})}connect_signals(){super.connect_signals(),this.connect(this.model.layout_provider.change,()=>{this.edge_view.set_data(!1),this.node_view.set_data(!1),this.request_render()})}remove(){this.edge_view.remove(),this.node_view.remove(),super.remove()}_render(){this.edge_view.render(),this.node_view.render()}renderer_view(e){if(e instanceof o.GlyphRenderer){if(e==this.edge_view.model)return this.edge_view;if(e==this.node_view.model)return this.node_view}return super.renderer_view(e)}}n.GraphRendererView=u,u.__name__="GraphRendererView";class y extends s.DataRenderer{constructor(e){super(e)}static init_GraphRenderer(){this.prototype.default_view=u,this.define(({Ref:e})=>({layout_provider:[e(l.LayoutProvider)],node_renderer:[e(o.GlyphRenderer)],edge_renderer:[e(o.GlyphRenderer)],selection_policy:[e(d.GraphHitTestPolicy),()=>new d.NodesOnly],inspection_policy:[e(d.GraphHitTestPolicy),()=>new d.NodesOnly]}))}get_selection_manager(){return this.node_renderer.data_source.selection_manager}}n.GraphRenderer=y,y.__name__="GraphRenderer",y.init_GraphRenderer()},
function _(o,e,r,t,n){t();const s=o(88);class c extends s.Model{constructor(o){super(o)}}r.LayoutProvider=c,c.__name__="LayoutProvider"},
function _(e,t,n,d,s){d();const o=e(88),_=e(12),i=e(9),r=e(94);class c extends o.Model{constructor(e){super(e)}_hit_test_nodes(e,t){if(!t.model.visible)return null;const n=t.node_view.glyph.hit_test(e);return null==n?null:t.node_view.model.view.convert_selection_from_subset(n)}_hit_test_edges(e,t){if(!t.model.visible)return null;const n=t.edge_view.glyph.hit_test(e);return null==n?null:t.edge_view.model.view.convert_selection_from_subset(n)}}n.GraphHitTestPolicy=c,c.__name__="GraphHitTestPolicy";class a extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test_nodes(e,t)}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;return s.update(e,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.model.get_selection_manager().get_or_create_inspector(n.node_view.model);return o.update(e,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!o.is_empty()}}n.NodesOnly=a,a.__name__="NodesOnly";class l extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test_nodes(e,t)}get_linked_edges(e,t,n){let d=[];"selection"==n?d=e.selected.indices.map(t=>e.data.index[t]):"inspection"==n&&(d=e.inspected.indices.map(t=>e.data.index[t]));const s=[];for(let e=0;e<t.data.start.length;e++)(i.contains(d,t.data.start[e])||i.contains(d,t.data.end[e]))&&s.push(e);const o=new r.Selection;for(const e of s)o.multiline_indices[e]=[0];return o.indices=s,o}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;s.update(e,n,d);const o=t.edge_renderer.data_source.selected,_=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(_,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);o.update(e,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0});const _=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),i=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return _.update(i,d,s),n.edge_view.model.data_source.setv({inspected:_},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!o.is_empty()}}n.NodesAndLinkedEdges=l,l.__name__="NodesAndLinkedEdges";class u extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test_edges(e,t)}get_linked_nodes(e,t,n){let d=[];"selection"==n?d=t.selected.indices:"inspection"==n&&(d=t.inspected.indices);const s=[];for(const e of d)s.push(t.data.start[e]),s.push(t.data.end[e]);const o=i.uniq(s).map(t=>_.indexOf(e.data.index,t));return new r.Selection({indices:o})}do_selection(e,t,n,d){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;s.update(e,n,d);const o=t.node_renderer.data_source.selected,_=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(_,n,d),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);o.update(e,d,s),n.edge_view.model.data_source.setv({inspected:o},{silent:!0});const _=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),i=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return _.update(i,d,s),n.node_view.model.data_source.setv({inspected:_},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view.model,{geometry:t}]),!o.is_empty()}}n.EdgesAndLinkedNodes=u,u.__name__="EdgesAndLinkedNodes"},
function _(e,t,i,s,n){s();const o=e(1),l=e(36),r=e(28),_=o.__importStar(e(108)),c=o.__importStar(e(18)),a=e(12),h=e(13),d=e(95),x=e(107),y=e(94);class g extends d.GlyphView{_project_data(){l.inplace.project_xy(this._xs.array,this._ys.array)}_index_data(e){const{data_size:t}=this;for(let i=0;i<t;i++){const t=this._xs.get(i);if(0==t.length){e.add_empty();continue}const s=this._ys.get(i);if(0==s.length){e.add_empty();continue}const[n,o]=a.minmax(t),[l,r]=a.minmax(s);e.add(n,l,o,r)}}_render(e,t,{sxs:i,sys:s}){for(const n of t){const t=i.get(n),o=s.get(n);this.visuals.line.set_vectorize(e,n);for(let i=0,s=t.length;i<s;i++)0!=i?isNaN(t[i])||isNaN(o[i])?(e.stroke(),e.beginPath()):e.lineTo(t[i],o[i]):(e.beginPath(),e.moveTo(t[i],o[i]));e.stroke()}}_hit_point(e){const t={x:e.sx,y:e.sy};let i=9999;const s=new Map;for(let e=0,n=this.sxs.length;e<n;e++){const n=Math.max(2,this.visuals.line.cache_select("line_width",e)/2),o=this.sxs.get(e),l=this.sys.get(e);let r=null;for(let e=0,s=o.length-1;e<s;e++){const s={x:o[e],y:l[e]},c={x:o[e+1],y:l[e+1]},a=_.dist_to_segment(t,s,c);a<n&&a<i&&(i=a,r=[e])}null!=r&&s.set(e,r)}return new y.Selection({indices:[...s.keys()],multiline_indices:h.to_object(s)})}_hit_span(e){const{sx:t,sy:i}=e;let s,n;"v"==e.direction?(s=this.renderer.yscale.invert(i),n=this._ys):(s=this.renderer.xscale.invert(t),n=this._xs);const o=new Map;for(let e=0,t=n.length;e<t;e++){const t=n.get(e),i=[];for(let e=0,n=t.length-1;e<n;e++)t[e]<=s&&s<=t[e+1]&&i.push(e);i.length>0&&o.set(e,i)}return new y.Selection({indices:[...o.keys()],multiline_indices:h.to_object(o)})}get_interpolation_hit(e,t,i){const s=this._xs.get(e),n=this._ys.get(e),o=s[t],l=n[t],r=s[t+1],_=n[t+1];return x.line_interpolation(this.renderer,i,o,l,r,_)}draw_legend_for_index(e,t,i){x.generic_line_legend(this.visuals,e,t,i)}scenterxy(){throw new Error(this+".scenterxy() is not implemented")}}i.MultiLineView=g,g.__name__="MultiLineView";class u extends d.Glyph{constructor(e){super(e)}static init_MultiLine(){this.prototype.default_view=g,this.define(({})=>({xs:[c.XCoordinateSeqSpec,{field:"xs"}],ys:[c.YCoordinateSeqSpec,{field:"ys"}]})),this.mixins(r.LineVector)}}i.MultiLine=u,u.__name__="MultiLine",u.init_MultiLine()},
function _(e,t,s,i,n){i();const r=e(1),o=e(95),a=e(107),_=e(12),c=e(28),l=r.__importStar(e(108)),h=r.__importStar(e(18)),d=e(94),y=e(11),p=e(36);class x extends o.GlyphView{_project_data(){p.inplace.project_xy(this._xs.array,this._ys.array)}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const t=this._xs.get(s),i=this._ys.get(s);if(0==t.length)e.add_empty();else{const[s,n]=_.minmax(t),[r,o]=_.minmax(i);e.add(s,r,n,o)}}}_mask_data(){const{x_range:e,y_range:t}=this.renderer.plot_view.frame;return this.index.indices({x0:e.min,x1:e.max,y0:t.min,y1:t.max})}_inner_loop(e,t,s,i){for(let n=0,r=t.length;n<r;n++)0!=n?isNaN(t[n]+s[n])?(e.closePath(),i.apply(e),e.beginPath()):e.lineTo(t[n],s[n]):(e.beginPath(),e.moveTo(t[n],s[n]));e.closePath(),i.call(e)}_render(e,t,{sxs:s,sys:i}){for(const n of t){const t=s.get(n),r=i.get(n);this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,n),this._inner_loop(e,t,r,e.fill)),this.visuals.hatch.doit2(e,n,()=>this._inner_loop(e,t,r,e.fill),()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,n),this._inner_loop(e,t,r,e.stroke))}}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,r=[t,s,s,t],o=[i,i,n,n],[a,_]=this.renderer.xscale.r_invert(t,s),[c,h]=this.renderer.yscale.r_invert(i,n),y=this.index.indices({x0:a,x1:_,y0:c,y1:h}),p=[];for(const e of y){const t=this.sxs.get(e),s=this.sys.get(e);let i=!0;for(let e=0,n=t.length;e<n;e++){const n=t[e],a=s[e];if(!l.point_in_poly(n,a,r,o)){i=!1;break}}i&&p.push(e)}return new d.Selection({indices:p})}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(s),r=this.index.indices({x0:i,y0:n,x1:i,y1:n}),o=[];for(const e of r){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;for(let a=0,_=0;;_++){if(isNaN(i[_])||_==r){const r=i.subarray(a,_),c=n.subarray(a,_);if(l.point_in_poly(t,s,r,c)){o.push(e);break}a=_+1}if(_==r)break}}return new d.Selection({indices:o})}_get_snap_coord(e){return _.sum(e)/e.length}scenterxy(e,t,s){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;let o=!1;for(let e=0,a=0;;a++){const _=isNaN(i[a]);if(o=o||_,a==r&&!o){return[this._get_snap_coord(i),this._get_snap_coord(n)]}if(_||a==r){const r=i.subarray(e,a),o=n.subarray(e,a);if(l.point_in_poly(t,s,r,o)){return[this._get_snap_coord(r),this._get_snap_coord(o)]}e=a+1}if(a==r)break}y.unreachable()}draw_legend_for_index(e,t,s){a.generic_area_legend(this.visuals,e,t,s)}}s.PatchesView=x,x.__name__="PatchesView";class f extends o.Glyph{constructor(e){super(e)}static init_Patches(){this.prototype.default_view=x,this.define(({})=>({xs:[h.XCoordinateSeqSpec,{field:"xs"}],ys:[h.YCoordinateSeqSpec,{field:"ys"}]})),this.mixins([c.LineVector,c.FillVector,c.HatchVector])}}s.Patches=f,f.__name__="Patches",f.init_Patches()},
function _(e,t,n,s,o){s();const r=e(88);class c extends r.Model{do_selection(e,t,n,s){return null!==e&&(t.selected.update(e,n,s),t._select.emit(),!t.selected.is_empty())}}n.SelectionPolicy=c,c.__name__="SelectionPolicy";class l extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!==t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_intersection(t);return e}return null}}n.IntersectRenderers=l,l.__name__="IntersectRenderers";class _ extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!==t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_union(t);return e}return null}}n.UnionRenderers=_,_.__name__="UnionRenderers"},
function _(t,n,e,s,o){s();const r=t(1),i=t(92),l=t(8),c=t(13),a=r.__importStar(t(131)),u=t(132),h=t(133);function d(t,n,e){if(l.isArray(t)){const s=t.concat(n);return null!=e&&s.length>e?s.slice(-e):s}if(l.isTypedArray(t)){const s=t.length+n.length;if(null!=e&&s>e){const o=s-e,r=t.length;let i;t.length<e?(i=new t.constructor(e),i.set(t,0)):i=t;for(let t=o,n=r;t<n;t++)i[t-o]=i[t];for(let t=0,e=n.length;t<e;t++)i[t+(r-o)]=n[t];return i}{const e=new t.constructor(n);return a.concat(t,e)}}throw new Error("unsupported array types")}function f(t,n){let e,s,o;return l.isNumber(t)?(e=t,o=t+1,s=1):(e=null!=t.start?t.start:0,o=null!=t.stop?t.stop:n,s=null!=t.step?t.step:1),[e,o,s]}function m(t,n){const e=new Set;let s=!1;for(const[o,r]of n){let n,i,c,a;if(l.isArray(o)){const[s]=o;e.add(s),n=t[s].shape,i=t[s],a=r,2===o.length?(n=[1,n[0]],c=[o[0],0,o[1]]):c=o}else l.isNumber(o)?(a=[r],e.add(o)):(a=r,s=!0),c=[0,0,o],n=[1,t.length],i=t;let u=0;const[h,d,m]=f(c[1],n[0]),[_,p,g]=f(c[2],n[1]);for(let t=h;t<d;t+=m)for(let o=_;o<p;o+=g)s&&e.add(o),i[t*n[1]+o]=a[u],u++}return e}e.stream_to_column=d,e.slice=f,e.patch_to_column=m;class _ extends i.ColumnarDataSource{constructor(t){super(t)}static init_ColumnDataSource(){this.define(({Dict:t,Any:n})=>({data:[t(n),{}]}))}stream(t,n,e){const{data:s}=this;for(const[e,o]of c.entries(t))s[e]=d(s[e],o,n);if(this.setv({data:s},{silent:!0}),this.streaming.emit(),null!=this.document){const s=new h.ColumnsStreamedEvent(this.document,this.ref(),t,n);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:s})}}patch(t,n){const{data:e}=this;let s=new Set;for(const[n,o]of c.entries(t))s=u.union(s,m(e[n],o));if(this.setv({data:e},{silent:!0}),this.patching.emit([...s]),null!=this.document){const e=new h.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:n,hint:e})}}}e.ColumnDataSource=_,_.__name__="ColumnDataSource",_.init_ColumnDataSource()},
function _(t,n,o,e,c){e(),o.concat=function(t,...n){let o=t.length;for(const t of n)o+=t.length;const e=new t.constructor(o);e.set(t,0);let c=t.length;for(const t of n)e.set(t,c),c+=t.length;return e}},
function _(n,o,t,e,f){function c(...n){const o=new Set;for(const t of n)for(const n of t)o.add(n);return o}e(),t.union=c,t.intersection=function(n,...o){const t=new Set;n:for(const e of n){for(const n of o)if(!n.has(e))continue n;t.add(e)}return t},t.difference=function(n,...o){const t=new Set(n);for(const n of c(...o))t.delete(n);return t}},
function _(e,t,s,n,o){n();const i=e(30);class r{constructor(e){this.document=e}}s.DocumentEvent=r,r.__name__="DocumentEvent";class a extends r{constructor(e,t,s){super(e),this.events=t,this.setter_id=s}}s.DocumentEventBatch=a,a.__name__="DocumentEventBatch";class d extends r{}s.DocumentChangedEvent=d,d.__name__="DocumentChangedEvent";class l extends d{constructor(e,t,s){super(e),this.msg_type=t,this.msg_data=s}[i.serialize](e){const t=this.msg_data,s=e.to_serializable(t);return{kind:"MessageSent",msg_type:this.msg_type,msg_data:s}}}s.MessageSentEvent=l,l.__name__="MessageSentEvent";class _ extends d{constructor(e,t,s,n,o,i,r){super(e),this.model=t,this.attr=s,this.old=n,this.new_=o,this.setter_id=i,this.hint=r}[i.serialize](e){if(null!=this.hint)return e.to_serializable(this.hint);const t=this.new_,s=e.to_serializable(t);return this.model!=t&&e.remove_def(this.model),{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:s}}}s.ModelChangedEvent=_,_.__name__="ModelChangedEvent";class c extends d{constructor(e,t,s){super(e),this.column_source=t,this.patches=s}[i.serialize](e){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}}}s.ColumnsPatchedEvent=c,c.__name__="ColumnsPatchedEvent";class h extends d{constructor(e,t,s,n){super(e),this.column_source=t,this.data=s,this.rollover=n}[i.serialize](e){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}}}s.ColumnsStreamedEvent=h,h.__name__="ColumnsStreamedEvent";class m extends d{constructor(e,t,s){super(e),this.title=t,this.setter_id=s}[i.serialize](e){return{kind:"TitleChanged",title:this.title}}}s.TitleChangedEvent=m,m.__name__="TitleChangedEvent";class u extends d{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}[i.serialize](e){return{kind:"RootAdded",model:e.to_serializable(this.model)}}}s.RootAddedEvent=u,u.__name__="RootAddedEvent";class v extends d{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}[i.serialize](e){return{kind:"RootRemoved",model:this.model.ref()}}}s.RootRemovedEvent=v,v.__name__="RootRemovedEvent"},
function _(s,e,t,i,l){i();const _=s(1),o=s(135),n=_.__importStar(s(28));class h extends o.UpperLowerView{connect_signals(){super.connect_signals();const s=()=>this.set_data(this.model.source);this.connect(this.model.change,s),this.connect(this.model.source.streaming,s),this.connect(this.model.source.patching,s),this.connect(this.model.source.change,s)}_render(){this._map_data();const{ctx:s}=this.layer;s.beginPath(),s.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let e=0,t=this._lower_sx.length;e<t;e++)s.lineTo(this._lower_sx[e],this._lower_sy[e]);for(let e=this._upper_sx.length-1;e>=0;e--)s.lineTo(this._upper_sx[e],this._upper_sy[e]);s.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(s),s.fill()),s.beginPath(),s.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let e=0,t=this._lower_sx.length;e<t;e++)s.lineTo(this._lower_sx[e],this._lower_sy[e]);this.visuals.line.doit&&(this.visuals.line.set_value(s),s.stroke()),s.beginPath(),s.moveTo(this._upper_sx[0],this._upper_sy[0]);for(let e=0,t=this._upper_sx.length;e<t;e++)s.lineTo(this._upper_sx[e],this._upper_sy[e]);this.visuals.line.doit&&(this.visuals.line.set_value(s),s.stroke())}}t.BandView=h,h.__name__="BandView";class r extends o.UpperLower{constructor(s){super(s)}static init_Band(){this.prototype.default_view=h,this.mixins([n.Line,n.Fill]),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}}t.Band=r,r.__name__="Band",r.init_Band()},
function _(e,t,i,s,o){s();const r=e(1),a=e(35),n=e(92),p=e(130),_=e(20),h=r.__importStar(e(18));class u extends a.AnnotationView{initialize(){super.initialize(),this.set_data(this.model.source)}set_data(e){super.set_data(e),this.visuals.warm_cache(e),this.plot_view.request_render()}_map_data(){const{frame:e}=this.plot_view,t=this.model.dimension,i=this.coordinates.x_scale,s=this.coordinates.y_scale,o="height"==t?s:i,r="height"==t?i:s,a="height"==t?e.yview:e.xview,n="height"==t?e.xview:e.yview;let p,_,h;p="data"==this.model.properties.lower.units?o.v_compute(this._lower):a.v_compute(this._lower),_="data"==this.model.properties.upper.units?o.v_compute(this._upper):a.v_compute(this._upper),h="data"==this.model.properties.base.units?r.v_compute(this._base):n.v_compute(this._base);const[u,d]="height"==t?[1,0]:[0,1],c=[p,h],l=[_,h];this._lower_sx=c[u],this._lower_sy=c[d],this._upper_sx=l[u],this._upper_sy=l[d]}}i.UpperLowerView=u,u.__name__="UpperLowerView";class d extends h.CoordinateSpec{get dimension(){return"width"==this.obj.dimension?"x":"y"}get units(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:"data"}}i.XOrYCoordinateSpec=d,d.__name__="XOrYCoordinateSpec";class c extends a.Annotation{constructor(e){super(e)}static init_UpperLower(){this.define(({Ref:e})=>({dimension:[_.Dimension,"height"],lower:[d,{field:"lower"}],upper:[d,{field:"upper"}],base:[d,{field:"base"}],source:[e(n.ColumnarDataSource),()=>new p.ColumnDataSource]}))}}i.UpperLower=c,c.__name__="UpperLower",c.init_UpperLower()},
function _(t,i,s,e,o){e();const n=t(1),l=t(35),a=t(15),h=n.__importStar(t(28)),r=t(20),u=t(86);s.EDGE_TOLERANCE=2.5;class _ extends l.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_paint(this)),this.connect(this.model.data_update,()=>this.plot_view.request_paint(this))}_render(){if(null==this.model.left&&null==this.model.right&&null==this.model.top&&null==this.model.bottom)return;const{frame:t}=this.plot_view,i=this.coordinates.x_scale,s=this.coordinates.y_scale,e=(t,i,s,e,o)=>{let n;return n=null!=t?this.model.screen?t:"data"==i?s.compute(t):e.compute(t):o,n};this.sleft=e(this.model.left,this.model.left_units,i,t.xview,t.bbox.left),this.sright=e(this.model.right,this.model.right_units,i,t.xview,t.bbox.right),this.stop=e(this.model.top,this.model.top_units,s,t.yview,t.bbox.top),this.sbottom=e(this.model.bottom,this.model.bottom_units,s,t.yview,t.bbox.bottom),this._paint_box(this.sleft,this.sright,this.sbottom,this.stop)}_paint_box(t,i,s,e){const{ctx:o}=this.layer;o.save(),o.beginPath(),o.rect(t,e,i-t,s-e),this.visuals.fill.doit&&(this.visuals.fill.set_value(o),o.fill()),this.visuals.line.doit&&(this.visuals.line.set_value(o),o.stroke()),o.restore()}interactive_bbox(){const t=this.model.properties.line_width.value()+s.EDGE_TOLERANCE;return new u.BBox({x0:this.sleft-t,y0:this.stop-t,x1:this.sright+t,y1:this.sbottom+t})}interactive_hit(t,i){if(null==this.model.in_cursor)return!1;return this.interactive_bbox().contains(t,i)}cursor(t,i){return Math.abs(t-this.sleft)<3||Math.abs(t-this.sright)<3?this.model.ew_cursor:Math.abs(i-this.sbottom)<3||Math.abs(i-this.stop)<3?this.model.ns_cursor:t>this.sleft&&t<this.sright&&i>this.stop&&i<this.sbottom?this.model.in_cursor:null}}s.BoxAnnotationView=_,_.__name__="BoxAnnotationView";class c extends l.Annotation{constructor(t){super(t)}static init_BoxAnnotation(){this.prototype.default_view=_,this.mixins([h.Line,h.Fill]),this.define(({Number:t,Nullable:i})=>({render_mode:[r.RenderMode,"canvas"],top:[i(t),null],top_units:[r.SpatialUnits,"data"],bottom:[i(t),null],bottom_units:[r.SpatialUnits,"data"],left:[i(t),null],left_units:[r.SpatialUnits,"data"],right:[i(t),null],right_units:[r.SpatialUnits,"data"]})),this.internal(({Boolean:t,String:i,Nullable:s})=>({screen:[t,!1],ew_cursor:[s(i),null],ns_cursor:[s(i),null],in_cursor:[s(i),null]})),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}initialize(){super.initialize(),this.data_update=new a.Signal0(this,"data_update")}update({left:t,right:i,top:s,bottom:e}){this.setv({left:t,right:i,top:s,bottom:e,screen:!0},{silent:!0}),this.data_update.emit()}}s.BoxAnnotation=c,c.__name__="BoxAnnotation",c.init_BoxAnnotation()},
function _(t,e,i,o,a){o();const s=t(1),r=t(35),n=t(138),l=t(140),_=t(141),h=t(143),m=t(144),c=t(148),d=t(157),u=t(169),g=t(170),p=t(168),f=t(20),b=s.__importStar(t(28)),v=s.__importStar(t(171)),w=t(9),k=t(12),x=t(8),j=t(11);class M extends r.AnnotationView{initialize(){super.initialize(),this._set_canvas_image()}connect_signals(){super.connect_signals(),this.connect(this.model.ticker.change,()=>this.plot_view.request_render()),this.connect(this.model.formatter.change,()=>this.plot_view.request_render()),null!=this.model.color_mapper&&this.connect(this.model.color_mapper.change,()=>{this._set_canvas_image(),this.plot_view.request_render()})}_get_size(){if(null==this.model.color_mapper)return{width:0,height:0};{const{width:t,height:e}=this.compute_legend_dimensions();return{width:t,height:e}}}_set_canvas_image(){if(null==this.model.color_mapper)return;let t,e,{palette:i}=this.model.color_mapper;switch("vertical"==this.model.orientation&&(i=w.reversed(i)),this.model.orientation){case"vertical":[t,e]=[1,i.length];break;case"horizontal":[t,e]=[i.length,1]}const o=document.createElement("canvas");o.width=t,o.height=e;const a=o.getContext("2d"),s=a.getImageData(0,0,t,e),r=new c.LinearColorMapper({palette:i}).rgba_mapper.v_compute(w.range(0,i.length));s.data.set(r),a.putImageData(s,0,0),this.image=o}compute_legend_dimensions(){const t=this._computed_image_dimensions(),[e,i]=[t.height,t.width],o=this._get_label_extent(),a=this._title_extent(),s=this._tick_extent(),{padding:r}=this.model;let n,l;switch(this.model.orientation){case"vertical":n=e+a+2*r,l=i+s+o+2*r;break;case"horizontal":n=e+a+s+o+2*r,l=i+2*r}return{width:l,height:n}}compute_legend_location(){const t=this.compute_legend_dimensions(),[e,i]=[t.height,t.width],o=this.model.margin,a=null!=this.panel?this.panel:this.plot_view.frame,[s,r]=a.bbox.ranges,{location:n}=this.model;let l,_;if(x.isString(n))switch(n){case"top_left":l=s.start+o,_=r.start+o;break;case"top_center":l=(s.end+s.start)/2-i/2,_=r.start+o;break;case"top_right":l=s.end-o-i,_=r.start+o;break;case"bottom_right":l=s.end-o-i,_=r.end-o-e;break;case"bottom_center":l=(s.end+s.start)/2-i/2,_=r.end-o-e;break;case"bottom_left":l=s.start+o,_=r.end-o-e;break;case"center_left":l=s.start+o,_=(r.end+r.start)/2-e/2;break;case"center":l=(s.end+s.start)/2-i/2,_=(r.end+r.start)/2-e/2;break;case"center_right":l=s.end-o-i,_=(r.end+r.start)/2-e/2}else if(x.isArray(n)&&2==n.length){const[t,i]=n;l=a.xview.compute(t),_=a.yview.compute(i)-e}else j.unreachable();return{sx:l,sy:_}}_render(){if(null==this.model.color_mapper)return;const{ctx:t}=this.layer;t.save();const{sx:e,sy:i}=this.compute_legend_location();t.translate(e,i),this._draw_bbox(t);const o=this._get_image_offset();t.translate(o.x,o.y),this._draw_image(t);const a=this.tick_info();this._draw_major_ticks(t,a),this._draw_minor_ticks(t,a),this._draw_major_labels(t,a),this.model.title&&this._draw_title(t),t.restore()}_draw_bbox(t){const e=this.compute_legend_dimensions();t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(0,0,e.width,e.height)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()}_draw_image(t){const e=this._computed_image_dimensions();t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this.image,0,0,e.width,e.height),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()}_draw_major_ticks(t,e){if(!this.visuals.major_tick_line.doit)return;const[i,o]=this._normals(),a=this._computed_image_dimensions(),[s,r]=[a.width*i,a.height*o],[n,l]=e.coords.major,_=this.model.major_tick_in,h=this.model.major_tick_out;t.save(),t.translate(s,r),this.visuals.major_tick_line.set_value(t);for(let e=0,a=n.length;e<a;e++)t.beginPath(),t.moveTo(Math.round(n[e]+i*h),Math.round(l[e]+o*h)),t.lineTo(Math.round(n[e]-i*_),Math.round(l[e]-o*_)),t.stroke();t.restore()}_draw_minor_ticks(t,e){if(!this.visuals.minor_tick_line.doit)return;const[i,o]=this._normals(),a=this._computed_image_dimensions(),[s,r]=[a.width*i,a.height*o],[n,l]=e.coords.minor,_=this.model.minor_tick_in,h=this.model.minor_tick_out;t.save(),t.translate(s,r),this.visuals.minor_tick_line.set_value(t);for(let e=0,a=n.length;e<a;e++)t.beginPath(),t.moveTo(Math.round(n[e]+i*h),Math.round(l[e]+o*h)),t.lineTo(Math.round(n[e]-i*_),Math.round(l[e]-o*_)),t.stroke();t.restore()}_draw_major_labels(t,e){if(!this.visuals.major_label_text.doit)return;const[i,o]=this._normals(),a=this._computed_image_dimensions(),[s,r]=[a.width*i,a.height*o],n=this.model.label_standoff+this._tick_extent(),[l,_]=[n*i,n*o],[h,m]=e.coords.major,c=e.labels.major;this.visuals.major_label_text.set_value(t),t.save(),t.translate(s+l,r+_);for(let e=0,a=h.length;e<a;e++)t.fillText(c[e],Math.round(h[e]+i*this.model.label_standoff),Math.round(m[e]+o*this.model.label_standoff));t.restore()}_draw_title(t){this.visuals.title_text.doit&&(t.save(),this.visuals.title_text.set_value(t),t.fillText(this.model.title,0,-this.model.title_standoff),t.restore())}_get_label_extent(){const t=this.tick_info().labels.major;let e;if(w.is_empty(t))e=0;else{const{ctx:i}=this.layer;switch(i.save(),this.visuals.major_label_text.set_value(i),this.model.orientation){case"vertical":e=w.max(t.map(t=>i.measureText(t.toString()).width));break;case"horizontal":e=v.measure_font(this.visuals.major_label_text.font_value()).height}e+=this.model.label_standoff,i.restore()}return e}_get_image_offset(){return{x:this.model.padding,y:this.model.padding+this._title_extent()}}_normals(){return"vertical"==this.model.orientation?[1,0]:[0,1]}_title_extent(){const t=this.model.title_text_font+" "+this.model.title_text_font_size+" "+this.model.title_text_font_style;return this.model.title?v.measure_font(t).height+this.model.title_standoff:0}_tick_extent(){return w.max([this.model.major_tick_out,this.model.minor_tick_out])}_computed_image_dimensions(){var t;const{bbox:e}=null!==(t=this.panel)&&void 0!==t?t:this.plot_view.frame,{padding:i}=this.model,o=this._title_extent();let a,s;switch(this.model.orientation){case"vertical":"auto"==this.model.height?null!=this.panel?s=e.height-2*i-o:(s=w.max([25*this.model.color_mapper.palette.length,.3*e.height]),s=w.min([s,.8*e.height-2*i-o])):s=this.model.height,a="auto"==this.model.width?25:this.model.width;break;case"horizontal":s="auto"==this.model.height?25:this.model.height,"auto"==this.model.width?null!=this.panel?a=e.width-2*i:(a=w.max([25*this.model.color_mapper.palette.length,.3*e.width]),a=w.min([a,.8*e.width-2*i])):a=this.model.width}return{width:a,height:s}}_tick_coordinate_scale(t){const e={source_range:new p.Range1d({start:this.model.color_mapper.metrics.min,end:this.model.color_mapper.metrics.max}),target_range:new p.Range1d({start:0,end:t})},{color_mapper:i}=this.model;if(i instanceof c.LinearColorMapper)return new d.LinearScale(e);if(i instanceof c.LogColorMapper)return new g.LogScale(e);if(i instanceof c.ScanningColorMapper){const{binning:t}=i.metrics;return new u.LinearInterpolationScale(Object.assign(Object.assign({},e),{binning:t}))}j.unreachable()}_format_major_labels(t,e){const i=this.model.formatter.doFormat(t,{loc:NaN});for(let t=0,o=e.length;t<o;t++)e[t]in this.model.major_label_overrides&&(i[t]=this.model.major_label_overrides[e[t]]);return i}tick_info(){const t=this._computed_image_dimensions();let e;switch(this.model.orientation){case"vertical":e=t.height;break;case"horizontal":e=t.width}const i=this._tick_coordinate_scale(e),[o,a]=this._normals(),[s,r]=[this.model.color_mapper.metrics.min,this.model.color_mapper.metrics.max],n=this.model.ticker.get_ticks_no_defaults(s,r,NaN,this.model.ticker.desired_num_ticks),l=n.major,_=n.minor,h=[[],[]],m=[[],[]];for(let t=0,e=l.length;t<e;t++)l[t]<s||l[t]>r||(h[o].push(l[t]),h[a].push(0));for(let t=0,e=_.length;t<e;t++)_[t]<s||_[t]>r||(m[o].push(_[t]),m[a].push(0));const c={major:this._format_major_labels(h[o],l)},d={major:[[],[]],minor:[[],[]]};return d.major[o]=i.v_compute(h[o]),d.minor[o]=i.v_compute(m[o]),d.major[a]=h[a],d.minor[a]=m[a],"vertical"==this.model.orientation&&(d.major[o]=k.map(d.major[o],t=>e-t),d.minor[o]=k.map(d.minor[o],t=>e-t)),{coords:d,labels:c}}}i.ColorBarView=M,M.__name__="ColorBarView";class C extends r.Annotation{constructor(t){super(t)}static init_ColorBar(){this.prototype.default_view=M,this.mixins([["major_label_",b.Text],["title_",b.Text],["major_tick_",b.Line],["minor_tick_",b.Line],["border_",b.Line],["bar_",b.Line],["background_",b.Fill]]),this.define(({Alpha:t,Number:e,String:i,Tuple:o,Dict:a,Or:s,Ref:r,Auto:c})=>({location:[s(f.LegendLocation,o(e,e)),"top_right"],orientation:[f.Orientation,"vertical"],title:[i],title_standoff:[e,2],width:[s(e,c),"auto"],height:[s(e,c),"auto"],scale_alpha:[t,1],ticker:[r(n.ContinuousTicker),()=>new _.BasicTicker],formatter:[r(l.TickFormatter),()=>new h.BasicTickFormatter],major_label_overrides:[a(i),{}],color_mapper:[r(m.ContinuousColorMapper)],label_standoff:[e,5],margin:[e,30],padding:[e,10],major_tick_in:[e,5],major_tick_out:[e,0],minor_tick_in:[e,0],minor_tick_out:[e,0]})),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_align:"center",major_label_text_baseline:"middle",major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})}}i.ColorBar=C,C.__name__="ColorBar",C.init_ColorBar()},
function _(t,i,n,s,e){s();const o=t(139),r=t(9);class c extends o.Ticker{constructor(t){super(t)}static init_ContinuousTicker(){this.define(({Int:t})=>({num_minor_ticks:[t,5],desired_num_ticks:[t,6]}))}get_ticks(t,i,n,s){return this.get_ticks_no_defaults(t,i,s,this.desired_num_ticks)}get_ticks_no_defaults(t,i,n,s){const e=this.get_interval(t,i,s),o=Math.floor(t/e),c=Math.ceil(i/e);let _;_=isFinite(o)&&isFinite(c)?r.range(o,c+1):[];const u=_.map(t=>t*e).filter(n=>t<=n&&n<=i),a=this.num_minor_ticks,f=[];if(a>0&&u.length>0){const n=e/a,s=r.range(0,a).map(t=>t*n);for(const n of s.slice(1)){const s=u[0]-n;t<=s&&s<=i&&f.push(s)}for(const n of u)for(const e of s){const s=n+e;t<=s&&s<=i&&f.push(s)}}return{major:u,minor:f}}get_ideal_interval(t,i,n){return(i-t)/n}}n.ContinuousTicker=c,c.__name__="ContinuousTicker",c.init_ContinuousTicker()},
function _(c,e,n,s,o){s();const r=c(88);class t extends r.Model{constructor(c){super(c)}}n.Ticker=t,t.__name__="Ticker"},
function _(t,o,r,c,e){c();const n=t(88);class u extends n.Model{constructor(t){super(t)}compute(t,o){return this.doFormat([t],null!=o?o:{loc:0})[0]}v_compute(t,o){return this.doFormat(t,null!=o?o:{loc:0})}}r.TickFormatter=u,u.__name__="TickFormatter"},
function _(c,e,s,i,n){i();const r=c(142);class t extends r.AdaptiveTicker{constructor(c){super(c)}}s.BasicTicker=t,t.__name__="BasicTicker"},
function _(t,i,a,e,s){e();const n=t(138),r=t(9),_=t(10);class l extends n.ContinuousTicker{constructor(t){super(t)}static init_AdaptiveTicker(){this.define(({Number:t,Array:i,Nullable:a})=>({base:[t,10],mantissas:[i(t),[1,2,5]],min_interval:[t,0],max_interval:[a(t),null]}))}get_min_interval(){return this.min_interval}get_max_interval(){var t;return null!==(t=this.max_interval)&&void 0!==t?t:1/0}initialize(){super.initialize();const t=r.nth(this.mantissas,-1)/this.base,i=r.nth(this.mantissas,0)*this.base;this.extended_mantissas=[t,...this.mantissas,i],this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()}get_interval(t,i,a){const e=i-t,s=this.get_ideal_interval(t,i,a),n=Math.floor(_.log(s/this.base_factor,this.base)),l=this.base**n*this.base_factor,h=this.extended_mantissas,m=h.map(t=>Math.abs(a-e/(t*l))),v=h[r.argmin(m)]*l;return _.clamp(v,this.get_min_interval(),this.get_max_interval())}}a.AdaptiveTicker=l,l.__name__="AdaptiveTicker",l.init_AdaptiveTicker()},
function _(i,t,e,s,n){s();const o=i(140),r=i(29);class c extends o.TickFormatter{constructor(i){super(i),this.last_precision=3}static init_BasicTickFormatter(){this.define(({Boolean:i,Int:t,Auto:e,Or:s})=>({precision:[s(t,e),"auto"],use_scientific:[i,!0],power_limit_high:[t,5],power_limit_low:[t,-3]}))}get scientific_limit_low(){return 10**this.power_limit_low}get scientific_limit_high(){return 10**this.power_limit_high}_need_sci(i){if(!this.use_scientific)return!1;const{scientific_limit_high:t}=this,{scientific_limit_low:e}=this,s=i.length<2?0:Math.abs(i[1]-i[0])/1e4;for(const n of i){const i=Math.abs(n);if(!(i<=s)&&(i>=t||i<=e))return!0}return!1}_format_with_precision(i,t,e){return t?i.map(i=>i.toExponential(e)):i.map(i=>r.to_fixed(i,e))}_auto_precision(i,t){const e=new Array(i.length),s=this.last_precision<=15;i:for(let n=this.last_precision;s?n<=15:n>=1;s?n++:n--){if(t){e[0]=i[0].toExponential(n);for(let t=1;t<i.length;t++)if(e[t]==e[t-1])continue i;this.last_precision=n;break}e[0]=r.to_fixed(i[0],n);for(let t=1;t<i.length;t++)if(e[t]=r.to_fixed(i[t],n),e[t]==e[t-1])continue i;this.last_precision=n;break}return this.last_precision}doFormat(i,t){if(0==i.length)return[];const e=this._need_sci(i),s="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,s)}}e.BasicTickFormatter=c,c.__name__="BasicTickFormatter",c.init_BasicTickFormatter()},
function _(t,o,n,e,s){e();const l=t(145),i=t(103),c=t(9),a=t(8);class r extends l.ColorMapper{constructor(t){super(t),this._scan_data=null}static init_ContinuousColorMapper(){this.define(({Number:t,String:o,Ref:n,Color:e,Or:s,Tuple:l,Array:c,Nullable:a})=>({high:[a(t),null],low:[a(t),null],high_color:[a(e),null],low_color:[a(e),null],domain:[c(l(n(i.GlyphRenderer),s(o,c(o)))),[]]}))}connect_signals(){super.connect_signals();const t=()=>{for(const[t]of this.domain)this.connect(t.view.change,()=>this.update_data()),this.connect(t.data_source.selected.change,()=>this.update_data())};this.connect(this.properties.domain.change,()=>t()),t()}update_data(){const{domain:t,palette:o}=this,n=[...this._collect(t)];this._scan_data=this.scan(n,o.length),this.change.emit()}get metrics(){return null==this._scan_data&&this.update_data(),this._scan_data}*_collect(t){for(const[o,n]of t)for(const t of a.isArray(n)?n:[n]){let n=o.data_source.get_column(t);n=o.view.indices.select(n);const e=o.view.masked,s=o.data_source.selected.indices;let l;if(null!=e&&s.length>0?l=c.intersection([...e],s):null!=e?l=[...e]:s.length>0&&(l=s),null!=l&&(n=c.map(l,t=>n[t])),n.length>0&&!a.isNumber(n[0]))for(const t of n)yield*t;else yield*n}}_v_compute(t,o,n,e){const{nan_color:s}=e;let{low_color:l,high_color:i}=e;null==l&&(l=n[0]),null==i&&(i=n[n.length-1]);const{domain:a}=this,r=c.is_empty(a)?t:[...this._collect(a)];this._scan_data=this.scan(r,n.length);for(let e=0,c=t.length;e<c;e++){const c=t[e];isNaN(c)?o[e]=s:o[e]=this.cmap(c,n,l,i,this._scan_data)}}_colors(t){return Object.assign(Object.assign({},super._colors(t)),{low_color:null!=this.low_color?t(this.low_color):void 0,high_color:null!=this.high_color?t(this.high_color):void 0})}}n.ContinuousColorMapper=r,r.__name__="ContinuousColorMapper",r.init_ContinuousColorMapper()},
function _(t,r,e,n,o){n();const i=t(146),c=t(8),l=t(22),_=t(82);function a(t){return c.isNumber(t)?t:("#"!=t[0]&&(t=l.color2hex(t)),9!=t.length&&(t+="ff"),parseInt(t.slice(1),16))}function s(t){const r=new Uint32Array(t.length);for(let e=0,n=t.length;e<n;e++)r[e]=a(t[e]);return r}function p(t){if(_.is_little_endian){const r=new DataView(t.buffer);for(let e=0,n=t.length;e<n;e++)r.setUint32(4*e,t[e])}return new Uint8Array(t.buffer)}e._convert_color=a,e._convert_palette=s,e._uint32_to_rgba=p;class u extends i.Mapper{constructor(t){super(t)}static init_ColorMapper(){this.define(({Number:t,Color:r,Array:e,Or:n})=>({palette:[e(n(r,t))],nan_color:[r,"gray"]}))}v_compute(t){const r=new Array(t.length);return this._v_compute(t,r,this.palette,this._colors(t=>t)),r}get rgba_mapper(){const t=this,r=s(this.palette),e=this._colors(a);return{v_compute(n){const o=new Uint32Array(n.length);return t._v_compute(n,o,r,e),p(o)}}}_colors(t){return{nan_color:t(this.nan_color)}}}e.ColorMapper=u,u.__name__="ColorMapper",u.init_ColorMapper()},
function _(r,e,n,s,o){s();const p=r(147);class t extends p.Transform{constructor(r){super(r)}compute(r){throw new Error("mapping single values is not supported")}}n.Mapper=t,t.__name__="Mapper"},
function _(n,s,o,r,c){r();const e=n(88);class t extends e.Model{constructor(n){super(n)}}o.Transform=t,t.__name__="Transform"},
function _(r,o,a,p,e){p(),e("CategoricalColorMapper",r(149).CategoricalColorMapper),e("CategoricalMarkerMapper",r(151).CategoricalMarkerMapper),e("CategoricalPatternMapper",r(152).CategoricalPatternMapper),e("ContinuousColorMapper",r(144).ContinuousColorMapper),e("ColorMapper",r(145).ColorMapper),e("LinearColorMapper",r(153).LinearColorMapper),e("LogColorMapper",r(154).LogColorMapper),e("ScanningColorMapper",r(155).ScanningColorMapper),e("EqHistColorMapper",r(156).EqHistColorMapper)},
function _(t,r,a,o,e){o();const c=t(150),l=t(145);class i extends l.ColorMapper{constructor(t){super(t)}static init_CategoricalColorMapper(){this.define(({Any:t,Number:r,Array:a,Nullable:o})=>({factors:[a(t)],start:[r,0],end:[o(r),null]}))}_v_compute(t,r,a,{nan_color:o}){c.cat_v_compute(t,this.factors,a,r,this.start,this.end,o)}}a.CategoricalColorMapper=i,i.__name__="CategoricalColorMapper",i.init_CategoricalColorMapper()},
function _(n,t,e,l,i){l();const c=n(12),u=n(8);function f(n,t){if(n.length!=t.length)return!1;for(let e=0,l=n.length;e<l;e++)if(n[e]!==t[e])return!1;return!0}e._cat_equals=f,e.cat_v_compute=function(n,t,e,l,i,o,r){const _=n.length;for(let g=0;g<_;g++){let _,s,h=n[g];u.isString(h)?_=c.index_of(t,h):(null!=i?h=null!=o?h.slice(i,o):h.slice(i):null!=o&&(h=h.slice(0,o)),_=1==h.length?c.index_of(t,h[0]):c.find_index(t,n=>f(n,h))),s=_<0||_>=e.length?r:e[_],l[g]=s}}},
function _(r,e,a,t,s){t();const c=r(150),i=r(146),n=r(20);class l extends i.Mapper{constructor(r){super(r)}static init_CategoricalMarkerMapper(){this.define(({Any:r,Number:e,Array:a,Nullable:t})=>({factors:[a(r)],markers:[a(n.MarkerType)],start:[e,0],end:[t(e),null],default_value:[n.MarkerType,"circle"]}))}v_compute(r){const e=new Array(r.length);return c.cat_v_compute(r,this.factors,this.markers,e,this.start,this.end,this.default_value),e}}a.CategoricalMarkerMapper=l,l.__name__="CategoricalMarkerMapper",l.init_CategoricalMarkerMapper()},
function _(t,a,e,r,n){r();const s=t(150),c=t(146),i=t(20);class p extends c.Mapper{constructor(t){super(t)}static init_CategoricalPatternMapper(){this.define(({Any:t,Number:a,Array:e,Nullable:r})=>({factors:[e(t)],patterns:[e(i.HatchPatternType)],start:[a,0],end:[r(a),null],default_value:[i.HatchPatternType," "]}))}v_compute(t){const a=new Array(t.length);return s.cat_v_compute(t,this.factors,this.patterns,a,this.start,this.end,this.default_value),a}}e.CategoricalPatternMapper=p,p.__name__="CategoricalPatternMapper",p.init_CategoricalPatternMapper()},
function _(n,r,o,t,a){t();const e=n(144),i=n(12);class s extends e.ContinuousColorMapper{constructor(n){super(n)}scan(n,r){const o=null!=this.low?this.low:i.min(n),t=null!=this.high?this.high:i.max(n);return{max:t,min:o,norm_factor:1/(t-o),normed_interval:1/r}}cmap(n,r,o,t,a){const e=r.length-1;if(n==a.max)return r[e];const i=(n-a.min)*a.norm_factor,s=Math.floor(i/a.normed_interval);return s<0?o:s>e?t:r[s]}}o.LinearColorMapper=s,s.__name__="LinearColorMapper"},
function _(o,t,n,r,l){r();const a=o(144),s=o(12);class e extends a.ContinuousColorMapper{constructor(o){super(o)}scan(o,t){const n=null!=this.low?this.low:s.min(o),r=null!=this.high?this.high:s.max(o);return{max:r,min:n,scale:t/(Math.log(r)-Math.log(n))}}cmap(o,t,n,r,l){const a=t.length-1;if(o>l.max)return r;if(o==l.max)return t[a];if(o<l.min)return n;const s=Math.log(o)-Math.log(l.min);let e=Math.floor(s*l.scale);return e>a&&(e=a),t[e]}}n.LogColorMapper=e,e.__name__="LogColorMapper"},
function _(n,e,i,r,o){r();const t=n(144),a=n(12);class c extends t.ContinuousColorMapper{constructor(n){super(n)}cmap(n,e,i,r,o){if(n<o.binning[0])return i;if(n>o.binning[o.binning.length-1])return r;return e[a.left_edge_index(n,o.binning)]}}i.ScanningColorMapper=c,c.__name__="ScanningColorMapper"},
function _(n,t,i,e,o){e();const s=n(155),r=n(12),a=n(9),l=n(19);class c extends s.ScanningColorMapper{constructor(n){super(n)}static init_EqHistColorMapper(){this.define(({Int:n})=>({bins:[n,65536]}))}scan(n,t){const i=null!=this.low?this.low:r.min(n),e=null!=this.high?this.high:r.max(n),o=this.bins,s=a.linspace(i,e,o+1),c=r.bin_counts(n,s),p=new Array(o);for(let n=0,t=s.length;n<t-1;n++){const t=s[n],i=s[n+1];p[n]=(t+i)/2}const h=a.cumsum(c),g=h[h.length-1],u=r.map(h,n=>n/g);let m=t-1,M=[],_=0,f=2*t;for(;m!=t&&_<4&&0!=m;){const n=f/m;if(n>1e3)break;f=Math.round(Math.max(t*n,t));const i=a.range(0,f),e=r.map(u,n=>n*(f-1));M=r.interpolate(i,e,p);m=a.uniq(M).length-1,_++}if(0==m){M=[i,e];for(let n=0;n<t-1;n++)M.push(e)}else M=M.slice(M.length-t-1),m!=t&&l.logger.warn("EqHistColorMapper warning: Histogram equalization did not converge.");return{min:i,max:e,binning:M}}}i.EqHistColorMapper=c,c.__name__="EqHistColorMapper",c.init_EqHistColorMapper()},
function _(e,n,t,r,_){r();const i=e(158);class u extends i.ContinuousScale{constructor(e){super(e)}compute(e){return this._linear_compute(e)}v_compute(e){return this._linear_v_compute(e)}invert(e){return this._linear_invert(e)}v_invert(e){return this._linear_v_invert(e)}}t.LinearScale=u,u.__name__="LinearScale"},
function _(n,c,o,s,e){s();const t=n(159);class u extends t.Scale{constructor(n){super(n)}}o.ContinuousScale=u,u.__name__="ContinuousScale"},
function _(t,e,r,n,s){n();const i=t(160),_=t(101),a=t(168),c=t(24);class o extends i.Transform{constructor(t){super(t)}static init_Scale(){this.internal(({Ref:t})=>({source_range:[t(_.Range)],target_range:[t(a.Range1d)]}))}r_compute(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]}r_invert(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]}_linear_compute(t){const[e,r]=this._linear_compute_state();return e*t+r}_linear_v_compute(t){const[e,r]=this._linear_compute_state(),n=new c.NumberArray(t.length);for(let s=0;s<t.length;s++)n[s]=e*t[s]+r;return n}_linear_invert(t){const[e,r]=this._linear_compute_state();return(t-r)/e}_linear_v_invert(t){const[e,r]=this._linear_compute_state(),n=new c.NumberArray(t.length);for(let s=0;s<t.length;s++)n[s]=(t[s]-r)/e;return n}_linear_compute_state(){const t=this.source_range.start,e=this.source_range.end,r=this.target_range.start,n=(this.target_range.end-r)/(e-t);return[n,-n*t+r]}}r.Scale=o,o.__name__="Scale",o.init_Scale()},
function _(r,o,t,e,n){e(),n("CustomJSTransform",r(161).CustomJSTransform),n("Dodge",r(162).Dodge),n("Interpolator",r(164).Interpolator),n("Jitter",r(165).Jitter),n("LinearInterpolator",r(166).LinearInterpolator),n("StepInterpolator",r(167).StepInterpolator),n("Transform",r(147).Transform)},
function _(t,r,s,n,e){n();const a=t(147),o=t(13),u=t(29);class m extends a.Transform{constructor(t){super(t)}static init_CustomJSTransform(){this.define(({Unknown:t,String:r,Dict:s})=>({args:[s(t),{}],func:[r,""],v_func:[r,""]}))}get names(){return o.keys(this.args)}get values(){return o.values(this.args)}_make_transform(t,r){return new Function(...this.names,t,u.use_strict(r))}get scalar_transform(){return this._make_transform("x",this.func)}get vector_transform(){return this._make_transform("xs",this.v_func)}compute(t){return this.scalar_transform(...this.values,t)}v_compute(t){return this.vector_transform(...this.values,t)}}s.CustomJSTransform=m,m.__name__="CustomJSTransform",m.init_CustomJSTransform()},
function _(e,t,n,o,s){o();const i=e(163);class r extends i.RangeTransform{constructor(e){super(e)}static init_Dodge(){this.define(({Number:e})=>({value:[e,0]}))}_compute(e){return e+this.value}}n.Dodge=r,r.__name__="Dodge",r.init_Dodge()},
function _(e,n,t,r,s){r();const a=e(147),i=e(101),o=e(100),c=e(24),f=e(8);class u extends a.Transform{constructor(e){super(e)}static init_RangeTransform(){this.define(({Ref:e})=>({range:[e(i.Range)]}))}v_compute(e){let n;if(this.range instanceof o.FactorRange)n=this.range.v_synthetic(e);else{if(!f.isArrayableOf(e,f.isNumber))throw new Error("unexpected");n=e}const t=new c.NumberArray(n.length);for(let e=0;e<n.length;e++){const r=n[e];t[e]=this._compute(r)}return t}compute(e){if(this.range instanceof o.FactorRange)return this._compute(this.range.synthetic(e));if(f.isNumber(e))return this._compute(e);throw new Error("unexpected")}}t.RangeTransform=u,u.__name__="RangeTransform",u.init_RangeTransform()},
function _(t,r,e,n,o){n();const s=t(147),i=t(92),a=t(24),h=t(9),l=t(8);class d extends s.Transform{constructor(t){super(t),this._sorted_dirty=!0}static init_Interpolator(){this.define(({Boolean:t,Number:r,String:e,Ref:n,Array:o,Or:s,Nullable:a})=>({x:[s(e,o(r))],y:[s(e,o(r))],data:[a(n(i.ColumnarDataSource)),null],clip:[t,!0]}))}connect_signals(){super.connect_signals(),this.connect(this.change,()=>this._sorted_dirty=!0)}v_compute(t){const r=new a.NumberArray(t.length);for(let e=0;e<t.length;e++){const n=t[e];r[e]=this.compute(n)}return r}sort(t=!1){if(!this._sorted_dirty)return;let r,e;if(l.isString(this.x)&&l.isString(this.y)&&null!=this.data){const t=this.data.columns();if(!h.includes(t,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!h.includes(t,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");r=this.data.get_column(this.x),e=this.data.get_column(this.y)}else{if(!l.isArray(this.x)||!l.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");r=this.x,e=this.y}if(r.length!==e.length)throw new Error("The length for x and y do not match");if(r.length<2)throw new Error("x and y must have at least two elements to support interpolation");const n=r.length,o=new Uint32Array(n);for(let t=0;t<n;t++)o[t]=t;const s=t?-1:1;o.sort((t,e)=>s*(r[t]-r[e])),this._x_sorted=new a.NumberArray(n),this._y_sorted=new a.NumberArray(n);for(let t=0;t<n;t++)this._x_sorted[t]=r[o[t]],this._y_sorted[t]=e[o[t]];this._sorted_dirty=!1}}e.Interpolator=d,d.__name__="Interpolator",d.init_Interpolator()},
function _(t,i,e,s,r){s();const n=t(1),u=t(163),o=t(20),a=n.__importStar(t(10));class h extends u.RangeTransform{constructor(t){super(t)}static init_Jitter(){this.define(({Number:t})=>({mean:[t,0],width:[t,1],distribution:[o.Distribution,"uniform"]}))}v_compute(t){return null!=this.previous_values&&this.previous_values.length==t.length||(this.previous_values=super.v_compute(t)),this.previous_values}_compute(t){switch(this.distribution){case"uniform":return t+this.mean+(a.random()-.5)*this.width;case"normal":return t+a.rnorm(this.mean,this.width)}}}e.Jitter=h,h.__name__="Jitter",h.init_Jitter()},
function _(t,s,_,r,e){r();const i=t(9),o=t(164);class n extends o.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];const s=i.find_last_index(this._x_sorted,s=>s<t),_=this._x_sorted[s],r=this._x_sorted[s+1],e=this._y_sorted[s],o=this._y_sorted[s+1];return e+(t-_)/(r-_)*(o-e)}}_.LinearInterpolator=n,n.__name__="LinearInterpolator"},
function _(t,e,s,r,o){r();const i=t(164),_=t(20),n=t(9);class d extends i.Interpolator{constructor(t){super(t)}static init_StepInterpolator(){this.define(()=>({mode:[_.StepMode,"after"]}))}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}let e;switch(this.mode){case"after":e=n.find_last_index(this._x_sorted,e=>t>=e);break;case"before":e=n.find_index(this._x_sorted,e=>t<=e);break;case"center":{const s=this._x_sorted.map(e=>Math.abs(e-t)),r=n.min(s);e=n.find_index(s,t=>r===t);break}default:throw new Error("unknown mode: "+this.mode)}return-1!=e?this._y_sorted[e]:NaN}}s.StepInterpolator=d,d.__name__="StepInterpolator",d.init_StepInterpolator()},
function _(t,e,s,n,i){n();const a=t(101);class r extends a.Range{constructor(t){super(t)}static init_Range1d(){this.define(({Number:t,Nullable:e})=>({start:[t,0],end:[t,1],reset_start:[e(t),null,{on_update(t,e){e._reset_start=null!=t?t:e.start}}],reset_end:[e(t),null,{on_update(t,e){e._reset_end=null!=t?t:e.end}}]}))}_set_auto_bounds(){if("auto"==this.bounds){const t=Math.min(this._reset_start,this._reset_end),e=Math.max(this._reset_start,this._reset_end);this.setv({bounds:[t,e]},{silent:!0})}}initialize(){super.initialize(),this._set_auto_bounds()}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}reset(){this._set_auto_bounds();const{_reset_start:t,_reset_end:e}=this;this.start!=t||this.end!=e?this.setv({start:t,end:e}):this.change.emit()}map(t){return new r({start:t(this.start),end:t(this.end)})}widen(t){let{start:e,end:s}=this;return this.is_reversed?(e+=t,s-=t):(e-=t,s+=t),new r({start:e,end:s})}}s.Range1d=r,r.__name__="Range1d",r.init_Range1d()},
function _(n,t,e,r,a){r();const i=n(159),s=n(24),o=n(9),c=n(12);class _ extends i.Scale{constructor(n){super(n)}static init_LinearInterpolationScale(){this.internal(({Arrayable:n})=>({binning:[n]}))}compute(n){return n}v_compute(n){const t=c.norm(n,this.source_range.start,this.source_range.end),e=o.linspace(0,1,this.binning.length),r=c.interpolate(t,e,this.binning),a=c.norm(r,this.source_range.start,this.source_range.end),i=this.target_range.end-this.target_range.start,_=c.map(a,n=>this.target_range.start+n*i);return new s.NumberArray(_)}invert(n){return n}v_invert(n){return new s.NumberArray(n)}}e.LinearInterpolationScale=_,_.__name__="LinearInterpolationScale",_.init_LinearInterpolationScale()},
function _(t,e,o,a,s){a();const n=t(158),r=t(24);class l extends n.ContinuousScale{constructor(t){super(t)}compute(t){const[e,o,a,s]=this._compute_state();let n;if(0==a)n=0;else{const r=(Math.log(t)-s)/a;n=isFinite(r)?r*e+o:NaN}return n}v_compute(t){const[e,o,a,s]=this._compute_state(),n=new r.NumberArray(t.length);if(0==a)for(let e=0;e<t.length;e++)n[e]=0;else for(let r=0;r<t.length;r++){const l=(Math.log(t[r])-s)/a;let c;c=isFinite(l)?l*e+o:NaN,n[r]=c}return n}invert(t){const[e,o,a,s]=this._compute_state(),n=(t-o)/e;return Math.exp(a*n+s)}v_invert(t){const[e,o,a,s]=this._compute_state(),n=new r.NumberArray(t.length);for(let r=0;r<t.length;r++){const l=(t[r]-o)/e;n[r]=Math.exp(a*l+s)}return n}_get_safe_factor(t,e){let o=t<0?0:t,a=e<0?0:e;if(o==a)if(0==o)[o,a]=[1,10];else{const t=Math.log(o)/Math.log(10);o=10**Math.floor(t),a=Math.ceil(t)!=Math.floor(t)?10**Math.ceil(t):10**(Math.ceil(t)+1)}return[o,a]}_compute_state(){const t=this.source_range.start,e=this.source_range.end,o=this.target_range.start,a=this.target_range.end-o,[s,n]=this._get_safe_factor(t,e);let r,l;0==s?(r=Math.log(n),l=0):(r=Math.log(n)-Math.log(s),l=Math.log(s));return[a,o,r,l]}}o.LogScale=l,l.__name__="LogScale"},
function _(t,e,n,o,i){o();const l=t(71),s=new Map;n.measure_font=function(t){const e=s.get(t);if(null!=e)return e;const n=l.span({style:{font:t}},"Hg"),o=l.div({style:{display:"inline-block",width:"1px",height:"0px"}}),i=l.div({},n,o);document.body.appendChild(i);try{o.style.verticalAlign="baseline";const e=l.offset(o).top-l.offset(n).top;o.style.verticalAlign="bottom";const d=l.offset(o).top-l.offset(n).top,c={height:d,ascent:e,descent:d-e};return s.set(t,c),c}finally{document.body.removeChild(i)}};const d=new Map;n.measure_text=function(t,e){let n=d.get(e);if(null!=n){const e=n.get(t);if(null!=e)return e}else n=new Map,d.set(e,n);const o=l.div({style:{display:"inline-block","white-space":"nowrap",font:e}},t);document.body.appendChild(o);try{const{width:e,height:i}=o.getBoundingClientRect();return n.set(t,{width:e,height:i}),{width:e,height:i}}finally{document.body.removeChild(o)}}},
function _(t,e,i,s,a){s();const l=t(1),n=t(173),o=t(20),_=l.__importStar(t(28));class d extends n.TextAnnotationView{initialize(){super.initialize(),this.visuals.warm_cache()}_get_size(){const{ctx:t}=this.layer;this.visuals.text.set_value(t);const{width:e,ascent:i}=t.measureText(this.model.text);return{width:e,height:i}}_render(){let t;switch(this.model.angle_units){case"rad":t=-this.model.angle;break;case"deg":t=-this.model.angle*Math.PI/180}const e=null!=this.panel?this.panel:this.plot_view.frame,i=this.coordinates.x_scale,s=this.coordinates.y_scale;let a="data"==this.model.x_units?i.compute(this.model.x):e.xview.compute(this.model.x),l="data"==this.model.y_units?s.compute(this.model.y):e.yview.compute(this.model.y);a+=this.model.x_offset,l-=this.model.y_offset;("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,this.model.text,a,l,t)}}i.LabelView=d,d.__name__="LabelView";class h extends n.TextAnnotation{constructor(t){super(t)}static init_Label(){this.prototype.default_view=d,this.mixins([_.Text,["border_",_.Line],["background_",_.Fill]]),this.define(({Number:t,String:e,Angle:i})=>({x:[t],x_units:[o.SpatialUnits,"data"],y:[t],y_units:[o.SpatialUnits,"data"],text:[e],angle:[i,0],angle_units:[o.AngleUnits,"rad"],x_offset:[t,0],y_offset:[t,0]})),this.override({background_fill_color:null,border_line_color:null})}}i.Label=h,h.__name__="Label",h.init_Label()},
function _(e,t,s,i,l){i();const a=e(35),n=e(71),o=e(20),r=e(171),u=e(11);class _ extends a.AnnotationView{constructor(){super(...arguments),this.rotate=!0}initialize(){super.initialize(),"css"==this.model.render_mode&&(this.el=n.div(),this.plot_view.canvas_view.add_overlay(this.el))}remove(){null!=this.el&&n.remove(this.el),super.remove()}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?this.connect(this.model.change,()=>this.render()):this.connect(this.model.change,()=>this.plot_view.request_render())}render(){this.model.visible||"css"!=this.model.render_mode||n.undisplay(this.el),super.render()}_calculate_text_dimensions(e,t){const{width:s}=e.measureText(t),{height:i}=r.measure_font(this.visuals.text.font_value());return[s,i]}_calculate_bounding_box_dimensions(e,t){const[s,i]=this._calculate_text_dimensions(e,t);let l,a;switch(e.textAlign){case"left":l=0;break;case"center":l=-s/2;break;case"right":l=-s;break;default:u.unreachable()}switch(e.textBaseline){case"top":a=0;break;case"middle":a=-.5*i;break;case"bottom":a=-1*i;break;case"alphabetic":a=-.8*i;break;case"hanging":a=-.17*i;break;case"ideographic":a=-.83*i;break;default:u.unreachable()}return[l,a,s,i]}_canvas_text(e,t,s,i,l){this.visuals.text.set_value(e);const a=this._calculate_bounding_box_dimensions(e,t);e.save(),e.beginPath(),e.translate(s,i),l&&e.rotate(l),e.rect(a[0],a[1],a[2],a[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(e),e.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(e),e.fillText(t,0,0)),e.restore()}_css_text(e,t,s,i,l){const{el:a}=this;u.assert(null!=a),n.undisplay(a),this.visuals.text.set_value(e);const o=this._calculate_bounding_box_dimensions(e,t),r=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_value(e),this.visuals.background_fill.set_value(e),a.style.position="absolute",a.style.left=s+o[0]+"px",a.style.top=i+o[1]+"px",a.style.color=""+this.visuals.text.text_color.value(),a.style.opacity=""+this.visuals.text.text_alpha.value(),a.style.font=""+this.visuals.text.font_value(),a.style.lineHeight="normal",l&&(a.style.transform=`rotate(${l}rad)`),this.visuals.background_fill.doit&&(a.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(a.style.borderStyle=""+r,a.style.borderWidth=this.visuals.border_line.line_width.value()+"px",a.style.borderColor=""+this.visuals.border_line.color_value()),a.textContent=t,n.display(a)}}s.TextAnnotationView=_,_.__name__="TextAnnotationView";class d extends a.Annotation{constructor(e){super(e)}static init_TextAnnotation(){this.define(()=>({render_mode:[o.RenderMode,"canvas"]}))}}s.TextAnnotation=d,d.__name__="TextAnnotation",d.init_TextAnnotation()},
function _(t,e,s,i,o){i();const l=t(1),a=t(173),n=t(130),r=l.__importStar(t(28)),_=t(20),h=t(71),c=l.__importStar(t(18));class d extends a.TextAnnotationView{initialize(){if(super.initialize(),this.set_data(this.model.source),"css"==this.model.render_mode)for(let t=0,e=this._text.length;t<e;t++){const t=h.div({style:{display:"none"}});this.el.appendChild(t)}}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?(this.connect(this.model.change,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.streaming,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.patching,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.change,()=>{this.set_data(this.model.source),this.render()})):(this.connect(this.model.change,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.streaming,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.patching,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.change,()=>{this.set_data(this.model.source),this.plot_view.request_render()}))}set_data(t){super.set_data(t),this.visuals.warm_cache(t)}_map_data(){const t=this.coordinates.x_scale,e=this.coordinates.y_scale,s=null!=this.panel?this.panel:this.plot_view.frame;return["data"==this.model.x_units?t.v_compute(this._x):s.xview.v_compute(this._x),"data"==this.model.y_units?e.v_compute(this._y):s.yview.v_compute(this._y)]}_render(){const t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),{ctx:e}=this.layer,[s,i]=this._map_data();for(let o=0,l=this._text.length;o<l;o++)t(e,o,this._text[o],s[o]+this._x_offset[o],i[o]-this._y_offset[o],this._angle[o])}_get_size(){const{ctx:t}=this.layer;this.visuals.text.set_value(t);const{width:e,ascent:s}=t.measureText(this._text[0]);return{width:e,height:s}}_v_canvas_text(t,e,s,i,o,l){this.visuals.text.set_vectorize(t,e);const a=this._calculate_bounding_box_dimensions(t,s);t.save(),t.beginPath(),t.translate(i,o),t.rotate(l),t.rect(a[0],a[1],a[2],a[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(s,0,0)),t.restore()}_v_css_text(t,e,s,i,o,l){const a=this.el.children[e];a.textContent=s,this.visuals.text.set_vectorize(t,e);const n=this._calculate_bounding_box_dimensions(t,s),r=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_vectorize(t,e),this.visuals.background_fill.set_vectorize(t,e),a.style.position="absolute",a.style.left=i+n[0]+"px",a.style.top=o+n[1]+"px",a.style.color=""+this.visuals.text.text_color.value(),a.style.opacity=""+this.visuals.text.text_alpha.value(),a.style.font=""+this.visuals.text.font_value(),a.style.lineHeight="normal",l&&(a.style.transform=`rotate(${l}rad)`),this.visuals.background_fill.doit&&(a.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(a.style.borderStyle=""+r,a.style.borderWidth=this.visuals.border_line.line_width.value()+"px",a.style.borderColor=""+this.visuals.border_line.color_value()),h.display(a)}}s.LabelSetView=d,d.__name__="LabelSetView";class u extends a.TextAnnotation{constructor(t){super(t)}static init_LabelSet(){this.prototype.default_view=d,this.mixins([r.TextVector,["border_",r.LineVector],["background_",r.FillVector]]),this.define(({Ref:t})=>({x:[c.XCoordinateSpec],y:[c.YCoordinateSpec],x_units:[_.SpatialUnits,"data"],y_units:[_.SpatialUnits,"data"],text:[c.StringSpec,{field:"text"}],angle:[c.AngleSpec,0],x_offset:[c.NumberSpec,{value:0}],y_offset:[c.NumberSpec,{value:0}],source:[t(n.ColumnDataSource),()=>new n.ColumnDataSource]})),this.override({background_fill_color:null,border_line_color:null})}}s.LabelSet=u,u.__name__="LabelSet",u.init_LabelSet()},
function _(t,e,i,l,s){l();const n=t(1),h=t(35),a=t(176),o=t(20),_=n.__importStar(t(28)),r=t(15),d=t(171),c=t(86),g=t(9),m=t(8),f=t(11);class b extends h.AnnotationView{cursor(t,e){return"none"==this.model.click_policy?null:"pointer"}get legend_padding(){return null!=this.visuals.border_line.line_color.value()?this.model.padding:0}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render()),this.connect(this.model.item_change,()=>this.plot_view.request_render())}compute_legend_bbox(){const t=this.model.get_legend_names(),{glyph_height:e,glyph_width:i}=this.model,{label_height:l,label_width:s}=this.model;this.max_label_height=g.max([d.measure_font(this.visuals.label_text.font_value()).height,l,e]);const{ctx:n}=this.layer;n.save(),this.visuals.label_text.set_value(n),this.text_widths=new Map;for(const e of t)this.text_widths.set(e,g.max([n.measureText(e).width,s]));this.visuals.title_text.set_value(n),this.title_height=this.model.title?d.measure_font(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?n.measureText(this.model.title).width:0,n.restore();const h=Math.max(g.max([...this.text_widths.values()]),0),a=this.model.margin,{legend_padding:o}=this,_=this.model.spacing,{label_standoff:r}=this.model;let b,u;if("vertical"==this.model.orientation)b=t.length*this.max_label_height+Math.max(t.length-1,0)*_+2*o+this.title_height,u=g.max([h+i+r+2*o,this.title_width+2*o]);else{let e=2*o+Math.max(t.length-1,0)*_;for(const[,t]of this.text_widths)e+=g.max([t,s])+i+r;u=g.max([this.title_width+2*o,e]),b=this.max_label_height+this.title_height+2*o}const x=null!=this.panel?this.panel:this.plot_view.frame,[p,w]=x.bbox.ranges,{location:v}=this.model;let y,k;if(m.isString(v))switch(v){case"top_left":y=p.start+a,k=w.start+a;break;case"top_center":y=(p.end+p.start)/2-u/2,k=w.start+a;break;case"top_right":y=p.end-a-u,k=w.start+a;break;case"bottom_right":y=p.end-a-u,k=w.end-a-b;break;case"bottom_center":y=(p.end+p.start)/2-u/2,k=w.end-a-b;break;case"bottom_left":y=p.start+a,k=w.end-a-b;break;case"center_left":y=p.start+a,k=(w.end+w.start)/2-b/2;break;case"center":y=(p.end+p.start)/2-u/2,k=(w.end+w.start)/2-b/2;break;case"center_right":y=p.end-a-u,k=(w.end+w.start)/2-b/2}else if(m.isArray(v)&&2==v.length){const[t,e]=v;y=x.xview.compute(t),k=x.yview.compute(e)-b}else f.unreachable();return new c.BBox({left:y,top:k,width:u,height:b})}interactive_bbox(){return this.compute_legend_bbox()}interactive_hit(t,e){return this.interactive_bbox().contains(t,e)}on_hit(t,e){let i;const{glyph_width:l}=this.model,{legend_padding:s}=this,n=this.model.spacing,{label_standoff:h}=this.model;let a=i=s;const o=this.compute_legend_bbox(),_="vertical"==this.model.orientation;for(const r of this.model.items){const d=r.get_labels_list_from_label_prop();for(const g of d){const d=o.x+a,m=o.y+i+this.title_height;let f,b;[f,b]=_?[o.width-2*s,this.max_label_height]:[this.text_widths.get(g)+l+h,this.max_label_height];if(new c.BBox({left:d,top:m,width:f,height:b}).contains(t,e)){switch(this.model.click_policy){case"hide":for(const t of r.renderers)t.visible=!t.visible;break;case"mute":for(const t of r.renderers)t.muted=!t.muted}return!0}_?i+=this.max_label_height+n:a+=this.text_widths.get(g)+l+h+n}}return!1}_render(){if(0==this.model.items.length)return;for(const t of this.model.items)t.legend=this.model;const{ctx:t}=this.layer,e=this.compute_legend_bbox();t.save(),this._draw_legend_box(t,e),this._draw_legend_items(t,e),this.model.title&&this._draw_title(t,e),t.restore()}_draw_legend_box(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.set_value(t),t.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke())}_draw_legend_items(t,e){const{glyph_width:i,glyph_height:l}=this.model,{legend_padding:s}=this,n=this.model.spacing,{label_standoff:h}=this.model;let a=s,o=s;const _="vertical"==this.model.orientation;for(const r of this.model.items){const d=r.get_labels_list_from_label_prop(),c=r.get_field_from_label_prop();if(0==d.length)continue;const m=(()=>{switch(this.model.click_policy){case"none":return!0;case"hide":return g.every(r.renderers,t=>t.visible);case"mute":return g.every(r.renderers,t=>!t.muted)}})();for(const g of d){const d=e.x+a,f=e.y+o+this.title_height,b=d+i,u=f+l;_?o+=this.max_label_height+n:a+=this.text_widths.get(g)+i+h+n,this.visuals.label_text.set_value(t),t.fillText(g,b+h,f+this.max_label_height/2);for(const e of r.renderers){const i=this.plot_view.renderer_view(e);null==i||i.draw_legend(t,d,b,f,u,c,g,r.index)}if(!m){let l,n;[l,n]=_?[e.width-2*s,this.max_label_height]:[this.text_widths.get(g)+i+h,this.max_label_height],t.beginPath(),t.rect(d,f,l,n),this.visuals.inactive_fill.set_value(t),t.fill()}}}}_draw_title(t,e){this.visuals.title_text.doit&&(t.save(),t.translate(e.x0,e.y0+this.title_height),this.visuals.title_text.set_value(t),t.fillText(this.model.title,this.legend_padding,this.legend_padding-this.model.title_standoff),t.restore())}_get_size(){const{width:t,height:e}=this.compute_legend_bbox();return{width:t+2*this.model.margin,height:e+2*this.model.margin}}}i.LegendView=b,b.__name__="LegendView";class u extends h.Annotation{constructor(t){super(t)}initialize(){super.initialize(),this.item_change=new r.Signal0(this,"item_change")}static init_Legend(){this.prototype.default_view=b,this.mixins([["label_",_.Text],["title_",_.Text],["inactive_",_.Fill],["border_",_.Line],["background_",_.Fill]]),this.define(({Number:t,String:e,Array:i,Tuple:l,Or:s,Ref:n})=>({orientation:[o.Orientation,"vertical"],location:[s(o.LegendLocation,l(t,t)),"top_right"],title:[e],title_standoff:[t,5],label_standoff:[t,5],glyph_height:[t,20],glyph_width:[t,20],label_height:[t,20],label_width:[t,20],margin:[t,10],padding:[t,10],spacing:[t,3],items:[i(n(a.LegendItem)),[]],click_policy:[o.LegendClickPolicy,"none"]})),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})}get_legend_names(){const t=[];for(const e of this.items){const i=e.get_labels_list_from_label_prop();t.push(...i)}return t}}i.Legend=u,u.__name__="Legend",u.init_Legend()},
function _(e,r,n,l,t){l();const i=e(1),s=e(88),o=e(103),_=e(92),a=e(177),u=i.__importStar(e(18)),d=e(19),c=e(9);class f extends s.Model{constructor(e){super(e)}static init_LegendItem(){this.define(({Int:e,Array:r,Ref:n,Nullable:l})=>({label:[u.NullStringSpec,null],renderers:[r(n(o.GlyphRenderer)),[]],index:[l(e),null]}))}_check_data_sources_on_renderers(){if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;const e=this.renderers[0].data_source;if(null!=e)for(const r of this.renderers)if(r.data_source!=e)return!1}return!0}_check_field_label_on_data_source(){const e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;const r=this.renderers[0].data_source;if(null!=r&&!c.includes(r.columns(),e))return!1}return!0}initialize(){super.initialize(),this.legend=null,this.connect(this.change,()=>{var e;return null===(e=this.legend)||void 0===e?void 0:e.item_change.emit()});this._check_data_sources_on_renderers()||d.logger.error("Non matching data sources on legend item renderers");this._check_field_label_on_data_source()||d.logger.error("Bad column name on label: "+this.label)}get_field_from_label_prop(){const{label:e}=this;return a.isField(e)?e.field:null}get_labels_list_from_label_prop(){if(a.isValue(this.label)){const{value:e}=this.label;return null!=e?[e]:[]}const e=this.get_field_from_label_prop();if(null!=e){let r;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if(r=this.renderers[0].data_source,r instanceof _.ColumnarDataSource){const n=r.get_column(e);return null!=n?c.uniq(Array.from(n)):["Invalid field"]}}return[]}}n.LegendItem=f,f.__name__="LegendItem",f.init_LegendItem()},
function _(i,n,e,t,u){t();const c=i(8);e.isValue=function(i){return c.isPlainObject(i)&&"value"in i},e.isField=function(i){return c.isPlainObject(i)&&"field"in i}},
function _(t,e,i,n,s){n();const o=t(1),l=t(35),a=o.__importStar(t(28)),r=t(20),h=t(15);class c extends l.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render()),this.connect(this.model.data_update,()=>this.plot_view.request_render())}_render(){const{xs:t,ys:e}=this.model;if(t.length!=e.length)return;if(t.length<3||e.length<3)return;const{frame:i}=this.plot_view,{ctx:n}=this.layer;for(let s=0,o=t.length;s<o;s++){let o,l;if("screen"!=this.model.xs_units)throw new Error("not implemented");if(o=this.model.screen?t[s]:i.xview.compute(t[s]),"screen"!=this.model.ys_units)throw new Error("not implemented");l=this.model.screen?e[s]:i.yview.compute(e[s]),0==s?(n.beginPath(),n.moveTo(o,l)):n.lineTo(o,l)}n.closePath(),this.visuals.line.doit&&(this.visuals.line.set_value(n),n.stroke()),this.visuals.fill.doit&&(this.visuals.fill.set_value(n),n.fill())}}i.PolyAnnotationView=c,c.__name__="PolyAnnotationView";class _ extends l.Annotation{constructor(t){super(t)}static init_PolyAnnotation(){this.prototype.default_view=c,this.mixins([a.Line,a.Fill]),this.define(({Number:t,Array:e})=>({xs:[e(t),[]],xs_units:[r.SpatialUnits,"data"],ys:[e(t),[]],ys_units:[r.SpatialUnits,"data"]})),this.internal(({Boolean:t})=>({screen:[t,!1]})),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}initialize(){super.initialize(),this.data_update=new h.Signal0(this,"data_update")}update({xs:t,ys:e}){this.setv({xs:t,ys:e,screen:!0},{silent:!0}),this.data_update.emit()}}i.PolyAnnotation=_,_.__name__="PolyAnnotation",_.init_PolyAnnotation()},
function _(e,t,i,n,o){n();const s=e(1),l=e(35),r=s.__importStar(e(28));class c extends l.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render())}_render(){const{gradient:e,y_intercept:t}=this.model;if(null==e||null==t)return;const{frame:i}=this.plot_view,n=this.coordinates.x_scale,o=this.coordinates.y_scale;let s,l,r,c;if(0==e)s=o.compute(t),l=s,r=i.bbox.left,c=r+i.bbox.width;else{s=i.bbox.top,l=s+i.bbox.height;const a=(o.invert(s)-t)/e,_=(o.invert(l)-t)/e;r=n.compute(a),c=n.compute(_)}const{ctx:a}=this.layer;a.save(),a.beginPath(),this.visuals.line.set_value(a),a.moveTo(r,s),a.lineTo(c,l),a.stroke(),a.restore()}}i.SlopeView=c,c.__name__="SlopeView";class a extends l.Annotation{constructor(e){super(e)}static init_Slope(){this.prototype.default_view=c,this.mixins(r.Line),this.define(({Number:e,Nullable:t})=>({gradient:[t(e),null],y_intercept:[t(e),null]})),this.override({line_color:"black"})}}i.Slope=a,a.__name__="Slope",a.init_Slope()},
function _(e,i,t,n,o){n();const s=e(1),a=e(35),l=s.__importStar(e(28)),r=e(20);class h extends a.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_paint(this))}_render(){const{location:e}=this.model;if(null==e)return;const{frame:i}=this.plot_view,t=this.coordinates.x_scale,n=this.coordinates.y_scale,o=(i,t)=>"data"==this.model.location_units?i.compute(e):this.model.for_hover?e:t.compute(e);let s,a,l,r;"width"==this.model.dimension?(l=o(n,i.yview),a=i.bbox.left,r=i.bbox.width,s=this.model.properties.line_width.value()):(l=i.bbox.top,a=o(t,i.xview),r=this.model.properties.line_width.value(),s=i.bbox.height);const{ctx:h}=this.layer;h.save(),h.beginPath(),this.visuals.line.set_value(h),h.moveTo(a,l),"width"==this.model.dimension?h.lineTo(a+r,l):h.lineTo(a,l+s),h.stroke(),h.restore()}}t.SpanView=h,h.__name__="SpanView";class c extends a.Annotation{constructor(e){super(e)}static init_Span(){this.prototype.default_view=h,this.mixins(l.Line),this.define(({Number:e,Nullable:i})=>({render_mode:[r.RenderMode,"canvas"],location:[i(e),null],location_units:[r.SpatialUnits,"data"],dimension:[r.Dimension,"width"]})),this.internal(({Boolean:e})=>({for_hover:[e,!1]})),this.override({line_color:"black"})}}t.Span=c,c.__name__="Span",c.init_Span()},
function _(t,e,i,l,s){l();const a=t(1),n=t(173),o=t(20),r=t(73),c=a.__importStar(t(28)),h=a.__importStar(t(18));class _ extends n.TextAnnotationView{initialize(){super.initialize(),this.visuals.text=new r.Text(this.model)}_get_location(){const t=this.panel,e=this.model.offset;let i,l;const{bbox:s}=t;switch(t.side){case"above":case"below":switch(this.model.vertical_align){case"top":l=s.top+5;break;case"middle":l=s.vcenter;break;case"bottom":l=s.bottom-5}switch(this.model.align){case"left":i=s.left+e;break;case"center":i=s.hcenter;break;case"right":i=s.right-e}break;case"left":switch(this.model.vertical_align){case"top":i=s.left-5;break;case"middle":i=s.hcenter;break;case"bottom":i=s.right+5}switch(this.model.align){case"left":l=s.bottom-e;break;case"center":l=s.vcenter;break;case"right":l=s.top+e}break;case"right":switch(this.model.vertical_align){case"top":i=s.right-5;break;case"middle":i=s.hcenter;break;case"bottom":i=s.left+5}switch(this.model.align){case"left":l=s.top+e;break;case"center":l=s.vcenter;break;case"right":l=s.bottom-e}}return[i,l]}_render(){const{text:t}=this.model;if(null==t||0==t.length)return;this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;const[e,i]=this._get_location(),l=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,t,e,i,l)}_get_size(){const{text:t}=this.model;if(null==t||0==t.length)return{width:0,height:0};{this.visuals.text.set_value(this.layer.ctx);const{width:e,ascent:i}=this.layer.ctx.measureText(t);return{width:e,height:i*this.visuals.text.text_line_height.value()+10}}}}i.TitleView=_,_.__name__="TitleView";class d extends n.TextAnnotation{constructor(t){super(t)}static init_Title(){this.prototype.default_view=_,this.mixins([["border_",c.Line],["background_",c.Fill]]),this.define(({Number:t,String:e})=>({text:[e],text_font:[h.Font,"helvetica"],text_font_size:[h.StringSpec,"13px"],text_font_style:[o.FontStyle,"bold"],text_color:[h.ColorSpec,"#444444"],text_alpha:[h.NumberSpec,1],text_line_height:[t,1],vertical_align:[o.VerticalAlign,"bottom"],align:[o.TextAlign,"left"],offset:[t,0]})),this.internal(()=>({text_align:[o.TextAlign,"left"],text_baseline:[o.TextBaseline,"bottom"]})),this.override({background_fill_color:null,border_line_color:null})}}i.Title=d,d.__name__="Title",d.init_Title()},
function _(i,e,t,o,l){o();const s=i(35),a=i(183),n=i(123),r=i(71),_=i(86);class h extends s.AnnotationView{constructor(){super(...arguments),this.rotate=!0,this._invalidate_toolbar=!0,this._previous_bbox=new _.BBox}initialize(){super.initialize(),this.el=r.div(),this.plot_view.canvas_view.add_event(this.el)}async lazy_initialize(){await super.lazy_initialize(),this._toolbar_view=await n.build_view(this.model.toolbar,{parent:this}),this.plot_view.visibility_callbacks.push(i=>this._toolbar_view.set_visibility(i))}remove(){this._toolbar_view.remove(),r.remove(this.el),super.remove()}render(){this.model.visible||r.undisplay(this.el),super.render()}_render(){const{bbox:i}=this.panel;this._previous_bbox.equals(i)||(r.position(this.el,i),this._previous_bbox=i),this._invalidate_toolbar&&(this.el.style.position="absolute",this.el.style.overflow="hidden",this._toolbar_view.render(),r.empty(this.el),this.el.appendChild(this._toolbar_view.el),this._invalidate_toolbar=!1),r.display(this.el)}_get_size(){const{tools:i,logo:e}=this.model.toolbar;return{width:30*i.length+(null!=e?25:0),height:30}}}t.ToolbarPanelView=h,h.__name__="ToolbarPanelView";class b extends s.Annotation{constructor(i){super(i)}static init_ToolbarPanel(){this.prototype.default_view=h,this.define(({Ref:i})=>({toolbar:[i(a.Toolbar)]}))}}t.ToolbarPanel=b,b.__name__="ToolbarPanel",b.init_ToolbarPanel()},
function _(t,s,e,i,o){i();const c=t(8),n=t(9),a=t(13),l=t(184),r=t(185),_=t(193),p=t(194);e.Drag=l.Tool,e.Inspection=l.Tool,e.Scroll=l.Tool,e.Tap=l.Tool;const u=t=>{switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null},h=t=>"tap"==t||"pan"==t;class v extends p.ToolbarBase{constructor(t){super(t)}static init_Toolbar(){this.prototype.default_view=p.ToolbarBaseView,this.define(({Or:t,Ref:s,Auto:i,Null:o,Nullable:c})=>({active_drag:[t(s(e.Drag),i,o),"auto"],active_inspect:[t(s(e.Inspection),i,o),"auto"],active_scroll:[t(s(e.Scroll),i,o),"auto"],active_tap:[t(s(e.Tap),i,o),"auto"],active_multi:[c(s(r.GestureTool)),null]}))}connect_signals(){super.connect_signals();const{tools:t,active_drag:s,active_inspect:e,active_scroll:i,active_tap:o,active_multi:c}=this.properties;this.on_change([t,s,e,i,o,c],()=>this._init_tools())}_init_tools(){if(super._init_tools(),"auto"==this.active_inspect);else if(this.active_inspect instanceof _.InspectTool){let t=!1;for(const s of this.inspectors)s!=this.active_inspect?s.active=!1:t=!0;t||(this.active_inspect=null)}else if(c.isArray(this.active_inspect)){const t=n.intersection(this.active_inspect,this.inspectors);t.length!=this.active_inspect.length&&(this.active_inspect=t);for(const t of this.inspectors)n.includes(this.active_inspect,t)||(t.active=!1)}else if(null==this.active_inspect)for(const t of this.inspectors)t.active=!1;const t=t=>{t.active?this._active_change(t):t.active=!0};for(const t of a.values(this.gestures)){t.tools=n.sort_by(t.tools,t=>t.default_order);for(const s of t.tools)this.connect(s.properties.active.change,()=>this._active_change(s))}for(const[s,e]of a.entries(this.gestures)){const i=u(s);if(i){const o=this[i];"auto"==o?0!=e.tools.length&&h(s)&&t(e.tools[0]):null!=o&&(n.includes(this.tools,o)?t(o):this[i]=null)}}}}e.Toolbar=v,v.__name__="Toolbar",v.init_Toolbar()},
function _(t,e,n,s,i){s();const o=t(70),a=t(9),r=t(88);class _ extends o.View{get plot_view(){return this.parent}get plot_model(){return this.parent.model}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>{this.model.active?this.activate():this.deactivate()})}activate(){}deactivate(){}}n.ToolView=_,_.__name__="ToolView";class c extends r.Model{constructor(t){super(t)}static init_Tool(){this.prototype._known_aliases=new Map,this.internal(({Boolean:t})=>({active:[t,!1]}))}get synthetic_renderers(){return[]}_get_dim_tooltip(t,e){switch(e){case"width":return t+" (x-axis)";case"height":return t+" (y-axis)";case"both":return t}}_get_dim_limits([t,e],[n,s],i,o){const r=i.bbox.h_range;let _;"width"==o||"both"==o?(_=[a.min([t,n]),a.max([t,n])],_=[a.max([_[0],r.start]),a.min([_[1],r.end])]):_=[r.start,r.end];const c=i.bbox.v_range;let l;return"height"==o||"both"==o?(l=[a.min([e,s]),a.max([e,s])],l=[a.max([l[0],c.start]),a.min([l[1],c.end])]):l=[c.start,c.end],[_,l]}static register_alias(t,e){this.prototype._known_aliases.set(t,e)}static from_string(t){const e=this.prototype._known_aliases.get(t);if(null!=e)return e();{const e=[...this.prototype._known_aliases.keys()];throw new Error(`unexpected tool name '${t}', possible tools are ${e.join(", ")}`)}}}n.Tool=c,c.__name__="Tool",c.init_Tool()},
function _(e,o,t,s,n){s();const u=e(186),_=e(191);class l extends u.ButtonToolView{}t.GestureToolView=l,l.__name__="GestureToolView";class i extends u.ButtonTool{constructor(e){super(e),this.button_view=_.OnOffButtonView}}t.GestureTool=i,i.__name__="GestureTool"},
function _(t,e,o,i,s){i();const n=t(1),l=n.__importDefault(t(79)),r=t(77),a=t(184),u=t(71),h=t(29),_=t(8),c=t(9),m=t(187),d=n.__importDefault(t(188)),p=n.__importDefault(t(189)),f=n.__importDefault(t(190)),g=t(83);class v extends r.DOMView{initialize(){super.initialize();const t=this.model.menu;if(null!=t){const e=this.parent.model.toolbar_location,o="left"==e||"above"==e,i=this.parent.model.horizontal?"vertical":"horizontal";this._menu=new g.ContextMenu(o?c.reversed(t):t,{orientation:i,prevent_hide:t=>t.target==this.el})}this._hammer=new l.default(this.el,{touchAction:"auto",inputClass:l.default.TouchMouseInput}),this.connect(this.model.change,()=>this.render()),this._hammer.on("tap",t=>{var e;(null===(e=this._menu)||void 0===e?void 0:e.is_open)?this._menu.hide():t.target==this.el&&this._clicked()}),this._hammer.on("press",()=>this._pressed())}remove(){var t;this._hammer.destroy(),null===(t=this._menu)||void 0===t||t.remove(),super.remove()}styles(){return[...super.styles(),d.default,p.default,f.default]}css_classes(){return super.css_classes().concat(m.bk_toolbar_button)}render(){u.empty(this.el);const t=this.model.computed_icon;_.isString(t)&&(h.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip,null!=this._menu&&this.root.el.appendChild(this._menu.el)}_pressed(){var t;const{left:e,top:o,right:i,bottom:s}=this.el.getBoundingClientRect(),n=(()=>{switch(this.parent.model.toolbar_location){case"right":return{right:e,top:o};case"left":return{left:i,top:o};case"above":return{left:e,top:s};case"below":return{left:e,bottom:o}}})();null===(t=this._menu)||void 0===t||t.toggle(n)}}o.ButtonToolButtonView=v,v.__name__="ButtonToolButtonView";class b extends a.ToolView{}o.ButtonToolView=b,b.__name__="ButtonToolView";class B extends a.Tool{constructor(t){super(t)}static init_ButtonTool(){this.internal(({Boolean:t})=>({disabled:[t,!1]}))}get tooltip(){return this.tool_name}get computed_icon(){return this.icon}get menu(){return null}}o.ButtonTool=B,B.__name__="ButtonTool",B.init_ButtonTool()},
function _(o,b,t,a,n){a(),t.bk_toolbar="bk-toolbar",t.bk_toolbar_hidden="bk-toolbar-hidden",t.bk_toolbar_button="bk-toolbar-button",t.bk_button_bar="bk-button-bar",t.bk_toolbar_button_custom_action="bk-toolbar-button-custom-action"},
function _(o,b,t,n,r){n();t.default='\n.bk-root .bk-toolbar-hidden {\n  visibility: hidden;\n  opacity: 0;\n  transition: visibility 0.3s linear, opacity 0.3s linear;\n}\n.bk-root .bk-toolbar,\n.bk-root .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-toolbar .bk-logo {\n  flex-shrink: 0;\n  -webkit-flex-shrink: 0;\n}\n.bk-root .bk-toolbar.bk-above,\n.bk-root .bk-toolbar.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n  justify-content: flex-end;\n  -webkit-justify-content: flex-end;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar,\n.bk-root .bk-toolbar.bk-below .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-toolbar.bk-above .bk-logo,\n.bk-root .bk-toolbar.bk-below .bk-logo {\n  order: 1;\n  -webkit-order: 1;\n  margin-left: 5px;\n  margin-right: 0px;\n}\n.bk-root .bk-toolbar.bk-left,\n.bk-root .bk-toolbar.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  justify-content: flex-start;\n  -webkit-justify-content: flex-start;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar,\n.bk-root .bk-toolbar.bk-right .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-toolbar.bk-left .bk-logo,\n.bk-root .bk-toolbar.bk-right .bk-logo {\n  order: 0;\n  -webkit-order: 0;\n  margin-bottom: 5px;\n  margin-top: 0px;\n}\n.bk-root .bk-toolbar-button {\n  width: 30px;\n  height: 30px;\n  cursor: pointer;\n  background-size: 60% 60%;\n  background-origin: border-box;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-toolbar-button:hover {\n  background-color: rgba(192, 192, 192, 0.15);\n}\n.bk-root .bk-toolbar-button:focus {\n  outline: none;\n}\n.bk-root .bk-toolbar-button::-moz-focus-inner {\n  border: 0;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button {\n  border-bottom: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button.bk-active {\n  border-bottom-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button {\n  border-top: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button.bk-active {\n  border-top-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button {\n  border-left: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button.bk-active {\n  border-left-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button {\n  border-right: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button.bk-active {\n  border-right-color: #26aae1;\n}\n.bk-root .bk-button-bar + .bk-button-bar:before {\n  content: " ";\n  display: inline-block;\n  background-color: lightgray;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-below .bk-button-bar + .bk-button-bar:before {\n  height: 10px;\n  width: 1px;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-right .bk-button-bar + .bk-button-bar:before {\n  height: 1px;\n  width: 10px;\n}\n'},
function _(A,g,C,B,w){B();C.default='\n.bk-root .bk-tool-icon-copy-to-clipboard {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-replace-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-append-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-intersect-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-subtract-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-clear-selection {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-box-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-box-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-zoom-in {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-zoom-out {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-help {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-hover {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-crosshair {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-lasso-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-pan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-xpan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-ypan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-range {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-polygon-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-redo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-reset {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-save {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-tap-select {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-undo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-wheel-pan {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-wheel-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-box-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-freehand-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-point-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-line-edit {\n  background-image: url("data:image/png;base64,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");\n}\n'},
function _(n,o,r,t,e){t();r.default="\n.bk-root .bk-menu-icon {\n  width: 28px;\n  height: 28px;\n  background-size: 60%;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-context-menu {\n  position: absolute;\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  width: auto;\n  height: auto;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-context-menu.bk-horizontal {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-context-menu.bk-vertical {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-context-menu > .bk-divider {\n  cursor: default;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-context-menu.bk-horizontal > .bk-divider {\n  width: 1px;\n  margin: 5px 0;\n}\n.bk-root .bk-context-menu.bk-vertical > .bk-divider {\n  height: 1px;\n  margin: 0 5px;\n}\n.bk-root .bk-context-menu > :not(.bk-divider) {\n  border: 1px solid transparent;\n}\n.bk-root .bk-context-menu > :not(.bk-divider).bk-active {\n  border-color: #26aae1;\n}\n.bk-root .bk-context-menu > :not(.bk-divider):hover {\n  background-color: #f9f9f9;\n}\n.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child {\n  border-top-left-radius: 4px;\n  border-bottom-left-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child {\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child {\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child {\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n.bk-root .bk-menu {\n  position: absolute;\n  left: 0;\n  width: 100%;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-menu.bk-above {\n  bottom: 100%;\n}\n.bk-root .bk-menu.bk-below {\n  top: 100%;\n}\n.bk-root .bk-menu > .bk-divider {\n  height: 1px;\n  margin: 7.5px 0;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-menu > :not(.bk-divider) {\n  padding: 6px 12px;\n}\n.bk-root .bk-menu > :not(.bk-divider):hover,\n.bk-root .bk-menu > :not(.bk-divider).bk-active {\n  background-color: #e6e6e6;\n}\n.bk-root .bk-caret {\n  display: inline-block;\n  vertical-align: middle;\n  width: 0;\n  height: 0;\n  margin: 0 5px;\n}\n.bk-root .bk-caret.bk-down {\n  border-top: 4px solid;\n}\n.bk-root .bk-caret.bk-up {\n  border-bottom: 4px solid;\n}\n.bk-root .bk-caret.bk-down,\n.bk-root .bk-caret.bk-up {\n  border-right: 4px solid transparent;\n  border-left: 4px solid transparent;\n}\n.bk-root .bk-caret.bk-left {\n  border-right: 4px solid;\n}\n.bk-root .bk-caret.bk-right {\n  border-left: 4px solid;\n}\n.bk-root .bk-caret.bk-left,\n.bk-root .bk-caret.bk-right {\n  border-top: 4px solid transparent;\n  border-bottom: 4px solid transparent;\n}\n"},
function _(e,t,n,i,o){i();const s=e(186),c=e(192),l=e(71);class a extends s.ButtonToolButtonView{render(){super.render(),l.classes(this.el).toggle(c.bk_active,this.model.active)}_clicked(){const{active:e}=this.model;this.model.active=!e}}n.OnOffButtonView=a,a.__name__="OnOffButtonView"},
function _(b,e,k,t,i){t(),k.bk_active="bk-active",k.bk_inline="bk-inline",k.bk_left="bk-left",k.bk_right="bk-right",k.bk_above="bk-above",k.bk_below="bk-below",k.bk_up="bk-up",k.bk_down="bk-down",k.bk_side=function(b){switch(b){case"above":return k.bk_above;case"below":return k.bk_below;case"left":return k.bk_left;case"right":return k.bk_right}}},
function _(t,e,o,n,s){n();const i=t(186),c=t(191);class l extends i.ButtonToolView{}o.InspectToolView=l,l.__name__="InspectToolView";class _ extends i.ButtonTool{constructor(t){super(t),this.event_type="move"}static init_InspectTool(){this.prototype.button_view=c.OnOffButtonView,this.define(({Boolean:t})=>({toggleable:[t,!0]})),this.override({active:!0})}}o.InspectTool=_,_.__name__="InspectTool",_.init_InspectTool()},
function _(t,o,e,i,l){i();const s=t(1),n=t(19),a=t(71),r=t(123),_=t(77),c=t(20),h=t(9),u=t(13),v=t(8),d=t(88),p=t(184),b=t(185),g=t(195),f=t(196),m=t(193),w=t(187),y=t(198),T=t(192),k=s.__importDefault(t(188)),z=s.__importDefault(t(199));class B extends d.Model{constructor(t){super(t)}static init_ToolbarViewModel(){this.define(({Boolean:t,Nullable:o})=>({_visible:[o(t),null],autohide:[t,!1]}))}get visible(){return!this.autohide||null!=this._visible&&this._visible}}e.ToolbarViewModel=B,B.__name__="ToolbarViewModel",B.init_ToolbarViewModel();class M extends _.DOMView{initialize(){super.initialize(),this._tool_button_views=new Map,this._toolbar_view_model=new B({autohide:this.model.autohide})}async lazy_initialize(){await super.lazy_initialize(),await this._build_tool_button_views()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.tools.change,async()=>{await this._build_tool_button_views(),this.render()}),this.connect(this.model.properties.autohide.change,()=>{this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change()}),this.connect(this._toolbar_view_model.properties._visible.change,()=>this._on_visible_change())}styles(){return[...super.styles(),k.default,z.default]}remove(){r.remove_views(this._tool_button_views),super.remove()}async _build_tool_button_views(){const t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools;await r.build_views(this._tool_button_views,t,{parent:this},t=>t.button_view)}set_visibility(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)}_on_visible_change(){const t=this._toolbar_view_model.visible,o=w.bk_toolbar_hidden;this.el.classList.contains(o)&&t?this.el.classList.remove(o):t||this.el.classList.add(o)}render(){if(a.empty(this.el),this.el.classList.add(w.bk_toolbar),this.el.classList.add(T.bk_side(this.model.toolbar_location)),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){const t="grey"===this.model.logo?y.bk_grey:null,o=a.a({href:"https://bokeh.org/",target:"_blank",class:[y.bk_logo,y.bk_logo_small,t]});this.el.appendChild(o)}for(const[,t]of this._tool_button_views)t.render();const t=[],o=t=>this._tool_button_views.get(t).el,{gestures:e}=this.model;for(const i of u.values(e))t.push(i.tools.map(o));t.push(this.model.actions.map(o)),t.push(this.model.inspectors.filter(t=>t.toggleable).map(o));for(const o of t)if(0!==o.length){const t=a.div({class:w.bk_button_bar},o);this.el.appendChild(t)}}update_layout(){}update_position(){}after_layout(){this._has_finished=!0}}function L(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}e.ToolbarBaseView=M,M.__name__="ToolbarBaseView";class V extends d.Model{constructor(t){super(t)}static init_ToolbarBase(){this.prototype.default_view=M,this.define(({Boolean:t,Array:o,Ref:e})=>({tools:[o(e(p.Tool)),[]],logo:[c.Logo,"normal"],autohide:[t,!1]})),this.internal(({Array:t,Struct:o,Ref:e,Nullable:i})=>{const l=o({tools:t(e(b.GestureTool)),active:i(e(p.Tool))});return{gestures:[o({pan:l,scroll:l,pinch:l,tap:l,doubletap:l,press:l,pressup:l,rotate:l,move:l,multi:l}),L],actions:[t(e(g.ActionTool)),[]],inspectors:[t(e(m.InspectTool)),[]],help:[t(e(f.HelpTool)),[]],toolbar_location:[c.Location,"right"]}})}initialize(){super.initialize(),this._init_tools()}_init_tools(){const t=function(t,o){if(t.length!=o.length)return!0;const e=new Set(o.map(t=>t.id));return h.some(t,t=>!e.has(t.id))},o=this.tools.filter(t=>t instanceof m.InspectTool);t(this.inspectors,o)&&(this.inspectors=o);const e=this.tools.filter(t=>t instanceof f.HelpTool);t(this.help,e)&&(this.help=e);const i=this.tools.filter(t=>t instanceof g.ActionTool);t(this.actions,i)&&(this.actions=i);const l=(t,o)=>{t in this.gestures||n.logger.warn(`Toolbar: unknown event type '${t}' for tool: ${o}`)},s={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};for(const t of this.tools)if(t instanceof b.GestureTool&&t.event_type)if(v.isString(t.event_type))s[t.event_type].tools.push(t),l(t.event_type,t);else{s.multi.tools.push(t);for(const o of t.event_type)l(o,t)}for(const o of Object.keys(s)){const e=this.gestures[o];t(e.tools,s[o].tools)&&(e.tools=s[o].tools),e.active&&h.every(e.tools,t=>t.id!=e.active.id)&&(e.active=null)}}get horizontal(){return"above"===this.toolbar_location||"below"===this.toolbar_location}get vertical(){return"left"===this.toolbar_location||"right"===this.toolbar_location}_active_change(t){const{event_type:o}=t;if(null==o)return;const e=v.isString(o)?[o]:o;for(const o of e)if(t.active){const e=this.gestures[o].active;null!=e&&t!=e&&(n.logger.debug(`Toolbar: deactivating tool: ${e} for event type '${o}'`),e.active=!1),this.gestures[o].active=t,n.logger.debug(`Toolbar: activating tool: ${t} for event type '${o}'`)}else this.gestures[o].active=null}}e.ToolbarBase=V,V.__name__="ToolbarBase",V.init_ToolbarBase()},
function _(o,t,n,i,e){i();const s=o(186),c=o(15);class l extends s.ButtonToolButtonView{_clicked(){this.model.do.emit(void 0)}}n.ActionToolButtonView=l,l.__name__="ActionToolButtonView";class _ extends s.ButtonToolView{connect_signals(){super.connect_signals(),this.connect(this.model.do,o=>this.doit(o))}}n.ActionToolView=_,_.__name__="ActionToolView";class d extends s.ButtonTool{constructor(o){super(o),this.button_view=l,this.do=new c.Signal(this,"do")}}n.ActionTool=d,d.__name__="ActionTool"},
function _(o,t,e,l,i){l();const s=o(195),n=o(197);class p extends s.ActionToolView{doit(){window.open(this.model.redirect)}}e.HelpToolView=p,p.__name__="HelpToolView";class _ extends s.ActionTool{constructor(o){super(o),this.tool_name="Help",this.icon=n.bk_tool_icon_help}static init_HelpTool(){this.prototype.default_view=p,this.define(({String:o})=>({help_tooltip:[o,"Click the question mark to learn more about Bokeh plot tools."],redirect:[o,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]})),this.register_alias("help",()=>new _)}get tooltip(){return this.help_tooltip}}e.HelpTool=_,_.__name__="HelpTool",_.init_HelpTool()},
function _(o,_,l,n,t){n(),l.bk_tool_icon_box_select="bk-tool-icon-box-select",l.bk_tool_icon_box_zoom="bk-tool-icon-box-zoom",l.bk_tool_icon_zoom_in="bk-tool-icon-zoom-in",l.bk_tool_icon_zoom_out="bk-tool-icon-zoom-out",l.bk_tool_icon_help="bk-tool-icon-help",l.bk_tool_icon_hover="bk-tool-icon-hover",l.bk_tool_icon_crosshair="bk-tool-icon-crosshair",l.bk_tool_icon_lasso_select="bk-tool-icon-lasso-select",l.bk_tool_icon_pan="bk-tool-icon-pan",l.bk_tool_icon_xpan="bk-tool-icon-xpan",l.bk_tool_icon_ypan="bk-tool-icon-ypan",l.bk_tool_icon_range="bk-tool-icon-range",l.bk_tool_icon_polygon_select="bk-tool-icon-polygon-select",l.bk_tool_icon_redo="bk-tool-icon-redo",l.bk_tool_icon_reset="bk-tool-icon-reset",l.bk_tool_icon_save="bk-tool-icon-save",l.bk_tool_icon_tap_select="bk-tool-icon-tap-select",l.bk_tool_icon_undo="bk-tool-icon-undo",l.bk_tool_icon_wheel_pan="bk-tool-icon-wheel-pan",l.bk_tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",l.bk_tool_icon_box_edit="bk-tool-icon-box-edit",l.bk_tool_icon_freehand_draw="bk-tool-icon-freehand-draw",l.bk_tool_icon_poly_draw="bk-tool-icon-poly-draw",l.bk_tool_icon_point_draw="bk-tool-icon-point-draw",l.bk_tool_icon_poly_edit="bk-tool-icon-poly-edit",l.bk_tool_icon_line_edit="bk-tool-icon-line-edit"},
function _(o,b,k,l,g){l(),k.bk_logo="bk-logo",k.bk_logo_notebook="bk-logo-notebook",k.bk_logo_small="bk-logo-small",k.bk_grey="bk-grey"},
function _(l,n,o,A,g){A();o.default="\n.bk-root .bk-logo {\n  margin: 5px;\n  position: relative;\n  display: block;\n  background-repeat: no-repeat;\n}\n.bk-root .bk-logo.bk-grey {\n  filter: url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\");\n  /* Firefox 10+, Firefox on Android */\n  filter: gray;\n  /* IE6-9 */\n  -webkit-filter: grayscale(100%);\n  /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n.bk-root .bk-logo-small {\n  width: 20px;\n  height: 20px;\n  background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);\n}\n.bk-root .bk-logo-notebook {\n  display: inline-block;\n  vertical-align: middle;\n  margin-right: 5px;\n}\n"},
function _(t,e,i,s,l){s();const o=t(1),n=t(35),h=t(20),a=t(71),r=t(201),c=t(192),d=o.__importDefault(t(202));class p extends n.AnnotationView{initialize(){super.initialize(),this.el=a.div({class:r.bk_tooltip}),a.undisplay(this.el),this.plot_view.canvas_view.add_overlay(this.el)}remove(){a.remove(this.el),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.content.change,()=>this.render()),this.connect(this.model.properties.position.change,()=>this._reposition())}styles(){return[...super.styles(),d.default]}render(){this.model.visible||a.undisplay(this.el),super.render()}_render(){const{content:t}=this.model;null!=t?(a.empty(this.el),a.classes(this.el).toggle(r.bk_tooltip_custom,this.model.custom),this.el.appendChild(t),this.model.show_arrow&&this.el.classList.add(r.bk_tooltip_arrow)):a.undisplay(this.el)}_reposition(){const{position:t}=this.model;if(null==t)return void a.undisplay(this.el);const[e,i]=t,s=(()=>{const t=this.parent.layout.bbox.relative(),{attachment:s}=this.model;switch(s){case"horizontal":return e<t.hcenter?"right":"left";case"vertical":return i<t.vcenter?"below":"above";default:return s}})();let l;this.el.classList.remove(c.bk_right),this.el.classList.remove(c.bk_left),this.el.classList.remove(c.bk_above),this.el.classList.remove(c.bk_below),a.display(this.el);let o=null,n=null;switch(s){case"right":this.el.classList.add(c.bk_left),o=e+(this.el.offsetWidth-this.el.clientWidth)+10,l=i-this.el.offsetHeight/2;break;case"left":this.el.classList.add(c.bk_right),n=this.plot_view.layout.bbox.width-e+10,l=i-this.el.offsetHeight/2;break;case"below":this.el.classList.add(c.bk_above),l=i+(this.el.offsetHeight-this.el.clientHeight)+10,o=Math.round(e-this.el.offsetWidth/2);break;case"above":this.el.classList.add(c.bk_below),l=i-this.el.offsetHeight-10,o=Math.round(e-this.el.offsetWidth/2)}this.el.style.top=l+"px",this.el.style.left=null!=o?o+"px":"auto",this.el.style.right=null!=n?n+"px":"auto"}}i.TooltipView=p,p.__name__="TooltipView";class u extends n.Annotation{constructor(t){super(t)}static init_Tooltip(){this.prototype.default_view=p,this.define(({Boolean:t})=>({attachment:[h.TooltipAttachment,"horizontal"],inner_only:[t,!0],show_arrow:[t,!0]})),this.internal(({Boolean:t,Number:e,Tuple:i,Ref:s,Nullable:l})=>({position:[l(i(e,e)),null],content:[s(HTMLElement),()=>a.div()],custom:[t]})),this.override({level:"overlay"})}clear(){this.position=null}}i.Tooltip=u,u.__name__="Tooltip",u.init_Tooltip()},
function _(o,t,l,b,_){b(),l.bk_tooltip="bk-tooltip",l.bk_tooltip_arrow="bk-tooltip-arrow",l.bk_tooltip_custom="bk-tooltip-custom",l.bk_tooltip_row_label="bk-tooltip-row-label",l.bk_tooltip_row_value="bk-tooltip-row-value",l.bk_tooltip_color_block="bk-tooltip-color-block"},
function _(o,n,t,r,e){r();t.default='\n.bk-root {\n  /* Same border color used everywhere */\n  /* Gray of icons */\n}\n.bk-root .bk-tooltip {\n  font-weight: 300;\n  font-size: 12px;\n  position: absolute;\n  padding: 5px;\n  border: 1px solid #e5e5e5;\n  color: #2f2f2f;\n  background-color: white;\n  pointer-events: none;\n  opacity: 0.95;\n  z-index: 100;\n}\n.bk-root .bk-tooltip > div:not(:first-child) {\n  /* gives space when multiple elements are being hovered over */\n  margin-top: 5px;\n  border-top: #e5e5e5 1px dashed;\n}\n.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-left::before {\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right::after {\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-above::before {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  top: -10px;\n  border-bottom-width: 10px;\n  border-bottom-color: #909599;\n}\n.bk-root .bk-tooltip.bk-below::after {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  bottom: -10px;\n  border-top-width: 10px;\n  border-top-color: #909599;\n}\n.bk-root .bk-tooltip-row-label {\n  text-align: right;\n  color: #26aae1;\n  /* blue from toolbar highlighting */\n}\n.bk-root .bk-tooltip-row-value {\n  color: default;\n  /* seems to be necessary for notebook */\n}\n.bk-root .bk-tooltip-color-block {\n  width: 12px;\n  height: 12px;\n  margin-left: 5px;\n  margin-right: 5px;\n  outline: #dddddd solid 1px;\n  display: inline-block;\n}\n'},
function _(e,t,s,i,r){i();const h=e(135),a=e(91),o=e(123),l=e(28);class n extends h.UpperLowerView{async lazy_initialize(){await super.lazy_initialize();const{lower_head:e,upper_head:t}=this.model,{parent:s}=this;null!=e&&(this.lower_head=await o.build_view(e,{parent:s})),null!=t&&(this.upper_head=await o.build_view(t,{parent:s}))}connect_signals(){super.connect_signals(),this.connect(this.model.source.streaming,()=>this.set_data(this.model.source)),this.connect(this.model.source.patching,()=>this.set_data(this.model.source)),this.connect(this.model.source.change,()=>this.set_data(this.model.source))}_render(){this._map_data();const{ctx:e}=this.layer;if(this.visuals.line.doit)for(let t=0,s=this._lower_sx.length;t<s;t++)this.visuals.line.set_vectorize(e,t),e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),e.stroke();const t="height"==this.model.dimension?0:Math.PI/2;if(null!=this.lower_head)for(let s=0,i=this._lower_sx.length;s<i;s++)e.save(),e.translate(this._lower_sx[s],this._lower_sy[s]),e.rotate(t+Math.PI),this.lower_head.render(e,s),e.restore();if(null!=this.upper_head)for(let s=0,i=this._upper_sx.length;s<i;s++)e.save(),e.translate(this._upper_sx[s],this._upper_sy[s]),e.rotate(t),this.upper_head.render(e,s),e.restore()}}s.WhiskerView=n,n.__name__="WhiskerView";class _ extends h.UpperLower{constructor(e){super(e)}static init_Whisker(){this.prototype.default_view=n,this.mixins(l.LineVector),this.define(({Ref:e,Nullable:t})=>({lower_head:[t(e(a.ArrowHead)),()=>new a.TeeHead({size:10})],upper_head:[t(e(a.ArrowHead)),()=>new a.TeeHead({size:10})]})),this.override({level:"underlay"})}}s.Whisker=_,_.__name__="Whisker",_.init_Whisker()},
function _(i,s,x,A,o){A(),o("Axis",i(205).Axis),o("CategoricalAxis",i(207).CategoricalAxis),o("ContinuousAxis",i(210).ContinuousAxis),o("DatetimeAxis",i(211).DatetimeAxis),o("LinearAxis",i(212).LinearAxis),o("LogAxis",i(225).LogAxis),o("MercatorAxis",i(228).MercatorAxis)},
function _(t,e,i,s,a){s();const l=t(1),o=t(206),n=t(139),r=t(140),_=l.__importStar(t(28)),h=t(20),c=t(9),d=t(8),m=t(100),{abs:b,min:u,max:x}=Math;class f extends o.GuideRendererView{constructor(){super(...arguments),this.rotate=!0}get panel(){return this.layout}get is_renderable(){const[t,e]=this.ranges;return t.is_valid&&e.is_valid}_render(){var t;if(!this.is_renderable)return;const e={tick:this._tick_extent(),tick_label:this._tick_label_extents(),axis_label:this._axis_label_extent()},{tick_coords:i}=this,s=this.layer.ctx;s.save(),this._draw_rule(s,e),this._draw_major_ticks(s,e,i),this._draw_minor_ticks(s,e,i),this._draw_major_labels(s,e,i),this._draw_axis_label(s,e,i),null===(t=this._paint)||void 0===t||t.call(this,s,e,i),s.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_layout())}get_size(){if(this.model.visible&&null==this.model.fixed_location&&this.is_renderable){const t=this._get_size();return{width:0,height:Math.round(t)}}return{width:0,height:0}}_get_size(){return this._tick_extent()+this._tick_label_extent()+this._axis_label_extent()}get needs_clip(){return null!=this.model.fixed_location}_draw_rule(t,e){if(!this.visuals.axis_line.doit)return;const[i,s]=this.rule_coords,[a,l]=this.coordinates.map_to_screen(i,s),[o,n]=this.normals,[r,_]=this.offsets;this.visuals.axis_line.set_value(t),t.beginPath(),t.moveTo(Math.round(a[0]+o*r),Math.round(l[0]+n*_));for(let e=1;e<a.length;e++){const i=Math.round(a[e]+o*r),s=Math.round(l[e]+n*_);t.lineTo(i,s)}t.stroke()}_draw_major_ticks(t,e,i){const s=this.model.major_tick_in,a=this.model.major_tick_out,l=this.visuals.major_tick_line;this._draw_ticks(t,i.major,s,a,l)}_draw_minor_ticks(t,e,i){const s=this.model.minor_tick_in,a=this.model.minor_tick_out,l=this.visuals.minor_tick_line;this._draw_ticks(t,i.minor,s,a,l)}_draw_major_labels(t,e,i){const s=i.major,a=this.compute_labels(s[this.dimension]),l=this.model.major_label_orientation,o=e.tick+this.model.major_label_standoff,n=this.visuals.major_label_text;this._draw_oriented_labels(t,a,s,l,this.panel.side,o,n)}_draw_axis_label(t,e,i){if(null==this.model.axis_label||0==this.model.axis_label.length||null!=this.model.fixed_location)return;let s,a;const{bbox:l}=this.panel;switch(this.panel.side){case"above":s=l.hcenter,a=l.bottom;break;case"below":s=l.hcenter,a=l.top;break;case"left":s=l.right,a=l.vcenter;break;case"right":s=l.left,a=l.vcenter;break;default:throw new Error("unknown side: "+this.panel.side)}const o=[[s],[a]],n=e.tick+c.sum(e.tick_label)+this.model.axis_label_standoff,r=this.visuals.axis_label_text;this._draw_oriented_labels(t,[this.model.axis_label],o,"parallel",this.panel.side,n,r,"screen")}_draw_ticks(t,e,i,s,a){if(!a.doit)return;const[l,o]=e,[n,r]=this.coordinates.map_to_screen(l,o),[_,h]=this.normals,[c,d]=this.offsets,[m,b]=[_*(c-i),h*(d-i)],[u,x]=[_*(c+s),h*(d+s)];a.set_value(t),t.beginPath();for(let e=0;e<n.length;e++){const i=Math.round(n[e]+u),s=Math.round(r[e]+x),a=Math.round(n[e]+m),l=Math.round(r[e]+b);t.moveTo(i,s),t.lineTo(a,l)}t.stroke()}_draw_oriented_labels(t,e,i,s,a,l,o,n="data"){if(!o.doit||0==e.length)return;let r,_,h,c;if("screen"==n)[r,_]=i,[h,c]=[0,0];else{const[t,e]=i;[r,_]=this.coordinates.map_to_screen(t,e),[h,c]=this.offsets}const[m,b]=this.normals,u=m*(h+l),x=b*(c+l);let f;o.set_value(t),this.panel.apply_label_text_heuristics(t,s),f=d.isString(s)?this.panel.get_label_angle_heuristic(s):-s;for(let i=0;i<r.length;i++){const s=Math.round(r[i]+u),a=Math.round(_[i]+x);t.translate(s,a),t.rotate(f),t.fillText(e[i],0,0),t.rotate(-f),t.translate(-s,-a)}}_axis_label_extent(){if(null==this.model.axis_label||""==this.model.axis_label)return 0;const t=this.model.axis_label_standoff,e=this.visuals.axis_label_text;return this._oriented_labels_extent([this.model.axis_label],"parallel",this.panel.side,t,e)}_tick_extent(){return this.model.major_tick_out}_tick_label_extent(){return c.sum(this._tick_label_extents())}_tick_label_extents(){const t=this.tick_coords.major,e=this.compute_labels(t[this.dimension]),i=this.model.major_label_orientation,s=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(e,i,this.panel.side,s,a)]}_oriented_labels_extent(t,e,i,s,a){if(0==t.length)return 0;const l=this.layer.ctx;let o;a.set_value(l),o=d.isString(e)?this.panel.get_label_angle_heuristic(e):-e,o=Math.abs(o);const n=Math.cos(o),r=Math.sin(o);let _=0;for(let e=0;e<t.length;e++){const s=1.1*l.measureText(t[e]).width,a=.9*l.measureText(t[e]).ascent;let o;o="above"==i||"below"==i?s*r+a*n:s*n+a*r,o>_&&(_=o)}return _>0&&(_+=s),_}get normals(){return this.panel.normals}get dimension(){return this.panel.dimension}compute_labels(t){const e=this.model.formatter.doFormat(t,this);for(let i=0;i<t.length;i++)t[i]in this.model.major_label_overrides&&(e[i]=this.model.major_label_overrides[t[i]]);return e}get offsets(){if(null!=this.model.fixed_location)return[0,0];const{frame:t}=this.plot_view;let[e,i]=[0,0];switch(this.panel.side){case"below":i=b(this.panel.bbox.top-t.bbox.bottom);break;case"above":i=b(this.panel.bbox.bottom-t.bbox.top);break;case"right":e=b(this.panel.bbox.left-t.bbox.right);break;case"left":e=b(this.panel.bbox.right-t.bbox.left)}return[e,i]}get ranges(){const t=this.dimension,e=(t+1)%2,{ranges:i}=this.coordinates;return[i[t],i[e]]}get computed_bounds(){const[t]=this.ranges,e=this.model.bounds,i=[t.min,t.max];if("auto"==e)return[t.min,t.max];{let t,s;const[a,l]=e,[o,n]=i;return b(a-l)>b(o-n)?(t=x(u(a,l),o),s=u(x(a,l),n)):(t=u(a,l),s=x(a,l)),[t,s]}}get rule_coords(){const t=this.dimension,e=(t+1)%2,[i]=this.ranges,[s,a]=this.computed_bounds,l=[new Array(2),new Array(2)];return l[t][0]=Math.max(s,i.min),l[t][1]=Math.min(a,i.max),l[t][0]>l[t][1]&&(l[t][0]=l[t][1]=NaN),l[e][0]=this.loc,l[e][1]=this.loc,l}get tick_coords(){const t=this.dimension,e=(t+1)%2,[i]=this.ranges,[s,a]=this.computed_bounds,l=this.model.ticker.get_ticks(s,a,i,this.loc),o=l.major,n=l.minor,r=[[],[]],_=[[],[]],[h,c]=[i.min,i.max];for(let i=0;i<o.length;i++)o[i]<h||o[i]>c||(r[t].push(o[i]),r[e].push(this.loc));for(let i=0;i<n.length;i++)n[i]<h||n[i]>c||(_[t].push(n[i]),_[e].push(this.loc));return{major:r,minor:_}}get loc(){const{fixed_location:t}=this.model;if(null!=t){if(d.isNumber(t))return t;const[,e]=this.ranges;if(e instanceof m.FactorRange)return e.synthetic(t);throw new Error("unexpected")}const[,e]=this.ranges;switch(this.panel.side){case"left":case"below":return e.start;case"right":case"above":return e.end}}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box})}}i.AxisView=f,f.__name__="AxisView";class g extends o.GuideRenderer{constructor(t){super(t)}static init_Axis(){this.prototype.default_view=f,this.mixins([["axis_",_.Line],["major_tick_",_.Line],["minor_tick_",_.Line],["major_label_",_.Text],["axis_label_",_.Text]]),this.define(({Any:t,Int:e,Number:i,String:s,Ref:a,Dict:l,Tuple:o,Or:_,Nullable:c,Auto:d})=>({bounds:[_(o(i,i),d),"auto"],ticker:[a(n.Ticker)],formatter:[a(r.TickFormatter)],axis_label:[c(s),""],axis_label_standoff:[e,5],major_label_standoff:[e,5],major_label_orientation:[_(h.TickLabelOrientation,i),"horizontal"],major_label_overrides:[l(s),{}],major_tick_in:[i,2],major_tick_out:[i,6],minor_tick_in:[i,0],minor_tick_out:[i,4],fixed_location:[c(_(i,t)),null]})),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic"})}}i.Axis=g,g.__name__="Axis",g.init_Axis()},
function _(e,r,d,i,n){i();const s=e(69);class t extends s.RendererView{}d.GuideRendererView=t,t.__name__="GuideRendererView";class _ extends s.Renderer{constructor(e){super(e)}static init_GuideRenderer(){this.override({level:"guide"})}}d.GuideRenderer=_,_.__name__="GuideRenderer",_.init_GuideRenderer()},
function _(t,s,o,e,i){e();const a=t(1),r=t(205),l=t(208),_=t(209),n=a.__importStar(t(28)),h=t(20);class c extends r.AxisView{_paint(t,s,o){this._draw_group_separators(t,s,o)}_draw_group_separators(t,s,o){const[e]=this.ranges,[i,a]=this.computed_bounds;if(!e.tops||e.tops.length<2||!this.visuals.separator_line.doit)return;const r=this.dimension,l=(r+1)%2,_=[[],[]];let n=0;for(let t=0;t<e.tops.length-1;t++){let s,o;for(let i=n;i<e.factors.length;i++)if(e.factors[i][0]==e.tops[t+1]){[s,o]=[e.factors[i-1],e.factors[i]],n=i;break}const h=(e.synthetic(s)+e.synthetic(o))/2;h>i&&h<a&&(_[r].push(h),_[l].push(this.loc))}const h=this._tick_label_extent();this._draw_ticks(t,_,-3,h-6,this.visuals.separator_line)}_draw_major_labels(t,s,o){const e=this._get_factor_info();let i=s.tick+this.model.major_label_standoff;for(let o=0;o<e.length;o++){const[a,r,l,_]=e[o];this._draw_oriented_labels(t,a,r,l,this.panel.side,i,_),i+=s.tick_label[o]}}_tick_label_extents(){const t=this._get_factor_info(),s=[];for(const[o,,e,i]of t){const t=this._oriented_labels_extent(o,e,this.panel.side,this.model.major_label_standoff,i);s.push(t)}return s}_get_factor_info(){const[t]=this.ranges,[s,o]=this.computed_bounds,e=this.loc,i=this.model.ticker.get_ticks(s,o,t,e),a=this.tick_coords,r=[];if(1==t.levels){const t=i.major,s=this.model.formatter.doFormat(t,this);r.push([s,a.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){const t=i.major.map(t=>t[1]),s=this.model.formatter.doFormat(t,this);r.push([s,a.major,this.model.major_label_orientation,this.visuals.major_label_text]),r.push([i.tops,a.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){const t=i.major.map(t=>t[2]),s=this.model.formatter.doFormat(t,this),o=i.mids.map(t=>t[1]);r.push([s,a.major,this.model.major_label_orientation,this.visuals.major_label_text]),r.push([o,a.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),r.push([i.tops,a.tops,this.model.group_label_orientation,this.visuals.group_text])}return r}get tick_coords(){const t=this.dimension,s=(t+1)%2,[o]=this.ranges,[e,i]=this.computed_bounds,a=this.model.ticker.get_ticks(e,i,o,this.loc),r={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return r.major[t]=a.major,r.major[s]=a.major.map(()=>this.loc),3==o.levels&&(r.mids[t]=a.mids,r.mids[s]=a.mids.map(()=>this.loc)),o.levels>1&&(r.tops[t]=a.tops,r.tops[s]=a.tops.map(()=>this.loc)),r}}o.CategoricalAxisView=c,c.__name__="CategoricalAxisView";class p extends r.Axis{constructor(t){super(t)}static init_CategoricalAxis(){this.prototype.default_view=c,this.mixins([["separator_",n.Line],["group_",n.Text],["subgroup_",n.Text]]),this.define(({Number:t,Or:s})=>({group_label_orientation:[s(h.TickLabelOrientation,t),"parallel"],subgroup_label_orientation:[s(h.TickLabelOrientation,t),"parallel"]})),this.override({ticker:()=>new l.CategoricalTicker,formatter:()=>new _.CategoricalTickFormatter,separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})}}o.CategoricalAxis=p,p.__name__="CategoricalAxis",p.init_CategoricalAxis()},
function _(t,c,o,s,e){s();const r=t(139);class i extends r.Ticker{constructor(t){super(t)}get_ticks(t,c,o,s){var e,r;return{major:this._collect(o.factors,o,t,c),minor:[],tops:this._collect(null!==(e=o.tops)&&void 0!==e?e:[],o,t,c),mids:this._collect(null!==(r=o.mids)&&void 0!==r?r:[],o,t,c)}}_collect(t,c,o,s){const e=[];for(const r of t){const t=c.synthetic(r);t>o&&t<s&&e.push(r)}return e}}o.CategoricalTicker=i,i.__name__="CategoricalTicker"},
function _(t,r,o,c,a){c();const e=t(140),n=t(9);class i extends e.TickFormatter{constructor(t){super(t)}doFormat(t,r){return n.copy(t)}}o.CategoricalTickFormatter=i,i.__name__="CategoricalTickFormatter"},
function _(s,n,i,o,u){o();const e=s(205);class t extends e.AxisView{}i.ContinuousAxisView=t,t.__name__="ContinuousAxisView";class _ extends e.Axis{constructor(s){super(s)}}i.ContinuousAxis=_,_.__name__="ContinuousAxis"},
function _(e,t,i,s,a){s();const n=e(212),r=e(213),m=e(218);class _ extends n.LinearAxisView{}i.DatetimeAxisView=_,_.__name__="DatetimeAxisView";class c extends n.LinearAxis{constructor(e){super(e)}static init_DatetimeAxis(){this.prototype.default_view=_,this.override({ticker:()=>new m.DatetimeTicker,formatter:()=>new r.DatetimeTickFormatter})}}i.DatetimeAxis=c,c.__name__="DatetimeAxis",c.init_DatetimeAxis()},
function _(i,e,s,n,t){n();const r=i(210),a=i(143),o=i(141);class c extends r.ContinuousAxisView{}s.LinearAxisView=c,c.__name__="LinearAxisView";class _ extends r.ContinuousAxis{constructor(i){super(i)}static init_LinearAxis(){this.prototype.default_view=c,this.override({ticker:()=>new o.BasicTicker,formatter:()=>new a.BasicTickFormatter})}}s.LinearAxis=_,_.__name__="LinearAxis",_.init_LinearAxis()},
function _(t,s,e,i,n){i();const r=t(1).__importDefault(t(214)),o=t(140),a=t(19),c=t(215),m=t(9),u=t(8);function h(t){return r.default(t,"%Y %m %d %H %M %S").split(/\s+/).map(t=>parseInt(t,10))}function d(t,s){if(u.isFunction(s))return s(t);{const e=c.sprintf("$1%06d",function(t){return Math.round(t/1e3%1*1e6)}(t));return-1==(s=s.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?s:r.default(t,s)}}const l=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"];class f extends o.TickFormatter{constructor(t){super(t),this.strip_leading_zeros=!0}static init_DatetimeTickFormatter(){this.define(({String:t,Array:s})=>({microseconds:[s(t),["%fus"]],milliseconds:[s(t),["%3Nms","%S.%3Ns"]],seconds:[s(t),["%Ss"]],minsec:[s(t),[":%M:%S"]],minutes:[s(t),[":%M","%Mm"]],hourmin:[s(t),["%H:%M"]],hours:[s(t),["%Hh","%H:%M"]],days:[s(t),["%m/%d","%a%d"]],months:[s(t),["%m/%Y","%b %Y"]],years:[s(t),["%Y"]]}))}initialize(){super.initialize(),this._update_width_formats()}_update_width_formats(){const t=+r.default(new Date),s=function(s){const e=s.map(s=>d(t,s).length),i=m.sort_by(m.zip(e,s),([t])=>t);return m.unzip(i)};this._width_formats={microseconds:s(this.microseconds),milliseconds:s(this.milliseconds),seconds:s(this.seconds),minsec:s(this.minsec),minutes:s(this.minutes),hourmin:s(this.hourmin),hours:s(this.hours),days:s(this.days),months:s(this.months),years:s(this.years)}}_get_resolution_str(t,s){const e=1.1*t;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return s>=60?"minsec":"seconds";case!(e<3600):return s>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}}doFormat(t,s){if(0==t.length)return[];const e=Math.abs(t[t.length-1]-t[0])/1e3,i=e/(t.length-1),n=this._get_resolution_str(i,e),[,[r]]=this._width_formats[n],o=[],c=l.indexOf(n),m={};for(const t of l)m[t]=0;m.seconds=5,m.minsec=4,m.minutes=4,m.hourmin=3,m.hours=3;for(const s of t){let t,e;try{e=h(s),t=d(s,r)}catch(t){a.logger.warn("unable to format tick for timestamp value "+s),a.logger.warn(" - "+t),o.push("ERR");continue}let i=!1,u=c;for(;0==e[m[l[u]]];){let r;if(u+=1,u==l.length)break;if(("minsec"==n||"hourmin"==n)&&!i){if("minsec"==n&&0==e[4]&&0!=e[5]||"hourmin"==n&&0==e[3]&&0!=e[4]){r=this._width_formats[l[c-1]][1][0],t=d(s,r);break}i=!0}r=this._width_formats[l[u]][1][0],t=d(s,r)}if(this.strip_leading_zeros){let s=t.replace(/^0+/g,"");s!=t&&isNaN(parseInt(s))&&(s="0"+s),o.push(s)}else o.push(t)}return o}}e.DatetimeTickFormatter=f,f.__name__="DatetimeTickFormatter",f.init_DatetimeTickFormatter()},
function _(e,t,n,r,o){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(r,t,n,e,i){e();const u=r(1),a=u.__importStar(r(216)),f=r(217),o=u.__importDefault(r(214)),l=r(21),s=r(8);function c(r,...t){return f.sprintf(r,...t)}function m(r,t,n){if(s.isNumber(r)){return c((()=>{switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}})(),r)}return""+r}function p(r,t,e){if(null==t)return m;if(null!=e&&r in e){const t=e[r];if(s.isString(t)){if(t in n.DEFAULT_FORMATTERS)return n.DEFAULT_FORMATTERS[t];throw new Error(`Unknown tooltip field formatter type '${t}'`)}return function(r,n,e){return t.format(r,n,e)}}return n.DEFAULT_FORMATTERS.numeral}function d(r,t,n,e){if("$"==r[0]){return function(r,t){if(r in t)return t[r];throw new Error(`Unknown special variable '$${r}'`)}(r.substring(1),e)}return function(r,t,n){const e=t.get_column(r);if(null==e)return null;if(s.isNumber(n))return e[n];const i=e[n.index];if(s.isTypedArray(i)||s.isArray(i))return s.isArray(i[0])?i[n.dim2][n.dim1]:i[n.flat_index];return i}(r.substring(1).replace(/[{}]/g,""),t,n)}n.FormatterType=l.Enum("numeral","printf","datetime"),n.DEFAULT_FORMATTERS={numeral:(r,t,n)=>a.format(r,t),datetime:(r,t,n)=>o.default(r,t),printf:(r,t,n)=>c(t,r)},n.sprintf=c,n.basic_formatter=m,n.get_formatter=p,n.get_value=d,n.replace_placeholders=function(r,t,n,e,i={},u){let a,f;if(s.isString(r)?(a=r,f=!1):(a=r.html,f=!0),a=a.replace(/@\$name/g,r=>`@{${i.name}}`),a=a.replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,(r,a,o)=>{const l=d(a,t,n,i);if(null==l)return u?u("???"):"???";if("safe"==o)return f=!0,""+l;const s=""+p(a,o,e)(l,o,i);return u?u(s):s}),f){return[...(new DOMParser).parseFromString(a,"text/html").body.childNodes]}return a}},
function _(e,n,t,r,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var a,o={},l=o,u="en-US",c=null,s="0,0";void 0!==n&&n.exports;function f(e){this._value=e}function d(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function h(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+d(i-r.length),n>0&&(a+="."+d(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function p(e,n,t){return n.indexOf("$")>-1?function(e,n,t){var r,i,a=n,l=a.indexOf("$"),c=a.indexOf("("),s=a.indexOf("+"),f=a.indexOf("-"),d="",h="";-1===a.indexOf("$")?"infix"===o[u].currency.position?(h=o[u].currency.symbol,o[u].currency.spaceSeparated&&(h=" "+h+" ")):o[u].currency.spaceSeparated&&(d=" "):a.indexOf(" $")>-1?(d=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(d=" ",a=a.replace("$ ","")):a=a.replace("$","");if(i=m(e,a,t,h),-1===n.indexOf("$"))switch(o[u].currency.position){case"postfix":i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;break;case"infix":break;case"prefix":i.indexOf("(")>-1||i.indexOf("-")>-1?(i=i.split(""),r=Math.max(c,f)+1,i.splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?i.indexOf("(")>-1||i.indexOf("+")>-1||i.indexOf("-")>-1?(r=1,(l<c||l<s||l<f)&&(r=0),(i=i.split("")).splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i:i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;return i}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=m(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):m(e,n,t)}function m(e,n,t,r){var i,a,l,s,f,d,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==c)return c;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(f=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(d=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,f)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===d?0:3*~~(d/3)-d)<0?M+3:M,i=0;i<M;i++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=o[u].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=o[u].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=o[u].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=o[u].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(a=Math.pow(1024,s),l=Math.pow(1024,s+1),e>=a&&e<l){C+=K[s],a>0&&(e/=a);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(a=Math.pow(1e3,s),l=Math.pow(1e3,s+1),e>=a&&e<l){C+=G[s],a>0&&(e/=a);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),o[u].ordinal&&(L+=o[u].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?h(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?h(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):h(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:o[u].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=h(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o[u].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function x(e,n){o[e]=n}function g(e){u=e;var n=o[e].defaults;n&&n.format&&a.defaultFormat(n.format),n&&n.currencyFormat&&a.defaultCurrencyFormat(n.currencyFormat)}(a=function(e){return a.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=a.fn.unformat(e)),new f(Number(e))}).version="1.6.2",a.isNumbro=function(e){return e instanceof f},a.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;l[t]||(Object.keys(l).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.setCulture=function(e,n){var t=e,r=e.split("-")[1],i=null;o[t]||(r&&Object.keys(o).forEach((function(e){i||e.split("-")[1]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return u;if(e&&!n){if(!l[e])throw new Error("Unknown language : "+e);g(e)}return!n&&l[e]||x(e,n),a},a.culture=function(e,n){if(!e)return u;if(e&&!n){if(!o[e])throw new Error("Unknown culture : "+e);g(e)}return!n&&o[e]||x(e,n),a},a.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return l[u];if(!l[e])throw new Error("Unknown language : "+e);return l[e]},a.cultureData=function(e){if(!e)return o[u];if(!o[e])throw new Error("Unknown culture : "+e);return o[e]},a.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),a.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),l},a.cultures=function(){return o},a.zeroFormat=function(e){c="string"==typeof e?e:null},a.defaultFormat=function(e){s="string"==typeof e?e:"0.0"},a.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},a.validate=function(e,n){var t,r,i,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=a.cultureData(n)}catch(e){c=a.cultureData(a.culture())}return i=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,r="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===i))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(r+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,r){return null!=t&&t!==a.culture()&&a.setCulture(t),p(Number(e),null!=n?n:s,null==r?Math.round:r)}}},
function _(e,n,t,r,i){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,i,n,t,a){t();const s=e(9),r=e(142),c=e(219),m=e(220),_=e(223),k=e(224),o=e(222);class T extends c.CompositeTicker{constructor(e){super(e)}static init_DatetimeTicker(){this.override({num_minor_ticks:0,tickers:()=>[new r.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*o.ONE_MILLI,num_minor_ticks:0}),new r.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:o.ONE_SECOND,max_interval:30*o.ONE_MINUTE,num_minor_ticks:0}),new r.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:o.ONE_HOUR,max_interval:12*o.ONE_HOUR,num_minor_ticks:0}),new m.DaysTicker({days:s.range(1,32)}),new m.DaysTicker({days:s.range(1,31,3)}),new m.DaysTicker({days:[1,8,15,22]}),new m.DaysTicker({days:[1,15]}),new _.MonthsTicker({months:s.range(0,12,1)}),new _.MonthsTicker({months:s.range(0,12,2)}),new _.MonthsTicker({months:s.range(0,12,4)}),new _.MonthsTicker({months:s.range(0,12,6)}),new k.YearsTicker({})]})}}n.DatetimeTicker=T,T.__name__="DatetimeTicker",T.init_DatetimeTicker()},
function _(t,e,i,s,r){s();const n=t(138),_=t(9);class a extends n.ContinuousTicker{constructor(t){super(t)}static init_CompositeTicker(){this.define(({Array:t,Ref:e})=>({tickers:[t(e(n.ContinuousTicker)),[]]}))}get min_intervals(){return this.tickers.map(t=>t.get_min_interval())}get max_intervals(){return this.tickers.map(t=>t.get_max_interval())}get_min_interval(){return this.min_intervals[0]}get_max_interval(){return this.max_intervals[0]}get_best_ticker(t,e,i){const s=e-t,r=this.get_ideal_interval(t,e,i),n=[_.sorted_index(this.min_intervals,r)-1,_.sorted_index(this.max_intervals,r)],a=[this.min_intervals[n[0]],this.max_intervals[n[1]]].map(t=>Math.abs(i-s/t));let c;if(_.is_empty(a.filter(t=>!isNaN(t))))c=this.tickers[0];else{const t=n[_.argmin(a)];c=this.tickers[t]}return c}get_interval(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)}get_ticks_no_defaults(t,e,i,s){return this.get_best_ticker(t,e,s).get_ticks_no_defaults(t,e,i,s)}}i.CompositeTicker=a,a.__name__="CompositeTicker",a.init_CompositeTicker()},
function _(t,e,n,i,s){i();const a=t(221),o=t(222),r=t(9);class c extends a.SingleIntervalTicker{constructor(t){super(t)}static init_DaysTicker(){this.define(({Int:t,Array:e})=>({days:[e(t),[]]})),this.override({num_minor_ticks:0})}initialize(){super.initialize();const t=this.days;t.length>1?this.interval=(t[1]-t[0])*o.ONE_DAY:this.interval=31*o.ONE_DAY}get_ticks_no_defaults(t,e,n,i){const s=function(t,e){const n=o.last_month_no_later_than(new Date(t)),i=o.last_month_no_later_than(new Date(e));i.setUTCMonth(i.getUTCMonth()+1);const s=[],a=n;for(;s.push(o.copy_date(a)),a.setUTCMonth(a.getUTCMonth()+1),!(a>i););return s}(t,e),a=this.days,c=this.interval;return{major:r.concat(s.map(t=>((t,e)=>{const n=t.getUTCMonth(),i=[];for(const s of a){const a=o.copy_date(t);a.setUTCDate(s),new Date(a.getTime()+e/2).getUTCMonth()==n&&i.push(a)}return i})(t,c))).map(t=>t.getTime()).filter(n=>t<=n&&n<=e),minor:[]}}}n.DaysTicker=c,c.__name__="DaysTicker",c.init_DaysTicker()},
function _(e,t,n,i,r){i();const l=e(138);class a extends l.ContinuousTicker{constructor(e){super(e)}static init_SingleIntervalTicker(){this.define(({Number:e})=>({interval:[e]}))}get_interval(e,t,n){return this.interval}get_min_interval(){return this.interval}get_max_interval(){return this.interval}}n.SingleIntervalTicker=a,a.__name__="SingleIntervalTicker",a.init_SingleIntervalTicker()},
function _(t,n,e,_,E){function N(t){return new Date(t.getTime())}function O(t){const n=N(t);return n.setUTCDate(1),n.setUTCHours(0),n.setUTCMinutes(0),n.setUTCSeconds(0),n.setUTCMilliseconds(0),n}_(),e.ONE_MILLI=1,e.ONE_SECOND=1e3,e.ONE_MINUTE=60*e.ONE_SECOND,e.ONE_HOUR=60*e.ONE_MINUTE,e.ONE_DAY=24*e.ONE_HOUR,e.ONE_MONTH=30*e.ONE_DAY,e.ONE_YEAR=365*e.ONE_DAY,e.copy_date=N,e.last_month_no_later_than=O,e.last_year_no_later_than=function(t){const n=O(t);return n.setUTCMonth(0),n}},
function _(t,e,n,i,s){i();const r=t(221),a=t(222),o=t(9);class c extends r.SingleIntervalTicker{constructor(t){super(t)}static init_MonthsTicker(){this.define(({Int:t,Array:e})=>({months:[e(t),[]]}))}initialize(){super.initialize();const t=this.months;t.length>1?this.interval=(t[1]-t[0])*a.ONE_MONTH:this.interval=12*a.ONE_MONTH}get_ticks_no_defaults(t,e,n,i){const s=function(t,e){const n=a.last_year_no_later_than(new Date(t)),i=a.last_year_no_later_than(new Date(e));i.setUTCFullYear(i.getUTCFullYear()+1);const s=[],r=n;for(;s.push(a.copy_date(r)),r.setUTCFullYear(r.getUTCFullYear()+1),!(r>i););return s}(t,e),r=this.months;return{major:o.concat(s.map(t=>r.map(e=>{const n=a.copy_date(t);return n.setUTCMonth(e),n}))).map(t=>t.getTime()).filter(n=>t<=n&&n<=e),minor:[]}}}n.MonthsTicker=c,c.__name__="MonthsTicker",c.init_MonthsTicker()},
function _(e,t,a,i,r){i();const n=e(141),_=e(221),s=e(222);class c extends _.SingleIntervalTicker{constructor(e){super(e)}initialize(){super.initialize(),this.interval=s.ONE_YEAR,this.basic_ticker=new n.BasicTicker({num_minor_ticks:0})}get_ticks_no_defaults(e,t,a,i){const r=s.last_year_no_later_than(new Date(e)).getUTCFullYear(),n=s.last_year_no_later_than(new Date(t)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,n,a,i).major.map(e=>Date.UTC(e,0,1)).filter(a=>e<=a&&a<=t),minor:[]}}}a.YearsTicker=c,c.__name__="YearsTicker"},
function _(i,s,t,e,o){e();const n=i(210),r=i(226),_=i(227);class c extends n.ContinuousAxisView{}t.LogAxisView=c,c.__name__="LogAxisView";class x extends n.ContinuousAxis{constructor(i){super(i)}static init_LogAxis(){this.prototype.default_view=c,this.override({ticker:()=>new _.LogTicker,formatter:()=>new r.LogTickFormatter})}}t.LogAxis=x,x.__name__="LogAxis",x.init_LogAxis()},
function _(t,i,r,e,o){e();const a=t(140),n=t(143),c=t(227);class s extends a.TickFormatter{constructor(t){super(t)}static init_LogTickFormatter(){this.define(({Ref:t,Nullable:i})=>({ticker:[i(t(c.LogTicker)),null]}))}initialize(){super.initialize(),this.basic_formatter=new n.BasicTickFormatter}doFormat(t,i){if(0==t.length)return[];const r=null!=this.ticker?this.ticker.base:10;let e=!1;const o=new Array(t.length);for(let i=0,a=t.length;i<a;i++)if(o[i]=`${r}^${Math.round(Math.log(t[i])/Math.log(r))}`,i>0&&o[i]==o[i-1]){e=!0;break}return e?this.basic_formatter.doFormat(t,i):o}}r.LogTickFormatter=s,s.__name__="LogTickFormatter",s.init_LogTickFormatter()},
function _(t,o,e,i,s){i();const n=t(142),r=t(9);class c extends n.AdaptiveTicker{constructor(t){super(t)}static init_LogTicker(){this.override({mantissas:[1,5]})}get_ticks_no_defaults(t,o,e,i){const s=this.num_minor_ticks,n=[],c=this.base,a=Math.log(t)/Math.log(c),f=Math.log(o)/Math.log(c),l=f-a;let h;if(isFinite(l))if(l<2){const e=this.get_interval(t,o,i),c=Math.floor(t/e),a=Math.ceil(o/e);if(h=r.range(c,a+1).filter(t=>0!=t).map(t=>t*e).filter(e=>t<=e&&e<=o),s>0&&h.length>0){const t=e/s,o=r.range(0,s).map(o=>o*t);for(const t of o.slice(1))n.push(h[0]-t);for(const t of h)for(const e of o)n.push(t+e)}}else{const t=Math.ceil(.999999*a),o=Math.floor(1.000001*f),e=Math.ceil((o-t)/9);if(h=r.range(t-1,o+1,e).map(t=>c**t),s>0&&h.length>0){const t=c**e/s,o=r.range(1,s+1).map(o=>o*t);for(const t of o)n.push(h[0]/t);n.push(h[0]);for(const t of h)for(const e of o)n.push(t*e)}}else h=[];return{major:h.filter(e=>t<=e&&e<=o),minor:n.filter(e=>t<=e&&e<=o)}}}e.LogTicker=c,c.__name__="LogTicker",c.init_LogTicker()},
function _(e,t,i,r,s){r();const a=e(205),o=e(212),c=e(229),n=e(230);class _ extends a.AxisView{}i.MercatorAxisView=_,_.__name__="MercatorAxisView";class x extends o.LinearAxis{constructor(e){super(e)}static init_MercatorAxis(){this.prototype.default_view=_,this.override({ticker:()=>new n.MercatorTicker({dimension:"lat"}),formatter:()=>new c.MercatorTickFormatter({dimension:"lat"})})}}i.MercatorAxis=x,x.__name__="MercatorAxis",x.init_MercatorAxis()},
function _(r,t,o,e,n){e();const i=r(143),c=r(20),s=r(36);class a extends i.BasicTickFormatter{constructor(r){super(r)}static init_MercatorTickFormatter(){this.define(()=>({dimension:[c.LatLon]}))}doFormat(r,t){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==r.length)return[];const o=r.length,e=new Array(o);if("lon"==this.dimension)for(let n=0;n<o;n++){const[o]=s.wgs84_mercator.invert(r[n],t.loc);e[n]=o}else for(let n=0;n<o;n++){const[,o]=s.wgs84_mercator.invert(t.loc,r[n]);e[n]=o}return super.doFormat(e,t)}}o.MercatorTickFormatter=a,a.__name__="MercatorTickFormatter",a.init_MercatorTickFormatter()},
function _(t,o,n,r,s){r();const i=t(141),e=t(20),c=t(36);class _ extends i.BasicTicker{constructor(t){super(t)}static init_MercatorTicker(){this.define(()=>({dimension:[e.LatLon]}))}get_ticks_no_defaults(t,o,n,r){if(null==this.dimension)throw new Error(this+".dimension wasn't configured");return[t,o]=c.clip_mercator(t,o,this.dimension),"lon"==this.dimension?this._get_ticks_lon(t,o,n,r):this._get_ticks_lat(t,o,n,r)}_get_ticks_lon(t,o,n,r){const[s]=c.wgs84_mercator.invert(t,n),[i,e]=c.wgs84_mercator.invert(o,n),_=super.get_ticks_no_defaults(s,i,n,r),a=[];for(const t of _.major)if(c.in_bounds(t,"lon")){const[o]=c.wgs84_mercator.compute(t,e);a.push(o)}const m=[];for(const t of _.minor)if(c.in_bounds(t,"lon")){const[o]=c.wgs84_mercator.compute(t,e);m.push(o)}return{major:a,minor:m}}_get_ticks_lat(t,o,n,r){const[,s]=c.wgs84_mercator.invert(n,t),[i,e]=c.wgs84_mercator.invert(n,o),_=super.get_ticks_no_defaults(s,e,n,r),a=[];for(const t of _.major)if(c.in_bounds(t,"lat")){const[,o]=c.wgs84_mercator.compute(i,t);a.push(o)}const m=[];for(const t of _.minor)if(c.in_bounds(t,"lat")){const[,o]=c.wgs84_mercator.compute(i,t);m.push(o)}return{major:a,minor:m}}}n.MercatorTicker=_,_.__name__="MercatorTicker",_.init_MercatorTicker()},
function _(n,o,t,u,e){u(),e("CustomJS",n(232).CustomJS),e("OpenURL",n(234).OpenURL)},
function _(t,s,e,n,c){n();const u=t(233),i=t(13),a=t(29);class r extends u.Callback{constructor(t){super(t)}static init_CustomJS(){this.define(({Unknown:t,String:s,Dict:e})=>({args:[e(t),{}],code:[s,""]}))}get names(){return i.keys(this.args)}get values(){return i.values(this.args)}get func(){const t=a.use_strict(this.code);return new Function(...this.names,"cb_obj","cb_data",t)}execute(t,s={}){return this.func.apply(t,this.values.concat(t,s))}}e.CustomJS=r,r.__name__="CustomJS",r.init_CustomJS()},
function _(c,a,l,n,s){n();const e=c(88);class o extends e.Model{constructor(c){super(c)}}l.Callback=o,o.__name__="Callback"},
function _(e,n,t,o,i){o();const s=e(233),c=e(215),r=e(8);class a extends s.Callback{constructor(e){super(e)}static init_OpenURL(){this.define(({Boolean:e,String:n})=>({url:[n,"http://"],same_tab:[e,!1]}))}execute(e,{source:n}){const t=e=>{const t=c.replace_placeholders(this.url,n,e,void 0,void 0,encodeURIComponent);if(!r.isString(t))throw new Error("HTML output is not supported in this context");this.same_tab?window.location.href=t:window.open(t)},{selected:o}=n;for(const e of o.indices)t(e);for(const e of o.line_indices)t(e)}}t.OpenURL=a,a.__name__="OpenURL",a.init_OpenURL()},
function _(a,n,e,r,s){r(),s("Canvas",a(76).Canvas),s("CartesianFrame",a(236).CartesianFrame)},
function _(e,t,s,a,_){a();const r=e(237),n=e(158),g=e(170),i=e(168),c=e(238),o=e(100),l=e(241),h=e(13),u=e(11);class y extends l.LayoutItem{constructor(e,t,s,a,_={},r={}){super(),this.in_x_scale=e,this.in_y_scale=t,this.x_range=s,this.y_range=a,this.extra_x_ranges=_,this.extra_y_ranges=r,u.assert(null==e.source_range&&null==e.target_range),u.assert(null==t.source_range&&null==t.target_range),this._configure_scales()}_get_ranges(e,t){return new Map(h.entries(Object.assign(Object.assign({},t),{default:e})))}_get_scales(e,t,s){const a=new Map;for(const[_,l]of t){if((l instanceof c.DataRange1d||l instanceof i.Range1d)&&!(e instanceof n.ContinuousScale))throw new Error(`Range ${l.type} is incompatible is Scale ${e.type}`);if(l instanceof o.FactorRange&&!(e instanceof r.CategoricalScale))throw new Error(`Range ${l.type} is incompatible is Scale ${e.type}`);e instanceof g.LogScale&&l instanceof c.DataRange1d&&(l.scale_hint="log");const t=e.clone();t.setv({source_range:l,target_range:s}),a.set(_,t)}return a}_configure_frame_ranges(){const{bbox:e}=this;this._x_target=new i.Range1d({start:e.left,end:e.right}),this._y_target=new i.Range1d({start:e.bottom,end:e.top})}_configure_scales(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._x_scales=this._get_scales(this.in_x_scale,this._x_ranges,this._x_target),this._y_scales=this._get_scales(this.in_y_scale,this._y_ranges,this._y_target)}_update_scales(){this._configure_frame_ranges();for(const[,e]of this._x_scales)e.target_range=this._x_target;for(const[,e]of this._y_scales)e.target_range=this._y_target}_set_geometry(e,t){super._set_geometry(e,t),this._update_scales()}get x_target(){return this._x_target}get y_target(){return this._y_target}get x_ranges(){return this._x_ranges}get y_ranges(){return this._y_ranges}get x_scales(){return this._x_scales}get y_scales(){return this._y_scales}get x_scale(){return this._x_scales.get("default")}get y_scale(){return this._y_scales.get("default")}get xscales(){return h.to_object(this.x_scales)}get yscales(){return h.to_object(this.y_scales)}}s.CartesianFrame=y,y.__name__="CartesianFrame"},
function _(e,r,t,n,_){n();const c=e(159);class i extends c.Scale{constructor(e){super(e)}compute(e){return super._linear_compute(this.source_range.synthetic(e))}v_compute(e){return super._linear_v_compute(this.source_range.v_synthetic(e))}invert(e){return this._linear_invert(e)}v_invert(e){return this._linear_v_invert(e)}}t.CategoricalScale=i,i.__name__="CategoricalScale"},
function _(t,i,n,a,e){a();const s=t(1),l=t(239),_=t(20),o=t(9),h=t(19),r=s.__importStar(t(86)),d=t(240);class u extends l.DataRange{constructor(t){super(t),this.have_updated_interactively=!1}static init_DataRange1d(){this.define(({Boolean:t,Number:i,Nullable:n})=>({start:[i],end:[i],range_padding:[i,.1],range_padding_units:[_.PaddingUnits,"percent"],flipped:[t,!1],follow:[n(_.StartEnd),null],follow_interval:[n(i),null],default_span:[i,2],only_visible:[t,!1]})),this.internal(({Enum:t})=>({scale_hint:[t("log","auto"),"auto"]}))}initialize(){super.initialize(),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}computed_renderers(){const{renderers:t,names:i}=this,n=o.concat(this.plots.map(t=>t.data_renderers));return d.compute_renderers(0==t.length?"auto":t,n,i)}_compute_plot_bounds(t,i){let n=r.empty();for(const a of t){const t=i.get(a);null==t||!a.visible&&this.only_visible||(n=r.union(n,t))}return n}adjust_bounds_for_aspect(t,i){const n=r.empty();let a=t.x1-t.x0;a<=0&&(a=1);let e=t.y1-t.y0;e<=0&&(e=1);const s=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return a<i*e?a=i*e:e=a/i,n.x1=s+.5*a,n.x0=s-.5*a,n.y1=l+.5*e,n.y0=l-.5*e,n}_compute_min_max(t,i){let n,a,e=r.empty();for(const i of t)e=r.union(e,i);return[n,a]=0==i?[e.x0,e.x1]:[e.y0,e.y1],[n,a]}_compute_range(t,i){const n=this.range_padding;let a,e;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){let s,l;if((isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,h.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,h.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+i)),i==t)l=this.default_span+.001,s=Math.log(t)/Math.log(10);else{let a,e;"percent"==this.range_padding_units?(a=Math.log(t)/Math.log(10),e=Math.log(i)/Math.log(10),l=(e-a)*(1+n)):(a=Math.log(t-n)/Math.log(10),e=Math.log(i+n)/Math.log(10),l=e-a),s=(a+e)/2}a=10**(s-l/2),e=10**(s+l/2)}else{let s;s=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+n):i-t+2*n;const l=(i+t)/2;a=l-s/2,e=l+s/2}let s=1;this.flipped&&([a,e]=[e,a],s=-1);const l=this.follow_interval;return null!=l&&Math.abs(a-e)>l&&("start"==this.follow?e=a+s*l:"end"==this.follow&&(a=e-s*l)),[a,e]}update(t,i,n,a){if(this.have_updated_interactively)return;const e=this.computed_renderers();let s=this._compute_plot_bounds(e,t);null!=a&&(s=this.adjust_bounds_for_aspect(s,a)),this._plot_bounds.set(n,s);const[l,_]=this._compute_min_max(this._plot_bounds.values(),i);let[o,h]=this._compute_range(l,_);null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(o=this._initial_start):o=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(h=this._initial_end):h=this._initial_end);const[r,d]=[this.start,this.end];if(o!=r||h!=d){const t={};o!=r&&(t.start=o),h!=d&&(t.end=h),this.setv(t)}"auto"==this.bounds&&this.setv({bounds:[o,h]},{silent:!0}),this.change.emit()}reset(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()}}n.DataRange1d=u,u.__name__="DataRange1d",u.init_DataRange1d()},
function _(a,e,n,t,r){t();const s=a(101),i=a(104);class R extends s.Range{constructor(a){super(a)}static init_DataRange(){this.define(({String:a,Array:e,Ref:n})=>({names:[e(a),[]],renderers:[e(n(i.DataRenderer)),[]]}))}}n.DataRange=R,R.__name__="DataRange",R.init_DataRange()},
function _(n,e,t,r,u){r();const l=n(9);t.compute_renderers=function(n,e,t){if(null==n)return[];let r="auto"==n?e:n;return t.length>0&&(r=r.filter(n=>l.includes(t,n.name))),r}},
function _(a,o,t,i,n){i();var c=a(242);n("Sizeable",c.Sizeable),n("SizingPolicy",c.SizingPolicy);var r=a(243);n("Layoutable",r.Layoutable),n("LayoutItem",r.LayoutItem);var e=a(244);n("HStack",e.HStack),n("VStack",e.VStack),n("AnchorLayout",e.AnchorLayout);var u=a(245);n("Grid",u.Grid),n("Row",u.Row),n("Column",u.Column);var l=a(246);n("ContentBox",l.ContentBox),n("VariadicBox",l.VariadicBox)},
function _(h,t,i,e,w){e();const n=h(21),{min:d,max:s}=Math;class g{constructor(h={}){this.width=null!=h.width?h.width:0,this.height=null!=h.height?h.height:0}bounded_to({width:h,height:t}){return new g({width:this.width==1/0&&null!=h?h:this.width,height:this.height==1/0&&null!=t?t:this.height})}expanded_to({width:h,height:t}){return new g({width:h!=1/0?s(this.width,h):this.width,height:t!=1/0?s(this.height,t):this.height})}expand_to({width:h,height:t}){this.width=s(this.width,h),this.height=s(this.height,t)}narrowed_to({width:h,height:t}){return new g({width:d(this.width,h),height:d(this.height,t)})}narrow_to({width:h,height:t}){this.width=d(this.width,h),this.height=d(this.height,t)}grow_by({left:h,right:t,top:i,bottom:e}){const w=this.width+h+t,n=this.height+i+e;return new g({width:w,height:n})}shrink_by({left:h,right:t,top:i,bottom:e}){const w=s(this.width-h-t,0),n=s(this.height-i-e,0);return new g({width:w,height:n})}map(h,t){return new g({width:h(this.width),height:(null!=t?t:h)(this.height)})}}i.Sizeable=g,g.__name__="Sizeable",i.SizingPolicy=n.Enum("fixed","fit","min","max")},
function _(i,t,h,e,s){e();const n=i(242),g=i(86),{min:l,max:a,round:d}=Math;class _{constructor(){this._bbox=new g.BBox,this._inner_bbox=new g.BBox}get bbox(){return this._bbox}get inner_bbox(){return this._inner_bbox}get sizing(){return this._sizing}set_sizing(i){var t,h,e,s,n;const g=null!==(t=i.width_policy)&&void 0!==t?t:"fit",l=i.width,a=null!=i.min_width?i.min_width:0,d=null!=i.max_width?i.max_width:1/0,_=null!==(h=i.height_policy)&&void 0!==h?h:"fit",r=i.height,w=null!=i.min_height?i.min_height:0,o=null!=i.max_height?i.max_height:1/0,u=i.aspect,c=null!==(e=i.margin)&&void 0!==e?e:{top:0,right:0,bottom:0,left:0},m=!1!==i.visible,z=null!==(s=i.halign)&&void 0!==s?s:"start",x=null!==(n=i.valign)&&void 0!==n?n:"start";this._sizing={width_policy:g,min_width:a,width:l,max_width:d,height_policy:_,min_height:w,height:r,max_height:o,aspect:u,margin:c,visible:m,halign:z,valign:x,size:{width:l,height:r},min_size:{width:a,height:w},max_size:{width:d,height:o}},this._init()}_init(){}_set_geometry(i,t){this._bbox=i,this._inner_bbox=t}set_geometry(i,t){this._set_geometry(i,null!=t?t:i)}is_width_expanding(){return"max"==this.sizing.width_policy}is_height_expanding(){return"max"==this.sizing.height_policy}apply_aspect(i,{width:t,height:h}){const{aspect:e}=this.sizing;if(null!=e){const{width_policy:s,height_policy:n}=this.sizing,g=(i,t)=>{const h={max:4,fit:3,min:2,fixed:1};return h[i]>h[t]};if("fixed"!=s&&"fixed"!=n)if(s==n){const s=t,n=d(t/e),g=d(h*e),l=h;Math.abs(i.width-s)+Math.abs(i.height-n)<=Math.abs(i.width-g)+Math.abs(i.height-l)?(t=s,h=n):(t=g,h=l)}else g(s,n)?h=d(t/e):t=d(h*e);else"fixed"==s?h=d(t/e):"fixed"==n&&(t=d(h*e))}return{width:t,height:h}}measure(i){if(!this.sizing.visible)return{width:0,height:0};const t=i=>"fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:i,h=i=>"fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:i,e=new n.Sizeable(i).shrink_by(this.sizing.margin).map(t,h),s=this._measure(e),g=this.clip_size(s),l=t(g.width),a=h(g.height),d=this.apply_aspect(e,{width:l,height:a});return Object.assign(Object.assign({},s),d)}compute(i={}){const t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),{width:h,height:e}=t,s=new g.BBox({left:0,top:0,width:h,height:e});let n=void 0;if(null!=t.inner){const{left:i,top:s,right:l,bottom:a}=t.inner;n=new g.BBox({left:i,top:s,right:h-l,bottom:e-a})}this.set_geometry(s,n)}get xview(){return this.bbox.xview}get yview(){return this.bbox.yview}clip_width(i){return a(this.sizing.min_width,l(i,this.sizing.max_width))}clip_height(i){return a(this.sizing.min_height,l(i,this.sizing.max_height))}clip_size({width:i,height:t}){return{width:this.clip_width(i),height:this.clip_height(t)}}}h.Layoutable=_,_.__name__="Layoutable";class r extends _{_measure(i){const{width_policy:t,height_policy:h}=this.sizing;let e,s;if(i.width==1/0)e=null!=this.sizing.width?this.sizing.width:0;else switch(t){case"fixed":e=null!=this.sizing.width?this.sizing.width:0;break;case"min":e=null!=this.sizing.width?l(i.width,this.sizing.width):0;break;case"fit":e=null!=this.sizing.width?l(i.width,this.sizing.width):i.width;break;case"max":e=null!=this.sizing.width?a(i.width,this.sizing.width):i.width}if(i.height==1/0)s=null!=this.sizing.height?this.sizing.height:0;else switch(h){case"fixed":s=null!=this.sizing.height?this.sizing.height:0;break;case"min":s=null!=this.sizing.height?l(i.height,this.sizing.height):0;break;case"fit":s=null!=this.sizing.height?l(i.height,this.sizing.height):i.height;break;case"max":s=null!=this.sizing.height?a(i.height,this.sizing.height):i.height}return{width:e,height:s}}}h.LayoutItem=r,r.__name__="LayoutItem";class w extends _{_measure(i){const t=this._content_size(),h=i.bounded_to(this.sizing.size).bounded_to(t);return{width:(()=>{switch(this.sizing.width_policy){case"fixed":return null!=this.sizing.width?this.sizing.width:t.width;case"min":return t.width;case"fit":return h.width;case"max":return Math.max(t.width,h.width)}})(),height:(()=>{switch(this.sizing.height_policy){case"fixed":return null!=this.sizing.height?this.sizing.height:t.height;case"min":return t.height;case"fit":return h.height;case"max":return Math.max(t.height,h.height)}})()}}}h.ContentLayoutable=w,w.__name__="ContentLayoutable"},
function _(t,e,h,o,r){o();const i=t(243),s=t(86);class n extends i.Layoutable{constructor(){super(...arguments),this.children=[]}}h.Stack=n,n.__name__="Stack";class c extends n{_measure(t){let e=0,h=0;for(const t of this.children){const o=t.measure({width:0,height:0});e+=o.width,h=Math.max(h,o.height)}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const{top:h,bottom:o}=t;let{left:r}=t;for(const t of this.children){const{width:e}=t.measure({width:0,height:0});t.set_geometry(new s.BBox({left:r,width:e,top:h,bottom:o})),r+=e}}}h.HStack=c,c.__name__="HStack";class a extends n{_measure(t){let e=0,h=0;for(const t of this.children){const o=t.measure({width:0,height:0});e=Math.max(e,o.width),h+=o.height}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const{left:h,right:o}=t;let{top:r}=t;for(const t of this.children){const{height:e}=t.measure({width:0,height:0});t.set_geometry(new s.BBox({top:r,height:e,left:h,right:o})),r+=e}}}h.VStack=a,a.__name__="VStack";class _ extends i.Layoutable{constructor(){super(...arguments),this.children=[]}_measure(t){let e=0,h=0;for(const{layout:o}of this.children){const r=o.measure(t);e=Math.max(e,r.width),h=Math.max(h,r.height)}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);for(const{layout:e,anchor:h,margin:o}of this.children){const{left:r,right:i,top:n,bottom:c,hcenter:a,vcenter:_}=t,{width:g,height:m}=e.measure(t);let d;switch(h){case"top_left":d=new s.BBox({left:r+o,top:n+o,width:g,height:m});break;case"top_center":d=new s.BBox({hcenter:a,top:n+o,width:g,height:m});break;case"top_right":d=new s.BBox({right:i-o,top:n+o,width:g,height:m});break;case"bottom_right":d=new s.BBox({right:i-o,bottom:c-o,width:g,height:m});break;case"bottom_center":d=new s.BBox({hcenter:a,bottom:c-o,width:g,height:m});break;case"bottom_left":d=new s.BBox({left:r+o,bottom:c-o,width:g,height:m});break;case"center_left":d=new s.BBox({left:r+o,vcenter:_,width:g,height:m});break;case"center":d=new s.BBox({hcenter:a,vcenter:_,width:g,height:m});break;case"center_right":d=new s.BBox({right:i-o,vcenter:_,width:g,height:m})}e.set_geometry(d)}}}h.AnchorLayout=_,_.__name__="AnchorLayout"},
function _(t,i,s,e,o){e();const n=t(242),l=t(243),r=t(8),h=t(86),c=t(9),{max:a,round:g}=Math;class p{constructor(t){this.def=t,this._map=new Map}get(t){let i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i}apply(t,i){const s=this.get(t);this._map.set(t,i(s))}}p.__name__="DefaultMap";class f{constructor(){this._items=[],this._nrows=0,this._ncols=0}get nrows(){return this._nrows}get ncols(){return this._ncols}add(t,i){const{r1:s,c1:e}=t;this._nrows=a(this._nrows,s+1),this._ncols=a(this._ncols,e+1),this._items.push({span:t,data:i})}at(t,i){return this._items.filter(({span:s})=>s.r0<=t&&t<=s.r1&&s.c0<=i&&i<=s.c1).map(({data:t})=>t)}row(t){return this._items.filter(({span:i})=>i.r0<=t&&t<=i.r1).map(({data:t})=>t)}col(t){return this._items.filter(({span:i})=>i.c0<=t&&t<=i.c1).map(({data:t})=>t)}foreach(t){for(const{span:i,data:s}of this._items)t(i,s)}map(t){const i=new f;for(const{span:s,data:e}of this._items)i.add(s,t(s,e));return i}}f.__name__="Container";class _ extends l.Layoutable{constructor(t=[]){super(),this.items=t,this.rows="auto",this.cols="auto",this.spacing=0,this.absolute=!1}is_width_expanding(){if(super.is_width_expanding())return!0;if("fixed"==this.sizing.width_policy)return!1;const{cols:t}=this._state;return c.some(t,t=>"max"==t.policy)}is_height_expanding(){if(super.is_height_expanding())return!0;if("fixed"==this.sizing.height_policy)return!1;const{rows:t}=this._state;return c.some(t,t=>"max"==t.policy)}_init(){var t,i,s,e;super._init();const o=new f;for(const{layout:t,row:i,col:s,row_span:e,col_span:n}of this.items)if(t.sizing.visible){const l=i,r=s,h=i+(null!=e?e:1)-1,c=s+(null!=n?n:1)-1;o.add({r0:l,c0:r,r1:h,c1:c},t)}const{nrows:n,ncols:l}=o,h=new Array(n);for(let s=0;s<n;s++){const e=(()=>{var t;const i=r.isPlainObject(this.rows)?null!==(t=this.rows[s])&&void 0!==t?t:this.rows["*"]:this.rows;return null==i?{policy:"auto"}:r.isNumber(i)?{policy:"fixed",height:i}:r.isString(i)?{policy:i}:i})(),n=null!==(t=e.align)&&void 0!==t?t:"auto";if("fixed"==e.policy)h[s]={policy:"fixed",height:e.height,align:n};else if("min"==e.policy)h[s]={policy:"min",align:n};else if("fit"==e.policy||"max"==e.policy)h[s]={policy:e.policy,flex:null!==(i=e.flex)&&void 0!==i?i:1,align:n};else{if("auto"!=e.policy)throw new Error("unrechable");c.some(o.row(s),t=>t.is_height_expanding())?h[s]={policy:"max",flex:1,align:n}:h[s]={policy:"min",align:n}}}const a=new Array(l);for(let t=0;t<l;t++){const i=(()=>{var i;const s=r.isPlainObject(this.cols)?null!==(i=this.cols[t])&&void 0!==i?i:this.cols["*"]:this.cols;return null==s?{policy:"auto"}:r.isNumber(s)?{policy:"fixed",width:s}:r.isString(s)?{policy:s}:s})(),n=null!==(s=i.align)&&void 0!==s?s:"auto";if("fixed"==i.policy)a[t]={policy:"fixed",width:i.width,align:n};else if("min"==i.policy)a[t]={policy:"min",align:n};else if("fit"==i.policy||"max"==i.policy)a[t]={policy:i.policy,flex:null!==(e=i.flex)&&void 0!==e?e:1,align:n};else{if("auto"!=i.policy)throw new Error("unrechable");c.some(o.col(t),t=>t.is_width_expanding())?a[t]={policy:"max",flex:1,align:n}:a[t]={policy:"min",align:n}}}const[g,p]=r.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing;this._state={items:o,nrows:n,ncols:l,rows:h,cols:a,rspacing:g,cspacing:p}}_measure_totals(t,i){const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state;return{height:c.sum(t)+(s-1)*o,width:c.sum(i)+(e-1)*n}}_measure_cells(t){const{items:i,nrows:s,ncols:e,rows:o,cols:l,rspacing:r,cspacing:h}=this._state,c=new Array(s);for(let t=0;t<s;t++){const i=o[t];c[t]="fixed"==i.policy?i.height:0}const p=new Array(e);for(let t=0;t<e;t++){const i=l[t];p[t]="fixed"==i.policy?i.width:0}const _=new f;i.foreach((i,s)=>{const{r0:e,c0:f,r1:d,c1:u}=i,w=(d-e)*r,m=(u-f)*h;let y=0;for(let i=e;i<=d;i++)y+=t(i,f).height;y+=w;let x=0;for(let i=f;i<=u;i++)x+=t(e,i).width;x+=m;const b=s.measure({width:x,height:y});_.add(i,{layout:s,size_hint:b});const z=new n.Sizeable(b).grow_by(s.sizing.margin);z.height-=w,z.width-=m;const v=[];for(let t=e;t<=d;t++){const i=o[t];"fixed"==i.policy?z.height-=i.height:v.push(t)}if(z.height>0){const t=g(z.height/v.length);for(const i of v)c[i]=a(c[i],t)}const j=[];for(let t=f;t<=u;t++){const i=l[t];"fixed"==i.policy?z.width-=i.width:j.push(t)}if(z.width>0){const t=g(z.width/j.length);for(const i of j)p[i]=a(p[i],t)}});return{size:this._measure_totals(c,p),row_heights:c,col_widths:p,size_hints:_}}_measure_grid(t){const{nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:l}=this._state,r=this._measure_cells((t,i)=>{const s=e[t],n=o[i];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==s.policy?s.height:1/0}});let h;h="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:r.size.height;let c,p=0;for(let t=0;t<i;t++){const i=e[t];"fit"==i.policy||"max"==i.policy?p+=i.flex:h-=r.row_heights[t]}if(h-=(i-1)*n,0!=p&&h>0)for(let t=0;t<i;t++){const i=e[t];if("fit"==i.policy||"max"==i.policy){const s=g(h*(i.flex/p));h-=s,r.row_heights[t]=s,p-=i.flex}}else if(h<0){let t=0;for(let s=0;s<i;s++){"fixed"!=e[s].policy&&t++}let s=-h;for(let o=0;o<i;o++){if("fixed"!=e[o].policy){const i=r.row_heights[o],e=g(s/t);r.row_heights[o]=a(i-e,0),s-=e>i?i:e,t--}}}c="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:r.size.width;let f=0;for(let t=0;t<s;t++){const i=o[t];"fit"==i.policy||"max"==i.policy?f+=i.flex:c-=r.col_widths[t]}if(c-=(s-1)*l,0!=f&&c>0)for(let t=0;t<s;t++){const i=o[t];if("fit"==i.policy||"max"==i.policy){const s=g(c*(i.flex/f));c-=s,r.col_widths[t]=s,f-=i.flex}}else if(c<0){let t=0;for(let i=0;i<s;i++){"fixed"!=o[i].policy&&t++}let i=-c;for(let e=0;e<s;e++){if("fixed"!=o[e].policy){const s=r.col_widths[e],o=g(i/t);r.col_widths[e]=a(s-o,0),i-=o>s?s:o,t--}}}const{row_heights:_,col_widths:d,size_hints:u}=this._measure_cells((t,i)=>({width:r.col_widths[i],height:r.row_heights[t]}));return{size:this._measure_totals(_,d),row_heights:_,col_widths:d,size_hints:u}}_measure(t){const{size:i}=this._measure_grid(t);return i}_set_geometry(t,i){super._set_geometry(t,i);const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state,{row_heights:l,col_widths:r,size_hints:c}=this._measure_grid(t),f=this._state.rows.map((t,i)=>Object.assign(Object.assign({},t),{top:0,height:l[i],get bottom(){return this.top+this.height}})),_=this._state.cols.map((t,i)=>Object.assign(Object.assign({},t),{left:0,width:r[i],get right(){return this.left+this.width}})),d=c.map((t,i)=>Object.assign(Object.assign({},i),{outer:new h.BBox,inner:new h.BBox}));for(let i=0,e=this.absolute?t.top:0;i<s;i++){const t=f[i];t.top=e,e+=t.height+o}for(let i=0,s=this.absolute?t.left:0;i<e;i++){const t=_[i];t.left=s,s+=t.width+n}d.foreach(({r0:t,c0:i,r1:s,c1:e},l)=>{const{layout:r,size_hint:c}=l,{sizing:a}=r,{width:p,height:d}=c,u=function(t,i){let s=(i-t)*n;for(let e=t;e<=i;e++)s+=_[e].width;return s}(i,e),w=function(t,i){let s=(i-t)*o;for(let e=t;e<=i;e++)s+=f[e].height;return s}(t,s),m=i==e&&"auto"!=_[i].align?_[i].align:a.halign,y=t==s&&"auto"!=f[t].align?f[t].align:a.valign;let x=_[i].left;"start"==m?x+=a.margin.left:"center"==m?x+=g((u-p)/2):"end"==m&&(x+=u-a.margin.right-p);let b=f[t].top;"start"==y?b+=a.margin.top:"center"==y?b+=g((w-d)/2):"end"==y&&(b+=w-a.margin.bottom-d),l.outer=new h.BBox({left:x,top:b,width:p,height:d})});const u=f.map(()=>({start:new p(()=>0),end:new p(()=>0)})),w=_.map(()=>({start:new p(()=>0),end:new p(()=>0)}));d.foreach(({r0:t,c0:i,r1:s,c1:e},{size_hint:o,outer:n})=>{const{inner:l}=o;null!=l&&(u[t].start.apply(n.top,t=>a(t,l.top)),u[s].end.apply(f[s].bottom-n.bottom,t=>a(t,l.bottom)),w[i].start.apply(n.left,t=>a(t,l.left)),w[e].end.apply(_[e].right-n.right,t=>a(t,l.right)))}),d.foreach(({r0:t,c0:i,r1:s,c1:e},o)=>{const{size_hint:n,outer:l}=o;function r({left:t,right:i,top:s,bottom:e}){const o=l.width-t-i,n=l.height-s-e;return new h.BBox({left:t,top:s,width:o,height:n})}if(null!=n.inner){let h=r(n.inner);if(!1!==n.align){const o=u[t].start.get(l.top),n=u[s].end.get(f[s].bottom-l.bottom),c=w[i].start.get(l.left),a=w[e].end.get(_[e].right-l.right);try{h=r({top:o,bottom:n,left:c,right:a})}catch(t){}}o.inner=h}else o.inner=l}),d.foreach((t,{layout:i,outer:s,inner:e})=>{i.set_geometry(s,e)})}}s.Grid=_,_.__name__="Grid";class d extends _{constructor(t){super(),this.items=t.map((t,i)=>({layout:t,row:0,col:i})),this.rows="fit"}}s.Row=d,d.__name__="Row";class u extends _{constructor(t){super(),this.items=t.map((t,i)=>({layout:t,row:i,col:0})),this.cols="fit"}}s.Column=u,u.__name__="Column"},
function _(e,t,s,n,i){n();const a=e(243),c=e(242),o=e(71);class r extends a.ContentLayoutable{constructor(e){super(),this.content_size=o.unsized(e,()=>new c.Sizeable(o.size(e)))}_content_size(){return this.content_size}}s.ContentBox=r,r.__name__="ContentBox";class _ extends a.Layoutable{constructor(e){super(),this.el=e}_measure(e){const t=new c.Sizeable(e).bounded_to(this.sizing.size);return o.sized(this.el,t,()=>{const e=new c.Sizeable(o.content_size(this.el)),{border:t,padding:s}=o.extents(this.el);return e.grow_by(t).grow_by(s).map(Math.ceil)})}}s.VariadicBox=_,_.__name__="VariadicBox";class h extends _{constructor(e){super(e),this._cache=new Map}_measure(e){const{width:t,height:s}=e,n=`${t},${s}`;let i=this._cache.get(n);return null==i&&(i=super._measure(e),this._cache.set(n,i)),i}invalidate_cache(){this._cache.clear()}}s.CachedVariadicBox=h,h.__name__="CachedVariadicBox"},
function _(u,m,n,s,S){s(),S("Expression",u(248).Expression),S("Stack",u(249).Stack),S("CumSum",u(250).CumSum)},
function _(e,t,s,n,i){n();const c=e(88);class _ extends c.Model{constructor(e){super(e)}initialize(){super.initialize(),this._connected=new Set,this._result=new Map}v_compute(e){this._connected.has(e)||(this.connect(e.change,()=>this._result.delete(e)),this.connect(e.patching,()=>this._result.delete(e)),this.connect(e.streaming,()=>this._result.delete(e)),this._connected.add(e));let t=this._result.get(e);return null==t&&(t=this._v_compute(e),this._result.set(e,t)),t}}s.Expression=_,_.__name__="Expression"},
function _(t,n,e,i,s){i();const r=t(248),c=t(24);class a extends r.Expression{constructor(t){super(t)}static init_Stack(){this.define(({String:t,Array:n})=>({fields:[n(t),[]]}))}_v_compute(t){var n;const e=null!==(n=t.get_length())&&void 0!==n?n:0,i=new c.NumberArray(e);for(const n of this.fields){const s=t.data[n];if(null!=s)for(let t=0,n=Math.min(e,s.length);t<n;t++)i[t]+=s[t]}return i}}e.Stack=a,a.__name__="Stack",a.init_Stack()},
function _(e,t,n,i,u){i();const r=e(248),o=e(24);class s extends r.Expression{constructor(e){super(e)}static init_CumSum(){this.define(({Boolean:e,String:t})=>({field:[t],include_zero:[e,!1]}))}_v_compute(e){var t;const n=new o.NumberArray(null!==(t=e.get_length())&&void 0!==t?t:0),i=e.data[this.field],u=this.include_zero?1:0;n[0]=this.include_zero?0:i[0];for(let e=1;e<n.length;e++)n[e]=n[e-1]+i[e-u];return n}}n.CumSum=s,s.__name__="CumSum",s.init_CumSum()},
function _(e,t,l,r,i){r(),i("BooleanFilter",e(252).BooleanFilter),i("CustomJSFilter",e(253).CustomJSFilter),i("Filter",e(122).Filter),i("GroupFilter",e(254).GroupFilter),i("IndexFilter",e(255).IndexFilter)},
function _(e,n,l,o,t){o();const i=e(122),s=e(24);class a extends i.Filter{constructor(e){super(e)}static init_BooleanFilter(){this.define(({Boolean:e,Array:n,Nullable:l})=>({booleans:[l(n(e)),null]}))}compute_indices(e){const n=e.length,{booleans:l}=this;return null==l?s.Indices.all_set(n):s.Indices.from_booleans(n,l)}}l.BooleanFilter=a,a.__name__="BooleanFilter",a.init_BooleanFilter()},
function _(e,t,s,n,r){n();const i=e(122),o=e(24),u=e(13),c=e(8),a=e(29);class l extends i.Filter{constructor(e){super(e)}static init_CustomJSFilter(){this.define(({Unknown:e,String:t,Dict:s})=>({args:[s(e),{}],code:[t,""]}))}get names(){return u.keys(this.args)}get values(){return u.values(this.args)}get func(){const e=a.use_strict(this.code);return new Function(...this.names,"source",e)}compute_indices(e){const t=e.length,s=this.func(...this.values,e);if(null==s)return o.Indices.all_set(t);if(c.isArrayOf(s,c.isInteger))return o.Indices.from_indices(t,s);if(c.isArrayOf(s,c.isBoolean))return o.Indices.from_booleans(t,s);throw new Error("expect an array of integers or booleans, or null, got "+s)}}s.CustomJSFilter=l,l.__name__="CustomJSFilter",l.init_CustomJSFilter()},
function _(n,t,e,i,o){i();const r=n(122),u=n(24),s=n(19);class c extends r.Filter{constructor(n){super(n)}static init_GroupFilter(){this.define(({String:n})=>({column_name:[n],group:[n]}))}compute_indices(n){const t=n.get_column(this.column_name);if(null==t)return s.logger.warn(`${this}: groupby column '${this.column_name}' not found in the data source`),new u.Indices(n.length,1);{const e=new u.Indices(n.length);for(let n=0;n<e.size;n++)t[n]===this.group&&e.set(n);return e}}}e.GroupFilter=c,c.__name__="GroupFilter",c.init_GroupFilter()},
function _(e,n,i,t,s){t();const l=e(122),c=e(24);class r extends l.Filter{constructor(e){super(e)}static init_IndexFilter(){this.define(({Int:e,Array:n,Nullable:i})=>({indices:[i(n(e)),null]}))}compute_indices(e){const n=e.length,{indices:i}=this;return null==i?c.Indices.all_set(n):c.Indices.from_indices(n,i)}}i.IndexFilter=r,r.__name__="IndexFilter",r.init_IndexFilter()},
function _(t,r,a,e,c){e(),c("BasicTickFormatter",t(143).BasicTickFormatter),c("CategoricalTickFormatter",t(209).CategoricalTickFormatter),c("DatetimeTickFormatter",t(213).DatetimeTickFormatter),c("FuncTickFormatter",t(257).FuncTickFormatter),c("LogTickFormatter",t(226).LogTickFormatter),c("MercatorTickFormatter",t(229).MercatorTickFormatter),c("NumeralTickFormatter",t(258).NumeralTickFormatter),c("PrintfTickFormatter",t(259).PrintfTickFormatter),c("TickFormatter",t(140).TickFormatter)},
function _(t,n,e,s,i){s();const r=t(140),c=t(13),a=t(29);class u extends r.TickFormatter{constructor(t){super(t)}static init_FuncTickFormatter(){this.define(({Unknown:t,String:n,Dict:e})=>({args:[e(t),{}],code:[n,""]}))}get names(){return c.keys(this.args)}get values(){return c.values(this.args)}_make_func(){const t=a.use_strict(this.code);return new Function("tick","index","ticks",...this.names,t)}doFormat(t,n){const e=this._make_func().bind({});return t.map((t,n,s)=>e(t,n,s,...this.values))}}e.FuncTickFormatter=u,u.__name__="FuncTickFormatter",u.init_FuncTickFormatter()},
function _(r,t,n,e,a){e();const o=r(1).__importStar(r(216)),i=r(140),u=r(20);class c extends i.TickFormatter{constructor(r){super(r)}static init_NumeralTickFormatter(){this.define(({String:r})=>({format:[r,"0,0"],language:[r,"en"],rounding:[u.RoundingFunction,"round"]}))}get _rounding_fn(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}doFormat(r,t){const{format:n,language:e,_rounding_fn:a}=this;return r.map(r=>o.format(r,n,e,a))}}n.NumeralTickFormatter=c,c.__name__="NumeralTickFormatter",c.init_NumeralTickFormatter()},
function _(t,r,i,n,o){n();const a=t(140),e=t(215);class c extends a.TickFormatter{constructor(t){super(t)}static init_PrintfTickFormatter(){this.define(({String:t})=>({format:[t,"%s"]}))}doFormat(t,r){return t.map(t=>e.sprintf(this.format,t))}}i.PrintfTickFormatter=c,c.__name__="PrintfTickFormatter",c.init_PrintfTickFormatter()},
function _(e,a,l,t,i){t(),i("AnnularWedge",e(261).AnnularWedge),i("Annulus",e(262).Annulus),i("Arc",e(263).Arc),i("Bezier",e(264).Bezier),i("Circle",e(265).Circle),i("CenterRotatable",e(269).CenterRotatable),i("Ellipse",e(270).Ellipse),i("EllipseOval",e(271).EllipseOval),i("Glyph",e(95).Glyph),i("HArea",e(118).HArea),i("HBar",e(272).HBar),i("HexTile",e(274).HexTile),i("Image",e(275).Image),i("ImageRGBA",e(279).ImageRGBA),i("ImageURL",e(280).ImageURL),i("Line",e(105).Line),i("MultiLine",e(127).MultiLine),i("MultiPolygons",e(282).MultiPolygons),i("Oval",e(283).Oval),i("Patch",e(117).Patch),i("Patches",e(128).Patches),i("Quad",e(284).Quad),i("Quadratic",e(285).Quadratic),i("Ray",e(286).Ray),i("Rect",e(287).Rect),i("Segment",e(288).Segment),i("Step",e(289).Step),i("Text",e(290).Text),i("VArea",e(120).VArea),i("VBar",e(291).VBar),i("Wedge",e(292).Wedge),i("XYGlyph",e(106).XYGlyph)},
function _(e,t,s,i,r){i();const n=e(1),a=e(106),_=e(107),o=e(28),h=e(24),d=e(20),l=n.__importStar(e(18)),u=e(10),c=e(94);class g extends a.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius,this._angle=new h.NumberArray(this._start_angle.length);for(let e=0,t=this._start_angle.length;e<t;e++)this._angle[e]=this._end_angle[e]-this._start_angle[e]}_render(e,t,{sx:s,sy:i,_start_angle:r,_angle:n,sinner_radius:a,souter_radius:_}){const o="anticlock"==this.model.direction;for(const h of t)isNaN(s[h]+i[h]+a[h]+_[h]+r[h]+n[h])||(e.translate(s[h],i[h]),e.rotate(r[h]),e.beginPath(),e.moveTo(_[h],0),e.arc(0,0,_[h],0,n[h],o),e.rotate(n[h]),e.lineTo(a[h],0),e.arc(0,0,a[h],0,-n[h],!o),e.closePath(),e.rotate(-n[h]-r[h]),e.translate(-s[h],-i[h]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,h),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,h),e.stroke()))}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s);let n,a,_,o;if("data"==this.model.properties.outer_radius.units)n=i-this.max_outer_radius,_=i+this.max_outer_radius,a=r-this.max_outer_radius,o=r+this.max_outer_radius;else{const e=t-this.max_outer_radius,i=t+this.max_outer_radius;[n,_]=this.renderer.xscale.r_invert(e,i);const r=s-this.max_outer_radius,h=s+this.max_outer_radius;[a,o]=this.renderer.yscale.r_invert(r,h)}const h=[];for(const e of this.index.indices({x0:n,x1:_,y0:a,y1:o})){const t=this.souter_radius[e]**2,s=this.sinner_radius[e]**2,[n,a]=this.renderer.xscale.r_compute(i,this._x[e]),[_,o]=this.renderer.yscale.r_compute(r,this._y[e]),d=(n-a)**2+(_-o)**2;d<=t&&d>=s&&h.push(e)}const d="anticlock"==this.model.direction,l=[];for(const e of h){const i=Math.atan2(s-this.sy[e],t-this.sx[e]);u.angle_between(-i,-this._start_angle[e],-this._end_angle[e],d)&&l.push(e)}return new c.Selection({indices:l})}draw_legend_for_index(e,t,s){_.generic_area_legend(this.visuals,e,t,s)}scenterxy(e){const t=(this.sinner_radius[e]+this.souter_radius[e])/2,s=(this._start_angle[e]+this._end_angle[e])/2;return[this.sx[e]+t*Math.cos(s),this.sy[e]+t*Math.sin(s)]}}s.AnnularWedgeView=g,g.__name__="AnnularWedgeView";class x extends a.XYGlyph{constructor(e){super(e)}static init_AnnularWedge(){this.prototype.default_view=g,this.mixins([o.LineVector,o.FillVector]),this.define(({})=>({direction:[d.Direction,"anticlock"],inner_radius:[l.DistanceSpec],outer_radius:[l.DistanceSpec],start_angle:[l.AngleSpec],end_angle:[l.AngleSpec]}))}}s.AnnularWedge=x,x.__name__="AnnularWedge",x.init_AnnularWedge()},
function _(s,i,t,e,r){e();const n=s(1),a=s(106),_=s(28),u=n.__importStar(s(18)),o=s(82),h=s(94);class d extends a.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius}_render(s,i,{sx:t,sy:e,sinner_radius:r,souter_radius:n}){for(const a of i)if(!isNaN(t[a]+e[a]+r[a]+n[a])){if(this.visuals.fill.doit){if(this.visuals.fill.set_vectorize(s,a),s.beginPath(),o.is_ie)for(const i of[!1,!0])s.arc(t[a],e[a],r[a],0,Math.PI,i),s.arc(t[a],e[a],n[a],Math.PI,0,!i);else s.arc(t[a],e[a],r[a],0,2*Math.PI,!0),s.arc(t[a],e[a],n[a],2*Math.PI,0,!1);s.fill()}this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,a),s.beginPath(),s.arc(t[a],e[a],r[a],0,2*Math.PI),s.moveTo(t[a]+n[a],e[a]),s.arc(t[a],e[a],n[a],0,2*Math.PI),s.stroke())}}_hit_point(s){const{sx:i,sy:t}=s,e=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(t);let n,a,_,u;if("data"==this.model.properties.outer_radius.units)n=e-this.max_outer_radius,_=e+this.max_outer_radius,a=r-this.max_outer_radius,u=r+this.max_outer_radius;else{const s=i-this.max_outer_radius,e=i+this.max_outer_radius;[n,_]=this.renderer.xscale.r_invert(s,e);const r=t-this.max_outer_radius,o=t+this.max_outer_radius;[a,u]=this.renderer.yscale.r_invert(r,o)}const o=[];for(const s of this.index.indices({x0:n,x1:_,y0:a,y1:u})){const i=this.souter_radius[s]**2,t=this.sinner_radius[s]**2,[n,a]=this.renderer.xscale.r_compute(e,this._x[s]),[_,u]=this.renderer.yscale.r_compute(r,this._y[s]),h=(n-a)**2+(_-u)**2;h<=i&&h>=t&&o.push(s)}return new h.Selection({indices:o})}draw_legend_for_index(s,{x0:i,y0:t,x1:e,y1:r},n){const a=n+1,_=new Array(a);_[n]=(i+e)/2;const u=new Array(a);u[n]=(t+r)/2;const o=.5*Math.min(Math.abs(e-i),Math.abs(r-t)),h=new Array(a);h[n]=.4*o;const d=new Array(a);d[n]=.8*o,this._render(s,[n],{sx:_,sy:u,sinner_radius:h,souter_radius:d})}}t.AnnulusView=d,d.__name__="AnnulusView";class c extends a.XYGlyph{constructor(s){super(s)}static init_Annulus(){this.prototype.default_view=d,this.mixins([_.LineVector,_.FillVector]),this.define(({})=>({inner_radius:[u.DistanceSpec],outer_radius:[u.DistanceSpec]}))}}t.Annulus=c,c.__name__="Annulus",c.init_Annulus()},
function _(i,e,s,t,n){t();const r=i(1),a=i(106),_=i(107),c=i(28),d=i(20),l=r.__importStar(i(18));class o extends a.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius}_render(i,e,{sx:s,sy:t,sradius:n,_start_angle:r,_end_angle:a}){if(this.visuals.line.doit){const _="anticlock"==this.model.direction;for(const c of e)isNaN(s[c]+t[c]+n[c]+r[c]+a[c])||(i.beginPath(),i.arc(s[c],t[c],n[c],r[c],a[c],_),this.visuals.line.set_vectorize(i,c),i.stroke())}}draw_legend_for_index(i,e,s){_.generic_line_legend(this.visuals,i,e,s)}}s.ArcView=o,o.__name__="ArcView";class h extends a.XYGlyph{constructor(i){super(i)}static init_Arc(){this.prototype.default_view=o,this.mixins(c.LineVector),this.define(({})=>({direction:[d.Direction,"anticlock"],radius:[l.DistanceSpec],start_angle:[l.AngleSpec],end_angle:[l.AngleSpec]}))}}s.Arc=h,h.__name__="Arc",h.init_Arc()},
function _(e,t,i,s,n){s();const c=e(1),o=e(28),_=e(95),r=e(107),a=e(36),h=c.__importStar(e(18));function d(e,t,i,s,n,c,o,_){const r=[],a=[[],[]];for(let a=0;a<=2;a++){let h,d,x;if(0===a?(d=6*e-12*i+6*n,h=-3*e+9*i-9*n+3*o,x=3*i-3*e):(d=6*t-12*s+6*c,h=-3*t+9*s-9*c+3*_,x=3*s-3*t),Math.abs(h)<1e-12){if(Math.abs(d)<1e-12)continue;const e=-x/d;0<e&&e<1&&r.push(e);continue}const l=d*d-4*x*h,y=Math.sqrt(l);if(l<0)continue;const p=(-d+y)/(2*h);0<p&&p<1&&r.push(p);const f=(-d-y)/(2*h);0<f&&f<1&&r.push(f)}let h=r.length;const d=h;for(;h--;){const d=r[h],x=1-d,l=x*x*x*e+3*x*x*d*i+3*x*d*d*n+d*d*d*o;a[0][h]=l;const y=x*x*x*t+3*x*x*d*s+3*x*d*d*c+d*d*d*_;a[1][h]=y}return a[0][d]=e,a[1][d]=t,a[0][d+1]=o,a[1][d+1]=_,[Math.min(...a[0]),Math.max(...a[1]),Math.max(...a[0]),Math.min(...a[1])]}class x extends _.GlyphView{_project_data(){a.inplace.project_xy(this._x0,this._y0),a.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{data_size:t}=this;for(let i=0;i<t;i++)if(isNaN(this._x0[i]+this._x1[i]+this._y0[i]+this._y1[i]+this._cx0[i]+this._cy0[i]+this._cx1[i]+this._cy1[i]))e.add_empty();else{const[t,s,n,c]=d(this._x0[i],this._y0[i],this._x1[i],this._y1[i],this._cx0[i],this._cy0[i],this._cx1[i],this._cy1[i]);e.add(t,s,n,c)}}_render(e,t,{sx0:i,sy0:s,sx1:n,sy1:c,scx0:o,scy0:_,scx1:r,scy1:a}){if(this.visuals.line.doit)for(const h of t)isNaN(i[h]+s[h]+n[h]+c[h]+o[h]+_[h]+r[h]+a[h])||(e.beginPath(),e.moveTo(i[h],s[h]),e.bezierCurveTo(o[h],_[h],r[h],a[h],n[h],c[h]),this.visuals.line.set_vectorize(e,h),e.stroke())}draw_legend_for_index(e,t,i){r.generic_line_legend(this.visuals,e,t,i)}scenterxy(){throw new Error(this+".scenterxy() is not implemented")}}i.BezierView=x,x.__name__="BezierView";class l extends _.Glyph{constructor(e){super(e)}static init_Bezier(){this.prototype.default_view=x,this.define(({})=>({x0:[h.XCoordinateSpec,{field:"x0"}],y0:[h.YCoordinateSpec,{field:"y0"}],x1:[h.XCoordinateSpec,{field:"x1"}],y1:[h.YCoordinateSpec,{field:"y1"}],cx0:[h.XCoordinateSpec,{field:"cx0"}],cy0:[h.YCoordinateSpec,{field:"cy0"}],cx1:[h.XCoordinateSpec,{field:"cx1"}],cy1:[h.YCoordinateSpec,{field:"cy1"}]})),this.mixins(o.LineVector)}}i.Bezier=l,l.__name__="Bezier",l.init_Bezier()},
function _(s,i,e,t,r){t();const a=s(1),n=s(106),h=s(266),d=s(28),l=s(20),_=a.__importStar(s(108)),c=a.__importStar(s(18)),o=s(9),u=s(12),x=s(94);class m extends n.XYGlyphView{initialize(){super.initialize();const{webgl:s}=this.renderer.plot_view.canvas_view;null!=s&&(this.glglyph=new h.CircleGL(s.gl,this))}_map_data(){if(null!=this._radius)if("data"==this.model.properties.radius.units)switch(this.model.radius_dimension){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this._radius);break;case"max":{const s=this.sdist(this.renderer.xscale,this._x,this._radius),i=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=u.map(s,(s,e)=>Math.max(s,i[e]));break}case"min":{const s=this.sdist(this.renderer.xscale,this._x,this._radius),i=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=u.map(s,(s,e)=>Math.min(s,i[e]));break}}else this.sradius=this._radius,this.max_size=2*this.max_radius;else this.sradius=u.map(this._size,s=>s/2)}_mask_data(){const{frame:s}=this.renderer.plot_view,i=s.x_target,e=s.y_target;let t,r;return null!=this._radius&&"data"==this.model.properties.radius.units?(t=i.map(s=>this.renderer.xscale.invert(s)).widen(this.max_radius),r=e.map(s=>this.renderer.yscale.invert(s)).widen(this.max_radius)):(t=i.widen(this.max_size).map(s=>this.renderer.xscale.invert(s)),r=e.widen(this.max_size).map(s=>this.renderer.yscale.invert(s))),this.index.indices({x0:t.start,x1:t.end,y0:r.start,y1:r.end})}_render(s,i,{sx:e,sy:t,sradius:r}){for(const a of i)isNaN(e[a]+t[a]+r[a])||(s.beginPath(),s.arc(e[a],t[a],r[a],0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(s,a),s.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,a),s.stroke()))}_hit_point(s){const{sx:i,sy:e}=s,t=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(e);let a,n,h,d;if(null!=this._radius&&"data"==this.model.properties.radius.units)a=t-this.max_radius,n=t+this.max_radius,h=r-this.max_radius,d=r+this.max_radius;else{const s=i-this.max_size,t=i+this.max_size;[a,n]=this.renderer.xscale.r_invert(s,t);const r=e-this.max_size,l=e+this.max_size;[h,d]=this.renderer.yscale.r_invert(r,l)}const l=this.index.indices({x0:a,x1:n,y0:h,y1:d}),_=[];if(null!=this._radius&&"data"==this.model.properties.radius.units)for(const s of l){const i=this.sradius[s]**2,[e,a]=this.renderer.xscale.r_compute(t,this._x[s]),[n,h]=this.renderer.yscale.r_compute(r,this._y[s]);(e-a)**2+(n-h)**2<=i&&_.push(s)}else for(const s of l){const t=this.sradius[s]**2;(this.sx[s]-i)**2+(this.sy[s]-e)**2<=t&&_.push(s)}return new x.Selection({indices:_})}_hit_span(s){const{sx:i,sy:e}=s,t=this.bounds();let r,a,n,h;if("h"==s.direction){let s,e;if(n=t.y0,h=t.y1,null!=this._radius&&"data"==this.model.properties.radius.units)s=i-this.max_radius,e=i+this.max_radius,[r,a]=this.renderer.xscale.r_invert(s,e);else{const t=this.max_size/2;s=i-t,e=i+t,[r,a]=this.renderer.xscale.r_invert(s,e)}}else{let s,i;if(r=t.x0,a=t.x1,null!=this._radius&&"data"==this.model.properties.radius.units)s=e-this.max_radius,i=e+this.max_radius,[n,h]=this.renderer.yscale.r_invert(s,i);else{const t=this.max_size/2;s=e-t,i=e+t,[n,h]=this.renderer.yscale.r_invert(s,i)}}const d=[...this.index.indices({x0:r,x1:a,y0:n,y1:h})];return new x.Selection({indices:d})}_hit_rect(s){const{sx0:i,sx1:e,sy0:t,sy1:r}=s,[a,n]=this.renderer.xscale.r_invert(i,e),[h,d]=this.renderer.yscale.r_invert(t,r),l=[...this.index.indices({x0:a,x1:n,y0:h,y1:d})];return new x.Selection({indices:l})}_hit_poly(s){const{sx:i,sy:e}=s,t=o.range(0,this.sx.length),r=[];for(let s=0,a=t.length;s<a;s++){const a=t[s];_.point_in_poly(this.sx[s],this.sy[s],i,e)&&r.push(a)}return new x.Selection({indices:r})}draw_legend_for_index(s,{x0:i,y0:e,x1:t,y1:r},a){const n=a+1,h=new Array(n);h[a]=(i+t)/2;const d=new Array(n);d[a]=(e+r)/2;const l=new Array(n);l[a]=.2*Math.min(Math.abs(t-i),Math.abs(r-e)),this._render(s,[a],{sx:h,sy:d,sradius:l})}}e.CircleView=m,m.__name__="CircleView";class y extends n.XYGlyph{constructor(s){super(s)}static init_Circle(){this.prototype.default_view=m,this.mixins([d.LineVector,d.FillVector]),this.define(({})=>({angle:[c.AngleSpec,0],size:[c.ScreenDistanceSpec,{value:4}],radius:[c.DistanceSpec,void 0,{optional:!0}],radius_dimension:[l.RadiusDimension,"x"]}))}}e.Circle=y,y.__name__="Circle",y.init_Circle()},
function _(t,e,s,i,a){i();const r=t(1),o=t(110),_=t(114),l=t(267),h=t(268),n=t(265),g=t(12),f=t(19),u=t(22);function d(t,e,s,i,a,r){if(a.doit)if(a[r].is_value)e.used=!1,t.set_attribute(s,"float",[a[r].value()]);else{e.used=!0;const o=new Float32Array(a.get_array(r));e.set_size(4*i),e.set_data(0,o),t.set_attribute(s,"float",e)}else e.used=!1,t.set_attribute(s,"float",[0])}function b(t,e,s,i,a,r){const o=r+"_color",_=r+"_alpha";if(a.doit){let r,l;if(e.used=!0,a[o].is_value){const t=u.encode_rgba(u.color2rgba(a[o].value())),e=new Uint32Array(i);e.fill(t),r=e}else r=a.get_array(o);if(a[_].is_value){const t=a[_].value(),e=new Float32Array(i);e.fill(t),l=e}else l=a.get_array(_);const h=new Float32Array(4*i);for(let t=0,e=i;t<e;t++){const e=u.decode_rgba(r[t]);1==e[3]&&(e[3]=l[t]),h.set(e,4*t)}e.set_size(4*i*4),e.set_data(0,h),t.set_attribute(s,"vec4",e)}else e.used=!1,t.set_attribute(s,"vec4",[0,0,0,0])}s.attach_float=d,s.attach_color=b;class c extends _.BaseGLGlyph{init(){const{gl:t}=this,e=l.vertex_shader,s=h.fragment_shader(this._marker_code);this.prog=new o.Program(t),this.prog.set_shaders(e,s),this.vbo_sx=new o.VertexBuffer(t),this.prog.set_attribute("a_sx","float",this.vbo_sx),this.vbo_sy=new o.VertexBuffer(t),this.prog.set_attribute("a_sy","float",this.vbo_sy),this.vbo_s=new o.VertexBuffer(t),this.prog.set_attribute("a_size","float",this.vbo_s),this.vbo_a=new o.VertexBuffer(t),this.prog.set_attribute("a_angle","float",this.vbo_a),this.vbo_linewidth=new o.VertexBuffer(t),this.vbo_fg_color=new o.VertexBuffer(t),this.vbo_bg_color=new o.VertexBuffer(t),this.index_buffer=new o.IndexBuffer(t)}draw(t,e,s){const i=e.glglyph,{nvertices:a}=i;if(i.data_changed&&(i._set_data(a),this.glyph instanceof n.CircleView&&null!=this.glyph._radius&&this.vbo_s.set_data(0,g.map(this.glyph.sradius,t=>2*t)),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(a),this.visuals_changed=!1),this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_attribute("a_sx","float",i.vbo_sx),this.prog.set_attribute("a_sy","float",i.vbo_sy),this.prog.set_attribute("a_size","float",i.vbo_s),this.prog.set_attribute("a_angle","float",i.vbo_a),0!=t.length)if(t.length===a)this.prog.draw(this.gl.POINTS,[0,a]);else if(a<65535){const e=window.navigator.userAgent;e.indexOf("MSIE ")+e.indexOf("Trident/")+e.indexOf("Edge/")>0&&f.logger.warn("WebGL warning: IE is known to produce 1px sprites whith selections."),this.index_buffer.set_size(2*t.length),this.index_buffer.set_data(0,new Uint16Array(t)),this.prog.draw(this.gl.POINTS,this.index_buffer)}else{const e=64e3,s=[];for(let t=0,i=Math.ceil(a/e);t<i;t++)s.push([]);for(let i=0,a=t.length;i<a;i++){const a=t[i]%e;s[Math.floor(t[i]/e)].push(a)}for(let t=0,a=s.length;t<a;t++){const a=new Uint16Array(s[t]),r=t*e*4;0!==a.length&&(this.prog.set_attribute("a_sx","float",i.vbo_sx,0,r),this.prog.set_attribute("a_sy","float",i.vbo_sy,0,r),this.prog.set_attribute("a_size","float",i.vbo_s,0,r),this.prog.set_attribute("a_angle","float",i.vbo_a,0,r),this.vbo_linewidth.used&&this.prog.set_attribute("a_linewidth","float",this.vbo_linewidth,0,r),this.vbo_fg_color.used&&this.prog.set_attribute("a_fg_color","vec4",this.vbo_fg_color,0,4*r),this.vbo_bg_color.used&&this.prog.set_attribute("a_bg_color","vec4",this.vbo_bg_color,0,4*r),this.index_buffer.set_size(2*a.length),this.index_buffer.set_data(0,a),this.prog.draw(this.gl.POINTS,this.index_buffer))}}}_set_data(t){const e=4*t;this.vbo_sx.set_size(e),this.vbo_sy.set_size(e),this.vbo_a.set_size(e),this.vbo_s.set_size(e),this.vbo_sx.set_data(0,this.glyph.sx),this.vbo_sy.set_data(0,this.glyph.sy),null!=this.glyph._angle&&this.vbo_a.set_data(0,new Float32Array(this.glyph._angle)),this.glyph instanceof n.CircleView&&null!=this.glyph._radius?this.vbo_s.set_data(0,g.map(this.glyph.sradius,t=>2*t)):this.vbo_s.set_data(0,new Float32Array(this.glyph._size))}_set_visuals(t){d(this.prog,this.vbo_linewidth,"a_linewidth",t,this.glyph.visuals.line,"line_width"),b(this.prog,this.vbo_fg_color,"a_fg_color",t,this.glyph.visuals.line,"line"),b(this.prog,this.vbo_bg_color,"a_bg_color",t,this.glyph.visuals.fill,"fill"),this.prog.set_uniform("u_antialias","float",[.8])}}function v(t){return class extends c{get _marker_code(){return t}}}s.MarkerGL=c,c.__name__="MarkerGL";const p=r.__importStar(t(268));s.AsteriskGL=v(p.asterisk),s.CircleGL=v(p.circle),s.CircleCrossGL=v(p.circlecross),s.CircleXGL=v(p.circlex),s.CrossGL=v(p.cross),s.DiamondGL=v(p.diamond),s.DiamondCrossGL=v(p.diamondcross),s.HexGL=v(p.hex),s.InvertedTriangleGL=v(p.invertedtriangle),s.SquareGL=v(p.square),s.SquareCrossGL=v(p.squarecross),s.SquareXGL=v(p.squarex),s.TriangleGL=v(p.triangle),s.XGL=v(p.x)},
function _(n,i,a,o,_){o(),a.vertex_shader="\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\n//\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform vec2 u_offset;\nuniform vec2 u_scale;\nuniform float u_antialias;\n//\nattribute float a_sx;\nattribute float a_sy;\nattribute float a_size;\nattribute float a_angle;  // in radians\nattribute float a_linewidth;\nattribute vec4  a_fg_color;\nattribute vec4  a_bg_color;\n//\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying vec2  v_rotation;\n\nvoid main (void)\n{\n    v_size = a_size * u_pixel_ratio;\n    v_linewidth = a_linewidth * u_pixel_ratio;\n    v_fg_color = a_fg_color;\n    v_bg_color = a_bg_color;\n    v_rotation = vec2(cos(-a_angle), sin(-a_angle));\n    vec2 pos = vec2(a_sx, a_sy);  // in pixels\n    pos += 0.5;  // make up for Bokeh's offset\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(pos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n    gl_PointSize = SQRT_2 * v_size + 2.0 * (v_linewidth + 1.5*u_antialias);\n}\n"},
function _(a,n,s,o,t){o(),s.fragment_shader=a=>`\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\nconst float PI = 3.14159265358979323846264;\n//\nuniform float u_antialias;\n//\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec2  v_rotation;\n\n${a}\n\nvec4 outline(float distance, float linewidth, float antialias, vec4 fg_color, vec4 bg_color)\n{\n    vec4 frag_color;\n    float t = linewidth/2.0 - antialias;\n    float signed_distance = distance;\n    float border_distance = abs(signed_distance) - t;\n    float alpha = border_distance/antialias;\n    alpha = exp(-alpha*alpha);\n\n    // If fg alpha is zero, it probably means no outline. To avoid a dark outline\n    // shining through due to aa, we set the fg color to the bg color. Avoid if (i.e. branching).\n    float select = float(bool(fg_color.a));\n    fg_color.rgb = select * fg_color.rgb + (1.0  - select) * bg_color.rgb;\n    // Similarly, if we want a transparent bg\n    select = float(bool(bg_color.a));\n    bg_color.rgb = select * bg_color.rgb + (1.0  - select) * fg_color.rgb;\n\n    if( border_distance < 0.0)\n        frag_color = fg_color;\n    else if( signed_distance < 0.0 ) {\n        frag_color = mix(bg_color, fg_color, sqrt(alpha));\n    } else {\n        if( abs(signed_distance) < (linewidth/2.0 + antialias) ) {\n            frag_color = vec4(fg_color.rgb, fg_color.a * alpha);\n        } else {\n            discard;\n        }\n    }\n    return frag_color;\n}\n\nvoid main()\n{\n    vec2 P = gl_PointCoord.xy - vec2(0.5, 0.5);\n    P = vec2(v_rotation.x*P.x - v_rotation.y*P.y,\n             v_rotation.y*P.x + v_rotation.x*P.y);\n    float point_size = SQRT_2*v_size  + 2.0 * (v_linewidth + 1.5*u_antialias);\n    float distance = marker(P*point_size, v_size);\n    gl_FragColor = outline(distance, v_linewidth, u_antialias, v_fg_color, v_bg_color);\n}\n`,s.circle="\nfloat marker(vec2 P, float size)\n{\n    return length(P) - size/2.0;\n}\n",s.square="\nfloat marker(vec2 P, float size)\n{\n    return max(abs(P.x), abs(P.y)) - size/2.0;\n}\n",s.diamond="\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    return r1 / SQRT_2;\n}\n",s.hex="\nfloat marker(vec2 P, float size)\n{\n    vec2 q = abs(P);\n    return max(q.y * 0.57735 + q.x - 1.0 * size/2.0, q.y - 0.866 * size/2.0);\n}\n",s.triangle="\nfloat marker(vec2 P, float size)\n{\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n",s.invertedtriangle="\nfloat marker(vec2 P, float size)\n{\n    P.y += size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = - P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n",s.cross='\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.5;   // 2.5 is a tweak\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(square, cross);\n}\n',s.circlecross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.squarecross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.diamondcross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float diamond = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    diamond /= SQRT_2;\n    float c1 = max(diamond, s1);\n    float c2 = max(diamond, s2);\n    float c3 = max(diamond, s3);\n    float c4 = max(diamond, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.x='\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 1.6;\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(circle, X);\n}\n',s.circlex='\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    float almost = min(min(min(c1, c2), c3), c4);\n    // In this case, the X is also outside of the main shape\n    float Xmask = length(P) - size / 1.6;  // a circle\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return min(max(X, Xmask), almost);\n}\n',s.squarex="\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.asterisk='\nfloat marker(vec2 P, float size)\n{\n    // Masks\n    float diamond = max(abs(SQRT_2 / 2.0 * (P.x - P.y)), abs(SQRT_2 / 2.0 * (P.x + P.y))) - size / (2.0 * SQRT_2);\n    float square = max(abs(P.x), abs(P.y)) - size / (2.0 * SQRT_2);\n    // Shapes\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    // Result is union of masked shapes\n    return min(max(X, diamond), max(cross, square));\n}\n'},
function _(e,t,n,a,i){a();const s=e(1),c=e(106),l=e(28),o=s.__importStar(e(18));class r extends c.XYGlyphView{}n.CenterRotatableView=r,r.__name__="CenterRotatableView";class _ extends c.XYGlyph{constructor(e){super(e)}static init_CenterRotatable(){this.mixins([l.LineVector,l.FillVector]),this.define(({})=>({angle:[o.AngleSpec,0],width:[o.DistanceSpec],height:[o.DistanceSpec]}))}}n.CenterRotatable=_,_.__name__="CenterRotatable",_.init_CenterRotatable()},
function _(e,l,i,s,t){s();const _=e(271);class p extends _.EllipseOvalView{}i.EllipseView=p,p.__name__="EllipseView";class n extends _.EllipseOval{constructor(e){super(e)}static init_Ellipse(){this.prototype.default_view=p}}i.Ellipse=n,n.__name__="Ellipse",n.init_Ellipse()},
function _(t,s,i,e,h){e();const a=t(1),r=t(269),n=a.__importStar(t(108)),_=t(94);class l extends r.CenterRotatableView{_set_data(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)}_map_data(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"):this.sw=this._width,"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height}_render(t,s,{sx:i,sy:e,sw:h,sh:a,_angle:r}){for(const n of s)isNaN(i[n]+e[n]+h[n]+a[n]+r[n])||(t.beginPath(),t.ellipse(i[n],e[n],h[n]/2,a[n]/2,r[n],0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,n),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,n),t.stroke()))}_hit_point(t){let s,i,e,h,a,r,l,d,o;const{sx:x,sy:m}=t,w=this.renderer.xscale.invert(x),c=this.renderer.yscale.invert(m);"data"==this.model.properties.width.units?(s=w-this.max_width,i=w+this.max_width):(r=x-this.max_width,l=x+this.max_width,[s,i]=this.renderer.xscale.r_invert(r,l)),"data"==this.model.properties.height.units?(e=c-this.max_height,h=c+this.max_height):(d=m-this.max_height,o=m+this.max_height,[e,h]=this.renderer.yscale.r_invert(d,o));const p=this.index.indices({x0:s,x1:i,y0:e,y1:h}),y=[];for(const t of p)a=n.point_in_ellipse(x,m,this._angle[t],this.sh[t]/2,this.sw[t]/2,this.sx[t],this.sy[t]),a&&y.push(t);return new _.Selection({indices:y})}draw_legend_for_index(t,{x0:s,y0:i,x1:e,y1:h},a){const r=a+1,n=new Array(r);n[a]=(s+e)/2;const _=new Array(r);_[a]=(i+h)/2;const l=this.sw[a]/this.sh[a],d=.8*Math.min(Math.abs(e-s),Math.abs(h-i)),o=new Array(r),x=new Array(r);l>1?(o[a]=d,x[a]=d/l):(o[a]=d*l,x[a]=d),this._render(t,[a],{sx:n,sy:_,sw:o,sh:x,_angle:[0]})}_bounds({x0:t,x1:s,y0:i,y1:e}){return{x0:t-this.max_w2,x1:s+this.max_w2,y0:i-this.max_h2,y1:e+this.max_h2}}}i.EllipseOvalView=l,l.__name__="EllipseOvalView";class d extends r.CenterRotatable{constructor(t){super(t)}}i.EllipseOval=d,d.__name__="EllipseOval"},
function _(t,s,e,i,h){i();const r=t(1),_=t(273),a=t(24),n=r.__importStar(t(18));class o extends _.BoxView{scenterxy(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]}_lrtb(t){return[Math.min(this._left[t],this._right[t]),Math.max(this._left[t],this._right[t]),this._y[t]+.5*this._height[t],this._y[t]-.5*this._height[t]]}_map_data(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);const t=this.sy.length;this.stop=new a.NumberArray(t),this.sbottom=new a.NumberArray(t);for(let s=0;s<t;s++)this.stop[s]=this.sy[s]-this.sh[s]/2,this.sbottom[s]=this.sy[s]+this.sh[s]/2;this._clamp_viewport()}}e.HBarView=o,o.__name__="HBarView";class c extends _.Box{constructor(t){super(t)}static init_HBar(){this.prototype.default_view=o,this.define(({})=>({left:[n.XCoordinateSpec,{value:0}],y:[n.YCoordinateSpec,{field:"y"}],height:[n.NumberSpec,{value:1}],right:[n.XCoordinateSpec,{field:"right"}]}))}}e.HBar=c,c.__name__="HBar",c.init_HBar()},
function _(t,e,i,s,r){s();const n=t(28),h=t(95),a=t(107),o=t(94);class c extends h.GlyphView{get_anchor_point(t,e,i){const s=Math.min(this.sleft[e],this.sright[e]),r=Math.max(this.sright[e],this.sleft[e]),n=Math.min(this.stop[e],this.sbottom[e]),h=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:s,y:n};case"top_center":return{x:(s+r)/2,y:n};case"top_right":return{x:r,y:n};case"bottom_left":return{x:s,y:h};case"bottom_center":return{x:(s+r)/2,y:h};case"bottom_right":return{x:r,y:h};case"center_left":return{x:s,y:(n+h)/2};case"center":return{x:(s+r)/2,y:(n+h)/2};case"center_right":return{x:r,y:(n+h)/2};default:return null}}_index_data(t){const{min:e,max:i}=Math,{data_size:s}=this;for(let r=0;r<s;r++){const[s,n,h,a]=this._lrtb(r);isNaN(s+n+h+a)||!isFinite(s+n+h+a)?t.add_empty():t.add(e(s,n),e(h,a),i(n,s),i(h,a))}}_render(t,e,{sleft:i,sright:s,stop:r,sbottom:n}){for(const h of e)isNaN(i[h]+r[h]+s[h]+n[h])||(t.rect(i[h],r[h],s[h]-i[h],n[h]-r[h]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,h),t.beginPath(),t.rect(i[h],r[h],s[h]-i[h],n[h]-r[h]),t.fill()),this.visuals.hatch.doit2(t,h,()=>{t.beginPath(),t.rect(i[h],r[h],s[h]-i[h],n[h]-r[h]),t.fill()},()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,h),t.beginPath(),t.rect(i[h],r[h],s[h]-i[h],n[h]-r[h]),t.stroke()))}_clamp_viewport(){const t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,i=this.stop.length;for(let s=0;s<i;s++)this.stop[s]=Math.max(this.stop[s],e.start),this.sbottom[s]=Math.min(this.sbottom[s],e.end),this.sleft[s]=Math.max(this.sleft[s],t.start),this.sright[s]=Math.min(this.sright[s],t.end)}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const{sx:e,sy:i}=t,s=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),n=[...this.index.indices({x0:s,y0:r,x1:s,y1:r})];return new o.Selection({indices:n})}_hit_span(t){const{sx:e,sy:i}=t;let s;if("v"==t.direction){const t=this.renderer.yscale.invert(i),e=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(e.start,e.end);s=[...this.index.indices({x0:r,y0:t,x1:n,y1:t})]}else{const t=this.renderer.xscale.invert(e),i=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(i.start,i.end);s=[...this.index.indices({x0:t,y0:r,x1:t,y1:n})]}return new o.Selection({indices:s})}draw_legend_for_index(t,e,i){a.generic_area_legend(this.visuals,t,e,i)}}i.BoxView=c,c.__name__="BoxView";class _ extends h.Glyph{constructor(t){super(t)}static init_Box(){this.mixins([n.LineVector,n.FillVector,n.HatchVector])}}i.Box=_,_.__name__="Box",_.init_Box()},
function _(e,t,s,i,r){i();const n=e(1),a=e(95),o=n.__importStar(e(108)),c=n.__importStar(e(18)),h=e(28),_=e(24),l=e(20),d=e(36),x=e(107),p=e(94);class y extends a.GlyphView{scenterxy(e){return[this.sx[e],this.sy[e]]}_set_data(){const e=this._q.length,{orientation:t,size:s,aspect_scale:i}=this.model;this._x=new _.NumberArray(e),this._y=new _.NumberArray(e);const r=Math.sqrt(3);if("pointytop"==t)for(let t=0;t<e;t++)this._x[t]=s*r*(this._q[t]+this._r[t]/2)/i,this._y[t]=3*-s/2*this._r[t];else for(let t=0;t<e;t++)this._x[t]=3*s/2*this._q[t],this._y[t]=-s*r*(this._r[t]+this._q[t]/2)*i}_project_data(){d.inplace.project_xy(this._x,this._y)}_index_data(e){let t=this.model.size,s=Math.sqrt(3)*t/2;"flattop"==this.model.orientation?([s,t]=[t,s],t*=this.model.aspect_scale):s/=this.model.aspect_scale;const{data_size:i}=this;for(let r=0;r<i;r++){const i=this._x[r],n=this._y[r];isNaN(i+n)||!isFinite(i+n)?e.add_empty():e.add(i-s,n-t,i+s,n+t)}}map_data(){[this.sx,this.sy]=this.renderer.coordinates.map_to_screen(this._x,this._y),[this.svx,this.svy]=this._get_unscaled_vertices()}_get_unscaled_vertices(){const e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){const s=this.renderer.yscale,i=this.renderer.xscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t,a=r/2;return[[0,-n,-n,0,n,n],[r,a,-a,-r,-a,a]]}{const s=this.renderer.xscale,i=this.renderer.yscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t,a=r/2;return[[r,a,-a,-r,-a,a],[0,-n,-n,0,n,n]]}}_render(e,t,{sx:s,sy:i,svx:r,svy:n,_scale:a}){for(const o of t)if(!isNaN(s[o]+i[o]+a[o])){e.translate(s[o],i[o]),e.beginPath();for(let t=0;t<6;t++)e.lineTo(r[t]*a[o],n[t]*a[o]);e.closePath(),e.translate(-s[o],-i[o]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,o),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,o),e.stroke())}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s),n=this.index.indices({x0:i,y0:r,x1:i,y1:r}),a=[];for(const e of n)o.point_in_poly(t-this.sx[e],s-this.sy[e],this.svx,this.svy)&&a.push(e);return new p.Selection({indices:a})}_hit_span(e){const{sx:t,sy:s}=e;let i;if("v"==e.direction){const e=this.renderer.yscale.invert(s),t=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(t.start,t.end);i=[...this.index.indices({x0:r,y0:e,x1:n,y1:e})]}else{const e=this.renderer.xscale.invert(t),s=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(s.start,s.end);i=[...this.index.indices({x0:e,y0:r,x1:e,y1:n})]}return new p.Selection({indices:i})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:r}=e,[n,a]=this.renderer.xscale.r_invert(t,s),[o,c]=this.renderer.yscale.r_invert(i,r),h=[...this.index.indices({x0:n,x1:a,y0:o,y1:c})];return new p.Selection({indices:h})}draw_legend_for_index(e,t,s){x.generic_area_legend(this.visuals,e,t,s)}}s.HexTileView=y,y.__name__="HexTileView";class u extends a.Glyph{constructor(e){super(e)}static init_HexTile(){this.prototype.default_view=y,this.mixins([h.LineVector,h.FillVector]),this.define(({Number:e})=>({r:[c.NumberSpec],q:[c.NumberSpec],size:[e,1],aspect_scale:[e,1],scale:[c.NumberSpec,1],orientation:[l.HexTileOrientation,"pointytop"]})),this.override({line_color:null})}}s.HexTile=u,u.__name__="HexTile",u.init_HexTile()},
function _(e,a,t,_,i){_();const s=e(276),n=e(145),r=e(153);class o extends s.ImageBaseView{connect_signals(){super.connect_signals(),this.connect(this.model.color_mapper.change,()=>this._update_image())}_update_image(){null!=this.image_data&&(this._set_data(null),this.renderer.plot_view.request_render())}_flat_img_to_buf8(e){return this.model.color_mapper.rgba_mapper.v_compute(e)}}t.ImageView=o,o.__name__="ImageView";class m extends s.ImageBase{constructor(e){super(e)}static init_Image(){this.prototype.default_view=o,this.define(({Ref:e})=>({color_mapper:[e(n.ColorMapper),()=>new r.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})]}))}}t.Image=m,m.__name__="Image",m.init_Image()},
function _(e,t,s,i,a){i();const h=e(1),_=e(106),n=e(24),r=h.__importStar(e(18)),d=e(94),l=e(9),g=e(277),c=e(11);class o extends _.XYGlyphView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,()=>this.renderer.request_render())}_render(e,t,{image_data:s,sx:i,sy:a,sw:h,sh:_}){const n=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;for(const n of t){if(null==s[n]||isNaN(i[n]+a[n]+h[n]+_[n]))continue;const t=a[n];e.translate(0,t),e.scale(1,-1),e.translate(0,-t),e.drawImage(s[n],0|i[n],0|a[n],h[n],_[n]),e.translate(0,t),e.scale(1,-1),e.translate(0,-t)}e.setImageSmoothingEnabled(n)}_set_data(e){this._set_width_heigh_data();for(let t=0,s=this._image.length;t<s;t++){if(null!=e&&e.indexOf(t)<0)continue;const s=this._image[t];let i;g.is_NDArray(s)?(c.assert(2==s.dimension,"expected a 2D array"),i=s,this._height[t]=s.shape[0],this._width[t]=s.shape[1]):(i=l.concat(s),this._height[t]=s.length,this._width[t]=s[0].length);const a=this._flat_img_to_buf8(i);this._set_image_data_from_buffer(t,a)}}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const[t,i,a,h]=this._lrtb(s);isNaN(t+i+a+h)||!isFinite(t+i+a+h)?e.add_empty():e.add(t,h,i,a)}}_lrtb(e){const t=this.renderer.xscale.source_range,s=this._x[e],i=t.is_reversed?s-this._dw[e]:s+this._dw[e],a=this.renderer.yscale.source_range,h=this._y[e],_=a.is_reversed?h-this._dh[e]:h+this._dh[e],[n,r]=s<i?[s,i]:[i,s],[d,l]=h<_?[h,_]:[_,h];return[n,r,l,d]}_set_width_heigh_data(){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new n.NumberArray(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new n.NumberArray(this._image.length))}_get_or_create_canvas(e){const t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;{const t=document.createElement("canvas");return t.width=this._width[e],t.height=this._height[e],t}}_set_image_data_from_buffer(e,t){const s=this._get_or_create_canvas(e),i=s.getContext("2d"),a=i.getImageData(0,0,this._width[e],this._height[e]);a.data.set(t),i.putImageData(a,0,0),this.image_data[e]=s}_map_data(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}}_image_index(e,t,s){const[i,a,h,_]=this._lrtb(e),n=this._width[e],r=this._height[e],d=(a-i)/n,l=(h-_)/r;let g=Math.floor((t-i)/d),c=Math.floor((s-_)/l);return this.renderer.xscale.source_range.is_reversed&&(g=n-g-1),this.renderer.yscale.source_range.is_reversed&&(c=r-c-1),{index:e,dim1:g,dim2:c,flat_index:c*n+g}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),a=this.renderer.yscale.invert(s),h=this.index.indices({x0:i,x1:i,y0:a,y1:a}),_=new d.Selection;for(const e of h)t!=1/0&&s!=1/0&&_.image_indices.push(this._image_index(e,i,a));return _}}s.ImageBaseView=o,o.__name__="ImageBaseView";class m extends _.XYGlyph{constructor(e){super(e)}static init_ImageBase(){this.define(({Boolean:e,Alpha:t})=>({image:[r.NDArraySpec],dw:[r.DistanceSpec],dh:[r.DistanceSpec],dilate:[e,!1],global_alpha:[t,1]}))}}s.ImageBase=m,m.__name__="ImageBase",m.init_ImageBase()},
function _(t,e,r,s,a){s();const n=t(8),i=t(11),h=t(26),_=t(30),u=t(278),l=Symbol("__ndarray__");class y extends Uint8Array{constructor(t,e){super(t),this.__ndarray__=l,this.dtype="uint8",this.shape=null!=e?e:f(t)?t.shape:[this.length],this.dimension=this.shape.length}[h.equals](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[_.serialize](t){return u.encode_NDArray(this)}}r.Uint8NDArray=y,y.__name__="Uint8NDArray";class c extends Int8Array{constructor(t,e){super(t),this.__ndarray__=l,this.dtype="int8",this.shape=null!=e?e:f(t)?t.shape:[this.length],this.dimension=this.shape.length}[h.equals](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[_.serialize](t){return u.encode_NDArray(this)}}r.Int8NDArray=c,c.__name__="Int8NDArray";class o extends Uint16Array{constructor(t,e){super(t),this.__ndarray__=l,this.dtype="uint16",this.shape=null!=e?e:f(t)?t.shape:[this.length],this.dimension=this.shape.length}[h.equals](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[_.serialize](t){return u.encode_NDArray(this)}}r.Uint16NDArray=o,o.__name__="Uint16NDArray";class p extends Int16Array{constructor(t,e){super(t),this.__ndarray__=l,this.dtype="int16",this.shape=null!=e?e:f(t)?t.shape:[this.length],this.dimension=this.shape.length}[h.equals](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[_.serialize](t){return u.encode_NDArray(this)}}r.Int16NDArray=p,p.__name__="Int16NDArray";class d extends Uint32Array{constructor(t,e){super(t),this.__ndarray__=l,this.dtype="uint32",this.shape=null!=e?e:f(t)?t.shape:[this.length],this.dimension=this.shape.length}[h.equals](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[_.serialize](t){return u.encode_NDArray(this)}}r.Uint32NDArray=d,d.__name__="Uint32NDArray";class A extends Int32Array{constructor(t,e){super(t),this.__ndarray__=l,this.dtype="int32",this.shape=null!=e?e:f(t)?t.shape:[this.length],this.dimension=this.shape.length}[h.equals](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[_.serialize](t){return u.encode_NDArray(this)}}r.Int32NDArray=A,A.__name__="Int32NDArray";class D extends Float32Array{constructor(t,e){super(t),this.__ndarray__=l,this.dtype="float32",this.shape=null!=e?e:f(t)?t.shape:[this.length],this.dimension=this.shape.length}[h.equals](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[_.serialize](t){return u.encode_NDArray(this)}}r.Float32NDArray=D,D.__name__="Float32NDArray";class N extends Float64Array{constructor(t,e){super(t),this.__ndarray__=l,this.dtype="float64",this.shape=null!=e?e:f(t)?t.shape:[this.length],this.dimension=this.shape.length}[h.equals](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[_.serialize](t){return u.encode_NDArray(this)}}function f(t){return n.isObject(t)&&t.__ndarray__==l}r.Float64NDArray=N,N.__name__="Float64NDArray",r.is_NDArray=f,r.ndarray=function(t,e={}){let{dtype:r}=e;null==r&&(r=t instanceof ArrayBuffer||n.isArray(t)?"float32":(()=>{switch(!0){case t instanceof Uint8Array:return"uint8";case t instanceof Int8Array:return"int8";case t instanceof Uint16Array:return"uint16";case t instanceof Int16Array:return"int16";case t instanceof Uint32Array:return"uint32";case t instanceof Int32Array:return"int32";case t instanceof Float32Array:return"float32";case t instanceof Float64Array:return"float64";default:i.unreachable()}})());const{shape:s}=e;switch(r){case"uint8":return new y(t,s);case"int8":return new c(t,s);case"uint16":return new o(t,s);case"int16":return new p(t,s);case"uint32":return new d(t,s);case"int32":return new A(t,s);case"float32":return new D(t,s);case"float64":return new N(t,s)}}},
function _(r,e,n,t,a){t();const f=r(1),_=r(8),o=r(82),s=f.__importStar(r(277));function i(r){const e=new Uint8Array(r),n=Array.from(e).map(r=>String.fromCharCode(r));return btoa(n.join(""))}function u(r){const e=atob(r),n=e.length,t=new Uint8Array(n);for(let r=0,a=n;r<a;r++)t[r]=e.charCodeAt(r);return t.buffer}function c(r){const e=new Uint8Array(r.buffer,r.byteOffset,2*r.length);for(let r=0,n=e.length;r<n;r+=2){const n=e[r];e[r]=e[r+1],e[r+1]=n}}function l(r){const e=new Uint8Array(r.buffer,r.byteOffset,4*r.length);for(let r=0,n=e.length;r<n;r+=4){let n=e[r];e[r]=e[r+3],e[r+3]=n,n=e[r+1],e[r+1]=e[r+2],e[r+2]=n}}function b(r){const e=new Uint8Array(r.buffer,r.byteOffset,8*r.length);for(let r=0,n=e.length;r<n;r+=8){let n=e[r];e[r]=e[r+7],e[r+7]=n,n=e[r+1],e[r+1]=e[r+6],e[r+6]=n,n=e[r+2],e[r+2]=e[r+5],e[r+5]=n,n=e[r+3],e[r+3]=e[r+4],e[r+4]=n}}n.buffer_to_base64=i,n.base64_to_buffer=u,n.BYTE_ORDER=o.is_little_endian?"little":"big",n.swap16=c,n.swap32=l,n.swap64=b,n.is_NDArray_ref=function(r){return _.isPlainObject(r)&&("__buffer__"in r||"__ndarray__"in r)},n.decode_NDArray=function(r,e){const{shape:t,dtype:a,order:f}=r;let _;if("__buffer__"in r){const n=e.get(r.__buffer__);if(null==n)throw new Error(`buffer for ${r.__buffer__} not found`);_=n}else _=u(r.__ndarray__);const o=(()=>{switch(a){case"uint8":return new s.Uint8NDArray(_,t);case"int8":return new s.Int8NDArray(_,t);case"uint16":return new s.Uint16NDArray(_,t);case"int16":return new s.Int16NDArray(_,t);case"uint32":return new s.Uint32NDArray(_,t);case"int32":return new s.Int32NDArray(_,t);case"float32":return new s.Float32NDArray(_,t);case"float64":return new s.Float64NDArray(_,t)}})();if(f!==n.BYTE_ORDER)switch(o.BYTES_PER_ELEMENT){case 2:c(o);break;case 4:l(o);break;case 8:b(o)}return o},n.encode_NDArray=function(r,e){const t={order:n.BYTE_ORDER,dtype:r.dtype,shape:r.shape};if(null!=e){const n=""+e.size;return e.set(n,r.buffer),Object.assign({__buffer__:n},t)}{const e=i(r.buffer);return Object.assign({__ndarray__:e},t)}}},
function _(e,a,t,_,i){_();const n=e(276),s=e(8);class r extends n.ImageBaseView{_flat_img_to_buf8(e){let a;return a=s.isArray(e)?new Uint32Array(e):e,new Uint8Array(a.buffer)}}t.ImageRGBAView=r,r.__name__="ImageRGBAView";class m extends n.ImageBase{constructor(e){super(e)}static init_ImageRGBA(){this.prototype.default_view=r}}t.ImageRGBA=m,m.__name__="ImageRGBA",m.init_ImageRGBA()},
function _(e,t,s,r,i){r();const a=e(1),n=e(106),h=e(24),o=e(20),_=a.__importStar(e(18)),l=e(12),c=e(281);class d extends n.XYGlyphView{constructor(){super(...arguments),this._images_rendered=!1}initialize(){super.initialize(),this.connect(this.model.properties.global_alpha.change,()=>this.renderer.request_render())}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++)e.add_empty()}_set_data(){null!=this.image&&this.image.length==this._url.length||(this.image=l.map(this._url,()=>null));const{retry_attempts:e,retry_timeout:t}=this.model;for(let s=0,r=this._url.length;s<r;s++){const r=this._url[s];null!=r&&""!=r&&new c.ImageLoader(r,{loaded:e=>{this.image[s]=e,this.renderer.request_render()},attempts:e+1,timeout:t})}const s="data"==this.model.properties.w.units,r="data"==this.model.properties.h.units,i=this._x.length,a=new h.NumberArray(s?2*i:i),n=new h.NumberArray(r?2*i:i),{anchor:o}=this.model;function _(e,t){switch(o){case"top_left":case"bottom_left":case"center_left":return[e,e+t];case"top_center":case"bottom_center":case"center":return[e-t/2,e+t/2];case"top_right":case"bottom_right":case"center_right":return[e-t,e]}}function d(e,t){switch(o){case"top_left":case"top_center":case"top_right":return[e,e-t];case"bottom_left":case"bottom_center":case"bottom_right":return[e+t,e];case"center_left":case"center":case"center_right":return[e+t/2,e-t/2]}}if(s)for(let e=0;e<i;e++)[a[e],a[i+e]]=_(this._x[e],this._w[e]);else a.set(this._x,0);if(r)for(let e=0;e<i;e++)[n[e],n[i+e]]=d(this._y[e],this._h[e]);else n.set(this._y,0);const[m,u]=l.minmax(a),[p,g]=l.minmax(n);this._bounds_rect={x0:m,x1:u,y0:p,y1:g}}has_finished(){return super.has_finished()&&1==this._images_rendered}_map_data(){const e=null!=this.model.w?this._w:l.map(this._x,()=>NaN),t=null!=this.model.h?this._h:l.map(this._x,()=>NaN);switch(this.model.properties.w.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,e,"edge",this.model.dilate);break;case"screen":this.sw=e}switch(this.model.properties.h.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,t,"edge",this.model.dilate);break;case"screen":this.sh=t}}_render(e,t,{image:s,sx:r,sy:i,sw:a,sh:n,_angle:h}){const{frame:o}=this.renderer.plot_view;e.rect(o.bbox.left+1,o.bbox.top+1,o.bbox.width-2,o.bbox.height-2),e.clip();let _=!0;for(const o of t){if(isNaN(r[o]+i[o]+h[o]))continue;const t=s[o];null!=t?this._render_image(e,o,t,r,i,a,n,h):_=!1}_&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())}_final_sx_sy(e,t,s,r,i){switch(e){case"top_left":return[t,s];case"top_center":return[t-r/2,s];case"top_right":return[t-r,s];case"center_right":return[t-r,s-i/2];case"bottom_right":return[t-r,s-i];case"bottom_center":return[t-r/2,s-i];case"bottom_left":return[t,s-i];case"center_left":return[t,s-i/2];case"center":return[t-r/2,s-i/2]}}_render_image(e,t,s,r,i,a,n,h){isNaN(a[t])&&(a[t]=s.width),isNaN(n[t])&&(n[t]=s.height);const{anchor:o}=this.model,[_,l]=this._final_sx_sy(o,r[t],i[t],a[t],n[t]);e.save(),e.globalAlpha=this.model.global_alpha;const c=a[t]/2,d=n[t]/2;h[t]?(e.translate(_,l),e.translate(c,d),e.rotate(h[t]),e.translate(-c,-d),e.drawImage(s,0,0,a[t],n[t]),e.translate(c,d),e.rotate(-h[t]),e.translate(-c,-d),e.translate(-_,-l)):e.drawImage(s,_,l,a[t],n[t]),e.restore()}bounds(){return this._bounds_rect}}s.ImageURLView=d,d.__name__="ImageURLView";class m extends n.XYGlyph{constructor(e){super(e)}static init_ImageURL(){this.prototype.default_view=d,this.define(({Boolean:e,Int:t,Alpha:s})=>({url:[_.StringSpec],anchor:[o.Anchor,"top_left"],global_alpha:[s,1],angle:[_.AngleSpec,0],w:[_.DistanceSpec,null],h:[_.DistanceSpec,null],dilate:[e,!1],retry_attempts:[t,0],retry_timeout:[t,0]}))}}s.ImageURL=m,m.__name__="ImageURL",m.init_ImageURL()},
function _(i,e,t,s,a){s();const o=i(19);class n{constructor(i,e={}){this._image=new Image,this._finished=!1;const{attempts:t=1,timeout:s=1}=e;this.promise=new Promise((a,n)=>{this._image.crossOrigin="anonymous";let r=0;this._image.onerror=()=>{if(++r==t){const s=`unable to load ${i} image after ${t} attempts`;if(o.logger.warn(s),null==this._image.crossOrigin)return void(null!=e.failed&&e.failed());o.logger.warn(`attempting to load ${i} without a cross origin policy`),this._image.crossOrigin=null,r=0}setTimeout(()=>this._image.src=i,s)},this._image.onload=()=>{this._finished=!0,null!=e.loaded&&e.loaded(this._image),a(this._image)},this._image.src=i})}get finished(){return this._finished}get image(){return this._image}}t.ImageLoader=n,n.__name__="ImageLoader"},
function _(t,e,s,i,n){i();const o=t(1),r=t(97),l=t(95),h=t(107),_=t(12),a=t(12),d=t(28),c=o.__importStar(t(108)),x=o.__importStar(t(18)),y=t(94),f=t(11);class g extends l.GlyphView{_project_data(){}_index_data(t){const{min:e,max:s}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._xs[n],o=this._ys[n];if(0==i.length||0==o.length){t.add_empty();continue}let r=1/0,l=-1/0,h=1/0,a=-1/0;for(let t=0,n=i.length;t<n;t++){const n=i[t][0],d=o[t][0];if(0!=n.length&&0!=d.length){const[t,i]=_.minmax(n),[o,c]=_.minmax(d);r=e(r,t),l=s(l,i),h=e(h,o),a=s(a,c)}}isFinite(r+l+h+a)?t.add(r,h,l,a):t.add_empty()}this._hole_index=this._index_hole_data()}_index_hole_data(){const{min:t,max:e}=Math,{data_size:s}=this,i=new r.SpatialIndex(s);for(let n=0;n<s;n++){const s=this._xs[n],o=this._ys[n];if(0==s.length||0==o.length){i.add_empty();continue}let r=1/0,l=-1/0,h=1/0,a=-1/0;for(let i=0,n=s.length;i<n;i++){const n=s[i],d=o[i];if(n.length>1&&d.length>1)for(let s=1,i=n.length;s<i;s++){const[i,o]=_.minmax(n[s]),[c,x]=_.minmax(d[s]);r=t(r,i),l=e(l,o),h=t(h,c),a=e(a,x)}}isFinite(r+l+h+a)?i.add(r,h,l,a):i.add_empty()}return i.finish(),i}_mask_data(){const{x_range:t,y_range:e}=this.renderer.plot_view.frame;return this.index.indices({x0:t.min,x1:t.max,y0:e.min,y1:e.max})}_inner_loop(t,e,s){t.beginPath();for(let i=0,n=e.length;i<n;i++)for(let n=0,o=e[i].length;n<o;n++){const o=e[i][n],r=s[i][n];for(let e=0,s=o.length;e<s;e++)0!=e?t.lineTo(o[e],r[e]):t.moveTo(o[e],r[e]);t.closePath()}}_render(t,e,{sxs:s,sys:i}){if(this.visuals.fill.doit||this.visuals.line.doit)for(const n of e){const[e,o]=[s[n],i[n]];this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,n),this._inner_loop(t,e,o),t.fill("evenodd")),this.visuals.hatch.doit2(t,n,()=>{this._inner_loop(t,e,o),t.fill("evenodd")},()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,n),this._inner_loop(t,e,o),t.stroke())}}_hit_rect(t){const{sx0:e,sx1:s,sy0:i,sy1:n}=t,o=[e,s,s,e],r=[i,i,n,n],[l,h]=this.renderer.xscale.r_invert(e,s),[_,a]=this.renderer.yscale.r_invert(i,n),d=this.index.indices({x0:l,x1:h,y0:_,y1:a}),x=[];for(const t of d){const e=this.sxs[t],s=this.sys[t];let i=!0;for(let t=0,n=e.length;t<n;t++){for(let n=0,l=e[t][0].length;n<l;n++){const l=e[t][0][n],h=s[t][0][n];if(!c.point_in_poly(l,h,o,r)){i=!1;break}}if(!i)break}i&&x.push(t)}return new y.Selection({indices:x})}_hit_point(t){const{sx:e,sy:s}=t,i=this.renderer.xscale.invert(e),n=this.renderer.yscale.invert(s),o=this.index.indices({x0:i,y0:n,x1:i,y1:n}),r=this._hole_index.indices({x0:i,y0:n,x1:i,y1:n}),l=[];for(const t of o){const i=this.sxs[t],n=this.sys[t];for(let o=0,h=i.length;o<h;o++){const h=i[o].length;if(c.point_in_poly(e,s,i[o][0],n[o][0]))if(1==h)l.push(t);else if(r.get(t)){if(h>1){let r=!1;for(let t=1;t<h;t++){const l=i[o][t],h=n[o][t];if(c.point_in_poly(e,s,l,h)){r=!0;break}}r||l.push(t)}}else l.push(t)}}return new y.Selection({indices:l})}_get_snap_coord(t){return a.sum(t)/t.length}scenterxy(t,e,s){if(1==this.sxs[t].length){return[this._get_snap_coord(this.sxs[t][0][0]),this._get_snap_coord(this.sys[t][0][0])]}{const i=this.sxs[t],n=this.sys[t];for(let t=0,o=i.length;t<o;t++)if(c.point_in_poly(e,s,i[t][0],n[t][0])){return[this._get_snap_coord(i[t][0]),this._get_snap_coord(n[t][0])]}}f.unreachable()}map_data(){const t=this._xs.length;this.sxs=new Array(t),this.sys=new Array(t);for(let e=0;e<t;e++){const t=this._xs[e].length;this.sxs[e]=new Array(t),this.sys[e]=new Array(t);for(let s=0;s<t;s++){const t=this._xs[e][s].length;this.sxs[e][s]=new Array(t),this.sys[e][s]=new Array(t);for(let i=0;i<t;i++){const[t,n]=this.renderer.coordinates.map_to_screen(this._xs[e][s][i],this._ys[e][s][i]);this.sxs[e][s][i]=t,this.sys[e][s][i]=n}}}}draw_legend_for_index(t,e,s){h.generic_area_legend(this.visuals,t,e,s)}}s.MultiPolygonsView=g,g.__name__="MultiPolygonsView";class p extends l.Glyph{constructor(t){super(t)}static init_MultiPolygons(){this.prototype.default_view=g,this.define(({})=>({xs:[x.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[x.YCoordinateSeqSeqSeqSpec,{field:"ys"}]})),this.mixins([d.LineVector,d.FillVector,d.HatchVector])}}s.MultiPolygons=p,p.__name__="MultiPolygons",p.init_MultiPolygons()},
function _(a,t,e,l,s){l();const _=a(271);class i extends _.EllipseOvalView{_map_data(){super._map_data();const{sw:a}=this,t=a.length;for(let e=0;e<t;e++)a[e]*=.75}}e.OvalView=i,i.__name__="OvalView";class n extends _.EllipseOval{constructor(a){super(a)}static init_Oval(){this.prototype.default_view=i}}e.Oval=n,n.__name__="Oval",n.init_Oval()},
function _(t,e,i,o,s){o();const r=t(1),_=t(273),d=r.__importStar(t(18));class n extends _.BoxView{scenterxy(t){return[(this.sleft[t]+this.sright[t])/2,(this.stop[t]+this.sbottom[t])/2]}_lrtb(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]}}i.QuadView=n,n.__name__="QuadView";class a extends _.Box{constructor(t){super(t)}static init_Quad(){this.prototype.default_view=n,this.define(({})=>({right:[d.XCoordinateSpec,{field:"right"}],bottom:[d.YCoordinateSpec,{field:"bottom"}],left:[d.XCoordinateSpec,{field:"left"}],top:[d.YCoordinateSpec,{field:"top"}]}))}}i.Quad=a,a.__name__="Quad",a.init_Quad()},
function _(i,t,e,s,a){s();const c=i(1),n=i(28),_=i(36),r=i(95),o=i(107),d=c.__importStar(i(18));function h(i,t,e){if(t==(i+e)/2)return[i,e];{const s=(i-t)/(i-2*t+e),a=i*(1-s)**2+2*t*(1-s)*s+e*s**2;return[Math.min(i,e,a),Math.max(i,e,a)]}}class x extends r.GlyphView{_project_data(){_.inplace.project_xy(this._x0,this._y0),_.inplace.project_xy(this._x1,this._y1)}_index_data(i){const{data_size:t}=this;for(let e=0;e<t;e++)if(isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx[e]+this._cy[e]))i.add_empty();else{const[t,s]=h(this._x0[e],this._cx[e],this._x1[e]),[a,c]=h(this._y0[e],this._cy[e],this._y1[e]);i.add(t,a,s,c)}}_render(i,t,{sx0:e,sy0:s,sx1:a,sy1:c,scx:n,scy:_}){if(this.visuals.line.doit)for(const r of t)isNaN(e[r]+s[r]+a[r]+c[r]+n[r]+_[r])||(i.beginPath(),i.moveTo(e[r],s[r]),i.quadraticCurveTo(n[r],_[r],a[r],c[r]),this.visuals.line.set_vectorize(i,r),i.stroke())}draw_legend_for_index(i,t,e){o.generic_line_legend(this.visuals,i,t,e)}scenterxy(){throw new Error(this+".scenterxy() is not implemented")}}e.QuadraticView=x,x.__name__="QuadraticView";class y extends r.Glyph{constructor(i){super(i)}static init_Quadratic(){this.prototype.default_view=x,this.define(({})=>({x0:[d.XCoordinateSpec,{field:"x0"}],y0:[d.YCoordinateSpec,{field:"y0"}],x1:[d.XCoordinateSpec,{field:"x1"}],y1:[d.YCoordinateSpec,{field:"y1"}],cx:[d.XCoordinateSpec,{field:"cx"}],cy:[d.YCoordinateSpec,{field:"cy"}]})),this.mixins(n.LineVector)}}e.Quadratic=y,y.__name__="Quadratic",y.init_Quadratic()},
function _(e,t,i,s,n){s();const a=e(1),r=e(106),l=e(107),h=e(28),_=a.__importStar(e(18));class o extends r.XYGlyphView{_map_data(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this._length):this.slength=this._length}_render(e,t,{sx:i,sy:s,slength:n,_angle:a}){if(this.visuals.line.doit){const r=2*(this.renderer.plot_view.frame.bbox.width+this.renderer.plot_view.frame.bbox.height);for(let e=0,t=n.length;e<t;e++)0==n[e]&&(n[e]=r);for(const r of t)isNaN(i[r]+s[r]+a[r]+n[r])||(e.translate(i[r],s[r]),e.rotate(a[r]),e.beginPath(),e.moveTo(0,0),e.lineTo(n[r],0),this.visuals.line.set_vectorize(e,r),e.stroke(),e.rotate(-a[r]),e.translate(-i[r],-s[r]))}}draw_legend_for_index(e,t,i){l.generic_line_legend(this.visuals,e,t,i)}}i.RayView=o,o.__name__="RayView";class d extends r.XYGlyph{constructor(e){super(e)}static init_Ray(){this.prototype.default_view=o,this.mixins(h.LineVector),this.define(({})=>({length:[_.DistanceSpec],angle:[_.AngleSpec]}))}}i.Ray=d,d.__name__="Ray",d.init_Ray()},
function _(t,s,e,i,h){i();const r=t(269),a=t(107),n=t(24),_=t(12),o=t(94);class l extends r.CenterRotatableView{_set_data(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)}_map_data(){if("data"==this.model.properties.width.units)[this.sw,this.sx0]=this._map_dist_corner_for_data_side_length(this._x,this._width,this.renderer.xscale);else{this.sw=this._width;const t=this.sx.length;this.sx0=new n.NumberArray(t);for(let s=0;s<t;s++)this.sx0[s]=this.sx[s]-this.sw[s]/2}if("data"==this.model.properties.height.units)[this.sh,this.sy1]=this._map_dist_corner_for_data_side_length(this._y,this._height,this.renderer.yscale);else{this.sh=this._height;const t=this.sy.length;this.sy1=new n.NumberArray(t);for(let s=0;s<t;s++)this.sy1[s]=this.sy[s]-this.sh[s]/2}const t=this.sw.length;this.ssemi_diag=new n.NumberArray(t);for(let s=0;s<t;s++)this.ssemi_diag[s]=Math.sqrt(this.sw[s]/2*this.sw[s]/2+this.sh[s]/2*this.sh[s]/2)}_render(t,s,{sx:e,sy:i,sx0:h,sy1:r,sw:a,sh:n,_angle:_}){if(this.visuals.fill.doit)for(const o of s)isNaN(e[o]+i[o]+h[o]+r[o]+a[o]+n[o]+_[o])||(this.visuals.fill.set_vectorize(t,o),_[o]?(t.translate(e[o],i[o]),t.rotate(_[o]),t.fillRect(-a[o]/2,-n[o]/2,a[o],n[o]),t.rotate(-_[o]),t.translate(-e[o],-i[o])):t.fillRect(h[o],r[o],a[o],n[o]));if(this.visuals.line.doit){t.beginPath();for(const o of s)isNaN(e[o]+i[o]+h[o]+r[o]+a[o]+n[o]+_[o])||0!=a[o]&&0!=n[o]&&(_[o]?(t.translate(e[o],i[o]),t.rotate(_[o]),t.rect(-a[o]/2,-n[o]/2,a[o],n[o]),t.rotate(-_[o]),t.translate(-e[o],-i[o])):t.rect(h[o],r[o],a[o],n[o]),this.visuals.line.set_vectorize(t,o),t.stroke(),t.beginPath());t.stroke()}}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){let{sx:s,sy:e}=t;const i=this.renderer.xscale.invert(s),h=this.renderer.yscale.invert(e),r=this.sx0.length,a=new n.NumberArray(r);for(let t=0;t<r;t++)a[t]=this.sx0[t]+this.sw[t]/2;const l=new n.NumberArray(r);for(let t=0;t<r;t++)l[t]=this.sy1[t]+this.sh[t]/2;const d=_.max(this._ddist(0,a,this.ssemi_diag)),c=_.max(this._ddist(1,l,this.ssemi_diag)),x=i-d,m=i+d,w=h-c,y=h+c;let f,g;const u=[];for(const t of this.index.indices({x0:x,x1:m,y0:w,y1:y})){if(this._angle[t]){const i=Math.sin(-this._angle[t]),h=Math.cos(-this._angle[t]),r=h*(s-this.sx[t])-i*(e-this.sy[t])+this.sx[t],a=i*(s-this.sx[t])+h*(e-this.sy[t])+this.sy[t];s=r,e=a,f=Math.abs(this.sx[t]-s)<=this.sw[t]/2,g=Math.abs(this.sy[t]-e)<=this.sh[t]/2}else{const i=s-this.sx0[t],h=e-this.sy1[t];f=0<=i&&i<=this.sw[t],g=0<=h&&h<=this.sh[t]}f&&g&&u.push(t)}return new o.Selection({indices:u})}_map_dist_corner_for_data_side_length(t,s,e){const i=t.length,h=new Float64Array(i),r=new Float64Array(i);for(let e=0;e<i;e++)h[e]=t[e]-s[e]/2,r[e]=t[e]+s[e]/2;const a=e.v_compute(h),n=e.v_compute(r),_=this.sdist(e,h,s,"edge",this.model.dilate);let o=a;for(let t=0;t<i;t++){const s=a[t],e=n[t];if(!isNaN(s+e)&&s!=e){o=s<e?a:n;break}}return[_,o]}_ddist(t,s,e){const i=0==t?this.renderer.xscale:this.renderer.yscale,h=s,r=h.length,a=new n.NumberArray(r);for(let t=0;t<r;t++)a[t]=h[t]+e[t];const _=i.v_invert(h),o=i.v_invert(a),l=_.length,d=new n.NumberArray(l);for(let t=0;t<l;t++)d[t]=Math.abs(o[t]-_[t]);return d}draw_legend_for_index(t,s,e){a.generic_area_legend(this.visuals,t,s,e)}_bounds({x0:t,x1:s,y0:e,y1:i}){return{x0:t-this.max_w2,x1:s+this.max_w2,y0:e-this.max_h2,y1:i+this.max_h2}}}e.RectView=l,l.__name__="RectView";class d extends r.CenterRotatable{constructor(t){super(t)}static init_Rect(){this.prototype.default_view=l,this.define(({Boolean:t})=>({dilate:[t,!1]}))}}e.Rect=d,d.__name__="Rect",d.init_Rect()},
function _(e,t,s,i,n){i();const r=e(1),_=r.__importStar(e(108)),h=r.__importStar(e(18)),a=e(28),o=e(36),c=e(95),d=e(107),x=e(94);class l extends c.GlyphView{_project_data(){o.inplace.project_xy(this._x0,this._y0),o.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{min:t,max:s}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._x0[n],r=this._x1[n],_=this._y0[n],h=this._y1[n];isNaN(i+r+_+h)?e.add_empty():e.add(t(i,r),t(_,h),s(i,r),s(_,h))}}_render(e,t,{sx0:s,sy0:i,sx1:n,sy1:r}){if(this.visuals.line.doit)for(const _ of t)isNaN(s[_]+i[_]+n[_]+r[_])||(e.beginPath(),e.moveTo(s[_],i[_]),e.lineTo(n[_],r[_]),this.visuals.line.set_vectorize(e,_),e.stroke())}_hit_point(e){const{sx:t,sy:s}=e,i={x:t,y:s},[n,r]=this.renderer.xscale.r_invert(t-2,t+2),[h,a]=this.renderer.yscale.r_invert(s-2,s+2),o=this.index.indices({x0:n,y0:h,x1:r,y1:a}),c=[];for(const e of o){const t=Math.max(2,this.visuals.line.cache_select("line_width",e)/2)**2,s={x:this.sx0[e],y:this.sy0[e]},n={x:this.sx1[e],y:this.sy1[e]};_.dist_to_segment_squared(i,s,n)<t&&c.push(e)}return new x.Selection({indices:c})}_hit_span(e){const[t,s]=this.renderer.plot_view.frame.bbox.ranges,{sx:i,sy:n}=e;let r,_,h;"v"==e.direction?(h=this.renderer.yscale.invert(n),[r,_]=[this._y0,this._y1]):(h=this.renderer.xscale.invert(i),[r,_]=[this._x0,this._x1]);const a=[],[o,c]=this.renderer.xscale.r_invert(t.start,t.end),[d,l]=this.renderer.yscale.r_invert(s.start,s.end),y=this.index.indices({x0:o,y0:d,x1:c,y1:l});for(const t of y){(r[t]<=h&&h<=_[t]||_[t]<=h&&h<=r[t])&&a.push(t);const s=1.5+this.visuals.line.cache_select("line_width",t)/2;r[t]==_[t]&&("h"==e.direction?Math.abs(this.sx0[t]-i)<=s&&a.push(t):Math.abs(this.sy0[t]-n)<=s&&a.push(t))}return new x.Selection({indices:a})}scenterxy(e){return[(this.sx0[e]+this.sx1[e])/2,(this.sy0[e]+this.sy1[e])/2]}draw_legend_for_index(e,t,s){d.generic_line_legend(this.visuals,e,t,s)}}s.SegmentView=l,l.__name__="SegmentView";class y extends c.Glyph{constructor(e){super(e)}static init_Segment(){this.prototype.default_view=l,this.define(({})=>({x0:[h.XCoordinateSpec,{field:"x0"}],y0:[h.YCoordinateSpec,{field:"y0"}],x1:[h.XCoordinateSpec,{field:"x1"}],y1:[h.YCoordinateSpec,{field:"y1"}]})),this.mixins(a.LineVector)}}s.Segment=y,y.__name__="Segment",y.init_Segment()},
function _(e,t,i,n,s){n();const o=e(106),r=e(107),l=e(28),a=e(20);class c extends o.XYGlyphView{_render(e,t,{sx:i,sy:n}){let s=!1,o=null;this.visuals.line.set_value(e);const r=t.length;if(!(r<2)){e.beginPath(),e.moveTo(i[0],n[0]);for(const r of t){let t,l,a,c;switch(this.model.mode){case"before":[t,a]=[i[r-1],n[r]],[l,c]=[i[r],n[r]];break;case"after":[t,a]=[i[r],n[r-1]],[l,c]=[i[r],n[r]];break;case"center":{const e=(i[r-1]+i[r])/2;[t,a]=[e,n[r-1]],[l,c]=[e,n[r]];break}default:throw new Error("unexpected")}if(s){if(!isFinite(i[r]+n[r])){e.stroke(),e.beginPath(),s=!1,o=r;continue}null!=o&&r-o>1&&(e.stroke(),s=!1)}s?(e.lineTo(t,a),e.lineTo(l,c)):(e.beginPath(),e.moveTo(i[r],n[r]),s=!0),o=r}e.lineTo(i[r-1],n[r-1]),e.stroke()}}draw_legend_for_index(e,t,i){r.generic_line_legend(this.visuals,e,t,i)}}i.StepView=c,c.__name__="StepView";class _ extends o.XYGlyph{constructor(e){super(e)}static init_Step(){this.prototype.default_view=c,this.mixins(l.LineVector),this.define(()=>({mode:[a.StepMode,"before"]}))}}i.Step=_,_.__name__="Step",_.init_Step()},
function _(t,s,e,i,n){i();const _=t(1),o=t(106),h=t(28),l=_.__importStar(t(108)),a=_.__importStar(t(18)),r=t(171),c=t(11),x=t(94);class u extends o.XYGlyphView{_rotate_point(t,s,e,i,n){return[(t-e)*Math.cos(n)-(s-i)*Math.sin(n)+e,(t-e)*Math.sin(n)+(s-i)*Math.cos(n)+i]}_text_bounds(t,s,e,i){return[[t,t+e,t+e,t,t],[s,s,s-i,s-i,s]]}_render(t,s,{sx:e,sy:i,_x_offset:n,_y_offset:_,_angle:o,_text:h}){this._sys=[],this._sxs=[];for(const l of s)if(this._sxs[l]=[],this._sys[l]=[],!isNaN(e[l]+i[l]+n[l]+_[l]+o[l])&&null!=h[l]&&this.visuals.text.doit){const s=""+h[l];t.save(),t.translate(e[l]+n[l],i[l]+_[l]),t.rotate(o[l]),this.visuals.text.set_vectorize(t,l);const a=this.visuals.text.cache_select("font",l),{height:c}=r.measure_font(a),x=this.visuals.text.text_line_height.value()*c;if(-1==s.indexOf("\n")){t.fillText(s,0,0);const o=e[l]+n[l],h=i[l]+_[l],a=t.measureText(s).width,[r,c]=this._text_bounds(o,h,a,x);this._sxs[l].push(r),this._sys[l].push(c)}else{const o=s.split("\n"),h=x*o.length,a=this.visuals.text.cache_select("text_baseline",l);let r;switch(a){case"top":r=0;break;case"middle":r=-h/2+x/2;break;case"bottom":r=-h+x;break;default:r=0,console.warn(`'${a}' baseline not supported with multi line text`)}for(const s of o){t.fillText(s,0,r);const o=e[l]+n[l],h=r+i[l]+_[l],a=t.measureText(s).width,[c,u]=this._text_bounds(o,h,a,x);this._sxs[l].push(c),this._sys[l].push(u),r+=x}}t.restore()}}_hit_point(t){const{sx:s,sy:e}=t,i=[];for(let t=0;t<this._sxs.length;t++){const n=this._sxs[t],_=this._sys[t],o=n.length;for(let h=0,a=o;h<a;h++){const[a,r]=this._rotate_point(s,e,n[o-1][0],_[o-1][0],-this._angle[t]);l.point_in_poly(a,r,n[h],_[h])&&i.push(t)}}return new x.Selection({indices:i})}scenterxy(t){const s=this._sxs[t],e=this._sys[t];c.assert(0!=s.length&&0!=e.length);const i=s[0][0],n=e[0][0],_=(s[0][2]+i)/2,o=(e[0][2]+n)/2,[h,l]=this._rotate_point(_,o,i,n,this._angle[t]);return[h,l]}}e.TextView=u,u.__name__="TextView";class f extends o.XYGlyph{constructor(t){super(t)}static init_Text(){this.prototype.default_view=u,this.mixins(h.TextVector),this.define(({})=>({text:[a.NullStringSpec,{field:"text"}],angle:[a.AngleSpec,0],x_offset:[a.NumberSpec,0],y_offset:[a.NumberSpec,0]}))}}e.Text=f,f.__name__="Text",f.init_Text()},
function _(t,s,i,e,h){e();const r=t(1),o=t(273),_=t(24),a=r.__importStar(t(18));class n extends o.BoxView{scenterxy(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]}_lrtb(t){return[this._x[t]-this._width[t]/2,this._x[t]+this._width[t]/2,Math.max(this._top[t],this._bottom[t]),Math.min(this._top[t],this._bottom[t])]}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);const t=this.sx.length;this.sleft=new _.NumberArray(t),this.sright=new _.NumberArray(t);for(let s=0;s<t;s++)this.sleft[s]=this.sx[s]-this.sw[s]/2,this.sright[s]=this.sx[s]+this.sw[s]/2;this._clamp_viewport()}}i.VBarView=n,n.__name__="VBarView";class c extends o.Box{constructor(t){super(t)}static init_VBar(){this.prototype.default_view=n,this.define(({})=>({x:[a.XCoordinateSpec,{field:"x"}],bottom:[a.YCoordinateSpec,{value:0}],width:[a.NumberSpec,{value:1}],top:[a.YCoordinateSpec,{field:"top"}]}))}}i.VBar=c,c.__name__="VBar",c.init_VBar()},
function _(e,s,t,i,n){i();const r=e(1),a=e(106),d=e(107),c=e(28),l=e(20),o=r.__importStar(e(18)),_=e(10),h=e(94);class u extends a.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius}_render(e,s,{sx:t,sy:i,sradius:n,_start_angle:r,_end_angle:a}){const d="anticlock"==this.model.direction;for(const c of s)isNaN(t[c]+i[c]+n[c]+r[c]+a[c])||(e.beginPath(),e.arc(t[c],i[c],n[c],r[c],a[c],d),e.lineTo(t[c],i[c]),e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,c),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,c),e.stroke()))}_hit_point(e){let s,t,i,n,r,a,d,c,l;const{sx:o,sy:u}=e,g=this.renderer.xscale.invert(o),p=this.renderer.yscale.invert(u),x=2*this.max_radius;"data"===this.model.properties.radius.units?(a=g-x,d=g+x,c=p-x,l=p+x):(t=o-x,i=o+x,[a,d]=this.renderer.xscale.r_invert(t,i),n=u-x,r=u+x,[c,l]=this.renderer.yscale.r_invert(n,r));const y=[];for(const e of this.index.indices({x0:a,x1:d,y0:c,y1:l})){const a=this.sradius[e]**2;[t,i]=this.renderer.xscale.r_compute(g,this._x[e]),[n,r]=this.renderer.yscale.r_compute(p,this._y[e]),s=(t-i)**2+(n-r)**2,s<=a&&y.push(e)}const f="anticlock"==this.model.direction,m=[];for(const e of y){const s=Math.atan2(u-this.sy[e],o-this.sx[e]);_.angle_between(-s,-this._start_angle[e],-this._end_angle[e],f)&&m.push(e)}return new h.Selection({indices:m})}draw_legend_for_index(e,s,t){d.generic_area_legend(this.visuals,e,s,t)}scenterxy(e){const s=this.sradius[e]/2,t=(this._start_angle[e]+this._end_angle[e])/2;return[this.sx[e]+s*Math.cos(t),this.sy[e]+s*Math.sin(t)]}}t.WedgeView=u,u.__name__="WedgeView";class g extends a.XYGlyph{constructor(e){super(e)}static init_Wedge(){this.prototype.default_view=u,this.mixins([c.LineVector,c.FillVector]),this.define(({})=>({direction:[l.Direction,"anticlock"],radius:[o.DistanceSpec],start_angle:[o.AngleSpec],end_angle:[o.AngleSpec]}))}}t.Wedge=g,g.__name__="Wedge",g.init_Wedge()},
function _(t,_,r,o,a){o();const e=t(1);e.__exportStar(t(126),r),e.__exportStar(t(125),r),e.__exportStar(t(294),r)},
function _(t,a,r,e,n){e();const o=t(125),u=t(24);class i extends o.LayoutProvider{constructor(t){super(t)}static init_StaticLayoutProvider(){this.define(({Number:t,Tuple:a,Dict:r})=>({graph_layout:[r(a(t,t)),{}]}))}get_node_coordinates(t){var a;const r=null!==(a=t.data.index)&&void 0!==a?a:[],e=r.length,n=new u.NumberArray(e),o=new u.NumberArray(e);for(let t=0;t<e;t++){const a=this.graph_layout[r[t]],[e,u]=null!=a?a:[NaN,NaN];n[t]=e,o[t]=u}return[n,o]}get_edge_coordinates(t){var a,r;const e=null!==(a=t.data.start)&&void 0!==a?a:[],n=null!==(r=t.data.end)&&void 0!==r?r:[],o=Math.min(e.length,n.length),u=[],i=[],l=null!=t.data.xs&&null!=t.data.ys;for(let a=0;a<o;a++){const r=null!=this.graph_layout[e[a]]&&null!=this.graph_layout[n[a]];if(l&&r)u.push(t.data.xs[a]),i.push(t.data.ys[a]);else{let t,o;r?(t=this.graph_layout[e[a]],o=this.graph_layout[n[a]]):(t=[NaN,NaN],o=[NaN,NaN]),u.push([t[0],o[0]]),i.push([t[1],o[1]])}}return[u,i]}}r.StaticLayoutProvider=i,i.__name__="StaticLayoutProvider",i.init_StaticLayoutProvider()},
function _(i,d,n,r,G){r(),G("Grid",i(296).Grid)},
function _(i,e,t,s,n){s();const r=i(1),o=i(204),d=i(206),_=i(139),a=r.__importStar(i(28)),l=i(8);class h extends d.GuideRendererView{_render(){const i=this.layer.ctx;i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render())}_draw_regions(i){if(!this.visuals.band_fill.doit&&!this.visuals.band_hatch.doit)return;this.visuals.band_fill.set_value(i);const[e,t]=this.grid_coords("major",!1);for(let s=0;s<e.length-1;s++){if(s%2!=1)continue;const[n,r]=this.coordinates.map_to_screen(e[s],t[s]),[o,d]=this.coordinates.map_to_screen(e[s+1],t[s+1]);this.visuals.band_fill.doit&&i.fillRect(n[0],r[0],o[1]-n[0],d[1]-r[0]),this.visuals.band_hatch.doit2(i,s,()=>{i.fillRect(n[0],r[0],o[1]-n[0],d[1]-r[0])},()=>this.request_render())}}_draw_grids(i){if(!this.visuals.grid_line.doit)return;const[e,t]=this.grid_coords("major");this._draw_grid_helper(i,this.visuals.grid_line,e,t)}_draw_minor_grids(i){if(!this.visuals.minor_grid_line.doit)return;const[e,t]=this.grid_coords("minor");this._draw_grid_helper(i,this.visuals.minor_grid_line,e,t)}_draw_grid_helper(i,e,t,s){e.set_value(i),i.beginPath();for(let e=0;e<t.length;e++){const[n,r]=this.coordinates.map_to_screen(t[e],s[e]);i.moveTo(Math.round(n[0]),Math.round(r[0]));for(let e=1;e<n.length;e++)i.lineTo(Math.round(n[e]),Math.round(r[e]))}i.stroke()}ranges(){const i=this.model.dimension,e=(i+1)%2,{ranges:t}=this.coordinates;return[t[i],t[e]]}computed_bounds(){const[i]=this.ranges(),e=this.model.bounds,t=[i.min,i.max];let s,n;if(l.isArray(e))s=Math.min(e[0],e[1]),n=Math.max(e[0],e[1]),s<t[0]&&(s=t[0]),n>t[1]&&(n=t[1]);else{[s,n]=t;for(const i of this.plot_view.axis_views)i.dimension==this.model.dimension&&i.model.x_range_name==this.model.x_range_name&&i.model.y_range_name==this.model.y_range_name&&([s,n]=i.computed_bounds)}return[s,n]}grid_coords(i,e=!0){const t=this.model.dimension,s=(t+1)%2,[n,r]=this.ranges();let[o,d]=this.computed_bounds();[o,d]=[Math.min(o,d),Math.max(o,d)];const _=[[],[]],a=this.model.get_ticker();if(null==a)return _;const l=a.get_ticks(o,d,n,r.min)[i],h=n.min,c=n.max,u=r.min,m=r.max;e||(l[0]!=h&&l.splice(0,0,h),l[l.length-1]!=c&&l.push(c));for(let i=0;i<l.length;i++){if((l[i]==h||l[i]==c)&&e)continue;const n=[],r=[],o=2;for(let e=0;e<o;e++){const t=u+(m-u)/(o-1)*e;n.push(l[i]),r.push(t)}_[t].push(n),_[s].push(r)}return _}}t.GridView=h,h.__name__="GridView";class c extends d.GuideRenderer{constructor(i){super(i)}static init_Grid(){this.prototype.default_view=h,this.mixins([["grid_",a.Line],["minor_grid_",a.Line],["band_",a.Fill],["band_",a.Hatch]]),this.define(({Number:i,Auto:e,Enum:t,Ref:s,Tuple:n,Or:r})=>({bounds:[r(n(i,i),e),"auto"],dimension:[t(0,1),0],axis:[s(o.Axis)],ticker:[s(_.Ticker)]})),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})}get_ticker(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null}}t.Grid=c,c.__name__="Grid",c.init_Grid()},
function _(o,a,x,B,e){B(),e("Box",o(298).Box),e("Column",o(301).Column),e("GridBox",o(302).GridBox),e("HTMLBox",o(303).HTMLBox),e("LayoutDOM",o(299).LayoutDOM),e("Panel",o(304).Panel),e("Row",o(305).Row),e("Spacer",o(306).Spacer),e("Tabs",o(307).Tabs),e("WidgetBox",o(312).WidgetBox)},
function _(e,n,i,t,s){t();const o=e(299);class c extends o.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,()=>this.rebuild())}get child_models(){return this.model.children}}i.BoxView=c,c.__name__="BoxView";class r extends o.LayoutDOM{constructor(e){super(e)}static init_Box(){this.define(({Number:e,Array:n,Ref:i})=>({children:[n(i(o.LayoutDOM)),[]],spacing:[e,0]}))}}i.Box=r,r.__name__="Box",r.init_Box()},
function _(i,t,e,s,o){s();const l=i(88),n=i(20),h=i(71),a=i(19),r=i(8),_=i(123),d=i(77),c=i(241),u=i(300),m=i(76);class p extends d.DOMView{constructor(){super(...arguments),this._idle_notified=!1,this._offset_parent=null,this._viewport={}}initialize(){super.initialize(),this.el.style.position=this.is_root?"relative":"absolute",this._child_views=new Map}async lazy_initialize(){await super.lazy_initialize(),await this.build_child_views()}remove(){for(const i of this.child_views)i.remove();this._child_views.clear(),super.remove()}connect_signals(){super.connect_signals(),this.is_root&&(this._on_resize=()=>this.resize_layout(),window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval(()=>{const i=this.el.offsetParent;this._offset_parent!=i&&(this._offset_parent=i,null!=i&&(this.compute_viewport(),this.invalidate_layout()))},250));const i=this.model.properties;this.on_change([i.width,i.height,i.min_width,i.min_height,i.max_width,i.max_height,i.margin,i.width_policy,i.height_policy,i.sizing_mode,i.aspect_ratio,i.visible],()=>this.invalidate_layout()),this.on_change([i.background,i.css_classes],()=>this.invalidate_render())}disconnect_signals(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),super.disconnect_signals()}css_classes(){return super.css_classes().concat(this.model.css_classes)}get child_views(){return this.child_models.map(i=>this._child_views.get(i))}async build_child_views(){await _.build_views(this._child_views,this.child_models,{parent:this})}render(){super.render(),h.empty(this.el);const{background:i}=this.model;this.el.style.backgroundColor=null!=i?i:"",h.classes(this.el).clear().add(...this.css_classes());for(const i of this.child_views)this.el.appendChild(i.el),i.render()}update_layout(){for(const i of this.child_views)i.update_layout();this._update_layout()}update_position(){this.el.style.display=this.model.visible?"block":"none";const i=this.is_root?this.layout.sizing.margin:void 0;h.position(this.el,this.layout.bbox,i);for(const i of this.child_views)i.update_position()}after_layout(){for(const i of this.child_views)i.after_layout();this._has_finished=!0}compute_viewport(){this._viewport=this._viewport_size()}renderTo(i){i.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build()}build(){return this.assert_root(),this.render(),this.update_layout(),this.compute_layout(),this}async rebuild(){await this.build_child_views(),this.invalidate_render()}compute_layout(){const i=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),a.logger.debug(`layout computed in ${Date.now()-i} ms`),this.notify_finished()}resize_layout(){this.root.compute_viewport(),this.root.compute_layout()}invalidate_layout(){this.root.update_layout(),this.root.compute_layout()}invalidate_render(){this.render(),this.invalidate_layout()}has_finished(){if(!super.has_finished())return!1;for(const i of this.child_views)if(!i.has_finished())return!1;return!0}notify_finished(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()}_width_policy(){return null!=this.model.width?"fixed":"fit"}_height_policy(){return null!=this.model.height?"fixed":"fit"}box_sizing(){let{width_policy:i,height_policy:t,aspect_ratio:e}=this.model;"auto"==i&&(i=this._width_policy()),"auto"==t&&(t=this._height_policy());const{sizing_mode:s}=this.model;if(null!=s)if("fixed"==s)i=t="fixed";else if("stretch_both"==s)i=t="max";else if("stretch_width"==s)i="max";else if("stretch_height"==s)t="max";else switch(null==e&&(e="auto"),s){case"scale_width":i="max",t="min";break;case"scale_height":i="min",t="max";break;case"scale_both":i="max",t="max"}const o={width_policy:i,height_policy:t},{min_width:l,min_height:n}=this.model;null!=l&&(o.min_width=l),null!=n&&(o.min_height=n);const{width:h,height:a}=this.model;null!=h&&(o.width=h),null!=a&&(o.height=a);const{max_width:_,max_height:d}=this.model;null!=_&&(o.max_width=_),null!=d&&(o.max_height=d),"auto"==e&&null!=h&&null!=a?o.aspect=h/a:r.isNumber(e)&&(o.aspect=e);const{margin:c}=this.model;if(null!=c)if(r.isNumber(c))o.margin={top:c,right:c,bottom:c,left:c};else if(2==c.length){const[i,t]=c;o.margin={top:i,right:t,bottom:i,left:t}}else{const[i,t,e,s]=c;o.margin={top:i,right:t,bottom:e,left:s}}o.visible=this.model.visible;const{align:u}=this.model;return r.isArray(u)?[o.halign,o.valign]=u:o.halign=o.valign=u,o}_viewport_size(){return h.undisplayed(this.el,()=>{let i=this.el;for(;i=i.parentElement;){if(i.classList.contains(u.bk_root))continue;if(i==document.body){const{margin:{left:i,right:t,top:e,bottom:s}}=h.extents(document.body);return{width:Math.ceil(document.documentElement.clientWidth-i-t),height:Math.ceil(document.documentElement.clientHeight-e-s)}}const{padding:{left:t,right:e,top:s,bottom:o}}=h.extents(i),{width:l,height:n}=i.getBoundingClientRect(),a=Math.ceil(l-t-e),r=Math.ceil(n-s-o);if(a>0||r>0)return{width:a>0?a:void 0,height:r>0?r:void 0}}return{}})}export(i,t=!0){const e="png"==i?"canvas":"svg",s=new m.CanvasLayer(e,t),{width:o,height:l}=this.layout.bbox;s.resize(o,l);for(const e of this.child_views){const o=e.export(i,t),{x:l,y:n}=e.layout.bbox;s.ctx.drawImage(o.canvas,l,n)}return s}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box,children:this.child_views.map(i=>i.serializable_state())})}}e.LayoutDOMView=p,p.__name__="LayoutDOMView";class g extends l.Model{constructor(i){super(i)}static init_LayoutDOM(){this.define(i=>{const{Boolean:t,Number:e,String:s,Auto:o,Color:l,Array:h,Tuple:a,Or:r,Null:_,Nullable:d}=i,u=a(e,e),m=a(e,e,e,e);return{width:[d(e),null],height:[d(e),null],min_width:[d(e),null],min_height:[d(e),null],max_width:[d(e),null],max_height:[d(e),null],margin:[d(r(e,u,m)),[0,0,0,0]],width_policy:[r(c.SizingPolicy,o),"auto"],height_policy:[r(c.SizingPolicy,o),"auto"],aspect_ratio:[r(e,o,_),null],sizing_mode:[d(n.SizingMode),null],visible:[t,!0],disabled:[t,!1],align:[r(n.Align,a(n.Align,n.Align)),"start"],background:[d(l),null],css_classes:[h(s),[]]}})}}e.LayoutDOM=g,g.__name__="LayoutDOM",g.init_LayoutDOM()},
function _(o,t,b,k,n){k(),b.bk_root="bk-root"},
function _(t,s,i,o,n){o();const e=t(298),l=t(245);class u extends e.BoxView{_update_layout(){const t=this.child_views.map(t=>t.layout);this.layout=new l.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())}}i.ColumnView=u,u.__name__="ColumnView";class a extends e.Box{constructor(t){super(t)}static init_Column(){this.prototype.default_view=u,this.define(({Any:t})=>({rows:[t,"auto"]}))}}i.Column=a,a.__name__="Column",a.init_Column()},
function _(t,s,i,o,e){o();const n=t(299),l=t(245);class a extends n.LayoutDOMView{connect_signals(){super.connect_signals();const{children:t,rows:s,cols:i,spacing:o}=this.model.properties;this.on_change([t,s,i,o],()=>this.rebuild())}get child_models(){return this.model.children.map(([t])=>t)}_update_layout(){this.layout=new l.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;for(const[t,s,i,o,e]of this.model.children){const n=this._child_views.get(t);this.layout.items.push({layout:n.layout,row:s,col:i,row_span:o,col_span:e})}this.layout.set_sizing(this.box_sizing())}}i.GridBoxView=a,a.__name__="GridBoxView";class r extends n.LayoutDOM{constructor(t){super(t)}static init_GridBox(){this.prototype.default_view=a,this.define(({Any:t,Int:s,Number:i,Tuple:o,Array:e,Ref:l,Or:a,Opt:r})=>({children:[e(o(l(n.LayoutDOM),s,s,r(s),r(s))),[]],rows:[t,"auto"],cols:[t,"auto"],spacing:[a(i,o(i,i)),0]}))}}i.GridBox=r,r.__name__="GridBox",r.init_GridBox()},
function _(t,e,o,s,n){s();const _=t(299),i=t(241);class a extends _.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new i.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())}}o.HTMLBoxView=a,a.__name__="HTMLBoxView";class u extends _.LayoutDOM{constructor(t){super(t)}}o.HTMLBox=u,u.__name__="HTMLBox"},
function _(e,n,t,i,l){i();const a=e(88),o=e(299);class s extends a.Model{constructor(e){super(e)}static init_Panel(){this.define(({Boolean:e,String:n,Ref:t})=>({title:[n,""],child:[t(o.LayoutDOM)],closable:[e,!1]}))}}t.Panel=s,s.__name__="Panel",s.init_Panel()},
function _(t,s,i,o,e){o();const n=t(298),a=t(245);class _ extends n.BoxView{_update_layout(){const t=this.child_views.map(t=>t.layout);this.layout=new a.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())}}i.RowView=_,_.__name__="RowView";class l extends n.Box{constructor(t){super(t)}static init_Row(){this.prototype.default_view=_,this.define(({Any:t})=>({cols:[t,"auto"]}))}}i.Row=l,l.__name__="Row",l.init_Row()},
function _(t,e,a,i,s){i();const _=t(299),c=t(241);class n extends _.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new c.LayoutItem,this.layout.set_sizing(this.box_sizing())}}a.SpacerView=n,n.__name__="SpacerView";class o extends _.LayoutDOM{constructor(t){super(t)}static init_Spacer(){this.prototype.default_view=n}}a.Spacer=o,o.__name__="Spacer",o.init_Spacer()},
function _(e,t,s,i,a){i();const l=e(1),h=e(241),o=e(71),d=e(9),c=e(20),r=e(299),n=e(304),_=e(192),b=e(308),p=e(309),u=e(85),m=l.__importDefault(e(310)),v=l.__importDefault(e(190)),g=l.__importDefault(e(311));class w extends r.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.tabs.change,()=>this.rebuild()),this.connect(this.model.properties.active.change,()=>this.on_active_change())}styles(){return[...super.styles(),m.default,v.default,g.default]}get child_models(){return this.model.tabs.map(e=>e.child)}_update_layout(){const e=this.model.tabs_location,t="above"==e||"below"==e,{scroll_el:s,headers_el:i}=this;this.header=new class extends h.ContentBox{_measure(e){const a=o.size(s),l=o.children(i).slice(0,3).map(e=>o.size(e)),{width:h,height:c}=super._measure(e);if(t){const t=a.width+d.sum(l.map(e=>e.width));return{width:e.width!=1/0?e.width:t,height:c}}{const t=a.height+d.sum(l.map(e=>e.height));return{width:h,height:e.height!=1/0?e.height:t}}}}(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});let a=1,l=1;switch(e){case"above":a-=1;break;case"below":a+=1;break;case"left":l-=1;break;case"right":l+=1}const c={layout:this.header,row:a,col:l},r=this.child_views.map(e=>({layout:e.layout,row:1,col:1}));this.layout=new h.Grid([c,...r]),this.layout.set_sizing(this.box_sizing())}update_position(){super.update_position(),this.header_el.style.position="absolute",o.position(this.header_el,this.header.bbox);const e=this.model.tabs_location,t="above"==e||"below"==e,s=o.size(this.scroll_el),i=o.scroll_size(this.headers_el);if(t){const{width:e}=this.header.bbox;i.width>e?(this.wrapper_el.style.maxWidth=e-s.width+"px",o.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",o.undisplay(this.scroll_el))}else{const{height:e}=this.header.bbox;i.height>e?(this.wrapper_el.style.maxHeight=e-s.height+"px",o.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",o.undisplay(this.scroll_el))}const{child_views:a}=this;for(const e of a)o.hide(e.el);const l=a[this.model.active];null!=l&&o.show(l.el)}render(){super.render();const{active:e}=this.model,t=this.model.tabs_location,s="above"==t||"below"==t,i=this.model.tabs.map((t,s)=>{const i=o.div({class:[b.bk_tab,s==e?_.bk_active:null]},t.title);if(i.addEventListener("click",e=>{e.target==e.currentTarget&&this.change_active(s)}),t.closable){const e=o.div({class:b.bk_close});e.addEventListener("click",e=>{if(e.target==e.currentTarget){this.model.tabs=d.remove_at(this.model.tabs,s);const e=this.model.tabs.length;this.model.active>e-1&&(this.model.active=e-1)}}),i.appendChild(e)}return i});this.headers_el=o.div({class:[b.bk_headers]},i),this.wrapper_el=o.div({class:b.bk_headers_wrapper},this.headers_el);const a=o.div({class:[p.bk_btn,p.bk_btn_default],disabled:""},o.div({class:[u.bk_caret,_.bk_left]})),l=o.div({class:[p.bk_btn,p.bk_btn_default]},o.div({class:[u.bk_caret,_.bk_right]}));let h=0;const c=e=>()=>{const t=this.model.tabs.length;h="left"==e?Math.max(h-1,0):Math.min(h+1,t-1),0==h?a.setAttribute("disabled",""):a.removeAttribute("disabled"),h==t-1?l.setAttribute("disabled",""):l.removeAttribute("disabled");const i=o.children(this.headers_el).slice(0,h).map(e=>e.getBoundingClientRect());if(s){const e=-d.sum(i.map(e=>e.width));this.headers_el.style.left=e+"px"}else{const e=-d.sum(i.map(e=>e.height));this.headers_el.style.top=e+"px"}};a.addEventListener("click",c("left")),l.addEventListener("click",c("right")),this.scroll_el=o.div({class:p.bk_btn_group},a,l),this.header_el=o.div({class:[b.bk_tabs_header,_.bk_side(t)]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)}change_active(e){e!=this.model.active&&(this.model.active=e)}on_active_change(){const e=this.model.active,t=o.children(this.headers_el);for(const e of t)e.classList.remove(_.bk_active);t[e].classList.add(_.bk_active);const{child_views:s}=this;for(const e of s)o.hide(e.el);o.show(s[e].el)}}s.TabsView=w,w.__name__="TabsView";class f extends r.LayoutDOM{constructor(e){super(e)}static init_Tabs(){this.prototype.default_view=w,this.define(({Int:e,Array:t,Ref:s})=>({tabs:[t(s(n.Panel)),[]],tabs_location:[c.Location,"above"],active:[e,0]}))}}s.Tabs=f,f.__name__="Tabs",f.init_Tabs()},
function _(e,b,a,k,r){k(),a.bk_tabs_header="bk-tabs-header",a.bk_headers_wrapper="bk-headers-wrapper",a.bk_headers="bk-headers",a.bk_tab="bk-tab",a.bk_close="bk-close"},
function _(n,b,t,r,_){r(),t.bk_btn="bk-btn",t.bk_btn_group="bk-btn-group",t.bk_btn_default="bk-btn-default",t.bk_btn_primary="bk-btn-primary",t.bk_btn_success="bk-btn-success",t.bk_btn_warning="bk-btn-warning",t.bk_btn_danger="bk-btn-danger",t.bk_btn_type=function(n){switch(n){case"default":return t.bk_btn_default;case"primary":return t.bk_btn_primary;case"success":return t.bk_btn_success;case"warning":return t.bk_btn_warning;case"danger":return t.bk_btn_danger}},t.bk_dropdown_toggle="bk-dropdown-toggle"},
function _(n,o,b,r,e){r();b.default="\n.bk-root .bk-btn {\n  height: 100%;\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  white-space: nowrap;\n  cursor: pointer;\n  padding: 6px 12px;\n  font-size: 12px;\n  border: 1px solid transparent;\n  border-radius: 4px;\n  outline: 0;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-btn:hover,\n.bk-root .bk-btn:focus {\n  text-decoration: none;\n}\n.bk-root .bk-btn:active,\n.bk-root .bk-btn.bk-active {\n  background-image: none;\n  box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n}\n.bk-root .bk-btn[disabled] {\n  cursor: not-allowed;\n  pointer-events: none;\n  opacity: 0.65;\n  box-shadow: none;\n}\n.bk-root .bk-btn-default {\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-default:hover {\n  background-color: #f5f5f5;\n  border-color: #b8b8b8;\n}\n.bk-root .bk-btn-default.bk-active {\n  background-color: #ebebeb;\n  border-color: #adadad;\n}\n.bk-root .bk-btn-default[disabled],\n.bk-root .bk-btn-default[disabled]:hover,\n.bk-root .bk-btn-default[disabled]:focus,\n.bk-root .bk-btn-default[disabled]:active,\n.bk-root .bk-btn-default[disabled].bk-active {\n  background-color: #e6e6e6;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-primary {\n  color: #fff;\n  background-color: #428bca;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-primary:hover {\n  background-color: #3681c1;\n  border-color: #2c699e;\n}\n.bk-root .bk-btn-primary.bk-active {\n  background-color: #3276b1;\n  border-color: #285e8e;\n}\n.bk-root .bk-btn-primary[disabled],\n.bk-root .bk-btn-primary[disabled]:hover,\n.bk-root .bk-btn-primary[disabled]:focus,\n.bk-root .bk-btn-primary[disabled]:active,\n.bk-root .bk-btn-primary[disabled].bk-active {\n  background-color: #506f89;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-success {\n  color: #fff;\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-success:hover {\n  background-color: #4eb24e;\n  border-color: #409240;\n}\n.bk-root .bk-btn-success.bk-active {\n  background-color: #47a447;\n  border-color: #398439;\n}\n.bk-root .bk-btn-success[disabled],\n.bk-root .bk-btn-success[disabled]:hover,\n.bk-root .bk-btn-success[disabled]:focus,\n.bk-root .bk-btn-success[disabled]:active,\n.bk-root .bk-btn-success[disabled].bk-active {\n  background-color: #667b66;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-warning {\n  color: #fff;\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-warning:hover {\n  background-color: #eea43b;\n  border-color: #e89014;\n}\n.bk-root .bk-btn-warning.bk-active {\n  background-color: #ed9c28;\n  border-color: #d58512;\n}\n.bk-root .bk-btn-warning[disabled],\n.bk-root .bk-btn-warning[disabled]:hover,\n.bk-root .bk-btn-warning[disabled]:focus,\n.bk-root .bk-btn-warning[disabled]:active,\n.bk-root .bk-btn-warning[disabled].bk-active {\n  background-color: #c89143;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-danger {\n  color: #fff;\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-danger:hover {\n  background-color: #d5433e;\n  border-color: #bd2d29;\n}\n.bk-root .bk-btn-danger.bk-active {\n  background-color: #d2322d;\n  border-color: #ac2925;\n}\n.bk-root .bk-btn-danger[disabled],\n.bk-root .bk-btn-danger[disabled]:hover,\n.bk-root .bk-btn-danger[disabled]:focus,\n.bk-root .bk-btn-danger[disabled]:active,\n.bk-root .bk-btn-danger[disabled].bk-active {\n  background-color: #a55350;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-group {\n  height: 100%;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-btn-group > .bk-btn {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n}\n.bk-root .bk-btn-group > .bk-btn + .bk-btn {\n  margin-left: -1px;\n}\n.bk-root .bk-btn-group > .bk-btn:first-child:not(:last-child) {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):last-child {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child) {\n  border-radius: 0;\n}\n.bk-root .bk-btn-group .bk-dropdown-toggle {\n  flex: 0 0 0;\n  -webkit-flex: 0 0 0;\n  padding: 6px 6px;\n}\n"},
function _(e,r,n,b,o){b();n.default='\n.bk-root .bk-tabs-header {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  overflow: hidden;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-tabs-header .bk-btn-group {\n  height: auto;\n  margin-right: 5px;\n}\n.bk-root .bk-tabs-header .bk-btn-group > .bk-btn {\n  flex-grow: 0;\n  -webkit-flex-grow: 0;\n  height: auto;\n  padding: 4px 4px;\n}\n.bk-root .bk-tabs-header .bk-headers-wrapper {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  overflow: hidden;\n  color: #666666;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper {\n  border-bottom: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper {\n  border-left: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper {\n  border-top: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper {\n  border-right: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-above,\n.bk-root .bk-tabs-header.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers,\n.bk-root .bk-tabs-header.bk-below .bk-headers {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-left,\n.bk-root .bk-tabs-header.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers,\n.bk-root .bk-tabs-header.bk-right .bk-headers {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header .bk-headers {\n  position: relative;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n}\n.bk-root .bk-tabs-header .bk-tab {\n  padding: 4px 8px;\n  border: solid transparent;\n  white-space: nowrap;\n  cursor: pointer;\n}\n.bk-root .bk-tabs-header .bk-tab:hover {\n  background-color: #f2f2f2;\n}\n.bk-root .bk-tabs-header .bk-tab.bk-active {\n  color: #4d4d4d;\n  background-color: white;\n  border-color: #e6e6e6;\n}\n.bk-root .bk-tabs-header .bk-tab .bk-close {\n  margin-left: 10px;\n}\n.bk-root .bk-tabs-header.bk-above .bk-tab {\n  border-width: 3px 1px 0px 1px;\n  border-radius: 4px 4px 0 0;\n}\n.bk-root .bk-tabs-header.bk-right .bk-tab {\n  border-width: 1px 3px 1px 0px;\n  border-radius: 0 4px 4px 0;\n}\n.bk-root .bk-tabs-header.bk-below .bk-tab {\n  border-width: 0px 1px 3px 1px;\n  border-radius: 0 0 4px 4px;\n}\n.bk-root .bk-tabs-header.bk-left .bk-tab {\n  border-width: 1px 0px 1px 3px;\n  border-radius: 4px 0 0 4px;\n}\n.bk-root .bk-close {\n  display: inline-block;\n  width: 10px;\n  height: 10px;\n  vertical-align: middle;\n  background-image: url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>\');\n}\n.bk-root .bk-close:hover {\n  background-image: url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>\');\n}\n'},
function _(t,e,i,o,n){o();const _=t(301);class s extends _.ColumnView{}i.WidgetBoxView=s,s.__name__="WidgetBoxView";class d extends _.Column{constructor(t){super(t)}static init_WidgetBox(){this.prototype.default_view=s}}i.WidgetBox=d,d.__name__="WidgetBox",d.init_WidgetBox()},
function _(r,t,a,e,c){e();r(1).__exportStar(r(314),a),c("Marker",r(315).Marker),c("Scatter",r(316).Scatter)},
function _(e,t,o,i,r){i();const n=e(1),s=e(315),c=n.__importStar(e(266)),l=Math.sqrt(3);function a(e,t){e.rotate(Math.PI/4),d(e,t),e.rotate(-Math.PI/4)}function u(e,t){const o=t*l,i=o/3;e.moveTo(-o/2,-i),e.lineTo(0,0),e.lineTo(o/2,-i),e.lineTo(0,0),e.lineTo(0,t)}function d(e,t){e.moveTo(0,t),e.lineTo(0,-t),e.moveTo(-t,0),e.lineTo(t,0)}function v(e,t){e.moveTo(0,t),e.lineTo(t/1.5,0),e.lineTo(0,-t),e.lineTo(-t/1.5,0),e.closePath()}function _(e,t){const o=t*l,i=o/3;e.moveTo(-t,i),e.lineTo(t,i),e.lineTo(0,i-o),e.closePath()}function f(e,t,o,i,r){d(e,o),a(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function T(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function z(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),d(e,o),e.stroke())}function C(e,t,o,i,r){T(e,t,o,i,r),g(e,t,o,i,r)}function k(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),u(e,o),e.stroke())}function m(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),a(e,o),e.stroke())}function h(e,t,o,i,r){d(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function q(e,t,o,i,r){v(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function P(e,t,o,i,r){v(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.moveTo(0,o),e.lineTo(0,-o),e.moveTo(-o/1.5,0),e.lineTo(o/1.5,0),e.stroke())}function D(e,t,o,i,r){q(e,t,o,i,r),g(e,t,o,i,r)}function g(e,t,o,i,r){!function(e,t){e.beginPath(),e.arc(0,0,t/4,0,2*Math.PI,!1),e.closePath()}(e,o),i.set_vectorize(e,t),e.fillStyle=e.strokeStyle,e.fill()}function S(e,t,o,i,r){!function(e,t){const o=t/2,i=l*o;e.moveTo(t,0),e.lineTo(o,-i),e.lineTo(-o,-i),e.lineTo(-t,0),e.lineTo(-o,i),e.lineTo(o,i),e.closePath()}(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function G(e,t,o,i,r){S(e,t,o,i,r),g(e,t,o,i)}function L(e,t,o,i,r){e.rotate(Math.PI),_(e,o),e.rotate(-Math.PI),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function x(e,t,o,i,r){const n=3*o/8,s=[n,n,o,o,n,n,-n,-n,-o,-o,-n,-n],c=[o,n,n,-n,-n,-o,-o,-n,-n,n,n,o];for(e.moveTo(s[0],c[0]),t=1;t<12;t++)e.lineTo(s[t],c[t]);e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function I(e,t,o,i,r){const n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function M(e,t,o,i,r){const n=3*o/8;e.moveTo(-o,-o),e.quadraticCurveTo(0,-n,o,-o),e.quadraticCurveTo(n,0,o,o),e.quadraticCurveTo(0,n,-o,o),e.quadraticCurveTo(-n,0,-o,-o),e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function p(e,t,o,i,r){const n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),d(e,o),e.stroke())}function X(e,t,o,i,r){I(e,t,o,i,r),g(e,t,o,i)}function y(e,t,o,i,r){const n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.moveTo(-o,o),e.lineTo(o,-o),e.moveTo(-o,-o),e.lineTo(o,o),e.stroke())}function H(e,t,o,i,r){_(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function Y(e,t,o,i,r){H(e,t,o,i,r),g(e,t,o,i)}function A(e,t,o,i,r){const n=o*l,s=n/3,c=3*s/8;e.moveTo(-o,s),e.quadraticCurveTo(0,c,o,s),e.quadraticCurveTo(l*c/2,c/2,0,s-n),e.quadraticCurveTo(-l*c/2,c/2,-o,s),e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function w(e,t,o,i,r){!function(e,t){e.moveTo(-t,0),e.lineTo(t,0)}(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function b(e,t,o,i,r){a(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function V(e,t,o,i,r){u(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function j(e,t,o){var i;const r=class extends s.MarkerView{static initClass(){this.prototype._render_one=t,this.prototype.glglyph_cls=o}};r.initClass();const n=((i=class extends s.Marker{static initClass(){this.prototype.default_view=r}}).__name__=e,i);return n.initClass(),n}o.Asterisk=j("Asterisk",f,c.AsteriskGL),o.CircleCross=j("CircleCross",z,c.CircleCrossGL),o.CircleDot=j("CircleDot",C),o.CircleY=j("CircleY",k),o.CircleX=j("CircleX",m,c.CircleXGL),o.Cross=j("Cross",h,c.CrossGL),o.Dash=j("Dash",w),o.Diamond=j("Diamond",q,c.DiamondGL),o.DiamondCross=j("DiamondCross",P,c.DiamondCrossGL),o.DiamondDot=j("DiamondDot",D),o.Dot=j("Dot",g),o.Hex=j("Hex",S,c.HexGL),o.HexDot=j("HexDot",G),o.InvertedTriangle=j("InvertedTriangle",L,c.InvertedTriangleGL),o.Plus=j("Plus",x),o.Square=j("Square",I,c.SquareGL),o.SquareCross=j("SquareCross",p,c.SquareCrossGL),o.SquareDot=j("SquareDot",X),o.SquarePin=j("SquarePin",M),o.SquareX=j("SquareX",y,c.SquareXGL),o.Triangle=j("Triangle",H,c.TriangleGL),o.TriangleDot=j("TriangleDot",Y),o.TrianglePin=j("TrianglePin",A),o.X=j("X",b,c.XGL),o.Y=j("Y",V),o.marker_funcs={asterisk:f,circle:T,circle_cross:z,circle_dot:C,circle_y:k,circle_x:m,cross:h,diamond:q,diamond_dot:D,diamond_cross:P,dot:g,hex:S,hex_dot:G,inverted_triangle:L,plus:x,square:I,square_cross:p,square_dot:X,square_pin:M,square_x:y,triangle:H,triangle_dot:Y,triangle_pin:A,dash:w,x:b,y:V}},
function _(e,s,t,i,n){i();const r=e(1),a=e(106),_=e(28),h=r.__importStar(e(108)),c=r.__importStar(e(18)),l=e(9),o=e(94);class x extends a.XYGlyphView{initialize(){super.initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;null!=e&&null!=this.glglyph_cls&&(this.glglyph=new this.glglyph_cls(e.gl,this))}_render(e,s,{sx:t,sy:i,_size:n,_angle:r}){for(const a of s){if(isNaN(t[a]+i[a]+n[a]+r[a]))continue;const s=n[a]/2;e.beginPath(),e.translate(t[a],i[a]),r[a]&&e.rotate(r[a]),this._render_one(e,a,s,this.visuals.line,this.visuals.fill),r[a]&&e.rotate(-r[a]),e.translate(-t[a],-i[a])}}_mask_data(){const{x_target:e,y_target:s}=this.renderer.plot_view.frame,t=e.widen(this.max_size).map(e=>this.renderer.xscale.invert(e)),i=s.widen(this.max_size).map(e=>this.renderer.yscale.invert(e));return this.index.indices({x0:t.start,x1:t.end,y0:i.start,y1:i.end})}_hit_point(e){const{sx:s,sy:t}=e,i=s-this.max_size,n=s+this.max_size,[r,a]=this.renderer.xscale.r_invert(i,n),_=t-this.max_size,h=t+this.max_size,[c,l]=this.renderer.yscale.r_invert(_,h),x=this.index.indices({x0:r,x1:a,y0:c,y1:l}),y=[];for(const e of x){const i=this._size[e]/2;Math.abs(this.sx[e]-s)<=i&&Math.abs(this.sy[e]-t)<=i&&y.push(e)}return new o.Selection({indices:y})}_hit_span(e){const{sx:s,sy:t}=e,i=this.bounds(),n=this.max_size/2;let r,a,_,h;if("h"==e.direction){_=i.y0,h=i.y1;const e=s-n,t=s+n;[r,a]=this.renderer.xscale.r_invert(e,t)}else{r=i.x0,a=i.x1;const e=t-n,s=t+n;[_,h]=this.renderer.yscale.r_invert(e,s)}const c=[...this.index.indices({x0:r,x1:a,y0:_,y1:h})];return new o.Selection({indices:c})}_hit_rect(e){const{sx0:s,sx1:t,sy0:i,sy1:n}=e,[r,a]=this.renderer.xscale.r_invert(s,t),[_,h]=this.renderer.yscale.r_invert(i,n),c=[...this.index.indices({x0:r,x1:a,y0:_,y1:h})];return new o.Selection({indices:c})}_hit_poly(e){const{sx:s,sy:t}=e,i=l.range(0,this.sx.length),n=[];for(let e=0,r=i.length;e<r;e++){const r=i[e];h.point_in_poly(this.sx[e],this.sy[e],s,t)&&n.push(r)}return new o.Selection({indices:n})}_get_legend_args({x0:e,x1:s,y0:t,y1:i},n){const r=n+1,a=new Array(r);a[n]=(e+s)/2;const _=new Array(r);_[n]=(t+i)/2;const h=new Array(r);h[n]=.4*Math.min(Math.abs(s-e),Math.abs(i-t));const c=new Array(r);return c[n]=0,{sx:a,sy:_,_size:h,_angle:c}}draw_legend_for_index(e,{x0:s,x1:t,y0:i,y1:n},r){const a=this._get_legend_args({x0:s,x1:t,y0:i,y1:n},r);this._render(e,[r],a)}}t.MarkerView=x,x.__name__="MarkerView";class y extends a.XYGlyph{constructor(e){super(e)}static init_Marker(){this.mixins([_.LineVector,_.FillVector]),this.define(({})=>({size:[c.ScreenDistanceSpec,{value:4}],angle:[c.AngleSpec,0]}))}}t.Marker=y,y.__name__="Marker",y.init_Marker()},
function _(e,t,r,a,s){a();const i=e(1),n=e(315),_=e(314),c=i.__importStar(e(18));class l extends n.MarkerView{_render(e,t,{sx:r,sy:a,_size:s,_angle:i,_marker:n}){for(const c of t){if(isNaN(r[c]+a[c]+s[c]+i[c])||null==n[c])continue;const t=s[c]/2;e.beginPath(),e.translate(r[c],a[c]),i[c]&&e.rotate(i[c]),_.marker_funcs[n[c]](e,c,t,this.visuals.line,this.visuals.fill),i[c]&&e.rotate(-i[c]),e.translate(-r[c],-a[c])}}draw_legend_for_index(e,{x0:t,x1:r,y0:a,y1:s},i){const n=this._get_legend_args({x0:t,x1:r,y0:a,y1:s},i),_=new Array(i+1);_[i]=this._marker[i],n._marker=_,this._render(e,[i],n)}}r.ScatterView=l,l.__name__="ScatterView";class o extends n.Marker{constructor(e){super(e)}static init_Scatter(){this.prototype.default_view=l,this.define(({})=>({marker:[c.MarkerSpec,{value:"circle"}]}))}}r.Scatter=o,o.__name__="Scatter",o.init_Scatter()},
function _(p,o,t,a,n){a(),n("MapOptions",p(318).MapOptions),n("GMapOptions",p(318).GMapOptions),n("GMapPlot",p(318).GMapPlot),n("Plot",p(319).Plot)},
function _(t,i,n,e,a){e();const s=t(319),o=t(88),p=t(168),_=t(326);a("GMapPlotView",_.GMapPlotView);class l extends o.Model{constructor(t){super(t)}static init_MapOptions(){this.define(({Int:t,Number:i})=>({lat:[i],lng:[i],zoom:[t,12]}))}}n.MapOptions=l,l.__name__="MapOptions",l.init_MapOptions();class r extends l{constructor(t){super(t)}static init_GMapOptions(){this.define(({Boolean:t,Int:i,String:n})=>({map_type:[n,"roadmap"],scale_control:[t,!1],styles:[n],tilt:[i,45]}))}}n.GMapOptions=r,r.__name__="GMapOptions",r.init_GMapOptions();class c extends s.Plot{constructor(t){super(t),this.use_map=!0}static init_GMapPlot(){this.prototype.default_view=_.GMapPlotView,this.define(({String:t,Ref:i})=>({map_options:[i(r)],api_key:[t]})),this.override({x_range:()=>new p.Range1d,y_range:()=>new p.Range1d})}}n.GMapPlot=c,c.__name__="GMapPlot",c.init_GMapPlot()},
function _(e,t,i,n,r){n();const o=e(1),a=o.__importStar(e(28)),s=o.__importStar(e(18)),l=e(15),_=e(20),h=e(9),c=e(13),d=e(8),u=e(299),g=e(205),p=e(296),f=e(35),b=e(181),w=e(157),m=e(183),y=e(101),v=e(159),x=e(130),A=e(69),R=e(104),S=e(103),P=e(238),D=e(320);r("PlotView",D.PlotView);class L extends u.LayoutDOM{constructor(e){super(e),this.use_map=!1}static init_Plot(){this.prototype.default_view=D.PlotView,this.mixins([["outline_",a.Line],["background_",a.Fill],["border_",a.Fill]]),this.define(({Boolean:e,Number:t,String:i,Array:n,Dict:r,Or:o,Ref:a,Null:l,Nullable:h})=>({toolbar:[a(m.Toolbar),()=>new m.Toolbar],toolbar_location:[h(_.Location),"right"],toolbar_sticky:[e,!0],plot_width:[s.Alias("width")],plot_height:[s.Alias("height")],frame_width:[h(t),null],frame_height:[h(t),null],title:[o(a(b.Title),i,l),()=>new b.Title({text:""})],title_location:[h(_.Location),"above"],above:[n(o(a(f.Annotation),a(g.Axis))),[]],below:[n(o(a(f.Annotation),a(g.Axis))),[]],left:[n(o(a(f.Annotation),a(g.Axis))),[]],right:[n(o(a(f.Annotation),a(g.Axis))),[]],center:[n(o(a(f.Annotation),a(p.Grid))),[]],renderers:[n(a(A.Renderer)),[]],x_range:[a(y.Range),()=>new P.DataRange1d],extra_x_ranges:[r(a(y.Range)),{}],y_range:[a(y.Range),()=>new P.DataRange1d],extra_y_ranges:[r(a(y.Range)),{}],x_scale:[a(v.Scale),()=>new w.LinearScale],y_scale:[a(v.Scale),()=>new w.LinearScale],lod_factor:[t,10],lod_interval:[t,300],lod_threshold:[t,2e3],lod_timeout:[t,500],hidpi:[e,!0],output_backend:[_.OutputBackend,"canvas"],min_border:[h(t),5],min_border_top:[h(t),null],min_border_left:[h(t),null],min_border_bottom:[h(t),null],min_border_right:[h(t),null],inner_width:[t],inner_height:[t],outer_width:[t],outer_height:[t],match_aspect:[e,!1],aspect_scale:[t,1],reset_policy:[_.ResetPolicy,"standard"]})),this.override({width:600,height:600,outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})}_doc_attached(){super._doc_attached(),this._push_changes([[this.properties.inner_height,null,this.inner_height],[this.properties.inner_width,null,this.inner_width]])}initialize(){super.initialize(),this.reset=new l.Signal0(this,"reset");for(const e of c.values(this.extra_x_ranges).concat(this.x_range)){let t=e.plots;d.isArray(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}for(const e of c.values(this.extra_y_ranges).concat(this.y_range)){let t=e.plots;d.isArray(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}}add_layout(e,t="center"){const i=this.properties[t].get_value();this.setv({[t]:[...i,e]})}remove_layout(e){const t=t=>{h.remove_by(t,t=>t==e)};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)}get data_renderers(){return this.renderers.filter(e=>e instanceof R.DataRenderer)}add_renderers(...e){this.renderers=this.renderers.concat(e)}add_glyph(e,t=new x.ColumnDataSource,i={}){const n=Object.assign(Object.assign({},i),{data_source:t,glyph:e}),r=new S.GlyphRenderer(n);return this.add_renderers(r),r}add_tools(...e){this.toolbar.tools=this.toolbar.tools.concat(e)}get panels(){return[...this.side_panels,...this.center]}get side_panels(){const{above:e,below:t,left:i,right:n}=this;return h.concat([e,t,i,n])}}i.Plot=L,L.__name__="Plot",L.init_Plot()},
function _(e,t,i,s,n){s();var a=this&&this.__rest||function(e,t){var i={};for(var s in e)Object.prototype.hasOwnProperty.call(e,s)&&t.indexOf(s)<0&&(i[s]=e[s]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(s=Object.getOwnPropertySymbols(e);n<s.length;n++)t.indexOf(s[n])<0&&Object.prototype.propertyIsEnumerable.call(e,s[n])&&(i[s[n]]=e[s[n]])}return i};const o=e(236),l=e(76),r=e(299),_=e(181),h=e(205),d=e(182),c=e(80),u=e(123),p=e(73),b=e(19),m=e(321),g=e(8),v=e(9),w=e(244),y=e(322),f=e(323),x=e(245),z=e(86),k=e(324),O=e(325);class q extends r.LayoutDOMView{constructor(){super(...arguments),this._outer_bbox=new z.BBox,this._inner_bbox=new z.BBox,this._needs_paint=!0,this._needs_layout=!1,this._invalidated_painters=new Set,this._invalidate_all=!0}get state(){return this._state_manager}set invalidate_dataranges(e){this._range_manager.invalidate_dataranges=e}renderer_view(e){const t=this.renderer_views.get(e);if(null==t)for(const[,t]of this.renderer_views){const i=t.renderer_view(e);if(null!=i)return i}return t}get is_paused(){return null!=this._is_paused&&0!==this._is_paused}get child_models(){return[]}pause(){null==this._is_paused?this._is_paused=1:this._is_paused+=1}unpause(e=!1){if(null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||e||this.request_paint()}request_render(){this.request_paint()}request_paint(e){if(null!=e?this._invalidated_painters.add(e):this._invalidate_all=!0,!this.is_paused){const e=this.throttled_paint();this._ready=this._ready.then(()=>e)}}request_layout(){this._needs_layout=!0,this.request_paint()}reset(){"standard"==this.model.reset_policy&&(this.state.clear(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new c.Reset)}remove(){u.remove_views(this.renderer_views),u.remove_views(this.tool_views),this.canvas_view.remove(),super.remove()}render(){super.render(),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()}initialize(){this.pause(),super.initialize(),this.lod_started=!1,this.visuals=new p.Visuals(this.model),this._initial_state={selection:new Map,dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.renderer_views=new Map,this.tool_views=new Map;const{hidpi:e,output_backend:t}=this.model;this.canvas=new l.Canvas({hidpi:e,output_backend:t}),this.frame=new o.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges),this._range_manager=new k.RangeManager(this),this._state_manager=new O.StateManager(this,this._initial_state),this.throttled_paint=m.throttle(()=>this.repaint(),1e3/60);const{title_location:i,title:s}=this.model;null!=i&&null!=s&&(this._title=s instanceof _.Title?s:new _.Title({text:s}));const{toolbar_location:n,toolbar:a}=this.model;null!=n&&null!=a&&(this._toolbar=new d.ToolbarPanel({toolbar:a}),a.toolbar_location=n)}async lazy_initialize(){await super.lazy_initialize(),this.canvas_view=await u.build_view(this.canvas,{parent:this}),this.canvas_view.plot_views=[this],await this.build_renderer_views(),await this.build_tool_views(),this._range_manager.update_dataranges(),this.unpause(!0),b.logger.debug("PlotView initialized")}_width_policy(){return null==this.model.frame_width?super._width_policy():"min"}_height_policy(){return null==this.model.frame_height?super._height_policy():"min"}_update_layout(){this.layout=new y.BorderLayout,this.layout.set_sizing(this.box_sizing());const{frame_width:e,frame_height:t}=this.model;this.layout.center_panel=this.frame,this.layout.center_panel.set_sizing(Object.assign(Object.assign({},null!=e?{width_policy:"fixed",width:e}:{width_policy:"fit"}),null!=t?{height_policy:"fixed",height:t}:{height_policy:"fit"}));const i=v.copy(this.model.above),s=v.copy(this.model.below),n=v.copy(this.model.left),a=v.copy(this.model.right),o=e=>{switch(e){case"above":return i;case"below":return s;case"left":return n;case"right":return a}},{title_location:l,title:r}=this.model;null!=l&&null!=r&&o(l).push(this._title);const{toolbar_location:h,toolbar:c}=this.model;if(null!=h&&null!=c){const e=o(h);let t=!0;if(this.model.toolbar_sticky)for(let i=0;i<e.length;i++){const s=e[i];if(s instanceof _.Title){e[i]="above"==h||"below"==h?[s,this._toolbar]:[this._toolbar,s],t=!1;break}}t&&e.push(this._toolbar)}const u=(e,t)=>{const i=this.renderer_view(t);return i.layout=new f.SidePanel(e,i)},p=(e,t)=>{const i="above"==e||"below"==e,s=[];for(const n of t)if(g.isArray(n)){const t=n.map(t=>{const s=u(e,t);if(t instanceof d.ToolbarPanel){const e=i?"width_policy":"height_policy";s.set_sizing(Object.assign(Object.assign({},s.sizing),{[e]:"min"}))}return s});let a;i?(a=new x.Row(t),a.set_sizing({width_policy:"max",height_policy:"min"})):(a=new x.Column(t),a.set_sizing({width_policy:"min",height_policy:"max"})),a.absolute=!0,s.push(a)}else s.push(u(e,n));return s},b=null!=this.model.min_border?this.model.min_border:0;this.layout.min_border={left:null!=this.model.min_border_left?this.model.min_border_left:b,top:null!=this.model.min_border_top?this.model.min_border_top:b,right:null!=this.model.min_border_right?this.model.min_border_right:b,bottom:null!=this.model.min_border_bottom?this.model.min_border_bottom:b};const m=new w.VStack,z=new w.VStack,k=new w.HStack,O=new w.HStack;m.children=v.reversed(p("above",i)),z.children=p("below",s),k.children=v.reversed(p("left",n)),O.children=p("right",a),m.set_sizing({width_policy:"fit",height_policy:"min"}),z.set_sizing({width_policy:"fit",height_policy:"min"}),k.set_sizing({width_policy:"min",height_policy:"fit"}),O.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.top_panel=m,this.layout.bottom_panel=z,this.layout.left_panel=k,this.layout.right_panel=O}get axis_views(){const e=[];for(const[,t]of this.renderer_views)t instanceof h.AxisView&&e.push(t);return e}set_toolbar_visibility(e){for(const t of this.visibility_callbacks)t(e)}update_range(e,t){this.pause(),this._range_manager.update(e,t),this.unpause()}reset_range(){this.update_range(null)}get_selection(){const e=new Map;for(const t of this.model.data_renderers){const{selected:i}=t.selection_manager.source;e.set(t,i)}return e}update_selection(e){for(const t of this.model.data_renderers){const i=t.selection_manager.source;if(null!=e){const s=e.get(t);null!=s&&i.selected.update(s,!0)}else i.selection_manager.clear()}}reset_selection(){this.update_selection(null)}_invalidate_layout(){(()=>{for(const e of this.model.side_panels){if(this.renderer_views.get(e).layout.has_size_changed())return!0}return!1})()&&this.root.compute_layout()}get_renderer_views(){return this.computed_renderers.map(e=>this.renderer_views.get(e))}*_compute_renderers(){const{above:e,below:t,left:i,right:s,center:n,renderers:a}=this.model;yield*e,yield*t,yield*i,yield*s,yield*n,yield*a,null!=this._title&&(yield this._title),null!=this._toolbar&&(yield this._toolbar);for(const e of this.model.toolbar.tools)null!=e.overlay&&(yield e.overlay),yield*e.synthetic_renderers}async build_renderer_views(){this.computed_renderers=[...this._compute_renderers()],await u.build_views(this.renderer_views,this.computed_renderers,{parent:this})}async build_tool_views(){const e=this.model.toolbar.tools;(await u.build_views(this.tool_views,e,{parent:this})).map(e=>this.canvas_view.ui_event_bus.register_tool(e))}connect_signals(){super.connect_signals();const{x_ranges:e,y_ranges:t}=this.frame;for(const[,t]of e)this.connect(t.change,()=>{this._needs_layout=!0,this.request_paint()});for(const[,e]of t)this.connect(e.change,()=>{this._needs_layout=!0,this.request_paint()});const{above:i,below:s,left:n,right:a,center:o,renderers:l}=this.model.properties;this.on_change([i,s,n,a,o,l],async()=>await this.build_renderer_views()),this.connect(this.model.toolbar.properties.tools.change,async()=>{await this.build_renderer_views(),await this.build_tool_views()}),this.connect(this.model.change,()=>this.request_paint()),this.connect(this.model.reset,()=>this.reset())}has_finished(){if(!super.has_finished())return!1;if(this.model.visible)for(const[,e]of this.renderer_views)if(!e.has_finished())return!1;return!0}after_layout(){if(super.after_layout(),this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame.bbox.width),inner_height:Math.round(this.frame.bbox.height),outer_width:Math.round(this.layout.bbox.width),outer_height:Math.round(this.layout.bbox.height)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this._range_manager.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){const{width:e,height:t}=this.layout.bbox;this.canvas_view.resize(e,t),this._outer_bbox=this.layout.bbox,this._invalidate_all=!0,this._needs_paint=!0}this._inner_bbox.equals(this.frame.inner_bbox)||(this._inner_bbox=this.layout.inner_bbox,this._needs_paint=!0),this._needs_paint&&this.paint()}repaint(){this._needs_layout&&this._invalidate_layout(),this.paint()}paint(){var e;if(this.is_paused||!this.model.visible)return;b.logger.trace("PlotView.paint() for "+this.model.id);const{document:t}=this.model;if(null!=t){const e=t.interactive_duration();e>=0&&e<this.model.lod_interval?setTimeout(()=>{t.interactive_duration()>this.model.lod_timeout&&t.interactive_stop(),this.request_paint()},this.model.lod_timeout):t.interactive_stop()}this._range_manager.invalidate_dataranges&&this._range_manager.update_dataranges();let i=!1,s=!1;if(this._invalidate_all)i=!0,s=!0;else for(const e of this._invalidated_painters){const{level:t}=e.model;if("overlay"!=t?i=!0:s=!0,i&&s)break}this._invalidated_painters.clear(),this._invalidate_all=!1;const n=[this.frame.bbox.left,this.frame.bbox.top,this.frame.bbox.width,this.frame.bbox.height],{primary:a,overlays:o}=this.canvas_view;i&&(a.prepare(),this.canvas_view.prepare_webgl(n),this._map_hook(a.ctx,n),this._paint_empty(a.ctx,n),this._paint_outline(a.ctx,n),this._paint_levels(a.ctx,"image",n,!0),this._paint_levels(a.ctx,"underlay",n,!0),this._paint_levels(a.ctx,"glyph",n,!0),this._paint_levels(a.ctx,"guide",n,!1),this._paint_levels(a.ctx,"annotation",n,!1),a.finish()),s&&(o.prepare(),this._paint_levels(o.ctx,"overlay",n,!1),o.finish()),null==this._initial_state.range&&(this._initial_state.range=null!==(e=this._range_manager.compute_initial())&&void 0!==e?e:void 0),this._needs_paint=!1}_paint_levels(e,t,i,s){for(const n of this.computed_renderers){if(n.level!=t)continue;const a=this.renderer_views.get(n);e.save(),(s||a.needs_clip)&&(e.beginPath(),e.rect(...i),e.clip()),a.render(),e.restore(),a.has_webgl&&a.needs_webgl_blit&&this.canvas_view.blit_webgl(e)}}_map_hook(e,t){}_paint_empty(e,t){const[i,s,n,a]=[0,0,this.layout.bbox.width,this.layout.bbox.height],[o,l,r,_]=t;this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(e),e.fillRect(i,s,n,a),e.clearRect(o,l,r,_)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fillRect(o,l,r,_))}_paint_outline(e,t){if(this.visuals.outline_line.doit){e.save(),this.visuals.outline_line.set_value(e);let[i,s,n,a]=t;i+n==this.layout.bbox.width&&(n-=1),s+a==this.layout.bbox.height&&(a-=1),e.strokeRect(i,s,n,a),e.restore()}}to_blob(){return this.canvas_view.to_blob()}export(e,t=!0){const i="png"==e?"canvas":"svg",s=new l.CanvasLayer(i,t),{width:n,height:a}=this.layout.bbox;s.resize(n,a);const{canvas:o}=this.canvas_view.compose();return s.ctx.drawImage(o,0,0),s}serializable_state(){const e=super.serializable_state(),{children:t}=e,i=a(e,["children"]),s=this.get_renderer_views().map(e=>e.serializable_state()).filter(e=>null!=e.bbox);return Object.assign(Object.assign({},i),{children:[...null!=t?t:[],...s]})}}i.PlotView=q,q.__name__="PlotView"},
function _(t,n,e,o,u){o(),e.throttle=function(t,n){let e=null,o=0,u=!1;return function(){return new Promise((r,i)=>{const l=function(){o=Date.now(),e=null,u=!1;try{t(),r()}catch(t){i(t)}},a=Date.now(),c=n-(a-o);c<=0&&!u?(null!=e&&clearTimeout(e),u=!0,requestAnimationFrame(l)):e||u?r():e=setTimeout(()=>requestAnimationFrame(l),c)})}}},
function _(t,e,h,i,o){i();const r=t(242),s=t(243),n=t(86);class a extends s.Layoutable{constructor(){super(...arguments),this.min_border={left:0,top:0,right:0,bottom:0}}_measure(t){t=new r.Sizeable(t).bounded_to(this.sizing.size);const e=this.left_panel.measure({width:0,height:t.height}),h=Math.max(e.width,this.min_border.left),i=this.right_panel.measure({width:0,height:t.height}),o=Math.max(i.width,this.min_border.right),s=this.top_panel.measure({width:t.width,height:0}),n=Math.max(s.height,this.min_border.top),a=this.bottom_panel.measure({width:t.width,height:0}),g=Math.max(a.height,this.min_border.bottom),_=new r.Sizeable(t).shrink_by({left:h,right:o,top:n,bottom:g}),m=this.center_panel.measure(_);return{width:h+m.width+o,height:n+m.height+g,inner:{left:h,right:o,top:n,bottom:g},align:(()=>{const{width_policy:t,height_policy:e}=this.center_panel.sizing;return"fixed"!=t&&"fixed"!=e})()}}_set_geometry(t,e){super._set_geometry(t,e),this.center_panel.set_geometry(e);const h=this.left_panel.measure({width:0,height:t.height}),i=this.right_panel.measure({width:0,height:t.height}),o=this.top_panel.measure({width:t.width,height:0}),r=this.bottom_panel.measure({width:t.width,height:0}),{left:s,top:a,right:g,bottom:_}=e;this.top_panel.set_geometry(new n.BBox({left:s,right:g,bottom:a,height:o.height})),this.bottom_panel.set_geometry(new n.BBox({left:s,right:g,top:_,height:r.height})),this.left_panel.set_geometry(new n.BBox({top:a,bottom:_,right:s,width:h.width})),this.right_panel.set_geometry(new n.BBox({top:a,bottom:_,left:g,width:i.width}))}}h.BorderLayout=a,a.__name__="BorderLayout"},
function _(i,t,e,l,a){l();const r=i(242),o=i(243),s=i(8),h=Math.PI/2,n="alphabetic",_="top",d="middle",c="hanging",m="left",g="right",b="center",z={above:{parallel:0,normal:-h,horizontal:0,vertical:-h},below:{parallel:0,normal:h,horizontal:0,vertical:h},left:{parallel:-h,normal:0,horizontal:0,vertical:-h},right:{parallel:h,normal:0,horizontal:0,vertical:h}},u={above:{justified:_,parallel:n,normal:d,horizontal:n,vertical:d},below:{justified:"bottom",parallel:c,normal:d,horizontal:c,vertical:d},left:{justified:_,parallel:n,normal:d,horizontal:d,vertical:n},right:{justified:_,parallel:n,normal:d,horizontal:d,vertical:n}},p={above:{justified:b,parallel:b,normal:m,horizontal:b,vertical:m},below:{justified:b,parallel:b,normal:m,horizontal:b,vertical:m},left:{justified:b,parallel:b,normal:g,horizontal:g,vertical:b},right:{justified:b,parallel:b,normal:m,horizontal:m,vertical:b}},v={above:g,below:m,left:g,right:m},f={above:m,below:g,left:g,right:m};class w extends o.ContentLayoutable{constructor(i,t){switch(super(),this.side=i,this.obj=t,this.side){case"above":this._dim=0,this._normals=[0,-1];break;case"below":this._dim=0,this._normals=[0,1];break;case"left":this._dim=1,this._normals=[-1,0];break;case"right":this._dim=1,this._normals=[1,0]}this.is_horizontal?this.set_sizing({width_policy:"max",height_policy:"fixed"}):this.set_sizing({width_policy:"fixed",height_policy:"max"})}_content_size(){return new r.Sizeable(this.get_oriented_size())}get_oriented_size(){const{width:i,height:t}=this.obj.get_size();return!this.obj.rotate||this.is_horizontal?{width:i,height:t}:{width:t,height:i}}has_size_changed(){const{width:i,height:t}=this.get_oriented_size();return this.is_horizontal?this.bbox.height!=t:this.bbox.width!=i}get dimension(){return this._dim}get normals(){return this._normals}get is_horizontal(){return 0==this._dim}get is_vertical(){return 1==this._dim}apply_label_text_heuristics(i,t){const e=this.side;let l,a;s.isString(t)?(l=u[e][t],a=p[e][t]):t<0?(l="middle",a=v[e]):(l="middle",a=f[e]),i.textBaseline=l,i.textAlign=a}get_label_angle_heuristic(i){return z[this.side][i]}}e.SidePanel=w,w.__name__="SidePanel"},
function _(t,n,e,s,a){s();const o=t(238),r=t(19);class l{constructor(t){this.parent=t,this.invalidate_dataranges=!0}get frame(){return this.parent.frame}update(t,n){const{x_ranges:e,y_ranges:s}=this.frame;if(null==t){for(const[,t]of e)t.reset();for(const[,t]of s)t.reset();this.update_dataranges()}else{const a=[];for(const[n,s]of e)a.push([s,t.xrs.get(n)]);for(const[n,e]of s)a.push([e,t.yrs.get(n)]);(null==n?void 0:n.scrolling)&&this._update_ranges_together(a),this._update_ranges_individually(a,n)}}reset(){this.update(null)}update_dataranges(){const t=new Map,n=new Map;let e=!1;for(const[,t]of this.frame.x_ranges)t instanceof o.DataRange1d&&"log"==t.scale_hint&&(e=!0);for(const[,t]of this.frame.y_ranges)t instanceof o.DataRange1d&&"log"==t.scale_hint&&(e=!0);for(const s of this.parent.model.data_renderers){const a=this.parent.renderer_view(s);if(null==a)continue;const o=a.glyph_view.bounds();if(null!=o&&t.set(s,o),e){const t=a.glyph_view.log_bounds();null!=t&&n.set(s,t)}}let s=!1,a=!1;const{width:l,height:i}=this.frame.bbox;let d;!1!==this.parent.model.match_aspect&&0!=l&&0!=i&&(d=1/this.parent.model.aspect_scale*(l/i));for(const[,e]of this.frame.x_ranges){if(e instanceof o.DataRange1d){const a="log"==e.scale_hint?n:t;e.update(a,0,this.parent.model,d),e.follow&&(s=!0)}null!=e.bounds&&(a=!0)}for(const[,e]of this.frame.y_ranges){if(e instanceof o.DataRange1d){const a="log"==e.scale_hint?n:t;e.update(a,1,this.parent.model,d),e.follow&&(s=!0)}null!=e.bounds&&(a=!0)}if(s&&a){r.logger.warn("Follow enabled so bounds are unset.");for(const[,t]of this.frame.x_ranges)t.bounds=null;for(const[,t]of this.frame.y_ranges)t.bounds=null}this.invalidate_dataranges=!1}compute_initial(){let t=!0;const{x_ranges:n,y_ranges:e}=this.frame,s=new Map,a=new Map;for(const[e,a]of n){const{start:n,end:o}=a;if(null==n||null==o||isNaN(n+o)){t=!1;break}s.set(e,{start:n,end:o})}if(t)for(const[n,s]of e){const{start:e,end:o}=s;if(null==e||null==o||isNaN(e+o)){t=!1;break}a.set(n,{start:e,end:o})}return t?{xrs:s,yrs:a}:(r.logger.warn("could not set initial ranges"),null)}_update_ranges_together(t){let n=1;for(const[e,s]of t)n=Math.min(n,this._get_weight_to_constrain_interval(e,s));if(n<1)for(const[e,s]of t)s.start=n*s.start+(1-n)*e.start,s.end=n*s.end+(1-n)*e.end}_update_ranges_individually(t,n){const e=!!(null==n?void 0:n.panning),s=!!(null==n?void 0:n.scrolling);let a=!1;for(const[n,o]of t){if(!s){const t=this._get_weight_to_constrain_interval(n,o);t<1&&(o.start=t*o.start+(1-t)*n.start,o.end=t*o.end+(1-t)*n.end)}if(null!=n.bounds&&"auto"!=n.bounds){const[t,r]=n.bounds,l=Math.abs(o.end-o.start);n.is_reversed?(null!=t&&t>=o.end&&(a=!0,o.end=t,(e||s)&&(o.start=t+l)),null!=r&&r<=o.start&&(a=!0,o.start=r,(e||s)&&(o.end=r-l))):(null!=t&&t>=o.start&&(a=!0,o.start=t,(e||s)&&(o.end=t+l)),null!=r&&r<=o.end&&(a=!0,o.end=r,(e||s)&&(o.start=r-l)))}}if(!(s&&a&&(null==n?void 0:n.maintain_focus)))for(const[n,e]of t)n.have_updated_interactively=!0,n.start==e.start&&n.end==e.end||n.setv(e)}_get_weight_to_constrain_interval(t,n){const{min_interval:e}=t;let{max_interval:s}=t;if(null!=t.bounds&&"auto"!=t.bounds){const[n,e]=t.bounds;if(null!=n&&null!=e){const t=Math.abs(e-n);s=null!=s?Math.min(s,t):t}}let a=1;if(null!=e||null!=s){const o=Math.abs(t.end-t.start),r=Math.abs(n.end-n.start);null!=e&&e>0&&r<e&&(a=(o-e)/(o-r)),null!=s&&s>0&&r>s&&(a=(s-o)/(r-o)),a=Math.max(0,Math.min(1,a))}return a}}e.RangeManager=l,l.__name__="RangeManager"},
function _(t,i,s,e,n){e();const h=t(15);class a{constructor(t,i){this.parent=t,this.initial_state=i,this.changed=new h.Signal0(this.parent,"state_changed"),this.history=[],this.index=-1}_do_state_change(t){const i=null!=this.history[t]?this.history[t].state:this.initial_state;null!=i.range&&this.parent.update_range(i.range),null!=i.selection&&this.parent.update_selection(i.selection)}push(t,i){const{history:s,index:e}=this,n=null!=s[e]?s[e].state:{},h=Object.assign(Object.assign(Object.assign({},this.initial_state),n),i);this.history=this.history.slice(0,this.index+1),this.history.push({type:t,state:h}),this.index=this.history.length-1,this.changed.emit()}clear(){this.history=[],this.index=-1,this.changed.emit()}undo(){this.can_undo&&(this.index-=1,this._do_state_change(this.index),this.changed.emit())}redo(){this.can_redo&&(this.index+=1,this._do_state_change(this.index),this.changed.emit())}get can_undo(){return this.index>=0}get can_redo(){return this.index<this.history.length-1}}s.StateManager=a,a.__name__="StateManager"},
function _(t,e,s,o,i){o();const a=t(19),n=t(15),p=t(71),l=t(36),_=t(320),h=new n.Signal0({},"gmaps_ready");class m extends _.PlotView{initialize(){this.pause(),super.initialize(),this._tiles_loaded=!1,this.zoom_count=0;const{zoom:t,lat:e,lng:s}=this.model.map_options;if(this.initial_zoom=t,this.initial_lat=e,this.initial_lng=s,!this.model.api_key){const t="https://developers.google.com/maps/documentation/javascript/get-api-key";a.logger.error(`api_key is required. See ${t} for more information on how to obtain your own.`)}if("undefined"==typeof google||null==google.maps){if(void 0===window._bokeh_gmaps_callback){!function(t){window._bokeh_gmaps_callback=()=>h.emit();const e=document.createElement("script");e.type="text/javascript",e.src=`https://maps.googleapis.com/maps/api/js?v=3.36&key=${t}&callback=_bokeh_gmaps_callback`,document.body.appendChild(e)}(atob(this.model.api_key))}h.connect(()=>this.request_render())}this.unpause()}remove(){p.remove(this.map_el),super.remove()}update_range(t,e){var s,o;if(null==t)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),super.update_range(null,e);else if(null!=t.sdx||null!=t.sdy)this.map.panBy(null!==(s=t.sdx)&&void 0!==s?s:0,null!==(o=t.sdy)&&void 0!==o?o:0),super.update_range(t,e);else if(null!=t.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),super.update_range(t,e);const s=t.factor<0?-1:1,o=this.map.getZoom(),i=o+s;if(i>=2){this.map.setZoom(i);const[t,e,,]=this._get_projected_bounds();e-t<0&&this.map.setZoom(o)}this.unpause()}this._set_bokeh_ranges()}_build_map(){const{maps:t}=google;this.map_types={satellite:t.MapTypeId.SATELLITE,terrain:t.MapTypeId.TERRAIN,roadmap:t.MapTypeId.ROADMAP,hybrid:t.MapTypeId.HYBRID};const e=this.model.map_options,s={center:new t.LatLng(e.lat,e.lng),zoom:e.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[e.map_type],scaleControl:e.scale_control,tilt:e.tilt};null!=e.styles&&(s.styles=JSON.parse(e.styles)),this.map_el=p.div({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),this.map=new t.Map(this.map_el,s),t.event.addListener(this.map,"idle",()=>this._set_bokeh_ranges()),t.event.addListener(this.map,"bounds_changed",()=>this._set_bokeh_ranges()),t.event.addListenerOnce(this.map,"tilesloaded",()=>this._render_finished()),this.connect(this.model.properties.map_options.change,()=>this._update_options()),this.connect(this.model.map_options.properties.styles.change,()=>this._update_styles()),this.connect(this.model.map_options.properties.lat.change,()=>this._update_center("lat")),this.connect(this.model.map_options.properties.lng.change,()=>this._update_center("lng")),this.connect(this.model.map_options.properties.zoom.change,()=>this._update_zoom()),this.connect(this.model.map_options.properties.map_type.change,()=>this._update_map_type()),this.connect(this.model.map_options.properties.scale_control.change,()=>this._update_scale_control()),this.connect(this.model.map_options.properties.tilt.change,()=>this._update_tilt())}_render_finished(){this._tiles_loaded=!0,this.notify_finished()}has_finished(){return super.has_finished()&&!0===this._tiles_loaded}_get_latlon_bounds(){const t=this.map.getBounds(),e=t.getNorthEast(),s=t.getSouthWest();return[s.lng(),e.lng(),s.lat(),e.lat()]}_get_projected_bounds(){const[t,e,s,o]=this._get_latlon_bounds(),[i,a]=l.wgs84_mercator.compute(t,s),[n,p]=l.wgs84_mercator.compute(e,o);return[i,n,a,p]}_set_bokeh_ranges(){const[t,e,s,o]=this._get_projected_bounds();this.frame.x_range.setv({start:t,end:e}),this.frame.y_range.setv({start:s,end:o})}_update_center(t){const e=this.map.getCenter().toJSON();e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()}_update_map_type(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})}_update_scale_control(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})}_update_tilt(){this.map.setOptions({tilt:this.model.map_options.tilt})}_update_options(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()}_update_styles(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})}_update_zoom(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()}_map_hook(t,e){if(null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map(),null!=this.map_el){const[t,s,o,i]=e;this.map_el.style.top=s+"px",this.map_el.style.left=t+"px",this.map_el.style.width=o+"px",this.map_el.style.height=i+"px"}}_paint_empty(t,e){const s=this.layout.bbox.width,o=this.layout.bbox.height,[i,a,n,p]=e;t.clearRect(0,0,s,o),t.beginPath(),t.moveTo(0,0),t.lineTo(0,o),t.lineTo(s,o),t.lineTo(s,0),t.lineTo(0,0),t.moveTo(i,a),t.lineTo(i+n,a),t.lineTo(i+n,a+p),t.lineTo(i,a+p),t.lineTo(i,a),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=this.model.border_fill_color,t.fill())}}s.GMapPlotView=m,m.__name__="GMapPlotView"},
function _(a,n,e,g,R){g(),R("DataRange",a(239).DataRange),R("DataRange1d",a(238).DataRange1d),R("FactorRange",a(100).FactorRange),R("Range",a(101).Range),R("Range1d",a(168).Range1d)},
function _(e,r,d,n,R){n(),R("GlyphRenderer",e(103).GlyphRenderer),R("GraphRenderer",e(124).GraphRenderer),R("GuideRenderer",e(206).GuideRenderer),R("Renderer",e(69).Renderer)},
function _(a,e,l,c,n){c(),n("CategoricalScale",a(237).CategoricalScale),n("ContinuousScale",a(158).ContinuousScale),n("LinearScale",a(157).LinearScale),n("LinearInterpolationScale",a(169).LinearInterpolationScale),n("LogScale",a(170).LogScale),n("Scale",a(159).Scale)},
function _(e,t,n,o,c){o();e(1).__exportStar(e(129),n),c("Selection",e(94).Selection)},
function _(a,e,S,o,r){o(),r("ServerSentDataSource",a(332).ServerSentDataSource),r("AjaxDataSource",a(334).AjaxDataSource),r("ColumnDataSource",a(130).ColumnDataSource),r("ColumnarDataSource",a(92).ColumnarDataSource),r("CDSView",a(121).CDSView),r("DataSource",a(93).DataSource),r("GeoJSONDataSource",a(335).GeoJSONDataSource),r("WebDataSource",a(333).WebDataSource)},
function _(e,t,i,a,s){a();const n=e(333);class r extends n.WebDataSource{constructor(e){super(e),this.initialized=!1}setup(){if(!this.initialized){this.initialized=!0;new EventSource(this.data_url).onmessage=e=>{this.load_data(JSON.parse(e.data),this.mode,this.max_size)}}}}i.ServerSentDataSource=r,r.__name__="ServerSentDataSource"},
function _(t,a,e,s,n){s();const i=t(130),c=t(20);class r extends i.ColumnDataSource{constructor(t){super(t)}get_column(t){const a=this.data[t];return null!=a?a:[]}initialize(){super.initialize(),this.setup()}load_data(t,a,e){const{adapter:s}=this;let n;switch(n=null!=s?s.execute(this,{response:t}):t,a){case"replace":this.data=n;break;case"append":{const t=this.data;for(const a of this.columns()){const s=Array.from(t[a]),i=Array.from(n[a]);n[a]=s.concat(i).slice(-e)}this.data=n;break}}}static init_WebDataSource(){this.define(({Any:t,Int:a,String:e,Nullable:s})=>({max_size:[a],mode:[c.UpdateMode,"replace"],adapter:[s(t),null],data_url:[e]}))}}e.WebDataSource=r,r.__name__="WebDataSource",r.init_WebDataSource()},
function _(t,e,i,s,a){s();const r=t(333),n=t(20),o=t(19),d=t(13);class l extends r.WebDataSource{constructor(t){super(t),this.interval=null,this.initialized=!1}static init_AjaxDataSource(){this.define(({Boolean:t,Int:e,String:i,Dict:s,Nullable:a})=>({polling_interval:[a(e),null],content_type:[i,"application/json"],http_headers:[s(i),{}],method:[n.HTTPMethod,"POST"],if_modified:[t,!1]}))}destroy(){null!=this.interval&&clearInterval(this.interval),super.destroy()}setup(){if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),null!=this.polling_interval)){const t=()=>this.get_data(this.mode,this.max_size,this.if_modified);this.interval=setInterval(t,this.polling_interval)}}get_data(t,e=0,i=!1){const s=this.prepare_request();s.addEventListener("load",()=>this.do_load(s,t,e)),s.addEventListener("error",()=>this.do_error(s)),s.send()}prepare_request(){const t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);const e=this.http_headers;for(const[i,s]of d.entries(e))t.setRequestHeader(i,s);return t}do_load(t,e,i){if(200===t.status){const s=JSON.parse(t.responseText);this.load_data(s,e,i)}}do_error(t){o.logger.error(`Failed to fetch JSON from ${this.data_url} with code ${t.status}`)}}i.AjaxDataSource=l,l.__name__="AjaxDataSource",l.init_AjaxDataSource()},
function _(e,t,o,r,n){r();const s=e(92),a=e(19),i=e(9),l=e(13);function c(e){return null!=e?e:NaN}class _ extends s.ColumnarDataSource{constructor(e){super(e)}static init_GeoJSONDataSource(){this.define(({String:e})=>({geojson:[e]})),this.internal(({Dict:e,Arrayable:t})=>({data:[e(t),{}]}))}initialize(){super.initialize(),this._update_data()}connect_signals(){super.connect_signals(),this.connect(this.properties.geojson.change,()=>this._update_data())}_update_data(){this.data=this.geojson_to_column_data()}_get_new_list_array(e){return i.range(0,e).map(e=>[])}_get_new_nan_array(e){return i.range(0,e).map(e=>NaN)}_add_properties(e,t,o,r){var n;const s=null!==(n=e.properties)&&void 0!==n?n:{};for(const[e,n]of l.entries(s))t.hasOwnProperty(e)||(t[e]=this._get_new_nan_array(r)),t[e][o]=c(n)}_add_geometry(e,t,o){function r(e,t){return e.concat([[NaN,NaN,NaN]]).concat(t)}switch(e.type){case"Point":{const[r,n,s]=e.coordinates;t.x[o]=r,t.y[o]=n,t.z[o]=c(s);break}case"LineString":{const{coordinates:r}=e;for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=c(a)}break}case"Polygon":{e.coordinates.length>1&&a.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");const r=e.coordinates[0];for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=c(a)}break}case"MultiPoint":a.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":{const n=e.coordinates.reduce(r);for(let e=0;e<n.length;e++){const[r,s,a]=n[e];t.xs[o][e]=r,t.ys[o][e]=s,t.zs[o][e]=c(a)}break}case"MultiPolygon":{const n=[];for(const t of e.coordinates)t.length>1&&a.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),n.push(t[0]);const s=n.reduce(r);for(let e=0;e<s.length;e++){const[r,n,a]=s[e];t.xs[o][e]=r,t.ys[o][e]=n,t.zs[o][e]=c(a)}break}default:throw new Error("Invalid GeoJSON geometry type: "+e.type)}}geojson_to_column_data(){const e=JSON.parse(this.geojson);let t;switch(e.type){case"GeometryCollection":if(null==e.geometries)throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if(null==e.features)throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}let o=0;for(const e of t){const t="Feature"===e.type?e.geometry:e;"GeometryCollection"==t.type?o+=t.geometries.length:o+=1}const r={x:this._get_new_nan_array(o),y:this._get_new_nan_array(o),z:this._get_new_nan_array(o),xs:this._get_new_list_array(o),ys:this._get_new_list_array(o),zs:this._get_new_list_array(o)};let n=0;for(const e of t){const t="Feature"==e.type?e.geometry:e;if("GeometryCollection"==t.type)for(const s of t.geometries)this._add_geometry(s,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1;else this._add_geometry(t,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1}return r}}o.GeoJSONDataSource=_,_.__name__="GeoJSONDataSource",_.init_GeoJSONDataSource()},
function _(e,i,r,c,k){c(),k("AdaptiveTicker",e(142).AdaptiveTicker),k("BasicTicker",e(141).BasicTicker),k("CategoricalTicker",e(208).CategoricalTicker),k("CompositeTicker",e(219).CompositeTicker),k("ContinuousTicker",e(138).ContinuousTicker),k("DatetimeTicker",e(218).DatetimeTicker),k("DaysTicker",e(220).DaysTicker),k("FixedTicker",e(337).FixedTicker),k("LogTicker",e(227).LogTicker),k("MercatorTicker",e(230).MercatorTicker),k("MonthsTicker",e(223).MonthsTicker),k("SingleIntervalTicker",e(221).SingleIntervalTicker),k("Ticker",e(139).Ticker),k("YearsTicker",e(224).YearsTicker)},
function _(i,t,e,r,n){r();const s=i(138);class _ extends s.ContinuousTicker{constructor(i){super(i)}static init_FixedTicker(){this.define(({Number:i,Array:t})=>({ticks:[t(i),[]],minor_ticks:[t(i),[]]}))}get_ticks_no_defaults(i,t,e,r){return{major:this.ticks,minor:this.minor_ticks}}get_interval(i,t,e){return 0}get_min_interval(){return 0}get_max_interval(){return 0}}e.FixedTicker=_,_.__name__="FixedTicker",_.init_FixedTicker()},
function _(e,r,T,o,S){o(),S("BBoxTileSource",e(339).BBoxTileSource),S("MercatorTileSource",e(340).MercatorTileSource),S("QUADKEYTileSource",e(343).QUADKEYTileSource),S("TileRenderer",e(344).TileRenderer),S("TileSource",e(341).TileSource),S("TMSTileSource",e(348).TMSTileSource),S("WMTSTileSource",e(345).WMTSTileSource)},
function _(e,t,r,i,o){i();const l=e(340);class n extends l.MercatorTileSource{constructor(e){super(e)}static init_BBoxTileSource(){this.define(({Boolean:e})=>({use_latlon:[e,!1]}))}get_image_url(e,t,r){const i=this.string_lookup_replace(this.url,this.extra_url_vars);let o,l,n,s;return this.use_latlon?[l,s,o,n]=this.get_tile_geographic_bounds(e,t,r):[l,s,o,n]=this.get_tile_meter_bounds(e,t,r),i.replace("{XMIN}",l.toString()).replace("{YMIN}",s.toString()).replace("{XMAX}",o.toString()).replace("{YMAX}",n.toString())}}r.BBoxTileSource=n,n.__name__="BBoxTileSource",n.init_BBoxTileSource()},
function _(t,e,i,_,s){_();const r=t(341),o=t(9),n=t(342);class l extends r.TileSource{constructor(t){super(t)}static init_MercatorTileSource(){this.define(({Boolean:t})=>({snap_to_zoom:[t,!1],wrap_around:[t,!0]})),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})}initialize(){super.initialize(),this._resolutions=o.range(this.min_zoom,this.max_zoom+1).map(t=>this.get_resolution(t))}_computed_initial_resolution(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size}is_valid_tile(t,e,i){return!(!this.wrap_around&&(t<0||t>=2**i))&&!(e<0||e>=2**i)}parent_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=_.substring(0,_.length-1);return this.quadkey_to_tile_xyz(s)}get_resolution(t){return this._computed_initial_resolution()/2**t}get_resolution_by_extent(t,e,i){return[(t[2]-t[0])/i,(t[3]-t[1])/e]}get_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s);let o=0;for(const t of this._resolutions){if(r>t){if(0==o)return 0;if(o>0)return o-1}o+=1}return o-1}get_closest_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s),o=this._resolutions.reduce((function(t,e){return Math.abs(e-r)<Math.abs(t-r)?e:t}));return this._resolutions.indexOf(o)}snap_to_zoom_level(t,e,i,_){const[s,r,o,n]=t,l=this._resolutions[_];let u=i*l,a=e*l;if(!this.snap_to_zoom){const t=(o-s)/u,e=(n-r)/a;t>e?(u=o-s,a*=t):(u*=e,a=n-r)}const h=(u-(o-s))/2,c=(a-(n-r))/2;return[s-h,r-c,o+h,n+c]}tms_to_wmts(t,e,i){return[t,2**i-1-e,i]}wmts_to_tms(t,e,i){return[t,2**i-1-e,i]}pixels_to_meters(t,e,i){const _=this.get_resolution(i);return[t*_-this.x_origin_offset,e*_-this.y_origin_offset]}meters_to_pixels(t,e,i){const _=this.get_resolution(i);return[(t+this.x_origin_offset)/_,(e+this.y_origin_offset)/_]}pixels_to_tile(t,e){let i=Math.ceil(t/this.tile_size);i=0===i?i:i-1;return[i,Math.max(Math.ceil(e/this.tile_size)-1,0)]}pixels_to_raster(t,e,i){return[t,(this.tile_size<<i)-e]}meters_to_tile(t,e,i){const[_,s]=this.meters_to_pixels(t,e,i);return this.pixels_to_tile(_,s)}get_tile_meter_bounds(t,e,i){const[_,s]=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),[r,o]=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i);return[_,s,r,o]}get_tile_geographic_bounds(t,e,i){const _=this.get_tile_meter_bounds(t,e,i),[s,r,o,l]=n.meters_extent_to_geographic(_);return[s,r,o,l]}get_tiles_by_extent(t,e,i=1){const[_,s,r,o]=t;let[n,l]=this.meters_to_tile(_,s,e),[u,a]=this.meters_to_tile(r,o,e);n-=i,l-=i,u+=i,a+=i;const h=[];for(let t=a;t>=l;t--)for(let i=n;i<=u;i++)this.is_valid_tile(i,t,e)&&h.push([i,t,e,this.get_tile_meter_bounds(i,t,e)]);return this.sort_tiles_from_center(h,[n,l,u,a]),h}quadkey_to_tile_xyz(t){let e=0,i=0;const _=t.length;for(let s=_;s>0;s--){const r=1<<s-1;switch(t.charAt(_-s)){case"0":continue;case"1":e|=r;break;case"2":i|=r;break;case"3":e|=r,i|=r;break;default:throw new TypeError("Invalid Quadkey: "+t)}}return[e,i,_]}tile_xyz_to_quadkey(t,e,i){let _="";for(let s=i;s>0;s--){const i=1<<s-1;let r=0;0!=(t&i)&&(r+=1),0!=(e&i)&&(r+=2),_+=r.toString()}return _}children_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=[];for(let t=0;t<=3;t++){const[e,i,r]=this.quadkey_to_tile_xyz(_+t.toString()),o=this.get_tile_meter_bounds(e,i,r);s.push([e,i,r,o])}return s}get_closest_parent_by_tile_xyz(t,e,i){const _=this.calculate_world_x_by_tile_xyz(t,e,i);[t,e,i]=this.normalize_xyz(t,e,i);let s=this.tile_xyz_to_quadkey(t,e,i);for(;s.length>0;)if(s=s.substring(0,s.length-1),[t,e,i]=this.quadkey_to_tile_xyz(s),[t,e,i]=this.denormalize_xyz(t,e,i,_),this.tiles.has(this.tile_xyz_to_key(t,e,i)))return[t,e,i];return[0,0,0]}normalize_xyz(t,e,i){if(this.wrap_around){const _=2**i;return[(t%_+_)%_,e,i]}return[t,e,i]}denormalize_xyz(t,e,i,_){return[t+_*2**i,e,i]}denormalize_meters(t,e,i,_){return[t+2*_*Math.PI*6378137,e]}calculate_world_x_by_tile_xyz(t,e,i){return Math.floor(t/2**i)}}i.MercatorTileSource=l,l.__name__="MercatorTileSource",l.init_MercatorTileSource()},
function _(e,t,r,i,n){i();const s=e(88),l=e(13);class a extends s.Model{constructor(e){super(e)}static init_TileSource(){this.define(({Number:e,String:t,Dict:r})=>({url:[t,""],tile_size:[e,256],max_zoom:[e,30],min_zoom:[e,0],extra_url_vars:[r(t),{}],attribution:[t,""],x_origin_offset:[e],y_origin_offset:[e],initial_resolution:[e]}))}initialize(){super.initialize(),this.tiles=new Map,this._normalize_case()}connect_signals(){super.connect_signals(),this.connect(this.change,()=>this._clear_cache())}string_lookup_replace(e,t){let r=e;for(const[e,i]of l.entries(t))r=r.replace(`{${e}}`,i);return r}_normalize_case(){const e=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=e}_clear_cache(){this.tiles=new Map}tile_xyz_to_key(e,t,r){return`${e}:${t}:${r}`}key_to_tile_xyz(e){const[t,r,i]=e.split(":").map(e=>parseInt(e));return[t,r,i]}sort_tiles_from_center(e,t){const[r,i,n,s]=t,l=(n-r)/2+r,a=(s-i)/2+i;e.sort((function(e,t){return Math.sqrt((l-e[0])**2+(a-e[1])**2)-Math.sqrt((l-t[0])**2+(a-t[1])**2)}))}get_image_url(e,t,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",t.toString()).replace("{Z}",r.toString())}}r.TileSource=a,a.__name__="TileSource",a.init_TileSource()},
function _(t,e,r,n,o){n();const c=t(36);function _(t,e){return c.wgs84_mercator.compute(t,e)}function g(t,e){return c.wgs84_mercator.invert(t,e)}r.geographic_to_meters=_,r.meters_to_geographic=g,r.geographic_extent_to_meters=function(t){const[e,r,n,o]=t,[c,g]=_(e,r),[i,u]=_(n,o);return[c,g,i,u]},r.meters_extent_to_geographic=function(t){const[e,r,n,o]=t,[c,_]=g(e,r),[i,u]=g(n,o);return[c,_,i,u]}},
function _(e,t,r,s,_){s();const o=e(340);class c extends o.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const s=this.string_lookup_replace(this.url,this.extra_url_vars),[_,o,c]=this.tms_to_wmts(e,t,r),i=this.tile_xyz_to_quadkey(_,o,c);return s.replace("{Q}",i)}}r.QUADKEYTileSource=c,c.__name__="QUADKEYTileSource"},
function _(t,e,i,s,_){s();const n=t(1),a=t(341),h=t(345),r=t(69),o=t(168),l=t(71),d=t(281),m=t(9),c=t(8),p=t(346),g=n.__importDefault(t(347));class u extends r.RendererView{initialize(){this._tiles=[],super.initialize()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render()),this.connect(this.model.tile_source.change,()=>this.request_render())}styles(){return[...super.styles(),g.default]}get_extent(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]}get map_plot(){return this.plot_model}get map_canvas(){return this.layer.ctx}get map_frame(){return this.plot_view.frame}get x_range(){return this.map_plot.x_range}get y_range(){return this.map_plot.y_range}_set_data(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0}_update_attribution(){null!=this.attribution_el&&l.removeElement(this.attribution_el);const{attribution:t}=this.model.tile_source;if(c.isString(t)&&t.length>0){const{layout:e,frame:i}=this.plot_view,s=e.bbox.width-i.bbox.right,_=e.bbox.height-i.bbox.bottom,n=i.bbox.width;this.attribution_el=l.div({class:p.bk_tile_attribution,style:{position:"absolute",right:s+"px",bottom:_+"px","max-width":n-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"9px","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}}),this.plot_view.canvas_view.add_event(this.attribution_el),this.attribution_el.innerHTML=t,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}}_map_data(){this.initial_extent=this.get_extent();const t=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width),e=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width,t);this.x_range.start=e[0],this.y_range.start=e[1],this.x_range.end=e[2],this.y_range.end=e[3],this.x_range instanceof o.Range1d&&(this.x_range.reset_start=e[0],this.x_range.reset_end=e[2]),this.y_range instanceof o.Range1d&&(this.y_range.reset_start=e[1],this.y_range.reset_end=e[3]),this._update_attribution()}_create_tile(t,e,i,s,_=!1){const[n,a,h]=this.model.tile_source.normalize_xyz(t,e,i),r={img:void 0,tile_coords:[t,e,i],normalized_coords:[n,a,h],quadkey:this.model.tile_source.tile_xyz_to_quadkey(t,e,i),cache_key:this.model.tile_source.tile_xyz_to_key(t,e,i),bounds:s,loaded:!1,finished:!1,x_coord:s[0],y_coord:s[3]},o=this.model.tile_source.get_image_url(n,a,h);new d.ImageLoader(o,{loaded:t=>{Object.assign(r,{img:t,loaded:!0}),_?(r.finished=!0,this.notify_finished()):this.request_render()},failed(){r.finished=!0}}),this.model.tile_source.tiles.set(r.cache_key,r),this._tiles.push(r)}_enforce_aspect_ratio(){if(this._last_height!==this.map_frame.bbox.height||this._last_width!==this.map_frame.bbox.width){const t=this.get_extent(),e=this.model.tile_source.get_level_by_extent(t,this.map_frame.bbox.height,this.map_frame.bbox.width),i=this.model.tile_source.snap_to_zoom_level(t,this.map_frame.bbox.height,this.map_frame.bbox.width,e);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame.bbox.height,this._last_width=this.map_frame.bbox.width}}has_finished(){if(!super.has_finished())return!1;if(0===this._tiles.length)return!1;for(const t of this._tiles)if(!t.finished)return!1;return!0}_render(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()}_draw_tile(t){const e=this.model.tile_source.tiles.get(t);if(null!=e&&e.loaded){const[[t],[i]]=this.coordinates.map_to_screen([e.bounds[0]],[e.bounds[3]]),[[s],[_]]=this.coordinates.map_to_screen([e.bounds[2]],[e.bounds[1]]),n=s-t,a=_-i,h=t,r=i,o=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(e.img,h,r,n,a),this.map_canvas.setImageSmoothingEnabled(o),e.finished=!0}}_set_rect(){const t=this.plot_model.properties.outline_line_width.value(),e=this.map_frame.bbox.left+t/2,i=this.map_frame.bbox.top+t/2,s=this.map_frame.bbox.width-t,_=this.map_frame.bbox.height-t;this.map_canvas.rect(e,i,s,_),this.map_canvas.clip()}_render_tiles(t){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(const e of t)this._draw_tile(e);this.map_canvas.restore()}_prefetch_tiles(){const{tile_source:t}=this.model,e=this.get_extent(),i=this.map_frame.bbox.height,s=this.map_frame.bbox.width,_=this.model.tile_source.get_level_by_extent(e,i,s),n=this.model.tile_source.get_tiles_by_extent(e,_);for(let e=0,i=Math.min(10,n.length);e<i;e++){const[i,s,_]=n[e],a=this.model.tile_source.children_by_tile_xyz(i,s,_);for(const e of a){const[i,s,_,n]=e;t.tiles.has(t.tile_xyz_to_key(i,s,_))||this._create_tile(i,s,_,n,!0)}}}_fetch_tiles(t){for(const e of t){const[t,i,s,_]=e;this._create_tile(t,i,s,_)}}_update(){const{tile_source:t}=this.model,{min_zoom:e}=t,{max_zoom:i}=t;let s=this.get_extent();const _=this.extent[2]-this.extent[0]<s[2]-s[0],n=this.map_frame.bbox.height,a=this.map_frame.bbox.width;let h=t.get_level_by_extent(s,n,a),r=!1;h<e?(s=this.extent,h=e,r=!0):h>i&&(s=this.extent,h=i,r=!0),r&&(this.x_range.setv({x_range:{start:s[0],end:s[2]}}),this.y_range.setv({start:s[1],end:s[3]})),this.extent=s;const o=t.get_tiles_by_extent(s,h),l=[],d=[],c=[],p=[];for(const e of o){const[i,s,n]=e,a=t.tile_xyz_to_key(i,s,n),h=t.tiles.get(a);if(null!=h&&h.loaded)d.push(a);else if(this.model.render_parents){const[e,a,h]=t.get_closest_parent_by_tile_xyz(i,s,n),r=t.tile_xyz_to_key(e,a,h),o=t.tiles.get(r);if(null!=o&&o.loaded&&!m.includes(c,r)&&c.push(r),_){const e=t.children_by_tile_xyz(i,s,n);for(const[i,s,_]of e){const e=t.tile_xyz_to_key(i,s,_);t.tiles.has(e)&&p.push(e)}}}null==h&&l.push(e)}this._render_tiles(c),this._render_tiles(p),this._render_tiles(d),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout(()=>this._fetch_tiles(l),65)}}i.TileRendererView=u,u.__name__="TileRendererView";class b extends r.Renderer{constructor(t){super(t)}static init_TileRenderer(){this.prototype.default_view=u,this.define(({Boolean:t,Number:e,Ref:i})=>({alpha:[e,1],smoothing:[t,!0],tile_source:[i(a.TileSource),()=>new h.WMTSTileSource],render_parents:[t,!0]})),this.override({level:"image"})}}i.TileRenderer=b,b.__name__="TileRenderer",b.init_TileRenderer()},
function _(t,e,r,o,s){o();const c=t(340);class i extends c.MercatorTileSource{constructor(t){super(t)}get_image_url(t,e,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars),[s,c,i]=this.tms_to_wmts(t,e,r);return o.replace("{X}",s.toString()).replace("{Y}",c.toString()).replace("{Z}",i.toString())}}r.WMTSTileSource=i,i.__name__="WMTSTileSource"},
function _(t,i,b,n,o){n(),b.bk_tile_attribution="bk-tile-attribution"},
function _(n,t,o,a,b){a();o.default="\n.bk-root .bk-tile-attribution a {\n  color: black;\n}\n"},
function _(e,r,t,c,o){c();const i=e(340);class l extends i.MercatorTileSource{constructor(e){super(e)}get_image_url(e,r,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",r.toString()).replace("{Z}",t.toString())}}t.TMSTileSource=l,l.__name__="TMSTileSource"},
function _(e,t,u,a,r){a(),r("CanvasTexture",e(350).CanvasTexture),r("ImageURLTexture",e(352).ImageURLTexture),r("Texture",e(351).Texture)},
function _(t,e,n,c,s){c();const r=t(351),i=t(29);class a extends r.Texture{constructor(t){super(t)}static init_CanvasTexture(){this.define(({String:t})=>({code:[t]}))}get func(){const t=i.use_strict(this.code);return new Function("ctx","color","scale","weight",t)}get_pattern(t,e,n){return c=>{const s=document.createElement("canvas");s.width=e,s.height=e;const r=s.getContext("2d");return this.func.call(this,r,t,e,n),c.createPattern(s,this.repetition)}}}n.CanvasTexture=a,a.__name__="CanvasTexture",a.init_CanvasTexture()},
function _(e,t,i,n,r){n();const o=e(88),s=e(20);class u extends o.Model{constructor(e){super(e)}static init_Texture(){this.define(()=>({repetition:[s.TextureRepetition,"repeat"]}))}onload(e){e()}}i.Texture=u,u.__name__="Texture",u.init_Texture()},
function _(e,t,i,r,n){r();const a=e(351),s=e(281);class o extends a.Texture{constructor(e){super(e)}static init_ImageURLTexture(){this.define(({String:e})=>({url:[e]}))}initialize(){super.initialize(),this._loader=new s.ImageLoader(this.url)}get_pattern(e,t,i){return e=>this._loader.finished?e.createPattern(this._loader.image,this.repetition):null}onload(e){this._loader.promise.then(()=>e())}}i.ImageURLTexture=o,o.__name__="ImageURLTexture",o.init_ImageURLTexture()},
function _(o,l,T,e,t){e(),t("ActionTool",o(195).ActionTool),t("CustomAction",o(354).CustomAction),t("HelpTool",o(196).HelpTool),t("RedoTool",o(355).RedoTool),t("ResetTool",o(356).ResetTool),t("SaveTool",o(357).SaveTool),t("UndoTool",o(358).UndoTool),t("ZoomInTool",o(359).ZoomInTool),t("ZoomOutTool",o(362).ZoomOutTool),t("ButtonTool",o(186).ButtonTool),t("EditTool",o(363).EditTool),t("BoxEditTool",o(364).BoxEditTool),t("FreehandDrawTool",o(365).FreehandDrawTool),t("PointDrawTool",o(366).PointDrawTool),t("PolyDrawTool",o(367).PolyDrawTool),t("PolyTool",o(368).PolyTool),t("PolyEditTool",o(369).PolyEditTool),t("BoxSelectTool",o(370).BoxSelectTool),t("BoxZoomTool",o(372).BoxZoomTool),t("GestureTool",o(185).GestureTool),t("LassoSelectTool",o(373).LassoSelectTool),t("LineEditTool",o(375).LineEditTool),t("PanTool",o(377).PanTool),t("PolySelectTool",o(374).PolySelectTool),t("RangeTool",o(378).RangeTool),t("SelectTool",o(371).SelectTool),t("TapTool",o(379).TapTool),t("WheelPanTool",o(380).WheelPanTool),t("WheelZoomTool",o(381).WheelZoomTool),t("CrosshairTool",o(382).CrosshairTool),t("CustomJSHover",o(383).CustomJSHover),t("HoverTool",o(384).HoverTool),t("InspectTool",o(193).InspectTool),t("Tool",o(184).Tool),t("ToolProxy",o(385).ToolProxy),t("Toolbar",o(183).Toolbar),t("ToolbarBase",o(194).ToolbarBase),t("ProxyToolbar",o(386).ProxyToolbar),t("ToolbarBox",o(386).ToolbarBox)},
function _(t,o,i,n,s){n();const c=t(195),e=t(187);class u extends c.ActionToolButtonView{css_classes(){return super.css_classes().concat(e.bk_toolbar_button_custom_action)}}i.CustomActionButtonView=u,u.__name__="CustomActionButtonView";class _ extends c.ActionToolView{doit(){var t;null===(t=this.model.callback)||void 0===t||t.execute(this.model)}}i.CustomActionView=_,_.__name__="CustomActionView";class l extends c.ActionTool{constructor(t){super(t),this.tool_name="Custom Action",this.button_view=u}static init_CustomAction(){this.prototype.default_view=_,this.define(({Any:t,String:o,Nullable:i})=>({action_tooltip:[o,"Perform a Custom Action"],callback:[i(t)],icon:[o]}))}get tooltip(){return this.action_tooltip}}i.CustomAction=l,l.__name__="CustomAction",l.init_CustomAction()},
function _(o,e,t,i,s){i();const n=o(195),_=o(197);class d extends n.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state.changed,()=>this.model.disabled=!this.plot_view.state.can_redo)}doit(){this.plot_view.state.redo()}}t.RedoToolView=d,d.__name__="RedoToolView";class l extends n.ActionTool{constructor(o){super(o),this.tool_name="Redo",this.icon=_.bk_tool_icon_redo}static init_RedoTool(){this.prototype.default_view=d,this.override({disabled:!0}),this.register_alias("redo",()=>new l)}}t.RedoTool=l,l.__name__="RedoTool",l.init_RedoTool()},
function _(e,t,o,s,i){s();const _=e(195),n=e(197);class l extends _.ActionToolView{doit(){this.plot_view.reset()}}o.ResetToolView=l,l.__name__="ResetToolView";class c extends _.ActionTool{constructor(e){super(e),this.tool_name="Reset",this.icon=n.bk_tool_icon_reset}static init_ResetTool(){this.prototype.default_view=l,this.register_alias("reset",()=>new c)}}o.ResetTool=c,c.__name__="ResetTool",c.init_ResetTool()},
function _(o,e,t,a,i){a();const n=o(195),s=o(197);class c extends n.ActionToolView{async copy(){const o=await this.plot_view.to_blob(),e=new ClipboardItem({[o.type]:o});await navigator.clipboard.write([e])}async save(o){const e=await this.plot_view.to_blob(),t=document.createElement("a");t.href=URL.createObjectURL(e),t.download=o,t.target="_blank",t.dispatchEvent(new MouseEvent("click"))}doit(o="save"){switch(o){case"save":this.save("bokeh_plot");break;case"copy":this.copy()}}}t.SaveToolView=c,c.__name__="SaveToolView";class l extends n.ActionTool{constructor(o){super(o),this.tool_name="Save",this.icon=s.bk_tool_icon_save}static init_SaveTool(){this.prototype.default_view=c,this.register_alias("save",()=>new l)}get menu(){return[{icon:"bk-tool-icon-copy-to-clipboard",tooltip:"Copy image to clipboard",if:()=>"undefined"!=typeof ClipboardItem,handler:()=>{this.do.emit("copy")}}]}}t.SaveTool=l,l.__name__="SaveTool",l.init_SaveTool()},
function _(o,t,n,i,e){i();const s=o(195),_=o(197);class d extends s.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state.changed,()=>this.model.disabled=!this.plot_view.state.can_undo)}doit(){this.plot_view.state.undo()}}n.UndoToolView=d,d.__name__="UndoToolView";class l extends s.ActionTool{constructor(o){super(o),this.tool_name="Undo",this.icon=_.bk_tool_icon_undo}static init_UndoTool(){this.prototype.default_view=d,this.override({disabled:!0}),this.register_alias("undo",()=>new l)}}n.UndoTool=l,l.__name__="UndoTool",l.init_UndoTool()},
function _(o,i,n,s,t){s();const e=o(360),_=o(197);class m extends e.ZoomBaseTool{constructor(o){super(o),this.sign=1,this.tool_name="Zoom In",this.icon=_.bk_tool_icon_zoom_in}static init_ZoomInTool(){this.prototype.default_view=e.ZoomBaseToolView,this.register_alias("zoom_in",()=>new m({dimensions:"both"})),this.register_alias("xzoom_in",()=>new m({dimensions:"width"})),this.register_alias("yzoom_in",()=>new m({dimensions:"height"}))}}n.ZoomInTool=m,m.__name__="ZoomInTool",m.init_ZoomInTool()},
function _(o,t,e,i,s){i();const n=o(195),l=o(20),a=o(361);class _ extends n.ActionToolView{doit(){var o;const t=this.plot_view.frame,e=this.model.dimensions,i="width"==e||"both"==e,s="height"==e||"both"==e,n=a.scale_range(t,this.model.sign*this.model.factor,i,s);this.plot_view.state.push("zoom_out",{range:n}),this.plot_view.update_range(n,{scrolling:!0}),null===(o=this.model.document)||void 0===o||o.interactive_start(this.plot_model)}}e.ZoomBaseToolView=_,_.__name__="ZoomBaseToolView";class m extends n.ActionTool{constructor(o){super(o)}static init_ZoomBaseTool(){this.prototype.default_view=_,this.define(({Percent:o})=>({factor:[o,.1],dimensions:[l.Dimensions,"both"]}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}e.ZoomBaseTool=m,m.__name__="ZoomBaseTool",m.init_ZoomBaseTool()},
function _(n,t,o,r,s){r();const c=n(10);function e(n,t,o){const[r,s]=[n.start,n.end],c=null!=o?o:(s+r)/2;return[r-(r-c)*t,s-(s-c)*t]}function a(n,[t,o]){const r=new Map;for(const[s,c]of n){const[n,e]=c.r_invert(t,o);r.set(s,{start:n,end:e})}return r}o.scale_highlow=e,o.get_info=a,o.scale_range=function(n,t,o=!0,r=!0,s){t=c.clamp(t,-.9,.9);const l=o?t:0,[u,i]=e(n.bbox.h_range,l,null!=s?s.x:void 0),_=a(n.x_scales,[u,i]),f=r?t:0,[g,x]=e(n.bbox.v_range,f,null!=s?s.y:void 0);return{xrs:_,yrs:a(n.y_scales,[g,x]),factor:t}}},
function _(o,t,i,s,e){s();const n=o(360),_=o(197);class m extends n.ZoomBaseTool{constructor(o){super(o),this.sign=-1,this.tool_name="Zoom Out",this.icon=_.bk_tool_icon_zoom_out}static init_ZoomOutTool(){this.prototype.default_view=n.ZoomBaseToolView,this.register_alias("zoom_out",()=>new m({dimensions:"both"})),this.register_alias("xzoom_out",()=>new m({dimensions:"width"})),this.register_alias("yzoom_out",()=>new m({dimensions:"height"}))}}i.ZoomOutTool=m,m.__name__="ZoomOutTool",m.init_ZoomOutTool()},
function _(e,t,o,s,n){s();const i=e(9),r=e(8),c=e(11),_=e(103),a=e(185);class l extends a.GestureToolView{constructor(){super(...arguments),this._mouse_in_frame=!0}_select_mode(e){const{shiftKey:t,ctrlKey:o}=e;return t||o?t&&!o?"append":!t&&o?"intersect":t&&o?"subtract":void c.unreachable():"replace"}_move_enter(e){this._mouse_in_frame=!0}_move_exit(e){this._mouse_in_frame=!1}_map_drag(e,t,o){if(!this.plot_view.frame.bbox.contains(e,t))return null;const s=this.plot_view.renderer_view(o);if(null==s)return null;return[s.coordinates.x_scale.invert(e),s.coordinates.y_scale.invert(t)]}_delete_selected(e){const t=e.data_source,o=t.selected.indices;o.sort();for(const e of t.columns()){const s=t.get_array(e);for(let e=0;e<o.length;e++){const t=o[e];s.splice(t-e,1)}}this._emit_cds_changes(t)}_pop_glyphs(e,t){const o=e.columns();if(t&&o.length)for(const s of o){let o=e.get_array(s);const n=o.length-t+1;n<1||(r.isArray(o)||(o=Array.from(o),e.data[s]=o),o.splice(0,n))}}_emit_cds_changes(e,t=!0,o=!0,s=!0){o&&e.selection_manager.clear(),t&&e.change.emit(),s&&(e.data=e.data,e.properties.data.change.emit())}_drag_points(e,t,o="both"){if(null==this._basepoint)return;const[s,n]=this._basepoint;for(const i of t){const t=this._map_drag(s,n,i),r=this._map_drag(e.sx,e.sy,i);if(null==r||null==t)continue;const[c,_]=r,[a,l]=t,[d,u]=[c-a,_-l],h=i.glyph,m=i.data_source,[p,f]=[h.x.field,h.y.field];for(const e of m.selected.indices)!p||"width"!=o&&"both"!=o||(m.data[p][e]+=d),!f||"height"!=o&&"both"!=o||(m.data[f][e]+=u);m.change.emit()}this._basepoint=[e.sx,e.sy]}_pad_empty_columns(e,t){for(const o of e.columns())i.includes(t,o)||e.get_array(o).push(this.model.empty_value)}_select_event(e,t,o){const s=this.plot_view.frame,{sx:n,sy:i}=e;if(!s.bbox.contains(n,i))return[];const r={type:"point",sx:n,sy:i},c=[];for(const e of o){const o=e.get_selection_manager(),s=e.data_source,n=this.plot_view.renderer_view(e);if(null!=n){o.select([n],r,!0,t)&&c.push(e),s.properties.selected.change.emit()}}return c}}o.EditToolView=l,l.__name__="EditToolView";class d extends a.GestureTool{constructor(e){super(e)}static init_EditTool(){this.define(({Unknown:e,String:t,Array:o,Ref:s})=>({custom_icon:[t],custom_tooltip:[t],empty_value:[e],renderers:[o(s(_.GlyphRenderer)),[]]}))}get tooltip(){var e;return null!==(e=this.custom_tooltip)&&void 0!==e?e:this.tool_name}get computed_icon(){var e;return null!==(e=this.custom_icon)&&void 0!==e?e:this.icon}}o.EditTool=d,d.__name__="EditTool",d.init_EditTool()},
function _(e,t,s,i,_){i();const o=e(71),n=e(20),a=e(363),d=e(197);class l extends a.EditToolView{_tap(e){null==this._draw_basepoint&&null==this._basepoint&&this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)if(e.keyCode===o.Keys.Backspace)this._delete_selected(t);else if(e.keyCode==o.Keys.Esc){t.data_source.selection_manager.clear()}}_set_extent([e,t],[s,i],_,o=!1){const n=this.model.renderers[0],a=this.plot_view.renderer_view(n);if(null==a)return;const d=n.glyph,l=n.data_source,[r,h]=a.coordinates.x_scale.r_invert(e,t),[p,u]=a.coordinates.y_scale.r_invert(s,i),[c,m]=[(r+h)/2,(p+u)/2],[f,b]=[h-r,u-p],[x,y]=[d.x.field,d.y.field],[w,v]=[d.width.field,d.height.field];if(_)this._pop_glyphs(l,this.model.num_objects),x&&l.get_array(x).push(c),y&&l.get_array(y).push(m),w&&l.get_array(w).push(f),v&&l.get_array(v).push(b),this._pad_empty_columns(l,[x,y,w,v]);else{const e=l.data[x].length-1;x&&(l.data[x][e]=c),y&&(l.data[y][e]=m),w&&(l.data[w][e]=f),v&&(l.data[v][e]=b)}this._emit_cds_changes(l,!0,!1,o)}_update_box(e,t=!1,s=!1){if(null==this._draw_basepoint)return;const i=[e.sx,e.sy],_=this.plot_view.frame,o=this.model.dimensions,n=this.model._get_dim_limits(this._draw_basepoint,i,_,o);if(null!=n){const[e,i]=n;this._set_extent(e,i,t,s)}}_doubletap(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,"append",this.model.renderers),this._update_box(e,!0,!1)))}_move(e){this._update_box(e,!1,!1)}_pan_start(e){if(e.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy]}}_pan(e,t=!1,s=!1){if(e.shiftKey){if(null==this._draw_basepoint)return;this._update_box(e,t,s)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}}_pan_end(e){if(this._pan(e,!1,!0),e.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0)}}}s.BoxEditToolView=l,l.__name__="BoxEditToolView";class r extends a.EditTool{constructor(e){super(e),this.tool_name="Box Edit Tool",this.icon=d.bk_tool_icon_box_edit,this.event_type=["tap","pan","move"],this.default_order=1}static init_BoxEditTool(){this.prototype.default_view=l,this.define(({Int:e})=>({dimensions:[n.Dimensions,"both"],num_objects:[e,0]}))}}s.BoxEditTool=r,r.__name__="BoxEditTool",r.init_BoxEditTool()},
function _(e,t,a,s,r){s();const _=e(71),o=e(8),i=e(363),d=e(197);class n extends i.EditToolView{_draw(e,t,a=!1){if(!this.model.active)return;const s=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,s);if(null==r)return;const[_,i]=r,d=s.data_source,n=s.glyph,[h,l]=[n.xs.field,n.ys.field];if("new"==t)this._pop_glyphs(d,this.model.num_objects),h&&d.get_array(h).push([_]),l&&d.get_array(l).push([i]),this._pad_empty_columns(d,[h,l]);else if("add"==t){if(h){const e=d.data[h].length-1;let t=d.get_array(h)[e];o.isArray(t)||(t=Array.from(t),d.data[h][e]=t),t.push(_)}if(l){const e=d.data[l].length-1;let t=d.get_array(l)[e];o.isArray(t)||(t=Array.from(t),d.data[l][e]=t),t.push(i)}}this._emit_cds_changes(d,!0,!0,a)}_pan_start(e){this._draw(e,"new")}_pan(e){this._draw(e,"add")}_pan_end(e){this._draw(e,"add",!0)}_tap(e){this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===_.Keys.Esc?t.data_source.selection_manager.clear():e.keyCode===_.Keys.Backspace&&this._delete_selected(t)}}a.FreehandDrawToolView=n,n.__name__="FreehandDrawToolView";class h extends i.EditTool{constructor(e){super(e),this.tool_name="Freehand Draw Tool",this.icon=d.bk_tool_icon_freehand_draw,this.event_type=["pan","tap"],this.default_order=3}static init_FreehandDrawTool(){this.prototype.default_view=n,this.define(({Int:e})=>({num_objects:[e,0]}))}}a.FreehandDrawTool=h,h.__name__="FreehandDrawTool",h.init_FreehandDrawTool()},
function _(e,t,s,o,i){o();const a=e(71),n=e(363),_=e(197);class r extends n.EditToolView{_tap(e){if(this._select_event(e,this._select_mode(e),this.model.renderers).length||!this.model.add)return;const t=this.model.renderers[0],s=this._map_drag(e.sx,e.sy,t);if(null==s)return;const o=t.glyph,i=t.data_source,[a,n]=[o.x.field,o.y.field],[_,r]=s;this._pop_glyphs(i,this.model.num_objects),a&&i.get_array(a).push(_),n&&i.get_array(n).push(r),this._pad_empty_columns(i,[a,n]),i.change.emit(),i.data=i.data,i.properties.data.change.emit()}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===a.Keys.Backspace?this._delete_selected(t):e.keyCode==a.Keys.Esc&&t.data_source.selection_manager.clear()}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0);this._basepoint=null}}}s.PointDrawToolView=r,r.__name__="PointDrawToolView";class d extends n.EditTool{constructor(e){super(e),this.tool_name="Point Draw Tool",this.icon=_.bk_tool_icon_point_draw,this.event_type=["tap","pan","move"],this.default_order=2}static init_PointDrawTool(){this.prototype.default_view=r,this.define(({Boolean:e,Int:t})=>({add:[e,!0],drag:[e,!0],num_objects:[t,0]}))}}s.PointDrawTool=d,d.__name__="PointDrawTool",d.init_PointDrawTool()},
function _(e,t,s,i,a){i();const o=e(71),r=e(8),n=e(368),_=e(197);class d extends n.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._initialized=!1}_tap(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,this._select_mode(e),this.model.renderers)}_draw(e,t,s=!1){const i=this.model.renderers[0],a=this._map_drag(e.sx,e.sy,i);if(this._initialized||this.activate(),null==a)return;const[o,n]=this._snap_to_vertex(e,...a),_=i.data_source,d=i.glyph,[l,h]=[d.xs.field,d.ys.field];if("new"==t)this._pop_glyphs(_,this.model.num_objects),l&&_.get_array(l).push([o,o]),h&&_.get_array(h).push([n,n]),this._pad_empty_columns(_,[l,h]);else if("edit"==t){if(l){const e=_.data[l][_.data[l].length-1];e[e.length-1]=o}if(h){const e=_.data[h][_.data[h].length-1];e[e.length-1]=n}}else if("add"==t){if(l){const e=_.data[l].length-1;let t=_.get_array(l)[e];const s=t[t.length-1];t[t.length-1]=o,r.isArray(t)||(t=Array.from(t),_.data[l][e]=t),t.push(s)}if(h){const e=_.data[h].length-1;let t=_.get_array(h)[e];const s=t[t.length-1];t[t.length-1]=n,r.isArray(t)||(t=Array.from(t),_.data[h][e]=t),t.push(s)}}this._emit_cds_changes(_,!0,!1,s)}_show_vertices(){if(!this.model.active)return;const e=[],t=[];for(let s=0;s<this.model.renderers.length;s++){const i=this.model.renderers[s],a=i.data_source,o=i.glyph,[r,n]=[o.xs.field,o.ys.field];if(r)for(const t of a.get_array(r))e.push(...t);if(n)for(const e of a.get_array(n))t.push(...e);this._drawing&&s==this.model.renderers.length-1&&(e.splice(e.length-1,1),t.splice(t.length-1,1))}this._set_vertices(e,t)}_doubletap(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))}_move(e){this._drawing&&this._draw(e,"edit")}_remove(){const e=this.model.renderers[0],t=e.data_source,s=e.glyph,[i,a]=[s.xs.field,s.ys.field];if(i){const e=t.data[i].length-1,s=t.get_array(i)[e];s.splice(s.length-1,1)}if(a){const e=t.data[a].length-1,s=t.get_array(a)[e];s.splice(s.length-1,1)}this._emit_cds_changes(t)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===o.Keys.Backspace?this._delete_selected(t):e.keyCode==o.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),t.data_source.selection_manager.clear())}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){if(null==this._basepoint||!this.model.drag)return;const[t,s]=this._basepoint;for(const i of this.model.renderers){const a=this._map_drag(t,s,i),o=this._map_drag(e.sx,e.sy,i);if(null==o||null==a)continue;const r=i.data_source,n=i.glyph,[_,d]=[n.xs.field,n.ys.field];if(!_&&!d)continue;const[l,h]=o,[c,g]=a,[f,p]=[l-c,h-g];for(const e of r.selected.indices){let t,s,i;_&&(s=r.data[_][e]),d?(i=r.data[d][e],t=i.length):t=s.length;for(let e=0;e<t;e++)s&&(s[e]+=f),i&&(i[e]+=p)}r.change.emit()}this._basepoint=[e.sx,e.sy]}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source);this._basepoint=null}}activate(){if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(const e of this.model.renderers){const t=e.data_source;t.connect(t.properties.data.change,()=>this._show_vertices())}this._initialized=!0}}deactivate(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()}}s.PolyDrawToolView=d,d.__name__="PolyDrawToolView";class l extends n.PolyTool{constructor(e){super(e),this.tool_name="Polygon Draw Tool",this.icon=_.bk_tool_icon_poly_draw,this.event_type=["pan","tap","move"],this.default_order=3}static init_PolyDrawTool(){this.prototype.default_view=d,this.define(({Boolean:e,Int:t})=>({drag:[e,!0],num_objects:[t,0]}))}}s.PolyDrawTool=l,l.__name__="PolyDrawTool",l.init_PolyDrawTool()},
function _(e,t,r,o,s){o();const i=e(8),l=e(363);class _ extends l.EditToolView{_set_vertices(e,t){const r=this.model.vertex_renderer.glyph,o=this.model.vertex_renderer.data_source,[s,l]=[r.x.field,r.y.field];s&&(i.isArray(e)?o.data[s]=e:r.x={value:e}),l&&(i.isArray(t)?o.data[l]=t:r.y={value:t}),this._emit_cds_changes(o,!0,!0,!1)}_hide_vertices(){this._set_vertices([],[])}_snap_to_vertex(e,t,r){if(this.model.vertex_renderer){const o=this._select_event(e,"replace",[this.model.vertex_renderer]),s=this.model.vertex_renderer.data_source,i=this.model.vertex_renderer.glyph,[l,_]=[i.x.field,i.y.field];if(o.length){const e=s.selected.indices[0];l&&(t=s.data[l][e]),_&&(r=s.data[_][e]),s.selection_manager.clear()}}return[t,r]}}r.PolyToolView=_,_.__name__="PolyToolView";class d extends l.EditTool{constructor(e){super(e)}static init_PolyTool(){this.define(({AnyRef:e})=>({vertex_renderer:[e()]}))}}r.PolyTool=d,d.__name__="PolyTool",d.init_PolyTool()},
function _(e,t,s,r,i){r();const _=e(71),d=e(8),n=e(368),l=e(197);class a extends n.PolyToolView{constructor(){super(...arguments),this._drawing=!1}_doubletap(e){if(!this.model.active)return;const t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null==t)return;const[s,r]=t,i=this._select_event(e,"replace",[this.model.vertex_renderer]),_=this.model.vertex_renderer.data_source,d=this.model.vertex_renderer.glyph,[n,l]=[d.x.field,d.y.field];if(i.length&&null!=this._selected_renderer){const e=_.selected.indices[0];this._drawing?(this._drawing=!1,_.selection_manager.clear()):(_.selected.indices=[e+1],n&&_.get_array(n).splice(e+1,0,s),l&&_.get_array(l).splice(e+1,0,r),this._drawing=!0),_.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}_show_vertices(e){if(!this.model.active)return;const t=this._select_event(e,"replace",this.model.renderers);if(!t.length)return this._set_vertices([],[]),this._selected_renderer=null,void(this._drawing=!1);const s=t[0],r=s.glyph,i=s.data_source,_=i.selected.indices[0],[n,l]=[r.xs.field,r.ys.field];let a,c;n?(a=i.data[n][_],d.isArray(a)||(i.data[n][_]=a=Array.from(a))):a=r.xs.value,l?(c=i.data[l][_],d.isArray(c)||(i.data[l][_]=c=Array.from(c))):c=r.ys.value,this._selected_renderer=s,this._set_vertices(a,c)}_move(e){if(this._drawing&&null!=this._selected_renderer){const t=this.model.vertex_renderer,s=t.data_source,r=t.glyph,i=this._map_drag(e.sx,e.sy,t);if(null==i)return;let[_,d]=i;const n=s.selected.indices;[_,d]=this._snap_to_vertex(e,_,d),s.selected.indices=n;const[l,a]=[r.x.field,r.y.field],c=n[0];l&&(s.data[l][c]=_),a&&(s.data[a][c]=d),s.change.emit(),this._selected_renderer.data_source.change.emit()}}_tap(e){const t=this.model.vertex_renderer,s=this._map_drag(e.sx,e.sy,t);if(null==s)return;if(this._drawing&&this._selected_renderer){let[r,i]=s;const _=t.data_source,d=t.glyph,[n,l]=[d.x.field,d.y.field],a=_.selected.indices;[r,i]=this._snap_to_vertex(e,r,i);const c=a[0];if(_.selected.indices=[c+1],n){const e=_.get_array(n),t=e[c];e[c]=r,e.splice(c+1,0,t)}if(l){const e=_.get_array(l),t=e[c];e[c]=i,e.splice(c+1,0,t)}return _.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}const r=this._select_mode(e);this._select_event(e,r,[t]),this._select_event(e,r,this.model.renderers)}_remove_vertex(){if(!this._drawing||!this._selected_renderer)return;const e=this.model.vertex_renderer,t=e.data_source,s=e.glyph,r=t.selected.indices[0],[i,_]=[s.x.field,s.y.field];i&&t.get_array(i).splice(r,1),_&&t.get_array(_).splice(r,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}_pan_start(e){this._select_event(e,"append",[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}_keyup(e){if(!this.model.active||!this._mouse_in_frame)return;let t;t=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;for(const s of t)e.keyCode===_.Keys.Backspace?(this._delete_selected(s),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==_.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),s.data_source.selection_manager.clear())}deactivate(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())}}s.PolyEditToolView=a,a.__name__="PolyEditToolView";class c extends n.PolyTool{constructor(e){super(e),this.tool_name="Poly Edit Tool",this.icon=l.bk_tool_icon_poly_edit,this.event_type=["tap","pan","move"],this.default_order=4}static init_PolyEditTool(){this.prototype.default_view=a}}s.PolyEditTool=c,c.__name__="PolyEditTool",c.init_PolyEditTool()},
function _(e,t,o,s,i){s();const l=e(371),n=e(136),_=e(20),c=e(197);class h extends l.SelectToolView{_compute_limits(e){const t=this.plot_view.frame,o=this.model.dimensions;let s=this._base_point;if("center"==this.model.origin){const[t,o]=s,[i,l]=e;s=[t-(i-t),o-(l-o)]}return this.model._get_dim_limits(s,e,t,o)}_pan_start(e){const{sx:t,sy:o}=e;this._base_point=[t,o]}_pan(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this.model.overlay.update({left:i[0],right:i[1],top:l[0],bottom:l[1]}),this.model.select_every_mousemove&&this._do_select(i,l,!1,this._select_mode(e))}_pan_end(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this._do_select(i,l,!0,this._select_mode(e)),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.state.push("box_select",{selection:this.plot_view.get_selection()})}_do_select([e,t],[o,s],i,l="replace"){const n={type:"rect",sx0:e,sx1:t,sy0:o,sy1:s};this._select(n,i,l)}}o.BoxSelectToolView=h,h.__name__="BoxSelectToolView";const r=()=>new n.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class a extends l.SelectTool{constructor(e){super(e),this.tool_name="Box Select",this.icon=c.bk_tool_icon_box_select,this.event_type="pan",this.default_order=30}static init_BoxSelectTool(){this.prototype.default_view=h,this.define(({Boolean:e,Ref:t})=>({dimensions:[_.Dimensions,"both"],select_every_mousemove:[e,!1],overlay:[t(n.BoxAnnotation),r],origin:[_.BoxOrigin,"corner"]})),this.register_alias("box_select",()=>new a),this.register_alias("xbox_select",()=>new a({dimensions:"width"})),this.register_alias("ybox_select",()=>new a({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}o.BoxSelectTool=a,a.__name__="BoxSelectTool",a.init_BoxSelectTool()},
function _(e,t,s,n,o){n();const r=e(185),c=e(103),i=e(124),l=e(104),a=e(240),d=e(20),_=e(71),h=e(80),p=e(15),u=e(11);class m extends r.GestureToolView{connect_signals(){super.connect_signals(),this.model.clear.connect(()=>this._clear())}get computed_renderers(){const{renderers:e,names:t}=this.model,s=this.plot_model.data_renderers;return a.compute_renderers(e,s,t)}_computed_renderers_by_data_source(){var e;const t=new Map;for(const s of this.computed_renderers){let n;if(s instanceof c.GlyphRenderer)n=s.data_source;else{if(!(s instanceof i.GraphRenderer))continue;n=s.node_renderer.data_source}const o=null!==(e=t.get(n))&&void 0!==e?e:[];t.set(n,[...o,s])}return t}_select_mode(e){const{shiftKey:t,ctrlKey:s}=e;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void u.unreachable():this.model.mode}_keyup(e){e.keyCode==_.Keys.Esc&&this._clear()}_clear(){for(const e of this.computed_renderers)e.get_selection_manager().clear();this.plot_view.request_render()}_select(e,t,s){const n=this._computed_renderers_by_data_source();for(const[,o]of n){const n=o[0].get_selection_manager(),r=[];for(const e of o){const t=this.plot_view.renderer_view(e);null!=t&&r.push(t)}n.select(r,e,t,s)}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)}_emit_selection_event(e,t=!0){const{x_scale:s,y_scale:n}=this.plot_view.frame;let o;switch(e.type){case"point":{const{sx:t,sy:r}=e,c=s.invert(t),i=n.invert(r);o=Object.assign(Object.assign({},e),{x:c,y:i});break}case"span":{const{sx:t,sy:r}=e,c=s.invert(t),i=n.invert(r);o=Object.assign(Object.assign({},e),{x:c,y:i});break}case"rect":{const{sx0:t,sx1:r,sy0:c,sy1:i}=e,[l,a]=s.r_invert(t,r),[d,_]=n.r_invert(c,i);o=Object.assign(Object.assign({},e),{x0:l,y0:d,x1:a,y1:_});break}case"poly":{const{sx:t,sy:r}=e,c=s.v_invert(t),i=n.v_invert(r);o=Object.assign(Object.assign({},e),{x:c,y:i});break}}this.plot_model.trigger_event(new h.SelectionGeometry(o,t))}}s.SelectToolView=m,m.__name__="SelectToolView";class v extends r.GestureTool{constructor(e){super(e)}initialize(){super.initialize(),this.clear=new p.Signal0(this,"clear")}static init_SelectTool(){this.define(({String:e,Array:t,Ref:s,Or:n,Auto:o})=>({renderers:[n(t(s(l.DataRenderer)),o),"auto"],names:[t(e),[]],mode:[d.SelectionMode,"replace"]}))}get menu(){return[{icon:"bk-tool-icon-replace-mode",tooltip:"Replace the current selection",active:()=>"replace"==this.mode,handler:()=>{this.mode="replace",this.active=!0}},{icon:"bk-tool-icon-append-mode",tooltip:"Append to the current selection (Shift)",active:()=>"append"==this.mode,handler:()=>{this.mode="append",this.active=!0}},{icon:"bk-tool-icon-intersect-mode",tooltip:"Intersect with the current selection (Ctrl)",active:()=>"intersect"==this.mode,handler:()=>{this.mode="intersect",this.active=!0}},{icon:"bk-tool-icon-subtract-mode",tooltip:"Subtract from the current selection (Shift+Ctrl)",active:()=>"subtract"==this.mode,handler:()=>{this.mode="subtract",this.active=!0}},null,{icon:"bk-tool-icon-clear-selection",tooltip:"Clear the current selection (Esc)",handler:()=>{this.clear.emit()}}]}}s.SelectTool=v,v.__name__="SelectTool",v.init_SelectTool()},
function _(t,o,e,s,i){s();const n=t(185),_=t(136),a=t(20),l=t(197);class r extends n.GestureToolView{_match_aspect(t,o,e){const s=e.bbox.aspect,i=e.bbox.h_range.end,n=e.bbox.h_range.start,_=e.bbox.v_range.end,a=e.bbox.v_range.start;let l=Math.abs(t[0]-o[0]),r=Math.abs(t[1]-o[1]);const h=0==r?0:l/r,[m]=h>=s?[1,h/s]:[s/h,1];let c,p,d,b;return t[0]<=o[0]?(c=t[0],p=t[0]+l*m,p>i&&(p=i)):(p=t[0],c=t[0]-l*m,c<n&&(c=n)),l=Math.abs(p-c),t[1]<=o[1]?(b=t[1],d=t[1]+l/s,d>_&&(d=_)):(d=t[1],b=t[1]-l/s,b<a&&(b=a)),r=Math.abs(d-b),t[0]<=o[0]?p=t[0]+s*r:c=t[0]-s*r,[[c,p],[b,d]]}_compute_limits(t){const o=this.plot_view.frame,e=this.model.dimensions;let s,i,n=this._base_point;if("center"==this.model.origin){const[o,e]=n,[s,i]=t;n=[o-(s-o),e-(i-e)]}return this.model.match_aspect&&"both"==e?[s,i]=this._match_aspect(n,t,o):[s,i]=this.model._get_dim_limits(n,t,o,e),[s,i]}_pan_start(t){this._base_point=[t.sx,t.sy]}_pan(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this.model.overlay.update({left:e[0],right:e[1],top:s[0],bottom:s[1]})}_pan_end(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this._update(e,s),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null}_update([t,o],[e,s]){if(Math.abs(o-t)<=5||Math.abs(s-e)<=5)return;const{x_scales:i,y_scales:n}=this.plot_view.frame,_=new Map;for(const[e,s]of i){const[i,n]=s.r_invert(t,o);_.set(e,{start:i,end:n})}const a=new Map;for(const[t,o]of n){const[i,n]=o.r_invert(e,s);a.set(t,{start:i,end:n})}const l={xrs:_,yrs:a};this.plot_view.state.push("box_zoom",{range:l}),this.plot_view.update_range(l)}}e.BoxZoomToolView=r,r.__name__="BoxZoomToolView";const h=()=>new _.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class m extends n.GestureTool{constructor(t){super(t),this.tool_name="Box Zoom",this.icon=l.bk_tool_icon_box_zoom,this.event_type="pan",this.default_order=20}static init_BoxZoomTool(){this.prototype.default_view=r,this.define(({Boolean:t,Ref:o})=>({dimensions:[a.Dimensions,"both"],overlay:[o(_.BoxAnnotation),h],match_aspect:[t,!1],origin:[a.BoxOrigin,"corner"]})),this.register_alias("box_zoom",()=>new m({dimensions:"both"})),this.register_alias("xbox_zoom",()=>new m({dimensions:"width"})),this.register_alias("ybox_zoom",()=>new m({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}e.BoxZoomTool=m,m.__name__="BoxZoomTool",m.init_BoxZoomTool()},
function _(e,s,t,o,a){o();const i=e(371),l=e(178),_=e(374),c=e(71),n=e(197);class h extends i.SelectToolView{initialize(){super.initialize(),this.data=null}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>this._active_change())}_active_change(){this.model.active||this._clear_overlay()}_keyup(e){e.keyCode==c.Keys.Enter&&this._clear_overlay()}_pan_start(e){const{sx:s,sy:t}=e;this.data={sx:[s],sy:[t]}}_pan(e){const{sx:s,sy:t}=e,[o,a]=this.plot_view.frame.bbox.clip(s,t);this.data.sx.push(o),this.data.sy.push(a);this.model.overlay.update({xs:this.data.sx,ys:this.data.sy}),this.model.select_every_mousemove&&this._do_select(this.data.sx,this.data.sy,!1,this._select_mode(e))}_pan_end(e){this._clear_overlay(),this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(e)),this.plot_view.state.push("lasso_select",{selection:this.plot_view.get_selection()})}_clear_overlay(){this.model.overlay.update({xs:[],ys:[]})}_do_select(e,s,t,o){const a={type:"poly",sx:e,sy:s};this._select(a,t,o)}}t.LassoSelectToolView=h,h.__name__="LassoSelectToolView";class d extends i.SelectTool{constructor(e){super(e),this.tool_name="Lasso Select",this.icon=n.bk_tool_icon_lasso_select,this.event_type="pan",this.default_order=12}static init_LassoSelectTool(){this.prototype.default_view=h,this.define(({Boolean:e,Ref:s})=>({select_every_mousemove:[e,!0],overlay:[s(l.PolyAnnotation),_.DEFAULT_POLY_OVERLAY]})),this.register_alias("lasso_select",()=>new d)}}t.LassoSelectTool=d,d.__name__="LassoSelectTool",d.init_LassoSelectTool()},
function _(e,t,s,l,o){l();const i=e(371),a=e(178),_=e(71),c=e(9),n=e(197);class h extends i.SelectToolView{initialize(){super.initialize(),this.data={sx:[],sy:[]}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>this._active_change())}_active_change(){this.model.active||this._clear_data()}_keyup(e){e.keyCode==_.Keys.Enter&&this._clear_data()}_doubletap(e){this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(e)),this.plot_view.state.push("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()}_clear_data(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})}_tap(e){const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)&&(this.data.sx.push(t),this.data.sy.push(s),this.model.overlay.update({xs:c.copy(this.data.sx),ys:c.copy(this.data.sy)}))}_do_select(e,t,s,l){const o={type:"poly",sx:e,sy:t};this._select(o,s,l)}}s.PolySelectToolView=h,h.__name__="PolySelectToolView",s.DEFAULT_POLY_OVERLAY=()=>new a.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class y extends i.SelectTool{constructor(e){super(e),this.tool_name="Poly Select",this.icon=n.bk_tool_icon_polygon_select,this.event_type="tap",this.default_order=11}static init_PolySelectTool(){this.prototype.default_view=h,this.define(({Ref:e})=>({overlay:[e(a.PolyAnnotation),s.DEFAULT_POLY_OVERLAY]})),this.register_alias("poly_select",()=>new y)}}s.PolySelectTool=y,y.__name__="PolySelectTool",y.init_PolySelectTool()},
function _(e,t,i,s,n){s();const r=e(20),_=e(376),d=e(197);class o extends _.LineToolView{constructor(){super(...arguments),this._drawing=!1}_doubletap(e){if(!this.model.active)return;const t=this.model.renderers;for(const i of t){1==this._select_event(e,"replace",[i]).length&&(this._selected_renderer=i)}this._show_intersections(),this._update_line_cds()}_show_intersections(){if(!this.model.active)return;if(null==this._selected_renderer)return;if(!this.model.renderers.length)return this._set_intersection([],[]),this._selected_renderer=null,void(this._drawing=!1);const e=this._selected_renderer.data_source,t=this._selected_renderer.glyph,[i,s]=[t.x.field,t.y.field],n=e.get_array(i),r=e.get_array(s);this._set_intersection(n,r)}_tap(e){const t=this.model.intersection_renderer;if(null==this._map_drag(e.sx,e.sy,t))return;if(this._drawing&&this._selected_renderer){const i=this._select_mode(e);if(0==this._select_event(e,i,[t]).length)return}const i=this._select_mode(e);this._select_event(e,i,[t]),this._select_event(e,i,this.model.renderers)}_update_line_cds(){if(null==this._selected_renderer)return;const e=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,[i,s]=[e.x.field,e.y.field];if(i&&s){const e=t.data[i],n=t.data[s];this._selected_renderer.data_source.data[i]=e,this._selected_renderer.data_source.data[s]=n}this._emit_cds_changes(this._selected_renderer.data_source,!0,!0,!1)}_pan_start(e){this._select_event(e,"append",[this.model.intersection_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer],this.model.dimensions),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer]),this._emit_cds_changes(this.model.intersection_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}activate(){this._drawing=!0}deactivate(){this._selected_renderer&&(this._drawing&&(this._drawing=!1),this._hide_intersections())}}i.LineEditToolView=o,o.__name__="LineEditToolView";class l extends _.LineTool{constructor(e){super(e),this.tool_name="Line Edit Tool",this.icon=d.bk_tool_icon_line_edit,this.event_type=["tap","pan","move"],this.default_order=4}static init_LineEditTool(){this.prototype.default_view=o,this.define(()=>({dimensions:[r.Dimensions,"both"]}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}i.LineEditTool=l,l.__name__="LineEditTool",l.init_LineEditTool()},
function _(e,i,t,n,o){n();const s=e(8),_=e(363);class r extends _.EditToolView{_set_intersection(e,i){const t=this.model.intersection_renderer.glyph,n=this.model.intersection_renderer.data_source,[o,_]=[t.x.field,t.y.field];o&&(s.isArray(e)?n.data[o]=e:t.x={value:e}),_&&(s.isArray(i)?n.data[_]=i:t.y={value:i}),this._emit_cds_changes(n,!0,!0,!1)}_hide_intersections(){this._set_intersection([],[])}}t.LineToolView=r,r.__name__="LineToolView";class c extends _.EditTool{constructor(e){super(e)}static init_LineTool(){this.define(({AnyRef:e})=>({intersection_renderer:[e()]}))}}t.LineTool=c,c.__name__="LineTool",c.init_LineTool()},
function _(t,s,n,i,e){i();const o=t(185),a=t(20),_=t(197);function h(t,s,n){const i=new Map;for(const[e,o]of t){const[t,a]=o.r_invert(s,n);i.set(e,{start:t,end:a})}return i}n.update_ranges=h;class l extends o.GestureToolView{_pan_start(t){var s;this.last_dx=0,this.last_dy=0;const{sx:n,sy:i}=t,e=this.plot_view.frame.bbox;if(!e.contains(n,i)){const t=e.h_range,s=e.v_range;(n<t.start||n>t.end)&&(this.v_axis_only=!0),(i<s.start||i>s.end)&&(this.h_axis_only=!0)}null===(s=this.model.document)||void 0===s||s.interactive_start(this.plot_model)}_pan(t){var s;this._update(t.deltaX,t.deltaY),null===(s=this.model.document)||void 0===s||s.interactive_start(this.plot_model)}_pan_end(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.state.push("pan",{range:this.pan_info})}_update(t,s){const n=this.plot_view.frame,i=t-this.last_dx,e=s-this.last_dy,o=n.bbox.h_range,a=o.start-i,_=o.end-i,l=n.bbox.v_range,d=l.start-e,r=l.end-e,p=this.model.dimensions;let c,u,m,x,v,y;"width"!=p&&"both"!=p||this.v_axis_only?(c=o.start,u=o.end,m=0):(c=a,u=_,m=-i),"height"!=p&&"both"!=p||this.h_axis_only?(x=l.start,v=l.end,y=0):(x=d,v=r,y=-e),this.last_dx=t,this.last_dy=s;const{x_scales:b,y_scales:g}=n,w=h(b,c,u),f=h(g,x,v);this.pan_info={xrs:w,yrs:f,sdx:m,sdy:y},this.plot_view.update_range(this.pan_info,{panning:!0})}}n.PanToolView=l,l.__name__="PanToolView";class d extends o.GestureTool{constructor(t){super(t),this.tool_name="Pan",this.event_type="pan",this.default_order=10}static init_PanTool(){this.prototype.default_view=l,this.define(()=>({dimensions:[a.Dimensions,"both",{on_update(t,s){switch(t){case"both":s.icon=_.bk_tool_icon_pan;break;case"width":s.icon=_.bk_tool_icon_xpan;break;case"height":s.icon=_.bk_tool_icon_ypan}}}]})),this.register_alias("pan",()=>new d({dimensions:"both"})),this.register_alias("xpan",()=>new d({dimensions:"width"})),this.register_alias("ypan",()=>new d({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip("Pan",this.dimensions)}}n.PanTool=d,d.__name__="PanTool",d.init_PanTool()},
function _(e,t,i,s,n){s();const l=e(136),a=e(168),r=e(19),o=e(185),_=e(197);function h(e){switch(e){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return e}}function d(e,t,i,s){if(null==t)return!1;const n=i.compute(t);return Math.abs(e-n)<s}function u(e,t,i,s,n){let l=!0;if(null!=n.left&&null!=n.right){const t=i.invert(e);(t<n.left||t>n.right)&&(l=!1)}if(null!=n.bottom&&null!=n.top){const e=s.invert(t);(e<n.bottom||e>n.top)&&(l=!1)}return l}function c(e,t,i){let s=0;return e>=i.start&&e<=i.end&&(s+=1),t>=i.start&&t<=i.end&&(s+=1),s}function g(e,t,i,s){const n=t.compute(e),l=t.invert(n+i);return l>=s.start&&l<=s.end?l:e}function y(e,t,i){return e>t.start?(t.end=e,i):(t.end=t.start,t.start=e,h(i))}function f(e,t,i){return e<t.end?(t.start=e,i):(t.start=t.end,t.end=e,h(i))}function m(e,t,i,s){const[n,l]=t.r_compute(e.start,e.end),[a,r]=t.r_invert(n+i,l+i),o=c(e.start,e.end,s);c(a,r,s)>=o&&(e.start=a,e.end=r)}i.flip_side=h,i.is_near=d,i.is_inside=u,i.sides_inside=c,i.compute_value=g,i.update_range_end_side=y,i.update_range_start_side=f,i.update_range=m;class p extends o.GestureToolView{initialize(){super.initialize(),this.side=0,this.model.update_overlay_from_ranges()}connect_signals(){super.connect_signals(),null!=this.model.x_range&&this.connect(this.model.x_range.change,()=>this.model.update_overlay_from_ranges()),null!=this.model.y_range&&this.connect(this.model.y_range.change,()=>this.model.update_overlay_from_ranges())}_pan_start(e){this.last_dx=0,this.last_dy=0;const t=this.model.x_range,i=this.model.y_range,{frame:s}=this.plot_view,n=s.x_scale,a=s.y_scale,r=this.model.overlay,{left:o,right:_,top:h,bottom:c}=r,g=this.model.overlay.properties.line_width.value()+l.EDGE_TOLERANCE;null!=t&&this.model.x_interaction&&(d(e.sx,o,n,g)?this.side=1:d(e.sx,_,n,g)?this.side=2:u(e.sx,e.sy,n,a,r)&&(this.side=3)),null!=i&&this.model.y_interaction&&(0==this.side&&d(e.sy,c,a,g)&&(this.side=4),0==this.side&&d(e.sy,h,a,g)?this.side=5:u(e.sx,e.sy,n,a,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))}_pan(e){const t=this.plot_view.frame,i=e.deltaX-this.last_dx,s=e.deltaY-this.last_dy,n=this.model.x_range,l=this.model.y_range,a=t.x_scale,r=t.y_scale;if(null!=n)if(3==this.side||7==this.side)m(n,a,i,t.x_range);else if(1==this.side){const e=g(n.start,a,i,t.x_range);this.side=f(e,n,this.side)}else if(2==this.side){const e=g(n.end,a,i,t.x_range);this.side=y(e,n,this.side)}if(null!=l)if(6==this.side||7==this.side)m(l,r,s,t.y_range);else if(4==this.side){const e=g(l.start,r,s,t.y_range);this.side=f(e,l,this.side)}else if(5==this.side){const e=g(l.end,r,s,t.y_range);this.side=y(e,l,this.side)}this.last_dx=e.deltaX,this.last_dy=e.deltaY}_pan_end(e){this.side=0}}i.RangeToolView=p,p.__name__="RangeToolView";const v=()=>new l.BoxAnnotation({level:"overlay",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:.5,line_dash:[2,2]});class x extends o.GestureTool{constructor(e){super(e),this.tool_name="Range Tool",this.icon=_.bk_tool_icon_range,this.event_type="pan",this.default_order=1}static init_RangeTool(){this.prototype.default_view=p,this.define(({Boolean:e,Ref:t,Nullable:i})=>({x_range:[i(t(a.Range1d)),null],x_interaction:[e,!0],y_range:[i(t(a.Range1d)),null],y_interaction:[e,!0],overlay:[t(l.BoxAnnotation),v]}))}initialize(){super.initialize(),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null}update_overlay_from_ranges(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,r.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)}}i.RangeTool=x,x.__name__="RangeTool",x.init_RangeTool()},
function _(e,t,s,o,i){o();const c=e(371),n=e(20),l=e(197);class a extends c.SelectToolView{_tap(e){const{sx:t,sy:s}=e,o={type:"point",sx:t,sy:s};this._select(o,!0,this._select_mode(e))}_select(e,t,s){const o=this.model.callback;if("select"==this.model.behavior){const i=this._computed_renderers_by_data_source();for(const[,c]of i){const i=c[0].get_selection_manager(),n=c.map(e=>this.plot_view.renderer_view(e)).filter(e=>null!=e);if(i.select(n,e,t,s)&&null!=o){const t=n[0].coordinates.x_scale.invert(e.sx),s=n[0].coordinates.y_scale.invert(e.sy),c={geometries:Object.assign(Object.assign({},e),{x:t,y:s}),source:i.source};o.execute(this.model,c)}}this._emit_selection_event(e),this.plot_view.state.push("tap",{selection:this.plot_view.get_selection()})}else for(const t of this.computed_renderers){const s=this.plot_view.renderer_view(t);if(null==s)continue;const i=t.get_selection_manager();if(i.inspect(s,e)&&null!=o){const t=s.coordinates.x_scale.invert(e.sx),c=s.coordinates.y_scale.invert(e.sy),n={geometries:Object.assign(Object.assign({},e),{x:t,y:c}),source:i.source};o.execute(this.model,n)}}}}s.TapToolView=a,a.__name__="TapToolView";class _ extends c.SelectTool{constructor(e){super(e),this.tool_name="Tap",this.icon=l.bk_tool_icon_tap_select,this.event_type="tap",this.default_order=10}static init_TapTool(){this.prototype.default_view=a,this.define(({Any:e,Nullable:t})=>({behavior:[n.TapBehavior,"select"],callback:[t(e)]})),this.register_alias("click",()=>new _({behavior:"inspect"})),this.register_alias("tap",()=>new _)}}s.TapTool=_,_.__name__="TapTool",_.init_TapTool()},
function _(e,t,s,i,n){i();const o=e(185),a=e(20),l=e(197),h=e(377);class _ extends o.GestureToolView{_scroll(e){let t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)}_update_ranges(e){var t;const{frame:s}=this.plot_view,i=s.bbox.h_range,n=s.bbox.v_range,[o,a]=[i.start,i.end],[l,_]=[n.start,n.end];let r,d,c,p;switch(this.model.dimension){case"height":{const t=Math.abs(_-l);r=o,d=a,c=l-t*e,p=_-t*e;break}case"width":{const t=Math.abs(a-o);r=o-t*e,d=a-t*e,c=l,p=_;break}default:throw new Error("this shouldn't have happened")}const{x_scales:u,y_scales:w}=s,m={xrs:h.update_ranges(u,r,d),yrs:h.update_ranges(w,c,p),factor:e};this.plot_view.state.push("wheel_pan",{range:m}),this.plot_view.update_range(m,{scrolling:!0}),null===(t=this.model.document)||void 0===t||t.interactive_start(this.plot_model)}}s.WheelPanToolView=_,_.__name__="WheelPanToolView";class r extends o.GestureTool{constructor(e){super(e),this.tool_name="Wheel Pan",this.icon=l.bk_tool_icon_wheel_pan,this.event_type="scroll",this.default_order=12}static init_WheelPanTool(){this.prototype.default_view=_,this.define(()=>({dimension:[a.Dimension,"width"]})),this.internal(({Number:e})=>({speed:[e,.001]})),this.register_alias("xwheel_pan",()=>new r({dimension:"width"})),this.register_alias("ywheel_pan",()=>new r({dimension:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimension)}}s.WheelPanTool=r,r.__name__="WheelPanTool",r.init_WheelPanTool()},
function _(e,o,t,s,i){s();const l=e(185),n=e(361),h=e(20),_=e(82),a=e(197);class m extends l.GestureToolView{_pinch(e){const{sx:o,sy:t,scale:s,ctrlKey:i,shiftKey:l}=e;let n;n=s>=1?20*(s-1):-20/s,this._scroll({type:"wheel",sx:o,sy:t,delta:n,ctrlKey:i,shiftKey:l})}_scroll(e){var o;const{frame:t}=this.plot_view,s=t.bbox.h_range,i=t.bbox.v_range,{sx:l,sy:h}=e,_=this.model.dimensions,a=("width"==_||"both"==_)&&s.start<l&&l<s.end,m=("height"==_||"both"==_)&&i.start<h&&h<i.end;if(!(a&&m||this.model.zoom_on_axis))return;const r=this.model.speed*e.delta,d=n.scale_range(t,r,a,m,{x:l,y:h});this.plot_view.state.push("wheel_zoom",{range:d});const{maintain_focus:c}=this.model;this.plot_view.update_range(d,{scrolling:!0,maintain_focus:c}),null===(o=this.model.document)||void 0===o||o.interactive_start(this.plot_model)}}t.WheelZoomToolView=m,m.__name__="WheelZoomToolView";class r extends l.GestureTool{constructor(e){super(e),this.tool_name="Wheel Zoom",this.icon=a.bk_tool_icon_wheel_zoom,this.event_type=_.is_mobile?"pinch":"scroll",this.default_order=10}static init_WheelZoomTool(){this.prototype.default_view=m,this.define(({Boolean:e,Number:o})=>({dimensions:[h.Dimensions,"both"],maintain_focus:[e,!0],zoom_on_axis:[e,!0],speed:[o,1/600]})),this.register_alias("wheel_zoom",()=>new r({dimensions:"both"})),this.register_alias("xwheel_zoom",()=>new r({dimensions:"width"})),this.register_alias("ywheel_zoom",()=>new r({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}t.WheelZoomTool=r,r.__name__="WheelZoomTool",r.init_WheelZoomTool()},
function _(i,s,t,o,e){o();const n=i(193),l=i(180),h=i(20),a=i(13),r=i(197);class _ extends n.InspectToolView{_move(i){if(!this.model.active)return;const{sx:s,sy:t}=i;this.plot_view.frame.bbox.contains(s,t)?this._update_spans(s,t):this._update_spans(null,null)}_move_exit(i){this._update_spans(null,null)}_update_spans(i,s){const t=this.model.dimensions;"width"!=t&&"both"!=t||(this.model.spans.width.location=s),"height"!=t&&"both"!=t||(this.model.spans.height.location=i)}}t.CrosshairToolView=_,_.__name__="CrosshairToolView";class c extends n.InspectTool{constructor(i){super(i),this.tool_name="Crosshair",this.icon=r.bk_tool_icon_crosshair}static init_CrosshairTool(){function i(i,s){return new l.Span({for_hover:!0,dimension:s,location_units:"screen",level:"overlay",line_color:i.line_color,line_width:i.line_width,line_alpha:i.line_alpha})}this.prototype.default_view=_,this.define(({Alpha:i,Number:s,Color:t})=>({dimensions:[h.Dimensions,"both"],line_color:[t,"black"],line_width:[s,1],line_alpha:[i,1]})),this.internal(({Struct:s,Ref:t})=>({spans:[s({width:t(l.Span),height:t(l.Span)}),s=>({width:i(s,"width"),height:i(s,"height")})]})),this.register_alias("crosshair",()=>new c)}get tooltip(){return this._get_dim_tooltip("Crosshair",this.dimensions)}get synthetic_renderers(){return a.values(this.spans)}}t.CrosshairTool=c,c.__name__="CrosshairTool",c.init_CrosshairTool()},
function _(t,e,s,o,r){o();const n=t(88),i=t(13),a=t(29);class u extends n.Model{constructor(t){super(t)}static init_CustomJSHover(){this.define(({Unknown:t,String:e,Dict:s})=>({args:[s(t),{}],code:[e,""]}))}get values(){return i.values(this.args)}_make_code(t,e,s,o){return new Function(...i.keys(this.args),t,e,s,a.use_strict(o))}format(t,e,s){return this._make_code("value","format","special_vars",this.code)(...this.values,t,e,s)}}s.CustomJSHover=u,u.__name__="CustomJSHover",u.init_CustomJSHover()},
function _(e,t,s,n,o){n();const i=e(1),r=e(193),l=e(383),a=e(200),c=e(103),_=e(124),d=e(104),p=e(105),h=e(127),u=i.__importStar(e(108)),m=e(215),y=e(71),f=e(22),x=e(13),v=e(84),w=e(8),g=e(123),b=e(20),k=e(197),S=e(201),T=e(15),C=e(240);function R(e,t,s,n,o,i){const r={x:o[e],y:i[e]},l={x:o[e+1],y:i[e+1]};let a,c;if("span"==t.type)"h"==t.direction?(a=Math.abs(r.x-s),c=Math.abs(l.x-s)):(a=Math.abs(r.y-n),c=Math.abs(l.y-n));else{const e={x:s,y:n};a=u.dist_2_pts(r,e),c=u.dist_2_pts(l,e)}return a<c?[[r.x,r.y],e]:[[l.x,l.y],e+1]}function H(e,t,s){return[[e[s],t[s]],s]}s._nearest_line_hit=R,s._line_hit=H;class M extends r.InspectToolView{initialize(){super.initialize(),this._ttmodels=new Map,this._ttviews=new Map;const{tooltips:e}=this.model;w.isArray(e)&&(this._template_el=this._create_template(e))}async lazy_initialize(){await super.lazy_initialize(),await this._update_ttmodels()}remove(){g.remove_views(this._ttviews),super.remove()}connect_signals(){super.connect_signals();const e=this.plot_model.properties.renderers,{renderers:t,tooltips:s}=this.model.properties;this.on_change([e,t,s],async()=>await this._update_ttmodels())}async _update_ttmodels(){const{_ttmodels:e,computed_renderers:t}=this;e.clear();const{tooltips:s}=this.model;if(null!=s)for(const t of this.computed_renderers){const n=new a.Tooltip({custom:w.isString(s)||w.isFunction(s),attachment:this.model.attachment,show_arrow:this.model.show_arrow});t instanceof c.GlyphRenderer?e.set(t,n):t instanceof _.GraphRenderer&&(e.set(t.node_renderer,n),e.set(t.edge_renderer,n))}const n=await g.build_views(this._ttviews,[...e.values()],{parent:this.plot_view});for(const e of n)e.render();const o=[...function*(){for(const e of t)e instanceof c.GlyphRenderer?yield e:e instanceof _.GraphRenderer&&(yield e.node_renderer,yield e.edge_renderer)}()],i=this._slots.get(this._update);if(null!=i){const e=new Set(o.map(e=>e.data_source));T.Signal.disconnect_receiver(this,i,e)}for(const e of o)this.connect(e.data_source.inspect,this._update)}get computed_renderers(){const{renderers:e,names:t}=this.model,s=this.plot_model.data_renderers;return C.compute_renderers(e,s,t)}get ttmodels(){return this._ttmodels}_clear(){this._inspect(1/0,1/0);for(const[,e]of this.ttmodels)e.clear()}_move(e){if(!this.model.active)return;const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)?this._inspect(t,s):this._clear()}_move_exit(){this._clear()}_inspect(e,t){let s;if("mouse"==this.model.mode)s={type:"point",sx:e,sy:t};else{s={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t}}for(const e of this.computed_renderers){const t=e.get_selection_manager(),n=this.plot_view.renderer_view(e);null!=n&&t.inspect(n,s)}this._emit_callback(s)}_update([e,{geometry:t}]){var s,n;if(!this.model.active)return;if("point"!=t.type&&"span"!=t.type)return;if(!(e instanceof c.GlyphRenderer))return;if("ignore"==this.model.muted_policy&&e.muted)return;const o=this.ttmodels.get(e);if(null==o)return;const i=e.get_selection_manager();let r=i.inspectors.get(e);if(r=e.view.convert_selection_to_subset(r),r.is_empty())return void o.clear();const l=i.source,a=this.plot_view.renderer_view(e);if(null==a)return;const{sx:_,sy:d}=t,u=a.coordinates.x_scale,m=a.coordinates.y_scale,f=u.invert(_),v=m.invert(d),{glyph:w}=a,g=[];if(w instanceof p.LineView)for(const s of r.line_indices){let n,o,i=w._x[s+1],a=w._y[s+1],c=s;switch(this.model.line_policy){case"interp":[i,a]=w.get_interpolation_hit(s,t),n=u.compute(i),o=m.compute(a);break;case"prev":[[n,o],c]=H(w.sx,w.sy,s);break;case"next":[[n,o],c]=H(w.sx,w.sy,s+1);break;case"nearest":[[n,o],c]=R(s,t,_,d,w.sx,w.sy),i=w._x[c],a=w._y[c];break;default:[n,o]=[_,d]}const p={index:c,x:f,y:v,sx:_,sy:d,data_x:i,data_y:a,rx:n,ry:o,indices:r.line_indices,name:e.name};g.push([n,o,this._render_tooltips(l,c,p)])}for(const t of r.image_indices){const s={index:t.index,x:f,y:v,sx:_,sy:d,name:e.name},n=this._render_tooltips(l,t,s);g.push([_,d,n])}for(const o of r.indices)if(w instanceof h.MultiLineView&&!x.isEmpty(r.multiline_indices))for(const s of r.multiline_indices[o.toString()]){let n,i,a,p=w._xs.get(o)[s],h=w._ys.get(o)[s],y=s;switch(this.model.line_policy){case"interp":[p,h]=w.get_interpolation_hit(o,s,t),n=u.compute(p),i=m.compute(h);break;case"prev":[[n,i],y]=H(w.sxs.get(o),w.sys.get(o),s);break;case"next":[[n,i],y]=H(w.sxs.get(o),w.sys.get(o),s+1);break;case"nearest":[[n,i],y]=R(s,t,_,d,w.sxs.get(o),w.sys.get(o)),p=w._xs.get(o)[y],h=w._ys.get(o)[y];break;default:throw new Error("should't have happened")}a=e instanceof c.GlyphRenderer?e.view.convert_indices_from_subset([o])[0]:o;const x={index:a,x:f,y:v,sx:_,sy:d,data_x:p,data_y:h,segment_index:y,indices:r.multiline_indices,name:e.name};g.push([n,i,this._render_tooltips(l,a,x)])}else{const t=null===(s=w._x)||void 0===s?void 0:s[o],i=null===(n=w._y)||void 0===n?void 0:n[o];let a,p,h;if("snap_to_data"==this.model.point_policy){let e=w.get_anchor_point(this.model.anchor,o,[_,d]);if(null==e&&(e=w.get_anchor_point("center",o,[_,d]),null==e))continue;a=e.x,p=e.y}else[a,p]=[_,d];h=e instanceof c.GlyphRenderer?e.view.convert_indices_from_subset([o])[0]:o;const u={index:h,x:f,y:v,sx:_,sy:d,data_x:t,data_y:i,indices:r.indices,name:e.name};g.push([a,p,this._render_tooltips(l,h,u)])}if(0==g.length)o.clear();else{const{content:e}=o;y.empty(o.content);for(const[,,t]of g)null!=t&&e.appendChild(t);const[t,s]=g[g.length-1];o.setv({position:[t,s]},{check_eq:!1})}}_emit_callback(e){const{callback:t}=this.model;if(null!=t)for(const s of this.computed_renderers){if(!(s instanceof c.GlyphRenderer))continue;const n=this.plot_view.renderer_view(s);if(null==n)continue;const{x_scale:o,y_scale:i}=n.coordinates,r=o.invert(e.sx),l=i.invert(e.sy);t.execute(this.model,{geometry:Object.assign({x:r,y:l},e),renderer:s})}}_create_template(e){const t=y.div({style:{display:"table",borderSpacing:"2px"}});for(const[s]of e){const e=y.div({style:{display:"table-row"}});t.appendChild(e);const n=y.div({style:{display:"table-cell"},class:S.bk_tooltip_row_label},0!=s.length?s+": ":"");e.appendChild(n);const o=y.span();o.dataset.value="";const i=y.span({class:S.bk_tooltip_color_block}," ");i.dataset.swatch="",y.undisplay(i);const r=y.div({style:{display:"table-cell"},class:S.bk_tooltip_row_value},o,i);e.appendChild(r)}return t}_render_template(e,t,s,n,o){const i=e.cloneNode(!0),r=i.querySelectorAll("[data-value]"),l=i.querySelectorAll("[data-swatch]"),a=/\$color(\[.*\])?:(\w*)/;for(const[[,e],i]of v.enumerate(t)){const t=e.match(a);if(null!=t){const[,e="",o]=t,a=s.get_column(o);if(null==a){r[i].textContent=o+" unknown";continue}const c=e.indexOf("hex")>=0,_=e.indexOf("swatch")>=0;let d=w.isNumber(n)?a[n]:null;if(null==d){r[i].textContent="(null)";continue}c&&(d=f.color2hex(d)),r[i].textContent=d,_&&(l[i].style.backgroundColor=d,y.display(l[i]))}else{const t=m.replace_placeholders(e.replace("$~","$data_"),s,n,this.model.formatters,o);if(w.isString(t))r[i].textContent=t;else for(const e of t)r[i].appendChild(e)}}return i}_render_tooltips(e,t,s){const n=this.model.tooltips;if(w.isString(n)){const o=m.replace_placeholders({html:n},e,t,this.model.formatters,s);return y.div({},o)}return w.isFunction(n)?n(e,s):null!=n?this._render_template(this._template_el,n,e,t,s):null}}s.HoverToolView=M,M.__name__="HoverToolView";class A extends r.InspectTool{constructor(e){super(e),this.tool_name="Hover",this.icon=k.bk_tool_icon_hover}static init_HoverTool(){this.prototype.default_view=M,this.define(({Any:e,Boolean:t,String:s,Array:n,Tuple:o,Dict:i,Or:r,Ref:a,Function:c,Auto:_,Nullable:p})=>({tooltips:[p(r(s,n(o(s,s)),c())),[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[i(r(a(l.CustomJSHover),m.FormatterType)),{}],renderers:[r(n(a(d.DataRenderer)),_),"auto"],names:[n(s),[]],mode:[b.HoverMode,"mouse"],muted_policy:[b.MutedPolicy,"show"],point_policy:[b.PointPolicy,"snap_to_data"],line_policy:[b.LinePolicy,"nearest"],show_arrow:[t,!0],anchor:[b.Anchor,"center"],attachment:[b.TooltipAttachment,"horizontal"],callback:[p(e)]})),this.register_alias("hover",()=>new A)}}s.HoverTool=A,A.__name__="HoverTool",A.init_HoverTool()},
function _(t,o,e,n,i){n();const s=t(15),l=t(88),c=t(186),r=t(193),a=t(84);class u extends l.Model{constructor(t){super(t)}static init_ToolProxy(){this.define(({Boolean:t,Array:o,Ref:e})=>({tools:[o(e(c.ButtonTool)),[]],active:[t,!1],disabled:[t,!1]}))}get button_view(){return this.tools[0].button_view}get event_type(){return this.tools[0].event_type}get tooltip(){return this.tools[0].tooltip}get tool_name(){return this.tools[0].tool_name}get icon(){return this.tools[0].computed_icon}get computed_icon(){return this.icon}get toggleable(){const t=this.tools[0];return t instanceof r.InspectTool&&t.toggleable}initialize(){super.initialize(),this.do=new s.Signal0(this,"do")}connect_signals(){super.connect_signals(),this.connect(this.do,()=>this.doit()),this.connect(this.properties.active.change,()=>this.set_active());for(const t of this.tools)this.connect(t.properties.active.change,()=>{this.active=t.active})}doit(){for(const t of this.tools)t.do.emit()}set_active(){for(const t of this.tools)t.active=this.active}get menu(){const{menu:t}=this.tools[0];if(null==t)return null;const o=[];for(const[e,n]of a.enumerate(t))if(null==e)o.push(null);else{const t=()=>{var t,o;for(const e of this.tools)null===(o=null===(t=e.menu)||void 0===t?void 0:t[n])||void 0===o||o.handler()};o.push(Object.assign(Object.assign({},e),{handler:t}))}return o}}e.ToolProxy=u,u.__name__="ToolProxy",u.init_ToolProxy()},
function _(o,t,s,i,e){i();const n=o(20),r=o(9),l=o(13),c=o(194),h=o(183),a=o(385),_=o(299),p=o(241);class f extends c.ToolbarBase{constructor(o){super(o)}static init_ProxyToolbar(){this.define(({Array:o,Ref:t})=>({toolbars:[o(t(h.Toolbar)),[]]}))}initialize(){super.initialize(),this._merge_tools()}_merge_tools(){this._proxied_tools=[];const o={},t={},s={},i=[],e=[];for(const o of this.help)r.includes(e,o.redirect)||(i.push(o),e.push(o.redirect));this._proxied_tools.push(...i),this.help=i;for(const[o,t]of l.entries(this.gestures)){o in s||(s[o]={});for(const i of t.tools)i.type in s[o]||(s[o][i.type]=[]),s[o][i.type].push(i)}for(const t of this.inspectors)t.type in o||(o[t.type]=[]),o[t.type].push(t);for(const o of this.actions)o.type in t||(t[o.type]=[]),t[o.type].push(o);const n=(o,t=!1)=>{const s=new a.ToolProxy({tools:o,active:t});return this._proxied_tools.push(s),s};for(const o of l.keys(s)){const t=this.gestures[o];t.tools=[];for(const i of l.keys(s[o])){const e=s[o][i];if(e.length>0)if("multi"==o)for(const o of e){const s=n([o]);t.tools.push(s),this.connect(s.properties.active.change,()=>this._active_change(s))}else{const o=n(e);t.tools.push(o),this.connect(o.properties.active.change,()=>this._active_change(o))}}}this.actions=[];for(const[o,s]of l.entries(t))if("CustomAction"==o)for(const o of s)this.actions.push(n([o]));else s.length>0&&this.actions.push(n(s));this.inspectors=[];for(const t of l.values(o))t.length>0&&this.inspectors.push(n(t,!0));for(const[o,t]of l.entries(this.gestures))0!=t.tools.length&&(t.tools=r.sort_by(t.tools,o=>o.default_order),"pinch"!=o&&"scroll"!=o&&"multi"!=o&&(t.tools[0].active=!0))}}s.ProxyToolbar=f,f.__name__="ProxyToolbar",f.init_ProxyToolbar();class u extends _.LayoutDOMView{initialize(){this.model.toolbar.toolbar_location=this.model.toolbar_location,super.initialize()}get child_models(){return[this.model.toolbar]}_update_layout(){this.layout=new p.ContentBox(this.child_views[0].el);const{toolbar:o}=this.model;o.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})}}s.ToolbarBoxView=u,u.__name__="ToolbarBoxView";class y extends _.LayoutDOM{constructor(o){super(o)}static init_ToolbarBox(){this.prototype.default_view=u,this.define(({Ref:o})=>({toolbar:[o(c.ToolbarBase)],toolbar_location:[n.Location,"right"]}))}}s.ToolbarBox=y,y.__name__="ToolbarBox",y.init_ToolbarBox()},
function _(n,e,t,o,i){o();const d=n(5),c=n(77),s=n(123),a=n(71),l=n(388);t.index={},t.add_document_standalone=async function(n,e,o=[],i=!1){const u=new Map;async function f(i){let d;const f=n.roots().indexOf(i),r=o[f];null!=r?d=r:e.classList.contains(l.BOKEH_ROOT)?d=e:(d=a.div({class:l.BOKEH_ROOT}),e.appendChild(d));const w=await s.build_view(i,{parent:null});return w instanceof c.DOMView&&w.renderTo(d),u.set(i,w),t.index[i.id]=w,w}for(const e of n.roots())await f(e);return i&&(window.document.title=n.title()),n.on_change(n=>{n instanceof d.RootAddedEvent?f(n.model):n instanceof d.RootRemovedEvent?function(n){const e=u.get(n);null!=e&&(e.remove(),u.delete(n),delete t.index[n.id])}(n.model):i&&n instanceof d.TitleChangedEvent&&(window.document.title=n.title)}),[...u.values()]}},
function _(o,e,n,t,r){t();const l=o(71),d=o(300);function u(o){let e=document.getElementById(o);if(null==e)throw new Error(`Error rendering Bokeh model: could not find #${o} HTML tag`);if(!document.body.contains(e))throw new Error(`Error rendering Bokeh model: element #${o} must be under <body>`);if("SCRIPT"==e.tagName){const o=l.div({class:n.BOKEH_ROOT});l.replaceWith(e,o),e=o}return e}n.BOKEH_ROOT=d.bk_root,n._resolve_element=function(o){const{elementid:e}=o;return null!=e?u(e):document.body},n._resolve_root_elements=function(o){const e=[];if(null!=o.root_ids&&null!=o.roots)for(const n of o.root_ids)e.push(u(o.roots[n]));return e}},
function _(n,o,t,s,e){s();const c=n(390),r=n(19),a=n(387);t._get_ws_url=function(n,o){let t,s="ws:";return"https:"==window.location.protocol&&(s="wss:"),null!=o?(t=document.createElement("a"),t.href=o):t=window.location,null!=n?"/"==n&&(n=""):n=t.pathname.replace(/\/+$/,""),s+"//"+t.host+n+"/ws"};const i={};t.add_document_from_session=async function(n,o,t,s=[],e=!1){const l=window.location.search.substr(1);let d;try{d=await function(n,o,t){const s=c.parse_token(o).session_id;n in i||(i[n]={});const e=i[n];return s in e||(e[s]=c.pull_session(n,o,t)),e[s]}(n,o,l)}catch(n){const t=c.parse_token(o).session_id;throw r.logger.error(`Failed to load Bokeh session ${t}: ${n}`),n}return a.add_document_standalone(d.document,t,s,e)}},
function _(e,s,n,t,o){t();const r=e(19),i=e(5),c=e(391),l=e(392),_=e(393);n.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",n.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";let h=0;function a(e){let s=e.split(".")[0];const n=s.length%4;return 0!=n&&(s+="=".repeat(4-n)),JSON.parse(atob(s.replace(/_/g,"/").replace(/-/g,"+")))}n.parse_token=a;class d{constructor(e=n.DEFAULT_SERVER_WEBSOCKET_URL,s=n.DEFAULT_TOKEN,t=null){this.url=e,this.token=s,this.args_string=t,this._number=h++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new l.Receiver,this.id=a(s).session_id.split(".")[0],r.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`)}async connect(){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{let e=""+this.url;return null!=this.args_string&&this.args_string.length>0&&(e+="?"+this.args_string),this.socket=new WebSocket(e,["bokeh",this.token]),new Promise((e,s)=>{this.socket.binaryType="arraybuffer",this.socket.onopen=()=>this._on_open(e,s),this.socket.onmessage=e=>this._on_message(e),this.socket.onclose=e=>this._on_close(e,s),this.socket.onerror=()=>this._on_error(s)})}catch(e){throw r.logger.error("websocket creation failed to url: "+this.url),r.logger.error(" - "+e),e}}close(){this.closed_permanently||(r.logger.debug("Permanently closing websocket connection "+this._number),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,"close method called on ClientConnection "+this._number),this.session._connection_closed())}_schedule_reconnect(e){setTimeout(()=>{this.closed_permanently||r.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`)},e)}send(e){if(null==this.socket)throw new Error("not connected so cannot send "+e);e.send(this.socket)}async send_with_reply(e){const s=await new Promise((s,n)=>{this._pending_replies.set(e.msgid(),{resolve:s,reject:n}),this.send(e)});if("ERROR"===s.msgtype())throw new Error("Error reply "+s.content.text);return s}async _pull_doc_json(){const e=c.Message.create("PULL-DOC-REQ",{}),s=await this.send_with_reply(e);if(!("doc"in s.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return s.content.doc}async _repull_session_doc(e,s){var n;r.logger.debug(this.session?"Repulling session":"Pulling session for first time");try{const n=await this._pull_doc_json();if(null==this.session)if(this.closed_permanently)r.logger.debug("Got new document after connection was already closed"),s(new Error("The connection has been closed"));else{const s=i.Document.from_json(n),t=i.Document._compute_patch_since_json(n,s);if(t.events.length>0){r.logger.debug(`Sending ${t.events.length} changes from model construction back to server`);const e=c.Message.create("PATCH-DOC",{},t);this.send(e)}this.session=new _.ClientSession(this,s,this.id);for(const e of this._pending_messages)this.session.handle(e);this._pending_messages=[],r.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(n),r.logger.debug("Updated existing session with new pulled doc")}catch(e){null===(n=console.trace)||void 0===n||n.call(console,e),r.logger.error("Failed to repull session "+e),s(e instanceof Error?e:""+e)}}_on_open(e,s){r.logger.info(`Websocket connection ${this._number} is now open`),this._current_handler=n=>{this._awaiting_ack_handler(n,e,s)}}_on_message(e){null==this._current_handler&&r.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(""+e)}const s=this._receiver.message;if(null!=s){const e=s.problem();null!=e&&this._close_bad_protocol(e),this._current_handler(s)}}_on_close(e,s){r.logger.info(`Lost websocket ${this._number} connection, ${e.code} (${e.reason})`),this.socket=null,this._pending_replies.forEach(e=>e.reject("Disconnected")),this._pending_replies.clear(),this.closed_permanently||this._schedule_reconnect(2e3),s(new Error(`Lost websocket connection, ${e.code} (${e.reason})`))}_on_error(e){r.logger.debug("Websocket error on socket "+this._number);const s="Could not open websocket";r.logger.error("Failed to connect to Bokeh server: "+s),e(new Error(s))}_close_bad_protocol(e){r.logger.error("Closing connection: "+e),null!=this.socket&&this.socket.close(1002,e)}_awaiting_ack_handler(e,s,n){"ACK"===e.msgtype()?(this._current_handler=e=>this._steady_state_handler(e),this._repull_session_doc(s,n)):this._close_bad_protocol("First message was not an ACK")}_steady_state_handler(e){const s=e.reqid(),n=this._pending_replies.get(s);n?(this._pending_replies.delete(s),n.resolve(e)):this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)}}n.ClientConnection=d,d.__name__="ClientConnection",n.pull_session=function(e,s,n){return new d(e,s,n).connect()}},
function _(e,s,t,r,n){r();const i=e(29);class a{constructor(e,s,t){this.header=e,this.metadata=s,this.content=t,this.buffers=new Map}static assemble(e,s,t){const r=JSON.parse(e),n=JSON.parse(s),i=JSON.parse(t);return new a(r,n,i)}assemble_buffer(e,s){const t=null!=this.header.num_buffers?this.header.num_buffers:0;if(t<=this.buffers.size)throw new Error("too many buffers received, expecting "+t);const{id:r}=JSON.parse(e);this.buffers.set(r,s)}static create(e,s,t={}){const r=a.create_header(e);return new a(r,s,t)}static create_header(e){return{msgid:i.uniqueId(),msgtype:e}}complete(){return null!=this.header&&null!=this.metadata&&null!=this.content&&(null==this.header.num_buffers||this.buffers.size==this.header.num_buffers)}send(e){if((null!=this.header.num_buffers?this.header.num_buffers:0)>0)throw new Error("BokehJS only supports receiving buffers, not sending");const s=JSON.stringify(this.header),t=JSON.stringify(this.metadata),r=JSON.stringify(this.content);e.send(s),e.send(t),e.send(r)}msgid(){return this.header.msgid}msgtype(){return this.header.msgtype}reqid(){return this.header.reqid}problem(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"}}t.Message=a,a.__name__="Message"},
function _(e,t,s,_,r){_();const i=e(391),h=e(8);class a{constructor(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}consume(e){this._current_consumer(e)}_HEADER(e){this._assume_text(e),this.message=null,this._partial=null,this._fragments=[e],this._buf_header=null,this._current_consumer=this._METADATA}_METADATA(e){this._assume_text(e),this._fragments.push(e),this._current_consumer=this._CONTENT}_CONTENT(e){this._assume_text(e),this._fragments.push(e);const[t,s,_]=this._fragments.slice(0,3);this._partial=i.Message.assemble(t,s,_),this._check_complete()}_BUFFER_HEADER(e){this._assume_text(e),this._buf_header=e,this._current_consumer=this._BUFFER_PAYLOAD}_BUFFER_PAYLOAD(e){this._assume_binary(e),this._partial.assemble_buffer(this._buf_header,e),this._check_complete()}_assume_text(e){if(!h.isString(e))throw new Error("Expected text fragment but received binary fragment")}_assume_binary(e){if(!(e instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")}_check_complete(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER}}s.Receiver=a,a.__name__="Receiver"},
function _(e,t,n,s,o){s();const c=e(5),i=e(391),_=e(19);class r{constructor(e,t,n){this._connection=e,this.document=t,this.id=n,this._document_listener=e=>{this._document_changed(e)},this.document.on_change(this._document_listener,!0)}handle(e){const t=e.msgtype();"PATCH-DOC"===t?this._handle_patch(e):"OK"===t?this._handle_ok(e):"ERROR"===t?this._handle_error(e):_.logger.debug("Doing nothing with message "+e.msgtype())}close(){this._connection.close()}_connection_closed(){this.document.remove_on_change(this._document_listener)}async request_server_info(){const e=i.Message.create("SERVER-INFO-REQ",{});return(await this._connection.send_with_reply(e)).content}async force_roundtrip(){await this.request_server_info()}_document_changed(e){if(e.setter_id===this.id)return;const t=e instanceof c.DocumentEventBatch?e.events:[e],n=this.document.create_json_patch(t),s=i.Message.create("PATCH-DOC",{},n);this._connection.send(s)}_handle_patch(e){this.document.apply_json_patch(e.content,e.buffers,this.id)}_handle_ok(e){_.logger.trace("Unhandled OK reply to "+e.reqid())}_handle_error(e){_.logger.error(`Unhandled ERROR reply to ${e.reqid()}: ${e.content.text}`)}}n.ClientSession=r,r.__name__="ClientSession"},
function _(e,o,t,n,r){n();const s=e(1);var i=this&&this.__asyncValues||function(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var o,t=e[Symbol.asyncIterator];return t?t.call(e):(e="function"==typeof __values?__values(e):e[Symbol.iterator](),o={},n("next"),n("throw"),n("return"),o[Symbol.asyncIterator]=function(){return this},o);function n(t){o[t]=e[t]&&function(o){return new Promise((function(n,r){(function(e,o,t,n){Promise.resolve(n).then((function(o){e({value:o,done:t})}),o)})(n,r,(o=e[t](o)).done,o.value)}))}}};const l=e(5),a=e(392),c=e(19),u=e(71),f=e(13),g=e(387),m=e(388),d=s.__importDefault(e(72)),p=s.__importDefault(e(199)),_=s.__importDefault(e(395));function b(e,o){o.buffers.length>0?e.consume(o.buffers[0].buffer):e.consume(o.content.data);const t=e.message;null!=t&&this.apply_json_patch(t.content,t.buffers)}function y(e,o){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){c.logger.info("Registering Jupyter comms for target "+e);const t=Jupyter.notebook.kernel.comm_manager;try{t.register_target(e,t=>{c.logger.info("Registering Jupyter comms for target "+e);const n=new a.Receiver;t.on_msg(b.bind(o,n))})}catch(e){c.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if(o.roots()[0].id in t.kernels){c.logger.info("Registering JupyterLab comms for target "+e);const n=t.kernels[o.roots()[0].id];try{n.registerCommTarget(e,t=>{c.logger.info("Registering JupyterLab comms for target "+e);const n=new a.Receiver;t.onMsg=b.bind(o,n)})}catch(e){c.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if("undefined"!=typeof google&&null!=google.colab.kernel){c.logger.info("Registering Google Colab comms for target "+e);const t=google.colab.kernel.comms;try{t.registerTarget(e,async t=>{var n,r,s;c.logger.info("Registering Google Colab comms for target "+e);const l=new a.Receiver;try{for(var u,f=i(t.messages);!(u=await f.next()).done;){const e=u.value,t={data:e.data},n=[];for(const o of null!==(s=e.buffers)&&void 0!==s?s:[])n.push(new DataView(o));const r={content:t,buffers:n};b.bind(o)(l,r)}}catch(e){n={error:e}}finally{try{u&&!u.done&&(r=f.return)&&await r.call(f)}finally{if(n)throw n.error}}})}catch(e){c.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}u.stylesheet.append(d.default),u.stylesheet.append(p.default),u.stylesheet.append(_.default),t.kernels={},t.embed_items_notebook=function(e,o){if(1!=f.size(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");const t=l.Document.from_json(f.values(e)[0]);for(const e of o){null!=e.notebook_comms_target&&y(e.notebook_comms_target,t);const o=m._resolve_element(e),n=m._resolve_root_elements(e);g.add_document_standalone(t,o,n)}}},
function _(t,e,o,n,r){n();o.default="\n/* notebook specific tweaks so no black outline and matching padding\n/* can't be wrapped inside bk-root. here are the offending jupyter lines:\n/* https://github.com/jupyter/notebook/blob/master/notebook/static/notebook/less/renderedhtml.less#L59-L76 */\n.rendered_html .bk-root .bk-tooltip table,\n.rendered_html .bk-root .bk-tooltip tr,\n.rendered_html .bk-root .bk-tooltip th,\n.rendered_html .bk-root .bk-tooltip td {\n  border: none;\n  padding: 1px;\n}\n"},
function _(t,_,o,r,n){r();const a=t(1);a.__exportStar(t(391),o),a.__exportStar(t(392),o)},
function _(e,t,n,s,o){function l(){const e=document.getElementsByTagName("body")[0],t=document.getElementsByClassName("bokeh-test-div");1==t.length&&(e.removeChild(t[0]),delete t[0]);const n=document.createElement("div");n.classList.add("bokeh-test-div"),n.style.display="none",e.insertBefore(n,e.firstChild)}s(),n.results={},n.init=function(){l()},n.record0=function(e,t){n.results[e]=t},n.record=function(e,t){n.results[e]=t,l()},n.count=function(e){null==n.results[e]&&(n.results[e]=0),n.results[e]+=1,l()}},
function _(e,t,o,n,l){n(),o.safely=function(e,t=!1){try{return e()}catch(e){if(function(e){const t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");const o=document.createElement("span");o.style.backgroundColor="#a94442",o.style.borderRadius="0px 4px 0px 0px",o.style.color="white",o.style.cursor="pointer",o.style.cssFloat="right",o.style.fontSize="0.8em",o.style.margin="-6px -6px 0px 0px",o.style.padding="2px 5px 4px 5px",o.title="close",o.setAttribute("aria-label","close"),o.appendChild(document.createTextNode("x")),o.addEventListener("click",()=>s.removeChild(t));const n=document.createElement("h3");n.style.color="#a94442",n.style.margin="8px 0px 0px 0px",n.style.padding="0px",n.appendChild(document.createTextNode("Bokeh Error"));const l=document.createElement("pre");l.style.whiteSpace="unset",l.style.overflowX="auto",l.appendChild(document.createTextNode(e)),t.appendChild(o),t.appendChild(n),t.appendChild(l);const s=document.getElementsByTagName("body")[0];s.insertBefore(t,s.firstChild)}(e instanceof Error&&e.stack?e.stack:""+e),t)return;throw e}}},
], 0, {"main":0,"tslib":1,"index":2,"version":3,"embed/index":4,"document/index":5,"document/document":6,"base":7,"core/util/types":8,"core/util/array":9,"core/util/math":10,"core/util/assert":11,"core/util/arrayable":12,"core/util/object":13,"core/has_props":14,"core/signaling":15,"core/util/defer":16,"core/util/refs":17,"core/properties":18,"core/logging":19,"core/enums":20,"core/kinds":21,"core/util/color":22,"core/util/svg_colors":23,"core/types":24,"core/util/bitset":25,"core/util/eq":26,"core/settings":27,"core/property_mixins":28,"core/util/string":29,"core/serializer":30,"core/util/pretty":31,"core/util/cloneable":32,"models/index":33,"models/annotations/index":34,"models/annotations/annotation":35,"core/util/projections":36,"models/renderers/renderer":69,"core/view":70,"core/dom":71,"styles/root.css":72,"core/visuals":73,"core/util/svg":74,"core/util/affine":75,"models/canvas/canvas":76,"core/dom_view":77,"core/ui_events":78,"core/bokeh_events":80,"core/util/wheel":81,"core/util/compat":82,"core/util/menus":83,"core/util/iterator":84,"styles/menus":85,"core/util/bbox":86,"core/util/canvas":87,"model":88,"models/canvas/coordinates":89,"models/annotations/arrow":90,"models/annotations/arrow_head":91,"models/sources/columnar_data_source":92,"models/sources/data_source":93,"models/selections/selection":94,"models/glyphs/glyph":95,"core/util/ragged_array":96,"core/util/spatial":97,"models/ranges/factor_range":100,"models/ranges/range":101,"core/selection_manager":102,"models/renderers/glyph_renderer":103,"models/renderers/data_renderer":104,"models/glyphs/line":105,"models/glyphs/xy_glyph":106,"models/glyphs/utils":107,"core/hittest":108,"models/glyphs/webgl/line":109,"models/glyphs/webgl/utils/index":110,"models/glyphs/webgl/utils/program":111,"models/glyphs/webgl/utils/buffer":112,"models/glyphs/webgl/utils/texture":113,"models/glyphs/webgl/base":114,"models/glyphs/webgl/line.vert":115,"models/glyphs/webgl/line.frag":116,"models/glyphs/patch":117,"models/glyphs/harea":118,"models/glyphs/area":119,"models/glyphs/varea":120,"models/sources/cds_view":121,"models/filters/filter":122,"core/build_views":123,"models/renderers/graph_renderer":124,"models/graphs/layout_provider":125,"models/graphs/graph_hit_test_policy":126,"models/glyphs/multi_line":127,"models/glyphs/patches":128,"models/selections/interaction_policy":129,"models/sources/column_data_source":130,"core/util/typed_array":131,"core/util/set":132,"document/events":133,"models/annotations/band":134,"models/annotations/upper_lower":135,"models/annotations/box_annotation":136,"models/annotations/color_bar":137,"models/tickers/continuous_ticker":138,"models/tickers/ticker":139,"models/formatters/tick_formatter":140,"models/tickers/basic_ticker":141,"models/tickers/adaptive_ticker":142,"models/formatters/basic_tick_formatter":143,"models/mappers/continuous_color_mapper":144,"models/mappers/color_mapper":145,"models/mappers/mapper":146,"models/transforms/transform":147,"models/mappers/index":148,"models/mappers/categorical_color_mapper":149,"models/mappers/categorical_mapper":150,"models/mappers/categorical_marker_mapper":151,"models/mappers/categorical_pattern_mapper":152,"models/mappers/linear_color_mapper":153,"models/mappers/log_color_mapper":154,"models/mappers/scanning_color_mapper":155,"models/mappers/eqhist_color_mapper":156,"models/scales/linear_scale":157,"models/scales/continuous_scale":158,"models/scales/scale":159,"models/transforms/index":160,"models/transforms/customjs_transform":161,"models/transforms/dodge":162,"models/transforms/range_transform":163,"models/transforms/interpolator":164,"models/transforms/jitter":165,"models/transforms/linear_interpolator":166,"models/transforms/step_interpolator":167,"models/ranges/range1d":168,"models/scales/linear_interpolation_scale":169,"models/scales/log_scale":170,"core/util/text":171,"models/annotations/label":172,"models/annotations/text_annotation":173,"models/annotations/label_set":174,"models/annotations/legend":175,"models/annotations/legend_item":176,"core/vectorization":177,"models/annotations/poly_annotation":178,"models/annotations/slope":179,"models/annotations/span":180,"models/annotations/title":181,"models/annotations/toolbar_panel":182,"models/tools/toolbar":183,"models/tools/tool":184,"models/tools/gestures/gesture_tool":185,"models/tools/button_tool":186,"styles/toolbar":187,"styles/toolbar.css":188,"styles/icons.css":189,"styles/menus.css":190,"models/tools/on_off_button":191,"styles/mixins":192,"models/tools/inspectors/inspect_tool":193,"models/tools/toolbar_base":194,"models/tools/actions/action_tool":195,"models/tools/actions/help_tool":196,"styles/icons":197,"styles/logo":198,"styles/logo.css":199,"models/annotations/tooltip":200,"styles/tooltips":201,"styles/tooltips.css":202,"models/annotations/whisker":203,"models/axes/index":204,"models/axes/axis":205,"models/renderers/guide_renderer":206,"models/axes/categorical_axis":207,"models/tickers/categorical_ticker":208,"models/formatters/categorical_tick_formatter":209,"models/axes/continuous_axis":210,"models/axes/datetime_axis":211,"models/axes/linear_axis":212,"models/formatters/datetime_tick_formatter":213,"core/util/templating":215,"models/tickers/datetime_ticker":218,"models/tickers/composite_ticker":219,"models/tickers/days_ticker":220,"models/tickers/single_interval_ticker":221,"models/tickers/util":222,"models/tickers/months_ticker":223,"models/tickers/years_ticker":224,"models/axes/log_axis":225,"models/formatters/log_tick_formatter":226,"models/tickers/log_ticker":227,"models/axes/mercator_axis":228,"models/formatters/mercator_tick_formatter":229,"models/tickers/mercator_ticker":230,"models/callbacks/index":231,"models/callbacks/customjs":232,"models/callbacks/callback":233,"models/callbacks/open_url":234,"models/canvas/index":235,"models/canvas/cartesian_frame":236,"models/scales/categorical_scale":237,"models/ranges/data_range1d":238,"models/ranges/data_range":239,"models/util":240,"core/layout/index":241,"core/layout/types":242,"core/layout/layoutable":243,"core/layout/alignments":244,"core/layout/grid":245,"core/layout/html":246,"models/expressions/index":247,"models/expressions/expression":248,"models/expressions/stack":249,"models/expressions/cumsum":250,"models/filters/index":251,"models/filters/boolean_filter":252,"models/filters/customjs_filter":253,"models/filters/group_filter":254,"models/filters/index_filter":255,"models/formatters/index":256,"models/formatters/func_tick_formatter":257,"models/formatters/numeral_tick_formatter":258,"models/formatters/printf_tick_formatter":259,"models/glyphs/index":260,"models/glyphs/annular_wedge":261,"models/glyphs/annulus":262,"models/glyphs/arc":263,"models/glyphs/bezier":264,"models/glyphs/circle":265,"models/glyphs/webgl/markers":266,"models/glyphs/webgl/markers.vert":267,"models/glyphs/webgl/markers.frag":268,"models/glyphs/center_rotatable":269,"models/glyphs/ellipse":270,"models/glyphs/ellipse_oval":271,"models/glyphs/hbar":272,"models/glyphs/box":273,"models/glyphs/hex_tile":274,"models/glyphs/image":275,"models/glyphs/image_base":276,"core/util/ndarray":277,"core/util/serialization":278,"models/glyphs/image_rgba":279,"models/glyphs/image_url":280,"core/util/image":281,"models/glyphs/multi_polygons":282,"models/glyphs/oval":283,"models/glyphs/quad":284,"models/glyphs/quadratic":285,"models/glyphs/ray":286,"models/glyphs/rect":287,"models/glyphs/segment":288,"models/glyphs/step":289,"models/glyphs/text":290,"models/glyphs/vbar":291,"models/glyphs/wedge":292,"models/graphs/index":293,"models/graphs/static_layout_provider":294,"models/grids/index":295,"models/grids/grid":296,"models/layouts/index":297,"models/layouts/box":298,"models/layouts/layout_dom":299,"styles/root":300,"models/layouts/column":301,"models/layouts/grid_box":302,"models/layouts/html_box":303,"models/layouts/panel":304,"models/layouts/row":305,"models/layouts/spacer":306,"models/layouts/tabs":307,"styles/tabs":308,"styles/buttons":309,"styles/buttons.css":310,"styles/tabs.css":311,"models/layouts/widget_box":312,"models/markers/index":313,"models/markers/defs":314,"models/markers/marker":315,"models/markers/scatter":316,"models/plots/index":317,"models/plots/gmap_plot":318,"models/plots/plot":319,"models/plots/plot_canvas":320,"core/util/throttle":321,"core/layout/border":322,"core/layout/side_panel":323,"models/plots/range_manager":324,"models/plots/state_manager":325,"models/plots/gmap_plot_canvas":326,"models/ranges/index":327,"models/renderers/index":328,"models/scales/index":329,"models/selections/index":330,"models/sources/index":331,"models/sources/server_sent_data_source":332,"models/sources/web_data_source":333,"models/sources/ajax_data_source":334,"models/sources/geojson_data_source":335,"models/tickers/index":336,"models/tickers/fixed_ticker":337,"models/tiles/index":338,"models/tiles/bbox_tile_source":339,"models/tiles/mercator_tile_source":340,"models/tiles/tile_source":341,"models/tiles/tile_utils":342,"models/tiles/quadkey_tile_source":343,"models/tiles/tile_renderer":344,"models/tiles/wmts_tile_source":345,"styles/tiles":346,"styles/tiles.css":347,"models/tiles/tms_tile_source":348,"models/textures/index":349,"models/textures/canvas_texture":350,"models/textures/texture":351,"models/textures/image_url_texture":352,"models/tools/index":353,"models/tools/actions/custom_action":354,"models/tools/actions/redo_tool":355,"models/tools/actions/reset_tool":356,"models/tools/actions/save_tool":357,"models/tools/actions/undo_tool":358,"models/tools/actions/zoom_in_tool":359,"models/tools/actions/zoom_base_tool":360,"core/util/zoom":361,"models/tools/actions/zoom_out_tool":362,"models/tools/edit/edit_tool":363,"models/tools/edit/box_edit_tool":364,"models/tools/edit/freehand_draw_tool":365,"models/tools/edit/point_draw_tool":366,"models/tools/edit/poly_draw_tool":367,"models/tools/edit/poly_tool":368,"models/tools/edit/poly_edit_tool":369,"models/tools/gestures/box_select_tool":370,"models/tools/gestures/select_tool":371,"models/tools/gestures/box_zoom_tool":372,"models/tools/gestures/lasso_select_tool":373,"models/tools/gestures/poly_select_tool":374,"models/tools/edit/line_edit_tool":375,"models/tools/edit/line_tool":376,"models/tools/gestures/pan_tool":377,"models/tools/gestures/range_tool":378,"models/tools/gestures/tap_tool":379,"models/tools/gestures/wheel_pan_tool":380,"models/tools/gestures/wheel_zoom_tool":381,"models/tools/inspectors/crosshair_tool":382,"models/tools/inspectors/customjs_hover":383,"models/tools/inspectors/hover_tool":384,"models/tools/tool_proxy":385,"models/tools/toolbar_box":386,"embed/standalone":387,"embed/dom":388,"embed/server":389,"client/connection":390,"protocol/message":391,"protocol/receiver":392,"client/session":393,"embed/notebook":394,"styles/notebook.css":395,"protocol/index":396,"testing":397,"safely":398}, {});
})

