import { Model } from "../../model";
import { View } from "../../core/view";
import * as visuals from "../../core/visuals";
import { LineVector, FillVector } from "../../core/property_mixins";
import * as p from "../../core/properties";
import { Context2d } from "../../core/util/canvas";
export declare abstract class ArrowHeadView extends View {
    model: ArrowHead;
    visuals: ArrowHead.Visuals;
    initialize(): void;
    abstract render(ctx: Context2d, i: number): void;
    abstract clip(ctx: Context2d, i: number): void;
}
export declare namespace ArrowHead {
    type Attrs = p.AttrsOf<Props>;
    type Props = Model.Props & {
        size: p.Property<number>;
    };
    type Visuals = visuals.Visuals;
}
export interface ArrowHead extends ArrowHead.Attrs {
}
export declare abstract class ArrowHead extends Model {
    properties: ArrowHead.Props;
    __view_type__: ArrowHeadView;
    constructor(attrs?: Partial<ArrowHead.Attrs>);
    static init_ArrowHead(): void;
}
export declare class OpenHeadView extends ArrowHeadView {
    model: OpenHead;
    visuals: OpenHead.Visuals;
    clip(ctx: Context2d, i: number): void;
    render(ctx: Context2d, i: number): void;
}
export declare namespace OpenHead {
    type Attrs = p.AttrsOf<Props>;
    type Props = ArrowHead.Props & Mixins;
    type Mixins = LineVector;
    type Visuals = ArrowHead.Visuals & {
        line: visuals.Line;
    };
}
export interface OpenHead extends OpenHead.Attrs {
}
export declare class OpenHead extends ArrowHead {
    properties: OpenHead.Props;
    __view_type__: OpenHeadView;
    constructor(attrs?: Partial<OpenHead.Attrs>);
    static init_OpenHead(): void;
}
export declare class NormalHeadView extends ArrowHeadView {
    model: NormalHead;
    visuals: NormalHead.Visuals;
    clip(ctx: Context2d, i: number): void;
    render(ctx: Context2d, i: number): void;
    protected _normal(ctx: Context2d, _i: number): void;
}
export declare namespace NormalHead {
    type Attrs = p.AttrsOf<Props>;
    type Props = ArrowHead.Props & Mixins;
    type Mixins = LineVector & FillVector;
    type Visuals = ArrowHead.Visuals & {
        line: visuals.Line;
        fill: visuals.Fill;
    };
}
export interface NormalHead extends NormalHead.Attrs {
}
export declare class NormalHead extends ArrowHead {
    properties: NormalHead.Props;
    __view_type__: NormalHeadView;
    constructor(attrs?: Partial<NormalHead.Attrs>);
    static init_NormalHead(): void;
}
export declare class VeeHeadView extends ArrowHeadView {
    model: VeeHead;
    visuals: VeeHead.Visuals;
    clip(ctx: Context2d, i: number): void;
    render(ctx: Context2d, i: number): void;
    protected _vee(ctx: Context2d, _i: number): void;
}
export declare namespace VeeHead {
    type Attrs = p.AttrsOf<Props>;
    type Props = ArrowHead.Props & Mixins;
    type Mixins = LineVector & FillVector;
    type Visuals = ArrowHead.Visuals & {
        line: visuals.Line;
        fill: visuals.Fill;
    };
}
export interface VeeHead extends VeeHead.Attrs {
}
export declare class VeeHead extends ArrowHead {
    properties: VeeHead.Props;
    __view_type__: VeeHeadView;
    constructor(attrs?: Partial<VeeHead.Attrs>);
    static init_VeeHead(): void;
}
export declare class TeeHeadView extends ArrowHeadView {
    model: TeeHead;
    visuals: TeeHead.Visuals;
    render(ctx: Context2d, i: number): void;
    clip(_ctx: Context2d, _i: number): void;
}
export declare namespace TeeHead {
    type Attrs = p.AttrsOf<Props>;
    type Props = ArrowHead.Props & Mixins;
    type Mixins = LineVector;
    type Visuals = ArrowHead.Visuals & {
        line: visuals.Line;
    };
}
export interface TeeHead extends TeeHead.Attrs {
}
export declare class TeeHead extends ArrowHead {
    properties: TeeHead.Props;
    __view_type__: TeeHeadView;
    constructor(attrs?: Partial<TeeHead.Attrs>);
    static init_TeeHead(): void;
}
//# sourceMappingURL=arrow_head.d.ts.map