# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ampel',
 'ampel.abstract',
 'ampel.abstract.ingest',
 'ampel.aux',
 'ampel.aux.filter',
 'ampel.config',
 'ampel.config.builder',
 'ampel.config.collector',
 'ampel.core',
 'ampel.db',
 'ampel.db.query',
 'ampel.demo.unit.base',
 'ampel.dev',
 'ampel.ingest',
 'ampel.ingest.compile',
 'ampel.log',
 'ampel.log.handlers',
 'ampel.metrics',
 'ampel.model',
 'ampel.model.aux',
 'ampel.model.builder',
 'ampel.model.db',
 'ampel.model.ingest',
 'ampel.model.operator',
 'ampel.model.purge',
 'ampel.model.t3',
 'ampel.model.template',
 'ampel.model.time',
 'ampel.plot',
 'ampel.run',
 'ampel.t2',
 'ampel.t3',
 'ampel.t3.complement',
 'ampel.t3.context',
 'ampel.t3.load',
 'ampel.t3.run',
 'ampel.t3.run.filter',
 'ampel.t3.run.project',
 'ampel.t3.select',
 'ampel.test',
 'ampel.util',
 'ampel.vendor.aiopipe']

package_data = \
{'': ['*'], 'ampel': ['t0/*', 't1/*'], 'ampel.test': ['test-data/*']}

install_requires = \
['PyYAML>=5.4.1,<6.0.0',
 'ampel-interface>=0.7.1-alpha.7,<0.8.0',
 'prometheus-client>=0.9.0,<0.10.0',
 'psutil>=5.8.0,<6.0.0',
 'pydantic>=1.4,<1.5',
 'pymongo>=3.10,<4.0',
 'schedule>=1.0.0,<2.0.0',
 'sjcl>=0.2.1,<0.3.0',
 'slackclient>=2.7,<3.0',
 'yq>=2.12.0,<3.0.0']

extras_require = \
{':extra == "docs"': ['tomlkit>=0.7.0,<0.8.0'],
 'docs': ['Sphinx>=3.5.1,<4.0.0',
          'sphinx-press-theme>=0.5.1,<0.6.0',
          'sphinx-autodoc-typehints>=1.11.1,<2.0.0'],
 'server': ['fastapi>=0.63.0,<0.64.0', 'uvicorn[standard]>=0.13.3,<0.14.0']}

entry_points = \
{'console_scripts': ['ampel-config = ampel.config.cli:main',
                     'ampel-controller = '
                     'ampel.core.AmpelController:AmpelController.main',
                     'ampel-db = ampel.db.AmpelDB:main']}

setup_kwargs = {
    'name': 'ampel-core',
    'version': '0.7.1a1',
    'description': 'Asynchronous and Modular Platform with Execution Layers',
    'long_description': '<img align="left" src="https://desycloud.desy.de/index.php/s/99Jkcyzn92rRpHF/preview" width="150" height="150"/>\n<br>\n\n# AMPEL-core\n<br><br>\n\n# Introduction\n\nAMPEL is a _modular_ and _scalable_ platform with explicit _provenance_ tracking, suited for systematically processing large - possibly complex and heterogeneous - datasets in real-time or not. This includes selecting, analyzing, updating, combining, enriching and reacting to data.\n\nThe framework requires analysis and reaction logic to be broken down in adequate indepentent units.\nAMPEL is general enough to be applicable in various fields,\nit was originaly developped to solve challenges in the context of experimental astrophysics.\n\nAMPEL is written in Python 3.8 and its codebase is fully typed.\n \n\n# Architecture\n\n## Tiers\nAMPEL is made of four execution layers (tiers) that replace a traditional pipeline architecture.\n<img align="left" src="https://desycloud.desy.de/index.php/s/fz2mnsH4MGEKwfD/preview"/>\n\nThe tiers are independently scheduled and the information exchange between tiers occurs via a dedicated database.\nThe execution layer architecture along with the database structure allow for simple parallelization.\n\n## Units\nEach tier is modular and executes so-called "units".\n\n<p align="center">\n<img src="https://desycloud.desy.de/index.php/s/P76f9qSWJse8oT7/preview" width=50%/>\n</p>\n\nAmpel _base units_ have standardized inputs and ouputs, enforced through abstract classes which units inherit.\n\n## Processes\n\nEvery change in AMPEL is triggered by a _process_.\nA process executes, at a given date and time, a _processor unit_ that itself runs one or multiple _base units_ with specific configurations.\nInformation about process executions are registred into the database.\nThe majority of processes are associated with a specific tier but general processes are possible.\n\nA working AMPEL system will spawn multiple processes, posssibly concurently, accross the four AMPEL tiers.\nThis will result in the ingestion and analysis of data and the triggering of automated reactions when given data states are detected.\n\n## Channels\n\n_Channels_ are convenient for multi-user or multi-prupose AMPEL systems.\nThey allow to define and enforce access rights and to privatize processes,\nmeaning that the output generated by the processes will be only accessible to processes\nbelonging to the same channel.\n\nInternally, _channels_ are just tags in database documents and ampel configuration files.  \nFrom a user perspective, a channel can be seen as a collection of private processes.\n\n<p align="center">\n<img src="https://desycloud.desy.de/index.php/s/YMiGJ2zckgEr54n/preview" width=50%/>\n<br/>\nProcesses associated with a given channel\n</p>\n\nNote that within AMPEL, different _channels_ requiring the same computation\nwill not result in the required computation being performed twice.\n\n\n# Repositories\n\nThe AMPEL code is partitioned in different repositories.  \nThe only mandatory repository in this list is _ampel-interface_\n\nPublic abstract class definitions:  \nhttps://github.com/AmpelProject/Ampel-interface\n\nSpecialized classes for Tier 0, capable of handling _alerts_:  \nhttps://github.com/AmpelProject/Ampel-alerts\n\nAn add-on that introduces two generic classes of datapoints:  \nhttps://github.com/AmpelProject/Ampel-photometry\n\nExample of an instrument specific implementation:  \nhttps://github.com/AmpelProject/Ampel-ztf\n\nNumerous _base units_, the majority being specific to astronomy:  \nhttps://github.com/AmpelProject/Ampel-contrib-HU/\n\n\n# Database\n\nMongoDB is used to store data.\nThe collections have been designed and indexed for fast insertion and query.\nUsers do not interact with the database directly.\nInformation exchange is instead regulated through (python) abstract base classes from which units are constructed.\nA specific set of internal classes handle database input and output.\n\n\n# Containers\n\nAll AMPEL software, can be combined into one container that defines an instance.\nThese containers can be used both to process real-time data as well as to reprocess archived data.\nThe containers themselves should be archived as well.\n\n<!--\nAstronomers have during the past century continuously refined tools for\nanalyzing individual astronomical transients. Simultaneously, progress in instrument and CCD\nmanufacturing as well as new data processing capabilities have led to a new generation of transient\nsurveys that can repeatedly scan large volumes of the Universe. With thousands of potential candidates\navailable, scientists are faced with a new kind of questions: Which transient should I focus on?\nWhat were those things that I dit not look at? Can I have them all?\n\nAmpel is a software framework meant to assist in answering such questions.\nIn short, Ampel assists in the the transition from studies of individual objects\n(based on more or less random selection) to systematically selected samples.\nOur design goals are to find a system where past experience (i.e. existing algorithms and code) can consistently be applied to large samples, and with built-in tools for controlling sample selection.\n-->\n\n# Installing Ampel\n\nSee `<https://ampelproject.github.io/Ampel-core/installing.html>`_.\n\n# Development\n\n`ampel-core` uses [poetry](http://poetry.eustace.io/) for dependency management and packaging. To work with an editable install it\'s recommended that you setup `poetry` and install `ampel-core` in a virtual environment by doing\n\n```console\npoetry install\n```\n\nPip does not support editable installs with PEP-517 yet. That means that running `pip install -e .` will fail because `poetry` doesn\'t use a `setup.py` file. As a workaround, you can use provided [create_setup.py](./create_setup.py) script to generate a temporary `setup.py`. To install `ampel-core` in editable mode without `poetry`, do\n\n```console\npip install poetry\npython create_setup.py\npip install -e .\n```\n',
    'author': 'Valery Brinnel',
    'author_email': None,
    'maintainer': 'Jakob van Santen',
    'maintainer_email': 'jakob.van.santen@desy.de',
    'url': 'https://ampelproject.github.io',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
