import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::Cloud9::EnvironmentEC2`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 */
export interface CfnEnvironmentEC2Props {
    /**
     * `AWS::Cloud9::EnvironmentEC2.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.AutomaticStopTimeMinutes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-automaticstoptimeminutes
     */
    readonly automaticStopTimeMinutes?: number;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-description
     */
    readonly description?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-name
     */
    readonly name?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.OwnerArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-ownerarn
     */
    readonly ownerArn?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Repositories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-repositories
     */
    readonly repositories?: Array<CfnEnvironmentEC2.RepositoryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Cloud9::EnvironmentEC2.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-subnetid
     */
    readonly subnetId?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Cloud9::EnvironmentEC2`
 *
 * @cloudformationResource AWS::Cloud9::EnvironmentEC2
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 */
export declare class CfnEnvironmentEC2 extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cloud9::EnvironmentEC2";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-instancetype
     */
    instanceType: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.AutomaticStopTimeMinutes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-automaticstoptimeminutes
     */
    automaticStopTimeMinutes: number | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-description
     */
    description: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-name
     */
    name: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.OwnerArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-ownerarn
     */
    ownerArn: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Repositories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-repositories
     */
    repositories: Array<CfnEnvironmentEC2.RepositoryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-subnetid
     */
    subnetId: string | undefined;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Cloud9::EnvironmentEC2`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEnvironmentEC2Props);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEnvironmentEC2 {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html
     */
    interface RepositoryProperty {
        /**
         * `CfnEnvironmentEC2.RepositoryProperty.PathComponent`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
         */
        readonly pathComponent: string;
        /**
         * `CfnEnvironmentEC2.RepositoryProperty.RepositoryUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
         */
        readonly repositoryUrl: string;
    }
}
