import gzip
import os
from io import BytesIO

from cameo_claw.cameo_claw_reuse import bytesio_to_gzip, requests_get_write, \
    pl_read_csv_distinct, groupby_write_gzip, it_lst_url_f, condition_filter_sort, distinct_filter_sort, \
    bytesio_filename, write_gzip
import polars as pl

from cameo_claw.file import mkdir
from cameo_claw.functional import it_mp_f


def a_download(url, target_directory):
    def write(bytes1):
        filename = os.path.basename(url)
        path = f'{target_directory}{filename}'
        with open(path, 'wb') as f:
            f.write(bytes1)
        return url

    return requests_get_write(write, target_directory, url)


def it_download(lst_url, target_directory):
    return it_mp_f(a_download, [tuple([url, target_directory]) for url in lst_url])


def a_distinct(url, target_directory, lst_distinct_column):
    def write(bytes1):
        df = pl_read_csv_distinct(bytes1, lst_distinct_column)
        return bytesio_to_gzip(df, url, target_directory)

    return requests_get_write(write, target_directory, url)


def it_distinct(lst_url, target_directory, lst_distinct_column):
    return it_mp_f(a_distinct, [tuple([url, target_directory, lst_distinct_column]) for url in lst_url])


def a_group(url, target_directory, lst_distinct_column, lst_group_by_column):
    def write(bytes1):
        df = pl_read_csv_distinct(bytes1, lst_distinct_column)
        return groupby_write_gzip(df, url, lst_group_by_column, target_directory)

    return requests_get_write(write, target_directory, url)


def it_group(lst_url, target_directory, lst_distinct_column, lst_group_by_column):
    return it_mp_f(a_group,
                   [tuple([url, target_directory, lst_distinct_column, lst_group_by_column]) for url in lst_url])


def a_filter(url, target_directory, lst_distinct_column, lst_column_match=[], sort_column=''):
    def write(bytes1):
        df = distinct_filter_sort(bytes1, lst_distinct_column, lst_column_match, sort_column)
        bytesio_to_gzip(df, url, target_directory)
        return url

    return requests_get_write(write, target_directory, url)


def it_filter(lst_url, target_directory, lst_distinct_column, lst_column_match, sort_column):
    return it_lst_url_f(a_filter, lst_url, target_directory, lst_distinct_column, lst_column_match, sort_column)


def a_chunk_pl_lst(url, target_directory, lst_distinct_column, lst_column_match, sort_column):
    tup_distinct_column = tuple(lst_distinct_column)
    tup_lst_column_match = tuple([tuple(l) for l in lst_column_match])
    return a_chunk_pl_tup(url, target_directory, tup_distinct_column, tup_lst_column_match, sort_column)


from functools import lru_cache


@lru_cache(maxsize=5000)
def a_chunk_pl_tup(url, target_directory, tup_distinct_column, tup_column_match, sort_column):
    def write(bytes1):
        df = pl.read_csv(bytes1)
        df = df.distinct(subset=list(tup_distinct_column))
        df = condition_filter_sort(df, tup_column_match, sort_column)
        bytesio_csv = BytesIO()
        df.to_csv(bytesio_csv, has_header=False)
        bytesio_gzip = BytesIO()
        with gzip.open(bytesio_gzip, 'wb') as f:
            f.write(bytesio_csv.getvalue())
        return bytesio_gzip.getvalue()

    return requests_get_write(write, target_directory, url)


def it_chunk_pl(lst_url, target_directory, lst_distinct_column, lst_column_match, sort_column):
    return it_lst_url_f(a_chunk_pl_lst, lst_url, target_directory, lst_distinct_column, lst_column_match, sort_column)


def a_filter_group(url, target_directory, lst_distinct_column, lst_column_match=[], sort_column='',
                   lst_group_by_column=[]):
    def write(bytes1):
        df = distinct_filter_sort(bytes1, lst_distinct_column, lst_column_match, sort_column)
        return groupby_write_gzip(df, url, lst_group_by_column, target_directory)

    return requests_get_write(write, target_directory, url)


def it_filter_group(lst_url, target_directory, lst_distinct_column,
                    lst_column_match, sort_column, lst_group_by_column):
    return it_mp_f(a_filter_group,
                   [tuple([url, target_directory, lst_distinct_column,
                           lst_column_match, sort_column, lst_group_by_column]) for url in lst_url])


def a_filter_group_mean_count(url, target_directory, lst_distinct_column,
                              lst_column_match, sort_column, lst_group_by_column,
                              time_column, value_column):
    def write(bytes1):
        df = distinct_filter_sort(bytes1, lst_distinct_column, lst_column_match, sort_column)
        g = df.groupby(lst_group_by_column)
        mkdir(target_directory)
        for df in g:
            filename_tail = '_group_' + '-'.join(list(
                map(lambda column:
                    str(df.row(0)[df.find_idx_by_name(column)]).replace('_', '-'),
                    lst_group_by_column)))
            bytesio, filename = bytesio_filename(df, url)
            path = f'{target_directory}{filename}{filename_tail}.csv.gz'
            write_gzip(bytesio, path)

            # mean daily
            # df_mean_daily = df.groupby(lst_group_by_column).agg([pl.col(value_column).mean()])
            df_mean_daily = (
                df.lazy()
                    .groupby(lst_group_by_column)
                    .agg(
                    [
                        pl.first('localTime'),
                        pl.col(value_column).mean(),
                    ]
                )
            ).collect()
            bytesio, filename = bytesio_filename(df_mean_daily, url)
            path = f'{target_directory}{filename}{filename_tail}_mean_daily.csv.gz'
            write_gzip(bytesio, path)

            # path= f'{target_directory}{filename}{filename_tail}_mean_hourly.csv.gz'
            # path= f'{target_directory}{filename}{filename_tail}_count_daily.csv.gz'

    return requests_get_write(write, target_directory, url)


def it_filter_group_mean_count(lst_url, target_directory, lst_distinct_column,
                               lst_column_match, sort_column, lst_group_by_column,
                               time_column, value_column):
    return it_mp_f(a_filter_group_mean_count,
                   [tuple([url, target_directory, lst_distinct_column,
                           lst_column_match, sort_column, lst_group_by_column,
                           time_column, value_column]) for url in lst_url])
