import * as iam from '@aws-cdk/aws-iam';
import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * Interface which all EventBus based classes MUST implement.
 *
 * @stability stable
 */
export interface IEventBus extends IResource {
    /**
     * The physical ID of this event bus resource.
     *
     * @stability stable
     * @attribute true
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     */
    readonly eventBusName: string;
    /**
     * The ARN of this event bus resource.
     *
     * @stability stable
     * @attribute true
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Arn-fn::getatt
     */
    readonly eventBusArn: string;
    /**
     * The JSON policy of this event bus resource.
     *
     * @stability stable
     * @attribute true
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Policy-fn::getatt
     */
    readonly eventBusPolicy: string;
    /**
     * The partner event source to associate with this event bus resource.
     *
     * @stability stable
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     */
    readonly eventSourceName?: string;
}
/**
 * Properties to define an event bus.
 *
 * @stability stable
 */
export interface EventBusProps {
    /**
     * The name of the event bus you are creating Note: If 'eventSourceName' is passed in, you cannot set this.
     *
     * @default - automatically generated name
     * @stability stable
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     */
    readonly eventBusName?: string;
    /**
     * The partner event source to associate with this event bus resource Note: If 'eventBusName' is passed in, you cannot set this.
     *
     * @default - no partner event source
     * @stability stable
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     */
    readonly eventSourceName?: string;
}
/**
 * Interface with properties necessary to import a reusable EventBus.
 *
 * @stability stable
 */
export interface EventBusAttributes {
    /**
     * The physical ID of this event bus resource.
     *
     * @stability stable
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     */
    readonly eventBusName: string;
    /**
     * The ARN of this event bus resource.
     *
     * @stability stable
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Arn-fn::getatt
     */
    readonly eventBusArn: string;
    /**
     * The JSON policy of this event bus resource.
     *
     * @stability stable
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Policy-fn::getatt
     */
    readonly eventBusPolicy: string;
    /**
     * The partner event source to associate with this event bus resource.
     *
     * @default - no partner event source
     * @stability stable
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     */
    readonly eventSourceName?: string;
}
/**
 * Define an EventBridge EventBus.
 *
 * @stability stable
 * @resource AWS::Events::EventBus
 */
export declare class EventBus extends Resource implements IEventBus {
    /**
     * Import an existing event bus resource.
     *
     * @param scope Parent construct.
     * @param id Construct ID.
     * @param eventBusArn ARN of imported event bus.
     * @stability stable
     */
    static fromEventBusArn(scope: Construct, id: string, eventBusArn: string): IEventBus;
    /**
     * Import an existing event bus resource.
     *
     * @param scope Parent construct.
     * @param id Construct ID.
     * @param attrs Imported event bus properties.
     * @stability stable
     */
    static fromEventBusAttributes(scope: Construct, id: string, attrs: EventBusAttributes): IEventBus;
    /**
     * Permits an IAM Principal to send custom events to EventBridge so that they can be matched to rules.
     *
     * @param grantee The principal (no-op if undefined).
     * @stability stable
     */
    static grantPutEvents(grantee: iam.IGrantable): iam.Grant;
    private static eventBusProps;
    /**
     * The physical ID of this event bus resource.
     *
     * @stability stable
     */
    readonly eventBusName: string;
    /**
     * The ARN of the event bus, such as: arn:aws:events:us-east-2:123456789012:event-bus/aws.partner/PartnerName/acct1/repo1.
     *
     * @stability stable
     */
    readonly eventBusArn: string;
    /**
     * The policy for the event bus in JSON form.
     *
     * @stability stable
     */
    readonly eventBusPolicy: string;
    /**
     * The name of the partner event source.
     *
     * @stability stable
     */
    readonly eventSourceName?: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: EventBusProps);
}
