"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeEventPattern = void 0;
/**
 * Merge the `src` event pattern into the `dest` event pattern by adding all
 * values from `src` into the fields in `dest`.
 *
 * See `rule.addEventPattern` for details.
 */
function mergeEventPattern(dest, src) {
    dest = dest || {};
    mergeObject(dest, src);
    return dest;
    function mergeObject(destObj, srcObj) {
        if (typeof (srcObj) !== 'object') {
            throw new Error(`Invalid event pattern '${JSON.stringify(srcObj)}', expecting an object or an array`);
        }
        for (const field of Object.keys(srcObj)) {
            const srcValue = srcObj[field];
            const destValue = destObj[field];
            if (srcValue === undefined) {
                continue;
            }
            if (typeof (srcValue) !== 'object') {
                throw new Error(`Invalid event pattern field { ${field}: ${JSON.stringify(srcValue)} }. All fields must be arrays`);
            }
            // dest doesn't have this field
            if (destObj[field] === undefined) {
                destObj[field] = srcValue;
                continue;
            }
            if (Array.isArray(srcValue) !== Array.isArray(destValue)) {
                throw new Error(`Invalid event pattern field ${field}. ` +
                    `Type mismatch between existing pattern ${JSON.stringify(destValue)} and added pattern ${JSON.stringify(srcValue)}`);
            }
            // if this is an array, concat and deduplicate the values
            if (Array.isArray(srcValue)) {
                const result = [...destValue, ...srcValue];
                const resultJson = result.map(i => JSON.stringify(i));
                destObj[field] = result.filter((value, index) => resultJson.indexOf(JSON.stringify(value)) === index);
                continue;
            }
            // otherwise, it's an object, so recurse
            mergeObject(destObj[field], srcValue);
        }
    }
}
exports.mergeEventPattern = mergeEventPattern;
//# sourceMappingURL=data:application/json;base64,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