"""
>>> add zip codes <<<

TroveFM is an online store and headless CMS.

Copyright (C) 2022  Brian Farrell

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

Contact: brian.farrell@me.com


Revision ID: 8c3423000743
Revises: f989260ff4b2
Create Date: 2022-04-25 16:02:34.352210
"""


import os
from typing import Tuple

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects.postgresql import DOUBLE_PRECISION
from sqlalchemy.sql import table

# revision identifiers, used by Alembic
revision = '8c3423000743'
down_revision = 'f989260ff4b2'
branch_labels = None
depends_on = None


zip_lookup = table(
    'zip_lookup',
    sa.Column("country_code", sa.VARCHAR(2)),
    sa.Column("zip_code", sa.VARCHAR(5), unique=True),
    sa.Column("place_name", sa.VARCHAR(180)),
    sa.Column("state", sa.VARCHAR(100)),
    sa.Column("state_ab", sa.VARCHAR(2)),
    sa.Column("county", sa.VARCHAR(50)),
    sa.Column("locality_code", sa.VARCHAR(5)),
    sa.Column("latitude", DOUBLE_PRECISION(asdecimal=True)),
    sa.Column("longitude", DOUBLE_PRECISION(asdecimal=True)),
    sa.Column("accuracy", sa.Integer)
)


def add_zip_code_test_data():
    op.bulk_insert(
        zip_lookup,
        [
            {'country_code': 'US', 'zip_code': '14610', 'place_name': 'Rochester', 'state': 'New York', 'state_ab': 'NY', 'county': 'Monroe', 'locality_code': '55', 'latitude': 43.1452, 'longitude': -77.5495, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '22101', 'place_name': 'Mc Lean', 'state': 'Virginia', 'state_ab': 'VA', 'county': 'Fairfax', 'locality_code': '59', 'latitude': 38.9326, 'longitude': -77.1706, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '22066', 'place_name': 'Great Falls', 'state': 'Virginia', 'state_ab': 'VA', 'county': 'Fairfax', 'locality_code': '59', 'latitude': 39.0039, 'longitude': -77.3083, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '20165', 'place_name': 'Sterling', 'state': 'Virginia', 'state_ab': 'VA', 'county': 'Loudoun', 'locality_code': '107', 'latitude': 39.0472, 'longitude': -77.3866, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '10001', 'place_name': 'New York', 'state': 'New York', 'state_ab': 'NY', 'county': 'New York', 'locality_code': '61', 'latitude': 40.7484, 'longitude': -73.9967, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '10024', 'place_name': 'New York', 'state': 'New York', 'state_ab': 'NY', 'county': 'New York', 'locality_code': '61', 'latitude': 40.7864, 'longitude': -73.9764, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '10031', 'place_name': 'New York', 'state': 'New York', 'state_ab': 'NY', 'county': 'New York', 'locality_code': '61', 'latitude': 40.8246, 'longitude': -73.9507, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '08540', 'place_name': 'Princeton', 'state': 'New Jersey', 'state_ab': 'NJ', 'county': 'Mercer', 'locality_code': '21', 'latitude': 40.3666, 'longitude': -74.6408, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '20007', 'place_name': 'Washington', 'state': 'District of Columbia', 'state_ab': 'DC', 'county': 'District of Columbia', 'locality_code': '1', 'latitude': 38.9144, 'longitude': -77.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '20018', 'place_name': 'Washington', 'state': 'District of Columbia', 'state_ab': 'DC', 'county': 'District of Columbia', 'locality_code': '1', 'latitude': 38.9277, 'longitude': -76.9762, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90016', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0298, 'longitude': -118.3528, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90210', 'place_name': 'Beverly Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0901, 'longitude': -118.4065, 'accuracy': 4},
        ]
    )


def add_zip_code_data():
    op.bulk_insert(
        zip_lookup,
        [
            {'country_code': 'US', 'zip_code': '99553', 'place_name': 'Akutan', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians East', 'locality_code': '13', 'latitude': 54.143, 'longitude': -165.7854, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99571', 'place_name': 'Cold Bay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians East', 'locality_code': '13', 'latitude': 55.1858, 'longitude': -162.7211, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99583', 'place_name': 'False Pass', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians East', 'locality_code': '13', 'latitude': 54.8542, 'longitude': -163.4113, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99612', 'place_name': 'King Cove', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians East', 'locality_code': '13', 'latitude': 55.0628, 'longitude': -162.3056, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99661', 'place_name': 'Sand Point', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians East', 'locality_code': '13', 'latitude': 55.3192, 'longitude': -160.4914, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99546', 'place_name': 'Adak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians West (CA)', 'locality_code': '16', 'latitude': 51.874, 'longitude': -176.634, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99547', 'place_name': 'Atka', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians West (CA)', 'locality_code': '16', 'latitude': 52.1961, 'longitude': -174.2006, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99591', 'place_name': 'Saint George Island', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians West (CA)', 'locality_code': '16', 'latitude': 56.5944, 'longitude': -169.6186, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99638', 'place_name': 'Nikolski', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians West (CA)', 'locality_code': '16', 'latitude': 52.9381, 'longitude': -168.8678, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99660', 'place_name': 'Saint Paul Island', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians West (CA)', 'locality_code': '16', 'latitude': 57.1842, 'longitude': -170.2764, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99685', 'place_name': 'Unalaska', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians West (CA)', 'locality_code': '16', 'latitude': 53.8871, 'longitude': -166.5199, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99692', 'place_name': 'Dutch Harbor', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Aleutians West (CA)', 'locality_code': '16', 'latitude': 53.8898, 'longitude': -166.5422, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99501', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.2116, 'longitude': -149.8761, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99502', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1661, 'longitude': -149.96, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99503', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.19, 'longitude': -149.8938, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99504', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.2037, 'longitude': -149.7447, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99505', 'place_name': 'Jber', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 59.8666, 'longitude': -158.5996, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99506', 'place_name': 'Jber', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 59.8666, 'longitude': -158.5996, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99507', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1535, 'longitude': -149.8289, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99508', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.206, 'longitude': -149.8101, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99509', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.2181, 'longitude': -149.9003, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99510', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1446, 'longitude': -149.8784, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99511', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.0683, 'longitude': -149.8005, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99513', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.2149, 'longitude': -149.8862, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99514', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.2181, 'longitude': -149.9003, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99515', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1194, 'longitude': -149.8974, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99516', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1054, 'longitude': -149.78, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99517', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1901, 'longitude': -149.9361, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99518', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1549, 'longitude': -149.8866, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99519', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1089, 'longitude': -149.4403, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99520', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.2181, 'longitude': -149.9003, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99521', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.2181, 'longitude': -149.9003, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99522', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.2181, 'longitude': -149.9003, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99523', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.2181, 'longitude': -149.9003, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99524', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.2181, 'longitude': -149.9003, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99529', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1515, 'longitude': -149.9443, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99530', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1515, 'longitude': -149.9443, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99540', 'place_name': 'Indian', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1089, 'longitude': -149.4403, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99567', 'place_name': 'Chugiak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.4098, 'longitude': -149.4537, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99577', 'place_name': 'Eagle River', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.3114, 'longitude': -149.5085, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99587', 'place_name': 'Girdwood', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 60.9577, 'longitude': -149.1406, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99599', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1872, 'longitude': -149.8804, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99695', 'place_name': 'Anchorage', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Anchorage Municipality', 'locality_code': '20', 'latitude': 61.1089, 'longitude': -149.4403, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99545', 'place_name': 'Kongiganak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 59.9599, 'longitude': -162.8919, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99551', 'place_name': 'Akiachak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.9094, 'longitude': -161.4314, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99552', 'place_name': 'Akiak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.9122, 'longitude': -161.2139, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99557', 'place_name': 'Aniak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 61.5783, 'longitude': -159.5222, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99559', 'place_name': 'Bethel', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.7922, 'longitude': -161.7558, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99561', 'place_name': 'Chefornak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.1537, 'longitude': -164.2103, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99575', 'place_name': 'Crooked Creek', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 61.8181, 'longitude': -158.0025, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99578', 'place_name': 'Eek', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.2151, 'longitude': -162.0323, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99589', 'place_name': 'Goodnews Bay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 59.1189, 'longitude': -161.5875, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99607', 'place_name': 'Kalskag', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 61.541, 'longitude': -160.3261, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99609', 'place_name': 'Kasigluk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.8956, 'longitude': -162.5181, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99614', 'place_name': 'Kipnuk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 59.9232, 'longitude': -164.101, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99621', 'place_name': 'Kwethluk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.8122, 'longitude': -161.4358, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99622', 'place_name': 'Kwigillingok', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 59.8644, 'longitude': -163.1342, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99626', 'place_name': 'Lower Kalskag', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 61.5138, 'longitude': -160.36, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99630', 'place_name': 'Mekoryuk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.3657, 'longitude': -166.2836, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99634', 'place_name': 'Napakiak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.6967, 'longitude': -161.9519, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99637', 'place_name': 'Toksook Bay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.5338, 'longitude': -165.1037, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99641', 'place_name': 'Nunapitchuk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.8969, 'longitude': -162.4594, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99651', 'place_name': 'Platinum', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 59.0131, 'longitude': -161.8164, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99655', 'place_name': 'Quinhagak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 59.7381, 'longitude': -161.8749, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99656', 'place_name': 'Red Devil', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 61.7611, 'longitude': -157.3125, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99668', 'place_name': 'Sleetmute', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 61.7025, 'longitude': -157.1697, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99679', 'place_name': 'Tuluksak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 61.1088, 'longitude': -160.9389, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99680', 'place_name': 'Tuntutuliak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.3431, 'longitude': -162.6631, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99681', 'place_name': 'Tununak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.5856, 'longitude': -165.2558, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99690', 'place_name': 'Nightmute', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bethel Census Area', 'locality_code': '50', 'latitude': 60.4794, 'longitude': -164.7239, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99613', 'place_name': 'King Salmon', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bristol Bay', 'locality_code': '60', 'latitude': 58.6883, 'longitude': -156.6614, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99633', 'place_name': 'Naknek', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bristol Bay', 'locality_code': '60', 'latitude': 58.783, 'longitude': -156.8992, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99670', 'place_name': 'South Naknek', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Bristol Bay', 'locality_code': '60', 'latitude': 58.6639, 'longitude': -156.9756, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99704', 'place_name': 'Clear', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Denali', 'locality_code': '68', 'latitude': 64.2966, 'longitude': -149.1608, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99729', 'place_name': 'Cantwell', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Denali', 'locality_code': '68', 'latitude': 63.3955, 'longitude': -148.8973, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99743', 'place_name': 'Healy', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Denali', 'locality_code': '68', 'latitude': 63.9171, 'longitude': -149.0111, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99744', 'place_name': 'Anderson', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Denali', 'locality_code': '68', 'latitude': 64.3442, 'longitude': -149.1869, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99755', 'place_name': 'Denali National Park', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Denali', 'locality_code': '68', 'latitude': 63.5436, 'longitude': -149.9867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99555', 'place_name': 'Aleknagik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Dillingham (CA)', 'locality_code': '70', 'latitude': 59.2697, 'longitude': -158.6199, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99569', 'place_name': 'Clarks Point', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Dillingham (CA)', 'locality_code': '70', 'latitude': 58.8173, 'longitude': -158.5299, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99576', 'place_name': 'Dillingham', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Dillingham (CA)', 'locality_code': '70', 'latitude': 59.0402, 'longitude': -158.5231, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99580', 'place_name': 'Ekwok', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Dillingham (CA)', 'locality_code': '70', 'latitude': 59.3628, 'longitude': -157.4782, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99628', 'place_name': 'Manokotak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Dillingham (CA)', 'locality_code': '70', 'latitude': 59.0096, 'longitude': -158.9897, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99636', 'place_name': 'New Stuyahok', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Dillingham (CA)', 'locality_code': '70', 'latitude': 59.4882, 'longitude': -157.2905, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99678', 'place_name': 'Togiak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Dillingham (CA)', 'locality_code': '70', 'latitude': 59.0619, 'longitude': -160.3764, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99701', 'place_name': 'Fairbanks', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.8378, 'longitude': -147.7164, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99702', 'place_name': 'Eielson Afb', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.6735, 'longitude': -147.0805, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99703', 'place_name': 'Fort Wainwright', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.8283, 'longitude': -147.6557, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99705', 'place_name': 'North Pole', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.7805, 'longitude': -147.3694, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99706', 'place_name': 'Fairbanks', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.8521, 'longitude': -147.9377, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99707', 'place_name': 'Fairbanks', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.8378, 'longitude': -147.7164, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99708', 'place_name': 'Fairbanks', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.9475, 'longitude': -147.8564, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99709', 'place_name': 'Fairbanks', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.8544, 'longitude': -147.8469, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99710', 'place_name': 'Fairbanks', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.8378, 'longitude': -147.7164, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99711', 'place_name': 'Fairbanks', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.8378, 'longitude': -147.7164, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99712', 'place_name': 'Fairbanks', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.9109, 'longitude': -147.5105, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99714', 'place_name': 'Salcha', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.5091, 'longitude': -146.953, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99716', 'place_name': 'Two Rivers', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.8746, 'longitude': -146.8982, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99725', 'place_name': 'Ester', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.871, 'longitude': -148.0949, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99775', 'place_name': 'Fairbanks', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.8591, 'longitude': -147.8267, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99790', 'place_name': 'Fairbanks', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Fairbanks North Star', 'locality_code': '90', 'latitude': 64.8378, 'longitude': -147.7164, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99827', 'place_name': 'Haines', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Haines', 'locality_code': '100', 'latitude': 59.2519, 'longitude': -135.542, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99801', 'place_name': 'Juneau', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Juneau City and Borough', 'locality_code': '110', 'latitude': 58.3628, 'longitude': -134.5294, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99802', 'place_name': 'Juneau', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Juneau City and Borough', 'locality_code': '110', 'latitude': 58.3019, 'longitude': -134.4197, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99803', 'place_name': 'Juneau', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Juneau City and Borough', 'locality_code': '110', 'latitude': 58.3019, 'longitude': -134.4197, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99811', 'place_name': 'Juneau', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Juneau City and Borough', 'locality_code': '110', 'latitude': 58.3019, 'longitude': -134.4197, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99812', 'place_name': 'Juneau', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Juneau City and Borough', 'locality_code': '110', 'latitude': 58.3271, 'longitude': -134.4742, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99821', 'place_name': 'Auke Bay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Juneau City and Borough', 'locality_code': '110', 'latitude': 58.4494, 'longitude': -134.7003, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99824', 'place_name': 'Douglas', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Juneau City and Borough', 'locality_code': '110', 'latitude': 58.2756, 'longitude': -134.395, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99850', 'place_name': 'Juneau', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Juneau City and Borough', 'locality_code': '110', 'latitude': 58.3019, 'longitude': -134.4197, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99556', 'place_name': 'Anchor Point', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 59.8371, 'longitude': -151.7078, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99568', 'place_name': 'Clam Gulch', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.2311, 'longitude': -151.3936, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99572', 'place_name': 'Cooper Landing', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.4767, 'longitude': -149.8235, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99603', 'place_name': 'Homer', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 59.5374, 'longitude': -151.2356, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99605', 'place_name': 'Hope', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.8726, 'longitude': -149.4683, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99610', 'place_name': 'Kasilof', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.3164, 'longitude': -151.2896, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99611', 'place_name': 'Kenai', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.6145, 'longitude': -151.2546, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99631', 'place_name': 'Moose Pass', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.6148, 'longitude': -149.4056, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99635', 'place_name': 'Nikiski', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.7007, 'longitude': -151.2766, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99639', 'place_name': 'Ninilchik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.0108, 'longitude': -151.6396, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99663', 'place_name': 'Seldovia', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 59.4495, 'longitude': -151.7009, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99664', 'place_name': 'Seward', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.1329, 'longitude': -149.3985, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99669', 'place_name': 'Soldotna', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.4818, 'longitude': -151.1358, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99672', 'place_name': 'Sterling', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 60.5136, 'longitude': -150.8532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99682', 'place_name': 'Tyonek', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kenai Peninsula', 'locality_code': '122', 'latitude': 61.0681, 'longitude': -151.1369, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99901', 'place_name': 'Ketchikan', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Ketchikan Gateway', 'locality_code': '130', 'latitude': 55.372, 'longitude': -131.6832, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99928', 'place_name': 'Ward Cove', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Ketchikan Gateway', 'locality_code': '130', 'latitude': 55.3954, 'longitude': -131.6754, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99950', 'place_name': 'Ketchikan', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Ketchikan Gateway', 'locality_code': '130', 'latitude': 55.3422, 'longitude': -131.6478, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99550', 'place_name': 'Port Lions', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kodiak Island', 'locality_code': '150', 'latitude': 57.8675, 'longitude': -152.8822, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99608', 'place_name': 'Karluk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kodiak Island', 'locality_code': '150', 'latitude': 57.5689, 'longitude': -154.4551, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99615', 'place_name': 'Kodiak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kodiak Island', 'locality_code': '150', 'latitude': 57.6036, 'longitude': -153.3751, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99619', 'place_name': 'Kodiak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kodiak Island', 'locality_code': '150', 'latitude': 57.79, 'longitude': -152.4072, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99624', 'place_name': 'Larsen Bay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kodiak Island', 'locality_code': '150', 'latitude': 57.54, 'longitude': -153.9786, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99643', 'place_name': 'Old Harbor', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kodiak Island', 'locality_code': '150', 'latitude': 57.2028, 'longitude': -153.3039, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99644', 'place_name': 'Ouzinkie', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kodiak Island', 'locality_code': '150', 'latitude': 57.9236, 'longitude': -152.5022, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99697', 'place_name': 'Kodiak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kodiak Island', 'locality_code': '150', 'latitude': 57.79, 'longitude': -152.4072, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99554', 'place_name': 'Alakanuk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 62.6944, 'longitude': -164.6475, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99563', 'place_name': 'Chevak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 61.529, 'longitude': -165.5905, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99581', 'place_name': 'Emmonak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 62.7818, 'longitude': -164.5335, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99585', 'place_name': 'Marshall', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 61.9287, 'longitude': -162.268, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99604', 'place_name': 'Hooper Bay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 61.527, 'longitude': -166.1151, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99620', 'place_name': 'Kotlik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 63.0295, 'longitude': -163.5542, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99632', 'place_name': 'Mountain Village', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 62.1123, 'longitude': -163.6644, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99650', 'place_name': 'Pilot Station', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 61.9462, 'longitude': -162.8747, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99657', 'place_name': 'Russian Mission', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 61.7744, 'longitude': -161.3939, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99658', 'place_name': 'Saint Marys', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 62.1172, 'longitude': -163.2376, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99662', 'place_name': 'Scammon Bay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 61.845, 'longitude': -165.5819, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99666', 'place_name': 'Nunam Iqua', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Kusilvak', 'locality_code': '158', 'latitude': 62.5309, 'longitude': -164.8496, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99548', 'place_name': 'Chignik Lake', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 56.2448, 'longitude': -158.7578, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99549', 'place_name': 'Port Heiden', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 56.9643, 'longitude': -158.5664, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99564', 'place_name': 'Chignik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 56.3016, 'longitude': -158.4157, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99565', 'place_name': 'Chignik Lagoon', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 58.2687, 'longitude': -156.6484, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99579', 'place_name': 'Egegik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 58.2062, 'longitude': -157.3422, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99606', 'place_name': 'Iliamna', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 59.7525, 'longitude': -154.8236, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99625', 'place_name': 'Levelock', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 59.2905, 'longitude': -156.6503, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99640', 'place_name': 'Nondalton', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 59.9736, 'longitude': -154.8458, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99647', 'place_name': 'Pedro Bay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 59.8681, 'longitude': -154.0757, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99648', 'place_name': 'Perryville', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 55.9453, 'longitude': -159.2593, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99649', 'place_name': 'Pilot Point', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 57.5642, 'longitude': -157.5792, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99653', 'place_name': 'Port Alsworth', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Lake and Peninsula', 'locality_code': '164', 'latitude': 60.2025, 'longitude': -154.3128, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99623', 'place_name': 'Wasilla', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 61.5463, 'longitude': -149.5901, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99629', 'place_name': 'Wasilla', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 61.5841, 'longitude': -149.4436, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99645', 'place_name': 'Palmer', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 61.6303, 'longitude': -148.9872, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99652', 'place_name': 'Big Lake', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 61.5214, 'longitude': -149.9544, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99654', 'place_name': 'Wasilla', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 61.5923, 'longitude': -149.3959, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99667', 'place_name': 'Skwentna', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 61.9903, 'longitude': -151.3978, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99674', 'place_name': 'Sutton', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 61.7327, 'longitude': -148.7837, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99676', 'place_name': 'Talkeetna', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 62.2605, 'longitude': -150.1101, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99683', 'place_name': 'Trapper Creek', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 62.3167, 'longitude': -150.2314, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99687', 'place_name': 'Wasilla', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 61.5313, 'longitude': -149.4784, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99688', 'place_name': 'Willow', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 61.8966, 'longitude': -150.0038, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99694', 'place_name': 'Houston', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Matanuska-Susitna Borough', 'locality_code': '170', 'latitude': 61.6303, 'longitude': -149.8181, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99659', 'place_name': 'Saint Michael', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 63.4776, 'longitude': -162.1091, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99671', 'place_name': 'Stebbins', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 63.5222, 'longitude': -162.2881, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99684', 'place_name': 'Unalakleet', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 63.8835, 'longitude': -160.7884, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99739', 'place_name': 'Elim', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 64.6217, 'longitude': -162.2604, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99742', 'place_name': 'Gambell', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 63.7766, 'longitude': -171.7017, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99753', 'place_name': 'Koyuk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 64.9319, 'longitude': -161.1569, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99762', 'place_name': 'Nome', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 64.5011, 'longitude': -165.4064, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99769', 'place_name': 'Savoonga', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 63.6797, 'longitude': -170.4709, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99771', 'place_name': 'Shaktoolik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 64.3537, 'longitude': -161.1932, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99772', 'place_name': 'Shishmaref', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 66.2306, 'longitude': -166.1373, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99778', 'place_name': 'Teller', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 65.2402, 'longitude': -166.3833, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99783', 'place_name': 'Wales', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 65.6092, 'longitude': -168.0875, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99784', 'place_name': 'White Mountain', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 64.6814, 'longitude': -163.4056, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99785', 'place_name': 'Brevig Mission', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Nome (CA)', 'locality_code': '180', 'latitude': 65.3342, 'longitude': -166.4786, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99721', 'place_name': 'Anaktuvuk Pass', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'North Slope', 'locality_code': '185', 'latitude': 68.1433, 'longitude': -151.7358, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99723', 'place_name': 'Barrow', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'North Slope', 'locality_code': '185', 'latitude': 71.2346, 'longitude': -156.8174, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99734', 'place_name': 'Prudhoe Bay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'North Slope', 'locality_code': '185', 'latitude': 70.2922, 'longitude': -148.6694, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99747', 'place_name': 'Kaktovik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'North Slope', 'locality_code': '185', 'latitude': 70.1319, 'longitude': -143.6239, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99759', 'place_name': 'Point Lay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'North Slope', 'locality_code': '185', 'latitude': 69.7439, 'longitude': -163.0084, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99766', 'place_name': 'Point Hope', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'North Slope', 'locality_code': '185', 'latitude': 68.3486, 'longitude': -166.7347, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99782', 'place_name': 'Wainwright', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'North Slope', 'locality_code': '185', 'latitude': 70.6369, 'longitude': -160.0383, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99789', 'place_name': 'Nuiqsut', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'North Slope', 'locality_code': '185', 'latitude': 70.1927, 'longitude': -150.9971, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99791', 'place_name': 'Atqasuk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'North Slope', 'locality_code': '185', 'latitude': 70.4947, 'longitude': -157.4411, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99727', 'place_name': 'Buckland', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 65.9789, 'longitude': -161.1262, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99736', 'place_name': 'Deering', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 66.0737, 'longitude': -162.714, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99749', 'place_name': 'Kiana', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 66.975, 'longitude': -160.4228, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99750', 'place_name': 'Kivalina', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 67.7269, 'longitude': -164.5333, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99751', 'place_name': 'Kobuk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 66.9072, 'longitude': -156.8811, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99752', 'place_name': 'Kotzebue', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 66.8985, 'longitude': -162.5981, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99761', 'place_name': 'Noatak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 67.5711, 'longitude': -162.9653, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99763', 'place_name': 'Noorvik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 66.8364, 'longitude': -161.0441, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99770', 'place_name': 'Selawik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 66.6039, 'longitude': -160.0069, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99773', 'place_name': 'Shungnak', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 66.8881, 'longitude': -157.1364, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99786', 'place_name': 'Ambler', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Northwest Arctic', 'locality_code': '188', 'latitude': 67.0861, 'longitude': -157.8514, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99903', 'place_name': 'Meyers Chuck', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Prince of Wales-Hyder', 'locality_code': '198', 'latitude': 55.7408, 'longitude': -132.2564, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99918', 'place_name': 'Coffman Cove', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Prince of Wales-Hyder', 'locality_code': '198', 'latitude': 55.9524, 'longitude': -132.7503, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99919', 'place_name': 'Thorne Bay', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Prince of Wales-Hyder', 'locality_code': '198', 'latitude': 55.6609, 'longitude': -132.5138, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99921', 'place_name': 'Craig', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Prince of Wales-Hyder', 'locality_code': '198', 'latitude': 55.4732, 'longitude': -133.1171, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99922', 'place_name': 'Hydaburg', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Prince of Wales-Hyder', 'locality_code': '198', 'latitude': 55.2087, 'longitude': -132.8259, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99923', 'place_name': 'Hyder', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Prince of Wales-Hyder', 'locality_code': '198', 'latitude': 55.9169, 'longitude': -130.0247, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99925', 'place_name': 'Klawock', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Prince of Wales-Hyder', 'locality_code': '198', 'latitude': 55.5526, 'longitude': -133.0555, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99926', 'place_name': 'Metlakatla', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Prince of Wales-Hyder', 'locality_code': '198', 'latitude': 55.1215, 'longitude': -131.579, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99927', 'place_name': 'Point Baker', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Prince of Wales-Hyder', 'locality_code': '198', 'latitude': 56.3528, 'longitude': -133.6211, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99835', 'place_name': 'Sitka', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Sitka City and Borough', 'locality_code': '220', 'latitude': 57.0514, 'longitude': -135.3166, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99689', 'place_name': 'Yakutat', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Skagway-Hoonah-Angoon', 'locality_code': '232', 'latitude': 59.812, 'longitude': -139.5505, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99820', 'place_name': 'Angoon', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Skagway-Hoonah-Angoon', 'locality_code': '232', 'latitude': 57.5005, 'longitude': -134.586, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99825', 'place_name': 'Elfin Cove', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Skagway-Hoonah-Angoon', 'locality_code': '232', 'latitude': 58.1944, 'longitude': -136.3433, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99826', 'place_name': 'Gustavus', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Skagway-Hoonah-Angoon', 'locality_code': '232', 'latitude': 58.4284, 'longitude': -135.7615, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99829', 'place_name': 'Hoonah', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Skagway-Hoonah-Angoon', 'locality_code': '232', 'latitude': 58.0977, 'longitude': -135.4316, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99832', 'place_name': 'Pelican', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Skagway-Hoonah-Angoon', 'locality_code': '232', 'latitude': 57.9608, 'longitude': -136.2275, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99840', 'place_name': 'Skagway', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Skagway-Hoonah-Angoon', 'locality_code': '232', 'latitude': 59.4685, 'longitude': -135.3018, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99841', 'place_name': 'Tenakee Springs', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Skagway-Hoonah-Angoon', 'locality_code': '232', 'latitude': 57.7808, 'longitude': -135.2189, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99731', 'place_name': 'Fort Greely', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Southeast Fairbanks Census Area', 'locality_code': '240', 'latitude': 63.952, 'longitude': -146.451, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99732', 'place_name': 'Chicken', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Southeast Fairbanks Census Area', 'locality_code': '240', 'latitude': 64.0733, 'longitude': -141.9361, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99737', 'place_name': 'Delta Junction', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Southeast Fairbanks Census Area', 'locality_code': '240', 'latitude': 64.0378, 'longitude': -145.7322, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99738', 'place_name': 'Eagle', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Southeast Fairbanks Census Area', 'locality_code': '240', 'latitude': 64.7881, 'longitude': -141.2, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99764', 'place_name': 'Northway', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Southeast Fairbanks Census Area', 'locality_code': '240', 'latitude': 62.9617, 'longitude': -141.9372, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99776', 'place_name': 'Tanacross', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Southeast Fairbanks Census Area', 'locality_code': '240', 'latitude': 63.3853, 'longitude': -143.3464, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99780', 'place_name': 'Tok', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Southeast Fairbanks Census Area', 'locality_code': '240', 'latitude': 63.3367, 'longitude': -142.9856, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99566', 'place_name': 'Chitina', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Valdez-Cordova (CA)', 'locality_code': '261', 'latitude': 61.5156, 'longitude': -144.4396, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99573', 'place_name': 'Copper Center', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Valdez-Cordova (CA)', 'locality_code': '261', 'latitude': 61.977, 'longitude': -145.3297, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99574', 'place_name': 'Cordova', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Valdez-Cordova (CA)', 'locality_code': '261', 'latitude': 60.5362, 'longitude': -145.7534, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99586', 'place_name': 'Gakona', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Valdez-Cordova (CA)', 'locality_code': '261', 'latitude': 62.3014, 'longitude': -145.3027, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99588', 'place_name': 'Glennallen', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Valdez-Cordova (CA)', 'locality_code': '261', 'latitude': 62.1039, 'longitude': -145.6617, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99677', 'place_name': 'Tatitlek', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Valdez-Cordova (CA)', 'locality_code': '261', 'latitude': 60.8906, 'longitude': -146.6703, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99686', 'place_name': 'Valdez', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Valdez-Cordova (CA)', 'locality_code': '261', 'latitude': 61.101, 'longitude': -146.9, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99693', 'place_name': 'Whittier', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Valdez-Cordova (CA)', 'locality_code': '261', 'latitude': 60.7734, 'longitude': -148.6839, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99830', 'place_name': 'Kake', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Wrangell-Petersburg (C', 'locality_code': '280', 'latitude': 56.9736, 'longitude': -133.936, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99833', 'place_name': 'Petersburg', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Wrangell-Petersburg (C', 'locality_code': '280', 'latitude': 56.8271, 'longitude': -133.1607, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99836', 'place_name': 'Port Alexander', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Wrangell-Petersburg (C', 'locality_code': '280', 'latitude': 56.2497, 'longitude': -134.6444, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99929', 'place_name': 'Wrangell', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Wrangell-Petersburg (C', 'locality_code': '280', 'latitude': 56.4335, 'longitude': -132.3529, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99558', 'place_name': 'Anvik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 62.6561, 'longitude': -160.2067, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99590', 'place_name': 'Grayling', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 62.9036, 'longitude': -160.0647, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99602', 'place_name': 'Holy Cross', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 62.1926, 'longitude': -159.8251, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99627', 'place_name': 'Mc Grath', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 62.9457, 'longitude': -155.5712, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99665', 'place_name': 'Shageluk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 62.6822, 'longitude': -159.5619, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99675', 'place_name': 'Takotna', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 62.9886, 'longitude': -156.0642, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99691', 'place_name': 'Nikolai', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 63.0133, 'longitude': -154.375, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99720', 'place_name': 'Allakaket', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 66.5656, 'longitude': -152.6456, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99722', 'place_name': 'Arctic Village', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 68.1269, 'longitude': -145.5378, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99724', 'place_name': 'Beaver', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 66.3594, 'longitude': -147.3964, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99726', 'place_name': 'Bettles Field', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 65.2264, 'longitude': -151.0251, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99730', 'place_name': 'Central', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 65.4681, 'longitude': -144.7489, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99733', 'place_name': 'Circle', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 65.8245, 'longitude': -144.0826, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99740', 'place_name': 'Fort Yukon', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 66.5647, 'longitude': -145.2739, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99741', 'place_name': 'Galena', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 64.7333, 'longitude': -156.9275, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99745', 'place_name': 'Hughes', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 66.0382, 'longitude': -154.2644, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99746', 'place_name': 'Huslia', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 65.6899, 'longitude': -156.292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99748', 'place_name': 'Kaltag', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 64.3305, 'longitude': -158.7243, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99754', 'place_name': 'Koyukuk', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 64.8803, 'longitude': -157.7008, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99756', 'place_name': 'Manley Hot Springs', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 65.0011, 'longitude': -150.6339, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99757', 'place_name': 'Lake Minchumina', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 63.8828, 'longitude': -152.3122, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99758', 'place_name': 'Minto', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 65.0584, 'longitude': -149.6912, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99760', 'place_name': 'Nenana', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 64.5577, 'longitude': -149.0867, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99765', 'place_name': 'Nulato', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 64.7194, 'longitude': -158.1031, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99767', 'place_name': 'Rampart', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 65.509, 'longitude': -150.1619, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99768', 'place_name': 'Ruby', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 64.7201, 'longitude': -155.5039, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99774', 'place_name': 'Stevens Village', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 66.0064, 'longitude': -149.0908, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '99777', 'place_name': 'Tanana', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 65.1719, 'longitude': -152.0789, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99781', 'place_name': 'Venetie', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 67.0104, 'longitude': -146.4137, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '99788', 'place_name': 'Chalkyitsik', 'state': 'Alaska', 'state_ab': 'AK', 'county': 'Yukon-Koyukuk (CA)', 'locality_code': '290', 'latitude': 66.6544, 'longitude': -143.7222, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '36003', 'place_name': 'Autaugaville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Autauga', 'locality_code': '1', 'latitude': 32.4625, 'longitude': -86.7149, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36006', 'place_name': 'Billingsley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Autauga', 'locality_code': '1', 'latitude': 32.6596, 'longitude': -86.7178, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36008', 'place_name': 'Booth', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Autauga', 'locality_code': '1', 'latitude': 32.5016, 'longitude': -86.5727, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36051', 'place_name': 'Marbury', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Autauga', 'locality_code': '1', 'latitude': 32.6841, 'longitude': -86.4946, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36066', 'place_name': 'Prattville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Autauga', 'locality_code': '1', 'latitude': 32.4787, 'longitude': -86.43, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36067', 'place_name': 'Prattville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Autauga', 'locality_code': '1', 'latitude': 32.4715, 'longitude': -86.4831, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36068', 'place_name': 'Prattville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Autauga', 'locality_code': '1', 'latitude': 32.464, 'longitude': -86.4597, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36749', 'place_name': 'Jones', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Autauga', 'locality_code': '1', 'latitude': 32.5104, 'longitude': -86.8138, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36507', 'place_name': 'Bay Minette', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.8635, 'longitude': -87.7644, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36511', 'place_name': 'Bon Secour', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.3128, 'longitude': -87.7431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36526', 'place_name': 'Daphne', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.6197, 'longitude': -87.8895, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36527', 'place_name': 'Spanish Fort', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.6959, 'longitude': -87.8867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36530', 'place_name': 'Elberta', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.3942, 'longitude': -87.589, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36532', 'place_name': 'Fairhope', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.5012, 'longitude': -87.8835, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36533', 'place_name': 'Fairhope', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.4841, 'longitude': -87.8606, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36535', 'place_name': 'Foley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.4007, 'longitude': -87.6857, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36536', 'place_name': 'Foley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.4222, 'longitude': -87.7064, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36542', 'place_name': 'Gulf Shores', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.2717, 'longitude': -87.7589, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36547', 'place_name': 'Gulf Shores', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.246, 'longitude': -87.7008, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36549', 'place_name': 'Lillian', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.3972, 'longitude': -87.4745, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36550', 'place_name': 'Little River', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 31.2246, 'longitude': -87.7548, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36551', 'place_name': 'Loxley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.618, 'longitude': -87.7562, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36555', 'place_name': 'Magnolia Springs', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.3996, 'longitude': -87.7761, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36559', 'place_name': 'Montrose', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.5623, 'longitude': -87.9005, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36561', 'place_name': 'Orange Beach', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.281, 'longitude': -87.5815, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36562', 'place_name': 'Perdido', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 31.0403, 'longitude': -87.6667, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36564', 'place_name': 'Point Clear', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.4741, 'longitude': -87.9192, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36567', 'place_name': 'Robertsdale', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.5616, 'longitude': -87.6373, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36574', 'place_name': 'Seminole', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.5048, 'longitude': -87.4659, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36576', 'place_name': 'Silverhill', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.5222, 'longitude': -87.7457, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36577', 'place_name': 'Spanish Fort', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.6749, 'longitude': -87.9153, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36578', 'place_name': 'Stapleton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.7476, 'longitude': -87.7787, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36579', 'place_name': 'Stockton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 31.0129, 'longitude': -87.8633, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36580', 'place_name': 'Summerdale', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Baldwin', 'locality_code': '3', 'latitude': 30.4752, 'longitude': -87.6992, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36016', 'place_name': 'Clayton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Barbour', 'locality_code': '5', 'latitude': 31.8874, 'longitude': -85.4509, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36017', 'place_name': 'Clio', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Barbour', 'locality_code': '5', 'latitude': 31.6852, 'longitude': -85.5904, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36027', 'place_name': 'Eufaula', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Barbour', 'locality_code': '5', 'latitude': 31.9051, 'longitude': -85.1656, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36048', 'place_name': 'Louisville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Barbour', 'locality_code': '5', 'latitude': 31.7943, 'longitude': -85.5581, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36072', 'place_name': 'Eufaula', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Barbour', 'locality_code': '5', 'latitude': 31.8913, 'longitude': -85.1455, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35034', 'place_name': 'Brent', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bibb', 'locality_code': '7', 'latitude': 32.9357, 'longitude': -87.2114, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35035', 'place_name': 'Brierfield', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bibb', 'locality_code': '7', 'latitude': 33.0427, 'longitude': -86.9517, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35042', 'place_name': 'Centreville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bibb', 'locality_code': '7', 'latitude': 32.9503, 'longitude': -87.1192, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35074', 'place_name': 'Green Pond', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bibb', 'locality_code': '7', 'latitude': 33.2251, 'longitude': -87.1264, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35184', 'place_name': 'West Blocton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bibb', 'locality_code': '7', 'latitude': 33.1424, 'longitude': -87.1369, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35188', 'place_name': 'Woodstock', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bibb', 'locality_code': '7', 'latitude': 33.2068, 'longitude': -87.15, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36792', 'place_name': 'Randolph', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bibb', 'locality_code': '7', 'latitude': 32.8888, 'longitude': -86.907, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36793', 'place_name': 'Lawley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bibb', 'locality_code': '7', 'latitude': 32.8646, 'longitude': -86.9567, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35013', 'place_name': 'Allgood', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Blount', 'locality_code': '9', 'latitude': 33.9222, 'longitude': -86.4493, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35031', 'place_name': 'Blountsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Blount', 'locality_code': '9', 'latitude': 34.0929, 'longitude': -86.5686, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35049', 'place_name': 'Cleveland', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Blount', 'locality_code': '9', 'latitude': 33.9778, 'longitude': -86.5598, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35079', 'place_name': 'Hayden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Blount', 'locality_code': '9', 'latitude': 33.9534, 'longitude': -86.7455, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35097', 'place_name': 'Locust Fork', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Blount', 'locality_code': '9', 'latitude': 33.905, 'longitude': -86.6261, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35121', 'place_name': 'Oneonta', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Blount', 'locality_code': '9', 'latitude': 33.9259, 'longitude': -86.4741, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35133', 'place_name': 'Remlap', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Blount', 'locality_code': '9', 'latitude': 33.8168, 'longitude': -86.6008, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36029', 'place_name': 'Fitzpatrick', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bullock', 'locality_code': '11', 'latitude': 32.2165, 'longitude': -85.8888, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36053', 'place_name': 'Midway', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bullock', 'locality_code': '11', 'latitude': 32.0955, 'longitude': -85.5315, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36061', 'place_name': 'Perote', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bullock', 'locality_code': '11', 'latitude': 32.0928, 'longitude': -85.7046, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36089', 'place_name': 'Union Springs', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Bullock', 'locality_code': '11', 'latitude': 32.1443, 'longitude': -85.7149, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36015', 'place_name': 'Chapman', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Butler', 'locality_code': '13', 'latitude': 31.6427, 'longitude': -86.7343, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36030', 'place_name': 'Forest Home', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Butler', 'locality_code': '13', 'latitude': 31.8501, 'longitude': -86.8372, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36033', 'place_name': 'Georgiana', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Butler', 'locality_code': '13', 'latitude': 31.6287, 'longitude': -86.734, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36037', 'place_name': 'Greenville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Butler', 'locality_code': '13', 'latitude': 31.81, 'longitude': -86.6229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36456', 'place_name': 'Mc Kenzie', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Butler', 'locality_code': '13', 'latitude': 31.545, 'longitude': -86.7356, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '36201', 'place_name': 'Anniston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.6539, 'longitude': -85.8382, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36202', 'place_name': 'Anniston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.7622, 'longitude': -85.8378, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36203', 'place_name': 'Oxford', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.5815, 'longitude': -85.8328, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36204', 'place_name': 'Anniston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.7622, 'longitude': -85.8378, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36205', 'place_name': 'Anniston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.7358, 'longitude': -85.7933, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36206', 'place_name': 'Anniston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.7191, 'longitude': -85.8389, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36207', 'place_name': 'Anniston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.6803, 'longitude': -85.7137, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36250', 'place_name': 'Alexandria', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.7808, 'longitude': -85.8924, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36253', 'place_name': 'Bynum', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.7622, 'longitude': -85.8378, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36254', 'place_name': 'Choccolocco', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.6573, 'longitude': -85.6991, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36257', 'place_name': 'De Armanville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.7622, 'longitude': -85.8378, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '36260', 'place_name': 'Eastaboga', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.6031, 'longitude': -85.9608, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36265', 'place_name': 'Jacksonville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.831, 'longitude': -85.7752, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36271', 'place_name': 'Ohatchee', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.7788, 'longitude': -86.0254, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36272', 'place_name': 'Piedmont', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.8389, 'longitude': -85.646, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36277', 'place_name': 'Weaver', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.7563, 'longitude': -85.8107, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36279', 'place_name': 'Wellington', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Calhoun', 'locality_code': '15', 'latitude': 33.8226, 'longitude': -85.8927, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36852', 'place_name': 'Cusseta', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chambers', 'locality_code': '17', 'latitude': 32.7831, 'longitude': -85.2756, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36854', 'place_name': 'Valley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chambers', 'locality_code': '17', 'latitude': 32.8113, 'longitude': -85.1749, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36855', 'place_name': 'Five Points', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chambers', 'locality_code': '17', 'latitude': 33.0424, 'longitude': -85.3243, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36862', 'place_name': 'Lafayette', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chambers', 'locality_code': '17', 'latitude': 32.9252, 'longitude': -85.4426, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36863', 'place_name': 'Lanett', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chambers', 'locality_code': '17', 'latitude': 32.8616, 'longitude': -85.2161, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35959', 'place_name': 'Cedar Bluff', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cherokee', 'locality_code': '19', 'latitude': 34.2417, 'longitude': -85.6026, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35960', 'place_name': 'Centre', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cherokee', 'locality_code': '19', 'latitude': 34.1116, 'longitude': -85.6092, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35973', 'place_name': 'Gaylesville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cherokee', 'locality_code': '19', 'latitude': 34.3573, 'longitude': -85.5589, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35983', 'place_name': 'Leesburg', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cherokee', 'locality_code': '19', 'latitude': 34.1911, 'longitude': -85.7705, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36275', 'place_name': 'Spring Garden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cherokee', 'locality_code': '19', 'latitude': 33.9778, 'longitude': -85.5521, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35045', 'place_name': 'Clanton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chilton', 'locality_code': '21', 'latitude': 32.8355, 'longitude': -86.6425, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35046', 'place_name': 'Clanton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chilton', 'locality_code': '21', 'latitude': 32.9229, 'longitude': -86.545, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35085', 'place_name': 'Jemison', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chilton', 'locality_code': '21', 'latitude': 32.9805, 'longitude': -86.7181, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35171', 'place_name': 'Thorsby', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chilton', 'locality_code': '21', 'latitude': 32.9157, 'longitude': -86.7158, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36091', 'place_name': 'Verbena', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chilton', 'locality_code': '21', 'latitude': 32.7499, 'longitude': -86.5114, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36750', 'place_name': 'Maplesville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chilton', 'locality_code': '21', 'latitude': 32.8045, 'longitude': -86.8717, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36790', 'place_name': 'Stanton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Chilton', 'locality_code': '21', 'latitude': 32.7332, 'longitude': -86.8963, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36904', 'place_name': 'Butler', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Choctaw', 'locality_code': '23', 'latitude': 32.0829, 'longitude': -88.2064, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36908', 'place_name': 'Gilbertown', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Choctaw', 'locality_code': '23', 'latitude': 31.8666, 'longitude': -88.3265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36910', 'place_name': 'Jachin', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Choctaw', 'locality_code': '23', 'latitude': 32.2299, 'longitude': -88.1684, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36912', 'place_name': 'Lisman', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Choctaw', 'locality_code': '23', 'latitude': 32.2177, 'longitude': -88.3234, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36913', 'place_name': 'Melvin', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Choctaw', 'locality_code': '23', 'latitude': 31.9304, 'longitude': -88.4589, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36915', 'place_name': 'Needham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Choctaw', 'locality_code': '23', 'latitude': 31.9879, 'longitude': -88.3367, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36916', 'place_name': 'Pennington', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Choctaw', 'locality_code': '23', 'latitude': 32.2094, 'longitude': -88.049, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36919', 'place_name': 'Silas', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Choctaw', 'locality_code': '23', 'latitude': 31.7668, 'longitude': -88.3091, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36921', 'place_name': 'Toxey', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Choctaw', 'locality_code': '23', 'latitude': 31.9155, 'longitude': -88.151, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36922', 'place_name': 'Ward', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Choctaw', 'locality_code': '23', 'latitude': 32.3038, 'longitude': -88.1476, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36436', 'place_name': 'Dickinson', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clarke', 'locality_code': '25', 'latitude': 31.7635, 'longitude': -87.7106, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36446', 'place_name': 'Fulton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clarke', 'locality_code': '25', 'latitude': 31.7925, 'longitude': -87.72, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36451', 'place_name': 'Grove Hill', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clarke', 'locality_code': '25', 'latitude': 31.7088, 'longitude': -87.7772, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36482', 'place_name': 'Whatley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clarke', 'locality_code': '25', 'latitude': 31.6395, 'longitude': -87.6565, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36524', 'place_name': 'Coffeeville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clarke', 'locality_code': '25', 'latitude': 31.7843, 'longitude': -88.0715, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36540', 'place_name': 'Gainestown', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clarke', 'locality_code': '25', 'latitude': 31.4258, 'longitude': -87.6822, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36545', 'place_name': 'Jackson', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clarke', 'locality_code': '25', 'latitude': 31.5131, 'longitude': -87.8672, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36727', 'place_name': 'Campbell', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clarke', 'locality_code': '25', 'latitude': 31.9213, 'longitude': -88.008, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36784', 'place_name': 'Thomasville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clarke', 'locality_code': '25', 'latitude': 31.9067, 'longitude': -87.7598, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35082', 'place_name': 'Hollins', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clay', 'locality_code': '27', 'latitude': 33.1162, 'longitude': -86.1386, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36251', 'place_name': 'Ashland', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clay', 'locality_code': '27', 'latitude': 33.2474, 'longitude': -85.829, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36255', 'place_name': 'Cragford', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clay', 'locality_code': '27', 'latitude': 33.2171, 'longitude': -85.7108, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36258', 'place_name': 'Delta', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clay', 'locality_code': '27', 'latitude': 33.4573, 'longitude': -85.6793, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36266', 'place_name': 'Lineville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clay', 'locality_code': '27', 'latitude': 33.3286, 'longitude': -85.7346, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36267', 'place_name': 'Millerville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Clay', 'locality_code': '27', 'latitude': 33.1915, 'longitude': -85.9258, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36261', 'place_name': 'Edwardsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cleburne', 'locality_code': '29', 'latitude': 33.7066, 'longitude': -85.5099, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36262', 'place_name': 'Fruithurst', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cleburne', 'locality_code': '29', 'latitude': 33.7717, 'longitude': -85.4381, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36264', 'place_name': 'Heflin', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cleburne', 'locality_code': '29', 'latitude': 33.6115, 'longitude': -85.5885, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36269', 'place_name': 'Muscadine', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cleburne', 'locality_code': '29', 'latitude': 33.7529, 'longitude': -85.3789, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36273', 'place_name': 'Ranburne', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cleburne', 'locality_code': '29', 'latitude': 33.5616, 'longitude': -85.3786, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36323', 'place_name': 'Elba', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coffee', 'locality_code': '31', 'latitude': 31.4137, 'longitude': -86.0777, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36330', 'place_name': 'Enterprise', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coffee', 'locality_code': '31', 'latitude': 31.3408, 'longitude': -85.8421, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36331', 'place_name': 'Enterprise', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coffee', 'locality_code': '31', 'latitude': 31.2978, 'longitude': -85.9036, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36346', 'place_name': 'Jack', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coffee', 'locality_code': '31', 'latitude': 31.5652, 'longitude': -85.971, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36351', 'place_name': 'New Brockton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coffee', 'locality_code': '31', 'latitude': 31.369, 'longitude': -85.9404, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36453', 'place_name': 'Kinston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coffee', 'locality_code': '31', 'latitude': 31.1926, 'longitude': -86.1514, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35616', 'place_name': 'Cherokee', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Colbert', 'locality_code': '33', 'latitude': 34.7442, 'longitude': -87.9724, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35646', 'place_name': 'Leighton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Colbert', 'locality_code': '33', 'latitude': 34.711, 'longitude': -87.5221, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35660', 'place_name': 'Sheffield', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Colbert', 'locality_code': '33', 'latitude': 34.7578, 'longitude': -87.6971, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35661', 'place_name': 'Muscle Shoals', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Colbert', 'locality_code': '33', 'latitude': 34.7561, 'longitude': -87.6304, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35662', 'place_name': 'Muscle Shoals', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Colbert', 'locality_code': '33', 'latitude': 34.7448, 'longitude': -87.6675, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35674', 'place_name': 'Tuscumbia', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Colbert', 'locality_code': '33', 'latitude': 34.6874, 'longitude': -87.6833, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36401', 'place_name': 'Evergreen', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Conecuh', 'locality_code': '35', 'latitude': 31.458, 'longitude': -86.9258, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36429', 'place_name': 'Brooklyn', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Conecuh', 'locality_code': '35', 'latitude': 31.2627, 'longitude': -86.7711, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36432', 'place_name': 'Castleberry', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Conecuh', 'locality_code': '35', 'latitude': 31.2991, 'longitude': -87.0225, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36454', 'place_name': 'Lenox', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Conecuh', 'locality_code': '35', 'latitude': 31.3366, 'longitude': -87.1855, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36473', 'place_name': 'Range', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Conecuh', 'locality_code': '35', 'latitude': 31.3058, 'longitude': -87.2137, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36475', 'place_name': 'Repton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Conecuh', 'locality_code': '35', 'latitude': 31.4256, 'longitude': -87.172, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35072', 'place_name': 'Goodwater', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coosa', 'locality_code': '37', 'latitude': 33.0746, 'longitude': -86.0781, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35089', 'place_name': 'Kellyton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coosa', 'locality_code': '37', 'latitude': 32.9791, 'longitude': -86.0484, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35136', 'place_name': 'Rockford', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coosa', 'locality_code': '37', 'latitude': 32.878, 'longitude': -86.24, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35183', 'place_name': 'Weogufka', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coosa', 'locality_code': '37', 'latitude': 33.0238, 'longitude': -86.3042, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36026', 'place_name': 'Equality', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Coosa', 'locality_code': '37', 'latitude': 32.8139, 'longitude': -86.1051, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36038', 'place_name': 'Gantt', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Covington', 'locality_code': '39', 'latitude': 31.4068, 'longitude': -86.4841, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36420', 'place_name': 'Andalusia', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Covington', 'locality_code': '39', 'latitude': 31.2971, 'longitude': -86.4905, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36442', 'place_name': 'Florala', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Covington', 'locality_code': '39', 'latitude': 31.0172, 'longitude': -86.3385, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36455', 'place_name': 'Lockhart', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Covington', 'locality_code': '39', 'latitude': 31.0105, 'longitude': -86.3497, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36467', 'place_name': 'Opp', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Covington', 'locality_code': '39', 'latitude': 31.2799, 'longitude': -86.2571, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36474', 'place_name': 'Red Level', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Covington', 'locality_code': '39', 'latitude': 31.4399, 'longitude': -86.6121, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36476', 'place_name': 'River Falls', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Covington', 'locality_code': '39', 'latitude': 31.3533, 'longitude': -86.541, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36483', 'place_name': 'Wing', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Covington', 'locality_code': '39', 'latitude': 31.0223, 'longitude': -86.6293, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36009', 'place_name': 'Brantley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Crenshaw', 'locality_code': '41', 'latitude': 31.571, 'longitude': -86.2743, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36028', 'place_name': 'Dozier', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Crenshaw', 'locality_code': '41', 'latitude': 31.5066, 'longitude': -86.3663, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36034', 'place_name': 'Glenwood', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Crenshaw', 'locality_code': '41', 'latitude': 31.6641, 'longitude': -86.171, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36041', 'place_name': 'Highland Home', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Crenshaw', 'locality_code': '41', 'latitude': 31.9283, 'longitude': -86.2971, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36042', 'place_name': 'Honoraville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Crenshaw', 'locality_code': '41', 'latitude': 31.8784, 'longitude': -86.3981, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36049', 'place_name': 'Luverne', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Crenshaw', 'locality_code': '41', 'latitude': 31.7074, 'longitude': -86.2566, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36062', 'place_name': 'Petrey', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Crenshaw', 'locality_code': '41', 'latitude': 31.8488, 'longitude': -86.2077, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36071', 'place_name': 'Rutledge', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Crenshaw', 'locality_code': '41', 'latitude': 31.7062, 'longitude': -86.3715, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35019', 'place_name': 'Baileyton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.2683, 'longitude': -86.6213, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35033', 'place_name': 'Bremen', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 33.9737, 'longitude': -87.0043, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35053', 'place_name': 'Crane Hill', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.0821, 'longitude': -87.0484, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35055', 'place_name': 'Cullman', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.1761, 'longitude': -86.8298, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35056', 'place_name': 'Cullman', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.1748, 'longitude': -86.8436, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35057', 'place_name': 'Cullman', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.0878, 'longitude': -86.9447, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35058', 'place_name': 'Cullman', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.2098, 'longitude': -86.752, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35070', 'place_name': 'Garden City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.0058, 'longitude': -86.7499, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35077', 'place_name': 'Hanceville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.0516, 'longitude': -86.7848, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35083', 'place_name': 'Holly Pond', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.1901, 'longitude': -86.6174, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35087', 'place_name': 'Joppa', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.2837, 'longitude': -86.5519, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35098', 'place_name': 'Logan', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.1377, 'longitude': -87.0266, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35179', 'place_name': 'Vinemont', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Cullman', 'locality_code': '43', 'latitude': 34.2621, 'longitude': -86.9125, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36311', 'place_name': 'Ariton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dale', 'locality_code': '45', 'latitude': 31.583, 'longitude': -85.7077, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36317', 'place_name': 'Clopton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dale', 'locality_code': '45', 'latitude': 31.6446, 'longitude': -85.3911, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36322', 'place_name': 'Daleville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dale', 'locality_code': '45', 'latitude': 31.2811, 'longitude': -85.7305, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36350', 'place_name': 'Midland City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dale', 'locality_code': '45', 'latitude': 31.3191, 'longitude': -85.4938, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36352', 'place_name': 'Newton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dale', 'locality_code': '45', 'latitude': 31.3311, 'longitude': -85.5992, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36360', 'place_name': 'Ozark', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dale', 'locality_code': '45', 'latitude': 31.4391, 'longitude': -85.6436, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36361', 'place_name': 'Ozark', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dale', 'locality_code': '45', 'latitude': 31.4591, 'longitude': -85.6405, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36362', 'place_name': 'Fort Rucker', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dale', 'locality_code': '45', 'latitude': 31.348, 'longitude': -85.7214, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36371', 'place_name': 'Pinckard', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dale', 'locality_code': '45', 'latitude': 31.3074, 'longitude': -85.5263, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36374', 'place_name': 'Skipperville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dale', 'locality_code': '45', 'latitude': 31.5748, 'longitude': -85.537, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36701', 'place_name': 'Selma', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dallas', 'locality_code': '47', 'latitude': 32.4197, 'longitude': -87.0245, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36702', 'place_name': 'Selma', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dallas', 'locality_code': '47', 'latitude': 32.4074, 'longitude': -87.0211, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36703', 'place_name': 'Selma', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dallas', 'locality_code': '47', 'latitude': 32.4156, 'longitude': -87.0135, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36758', 'place_name': 'Plantersville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dallas', 'locality_code': '47', 'latitude': 32.6176, 'longitude': -86.9475, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36759', 'place_name': 'Marion Junction', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dallas', 'locality_code': '47', 'latitude': 32.4266, 'longitude': -87.2702, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36761', 'place_name': 'Minter', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dallas', 'locality_code': '47', 'latitude': 32.1899, 'longitude': -87.0633, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36767', 'place_name': 'Orrville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dallas', 'locality_code': '47', 'latitude': 32.2949, 'longitude': -87.2214, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36773', 'place_name': 'Safford', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dallas', 'locality_code': '47', 'latitude': 32.3002, 'longitude': -87.3693, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36775', 'place_name': 'Sardis', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dallas', 'locality_code': '47', 'latitude': 32.2844, 'longitude': -86.992, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36785', 'place_name': 'Tyler', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Dallas', 'locality_code': '47', 'latitude': 32.3239, 'longitude': -86.8646, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35961', 'place_name': 'Collinsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.268, 'longitude': -85.862, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35962', 'place_name': 'Crossville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.2588, 'longitude': -86.0306, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35963', 'place_name': 'Dawson', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.3568, 'longitude': -85.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35967', 'place_name': 'Fort Payne', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.4368, 'longitude': -85.7124, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35968', 'place_name': 'Fort Payne', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.4898, 'longitude': -85.7657, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35971', 'place_name': 'Fyffe', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.4373, 'longitude': -85.9288, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35974', 'place_name': 'Geraldine', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.3592, 'longitude': -86.024, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35975', 'place_name': 'Groveoak', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.4359, 'longitude': -86.04, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '35978', 'place_name': 'Henagar', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.6186, 'longitude': -85.7274, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35981', 'place_name': 'Ider', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.7351, 'longitude': -85.6416, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35984', 'place_name': 'Mentone', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.5872, 'longitude': -85.5777, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35986', 'place_name': 'Rainsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.4989, 'longitude': -85.8446, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35988', 'place_name': 'Sylvania', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.559, 'longitude': -85.7921, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35989', 'place_name': 'Valley Head', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'DeKalb', 'locality_code': '49', 'latitude': 34.5697, 'longitude': -85.6272, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36020', 'place_name': 'Coosada', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Elmore', 'locality_code': '51', 'latitude': 32.5056, 'longitude': -86.3322, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36022', 'place_name': 'Deatsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Elmore', 'locality_code': '51', 'latitude': 32.6082, 'longitude': -86.3958, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36024', 'place_name': 'Eclectic', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Elmore', 'locality_code': '51', 'latitude': 32.6542, 'longitude': -86.0316, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36025', 'place_name': 'Elmore', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Elmore', 'locality_code': '51', 'latitude': 32.5454, 'longitude': -86.3161, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36045', 'place_name': 'Kent', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Elmore', 'locality_code': '51', 'latitude': 32.619, 'longitude': -85.9486, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36054', 'place_name': 'Millbrook', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Elmore', 'locality_code': '51', 'latitude': 32.4995, 'longitude': -86.3641, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36078', 'place_name': 'Tallassee', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Elmore', 'locality_code': '51', 'latitude': 32.551, 'longitude': -85.8978, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36080', 'place_name': 'Titus', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Elmore', 'locality_code': '51', 'latitude': 32.69, 'longitude': -86.2393, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36092', 'place_name': 'Wetumpka', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Elmore', 'locality_code': '51', 'latitude': 32.5927, 'longitude': -86.2153, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36093', 'place_name': 'Wetumpka', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Elmore', 'locality_code': '51', 'latitude': 32.5622, 'longitude': -86.0994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36426', 'place_name': 'Brewton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Escambia', 'locality_code': '53', 'latitude': 31.1294, 'longitude': -87.0961, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36427', 'place_name': 'Brewton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Escambia', 'locality_code': '53', 'latitude': 31.1052, 'longitude': -87.0722, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36441', 'place_name': 'Flomaton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Escambia', 'locality_code': '53', 'latitude': 31.0402, 'longitude': -87.2664, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36502', 'place_name': 'Atmore', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Escambia', 'locality_code': '53', 'latitude': 31.0572, 'longitude': -87.4873, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36503', 'place_name': 'Atmore', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Escambia', 'locality_code': '53', 'latitude': 31.0238, 'longitude': -87.4939, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36504', 'place_name': 'Atmore', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Escambia', 'locality_code': '53', 'latitude': 31.0158, 'longitude': -87.4972, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36543', 'place_name': 'Huxford', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Escambia', 'locality_code': '53', 'latitude': 31.2202, 'longitude': -87.4619, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35901', 'place_name': 'Gadsden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 34.048, 'longitude': -85.9246, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35902', 'place_name': 'Gadsden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 34.0143, 'longitude': -86.0066, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35903', 'place_name': 'Gadsden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 33.9845, 'longitude': -85.9077, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35904', 'place_name': 'Gadsden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 34.0217, 'longitude': -86.0495, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35905', 'place_name': 'Gadsden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 33.9352, 'longitude': -85.9576, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35906', 'place_name': 'Rainbow City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 33.9318, 'longitude': -86.0898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35907', 'place_name': 'Gadsden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 33.8979, 'longitude': -86.0245, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35952', 'place_name': 'Altoona', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 34.071, 'longitude': -86.2096, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35954', 'place_name': 'Attalla', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 34.0296, 'longitude': -86.0967, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35972', 'place_name': 'Gallant', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 33.9976, 'longitude': -86.2346, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35990', 'place_name': 'Walnut Grove', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Etowah', 'locality_code': '55', 'latitude': 34.0657, 'longitude': -86.3064, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35542', 'place_name': 'Bankston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Fayette', 'locality_code': '57', 'latitude': 33.7008, 'longitude': -87.6897, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35545', 'place_name': 'Belk', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Fayette', 'locality_code': '57', 'latitude': 33.6476, 'longitude': -87.9314, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35546', 'place_name': 'Berry', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Fayette', 'locality_code': '57', 'latitude': 33.6945, 'longitude': -87.6226, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35555', 'place_name': 'Fayette', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Fayette', 'locality_code': '57', 'latitude': 33.6974, 'longitude': -87.8346, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35559', 'place_name': 'Glen Allen', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Fayette', 'locality_code': '57', 'latitude': 33.9151, 'longitude': -87.7417, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35571', 'place_name': 'Hodges', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Franklin', 'locality_code': '59', 'latitude': 34.3417, 'longitude': -87.959, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35581', 'place_name': 'Phil Campbell', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Franklin', 'locality_code': '59', 'latitude': 34.347, 'longitude': -87.7154, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35582', 'place_name': 'Red Bay', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Franklin', 'locality_code': '59', 'latitude': 34.4513, 'longitude': -88.1129, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35585', 'place_name': 'Spruce Pine', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Franklin', 'locality_code': '59', 'latitude': 34.4246, 'longitude': -87.8145, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35593', 'place_name': 'Vina', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Franklin', 'locality_code': '59', 'latitude': 34.3712, 'longitude': -88.0774, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35653', 'place_name': 'Russellville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Franklin', 'locality_code': '59', 'latitude': 34.5066, 'longitude': -87.7257, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35654', 'place_name': 'Russellville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Franklin', 'locality_code': '59', 'latitude': 34.4675, 'longitude': -87.6478, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36313', 'place_name': 'Bellwood', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Geneva', 'locality_code': '61', 'latitude': 31.1732, 'longitude': -85.7933, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36314', 'place_name': 'Black', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Geneva', 'locality_code': '61', 'latitude': 31.0132, 'longitude': -85.7456, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36316', 'place_name': 'Chancellor', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Geneva', 'locality_code': '61', 'latitude': 31.1767, 'longitude': -85.8135, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36318', 'place_name': 'Coffee Springs', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Geneva', 'locality_code': '61', 'latitude': 31.1388, 'longitude': -85.9182, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36340', 'place_name': 'Geneva', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Geneva', 'locality_code': '61', 'latitude': 31.0414, 'longitude': -85.8847, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36344', 'place_name': 'Hartford', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Geneva', 'locality_code': '61', 'latitude': 31.086, 'longitude': -85.7192, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36349', 'place_name': 'Malvern', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Geneva', 'locality_code': '61', 'latitude': 31.1212, 'longitude': -85.5592, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36375', 'place_name': 'Slocomb', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Geneva', 'locality_code': '61', 'latitude': 31.0956, 'longitude': -85.583, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36477', 'place_name': 'Samson', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Geneva', 'locality_code': '61', 'latitude': 31.1049, 'longitude': -86.0674, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35443', 'place_name': 'Boligee', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Greene', 'locality_code': '63', 'latitude': 32.7746, 'longitude': -88.0267, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35448', 'place_name': 'Clinton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Greene', 'locality_code': '63', 'latitude': 32.9137, 'longitude': -87.9925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35462', 'place_name': 'Eutaw', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Greene', 'locality_code': '63', 'latitude': 32.8889, 'longitude': -87.9303, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35469', 'place_name': 'Knoxville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Greene', 'locality_code': '63', 'latitude': 32.9824, 'longitude': -87.7919, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35491', 'place_name': 'West Greene', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Greene', 'locality_code': '63', 'latitude': 32.9237, 'longitude': -88.0853, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36740', 'place_name': 'Forkland', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Greene', 'locality_code': '63', 'latitude': 32.6108, 'longitude': -87.8441, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35441', 'place_name': 'Akron', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Hale', 'locality_code': '65', 'latitude': 32.8553, 'longitude': -87.7219, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35474', 'place_name': 'Moundville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Hale', 'locality_code': '65', 'latitude': 32.9108, 'longitude': -87.5935, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36742', 'place_name': 'Gallion', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Hale', 'locality_code': '65', 'latitude': 32.5298, 'longitude': -87.6985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36744', 'place_name': 'Greensboro', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Hale', 'locality_code': '65', 'latitude': 32.7167, 'longitude': -87.5905, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36765', 'place_name': 'Newbern', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Hale', 'locality_code': '65', 'latitude': 32.5515, 'longitude': -87.5615, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36776', 'place_name': 'Sawyerville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Hale', 'locality_code': '65', 'latitude': 32.7578, 'longitude': -87.7402, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36310', 'place_name': 'Abbeville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Henry', 'locality_code': '67', 'latitude': 31.5755, 'longitude': -85.279, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36345', 'place_name': 'Headland', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Henry', 'locality_code': '67', 'latitude': 31.3534, 'longitude': -85.3323, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36353', 'place_name': 'Newville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Henry', 'locality_code': '67', 'latitude': 31.4403, 'longitude': -85.3287, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36373', 'place_name': 'Shorterville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Henry', 'locality_code': '67', 'latitude': 31.501, 'longitude': -85.1135, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36301', 'place_name': 'Dothan', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.1481, 'longitude': -85.3718, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36302', 'place_name': 'Dothan', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.2232, 'longitude': -85.3905, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36303', 'place_name': 'Dothan', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.2668, 'longitude': -85.3971, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36304', 'place_name': 'Dothan', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.156, 'longitude': -85.3559, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36305', 'place_name': 'Dothan', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.2197, 'longitude': -85.4828, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36312', 'place_name': 'Ashford', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.1888, 'longitude': -85.2535, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36319', 'place_name': 'Columbia', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.3352, 'longitude': -85.1455, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36320', 'place_name': 'Cottonwood', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.0507, 'longitude': -85.3154, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36321', 'place_name': 'Cowarts', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.2025, 'longitude': -85.3014, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36343', 'place_name': 'Gordon', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.1002, 'longitude': -85.1234, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36370', 'place_name': 'Pansey', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.1403, 'longitude': -85.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36376', 'place_name': 'Webb', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Houston', 'locality_code': '69', 'latitude': 31.2656, 'longitude': -85.2544, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35740', 'place_name': 'Bridgeport', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.9446, 'longitude': -85.7277, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35744', 'place_name': 'Dutton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.6046, 'longitude': -85.9067, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35745', 'place_name': 'Estillfork', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.913, 'longitude': -86.1716, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35746', 'place_name': 'Fackler', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.8259, 'longitude': -85.9846, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35751', 'place_name': 'Hollytree', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.7955, 'longitude': -86.2743, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35752', 'place_name': 'Hollywood', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.7304, 'longitude': -85.9532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35755', 'place_name': 'Langston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.5001, 'longitude': -86.1353, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35764', 'place_name': 'Paint Rock', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.7031, 'longitude': -86.3068, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35765', 'place_name': 'Pisgah', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.6809, 'longitude': -85.8478, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35766', 'place_name': 'Princeton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.8713, 'longitude': -86.2513, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35768', 'place_name': 'Scottsboro', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.7507, 'longitude': -86.1422, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35769', 'place_name': 'Scottsboro', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.618, 'longitude': -86.0562, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35771', 'place_name': 'Section', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.5433, 'longitude': -85.994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35772', 'place_name': 'Stevenson', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.8769, 'longitude': -85.8508, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35774', 'place_name': 'Trenton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.7632, 'longitude': -86.2295, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35776', 'place_name': 'Woodville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.6689, 'longitude': -86.2296, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35958', 'place_name': 'Bryant', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.945, 'longitude': -85.6324, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35966', 'place_name': 'Flat Rock', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.8076, 'longitude': -85.7084, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35979', 'place_name': 'Higdon', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jackson', 'locality_code': '71', 'latitude': 34.8391, 'longitude': -85.6196, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35005', 'place_name': 'Adamsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5884, 'longitude': -86.9597, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35006', 'place_name': 'Adger', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4343, 'longitude': -87.1675, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35015', 'place_name': 'Alton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5793, 'longitude': -86.6375, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35020', 'place_name': 'Bessemer', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.409, 'longitude': -86.9475, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35021', 'place_name': 'Bessemer', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35022', 'place_name': 'Bessemer', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.3224, 'longitude': -86.9657, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35023', 'place_name': 'Bessemer', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.468, 'longitude': -87.0924, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35036', 'place_name': 'Brookside', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.6379, 'longitude': -86.9167, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35048', 'place_name': 'Clay', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.7026, 'longitude': -86.5997, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35060', 'place_name': 'Docena', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5589, 'longitude': -86.9294, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35061', 'place_name': 'Dolomite', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4654, 'longitude': -86.9564, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35064', 'place_name': 'Fairfield', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4735, 'longitude': -86.9183, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35068', 'place_name': 'Fultondale', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.6017, 'longitude': -86.8265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35071', 'place_name': 'Gardendale', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.7189, 'longitude': -86.8225, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35073', 'place_name': 'Graysville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.6539, 'longitude': -86.9803, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35091', 'place_name': 'Kimberly', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.7684, 'longitude': -86.8084, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35094', 'place_name': 'Leeds', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5283, 'longitude': -86.5748, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35111', 'place_name': 'Mc Calla', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.2845, 'longitude': -87.1024, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '35116', 'place_name': 'Morris', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.7392, 'longitude': -86.7726, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35117', 'place_name': 'Mount Olive', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.6768, 'longitude': -86.8717, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35118', 'place_name': 'Mulga', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5363, 'longitude': -87.051, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35119', 'place_name': 'New Castle', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.649, 'longitude': -86.7686, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35123', 'place_name': 'Palmerdale', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.7387, 'longitude': -86.6461, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35126', 'place_name': 'Pinson', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.7299, 'longitude': -86.6451, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35127', 'place_name': 'Pleasant Grove', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4883, 'longitude': -86.9766, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35139', 'place_name': 'Sayre', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.7111, 'longitude': -86.9759, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35142', 'place_name': 'Shannon', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4069, 'longitude': -86.8735, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35172', 'place_name': 'Trafford', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.819, 'longitude': -86.7434, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35173', 'place_name': 'Trussville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.6339, 'longitude': -86.5981, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35180', 'place_name': 'Warrior', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.8529, 'longitude': -86.8198, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35181', 'place_name': 'Watson', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35201', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5207, 'longitude': -86.8025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35202', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5207, 'longitude': -86.8025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35203', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.521, 'longitude': -86.8066, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35204', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5179, 'longitude': -86.8372, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35205', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4951, 'longitude': -86.8059, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35206', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5678, 'longitude': -86.7199, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35207', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5594, 'longitude': -86.8153, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35208', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4977, 'longitude': -86.8799, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35209', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4653, 'longitude': -86.8082, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35210', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5452, 'longitude': -86.6655, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35211', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4816, 'longitude': -86.859, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35212', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5409, 'longitude': -86.7495, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35213', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5066, 'longitude': -86.7428, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35214', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5554, 'longitude': -86.887, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35215', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.6493, 'longitude': -86.7057, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35216', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4188, 'longitude': -86.7867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35217', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5887, 'longitude': -86.765, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35218', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.506, 'longitude': -86.893, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35219', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35220', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35221', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4523, 'longitude': -86.8935, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35222', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5219, 'longitude': -86.7666, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35223', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4995, 'longitude': -86.7268, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35224', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5191, 'longitude': -86.9342, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35226', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.3967, 'longitude': -86.8346, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35228', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4558, 'longitude': -86.9118, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35229', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4629, 'longitude': -86.7904, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35231', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35232', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35233', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5062, 'longitude': -86.8003, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35234', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5378, 'longitude': -86.8068, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35235', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.6328, 'longitude': -86.6493, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35236', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35237', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5207, 'longitude': -86.8025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35238', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35243', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4459, 'longitude': -86.7502, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35244', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.3538, 'longitude': -86.8254, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35246', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5207, 'longitude': -86.8025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35249', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5207, 'longitude': -86.8025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35253', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35254', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35255', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35259', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35260', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35261', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35266', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.3729, 'longitude': -86.8531, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35270', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5206, 'longitude': -86.8025, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '35282', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35283', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5207, 'longitude': -86.8025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35285', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35287', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5207, 'longitude': -86.8025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35288', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.4458, 'longitude': -86.9285, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35290', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35291', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5207, 'longitude': -86.8025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35292', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5207, 'longitude': -86.8025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35293', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35294', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35295', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5207, 'longitude': -86.8025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35296', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35297', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35298', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Jefferson', 'locality_code': '73', 'latitude': 33.5446, 'longitude': -86.9292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35544', 'place_name': 'Beaverton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lamar', 'locality_code': '75', 'latitude': 33.9429, 'longitude': -88.0157, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35552', 'place_name': 'Detroit', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lamar', 'locality_code': '75', 'latitude': 34.0282, 'longitude': -88.17, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35574', 'place_name': 'Kennedy', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lamar', 'locality_code': '75', 'latitude': 33.6153, 'longitude': -87.9948, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35576', 'place_name': 'Millport', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lamar', 'locality_code': '75', 'latitude': 33.5401, 'longitude': -88.2, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35586', 'place_name': 'Sulligent', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lamar', 'locality_code': '75', 'latitude': 33.8549, 'longitude': -88.1508, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35592', 'place_name': 'Vernon', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lamar', 'locality_code': '75', 'latitude': 33.7613, 'longitude': -88.0979, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35610', 'place_name': 'Anderson', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.9424, 'longitude': -87.2734, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35617', 'place_name': 'Cloverdale', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.9387, 'longitude': -87.7714, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35630', 'place_name': 'Florence', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.8305, 'longitude': -87.656, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35631', 'place_name': 'Florence', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.87, 'longitude': -87.7069, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35632', 'place_name': 'Florence', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.87, 'longitude': -87.7069, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35633', 'place_name': 'Florence', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.8825, 'longitude': -87.7398, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35634', 'place_name': 'Florence', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.9186, 'longitude': -87.6136, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35645', 'place_name': 'Killen', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.9016, 'longitude': -87.5082, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35648', 'place_name': 'Lexington', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.9559, 'longitude': -87.3935, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35652', 'place_name': 'Rogersville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.8495, 'longitude': -87.3237, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35677', 'place_name': 'Waterloo', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lauderdale', 'locality_code': '77', 'latitude': 34.9357, 'longitude': -87.9624, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35618', 'place_name': 'Courtland', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lawrence', 'locality_code': '79', 'latitude': 34.6719, 'longitude': -87.3143, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35643', 'place_name': 'Hillsboro', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lawrence', 'locality_code': '79', 'latitude': 34.6476, 'longitude': -87.1804, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35650', 'place_name': 'Moulton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lawrence', 'locality_code': '79', 'latitude': 34.5058, 'longitude': -87.2224, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35651', 'place_name': 'Mount Hope', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lawrence', 'locality_code': '79', 'latitude': 34.4793, 'longitude': -87.4769, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35672', 'place_name': 'Town Creek', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lawrence', 'locality_code': '79', 'latitude': 34.6491, 'longitude': -87.4262, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36801', 'place_name': 'Opelika', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.6454, 'longitude': -85.3783, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36802', 'place_name': 'Opelika', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.5782, 'longitude': -85.349, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36803', 'place_name': 'Opelika', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.6454, 'longitude': -85.3783, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36804', 'place_name': 'Opelika', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.5768, 'longitude': -85.312, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36830', 'place_name': 'Auburn', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.5475, 'longitude': -85.4682, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36831', 'place_name': 'Auburn', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.6099, 'longitude': -85.4808, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36832', 'place_name': 'Auburn', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.592, 'longitude': -85.5189, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36849', 'place_name': 'Auburn University', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.6024, 'longitude': -85.4873, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36865', 'place_name': 'Loachapoka', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.6043, 'longitude': -85.5933, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36872', 'place_name': 'Valley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.5782, 'longitude': -85.349, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36874', 'place_name': 'Salem', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.6212, 'longitude': -85.184, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36877', 'place_name': 'Smiths Station', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.5401, 'longitude': -85.0985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36879', 'place_name': 'Waverly', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lee', 'locality_code': '81', 'latitude': 32.7632, 'longitude': -85.5144, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35611', 'place_name': 'Athens', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.8036, 'longitude': -86.9707, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35612', 'place_name': 'Athens', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.7749, 'longitude': -87.0305, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35613', 'place_name': 'Athens', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.8317, 'longitude': -86.8867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35614', 'place_name': 'Athens', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.8474, 'longitude': -87.0607, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35615', 'place_name': 'Belle Mina', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.6568, 'longitude': -86.8792, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35620', 'place_name': 'Elkmont', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.929, 'longitude': -86.9739, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35647', 'place_name': 'Lester', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.9596, 'longitude': -87.1006, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35649', 'place_name': 'Mooresville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.6259, 'longitude': -86.8746, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35671', 'place_name': 'Tanner', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.6796, 'longitude': -86.9625, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35739', 'place_name': 'Ardmore', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.9804, 'longitude': -86.8346, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35742', 'place_name': 'Capshaw', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Limestone', 'locality_code': '83', 'latitude': 34.7731, 'longitude': -86.7928, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36032', 'place_name': 'Fort Deposit', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lowndes', 'locality_code': '85', 'latitude': 31.996, 'longitude': -86.5761, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36040', 'place_name': 'Hayneville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lowndes', 'locality_code': '85', 'latitude': 32.1957, 'longitude': -86.655, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36047', 'place_name': 'Letohatchee', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lowndes', 'locality_code': '85', 'latitude': 32.0862, 'longitude': -86.488, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36752', 'place_name': 'Lowndesboro', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Lowndes', 'locality_code': '85', 'latitude': 32.2943, 'longitude': -86.6471, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36031', 'place_name': 'Fort Davis', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Macon', 'locality_code': '87', 'latitude': 32.2507, 'longitude': -85.7524, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36039', 'place_name': 'Hardaway', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Macon', 'locality_code': '87', 'latitude': 32.3129, 'longitude': -85.8838, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36075', 'place_name': 'Shorter', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Macon', 'locality_code': '87', 'latitude': 32.3836, 'longitude': -85.9162, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36083', 'place_name': 'Tuskegee', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Macon', 'locality_code': '87', 'latitude': 32.4316, 'longitude': -85.6861, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36087', 'place_name': 'Tuskegee Institute', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Macon', 'locality_code': '87', 'latitude': 32.4093, 'longitude': -85.738, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '36088', 'place_name': 'Tuskegee Institute', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Macon', 'locality_code': '87', 'latitude': 32.4145, 'longitude': -85.7253, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '36866', 'place_name': 'Notasulga', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Macon', 'locality_code': '87', 'latitude': 32.5437, 'longitude': -85.6871, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35741', 'place_name': 'Brownsboro', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7167, 'longitude': -86.4687, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35748', 'place_name': 'Gurley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.714, 'longitude': -86.394, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35749', 'place_name': 'Harvest', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.8273, 'longitude': -86.7499, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35750', 'place_name': 'Hazel Green', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.9496, 'longitude': -86.5935, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35756', 'place_name': 'Madison', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.643, 'longitude': -86.8168, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35757', 'place_name': 'Madison', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7782, 'longitude': -86.7442, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35758', 'place_name': 'Madison', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7108, 'longitude': -86.7425, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35759', 'place_name': 'Meridianville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.8618, 'longitude': -86.5789, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35760', 'place_name': 'New Hope', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.5494, 'longitude': -86.3961, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35761', 'place_name': 'New Market', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.9, 'longitude': -86.4487, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35762', 'place_name': 'Normal', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.789, 'longitude': -86.5719, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35763', 'place_name': 'Owens Cross Roads', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.6215, 'longitude': -86.4644, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35767', 'place_name': 'Ryland', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7698, 'longitude': -86.4808, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35773', 'place_name': 'Toney', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.9116, 'longitude': -86.7, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35801', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7269, 'longitude': -86.5673, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35802', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.6679, 'longitude': -86.5603, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35803', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.6205, 'longitude': -86.551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35804', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7284, 'longitude': -86.5853, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35805', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7059, 'longitude': -86.6165, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35806', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7448, 'longitude': -86.6704, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35807', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.734, 'longitude': -86.5229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35808', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.6845, 'longitude': -86.6538, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35809', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.734, 'longitude': -86.5229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35810', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7784, 'longitude': -86.6091, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35811', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7789, 'longitude': -86.5438, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35812', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.734, 'longitude': -86.5229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35813', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.734, 'longitude': -86.5229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35814', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.734, 'longitude': -86.5229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35815', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.734, 'longitude': -86.5229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35816', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7389, 'longitude': -86.6249, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35824', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.6583, 'longitude': -86.7295, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35893', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7304, 'longitude': -86.5861, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35894', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.734, 'longitude': -86.5229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35895', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7304, 'longitude': -86.5861, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35896', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7543, 'longitude': -86.6546, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35897', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.734, 'longitude': -86.5229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35898', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.734, 'longitude': -86.5229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35899', 'place_name': 'Huntsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Madison', 'locality_code': '89', 'latitude': 34.7339, 'longitude': -86.6456, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36732', 'place_name': 'Demopolis', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marengo', 'locality_code': '91', 'latitude': 32.4908, 'longitude': -87.8397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36736', 'place_name': 'Dixons Mills', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marengo', 'locality_code': '91', 'latitude': 32.0672, 'longitude': -87.7454, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36738', 'place_name': 'Faunsdale', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marengo', 'locality_code': '91', 'latitude': 32.4233, 'longitude': -87.6181, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36745', 'place_name': 'Jefferson', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marengo', 'locality_code': '91', 'latitude': 32.414, 'longitude': -87.8986, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36748', 'place_name': 'Linden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marengo', 'locality_code': '91', 'latitude': 32.3053, 'longitude': -87.7954, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36754', 'place_name': 'Magnolia', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marengo', 'locality_code': '91', 'latitude': 32.1419, 'longitude': -87.6998, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36763', 'place_name': 'Myrtlewood', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marengo', 'locality_code': '91', 'latitude': 32.2516, 'longitude': -87.9494, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36764', 'place_name': 'Nanafalia', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marengo', 'locality_code': '91', 'latitude': 32.1129, 'longitude': -87.9881, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36782', 'place_name': 'Sweet Water', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marengo', 'locality_code': '91', 'latitude': 32.0773, 'longitude': -87.9228, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36783', 'place_name': 'Thomaston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marengo', 'locality_code': '91', 'latitude': 32.2538, 'longitude': -87.5974, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35543', 'place_name': 'Bear Creek', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marion', 'locality_code': '93', 'latitude': 34.1649, 'longitude': -87.7396, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35548', 'place_name': 'Brilliant', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marion', 'locality_code': '93', 'latitude': 34.0377, 'longitude': -87.7563, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35563', 'place_name': 'Guin', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marion', 'locality_code': '93', 'latitude': 33.9676, 'longitude': -87.9024, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35564', 'place_name': 'Hackleburg', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marion', 'locality_code': '93', 'latitude': 34.2678, 'longitude': -87.8608, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35570', 'place_name': 'Hamilton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marion', 'locality_code': '93', 'latitude': 34.1534, 'longitude': -88.0085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35594', 'place_name': 'Winfield', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marion', 'locality_code': '93', 'latitude': 33.9303, 'longitude': -87.7972, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35016', 'place_name': 'Arab', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marshall', 'locality_code': '95', 'latitude': 34.3283, 'longitude': -86.4896, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35175', 'place_name': 'Union Grove', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marshall', 'locality_code': '95', 'latitude': 34.4093, 'longitude': -86.4628, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35747', 'place_name': 'Grant', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marshall', 'locality_code': '95', 'latitude': 34.4959, 'longitude': -86.259, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35950', 'place_name': 'Albertville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marshall', 'locality_code': '95', 'latitude': 34.2739, 'longitude': -86.2064, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35951', 'place_name': 'Albertville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marshall', 'locality_code': '95', 'latitude': 34.3223, 'longitude': -86.1935, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35956', 'place_name': 'Boaz', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marshall', 'locality_code': '95', 'latitude': 34.1437, 'longitude': -86.148, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35957', 'place_name': 'Boaz', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marshall', 'locality_code': '95', 'latitude': 34.1921, 'longitude': -86.1941, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35964', 'place_name': 'Douglas', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marshall', 'locality_code': '95', 'latitude': 34.1737, 'longitude': -86.3236, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35976', 'place_name': 'Guntersville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marshall', 'locality_code': '95', 'latitude': 34.3449, 'longitude': -86.2752, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35980', 'place_name': 'Horton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Marshall', 'locality_code': '95', 'latitude': 34.19, 'longitude': -86.3173, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36421', 'place_name': 'Andalusia', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 31.3247, 'longitude': -86.5067, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36505', 'place_name': 'Axis', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.9394, 'longitude': -88.0159, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36509', 'place_name': 'Bayou La Batre', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.408, 'longitude': -88.2507, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36512', 'place_name': 'Bucks', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 31.0105, 'longitude': -88.0242, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36521', 'place_name': 'Chunchula', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.9912, 'longitude': -88.1311, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36522', 'place_name': 'Citronelle', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 31.0425, 'longitude': -88.2549, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36523', 'place_name': 'Coden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.3903, 'longitude': -88.2076, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36525', 'place_name': 'Creola', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.9013, 'longitude': -88.0174, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36528', 'place_name': 'Dauphin Island', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.2521, 'longitude': -88.1096, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36541', 'place_name': 'Grand Bay', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.4983, 'longitude': -88.3282, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36544', 'place_name': 'Irvington', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.4802, 'longitude': -88.2396, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36560', 'place_name': 'Mount Vernon', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 31.0974, 'longitude': -88.035, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36568', 'place_name': 'Saint Elmo', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.5035, 'longitude': -88.2542, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36571', 'place_name': 'Saraland', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.8332, 'longitude': -88.0934, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36572', 'place_name': 'Satsuma', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.8516, 'longitude': -88.0533, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36575', 'place_name': 'Semmes', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.7544, 'longitude': -88.2667, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36582', 'place_name': 'Theodore', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.5444, 'longitude': -88.1807, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36587', 'place_name': 'Wilmer', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.8137, 'longitude': -88.3332, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36590', 'place_name': 'Theodore', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.488, 'longitude': -88.2533, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36601', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6944, 'longitude': -88.0431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36602', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6888, 'longitude': -88.0453, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36603', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6921, 'longitude': -88.0562, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36604', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.682, 'longitude': -88.0678, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36605', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6341, 'longitude': -88.0846, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36606', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6729, 'longitude': -88.1009, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36607', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6975, 'longitude': -88.1029, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36608', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6817, 'longitude': -88.2945, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36609', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6605, 'longitude': -88.1618, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36610', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.7309, 'longitude': -88.0789, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36611', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.7705, 'longitude': -88.0781, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36612', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.7518, 'longitude': -88.1131, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36613', 'place_name': 'Eight Mile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.7951, 'longitude': -88.1823, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36615', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6411, 'longitude': -88.0622, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36616', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.671, 'longitude': -88.1267, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36617', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.7145, 'longitude': -88.0918, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36618', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.7322, 'longitude': -88.1758, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36619', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.5928, 'longitude': -88.1946, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36628', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6944, 'longitude': -88.0431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36633', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6589, 'longitude': -88.178, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36640', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6589, 'longitude': -88.178, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36641', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6589, 'longitude': -88.178, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36644', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6944, 'longitude': -88.0431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36652', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6944, 'longitude': -88.0431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36660', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6589, 'longitude': -88.178, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36663', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6944, 'longitude': -88.0431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36670', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6589, 'longitude': -88.178, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36671', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6589, 'longitude': -88.178, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36675', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6944, 'longitude': -88.0431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36685', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6589, 'longitude': -88.178, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36688', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6962, 'longitude': -88.1821, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36689', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6589, 'longitude': -88.178, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36691', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6944, 'longitude': -88.0431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36693', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6311, 'longitude': -88.1588, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36695', 'place_name': 'Mobile', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Mobile', 'locality_code': '97', 'latitude': 30.6474, 'longitude': -88.2292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36425', 'place_name': 'Beatrice', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.7273, 'longitude': -87.1719, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36439', 'place_name': 'Excel', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.4279, 'longitude': -87.3414, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36444', 'place_name': 'Franklin', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.7238, 'longitude': -87.4412, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36445', 'place_name': 'Frisco City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.4235, 'longitude': -87.3817, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36449', 'place_name': 'Goodway', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.3368, 'longitude': -87.4258, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36457', 'place_name': 'Megargel', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.3612, 'longitude': -87.4353, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36458', 'place_name': 'Mexia', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.5147, 'longitude': -87.4084, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36460', 'place_name': 'Monroeville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.5153, 'longitude': -87.341, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36461', 'place_name': 'Monroeville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.5221, 'longitude': -87.3411, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36470', 'place_name': 'Perdue Hill', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.5141, 'longitude': -87.4933, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36471', 'place_name': 'Peterman', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.59, 'longitude': -87.26, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36480', 'place_name': 'Uriah', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.3135, 'longitude': -87.5705, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36481', 'place_name': 'Vredenburgh', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Monroe', 'locality_code': '99', 'latitude': 31.8085, 'longitude': -87.3164, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36013', 'place_name': 'Cecil', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2937, 'longitude': -85.9827, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36036', 'place_name': 'Grady', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.0194, 'longitude': -86.1292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36043', 'place_name': 'Hope Hull', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2243, 'longitude': -86.3932, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36046', 'place_name': 'Lapine', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 31.9657, 'longitude': -86.2844, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36052', 'place_name': 'Mathews', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.1283, 'longitude': -86.0413, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '36057', 'place_name': 'Mount Meigs', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36064', 'place_name': 'Pike Road', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3357, 'longitude': -86.0959, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36065', 'place_name': 'Pine Level', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.0726, 'longitude': -86.0606, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36069', 'place_name': 'Ramer', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.0677, 'longitude': -86.2463, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36101', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.357, 'longitude': -86.2578, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36102', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36103', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3462, 'longitude': -86.2873, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36104', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.373, 'longitude': -86.3081, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36105', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3257, 'longitude': -86.3104, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36106', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3543, 'longitude': -86.2673, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36107', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3804, 'longitude': -86.2799, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36108', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3417, 'longitude': -86.3529, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36109', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3834, 'longitude': -86.2434, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36110', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.4217, 'longitude': -86.275, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36111', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3374, 'longitude': -86.2715, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36112', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3808, 'longitude': -86.3491, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36113', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3846, 'longitude': -86.3039, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36114', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.404, 'longitude': -86.2539, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36115', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.4076, 'longitude': -86.2474, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36116', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3129, 'longitude': -86.2421, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36117', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3736, 'longitude': -86.1833, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36118', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36119', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36120', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36121', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36123', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.3668, 'longitude': -86.3, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36124', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36125', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36130', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36131', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36132', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36135', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36140', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36141', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36142', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36177', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36191', 'place_name': 'Montgomery', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Montgomery', 'locality_code': '101', 'latitude': 32.2334, 'longitude': -86.2085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35601', 'place_name': 'Decatur', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.5896, 'longitude': -86.9887, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35602', 'place_name': 'Decatur', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.6059, 'longitude': -86.9833, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35603', 'place_name': 'Decatur', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.5484, 'longitude': -87.0004, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35609', 'place_name': 'Decatur', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.6059, 'longitude': -86.9833, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35619', 'place_name': 'Danville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.3873, 'longitude': -87.1454, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35621', 'place_name': 'Eva', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.3323, 'longitude': -86.7589, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35622', 'place_name': 'Falkville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.3477, 'longitude': -86.9131, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35640', 'place_name': 'Hartselle', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.4482, 'longitude': -86.9242, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35670', 'place_name': 'Somerville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.4995, 'longitude': -86.8009, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35673', 'place_name': 'Trinity', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.5918, 'longitude': -87.0913, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35699', 'place_name': 'Decatur', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.6059, 'longitude': -86.9833, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35754', 'place_name': 'Laceys Spring', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.4996, 'longitude': -86.6129, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35775', 'place_name': 'Valhermoso Springs', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Morgan', 'locality_code': '103', 'latitude': 34.542, 'longitude': -86.6871, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36756', 'place_name': 'Marion', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Perry', 'locality_code': '105', 'latitude': 32.6463, 'longitude': -87.3314, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36786', 'place_name': 'Uniontown', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Perry', 'locality_code': '105', 'latitude': 32.447, 'longitude': -87.4934, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35442', 'place_name': 'Aliceville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pickens', 'locality_code': '107', 'latitude': 33.1228, 'longitude': -88.1667, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35447', 'place_name': 'Carrollton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pickens', 'locality_code': '107', 'latitude': 33.2485, 'longitude': -88.1321, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35461', 'place_name': 'Ethelsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pickens', 'locality_code': '107', 'latitude': 33.4157, 'longitude': -88.2167, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35466', 'place_name': 'Gordo', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pickens', 'locality_code': '107', 'latitude': 33.3469, 'longitude': -87.9005, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35471', 'place_name': 'Mc Shan', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pickens', 'locality_code': '107', 'latitude': 33.2626, 'longitude': -88.0885, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '35481', 'place_name': 'Reform', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pickens', 'locality_code': '107', 'latitude': 33.3959, 'longitude': -88.0203, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36005', 'place_name': 'Banks', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pike', 'locality_code': '109', 'latitude': 31.8368, 'longitude': -85.7998, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36010', 'place_name': 'Brundidge', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pike', 'locality_code': '109', 'latitude': 31.7013, 'longitude': -85.8177, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36035', 'place_name': 'Goshen', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pike', 'locality_code': '109', 'latitude': 31.7946, 'longitude': -86.1277, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36079', 'place_name': 'Troy', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pike', 'locality_code': '109', 'latitude': 31.7595, 'longitude': -86.0107, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36081', 'place_name': 'Troy', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pike', 'locality_code': '109', 'latitude': 31.7945, 'longitude': -85.9655, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36082', 'place_name': 'Troy', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Pike', 'locality_code': '109', 'latitude': 31.8028, 'longitude': -85.9546, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36263', 'place_name': 'Graham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Randolph', 'locality_code': '111', 'latitude': 33.463, 'longitude': -85.334, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36274', 'place_name': 'Roanoke', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Randolph', 'locality_code': '111', 'latitude': 33.1512, 'longitude': -85.3722, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36276', 'place_name': 'Wadley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Randolph', 'locality_code': '111', 'latitude': 33.1492, 'longitude': -85.5513, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36278', 'place_name': 'Wedowee', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Randolph', 'locality_code': '111', 'latitude': 33.3019, 'longitude': -85.4737, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36280', 'place_name': 'Woodland', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Randolph', 'locality_code': '111', 'latitude': 33.3743, 'longitude': -85.3997, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36851', 'place_name': 'Cottonton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.1468, 'longitude': -85.0738, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36856', 'place_name': 'Fort Mitchell', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.2965, 'longitude': -84.9972, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36858', 'place_name': 'Hatchechubbee', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.2845, 'longitude': -85.3029, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36859', 'place_name': 'Holy Trinity', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.2298, 'longitude': -85.0082, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36860', 'place_name': 'Hurtsboro', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.2454, 'longitude': -85.3959, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36867', 'place_name': 'Phenix City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.4978, 'longitude': -85.0234, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36868', 'place_name': 'Phenix City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.4646, 'longitude': -85.0206, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36869', 'place_name': 'Phenix City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.4204, 'longitude': -85.0796, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36870', 'place_name': 'Phenix City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.4781, 'longitude': -85.124, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36871', 'place_name': 'Pittsview', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.1733, 'longitude': -85.1312, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36875', 'place_name': 'Seale', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Russell', 'locality_code': '113', 'latitude': 32.3053, 'longitude': -85.1677, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35004', 'place_name': 'Moody', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.6035, 'longitude': -86.4668, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35052', 'place_name': 'Cook Springs', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.5895, 'longitude': -86.3923, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35054', 'place_name': 'Cropwell', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.5296, 'longitude': -86.3007, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35112', 'place_name': 'Margaret', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.6862, 'longitude': -86.475, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35120', 'place_name': 'Odenville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.6756, 'longitude': -86.409, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35125', 'place_name': 'Pell City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.5979, 'longitude': -86.3432, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35128', 'place_name': 'Pell City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.5873, 'longitude': -86.3366, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35131', 'place_name': 'Ragland', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.7367, 'longitude': -86.1619, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35135', 'place_name': 'Riverside', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.6166, 'longitude': -86.1996, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35146', 'place_name': 'Springville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.7386, 'longitude': -86.4394, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35182', 'place_name': 'Wattsville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.7068, 'longitude': -86.2567, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35953', 'place_name': 'Ashville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.8374, 'longitude': -86.2552, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35987', 'place_name': 'Steele', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'St. Clair', 'locality_code': '115', 'latitude': 33.9417, 'longitude': -86.2289, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35007', 'place_name': 'Alabaster', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.1934, 'longitude': -86.7944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35040', 'place_name': 'Calera', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.1098, 'longitude': -86.756, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35043', 'place_name': 'Chelsea', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.2982, 'longitude': -86.6563, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35051', 'place_name': 'Columbiana', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.177, 'longitude': -86.6161, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35078', 'place_name': 'Harpersville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.3234, 'longitude': -86.4424, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35080', 'place_name': 'Helena', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.2663, 'longitude': -86.902, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35114', 'place_name': 'Maylene', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.2317, 'longitude': -86.8727, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35115', 'place_name': 'Montevallo', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.1248, 'longitude': -86.8622, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35124', 'place_name': 'Pelham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.2932, 'longitude': -86.768, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35137', 'place_name': 'Saginaw', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.2063, 'longitude': -86.7812, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35143', 'place_name': 'Shelby', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.0785, 'longitude': -86.5536, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35144', 'place_name': 'Siluria', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.2293, 'longitude': -86.825, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35147', 'place_name': 'Sterrett', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.4461, 'longitude': -86.4917, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35176', 'place_name': 'Vandiver', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.4807, 'longitude': -86.5013, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35178', 'place_name': 'Vincent', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.401, 'longitude': -86.3994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35185', 'place_name': 'Westover', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.3356, 'longitude': -86.5437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35186', 'place_name': 'Wilsonville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.2293, 'longitude': -86.5299, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35187', 'place_name': 'Wilton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.081, 'longitude': -86.8793, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35242', 'place_name': 'Birmingham', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Shelby', 'locality_code': '117', 'latitude': 33.3813, 'longitude': -86.7046, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35459', 'place_name': 'Emelle', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Sumter', 'locality_code': '119', 'latitude': 32.755, 'longitude': -88.3057, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35460', 'place_name': 'Epes', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Sumter', 'locality_code': '119', 'latitude': 32.672, 'longitude': -88.1206, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35464', 'place_name': 'Gainesville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Sumter', 'locality_code': '119', 'latitude': 32.821, 'longitude': -88.1589, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35470', 'place_name': 'Livingston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Sumter', 'locality_code': '119', 'latitude': 32.5843, 'longitude': -88.1872, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35477', 'place_name': 'Panola', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Sumter', 'locality_code': '119', 'latitude': 32.8726, 'longitude': -88.2374, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36901', 'place_name': 'Bellamy', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Sumter', 'locality_code': '119', 'latitude': 32.449, 'longitude': -88.1336, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36907', 'place_name': 'Cuba', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Sumter', 'locality_code': '119', 'latitude': 32.411, 'longitude': -88.3611, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36925', 'place_name': 'York', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Sumter', 'locality_code': '119', 'latitude': 32.4728, 'longitude': -88.2683, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35014', 'place_name': 'Alpine', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Talladega', 'locality_code': '121', 'latitude': 33.404, 'longitude': -86.2339, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35032', 'place_name': 'Bon Air', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Talladega', 'locality_code': '121', 'latitude': 33.2649, 'longitude': -86.3364, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35044', 'place_name': 'Childersburg', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Talladega', 'locality_code': '121', 'latitude': 33.2459, 'longitude': -86.3641, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35096', 'place_name': 'Lincoln', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Talladega', 'locality_code': '121', 'latitude': 33.6059, 'longitude': -86.1112, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35149', 'place_name': 'Sycamore', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Talladega', 'locality_code': '121', 'latitude': 33.2512, 'longitude': -86.2025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35150', 'place_name': 'Sylacauga', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Talladega', 'locality_code': '121', 'latitude': 33.1717, 'longitude': -86.2713, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35151', 'place_name': 'Sylacauga', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Talladega', 'locality_code': '121', 'latitude': 33.1756, 'longitude': -86.3574, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35160', 'place_name': 'Talladega', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Talladega', 'locality_code': '121', 'latitude': 33.4354, 'longitude': -86.1134, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35161', 'place_name': 'Talladega', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Talladega', 'locality_code': '121', 'latitude': 33.4202, 'longitude': -86.1028, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36268', 'place_name': 'Munford', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Talladega', 'locality_code': '121', 'latitude': 33.541, 'longitude': -85.9363, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35010', 'place_name': 'Alexander City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tallapoosa', 'locality_code': '123', 'latitude': 32.9164, 'longitude': -85.9368, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35011', 'place_name': 'Alexander City', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tallapoosa', 'locality_code': '123', 'latitude': 32.9902, 'longitude': -85.958, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36023', 'place_name': 'East Tallassee', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tallapoosa', 'locality_code': '123', 'latitude': 32.8002, 'longitude': -85.8034, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '36256', 'place_name': 'Daviston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tallapoosa', 'locality_code': '123', 'latitude': 33.0335, 'longitude': -85.7538, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36850', 'place_name': 'Camp Hill', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tallapoosa', 'locality_code': '123', 'latitude': 32.7827, 'longitude': -85.6474, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36853', 'place_name': 'Dadeville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tallapoosa', 'locality_code': '123', 'latitude': 32.8224, 'longitude': -85.7704, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36861', 'place_name': 'Jacksons Gap', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tallapoosa', 'locality_code': '123', 'latitude': 32.8797, 'longitude': -85.8487, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35401', 'place_name': 'Tuscaloosa', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.1969, 'longitude': -87.5627, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35402', 'place_name': 'Tuscaloosa', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.3066, 'longitude': -87.4532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35403', 'place_name': 'Tuscaloosa', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.2045, 'longitude': -87.527, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35404', 'place_name': 'Tuscaloosa', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.1826, 'longitude': -87.4827, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35405', 'place_name': 'Tuscaloosa', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.1617, 'longitude': -87.5144, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35406', 'place_name': 'Tuscaloosa', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.2722, 'longitude': -87.536, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35407', 'place_name': 'Tuscaloosa', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.3066, 'longitude': -87.4532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35440', 'place_name': 'Abernant', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.311, 'longitude': -87.1898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35444', 'place_name': 'Brookwood', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.2775, 'longitude': -87.309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35446', 'place_name': 'Buhl', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.2306, 'longitude': -87.7547, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35449', 'place_name': 'Coaling', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.1359, 'longitude': -87.3384, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35452', 'place_name': 'Coker', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.2934, 'longitude': -87.6888, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35453', 'place_name': 'Cottondale', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.1767, 'longitude': -87.3871, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35456', 'place_name': 'Duncanville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.0618, 'longitude': -87.4422, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35457', 'place_name': 'Echola', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.294, 'longitude': -87.7766, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35458', 'place_name': 'Elrod', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.2562, 'longitude': -87.7922, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35463', 'place_name': 'Fosters', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.0843, 'longitude': -87.6975, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35468', 'place_name': 'Kellerman', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.3407, 'longitude': -87.3047, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35473', 'place_name': 'Northport', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.2723, 'longitude': -87.5825, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35475', 'place_name': 'Northport', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.3992, 'longitude': -87.5599, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35476', 'place_name': 'Northport', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.2273, 'longitude': -87.5943, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35478', 'place_name': 'Peterson', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.3066, 'longitude': -87.4532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35480', 'place_name': 'Ralph', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.1274, 'longitude': -87.7624, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35482', 'place_name': 'Samantha', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.3066, 'longitude': -87.4532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35486', 'place_name': 'Tuscaloosa', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.2098, 'longitude': -87.5692, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35487', 'place_name': 'Tuscaloosa', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.3072, 'longitude': -87.5859, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35490', 'place_name': 'Vance', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Tuscaloosa', 'locality_code': '125', 'latitude': 33.175, 'longitude': -87.2574, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35038', 'place_name': 'Burnwell', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.7079, 'longitude': -87.0875, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35062', 'place_name': 'Dora', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.7357, 'longitude': -87.0546, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35063', 'place_name': 'Empire', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.8256, 'longitude': -87.0161, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35130', 'place_name': 'Quinton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.6561, 'longitude': -87.1007, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35148', 'place_name': 'Sumiton', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.768, 'longitude': -87.0445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35501', 'place_name': 'Jasper', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.8312, 'longitude': -87.2775, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35502', 'place_name': 'Jasper', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.8312, 'longitude': -87.2775, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35503', 'place_name': 'Jasper', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.9152, 'longitude': -87.3074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35504', 'place_name': 'Jasper', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.8927, 'longitude': -87.1667, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35549', 'place_name': 'Carbon Hill', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.9093, 'longitude': -87.5403, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35550', 'place_name': 'Cordova', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.768, 'longitude': -87.1841, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35554', 'place_name': 'Eldridge', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.9315, 'longitude': -87.6194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35560', 'place_name': 'Goodsprings', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.6795, 'longitude': -87.2374, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35573', 'place_name': 'Kansas', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.9018, 'longitude': -87.552, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35578', 'place_name': 'Nauvoo', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.9299, 'longitude': -87.4324, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35579', 'place_name': 'Oakman', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.7002, 'longitude': -87.3686, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35580', 'place_name': 'Parrish', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.7213, 'longitude': -87.2658, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35584', 'place_name': 'Sipsey', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.8201, 'longitude': -87.0779, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35587', 'place_name': 'Townley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Walker', 'locality_code': '127', 'latitude': 33.847, 'longitude': -87.4372, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36513', 'place_name': 'Calvert', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.1552, 'longitude': -88.01, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36518', 'place_name': 'Chatom', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.4876, 'longitude': -88.2699, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36529', 'place_name': 'Deer Park', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.2168, 'longitude': -88.3172, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36538', 'place_name': 'Frankville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.6468, 'longitude': -88.1332, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36539', 'place_name': 'Fruitdale', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.3488, 'longitude': -88.3766, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36548', 'place_name': 'Leroy', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.491, 'longitude': -87.9687, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36553', 'place_name': 'Mc Intosh', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.2361, 'longitude': -88.0511, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '36556', 'place_name': 'Malcolm', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.1913, 'longitude': -88.0075, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36558', 'place_name': 'Millry', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.6269, 'longitude': -88.3559, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36569', 'place_name': 'Saint Stephens', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.533, 'longitude': -88.0521, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36581', 'place_name': 'Sunflower', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.3696, 'longitude': -88.0122, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36583', 'place_name': 'Tibbie', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.4067, 'longitude': -88.1758, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36584', 'place_name': 'Vinegar Bend', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.2584, 'longitude': -88.3865, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36585', 'place_name': 'Wagarville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Washington', 'locality_code': '129', 'latitude': 31.4102, 'longitude': -88.0705, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36435', 'place_name': 'Coy', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 31.8889, 'longitude': -87.3926, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36720', 'place_name': 'Alberta', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 32.1585, 'longitude': -87.3468, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36722', 'place_name': 'Arlington', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 32.0668, 'longitude': -87.5597, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36723', 'place_name': 'Boykin', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 32.0779, 'longitude': -87.2814, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36726', 'place_name': 'Camden', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 32.0047, 'longitude': -87.295, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36728', 'place_name': 'Catherine', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 32.182, 'longitude': -87.4836, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36741', 'place_name': 'Furman', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 32.0061, 'longitude': -86.9817, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36751', 'place_name': 'Lower Peach Tree', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 31.8504, 'longitude': -87.5682, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36753', 'place_name': 'Mc Williams', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 32.0481, 'longitude': -87.2623, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '36766', 'place_name': 'Oak Hill', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 31.947, 'longitude': -87.0745, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36768', 'place_name': 'Pine Apple', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 31.9265, 'longitude': -87.0047, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '36769', 'place_name': 'Pine Hill', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Wilcox', 'locality_code': '131', 'latitude': 31.9735, 'longitude': -87.5771, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35540', 'place_name': 'Addison', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Winston', 'locality_code': '133', 'latitude': 34.2056, 'longitude': -87.1948, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35541', 'place_name': 'Arley', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Winston', 'locality_code': '133', 'latitude': 34.0632, 'longitude': -87.1828, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35551', 'place_name': 'Delmar', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Winston', 'locality_code': '133', 'latitude': 34.1701, 'longitude': -87.6059, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35553', 'place_name': 'Double Springs', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Winston', 'locality_code': '133', 'latitude': 34.1387, 'longitude': -87.3974, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35565', 'place_name': 'Haleyville', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Winston', 'locality_code': '133', 'latitude': 34.2314, 'longitude': -87.5938, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35572', 'place_name': 'Houston', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Winston', 'locality_code': '133', 'latitude': 34.118, 'longitude': -87.2618, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35575', 'place_name': 'Lynn', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Winston', 'locality_code': '133', 'latitude': 34.053, 'longitude': -87.5398, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '35577', 'place_name': 'Natural Bridge', 'state': 'Alabama', 'state_ab': 'AL', 'county': 'Winston', 'locality_code': '133', 'latitude': 34.0934, 'longitude': -87.6008, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72003', 'place_name': 'Almyra', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Arkansas', 'locality_code': '1', 'latitude': 34.4146, 'longitude': -91.431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72026', 'place_name': 'Casscoe', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Arkansas', 'locality_code': '1', 'latitude': 34.5095, 'longitude': -91.299, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72038', 'place_name': 'Crocketts Bluff', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Arkansas', 'locality_code': '1', 'latitude': 34.4528, 'longitude': -91.2692, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72042', 'place_name': 'De Witt', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Arkansas', 'locality_code': '1', 'latitude': 34.2853, 'longitude': -91.3336, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72048', 'place_name': 'Ethel', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Arkansas', 'locality_code': '1', 'latitude': 34.2435, 'longitude': -91.1398, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72055', 'place_name': 'Gillett', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Arkansas', 'locality_code': '1', 'latitude': 34.1218, 'longitude': -91.38, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72073', 'place_name': 'Humphrey', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Arkansas', 'locality_code': '1', 'latitude': 34.4034, 'longitude': -91.679, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72140', 'place_name': 'Saint Charles', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Arkansas', 'locality_code': '1', 'latitude': 34.3878, 'longitude': -91.1463, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72160', 'place_name': 'Stuttgart', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Arkansas', 'locality_code': '1', 'latitude': 34.4854, 'longitude': -91.5487, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72166', 'place_name': 'Tichnor', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Arkansas', 'locality_code': '1', 'latitude': 34.0893, 'longitude': -91.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71635', 'place_name': 'Crossett', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ashley', 'locality_code': '3', 'latitude': 33.156, 'longitude': -91.9975, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71642', 'place_name': 'Fountain Hill', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ashley', 'locality_code': '3', 'latitude': 33.3631, 'longitude': -91.9088, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71646', 'place_name': 'Hamburg', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ashley', 'locality_code': '3', 'latitude': 33.2058, 'longitude': -91.8023, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71658', 'place_name': 'Montrose', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ashley', 'locality_code': '3', 'latitude': 33.3075, 'longitude': -91.5228, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71661', 'place_name': 'Parkdale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ashley', 'locality_code': '3', 'latitude': 33.1213, 'longitude': -91.5428, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71663', 'place_name': 'Portland', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ashley', 'locality_code': '3', 'latitude': 33.2318, 'longitude': -91.5139, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71676', 'place_name': 'Wilmot', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ashley', 'locality_code': '3', 'latitude': 33.0576, 'longitude': -91.5723, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72537', 'place_name': 'Gamaliel', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.4618, 'longitude': -92.2284, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72544', 'place_name': 'Henderson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.4105, 'longitude': -92.1951, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72617', 'place_name': 'Big Flat', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.0068, 'longitude': -92.3917, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72623', 'place_name': 'Clarkridge', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.4724, 'longitude': -92.3296, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72626', 'place_name': 'Cotter', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.2712, 'longitude': -92.5354, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72635', 'place_name': 'Gassville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.3175, 'longitude': -92.4736, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72642', 'place_name': 'Lakeview', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.373, 'longitude': -92.5422, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72651', 'place_name': 'Midway', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.3933, 'longitude': -92.4881, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72653', 'place_name': 'Mountain Home', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.3312, 'longitude': -92.3753, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72654', 'place_name': 'Mountain Home', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.3353, 'longitude': -92.3852, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72658', 'place_name': 'Norfork', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.2066, 'longitude': -92.273, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72659', 'place_name': 'Norfork', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Baxter', 'locality_code': '5', 'latitude': 36.2095, 'longitude': -92.2843, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72711', 'place_name': 'Avoca', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.4047, 'longitude': -94.0713, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72712', 'place_name': 'Bentonville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.3577, 'longitude': -94.2224, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72713', 'place_name': 'Bentonville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.3115, 'longitude': -94.3503, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72714', 'place_name': 'Bella Vista', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.4676, 'longitude': -94.2166, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72715', 'place_name': 'Bella Vista', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.4677, 'longitude': -94.3209, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72716', 'place_name': 'Bentonville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.3729, 'longitude': -94.2088, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72718', 'place_name': 'Cave Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.2738, 'longitude': -94.2183, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72719', 'place_name': 'Centerton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.367, 'longitude': -94.3089, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72722', 'place_name': 'Decatur', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.3347, 'longitude': -94.4534, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72732', 'place_name': 'Garfield', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.4288, 'longitude': -93.9512, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72733', 'place_name': 'Gateway', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.4864, 'longitude': -93.9277, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72734', 'place_name': 'Gentry', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.2652, 'longitude': -94.4751, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72736', 'place_name': 'Gravette', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.4155, 'longitude': -94.4779, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72739', 'place_name': 'Hiwasse', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.4416, 'longitude': -94.339, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72745', 'place_name': 'Lowell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.2554, 'longitude': -94.1308, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72747', 'place_name': 'Maysville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.3811, 'longitude': -94.5783, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72751', 'place_name': 'Pea Ridge', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.4539, 'longitude': -94.118, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72756', 'place_name': 'Rogers', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.3363, 'longitude': -94.1148, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72757', 'place_name': 'Rogers', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.332, 'longitude': -94.1185, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72758', 'place_name': 'Rogers', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.3169, 'longitude': -94.1545, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72761', 'place_name': 'Siloam Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.18, 'longitude': -94.528, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72768', 'place_name': 'Sulphur Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Benton', 'locality_code': '7', 'latitude': 36.4794, 'longitude': -94.4521, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72260', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Boone', 'locality_code': '9', 'latitude': 34.7399, 'longitude': -92.34, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72601', 'place_name': 'Harrison', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Boone', 'locality_code': '9', 'latitude': 36.2417, 'longitude': -93.1062, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72602', 'place_name': 'Harrison', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Boone', 'locality_code': '9', 'latitude': 36.2298, 'longitude': -93.1077, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72611', 'place_name': 'Alpena', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Boone', 'locality_code': '9', 'latitude': 36.2998, 'longitude': -93.2792, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72615', 'place_name': 'Bergman', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Boone', 'locality_code': '9', 'latitude': 36.3083, 'longitude': -93.0321, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72630', 'place_name': 'Diamond City', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Boone', 'locality_code': '9', 'latitude': 36.4645, 'longitude': -92.9202, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72633', 'place_name': 'Everton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Boone', 'locality_code': '9', 'latitude': 36.1534, 'longitude': -92.915, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72644', 'place_name': 'Lead Hill', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Boone', 'locality_code': '9', 'latitude': 36.3848, 'longitude': -93.0039, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72662', 'place_name': 'Omaha', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Boone', 'locality_code': '9', 'latitude': 36.4612, 'longitude': -93.1888, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72682', 'place_name': 'Valley Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Boone', 'locality_code': '9', 'latitude': 36.1351, 'longitude': -92.7541, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71631', 'place_name': 'Banks', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Bradley', 'locality_code': '11', 'latitude': 33.5497, 'longitude': -92.2604, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71647', 'place_name': 'Hermitage', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Bradley', 'locality_code': '11', 'latitude': 33.39, 'longitude': -92.156, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71651', 'place_name': 'Jersey', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Bradley', 'locality_code': '11', 'latitude': 33.3889, 'longitude': -92.2966, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71671', 'place_name': 'Warren', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Bradley', 'locality_code': '11', 'latitude': 33.614, 'longitude': -92.0778, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71744', 'place_name': 'Hampton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Calhoun', 'locality_code': '13', 'latitude': 33.5376, 'longitude': -92.5295, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71745', 'place_name': 'Harrell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Calhoun', 'locality_code': '13', 'latitude': 33.5101, 'longitude': -92.3988, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71766', 'place_name': 'Thornton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Calhoun', 'locality_code': '13', 'latitude': 33.7768, 'longitude': -92.4862, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72613', 'place_name': 'Beaver', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Carroll', 'locality_code': '15', 'latitude': 36.4311, 'longitude': -93.6994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72616', 'place_name': 'Berryville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Carroll', 'locality_code': '15', 'latitude': 36.3519, 'longitude': -93.5587, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72631', 'place_name': 'Eureka Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Carroll', 'locality_code': '15', 'latitude': 36.435, 'longitude': -93.7673, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72632', 'place_name': 'Eureka Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Carroll', 'locality_code': '15', 'latitude': 36.4175, 'longitude': -93.7379, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72638', 'place_name': 'Green Forest', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Carroll', 'locality_code': '15', 'latitude': 36.3224, 'longitude': -93.4059, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72660', 'place_name': 'Oak Grove', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Carroll', 'locality_code': '15', 'latitude': 36.4613, 'longitude': -93.4321, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71638', 'place_name': 'Dermott', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Chicot', 'locality_code': '17', 'latitude': 33.5241, 'longitude': -91.4394, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71640', 'place_name': 'Eudora', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Chicot', 'locality_code': '17', 'latitude': 33.1213, 'longitude': -91.2716, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71653', 'place_name': 'Lake Village', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Chicot', 'locality_code': '17', 'latitude': 33.3274, 'longitude': -91.2825, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71721', 'place_name': 'Beirne', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clark', 'locality_code': '19', 'latitude': 33.8887, 'longitude': -93.2041, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71728', 'place_name': 'Curtis', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clark', 'locality_code': '19', 'latitude': 34.0103, 'longitude': -93.0976, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71743', 'place_name': 'Gurdon', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clark', 'locality_code': '19', 'latitude': 33.9125, 'longitude': -93.1417, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71772', 'place_name': 'Whelen Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clark', 'locality_code': '19', 'latitude': 33.8309, 'longitude': -93.1263, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71920', 'place_name': 'Alpine', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clark', 'locality_code': '19', 'latitude': 34.229, 'longitude': -93.3791, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71921', 'place_name': 'Amity', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clark', 'locality_code': '19', 'latitude': 34.2594, 'longitude': -93.4206, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71923', 'place_name': 'Arkadelphia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clark', 'locality_code': '19', 'latitude': 34.1153, 'longitude': -93.069, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71962', 'place_name': 'Okolona', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clark', 'locality_code': '19', 'latitude': 34.0551, 'longitude': -93.2897, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71998', 'place_name': 'Arkadelphia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clark', 'locality_code': '19', 'latitude': 34.1209, 'longitude': -93.0538, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71999', 'place_name': 'Arkadelphia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clark', 'locality_code': '19', 'latitude': 34.1209, 'longitude': -93.0538, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72422', 'place_name': 'Corning', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.4155, 'longitude': -90.587, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72424', 'place_name': 'Datto', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.3897, 'longitude': -90.7231, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72430', 'place_name': 'Greenway', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.3348, 'longitude': -90.2253, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72435', 'place_name': 'Knobel', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.3176, 'longitude': -90.599, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72441', 'place_name': 'Mc Dougal', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.437, 'longitude': -90.3837, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '72453', 'place_name': 'Peach Orchard', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.283, 'longitude': -90.6702, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72454', 'place_name': 'Piggott', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.387, 'longitude': -90.1926, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72456', 'place_name': 'Pollard', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.4317, 'longitude': -90.2751, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72461', 'place_name': 'Rector', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.2672, 'longitude': -90.2702, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72464', 'place_name': 'Saint Francis', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.4534, 'longitude': -90.1454, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72470', 'place_name': 'Success', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Clay', 'locality_code': '21', 'latitude': 36.4536, 'longitude': -90.7281, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72044', 'place_name': 'Edgemont', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.6321, 'longitude': -92.157, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72067', 'place_name': 'Higden', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.5685, 'longitude': -92.1341, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72130', 'place_name': 'Prim', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.6674, 'longitude': -92.0933, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72131', 'place_name': 'Quitman', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.405, 'longitude': -92.1333, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72179', 'place_name': 'Wilburn', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.5106, 'longitude': -91.8648, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72523', 'place_name': 'Concord', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.6414, 'longitude': -91.8333, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72530', 'place_name': 'Drasco', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.6616, 'longitude': -91.9398, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72543', 'place_name': 'Heber Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.5103, 'longitude': -92.0392, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72545', 'place_name': 'Heber Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.5352, 'longitude': -92.0213, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72546', 'place_name': 'Ida', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.5816, 'longitude': -91.9305, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72581', 'place_name': 'Tumbling Shoals', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleburne', 'locality_code': '23', 'latitude': 35.547, 'longitude': -91.9704, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71652', 'place_name': 'Kingsland', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleveland', 'locality_code': '25', 'latitude': 33.86, 'longitude': -92.3014, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71660', 'place_name': 'New Edinburg', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleveland', 'locality_code': '25', 'latitude': 33.7588, 'longitude': -92.1939, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71665', 'place_name': 'Rison', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cleveland', 'locality_code': '25', 'latitude': 33.9453, 'longitude': -92.1188, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71740', 'place_name': 'Emerson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Columbia', 'locality_code': '27', 'latitude': 33.0891, 'longitude': -93.1987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71752', 'place_name': 'Mc Neil', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Columbia', 'locality_code': '27', 'latitude': 33.3622, 'longitude': -93.193, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '71753', 'place_name': 'Magnolia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Columbia', 'locality_code': '27', 'latitude': 33.2647, 'longitude': -93.2392, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71754', 'place_name': 'Magnolia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Columbia', 'locality_code': '27', 'latitude': 33.2426, 'longitude': -93.23, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71770', 'place_name': 'Waldo', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Columbia', 'locality_code': '27', 'latitude': 33.36, 'longitude': -93.2949, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71861', 'place_name': 'Taylor', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Columbia', 'locality_code': '27', 'latitude': 33.108, 'longitude': -93.446, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72027', 'place_name': 'Center Ridge', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Conway', 'locality_code': '29', 'latitude': 35.3981, 'longitude': -92.5582, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72030', 'place_name': 'Cleveland', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Conway', 'locality_code': '29', 'latitude': 35.3955, 'longitude': -92.702, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72063', 'place_name': 'Hattieville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Conway', 'locality_code': '29', 'latitude': 35.2907, 'longitude': -92.7783, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72080', 'place_name': 'Jerusalem', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Conway', 'locality_code': '29', 'latitude': 35.5699, 'longitude': -92.8251, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72107', 'place_name': 'Menifee', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Conway', 'locality_code': '29', 'latitude': 35.1356, 'longitude': -92.5498, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72110', 'place_name': 'Morrilton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Conway', 'locality_code': '29', 'latitude': 35.1692, 'longitude': -92.7354, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72127', 'place_name': 'Plumerville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Conway', 'locality_code': '29', 'latitude': 35.1575, 'longitude': -92.6204, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72156', 'place_name': 'Solgohachia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Conway', 'locality_code': '29', 'latitude': 35.2701, 'longitude': -92.6754, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72157', 'place_name': 'Springfield', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Conway', 'locality_code': '29', 'latitude': 35.2749, 'longitude': -92.5457, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72401', 'place_name': 'Jonesboro', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.833, 'longitude': -90.6965, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72402', 'place_name': 'Jonesboro', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.8088, 'longitude': -90.6529, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72403', 'place_name': 'Jonesboro', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.8305, 'longitude': -90.7039, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72404', 'place_name': 'Jonesboro', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.7792, 'longitude': -90.766, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72405', 'place_name': 'Jonesboro', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.7792, 'longitude': -90.766, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72411', 'place_name': 'Bay', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.7456, 'longitude': -90.5507, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72414', 'place_name': 'Black Oak', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.8368, 'longitude': -90.4005, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72416', 'place_name': 'Bono', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.9086, 'longitude': -90.7848, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72417', 'place_name': 'Brookland', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.9165, 'longitude': -90.5762, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72419', 'place_name': 'Caraway', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.759, 'longitude': -90.3358, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72421', 'place_name': 'Cash', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.8301, 'longitude': -90.941, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72427', 'place_name': 'Egypt', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.864, 'longitude': -90.9428, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72437', 'place_name': 'Lake City', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.8171, 'longitude': -90.4423, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72447', 'place_name': 'Monette', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.9002, 'longitude': -90.3437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72467', 'place_name': 'State University', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Craighead', 'locality_code': '31', 'latitude': 35.8422, 'longitude': -90.6735, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72921', 'place_name': 'Alma', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.5, 'longitude': -94.2073, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72932', 'place_name': 'Cedarville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.603, 'longitude': -94.3749, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72934', 'place_name': 'Chester', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.6898, 'longitude': -94.202, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72935', 'place_name': 'Dyer', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.4923, 'longitude': -94.1377, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72946', 'place_name': 'Mountainburg', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.6464, 'longitude': -94.1497, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72947', 'place_name': 'Mulberry', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.5172, 'longitude': -93.9885, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72948', 'place_name': 'Natural Dam', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.6743, 'longitude': -94.4124, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72952', 'place_name': 'Rudy', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.5468, 'longitude': -94.2913, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72955', 'place_name': 'Uniontown', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.5748, 'longitude': -94.4349, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72956', 'place_name': 'Van Buren', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.454, 'longitude': -94.3278, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72957', 'place_name': 'Van Buren', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crawford', 'locality_code': '33', 'latitude': 35.4368, 'longitude': -94.3483, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72301', 'place_name': 'West Memphis', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crittenden', 'locality_code': '35', 'latitude': 35.1484, 'longitude': -90.1779, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72303', 'place_name': 'West Memphis', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crittenden', 'locality_code': '35', 'latitude': 35.1465, 'longitude': -90.1845, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72325', 'place_name': 'Clarkedale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crittenden', 'locality_code': '35', 'latitude': 35.3093, 'longitude': -90.2362, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72327', 'place_name': 'Crawfordsville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crittenden', 'locality_code': '35', 'latitude': 35.2119, 'longitude': -90.3351, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72331', 'place_name': 'Earle', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crittenden', 'locality_code': '35', 'latitude': 35.2799, 'longitude': -90.4503, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72332', 'place_name': 'Edmondson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crittenden', 'locality_code': '35', 'latitude': 35.1042, 'longitude': -90.3133, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72339', 'place_name': 'Gilmore', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crittenden', 'locality_code': '35', 'latitude': 35.4057, 'longitude': -90.2714, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72364', 'place_name': 'Marion', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crittenden', 'locality_code': '35', 'latitude': 35.2077, 'longitude': -90.1989, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72376', 'place_name': 'Proctor', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crittenden', 'locality_code': '35', 'latitude': 35.0834, 'longitude': -90.255, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72384', 'place_name': 'Turrell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Crittenden', 'locality_code': '35', 'latitude': 35.3439, 'longitude': -90.2978, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72324', 'place_name': 'Cherry Valley', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cross', 'locality_code': '37', 'latitude': 35.3991, 'longitude': -90.7613, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72347', 'place_name': 'Hickory Ridge', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cross', 'locality_code': '37', 'latitude': 35.3995, 'longitude': -90.9823, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72373', 'place_name': 'Parkin', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cross', 'locality_code': '37', 'latitude': 35.2586, 'longitude': -90.5564, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72387', 'place_name': 'Vanndale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cross', 'locality_code': '37', 'latitude': 35.3245, 'longitude': -90.7712, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72396', 'place_name': 'Wynne', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Cross', 'locality_code': '37', 'latitude': 35.233, 'longitude': -90.793, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71725', 'place_name': 'Carthage', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Dallas', 'locality_code': '39', 'latitude': 34.0751, 'longitude': -92.5554, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71742', 'place_name': 'Fordyce', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Dallas', 'locality_code': '39', 'latitude': 33.8176, 'longitude': -92.4225, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71748', 'place_name': 'Ivan', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Dallas', 'locality_code': '39', 'latitude': 33.9118, 'longitude': -92.4246, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71763', 'place_name': 'Sparkman', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Dallas', 'locality_code': '39', 'latitude': 33.9143, 'longitude': -92.8532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71630', 'place_name': 'Arkansas City', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Desha', 'locality_code': '41', 'latitude': 33.6143, 'longitude': -91.2325, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71639', 'place_name': 'Dumas', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Desha', 'locality_code': '41', 'latitude': 33.8921, 'longitude': -91.4861, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71654', 'place_name': 'Mc Gehee', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Desha', 'locality_code': '41', 'latitude': 33.6297, 'longitude': -91.3928, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '71662', 'place_name': 'Pickens', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Desha', 'locality_code': '41', 'latitude': 33.842, 'longitude': -91.5022, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71666', 'place_name': 'Rohwer', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Desha', 'locality_code': '41', 'latitude': 33.7609, 'longitude': -91.2757, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71670', 'place_name': 'Tillar', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Desha', 'locality_code': '41', 'latitude': 33.6981, 'longitude': -91.4433, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71674', 'place_name': 'Watson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Desha', 'locality_code': '41', 'latitude': 33.8907, 'longitude': -91.2815, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72379', 'place_name': 'Snow Lake', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Desha', 'locality_code': '41', 'latitude': 34.0665, 'longitude': -91.0071, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71655', 'place_name': 'Monticello', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Drew', 'locality_code': '43', 'latitude': 33.625, 'longitude': -91.7948, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71656', 'place_name': 'Monticello', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Drew', 'locality_code': '43', 'latitude': 33.629, 'longitude': -91.791, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71657', 'place_name': 'Monticello', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Drew', 'locality_code': '43', 'latitude': 33.629, 'longitude': -91.791, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71675', 'place_name': 'Wilmar', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Drew', 'locality_code': '43', 'latitude': 33.6213, 'longitude': -91.9257, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71677', 'place_name': 'Winchester', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Drew', 'locality_code': '43', 'latitude': 33.7471, 'longitude': -91.4649, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72032', 'place_name': 'Conway', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.0842, 'longitude': -92.4236, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72033', 'place_name': 'Conway', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.1053, 'longitude': -92.3549, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72034', 'place_name': 'Conway', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.0823, 'longitude': -92.4683, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72035', 'place_name': 'Conway', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.1053, 'longitude': -92.3549, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72039', 'place_name': 'Damascus', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.3673, 'longitude': -92.4096, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72047', 'place_name': 'Enola', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.2087, 'longitude': -92.2123, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72058', 'place_name': 'Greenbrier', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.2295, 'longitude': -92.3578, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72061', 'place_name': 'Guy', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.3239, 'longitude': -92.2878, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72106', 'place_name': 'Mayflower', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 34.9669, 'longitude': -92.4001, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72111', 'place_name': 'Mount Vernon', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.2265, 'longitude': -92.124, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72173', 'place_name': 'Vilonia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.0719, 'longitude': -92.1832, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72181', 'place_name': 'Wooster', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Faulkner', 'locality_code': '45', 'latitude': 35.1645, 'longitude': -92.453, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72820', 'place_name': 'Alix', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Franklin', 'locality_code': '47', 'latitude': 35.41, 'longitude': -93.7286, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72821', 'place_name': 'Altus', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Franklin', 'locality_code': '47', 'latitude': 35.4346, 'longitude': -93.7598, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72928', 'place_name': 'Branch', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Franklin', 'locality_code': '47', 'latitude': 35.2971, 'longitude': -93.9454, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72930', 'place_name': 'Cecil', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Franklin', 'locality_code': '47', 'latitude': 35.4252, 'longitude': -94.0409, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72933', 'place_name': 'Charleston', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Franklin', 'locality_code': '47', 'latitude': 35.3115, 'longitude': -94.0337, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72949', 'place_name': 'Ozark', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Franklin', 'locality_code': '47', 'latitude': 35.5246, 'longitude': -93.8374, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72515', 'place_name': 'Bexar', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Fulton', 'locality_code': '49', 'latitude': 36.2901, 'longitude': -92.055, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72520', 'place_name': 'Camp', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Fulton', 'locality_code': '49', 'latitude': 36.4025, 'longitude': -91.7262, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72531', 'place_name': 'Elizabeth', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Fulton', 'locality_code': '49', 'latitude': 36.3238, 'longitude': -92.0934, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72538', 'place_name': 'Gepp', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Fulton', 'locality_code': '49', 'latitude': 36.4364, 'longitude': -92.0995, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72539', 'place_name': 'Glencoe', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Fulton', 'locality_code': '49', 'latitude': 36.2942, 'longitude': -91.7474, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72554', 'place_name': 'Mammoth Spring', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Fulton', 'locality_code': '49', 'latitude': 36.4076, 'longitude': -91.5757, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72576', 'place_name': 'Salem', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Fulton', 'locality_code': '49', 'latitude': 36.3766, 'longitude': -91.8759, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72578', 'place_name': 'Sturkie', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Fulton', 'locality_code': '49', 'latitude': 36.4747, 'longitude': -91.8891, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72583', 'place_name': 'Viola', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Fulton', 'locality_code': '49', 'latitude': 36.3924, 'longitude': -91.9932, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71901', 'place_name': 'Hot Springs National Park', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.5268, 'longitude': -92.9587, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71902', 'place_name': 'Hot Springs National Park', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.5814, 'longitude': -93.0994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71903', 'place_name': 'Hot Springs National Park', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.5814, 'longitude': -93.0994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71909', 'place_name': 'Hot Springs Village', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.6484, 'longitude': -92.983, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71910', 'place_name': 'Hot Springs Village', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.672, 'longitude': -92.9988, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71913', 'place_name': 'Hot Springs National Park', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.5317, 'longitude': -93.0638, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71914', 'place_name': 'Hot Springs National Park', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.5137, 'longitude': -92.9685, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71949', 'place_name': 'Jessieville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.7094, 'longitude': -93.0382, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71956', 'place_name': 'Mountain Pine', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.5976, 'longitude': -93.1539, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71964', 'place_name': 'Pearcy', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.4351, 'longitude': -93.242, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71968', 'place_name': 'Royal', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.515, 'longitude': -93.2897, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72087', 'place_name': 'Lonsdale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Garland', 'locality_code': '51', 'latitude': 34.5562, 'longitude': -92.834, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72057', 'place_name': 'Grapevine', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Grant', 'locality_code': '53', 'latitude': 34.1309, 'longitude': -92.3109, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72084', 'place_name': 'Leola', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Grant', 'locality_code': '53', 'latitude': 34.1856, 'longitude': -92.5979, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72128', 'place_name': 'Poyen', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Grant', 'locality_code': '53', 'latitude': 34.3023, 'longitude': -92.6095, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72129', 'place_name': 'Prattsville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Grant', 'locality_code': '53', 'latitude': 34.3079, 'longitude': -92.5131, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72150', 'place_name': 'Sheridan', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Grant', 'locality_code': '53', 'latitude': 34.3165, 'longitude': -92.3657, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72412', 'place_name': 'Beech Grove', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Greene', 'locality_code': '55', 'latitude': 36.1281, 'longitude': -90.6914, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72425', 'place_name': 'Delaplaine', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Greene', 'locality_code': '55', 'latitude': 36.1995, 'longitude': -90.7345, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72436', 'place_name': 'Lafe', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Greene', 'locality_code': '55', 'latitude': 36.2359, 'longitude': -90.4811, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72443', 'place_name': 'Marmaduke', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Greene', 'locality_code': '55', 'latitude': 36.1951, 'longitude': -90.3837, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72450', 'place_name': 'Paragould', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Greene', 'locality_code': '55', 'latitude': 36.06, 'longitude': -90.5251, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72451', 'place_name': 'Paragould', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Greene', 'locality_code': '55', 'latitude': 36.0584, 'longitude': -90.4973, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72474', 'place_name': 'Walcott', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Greene', 'locality_code': '55', 'latitude': 36.0413, 'longitude': -90.6718, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71801', 'place_name': 'Hope', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hempstead', 'locality_code': '57', 'latitude': 33.6736, 'longitude': -93.6068, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71802', 'place_name': 'Hope', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hempstead', 'locality_code': '57', 'latitude': 33.6671, 'longitude': -93.5916, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71825', 'place_name': 'Blevins', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hempstead', 'locality_code': '57', 'latitude': 33.8718, 'longitude': -93.5771, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71831', 'place_name': 'Columbus', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hempstead', 'locality_code': '57', 'latitude': 33.7935, 'longitude': -93.807, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71838', 'place_name': 'Fulton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hempstead', 'locality_code': '57', 'latitude': 33.6299, 'longitude': -93.8086, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71847', 'place_name': 'Mc Caskill', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hempstead', 'locality_code': '57', 'latitude': 33.923, 'longitude': -93.6266, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '71855', 'place_name': 'Ozan', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hempstead', 'locality_code': '57', 'latitude': 33.9028, 'longitude': -93.7714, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71862', 'place_name': 'Washington', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hempstead', 'locality_code': '57', 'latitude': 33.7546, 'longitude': -93.6735, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71929', 'place_name': 'Bismarck', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hot Spring', 'locality_code': '59', 'latitude': 34.311, 'longitude': -93.1872, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71933', 'place_name': 'Bonnerdale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hot Spring', 'locality_code': '59', 'latitude': 34.3848, 'longitude': -93.3819, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71941', 'place_name': 'Donaldson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hot Spring', 'locality_code': '59', 'latitude': 34.2212, 'longitude': -92.9094, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71942', 'place_name': 'Friendship', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hot Spring', 'locality_code': '59', 'latitude': 34.2235, 'longitude': -93.0024, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72019', 'place_name': 'Benton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hot Spring', 'locality_code': '59', 'latitude': 34.604, 'longitude': -92.6259, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72104', 'place_name': 'Malvern', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hot Spring', 'locality_code': '59', 'latitude': 34.3557, 'longitude': -92.8292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72105', 'place_name': 'Jones Mill', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Hot Spring', 'locality_code': '59', 'latitude': 34.4374, 'longitude': -92.8943, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '71833', 'place_name': 'Dierks', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Howard', 'locality_code': '61', 'latitude': 34.1323, 'longitude': -94.0152, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71851', 'place_name': 'Mineral Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Howard', 'locality_code': '61', 'latitude': 33.8639, 'longitude': -93.9188, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71852', 'place_name': 'Nashville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Howard', 'locality_code': '61', 'latitude': 33.9576, 'longitude': -93.8707, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71859', 'place_name': 'Saratoga', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Howard', 'locality_code': '61', 'latitude': 33.7599, 'longitude': -93.8767, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71971', 'place_name': 'Umpire', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Howard', 'locality_code': '61', 'latitude': 34.2921, 'longitude': -94.0314, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72165', 'place_name': 'Thida', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.5762, 'longitude': -91.4539, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72501', 'place_name': 'Batesville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.7826, 'longitude': -91.6352, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72503', 'place_name': 'Batesville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.7346, 'longitude': -91.5343, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72522', 'place_name': 'Charlotte', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.8184, 'longitude': -91.4387, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72524', 'place_name': 'Cord', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.8184, 'longitude': -91.3375, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72526', 'place_name': 'Cushman', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.8729, 'longitude': -91.754, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72527', 'place_name': 'Desha', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.7411, 'longitude': -91.6985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72534', 'place_name': 'Floral', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.6023, 'longitude': -91.7341, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72550', 'place_name': 'Locust Grove', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.7177, 'longitude': -91.7414, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72553', 'place_name': 'Magness', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.6941, 'longitude': -91.4753, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72562', 'place_name': 'Newark', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.7118, 'longitude': -91.4394, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72564', 'place_name': 'Oil Trough', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.6131, 'longitude': -91.4703, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72568', 'place_name': 'Pleasant Plains', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.5893, 'longitude': -91.632, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72571', 'place_name': 'Rosie', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.6638, 'longitude': -91.534, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72575', 'place_name': 'Salado', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.6919, 'longitude': -91.5989, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72579', 'place_name': 'Sulphur Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Independence', 'locality_code': '63', 'latitude': 35.7545, 'longitude': -91.5073, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72512', 'place_name': 'Horseshoe Bend', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.2025, 'longitude': -91.7553, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72517', 'place_name': 'Brockwell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.1358, 'longitude': -91.9513, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72519', 'place_name': 'Calico Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.1202, 'longitude': -92.1867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72528', 'place_name': 'Dolph', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.2229, 'longitude': -92.1177, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72536', 'place_name': 'Franklin', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.1703, 'longitude': -91.776, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72540', 'place_name': 'Guion', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 35.9266, 'longitude': -91.9103, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72556', 'place_name': 'Melbourne', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.0635, 'longitude': -91.9079, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72561', 'place_name': 'Mount Pleasant', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 35.9759, 'longitude': -91.785, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72565', 'place_name': 'Oxford', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.2114, 'longitude': -91.9258, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72566', 'place_name': 'Pineville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.1677, 'longitude': -92.1073, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72573', 'place_name': 'Sage', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.0688, 'longitude': -91.791, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72584', 'place_name': 'Violet Hill', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.163, 'longitude': -91.8471, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72585', 'place_name': 'Wideman', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.1865, 'longitude': -92.0088, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72587', 'place_name': 'Wiseman', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Izard', 'locality_code': '65', 'latitude': 36.2345, 'longitude': -91.8154, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72005', 'place_name': 'Amagon', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jackson', 'locality_code': '67', 'latitude': 35.562, 'longitude': -91.1104, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72014', 'place_name': 'Beedeville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jackson', 'locality_code': '67', 'latitude': 35.4291, 'longitude': -91.1057, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72043', 'place_name': 'Diaz', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jackson', 'locality_code': '67', 'latitude': 35.6336, 'longitude': -91.2592, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72075', 'place_name': 'Jacksonport', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jackson', 'locality_code': '67', 'latitude': 35.6414, 'longitude': -91.3072, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72112', 'place_name': 'Newport', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jackson', 'locality_code': '67', 'latitude': 35.5988, 'longitude': -91.2571, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72169', 'place_name': 'Tupelo', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jackson', 'locality_code': '67', 'latitude': 35.3844, 'longitude': -91.2232, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72431', 'place_name': 'Grubbs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jackson', 'locality_code': '67', 'latitude': 35.6498, 'longitude': -91.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72471', 'place_name': 'Swifton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jackson', 'locality_code': '67', 'latitude': 35.8274, 'longitude': -91.1264, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72473', 'place_name': 'Tuckerman', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jackson', 'locality_code': '67', 'latitude': 35.7307, 'longitude': -91.2003, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71601', 'place_name': 'Pine Bluff', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.209, 'longitude': -91.9859, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71602', 'place_name': 'White Hall', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.274, 'longitude': -92.091, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71603', 'place_name': 'Pine Bluff', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.1897, 'longitude': -92.0448, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71611', 'place_name': 'Pine Bluff', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.2615, 'longitude': -91.9551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71612', 'place_name': 'White Hall', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.274, 'longitude': -92.091, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71613', 'place_name': 'Pine Bluff', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.1579, 'longitude': -92.0713, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71659', 'place_name': 'Moscow', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.1465, 'longitude': -91.7951, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72004', 'place_name': 'Altheimer', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.3062, 'longitude': -91.8289, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72079', 'place_name': 'Jefferson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.3934, 'longitude': -92.2029, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72132', 'place_name': 'Redfield', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.4526, 'longitude': -92.1758, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72133', 'place_name': 'Reydell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.1715, 'longitude': -91.5656, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72152', 'place_name': 'Sherrill', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.3581, 'longitude': -91.9933, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72168', 'place_name': 'Tucker', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.4414, 'longitude': -91.9163, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72175', 'place_name': 'Wabbaseka', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.3936, 'longitude': -91.7549, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72182', 'place_name': 'Wright', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Jefferson', 'locality_code': '69', 'latitude': 34.4291, 'longitude': -92.0599, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72830', 'place_name': 'Clarksville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Johnson', 'locality_code': '71', 'latitude': 35.4908, 'longitude': -93.4911, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72832', 'place_name': 'Coal Hill', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Johnson', 'locality_code': '71', 'latitude': 35.4371, 'longitude': -93.672, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72839', 'place_name': 'Hagarville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Johnson', 'locality_code': '71', 'latitude': 35.6155, 'longitude': -93.2726, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72840', 'place_name': 'Hartman', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Johnson', 'locality_code': '71', 'latitude': 35.4436, 'longitude': -93.6142, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72845', 'place_name': 'Knoxville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Johnson', 'locality_code': '71', 'latitude': 35.3749, 'longitude': -93.3618, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72846', 'place_name': 'Lamar', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Johnson', 'locality_code': '71', 'latitude': 35.4349, 'longitude': -93.3552, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72852', 'place_name': 'Oark', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Johnson', 'locality_code': '71', 'latitude': 35.7095, 'longitude': -93.5585, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72854', 'place_name': 'Ozone', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Johnson', 'locality_code': '71', 'latitude': 35.6575, 'longitude': -93.4311, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71826', 'place_name': 'Bradley', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lafayette', 'locality_code': '73', 'latitude': 33.107, 'longitude': -93.6275, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71827', 'place_name': 'Buckner', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lafayette', 'locality_code': '73', 'latitude': 33.3753, 'longitude': -93.447, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71839', 'place_name': 'Garland City', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lafayette', 'locality_code': '73', 'latitude': 33.3352, 'longitude': -93.7316, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '71845', 'place_name': 'Lewisville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lafayette', 'locality_code': '73', 'latitude': 33.3736, 'longitude': -93.5953, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71860', 'place_name': 'Stamps', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lafayette', 'locality_code': '73', 'latitude': 33.3569, 'longitude': -93.5013, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72410', 'place_name': 'Alicia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 35.9423, 'longitude': -91.081, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72415', 'place_name': 'Black Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 36.1149, 'longitude': -91.1176, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72433', 'place_name': 'Hoxie', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 36.0326, 'longitude': -90.9715, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72434', 'place_name': 'Imboden', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 36.1976, 'longitude': -91.1854, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72440', 'place_name': 'Lynn', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 35.9813, 'longitude': -91.2676, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72445', 'place_name': 'Minturn', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 35.9728, 'longitude': -91.0235, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72457', 'place_name': 'Portia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 36.0865, 'longitude': -91.0673, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72458', 'place_name': 'Powhatan', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 36.08, 'longitude': -91.1482, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72459', 'place_name': 'Ravenden', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 36.2029, 'longitude': -91.2593, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72465', 'place_name': 'Sedgwick', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 35.9643, 'longitude': -90.8954, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72466', 'place_name': 'Smithville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 36.0908, 'longitude': -91.2745, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72469', 'place_name': 'Strawberry', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 35.9673, 'longitude': -91.2935, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72476', 'place_name': 'Walnut Ridge', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 36.0244, 'longitude': -90.9288, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72572', 'place_name': 'Saffell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lawrence', 'locality_code': '75', 'latitude': 35.8781, 'longitude': -91.3004, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72311', 'place_name': 'Aubrey', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lee', 'locality_code': '77', 'latitude': 34.7195, 'longitude': -90.8969, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72320', 'place_name': 'Brickeys', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lee', 'locality_code': '77', 'latitude': 34.8548, 'longitude': -90.5377, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72341', 'place_name': 'Haynes', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lee', 'locality_code': '77', 'latitude': 34.8838, 'longitude': -90.7666, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72352', 'place_name': 'La Grange', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lee', 'locality_code': '77', 'latitude': 34.7697, 'longitude': -90.7552, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72360', 'place_name': 'Marianna', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lee', 'locality_code': '77', 'latitude': 34.7759, 'longitude': -90.7785, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72368', 'place_name': 'Moro', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lee', 'locality_code': '77', 'latitude': 34.803, 'longitude': -91.006, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71643', 'place_name': 'Gould', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lincoln', 'locality_code': '79', 'latitude': 34.0345, 'longitude': -91.5768, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71644', 'place_name': 'Grady', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lincoln', 'locality_code': '79', 'latitude': 34.1032, 'longitude': -91.7057, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71667', 'place_name': 'Star City', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lincoln', 'locality_code': '79', 'latitude': 33.9405, 'longitude': -91.8653, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71678', 'place_name': 'Yorktown', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lincoln', 'locality_code': '79', 'latitude': 33.9787, 'longitude': -91.6991, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71820', 'place_name': 'Alleene', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Little River', 'locality_code': '81', 'latitude': 33.7944, 'longitude': -94.2681, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71822', 'place_name': 'Ashdown', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Little River', 'locality_code': '81', 'latitude': 33.6787, 'longitude': -94.1351, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71836', 'place_name': 'Foreman', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Little River', 'locality_code': '81', 'latitude': 33.7176, 'longitude': -94.3881, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71853', 'place_name': 'Ogden', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Little River', 'locality_code': '81', 'latitude': 33.5826, 'longitude': -94.0427, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71865', 'place_name': 'Wilton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Little River', 'locality_code': '81', 'latitude': 33.7475, 'longitude': -94.1518, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71866', 'place_name': 'Winthrop', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Little River', 'locality_code': '81', 'latitude': 33.8583, 'longitude': -94.3952, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72826', 'place_name': 'Blue Mountain', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Logan', 'locality_code': '83', 'latitude': 35.1304, 'longitude': -93.7116, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72835', 'place_name': 'Delaware', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Logan', 'locality_code': '83', 'latitude': 35.278, 'longitude': -93.3462, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72851', 'place_name': 'New Blaine', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Logan', 'locality_code': '83', 'latitude': 35.3189, 'longitude': -93.4446, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72855', 'place_name': 'Paris', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Logan', 'locality_code': '83', 'latitude': 35.2941, 'longitude': -93.7265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72863', 'place_name': 'Scranton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Logan', 'locality_code': '83', 'latitude': 35.3585, 'longitude': -93.5454, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72865', 'place_name': 'Subiaco', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Logan', 'locality_code': '83', 'latitude': 35.3153, 'longitude': -93.5991, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72927', 'place_name': 'Booneville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Logan', 'locality_code': '83', 'latitude': 35.1364, 'longitude': -93.9274, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72943', 'place_name': 'Magazine', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Logan', 'locality_code': '83', 'latitude': 35.1587, 'longitude': -93.8003, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72951', 'place_name': 'Ratcliff', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Logan', 'locality_code': '83', 'latitude': 35.2917, 'longitude': -93.8899, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72007', 'place_name': 'Austin', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lonoke', 'locality_code': '85', 'latitude': 34.9921, 'longitude': -91.9798, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72023', 'place_name': 'Cabot', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lonoke', 'locality_code': '85', 'latitude': 34.9457, 'longitude': -92.0318, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72024', 'place_name': 'Carlisle', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lonoke', 'locality_code': '85', 'latitude': 34.7933, 'longitude': -91.7459, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72037', 'place_name': 'Coy', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lonoke', 'locality_code': '85', 'latitude': 34.5387, 'longitude': -91.874, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72046', 'place_name': 'England', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lonoke', 'locality_code': '85', 'latitude': 34.5575, 'longitude': -91.9484, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72072', 'place_name': 'Humnoke', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lonoke', 'locality_code': '85', 'latitude': 34.4857, 'longitude': -91.7624, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72083', 'place_name': 'Keo', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lonoke', 'locality_code': '85', 'latitude': 34.6041, 'longitude': -92.0078, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72086', 'place_name': 'Lonoke', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lonoke', 'locality_code': '85', 'latitude': 34.7832, 'longitude': -91.9214, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72176', 'place_name': 'Ward', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Lonoke', 'locality_code': '85', 'latitude': 34.9532, 'longitude': -91.9004, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72721', 'place_name': 'Combs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Madison', 'locality_code': '87', 'latitude': 35.8607, 'longitude': -93.8112, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72738', 'place_name': 'Hindsville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Madison', 'locality_code': '87', 'latitude': 36.1422, 'longitude': -93.8633, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72740', 'place_name': 'Huntsville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Madison', 'locality_code': '87', 'latitude': 36.1043, 'longitude': -93.7279, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72742', 'place_name': 'Kingston', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Madison', 'locality_code': '87', 'latitude': 36.0485, 'longitude': -93.5044, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72752', 'place_name': 'Pettigrew', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Madison', 'locality_code': '87', 'latitude': 35.8346, 'longitude': -93.6181, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72760', 'place_name': 'Saint Paul', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Madison', 'locality_code': '87', 'latitude': 35.8496, 'longitude': -93.7347, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72773', 'place_name': 'Wesley', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Madison', 'locality_code': '87', 'latitude': 36.0114, 'longitude': -93.8526, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72776', 'place_name': 'Witter', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Madison', 'locality_code': '87', 'latitude': 35.9356, 'longitude': -93.621, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72619', 'place_name': 'Bull Shoals', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Marion', 'locality_code': '89', 'latitude': 36.371, 'longitude': -92.5938, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72634', 'place_name': 'Flippin', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Marion', 'locality_code': '89', 'latitude': 36.2682, 'longitude': -92.578, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72661', 'place_name': 'Oakland', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Marion', 'locality_code': '89', 'latitude': 36.4442, 'longitude': -92.5832, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72668', 'place_name': 'Peel', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Marion', 'locality_code': '89', 'latitude': 36.435, 'longitude': -92.7615, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72672', 'place_name': 'Pyatt', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Marion', 'locality_code': '89', 'latitude': 36.2486, 'longitude': -92.8416, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72677', 'place_name': 'Summit', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Marion', 'locality_code': '89', 'latitude': 36.2523, 'longitude': -92.6907, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72687', 'place_name': 'Yellville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Marion', 'locality_code': '89', 'latitude': 36.2253, 'longitude': -92.7245, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71834', 'place_name': 'Doddridge', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Miller', 'locality_code': '91', 'latitude': 33.1054, 'longitude': -93.9543, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71837', 'place_name': 'Fouke', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Miller', 'locality_code': '91', 'latitude': 33.3025, 'longitude': -93.901, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71840', 'place_name': 'Genoa', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Miller', 'locality_code': '91', 'latitude': 33.3837, 'longitude': -93.9096, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71854', 'place_name': 'Texarkana', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Miller', 'locality_code': '91', 'latitude': 33.431, 'longitude': -93.8765, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72310', 'place_name': 'Armorel', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.9201, 'longitude': -89.7981, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72313', 'place_name': 'Bassett', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.5365, 'longitude': -90.1268, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72315', 'place_name': 'Blytheville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.9273, 'longitude': -89.919, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72316', 'place_name': 'Blytheville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.9273, 'longitude': -89.919, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72319', 'place_name': 'Gosnell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.9598, 'longitude': -89.972, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72321', 'place_name': 'Burdette', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.8173, 'longitude': -89.9393, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72329', 'place_name': 'Driver', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.6253, 'longitude': -90.0138, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72330', 'place_name': 'Dyess', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.5954, 'longitude': -90.2157, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72338', 'place_name': 'Frenchmans Bayou', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.4591, 'longitude': -90.1884, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72350', 'place_name': 'Joiner', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.5052, 'longitude': -90.1478, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72351', 'place_name': 'Keiser', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.6737, 'longitude': -90.0963, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72358', 'place_name': 'Luxora', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.7608, 'longitude': -89.922, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72370', 'place_name': 'Osceola', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.7019, 'longitude': -89.9798, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72391', 'place_name': 'West Ridge', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.6831, 'longitude': -90.2626, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72395', 'place_name': 'Wilson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.566, 'longitude': -90.0427, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72426', 'place_name': 'Dell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.8554, 'longitude': -90.0418, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72428', 'place_name': 'Etowah', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.7337, 'longitude': -90.1838, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72438', 'place_name': 'Leachville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.9332, 'longitude': -90.1955, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72442', 'place_name': 'Manila', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Mississippi', 'locality_code': '93', 'latitude': 35.8439, 'longitude': -90.1806, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72021', 'place_name': 'Brinkley', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Monroe', 'locality_code': '95', 'latitude': 34.8781, 'longitude': -91.1886, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72029', 'place_name': 'Clarendon', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Monroe', 'locality_code': '95', 'latitude': 34.6601, 'longitude': -91.2564, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72069', 'place_name': 'Holly Grove', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Monroe', 'locality_code': '95', 'latitude': 34.5993, 'longitude': -91.1844, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72108', 'place_name': 'Monroe', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Monroe', 'locality_code': '95', 'latitude': 34.7348, 'longitude': -91.1046, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72134', 'place_name': 'Roe', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Monroe', 'locality_code': '95', 'latitude': 34.6286, 'longitude': -91.3771, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71935', 'place_name': 'Caddo Gap', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Montgomery', 'locality_code': '97', 'latitude': 34.3913, 'longitude': -93.7637, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71957', 'place_name': 'Mount Ida', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Montgomery', 'locality_code': '97', 'latitude': 34.5612, 'longitude': -93.5749, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71960', 'place_name': 'Norman', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Montgomery', 'locality_code': '97', 'latitude': 34.4596, 'longitude': -93.6743, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71961', 'place_name': 'Oden', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Montgomery', 'locality_code': '97', 'latitude': 34.6113, 'longitude': -93.8211, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71965', 'place_name': 'Pencil Bluff', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Montgomery', 'locality_code': '97', 'latitude': 34.6399, 'longitude': -93.7429, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71966', 'place_name': 'Oden', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Montgomery', 'locality_code': '97', 'latitude': 34.619, 'longitude': -93.7769, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71969', 'place_name': 'Sims', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Montgomery', 'locality_code': '97', 'latitude': 34.6462, 'longitude': -93.6741, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71970', 'place_name': 'Story', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Montgomery', 'locality_code': '97', 'latitude': 34.6687, 'longitude': -93.5376, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71722', 'place_name': 'Bluff City', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Nevada', 'locality_code': '99', 'latitude': 33.7038, 'longitude': -93.1588, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71828', 'place_name': 'Cale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Nevada', 'locality_code': '99', 'latitude': 33.7008, 'longitude': -93.2941, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71835', 'place_name': 'Emmet', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Nevada', 'locality_code': '99', 'latitude': 33.6929, 'longitude': -93.4232, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71857', 'place_name': 'Prescott', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Nevada', 'locality_code': '99', 'latitude': 33.804, 'longitude': -93.3725, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71858', 'place_name': 'Rosston', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Nevada', 'locality_code': '99', 'latitude': 33.5926, 'longitude': -93.2766, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71864', 'place_name': 'Willisville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Nevada', 'locality_code': '99', 'latitude': 33.7008, 'longitude': -93.2941, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72624', 'place_name': 'Compton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Newton', 'locality_code': '101', 'latitude': 36.0979, 'longitude': -93.3099, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72628', 'place_name': 'Deer', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Newton', 'locality_code': '101', 'latitude': 35.853, 'longitude': -93.3174, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72640', 'place_name': 'Hasty', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Newton', 'locality_code': '101', 'latitude': 36.0152, 'longitude': -93.046, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72641', 'place_name': 'Jasper', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Newton', 'locality_code': '101', 'latitude': 36.0038, 'longitude': -93.2048, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72648', 'place_name': 'Marble Falls', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Newton', 'locality_code': '101', 'latitude': 36.0695, 'longitude': -93.1566, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72655', 'place_name': 'Mount Judea', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Newton', 'locality_code': '101', 'latitude': 35.9407, 'longitude': -93.0654, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72666', 'place_name': 'Parthenon', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Newton', 'locality_code': '101', 'latitude': 35.9451, 'longitude': -93.2677, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72670', 'place_name': 'Ponca', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Newton', 'locality_code': '101', 'latitude': 36.0242, 'longitude': -93.3646, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72683', 'place_name': 'Vendor', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Newton', 'locality_code': '101', 'latitude': 35.9473, 'longitude': -93.0774, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72685', 'place_name': 'Western Grove', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Newton', 'locality_code': '101', 'latitude': 36.083, 'longitude': -92.9716, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71701', 'place_name': 'Camden', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ouachita', 'locality_code': '103', 'latitude': 33.5948, 'longitude': -92.8513, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71711', 'place_name': 'Camden', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ouachita', 'locality_code': '103', 'latitude': 33.589, 'longitude': -92.8426, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71720', 'place_name': 'Bearden', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ouachita', 'locality_code': '103', 'latitude': 33.7298, 'longitude': -92.618, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71726', 'place_name': 'Chidester', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ouachita', 'locality_code': '103', 'latitude': 33.6652, 'longitude': -92.9969, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71751', 'place_name': 'Louann', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ouachita', 'locality_code': '103', 'latitude': 33.4169, 'longitude': -92.777, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71764', 'place_name': 'Stephens', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Ouachita', 'locality_code': '103', 'latitude': 33.455, 'longitude': -93.0214, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72001', 'place_name': 'Adona', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Perry', 'locality_code': '105', 'latitude': 35.047, 'longitude': -92.9033, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72016', 'place_name': 'Bigelow', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Perry', 'locality_code': '105', 'latitude': 34.9847, 'longitude': -92.6308, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72025', 'place_name': 'Casa', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Perry', 'locality_code': '105', 'latitude': 35.0322, 'longitude': -93.047, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72070', 'place_name': 'Houston', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Perry', 'locality_code': '105', 'latitude': 35.0362, 'longitude': -92.6913, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72125', 'place_name': 'Perry', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Perry', 'locality_code': '105', 'latitude': 35.0443, 'longitude': -92.7958, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72126', 'place_name': 'Perryville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Perry', 'locality_code': '105', 'latitude': 34.9701, 'longitude': -92.8472, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72312', 'place_name': 'Barton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.5467, 'longitude': -90.7679, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72328', 'place_name': 'Crumrod', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.1335, 'longitude': -90.9751, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72333', 'place_name': 'Elaine', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.3118, 'longitude': -90.8939, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72342', 'place_name': 'Helena', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.5325, 'longitude': -90.6298, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72353', 'place_name': 'Lambrook', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.3286, 'longitude': -90.9652, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72355', 'place_name': 'Lexa', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.5979, 'longitude': -90.7523, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72366', 'place_name': 'Marvell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.5485, 'longitude': -90.9413, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72367', 'place_name': 'Mellwood', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.2198, 'longitude': -90.9504, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72369', 'place_name': 'Oneida', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.4542, 'longitude': -90.7684, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72374', 'place_name': 'Poplar Grove', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.5394, 'longitude': -90.8813, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72383', 'place_name': 'Turner', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.4762, 'longitude': -91.0187, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72389', 'place_name': 'Wabash', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.3466, 'longitude': -90.8869, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72390', 'place_name': 'West Helena', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Phillips', 'locality_code': '107', 'latitude': 34.5496, 'longitude': -90.6545, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71922', 'place_name': 'Antoine', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pike', 'locality_code': '109', 'latitude': 34.0362, 'longitude': -93.4207, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71940', 'place_name': 'Delight', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pike', 'locality_code': '109', 'latitude': 34.0238, 'longitude': -93.5247, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71943', 'place_name': 'Glenwood', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pike', 'locality_code': '109', 'latitude': 34.3192, 'longitude': -93.5559, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71950', 'place_name': 'Kirby', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pike', 'locality_code': '109', 'latitude': 34.2513, 'longitude': -93.741, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71952', 'place_name': 'Langley', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pike', 'locality_code': '109', 'latitude': 34.314, 'longitude': -93.8509, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71958', 'place_name': 'Murfreesboro', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pike', 'locality_code': '109', 'latitude': 34.1017, 'longitude': -93.7109, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71959', 'place_name': 'Newhope', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pike', 'locality_code': '109', 'latitude': 34.2273, 'longitude': -93.8905, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72354', 'place_name': 'Lepanto', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Poinsett', 'locality_code': '111', 'latitude': 35.6069, 'longitude': -90.3359, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72365', 'place_name': 'Marked Tree', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Poinsett', 'locality_code': '111', 'latitude': 35.5349, 'longitude': -90.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72377', 'place_name': 'Rivervale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Poinsett', 'locality_code': '111', 'latitude': 35.674, 'longitude': -90.3401, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72386', 'place_name': 'Tyronza', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Poinsett', 'locality_code': '111', 'latitude': 35.4865, 'longitude': -90.3519, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72429', 'place_name': 'Fisher', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Poinsett', 'locality_code': '111', 'latitude': 35.514, 'longitude': -90.955, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72432', 'place_name': 'Harrisburg', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Poinsett', 'locality_code': '111', 'latitude': 35.5722, 'longitude': -90.7038, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72472', 'place_name': 'Trumann', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Poinsett', 'locality_code': '111', 'latitude': 35.5882, 'longitude': -90.562, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72475', 'place_name': 'Waldenburg', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Poinsett', 'locality_code': '111', 'latitude': 35.5631, 'longitude': -90.9207, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72479', 'place_name': 'Weiner', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Poinsett', 'locality_code': '111', 'latitude': 35.6291, 'longitude': -90.9289, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71932', 'place_name': 'Board Camp', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Polk', 'locality_code': '113', 'latitude': 34.5372, 'longitude': -94.0972, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71937', 'place_name': 'Cove', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Polk', 'locality_code': '113', 'latitude': 34.4192, 'longitude': -94.3923, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71944', 'place_name': 'Grannis', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Polk', 'locality_code': '113', 'latitude': 34.237, 'longitude': -94.3255, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71945', 'place_name': 'Hatfield', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Polk', 'locality_code': '113', 'latitude': 34.4877, 'longitude': -94.3714, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71953', 'place_name': 'Mena', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Polk', 'locality_code': '113', 'latitude': 34.5814, 'longitude': -94.221, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71972', 'place_name': 'Vandervoort', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Polk', 'locality_code': '113', 'latitude': 34.3941, 'longitude': -94.2535, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71973', 'place_name': 'Wickes', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Polk', 'locality_code': '113', 'latitude': 34.3088, 'longitude': -94.3403, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72679', 'place_name': 'Tilly', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.7341, 'longitude': -92.8391, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72801', 'place_name': 'Russellville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.2842, 'longitude': -93.1315, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72802', 'place_name': 'Russellville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.3067, 'longitude': -93.0712, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72811', 'place_name': 'Russellville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.2784, 'longitude': -93.1338, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72812', 'place_name': 'Russellville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.4231, 'longitude': -93.0544, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72823', 'place_name': 'Atkins', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.2449, 'longitude': -92.9507, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72837', 'place_name': 'Dover', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.4074, 'longitude': -93.1355, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72843', 'place_name': 'Hector', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.5499, 'longitude': -92.9616, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72847', 'place_name': 'London', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.3744, 'longitude': -93.2736, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72856', 'place_name': 'Pelsor', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.7854, 'longitude': -93.0812, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72858', 'place_name': 'Pottsville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pope', 'locality_code': '115', 'latitude': 35.2398, 'longitude': -93.0564, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72017', 'place_name': 'Biscoe', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Prairie', 'locality_code': '117', 'latitude': 34.8733, 'longitude': -91.3945, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72040', 'place_name': 'Des Arc', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Prairie', 'locality_code': '117', 'latitude': 34.9751, 'longitude': -91.5113, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72041', 'place_name': 'De Valls Bluff', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Prairie', 'locality_code': '117', 'latitude': 34.7447, 'longitude': -91.4982, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72064', 'place_name': 'Hazen', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Prairie', 'locality_code': '117', 'latitude': 34.7838, 'longitude': -91.5767, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72066', 'place_name': 'Hickory Plains', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Prairie', 'locality_code': '117', 'latitude': 34.9901, 'longitude': -91.7368, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72170', 'place_name': 'Ulm', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Prairie', 'locality_code': '117', 'latitude': 34.5772, 'longitude': -91.4633, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72002', 'place_name': 'Alexander', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.6313, 'longitude': -92.4727, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72053', 'place_name': 'College Station', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7093, 'longitude': -92.2283, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72065', 'place_name': 'Hensley', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.5208, 'longitude': -92.2758, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72076', 'place_name': 'Jacksonville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.919, 'longitude': -92.1419, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72078', 'place_name': 'Jacksonville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8662, 'longitude': -92.1101, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72099', 'place_name': 'Little Rock Air Force Base', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.9074, 'longitude': -92.1397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72103', 'place_name': 'Mabelvale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.6478, 'longitude': -92.3849, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72113', 'place_name': 'Maumelle', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8491, 'longitude': -92.4059, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72114', 'place_name': 'North Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7666, 'longitude': -92.2629, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72115', 'place_name': 'North Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7695, 'longitude': -92.2671, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72116', 'place_name': 'North Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8059, 'longitude': -92.2305, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72117', 'place_name': 'North Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7658, 'longitude': -92.1524, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72118', 'place_name': 'North Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8337, 'longitude': -92.3289, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72119', 'place_name': 'North Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8017, 'longitude': -92.2598, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72120', 'place_name': 'Sherwood', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8807, 'longitude': -92.2303, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72124', 'place_name': 'North Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7519, 'longitude': -92.3925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72135', 'place_name': 'Roland', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8829, 'longitude': -92.5192, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72142', 'place_name': 'Scott', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.6942, 'longitude': -92.1157, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72164', 'place_name': 'Sweet Home', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.6873, 'longitude': -92.2399, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72180', 'place_name': 'Woodson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.5338, 'longitude': -92.2089, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72183', 'place_name': 'Wrightsville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.6012, 'longitude': -92.1938, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72190', 'place_name': 'North Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7519, 'longitude': -92.3925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72199', 'place_name': 'North Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8272, 'longitude': -92.2847, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72201', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7483, 'longitude': -92.2819, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72202', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7363, 'longitude': -92.2741, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72203', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8835, 'longitude': -92.3908, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72204', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7269, 'longitude': -92.344, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72205', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.751, 'longitude': -92.3455, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72206', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.6836, 'longitude': -92.2776, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72207', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7721, 'longitude': -92.3565, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72209', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.6725, 'longitude': -92.3529, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72210', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7076, 'longitude': -92.466, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72211', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7413, 'longitude': -92.4222, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72212', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7871, 'longitude': -92.4222, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72214', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7621, 'longitude': -92.2282, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72215', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7519, 'longitude': -92.3925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72216', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8178, 'longitude': -92.2357, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72217', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8302, 'longitude': -92.1702, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72219', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7519, 'longitude': -92.3925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72221', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7519, 'longitude': -92.3925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72222', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7519, 'longitude': -92.3925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72223', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7902, 'longitude': -92.5044, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72225', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7519, 'longitude': -92.3925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72227', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7757, 'longitude': -92.3724, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72231', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.8019, 'longitude': -92.1894, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72255', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7464, 'longitude': -92.2894, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '72295', 'place_name': 'Little Rock', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Pulaski', 'locality_code': '119', 'latitude': 34.7519, 'longitude': -92.3925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72413', 'place_name': 'Biggers', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Randolph', 'locality_code': '121', 'latitude': 36.2844, 'longitude': -90.8538, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72444', 'place_name': 'Maynard', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Randolph', 'locality_code': '121', 'latitude': 36.4386, 'longitude': -90.8749, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72449', 'place_name': 'O Kean', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Randolph', 'locality_code': '121', 'latitude': 36.1797, 'longitude': -90.8241, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72455', 'place_name': 'Pocahontas', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Randolph', 'locality_code': '121', 'latitude': 36.2829, 'longitude': -90.9968, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72460', 'place_name': 'Ravenden Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Randolph', 'locality_code': '121', 'latitude': 36.3104, 'longitude': -91.2094, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72462', 'place_name': 'Reyno', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Randolph', 'locality_code': '121', 'latitude': 36.3744, 'longitude': -90.7676, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72478', 'place_name': 'Warm Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Randolph', 'locality_code': '121', 'latitude': 36.4803, 'longitude': -91.0515, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72322', 'place_name': 'Caldwell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 35.0562, 'longitude': -90.8288, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72326', 'place_name': 'Colt', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 35.0881, 'longitude': -90.8895, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72335', 'place_name': 'Forrest City', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 35.0091, 'longitude': -90.7886, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72336', 'place_name': 'Forrest City', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 35.0081, 'longitude': -90.7898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72340', 'place_name': 'Goodwin', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 34.9358, 'longitude': -91.0292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72346', 'place_name': 'Heth', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 35.0973, 'longitude': -90.4586, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72348', 'place_name': 'Hughes', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 34.9454, 'longitude': -90.4741, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72359', 'place_name': 'Madison', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 35.0252, 'longitude': -90.7086, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72372', 'place_name': 'Palestine', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 34.9663, 'longitude': -90.9049, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72392', 'place_name': 'Wheatley', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 34.9207, 'longitude': -91.1086, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72394', 'place_name': 'Widener', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'St. Francis', 'locality_code': '123', 'latitude': 35.0592, 'longitude': -90.6293, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72011', 'place_name': 'Bauxite', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Saline', 'locality_code': '125', 'latitude': 34.5091, 'longitude': -92.4828, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72015', 'place_name': 'Benton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Saline', 'locality_code': '125', 'latitude': 34.4933, 'longitude': -92.5896, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72018', 'place_name': 'Benton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Saline', 'locality_code': '125', 'latitude': 34.5645, 'longitude': -92.5868, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72022', 'place_name': 'Bryant', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Saline', 'locality_code': '125', 'latitude': 34.6068, 'longitude': -92.492, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72089', 'place_name': 'Bryant', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Saline', 'locality_code': '125', 'latitude': 34.5959, 'longitude': -92.489, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72122', 'place_name': 'Paron', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Saline', 'locality_code': '125', 'latitude': 34.7853, 'longitude': -92.7482, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72158', 'place_name': 'Benton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Saline', 'locality_code': '125', 'latitude': 34.635, 'longitude': -92.6597, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72167', 'place_name': 'Traskwood', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Saline', 'locality_code': '125', 'latitude': 34.4508, 'longitude': -92.6547, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72841', 'place_name': 'Harvey', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Scott', 'locality_code': '127', 'latitude': 34.8762, 'longitude': -93.764, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72926', 'place_name': 'Boles', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Scott', 'locality_code': '127', 'latitude': 34.7654, 'longitude': -94.0629, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72944', 'place_name': 'Mansfield', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Scott', 'locality_code': '127', 'latitude': 35.0432, 'longitude': -94.2204, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72950', 'place_name': 'Parks', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Scott', 'locality_code': '127', 'latitude': 34.8003, 'longitude': -93.9509, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72958', 'place_name': 'Waldron', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Scott', 'locality_code': '127', 'latitude': 34.9026, 'longitude': -94.0772, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72636', 'place_name': 'Gilbert', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Searcy', 'locality_code': '129', 'latitude': 35.9879, 'longitude': -92.7163, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72639', 'place_name': 'Harriet', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Searcy', 'locality_code': '129', 'latitude': 35.9991, 'longitude': -92.5042, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72645', 'place_name': 'Leslie', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Searcy', 'locality_code': '129', 'latitude': 35.8272, 'longitude': -92.5663, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72650', 'place_name': 'Marshall', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Searcy', 'locality_code': '129', 'latitude': 35.9267, 'longitude': -92.6402, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72669', 'place_name': 'Pindall', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Searcy', 'locality_code': '129', 'latitude': 36.0675, 'longitude': -92.8864, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72675', 'place_name': 'Saint Joe', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Searcy', 'locality_code': '129', 'latitude': 35.9877, 'longitude': -92.7928, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72686', 'place_name': 'Witts Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Searcy', 'locality_code': '129', 'latitude': 35.7681, 'longitude': -92.8668, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72901', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3653, 'longitude': -94.411, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72902', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3862, 'longitude': -94.4091, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72903', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3427, 'longitude': -94.3784, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72904', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.4051, 'longitude': -94.3872, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72905', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3859, 'longitude': -94.3985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72906', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3859, 'longitude': -94.3985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72908', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3219, 'longitude': -94.4028, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72913', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3859, 'longitude': -94.3985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72914', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3859, 'longitude': -94.3985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72916', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.2502, 'longitude': -94.3703, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72917', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3859, 'longitude': -94.3985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72918', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3859, 'longitude': -94.3985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72919', 'place_name': 'Fort Smith', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3859, 'longitude': -94.3985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72923', 'place_name': 'Barling', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.333, 'longitude': -94.3082, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72936', 'place_name': 'Greenwood', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.1955, 'longitude': -94.253, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72937', 'place_name': 'Hackett', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.1945, 'longitude': -94.3983, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72938', 'place_name': 'Hartford', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.0222, 'longitude': -94.3819, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72940', 'place_name': 'Huntington', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.0963, 'longitude': -94.3313, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72941', 'place_name': 'Lavaca', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.3661, 'longitude': -94.1917, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72945', 'place_name': 'Midland', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sebastian', 'locality_code': '131', 'latitude': 35.0932, 'longitude': -94.3533, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71823', 'place_name': 'Ben Lomond', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sevier', 'locality_code': '133', 'latitude': 33.8115, 'longitude': -94.1251, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71832', 'place_name': 'De Queen', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sevier', 'locality_code': '133', 'latitude': 34.0442, 'longitude': -94.3386, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71841', 'place_name': 'Gillham', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sevier', 'locality_code': '133', 'latitude': 34.157, 'longitude': -94.3165, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71842', 'place_name': 'Horatio', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sevier', 'locality_code': '133', 'latitude': 33.9392, 'longitude': -94.2959, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71846', 'place_name': 'Lockesburg', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sevier', 'locality_code': '133', 'latitude': 33.9306, 'longitude': -94.1276, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72482', 'place_name': 'Williford', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sharp', 'locality_code': '135', 'latitude': 36.2453, 'longitude': -91.3792, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72513', 'place_name': 'Ash Flat', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sharp', 'locality_code': '135', 'latitude': 36.2201, 'longitude': -91.6421, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72521', 'place_name': 'Cave City', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sharp', 'locality_code': '135', 'latitude': 35.9517, 'longitude': -91.5444, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72525', 'place_name': 'Cherokee Village', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sharp', 'locality_code': '135', 'latitude': 36.311, 'longitude': -91.597, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72529', 'place_name': 'Cherokee Village', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sharp', 'locality_code': '135', 'latitude': 36.3011, 'longitude': -91.5281, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72532', 'place_name': 'Evening Shade', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sharp', 'locality_code': '135', 'latitude': 36.0855, 'longitude': -91.598, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72542', 'place_name': 'Hardy', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sharp', 'locality_code': '135', 'latitude': 36.3227, 'longitude': -91.411, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72569', 'place_name': 'Poughkeepsie', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sharp', 'locality_code': '135', 'latitude': 36.0767, 'longitude': -91.4793, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72577', 'place_name': 'Sidney', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Sharp', 'locality_code': '135', 'latitude': 36.0664, 'longitude': -91.642, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72051', 'place_name': 'Fox', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Stone', 'locality_code': '137', 'latitude': 35.7682, 'longitude': -92.3043, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72533', 'place_name': 'Fifty Six', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Stone', 'locality_code': '137', 'latitude': 35.992, 'longitude': -92.2182, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72555', 'place_name': 'Marcella', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Stone', 'locality_code': '137', 'latitude': 35.7756, 'longitude': -91.8718, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72560', 'place_name': 'Mountain View', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Stone', 'locality_code': '137', 'latitude': 35.8208, 'longitude': -92.0389, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72567', 'place_name': 'Pleasant Grove', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Stone', 'locality_code': '137', 'latitude': 35.8265, 'longitude': -91.8958, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72657', 'place_name': 'Timbo', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Stone', 'locality_code': '137', 'latitude': 35.919, 'longitude': -92.1272, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72663', 'place_name': 'Onia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Stone', 'locality_code': '137', 'latitude': 35.9403, 'longitude': -92.3459, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72680', 'place_name': 'Timbo', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Stone', 'locality_code': '137', 'latitude': 35.8845, 'longitude': -92.2913, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71724', 'place_name': 'Calion', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Union', 'locality_code': '139', 'latitude': 33.3261, 'longitude': -92.5464, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71730', 'place_name': 'El Dorado', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Union', 'locality_code': '139', 'latitude': 33.2073, 'longitude': -92.6629, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71731', 'place_name': 'El Dorado', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Union', 'locality_code': '139', 'latitude': 33.2076, 'longitude': -92.6663, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71747', 'place_name': 'Huttig', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Union', 'locality_code': '139', 'latitude': 33.0459, 'longitude': -92.1942, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71749', 'place_name': 'Junction City', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Union', 'locality_code': '139', 'latitude': 33.0163, 'longitude': -92.7243, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71750', 'place_name': 'Lawson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Union', 'locality_code': '139', 'latitude': 33.1968, 'longitude': -92.4829, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71758', 'place_name': 'Mount Holly', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Union', 'locality_code': '139', 'latitude': 33.3085, 'longitude': -92.9443, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71759', 'place_name': 'Norphlet', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Union', 'locality_code': '139', 'latitude': 33.316, 'longitude': -92.6629, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71762', 'place_name': 'Smackover', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Union', 'locality_code': '139', 'latitude': 33.3398, 'longitude': -92.7442, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '71765', 'place_name': 'Strong', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Union', 'locality_code': '139', 'latitude': 33.1195, 'longitude': -92.3621, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72013', 'place_name': 'Bee Branch', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Van Buren', 'locality_code': '141', 'latitude': 35.4683, 'longitude': -92.3779, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72028', 'place_name': 'Choctaw', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Van Buren', 'locality_code': '141', 'latitude': 35.5773, 'longitude': -92.5456, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72031', 'place_name': 'Clinton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Van Buren', 'locality_code': '141', 'latitude': 35.6045, 'longitude': -92.4758, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72088', 'place_name': 'Fairfield Bay', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Van Buren', 'locality_code': '141', 'latitude': 35.6027, 'longitude': -92.2742, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72141', 'place_name': 'Scotland', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Van Buren', 'locality_code': '141', 'latitude': 35.508, 'longitude': -92.5867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72153', 'place_name': 'Shirley', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Van Buren', 'locality_code': '141', 'latitude': 35.6498, 'longitude': -92.3143, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72629', 'place_name': 'Dennard', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Van Buren', 'locality_code': '141', 'latitude': 35.7252, 'longitude': -92.5575, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72701', 'place_name': 'Fayetteville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.052, 'longitude': -94.1534, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72702', 'place_name': 'Fayetteville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.0626, 'longitude': -94.1574, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72703', 'place_name': 'Fayetteville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.0992, 'longitude': -94.1716, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72704', 'place_name': 'Fayetteville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.0877, 'longitude': -94.3093, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72717', 'place_name': 'Canehill', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 35.8477, 'longitude': -94.4441, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72727', 'place_name': 'Elkins', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.0177, 'longitude': -94.0073, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72728', 'place_name': 'Elm Springs', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.21, 'longitude': -94.2546, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72729', 'place_name': 'Evansville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 35.7823, 'longitude': -94.4638, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72730', 'place_name': 'Farmington', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.0436, 'longitude': -94.2539, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72735', 'place_name': 'Goshen', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.0876, 'longitude': -93.9666, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72737', 'place_name': 'Greenland', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 35.9942, 'longitude': -94.1752, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72741', 'place_name': 'Johnson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.1329, 'longitude': -94.1655, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72744', 'place_name': 'Lincoln', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 35.9569, 'longitude': -94.4272, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72749', 'place_name': 'Morrow', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 35.8654, 'longitude': -94.4432, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72753', 'place_name': 'Prairie Grove', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 35.9918, 'longitude': -94.3169, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72762', 'place_name': 'Springdale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.1835, 'longitude': -94.1762, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72764', 'place_name': 'Springdale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.1716, 'longitude': -94.0428, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72765', 'place_name': 'Springdale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.1725, 'longitude': -94.1535, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72766', 'place_name': 'Springdale', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.1867, 'longitude': -94.1288, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72769', 'place_name': 'Summers', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.0138, 'longitude': -94.5, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72770', 'place_name': 'Tontitown', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 36.15, 'longitude': -94.2429, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72774', 'place_name': 'West Fork', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 35.9082, 'longitude': -94.2304, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72959', 'place_name': 'Winslow', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Washington', 'locality_code': '143', 'latitude': 35.8312, 'longitude': -94.1187, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72010', 'place_name': 'Bald Knob', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.3113, 'longitude': -91.5502, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72012', 'place_name': 'Beebe', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.0937, 'longitude': -91.9074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72020', 'place_name': 'Bradford', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.4277, 'longitude': -91.519, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72045', 'place_name': 'El Paso', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.1142, 'longitude': -92.0901, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72052', 'place_name': 'Garner', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.1443, 'longitude': -91.7772, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72060', 'place_name': 'Griffithville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.1144, 'longitude': -91.6242, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72068', 'place_name': 'Higginson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.1903, 'longitude': -91.7108, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72081', 'place_name': 'Judsonia', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.325, 'longitude': -91.6491, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72082', 'place_name': 'Kensett', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.2388, 'longitude': -91.6731, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72085', 'place_name': 'Letona', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.3617, 'longitude': -91.8293, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72102', 'place_name': 'Mc Rae', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.1132, 'longitude': -91.8216, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '72121', 'place_name': 'Pangburn', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.4216, 'longitude': -91.796, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72136', 'place_name': 'Romance', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.2155, 'longitude': -92.0699, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72137', 'place_name': 'Rose Bud', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.3214, 'longitude': -92.062, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72139', 'place_name': 'Russell', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.3609, 'longitude': -91.5071, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72143', 'place_name': 'Searcy', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.2436, 'longitude': -91.7317, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72145', 'place_name': 'Searcy', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.2774, 'longitude': -91.7326, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72149', 'place_name': 'Searcy', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.2474, 'longitude': -91.7314, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72178', 'place_name': 'West Point', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'White', 'locality_code': '145', 'latitude': 35.2032, 'longitude': -91.6064, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72006', 'place_name': 'Augusta', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Woodruff', 'locality_code': '147', 'latitude': 35.2788, 'longitude': -91.3527, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72036', 'place_name': 'Cotton Plant', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Woodruff', 'locality_code': '147', 'latitude': 35.0178, 'longitude': -91.229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72059', 'place_name': 'Gregory', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Woodruff', 'locality_code': '147', 'latitude': 35.1554, 'longitude': -91.3432, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72074', 'place_name': 'Hunter', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Woodruff', 'locality_code': '147', 'latitude': 35.0529, 'longitude': -91.1262, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72101', 'place_name': 'Mc Crory', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Woodruff', 'locality_code': '147', 'latitude': 35.2473, 'longitude': -91.1793, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '72123', 'place_name': 'Patterson', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Woodruff', 'locality_code': '147', 'latitude': 35.2588, 'longitude': -91.237, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72824', 'place_name': 'Belleville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 35.1038, 'longitude': -93.4518, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72827', 'place_name': 'Bluffton', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 34.9016, 'longitude': -93.5919, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72828', 'place_name': 'Briggsville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 34.9161, 'longitude': -93.5157, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72829', 'place_name': 'Centerville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 35.1018, 'longitude': -93.1773, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72833', 'place_name': 'Danville', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 35.0495, 'longitude': -93.3929, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72834', 'place_name': 'Dardanelle', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 35.1955, 'longitude': -93.1873, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72838', 'place_name': 'Gravelly', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 34.8881, 'longitude': -93.6802, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72842', 'place_name': 'Havana', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 35.0832, 'longitude': -93.5955, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72853', 'place_name': 'Ola', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 35.0309, 'longitude': -93.2136, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72857', 'place_name': 'Plainview', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 34.9668, 'longitude': -93.3099, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '72860', 'place_name': 'Rover', 'state': 'Arkansas', 'state_ab': 'AR', 'county': 'Yell', 'locality_code': '149', 'latitude': 34.9475, 'longitude': -93.4017, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85920', 'place_name': 'Alpine', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 33.8279, 'longitude': -109.1283, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85924', 'place_name': 'Concho', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 34.4458, 'longitude': -109.6741, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85925', 'place_name': 'Eagar', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 34.1077, 'longitude': -109.294, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85927', 'place_name': 'Greer', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 34.0052, 'longitude': -109.4664, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85930', 'place_name': 'Mcnary', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 34.0754, 'longitude': -109.8532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85932', 'place_name': 'Nutrioso', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 33.9531, 'longitude': -109.2092, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85936', 'place_name': 'Saint Johns', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 34.501, 'longitude': -109.3796, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85938', 'place_name': 'Springerville', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 34.1702, 'longitude': -109.3315, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85940', 'place_name': 'Vernon', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 34.2575, 'longitude': -109.6929, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86028', 'place_name': 'Petrified Forest Natl Pk', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.2375, 'longitude': -109.5229, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86502', 'place_name': 'Chambers', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.2375, 'longitude': -109.5229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86503', 'place_name': 'Chinle', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 36.1304, 'longitude': -109.6037, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86504', 'place_name': 'Fort Defiance', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.7445, 'longitude': -109.0765, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86505', 'place_name': 'Ganado', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.7114, 'longitude': -109.542, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86506', 'place_name': 'Houck', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.2831, 'longitude': -109.207, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86507', 'place_name': 'Lukachukai', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 36.4181, 'longitude': -109.2446, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86508', 'place_name': 'Lupton', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.3539, 'longitude': -109.0537, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86511', 'place_name': 'Saint Michaels', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.6447, 'longitude': -109.0956, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86512', 'place_name': 'Sanders', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.2164, 'longitude': -109.3337, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86514', 'place_name': 'Teec Nos Pos', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 36.7797, 'longitude': -109.359, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86515', 'place_name': 'Window Rock', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.6676, 'longitude': -109.0784, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86535', 'place_name': 'Dennehotso', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 36.7773, 'longitude': -109.861, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86538', 'place_name': 'Many Farms', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 36.4083, 'longitude': -109.634, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86540', 'place_name': 'Nazlini', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.8964, 'longitude': -109.4487, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86544', 'place_name': 'Red Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 35.2375, 'longitude': -109.5229, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86545', 'place_name': 'Rock Point', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 36.7181, 'longitude': -109.6259, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86547', 'place_name': 'Round Rock', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 36.5131, 'longitude': -109.4734, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86556', 'place_name': 'Tsaile', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Apache', 'locality_code': '1', 'latitude': 36.3071, 'longitude': -109.2176, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85602', 'place_name': 'Benson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.9883, 'longitude': -110.2941, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85603', 'place_name': 'Bisbee', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.4086, 'longitude': -109.9117, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85605', 'place_name': 'Bowie', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 32.3265, 'longitude': -109.487, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85606', 'place_name': 'Cochise', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 32.0979, 'longitude': -109.9239, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85607', 'place_name': 'Douglas', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.3511, 'longitude': -109.5447, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85608', 'place_name': 'Douglas', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.4151, 'longitude': -109.596, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85609', 'place_name': 'Dragoon', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 32.0281, 'longitude': -110.0387, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85610', 'place_name': 'Elfrida', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.7139, 'longitude': -109.6193, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85613', 'place_name': 'Fort Huachuca', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.5587, 'longitude': -110.3441, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85615', 'place_name': 'Hereford', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.4035, 'longitude': -110.2047, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85616', 'place_name': 'Huachuca City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.6639, 'longitude': -110.3334, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85617', 'place_name': 'Mc Neal', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.5121, 'longitude': -109.8438, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85620', 'place_name': 'Naco', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.3373, 'longitude': -109.9413, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85625', 'place_name': 'Pearce', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.8885, 'longitude': -109.6119, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85626', 'place_name': 'Pirtleville', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.3572, 'longitude': -109.5635, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85627', 'place_name': 'Pomerene', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.9995, 'longitude': -110.2862, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85630', 'place_name': 'Saint David', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.8973, 'longitude': -110.2154, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85632', 'place_name': 'San Simon', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 32.0423, 'longitude': -109.1748, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85635', 'place_name': 'Sierra Vista', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.5365, 'longitude': -110.2666, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85636', 'place_name': 'Sierra Vista', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.6687, 'longitude': -110.2801, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85638', 'place_name': 'Tombstone', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.7216, 'longitude': -110.0584, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85643', 'place_name': 'Willcox', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 32.373, 'longitude': -109.8631, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85644', 'place_name': 'Willcox', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 32.2529, 'longitude': -109.832, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85650', 'place_name': 'Sierra Vista', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.4892, 'longitude': -110.2153, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85655', 'place_name': 'Douglas', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.3447, 'longitude': -109.5468, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85670', 'place_name': 'Fort Huachuca', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.8801, 'longitude': -109.7543, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85671', 'place_name': 'Sierra Vista', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Cochise', 'locality_code': '3', 'latitude': 31.5545, 'longitude': -110.3037, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85931', 'place_name': 'Forest Lakes', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 34.4513, 'longitude': -110.8644, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86001', 'place_name': 'Flagstaff', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.1859, 'longitude': -111.662, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86002', 'place_name': 'Flagstaff', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.1981, 'longitude': -111.6513, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86003', 'place_name': 'Flagstaff', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.1981, 'longitude': -111.6513, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86004', 'place_name': 'Flagstaff', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.2257, 'longitude': -111.5741, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86005', 'place_name': 'Flagstaff', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.1545, 'longitude': -111.6789, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86011', 'place_name': 'Flagstaff', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.1981, 'longitude': -111.6513, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86015', 'place_name': 'Bellemont', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.2381, 'longitude': -111.8335, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86016', 'place_name': 'Gray Mountain', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.7504, 'longitude': -111.6188, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86017', 'place_name': 'Munds Park', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 34.9412, 'longitude': -111.641, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86018', 'place_name': 'Parks', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.2563, 'longitude': -111.95, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86020', 'place_name': 'Cameron', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.9922, 'longitude': -111.5038, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86022', 'place_name': 'Fredonia', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 36.9044, 'longitude': -112.4979, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86023', 'place_name': 'Grand Canyon', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.9421, 'longitude': -112.1309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86024', 'place_name': 'Happy Jack', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 34.6616, 'longitude': -111.3404, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86035', 'place_name': 'Leupp', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.3365, 'longitude': -110.9927, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86036', 'place_name': 'Marble Canyon', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 36.737, 'longitude': -111.8229, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86038', 'place_name': 'Mormon Lake', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 34.9083, 'longitude': -111.463, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86040', 'place_name': 'Page', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 36.9147, 'longitude': -111.4558, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86044', 'place_name': 'Tonalea', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 36.7093, 'longitude': -110.8411, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86045', 'place_name': 'Tuba City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 36.1037, 'longitude': -111.2686, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86046', 'place_name': 'Williams', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 35.5434, 'longitude': -112.1707, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86052', 'place_name': 'North Rim', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 36.2105, 'longitude': -112.0613, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86053', 'place_name': 'Kaibeto', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 36.4025, 'longitude': -111.3518, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86336', 'place_name': 'Sedona', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 34.8266, 'longitude': -111.7506, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86339', 'place_name': 'Sedona', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 34.8697, 'longitude': -111.761, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86351', 'place_name': 'Sedona', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 34.7784, 'longitude': -111.7851, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86435', 'place_name': 'Supai', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Coconino', 'locality_code': '5', 'latitude': 36.2242, 'longitude': -112.6932, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85135', 'place_name': 'Hayden', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 33.0041, 'longitude': -110.7868, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85192', 'place_name': 'Winkelman', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 33.0057, 'longitude': -110.7727, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85501', 'place_name': 'Globe', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 33.4024, 'longitude': -110.7892, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85502', 'place_name': 'Globe', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 33.3942, 'longitude': -110.7865, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85532', 'place_name': 'Claypool', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 33.4154, 'longitude': -110.8149, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85539', 'place_name': 'Miami', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 33.3992, 'longitude': -110.8687, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85541', 'place_name': 'Payson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 34.2198, 'longitude': -111.2878, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85542', 'place_name': 'Peridot', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 33.3103, 'longitude': -110.4554, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85544', 'place_name': 'Pine', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 34.3435, 'longitude': -111.5353, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85545', 'place_name': 'Roosevelt', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 33.6358, 'longitude': -110.9749, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85547', 'place_name': 'Payson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 34.2575, 'longitude': -111.2878, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85550', 'place_name': 'San Carlos', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 33.3456, 'longitude': -110.455, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85553', 'place_name': 'Tonto Basin', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 33.8317, 'longitude': -111.2946, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85554', 'place_name': 'Young', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Gila', 'locality_code': '7', 'latitude': 34.1014, 'longitude': -110.9637, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85530', 'place_name': 'Bylas', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Graham', 'locality_code': '9', 'latitude': 33.1265, 'longitude': -110.117, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85531', 'place_name': 'Central', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Graham', 'locality_code': '9', 'latitude': 32.8692, 'longitude': -109.7878, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85535', 'place_name': 'Eden', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Graham', 'locality_code': '9', 'latitude': 32.9612, 'longitude': -109.8954, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85536', 'place_name': 'Fort Thomas', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Graham', 'locality_code': '9', 'latitude': 33.0333, 'longitude': -109.9717, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85543', 'place_name': 'Pima', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Graham', 'locality_code': '9', 'latitude': 32.9097, 'longitude': -109.856, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85546', 'place_name': 'Safford', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Graham', 'locality_code': '9', 'latitude': 32.8295, 'longitude': -109.6266, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85548', 'place_name': 'Safford', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Graham', 'locality_code': '9', 'latitude': 32.797, 'longitude': -109.7522, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85551', 'place_name': 'Solomon', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Graham', 'locality_code': '9', 'latitude': 32.8126, 'longitude': -109.634, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85552', 'place_name': 'Thatcher', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Graham', 'locality_code': '9', 'latitude': 32.8504, 'longitude': -109.7461, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85533', 'place_name': 'Clifton', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Greenlee', 'locality_code': '11', 'latitude': 33.1323, 'longitude': -109.2462, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85534', 'place_name': 'Duncan', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Greenlee', 'locality_code': '11', 'latitude': 32.881, 'longitude': -109.2157, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85540', 'place_name': 'Morenci', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Greenlee', 'locality_code': '11', 'latitude': 33.0787, 'longitude': -109.3654, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85922', 'place_name': 'Blue', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Greenlee', 'locality_code': '11', 'latitude': 33.6512, 'longitude': -109.0685, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85325', 'place_name': 'Bouse', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'La Paz', 'locality_code': '12', 'latitude': 33.9578, 'longitude': -114.0036, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85328', 'place_name': 'Cibola', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'La Paz', 'locality_code': '12', 'latitude': 33.3164, 'longitude': -114.665, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85334', 'place_name': 'Ehrenberg', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'La Paz', 'locality_code': '12', 'latitude': 33.6177, 'longitude': -114.5077, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85344', 'place_name': 'Parker', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'La Paz', 'locality_code': '12', 'latitude': 34.15, 'longitude': -114.2891, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85346', 'place_name': 'Quartzsite', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'La Paz', 'locality_code': '12', 'latitude': 33.7292, 'longitude': -114.1925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85348', 'place_name': 'Salome', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'La Paz', 'locality_code': '12', 'latitude': 33.7481, 'longitude': -113.5715, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85357', 'place_name': 'Wenden', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'La Paz', 'locality_code': '12', 'latitude': 34.0422, 'longitude': -113.458, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85359', 'place_name': 'Quartzsite', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'La Paz', 'locality_code': '12', 'latitude': 33.6669, 'longitude': -114.2396, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85371', 'place_name': 'Poston', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'La Paz', 'locality_code': '12', 'latitude': 33.9906, 'longitude': -114.3963, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85001', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85002', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85003', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4511, 'longitude': -112.0774, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85004', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4557, 'longitude': -112.0686, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85005', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85006', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.465, 'longitude': -112.0474, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85007', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4523, 'longitude': -112.0893, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85008', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4665, 'longitude': -111.9984, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85009', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4564, 'longitude': -112.1284, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85010', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85011', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85012', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5097, 'longitude': -112.0678, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85013', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5085, 'longitude': -112.0827, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85014', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5103, 'longitude': -112.0556, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85015', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5082, 'longitude': -112.1011, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85016', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5021, 'longitude': -112.0305, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85017', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5153, 'longitude': -112.1212, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85018', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4958, 'longitude': -111.9883, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85019', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5123, 'longitude': -112.1417, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85020', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5623, 'longitude': -112.0559, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85021', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.56, 'longitude': -112.0927, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85022', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6315, 'longitude': -112.052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85023', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6324, 'longitude': -112.1118, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85024', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6617, 'longitude': -112.037, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85025', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85026', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85027', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6819, 'longitude': -112.0996, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85028', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5851, 'longitude': -112.0087, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85029', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5961, 'longitude': -112.1199, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85030', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85031', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4939, 'longitude': -112.1696, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85032', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6238, 'longitude': -112.0044, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85033', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4944, 'longitude': -112.2132, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85034', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4413, 'longitude': -112.0421, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85035', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4724, 'longitude': -112.1832, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85036', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85037', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4913, 'longitude': -112.2468, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85038', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85039', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85040', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4061, 'longitude': -112.0265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85041', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3889, 'longitude': -112.0954, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85042', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3794, 'longitude': -112.0283, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85043', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4491, 'longitude': -112.1972, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85044', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3291, 'longitude': -111.9943, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85045', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3022, 'longitude': -112.1226, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85046', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85048', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.316, 'longitude': -112.0669, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85050', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6863, 'longitude': -111.9963, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85051', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5591, 'longitude': -112.1332, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85053', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6299, 'longitude': -112.1316, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85054', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6731, 'longitude': -111.9461, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85060', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85061', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85062', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85063', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85064', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85065', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85066', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85067', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85068', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85069', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85070', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85071', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85072', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85073', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85074', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85075', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85076', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85078', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85079', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85080', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85082', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85083', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.7352, 'longitude': -112.1294, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85085', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.7529, 'longitude': -112.0893, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85086', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.8155, 'longitude': -112.1202, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85087', 'place_name': 'New River', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.9235, 'longitude': -112.1279, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85097', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85098', 'place_name': 'Phoenix', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4484, 'longitude': -112.074, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85127', 'place_name': 'Chandler Heights', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.2125, 'longitude': -111.697, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85142', 'place_name': 'Queen Creek', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.2487, 'longitude': -111.6343, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85190', 'place_name': 'Tortilla Flat', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5264, 'longitude': -111.3892, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85201', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4317, 'longitude': -111.8469, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85202', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3851, 'longitude': -111.8724, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85203', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.437, 'longitude': -111.8057, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85204', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3992, 'longitude': -111.7896, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85205', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4368, 'longitude': -111.7129, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85206', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4026, 'longitude': -111.7242, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85207', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4321, 'longitude': -111.6426, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85208', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3984, 'longitude': -111.6513, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85209', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3782, 'longitude': -111.6406, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85210', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3887, 'longitude': -111.8428, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85211', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4663, 'longitude': -111.8373, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85212', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3425, 'longitude': -111.6353, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85213', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4367, 'longitude': -111.7731, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85214', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4125, 'longitude': -111.8319, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85215', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4707, 'longitude': -111.7188, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85216', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4125, 'longitude': -111.8319, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85224', 'place_name': 'Chandler', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3301, 'longitude': -111.8632, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85225', 'place_name': 'Chandler', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3105, 'longitude': -111.8239, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85226', 'place_name': 'Chandler', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3092, 'longitude': -111.9198, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85233', 'place_name': 'Gilbert', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3354, 'longitude': -111.8153, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85234', 'place_name': 'Gilbert', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3527, 'longitude': -111.7809, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85236', 'place_name': 'Higley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3024, 'longitude': -111.6969, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85244', 'place_name': 'Chandler', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3213, 'longitude': -111.8888, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85246', 'place_name': 'Chandler', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3062, 'longitude': -111.8413, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85248', 'place_name': 'Chandler', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.2509, 'longitude': -111.8593, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85249', 'place_name': 'Chandler', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.2414, 'longitude': -111.7745, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85250', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5218, 'longitude': -111.9049, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85251', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4936, 'longitude': -111.9167, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85252', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4995, 'longitude': -111.8684, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85253', 'place_name': 'Paradise Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5494, 'longitude': -111.9565, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85254', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6165, 'longitude': -111.9554, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85255', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6968, 'longitude': -111.8892, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85256', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4858, 'longitude': -111.8533, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85257', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4669, 'longitude': -111.9151, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85258', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5647, 'longitude': -111.8931, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85259', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5879, 'longitude': -111.8404, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85260', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6013, 'longitude': -111.8867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85261', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5092, 'longitude': -111.899, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85262', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.7752, 'longitude': -111.7791, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85263', 'place_name': 'Rio Verde', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.7225, 'longitude': -111.6757, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85264', 'place_name': 'Fort Mcdowell', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6118, 'longitude': -111.6806, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85266', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.7669, 'longitude': -111.9182, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85267', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5092, 'longitude': -111.899, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85268', 'place_name': 'Fountain Hills', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6085, 'longitude': -111.7237, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85269', 'place_name': 'Fountain Hills', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6117, 'longitude': -111.7174, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85271', 'place_name': 'Scottsdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5092, 'longitude': -111.899, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85274', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4125, 'longitude': -111.8319, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85275', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4125, 'longitude': -111.8319, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85277', 'place_name': 'Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4125, 'longitude': -111.8319, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85280', 'place_name': 'Tempe', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4014, 'longitude': -111.9313, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85281', 'place_name': 'Tempe', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4227, 'longitude': -111.9261, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85282', 'place_name': 'Tempe', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3917, 'longitude': -111.9249, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85283', 'place_name': 'Tempe', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3665, 'longitude': -111.9312, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85284', 'place_name': 'Tempe', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3363, 'longitude': -111.9197, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85285', 'place_name': 'Tempe', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4148, 'longitude': -111.9093, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85286', 'place_name': 'Chandler', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.2711, 'longitude': -111.8311, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85287', 'place_name': 'Tempe', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4285, 'longitude': -111.9349, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85295', 'place_name': 'Gilbert', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3054, 'longitude': -111.7408, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85296', 'place_name': 'Gilbert', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3354, 'longitude': -111.7406, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85297', 'place_name': 'Gilbert', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.2781, 'longitude': -111.7096, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85298', 'place_name': 'Gilbert', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.2522, 'longitude': -111.7022, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85299', 'place_name': 'Gilbert', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3528, 'longitude': -111.789, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85301', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5311, 'longitude': -112.1767, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85302', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5675, 'longitude': -112.1753, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85303', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5262, 'longitude': -112.2149, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85304', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5943, 'longitude': -112.1746, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85305', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5291, 'longitude': -112.2482, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85306', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6239, 'longitude': -112.1776, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85307', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5376, 'longitude': -112.3137, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85308', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6539, 'longitude': -112.1694, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85309', 'place_name': 'Luke Air Force Base', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5387, 'longitude': -112.186, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85310', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.7047, 'longitude': -112.1641, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85311', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5387, 'longitude': -112.186, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85312', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5387, 'longitude': -112.186, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85318', 'place_name': 'Glendale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5387, 'longitude': -112.186, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85320', 'place_name': 'Aguila', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.9186, 'longitude': -113.2134, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85322', 'place_name': 'Arlington', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3133, 'longitude': -112.7891, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85323', 'place_name': 'Avondale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4321, 'longitude': -112.3438, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85326', 'place_name': 'Buckeye', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3703, 'longitude': -112.5838, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85327', 'place_name': 'Cave Creek', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.8333, 'longitude': -111.9508, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85329', 'place_name': 'Cashion', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4353, 'longitude': -112.2979, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85331', 'place_name': 'Cave Creek', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.8851, 'longitude': -111.9349, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85335', 'place_name': 'El Mirage', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6082, 'longitude': -112.3241, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85337', 'place_name': 'Gila Bend', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 32.9306, 'longitude': -112.7468, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85338', 'place_name': 'Goodyear', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4368, 'longitude': -112.3834, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85339', 'place_name': 'Laveen', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3436, 'longitude': -112.1716, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85340', 'place_name': 'Litchfield Park', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5098, 'longitude': -112.4135, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85342', 'place_name': 'Morristown', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.8567, 'longitude': -112.6232, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85343', 'place_name': 'Palo Verde', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.3481, 'longitude': -112.6774, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85345', 'place_name': 'Peoria', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5761, 'longitude': -112.2344, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85351', 'place_name': 'Sun City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6061, 'longitude': -112.2797, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85353', 'place_name': 'Tolleson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4347, 'longitude': -112.2774, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85354', 'place_name': 'Tonopah', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4228, 'longitude': -112.9528, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85355', 'place_name': 'Waddell', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5673, 'longitude': -112.4387, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85358', 'place_name': 'Wickenburg', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.9686, 'longitude': -112.7296, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85361', 'place_name': 'Wittmann', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.7637, 'longitude': -112.6142, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85363', 'place_name': 'Youngtown', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5908, 'longitude': -112.3013, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85372', 'place_name': 'Sun City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5975, 'longitude': -112.2718, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85373', 'place_name': 'Sun City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6588, 'longitude': -112.3214, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85374', 'place_name': 'Surprise', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.63, 'longitude': -112.3314, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85375', 'place_name': 'Sun City West', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6856, 'longitude': -112.3659, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85376', 'place_name': 'Sun City West', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.662, 'longitude': -112.3413, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85377', 'place_name': 'Carefree', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.824, 'longitude': -111.913, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85378', 'place_name': 'Surprise', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6306, 'longitude': -112.3332, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85379', 'place_name': 'Surprise', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6021, 'longitude': -112.3736, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85380', 'place_name': 'Peoria', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5806, 'longitude': -112.2374, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85381', 'place_name': 'Peoria', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6048, 'longitude': -112.2237, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85382', 'place_name': 'Peoria', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6308, 'longitude': -112.2072, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85383', 'place_name': 'Peoria', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.7169, 'longitude': -112.238, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85385', 'place_name': 'Peoria', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.5806, 'longitude': -112.2374, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85387', 'place_name': 'Surprise', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.7129, 'longitude': -112.4375, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85388', 'place_name': 'Surprise', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.6134, 'longitude': -112.4512, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85390', 'place_name': 'Wickenburg', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.8944, 'longitude': -112.8603, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85392', 'place_name': 'Avondale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.4777, 'longitude': -112.3093, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85395', 'place_name': 'Goodyear', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.479, 'longitude': -112.3947, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85396', 'place_name': 'Buckeye', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Maricopa', 'locality_code': '13', 'latitude': 33.468, 'longitude': -112.4787, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85360', 'place_name': 'Wikieup', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 34.7033, 'longitude': -113.6113, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86021', 'place_name': 'Colorado City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 36.9903, 'longitude': -112.9758, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86401', 'place_name': 'Kingman', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.1328, 'longitude': -113.7033, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86402', 'place_name': 'Kingman', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.2632, 'longitude': -114.0637, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86403', 'place_name': 'Lake Havasu City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 34.4814, 'longitude': -114.3483, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86404', 'place_name': 'Lake Havasu City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 34.5575, 'longitude': -114.3307, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86405', 'place_name': 'Lake Havasu City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 34.4839, 'longitude': -114.3225, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86406', 'place_name': 'Lake Havasu City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 34.4228, 'longitude': -114.125, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86409', 'place_name': 'Kingman', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.2633, 'longitude': -114.0223, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86411', 'place_name': 'Hackberry', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.3692, 'longitude': -113.7272, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86412', 'place_name': 'Hualapai', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.3972, 'longitude': -113.8432, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86413', 'place_name': 'Golden Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.3002, 'longitude': -114.2215, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86426', 'place_name': 'Fort Mohave', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.0052, 'longitude': -114.5687, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86427', 'place_name': 'Fort Mohave', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.0043, 'longitude': -114.5812, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86429', 'place_name': 'Bullhead City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.1715, 'longitude': -114.5386, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86430', 'place_name': 'Bullhead City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.1473, 'longitude': -114.5433, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86431', 'place_name': 'Chloride', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.3896, 'longitude': -114.2221, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86432', 'place_name': 'Littlefield', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 36.8872, 'longitude': -113.9297, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86433', 'place_name': 'Oatman', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.0285, 'longitude': -114.3837, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86434', 'place_name': 'Peach Springs', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.5378, 'longitude': -113.4202, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86436', 'place_name': 'Topock', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 34.7784, 'longitude': -114.4817, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86437', 'place_name': 'Valentine', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.3788, 'longitude': -113.6141, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86438', 'place_name': 'Yucca', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 34.8722, 'longitude': -114.1494, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86439', 'place_name': 'Bullhead City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.1478, 'longitude': -114.5683, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86440', 'place_name': 'Mohave Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 34.8929, 'longitude': -114.5951, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86441', 'place_name': 'Dolan Springs', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.5692, 'longitude': -114.3777, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86442', 'place_name': 'Bullhead City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.106, 'longitude': -114.5947, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86443', 'place_name': 'Temple Bar Marina', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.2106, 'longitude': -114.1792, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86444', 'place_name': 'Meadview', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.9822, 'longitude': -114.0775, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86445', 'place_name': 'Willow Beach', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 35.7759, 'longitude': -114.5001, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86446', 'place_name': 'Mohave Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Mohave', 'locality_code': '15', 'latitude': 34.8499, 'longitude': -114.5917, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85901', 'place_name': 'Show Low', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.2998, 'longitude': -110, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85902', 'place_name': 'Show Low', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.2981, 'longitude': -110.0352, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85911', 'place_name': 'Cibecue', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.0448, 'longitude': -110.4854, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85912', 'place_name': 'White Mountain Lake', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.2666, 'longitude': -110.2031, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85923', 'place_name': 'Clay Springs', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.3617, 'longitude': -110.2954, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85926', 'place_name': 'Fort Apache', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 33.7906, 'longitude': -109.9887, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85928', 'place_name': 'Heber', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.41, 'longitude': -110.5883, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85929', 'place_name': 'Lakeside', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.1662, 'longitude': -109.9869, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85933', 'place_name': 'Overgaard', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.4086, 'longitude': -110.56, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85934', 'place_name': 'Pinedale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.3003, 'longitude': -110.2457, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85935', 'place_name': 'Pinetop', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.1175, 'longitude': -109.9197, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85937', 'place_name': 'Snowflake', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.4959, 'longitude': -110.0807, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85939', 'place_name': 'Taylor', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.439, 'longitude': -110.0858, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85941', 'place_name': 'Whiteriver', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 33.8021, 'longitude': -109.9937, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85942', 'place_name': 'Woodruff', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.7814, 'longitude': -110.0435, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86025', 'place_name': 'Holbrook', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.9085, 'longitude': -110.1434, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86029', 'place_name': 'Sun Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.9806, 'longitude': -110.0582, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86030', 'place_name': 'Hotevilla', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 35.9278, 'longitude': -110.6729, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86031', 'place_name': 'Indian Wells', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 35.4056, 'longitude': -110.0848, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86032', 'place_name': 'Joseph City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 34.9814, 'longitude': -110.3373, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86033', 'place_name': 'Kayenta', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 36.6883, 'longitude': -110.2652, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86034', 'place_name': 'Keams Canyon', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 35.8082, 'longitude': -110.2845, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86039', 'place_name': 'Kykotsmovi Village', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 35.8742, 'longitude': -110.6235, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86042', 'place_name': 'Polacca', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 35.8617, 'longitude': -110.3875, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86043', 'place_name': 'Second Mesa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 35.7933, 'longitude': -110.5051, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86047', 'place_name': 'Winslow', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 35.0242, 'longitude': -110.6974, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86054', 'place_name': 'Shonto', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 36.6159, 'longitude': -110.6477, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86510', 'place_name': 'Pinon', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 36.1002, 'longitude': -110.2211, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86520', 'place_name': 'Blue Gap', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Navajo', 'locality_code': '17', 'latitude': 36.1708, 'longitude': -109.9465, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85321', 'place_name': 'Ajo', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2295, 'longitude': -112.6542, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85341', 'place_name': 'Lukeville', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 31.8826, 'longitude': -112.8157, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85601', 'place_name': 'Arivaca', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 31.5885, 'longitude': -111.316, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85614', 'place_name': 'Green Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 31.8543, 'longitude': -111.0003, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85619', 'place_name': 'Mount Lemmon', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.3763, 'longitude': -110.7605, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85622', 'place_name': 'Green Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 31.8269, 'longitude': -111.0755, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85629', 'place_name': 'Sahuarita', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 31.9452, 'longitude': -111.0002, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85633', 'place_name': 'Sasabe', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 31.4887, 'longitude': -111.5421, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85634', 'place_name': 'Sells', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.0315, 'longitude': -112.0065, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85639', 'place_name': 'Topawa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 31.814, 'longitude': -111.8257, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85641', 'place_name': 'Vail', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.0027, 'longitude': -110.7053, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85652', 'place_name': 'Cortaro', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.4201, 'longitude': -111.1132, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85653', 'place_name': 'Marana', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.4047, 'longitude': -111.2736, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85654', 'place_name': 'Rillito', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.4148, 'longitude': -111.1562, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85701', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2139, 'longitude': -110.9694, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85702', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85703', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85704', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.3379, 'longitude': -110.9855, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85705', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2691, 'longitude': -110.9845, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85706', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.1392, 'longitude': -110.9451, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85707', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.1696, 'longitude': -110.8751, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85708', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.18, 'longitude': -110.8693, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85709', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2008, 'longitude': -110.898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85710', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2138, 'longitude': -110.824, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85711', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2127, 'longitude': -110.8829, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85712', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.25, 'longitude': -110.8869, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85713', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.1941, 'longitude': -110.9739, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85714', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.1707, 'longitude': -110.9719, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85715', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2519, 'longitude': -110.82, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85716', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2468, 'longitude': -110.9222, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85717', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85718', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.3112, 'longitude': -110.9179, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85719', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2474, 'longitude': -110.9491, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85720', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85721', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2338, 'longitude': -110.95, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85722', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85723', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85724', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2406, 'longitude': -110.9443, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85725', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85726', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2027, 'longitude': -110.9453, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85728', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85730', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.181, 'longitude': -110.819, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85731', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85732', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85733', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85734', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.0651, 'longitude': -110.9353, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85735', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.093, 'longitude': -111.3472, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85736', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 31.9011, 'longitude': -111.3702, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85737', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.4142, 'longitude': -110.9466, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85738', 'place_name': 'Catalina', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.5056, 'longitude': -110.9211, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85739', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.465, 'longitude': -110.8922, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85740', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85741', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.3472, 'longitude': -111.0419, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85742', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.4076, 'longitude': -111.065, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85743', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.3366, 'longitude': -111.1771, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85744', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85745', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2434, 'longitude': -111.0179, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85746', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.1422, 'longitude': -111.0506, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85747', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.0984, 'longitude': -110.7272, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85748', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.215, 'longitude': -110.7758, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85749', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2733, 'longitude': -110.7658, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85750', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2974, 'longitude': -110.8404, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85751', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85752', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85754', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85755', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.4227, 'longitude': -110.9768, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85756', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.0839, 'longitude': -110.9004, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85757', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.1336, 'longitude': -111.0973, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85775', 'place_name': 'Tucson', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pima', 'locality_code': '19', 'latitude': 32.2217, 'longitude': -110.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85117', 'place_name': 'Apache Junction', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.3284, 'longitude': -111.327, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85118', 'place_name': 'Gold Canyon', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.3284, 'longitude': -111.3502, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85119', 'place_name': 'Apache Junction', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.4001, 'longitude': -111.5028, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85120', 'place_name': 'Apache Junction', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.3931, 'longitude': -111.5768, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85121', 'place_name': 'Bapchule', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.1405, 'longitude': -111.9128, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85122', 'place_name': 'Casa Grande', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.8905, 'longitude': -111.754, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85123', 'place_name': 'Arizona City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.7559, 'longitude': -111.671, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85128', 'place_name': 'Coolidge', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.9574, 'longitude': -111.5344, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85130', 'place_name': 'Casa Grande', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.8151, 'longitude': -111.7054, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85131', 'place_name': 'Eloy', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.7509, 'longitude': -111.5833, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85132', 'place_name': 'Florence', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.9969, 'longitude': -111.3612, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85137', 'place_name': 'Kearny', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.0594, 'longitude': -110.9123, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85138', 'place_name': 'Maricopa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.0073, 'longitude': -111.9324, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85139', 'place_name': 'Maricopa', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.9576, 'longitude': -112.0534, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85140', 'place_name': 'San Tan Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.1911, 'longitude': -111.528, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85141', 'place_name': 'Picacho', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.6686, 'longitude': -111.4549, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85143', 'place_name': 'San Tan Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.1911, 'longitude': -111.528, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85145', 'place_name': 'Red Rock', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.58, 'longitude': -111.341, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85147', 'place_name': 'Sacaton', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.1234, 'longitude': -111.7384, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85172', 'place_name': 'Stanfield', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.8823, 'longitude': -111.966, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85173', 'place_name': 'Superior', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.2887, 'longitude': -111.0985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85178', 'place_name': 'Apache Junction', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 33.405, 'longitude': -111.547, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85191', 'place_name': 'Valley Farms', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.9827, 'longitude': -111.4429, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85193', 'place_name': 'Casa Grande', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.8554, 'longitude': -111.7973, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85194', 'place_name': 'Casa Grande', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.8984, 'longitude': -111.6261, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85618', 'place_name': 'Mammoth', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.7239, 'longitude': -110.644, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85623', 'place_name': 'Oracle', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.6005, 'longitude': -110.7961, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85631', 'place_name': 'San Manuel', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.6209, 'longitude': -110.5992, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85658', 'place_name': 'Marana', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Pinal', 'locality_code': '21', 'latitude': 32.4305, 'longitude': -111.1459, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85611', 'place_name': 'Elgin', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Santa Cruz', 'locality_code': '23', 'latitude': 31.6598, 'longitude': -110.5254, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85621', 'place_name': 'Nogales', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Santa Cruz', 'locality_code': '23', 'latitude': 31.377, 'longitude': -110.9435, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85624', 'place_name': 'Patagonia', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Santa Cruz', 'locality_code': '23', 'latitude': 31.5353, 'longitude': -110.6968, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85628', 'place_name': 'Nogales', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Santa Cruz', 'locality_code': '23', 'latitude': 31.532, 'longitude': -110.9093, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85637', 'place_name': 'Sonoita', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Santa Cruz', 'locality_code': '23', 'latitude': 31.6731, 'longitude': -110.6188, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85640', 'place_name': 'Tumacacori', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Santa Cruz', 'locality_code': '23', 'latitude': 31.5696, 'longitude': -111.0534, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85645', 'place_name': 'Amado', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Santa Cruz', 'locality_code': '23', 'latitude': 31.6723, 'longitude': -111.0986, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85646', 'place_name': 'Tubac', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Santa Cruz', 'locality_code': '23', 'latitude': 31.6126, 'longitude': -111.0459, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85648', 'place_name': 'Rio Rico', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Santa Cruz', 'locality_code': '23', 'latitude': 31.5084, 'longitude': -111.0757, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85662', 'place_name': 'Nogales', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Santa Cruz', 'locality_code': '23', 'latitude': 31.532, 'longitude': -110.9093, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85324', 'place_name': 'Black Canyon City', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.0755, 'longitude': -112.134, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85332', 'place_name': 'Congress', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.1764, 'longitude': -112.768, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85362', 'place_name': 'Yarnell', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.2508, 'longitude': -112.7567, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86301', 'place_name': 'Prescott', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.5917, 'longitude': -112.4265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86302', 'place_name': 'Prescott', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.5749, 'longitude': -112.4915, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86303', 'place_name': 'Prescott', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.4958, 'longitude': -112.3783, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86304', 'place_name': 'Prescott', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.5967, 'longitude': -112.4907, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86305', 'place_name': 'Prescott', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.8185, 'longitude': -112.9584, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86312', 'place_name': 'Prescott Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.6683, 'longitude': -112.3078, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86313', 'place_name': 'Prescott', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.7067, 'longitude': -112.3977, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86314', 'place_name': 'Prescott Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.6019, 'longitude': -112.3264, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86315', 'place_name': 'Prescott Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.7055, 'longitude': -112.2639, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86320', 'place_name': 'Ash Fork', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 35.215, 'longitude': -112.5027, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86321', 'place_name': 'Bagdad', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.5785, 'longitude': -113.1755, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86322', 'place_name': 'Camp Verde', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.5697, 'longitude': -111.8551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86323', 'place_name': 'Chino Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.7757, 'longitude': -112.4731, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86324', 'place_name': 'Clarkdale', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.7711, 'longitude': -112.0579, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86325', 'place_name': 'Cornville', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.7256, 'longitude': -111.9086, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86326', 'place_name': 'Cottonwood', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.7055, 'longitude': -112.0091, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86327', 'place_name': 'Dewey', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.5368, 'longitude': -112.2567, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86329', 'place_name': 'Humboldt', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.5009, 'longitude': -112.2374, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86331', 'place_name': 'Jerome', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.7486, 'longitude': -112.1086, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86332', 'place_name': 'Kirkland', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.4541, 'longitude': -112.8966, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86333', 'place_name': 'Mayer', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.3655, 'longitude': -112.1296, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86334', 'place_name': 'Paulden', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 35.0313, 'longitude': -112.5441, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86335', 'place_name': 'Rimrock', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.638, 'longitude': -111.7842, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86337', 'place_name': 'Seligman', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 35.3212, 'longitude': -112.9548, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86338', 'place_name': 'Skull Valley', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.5053, 'longitude': -112.6855, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86340', 'place_name': 'Sedona', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.7067, 'longitude': -112.3977, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86341', 'place_name': 'Sedona', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.7766, 'longitude': -111.7679, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '86342', 'place_name': 'Lake Montezuma', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.6417, 'longitude': -111.7872, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '86343', 'place_name': 'Crown King', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yavapai', 'locality_code': '25', 'latitude': 34.2241, 'longitude': -112.334, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85333', 'place_name': 'Dateland', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.8679, 'longitude': -113.4631, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85336', 'place_name': 'Gadsden', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.5545, 'longitude': -114.785, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85347', 'place_name': 'Roll', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.7517, 'longitude': -113.9891, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85349', 'place_name': 'San Luis', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.487, 'longitude': -114.7822, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85350', 'place_name': 'Somerton', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.5634, 'longitude': -114.7127, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85352', 'place_name': 'Tacna', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.6934, 'longitude': -113.9763, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '85356', 'place_name': 'Wellton', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.6935, 'longitude': -114.1561, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85364', 'place_name': 'Yuma', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.7015, 'longitude': -114.6424, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85365', 'place_name': 'Yuma', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.7093, 'longitude': -114.4905, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85366', 'place_name': 'Yuma', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.61, 'longitude': -114.6312, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85367', 'place_name': 'Yuma', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.6566, 'longitude': -114.4042, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '85369', 'place_name': 'Yuma', 'state': 'Arizona', 'state_ab': 'AZ', 'county': 'Yuma', 'locality_code': '27', 'latitude': 32.7253, 'longitude': -114.6244, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94501', 'place_name': 'Alameda', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7706, 'longitude': -122.2648, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94502', 'place_name': 'Alameda', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7351, 'longitude': -122.2431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94536', 'place_name': 'Fremont', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.5605, 'longitude': -121.9999, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94537', 'place_name': 'Fremont', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6802, 'longitude': -121.9215, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94538', 'place_name': 'Fremont', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.5308, 'longitude': -121.9712, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94539', 'place_name': 'Fremont', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.5176, 'longitude': -121.9287, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94540', 'place_name': 'Hayward', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6802, 'longitude': -121.9215, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94541', 'place_name': 'Hayward', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.674, 'longitude': -122.0894, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94542', 'place_name': 'Hayward', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6586, 'longitude': -122.0472, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94543', 'place_name': 'Hayward', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6688, 'longitude': -122.0808, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94544', 'place_name': 'Hayward', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6374, 'longitude': -122.067, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94545', 'place_name': 'Hayward', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6332, 'longitude': -122.0971, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94546', 'place_name': 'Castro Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7015, 'longitude': -122.0782, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94550', 'place_name': 'Livermore', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.683, 'longitude': -121.763, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94551', 'place_name': 'Livermore', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7526, 'longitude': -121.77, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94552', 'place_name': 'Castro Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7131, 'longitude': -122.0381, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94555', 'place_name': 'Fremont', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.5735, 'longitude': -122.0469, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94557', 'place_name': 'Hayward', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6802, 'longitude': -121.9215, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94560', 'place_name': 'Newark', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.5368, 'longitude': -122.032, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94566', 'place_name': 'Pleasanton', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6658, 'longitude': -121.8755, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94568', 'place_name': 'Dublin', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7166, 'longitude': -121.9226, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94577', 'place_name': 'San Leandro', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7205, 'longitude': -122.1587, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94578', 'place_name': 'San Leandro', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7024, 'longitude': -122.124, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94579', 'place_name': 'San Leandro', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6892, 'longitude': -122.1507, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94580', 'place_name': 'San Lorenzo', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6787, 'longitude': -122.1295, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94586', 'place_name': 'Sunol', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6094, 'longitude': -121.8986, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94587', 'place_name': 'Union City', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.5895, 'longitude': -122.0497, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94588', 'place_name': 'Pleasanton', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.6873, 'longitude': -121.8957, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94601', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7806, 'longitude': -122.2166, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94602', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8011, 'longitude': -122.2104, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94603', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7402, 'longitude': -122.171, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94604', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8044, 'longitude': -122.2708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94605', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7641, 'longitude': -122.1633, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94606', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7957, 'longitude': -122.2429, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94607', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8071, 'longitude': -122.2851, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94608', 'place_name': 'Emeryville', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8365, 'longitude': -122.2804, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94609', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8361, 'longitude': -122.2637, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94610', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8126, 'longitude': -122.2443, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94611', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8471, 'longitude': -122.2223, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94612', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8085, 'longitude': -122.2668, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94613', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7811, 'longitude': -122.1866, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94614', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7277, 'longitude': -122.2046, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94615', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8067, 'longitude': -122.3004, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94617', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8078, 'longitude': -122.2717, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94618', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8431, 'longitude': -122.2402, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94619', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7878, 'longitude': -122.1884, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94620', 'place_name': 'Piedmont', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8244, 'longitude': -122.2316, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94621', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.7589, 'longitude': -122.1853, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94622', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.799, 'longitude': -122.2337, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94623', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8044, 'longitude': -122.2708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94624', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8044, 'longitude': -122.2708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94649', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8044, 'longitude': -122.2708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94659', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8044, 'longitude': -122.2708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94660', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8044, 'longitude': -122.2708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94661', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8044, 'longitude': -122.2708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94662', 'place_name': 'Emeryville', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8313, 'longitude': -122.2852, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94666', 'place_name': 'Oakland', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8044, 'longitude': -122.2708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94701', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8606, 'longitude': -122.2967, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94702', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8656, 'longitude': -122.2851, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94703', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.863, 'longitude': -122.2749, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94704', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8664, 'longitude': -122.257, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94705', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8571, 'longitude': -122.25, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94706', 'place_name': 'Albany', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.89, 'longitude': -122.2954, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94707', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8927, 'longitude': -122.2761, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94708', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8918, 'longitude': -122.2604, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94709', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8784, 'longitude': -122.2655, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94710', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8696, 'longitude': -122.2959, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94712', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8716, 'longitude': -122.2727, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94720', 'place_name': 'Berkeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Alameda', 'locality_code': '1', 'latitude': 37.8738, 'longitude': -122.2549, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95646', 'place_name': 'Kirkwood', 'state': 'California', 'state_ab': 'CA', 'county': 'Alpine', 'locality_code': '3', 'latitude': 38.6918, 'longitude': -120.0736, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96120', 'place_name': 'Markleeville', 'state': 'California', 'state_ab': 'CA', 'county': 'Alpine', 'locality_code': '3', 'latitude': 38.7713, 'longitude': -119.8327, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95601', 'place_name': 'Amador City', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.4194, 'longitude': -120.823, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95629', 'place_name': 'Fiddletown', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.5234, 'longitude': -120.6763, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95640', 'place_name': 'Ione', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.3324, 'longitude': -120.9418, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95642', 'place_name': 'Jackson', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.3545, 'longitude': -120.7573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95644', 'place_name': 'Kit Carson', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.6707, 'longitude': -120.1135, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95654', 'place_name': 'Martell', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.3515, 'longitude': -120.7752, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95665', 'place_name': 'Pine Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.4049, 'longitude': -120.6544, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95666', 'place_name': 'Pioneer', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.4319, 'longitude': -120.5719, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95669', 'place_name': 'Plymouth', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.4916, 'longitude': -120.8819, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95675', 'place_name': 'River Pines', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.5463, 'longitude': -120.743, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95685', 'place_name': 'Sutter Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.4175, 'longitude': -120.7951, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95689', 'place_name': 'Volcano', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.4765, 'longitude': -120.6017, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95699', 'place_name': 'Drytown', 'state': 'California', 'state_ab': 'CA', 'county': 'Amador', 'locality_code': '5', 'latitude': 38.4411, 'longitude': -120.8533, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95914', 'place_name': 'Bangor', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.3885, 'longitude': -121.4052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95916', 'place_name': 'Berry Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.6776, 'longitude': -121.3689, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95917', 'place_name': 'Biggs', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.4162, 'longitude': -121.7189, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95926', 'place_name': 'Chico', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.7458, 'longitude': -121.8444, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95927', 'place_name': 'Chico', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.8117, 'longitude': -121.9398, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95928', 'place_name': 'Chico', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.7224, 'longitude': -121.8113, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95929', 'place_name': 'Chico', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.7301, 'longitude': -121.8414, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95930', 'place_name': 'Clipper Mills', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.5327, 'longitude': -121.1575, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95938', 'place_name': 'Durham', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.633, 'longitude': -121.7886, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95940', 'place_name': 'Feather Falls', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.622, 'longitude': -121.2669, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95941', 'place_name': 'Forbestown', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.521, 'longitude': -121.2423, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95942', 'place_name': 'Forest Ranch', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.8821, 'longitude': -121.6728, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95948', 'place_name': 'Gridley', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.3532, 'longitude': -121.7137, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95954', 'place_name': 'Magalia', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.8912, 'longitude': -121.58, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95958', 'place_name': 'Nelson', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.5522, 'longitude': -121.7644, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95965', 'place_name': 'Oroville', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.6054, 'longitude': -121.5751, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95966', 'place_name': 'Oroville', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.4877, 'longitude': -121.4698, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95967', 'place_name': 'Paradise', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.7155, 'longitude': -121.6551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95968', 'place_name': 'Palermo', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.4361, 'longitude': -121.5454, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95969', 'place_name': 'Paradise', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.7555, 'longitude': -121.6069, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95973', 'place_name': 'Chico', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.8032, 'longitude': -121.8673, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95974', 'place_name': 'Richvale', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.4959, 'longitude': -121.748, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95976', 'place_name': 'Chico', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.7346, 'longitude': -121.8331, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95978', 'place_name': 'Stirling City', 'state': 'California', 'state_ab': 'CA', 'county': 'Butte', 'locality_code': '7', 'latitude': 39.9077, 'longitude': -121.5269, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95221', 'place_name': 'Altaville', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.0838, 'longitude': -120.5608, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95222', 'place_name': 'Angels Camp', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.071, 'longitude': -120.5722, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95223', 'place_name': 'Arnold', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.3086, 'longitude': -120.268, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95224', 'place_name': 'Avery', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.2044, 'longitude': -120.3688, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95225', 'place_name': 'Burson', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.1838, 'longitude': -120.8894, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95226', 'place_name': 'Campo Seco', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.2271, 'longitude': -120.8533, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95228', 'place_name': 'Copperopolis', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 37.944, 'longitude': -120.6423, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95229', 'place_name': 'Douglas Flat', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.1144, 'longitude': -120.4538, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95232', 'place_name': 'Glencoe', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.3554, 'longitude': -120.5778, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95233', 'place_name': 'Hathaway Pines', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.1919, 'longitude': -120.3644, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95245', 'place_name': 'Mokelumne Hill', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.3152, 'longitude': -120.5591, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95246', 'place_name': 'Mountain Ranch', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.2328, 'longitude': -120.4994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95247', 'place_name': 'Murphys', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.1345, 'longitude': -120.4516, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95248', 'place_name': 'Rail Road Flat', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.3405, 'longitude': -120.5161, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95249', 'place_name': 'San Andreas', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.1904, 'longitude': -120.6441, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95251', 'place_name': 'Vallecito', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.1013, 'longitude': -120.4676, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95252', 'place_name': 'Valley Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.162, 'longitude': -120.8572, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95254', 'place_name': 'Wallace', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.1983, 'longitude': -120.9793, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95255', 'place_name': 'West Point', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.4197, 'longitude': -120.4759, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95257', 'place_name': 'Wilseyville', 'state': 'California', 'state_ab': 'CA', 'county': 'Calaveras', 'locality_code': '9', 'latitude': 38.3793, 'longitude': -120.4627, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95912', 'place_name': 'Arbuckle', 'state': 'California', 'state_ab': 'CA', 'county': 'Colusa', 'locality_code': '11', 'latitude': 39.0138, 'longitude': -122.0274, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95932', 'place_name': 'Colusa', 'state': 'California', 'state_ab': 'CA', 'county': 'Colusa', 'locality_code': '11', 'latitude': 39.2345, 'longitude': -122.0277, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95950', 'place_name': 'Grimes', 'state': 'California', 'state_ab': 'CA', 'county': 'Colusa', 'locality_code': '11', 'latitude': 39.0744, 'longitude': -121.8927, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95955', 'place_name': 'Maxwell', 'state': 'California', 'state_ab': 'CA', 'county': 'Colusa', 'locality_code': '11', 'latitude': 39.3163, 'longitude': -122.1849, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95970', 'place_name': 'Princeton', 'state': 'California', 'state_ab': 'CA', 'county': 'Colusa', 'locality_code': '11', 'latitude': 39.4168, 'longitude': -122.0519, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95979', 'place_name': 'Stonyford', 'state': 'California', 'state_ab': 'CA', 'county': 'Colusa', 'locality_code': '11', 'latitude': 39.3176, 'longitude': -122.5393, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95987', 'place_name': 'Williams', 'state': 'California', 'state_ab': 'CA', 'county': 'Colusa', 'locality_code': '11', 'latitude': 39.1337, 'longitude': -122.2162, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94505', 'place_name': 'Discovery Bay', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.8989, 'longitude': -121.6054, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94506', 'place_name': 'Danville', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.8321, 'longitude': -121.9167, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94507', 'place_name': 'Alamo', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.8537, 'longitude': -122.0229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94509', 'place_name': 'Antioch', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9939, 'longitude': -121.8089, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94511', 'place_name': 'Bethel Island', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 38.0266, 'longitude': -121.6425, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94513', 'place_name': 'Brentwood', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9324, 'longitude': -121.6894, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94514', 'place_name': 'Byron', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.8254, 'longitude': -121.6236, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94516', 'place_name': 'Canyon', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.8339, 'longitude': -122.165, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94517', 'place_name': 'Clayton', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9154, 'longitude': -121.91, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94518', 'place_name': 'Concord', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9504, 'longitude': -122.0263, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94519', 'place_name': 'Concord', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9841, 'longitude': -122.0119, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94520', 'place_name': 'Concord', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9823, 'longitude': -122.0362, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94521', 'place_name': 'Concord', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9575, 'longitude': -121.975, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94522', 'place_name': 'Concord', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.978, 'longitude': -122.0311, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94523', 'place_name': 'Pleasant Hill', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.954, 'longitude': -122.0737, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94524', 'place_name': 'Concord', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.978, 'longitude': -122.0311, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94525', 'place_name': 'Crockett', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 38.0519, 'longitude': -122.2177, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94526', 'place_name': 'Danville', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.814, 'longitude': -121.966, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94527', 'place_name': 'Concord', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9535, 'longitude': -121.9578, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94528', 'place_name': 'Diablo', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.8387, 'longitude': -121.9667, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94529', 'place_name': 'Concord', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.978, 'longitude': -122.0311, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94530', 'place_name': 'El Cerrito', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9156, 'longitude': -122.2985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94531', 'place_name': 'Antioch', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9658, 'longitude': -121.7758, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94547', 'place_name': 'Hercules', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 38.0066, 'longitude': -122.2637, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94548', 'place_name': 'Knightsen', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9726, 'longitude': -121.6652, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94549', 'place_name': 'Lafayette', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.8961, 'longitude': -122.1119, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94553', 'place_name': 'Martinez', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9864, 'longitude': -122.135, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94556', 'place_name': 'Moraga', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.8437, 'longitude': -122.1242, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94561', 'place_name': 'Oakley', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.994, 'longitude': -121.7036, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94563', 'place_name': 'Orinda', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.8787, 'longitude': -122.1728, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94564', 'place_name': 'Pinole', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9969, 'longitude': -122.2875, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94565', 'place_name': 'Pittsburg', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 38.0031, 'longitude': -121.9172, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94569', 'place_name': 'Port Costa', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 38.046, 'longitude': -122.1866, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94570', 'place_name': 'Moraga', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.7772, 'longitude': -121.9554, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94572', 'place_name': 'Rodeo', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 38.0307, 'longitude': -122.2581, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94575', 'place_name': 'Moraga', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.7772, 'longitude': -121.9554, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94582', 'place_name': 'San Ramon', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.7636, 'longitude': -121.9155, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94583', 'place_name': 'San Ramon', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.7562, 'longitude': -121.9522, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94595', 'place_name': 'Walnut Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.8753, 'longitude': -122.0703, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94596', 'place_name': 'Walnut Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9053, 'longitude': -122.0549, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94597', 'place_name': 'Walnut Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9182, 'longitude': -122.0717, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94598', 'place_name': 'Walnut Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9194, 'longitude': -122.0259, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94801', 'place_name': 'Richmond', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.94, 'longitude': -122.362, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94802', 'place_name': 'Richmond', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9358, 'longitude': -122.3477, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94803', 'place_name': 'El Sobrante', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9693, 'longitude': -122.2901, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94804', 'place_name': 'Richmond', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9265, 'longitude': -122.3342, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94805', 'place_name': 'Richmond', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9417, 'longitude': -122.3238, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94806', 'place_name': 'San Pablo', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9724, 'longitude': -122.3369, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94807', 'place_name': 'Richmond', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9358, 'longitude': -122.3477, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94808', 'place_name': 'Richmond', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9358, 'longitude': -122.3477, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94820', 'place_name': 'El Sobrante', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9771, 'longitude': -122.2952, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94850', 'place_name': 'Richmond', 'state': 'California', 'state_ab': 'CA', 'county': 'Contra Costa', 'locality_code': '13', 'latitude': 37.9358, 'longitude': -122.3477, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95531', 'place_name': 'Crescent City', 'state': 'California', 'state_ab': 'CA', 'county': 'Del Norte', 'locality_code': '15', 'latitude': 41.7817, 'longitude': -124.1332, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95532', 'place_name': 'Crescent City', 'state': 'California', 'state_ab': 'CA', 'county': 'Del Norte', 'locality_code': '15', 'latitude': 41.7561, 'longitude': -124.2005, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95538', 'place_name': 'Fort Dick', 'state': 'California', 'state_ab': 'CA', 'county': 'Del Norte', 'locality_code': '15', 'latitude': 41.8679, 'longitude': -124.149, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95543', 'place_name': 'Gasquet', 'state': 'California', 'state_ab': 'CA', 'county': 'Del Norte', 'locality_code': '15', 'latitude': 41.9056, 'longitude': -123.831, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '95548', 'place_name': 'Klamath', 'state': 'California', 'state_ab': 'CA', 'county': 'Del Norte', 'locality_code': '15', 'latitude': 41.5804, 'longitude': -124.0387, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95567', 'place_name': 'Smith River', 'state': 'California', 'state_ab': 'CA', 'county': 'Del Norte', 'locality_code': '15', 'latitude': 41.9404, 'longitude': -124.1587, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95613', 'place_name': 'Coloma', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.8, 'longitude': -120.8891, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95614', 'place_name': 'Cool', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.8923, 'longitude': -120.9802, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '95619', 'place_name': 'Diamond Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.6865, 'longitude': -120.8145, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95623', 'place_name': 'El Dorado', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.633, 'longitude': -120.8498, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95633', 'place_name': 'Garden Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.8665, 'longitude': -120.8567, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95634', 'place_name': 'Georgetown', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.9185, 'longitude': -120.7599, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95635', 'place_name': 'Greenwood', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.9143, 'longitude': -120.9001, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95636', 'place_name': 'Grizzly Flats', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.6489, 'longitude': -120.5098, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '95651', 'place_name': 'Lotus', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.8278, 'longitude': -120.9238, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95656', 'place_name': 'Mount Aukum', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.55, 'longitude': -120.7304, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95664', 'place_name': 'Pilot Hill', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.8135, 'longitude': -121.0308, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95667', 'place_name': 'Placerville', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.7195, 'longitude': -120.8046, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95672', 'place_name': 'Rescue', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.7194, 'longitude': -120.9945, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '95682', 'place_name': 'Shingle Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.6465, 'longitude': -120.9641, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95684', 'place_name': 'Somerset', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.5953, 'longitude': -120.5949, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95709', 'place_name': 'Camino', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.747, 'longitude': -120.6743, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95720', 'place_name': 'Kyburz', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.7825, 'longitude': -120.2569, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95721', 'place_name': 'Echo Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.8338, 'longitude': -120.0416, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95726', 'place_name': 'Pollock Pines', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.7708, 'longitude': -120.5427, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95735', 'place_name': 'Twin Bridges', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.8092, 'longitude': -120.1242, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95762', 'place_name': 'El Dorado Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.685, 'longitude': -121.068, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96142', 'place_name': 'Tahoma', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 39.0644, 'longitude': -120.1357, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96150', 'place_name': 'South Lake Tahoe', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.917, 'longitude': -119.9865, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96151', 'place_name': 'South Lake Tahoe', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.9039, 'longitude': -119.995, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96152', 'place_name': 'South Lake Tahoe', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.9271, 'longitude': -119.999, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96154', 'place_name': 'South Lake Tahoe', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.8753, 'longitude': -120.0188, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96155', 'place_name': 'South Lake Tahoe', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.8449, 'longitude': -120.043, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96156', 'place_name': 'South Lake Tahoe', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.9352, 'longitude': -119.9676, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96157', 'place_name': 'South Lake Tahoe', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.9344, 'longitude': -119.9767, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96158', 'place_name': 'South Lake Tahoe', 'state': 'California', 'state_ab': 'CA', 'county': 'El Dorado', 'locality_code': '17', 'latitude': 38.8981, 'longitude': -119.9984, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93210', 'place_name': 'Coalinga', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.1624, 'longitude': -120.3489, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93234', 'place_name': 'Huron', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.2371, 'longitude': -120.102, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93242', 'place_name': 'Laton', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.4378, 'longitude': -119.7156, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93602', 'place_name': 'Auberry', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 37.0726, 'longitude': -119.4572, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93605', 'place_name': 'Big Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 37.2032, 'longitude': -119.2492, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93606', 'place_name': 'Biola', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8032, 'longitude': -120.0185, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93607', 'place_name': 'Burrel', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.5898, 'longitude': -119.8994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93608', 'place_name': 'Cantua Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.4921, 'longitude': -120.3353, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93609', 'place_name': 'Caruthers', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.5358, 'longitude': -119.8446, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93611', 'place_name': 'Clovis', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8253, 'longitude': -119.6802, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93612', 'place_name': 'Clovis', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8149, 'longitude': -119.7106, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93613', 'place_name': 'Clovis', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8252, 'longitude': -119.7029, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93616', 'place_name': 'Del Rey', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6543, 'longitude': -119.5929, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93621', 'place_name': 'Dunlap', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7446, 'longitude': -119.0899, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93622', 'place_name': 'Firebaugh', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8651, 'longitude': -120.47, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93624', 'place_name': 'Five Points', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.3386, 'longitude': -120.1118, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93625', 'place_name': 'Fowler', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6282, 'longitude': -119.671, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93626', 'place_name': 'Friant', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 37.0422, 'longitude': -119.6807, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93627', 'place_name': 'Helm', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.5316, 'longitude': -120.0982, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93628', 'place_name': 'Hume', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7515, 'longitude': -118.9575, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93630', 'place_name': 'Kerman', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7306, 'longitude': -120.0724, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93631', 'place_name': 'Kingsburg', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.508, 'longitude': -119.5433, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93634', 'place_name': 'Lakeshore', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 37.253, 'longitude': -119.1748, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93640', 'place_name': 'Mendota', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7424, 'longitude': -120.4093, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93641', 'place_name': 'Miramonte', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6894, 'longitude': -119.0477, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93642', 'place_name': 'Mono Hot Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 37.3266, 'longitude': -119.0176, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93646', 'place_name': 'Orange Cove', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6255, 'longitude': -119.3204, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93648', 'place_name': 'Parlier', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6103, 'longitude': -119.5375, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93649', 'place_name': 'Piedra', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8417, 'longitude': -119.3496, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93650', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8411, 'longitude': -119.801, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93651', 'place_name': 'Prather', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.9938, 'longitude': -119.5268, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93652', 'place_name': 'Raisin City', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6024, 'longitude': -119.904, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93654', 'place_name': 'Reedley', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6044, 'longitude': -119.4378, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93656', 'place_name': 'Riverdale', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.4295, 'longitude': -119.872, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93657', 'place_name': 'Sanger', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7243, 'longitude': -119.5478, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93660', 'place_name': 'San Joaquin', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6059, 'longitude': -120.1889, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93662', 'place_name': 'Selma', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.5695, 'longitude': -119.617, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93664', 'place_name': 'Shaver Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 37.1397, 'longitude': -119.273, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93667', 'place_name': 'Tollhouse', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.9943, 'longitude': -119.3914, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93668', 'place_name': 'Tranquillity', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6584, 'longitude': -120.2617, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93675', 'place_name': 'Squaw Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7071, 'longitude': -119.1814, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93701', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7487, 'longitude': -119.7867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93702', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.74, 'longitude': -119.7532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93703', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7684, 'longitude': -119.7594, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93704', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7991, 'longitude': -119.8016, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93705', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7863, 'longitude': -119.8286, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93706', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6486, 'longitude': -119.9987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93707', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93708', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93709', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93710', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8236, 'longitude': -119.7621, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93711', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8303, 'longitude': -119.8319, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93712', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93714', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93715', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93716', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93717', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93718', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93720', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8579, 'longitude': -119.7655, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93721', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7377, 'longitude': -119.7843, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93722', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7918, 'longitude': -119.8801, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93723', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7863, 'longitude': -119.9532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93724', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93725', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.6207, 'longitude': -119.7308, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93726', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7949, 'longitude': -119.7604, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93727', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7528, 'longitude': -119.7061, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93728', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7581, 'longitude': -119.8113, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93729', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93730', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.8878, 'longitude': -119.7589, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93737', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7477, 'longitude': -119.7724, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93740', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93741', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93744', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93745', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93747', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93750', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93755', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93760', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93761', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93764', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93765', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93771', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93772', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93773', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93774', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93775', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93776', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93777', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93778', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93779', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93786', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93790', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93791', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93792', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93793', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93794', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93844', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93888', 'place_name': 'Fresno', 'state': 'California', 'state_ab': 'CA', 'county': 'Fresno', 'locality_code': '19', 'latitude': 36.7464, 'longitude': -119.6397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95913', 'place_name': 'Artois', 'state': 'California', 'state_ab': 'CA', 'county': 'Glenn', 'locality_code': '21', 'latitude': 39.6197, 'longitude': -122.1927, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95920', 'place_name': 'Butte City', 'state': 'California', 'state_ab': 'CA', 'county': 'Glenn', 'locality_code': '21', 'latitude': 39.4568, 'longitude': -121.9515, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95939', 'place_name': 'Elk Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Glenn', 'locality_code': '21', 'latitude': 39.5306, 'longitude': -122.6124, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95943', 'place_name': 'Glenn', 'state': 'California', 'state_ab': 'CA', 'county': 'Glenn', 'locality_code': '21', 'latitude': 39.6069, 'longitude': -122.0384, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95951', 'place_name': 'Hamilton City', 'state': 'California', 'state_ab': 'CA', 'county': 'Glenn', 'locality_code': '21', 'latitude': 39.7386, 'longitude': -122.0085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95963', 'place_name': 'Orland', 'state': 'California', 'state_ab': 'CA', 'county': 'Glenn', 'locality_code': '21', 'latitude': 39.7314, 'longitude': -122.2534, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95988', 'place_name': 'Willows', 'state': 'California', 'state_ab': 'CA', 'county': 'Glenn', 'locality_code': '21', 'latitude': 39.5353, 'longitude': -122.2597, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95501', 'place_name': 'Eureka', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.7938, 'longitude': -124.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95502', 'place_name': 'Eureka', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.7965, 'longitude': -124.1737, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95503', 'place_name': 'Eureka', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.7592, 'longitude': -124.1593, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95511', 'place_name': 'Alderpoint', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.1676, 'longitude': -123.6192, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95514', 'place_name': 'Blocksburg', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.2987, 'longitude': -123.6576, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95518', 'place_name': 'Arcata', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.8685, 'longitude': -124.0856, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95519', 'place_name': 'Mckinleyville', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.9465, 'longitude': -124.0834, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95521', 'place_name': 'Arcata', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.8742, 'longitude': -124.0765, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95524', 'place_name': 'Bayside', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.8266, 'longitude': -124.0552, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95525', 'place_name': 'Blue Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.9374, 'longitude': -123.8913, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95526', 'place_name': 'Bridgeville', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.4693, 'longitude': -123.7998, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95528', 'place_name': 'Carlotta', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.507, 'longitude': -123.9743, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95534', 'place_name': 'Cutten', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.7965, 'longitude': -124.1737, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95536', 'place_name': 'Ferndale', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.5259, 'longitude': -124.2514, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95537', 'place_name': 'Fields Landing', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.7268, 'longitude': -124.2174, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95540', 'place_name': 'Fortuna', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.5835, 'longitude': -124.1473, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95542', 'place_name': 'Garberville', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.0864, 'longitude': -123.7991, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95545', 'place_name': 'Honeydew', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.2421, 'longitude': -124.0972, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95546', 'place_name': 'Hoopa', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 41.0504, 'longitude': -123.6742, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95547', 'place_name': 'Hydesville', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.5485, 'longitude': -124.0847, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95549', 'place_name': 'Kneeland', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.6405, 'longitude': -123.8826, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95550', 'place_name': 'Korbel', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.7775, 'longitude': -123.8486, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95551', 'place_name': 'Loleta', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.6589, 'longitude': -124.2251, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95553', 'place_name': 'Miranda', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.2397, 'longitude': -123.8077, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95554', 'place_name': 'Myers Flat', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.2841, 'longitude': -123.7945, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95555', 'place_name': 'Orick', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 41.3596, 'longitude': -124.0317, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95556', 'place_name': 'Orleans', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 41.3115, 'longitude': -123.5399, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95558', 'place_name': 'Petrolia', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.2868, 'longitude': -124.2271, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95559', 'place_name': 'Phillipsville', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.2008, 'longitude': -123.7735, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95560', 'place_name': 'Redway', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.1201, 'longitude': -123.8234, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95562', 'place_name': 'Rio Dell', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.4987, 'longitude': -124.1102, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95564', 'place_name': 'Samoa', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.8037, 'longitude': -124.1936, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95565', 'place_name': 'Scotia', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.4583, 'longitude': -124.0517, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95569', 'place_name': 'Redcrest', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.3437, 'longitude': -123.9095, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95570', 'place_name': 'Trinidad', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 41.0593, 'longitude': -124.1431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95571', 'place_name': 'Weott', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.3218, 'longitude': -123.9217, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95573', 'place_name': 'Willow Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.9484, 'longitude': -123.6276, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95589', 'place_name': 'Whitethorn', 'state': 'California', 'state_ab': 'CA', 'county': 'Humboldt', 'locality_code': '23', 'latitude': 40.0231, 'longitude': -124.0139, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92222', 'place_name': 'Bard', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.7822, 'longitude': -114.5619, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '92227', 'place_name': 'Brawley', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.9792, 'longitude': -115.5296, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92231', 'place_name': 'Calexico', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.6832, 'longitude': -115.5028, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92232', 'place_name': 'Calexico', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.6789, 'longitude': -115.4989, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92233', 'place_name': 'Calipatria', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 33.167, 'longitude': -115.5114, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92243', 'place_name': 'El Centro', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.7893, 'longitude': -115.5665, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92244', 'place_name': 'El Centro', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.7948, 'longitude': -115.6927, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92249', 'place_name': 'Heber', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.7218, 'longitude': -115.4383, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92250', 'place_name': 'Holtville', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.8104, 'longitude': -115.3775, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92251', 'place_name': 'Imperial', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.847, 'longitude': -115.573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92257', 'place_name': 'Niland', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 33.3784, 'longitude': -115.6965, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92259', 'place_name': 'Ocotillo', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.7387, 'longitude': -115.9942, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92266', 'place_name': 'Palo Verde', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 33.3696, 'longitude': -114.7355, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92273', 'place_name': 'Seeley', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.7941, 'longitude': -115.6948, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92275', 'place_name': 'Salton City', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 33.3092, 'longitude': -115.9578, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92281', 'place_name': 'Westmorland', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 33.038, 'longitude': -115.5914, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92283', 'place_name': 'Winterhaven', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 32.9818, 'longitude': -114.6854, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '92331', 'place_name': 'Fontana', 'state': 'California', 'state_ab': 'CA', 'county': 'Imperial', 'locality_code': '25', 'latitude': 34.0922, 'longitude': -117.4612, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92328', 'place_name': 'Death Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 36.4672, 'longitude': -116.8937, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92384', 'place_name': 'Shoshone', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 35.973, 'longitude': -116.2711, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '92389', 'place_name': 'Tecopa', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 35.9021, 'longitude': -116.1544, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '93513', 'place_name': 'Big Pine', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 37.1679, 'longitude': -118.2916, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93514', 'place_name': 'Bishop', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 37.5014, 'longitude': -118.4048, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93515', 'place_name': 'Bishop', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 37.3635, 'longitude': -118.3951, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93522', 'place_name': 'Darwin', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 36.2948, 'longitude': -117.5957, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93526', 'place_name': 'Independence', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 36.8396, 'longitude': -118.2048, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93530', 'place_name': 'Keeler', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 36.4886, 'longitude': -117.8741, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93542', 'place_name': 'Little Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 35.9366, 'longitude': -117.9067, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93545', 'place_name': 'Lone Pine', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 36.5798, 'longitude': -118.0578, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93549', 'place_name': 'Olancha', 'state': 'California', 'state_ab': 'CA', 'county': 'Inyo', 'locality_code': '27', 'latitude': 36.23, 'longitude': -117.9552, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93203', 'place_name': 'Arvin', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.1966, 'longitude': -118.8336, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93205', 'place_name': 'Bodfish', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.587, 'longitude': -118.4847, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93206', 'place_name': 'Buttonwillow', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.4033, 'longitude': -119.4659, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93215', 'place_name': 'Delano', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.7715, 'longitude': -119.2459, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93216', 'place_name': 'Delano', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.7688, 'longitude': -119.2471, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93220', 'place_name': 'Edison', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3475, 'longitude': -118.8718, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93222', 'place_name': 'Pine Mountain Club', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 34.8469, 'longitude': -119.1568, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93224', 'place_name': 'Fellows', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.1786, 'longitude': -119.5412, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93225', 'place_name': 'Frazier Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 34.8265, 'longitude': -119.0355, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93226', 'place_name': 'Glennville', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.7377, 'longitude': -118.7169, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93238', 'place_name': 'Kernville', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.755, 'longitude': -118.4047, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93240', 'place_name': 'Lake Isabella', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.669, 'longitude': -118.457, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93241', 'place_name': 'Lamont', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2571, 'longitude': -118.9124, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93243', 'place_name': 'Lebec', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 34.8818, 'longitude': -118.8566, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93249', 'place_name': 'Lost Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.6163, 'longitude': -119.6943, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93250', 'place_name': 'Mc Farland', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.6758, 'longitude': -119.2272, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '93251', 'place_name': 'Mc Kittrick', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3031, 'longitude': -119.6366, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '93252', 'place_name': 'Maricopa', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.0589, 'longitude': -119.401, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93255', 'place_name': 'Onyx', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.6824, 'longitude': -118.0959, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93263', 'place_name': 'Shafter', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.497, 'longitude': -119.2801, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93268', 'place_name': 'Taft', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.1482, 'longitude': -119.4557, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93276', 'place_name': 'Tupman', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2992, 'longitude': -119.3584, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93280', 'place_name': 'Wasco', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.648, 'longitude': -119.4487, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93283', 'place_name': 'Weldon', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.6391, 'longitude': -118.2859, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93285', 'place_name': 'Wofford Heights', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.7246, 'longitude': -118.4559, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93287', 'place_name': 'Woody', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.7068, 'longitude': -118.8439, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93301', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3866, 'longitude': -119.0171, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93302', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3733, 'longitude': -119.0187, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93303', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2944, 'longitude': -118.9052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93304', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3396, 'longitude': -119.0218, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93305', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3855, 'longitude': -118.986, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93306', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3867, 'longitude': -118.9391, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93307', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3275, 'longitude': -118.9839, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93308', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.4244, 'longitude': -119.0433, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93309', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3384, 'longitude': -119.0627, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93311', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3039, 'longitude': -119.1056, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93312', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3935, 'longitude': -119.1205, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93313', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2974, 'longitude': -119.0509, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93314', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3863, 'longitude': -119.17, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93380', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2944, 'longitude': -118.9052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93383', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2944, 'longitude': -118.9052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93384', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3733, 'longitude': -119.0187, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93385', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2944, 'longitude': -118.9052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93386', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2944, 'longitude': -118.9052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93387', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2944, 'longitude': -118.9052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93388', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2944, 'longitude': -118.9052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93389', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2944, 'longitude': -118.9052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93390', 'place_name': 'Bakersfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2944, 'longitude': -118.9052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93501', 'place_name': 'Mojave', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.0478, 'longitude': -118.1735, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93502', 'place_name': 'Mojave', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.0525, 'longitude': -118.174, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93504', 'place_name': 'California City', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.1871, 'longitude': -117.8854, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93505', 'place_name': 'California City', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.1278, 'longitude': -117.9651, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93516', 'place_name': 'Boron', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.0037, 'longitude': -117.6629, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '93518', 'place_name': 'Caliente', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3701, 'longitude': -118.4612, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93519', 'place_name': 'Cantil', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3089, 'longitude': -117.9684, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93523', 'place_name': 'Edwards', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 34.9261, 'longitude': -117.9351, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93524', 'place_name': 'Edwards', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 34.932, 'longitude': -117.9071, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93527', 'place_name': 'Inyokern', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.6397, 'longitude': -117.857, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93528', 'place_name': 'Johannesburg', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3708, 'longitude': -117.6427, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93531', 'place_name': 'Keene', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.2375, 'longitude': -118.6076, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93554', 'place_name': 'Randsburg', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.3866, 'longitude': -117.7159, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93555', 'place_name': 'Ridgecrest', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.6225, 'longitude': -117.6709, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93556', 'place_name': 'Ridgecrest', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.6225, 'longitude': -117.6709, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93560', 'place_name': 'Rosamond', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 34.8664, 'longitude': -118.3409, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93561', 'place_name': 'Tehachapi', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.1322, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93581', 'place_name': 'Tehachapi', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 35.1322, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93596', 'place_name': 'Boron', 'state': 'California', 'state_ab': 'CA', 'county': 'Kern', 'locality_code': '29', 'latitude': 34.9994, 'longitude': -117.6498, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93202', 'place_name': 'Armona', 'state': 'California', 'state_ab': 'CA', 'county': 'Kings', 'locality_code': '31', 'latitude': 36.3095, 'longitude': -119.7053, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93204', 'place_name': 'Avenal', 'state': 'California', 'state_ab': 'CA', 'county': 'Kings', 'locality_code': '31', 'latitude': 35.9877, 'longitude': -120.1227, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93212', 'place_name': 'Corcoran', 'state': 'California', 'state_ab': 'CA', 'county': 'Kings', 'locality_code': '31', 'latitude': 36.0865, 'longitude': -119.5607, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93230', 'place_name': 'Hanford', 'state': 'California', 'state_ab': 'CA', 'county': 'Kings', 'locality_code': '31', 'latitude': 36.3314, 'longitude': -119.6491, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93232', 'place_name': 'Hanford', 'state': 'California', 'state_ab': 'CA', 'county': 'Kings', 'locality_code': '31', 'latitude': 36.3275, 'longitude': -119.6457, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93239', 'place_name': 'Kettleman City', 'state': 'California', 'state_ab': 'CA', 'county': 'Kings', 'locality_code': '31', 'latitude': 36.0083, 'longitude': -119.9618, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93245', 'place_name': 'Lemoore', 'state': 'California', 'state_ab': 'CA', 'county': 'Kings', 'locality_code': '31', 'latitude': 36.2682, 'longitude': -119.8173, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93246', 'place_name': 'Lemoore', 'state': 'California', 'state_ab': 'CA', 'county': 'Kings', 'locality_code': '31', 'latitude': 36.1389, 'longitude': -119.8947, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93266', 'place_name': 'Stratford', 'state': 'California', 'state_ab': 'CA', 'county': 'Kings', 'locality_code': '31', 'latitude': 36.179, 'longitude': -119.8236, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95422', 'place_name': 'Clearlake', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 38.9576, 'longitude': -122.636, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95423', 'place_name': 'Clearlake Oaks', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 39.0664, 'longitude': -122.6558, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95424', 'place_name': 'Clearlake Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 38.9666, 'longitude': -122.65, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95426', 'place_name': 'Cobb', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 38.8155, 'longitude': -122.7132, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95435', 'place_name': 'Finley', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 39.0043, 'longitude': -122.8755, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95443', 'place_name': 'Glenhaven', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 39.0263, 'longitude': -122.733, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95451', 'place_name': 'Kelseyville', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 38.9421, 'longitude': -122.7777, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95453', 'place_name': 'Lakeport', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 39.047, 'longitude': -122.9328, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95457', 'place_name': 'Lower Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 38.8915, 'longitude': -122.5914, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95458', 'place_name': 'Lucerne', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 39.0783, 'longitude': -122.7846, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95461', 'place_name': 'Middletown', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 38.7824, 'longitude': -122.6487, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95464', 'place_name': 'Nice', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 39.1194, 'longitude': -122.8315, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95467', 'place_name': 'Hidden Valley Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 38.8036, 'longitude': -122.5407, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95485', 'place_name': 'Upper Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 39.1804, 'longitude': -122.9144, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95493', 'place_name': 'Witter Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Lake', 'locality_code': '33', 'latitude': 39.1821, 'longitude': -122.9711, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96009', 'place_name': 'Bieber', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 41.1315, 'longitude': -121.1286, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96068', 'place_name': 'Nubieber', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 41.0957, 'longitude': -121.183, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96109', 'place_name': 'Doyle', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.0008, 'longitude': -120.1077, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96113', 'place_name': 'Herlong', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.1485, 'longitude': -120.1713, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96114', 'place_name': 'Janesville', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.2963, 'longitude': -120.5098, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96117', 'place_name': 'Litchfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.4073, 'longitude': -120.4092, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96119', 'place_name': 'Madeline', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.9766, 'longitude': -120.5548, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96121', 'place_name': 'Milford', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.1828, 'longitude': -120.3895, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96123', 'place_name': 'Ravendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.7985, 'longitude': -120.3652, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96127', 'place_name': 'Susanville', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.4163, 'longitude': -120.653, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96128', 'place_name': 'Standish', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.3509, 'longitude': -120.4068, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96130', 'place_name': 'Susanville', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.3983, 'longitude': -120.6464, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96132', 'place_name': 'Termo', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.9509, 'longitude': -120.613, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96136', 'place_name': 'Wendel', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.3406, 'longitude': -120.2824, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96137', 'place_name': 'Westwood', 'state': 'California', 'state_ab': 'CA', 'county': 'Lassen', 'locality_code': '35', 'latitude': 40.3038, 'longitude': -121.0226, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90001', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9731, 'longitude': -118.2479, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90002', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9497, 'longitude': -118.2462, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90003', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9653, 'longitude': -118.2727, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90004', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0762, 'longitude': -118.3029, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90005', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0585, 'longitude': -118.3012, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90006', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0493, 'longitude': -118.2917, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90007', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0294, 'longitude': -118.2871, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90008', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0116, 'longitude': -118.3411, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90009', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90010', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0606, 'longitude': -118.3027, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90011', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0079, 'longitude': -118.2582, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90012', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0614, 'longitude': -118.2385, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90013', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0448, 'longitude': -118.2434, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90014', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0443, 'longitude': -118.2509, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90015', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0434, 'longitude': -118.2716, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90016', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0298, 'longitude': -118.3528, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90017', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0559, 'longitude': -118.2666, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90018', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.029, 'longitude': -118.3152, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90019', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0482, 'longitude': -118.3343, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90020', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0665, 'longitude': -118.3022, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90021', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0333, 'longitude': -118.2447, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90022', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0245, 'longitude': -118.1561, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90023', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0245, 'longitude': -118.1975, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90024', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0637, 'longitude': -118.4408, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90025', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0447, 'longitude': -118.4487, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90026', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0766, 'longitude': -118.2646, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90027', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.104, 'longitude': -118.2925, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90028', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1005, 'longitude': -118.3254, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90029', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.09, 'longitude': -118.2944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90030', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90031', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0783, 'longitude': -118.2113, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90032', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0818, 'longitude': -118.1753, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90033', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0487, 'longitude': -118.2084, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90034', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.029, 'longitude': -118.4005, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90035', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0531, 'longitude': -118.3806, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90036', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0699, 'longitude': -118.3492, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90037', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.003, 'longitude': -118.2863, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90038', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0898, 'longitude': -118.3215, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90039', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1121, 'longitude': -118.2594, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90040', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9909, 'longitude': -118.1532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90041', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1339, 'longitude': -118.2082, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90042', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1145, 'longitude': -118.1929, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90043', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9871, 'longitude': -118.3321, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90044', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9551, 'longitude': -118.2901, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90045', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9631, 'longitude': -118.3941, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90046', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1074, 'longitude': -118.3652, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90047', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9569, 'longitude': -118.3073, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90048', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0737, 'longitude': -118.372, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90049', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.066, 'longitude': -118.474, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90050', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90051', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90052', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90053', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90054', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90055', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90056', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9853, 'longitude': -118.3707, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90057', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0622, 'longitude': -118.2763, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90058', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9994, 'longitude': -118.2133, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90059', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9293, 'longitude': -118.2463, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90060', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90061', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9245, 'longitude': -118.2716, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90062', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0032, 'longitude': -118.3073, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90063', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0451, 'longitude': -118.1859, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90064', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0353, 'longitude': -118.4259, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90065', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1073, 'longitude': -118.2266, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90066', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.003, 'longitude': -118.4298, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90067', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0551, 'longitude': -118.4095, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90068', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1156, 'longitude': -118.3305, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90069', 'place_name': 'West Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0906, 'longitude': -118.3788, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90070', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90071', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0529, 'longitude': -118.2549, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90072', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90073', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90074', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90075', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90076', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90077', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1112, 'longitude': -118.4502, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90078', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90079', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90080', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90081', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90082', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90083', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90084', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90086', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90087', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90088', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90089', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90090', 'place_name': 'Dodgertown', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0725, 'longitude': -118.2418, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '90091', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90093', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90094', 'place_name': 'Playa Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9728, 'longitude': -118.4276, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90095', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90096', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90099', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90134', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0522, 'longitude': -118.2437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90189', 'place_name': 'Los Angeles', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0515, 'longitude': -118.2559, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90201', 'place_name': 'Bell Gardens', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9653, 'longitude': -118.1515, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90202', 'place_name': 'Bell', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9775, 'longitude': -118.187, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90209', 'place_name': 'Beverly Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0736, 'longitude': -118.4004, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90210', 'place_name': 'Beverly Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0901, 'longitude': -118.4065, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90211', 'place_name': 'Beverly Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0652, 'longitude': -118.383, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90212', 'place_name': 'Beverly Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0619, 'longitude': -118.3995, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90213', 'place_name': 'Beverly Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0736, 'longitude': -118.4004, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90220', 'place_name': 'Compton', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8748, 'longitude': -118.2402, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90221', 'place_name': 'Compton', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8796, 'longitude': -118.2168, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90222', 'place_name': 'Compton', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9099, 'longitude': -118.2357, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90223', 'place_name': 'Compton', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8958, 'longitude': -118.2201, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90224', 'place_name': 'Compton', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90230', 'place_name': 'Culver City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9949, 'longitude': -118.3991, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90231', 'place_name': 'Culver City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0211, 'longitude': -118.3965, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90232', 'place_name': 'Culver City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0168, 'longitude': -118.3973, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90233', 'place_name': 'Culver City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0211, 'longitude': -118.3965, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90239', 'place_name': 'Downey', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.94, 'longitude': -118.1326, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90240', 'place_name': 'Downey', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9581, 'longitude': -118.1174, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90241', 'place_name': 'Downey', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9416, 'longitude': -118.1306, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90242', 'place_name': 'Downey', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9218, 'longitude': -118.1395, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90245', 'place_name': 'El Segundo', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9243, 'longitude': -118.4119, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90247', 'place_name': 'Gardena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8925, 'longitude': -118.2961, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90248', 'place_name': 'Gardena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8766, 'longitude': -118.2835, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90249', 'place_name': 'Gardena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8998, 'longitude': -118.3199, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90250', 'place_name': 'Hawthorne', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9143, 'longitude': -118.3493, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90251', 'place_name': 'Hawthorne', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9164, 'longitude': -118.3526, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90254', 'place_name': 'Hermosa Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8643, 'longitude': -118.3955, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90255', 'place_name': 'Huntington Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9769, 'longitude': -118.2161, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90260', 'place_name': 'Lawndale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8879, 'longitude': -118.351, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90261', 'place_name': 'Lawndale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8872, 'longitude': -118.3526, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90262', 'place_name': 'Lynwood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9241, 'longitude': -118.2013, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90263', 'place_name': 'Malibu', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.005, 'longitude': -118.8101, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90264', 'place_name': 'Malibu', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.005, 'longitude': -118.8101, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90265', 'place_name': 'Malibu', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0402, 'longitude': -118.7351, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90266', 'place_name': 'Manhattan Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8896, 'longitude': -118.3996, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90267', 'place_name': 'Manhattan Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90270', 'place_name': 'Maywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.989, 'longitude': -118.1877, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90272', 'place_name': 'Pacific Palisades', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0481, 'longitude': -118.5265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90274', 'place_name': 'Palos Verdes Peninsula', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7669, 'longitude': -118.3806, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90275', 'place_name': 'Rancho Palos Verdes', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7515, 'longitude': -118.367, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90277', 'place_name': 'Redondo Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8307, 'longitude': -118.3832, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90278', 'place_name': 'Redondo Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8707, 'longitude': -118.3715, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90280', 'place_name': 'South Gate', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9462, 'longitude': -118.2013, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90290', 'place_name': 'Topanga', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1076, 'longitude': -118.6023, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90291', 'place_name': 'Venice', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9938, 'longitude': -118.4635, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90292', 'place_name': 'Marina Del Rey', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9779, 'longitude': -118.4525, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90293', 'place_name': 'Playa Del Rey', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9577, 'longitude': -118.4373, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90294', 'place_name': 'Venice', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9908, 'longitude': -118.4601, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90295', 'place_name': 'Marina Del Rey', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90296', 'place_name': 'Playa Del Rey', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90301', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.955, 'longitude': -118.3556, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90302', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9745, 'longitude': -118.3548, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90303', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9377, 'longitude': -118.3321, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90304', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9379, 'longitude': -118.3586, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90305', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9583, 'longitude': -118.3259, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90306', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9617, 'longitude': -118.3531, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90307', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90308', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9617, 'longitude': -118.3531, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90309', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90310', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90311', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9617, 'longitude': -118.3531, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90312', 'place_name': 'Inglewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9617, 'longitude': -118.3531, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90401', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0176, 'longitude': -118.4907, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90402', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0349, 'longitude': -118.503, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90403', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0287, 'longitude': -118.4924, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90404', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0268, 'longitude': -118.4733, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90405', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.01, 'longitude': -118.4717, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90406', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0195, 'longitude': -118.4912, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90407', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0195, 'longitude': -118.4912, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90408', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0195, 'longitude': -118.4912, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90409', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0195, 'longitude': -118.4912, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90410', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0195, 'longitude': -118.4912, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90411', 'place_name': 'Santa Monica', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0195, 'longitude': -118.4912, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90501', 'place_name': 'Torrance', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8268, 'longitude': -118.3118, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90502', 'place_name': 'Torrance', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8286, 'longitude': -118.292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90503', 'place_name': 'Torrance', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8397, 'longitude': -118.3542, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90504', 'place_name': 'Torrance', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8708, 'longitude': -118.3295, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90505', 'place_name': 'Torrance', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8106, 'longitude': -118.3507, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90506', 'place_name': 'Torrance', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90507', 'place_name': 'Torrance', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90508', 'place_name': 'Torrance', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90509', 'place_name': 'Torrance', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90510', 'place_name': 'Torrance', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90601', 'place_name': 'Whittier', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0011, 'longitude': -118.0371, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90602', 'place_name': 'Whittier', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9693, 'longitude': -118.0337, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90603', 'place_name': 'Whittier', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9432, 'longitude': -117.9927, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90604', 'place_name': 'Whittier', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9299, 'longitude': -118.0121, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90605', 'place_name': 'Whittier', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9413, 'longitude': -118.0356, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90606', 'place_name': 'Whittier', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9777, 'longitude': -118.0658, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90607', 'place_name': 'Whittier', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9792, 'longitude': -118.0328, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90608', 'place_name': 'Whittier', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9792, 'longitude': -118.0328, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90609', 'place_name': 'Whittier', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9792, 'longitude': -118.0328, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90610', 'place_name': 'Whittier', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9792, 'longitude': -118.0328, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90637', 'place_name': 'La Mirada', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9172, 'longitude': -118.012, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90638', 'place_name': 'La Mirada', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9067, 'longitude': -118.0101, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90639', 'place_name': 'La Mirada', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9058, 'longitude': -118.0182, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90640', 'place_name': 'Montebello', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0133, 'longitude': -118.113, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90650', 'place_name': 'Norwalk', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9056, 'longitude': -118.0818, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90651', 'place_name': 'Norwalk', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9022, 'longitude': -118.0817, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90652', 'place_name': 'Norwalk', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9022, 'longitude': -118.0817, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90660', 'place_name': 'Pico Rivera', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9886, 'longitude': -118.0883, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90661', 'place_name': 'Pico Rivera', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9831, 'longitude': -118.0967, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90662', 'place_name': 'Pico Rivera', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9831, 'longitude': -118.0967, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90670', 'place_name': 'Santa Fe Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9464, 'longitude': -118.0838, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90671', 'place_name': 'Santa Fe Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9472, 'longitude': -118.0853, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90701', 'place_name': 'Artesia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8654, 'longitude': -118.0731, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90702', 'place_name': 'Artesia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8658, 'longitude': -118.0831, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90703', 'place_name': 'Cerritos', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8669, 'longitude': -118.0686, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90704', 'place_name': 'Avalon', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.332, 'longitude': -118.3437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90706', 'place_name': 'Bellflower', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8867, 'longitude': -118.1265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90707', 'place_name': 'Bellflower', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8817, 'longitude': -118.117, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90710', 'place_name': 'Harbor City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.797, 'longitude': -118.2991, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90711', 'place_name': 'Lakewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90712', 'place_name': 'Lakewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8512, 'longitude': -118.1457, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90713', 'place_name': 'Lakewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8473, 'longitude': -118.1115, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90714', 'place_name': 'Lakewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8512, 'longitude': -118.1339, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90715', 'place_name': 'Lakewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8405, 'longitude': -118.0767, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90716', 'place_name': 'Hawaiian Gardens', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8296, 'longitude': -118.073, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90717', 'place_name': 'Lomita', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7938, 'longitude': -118.3172, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90723', 'place_name': 'Paramount', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8969, 'longitude': -118.1632, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90731', 'place_name': 'San Pedro', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7339, 'longitude': -118.2914, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90732', 'place_name': 'San Pedro', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.742, 'longitude': -118.3121, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90733', 'place_name': 'San Pedro', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90734', 'place_name': 'San Pedro', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90744', 'place_name': 'Wilmington', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7855, 'longitude': -118.2645, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90745', 'place_name': 'Carson', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.823, 'longitude': -118.2684, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90746', 'place_name': 'Carson', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8584, 'longitude': -118.2554, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90747', 'place_name': 'Carson', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8671, 'longitude': -118.2538, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90748', 'place_name': 'Wilmington', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.78, 'longitude': -118.2626, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90749', 'place_name': 'Carson', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90755', 'place_name': 'Signal Hill', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8029, 'longitude': -118.1677, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90801', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.767, 'longitude': -118.1892, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90802', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7706, 'longitude': -118.182, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90803', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7619, 'longitude': -118.1341, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90804', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7857, 'longitude': -118.1357, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90805', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8635, 'longitude': -118.1801, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90806', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8045, 'longitude': -118.1876, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90807', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8315, 'longitude': -118.1811, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90808', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8241, 'longitude': -118.1103, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90809', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90810', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8193, 'longitude': -118.2325, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90813', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.782, 'longitude': -118.1835, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90814', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7716, 'longitude': -118.148, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90815', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7939, 'longitude': -118.1192, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90822', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7927, 'longitude': -118.1638, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90831', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7678, 'longitude': -118.1994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90832', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.767, 'longitude': -118.1892, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90833', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7678, 'longitude': -118.1994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90834', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7678, 'longitude': -118.1994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90835', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7678, 'longitude': -118.1994, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90840', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7843, 'longitude': -118.1157, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90842', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90844', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.767, 'longitude': -118.1892, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90846', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8249, 'longitude': -118.1504, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90847', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90848', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90853', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90895', 'place_name': 'Carson', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.8392, 'longitude': -118.2202, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90899', 'place_name': 'Long Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.767, 'longitude': -118.1892, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91001', 'place_name': 'Altadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1912, 'longitude': -118.1392, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91003', 'place_name': 'Altadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1897, 'longitude': -118.1312, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91006', 'place_name': 'Arcadia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1324, 'longitude': -118.0264, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91007', 'place_name': 'Arcadia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1243, 'longitude': -118.0515, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91008', 'place_name': 'Duarte', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.149, 'longitude': -117.9644, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91009', 'place_name': 'Duarte', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1395, 'longitude': -117.9773, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91010', 'place_name': 'Duarte', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1407, 'longitude': -117.9567, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91011', 'place_name': 'La Canada Flintridge', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2217, 'longitude': -118.2051, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91012', 'place_name': 'La Canada Flintridge', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1992, 'longitude': -118.1879, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91016', 'place_name': 'Monrovia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.144, 'longitude': -118.0014, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91017', 'place_name': 'Monrovia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1481, 'longitude': -117.999, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91020', 'place_name': 'Montrose', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2114, 'longitude': -118.2305, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91021', 'place_name': 'Montrose', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2064, 'longitude': -118.2242, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91023', 'place_name': 'Mount Wilson', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2264, 'longitude': -118.0662, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91024', 'place_name': 'Sierra Madre', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1651, 'longitude': -118.0519, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91025', 'place_name': 'Sierra Madre', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1617, 'longitude': -118.0528, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91030', 'place_name': 'South Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1109, 'longitude': -118.1547, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91031', 'place_name': 'South Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1161, 'longitude': -118.1503, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91040', 'place_name': 'Sunland', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2618, 'longitude': -118.3371, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91041', 'place_name': 'Sunland', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2669, 'longitude': -118.3023, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91042', 'place_name': 'Tujunga', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2544, 'longitude': -118.2849, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91043', 'place_name': 'Tujunga', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2522, 'longitude': -118.2884, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91046', 'place_name': 'Verdugo City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2114, 'longitude': -118.2395, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91066', 'place_name': 'Arcadia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1397, 'longitude': -118.0353, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91077', 'place_name': 'Arcadia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1397, 'longitude': -118.0353, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91101', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1468, 'longitude': -118.1391, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91102', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91103', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1669, 'longitude': -118.1551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91104', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1678, 'longitude': -118.1261, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91105', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1355, 'longitude': -118.1636, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91106', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1435, 'longitude': -118.1266, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91107', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.151, 'longitude': -118.0889, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91108', 'place_name': 'San Marino', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1207, 'longitude': -118.1117, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91109', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91110', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91114', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91115', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91116', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91117', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91118', 'place_name': 'San Marino', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1214, 'longitude': -118.1065, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91121', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91123', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91124', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91125', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91126', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91129', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91182', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91184', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91185', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91188', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91189', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91199', 'place_name': 'Pasadena', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1478, 'longitude': -118.1436, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91201', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1716, 'longitude': -118.2899, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91202', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1652, 'longitude': -118.2656, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91203', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1517, 'longitude': -118.2636, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91204', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1379, 'longitude': -118.2599, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91205', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1378, 'longitude': -118.2425, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91206', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1556, 'longitude': -118.2322, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91207', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1649, 'longitude': -118.2451, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91208', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1921, 'longitude': -118.235, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91209', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1425, 'longitude': -118.2551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91210', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1425, 'longitude': -118.2551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91214', 'place_name': 'La Crescenta', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2316, 'longitude': -118.2457, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91221', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1425, 'longitude': -118.2551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91222', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1425, 'longitude': -118.2551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91224', 'place_name': 'La Crescenta', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2242, 'longitude': -118.2401, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91225', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1425, 'longitude': -118.2551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91226', 'place_name': 'Glendale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1425, 'longitude': -118.2551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91301', 'place_name': 'Agoura Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1227, 'longitude': -118.7573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91302', 'place_name': 'Calabasas', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1419, 'longitude': -118.6641, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91303', 'place_name': 'Canoga Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1993, 'longitude': -118.5983, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91304', 'place_name': 'Canoga Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2197, 'longitude': -118.6111, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91305', 'place_name': 'Canoga Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2011, 'longitude': -118.5981, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91306', 'place_name': 'Winnetka', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2092, 'longitude': -118.5749, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91307', 'place_name': 'West Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1963, 'longitude': -118.6389, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91308', 'place_name': 'West Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1973, 'longitude': -118.644, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91309', 'place_name': 'Canoga Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2011, 'longitude': -118.5981, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91310', 'place_name': 'Castaic', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4889, 'longitude': -118.6229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91311', 'place_name': 'Chatsworth', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2583, 'longitude': -118.5914, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91313', 'place_name': 'Chatsworth', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2572, 'longitude': -118.6012, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91316', 'place_name': 'Encino', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1655, 'longitude': -118.5175, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91321', 'place_name': 'Newhall', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.3795, 'longitude': -118.523, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91322', 'place_name': 'Newhall', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.3847, 'longitude': -118.5309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91324', 'place_name': 'Northridge', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2367, 'longitude': -118.5466, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91325', 'place_name': 'Northridge', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2353, 'longitude': -118.5188, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91326', 'place_name': 'Porter Ranch', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2619, 'longitude': -118.582, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '91327', 'place_name': 'Northridge', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2283, 'longitude': -118.5368, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91328', 'place_name': 'Northridge', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2283, 'longitude': -118.5368, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91329', 'place_name': 'Northridge', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2283, 'longitude': -118.5368, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91330', 'place_name': 'Northridge', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2283, 'longitude': -118.5368, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91331', 'place_name': 'Pacoima', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2556, 'longitude': -118.4208, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91333', 'place_name': 'Pacoima', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2625, 'longitude': -118.427, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91334', 'place_name': 'Pacoima', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2625, 'longitude': -118.427, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91335', 'place_name': 'Reseda', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2007, 'longitude': -118.5391, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91337', 'place_name': 'Reseda', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2011, 'longitude': -118.5365, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91340', 'place_name': 'San Fernando', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2875, 'longitude': -118.4352, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91341', 'place_name': 'San Fernando', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2819, 'longitude': -118.439, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91342', 'place_name': 'Sylmar', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.3054, 'longitude': -118.4322, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91343', 'place_name': 'North Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2366, 'longitude': -118.4758, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91344', 'place_name': 'Granada Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2771, 'longitude': -118.4992, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91345', 'place_name': 'Mission Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2619, 'longitude': -118.4587, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91346', 'place_name': 'Mission Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2572, 'longitude': -118.467, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91350', 'place_name': 'Santa Clarita', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4336, 'longitude': -118.5007, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91351', 'place_name': 'Canyon Country', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4262, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91352', 'place_name': 'Sun Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2209, 'longitude': -118.3699, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91353', 'place_name': 'Sun Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2175, 'longitude': -118.3704, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91354', 'place_name': 'Valencia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4466, 'longitude': -118.5374, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91355', 'place_name': 'Valencia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.3985, 'longitude': -118.5535, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91356', 'place_name': 'Tarzana', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1671, 'longitude': -118.5414, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91357', 'place_name': 'Tarzana', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1733, 'longitude': -118.554, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91364', 'place_name': 'Woodland Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1557, 'longitude': -118.6, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91365', 'place_name': 'Woodland Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1683, 'longitude': -118.6059, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91367', 'place_name': 'Woodland Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1767, 'longitude': -118.6159, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91371', 'place_name': 'Woodland Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1683, 'longitude': -118.6059, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91372', 'place_name': 'Calabasas', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1578, 'longitude': -118.6384, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91376', 'place_name': 'Agoura Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1364, 'longitude': -118.7745, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91380', 'place_name': 'Santa Clarita', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.3917, 'longitude': -118.5426, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91381', 'place_name': 'Stevenson Ranch', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.3775, 'longitude': -118.6131, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91382', 'place_name': 'Santa Clarita', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.3917, 'longitude': -118.5426, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91383', 'place_name': 'Santa Clarita', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.3917, 'longitude': -118.5426, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91384', 'place_name': 'Castaic', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4827, 'longitude': -118.6254, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91385', 'place_name': 'Valencia', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4436, 'longitude': -118.6095, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91386', 'place_name': 'Canyon Country', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4233, 'longitude': -118.472, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91387', 'place_name': 'Canyon Country', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4132, 'longitude': -118.426, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91390', 'place_name': 'Santa Clarita', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4684, 'longitude': -118.5261, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91392', 'place_name': 'Sylmar', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.3078, 'longitude': -118.4492, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91393', 'place_name': 'North Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2364, 'longitude': -118.4847, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91394', 'place_name': 'Granada Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2647, 'longitude': -118.5231, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91395', 'place_name': 'Mission Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2572, 'longitude': -118.467, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91396', 'place_name': 'Winnetka', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2133, 'longitude': -118.572, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91401', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1802, 'longitude': -118.4324, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91402', 'place_name': 'Panorama City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2262, 'longitude': -118.447, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91403', 'place_name': 'Sherman Oaks', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1514, 'longitude': -118.4603, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91404', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1867, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91405', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2001, 'longitude': -118.4456, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91406', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2006, 'longitude': -118.4868, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91407', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1867, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91408', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1867, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91409', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1867, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91410', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1867, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91411', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1781, 'longitude': -118.4574, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91412', 'place_name': 'Panorama City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2247, 'longitude': -118.4498, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91413', 'place_name': 'Sherman Oaks', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1511, 'longitude': -118.4492, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91416', 'place_name': 'Encino', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1592, 'longitude': -118.5012, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91423', 'place_name': 'Sherman Oaks', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1526, 'longitude': -118.4322, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91426', 'place_name': 'Encino', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1592, 'longitude': -118.5012, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91436', 'place_name': 'Encino', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.151, 'longitude': -118.4882, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91470', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1867, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91482', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1867, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91495', 'place_name': 'Sherman Oaks', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1511, 'longitude': -118.4492, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91496', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1867, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91499', 'place_name': 'Van Nuys', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1867, 'longitude': -118.449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91501', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1862, 'longitude': -118.3009, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91502', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1745, 'longitude': -118.3059, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91503', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1808, 'longitude': -118.309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91504', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2001, 'longitude': -118.3264, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91505', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.169, 'longitude': -118.3442, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91506', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1717, 'longitude': -118.3231, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91507', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1808, 'longitude': -118.309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91508', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1808, 'longitude': -118.309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91510', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1808, 'longitude': -118.309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91521', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1808, 'longitude': -118.309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91522', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1808, 'longitude': -118.309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91523', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1808, 'longitude': -118.309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91526', 'place_name': 'Burbank', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1808, 'longitude': -118.309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91601', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1687, 'longitude': -118.3713, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91602', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.151, 'longitude': -118.3663, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91603', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1722, 'longitude': -118.379, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91604', 'place_name': 'Studio City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.143, 'longitude': -118.3913, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91605', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2057, 'longitude': -118.4001, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91606', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1872, 'longitude': -118.3865, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91607', 'place_name': 'Valley Village', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1672, 'longitude': -118.3989, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91608', 'place_name': 'Universal City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1383, 'longitude': -118.3528, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91609', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1722, 'longitude': -118.379, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91610', 'place_name': 'Toluca Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.7866, 'longitude': -118.2987, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '91611', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1722, 'longitude': -118.379, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91612', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1722, 'longitude': -118.379, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91614', 'place_name': 'Studio City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1486, 'longitude': -118.3965, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91615', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1722, 'longitude': -118.379, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91616', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1722, 'longitude': -118.379, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91617', 'place_name': 'Valley Village', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1649, 'longitude': -118.3965, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91618', 'place_name': 'North Hollywood', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1722, 'longitude': -118.379, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91702', 'place_name': 'Azusa', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1248, 'longitude': -117.9031, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91706', 'place_name': 'Baldwin Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0964, 'longitude': -117.9682, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91711', 'place_name': 'Claremont', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1092, 'longitude': -117.7183, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91714', 'place_name': 'City Of Industry', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0197, 'longitude': -117.9587, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91715', 'place_name': 'City Of Industry', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0197, 'longitude': -117.9587, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91716', 'place_name': 'City Of Industry', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0197, 'longitude': -117.9587, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91722', 'place_name': 'Covina', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0972, 'longitude': -117.9065, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91723', 'place_name': 'Covina', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.086, 'longitude': -117.8843, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91724', 'place_name': 'Covina', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0938, 'longitude': -117.856, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91731', 'place_name': 'El Monte', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0791, 'longitude': -118.0371, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91732', 'place_name': 'El Monte', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0705, 'longitude': -118.0149, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91733', 'place_name': 'South El Monte', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0557, 'longitude': -118.0444, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91734', 'place_name': 'El Monte', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0686, 'longitude': -118.0276, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91735', 'place_name': 'El Monte', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0686, 'longitude': -118.0276, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91740', 'place_name': 'Glendora', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1287, 'longitude': -117.8552, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91741', 'place_name': 'Glendora', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1537, 'longitude': -117.8437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91744', 'place_name': 'La Puente', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0289, 'longitude': -117.9373, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91745', 'place_name': 'Hacienda Heights', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9977, 'longitude': -117.9652, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91746', 'place_name': 'La Puente', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0443, 'longitude': -117.9862, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91747', 'place_name': 'La Puente', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.02, 'longitude': -117.9495, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91748', 'place_name': 'Rowland Heights', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 33.9818, 'longitude': -117.8969, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91749', 'place_name': 'La Puente', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.02, 'longitude': -117.9495, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91750', 'place_name': 'La Verne', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1159, 'longitude': -117.7708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91754', 'place_name': 'Monterey Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0534, 'longitude': -118.1271, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91755', 'place_name': 'Monterey Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.048, 'longitude': -118.115, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91756', 'place_name': 'Monterey Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0625, 'longitude': -118.1228, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91759', 'place_name': 'Mount Baldy', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.2361, 'longitude': -117.6601, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '91765', 'place_name': 'Diamond Bar', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0066, 'longitude': -117.8098, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91766', 'place_name': 'Pomona', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0418, 'longitude': -117.7569, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91767', 'place_name': 'Pomona', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0812, 'longitude': -117.7362, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91768', 'place_name': 'Pomona', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0662, 'longitude': -117.7763, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91769', 'place_name': 'Pomona', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0553, 'longitude': -117.7523, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91770', 'place_name': 'Rosemead', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0658, 'longitude': -118.0853, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91771', 'place_name': 'Rosemead', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0806, 'longitude': -118.0728, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91772', 'place_name': 'Rosemead', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0806, 'longitude': -118.0728, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91773', 'place_name': 'San Dimas', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1023, 'longitude': -117.8169, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91775', 'place_name': 'San Gabriel', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1155, 'longitude': -118.0857, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91776', 'place_name': 'San Gabriel', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.089, 'longitude': -118.0955, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91778', 'place_name': 'San Gabriel', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0961, 'longitude': -118.1058, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91780', 'place_name': 'Temple City', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.1016, 'longitude': -118.0537, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91788', 'place_name': 'Walnut', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0203, 'longitude': -117.8653, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91789', 'place_name': 'Walnut', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0183, 'longitude': -117.8546, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91790', 'place_name': 'West Covina', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0673, 'longitude': -117.9366, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91791', 'place_name': 'West Covina', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0653, 'longitude': -117.8978, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91792', 'place_name': 'West Covina', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0229, 'longitude': -117.8975, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91793', 'place_name': 'West Covina', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0686, 'longitude': -117.939, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91801', 'place_name': 'Alhambra', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0914, 'longitude': -118.1293, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91802', 'place_name': 'Alhambra', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0953, 'longitude': -118.127, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91803', 'place_name': 'Alhambra', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0745, 'longitude': -118.1434, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91804', 'place_name': 'Alhambra', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0953, 'longitude': -118.127, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91896', 'place_name': 'Alhambra', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0953, 'longitude': -118.127, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91899', 'place_name': 'Alhambra', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.0953, 'longitude': -118.127, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93510', 'place_name': 'Acton', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4835, 'longitude': -118.1959, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93532', 'place_name': 'Lake Hughes', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.6847, 'longitude': -118.5442, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93534', 'place_name': 'Lancaster', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.6909, 'longitude': -118.1491, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93535', 'place_name': 'Lancaster', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.7131, 'longitude': -117.8783, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93536', 'place_name': 'Lancaster', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.7471, 'longitude': -118.3687, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93539', 'place_name': 'Lancaster', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.698, 'longitude': -118.1367, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93543', 'place_name': 'Littlerock', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4891, 'longitude': -117.9708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93544', 'place_name': 'Llano', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.493, 'longitude': -117.7543, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93550', 'place_name': 'Palmdale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4133, 'longitude': -118.0917, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93551', 'place_name': 'Palmdale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.6017, 'longitude': -118.231, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93552', 'place_name': 'Palmdale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.5715, 'longitude': -118.0231, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93553', 'place_name': 'Pearblossom', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.4225, 'longitude': -117.9055, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93563', 'place_name': 'Valyermo', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.3966, 'longitude': -117.7604, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93584', 'place_name': 'Lancaster', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.698, 'longitude': -118.1367, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93586', 'place_name': 'Lancaster', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.698, 'longitude': -118.1367, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93590', 'place_name': 'Palmdale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.5794, 'longitude': -118.1165, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93591', 'place_name': 'Palmdale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.6019, 'longitude': -117.8123, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93599', 'place_name': 'Palmdale', 'state': 'California', 'state_ab': 'CA', 'county': 'Los Angeles', 'locality_code': '37', 'latitude': 34.5794, 'longitude': -118.1165, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93601', 'place_name': 'Ahwahnee', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 37.4076, 'longitude': -119.7233, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93604', 'place_name': 'Bass Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 37.3244, 'longitude': -119.5568, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93610', 'place_name': 'Chowchilla', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 37.1014, 'longitude': -120.2691, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93614', 'place_name': 'Coarsegold', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 37.2214, 'longitude': -119.7455, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93637', 'place_name': 'Madera', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 36.9403, 'longitude': -120.082, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93638', 'place_name': 'Madera', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 37.0402, 'longitude': -120.0335, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93639', 'place_name': 'Madera', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 36.9613, 'longitude': -120.0607, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93643', 'place_name': 'North Fork', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 37.2125, 'longitude': -119.5143, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93644', 'place_name': 'Oakhurst', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 37.3476, 'longitude': -119.6449, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93645', 'place_name': 'O Neals', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 37.1639, 'longitude': -119.6652, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93653', 'place_name': 'Raymond', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 37.279, 'longitude': -119.8766, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93669', 'place_name': 'Wishon', 'state': 'California', 'state_ab': 'CA', 'county': 'Madera', 'locality_code': '39', 'latitude': 37.281, 'longitude': -119.557, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '94901', 'place_name': 'San Rafael', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9691, 'longitude': -122.5105, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94903', 'place_name': 'San Rafael', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0339, 'longitude': -122.5855, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94904', 'place_name': 'Greenbrae', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9479, 'longitude': -122.5363, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94912', 'place_name': 'San Rafael', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9735, 'longitude': -122.5311, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94913', 'place_name': 'San Rafael', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9735, 'longitude': -122.5311, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94914', 'place_name': 'Kentfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9521, 'longitude': -122.5572, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94915', 'place_name': 'San Rafael', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0739, 'longitude': -122.5594, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94920', 'place_name': 'Belvedere Tiburon', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.8843, 'longitude': -122.4637, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '94924', 'place_name': 'Bolinas', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9079, 'longitude': -122.6947, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94925', 'place_name': 'Corte Madera', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9223, 'longitude': -122.5132, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94929', 'place_name': 'Dillon Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.2508, 'longitude': -122.9653, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94930', 'place_name': 'Fairfax', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9883, 'longitude': -122.5937, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94933', 'place_name': 'Forest Knolls', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0122, 'longitude': -122.6907, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94937', 'place_name': 'Inverness', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.1126, 'longitude': -122.8877, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94938', 'place_name': 'Lagunitas', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0139, 'longitude': -122.7016, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94939', 'place_name': 'Larkspur', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9367, 'longitude': -122.5362, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94940', 'place_name': 'Marshall', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.1762, 'longitude': -122.89, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94941', 'place_name': 'Mill Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.8958, 'longitude': -122.5339, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94942', 'place_name': 'Mill Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.906, 'longitude': -122.545, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94945', 'place_name': 'Novato', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.1163, 'longitude': -122.5714, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94946', 'place_name': 'Nicasio', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0546, 'longitude': -122.6964, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94947', 'place_name': 'Novato', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0973, 'longitude': -122.5837, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94948', 'place_name': 'Novato', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.1489, 'longitude': -122.5737, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94949', 'place_name': 'Novato', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0618, 'longitude': -122.5404, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94950', 'place_name': 'Olema', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0467, 'longitude': -122.7699, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94956', 'place_name': 'Point Reyes Station', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0691, 'longitude': -122.8069, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94957', 'place_name': 'Ross', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9624, 'longitude': -122.555, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94960', 'place_name': 'San Anselmo', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9846, 'longitude': -122.5711, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94963', 'place_name': 'San Geronimo', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0133, 'longitude': -122.6639, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94964', 'place_name': 'San Quentin', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9416, 'longitude': -122.4844, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94965', 'place_name': 'Sausalito', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.8601, 'longitude': -122.4946, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94966', 'place_name': 'Sausalito', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.8591, 'longitude': -122.4853, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94970', 'place_name': 'Stinson Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.902, 'longitude': -122.6393, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94971', 'place_name': 'Tomales', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.2427, 'longitude': -122.9145, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94973', 'place_name': 'Woodacre', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.0069, 'longitude': -122.6382, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94974', 'place_name': 'San Quentin', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9413, 'longitude': -122.485, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94976', 'place_name': 'Corte Madera', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9255, 'longitude': -122.5275, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94977', 'place_name': 'Larkspur', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9341, 'longitude': -122.5353, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94978', 'place_name': 'Fairfax', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9871, 'longitude': -122.5889, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94979', 'place_name': 'San Anselmo', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 37.9746, 'longitude': -122.5616, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94998', 'place_name': 'Novato', 'state': 'California', 'state_ab': 'CA', 'county': 'Marin', 'locality_code': '41', 'latitude': 38.1173, 'longitude': -122.5684, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93623', 'place_name': 'Fish Camp', 'state': 'California', 'state_ab': 'CA', 'county': 'Mariposa', 'locality_code': '43', 'latitude': 37.4785, 'longitude': -119.6404, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95306', 'place_name': 'Catheys Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Mariposa', 'locality_code': '43', 'latitude': 37.4404, 'longitude': -120.1438, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95311', 'place_name': 'Coulterville', 'state': 'California', 'state_ab': 'CA', 'county': 'Mariposa', 'locality_code': '43', 'latitude': 37.7197, 'longitude': -120.1197, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95318', 'place_name': 'El Portal', 'state': 'California', 'state_ab': 'CA', 'county': 'Mariposa', 'locality_code': '43', 'latitude': 37.6747, 'longitude': -119.7841, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95325', 'place_name': 'Hornitos', 'state': 'California', 'state_ab': 'CA', 'county': 'Mariposa', 'locality_code': '43', 'latitude': 37.4676, 'longitude': -120.2793, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95338', 'place_name': 'Mariposa', 'state': 'California', 'state_ab': 'CA', 'county': 'Mariposa', 'locality_code': '43', 'latitude': 37.4931, 'longitude': -119.9219, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95345', 'place_name': 'Midpines', 'state': 'California', 'state_ab': 'CA', 'county': 'Mariposa', 'locality_code': '43', 'latitude': 37.5757, 'longitude': -119.9601, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95389', 'place_name': 'Yosemite National Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Mariposa', 'locality_code': '43', 'latitude': 37.7314, 'longitude': -119.6489, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '95410', 'place_name': 'Albion', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.2131, 'longitude': -123.72, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95415', 'place_name': 'Boonville', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.0197, 'longitude': -123.3856, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95417', 'place_name': 'Branscomb', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.6949, 'longitude': -123.5527, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95418', 'place_name': 'Calpella', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.2214, 'longitude': -123.2154, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95420', 'place_name': 'Caspar', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.3629, 'longitude': -123.7944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95427', 'place_name': 'Comptche', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.2767, 'longitude': -123.5873, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95428', 'place_name': 'Covelo', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.82, 'longitude': -123.0585, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95429', 'place_name': 'Dos Rios', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.7168, 'longitude': -123.3533, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95432', 'place_name': 'Elk', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.1593, 'longitude': -123.7219, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95437', 'place_name': 'Fort Bragg', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.4402, 'longitude': -123.7703, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95445', 'place_name': 'Gualala', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 38.8251, 'longitude': -123.5399, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95449', 'place_name': 'Hopland', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 38.938, 'longitude': -123.0703, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95454', 'place_name': 'Laytonville', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.6627, 'longitude': -123.4929, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95456', 'place_name': 'Little River', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.2707, 'longitude': -123.7883, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95459', 'place_name': 'Manchester', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.0097, 'longitude': -123.6523, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95460', 'place_name': 'Mendocino', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.3173, 'longitude': -123.7739, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95463', 'place_name': 'Navarro', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.185, 'longitude': -123.5268, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95466', 'place_name': 'Philo', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.0657, 'longitude': -123.445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95468', 'place_name': 'Point Arena', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 38.9152, 'longitude': -123.6, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95469', 'place_name': 'Potter Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.3932, 'longitude': -123.0647, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95470', 'place_name': 'Redwood Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.2779, 'longitude': -123.2243, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95481', 'place_name': 'Talmage', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.1269, 'longitude': -123.1658, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95482', 'place_name': 'Ukiah', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.1552, 'longitude': -123.1951, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95488', 'place_name': 'Westport', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.6843, 'longitude': -123.7686, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95490', 'place_name': 'Willits', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.4493, 'longitude': -123.3679, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95494', 'place_name': 'Yorkville', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 38.9235, 'longitude': -123.2973, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95585', 'place_name': 'Leggett', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.8481, 'longitude': -123.6615, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95587', 'place_name': 'Piercy', 'state': 'California', 'state_ab': 'CA', 'county': 'Mendocino', 'locality_code': '45', 'latitude': 39.9465, 'longitude': -123.7552, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93620', 'place_name': 'Dos Palos', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.0025, 'longitude': -120.6333, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93635', 'place_name': 'Los Banos', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.0627, 'longitude': -120.8544, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93636', 'place_name': 'Madera', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 36.9528, 'longitude': -119.8806, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93661', 'place_name': 'Santa Rita Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.1869, 'longitude': -120.6504, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93665', 'place_name': 'South Dos Palos', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 36.9644, 'longitude': -120.6532, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95301', 'place_name': 'Atwater', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.3489, 'longitude': -120.6028, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95303', 'place_name': 'Ballico', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.4548, 'longitude': -120.6931, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95312', 'place_name': 'Cressey', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.4197, 'longitude': -120.6663, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95315', 'place_name': 'Delhi', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.4273, 'longitude': -120.7752, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95317', 'place_name': 'El Nido', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.1391, 'longitude': -120.5251, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95322', 'place_name': 'Gustine', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.2001, 'longitude': -121.0047, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95324', 'place_name': 'Hilmar', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.4002, 'longitude': -120.8723, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95333', 'place_name': 'Le Grand', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.2496, 'longitude': -120.2667, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95334', 'place_name': 'Livingston', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.3763, 'longitude': -120.7252, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95340', 'place_name': 'Merced', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.2983, 'longitude': -120.4649, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95341', 'place_name': 'Merced', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.2308, 'longitude': -120.5144, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95343', 'place_name': 'Merced', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.3082, 'longitude': -120.48, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95344', 'place_name': 'Merced', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.3082, 'longitude': -120.48, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95348', 'place_name': 'Merced', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.3302, 'longitude': -120.508, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95365', 'place_name': 'Planada', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.2908, 'longitude': -120.3185, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95369', 'place_name': 'Snelling', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.5354, 'longitude': -120.378, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95374', 'place_name': 'Stevinson', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.3283, 'longitude': -120.8764, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95388', 'place_name': 'Winton', 'state': 'California', 'state_ab': 'CA', 'county': 'Merced', 'locality_code': '47', 'latitude': 37.4014, 'longitude': -120.6045, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96006', 'place_name': 'Adin', 'state': 'California', 'state_ab': 'CA', 'county': 'Modoc', 'locality_code': '49', 'latitude': 41.2175, 'longitude': -120.9432, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96015', 'place_name': 'Canby', 'state': 'California', 'state_ab': 'CA', 'county': 'Modoc', 'locality_code': '49', 'latitude': 41.4664, 'longitude': -120.9218, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96054', 'place_name': 'Lookout', 'state': 'California', 'state_ab': 'CA', 'county': 'Modoc', 'locality_code': '49', 'latitude': 41.2347, 'longitude': -121.2156, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96101', 'place_name': 'Alturas', 'state': 'California', 'state_ab': 'CA', 'county': 'Modoc', 'locality_code': '49', 'latitude': 41.4767, 'longitude': -120.5456, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96104', 'place_name': 'Cedarville', 'state': 'California', 'state_ab': 'CA', 'county': 'Modoc', 'locality_code': '49', 'latitude': 41.4759, 'longitude': -120.1516, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96108', 'place_name': 'Davis Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'Modoc', 'locality_code': '49', 'latitude': 41.7336, 'longitude': -120.3741, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '96110', 'place_name': 'Eagleville', 'state': 'California', 'state_ab': 'CA', 'county': 'Modoc', 'locality_code': '49', 'latitude': 41.3163, 'longitude': -120.1158, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96112', 'place_name': 'Fort Bidwell', 'state': 'California', 'state_ab': 'CA', 'county': 'Modoc', 'locality_code': '49', 'latitude': 41.8644, 'longitude': -120.162, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '96115', 'place_name': 'Lake City', 'state': 'California', 'state_ab': 'CA', 'county': 'Modoc', 'locality_code': '49', 'latitude': 41.6682, 'longitude': -120.1814, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96116', 'place_name': 'Likely', 'state': 'California', 'state_ab': 'CA', 'county': 'Modoc', 'locality_code': '49', 'latitude': 41.2329, 'longitude': -120.5079, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93512', 'place_name': 'Benton', 'state': 'California', 'state_ab': 'CA', 'county': 'Mono', 'locality_code': '51', 'latitude': 37.8926, 'longitude': -118.5647, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93517', 'place_name': 'Bridgeport', 'state': 'California', 'state_ab': 'CA', 'county': 'Mono', 'locality_code': '51', 'latitude': 38.2566, 'longitude': -119.208, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '93529', 'place_name': 'June Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'Mono', 'locality_code': '51', 'latitude': 37.7773, 'longitude': -119.0825, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '93541', 'place_name': 'Lee Vining', 'state': 'California', 'state_ab': 'CA', 'county': 'Mono', 'locality_code': '51', 'latitude': 37.989, 'longitude': -119.1234, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '93546', 'place_name': 'Mammoth Lakes', 'state': 'California', 'state_ab': 'CA', 'county': 'Mono', 'locality_code': '51', 'latitude': 37.6094, 'longitude': -118.8656, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96107', 'place_name': 'Coleville', 'state': 'California', 'state_ab': 'CA', 'county': 'Mono', 'locality_code': '51', 'latitude': 38.5029, 'longitude': -119.4828, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96133', 'place_name': 'Topaz', 'state': 'California', 'state_ab': 'CA', 'county': 'Mono', 'locality_code': '51', 'latitude': 38.6415, 'longitude': -119.5122, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '93426', 'place_name': 'Bradley', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 35.8093, 'longitude': -120.9728, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93450', 'place_name': 'San Ardo', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 35.9857, 'longitude': -120.8612, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93901', 'place_name': 'Salinas', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6677, 'longitude': -121.6596, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93902', 'place_name': 'Salinas', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6777, 'longitude': -121.6555, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93905', 'place_name': 'Salinas', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6811, 'longitude': -121.6176, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93906', 'place_name': 'Salinas', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.7103, 'longitude': -121.6438, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93907', 'place_name': 'Salinas', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.7563, 'longitude': -121.6703, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93908', 'place_name': 'Salinas', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6011, 'longitude': -121.6729, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93912', 'place_name': 'Salinas', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6777, 'longitude': -121.6555, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93915', 'place_name': 'Salinas', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6777, 'longitude': -121.6555, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93920', 'place_name': 'Big Sur', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.2458, 'longitude': -121.7009, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93921', 'place_name': 'Carmel By The Sea', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.5552, 'longitude': -121.9233, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93922', 'place_name': 'Carmel', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.5433, 'longitude': -121.9263, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93923', 'place_name': 'Carmel', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.5457, 'longitude': -121.8949, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93924', 'place_name': 'Carmel Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.4787, 'longitude': -121.7244, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93925', 'place_name': 'Chualar', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.595, 'longitude': -121.432, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93926', 'place_name': 'Gonzales', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.49, 'longitude': -121.4103, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93927', 'place_name': 'Greenfield', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.3202, 'longitude': -121.2451, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93928', 'place_name': 'Jolon', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 35.9708, 'longitude': -121.176, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93930', 'place_name': 'King City', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.2028, 'longitude': -121.1273, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93932', 'place_name': 'Lockwood', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 35.95, 'longitude': -121.0626, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93933', 'place_name': 'Marina', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6849, 'longitude': -121.7934, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93940', 'place_name': 'Monterey', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.5802, 'longitude': -121.8443, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93942', 'place_name': 'Monterey', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6002, 'longitude': -121.8947, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93943', 'place_name': 'Monterey', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.597, 'longitude': -121.8741, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93944', 'place_name': 'Monterey', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6062, 'longitude': -121.9089, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93950', 'place_name': 'Pacific Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6167, 'longitude': -121.922, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93953', 'place_name': 'Pebble Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.5907, 'longitude': -121.942, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93954', 'place_name': 'San Lucas', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.1289, 'longitude': -121.0205, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93955', 'place_name': 'Seaside', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6217, 'longitude': -121.7935, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93960', 'place_name': 'Soledad', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.4196, 'longitude': -121.3243, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93962', 'place_name': 'Spreckels', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.6261, 'longitude': -121.6555, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95004', 'place_name': 'Aromas', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.8769, 'longitude': -121.6324, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95012', 'place_name': 'Castroville', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.7658, 'longitude': -121.758, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95039', 'place_name': 'Moss Landing', 'state': 'California', 'state_ab': 'CA', 'county': 'Monterey', 'locality_code': '53', 'latitude': 36.8175, 'longitude': -121.7773, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94503', 'place_name': 'American Canyon', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.1668, 'longitude': -122.2553, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94508', 'place_name': 'Angwin', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.5769, 'longitude': -122.4477, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94515', 'place_name': 'Calistoga', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.5823, 'longitude': -122.5814, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94558', 'place_name': 'Napa', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.4549, 'longitude': -122.2564, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94559', 'place_name': 'Napa', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.2904, 'longitude': -122.2841, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94562', 'place_name': 'Oakville', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.4379, 'longitude': -122.3991, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94567', 'place_name': 'Pope Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.6152, 'longitude': -122.4278, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94573', 'place_name': 'Rutherford', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.4585, 'longitude': -122.4225, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94574', 'place_name': 'Saint Helena', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.5138, 'longitude': -122.4619, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94576', 'place_name': 'Deer Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.5494, 'longitude': -122.4764, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94581', 'place_name': 'Napa', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.2971, 'longitude': -122.2855, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94599', 'place_name': 'Yountville', 'state': 'California', 'state_ab': 'CA', 'county': 'Napa', 'locality_code': '55', 'latitude': 38.4016, 'longitude': -122.3608, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95712', 'place_name': 'Chicago Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.143, 'longitude': -120.9666, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '95724', 'place_name': 'Norden', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.318, 'longitude': -120.356, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95728', 'place_name': 'Soda Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.317, 'longitude': -120.4259, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95924', 'place_name': 'Cedar Ridge', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.1988, 'longitude': -121.02, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95945', 'place_name': 'Grass Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.2081, 'longitude': -121.0069, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95946', 'place_name': 'Penn Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.2019, 'longitude': -121.2026, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95949', 'place_name': 'Grass Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.1193, 'longitude': -121.0938, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95959', 'place_name': 'Nevada City', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.3017, 'longitude': -120.9717, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95960', 'place_name': 'North San Juan', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.3765, 'longitude': -121.0891, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95975', 'place_name': 'Rough And Ready', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.2286, 'longitude': -121.1509, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95977', 'place_name': 'Smartsville', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.2076, 'longitude': -121.3001, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95986', 'place_name': 'Washington', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.3569, 'longitude': -120.8, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96111', 'place_name': 'Floriston', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.3928, 'longitude': -120.0212, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '96160', 'place_name': 'Truckee', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.328, 'longitude': -120.1833, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96161', 'place_name': 'Truckee', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.3385, 'longitude': -120.1729, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96162', 'place_name': 'Truckee', 'state': 'California', 'state_ab': 'CA', 'county': 'Nevada', 'locality_code': '57', 'latitude': 39.328, 'longitude': -120.1833, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90620', 'place_name': 'Buena Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8439, 'longitude': -118.008, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90621', 'place_name': 'Buena Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8772, 'longitude': -117.9893, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90622', 'place_name': 'Buena Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8462, 'longitude': -118.0031, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90623', 'place_name': 'La Palma', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8491, 'longitude': -118.0398, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90624', 'place_name': 'Buena Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8584, 'longitude': -118.0033, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90630', 'place_name': 'Cypress', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8181, 'longitude': -118.0357, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90631', 'place_name': 'La Habra', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.9331, 'longitude': -117.9493, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90632', 'place_name': 'La Habra', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.9143, 'longitude': -117.9547, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90633', 'place_name': 'La Habra', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.9345, 'longitude': -117.9452, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90680', 'place_name': 'Stanton', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7991, 'longitude': -117.9956, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90720', 'place_name': 'Los Alamitos', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7956, 'longitude': -118.0648, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90721', 'place_name': 'Los Alamitos', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8023, 'longitude': -118.069, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90740', 'place_name': 'Seal Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7602, 'longitude': -118.0808, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90742', 'place_name': 'Sunset Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7164, 'longitude': -118.069, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '90743', 'place_name': 'Surfside', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7264, 'longitude': -118.0833, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92602', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7419, 'longitude': -117.7467, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92603', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6245, 'longitude': -117.794, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92604', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6899, 'longitude': -117.7868, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92605', 'place_name': 'Huntington Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7151, 'longitude': -118.0077, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92606', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6951, 'longitude': -117.8224, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92607', 'place_name': 'Laguna Niguel', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.5269, 'longitude': -117.7117, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92609', 'place_name': 'El Toro', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.624, 'longitude': -117.6908, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92610', 'place_name': 'Foothill Ranch', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6748, 'longitude': -117.6649, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92612', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6607, 'longitude': -117.8264, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92614', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6829, 'longitude': -117.8298, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92615', 'place_name': 'Huntington Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6566, 'longitude': -117.9699, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92616', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6519, 'longitude': -117.8361, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92617', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6425, 'longitude': -117.8417, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92618', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7074, 'longitude': -117.7054, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92619', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6706, 'longitude': -117.7645, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92620', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7009, 'longitude': -117.7564, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92623', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6942, 'longitude': -117.8126, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92624', 'place_name': 'Capistrano Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.46, 'longitude': -117.6632, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92625', 'place_name': 'Corona Del Mar', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6021, 'longitude': -117.8743, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92626', 'place_name': 'Costa Mesa', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6801, 'longitude': -117.9085, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92627', 'place_name': 'Costa Mesa', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6483, 'longitude': -117.9155, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92628', 'place_name': 'Costa Mesa', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6401, 'longitude': -117.9159, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92629', 'place_name': 'Dana Point', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.4743, 'longitude': -117.6964, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92630', 'place_name': 'Lake Forest', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6437, 'longitude': -117.6868, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92637', 'place_name': 'Laguna Woods', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6103, 'longitude': -117.7253, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92646', 'place_name': 'Huntington Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6654, 'longitude': -117.9686, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92647', 'place_name': 'Huntington Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.721, 'longitude': -118.0033, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92648', 'place_name': 'Huntington Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6773, 'longitude': -118.0051, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92649', 'place_name': 'Huntington Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.718, 'longitude': -118.0505, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92650', 'place_name': 'East Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6795, 'longitude': -117.7609, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92651', 'place_name': 'Laguna Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.5429, 'longitude': -117.7813, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92652', 'place_name': 'Laguna Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.543, 'longitude': -117.7815, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92653', 'place_name': 'Laguna Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.5916, 'longitude': -117.6985, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92654', 'place_name': 'Laguna Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6042, 'longitude': -117.7154, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92655', 'place_name': 'Midway City', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7446, 'longitude': -117.984, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92656', 'place_name': 'Aliso Viejo', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.5701, 'longitude': -117.7086, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92657', 'place_name': 'Newport Coast', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.5943, 'longitude': -117.8334, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92658', 'place_name': 'Newport Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6422, 'longitude': -117.8631, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92659', 'place_name': 'Newport Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6222, 'longitude': -117.9235, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92660', 'place_name': 'Newport Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6295, 'longitude': -117.8684, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92661', 'place_name': 'Newport Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6045, 'longitude': -117.9021, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92662', 'place_name': 'Newport Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6062, 'longitude': -117.8931, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92663', 'place_name': 'Newport Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.621, 'longitude': -117.9321, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92672', 'place_name': 'San Clemente', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.4361, 'longitude': -117.6231, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92673', 'place_name': 'San Clemente', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.4615, 'longitude': -117.6375, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92674', 'place_name': 'San Clemente', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.4409, 'longitude': -117.6211, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92675', 'place_name': 'San Juan Capistrano', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.5085, 'longitude': -117.6565, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92676', 'place_name': 'Silverado', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7451, 'longitude': -117.6153, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92677', 'place_name': 'Laguna Niguel', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.5145, 'longitude': -117.7084, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92678', 'place_name': 'Trabuco Canyon', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6643, 'longitude': -117.5896, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92679', 'place_name': 'Trabuco Canyon', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6625, 'longitude': -117.5903, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92683', 'place_name': 'Westminster', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7524, 'longitude': -117.9939, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92684', 'place_name': 'Westminster', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7627, 'longitude': -118.0072, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92685', 'place_name': 'Westminster', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7528, 'longitude': -117.9951, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92688', 'place_name': 'Rancho Santa Margarita', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6512, 'longitude': -117.5938, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92690', 'place_name': 'Mission Viejo', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6117, 'longitude': -117.643, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92691', 'place_name': 'Mission Viejo', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6128, 'longitude': -117.6622, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92692', 'place_name': 'Mission Viejo', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6144, 'longitude': -117.6433, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92693', 'place_name': 'San Juan Capistrano', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.4977, 'longitude': -117.6651, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92694', 'place_name': 'Ladera Ranch', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.5472, 'longitude': -117.6238, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92697', 'place_name': 'Irvine', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6485, 'longitude': -117.8387, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92698', 'place_name': 'Aliso Viejo', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.6686, 'longitude': -117.8386, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92701', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7523, 'longitude': -117.8541, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92702', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7365, 'longitude': -117.8714, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92703', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7489, 'longitude': -117.9072, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92704', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7249, 'longitude': -117.909, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92705', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.754, 'longitude': -117.7919, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92706', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7691, 'longitude': -117.8855, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92707', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7086, 'longitude': -117.8701, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92708', 'place_name': 'Fountain Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7102, 'longitude': -117.9503, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92711', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7669, 'longitude': -117.8043, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92712', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7496, 'longitude': -117.875, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92728', 'place_name': 'Fountain Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.714, 'longitude': -117.9284, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92735', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7188, 'longitude': -117.8546, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92780', 'place_name': 'Tustin', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7364, 'longitude': -117.8229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92781', 'place_name': 'Tustin', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7369, 'longitude': -117.8181, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92782', 'place_name': 'Tustin', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7346, 'longitude': -117.7869, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92799', 'place_name': 'Santa Ana', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7205, 'longitude': -117.9098, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92801', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8428, 'longitude': -117.9546, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92802', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8085, 'longitude': -117.9228, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92803', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8397, 'longitude': -117.9388, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92804', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8186, 'longitude': -117.9729, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92805', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8359, 'longitude': -117.9086, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92806', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8356, 'longitude': -117.8681, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92807', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8544, 'longitude': -117.7858, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92808', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8579, 'longitude': -117.7513, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92809', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8426, 'longitude': -117.9388, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92811', 'place_name': 'Atwood', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8674, 'longitude': -117.831, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92812', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.817, 'longitude': -117.9286, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92814', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8173, 'longitude': -117.9607, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92815', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8319, 'longitude': -117.9121, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92816', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8401, 'longitude': -117.8867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92817', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8512, 'longitude': -117.7915, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92821', 'place_name': 'Brea', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.9291, 'longitude': -117.8845, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92822', 'place_name': 'Brea', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.9187, 'longitude': -117.8892, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92823', 'place_name': 'Brea', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.923, 'longitude': -117.798, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92825', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8356, 'longitude': -117.9132, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92831', 'place_name': 'Fullerton', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8873, 'longitude': -117.8946, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92832', 'place_name': 'Fullerton', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.868, 'longitude': -117.9265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92833', 'place_name': 'Fullerton', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8766, 'longitude': -117.9551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92834', 'place_name': 'Fullerton', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8768, 'longitude': -117.897, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92835', 'place_name': 'Fullerton', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8994, 'longitude': -117.9063, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92836', 'place_name': 'Fullerton', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8755, 'longitude': -117.9038, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92837', 'place_name': 'Fullerton', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8695, 'longitude': -117.9611, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92838', 'place_name': 'Fullerton', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8934, 'longitude': -117.931, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92840', 'place_name': 'Garden Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7869, 'longitude': -117.9273, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92841', 'place_name': 'Garden Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7817, 'longitude': -117.9766, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92842', 'place_name': 'Garden Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7783, 'longitude': -117.9456, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92843', 'place_name': 'Garden Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7671, 'longitude': -117.929, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92844', 'place_name': 'Garden Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7661, 'longitude': -117.9738, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92845', 'place_name': 'Garden Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7787, 'longitude': -118.0267, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92846', 'place_name': 'Garden Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.788, 'longitude': -118.0325, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92850', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8442, 'longitude': -117.9555, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92856', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7841, 'longitude': -117.8435, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92857', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8317, 'longitude': -117.8491, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92859', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8027, 'longitude': -117.7867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92861', 'place_name': 'Villa Park', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8205, 'longitude': -117.8104, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92862', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7915, 'longitude': -117.714, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92863', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8153, 'longitude': -117.8273, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92864', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8143, 'longitude': -117.8308, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92865', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8263, 'longitude': -117.8511, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92866', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7877, 'longitude': -117.8423, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92867', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.811, 'longitude': -117.8493, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92868', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7875, 'longitude': -117.8776, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92869', 'place_name': 'Orange', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.7868, 'longitude': -117.7934, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92870', 'place_name': 'Placentia', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8744, 'longitude': -117.8543, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92871', 'place_name': 'Placentia', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8829, 'longitude': -117.8557, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92885', 'place_name': 'Yorba Linda', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8911, 'longitude': -117.8222, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92886', 'place_name': 'Yorba Linda', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.9058, 'longitude': -117.7865, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92887', 'place_name': 'Yorba Linda', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8841, 'longitude': -117.7304, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92899', 'place_name': 'Anaheim', 'state': 'California', 'state_ab': 'CA', 'county': 'Orange', 'locality_code': '59', 'latitude': 33.8373, 'longitude': -117.8712, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95602', 'place_name': 'Auburn', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.9829, 'longitude': -121.0944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95603', 'place_name': 'Auburn', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.9115, 'longitude': -121.08, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95604', 'place_name': 'Auburn', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.9029, 'longitude': -121.067, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95631', 'place_name': 'Foresthill', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.0682, 'longitude': -120.7224, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95648', 'place_name': 'Lincoln', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.8942, 'longitude': -121.2908, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95650', 'place_name': 'Loomis', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.8071, 'longitude': -121.1698, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95658', 'place_name': 'Newcastle', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.8763, 'longitude': -121.143, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95661', 'place_name': 'Roseville', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.7346, 'longitude': -121.234, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95663', 'place_name': 'Penryn', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.8567, 'longitude': -121.1791, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95677', 'place_name': 'Rocklin', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.7877, 'longitude': -121.2366, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95678', 'place_name': 'Roseville', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.7609, 'longitude': -121.2867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95681', 'place_name': 'Sheridan', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.9953, 'longitude': -121.368, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95701', 'place_name': 'Alta', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.2441, 'longitude': -120.7531, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95703', 'place_name': 'Applegate', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.0007, 'longitude': -120.9924, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95713', 'place_name': 'Colfax', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.0783, 'longitude': -120.9549, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95714', 'place_name': 'Dutch Flat', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.1978, 'longitude': -120.8262, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95715', 'place_name': 'Emigrant Gap', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.2968, 'longitude': -120.6727, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95717', 'place_name': 'Gold Run', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.171, 'longitude': -120.8601, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95722', 'place_name': 'Meadow Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.0031, 'longitude': -121.0292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95736', 'place_name': 'Weimar', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.0375, 'longitude': -120.9713, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95746', 'place_name': 'Granite Bay', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.7435, 'longitude': -121.1897, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95747', 'place_name': 'Roseville', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.7703, 'longitude': -121.3372, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95765', 'place_name': 'Rocklin', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 38.8136, 'longitude': -121.2677, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96140', 'place_name': 'Carnelian Bay', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.2319, 'longitude': -120.0753, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96141', 'place_name': 'Homewood', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.0786, 'longitude': -120.1734, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96143', 'place_name': 'Kings Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.2401, 'longitude': -120.0233, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96145', 'place_name': 'Tahoe City', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.1806, 'longitude': -120.1445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96146', 'place_name': 'Olympic Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.1752, 'longitude': -120.1954, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96148', 'place_name': 'Tahoe Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'Placer', 'locality_code': '61', 'latitude': 39.2448, 'longitude': -120.0521, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95915', 'place_name': 'Belden', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 40.006, 'longitude': -121.2491, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95923', 'place_name': 'Canyon Dam', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 39.5645, 'longitude': -121.5751, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '95934', 'place_name': 'Crescent Mills', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 40.0673, 'longitude': -120.9248, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95947', 'place_name': 'Greenville', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 40.1699, 'longitude': -120.9014, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95956', 'place_name': 'Meadow Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 39.9296, 'longitude': -121.0608, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95971', 'place_name': 'Quincy', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 39.9284, 'longitude': -120.9698, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95980', 'place_name': 'Storrie', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 39.9175, 'longitude': -121.3222, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95983', 'place_name': 'Taylorsville', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 40.0357, 'longitude': -120.7353, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95984', 'place_name': 'Twain', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 40.0509, 'longitude': -121.1268, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96020', 'place_name': 'Chester', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 40.2975, 'longitude': -121.2273, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96103', 'place_name': 'Blairsden Graeagle', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 40.1919, 'longitude': -120.1746, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '96105', 'place_name': 'Chilcoot', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 39.7977, 'longitude': -120.1396, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96106', 'place_name': 'Clio', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 39.7546, 'longitude': -120.5951, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96122', 'place_name': 'Portola', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 39.8105, 'longitude': -120.4691, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96129', 'place_name': 'Beckwourth', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 39.7721, 'longitude': -120.4051, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '96135', 'place_name': 'Vinton', 'state': 'California', 'state_ab': 'CA', 'county': 'Plumas', 'locality_code': '63', 'latitude': 39.8043, 'longitude': -120.1783, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91752', 'place_name': 'Mira Loma', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9938, 'longitude': -117.5236, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92201', 'place_name': 'Indio', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7207, 'longitude': -116.2168, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92202', 'place_name': 'Indio', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7529, 'longitude': -116.0556, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92203', 'place_name': 'Indio', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7532, 'longitude': -116.2676, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92210', 'place_name': 'Indian Wells', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7163, 'longitude': -116.3381, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92211', 'place_name': 'Palm Desert', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7644, 'longitude': -116.3398, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92220', 'place_name': 'Banning', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9282, 'longitude': -116.8899, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92223', 'place_name': 'Beaumont', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9504, 'longitude': -116.9701, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '92225', 'place_name': 'Blythe', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.6103, 'longitude': -114.5963, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92226', 'place_name': 'Blythe', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.5987, 'longitude': -114.6525, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92230', 'place_name': 'Cabazon', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9086, 'longitude': -116.7739, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92234', 'place_name': 'Cathedral City', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8098, 'longitude': -116.4665, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92235', 'place_name': 'Cathedral City', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7797, 'longitude': -116.4653, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92236', 'place_name': 'Coachella', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.675, 'longitude': -116.1772, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92239', 'place_name': 'Desert Center', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.809, 'longitude': -115.3666, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92240', 'place_name': 'Desert Hot Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9531, 'longitude': -116.5219, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92241', 'place_name': 'Desert Hot Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8763, 'longitude': -116.354, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92247', 'place_name': 'La Quinta', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.6736, 'longitude': -116.2951, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92253', 'place_name': 'La Quinta', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.6685, 'longitude': -116.3081, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92254', 'place_name': 'Mecca', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.545, 'longitude': -116.0187, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92255', 'place_name': 'Palm Desert', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7225, 'longitude': -116.377, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92258', 'place_name': 'North Palm Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9228, 'longitude': -116.5431, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92260', 'place_name': 'Palm Desert', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7225, 'longitude': -116.377, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92261', 'place_name': 'Palm Desert', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.6604, 'longitude': -116.4082, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92262', 'place_name': 'Palm Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8414, 'longitude': -116.5347, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92263', 'place_name': 'Palm Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7611, 'longitude': -116.5359, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92264', 'place_name': 'Palm Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8018, 'longitude': -116.517, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92270', 'place_name': 'Rancho Mirage', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7643, 'longitude': -116.4225, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92274', 'place_name': 'Thermal', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.5578, 'longitude': -116.1572, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92276', 'place_name': 'Thousand Palms', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8082, 'longitude': -116.3713, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92282', 'place_name': 'Whitewater', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.989, 'longitude': -116.6566, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92320', 'place_name': 'Calimesa', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9946, 'longitude': -117.043, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92501', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9924, 'longitude': -117.3694, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92502', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9533, 'longitude': -117.3962, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92503', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9208, 'longitude': -117.4589, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92504', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9315, 'longitude': -117.4119, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92505', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9228, 'longitude': -117.4867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92506', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9455, 'longitude': -117.3757, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92507', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9761, 'longitude': -117.3389, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92508', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8897, 'longitude': -117.3043, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92509', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 34.0033, 'longitude': -117.445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92513', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9533, 'longitude': -117.3962, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92514', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9533, 'longitude': -117.3962, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92515', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9533, 'longitude': -117.3962, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92516', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9533, 'longitude': -117.3962, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92517', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9533, 'longitude': -117.3962, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92518', 'place_name': 'March Air Reserve Base', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9533, 'longitude': -117.3962, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '92519', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9533, 'longitude': -117.3962, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92521', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9533, 'longitude': -117.3962, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92522', 'place_name': 'Riverside', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9533, 'longitude': -117.3962, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92530', 'place_name': 'Lake Elsinore', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.6598, 'longitude': -117.3485, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92531', 'place_name': 'Lake Elsinore', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.6681, 'longitude': -117.3273, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92532', 'place_name': 'Lake Elsinore', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.6927, 'longitude': -117.303, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92536', 'place_name': 'Aguanga', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.4473, 'longitude': -116.7997, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92539', 'place_name': 'Anza', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.5688, 'longitude': -116.7135, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92543', 'place_name': 'Hemet', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7416, 'longitude': -116.973, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92544', 'place_name': 'Hemet', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.739, 'longitude': -116.9243, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92545', 'place_name': 'Hemet', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7399, 'longitude': -117.0151, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92546', 'place_name': 'Hemet', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7476, 'longitude': -116.9731, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92548', 'place_name': 'Homeland', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7453, 'longitude': -117.1118, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92549', 'place_name': 'Idyllwild', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7304, 'longitude': -116.7107, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92551', 'place_name': 'Moreno Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8814, 'longitude': -117.2261, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92552', 'place_name': 'Moreno Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9375, 'longitude': -117.2306, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92553', 'place_name': 'Moreno Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9157, 'longitude': -117.2351, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92554', 'place_name': 'Moreno Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9375, 'longitude': -117.2306, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92555', 'place_name': 'Moreno Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9377, 'longitude': -117.1851, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92556', 'place_name': 'Moreno Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9375, 'longitude': -117.2306, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92557', 'place_name': 'Moreno Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9553, 'longitude': -117.2457, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92561', 'place_name': 'Mountain Center', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7042, 'longitude': -116.7259, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92562', 'place_name': 'Murrieta', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.5631, 'longitude': -117.2738, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92563', 'place_name': 'Murrieta', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.569, 'longitude': -117.1783, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92564', 'place_name': 'Murrieta', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.5539, 'longitude': -117.2139, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92567', 'place_name': 'Nuevo', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8123, 'longitude': -117.1048, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92570', 'place_name': 'Perris', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7852, 'longitude': -117.3166, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92571', 'place_name': 'Perris', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.811, 'longitude': -117.218, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92572', 'place_name': 'Perris', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7825, 'longitude': -117.2286, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92581', 'place_name': 'San Jacinto', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7839, 'longitude': -116.9586, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92582', 'place_name': 'San Jacinto', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7883, 'longitude': -116.9819, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92583', 'place_name': 'San Jacinto', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7967, 'longitude': -116.9324, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92584', 'place_name': 'Menifee', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.6647, 'longitude': -117.1743, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92585', 'place_name': 'Sun City', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7467, 'longitude': -117.1721, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92586', 'place_name': 'Sun City', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7044, 'longitude': -117.1969, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92587', 'place_name': 'Quail Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.707, 'longitude': -117.245, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92589', 'place_name': 'Temecula', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.4936, 'longitude': -117.1484, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92590', 'place_name': 'Temecula', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.4903, 'longitude': -117.1824, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92591', 'place_name': 'Temecula', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.5217, 'longitude': -117.1286, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92592', 'place_name': 'Temecula', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.4983, 'longitude': -117.0958, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92593', 'place_name': 'Temecula', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.4936, 'longitude': -117.1484, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92595', 'place_name': 'Wildomar', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.6021, 'longitude': -117.264, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92596', 'place_name': 'Winchester', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.6243, 'longitude': -117.0885, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92599', 'place_name': 'Perris', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7825, 'longitude': -117.2286, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92860', 'place_name': 'Norco', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9247, 'longitude': -117.5517, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92877', 'place_name': 'Corona', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8753, 'longitude': -117.5664, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92878', 'place_name': 'Corona', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8753, 'longitude': -117.5664, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92879', 'place_name': 'Corona', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8797, 'longitude': -117.5354, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92880', 'place_name': 'Corona', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.9208, 'longitude': -117.6096, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92881', 'place_name': 'Corona', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8241, 'longitude': -117.5198, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92882', 'place_name': 'Corona', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.8419, 'longitude': -117.6043, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92883', 'place_name': 'Corona', 'state': 'California', 'state_ab': 'CA', 'county': 'Riverside', 'locality_code': '65', 'latitude': 33.7541, 'longitude': -117.474, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94203', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94204', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94205', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94206', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94207', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94208', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94209', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94211', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94229', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94230', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94232', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94234', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94235', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94236', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94237', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94239', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94240', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94244', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94245', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94247', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94248', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94249', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94250', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94252', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94254', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94256', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94257', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94258', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94259', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94261', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94262', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94263', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94267', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94268', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94269', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94271', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94273', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94274', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94277', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94278', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94279', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94280', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94282', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94283', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94284', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94285', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94286', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94287', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94288', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94289', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94290', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94291', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94293', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94294', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94295', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94296', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94297', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94298', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94299', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95608', 'place_name': 'Carmichael', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6284, 'longitude': -121.3287, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95609', 'place_name': 'Carmichael', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6257, 'longitude': -121.3272, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95610', 'place_name': 'Citrus Heights', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6946, 'longitude': -121.2692, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95611', 'place_name': 'Citrus Heights', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.7072, 'longitude': -121.28, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95615', 'place_name': 'Courtland', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.3137, 'longitude': -121.563, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95621', 'place_name': 'Citrus Heights', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6952, 'longitude': -121.3075, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95624', 'place_name': 'Elk Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.4232, 'longitude': -121.3599, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95626', 'place_name': 'Elverta', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.7233, 'longitude': -121.4497, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95628', 'place_name': 'Fair Oaks', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6554, 'longitude': -121.2611, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95630', 'place_name': 'Folsom', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6709, 'longitude': -121.1529, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95632', 'place_name': 'Galt', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.2691, 'longitude': -121.3, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95638', 'place_name': 'Herald', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.3119, 'longitude': -121.1729, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95639', 'place_name': 'Hood', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.3702, 'longitude': -121.5143, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95641', 'place_name': 'Isleton', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.157, 'longitude': -121.6066, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95652', 'place_name': 'Mcclellan', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6621, 'longitude': -121.3955, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95655', 'place_name': 'Mather', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5579, 'longitude': -121.291, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95660', 'place_name': 'North Highlands', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6707, 'longitude': -121.3781, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95662', 'place_name': 'Orangevale', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6845, 'longitude': -121.2256, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95670', 'place_name': 'Rancho Cordova', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6072, 'longitude': -121.2761, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95671', 'place_name': 'Represa', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.7065, 'longitude': -121.1694, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '95673', 'place_name': 'Rio Linda', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6895, 'longitude': -121.4479, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95680', 'place_name': 'Ryde', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.2386, 'longitude': -121.5594, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95683', 'place_name': 'Sloughhouse', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5143, 'longitude': -121.0964, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95690', 'place_name': 'Walnut Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.2396, 'longitude': -121.5443, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95693', 'place_name': 'Wilton', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.3983, 'longitude': -121.2303, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95741', 'place_name': 'Rancho Cordova', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5891, 'longitude': -121.3016, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95742', 'place_name': 'Rancho Cordova', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5981, 'longitude': -121.2153, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95757', 'place_name': 'Elk Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.4081, 'longitude': -121.4294, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95758', 'place_name': 'Elk Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.4243, 'longitude': -121.437, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95759', 'place_name': 'Elk Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.407, 'longitude': -121.3752, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95763', 'place_name': 'Folsom', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.678, 'longitude': -121.175, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95811', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5762, 'longitude': -121.488, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95812', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5822, 'longitude': -121.4943, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95813', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6026, 'longitude': -121.4475, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95814', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5804, 'longitude': -121.4922, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95815', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6093, 'longitude': -121.4443, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95816', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5728, 'longitude': -121.4675, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95817', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5498, 'longitude': -121.4583, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95818', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5568, 'longitude': -121.4929, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95819', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5683, 'longitude': -121.4366, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95820', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5347, 'longitude': -121.4451, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95821', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6239, 'longitude': -121.3837, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95822', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5091, 'longitude': -121.4935, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95823', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.4797, 'longitude': -121.4438, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95824', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5178, 'longitude': -121.4419, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95825', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5892, 'longitude': -121.4057, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95826', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5539, 'longitude': -121.3693, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95827', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5662, 'longitude': -121.3286, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95828', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.4826, 'longitude': -121.4006, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95829', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.4689, 'longitude': -121.344, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95830', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.4896, 'longitude': -121.2772, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95831', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.4962, 'longitude': -121.5297, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95832', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.4695, 'longitude': -121.4883, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95833', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6157, 'longitude': -121.5053, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95834', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6383, 'longitude': -121.5072, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95835', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6626, 'longitude': -121.4834, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95836', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.7198, 'longitude': -121.5343, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95837', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6817, 'longitude': -121.603, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95838', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6406, 'longitude': -121.444, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95840', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4933, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95841', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6627, 'longitude': -121.3406, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95842', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6865, 'longitude': -121.3494, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95843', 'place_name': 'Antelope', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.7159, 'longitude': -121.3648, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95851', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6026, 'longitude': -121.4475, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95852', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6026, 'longitude': -121.4475, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95853', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6026, 'longitude': -121.4475, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95860', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.6105, 'longitude': -121.3799, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95864', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5878, 'longitude': -121.3769, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95865', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.596, 'longitude': -121.3978, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95866', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.596, 'longitude': -121.3978, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95867', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4933, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95894', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5816, 'longitude': -121.4933, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95899', 'place_name': 'Sacramento', 'state': 'California', 'state_ab': 'CA', 'county': 'Sacramento', 'locality_code': '67', 'latitude': 38.5383, 'longitude': -121.5549, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95023', 'place_name': 'Hollister', 'state': 'California', 'state_ab': 'CA', 'county': 'San Benito', 'locality_code': '69', 'latitude': 36.8337, 'longitude': -121.3439, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95024', 'place_name': 'Hollister', 'state': 'California', 'state_ab': 'CA', 'county': 'San Benito', 'locality_code': '69', 'latitude': 36.8586, 'longitude': -121.3982, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95043', 'place_name': 'Paicines', 'state': 'California', 'state_ab': 'CA', 'county': 'San Benito', 'locality_code': '69', 'latitude': 36.4985, 'longitude': -120.9744, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95045', 'place_name': 'San Juan Bautista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Benito', 'locality_code': '69', 'latitude': 36.8463, 'longitude': -121.5346, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95075', 'place_name': 'Tres Pinos', 'state': 'California', 'state_ab': 'CA', 'county': 'San Benito', 'locality_code': '69', 'latitude': 36.767, 'longitude': -121.3017, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91701', 'place_name': 'Rancho Cucamonga', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1376, 'longitude': -117.5999, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91708', 'place_name': 'Chino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 33.954, 'longitude': -117.6404, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91709', 'place_name': 'Chino Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 33.9797, 'longitude': -117.7308, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91710', 'place_name': 'Chino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0125, 'longitude': -117.6844, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91729', 'place_name': 'Rancho Cucamonga', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1064, 'longitude': -117.5931, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91730', 'place_name': 'Rancho Cucamonga', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.107, 'longitude': -117.5941, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91737', 'place_name': 'Rancho Cucamonga', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1467, 'longitude': -117.5803, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91739', 'place_name': 'Rancho Cucamonga', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1705, 'longitude': -117.5182, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91743', 'place_name': 'Guasti', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.065, 'longitude': -117.5864, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91758', 'place_name': 'Ontario', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0633, 'longitude': -117.6509, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91761', 'place_name': 'Ontario', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0316, 'longitude': -117.6187, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91762', 'place_name': 'Ontario', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0584, 'longitude': -117.6665, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91763', 'place_name': 'Montclair', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0733, 'longitude': -117.6987, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91764', 'place_name': 'Ontario', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0763, 'longitude': -117.6254, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91784', 'place_name': 'Upland', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.141, 'longitude': -117.6581, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91785', 'place_name': 'Upland', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1144, 'longitude': -117.6583, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91786', 'place_name': 'Upland', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1144, 'longitude': -117.6583, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92242', 'place_name': 'Earp', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1652, 'longitude': -114.3197, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '92248', 'place_name': 'La Quinta', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 33.6736, 'longitude': -116.2951, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92252', 'place_name': 'Joshua Tree', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1502, 'longitude': -116.3038, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92256', 'place_name': 'Morongo Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0606, 'longitude': -116.5656, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92267', 'place_name': 'Parker Dam', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2872, 'longitude': -114.143, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92268', 'place_name': 'Pioneertown', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1887, 'longitude': -116.5048, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92277', 'place_name': 'Twentynine Palms', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1455, 'longitude': -116.0601, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92278', 'place_name': 'Twentynine Palms', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.238, 'longitude': -116.0604, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92280', 'place_name': 'Vidal', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1561, 'longitude': -114.5656, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92284', 'place_name': 'Yucca Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1559, 'longitude': -116.4313, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92285', 'place_name': 'Landers', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.3103, 'longitude': -116.5241, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92286', 'place_name': 'Yucca Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1803, 'longitude': -116.35, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92301', 'place_name': 'Adelanto', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.5841, 'longitude': -117.4242, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92304', 'place_name': 'Amboy', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.5578, 'longitude': -115.7444, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92305', 'place_name': 'Angelus Oaks', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1531, 'longitude': -116.9485, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92307', 'place_name': 'Apple Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.5291, 'longitude': -117.2132, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92308', 'place_name': 'Apple Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.4698, 'longitude': -117.1927, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92309', 'place_name': 'Baker', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 35.3606, 'longitude': -116.0638, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92310', 'place_name': 'Fort Irwin', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 35.2625, 'longitude': -116.6966, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92311', 'place_name': 'Barstow', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.8914, 'longitude': -117.0387, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92312', 'place_name': 'Barstow', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.8986, 'longitude': -117.0228, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92313', 'place_name': 'Grand Terrace', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.031, 'longitude': -117.3129, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92314', 'place_name': 'Big Bear City', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.261, 'longitude': -116.8131, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92315', 'place_name': 'Big Bear Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.235, 'longitude': -116.9053, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92316', 'place_name': 'Bloomington', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0662, 'longitude': -117.3993, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92317', 'place_name': 'Blue Jay', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2112, 'longitude': -117.0796, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92318', 'place_name': 'Bryn Mawr', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0483, 'longitude': -117.2309, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92321', 'place_name': 'Cedar Glen', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2545, 'longitude': -117.1533, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92322', 'place_name': 'Cedarpines Park', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2544, 'longitude': -117.3265, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92323', 'place_name': 'Cima', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 35.2378, 'longitude': -115.4992, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '92324', 'place_name': 'Colton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0315, 'longitude': -117.2874, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92325', 'place_name': 'Crestline', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2433, 'longitude': -117.2811, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92327', 'place_name': 'Daggett', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.8668, 'longitude': -116.8876, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92329', 'place_name': 'Phelan', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.4261, 'longitude': -117.5723, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92332', 'place_name': 'Essex', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.5881, 'longitude': -115.5771, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92333', 'place_name': 'Fawnskin', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2583, 'longitude': -116.9515, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92334', 'place_name': 'Fontana', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0922, 'longitude': -117.435, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92335', 'place_name': 'Fontana', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0794, 'longitude': -117.4551, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92336', 'place_name': 'Fontana', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1173, 'longitude': -117.4378, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92337', 'place_name': 'Fontana', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0498, 'longitude': -117.4706, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92338', 'place_name': 'Ludlow', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.7211, 'longitude': -116.16, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92339', 'place_name': 'Forest Falls', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0937, 'longitude': -116.9362, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92340', 'place_name': 'Hesperia', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.4264, 'longitude': -117.3009, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92341', 'place_name': 'Green Valley Lake', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2348, 'longitude': -117.066, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92342', 'place_name': 'Helendale', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.7499, 'longitude': -117.3367, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92344', 'place_name': 'Hesperia', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.4239, 'longitude': -117.4075, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92345', 'place_name': 'Hesperia', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.4222, 'longitude': -117.3025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92346', 'place_name': 'Highland', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1283, 'longitude': -117.2087, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92347', 'place_name': 'Hinkley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.9279, 'longitude': -117.1809, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92350', 'place_name': 'Loma Linda', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0483, 'longitude': -117.2612, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92352', 'place_name': 'Lake Arrowhead', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2606, 'longitude': -117.2016, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92354', 'place_name': 'Loma Linda', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0528, 'longitude': -117.2513, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92356', 'place_name': 'Lucerne Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.447, 'longitude': -116.9189, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92357', 'place_name': 'Loma Linda', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0483, 'longitude': -117.2612, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92358', 'place_name': 'Lytle Creek', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2558, 'longitude': -117.5186, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92359', 'place_name': 'Mentone', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0774, 'longitude': -117.1126, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92363', 'place_name': 'Needles', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.7824, 'longitude': -114.5871, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92364', 'place_name': 'Nipton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 35.4667, 'longitude': -115.2722, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92365', 'place_name': 'Newberry Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.885, 'longitude': -116.7464, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92366', 'place_name': 'Mountain Pass', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 35.4703, 'longitude': -115.545, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92368', 'place_name': 'Oro Grande', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.6178, 'longitude': -117.3327, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92369', 'place_name': 'Patton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1358, 'longitude': -117.2239, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92371', 'place_name': 'Phelan', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.4449, 'longitude': -117.5196, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92372', 'place_name': 'Pinon Hills', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.4429, 'longitude': -117.6403, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92373', 'place_name': 'Redlands', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0397, 'longitude': -117.1804, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92374', 'place_name': 'Redlands', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.065, 'longitude': -117.1672, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92375', 'place_name': 'Redlands', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0556, 'longitude': -117.1825, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92376', 'place_name': 'Rialto', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1132, 'longitude': -117.3771, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92377', 'place_name': 'Rialto', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1561, 'longitude': -117.4042, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92378', 'place_name': 'Rimforest', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2297, 'longitude': -117.225, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92382', 'place_name': 'Running Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2102, 'longitude': -117.1109, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92385', 'place_name': 'Skyforest', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2353, 'longitude': -117.1792, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92386', 'place_name': 'Sugarloaf', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2372, 'longitude': -116.8277, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92391', 'place_name': 'Twin Peaks', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2379, 'longitude': -117.2348, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92392', 'place_name': 'Victorville', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.4802, 'longitude': -117.4082, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92393', 'place_name': 'Victorville', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.5361, 'longitude': -117.2912, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92394', 'place_name': 'Victorville', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.5563, 'longitude': -117.3528, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92395', 'place_name': 'Victorville', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.5016, 'longitude': -117.2944, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92397', 'place_name': 'Wrightwood', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.3628, 'longitude': -117.6249, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92398', 'place_name': 'Yermo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.905, 'longitude': -116.8203, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92399', 'place_name': 'Yucaipa', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0282, 'longitude': -117.0489, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92401', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1105, 'longitude': -117.2898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92402', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1083, 'longitude': -117.2898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92403', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1083, 'longitude': -117.2898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92404', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1426, 'longitude': -117.2606, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92405', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1446, 'longitude': -117.3013, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92406', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1083, 'longitude': -117.2898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92407', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.2166, 'longitude': -117.3908, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92408', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.0831, 'longitude': -117.2711, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92410', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1069, 'longitude': -117.2975, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92411', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1214, 'longitude': -117.3172, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92413', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1083, 'longitude': -117.2898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92415', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1083, 'longitude': -117.2898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92418', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1083, 'longitude': -117.2898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92423', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1083, 'longitude': -117.2898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92427', 'place_name': 'San Bernardino', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 34.1083, 'longitude': -117.2898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93558', 'place_name': 'Red Mountain', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 35.3479, 'longitude': -117.6214, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93562', 'place_name': 'Trona', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 35.7481, 'longitude': -117.3808, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93592', 'place_name': 'Trona', 'state': 'California', 'state_ab': 'CA', 'county': 'San Bernardino', 'locality_code': '71', 'latitude': 35.7627, 'longitude': -117.3728, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91901', 'place_name': 'Alpine', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8282, 'longitude': -116.7543, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91902', 'place_name': 'Bonita', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6671, 'longitude': -117.0221, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91903', 'place_name': 'Alpine', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8351, 'longitude': -116.7664, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91905', 'place_name': 'Boulevard', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6719, 'longitude': -116.32, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91906', 'place_name': 'Campo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6605, 'longitude': -116.4905, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91908', 'place_name': 'Bonita', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6578, 'longitude': -117.03, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91909', 'place_name': 'Chula Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6401, 'longitude': -117.0842, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91910', 'place_name': 'Chula Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6371, 'longitude': -117.0676, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91911', 'place_name': 'Chula Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6084, 'longitude': -117.0565, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91912', 'place_name': 'Chula Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6401, 'longitude': -117.0842, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91913', 'place_name': 'Chula Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6513, 'longitude': -116.9852, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91914', 'place_name': 'Chula Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6587, 'longitude': -116.9652, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91915', 'place_name': 'Chula Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6315, 'longitude': -116.9408, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91916', 'place_name': 'Descanso', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.873, 'longitude': -116.6027, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91917', 'place_name': 'Dulzura', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6152, 'longitude': -116.7285, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91921', 'place_name': 'Chula Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6401, 'longitude': -117.0842, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91931', 'place_name': 'Guatay', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8497, 'longitude': -116.5583, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91932', 'place_name': 'Imperial Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.5783, 'longitude': -117.1148, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91933', 'place_name': 'Imperial Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.5839, 'longitude': -117.1131, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91934', 'place_name': 'Jacumba', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6249, 'longitude': -116.1952, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91935', 'place_name': 'Jamul', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7163, 'longitude': -116.8323, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91941', 'place_name': 'La Mesa', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7604, 'longitude': -117.0115, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91942', 'place_name': 'La Mesa', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7835, 'longitude': -117.0189, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91943', 'place_name': 'La Mesa', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7678, 'longitude': -117.0231, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91944', 'place_name': 'La Mesa', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7678, 'longitude': -117.0231, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91945', 'place_name': 'Lemon Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7332, 'longitude': -117.0326, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91946', 'place_name': 'Lemon Grove', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7426, 'longitude': -117.0314, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91948', 'place_name': 'Mount Laguna', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8676, 'longitude': -116.4206, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91950', 'place_name': 'National City', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6749, 'longitude': -117.0897, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91951', 'place_name': 'National City', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6781, 'longitude': -117.0992, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91962', 'place_name': 'Pine Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.835, 'longitude': -116.5127, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91963', 'place_name': 'Potrero', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6205, 'longitude': -116.6037, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91976', 'place_name': 'Spring Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7448, 'longitude': -116.9989, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91977', 'place_name': 'Spring Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.724, 'longitude': -116.9976, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91978', 'place_name': 'Spring Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7329, 'longitude': -116.9596, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91979', 'place_name': 'Spring Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7448, 'longitude': -116.9989, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91980', 'place_name': 'Tecate', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.5889, 'longitude': -116.6192, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '91987', 'place_name': 'Tecate', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.5773, 'longitude': -116.6275, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92003', 'place_name': 'Bonsall', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.294, 'longitude': -117.1897, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92004', 'place_name': 'Borrego Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.2386, 'longitude': -116.3514, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92007', 'place_name': 'Cardiff By The Sea', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.023, 'longitude': -117.2745, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92008', 'place_name': 'Carlsbad', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1602, 'longitude': -117.325, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92009', 'place_name': 'Carlsbad', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.0954, 'longitude': -117.2619, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92010', 'place_name': 'Carlsbad', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1639, 'longitude': -117.3009, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92011', 'place_name': 'Carlsbad', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1072, 'longitude': -117.2943, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92013', 'place_name': 'Carlsbad', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1581, 'longitude': -117.3506, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92014', 'place_name': 'Del Mar', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.9665, 'longitude': -117.249, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92018', 'place_name': 'Carlsbad', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1581, 'longitude': -117.3506, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92019', 'place_name': 'El Cajon', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7777, 'longitude': -116.9191, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92020', 'place_name': 'El Cajon', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7928, 'longitude': -116.9665, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92021', 'place_name': 'El Cajon', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8178, 'longitude': -116.9223, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92022', 'place_name': 'El Cajon', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7948, 'longitude': -116.9625, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92023', 'place_name': 'Encinitas', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.036, 'longitude': -117.292, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92024', 'place_name': 'Encinitas', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.0535, 'longitude': -117.2689, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92025', 'place_name': 'Escondido', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1101, 'longitude': -117.07, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92026', 'place_name': 'Escondido', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1605, 'longitude': -117.0978, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92027', 'place_name': 'Escondido', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1388, 'longitude': -117.052, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92028', 'place_name': 'Fallbrook', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.369, 'longitude': -117.229, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92029', 'place_name': 'Escondido', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.0895, 'longitude': -117.1128, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92030', 'place_name': 'Escondido', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1192, 'longitude': -117.0864, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92033', 'place_name': 'Escondido', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1192, 'longitude': -117.0864, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92036', 'place_name': 'Julian', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.0534, 'longitude': -116.5658, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92037', 'place_name': 'La Jolla', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8455, 'longitude': -117.2521, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92038', 'place_name': 'La Jolla', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8473, 'longitude': -117.2742, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92039', 'place_name': 'La Jolla', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8473, 'longitude': -117.2742, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92040', 'place_name': 'Lakeside', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8562, 'longitude': -116.9201, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92046', 'place_name': 'Escondido', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1192, 'longitude': -117.0864, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92049', 'place_name': 'Oceanside', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1959, 'longitude': -117.3795, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92051', 'place_name': 'Oceanside', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1959, 'longitude': -117.3795, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92052', 'place_name': 'Oceanside', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1959, 'longitude': -117.3795, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92054', 'place_name': 'Oceanside', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.2072, 'longitude': -117.3573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92055', 'place_name': 'Camp Pendleton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.2433, 'longitude': -117.3768, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '92056', 'place_name': 'Oceanside', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1968, 'longitude': -117.2831, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92057', 'place_name': 'Oceanside', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.2407, 'longitude': -117.3025, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92058', 'place_name': 'Oceanside', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1959, 'longitude': -117.3795, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92059', 'place_name': 'Pala', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.3777, 'longitude': -117.0717, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92060', 'place_name': 'Palomar Mountain', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.3228, 'longitude': -116.8786, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92061', 'place_name': 'Pauma Valley', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.3063, 'longitude': -116.9596, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92064', 'place_name': 'Poway', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.9756, 'longitude': -117.0402, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92065', 'place_name': 'Ramona', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.0293, 'longitude': -116.8535, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92066', 'place_name': 'Ranchita', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.21, 'longitude': -116.5167, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92067', 'place_name': 'Rancho Santa Fe', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.005, 'longitude': -117.2157, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92068', 'place_name': 'San Luis Rey', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.232, 'longitude': -117.3236, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92069', 'place_name': 'San Marcos', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1444, 'longitude': -117.1697, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92070', 'place_name': 'Santa Ysabel', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1476, 'longitude': -116.6963, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92071', 'place_name': 'Santee', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8486, 'longitude': -116.9862, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92072', 'place_name': 'Santee', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8384, 'longitude': -116.9739, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92074', 'place_name': 'Poway', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.9628, 'longitude': -117.0359, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92075', 'place_name': 'Solana Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.9937, 'longitude': -117.2598, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92078', 'place_name': 'San Marcos', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1193, 'longitude': -117.185, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92079', 'place_name': 'San Marcos', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1434, 'longitude': -117.1661, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92081', 'place_name': 'Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1644, 'longitude': -117.2403, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92082', 'place_name': 'Valley Center', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.249, 'longitude': -117.0122, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92083', 'place_name': 'Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1978, 'longitude': -117.2482, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92084', 'place_name': 'Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.2131, 'longitude': -117.2243, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92085', 'place_name': 'Vista', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.2, 'longitude': -117.2425, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92086', 'place_name': 'Warner Springs', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.3096, 'longitude': -116.6527, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92088', 'place_name': 'Fallbrook', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.3764, 'longitude': -117.2511, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92091', 'place_name': 'Rancho Santa Fe', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.9623, 'longitude': -117.0462, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92092', 'place_name': 'La Jolla', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8473, 'longitude': -117.2742, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92093', 'place_name': 'La Jolla', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8473, 'longitude': -117.2742, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92096', 'place_name': 'San Marcos', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.1434, 'longitude': -117.1661, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92101', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7185, 'longitude': -117.1593, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92102', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7139, 'longitude': -117.1219, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92103', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7466, 'longitude': -117.1636, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92104', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7454, 'longitude': -117.1272, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92105', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7423, 'longitude': -117.0947, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92106', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7272, 'longitude': -117.2268, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92107', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7425, 'longitude': -117.2433, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92108', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7783, 'longitude': -117.1335, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92109', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7969, 'longitude': -117.2405, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92110', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7635, 'longitude': -117.2028, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92111', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7972, 'longitude': -117.1708, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92112', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92113', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.697, 'longitude': -117.1153, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92114', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7059, 'longitude': -117.0524, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92115', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7607, 'longitude': -117.0721, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92116', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7624, 'longitude': -117.1242, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92117', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8239, 'longitude': -117.1965, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92118', 'place_name': 'Coronado', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6807, 'longitude': -117.1698, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92119', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8036, 'longitude': -117.0261, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92120', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7958, 'longitude': -117.0707, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92121', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8919, 'longitude': -117.2035, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92122', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8577, 'longitude': -117.2115, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92123', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7973, 'longitude': -117.1392, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92124', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8201, 'longitude': -117.0986, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92126', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.9161, 'longitude': -117.1402, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92127', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.0279, 'longitude': -117.0856, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92128', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.0067, 'longitude': -117.069, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92129', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.9652, 'longitude': -117.1213, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92130', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.9555, 'longitude': -117.2252, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92131', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.9123, 'longitude': -117.0898, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92132', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6437, 'longitude': -117.1384, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92134', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7242, 'longitude': -117.1466, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92135', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92136', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6834, 'longitude': -117.1219, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92137', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8538, 'longitude': -117.1197, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92138', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92139', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6806, 'longitude': -117.0474, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92140', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7434, 'longitude': -117.2004, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92142', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92143', 'place_name': 'San Ysidro', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 33.2553, 'longitude': -116.5664, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92145', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8891, 'longitude': -117.1005, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92147', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92149', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92150', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92152', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92153', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92154', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.5753, 'longitude': -117.0707, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92155', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6716, 'longitude': -117.1657, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92158', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92159', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92160', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92161', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.8718, 'longitude': -117.2291, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92163', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92165', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92166', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92167', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92168', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92169', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92170', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92171', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92172', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92173', 'place_name': 'San Ysidro', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.5626, 'longitude': -117.043, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92174', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92175', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92176', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92177', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92178', 'place_name': 'Coronado', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.6859, 'longitude': -117.1831, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92179', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92182', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7751, 'longitude': -117.0762, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92186', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92187', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92190', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92191', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92192', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92193', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92195', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92196', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92197', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92198', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7153, 'longitude': -117.1573, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '92199', 'place_name': 'San Diego', 'state': 'California', 'state_ab': 'CA', 'county': 'San Diego', 'locality_code': '73', 'latitude': 32.7516, 'longitude': -117.1918, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94102', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7813, 'longitude': -122.4167, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94103', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7725, 'longitude': -122.4147, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94104', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7915, 'longitude': -122.4018, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94105', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7864, 'longitude': -122.3892, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94107', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7621, 'longitude': -122.3971, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94108', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7929, 'longitude': -122.4079, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94109', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7917, 'longitude': -122.4186, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94110', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7509, 'longitude': -122.4153, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94111', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7974, 'longitude': -122.4001, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94112', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7195, 'longitude': -122.4411, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94114', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7587, 'longitude': -122.433, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94115', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7856, 'longitude': -122.4358, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94116', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7441, 'longitude': -122.4863, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94117', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7712, 'longitude': -122.4413, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94118', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7812, 'longitude': -122.4614, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94119', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94120', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94121', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7786, 'longitude': -122.4892, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94122', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7593, 'longitude': -122.4836, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94123', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7999, 'longitude': -122.4342, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94124', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7309, 'longitude': -122.3886, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94125', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94126', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94127', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7354, 'longitude': -122.4571, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94129', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.8005, 'longitude': -122.465, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94130', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.8231, 'longitude': -122.3693, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94131', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.745, 'longitude': -122.4383, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94132', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7211, 'longitude': -122.4754, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94133', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.8002, 'longitude': -122.4091, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94134', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.719, 'longitude': -122.4096, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94137', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94139', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94140', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94141', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94142', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94143', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7631, 'longitude': -122.4586, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94144', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94145', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94146', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94147', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94151', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94158', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7694, 'longitude': -122.3867, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94159', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94160', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94161', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94163', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94164', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94172', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94177', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '94188', 'place_name': 'San Francisco', 'state': 'California', 'state_ab': 'CA', 'county': 'City and County of San Francisco', 'locality_code': '75', 'latitude': 37.7749, 'longitude': -122.4194, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95201', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.958, 'longitude': -121.2876, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95202', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9606, 'longitude': -121.2871, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95203', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9532, 'longitude': -121.3116, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95204', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9743, 'longitude': -121.3154, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95205', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9625, 'longitude': -121.2624, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95206', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9177, 'longitude': -121.3123, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95207', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.0024, 'longitude': -121.3238, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95208', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9304, 'longitude': -121.436, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95209', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.0377, 'longitude': -121.3445, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95210', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.025, 'longitude': -121.2972, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95211', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9809, 'longitude': -121.311, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95212', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.0315, 'longitude': -121.2589, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95213', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9054, 'longitude': -121.2222, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95214', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9053, 'longitude': -121.2262, 'accuracy': 1},
            {'country_code': 'US', 'zip_code': '95215', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9551, 'longitude': -121.2041, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95219', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.01, 'longitude': -121.3698, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95220', 'place_name': 'Acampo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.2004, 'longitude': -121.2186, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95227', 'place_name': 'Clements', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.1929, 'longitude': -121.0811, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95230', 'place_name': 'Farmington', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9299, 'longitude': -121.0002, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95231', 'place_name': 'French Camp', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.878, 'longitude': -121.2827, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95234', 'place_name': 'Holt', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9344, 'longitude': -121.4261, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95236', 'place_name': 'Linden', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.032, 'longitude': -121.0493, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95237', 'place_name': 'Lockeford', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.1613, 'longitude': -121.1424, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95240', 'place_name': 'Lodi', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.1222, 'longitude': -121.2555, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95241', 'place_name': 'Lodi', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.1327, 'longitude': -121.2724, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95242', 'place_name': 'Lodi', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.1308, 'longitude': -121.3345, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95253', 'place_name': 'Victor', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.138, 'longitude': -121.205, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95258', 'place_name': 'Woodbridge', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.1551, 'longitude': -121.3086, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95267', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.0003, 'longitude': -121.3174, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95269', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.0187, 'longitude': -121.3225, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95296', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.9577, 'longitude': -121.2908, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95297', 'place_name': 'Stockton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.0025, 'longitude': -121.324, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95304', 'place_name': 'Tracy', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.7319, 'longitude': -121.4096, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95320', 'place_name': 'Escalon', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.7983, 'longitude': -121.0006, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95330', 'place_name': 'Lathrop', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.8209, 'longitude': -121.2827, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95336', 'place_name': 'Manteca', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.8134, 'longitude': -121.2132, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95337', 'place_name': 'Manteca', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.7808, 'longitude': -121.2344, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95366', 'place_name': 'Ripon', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.7491, 'longitude': -121.1284, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95376', 'place_name': 'Tracy', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.7383, 'longitude': -121.4345, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95377', 'place_name': 'Tracy', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.6567, 'longitude': -121.4955, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95378', 'place_name': 'Tracy', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.6761, 'longitude': -121.433, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95385', 'place_name': 'Vernalis', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.6176, 'longitude': -121.2581, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95391', 'place_name': 'Tracy', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 37.7695, 'longitude': -121.5397, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '95686', 'place_name': 'Thornton', 'state': 'California', 'state_ab': 'CA', 'county': 'San Joaquin', 'locality_code': '77', 'latitude': 38.2261, 'longitude': -121.4236, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93401', 'place_name': 'San Luis Obispo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.2635, 'longitude': -120.6509, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93402', 'place_name': 'Los Osos', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.3172, 'longitude': -120.8333, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93403', 'place_name': 'San Luis Obispo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.2828, 'longitude': -120.6596, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93405', 'place_name': 'San Luis Obispo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.2901, 'longitude': -120.6817, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93406', 'place_name': 'San Luis Obispo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.2828, 'longitude': -120.6596, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93407', 'place_name': 'San Luis Obispo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.2828, 'longitude': -120.6596, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93408', 'place_name': 'San Luis Obispo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.2828, 'longitude': -120.6596, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93409', 'place_name': 'San Luis Obispo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.2211, 'longitude': -120.6364, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93410', 'place_name': 'San Luis Obispo', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.3471, 'longitude': -120.4553, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93412', 'place_name': 'Los Osos', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.3111, 'longitude': -120.8324, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93420', 'place_name': 'Arroyo Grande', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.1661, 'longitude': -120.4651, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93421', 'place_name': 'Arroyo Grande', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.1186, 'longitude': -120.5907, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93422', 'place_name': 'Atascadero', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.4754, 'longitude': -120.6638, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93423', 'place_name': 'Atascadero', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.4282, 'longitude': -120.7695, 'accuracy': 4},
            {'country_code': 'US', 'zip_code': '93424', 'place_name': 'Avila Beach', 'state': 'California', 'state_ab': 'CA', 'county': 'San Luis Obispo', 'locality_code': '79', 'latitude': 35.18, 'longitude': -120.7318, 'accuracy': 4},
     