# -*- coding:utf-8 -*-
import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()


def get_requirements(file_name):
    """
    Takes requirements from requirements.txt and returns a list.
    """
    with open(file_name) as fp:
        reqs = list()
        for lib in fp.read().split("\n"):
            # Ignore pypi flags and comments
            if not lib.startswith("-") or lib.startswith("#"):
                reqs.append(lib.strip())
        return reqs


install_requires = get_requirements("requirements.txt")

setuptools.setup(
    name="notion-hugo",
    version="0.2.4",
    author="gclm",
    author_email="gclmit@163.com",
    description="convert notion page content to markdown",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/gclm/notion-hugo",
    install_requires=install_requires,
    include_package_data=True,
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
    ],
)
